# Dalli 3.0

This major version update contains several backwards incompatible changes.

* **:dalli_store** has been removed. Users should migrate to the
  official Rails **:mem_cache_store**, documented in the [caching
guide](https://guides.rubyonrails.org/caching_with_rails.html#activesupport-cache-memcachestore).
* Attempting to store a larger value than allowed by memcached used to
  print a warning and truncate the value. This now raises an error to
  prevent silent data corruption.
* Compression now defaults to `true` for large values (greater than 4KB).
  This is intended to minimize errors due to the previous note.
* Errors marshalling values now raise rather than just printing an error.
* The Rack session adapter has been refactored to remove support for thread-unsafe
  configurations. You will need to include the `connection_pool` gem in
  your Gemfile to ensure session operations are thread-safe.
* Support for the `kgio` gem has been removed, it is not relevant in Ruby 2.3+.
* Removed inline native code, use Ruby 2.3+ support for bsearch instead.
* The CAS operations previously in 'dalli/cas/client' have been
  integrated into 'dalli/client'.

## Future Directions

The memcached project has deprecated the binary protocol used by Dalli
in favor of a new `meta/text` protocol that is somewhat human readable.

Dalli 4.0 will move in this direction and require memcached 1.6+.
