/*
 * Decompiled with CFR 0.152.
 */
package org.boehn.kmlframework.todo.servlet.kmz;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class KmzResponseStream
extends ServletOutputStream {
    protected ZipOutputStream zipstream = null;
    protected boolean closed = false;
    protected HttpServletResponse response = null;
    protected ServletOutputStream output = null;
    private String kmlFileName = "index.kml";
    protected int bufferCount = 0;
    protected byte[] buffer = null;
    protected int length = -1;

    public KmzResponseStream(HttpServletResponse response) throws IOException {
        this.response = response;
        this.output = response.getOutputStream();
        this.buffer = new byte[128];
    }

    public void setKMLFileName(String kml) {
        this.kmlFileName = kml;
    }

    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("This output stream has already been closed");
        }
        if (this.zipstream != null) {
            this.flushToZip();
            this.zipstream.close();
            this.zipstream = null;
        } else if (this.bufferCount > 0) {
            this.output.write(this.buffer, 0, this.bufferCount);
            this.bufferCount = 0;
        }
        this.output.close();
        this.closed = true;
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Cannot flush a closed output stream");
        }
        if (this.zipstream != null) {
            this.zipstream.flush();
        }
    }

    public void flushToZip() throws IOException {
        if (this.bufferCount > 0) {
            this.writeToZip(this.buffer, 0, this.bufferCount);
            this.bufferCount = 0;
        }
    }

    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        if (this.bufferCount >= this.buffer.length) {
            this.flushToZip();
        }
        this.buffer[this.bufferCount++] = (byte)b;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        if (len == 0) {
            return;
        }
        if (len <= this.buffer.length - this.bufferCount) {
            System.arraycopy(b, off, this.buffer, this.bufferCount, len);
            this.bufferCount += len;
            return;
        }
        this.flushToZip();
        if (len <= this.buffer.length - this.bufferCount) {
            System.arraycopy(b, off, this.buffer, this.bufferCount, len);
            this.bufferCount += len;
            return;
        }
        this.writeToZip(b, off, len);
    }

    public void writeToZip(byte[] b, int off, int len) throws IOException {
        if (this.zipstream == null) {
            this.response.setContentType("application/vnd.google-earth.kmzl; charset=UTF-8");
            this.zipstream = new ZipOutputStream((OutputStream)this.output);
            this.zipstream.putNextEntry(new ZipEntry(this.kmlFileName));
        }
        this.zipstream.write(b, off, len);
    }

    public boolean closed() {
        return this.closed;
    }

    public void reset() {
    }
}

