# -*- coding: utf-8 -*-
info = {
    "name": "it",
    "date_order": "DMY",
    "january": [
        "gennaio",
        "gen"
    ],
    "february": [
        "febbraio",
        "feb"
    ],
    "march": [
        "marzo",
        "mar"
    ],
    "april": [
        "aprile",
        "apr"
    ],
    "may": [
        "maggio",
        "mag"
    ],
    "june": [
        "giugno",
        "giu"
    ],
    "july": [
        "luglio",
        "lug"
    ],
    "august": [
        "agosto",
        "ago"
    ],
    "september": [
        "settembre",
        "set"
    ],
    "october": [
        "ottobre",
        "ott"
    ],
    "november": [
        "novembre",
        "nov"
    ],
    "december": [
        "dicembre",
        "dic"
    ],
    "monday": [
        "lunedì",
        "lun"
    ],
    "tuesday": [
        "martedì",
        "mar"
    ],
    "wednesday": [
        "mercoledì",
        "mer"
    ],
    "thursday": [
        "giovedì",
        "gio"
    ],
    "friday": [
        "venerdì",
        "ven"
    ],
    "saturday": [
        "sabato",
        "sab"
    ],
    "sunday": [
        "domenica",
        "dom"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "anno",
        "anni"
    ],
    "month": [
        "mese",
        "mesi"
    ],
    "week": [
        "settimana",
        "sett",
        "settimane"
    ],
    "day": [
        "giorno",
        "g",
        "giorni"
    ],
    "hour": [
        "ora",
        "h",
        "ore"
    ],
    "minute": [
        "minuto",
        "min",
        "m",
        "minuti"
    ],
    "second": [
        "secondo",
        "sec",
        "s",
        "secondi"
    ],
    "relative-type": {
        "1 year ago": [
            "anno scorso"
        ],
        "0 year ago": [
            "quest'anno"
        ],
        "in 1 year": [
            "anno prossimo"
        ],
        "1 month ago": [
            "mese scorso"
        ],
        "0 month ago": [
            "questo mese"
        ],
        "in 1 month": [
            "mese prossimo"
        ],
        "1 week ago": [
            "settimana scorsa"
        ],
        "0 week ago": [
            "questa settimana"
        ],
        "in 1 week": [
            "settimana prossima"
        ],
        "1 day ago": [
            "ieri"
        ],
        "0 day ago": [
            "oggi"
        ],
        "in 1 day": [
            "domani"
        ],
        "0 hour ago": [
            "quest'ora"
        ],
        "0 minute ago": [
            "questo minuto"
        ],
        "0 second ago": [
            "ora"
        ],
        "2 day ago": [
            "altro ieri"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "tra (\\d+) anno",
            "tra (\\d+) anni"
        ],
        "\\1 year ago": [
            "(\\d+) anno fa",
            "(\\d+) anni fa"
        ],
        "in \\1 month": [
            "tra (\\d+) mese",
            "tra (\\d+) mesi"
        ],
        "\\1 month ago": [
            "(\\d+) mese fa",
            "(\\d+) mesi fa"
        ],
        "in \\1 week": [
            "tra (\\d+) settimana",
            "tra (\\d+) settimane",
            "tra (\\d+) sett"
        ],
        "\\1 week ago": [
            "(\\d+) settimana fa",
            "(\\d+) settimane fa",
            "(\\d+) sett fa"
        ],
        "in \\1 day": [
            "tra (\\d+) giorno",
            "tra (\\d+) giorni",
            "tra (\\d+) g",
            "tra (\\d+) gg"
        ],
        "\\1 day ago": [
            "(\\d+) giorno fa",
            "(\\d+) giorni fa",
            "(\\d+) g fa",
            "(\\d+) gg fa"
        ],
        "in \\1 hour": [
            "tra (\\d+) ora",
            "tra (\\d+) ore",
            "tra (\\d+) h"
        ],
        "\\1 hour ago": [
            "(\\d+) ora fa",
            "(\\d+) ore fa",
            "(\\d+) h fa"
        ],
        "in \\1 minute": [
            "tra (\\d+) minuto",
            "tra (\\d+) minuti",
            "tra (\\d+) min"
        ],
        "\\1 minute ago": [
            "(\\d+) minuto fa",
            "(\\d+) minuti fa",
            "(\\d+) min fa"
        ],
        "in \\1 second": [
            "tra (\\d+) secondo",
            "tra (\\d+) secondi",
            "tra (\\d+) sec",
            "tra (\\d+) s"
        ],
        "\\1 second ago": [
            "(\\d+) secondo fa",
            "(\\d+) secondi fa",
            "(\\d+) sec fa",
            "(\\d+) s fa"
        ]
    },
    "locale_specific": {
        "it-CH": {
            "name": "it-CH"
        },
        "it-SM": {
            "name": "it-SM"
        },
        "it-VA": {
            "name": "it-VA"
        }
    },
    "skip": [
        "circa",
        "e",
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "fa"
    ],
    "in": [
        "in"
    ],
    "simplifications": [
        {
            "(\\d+)\\s+ora": "\\1 ore"
        }
    ]
}