# -*- coding: utf-8 -*-
info = {
    "name": "he",
    "date_order": "DMY",
    "january": [
        "ינואר",
        "ינו׳",
        "ינואר",
        "לינואר",
        "בינואר",
        "ינו"
    ],
    "february": [
        "פברואר",
        "פבר׳",
        "פברואר",
        "בפברואר",
        "לפברואר",
        "פבר"
    ],
    "march": [
        "מרץ",
        "מרץ",
        "במרץ",
        "למרץ",
        "מרס",
        "במרס",
        "למרס",
        "מארס",
        "במארס",
        "למארס"
    ],
    "april": [
        "אפריל",
        "אפר׳",
        "אפריל",
        "באפריל",
        "לאפריל",
        "אפר"
    ],
    "may": [
        "מאי",
        "מאי",
        "במאי",
        "למאי"
    ],
    "june": [
        "יוני",
        "יוני",
        "ביוני",
        "ליוני",
        "יונ"
    ],
    "july": [
        "יולי",
        "יולי",
        "ביולי",
        "ליולי",
        "יול"
    ],
    "august": [
        "אוגוסט",
        "אוג׳",
        "אוגוסט",
        "באוגוסט",
        "לאוגוסט",
        "אוג"
    ],
    "september": [
        "ספטמבר",
        "ספט׳",
        "ספטמבר",
        "בספטמבר",
        "לספטמבר",
        "ספט"
    ],
    "october": [
        "אוקטובר",
        "אוק׳",
        "אוקטובר",
        "באוקטובר",
        "לאוקטובר",
        "אוק"
    ],
    "november": [
        "נובמבר",
        "נוב׳",
        "נובמבר",
        "בנובמבר",
        "לנובמבר",
        "נוב"
    ],
    "december": [
        "דצמבר",
        "דצמ׳",
        "דצמבר",
        "בדצמבר",
        "לדצמבר",
        "דצמ"
    ],
    "monday": [
        "יום שני",
        "יום ב׳",
        "שני",
        "יום שני",
        "יום ב"
    ],
    "tuesday": [
        "יום שלישי",
        "יום ג׳",
        "שלישי",
        "יום שלישי",
        "יום ג"
    ],
    "wednesday": [
        "יום רביעי",
        "יום ד׳",
        "רביעי",
        "יום רביעי",
        "יום ד"
    ],
    "thursday": [
        "יום חמישי",
        "יום ה׳",
        "חמישי",
        "יום חמישי",
        "יום ה"
    ],
    "friday": [
        "יום שישי",
        "יום ו׳",
        "שישי",
        "יום שישי",
        "יום ו"
    ],
    "saturday": [
        "יום שבת",
        "שבת",
        "שבת",
        "יום שבת"
    ],
    "sunday": [
        "יום ראשון",
        "יום א׳",
        "ראשון",
        "יום ראשון",
        "יום א"
    ],
    "am": [
        "לפנה״צ"
    ],
    "pm": [
        "אחה״צ"
    ],
    "year": [
        "שנה",
        "שנ׳",
        "שנה",
        "שנים",
        "בשנה"
    ],
    "month": [
        "חודש",
        "חו׳",
        "חודש",
        "חודשים",
        "בחודש"
    ],
    "week": [
        "שבוע",
        "שב׳",
        "שבוע",
        "שבועות"
    ],
    "day": [
        "יום",
        "יום",
        "ימים",
        "ביום"
    ],
    "hour": [
        "שעה",
        "שע׳",
        "שעה",
        "שעות"
    ],
    "minute": [
        "דקה",
        "דק׳",
        "דקה",
        "דקות"
    ],
    "second": [
        "שנייה",
        "שנ׳",
        "שניה",
        "שנייה",
        "שניות"
    ],
    "relative-type": {
        "1 year ago": [
            "השנה שעברה"
        ],
        "0 year ago": [
            "השנה"
        ],
        "in 1 year": [
            "השנה הבאה"
        ],
        "1 month ago": [
            "החודש שעבר"
        ],
        "0 month ago": [
            "החודש"
        ],
        "in 1 month": [
            "החודש הבא"
        ],
        "1 week ago": [
            "השבוע שעבר"
        ],
        "0 week ago": [
            "השבוע"
        ],
        "in 1 week": [
            "השבוע הבא"
        ],
        "1 day ago": [
            "אתמול"
        ],
        "0 day ago": [
            "היום"
        ],
        "in 1 day": [
            "מחר"
        ],
        "0 hour ago": [
            "בשעה זו"
        ],
        "0 minute ago": [
            "בדקה זו"
        ],
        "0 second ago": [
            "עכשיו"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "בעוד (\\d+) שנים"
        ],
        "\\1 year ago": [
            "לפני (\\d+) שנים"
        ],
        "in \\1 month": [
            "בעוד (\\d+) חודשים",
            "בעוד (\\d+) חו׳"
        ],
        "\\1 month ago": [
            "לפני (\\d+) חודשים",
            "לפני (\\d+) חו׳"
        ],
        "in \\1 week": [
            "בעוד (\\d+) שבועות",
            "בעוד (\\d+) שב׳"
        ],
        "\\1 week ago": [
            "לפני (\\d+) שבועות",
            "לפני (\\d+) שב׳"
        ],
        "in \\1 day": [
            "בעוד יום (\\d+)",
            "בעוד (\\d+) ימים",
            "בעוד (\\d+) ימ׳"
        ],
        "\\1 day ago": [
            "לפני יום (\\d+)",
            "לפני (\\d+) ימים",
            "לפני (\\d+) ימ׳"
        ],
        "in \\1 hour": [
            "בעוד (\\d+) שעות",
            "בעוד (\\d+) שע׳"
        ],
        "\\1 hour ago": [
            "לפני (\\d+) שעות",
            "לפני (\\d+) שע׳"
        ],
        "in \\1 minute": [
            "בעוד (\\d+) דקות",
            "בעוד (\\d+) דק׳"
        ],
        "\\1 minute ago": [
            "לפני (\\d+) דקות",
            "לפני (\\d+) דק׳"
        ],
        "in \\1 second": [
            "בעוד (\\d+) שניות",
            "בעוד (\\d+) שנ׳"
        ],
        "\\1 second ago": [
            "לפני (\\d+) שניות",
            "לפני (\\d+) שנ׳"
        ]
    },
    "locale_specific": {},
    "dateorder": "DMY",
    "sentence_splitter_group": 1,
    "skip": [
        "ה-",
        "ב-",
        "בשעה",
        "בסביבות",
        "בערך",
        "בקירוב",
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ],
    "ago": [
        "לפני"
    ],
    "in": [
        "בעוד",
        "עוד"
    ],
    "simplifications": [
        {
            "ויום": "1 יום"
        },
        {
            "ושבוע": "1 שבוע"
        },
        {
            "וחודש": "1 חודש"
        },
        {
            "ושנה": "1 שנה"
        },
        {
            "ו(\\w+)": "\\1"
        },
        {
            "שנתיי?ם": "2 שנים"
        },
        {
            "חודשיים": "2 חודשים"
        },
        {
            "שבועיי?ם": "2 שבועות"
        },
        {
            "יומיי?ם": "2 ימים"
        },
        {
            "שעתיי?ם": "2 שעות"
        },
        {
            "שלשום": "2 ימים"
        },
        {
            "מחר": "בעוד 1 יום"
        },
        {
            "אחר חצות": "am"
        },
        {
            "חצות": "12 am"
        },
        {
            "לפנות בוקר": "am"
        },
        {
            "בבוקר": "am"
        },
        {
            "בצהריי?ם": "pm"
        },
        {
            "אחרי ה?צהריי?ם": "pm"
        },
        {
            "אחה\"צ": "pm"
        },
        {
            "לפנות ערב": "pm"
        },
        {
            "בערב": "pm"
        }
    ]
}