# extract the content of an archive using dpkg-deb
# USAGE: archive_extraction_using_dpkgdeb $archive $destination_directory $log_file
archive_extraction_using_dpkgdeb() {
	local archive destination_directory log_file
	archive="$1"
	destination_directory="$2"
	log_file="$3"

	local archive_path
	archive_path=$(archive_path "$archive")

	local extractor_options
	extractor_options=$(archive_extractor_options "$archive")
	if ! {
		printf 'dpkg-deb --verbose %s --extract "%s" "%s"\n' "$extractor_options" "$archive_path" "$destination_directory"
		dpkg-deb --verbose $extractor_options --extract "$archive_path" "$destination_directory" 2>&1
	} >> "$log_file"
	then
		error_archive_extraction_failure "$archive"
		return 1
	fi
}

