/*
 * unity-webapps-preinstalled-application-info.c
 * Copyright (C) Canonical LTD 2011
 *
 * Author: Robert Carr <racarr@canonical.com>
 * 
 unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>

#include "unity-webapps-preinstalled-application-info.h"

#include "../unity-webapps-debug.h"

G_DEFINE_TYPE(UnityWebappsPreinstalledApplicationInfo, unity_webapps_preinstalled_application_info, UNITY_WEBAPPS_TYPE_APPLICATION_INFO);

enum {
  PROP_0,
  PROP_DESKTOP_NAME
};


#define UNITY_WEBAPPS_PREINSTALLED_APPLICATION_INFO_GET_PRIVATE(object) (G_TYPE_INSTANCE_GET_PRIVATE ((object), UNITY_WEBAPPS_TYPE_PREINSTALLED_APPLICATION_INFO, UnityWebappsPreinstalledApplicationInfoPrivate))

struct _UnityWebappsPreinstalledApplicationInfoPrivate {
  gchar *desktop_name;
};


static void
unity_webapps_preinstalled_application_info_finalize (GObject *object)
{
  UnityWebappsPreinstalledApplicationInfo *info;
  
  info = UNITY_WEBAPPS_PREINSTALLED_APPLICATION_INFO (object);
    
  g_free (info->priv->desktop_name);
}

static void
unity_webapps_preinstalled_application_info_set_property (GObject *object, guint property_id,
							  const GValue *value, GParamSpec *pspec)
{
  UnityWebappsPreinstalledApplicationInfo *self;
  
  self = UNITY_WEBAPPS_PREINSTALLED_APPLICATION_INFO (object);
  
  switch (property_id)
    {
    case PROP_DESKTOP_NAME:
      g_return_if_fail (self->priv->desktop_name == NULL);
      self->priv->desktop_name = g_value_dup_string (value);
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
    }

}

static void
unity_webapps_preinstalled_application_info_get_property (GObject *object, guint property_id,
							  GValue *value, GParamSpec *pspec)
{
  UnityWebappsPreinstalledApplicationInfo *self;
  
  self = UNITY_WEBAPPS_PREINSTALLED_APPLICATION_INFO (object);
  
  switch (property_id)
    {
    case PROP_DESKTOP_NAME:
      g_value_set_string (value, self->priv->desktop_name);
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
    }
}

static gchar *
unity_webapps_preinstalled_application_info_get_desktop_file_name (UnityWebappsApplicationInfo *application_info)
{
  UnityWebappsPreinstalledApplicationInfo *info;
  
  info = UNITY_WEBAPPS_PREINSTALLED_APPLICATION_INFO (application_info);
  
  return g_strdup (info->priv->desktop_name);
}

static gchar *
unity_webapps_preinstalled_application_info_get_desktop_file_path (UnityWebappsApplicationInfo *application_info)
{
  UnityWebappsPreinstalledApplicationInfo *info;
  GDesktopAppInfo *desktop_app_info;
  gchar *desktop_file_path = NULL;

  info = UNITY_WEBAPPS_PREINSTALLED_APPLICATION_INFO (application_info);

  // TODO: Cache GDesktopAppInfo for lifetime of object? Not without implications
  desktop_app_info = g_desktop_app_info_new (info->priv->desktop_name);
  if (desktop_app_info)
    {
      desktop_file_path = g_strdup (g_desktop_app_info_get_filename (desktop_app_info));

      g_object_unref (G_OBJECT (desktop_app_info));
    }

  return desktop_file_path;
}

static gboolean
unity_webapps_preinstalled_application_info_ensure_desktop_file (UnityWebappsApplicationInfo *application_info,
								 GError **error)
{
  gboolean res = FALSE;
  UnityWebappsPreinstalledApplicationInfo *info;
  GDesktopAppInfo *desktop_app_info;

  info = UNITY_WEBAPPS_PREINSTALLED_APPLICATION_INFO (application_info);

  desktop_app_info = g_desktop_app_info_new (info->priv->desktop_name);
  if (desktop_app_info)
    {
      res = TRUE;
      g_object_unref (G_OBJECT (desktop_app_info));
    }

  return res;
}

static void
unity_webapps_preinstalled_application_info_class_init (UnityWebappsPreinstalledApplicationInfoClass *klass)
{
  GParamSpec *pspec;
  GObjectClass *object_class = G_OBJECT_CLASS (klass);
  UnityWebappsApplicationInfoClass *application_info_class = UNITY_WEBAPPS_APPLICATION_INFO_CLASS (klass);
  
  object_class->finalize = unity_webapps_preinstalled_application_info_finalize;
  object_class->get_property = unity_webapps_preinstalled_application_info_get_property;
  object_class->set_property = unity_webapps_preinstalled_application_info_set_property;
  
  application_info_class->get_desktop_file_name = unity_webapps_preinstalled_application_info_get_desktop_file_name;
  application_info_class->get_desktop_file_path = unity_webapps_preinstalled_application_info_get_desktop_file_path;
  application_info_class->ensure_desktop_file = unity_webapps_preinstalled_application_info_ensure_desktop_file;
  
  pspec = g_param_spec_string ("desktop-name", "Desktop Name", "Desktop Name for the Preinstalled .desktop file",
			       NULL, G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_STATIC_STRINGS);
  g_object_class_install_property (object_class, PROP_DESKTOP_NAME, pspec);

  g_type_class_add_private (object_class, sizeof(UnityWebappsPreinstalledApplicationInfoPrivate));
}

static void
unity_webapps_preinstalled_application_info_init (UnityWebappsPreinstalledApplicationInfo *info)
{
  info->priv = UNITY_WEBAPPS_PREINSTALLED_APPLICATION_INFO_GET_PRIVATE (info);
}


UnityWebappsApplicationInfo *
unity_webapps_preinstalled_application_info_new (const gchar *name,
						 const gchar *domain,
						 const gchar *icon_url,
						 const gchar *mime_types,
						 const gchar *desktop_name)
{
  return g_object_new (UNITY_WEBAPPS_TYPE_PREINSTALLED_APPLICATION_INFO,
		       "name", name,
		       "domain", domain,
		       "icon-url", icon_url,
		       "mime-types", mime_types,
		       "desktop-name", desktop_name,
		       NULL);
}
