# flake8: noqa
# EAM potential for Pt from LAMMPS

Pt_u3 = \
"""DATE: 2007-06-11 CONTRIBUTOR: Stephen Foiles, foiles@sandia.gov CITATION: Foiles et al, Phys Rev B, 33, 7983 (1986) COMMENT: Pt functions  (universal 3), SM Foiles et al, PRB, 33, 7983 (1986)
   78     195.09         3.9200    FCC
  500  5.0100200400801306e-04  500  1.0707070707070721e-02  5.3000000000000114e+00
  0.                     -4.8256532387839535e-01 -8.2163069483085494e-01 -1.1184672638766031e+00 -1.3913023282712871e+00
 -1.6478367404515737e+00 -1.8922209123812408e+00 -2.1270046425573668e+00 -2.3518118673440256e+00 -2.5692311780562278e+00
 -2.7807647208236403e+00 -2.9870891892343252e+00 -3.1887362585777481e+00 -3.3861326223263433e+00 -3.5796268226704626e+00
 -3.7695078528599879e+00 -3.9560184285805349e+00 -4.1393646896262055e+00 -4.3197234427424007e+00 -4.4972476688606662e+00
 -4.6720707786854518e+00 -4.8443099484124730e+00 -5.0140687680251403e+00 -5.1814393677891530e+00 -5.3465041437574428e+00
 -5.5093371707724543e+00 -5.6700053695279280e+00 -5.8285694779638106e+00 -5.9850848655324853e+00 -6.1396022201937228e+00
 -6.2921681314840612e+00 -6.4428255881094003e+00 -6.5916144047229466e+00 -6.7385715896828060e+00 -6.8837316632833563e+00
 -7.0267946191073918e+00 -7.1664929523390981e+00 -7.3044721581305794e+00 -7.4407606561703972e+00 -7.5753855110402242e+00
 -7.7083725687124343e+00 -7.8397465769618009e+00 -7.9695312918024115e+00 -8.0977495716777526e+00 -8.2244234611367801e+00
 -8.3495742649348017e+00 -8.4732226141273941e+00 -8.5953885248173947e+00 -8.7160914505300866e+00 -8.8353503289578725e+00
 -8.9531836236402000e+00 -9.0696093612581876e+00 -9.1846451649266783e+00 -9.2983082839703002e+00 -9.4106156205833713e+00
 -9.5215837536494519e+00 -9.6312289600847976e+00 -9.7395672339368957e+00 -9.8466143034397078e+00 -9.9523856463964648e+00
 -1.0056896503782298e+01 -1.0160161892048848e+01 -1.0262196614080892e+01 -1.0363015269007064e+01 -1.0462632260978864e+01
 -1.0561061807021588e+01 -1.0658317944056876e+01 -1.0754414535178739e+01 -1.0849365275313289e+01 -1.0943183696090216e+01
 -1.1035883170564546e+01 -1.1127476917048284e+01 -1.1217978002785060e+01 -1.1307399347159560e+01 -1.1395753724585290e+01
 -1.1483053767097715e+01 -1.1569311966688872e+01 -1.1654540677403645e+01 -1.1738752117243337e+01 -1.1821958369879894e+01
 -1.1904171386222060e+01 -1.1985402985841404e+01 -1.2065664858281309e+01 -1.2144968564260978e+01 -1.2223311768936753e+01
 -1.2300484082444200e+01 -1.2376735655437130e+01 -1.2452077613822269e+01 -1.2526520957875107e+01 -1.2600076562804816e+01
 -1.2672755179662204e+01 -1.2744567436120121e+01 -1.2815523837253011e+01 -1.2885634766309352e+01 -1.2954910485479104e+01
 -1.3023361136660640e+01 -1.3090996742227674e+01 -1.3157827205799549e+01 -1.3223862313023801e+01 -1.3289111732358606e+01
 -1.3353585015871943e+01 -1.3417291600044109e+01 -1.3480240806593770e+01 -1.3542441843298207e+01 -1.3603903804847164e+01
 -1.3664635673689077e+01 -1.3724646320909244e+01 -1.3783944507107776e+01 -1.3842538883293571e+01 -1.3900437991796025e+01
 -1.3957650267183055e+01 -1.4014184037194070e+01 -1.4070047523682831e+01 -1.4125248843591976e+01 -1.4179796009850634e+01
 -1.4233696932440012e+01 -1.4286959419319373e+01 -1.4339591177435011e+01 -1.4391599813717164e+01 -1.4442992836085295e+01
 -1.4493777654465759e+01 -1.4543961581804581e+01 -1.4593551835095070e+01 -1.4642555536403506e+01 -1.4690979713899083e+01
 -1.4738831302890674e+01 -1.4786117146859510e+01 -1.4832843998496060e+01 -1.4879018520742534e+01 -1.4924647287827327e+01
 -1.4969736786301610e+01 -1.5014293416078772e+01 -1.5058323491470446e+01 -1.5101833242216628e+01 -1.5144828814517894e+01
 -1.5187316272062105e+01 -1.5229301597048220e+01 -1.5270790691206514e+01 -1.5311789376810736e+01 -1.5352303397695209e+01
 -1.5392338420255896e+01 -1.5431900034440332e+01 -1.5470993754752044e+01 -1.5509625021238833e+01 -1.5547799200463771e+01
 -1.5585521586444088e+01 -1.5622797401777063e+01 -1.5659631798356088e+01 -1.5696029858477971e+01 -1.5731996595753969e+01
 -1.5767536956062543e+01 -1.5802655818371193e+01 -1.5837357995818650e+01 -1.5871648236510850e+01 -1.5905531224447714e+01
 -1.5939011580416889e+01 -1.5972093862871759e+01 -1.6004782568806604e+01 -1.6037082134620618e+01 -1.6068996936965505e+01
 -1.6100531293611539e+01 -1.6131593588097985e+01 -1.6162278534625557e+01 -1.6192598416643477e+01 -1.6222557318775557e+01
 -1.6252159270704283e+01 -1.6281408247962872e+01 -1.6310308172719147e+01 -1.6338862914542347e+01 -1.6367076291169610e+01
 -1.6394952069254714e+01 -1.6422493965111471e+01 -1.6449705645445420e+01 -1.6476590728077781e+01 -1.6503152782656343e+01
 -1.6529395331364526e+01 -1.6555321849607594e+01 -1.6580935766706148e+01 -1.6606240466562895e+01 -1.6631239288333518e+01
 -1.6655935527083443e+01 -1.6680332434432216e+01 -1.6704433219196062e+01 -1.6728241048009636e+01 -1.6751759045957442e+01
 -1.6774990297173076e+01 -1.6797937845450861e+01 -1.6820604694834287e+01 -1.6842993810205030e+01 -1.6865108117854788e+01
 -1.6886950506056110e+01 -1.6908523825624798e+01 -1.6929830890463563e+01 -1.6950874478114656e+01 -1.6971657330285552e+01
 -1.6992182153382714e+01 -1.7012451619031253e+01 -1.7032468364576062e+01 -1.7052234993601473e+01 -1.7071754076412162e+01
 -1.7091028150529155e+01 -1.7110059721172433e+01 -1.7128851261726936e+01 -1.7147405214217201e+01 -1.7165723989760636e+01
 -1.7183809969023741e+01 -1.7201665502664468e+01 -1.7219292911770367e+01 -1.7236694488294233e+01 -1.7253872495473615e+01
 -1.7270829168252362e+01 -1.7287566713692627e+01 -1.7304087311378225e+01 -1.7320393113812997e+01 -1.7336486246821323e+01
 -1.7352368809925224e+01 -1.7368042876730328e+01 -1.7383510495269206e+01 -1.7398773688479196e+01 -1.7413834454415337e+01
 -1.7428694766699664e+01 -1.7443356574854988e+01 -1.7457821804649825e+01 -1.7472092358438658e+01 -1.7486170115497430e+01
 -1.7500056932352777e+01 -1.7513754643111383e+01 -1.7527265059776710e+01 -1.7540589972562998e+01 -1.7553731150209160e+01
 -1.7566690340282662e+01 -1.7579469269479091e+01 -1.7592069643916034e+01 -1.7604493149431619e+01 -1.7616741451859866e+01
 -1.7628816197326728e+01 -1.7640719012513387e+01 -1.7652451504941723e+01 -1.7664015263234546e+01 -1.7675411857384574e+01
 -1.7686642839018532e+01 -1.7697709741645212e+01 -1.7708614080906386e+01 -1.7719357354865451e+01 -1.7729941044171710e+01
 -1.7740366612375851e+01 -1.7750635506130834e+01 -1.7760749155460871e+01 -1.7770708973917863e+01 -1.7780516358892783e+01
 -1.7790172691791781e+01 -1.7799679338239912e+01 -1.7809037648367507e+01 -1.7818248956946832e+01 -1.7827314583636962e+01
 -1.7836235833183991e+01 -1.7845013995631462e+01 -1.7853650346504992e+01 -1.7862146147026351e+01 -1.7870502644288649e+01
 -1.7878721071467453e+01 -1.7886802647989271e+01 -1.7894748579730390e+01 -1.7902560059192638e+01 -1.7910238265685734e+01
 -1.7917784365493731e+01 -1.7925199512068616e+01 -1.7932484846183684e+01 -1.7939641496112472e+01 -1.7946670577782129e+01
 -1.7953573194960541e+01 -1.7960350439387867e+01 -1.7967003390960258e+01 -1.7973533117868556e+01 -1.7979940676768706e+01
 -1.7986227112911934e+01 -1.7992393460314474e+01 -1.7998440741896161e+01 -1.8004369969619688e+01 -1.8010182144639430e+01
 -1.8015878257452187e+01 -1.8021459288021106e+01 -1.8026926205888003e+01 -1.8032279970369245e+01 -1.8037521530645449e+01
 -1.8042651825894609e+01 -1.8047671785429884e+01 -1.8052582328819653e+01 -1.8057384366016095e+01 -1.8062078797478875e+01
 -1.8066666514291228e+01 -1.8071148398281139e+01 -1.8075525322143676e+01 -1.8079798149545240e+01 -1.8083967735250440e+01
 -1.8088034925228726e+01 -1.8092000556763992e+01 -1.8095865458561434e+01 -1.8099630450861810e+01 -1.8103296345542503e+01
 -1.8106863946225417e+01 -1.8110334048375421e+01 -1.8113707439406085e+01 -1.8116984898770738e+01 -1.8120167198077979e+01
 -1.8123255101170798e+01 -1.8126249364231739e+01 -1.8129150735877374e+01 -1.8131959957245840e+01 -1.8134677762093588e+01
 -1.8137304876882126e+01 -1.8139842020870333e+01 -1.8142289906199380e+01 -1.8144649237984936e+01 -1.8146920714387306e+01
 -1.8149105026717962e+01 -1.8151202859502860e+01 -1.8153214890571803e+01 -1.8155141791145525e+01 -1.8156984225901851e+01
 -1.8158742853058584e+01 -1.8160418324462398e+01 -1.8162011285649669e+01 -1.8163522375925368e+01 -1.8164952228439006e+01
 -1.8166301470260123e+01 -1.8167570722449000e+01 -1.8168760600121459e+01 -1.8169871712527765e+01 -1.8170904663114243e+01
 -1.8171860049595580e+01 -1.8172738464022132e+01 -1.8173540492843586e+01 -1.8174266716978536e+01 -1.8174917711871331e+01
 -1.8175494047560733e+01 -1.8175996288747456e+01 -1.8176424994848048e+01 -1.8176780720052875e+01 -1.8177064013398422e+01
 -1.8177275418819590e+01 -1.8177415475203588e+01 -1.8177484716460413e+01 -1.8177483671561731e+01 -1.8177412864615462e+01
 -1.8177272814913977e+01 -1.8177064036978436e+01 -1.8176787040637691e+01 -1.8176442331048293e+01 -1.8176030408777024e+01
 -1.8175551769837966e+01 -1.8175006905744112e+01 -1.8174396303561252e+01 -1.8173720445954359e+01 -1.8172979811246933e+01
 -1.8172174873446693e+01 -1.8171306102319022e+01 -1.8170373963424481e+01 -1.8169378918157918e+01 -1.8168321423801217e+01
 -1.8167201933572414e+01 -1.8166020896665486e+01 -1.8164778758290595e+01 -1.8163475959725019e+01 -1.8162112938359314e+01
 -1.8160690127726411e+01 -1.8159207957556191e+01 -1.8157666853806177e+01 -1.8156067238718151e+01 -1.8154409530839985e+01
 -1.8152694145077476e+01 -1.8150921492733232e+01 -1.8149091981536003e+01 -1.8147206015695701e+01 -1.8145263995923187e+01
 -1.8143266319476879e+01 -1.8141213380202998e+01 -1.8139105568559671e+01 -1.8136943271674454e+01 -1.8134726873350019e+01
 -1.8132456754123496e+01 -1.8130133291300126e+01 -1.8127756858968041e+01 -1.8125327828048285e+01 -1.8122846566330281e+01
 -1.8120313438487756e+01 -1.8117728806134437e+01 -1.8115093027839293e+01 -1.8112406459155181e+01 -1.8109669452669777e+01
 -1.8106882358022176e+01 -1.8104045521926992e+01 -1.8101159288226427e+01 -1.8098223997901641e+01 -1.8095239989096626e+01
 -1.8092207597182096e+01 -1.8089127154743665e+01 -1.8085998991628230e+01 -1.8082823434979900e+01 -1.8079600809244994e+01
 -1.8076331436222745e+01 -1.8073015635088723e+01 -1.8069653722397106e+01 -1.8066246012142301e+01 -1.8062792815761213e+01
 -1.8059294442165992e+01 -1.8055751197769723e+01 -1.8052163386513030e+01 -1.8048531309885220e+01 -1.8044855266951799e+01
 -1.8041135554378116e+01 -1.8037372466449369e+01 -1.8033566295099263e+01 -1.8029717329942741e+01 -1.8025825858270764e+01
 -1.8021892165099644e+01 -1.8017916533186963e+01 -1.8013899243045216e+01 -1.8009840572975918e+01 -1.8005740799081423e+01
 -1.8001600195293577e+01 -1.7997419033393953e+01 -1.7993197583024084e+01 -1.7988936111725479e+01 -1.7984634884947582e+01
 -1.7980294166064368e+01 -1.7975914216407318e+01 -1.7971495295278373e+01 -1.7967037659964490e+01 -1.7962541565765378e+01
 -1.7958007266012146e+01 -1.7953435012073896e+01 -1.7948825053399105e+01 -1.7944177637509256e+01 -1.7939493010037040e+01
 -1.7934771414738179e+01 -1.7930013093495745e+01 -1.7925218286361996e+01 -1.7920387231556106e+01 -1.7915520165490307e+01
 -1.7910617322795588e+01 -1.7905678936306458e+01 -1.7900705237120064e+01 -1.7895696454587323e+01 -1.7890652816327702e+01
 -1.7885574548254453e+01 -1.7880461874598950e+01 -1.7875315017897265e+01 -1.7870134199038830e+01 -1.7864919637259618e+01
 -1.7859671550174653e+01 -1.7854390153766872e+01 -1.7849075662431687e+01 -1.7843728288976763e+01 -1.7838348244637245e+01
 -1.7832935739089407e+01 -1.7827490980469065e+01 -1.7822014175385902e+01 -1.7816505528932339e+01 -1.7810965244702629e+01
 -1.7805393524798319e+01 -1.7799790569855304e+01 -1.7794156579049741e+01 -1.7788491750098729e+01 -1.7782796279305103e+01
 -1.7777070361533561e+01 -1.7771314190256362e+01 -1.7765527957533777e+01 -1.7759711854052057e+01 -1.7753866069139121e+01
 -1.7747990790742278e+01 -1.7742086205475744e+01 -1.7736152498627007e+01 -1.7730189854141827e+01 -1.7724198454672205e+01
 -1.7718178481562518e+01 -1.7712130114881120e+01 -1.7706053533408976e+01 -1.7699948914666948e+01 -1.7693816434924429e+01
 -1.7687656269211629e+01 -1.7681468591315024e+01 -1.7675253573812597e+01 -1.7669011388068157e+01 -1.7662742204248389e+01
 -1.7656446191326722e+01 -1.7650123517101065e+01 -1.7643774348205852e+01 -1.7637398850107729e+01 -1.7630997187131015e+01
 -1.7624569522463162e+01 -1.7618116018159071e+01 -1.7611636835157469e+01 -1.7605132133291818e+01 -1.7598602071291680e+01
 -1.7592046806792723e+01 -1.7585466496359004e+01 -1.7578861295480237e+01 -1.7572231358576573e+01 -1.7565576839027017e+01
  1.0000000000000000e+01  9.8585282692716305e+00  9.7390839480922864e+00  9.6210650654732035e+00  9.5044548910571507e+00
  9.3892368865845128e+00  9.2753947037543867e+00  9.1629121821075046e+00  9.0517733469309860e+00  8.9419624071875319e+00
  8.8334637534648550e+00  8.7262619559474501e+00  8.6203417624104191e+00  8.5156880962351238e+00  8.4122860544447349e+00
  8.3101209057620053e+00  8.2091780886877359e+00  8.1094432095991920e+00  8.0109020408699507e+00  7.9135405190087056e+00
  7.8173447428192731e+00  7.7223009715797275e+00  7.6283956232411754e+00  7.5356152726464813e+00  7.4439466497672697e+00
  7.3533766379608494e+00  7.2638922722452151e+00  7.1754807375936309e+00  7.0881293672462675e+00  7.0018256410417052e+00
  6.9165571837650361e+00  6.8323117635150936e+00  6.7490772900883371e+00  6.6668418133810690e+00  6.5855935218084198e+00
  6.5053207407408706e+00  6.4260119309575998e+00  6.3476556871170828e+00  6.2702407362431245e+00  6.1937559362289676e+00
  6.1181902743563796e+00  6.0435328658318497e+00  5.9697729523381895e+00  5.8968999006018521e+00  5.8249032009764790e+00
  5.7537724660413687e+00  5.6834974292154357e+00  5.6140679433865728e+00  5.5454739795557657e+00  5.4777056254960712e+00
  5.4107530844262044e+00  5.3446066736989337e+00  5.2792568235036867e+00  5.2146940755838216e+00  5.1509090819669154e+00
  5.0878926037102303e+00  5.0256355096592813e+00  4.9641287752204164e+00  4.9033634811463287e+00  4.8433308123358074e+00
  4.7840220566460516e+00  4.7254286037181998e+00  4.6675419438161327e+00  4.6103536666776961e+00  4.5538554603788270e+00
  4.4980391102104988e+00  4.4428964975671192e+00  4.3884195988484862e+00  4.3346004843731407e+00  4.2814313173039125e+00
  4.2289043525851753e+00  4.1770119358924944e+00  4.1257465025930173e+00  4.0751005767184836e+00  4.0250667699485518e+00
  3.9756377806061352e+00  3.9268063926636927e+00  3.8785654747605633e+00  3.8309079792314833e+00  3.7838269411450227e+00
  3.7373154773540449e+00  3.6913667855560561e+00  3.6459741433634463e+00  3.6011309073855244e+00  3.5568305123193085e+00
  3.5130664700516547e+00  3.4698323687706676e+00  3.4271218720872838e+00  3.3849287181667336e+00  3.3432467188696364e+00
  3.3020697589028885e+00  3.2613917949794597e+00  3.2212068549886226e+00  3.1815090371745924e+00  3.1422925093246192e+00
  3.1035515079663867e+00  3.0652803375743218e+00  3.0274733697846301e+00  2.9901250426195389e+00  2.9532298597196842e+00
  2.9167823895857481e+00  2.8807772648282395e+00  2.8452091814257443e+00  2.8100728979917591e+00  2.7753632350494115e+00
  2.7410750743147503e+00  2.7072033579878507e+00  2.6737430880519923e+00  2.6406893255806807e+00  2.6080371900526558e+00
  2.5757818586744463e+00  2.5439185657106975e+00  2.5124426018220873e+00  2.4813493134105329e+00  2.4506341019720281e+00
  2.4202924234566439e+00  2.3903197876360167e+00  2.3607117574776737e+00  2.3314639485266042e+00  2.3025720282938664e+00
  2.2740317156522138e+00  2.2458387802381878e+00  2.2179890418615287e+00  2.1904783699209247e+00  2.1633026828265542e+00
  2.1364579474289513e+00  2.1099401784548633e+00  2.0837454379488491e+00  2.0578698347219415e+00  2.0323095238059636e+00
  2.0070607059144692e+00  1.9821196269094656e+00  1.9574825772748028e+00  1.9331458915948119e+00  1.9091059480394605e+00
  1.8853591678550714e+00  1.8619020148610232e+00  1.8387309949521082e+00  1.8158426556066445e+00  1.7932335854000101e+00
  1.7709004135240960e+00  1.7488398093118533e+00  1.7270484817675253e+00  1.7055231791022365e+00  1.6842606882747617e+00
  1.6632578345377880e+00  1.6425114809889934e+00  1.6220185281277253e+00  1.6017759134163896e+00  1.5817806108470975e+00
  1.5620296305131234e+00  1.5425200181854493e+00  1.5232488548939429e+00  1.5042132565135802e+00  1.4854103733552293e+00
  1.4668373897613378e+00  1.4484915237060108e+00  1.4303700263999062e+00  1.4124701818995149e+00  1.3947893067211226e+00
  1.3773247494590422e+00  1.3600738904082732e+00  1.3430341411915023e+00  1.3262029443906087e+00  1.3095777731819922e+00
  1.2931561309766195e+00  1.2769355510636231e+00  1.2609135962587104e+00  1.2450878585559551e+00  1.2294559587841078e+00
  1.2140155462665732e+00  1.1987642984854503e+00  1.1836999207494472e+00  1.1688201458656025e+00  1.1541227338147664e+00
  1.1396054714309045e+00  1.1252661720841743e+00  1.1111026753673983e+00  1.0971128467865228e+00  1.0832945774543603e+00
  1.0696457837881184e+00  1.0561644072101899e+00  1.0428484138526386e+00  1.0296957942649811e+00  1.0167045631254084e+00
  1.0038727589553318e+00  9.9119844383715616e-01  9.7867970313559383e-01  9.6631464522190313e-01  9.5410140120151610e-01
  9.4203812464478531e-01  9.3012299132083243e-01  9.1835419893454784e-01  9.0672996686658891e-01  8.9524853591645837e-01
  8.8390816804849592e-01  8.7270714614088618e-01  8.6164377373764367e-01  8.5071637480329088e-01  8.3992329348066619e-01
  8.2926289385125074e-01  8.1873355969859674e-01  8.0833369427423207e-01  7.9806172006654919e-01  7.8791607857216661e-01
  7.7789523007009365e-01  7.6799765339850623e-01  7.5822184573410212e-01  7.4856632237407794e-01  7.3902961652057897e-01
  7.2961027906773879e-01  7.2030687839120233e-01  7.1111800014000437e-01  7.0204224703107343e-01  6.9307823864600593e-01
  6.8422461123017442e-01  6.7548001749432984e-01  6.6684312641843491e-01  6.5831262305778537e-01  6.4988720835149039e-01
  6.4156559893307374e-01  6.3334652694340576e-01  6.2522873984571348e-01  6.1721100024293207e-01  6.0929208569699966e-01
  6.0147078855038671e-01  5.9374591574974644e-01  5.8611628867150145e-01  5.7858074294964013e-01  5.7113812830543509e-01
  5.6378730837917601e-01  5.5652716056388485e-01  5.4935657584100994e-01  5.4227445861801371e-01  5.3527972656789657e-01
  5.2837131047058605e-01  5.2154815405625499e-01  5.1480921385035572e-01  5.0815345902059406e-01  5.0157987122570802e-01
  4.9508744446591635e-01  4.8867518493523221e-01  4.8234211087549284e-01  4.7608725243208916e-01  4.6990965151138830e-01
  4.6380836163990580e-01  4.5778244782503386e-01  4.5183098641748920e-01  4.4595306497538445e-01  4.4014778212983252e-01
  4.3441424745224566e-01  4.2875158132308577e-01  4.2315891480226497e-01  4.1763538950099743e-01  4.1218015745523218e-01
  4.0679238100053006e-01  4.0147123264845597e-01  3.9621589496439391e-01  3.9102556044685599e-01  3.8589943140818761e-01
  3.8083671985667955e-01  3.7583664738007094e-01  3.7089844503050351e-01  3.6602135321072637e-01  3.6120462156172017e-01
  3.5644750885162857e-01  3.5174928286603446e-01  3.4710922029949565e-01  3.4252660664837542e-01  3.3800073610498238e-01
  3.3353091145289682e-01  3.2911644396363116e-01  3.2475665329440773e-01  3.2045086738724038e-01  3.1619842236917250e-01
  3.1199866245370167e-01  3.0785093984338019e-01  3.0375461463356856e-01  2.9970905471733467e-01  2.9571363569149867e-01
  2.9176774076376510e-01  2.8787076066095274e-01  2.8402209353838614e-01  2.8022114489027139e-01  2.7646732746120151e-01
  2.7276006115868867e-01  2.6909877296673734e-01  2.6548289686045123e-01  2.6191187372168301e-01  2.5838515125562722e-01
  2.5490218390845421e-01  2.5146243278591562e-01  2.4806536557292702e-01  2.4471045645407763e-01  2.4139718603512783e-01
  2.3812504126539480e-01  2.3489351536114356e-01  2.3170210772977384e-01  2.2855032389502927e-01  2.2543767542303872e-01
  2.2236367984922101e-01  2.1932786060613019e-01  2.1632974695208329e-01  2.1336887390071446e-01  2.1044478215129825e-01
  2.0755701801999038e-01  2.0470513337177820e-01  2.0188868555338146e-01  1.9910723732680591e-01  1.9636035680383923e-01
  1.9364761738119540e-01  1.9096859767654717e-01  1.8832288146523624e-01  1.8571005761779968e-01  1.8312972003822381e-01
  1.8058146760290850e-01  1.7806490410043718e-01  1.7557963817196587e-01  1.7312528325242749e-01  1.7070145751236865e-01
  1.6830778380049871e-01  1.6594388958697337e-01  1.6360940690727244e-01  1.6130397230684856e-01  1.5902722678634262e-01
  1.5677881574755137e-01  1.5455838893995200e-01  1.5236560040793634e-01  1.5020010843864373e-01  1.4806157551044308e-01
  1.4594966824199407e-01  1.4386405734196117e-01  1.4180441755932893e-01  1.3977042763426883e-01  1.3776177024965452e-01
  1.3577813198311262e-01  1.3381920325970409e-01  1.3188467830508266e-01  1.2997425509933525e-01  1.2808763533126566e-01
  1.2622452435332576e-01  1.2438463113698628e-01  1.2256766822875420e-01  1.2077335170661474e-01  1.1900140113708968e-01
  1.1725153953273537e-01  1.1552349331020029e-01  1.1381699224878616e-01  1.1213176944947190e-01  1.1046756129447299e-01
  1.0882410740725135e-01  1.0720115061304991e-01  1.0559843689985637e-01  1.0401571537986953e-01  1.0245273825141155e-01
  1.0090926076132156e-01  9.9385041167768140e-02  9.7879840703551491e-02  9.6393423539806733e-02  9.4925556750188100e-02
  9.3476010275438615e-02  9.2044556888424722e-02  9.0630972159587486e-02  8.9235034422777471e-02  8.7856524741557696e-02
  8.6495226875854758e-02  8.5150927249066477e-02  8.3823414915518146e-02  8.2512481528355774e-02  8.1217921307793262e-02
  7.9939531009756593e-02  7.8677109894921493e-02  7.7430459698090370e-02  7.6199384597978259e-02  7.4983691187329615e-02
  7.3783188443430792e-02  7.2597687698950253e-02  7.1427002613137169e-02  7.0270949143383721e-02  6.9129345517125795e-02
  6.8002012204063433e-02  6.6888771888750753e-02  6.5789449443483417e-02  6.4703871901554688e-02  6.3631868430787719e-02
  6.2573270307431539e-02  6.1527910890343041e-02  6.0495625595505587e-02  5.9476251870829167e-02  5.8469629171288062e-02
  5.7475598934329408e-02  5.6494004555598387e-02  5.5524691364960077e-02  5.4567506602792193e-02  5.3622299396587358e-02
  5.2688920737826273e-02  5.1767223459139533e-02  5.0857062211734139e-02  4.9958293443112645e-02  4.9070775375038789e-02
  4.8194367981803321e-02  4.7328932968710991e-02  4.6474333750875729e-02  4.5630435432230332e-02  4.4797104784824349e-02
  4.3974210228351573e-02  4.3161621809939543e-02  4.2359211184176626e-02  4.1566851593383136e-02  4.0784417848134691e-02
  4.0011786307996289e-02  3.9248834862517734e-02  3.8495442912441780e-02  3.7751491351154076e-02  3.7016862546342733e-02
  3.6291440321904345e-02  3.5575109940037652e-02  3.4867758083595213e-02  3.4169272838608267e-02  3.3479543677062740e-02
  3.2798461439850213e-02  3.2125918319956703e-02  3.1461807845833745e-02  3.0806024864983739e-02  3.0158465527744482e-02
  2.9519027271263543e-02  2.8887608803682241e-02  2.8264110088490835e-02  2.7648432329102635e-02  2.7040477953584219e-02
  2.6440150599604584e-02  2.5847355099535729e-02  2.5261997465764630e-02  2.4683984876160858e-02  2.4113225659734727e-02
  2.3549629282465290e-02  2.2993106333307090e-02  2.2443568510356116e-02  2.1900928607195835e-02  2.1365100499407763e-02
  2.0835999131238570e-02  2.0313540502443939e-02  1.9797641655275866e-02  1.9288220661649591e-02  1.8785196610443311e-02
  1.8288489594979307e-02  1.7798020700630746e-02  1.7313711992604564e-02  1.6835486503854691e-02  1.6363268223159144e-02
  1.5896982083323241e-02  1.5436553949552678e-02  1.4981910607941629e-02  1.4532979754120490e-02  1.4089689982039300e-02
  1.3651970772878608e-02  1.3219752484108893e-02  1.2792966338673439e-02  1.2371544414313762e-02  1.1955419633011832e-02
  1.1544525750577739e-02  1.1138797346350149e-02  1.0738169813035103e-02  1.0342579346658276e-02  9.9519629366497941e-03
  9.5662583560424119e-03  9.1854041517979157e-03  8.8093396352418862e-03  8.4380048726288015e-03  8.0713406758079476e-03
  7.7092885930126753e-03  7.3517908997683401e-03  6.9987905898953873e-03  6.6502313666337853e-03  6.3060576338778151e-03
  5.9662144875094469e-03  5.6306477068467364e-03  5.2993037461942505e-03  4.9721297264926356e-03  4.6490734270783207e-03
  4.3300832775373665e-03  4.0151083496663409e-03  3.7040983495217894e-03  3.3970036095808398e-03  3.0937750809827413e-03
  2.7943643258805384e-03  2.4987235098741234e-03  2.2068053945462074e-03  1.9185633300798921e-03  1.6339512479797147e-03
  1.3529236538666334e-03  1.0754356203770410e-03  8.0144278013627446e-04  5.3090131882682634e-04  2.6376796833782468e-04
  0.                      0.                      0.                      0.                      0.
  0.                     -3.9648238684865801e-06 -3.9647379584246923e-06 -3.9628213744895963e-06 -3.9467037431234605e-06
 -3.8669955682309838e-06 -3.5838112852706622e-06 -2.7802960750788119e-06 -8.4219761569586434e-07  3.2926772002249687e-06
  1.1307382478067452e-05  2.5690720406621164e-05  4.9922293853264408e-05  8.8645703309235546e-05  1.4781862131741774e-04
  2.3482997173037562e-04  3.5857643823965571e-04  5.2949280763813292e-04  7.5953302911151849e-04  1.0621011875219313e-03
  1.4519337282253714e-03  1.9449361497403880e-03  2.5579789454755197e-03  3.3086587999045514e-03  4.2150319227431399e-03
  5.2953269484396770e-03  6.5676450618533944e-03  8.0496549673465534e-03  9.7582900360645985e-03  1.1709454486124704e-02
  1.3917744814340938e-02  1.6396191946403960e-02  1.9156028742952969e-02  2.2206486626139221e-02  2.5554624205531451e-02
  2.9205189909676799e-02  3.3160519792081455e-02  3.7420470895219271e-02  4.1982389836949574e-02  4.6841115639814745e-02
  5.1989015261616922e-02  5.7416049808337366e-02  6.3109869018822096e-02  6.9055931302814066e-02  7.5237646386900447e-02
  8.1636537471760473e-02  8.8232419723046629e-02  9.5003591900837847e-02  1.0192703797172165e-01  1.0897863563601806e-01
  1.1613336883305392e-01  1.2336554145279433e-01  1.3064898967530336e-01  1.3795729057407335e-01  1.4526396484941184e-01
  1.5254267179758951e-01  1.5976739486619884e-01  1.6691261639058208e-01  1.7395348034786196e-01  1.8086594219887786e-01
  1.8762690511328639e-01  1.9421434208549382e-01  2.0060740364800100e-01  2.0678651107248047e-01  2.1273343511662279e-01
  2.1843136052589074e-01  2.2386493663365137e-01  2.2902031452042859e-01  2.3388517129408726e-01  2.3844872213752044e-01
  2.4270172083993913e-01  2.4663644958254860e-01  2.5024669879062600e-01  2.5352773789253646e-01  2.5647627784258198e-01
  2.5909042627096035e-01  2.6136963612034414e-01  2.6331464861675080e-01  2.6492743140259734e-01  2.6621111263431629e-01
  2.6716991181501903e-01  2.6780906809717919e-01  2.6813476675048165e-01  2.6815406444749179e-01  2.6787481397543011e-01
  2.6730558893605583e-01  2.6645560894936793e-01  2.6533466582915999e-01  2.6395305115245549e-01  2.6232148559814661e-01
  2.6045105038573091e-01  2.5835312110106301e-01  2.5603930415458720e-01  2.5352137607692704e-01  2.5081122581937443e-01
  2.4792080019090168e-01  2.4486205252950111e-01  2.4164689467539890e-01  2.3828715228427200e-01  2.3479452349277974e-01
  2.3118054092475315e-01  2.2745653700480872e-01  2.2363361252690162e-01  2.1972260840846225e-01  2.1573408054555276e-01
  2.1167827767206404e-01  2.0756512211437439e-01  2.0340419332460602e-01  1.9920471406724971e-01  1.9497553912901999e-01
  1.9072514641659932e-01  1.8646163030462937e-01  1.8219269709400621e-01  1.7792566244018726e-01  1.7366745061154099e-01
  1.6942459543887090e-01  1.6520324281963816e-01  1.6100915464284249e-01  1.5684771400427255e-01  1.5272393158544428e-01
  1.4864245307413970e-01  1.4460756750921444e-01  1.4062321643707509e-01  1.3669300377304516e-01  1.3282020626560875e-01
  1.2900778446772065e-01  1.2525839412448647e-01  1.2157439789251967e-01  1.1795787731163010e-01  1.1441064495527309e-01
  1.1093425669153945e-01  1.0753002399184552e-01  1.0419902622979293e-01  1.0094212291761373e-01  9.7759965832612039e-02
  9.4653010990620956e-02  9.1621530428073861e-02  8.8665623758583667e-02  8.5785229473909652e-02  8.2980135963188761e-02
  8.0249992227829470e-02  7.7594318273021212e-02  7.5012515159829540e-02  7.2503874705091231e-02  7.0067588818818471e-02
  6.7702758471654079e-02  6.5408402287066458e-02  6.3183464755318219e-02  6.1026824068104446e-02  5.8937299574615798e-02
  5.6913658861432515e-02  5.4954624460036072e-02  5.3058880187135005e-02  5.1225077124064100e-02  4.9451839242618867e-02
  4.7737768685490067e-02  4.6081450710315774e-02  4.4481458306923960e-02  4.2936356497934813e-02  4.1444706333338299e-02
  4.0005068589950232e-02  3.8616007186985657e-02  3.7276092329113775e-02  3.5983903388508764e-02  3.4738031537461467e-02
  3.3537082143044072e-02  3.2379676935394341e-02  3.1264455960905213e-02  3.0190079331599784e-02  2.9155228781700626e-02
  2.8158609042236105e-02  2.7198949044218823e-02  2.6275002960732485e-02  2.5385551097897086e-02  2.4529400644468402e-02
  2.3705386289384900e-02  2.2912370716361652e-02  2.2149244984220884e-02  2.1414928801316790e-02  2.0708370702084089e-02
  2.0028548133355972e-02  1.9374467457788813e-02  1.8745163881344395e-02  1.8139701311457701e-02  1.7557172152180667e-02
  1.6996697042253484e-02  1.6457424541724941e-02  1.5938530772423354e-02  1.5439219017299555e-02  1.4958719283310606e-02
  1.4496287832256260e-02  1.4051206683705519e-02  1.3622783093843127e-02  1.3210349013833056e-02  1.2813260531043369e-02
  1.2430897296217491e-02  1.2062661939473140e-02  1.1707979477758812e-02  1.1366296716230184e-02  1.1037081645763447e-02
  1.0719822838679227e-02  1.0414028844531742e-02  1.0119227587681079e-02  9.8349657681883751e-03  9.5608082674313311e-03
  9.2963375596950559e-03  9.0411531308550175e-03  8.7948709051597906e-03  8.5571226809857404e-03  8.3275555763442921e-03
  8.1058314848086455e-03  7.8916265424464060e-03  7.6846306062413605e-03  7.4845467444241143e-03  7.2910907390426050e-03
  7.1039906010419707e-03  6.9229860980661584e-03  6.7478282951155544e-03  6.5782791081698544e-03  6.4141108708119787e-03
  6.2551059138641618e-03  6.1010561579909195e-03  5.9517627192071654e-03  5.8070355271753749e-03  5.6666929561701718e-03
  5.5305614685408344e-03  5.3984752704999139e-03  5.2702759800296040e-03  5.1458123066918660e-03  5.0249397431101073e-03
  4.9075202678708352e-03  4.7934220595943211e-03  4.6825192219082379e-03  4.5746915190486293e-03  4.4698241218146806e-03
  4.3678073635918802e-03  4.2685365061615743e-03  4.1719115150071207e-03  4.0778368438337265e-03  3.9862212280138976e-03
  3.8969774866705609e-03  3.8100223331219985e-03  3.7252761933992129e-03  3.6426630325680220e-03  3.5621101885756068e-03
  3.4835482133581258e-03  3.4069107209438593e-03  3.3321342422940048e-03  3.2591580866271896e-03  3.1879242089835474e-03
  3.1183770837836661e-03  3.0504635841505645e-03  2.9841328667638833e-03  2.9193362620252433e-03  2.8560271693185979e-03
  2.7941609571553727e-03  2.7336948680027617e-03  2.6745879275973244e-03  2.6168008585546049e-03  2.5602959980906281e-03
  2.5050372196779025e-03  2.4509898584648832e-03  2.3981206402930583e-03  2.3463976141530341e-03  2.2957900879271853e-03
  2.2462685672689497e-03  2.1978046974800575e-03  2.1503712082465293e-03  2.1039418611046024e-03  2.0584913995096016e-03
  2.0139955013874500e-03  1.9704307340533550e-03  1.9277745113862321e-03  1.8860050531527214e-03  1.8451013463796004e-03
  1.8050431086757621e-03  1.7658107534117631e-03  1.7273853566669717e-03  1.6897486258593344e-03  1.6528828699756068e-03
  1.6167709713248088e-03  1.5813963587400434e-03  1.5467429821572412e-03  1.5127952885036697e-03  1.4795381988309333e-03
  1.4469570866303127e-03  1.4150377572722111e-03  1.3837664285128795e-03  1.3531297120151151e-03  1.3231145958318286e-03
  1.2937084278030683e-03  1.2648988998213845e-03  1.2366740329201806e-03  1.2090221631435791e-03  1.1819319281576313e-03
  1.1553922545643608e-03  1.1293923458830929e-03  1.1039216711636532e-03  1.0789699541992048e-03  1.0545271633073811e-03
  1.0305835016493139e-03  1.0071293980598306e-03  9.8415549835969424e-04  9.6165265712688103e-04  9.3961192990005618e-04
  9.1802456579386654e-04  8.9688200050116323e-04  8.7617584966451570e-04  8.5589790259397308e-04  8.3604011631561656e-04
  8.1659460992970084e-04  7.9755365926454519e-04  7.7890969180804612e-04  7.6065528190175785e-04  7.4278314618478683e-04
  7.2528613927106897e-04  7.0815724964966645e-04  6.9138959579336315e-04  6.7497642246599002e-04  6.5891109721573707e-04
  6.4318710704439411e-04  6.2779805524357593e-04  6.1273765838630243e-04  5.9799974346742141e-04  5.8357824518249710e-04
  5.6946720333813164e-04  5.5566076038550405e-04  5.4215315907093706e-04  5.2893874019495010e-04  5.1601194047556226e-04
  5.0336729050731374e-04  4.9099941281269613e-04  4.7890301997820760e-04  4.6707291287201823e-04  4.5550397893638281e-04
  4.4419119055210364e-04  4.3312960346890764e-04  4.2231435529930562e-04  4.1174066407052325e-04  4.0140382683225874e-04
  3.9129921831561852e-04  3.8142228964106219e-04  3.7176856707126643e-04  3.6233365080714369e-04  3.5311321382303952e-04
  3.4410300074003836e-04  3.3529882673348846e-04  3.2669657647382659e-04  3.1829220309746720e-04  3.1008172720682972e-04
  3.0206123589660537e-04  2.9422688180553644e-04  2.8657488219117726e-04  2.7910151802692032e-04  2.7180313311903591e-04
  2.6467613324337308e-04  2.5771698529936972e-04  2.5092221648138381e-04  2.4428841346509078e-04  2.3781222160909783e-04
  2.3149034416975432e-04  2.2531954152932993e-04  2.1929663043573910e-04  2.1341848325407385e-04  2.0768202722833053e-04
  2.0208424375349737e-04  1.9662216765670235e-04  1.9129288648763332e-04  1.8609353981691688e-04  1.8102131854280147e-04
  1.7607346420509158e-04  1.7124726830643981e-04  1.6654007164013281e-04  1.6194926362479885e-04  1.5747228164487721e-04
  1.5310661039735773e-04  1.4884978124416175e-04  1.4469937156988671e-04  1.4065300414520775e-04  1.3670834649513481e-04
  1.3286311027261265e-04  1.2911505063676991e-04  1.2546196563624316e-04  1.2190169559701987e-04  1.1843212251511082e-04
  1.1505116945364222e-04  1.1175679994469313e-04  1.0854701739540810e-04  1.0541986449882348e-04  1.0237342264892693e-04
  9.9405811360358132e-05  9.6515187692370902e-05  9.3699745677400074e-05  9.0957715753944412e-05  8.8287364204016165e-05
  8.5686992595021983e-05  8.3154937226130685e-05  8.0689568579240655e-05  7.8289290774479197e-05  7.5952541030245135e-05
  7.3677789127971592e-05  7.1463536881511379e-05  6.9308317611135005e-05  6.7210695622487836e-05  6.5169265690054930e-05
  6.3182652545669578e-05  6.1249510371733790e-05  5.9368522299412668e-05  5.7538399911702919e-05  5.5757882751529672e-05
  5.4025737834792475e-05  5.2340759168498360e-05  5.0701767273936662e-05  4.9107608714990146e-05  4.7557155631555758e-05
  4.6049305278167809e-05  4.4582979567776111e-05  4.3157124620795718e-05  4.1770710319351517e-05  4.0422729866826726e-05
  3.9112199352681499e-05  3.7838157322578683e-05  3.6599664353829334e-05  3.5395802636168814e-05  3.4225675557885814e-05
  3.3088407297285436e-05  3.1983142419520589e-05  3.0909045478793879e-05  2.9865300625895935e-05  2.8851111221144367e-05
  2.7865699452646157e-05  2.6908305959935305e-05  2.5978189462957544e-05  2.5074626396383586e-05  2.4196910549263251e-05
  2.3344352709974737e-05  2.2516280316490600e-05  2.1712037111907092e-05  2.0930982805247291e-05  2.0172492737486822e-05
  1.9435957552817900e-05  1.8720782875073102e-05  1.8026388989343211e-05  1.7352210528701778e-05  1.6697696166057181e-05
  1.6062308311053184e-05  1.5445522812031513e-05  1.4846828662973418e-05  1.4265727715439625e-05  1.3701734395386378e-05
  1.3154375424950706e-05  1.2623189548993381e-05  1.2107727266537382e-05  1.1607550566894442e-05  1.1122232670585292e-05
  1.0651357774867272e-05  1.0194520803960007e-05  9.7513271637940575e-06  9.3213925013519642e-06  8.9043424684557833e-06
  8.4998124900184896e-06  8.1074475366826621e-06  7.7269019017899053e-06  7.3578389826527103e-06  6.9999310660550837e-06
  6.6528591179447027e-06  6.3163125772558795e-06  5.9899891538183966e-06  5.6735946302881356e-06  5.3668426680612271e-06
  5.0694546171018459e-06  4.7811593296462449e-06  4.5016929777116346e-06  4.2307988743741287e-06  3.9682272987463124e-06
  3.7137353246110118e-06  3.4670866526486516e-06  3.2280514462130431e-06  2.9964061705913111e-06  2.7719334357045357e-06
  2.5544218421855755e-06  2.3436658307887529e-06  2.1394655350692488e-06  1.9416266372896795e-06  1.7499602274870685e-06
  1.5642826656651399e-06  1.3844154470325960e-06  1.2101850702750470e-06  1.0414229087590029e-06  8.7796508466752112e-07
  7.1965234596822335e-07  5.6632994620788219e-07  4.1784752704301887e-07  2.7405900348531609e-07  1.3482245179844733e-07
  0.                      0.                      0.                      0.                      0.

"""
