/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.classloading.vfs;

import java.net.URL;
import java.security.PrivilegedAction;
import java.security.AccessController;

/**
 * A ClassLoaderUtil.
 *
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 69895 $
 */
public class ClassLoaderUtil
{
   /**
    * Get the location of a class
    *
    * @param className the class name
    * @return the location
    * @throws ClassNotFoundException if the class is not found
    */
   public static URL getLocation(String className) throws ClassNotFoundException
   {
      Class<?> clazz = Class.forName(className);
      return clazz.getProtectionDomain().getCodeSource().getLocation();
   }

   /**
    * Get the classloader.
    *
    * @param clazz the class
    * @return the classloader
    */
   public static ClassLoader getClassLoader(final Class<?> clazz)
   {
      if (clazz == null)
         throw new IllegalArgumentException("Null clazz.");

      SecurityManager sm = System.getSecurityManager();
      if (sm == null)
         return clazz.getClassLoader();
      else
         return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>()
         {
            public ClassLoader run()
            {
               return clazz.getClassLoader();
            }
         });
   }
}
