/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.aop.microcontainer.beans;

import org.jboss.aop.AspectManager;
import org.jboss.aop.metadata.ClassMetaDataBinding;
import org.jboss.aop.metadata.ClassMetaDataLoader;
import org.jboss.util.id.GUID;
import org.w3c.dom.Element;

/**
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public class ClassMetaData
{
   AspectManager manager;
   String name;
   
   //Should we read these from the element instead?
   String tag;
   String className;
   
   Element element;

   public AspectManager getManager()
   {
      return manager;
   }
   
   public void setManager(AspectManager manager)
   {
      this.manager = manager;
   }
   
   public String getName()
   {
      return name;
   }
   
   public void setName(String name)
   {
      this.name = name;
   }
   
   public String getTag()
   {
      return tag;
   }
   
   public void setTag(String tag)
   {
      this.tag = tag;
   }
   
   public String getClassName()
   {
      return className;
   }
   
   public void setClassName(String className)
   {
      this.className = className;
   }

   public Element getElement()
   {
      return element;
   }

   public void setElement(Element element)
   {
      this.element = element;
   }
      
   public void start()
   {
      if (manager == null)
         throw new IllegalArgumentException("Null manager");
      if (tag == null)
         throw new IllegalArgumentException("Null tag");
      if (className == null)
         throw new IllegalArgumentException("Null className");
      if (name == null)
         name = GUID.asString();
      
      ClassMetaDataLoader loader = manager.findClassMetaDataLoader(tag);
      try
      {
         ClassMetaDataBinding data = loader.importMetaData(element, name, tag, className);
         manager.addClassMetaData(data);      
      }
      catch (Exception e)
      {
         // AutoGenerated
         throw new RuntimeException(e);
      }
   }
   
   public void stop()
   {
      manager.removeClassMetaData(name);
   }
}
