/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.config.Dynamic;

/**
 * Configuration implementation for {@link LFUPolicy}.
 * <p/>
 * If configured via XML, expects the following:
 * <p/>
 * <pre>
 * <region name="abc">
 *    <attribute name="minNodes">10</attribute>
 *    <attribute name="maxNodes">20</attribute>
 * </region>
 * </pre>
 *
 * @author Daniel Huang (dhuang@jboss.org)
 * @version $Revision: 6120 $
 */
public class LFUConfiguration extends EvictionPolicyConfigBase
{
   /**
    * The serialVersionUID
    */
   private static final long serialVersionUID = 1865801530398969179L;

   @Dynamic
   private int minNodes;

   @Override
   protected void setEvictionPolicyClassName()
   {
      setEvictionPolicyClass(LFUPolicy.class.getName());
   }

   public int getMinNodes()
   {
      return minNodes;
   }

   public void setMinNodes(int minNodes)
   {
      testImmutability("minNodes");
      this.minNodes = minNodes;
   }

   @Override
   public String toString()
   {
      StringBuilder ret = new StringBuilder();
      ret.append("LFUConfiguration: maxNodes = ").append(getMaxNodes()).append(" minNodes = ").append(getMinNodes());
      return ret.toString();
   }

   @Override
   public boolean equals(Object obj)
   {
      if (super.equals(obj))
      {
         return (this.minNodes == ((LFUConfiguration) obj).minNodes);
      }
      return false;
   }

   @Override
   public int hashCode()
   {
      int result = super.hashCode();
      result = 31 * result + minNodes;
      return result;
   }

   @Override
   public LFUConfiguration clone() throws CloneNotSupportedException
   {
      return (LFUConfiguration) super.clone();
   }

}
