package org.jboss.cache.eviction;

import org.jboss.cache.config.Dynamic;

/**
 * Configuration for indicating the Node key for setting a specific eviction time.
 */
public class ExpirationConfiguration extends EvictionPolicyConfigBase
{

   private static final long serialVersionUID = 47338798734219507L;

   /**
    * Default key name for indicating expiration time.
    */
   public static final String EXPIRATION_KEY = "expiration";

   /**
    * Node key name used to indicate the expiration of a node.
    */
   @Dynamic
   private String expirationKeyName = EXPIRATION_KEY;

   @Dynamic
   private boolean warnNoExpirationKey = true;

   @Dynamic
   private int timeToLiveSeconds = 0;

   @Override
   protected void setEvictionPolicyClassName()
   {
      setEvictionPolicyClass(ExpirationPolicy.class.getName());
   }

   /**
    * Returns the expirationKeyName.
    * This key should point to a java.lang.Long value in the Node data.
    */
   public String getExpirationKeyName()
   {
      return expirationKeyName;
   }

   /**
    * Sets the expirationKeyName.
    */
   public void setExpirationKeyName(String expirationKeyName)
   {
      this.expirationKeyName = expirationKeyName;
   }

   /**
    * Returns true if the algorithm should warn if a expiration key is missing for a node.
    */
   public boolean getWarnNoExpirationKey()
   {
      return warnNoExpirationKey;
   }

   /**
    * Sets if the algorithm should warn if a expiration key is missing for a node.
    */
   public void setWarnNoExpirationKey(boolean warnNoExpirationKey)
   {
      this.warnNoExpirationKey = warnNoExpirationKey;
   }

   public int getTimeToLiveSeconds()
   {
      return timeToLiveSeconds;
   }

   public void setTimeToLiveSeconds(int timeToLiveSeconds)
   {
      this.timeToLiveSeconds = timeToLiveSeconds;
   }

   @Override
   public ExpirationConfiguration clone() throws CloneNotSupportedException
   {
      return (ExpirationConfiguration) super.clone();
   }


}
