/* 
//  $Id: command.l 1.3.1.4.1.11 Mon, 27 Nov 2000 11:42:24 -0800 cengiz $
//
//  Copyright (c) 1994 by the University of Southern California
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and its
//  documentation in source and binary forms for lawful non-commercial
//  purposes and without fee is hereby granted, provided that the above
//  copyright notice appear in all copies and that both the copyright
//  notice and this permission notice appear in supporting documentation,
//  and that any documentation, advertising materials, and other materials
//  related to such distribution and use acknowledge that the software was
//  developed by the University of Southern California, Information
//  Sciences Institute. The name of the USC may not be used to endorse or
//  promote products derived from this software without specific prior
//  written permission.
//
//  THE UNIVERSITY OF SOUTHERN CALIFORNIA DOES NOT MAKE ANY
//  REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY
//  PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
//  IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE,
//  TITLE, AND NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT, TORT,
//  OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE
//  OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to
//  ratoolset@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu <cengiz@ISI.EDU>
*/

/* definitions */
%x USEFUL_LINE
%x USELESS_LINE

DNAME          [[:alnum:]_-]+

%{
#include "config.h"
#include <iostream.h>
#include "RtConfig.hh"
#include "command.y.hh"
#include "irr/irr.hh"

#define yylval commandlval
#define LEXER_RETURN(x)  return(x)

typedef struct _KeyWord {
   char *val;
   int num;
} KeyWord;

int yylineno = 1;

static KeyWord keywords[] = {
"import",                  KW_IMPORT,
"export",                  KW_EXPORT,
"exportGroup",             KW_EXPORT_GROUP,
"importGroup",             KW_IMPORT_GROUP,
"default",                 KW_DEFAULT,
"printPrefixes",           KW_PRINT_PREFIXES,
"printPrefixRanges",       KW_PRINT_PREFIX_RANGES,
"printSuperPrefixRanges",  KW_PRINT_SUPER_PREFIX_RANGES,
"access_list",             KW_ACCESS_LIST,
"aspath_access_list",      KW_ASPATH_ACCESS_LIST,
"configureRouter",         KW_CONFIGURE_ROUTER,
"static2bgp",              KW_STATIC2BGP,
"networks",                KW_NETWORKS,
"pkt_filter",              KW_PKT_FILTER,
"outbound_pkt_filter",     KW_OUTBOUND_PKT_FILTER,
"set",                     KW_SET,
"cisco_map_name",          KW_CISCO_MAP_NAME,
"junos_policy_name",       KW_JUNOS_POLICY_NAME,
"cisco_map_increment_by",  KW_CISCO_MAP_INC,
"cisco_map_first_no",      KW_CISCO_MAP_START,
"cisco_access_list_no",    KW_CISCO_ACCESS_LIST_NO,
"cisco_prefix_acl_no",     KW_CISCO_PREFIX_ACL_NO,
"cisco_aspath_acl_no",     KW_CISCO_ASPATH_ACL_NO,
"cisco_pktfilter_acl_no",  KW_CISCO_PKTFILTER_ACL_NO,
"cisco_community_acl_no",  KW_CISCO_COMMUNITY_ACL_NO,
"cisco_max_preference",    KW_PREFERENCECEILING,
"sources",                 KW_SOURCE,
"bcc_version_line",        KW_BCC_VERSION, 
"bcc_max_preference",      KW_BCC_MAX_PREFERENCE, 
"bcc_advertise_nets",      KW_BCC_ADVERTISE_NETS,
"bcc_advertise_all",       KW_BCC_ADVERTISE_ALL,
"bcc_force_back",          KW_BCC_FORCE_BACK,
"bcc_max_prefixes",        KW_BCC_MAX_PREFIXES,
NULL,        -1
};

static int get_keyword_num(char *string) {
   int i;

   for (i = 0; keywords[i].val; i++)
      if (!strcmp(keywords[i].val, string))
	 break;

   return(keywords[i].num);
}

extern "C" {
int yywrap () {
   return 1;
}
}

%}

%%

%{
/* Rules */
%}

^@RtConfig {
   BEGIN(USEFUL_LINE);
}

\n {
   yylineno++;
   ECHO;
   /* simply skip this line, it is not interesting to us */
   LEXER_RETURN((int) *yytext);
}

. {
   ECHO;
   /* simply skip this line, it is not interesting to us */
   BEGIN(USELESS_LINE);
}

<USELESS_LINE>.* {
   ECHO;
   /* simply skip this line, it is not interesting to us */
}

<USELESS_LINE>\n {
   yylineno++;
   ECHO;
   /* simply skip this line, it is not interesting to us */
   BEGIN(INITIAL);
   LEXER_RETURN((int) *yytext);
}

<USEFUL_LINE>[Aa][Ss][0-9]+ {
   yylval.as = atoi(yytext+2);
   LEXER_RETURN(TKN_ASNUM);
}

<USEFUL_LINE>[0-9]+(\.[0-9]+){3,3} {
   yylval.ip = new IPAddr(yytext);
   LEXER_RETURN(TKN_IP);
}

<USEFUL_LINE>{DNAME}("."{DNAME})+ {
   yylval.val = strdup(yytext);
   LEXER_RETURN(TKN_DNSNAME);
}

<USEFUL_LINE>[0-9]+ {
   yylval.i = atoi(yytext);
   LEXER_RETURN(TKN_INT);
}

<USEFUL_LINE>\"([^\"]|\\\")*\" { 
   yylval.val = yytext + 1; 
   *(yytext + yyleng - 1) = 0;
   LEXER_RETURN(TKN_STR);
}

<USEFUL_LINE>filter\ .* {
   yylval.val = yytext + 7; 
   LEXER_RETURN(TKN_FILTER);
}

<USEFUL_LINE>[ \t,]+ { 
   /* Skip white space */
}

<USEFUL_LINE>\n {
   yylineno++;
   BEGIN(INITIAL);
   LEXER_RETURN((int) *yytext);
}

<USEFUL_LINE>= {
   LEXER_RETURN((int) *yytext);
}

<USEFUL_LINE>. {
   LEXER_RETURN(TKN_ERROR);
}

<USEFUL_LINE>[A-Za-z_0-9-]+ {
   int code = get_keyword_num(yytext);
   if (code != -1)
      LEXER_RETURN(code);

   yylval.val = yytext;
   LEXER_RETURN(TKN_WORD);
}

%%

/* User Code if any */








