// $Id: RadixSet.cc 1.2 Fri, 18 Jul 1997 16:00:26 -0700 wlee $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu <cengiz@isi.edu>

#include "config.hh"
#include "RadixSet.hh"
#include "PrefaskMap.hh"

RadixNode *RadixNode::insert(Pix rt, void *dt) {
   unsigned int mask = 1 << 31;
   RadixNode *current = this;
   unsigned int  prefix = Prefask_map(rt).get_prefix();
   unsigned char length = Prefask_map(rt).get_length();

   for (int i = 0; i < length; ++i, mask = mask >> 1) {
      if (! (prefix & mask)) {
	 if (! current->left) 
	    current->left = new RadixNode(current);
	 current = current->left;
      }
      else { 
	 if (! current->rght) 
	    current->rght = new RadixNode(current);
	 current = current->rght;
      }
   }

   if (current->state != RADIX_FULL) {
      current->state = RADIX_FULL;
      current->route = rt;
      current->data  = dt;
   }
}

RadixNode *RadixNode::find(Pix rt) {
   unsigned int mask = 1 << 31;
   RadixNode *current = this;
   unsigned int  prefix = Prefask_map(rt).get_prefix();
   unsigned char length = Prefask_map(rt).get_length();

   for (int i = 0; i < length; ++i, mask = mask >> 1) {
      if (! (prefix & mask)) {
	 if (! current->left) 
	    return NULL;
	 current = current->left;
      }
      else { 
	 if (! current->rght) 
	    return NULL;
	 current = current->rght;
      }
   }

   return current;
}

inline RadixNode *RadixNode::next_i() {
   RadixNode *current = this;

   if (current->left)
      return current->left;

   if (current->rght)
      return current->rght;
      
   while (current->prnt) {
      while (current->prnt && current == current->prnt->left) { 
	 // I was a left child
	 current = current->prnt;
	 if (current->rght)
	    return current->rght;
      }
      while (current->prnt && current == current->prnt->rght)
	 // I was a rght child
	 current = current->prnt;
   }
   return NULL;
}

RadixNode *RadixNode::next() {
   RadixNode *current;
   for (current = this->next_i(); 
	current && current->state == RADIX_EMPTY;
	current = current->next_i())
      ;
   return current;
}

