// $Id: asno.cc 1.5 Fri, 18 Jul 1997 15:53:23 -0700 wlee $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu <cengiz@isi.edu>

#include "config.hh"
#include "asno.hh"

#ifndef MAX
#define MAX(x,y) ((x) > (y) ? (x) : (y))
#endif

// static member initialization
char *re_asno_t::prefix_str = "AS";

ostream& operator<<(ostream& out, const re_asno_t &no) {
   re_asno_t::range *pi, *qi;

   if (no.universal())
      out << ".";
   else if (no.empty())
      out << "E";
   else
      for (pi = no.ranges.head(); pi; pi = no.ranges.next(pi->ranges)) {
	 out << " " << no.prefix_str << pi->low;
	 if (pi->low != pi->high)
	    out << "-" << no.prefix_str << pi->high;
      }

   return out;
}

re_asno_t& re_asno_t::operator+=(re_asno_t& no) { // destroys no
   range *pi, *qi, *r;

   pi = ranges.head();
   qi = no.ranges.head();
   while (pi && qi) {
      while (pi && pi->low <= qi->low)
	 pi = ranges.next(pi->ranges);

      if (pi)
	 while (qi && qi->low < pi->low) {
	    r = qi;
	    qi = no.ranges.next(qi->ranges);
	    ranges.insert_before(pi->ranges, r->ranges);
	 }
   }

   if (qi) // add remaining ranges of no
      ranges.splice(no.ranges);

   for (pi = ranges.head(); pi; ) {
      qi = ranges.next(pi->ranges);
      if (qi && pi->high >= qi->low - 1) {
	 pi->high = MAX(qi->high, pi->high);
	 ranges.unlink(qi->ranges);
	 delete qi;
      } else
	 pi = qi;
   }

   no.ranges.set_empty();
   return *this;
}

void re_asno_t::complement() {
   range *pi = ranges.head();
   range *qi;

   if (universal()) {
      clear();
      return;
   }

   if (empty()) {
      ranges.append((new range(0, MAX_AS))->ranges);
      return;
   }

   if (pi->low != 0)
      ranges.prepend((new range(0, (*pi).low-1))->ranges);

   for (qi = ranges.next(pi->ranges); 
	qi; 
	pi = qi, qi = ranges.next(qi->ranges)) {
      pi->low  = pi->high + 1;
      pi->high = qi->low  - 1;
   }

   if (pi->high != MAX_AS) {
      pi->low  = pi->high + 1;
      pi->high = MAX_AS;
   } else {
      ranges.unlink(pi->ranges);
      delete pi;
   }
}

int re_asno_t::contains(const range r) const {
   for (range *i = ranges.head(); i; i = ranges.next(i->ranges))
      if (i->low <= r.low && i->high >= r.high)
	 return 1;

   return 0;
}

