/* $Id: xx_lexer.y 1.4 Fri, 18 Jul 1997 16:00:26 -0700 wlee $
 
  Copyright (c) 1994 by the University of Southern California
  and/or the International Business Machines Corporation.
  All rights reserved.

  Permission to use, copy, modify, and distribute this software and
  its documentation in source and binary forms for lawful
  non-commercial purposes and without fee is hereby granted, provided
  that the above copyright notice appear in all copies and that both
  the copyright notice and this permission notice appear in supporting
  documentation, and that any documentation, advertising materials,
  and other materials related to such distribution and use acknowledge
  that the software was developed by the University of Southern
  California, Information Sciences Institute and/or the International
  Business Machines Corporation.  The name of the USC or IBM may not
  be used to endorse or promote products derived from this software
  without specific prior written permission.

  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
  NON-INFRINGEMENT.

  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
  THE USE OR PERFORMANCE OF THIS SOFTWARE.

  Questions concerning this software should be directed to 
  info-ra@isi.edu.

  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu) */


/* definitions */
%x  ASPATHRE

%{

#include "config.hh"
#include <cstring>
#include <iostream.h>
#include <fstream.h>
#include <GetOpt.h>
#include <trace.hh>
#include <Error.hh>
#include <cstdio>
#include <cctype>

extern "C" {
#include <sys/stat.h>
}

#include "Node.h"
#include "xx_parser.h"
#include "RegisterMap.hh"
#include "PrefaskMap.hh"
#include "ASMap.h"
#include "ASMacroMap.h"
#include "CommunityMap.hh"

#define LEXER_RETURN(x)  parser_error(yytext); return(x)
#define yylval xxlval

extern Error parser_error;

typedef struct _Word {
   char *val;
   int num;
} Word;

static Word words[] = {
"AND",    AND_TKN,
"and",    AND_TKN,
"OR",     OR_TKN,
"or",     OR_TKN,
"NOT",    NOT_TKN,
"not",    NOT_TKN,
"from",   FROM_TKN,
"accept", ACCEPT_TKN,
"set",    SET_TKN,
"SET",    SET_TKN,
"ANY",    ANY_TKN,
"IGP",    IGP_TKN,
"MED",    MED_TKN,
"PREF",   PREF_TKN,
//"to",     TO_TKN,
//"transit",TRANSIT_TKN,
//"exclude",EXCLUDE_TKN,
NULL,     ERROR_TKN
};

static inline strtoupper(char *c) {
   for (; *c; c++)
      if (isascii(*c) && isalpha(*c))
	 *c = toupper(*c);
}

static int get_tok_num(char *string) {
   int i;

   for (i = 0; words[i].val; i++)
      if (!strcmp(words[i].val, string))
	 break;

   return(words[i].num);
}

static struct stat statbuf;

#ifndef MIN
#define MIN(x,y) ((x) < (y) ? (x) : (y))
#endif
#ifndef MAX
#define MAX(x,y) ((x) > (y) ? (x) : (y))
#endif

extern "C" {
int yywrap () {
   return 1;
}
}

#undef YY_INPUT
#define YY_INPUT(buf,result,max_size) { \
        if ( yy_current_buffer->yy_is_interactive ) \
                { \
                int c = getc( yyin ); \
                result = c == EOF ? 0 : 1; \
                buf[0] = (char) c; \
                } \
        else { \
	   if (fstat(fileno(yyin), &statbuf) < 0) \
	      YY_FATAL_ERROR( "input in flex scanner failed" ); \
	   result = MAX(MIN(max_size, statbuf.st_size), 1); \
           if ( ((result = fread( buf, 1, result, yyin )) == 0) \
                  && ferror( yyin ) ) \
                YY_FATAL_ERROR( "input in flex scanner failed" ); \
        } \
	if (result < max_size) \
           buf[result] = 0; \
        Trace(TR_INPUT) << (char *) buf; \
}

#ifdef 0
#undef YY_INPUT
#define YY_INPUT(buf, result, max_size) {\
        int buflen;\
\
        if ((buflen = strlen(lex_buf)) == 0) { \
                result = YY_NULL;\
                buf[0] = '\0'; \
        } \
        else {\
                if (buflen >= max_size) {\
                        (void)strncpy(buf, lex_buf, max_size);\
                        result = max_size;\
                }\
                else {\
                        (void)strncpy(buf, lex_buf, buflen);\
                        result = buflen;\
                }\
                lex_buf += result;\
        }\
}
#endif
%}

%%

%{
/* Rules */
%}

\$[a-zA-Z0-9./%]+ {
   yylval.pi = register_map.add_entry(yytext);
   LEXER_RETURN(REGISTER_TKN);
}

[a-z]+ {
   LEXER_RETURN(get_tok_num(yytext));
}

<ASPATHRE,INITIAL>[Aa][Ss][0-9]+ {
   strtoupper(yytext);

   yylval.pi = AS_map.add_entry(yytext);
   LEXER_RETURN(ASNUM_TKN);
}

<ASPATHRE,INITIAL>[Aa][Ss]-[A-Za-z0-9_-]+ {
   strtoupper(yytext);

   yylval.pi = ASMacro_map.add_entry(yytext);
   LEXER_RETURN(ASMACRO_TKN);
}

[A-Za-z][A-Za-z0-9_-]* {
   int token_type;

   strtoupper(yytext);

   if ((token_type = get_tok_num(yytext)) == ERROR_TKN) {
      token_type = CNAME_TKN;
      yylval.pi = Community_map.add_entry(yytext);
   }

   LEXER_RETURN(token_type);
}

[0-9]+ {
   yylval.i = atoi(yytext);
   LEXER_RETURN(NUM_TKN);
}

[0-9]+(\.[0-9]+){3,3}\/[0-9]+(\^([0-9]+)(-[0-9]+)?)? {
   static char addr[256];
   char buf[64];
   int length, n = 0, m = 0;
   sscanf(yytext, "%[^/]/%d^%d-%d", buf, &length, &n, &m);
   if (n == 0) n = length;
   if (m == 0) m = n;
   sprintf(addr, "%s/%d^%d-%d", buf, length, n, m);
   yytext = addr;
   yylval.pi = Prefask_map.add_entry(yytext);
   LEXER_RETURN(PRFMSK_TKN);
}

[0-9]+(\.[0-9]+){3,3}\/[0-9]+(\^[+-])? {
   static char addr[256];
   char buf[64], ch;
   int length, n, m = 32;
   sscanf(yytext, "%[^/]/%d^%c", buf, &length, &ch);
   switch (ch)
     {
     case '+': 
       /* inclusive */
       n = length; 
       break;
     case '-': 
       /* exclusive */
       n = length + 1; 
       break;
     }
   sprintf(addr, "%s/%d^%d-%d", buf, length, n, m);
   yytext = addr;
   yylval.pi = Prefask_map.add_entry(yytext);
   LEXER_RETURN(PRFMSK_TKN);
}

[,{}():?] { 
   LEXER_RETURN((int) *yytext); 
}

\; { 
   LEXER_RETURN((int) *yytext); 
}

\< {
   BEGIN(ASPATHRE);
   LEXER_RETURN((int) *yytext); 
}

<ASPATHRE>\> {
   BEGIN(INITIAL);
   LEXER_RETURN((int) *yytext); 
}

<ASPATHRE>[()^|*+\-\.[\]?$] { 
   LEXER_RETURN((int) *yytext); 
}

<ASPATHRE,INITIAL>[ \t]+ { 
   /* Skip white space */
   parser_error(yytext); 
}

<ASPATHRE>_+ { 
   /* Skip white space */
   parser_error(yytext);
}

<ASPATHRE,INITIAL>\n {
   BEGIN(INITIAL);
   LEXER_RETURN((int) *yytext); 
}

<ASPATHRE,INITIAL>. {
   BEGIN(INITIAL);   
   LEXER_RETURN(ERROR_TKN);
}
%%

/* User Code if any */

