// $Id: NE.hh 1.7 Fri, 18 Jul 1997 15:53:23 -0700 wlee $
//
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

#ifndef NE_H
#define NE_H

#include "config.hh"
#include <iostream.h>
extern "C" {
#include <sys/types.h>
}
#include "NT.hh"
#include "NormalTermPtr.DLList.h"
#include "debug.hh"

#define NOT_ANY 0
#define ANY     1
#define NEITHER 2

class NormalExpression {
public:
   NormalExpression() : terms() { 
      singleton_flag = -1;
   }
   NormalExpression(NormalExpression& a);
   ~NormalExpression() {
      terms.clear();
   }

   friend ostream& operator<<(ostream& stream, NormalExpression& ne);

   void do_and(NormalExpression &other);
   void do_or(NormalExpression &other);
   void do_not();

   int universal() {
      return length() == 1 && terms(terms.first())->universal();
   }
   int empty () {
      return (length() == 0);
   }
   int any() {
      if (empty()) 
	 return NOT_ANY;
      if (universal())
	 return ANY;
      return NEITHER;
   }

   void become_universal () {
      NormalTerm* nt = new NormalTerm;
      nt->make_universal();
      terms.clear();
      terms.append(nt);

      singleton_flag = -1;
   }

   void become_not_any () {
      terms.clear();
      singleton_flag = -1;
   }

   void operator +=(NormalTerm* nt) {
      terms.append(nt);
   }

   CLASS_DEBUG_MEMORY_HH(NormalExpression);

   NormalTerm *first () {
      i = terms.first();
      return i ? terms(i) : (NormalTerm *)0;
   }

   NormalTerm *next () {
      terms.next(i);
      return i ? terms(i) : (NormalTerm *)0;
   }

   int length () {
      return terms.length();
   }

   void evaluate(int expand);

private:
   NormalTermPtrDLList terms;	// Normal Expression means
                                // Union for all term in terms
   
   Pix i;

   void reduce();

public:
   int singleton_flag;          // If the NE contains one NT
                                // and that one NT contains only one filter
                                // which is not universal,
                                // then this flag contins that filters index
                                // the value of this field is -1 otherwise
                                // the value of the flag is set by
                                // Node::Evalutate and do_and, do_or, do_not
};

#endif   // NE_H

