// $Id: trace.hh 1.4 Fri, 18 Jul 1997 15:53:23 -0700 wlee $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this sotrace and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.

#ifndef TRACE_H
#define TRACE_H

#include "config.hh"
#include <iostream.h>

#define TR_MAX                   (sizeof(long int) * 8 -1)

#define TR_ALL                   0
#define TR_WHOIS_QUERY           1
#define TR_WHOIS_RESPONSE        2
#define TR_INPUT                 3

#define Trace(level) if (trace.enabledp(level)) clog

class Tracer {
private:
   Tracer(Tracer& a) {} // private so no temporaries for Tracer
public:
   Tracer();
   void Tracer::enable(int level);
   void Tracer::disable(int level);
   int  Tracer::enabledp(int level);
   void Tracer::enable(char *tracename);
   void Tracer::disable(char *tracename);
   int  Tracer::enabledp(char *tracename);

private:
   long int enabled;
   static char *tracenames[TR_MAX];
   inline int index(char *tracename);
};

extern Tracer trace;

#endif /* TRACE_H */
