// $Id: whois.hh 1.3.1.1 Mon, 18 Aug 1997 17:11:28 -0700 wlee $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu <cengiz@isi.edu>

#include "config.hh"

#ifndef _WHOIS_H
#define _WHOIS_H

#include <cstdio>
#include <cstdarg>

#include "_SetOfPix.hh"
#include "Error.hh"

class AutNum;
class Route;
class Error;
class Map;

typedef Pix (*CharPtr2Pix)(char *);

class Whois { // Whois Client that talks to RAWhoisd
private:
   char  *current_sources;

protected:
   static char const *dflt_host;
   static char const *dflt_sources;
   static int    dflt_port;
   static int    ignore_errors;

   char  host[64];
   char  sources[256];
   int   port;

   int _is_open;
   FILE *in;
   FILE *out;

   char last_query[256];

public:
   Error error;

   Whois() {
      error.immediate(1);
      error.ignore(ignore_errors);
      _is_open = 0;
      current_sources = NULL;
   };
   ~Whois() {
      if (_is_open)
	 Close();
      if (current_sources) delete []current_sources;
   }

   int is_open() {
      return _is_open;
   }

   int in_fileno () { return fileno(in); } 
   int out_fileno() { return fileno(out); }

   static void SetDefaultHost(const char *_host) {
     // modified by wlee@isi.edu
      dflt_host = _host;
/*
      dflt_host = new char[strlen(_host)+1];
      strcpy(dflt_host, _host);
*/
   }
   static void SetDefaultSources(const char *_sources) {
     // modified by wlee@isi.edu
      dflt_sources = _sources;
/*
      dflt_sources = new char[strlen(_sources)+1];
      strcpy(dflt_sources, _sources);
*/
   }
   static void SetDefaultPort(const int _port) {
      dflt_port = _port;
   }
   // the following interface is used by ParseArgv
   static int ArgvHost    (char *dst, char *key, const char *_nextArg);
   static int ArgvSources (char *dst, char *key, const char *_nextArg);
   static int ArgvPort    (char *dst, char *key, const char *_nextArg);
   static int ReportErrors(char *dst, char *key, const char *_nextArg);
   static int IgnoreErrors(char *dst, char *key, const char *_nextArg);

   void Open(const char *_host = dflt_host, 
	     const int _port = dflt_port, 
	     const char *_sources = dflt_sources);

   void Close();

   void SetSources(const char *_sources = dflt_sources);

   char *GetSources(void);
   
   // PendingData() returns true if there is data available for reading
   int  PendingData(); 

   // Query using printf style arguments
   void Query(const char *format, ...);

   // Response allocates enough space to hold the result
   int  Response(char *&response);

   // do a Query and Response, returning the AXX and CXX lines
   // in addition to the the response.
   int TotalResponse (char *&response);

   // do a Query and Response
   int  QueryResponse(char *&response, const char *format, ...);

   // do a Query and Response but kill the reply
   int  QueryKillResponse(const char *format, ...);

private:
   void WriteQuery(const char *format, va_list ap);
};

class WhoisParser : public Whois {
public:
   int ParseAutNum(const char *query, AutNum &as);
   int ParseRoute(const char *query, Route &r);
   int ParseExpansion(const char *query, const char *key, _SetOfPix& result, const CharPtr2Pix f);

private:
   int ParseObject();
};

extern WhoisParser whois;

#endif // WHOIS_H
