// $Id: aut-num.hh 1.4 Fri, 18 Jul 1997 16:00:26 -0700 wlee $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu <cengiz@isi.edu>

#ifndef AUT_NUM_H
#define AUT_NUM_H

#include "config.hh"
#include "List.hh"
#include "NE.hh"
#include "Node.h"
#include "int.int.VHMap.h"

class Filter_Action {
private:
   NormalExpression *expansion;

public:
   FilterNode *filter;
   ActionNode *action;

   ListNode falist;

   Filter_Action() : falist(this) {
      expansion = NULL;
      filter = NULL;
      action = NULL;
   }
   ~Filter_Action() {
      if (expansion)
	 delete expansion;
      if (filter)
	 delete filter;
      if (action) 
	 delete action;
   }

   NormalExpression *expand() {
      if (! expansion)
	 expansion = filter->Evaluate(~0);
      return expansion;
   }
  // For debugging purpose!
  friend ostream &operator<<(ostream &os, Filter_Action *fa) {
     os << "Filter:\n" << fa->filter << endl;
     os << "Action:\n" << fa->action << endl;
  }
};

class InterASPolicy {
public:
   InterASPolicy() : interas(this) {}
   ~InterASPolicy() {
      in.clear();
      out.clear();
      ext_in.clear();
      ext_out.clear();
   }

   Pix laddress;
   Pix raddress;

   ListHead<Filter_Action> in;
   ListHead<Filter_Action> out;
   ListHead<Filter_Action> ext_in;
   ListHead<Filter_Action> ext_out;

   ListNode interas;
};

class ASPolicy {
private:
   void printFilterActionList(ostream &os, 
			      ListHead<Filter_Action> &lh, 
			      char *tag, char *str1, char *str2) {
      Filter_Action *fap;
      for (fap = lh.head(); fap; fap = lh.next(fap->falist)) 
	 os << tag 
	    << str1
	    << AS_map.key(peeras) 
	    << " " 
	    << fap->action 
	    << str2
	    << fap->filter 
	    << endl;
   }

public:
   Pix peeras;
   intintVHMap ipref_map;
   ListNode peers;

   ListHead<Filter_Action> in;
   ListHead<Filter_Action> out;
   ListHead<Filter_Action> ext_in;
   ListHead<Filter_Action> ext_out;
   ListHead<Filter_Action> dflt;

   ListHead<InterASPolicy> interas;

public:
   ASPolicy() : peers(this), ipref_map(0) {
      remaining_in  = NULL;
      remaining_out = NULL;
   }
   ~ASPolicy() {
      in.clear();
      out.clear();
      ext_in.clear();
      ext_out.clear();
      dflt.clear();
      interas.clear();
      // Added by wlee@isi.edu
      if (remaining_in) delete remaining_in;
      if (remaining_out) delete remaining_out;
   }

   void printASIn(ostream &os) {
      printFilterActionList(os, in, "as-in:        ", "from ", "accept "); 
   }
   void printASOut(ostream &os) {
      printFilterActionList(os, out, "as-out:       ", "to ", "announce "); 
   }
   void printDefault(ostream &os) {
      printFilterActionList(os, dflt, "default:      ", "", ""); 
   }

   InterASPolicy *find_peering(Pix local, Pix remote) {
      InterASPolicy *p;
      for (p = interas.head(); 
	   p && !(p->raddress == remote && p->laddress == local); 
	   p = interas.next(p->interas))
	 ;
      return p;
   }


private:
   NormalExpression *remaining_in;
   NormalExpression *remaining_out;

public:
   NormalExpression *get_remaining_in() {
      InterASPolicy *ip;
      Filter_Action *p;
      
      if (!remaining_in) {
	 remaining_in = new NormalExpression;
	 for (ip = interas.head(); ip; ip = interas.next(ip->interas))
	   for (p = ip->in.head(); p; p = ip->in.next(p->falist)) {
 	       // Modified by wlee@isi.edu
	       NormalExpression *ne = new NormalExpression(*p->expand());
	       remaining_in->do_or(*ne);
	       delete ne;
	   }
	 remaining_in->do_not();
      }
      return remaining_in;
   }

   NormalExpression *get_remaining_out() {
      InterASPolicy *ip;
      Filter_Action *p;
      
      if (!remaining_out) {
	 remaining_out = new NormalExpression;
	 for (ip = interas.head(); ip; ip = interas.next(ip->interas))
	   for (p = ip->out.head(); p; p = ip->out.next(p->falist)) {
  	       // Modified by wlee@isi.edu
	       NormalExpression *ne = new NormalExpression(*p->expand());
	       remaining_out->do_or(*ne);
	       delete ne;
	   }
	 remaining_out->do_not();
      }
      return remaining_out;
   }
};

class NonPolicyLines
{
   public:
      char *line;
      ListNode node;

   public:
      NonPolicyLines(char *line) : node(this), line(line) {}
      ~NonPolicyLines(void) { 
	 if (line) { free(line); }
      }
};

class AutNum {
private:
   AutNum(const AutNum &b) : pref_map(0), mark(-1) {}

public:
   Pix asno;

   int mark; // -1 is unmarked, anything else is marked

   ListHead<NonPolicyLines> prolog;
   ListHead<ASPolicy> peers;
   ListHead<NonPolicyLines> epilog;

   intintVHMap pref_map;

public:
   AutNum() : pref_map(0), mark(-1) {}
   ~AutNum() {
      prolog.clear();
      peers.clear();
      epilog.clear();
   }

   // Print to stdout
   void print();

   // Print to a stream
   void printPolicyLine(ostream &os);
      void printASIn(ostream &os);
      void printASOut(ostream &os);
      void printInterASIn(ostream &os);
      void printInterASOut(ostream &os);
      void printDefault(ostream &os);
   void printProlog(ostream &os) { print(os, prolog); }
   void printEpilog(ostream &os) { print(os, epilog); }
      void print(ostream &os, ListHead<NonPolicyLines> &lh);
   friend ostream &operator<<(ostream &os, AutNum &an) {
      an.printProlog(os);
      an.printPolicyLine(os);
      an.printEpilog(os);
      return os; 
   }
   friend ostream &operator<<(ostream &os, AutNum *an) {
      return os << *an;
   }

   ASPolicy *find_peer(Pix peer) {
      ASPolicy *p;
      for (p = peers.head(); p && p->peeras != peer; p = peers.next(p->peers))
	 ;
      return p;
   }
   int remove_peer(Pix peer) {
      ASPolicy *p = find_peer(peer);
      if (!p) return 0;
      p->peers.un_link();
      delete p;
      return 1;
   }
};

#endif   // AUT_NUM_H
