// $Id: ASMacroMap.h 1.7 Fri, 18 Jul 1997 15:53:23 -0700 wlee $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

#ifndef _STNAMEASMACROMAP_H
#define _STNAMEASMACROMAP_H

#include "config.hh"
#include "Map.hh"
#include "Allocator.hh"
#include "whois.hh"

extern Allocator STAllocator;

class ASMacroMap : public Map {
  public:
   ASMacroMap(SymTab& dflt) : Map(dflt) {}

   Pix add_entry(char *macro) {
      Pix r, s;

      if (r = seek(macro))
	 return r;

      char *dup_macro = (char *) STAllocator.allocate(strlen(macro)+1);
      strcpy(dup_macro, macro);
      (void) (*this)[dup_macro];
      r = seek(dup_macro);

      dup_macro = (char *) STAllocator.allocate(strlen(macro)+5);
      strcpy(dup_macro, "NOT ");
      strcpy(dup_macro + 4, macro);

      (void) (*this)[dup_macro];
      s = seek(dup_macro);

      contents(r).not = s;
      contents(s).not = r;
      contents(s).evaluated = 2;

      return r;
   }

   void dump();
   _SetOfPix& expand(Pix p, WhoisParser &db = whois);
};

extern ASMacroMap ASMacro_map;
extern void ASMacro2AS( _SetOfPix&, _SetOfPix& );
extern void ASMacro2AS(Pix r, _SetOfPix &ASset );

#endif
