/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_CONNECTION = 265,
     SQL_CONTINUE = 266,
     SQL_COUNT = 267,
     SQL_CURRENT = 268,
     SQL_DATA = 269,
     SQL_DATETIME_INTERVAL_CODE = 270,
     SQL_DATETIME_INTERVAL_PRECISION = 271,
     SQL_DESCRIBE = 272,
     SQL_DESCRIPTOR = 273,
     SQL_DISCONNECT = 274,
     SQL_ENUM = 275,
     SQL_FOUND = 276,
     SQL_FREE = 277,
     SQL_GO = 278,
     SQL_GOTO = 279,
     SQL_IDENTIFIED = 280,
     SQL_INDICATOR = 281,
     SQL_KEY_MEMBER = 282,
     SQL_LENGTH = 283,
     SQL_LONG = 284,
     SQL_NAME = 285,
     SQL_NULLABLE = 286,
     SQL_OCTET_LENGTH = 287,
     SQL_OPEN = 288,
     SQL_OUTPUT = 289,
     SQL_RELEASE = 290,
     SQL_REFERENCE = 291,
     SQL_RETURNED_LENGTH = 292,
     SQL_RETURNED_OCTET_LENGTH = 293,
     SQL_SCALE = 294,
     SQL_SECTION = 295,
     SQL_SHORT = 296,
     SQL_SIGNED = 297,
     SQL_SQL = 298,
     SQL_SQLERROR = 299,
     SQL_SQLPRINT = 300,
     SQL_SQLWARNING = 301,
     SQL_START = 302,
     SQL_STOP = 303,
     SQL_STRUCT = 304,
     SQL_UNSIGNED = 305,
     SQL_VALUE = 306,
     SQL_VAR = 307,
     SQL_WHENEVER = 308,
     S_ADD = 309,
     S_AND = 310,
     S_ANYTHING = 311,
     S_AUTO = 312,
     S_CONST = 313,
     S_DEC = 314,
     S_DIV = 315,
     S_DOTPOINT = 316,
     S_EQUAL = 317,
     S_EXTERN = 318,
     S_INC = 319,
     S_LSHIFT = 320,
     S_MEMPOINT = 321,
     S_MEMBER = 322,
     S_MOD = 323,
     S_MUL = 324,
     S_NEQUAL = 325,
     S_OR = 326,
     S_REGISTER = 327,
     S_RSHIFT = 328,
     S_STATIC = 329,
     S_SUB = 330,
     S_VOLATILE = 331,
     S_TYPEDEF = 332,
     TYPECAST = 333,
     ABORT_P = 334,
     ABSOLUTE_P = 335,
     ACCESS = 336,
     ACTION = 337,
     ADD = 338,
     AFTER = 339,
     AGGREGATE = 340,
     ALL = 341,
     ALTER = 342,
     ANALYSE = 343,
     ANALYZE = 344,
     AND = 345,
     ANY = 346,
     ARRAY = 347,
     AS = 348,
     ASC = 349,
     ASSERTION = 350,
     ASSIGNMENT = 351,
     AT = 352,
     AUTHORIZATION = 353,
     BACKWARD = 354,
     BEFORE = 355,
     BEGIN_P = 356,
     BETWEEN = 357,
     BIGINT = 358,
     BINARY = 359,
     BIT = 360,
     BOOLEAN_P = 361,
     BOTH = 362,
     BY = 363,
     CACHE = 364,
     CALLED = 365,
     CASCADE = 366,
     CASE = 367,
     CAST = 368,
     CHAIN = 369,
     CHAR_P = 370,
     CHARACTER = 371,
     CHARACTERISTICS = 372,
     CHECK = 373,
     CHECKPOINT = 374,
     CLASS = 375,
     CLOSE = 376,
     CLUSTER = 377,
     COALESCE = 378,
     COLLATE = 379,
     COLUMN = 380,
     COMMENT = 381,
     COMMIT = 382,
     COMMITTED = 383,
     CONSTRAINT = 384,
     CONSTRAINTS = 385,
     CONVERSION_P = 386,
     CONVERT = 387,
     COPY = 388,
     CREATE = 389,
     CREATEDB = 390,
     CREATEUSER = 391,
     CROSS = 392,
     CURRENT_DATE = 393,
     CURRENT_TIME = 394,
     CURRENT_TIMESTAMP = 395,
     CURRENT_USER = 396,
     CURSOR = 397,
     CYCLE = 398,
     DATABASE = 399,
     DAY_P = 400,
     DEALLOCATE = 401,
     DEC = 402,
     DECIMAL_P = 403,
     DECLARE = 404,
     DEFAULT = 405,
     DEFAULTS = 406,
     DEFERRABLE = 407,
     DEFERRED = 408,
     DEFINER = 409,
     DELETE_P = 410,
     DELIMITER = 411,
     DELIMITERS = 412,
     DESC = 413,
     DISTINCT = 414,
     DO = 415,
     DOMAIN_P = 416,
     DOUBLE_P = 417,
     DROP = 418,
     EACH = 419,
     ELSE = 420,
     ENCODING = 421,
     ENCRYPTED = 422,
     END_P = 423,
     ESCAPE = 424,
     EXCEPT = 425,
     EXCLUSIVE = 426,
     EXCLUDING = 427,
     EXECUTE = 428,
     EXISTS = 429,
     EXPLAIN = 430,
     EXTERNAL = 431,
     EXTRACT = 432,
     FALSE_P = 433,
     FETCH = 434,
     FIRST_P = 435,
     FLOAT_P = 436,
     FOR = 437,
     FORCE = 438,
     FOREIGN = 439,
     FORWARD = 440,
     FREEZE = 441,
     FROM = 442,
     FULL = 443,
     FUNCTION = 444,
     GET = 445,
     GLOBAL = 446,
     GRANT = 447,
     GROUP_P = 448,
     HANDLER = 449,
     HAVING = 450,
     HOLD = 451,
     HOUR_P = 452,
     ILIKE = 453,
     IMMEDIATE = 454,
     IMMUTABLE = 455,
     IMPLICIT_P = 456,
     IN_P = 457,
     INCLUDING = 458,
     INCREMENT = 459,
     INDEX = 460,
     INHERITS = 461,
     INITIALLY = 462,
     INNER_P = 463,
     INOUT = 464,
     INPUT_P = 465,
     INSENSITIVE = 466,
     INSERT = 467,
     INSTEAD = 468,
     INT_P = 469,
     INTEGER = 470,
     INTERSECT = 471,
     INTERVAL = 472,
     INTO = 473,
     INVOKER = 474,
     IS = 475,
     ISNULL = 476,
     ISOLATION = 477,
     JOIN = 478,
     KEY = 479,
     LANCOMPILER = 480,
     LANGUAGE = 481,
     LAST_P = 482,
     LEADING = 483,
     LEFT = 484,
     LEVEL = 485,
     LIKE = 486,
     LIMIT = 487,
     LISTEN = 488,
     LOAD = 489,
     LOCAL = 490,
     LOCATION = 491,
     LOCK_P = 492,
     MATCH = 493,
     MAXVALUE = 494,
     MINUTE_P = 495,
     MINVALUE = 496,
     MODE = 497,
     MONTH_P = 498,
     MOVE = 499,
     NAMES = 500,
     NATIONAL = 501,
     NATURAL = 502,
     NCHAR = 503,
     NEW = 504,
     NEXT = 505,
     NO = 506,
     NOCREATEDB = 507,
     NOCREATEUSER = 508,
     NONE = 509,
     NOT = 510,
     NOTHING = 511,
     NOTIFY = 512,
     NOTNULL = 513,
     NULL_P = 514,
     NULLIF = 515,
     NUMERIC = 516,
     OF = 517,
     OFF = 518,
     OFFSET = 519,
     OIDS = 520,
     OLD = 521,
     ON = 522,
     ONLY = 523,
     OPERATOR = 524,
     OPTION = 525,
     OR = 526,
     ORDER = 527,
     OUT_P = 528,
     OUTER_P = 529,
     OVERLAPS = 530,
     OVERLAY = 531,
     OWNER = 532,
     PARTIAL = 533,
     PASSWORD = 534,
     PATH_P = 535,
     PENDANT = 536,
     PLACING = 537,
     POSITION = 538,
     PRECISION = 539,
     PRESERVE = 540,
     PREPARE = 541,
     PRIMARY = 542,
     PRIOR = 543,
     PRIVILEGES = 544,
     PROCEDURAL = 545,
     PROCEDURE = 546,
     READ = 547,
     REAL = 548,
     RECHECK = 549,
     REFERENCES = 550,
     REINDEX = 551,
     RELATIVE_P = 552,
     RENAME = 553,
     REPLACE = 554,
     RESET = 555,
     RESTART = 556,
     RESTRICT = 557,
     RETURNS = 558,
     REVOKE = 559,
     RIGHT = 560,
     ROLLBACK = 561,
     ROW = 562,
     ROWS = 563,
     RULE = 564,
     SCHEMA = 565,
     SCROLL = 566,
     SECOND_P = 567,
     SECURITY = 568,
     SELECT = 569,
     SEQUENCE = 570,
     SERIALIZABLE = 571,
     SESSION = 572,
     SESSION_USER = 573,
     SET = 574,
     SETOF = 575,
     SHARE = 576,
     SHOW = 577,
     SIMILAR = 578,
     SIMPLE = 579,
     SMALLINT = 580,
     SOME = 581,
     STABLE = 582,
     START = 583,
     STATEMENT = 584,
     STATISTICS = 585,
     STDIN = 586,
     STDOUT = 587,
     STORAGE = 588,
     STRICT_P = 589,
     SUBSTRING = 590,
     SYSID = 591,
     TABLE = 592,
     TEMP = 593,
     TEMPLATE = 594,
     TEMPORARY = 595,
     THEN = 596,
     TIME = 597,
     TIMESTAMP = 598,
     TO = 599,
     TOAST = 600,
     TRAILING = 601,
     TRANSACTION = 602,
     TREAT = 603,
     TRIGGER = 604,
     TRIM = 605,
     TRUE_P = 606,
     TRUNCATE = 607,
     TRUSTED = 608,
     TYPE_P = 609,
     UNENCRYPTED = 610,
     UNION = 611,
     UNIQUE = 612,
     UNKNOWN = 613,
     UNLISTEN = 614,
     UNTIL = 615,
     UPDATE = 616,
     USAGE = 617,
     USER = 618,
     USING = 619,
     VACUUM = 620,
     VALID = 621,
     VALUES = 622,
     VARCHAR = 623,
     VARYING = 624,
     VERBOSE = 625,
     VERSION = 626,
     VIEW = 627,
     VOLATILE = 628,
     WHEN = 629,
     WHERE = 630,
     WITH = 631,
     WITHOUT = 632,
     WORK = 633,
     WRITE = 634,
     YEAR_P = 635,
     ZONE = 636,
     UNIONJOIN = 637,
     IDENT = 638,
     SCONST = 639,
     Op = 640,
     CSTRING = 641,
     CVARIABLE = 642,
     CPP_LINE = 643,
     IP = 644,
     BCONST = 645,
     XCONST = 646,
     ICONST = 647,
     PARAM = 648,
     FCONST = 649,
     POSTFIXOP = 650,
     UMINUS = 651
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_CONNECTION 265
#define SQL_CONTINUE 266
#define SQL_COUNT 267
#define SQL_CURRENT 268
#define SQL_DATA 269
#define SQL_DATETIME_INTERVAL_CODE 270
#define SQL_DATETIME_INTERVAL_PRECISION 271
#define SQL_DESCRIBE 272
#define SQL_DESCRIPTOR 273
#define SQL_DISCONNECT 274
#define SQL_ENUM 275
#define SQL_FOUND 276
#define SQL_FREE 277
#define SQL_GO 278
#define SQL_GOTO 279
#define SQL_IDENTIFIED 280
#define SQL_INDICATOR 281
#define SQL_KEY_MEMBER 282
#define SQL_LENGTH 283
#define SQL_LONG 284
#define SQL_NAME 285
#define SQL_NULLABLE 286
#define SQL_OCTET_LENGTH 287
#define SQL_OPEN 288
#define SQL_OUTPUT 289
#define SQL_RELEASE 290
#define SQL_REFERENCE 291
#define SQL_RETURNED_LENGTH 292
#define SQL_RETURNED_OCTET_LENGTH 293
#define SQL_SCALE 294
#define SQL_SECTION 295
#define SQL_SHORT 296
#define SQL_SIGNED 297
#define SQL_SQL 298
#define SQL_SQLERROR 299
#define SQL_SQLPRINT 300
#define SQL_SQLWARNING 301
#define SQL_START 302
#define SQL_STOP 303
#define SQL_STRUCT 304
#define SQL_UNSIGNED 305
#define SQL_VALUE 306
#define SQL_VAR 307
#define SQL_WHENEVER 308
#define S_ADD 309
#define S_AND 310
#define S_ANYTHING 311
#define S_AUTO 312
#define S_CONST 313
#define S_DEC 314
#define S_DIV 315
#define S_DOTPOINT 316
#define S_EQUAL 317
#define S_EXTERN 318
#define S_INC 319
#define S_LSHIFT 320
#define S_MEMPOINT 321
#define S_MEMBER 322
#define S_MOD 323
#define S_MUL 324
#define S_NEQUAL 325
#define S_OR 326
#define S_REGISTER 327
#define S_RSHIFT 328
#define S_STATIC 329
#define S_SUB 330
#define S_VOLATILE 331
#define S_TYPEDEF 332
#define TYPECAST 333
#define ABORT_P 334
#define ABSOLUTE_P 335
#define ACCESS 336
#define ACTION 337
#define ADD 338
#define AFTER 339
#define AGGREGATE 340
#define ALL 341
#define ALTER 342
#define ANALYSE 343
#define ANALYZE 344
#define AND 345
#define ANY 346
#define ARRAY 347
#define AS 348
#define ASC 349
#define ASSERTION 350
#define ASSIGNMENT 351
#define AT 352
#define AUTHORIZATION 353
#define BACKWARD 354
#define BEFORE 355
#define BEGIN_P 356
#define BETWEEN 357
#define BIGINT 358
#define BINARY 359
#define BIT 360
#define BOOLEAN_P 361
#define BOTH 362
#define BY 363
#define CACHE 364
#define CALLED 365
#define CASCADE 366
#define CASE 367
#define CAST 368
#define CHAIN 369
#define CHAR_P 370
#define CHARACTER 371
#define CHARACTERISTICS 372
#define CHECK 373
#define CHECKPOINT 374
#define CLASS 375
#define CLOSE 376
#define CLUSTER 377
#define COALESCE 378
#define COLLATE 379
#define COLUMN 380
#define COMMENT 381
#define COMMIT 382
#define COMMITTED 383
#define CONSTRAINT 384
#define CONSTRAINTS 385
#define CONVERSION_P 386
#define CONVERT 387
#define COPY 388
#define CREATE 389
#define CREATEDB 390
#define CREATEUSER 391
#define CROSS 392
#define CURRENT_DATE 393
#define CURRENT_TIME 394
#define CURRENT_TIMESTAMP 395
#define CURRENT_USER 396
#define CURSOR 397
#define CYCLE 398
#define DATABASE 399
#define DAY_P 400
#define DEALLOCATE 401
#define DEC 402
#define DECIMAL_P 403
#define DECLARE 404
#define DEFAULT 405
#define DEFAULTS 406
#define DEFERRABLE 407
#define DEFERRED 408
#define DEFINER 409
#define DELETE_P 410
#define DELIMITER 411
#define DELIMITERS 412
#define DESC 413
#define DISTINCT 414
#define DO 415
#define DOMAIN_P 416
#define DOUBLE_P 417
#define DROP 418
#define EACH 419
#define ELSE 420
#define ENCODING 421
#define ENCRYPTED 422
#define END_P 423
#define ESCAPE 424
#define EXCEPT 425
#define EXCLUSIVE 426
#define EXCLUDING 427
#define EXECUTE 428
#define EXISTS 429
#define EXPLAIN 430
#define EXTERNAL 431
#define EXTRACT 432
#define FALSE_P 433
#define FETCH 434
#define FIRST_P 435
#define FLOAT_P 436
#define FOR 437
#define FORCE 438
#define FOREIGN 439
#define FORWARD 440
#define FREEZE 441
#define FROM 442
#define FULL 443
#define FUNCTION 444
#define GET 445
#define GLOBAL 446
#define GRANT 447
#define GROUP_P 448
#define HANDLER 449
#define HAVING 450
#define HOLD 451
#define HOUR_P 452
#define ILIKE 453
#define IMMEDIATE 454
#define IMMUTABLE 455
#define IMPLICIT_P 456
#define IN_P 457
#define INCLUDING 458
#define INCREMENT 459
#define INDEX 460
#define INHERITS 461
#define INITIALLY 462
#define INNER_P 463
#define INOUT 464
#define INPUT_P 465
#define INSENSITIVE 466
#define INSERT 467
#define INSTEAD 468
#define INT_P 469
#define INTEGER 470
#define INTERSECT 471
#define INTERVAL 472
#define INTO 473
#define INVOKER 474
#define IS 475
#define ISNULL 476
#define ISOLATION 477
#define JOIN 478
#define KEY 479
#define LANCOMPILER 480
#define LANGUAGE 481
#define LAST_P 482
#define LEADING 483
#define LEFT 484
#define LEVEL 485
#define LIKE 486
#define LIMIT 487
#define LISTEN 488
#define LOAD 489
#define LOCAL 490
#define LOCATION 491
#define LOCK_P 492
#define MATCH 493
#define MAXVALUE 494
#define MINUTE_P 495
#define MINVALUE 496
#define MODE 497
#define MONTH_P 498
#define MOVE 499
#define NAMES 500
#define NATIONAL 501
#define NATURAL 502
#define NCHAR 503
#define NEW 504
#define NEXT 505
#define NO 506
#define NOCREATEDB 507
#define NOCREATEUSER 508
#define NONE 509
#define NOT 510
#define NOTHING 511
#define NOTIFY 512
#define NOTNULL 513
#define NULL_P 514
#define NULLIF 515
#define NUMERIC 516
#define OF 517
#define OFF 518
#define OFFSET 519
#define OIDS 520
#define OLD 521
#define ON 522
#define ONLY 523
#define OPERATOR 524
#define OPTION 525
#define OR 526
#define ORDER 527
#define OUT_P 528
#define OUTER_P 529
#define OVERLAPS 530
#define OVERLAY 531
#define OWNER 532
#define PARTIAL 533
#define PASSWORD 534
#define PATH_P 535
#define PENDANT 536
#define PLACING 537
#define POSITION 538
#define PRECISION 539
#define PRESERVE 540
#define PREPARE 541
#define PRIMARY 542
#define PRIOR 543
#define PRIVILEGES 544
#define PROCEDURAL 545
#define PROCEDURE 546
#define READ 547
#define REAL 548
#define RECHECK 549
#define REFERENCES 550
#define REINDEX 551
#define RELATIVE_P 552
#define RENAME 553
#define REPLACE 554
#define RESET 555
#define RESTART 556
#define RESTRICT 557
#define RETURNS 558
#define REVOKE 559
#define RIGHT 560
#define ROLLBACK 561
#define ROW 562
#define ROWS 563
#define RULE 564
#define SCHEMA 565
#define SCROLL 566
#define SECOND_P 567
#define SECURITY 568
#define SELECT 569
#define SEQUENCE 570
#define SERIALIZABLE 571
#define SESSION 572
#define SESSION_USER 573
#define SET 574
#define SETOF 575
#define SHARE 576
#define SHOW 577
#define SIMILAR 578
#define SIMPLE 579
#define SMALLINT 580
#define SOME 581
#define STABLE 582
#define START 583
#define STATEMENT 584
#define STATISTICS 585
#define STDIN 586
#define STDOUT 587
#define STORAGE 588
#define STRICT_P 589
#define SUBSTRING 590
#define SYSID 591
#define TABLE 592
#define TEMP 593
#define TEMPLATE 594
#define TEMPORARY 595
#define THEN 596
#define TIME 597
#define TIMESTAMP 598
#define TO 599
#define TOAST 600
#define TRAILING 601
#define TRANSACTION 602
#define TREAT 603
#define TRIGGER 604
#define TRIM 605
#define TRUE_P 606
#define TRUNCATE 607
#define TRUSTED 608
#define TYPE_P 609
#define UNENCRYPTED 610
#define UNION 611
#define UNIQUE 612
#define UNKNOWN 613
#define UNLISTEN 614
#define UNTIL 615
#define UPDATE 616
#define USAGE 617
#define USER 618
#define USING 619
#define VACUUM 620
#define VALID 621
#define VALUES 622
#define VARCHAR 623
#define VARYING 624
#define VERBOSE 625
#define VERSION 626
#define VIEW 627
#define VOLATILE 628
#define WHEN 629
#define WHERE 630
#define WITH 631
#define WITHOUT 632
#define WORK 633
#define WRITE 634
#define YEAR_P 635
#define ZONE 636
#define UNIONJOIN 637
#define IDENT 638
#define SCONST 639
#define Op 640
#define CSTRING 641
#define CVARIABLE 642
#define CPP_LINE 643
#define IP 644
#define BCONST 645
#define XCONST 646
#define ICONST 647
#define PARAM 648
#define FCONST 649
#define POSTFIXOP 650
#define UMINUS 651




/* Copy the first part of user declarations.  */
#line 4 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
int ecpg_informix_var = 0;
char	errortext[128];
char	*connection = NULL;
char	*input_filename = NULL;

static int	QueryIsRule = 0, FoundInto = 0;
static int	initializer = 0;
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, 0L, NULL, {NULL}};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, 0L, NULL, {NULL}};

static struct inf_compat_col
{
	char *name;
	char *indirection;
	struct inf_compat_col *next;
} *informix_col;

static struct inf_compat_val
{
	char *val;
	struct inf_compat_val *next;
} *informix_val;

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, char * error)
{
	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, "%s:%d: WARNING: %s\n", input_filename, yylineno, error);
			break;
		case ET_ERROR:
			fprintf(stderr, "%s:%d: ERROR: %s\n", input_filename, yylineno, error);
			ret_value = error_code;
			break;
		case ET_FATAL:
			fprintf(stderr, "%s:%d: ERROR: %s\n", input_filename, yylineno, error);
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	char * name = (char *)mm_alloc(yyleng + 1);

	strncpy(name, yytext, yyleng);
	name[yyleng] = '\0';
	return(name);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct 
	 * An array is only allowed together with an element argument 
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else 
	 * so we don't have to worry here. */
	
	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
		result = cat2_str(result, make_str("? , "));

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_informix(struct arguments *list)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
	 * This breaks standard and leads to some very dangerous programming. 
	 * Since they do, we have to work around and accept their syntax as well.
	 * But we will do so ONLY in Informix mode.
	 * We have to change the variables to our own struct and just store the pointer instead of the variable */

	 struct arguments *ptr;
	 char *result = make_str("");

	 for (ptr = list; ptr != NULL; ptr = ptr->next)
	 {
	 	char temp[20]; /* this should be sufficient unless you have 8 byte integers */
		char *original_var;
		
	 	/* change variable name to "ECPG_informix_get_var(<counter>)" */
		original_var = ptr->variable->name;
		sprintf(temp, "%d))", ecpg_informix_var);
		
		if ((ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->variable->type->u.element->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, make_str("1")), ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else
		{
			ptr->variable = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size), 0);
			sprintf(temp, "%d, &(", ecpg_informix_var++);
		}
		
		/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
		result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		
		/* now the indicator if there is one */
		if (ptr->indicator->type->type != ECPGt_NO_INDICATOR)
		{
			/* change variable name to "ECPG_informix_get_var(<counter>)" */
			original_var = ptr->indicator->name;
			sprintf(temp, "%d))", ecpg_informix_var);
			
			/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
			if (atoi(ptr->indicator->type->size) > 1)
			{
				ptr->indicator = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, (", ecpg_informix_var++);
			}
			else
			{
				ptr->indicator = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, &(", ecpg_informix_var++);
			}
			result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		}
	 }

	 return result;
}

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		snprintf(errortext, sizeof(errortext), "trying to access an undeclared cursor %s\n", name);
		mmerror(PARSE_ERROR, ET_ERROR, errortext);
		return NULL;
	}
	if (insert)
	{
		/* add all those input variables that were given earlier 
		 * note that we have to append here but have to keep the existing order */
		for (p = ptr->argsinsert; p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = ptr->argsresult; p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);
	
	return ptr;
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 284 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 1161 "y.tab.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1173 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   50227

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  417
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  493
/* YYNRULES -- Number of rules. */
#define YYNRULES  1858
/* YYNRULES -- Number of states. */
#define YYNSTATES  3031

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   652

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   403,     2,     2,
     408,   409,   401,   399,   414,   400,   410,   402,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   416,   411,
     396,   395,   397,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   406,     2,   407,   404,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   412,     2,   413,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     398,   405,   415
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     6,     9,    14,    18,    21,    23,
      25,    27,    29,    31,    34,    36,    38,    40,    42,    44,
      46,    48,    50,    52,    54,    56,    58,    60,    62,    64,
      66,    68,    70,    72,    74,    76,    78,    80,    82,    84,
      86,    88,    90,    92,    94,    96,    98,   100,   102,   104,
     106,   108,   110,   112,   114,   116,   118,   120,   122,   124,
     126,   128,   130,   132,   134,   136,   138,   140,   142,   144,
     146,   148,   150,   152,   154,   156,   158,   160,   162,   164,
     166,   168,   170,   172,   174,   176,   178,   180,   182,   184,
     186,   188,   190,   192,   194,   196,   198,   200,   202,   204,
     206,   208,   210,   216,   218,   219,   224,   230,   236,   241,
     245,   248,   249,   252,   255,   257,   259,   261,   263,   267,
     271,   275,   277,   282,   288,   291,   292,   295,   298,   305,
     312,   316,   324,   329,   331,   332,   335,   336,   338,   340,
     342,   345,   349,   353,   357,   361,   365,   368,   374,   377,
     381,   385,   387,   389,   391,   395,   398,   400,   402,   404,
     406,   408,   410,   412,   414,   416,   418,   422,   429,   431,
     433,   435,   437,   438,   440,   442,   445,   449,   454,   458,
     461,   464,   468,   473,   477,   480,   485,   487,   489,   491,
     493,   495,   502,   510,   520,   530,   540,   550,   558,   564,
     572,   579,   586,   593,   600,   604,   607,   609,   611,   612,
     615,   625,   627,   629,   631,   633,   635,   638,   639,   641,
     643,   647,   651,   653,   654,   657,   658,   662,   663,   665,
     666,   677,   689,   691,   693,   696,   699,   702,   705,   706,
     708,   709,   711,   715,   717,   719,   721,   725,   728,   729,
     733,   735,   737,   740,   742,   744,   747,   752,   755,   761,
     763,   766,   769,   772,   776,   779,   782,   783,   787,   789,
     794,   799,   805,   817,   821,   822,   826,   828,   830,   833,
     836,   837,   839,   841,   844,   847,   848,   852,   856,   859,
     861,   863,   866,   869,   874,   875,   878,   881,   882,   886,
     891,   896,   897,   898,   907,   911,   912,   916,   918,   920,
     926,   931,   934,   935,   938,   940,   943,   947,   950,   953,
     956,   959,   963,   967,   969,   970,   979,   981,   982,   984,
     986,   989,   990,   996,   998,   999,  1014,  1034,  1036,  1038,
    1040,  1044,  1050,  1052,  1054,  1056,  1060,  1061,  1063,  1064,
    1066,  1068,  1070,  1074,  1075,  1077,  1079,  1080,  1083,  1085,
    1088,  1090,  1093,  1096,  1098,  1101,  1104,  1111,  1120,  1124,
    1129,  1134,  1139,  1145,  1149,  1153,  1155,  1159,  1163,  1165,
    1167,  1169,  1171,  1184,  1186,  1190,  1195,  1203,  1208,  1211,
    1213,  1214,  1216,  1217,  1225,  1230,  1232,  1234,  1236,  1238,
    1240,  1242,  1244,  1246,  1248,  1252,  1254,  1256,  1260,  1266,
    1271,  1276,  1280,  1285,  1289,  1293,  1296,  1301,  1304,  1306,
    1308,  1310,  1312,  1315,  1318,  1320,  1322,  1324,  1327,  1330,
    1332,  1335,  1338,  1340,  1342,  1344,  1351,  1361,  1369,  1379,
    1388,  1397,  1404,  1406,  1408,  1410,  1412,  1414,  1416,  1418,
    1420,  1422,  1424,  1426,  1434,  1443,  1446,  1448,  1450,  1452,
    1456,  1458,  1460,  1462,  1464,  1466,  1468,  1470,  1472,  1474,
    1476,  1478,  1480,  1482,  1485,  1488,  1491,  1494,  1497,  1499,
    1503,  1505,  1508,  1512,  1513,  1517,  1518,  1520,  1524,  1527,
    1539,  1541,  1542,  1545,  1546,  1548,  1552,  1555,  1561,  1566,
    1568,  1571,  1572,  1582,  1585,  1586,  1590,  1593,  1595,  1599,
    1602,  1604,  1606,  1608,  1610,  1612,  1616,  1618,  1620,  1625,
    1627,  1630,  1633,  1636,  1638,  1640,  1642,  1647,  1653,  1655,
    1659,  1663,  1666,  1669,  1672,  1673,  1679,  1687,  1689,  1691,
    1699,  1701,  1705,  1709,  1713,  1715,  1719,  1731,  1742,  1745,
    1746,  1755,  1760,  1765,  1767,  1769,  1771,  1772,  1782,  1789,
    1796,  1804,  1811,  1818,  1828,  1835,  1844,  1853,  1860,  1862,
    1863,  1865,  1866,  1867,  1882,  1884,  1886,  1890,  1894,  1896,
    1898,  1900,  1902,  1904,  1906,  1908,  1909,  1911,  1913,  1915,
    1917,  1919,  1920,  1927,  1930,  1933,  1936,  1939,  1942,  1945,
    1949,  1952,  1955,  1958,  1960,  1962,  1963,  1967,  1969,  1974,
    1979,  1981,  1982,  1985,  1988,  1996,  1999,  2005,  2009,  2011,
    2014,  2018,  2022,  2026,  2030,  2034,  2038,  2042,  2046,  2048,
    2049,  2055,  2060,  2064,  2071,  2076,  2083,  2090,  2096,  2104,
    2111,  2113,  2114,  2125,  2130,  2133,  2135,  2140,  2146,  2152,
    2155,  2160,  2162,  2164,  2166,  2167,  2169,  2170,  2172,  2173,
    2177,  2178,  2183,  2185,  2187,  2189,  2191,  2193,  2195,  2196,
    2201,  2206,  2209,  2211,  2219,  2224,  2228,  2230,  2233,  2238,
    2243,  2247,  2248,  2251,  2254,  2257,  2261,  2263,  2267,  2269,
    2272,  2279,  2287,  2288,  2291,  2294,  2297,  2301,  2302,  2305,
    2308,  2310,  2312,  2316,  2320,  2322,  2325,  2330,  2335,  2337,
    2339,  2348,  2353,  2358,  2363,  2366,  2368,  2369,  2373,  2377,
    2382,  2387,  2392,  2397,  2400,  2402,  2404,  2405,  2407,  2408,
    2410,  2416,  2418,  2419,  2421,  2422,  2426,  2428,  2432,  2436,
    2439,  2442,  2444,  2449,  2454,  2457,  2460,  2465,  2467,  2468,
    2470,  2472,  2474,  2478,  2479,  2482,  2483,  2487,  2491,  2493,
    2494,  2497,  2498,  2501,  2502,  2506,  2508,  2510,  2513,  2515,
    2518,  2524,  2531,  2537,  2539,  2542,  2544,  2549,  2553,  2558,
    2562,  2568,  2573,  2579,  2584,  2590,  2593,  2598,  2600,  2603,
    2606,  2609,  2611,  2613,  2614,  2619,  2622,  2624,  2627,  2630,
    2635,  2639,  2644,  2647,  2648,  2650,  2654,  2657,  2660,  2664,
    2670,  2677,  2681,  2686,  2687,  2689,  2693,  2697,  2701,  2705,
    2709,  2713,  2715,  2717,  2719,  2721,  2723,  2725,  2727,  2730,
    2736,  2739,  2741,  2743,  2745,  2747,  2749,  2751,  2753,  2755,
    2757,  2759,  2761,  2764,  2767,  2770,  2773,  2776,  2778,  2782,
    2783,  2789,  2793,  2794,  2800,  2804,  2805,  2807,  2809,  2811,
    2813,  2819,  2822,  2824,  2826,  2828,  2830,  2836,  2839,  2842,
    2845,  2847,  2851,  2855,  2858,  2860,  2861,  2865,  2866,  2872,
    2875,  2881,  2884,  2886,  2890,  2894,  2895,  2897,  2899,  2901,
    2903,  2905,  2907,  2911,  2915,  2919,  2923,  2927,  2931,  2935,
    2936,  2940,  2945,  2950,  2954,  2958,  2962,  2967,  2971,  2977,
    2982,  2987,  2991,  2995,  2999,  3001,  3003,  3005,  3007,  3009,
    3011,  3013,  3015,  3017,  3019,  3021,  3023,  3025,  3027,  3029,
    3034,  3036,  3041,  3043,  3047,  3053,  3056,  3059,  3062,  3065,
    3068,  3071,  3075,  3079,  3083,  3087,  3091,  3095,  3099,  3103,
    3107,  3111,  3114,  3117,  3121,  3125,  3128,  3132,  3138,  3143,
    3150,  3154,  3160,  3165,  3172,  3177,  3184,  3190,  3198,  3201,
    3205,  3208,  3213,  3217,  3222,  3226,  3231,  3235,  3240,  3246,
    3253,  3261,  3267,  3274,  3278,  3283,  3288,  3295,  3298,  3300,
    3302,  3306,  3309,  3312,  3315,  3318,  3321,  3325,  3329,  3333,
    3337,  3341,  3345,  3349,  3353,  3357,  3361,  3364,  3367,  3373,
    3380,  3388,  3390,  3392,  3396,  3402,  3407,  3409,  3413,  3418,
    3424,  3430,  3435,  3437,  3440,  3445,  3448,  3453,  3456,  3459,
    3462,  3469,  3474,  3479,  3484,  3489,  3496,  3502,  3508,  3514,
    3519,  3526,  3531,  3533,  3536,  3539,  3542,  3547,  3554,  3555,
    3557,  3561,  3565,  3566,  3570,  3572,  3574,  3578,  3582,  3586,
    3588,  3590,  3592,  3594,  3596,  3598,  3600,  3602,  3607,  3611,
    3614,  3618,  3619,  3623,  3627,  3630,  3633,  3635,  3636,  3639,
    3642,  3646,  3649,  3651,  3653,  3657,  3663,  3670,  3675,  3678,
    3680,  3685,  3688,  3689,  3691,  3692,  3695,  3698,  3701,  3704,
    3707,  3711,  3714,  3715,  3719,  3721,  3725,  3727,  3729,  3733,
    3741,  3743,  3746,  3751,  3753,  3757,  3762,  3767,  3771,  3773,
    3775,  3777,  3779,  3781,  3783,  3787,  3789,  3791,  3793,  3797,
    3799,  3801,  3803,  3805,  3807,  3809,  3811,  3813,  3815,  3818,
    3822,  3829,  3832,  3834,  3836,  3838,  3840,  3842,  3844,  3846,
    3848,  3850,  3852,  3854,  3856,  3859,  3861,  3863,  3865,  3867,
    3869,  3871,  3873,  3876,  3879,  3881,  3883,  3885,  3887,  3889,
    3891,  3893,  3895,  3897,  3899,  3901,  3903,  3909,  3913,  3916,
    3919,  3923,  3931,  3933,  3936,  3939,  3941,  3942,  3944,  3948,
    3950,  3953,  3954,  3957,  3958,  3961,  3962,  3964,  3968,  3973,
    3977,  3979,  3981,  3983,  3986,  3987,  3995,  3999,  4002,  4004,
    4006,  4008,  4009,  4015,  4016,  4021,  4024,  4026,  4029,  4030,
    4032,  4036,  4040,  4044,  4048,  4050,  4052,  4055,  4057,  4058,
    4063,  4069,  4075,  4076,  4078,  4080,  4082,  4085,  4088,  4090,
    4093,  4094,  4102,  4103,  4109,  4110,  4115,  4118,  4121,  4123,
    4125,  4127,  4129,  4131,  4133,  4135,  4137,  4139,  4141,  4143,
    4149,  4151,  4154,  4156,  4160,  4163,  4166,  4170,  4171,  4177,
    4179,  4180,  4186,  4189,  4192,  4194,  4196,  4198,  4201,  4204,
    4208,  4210,  4213,  4216,  4220,  4224,  4229,  4232,  4234,  4237,
    4239,  4241,  4244,  4247,  4251,  4253,  4255,  4257,  4258,  4260,
    4264,  4269,  4270,  4273,  4274,  4276,  4279,  4283,  4286,  4288,
    4290,  4292,  4293,  4295,  4297,  4301,  4302,  4307,  4310,  4313,
    4315,  4317,  4318,  4320,  4322,  4324,  4326,  4329,  4333,  4334,
    4336,  4339,  4344,  4349,  4350,  4352,  4354,  4356,  4359,  4361,
    4363,  4367,  4369,  4371,  4376,  4381,  4386,  4391,  4393,  4394,
    4398,  4402,  4406,  4408,  4412,  4414,  4416,  4418,  4420,  4422,
    4424,  4426,  4428,  4430,  4432,  4434,  4436,  4438,  4440,  4442,
    4444,  4448,  4450,  4454,  4459,  4466,  4473,  4476,  4481,  4486,
    4488,  4490,  4495,  4500,  4504,  4505,  4513,  4515,  4516,  4517,
    4525,  4529,  4534,  4538,  4540,  4542,  4544,  4547,  4551,  4557,
    4560,  4566,  4569,  4571,  4573,  4575,  4577,  4579,  4581,  4583,
    4585,  4587,  4589,  4591,  4593,  4595,  4597,  4599,  4601,  4603,
    4605,  4607,  4609,  4611,  4613,  4615,  4617,  4619,  4621,  4623,
    4625,  4627,  4629,  4631,  4633,  4635,  4637,  4639,  4641,  4643,
    4645,  4647,  4649,  4651,  4653,  4655,  4657,  4659,  4661,  4663,
    4665,  4667,  4669,  4671,  4673,  4675,  4677,  4679,  4681,  4683,
    4685,  4687,  4689,  4691,  4693,  4695,  4697,  4699,  4701,  4703,
    4705,  4707,  4709,  4711,  4713,  4715,  4717,  4719,  4721,  4723,
    4725,  4727,  4729,  4731,  4733,  4735,  4737,  4739,  4741,  4743,
    4745,  4747,  4749,  4751,  4753,  4755,  4757,  4759,  4761,  4763,
    4765,  4767,  4769,  4771,  4773,  4775,  4777,  4779,  4781,  4783,
    4785,  4787,  4789,  4791,  4793,  4795,  4797,  4799,  4801,  4803,
    4805,  4807,  4809,  4811,  4813,  4815,  4817,  4819,  4821,  4823,
    4825,  4827,  4829,  4831,  4833,  4835,  4837,  4839,  4841,  4843,
    4845,  4847,  4849,  4851,  4853,  4855,  4857,  4859,  4861,  4863,
    4865,  4867,  4869,  4871,  4873,  4875,  4877,  4879,  4881,  4883,
    4885,  4887,  4889,  4891,  4893,  4895,  4897,  4899,  4901,  4903,
    4905,  4907,  4909,  4911,  4913,  4915,  4917,  4919,  4921,  4923,
    4925,  4927,  4929,  4931,  4933,  4935,  4937,  4939,  4941,  4943,
    4945,  4947,  4949,  4951,  4953,  4955,  4957,  4959,  4961,  4963,
    4965,  4967,  4969,  4971,  4973,  4975,  4977,  4979,  4981,  4983,
    4985,  4987,  4989,  4991,  4993,  4995,  4997,  4999,  5001,  5003,
    5005,  5007,  5009,  5011,  5013,  5015,  5017,  5019,  5021,  5023,
    5025,  5027,  5029,  5031,  5033,  5035,  5037,  5039,  5041,  5043,
    5045,  5047,  5049,  5051,  5053,  5055,  5057,  5059,  5061,  5063,
    5065,  5067,  5069,  5071,  5073,  5075,  5077,  5079,  5081,  5083,
    5085,  5087,  5089,  5091,  5093,  5095,  5097,  5099,  5101,  5103,
    5105,  5107,  5109,  5111,  5113,  5115,  5117,  5119,  5121,  5123,
    5125,  5127,  5129,  5131,  5133,  5135,  5137,  5139,  5141,  5143,
    5145,  5147,  5149,  5151,  5153,  5155,  5157,  5159,  5161,  5163,
    5165,  5167,  5169,  5171,  5173,  5175,  5177,  5179,  5181,  5183,
    5185,  5187,  5189,  5191,  5193,  5195,  5197,  5199,  5201,  5203,
    5205,  5207,  5209,  5211,  5213,  5215,  5217,  5219,  5221,  5223,
    5225,  5227,  5229,  5231,  5233,  5235,  5237,  5239,  5241,  5243,
    5245,  5247,  5249,  5251,  5253,  5255,  5257,  5259,  5261,  5263,
    5265,  5267,  5269,  5271,  5273,  5275,  5277,  5279,  5281,  5283,
    5285,  5287,  5289,  5291,  5293,  5295,  5297,  5299,  5301,  5303,
    5305,  5307,  5309,  5311,  5315,  5317,  5318,  5320,  5323,  5325,
    5328,  5330,  5332,  5335,  5338,  5340,  5342,  5344,  5346,  5348,
    5350,  5353,  5357,  5359,  5362,  5364,  5368,  5370,  5374,  5376,
    5378,  5380,  5382,  5384,  5386,  5388,  5390,  5392,  5394,  5396,
    5398,  5400,  5402,  5404,  5406,  5408,  5410,  5412,  5414,  5416,
    5418,  5420,  5422,  5424,  5426,  5428,  5430,  5432,  5434,  5436,
    5438,  5440,  5442,  5444,  5446,  5448,  5450,  5452,  5454,  5456,
    5458,  5460,  5462,  5464,  5466,  5468,  5470,  5472,  5474,  5476,
    5478,  5480,  5482,  5484,  5486,  5488,  5490,  5492,  5494
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     418,     0,    -1,   419,    -1,    -1,   419,   420,    -1,   895,
     421,   422,   411,    -1,   895,   422,   411,    -1,   895,   792,
      -1,   801,    -1,   908,    -1,   388,    -1,   412,    -1,   413,
      -1,    97,   778,    -1,   618,    -1,   621,    -1,   434,    -1,
     500,    -1,   456,    -1,   426,    -1,   425,    -1,   626,    -1,
     455,    -1,   459,    -1,   624,    -1,   547,    -1,   452,    -1,
     460,    -1,   494,    -1,   524,    -1,   586,    -1,   623,    -1,
     620,    -1,   568,    -1,   431,    -1,   504,    -1,   532,    -1,
     436,    -1,   499,    -1,   469,    -1,   510,    -1,   423,    -1,
     614,    -1,   644,    -1,   526,    -1,   639,    -1,   525,    -1,
     588,    -1,   435,    -1,   537,    -1,   508,    -1,   603,    -1,
     538,    -1,   523,    -1,   427,    -1,   619,    -1,   632,    -1,
     543,    -1,   550,    -1,   562,    -1,   635,    -1,   605,    -1,
     613,    -1,   640,    -1,   604,    -1,   589,    -1,   581,    -1,
     583,    -1,   580,    -1,   592,    -1,   551,    -1,   595,    -1,
     647,    -1,   607,    -1,   542,    -1,   606,    -1,   643,    -1,
     625,    -1,   440,    -1,   450,    -1,   451,    -1,   612,    -1,
     858,    -1,   777,    -1,   790,    -1,   791,    -1,   857,    -1,
     834,    -1,   855,    -1,   835,    -1,   838,    -1,   843,    -1,
     866,    -1,   865,    -1,   844,    -1,   854,    -1,   867,    -1,
     868,    -1,   870,    -1,   871,    -1,   874,    -1,   876,    -1,
     134,   363,   775,   424,   428,    -1,   376,    -1,    -1,    87,
     363,   775,   428,    -1,    87,   363,   775,   376,   428,    -1,
      87,   363,   775,   319,   441,    -1,    87,   363,   775,   451,
      -1,   163,   363,   430,    -1,   428,   429,    -1,    -1,   279,
     767,    -1,   336,   768,    -1,   135,    -1,   252,    -1,   136,
      -1,   253,    -1,   202,   193,   430,    -1,   366,   360,   767,
      -1,   430,   414,   775,    -1,   775,    -1,   134,   193,   775,
     432,    -1,   134,   193,   775,   376,   432,    -1,   432,   433,
      -1,    -1,   363,   430,    -1,   336,   768,    -1,    87,   193,
     775,    83,   363,   430,    -1,    87,   193,   775,   163,   363,
     430,    -1,   163,   193,   775,    -1,   134,   310,   775,   437,
      98,   775,   438,    -1,   134,   310,   883,   438,    -1,   883,
      -1,    -1,   438,   439,    -1,    -1,   469,    -1,   550,    -1,
     612,    -1,   319,   441,    -1,   319,   235,   441,    -1,   319,
     317,   441,    -1,   883,   344,   442,    -1,   883,   415,   442,
      -1,   342,   381,   447,    -1,   347,   609,    -1,   317,   117,
      93,   347,   609,    -1,   245,   448,    -1,   317,    98,   449,
      -1,   317,    98,   150,    -1,   443,    -1,   150,    -1,   445,
      -1,   443,   414,   445,    -1,   292,   128,    -1,   316,    -1,
     446,    -1,   773,    -1,   883,    -1,   351,    -1,   178,    -1,
     267,    -1,   263,    -1,   773,    -1,   902,    -1,   705,   770,
     707,    -1,   705,   408,   768,   409,   770,   707,    -1,   150,
      -1,   235,    -1,   770,    -1,   150,    -1,    -1,   883,    -1,
     770,    -1,   322,   883,    -1,   322,   342,   381,    -1,   322,
     347,   222,   230,    -1,   322,   317,    98,    -1,   322,    86,
      -1,   300,   883,    -1,   300,   342,   381,    -1,   300,   347,
     222,   230,    -1,   300,   317,    98,    -1,   300,    86,    -1,
     319,   130,   453,   454,    -1,    86,    -1,   754,    -1,   153,
      -1,   199,    -1,   119,    -1,    87,   337,   678,    83,   594,
     474,    -1,    87,   337,   678,    87,   594,   883,   457,    -1,
      87,   337,   678,    87,   594,   883,   163,   255,   259,    -1,
      87,   337,   678,    87,   594,   883,   319,   255,   259,    -1,
      87,   337,   678,    87,   594,   883,   319,   330,   768,    -1,
      87,   337,   678,    87,   594,   883,   319,   333,   883,    -1,
      87,   337,   678,   163,   594,   883,   458,    -1,    87,   337,
     678,    83,   481,    -1,    87,   337,   678,   163,   129,   755,
     458,    -1,    87,   337,   678,   319,   377,   265,    -1,    87,
     337,   753,   134,   345,   337,    -1,    87,   337,   753,   277,
     344,   775,    -1,    87,   337,   753,   122,   267,   755,    -1,
     319,   150,   716,    -1,   163,   150,    -1,   111,    -1,   302,
      -1,    -1,   121,   755,    -1,   133,   465,   753,   466,   461,
     462,   467,   424,   463,    -1,   344,    -1,   187,    -1,   770,
      -1,   331,    -1,   332,    -1,   463,   464,    -1,    -1,   104,
      -1,   265,    -1,   156,   622,   770,    -1,   259,   622,   770,
      -1,   104,    -1,    -1,   376,   265,    -1,    -1,   468,   157,
     770,    -1,    -1,   364,    -1,    -1,   134,   470,   337,   753,
     408,   471,   409,   491,   492,   493,    -1,   134,   470,   337,
     753,   262,   753,   408,   471,   409,   492,   493,    -1,   340,
      -1,   338,    -1,   235,   340,    -1,   235,   338,    -1,   191,
     340,    -1,   191,   338,    -1,    -1,   472,    -1,    -1,   473,
      -1,   472,   414,   473,    -1,   474,    -1,   479,    -1,   481,
      -1,   883,   683,   475,    -1,   475,   476,    -1,    -1,   129,
     755,   477,    -1,   477,    -1,   478,    -1,   255,   259,    -1,
     259,    -1,   357,    -1,   287,   224,    -1,   118,   408,   716,
     409,    -1,   150,   717,    -1,   295,   753,   483,   486,   487,
      -1,   152,    -1,   255,   152,    -1,   207,   153,    -1,   207,
     199,    -1,   231,   753,   480,    -1,   203,   151,    -1,   172,
     151,    -1,    -1,   129,   755,   482,    -1,   482,    -1,   118,
     408,   716,   409,    -1,   357,   408,   484,   409,    -1,   287,
     224,   408,   484,   409,    -1,   184,   224,   408,   484,   409,
     295,   753,   483,   486,   487,   520,    -1,   408,   484,   409,
      -1,    -1,   484,   414,   485,    -1,   485,    -1,   883,    -1,
     238,   188,    -1,   238,   278,    -1,    -1,   488,    -1,   489,
      -1,   488,   489,    -1,   489,   488,    -1,    -1,   267,   155,
     490,    -1,   267,   361,   490,    -1,   251,    82,    -1,   302,
      -1,   111,    -1,   319,   150,    -1,   319,   259,    -1,   206,
     408,   752,   409,    -1,    -1,   376,   265,    -1,   377,   265,
      -1,    -1,   267,   127,   163,    -1,   267,   127,   155,   308,
      -1,   267,   127,   285,   308,    -1,    -1,    -1,   134,   470,
     337,   753,   496,    93,   495,   647,    -1,   408,   497,   409,
      -1,    -1,   497,   414,   498,    -1,   498,    -1,   883,    -1,
     134,   470,   315,   753,   501,    -1,    87,   315,   753,   501,
      -1,   501,   502,    -1,    -1,   109,   772,    -1,   143,    -1,
     251,   143,    -1,   204,   503,   772,    -1,   239,   772,    -1,
     241,   772,    -1,   251,   239,    -1,   251,   241,    -1,   328,
     424,   772,    -1,   301,   424,   772,    -1,   108,    -1,    -1,
     134,   505,   509,   226,   449,   194,   506,   507,    -1,   353,
      -1,    -1,   755,    -1,   740,    -1,   225,   770,    -1,    -1,
     163,   509,   226,   770,   458,    -1,   290,    -1,    -1,   134,
     349,   755,   511,   512,   267,   753,   514,   173,   291,   755,
     408,   517,   409,    -1,   134,   129,   349,   755,    84,   512,
     267,   753,   519,   520,   182,   164,   307,   173,   291,   761,
     408,   517,   409,    -1,   100,    -1,    84,    -1,   513,    -1,
     513,   271,   513,    -1,   513,   271,   513,   271,   513,    -1,
     212,    -1,   155,    -1,   361,    -1,   182,   515,   516,    -1,
      -1,   164,    -1,    -1,   307,    -1,   329,    -1,   518,    -1,
     517,   414,   518,    -1,    -1,   774,    -1,   883,    -1,    -1,
     187,   753,    -1,   521,    -1,   521,   522,    -1,   522,    -1,
     522,   521,    -1,   255,   152,    -1,   152,    -1,   207,   199,
      -1,   207,   153,    -1,   163,   349,   755,   267,   753,   458,
      -1,   134,    95,   755,   118,   408,   716,   409,   520,    -1,
     163,    95,   755,    -1,   134,    85,   761,   528,    -1,   134,
     269,   712,   528,    -1,   134,   354,   541,   528,    -1,   134,
     354,   541,    93,   527,    -1,   408,   681,   409,    -1,   408,
     529,   409,    -1,   530,    -1,   529,   414,   530,    -1,   886,
     395,   531,    -1,   886,    -1,   575,    -1,   715,    -1,   773,
      -1,   134,   269,   120,   541,   535,   182,   354,   683,   364,
     757,    93,   533,    -1,   534,    -1,   533,   414,   534,    -1,
     269,   768,   585,   536,    -1,   269,   768,   585,   408,   584,
     409,   536,    -1,   189,   768,   761,   570,    -1,   333,   683,
      -1,   150,    -1,    -1,   294,    -1,    -1,   163,   269,   120,
     541,   364,   757,   458,    -1,   163,   539,   540,   458,    -1,
     337,    -1,   315,    -1,   372,    -1,   205,    -1,   354,    -1,
     161,    -1,   131,    -1,   310,    -1,   541,    -1,   540,   414,
     541,    -1,   883,    -1,   740,    -1,   352,   654,   753,    -1,
     179,   544,   546,   755,   850,    -1,   179,   544,   755,   850,
      -1,   179,   546,   755,   850,    -1,   179,   755,   850,    -1,
     179,   544,   546,   755,    -1,   179,   544,   755,    -1,   179,
     546,   755,    -1,   179,   755,    -1,   244,   544,   546,   755,
      -1,   244,   755,    -1,   250,    -1,   288,    -1,   180,    -1,
     227,    -1,    80,   545,    -1,   297,   545,    -1,   545,    -1,
      86,    -1,   185,    -1,   185,   545,    -1,   185,    86,    -1,
      99,    -1,    99,   545,    -1,    99,    86,    -1,   769,    -1,
     202,    -1,   187,    -1,   126,   267,   548,   755,   220,   549,
      -1,   126,   267,    85,   761,   408,   582,   409,   220,   549,
      -1,   126,   267,   189,   761,   570,   220,   549,    -1,   126,
     267,   269,   712,   408,   584,   409,   220,   549,    -1,   126,
     267,   349,   755,   267,   541,   220,   549,    -1,   126,   267,
     309,   755,   267,   541,   220,   549,    -1,   126,   267,   309,
     755,   220,   549,    -1,   125,    -1,   144,    -1,   310,    -1,
     205,    -1,   315,    -1,   337,    -1,   161,    -1,   354,    -1,
     372,    -1,   770,    -1,   259,    -1,   192,   552,   267,   555,
     344,   556,   558,    -1,   304,   559,   552,   267,   555,   187,
     556,   458,    -1,    86,   289,    -1,    86,    -1,   553,    -1,
     554,    -1,   553,   414,   554,    -1,   314,    -1,   212,    -1,
     361,    -1,   155,    -1,   309,    -1,   295,    -1,   349,    -1,
     173,    -1,   362,    -1,   134,    -1,   340,    -1,   338,    -1,
     752,    -1,   337,   752,    -1,   189,   560,    -1,   144,   754,
      -1,   226,   754,    -1,   310,   754,    -1,   557,    -1,   556,
     414,   557,    -1,   883,    -1,   193,   883,    -1,   376,   192,
     270,    -1,    -1,   192,   270,   182,    -1,    -1,   561,    -1,
     560,   414,   561,    -1,   761,   570,    -1,   134,   563,   205,
     759,   267,   753,   564,   408,   565,   409,   680,    -1,   357,
      -1,    -1,   364,   757,    -1,    -1,   566,    -1,   565,   414,
     566,    -1,   758,   567,    -1,   761,   408,   720,   409,   567,
      -1,   408,   716,   409,   567,    -1,   541,    -1,   364,   541,
      -1,    -1,   134,   569,   189,   761,   570,   303,   575,   577,
     579,    -1,   271,   299,    -1,    -1,   408,   571,   409,    -1,
     408,   409,    -1,   572,    -1,   571,   414,   572,    -1,   573,
     576,    -1,   576,    -1,   202,    -1,   273,    -1,   209,    -1,
     770,    -1,   770,   414,   770,    -1,   576,    -1,   683,    -1,
     884,   741,   403,   354,    -1,   578,    -1,   577,   578,    -1,
      93,   574,    -1,   226,   449,    -1,   200,    -1,   327,    -1,
     373,    -1,   110,   267,   259,   210,    -1,   303,   259,   267,
     259,   210,    -1,   334,    -1,   176,   313,   154,    -1,   176,
     313,   219,    -1,   313,   154,    -1,   313,   219,    -1,   376,
     528,    -1,    -1,   163,   189,   761,   570,   458,    -1,   163,
      85,   761,   408,   582,   409,   458,    -1,   683,    -1,   401,
      -1,   163,   269,   712,   408,   584,   409,   458,    -1,   683,
      -1,   683,   414,   683,    -1,   254,   414,   683,    -1,   683,
     414,   254,    -1,   712,    -1,   883,   410,   585,    -1,   134,
     113,   408,   683,    93,   683,   409,   376,   189,   561,   587,
      -1,   134,   113,   408,   683,    93,   683,   409,   377,   189,
     587,    -1,    93,    96,    -1,    -1,   163,   113,   408,   683,
      93,   683,   409,   458,    -1,   296,   590,   753,   591,    -1,
     296,   144,   755,   591,    -1,   205,    -1,   337,    -1,   183,
      -1,    -1,    87,    85,   761,   408,   582,   409,   298,   344,
     755,    -1,    87,   131,   541,   298,   344,   755,    -1,    87,
     144,   756,   298,   344,   756,    -1,    87,   189,   761,   570,
     298,   344,   755,    -1,    87,   193,   775,   298,   344,   775,
      -1,    87,   226,   755,   298,   344,   755,    -1,    87,   269,
     120,   541,   364,   757,   298,   344,   755,    -1,    87,   310,
     755,   298,   344,   755,    -1,    87,   337,   678,   298,   594,
     593,   344,   755,    -1,    87,   349,   755,   267,   678,   298,
     344,   755,    -1,    87,   363,   775,   298,   344,   775,    -1,
     755,    -1,    -1,   125,    -1,    -1,    -1,   134,   569,   309,
     755,    93,   596,   267,   601,   344,   753,   680,   160,   602,
     597,    -1,   256,    -1,   599,    -1,   408,   598,   409,    -1,
     598,   411,   600,    -1,   600,    -1,   647,    -1,   635,    -1,
     643,    -1,   639,    -1,   604,    -1,   599,    -1,    -1,   314,
      -1,   361,    -1,   155,    -1,   212,    -1,   213,    -1,    -1,
     163,   309,   755,   267,   753,   458,    -1,   257,   753,    -1,
     233,   753,    -1,   359,   753,    -1,   359,   401,    -1,    79,
     608,    -1,   101,   608,    -1,   328,   347,   610,    -1,   127,
     608,    -1,   168,   608,    -1,   306,   608,    -1,   378,    -1,
     347,    -1,    -1,   222,   230,   444,    -1,   611,    -1,   222,
     230,   444,   611,    -1,   611,   222,   230,   444,    -1,   609,
      -1,    -1,   292,   268,    -1,   292,   379,    -1,   134,   569,
     372,   753,   483,    93,   647,    -1,   234,   760,    -1,   134,
     144,   756,   376,   615,    -1,   134,   144,   756,    -1,   616,
      -1,   615,   616,    -1,   236,   617,   770,    -1,   236,   617,
     150,    -1,   339,   617,   755,    -1,   339,   617,   150,    -1,
     166,   617,   771,    -1,   166,   617,   150,    -1,   277,   617,
     755,    -1,   277,   617,   150,    -1,   395,    -1,    -1,    87,
     144,   756,   319,   441,    -1,    87,   144,   756,   451,    -1,
     163,   144,   756,    -1,   134,   161,   541,   622,   683,   475,
      -1,    87,   161,   541,   457,    -1,    87,   161,   541,   163,
     255,   259,    -1,    87,   161,   541,   319,   255,   259,    -1,
      87,   161,   541,    83,   481,    -1,    87,   161,   541,   163,
     129,   755,   458,    -1,    87,   161,   541,   277,   344,   775,
      -1,    93,    -1,    -1,   134,   535,   131,   541,   182,   770,
     344,   770,   187,   541,    -1,   122,   759,   267,   753,    -1,
     122,   753,    -1,   122,    -1,   365,   629,   630,   628,    -1,
     365,   629,   630,   628,   753,    -1,   365,   629,   630,   628,
     626,    -1,   627,   628,    -1,   627,   628,   753,   631,    -1,
      89,    -1,    88,    -1,   370,    -1,    -1,   188,    -1,    -1,
     186,    -1,    -1,   408,   754,   409,    -1,    -1,   175,   634,
     628,   633,    -1,   647,    -1,   635,    -1,   643,    -1,   639,
      -1,   644,    -1,   627,    -1,    -1,   212,   218,   753,   636,
      -1,   367,   408,   749,   409,    -1,   150,   367,    -1,   647,
      -1,   408,   637,   409,   367,   408,   749,   409,    -1,   408,
     637,   409,   647,    -1,   637,   414,   638,    -1,   638,    -1,
     883,   719,    -1,   155,   187,   678,   680,    -1,   237,   654,
     752,   641,    -1,   202,   642,   242,    -1,    -1,    81,   321,
      -1,   307,   321,    -1,   307,   171,    -1,   321,   361,   171,
      -1,   321,    -1,   321,   307,   171,    -1,   171,    -1,    81,
     171,    -1,   361,   678,   319,   745,   670,   680,    -1,   149,
     755,   645,   142,   646,   182,   647,    -1,    -1,   645,   104,
      -1,   645,   211,    -1,   645,   311,    -1,   645,   251,   311,
      -1,    -1,   376,   196,    -1,   377,   196,    -1,   649,    -1,
     648,    -1,   408,   649,   409,    -1,   408,   648,   409,    -1,
     651,    -1,   650,   658,    -1,   650,   657,   667,   662,    -1,
     650,   657,   661,   668,    -1,   651,    -1,   648,    -1,   314,
     656,   743,   652,   670,   680,   665,   666,    -1,   650,   356,
     655,   650,    -1,   650,   216,   655,   650,    -1,   650,   170,
     655,   650,    -1,   218,   653,    -1,   850,    -1,    -1,   340,
     654,   753,    -1,   338,   654,   753,    -1,   235,   340,   654,
     753,    -1,   235,   338,   654,   753,    -1,   191,   340,   654,
     753,    -1,   191,   338,   654,   753,    -1,   337,   753,    -1,
     753,    -1,   337,    -1,    -1,    86,    -1,    -1,   159,    -1,
     159,   267,   408,   720,   409,    -1,    86,    -1,    -1,   658,
      -1,    -1,   272,   108,   659,    -1,   660,    -1,   659,   414,
     660,    -1,   716,   364,   715,    -1,   716,    94,    -1,   716,
     158,    -1,   716,    -1,   232,   663,   264,   664,    -1,   264,
     664,   232,   663,    -1,   232,   663,    -1,   264,   664,    -1,
     232,   663,   414,   664,    -1,   661,    -1,    -1,   716,    -1,
      86,    -1,   716,    -1,   193,   108,   720,    -1,    -1,   195,
     716,    -1,    -1,   182,   361,   669,    -1,   182,   292,   268,
      -1,   667,    -1,    -1,   262,   754,    -1,    -1,   187,   671,
      -1,    -1,   671,   414,   672,    -1,   672,    -1,   678,    -1,
     678,   674,    -1,   679,    -1,   679,   674,    -1,   679,    93,
     408,   681,   409,    -1,   679,    93,   883,   408,   681,   409,
      -1,   679,   883,   408,   681,   409,    -1,   648,    -1,   648,
     674,    -1,   673,    -1,   408,   673,   409,   674,    -1,   408,
     673,   409,    -1,   672,   137,   223,   672,    -1,   672,   382,
     672,    -1,   672,   675,   223,   672,   677,    -1,   672,   223,
     672,   677,    -1,   672,   247,   675,   223,   672,    -1,   672,
     247,   223,   672,    -1,    93,   883,   408,   754,   409,    -1,
      93,   883,    -1,   883,   408,   754,   409,    -1,   883,    -1,
     188,   676,    -1,   229,   676,    -1,   305,   676,    -1,   208,
      -1,   274,    -1,    -1,   364,   408,   754,   409,    -1,   267,
     716,    -1,   753,    -1,   753,   401,    -1,   268,   753,    -1,
     268,   408,   753,   409,    -1,   761,   408,   409,    -1,   761,
     408,   720,   409,    -1,   375,   716,    -1,    -1,   682,    -1,
     681,   414,   682,    -1,   883,   683,    -1,   686,   684,    -1,
     320,   686,   684,    -1,   686,    92,   406,   768,   407,    -1,
     320,   686,    92,   406,   768,   407,    -1,   406,   407,   684,
      -1,   406,   685,   407,   684,    -1,    -1,   768,    -1,   408,
     685,   409,    -1,   685,   399,   685,    -1,   685,   400,   685,
      -1,   685,   401,   685,    -1,   685,   402,   685,    -1,   685,
     403,   685,    -1,   767,    -1,   883,    -1,   688,    -1,   704,
      -1,   689,    -1,   693,    -1,   697,    -1,   705,   707,    -1,
     705,   408,   768,   409,   707,    -1,   884,   741,    -1,   688,
      -1,   704,    -1,   689,    -1,   694,    -1,   698,    -1,   884,
      -1,   214,    -1,   215,    -1,   325,    -1,   103,    -1,   293,
      -1,   181,   690,    -1,   162,   284,    -1,   148,   692,    -1,
     147,   692,    -1,   261,   691,    -1,   106,    -1,   408,   768,
     409,    -1,    -1,   408,   768,   414,   768,   409,    -1,   408,
     768,   409,    -1,    -1,   408,   768,   414,   768,   409,    -1,
     408,   768,   409,    -1,    -1,   695,    -1,   696,    -1,   695,
      -1,   696,    -1,   105,   702,   408,   768,   409,    -1,   105,
     702,    -1,   699,    -1,   700,    -1,   699,    -1,   700,    -1,
     701,   408,   768,   409,   703,    -1,   701,   703,    -1,   116,
     702,    -1,   115,   702,    -1,   368,    -1,   246,   116,   702,
      -1,   246,   115,   702,    -1,   248,   702,    -1,   369,    -1,
      -1,   116,   319,   883,    -1,    -1,   343,   408,   768,   409,
     706,    -1,   343,   706,    -1,   342,   408,   768,   409,   706,
      -1,   342,   706,    -1,   217,    -1,   376,   342,   381,    -1,
     377,   342,   381,    -1,    -1,   380,    -1,   243,    -1,   145,
      -1,   197,    -1,   240,    -1,   312,    -1,   380,   344,   243,
      -1,   145,   344,   197,    -1,   145,   344,   240,    -1,   145,
     344,   312,    -1,   197,   344,   240,    -1,   240,   344,   312,
      -1,   197,   344,   312,    -1,    -1,   709,   202,   648,    -1,
     709,   255,   202,   648,    -1,   709,   715,   711,   648,    -1,
     709,   715,   648,    -1,   709,   715,   709,    -1,   709,   220,
     259,    -1,   709,   220,   255,   259,    -1,   709,   275,   709,
      -1,   709,   220,   159,   187,   709,    -1,   307,   408,   710,
     409,    -1,   307,   408,   716,   409,    -1,   307,   408,   409,
      -1,   408,   710,   409,    -1,   720,   414,   716,    -1,    91,
      -1,   326,    -1,    86,    -1,   385,    -1,   713,    -1,   399,
      -1,   400,    -1,   401,    -1,   403,    -1,   404,    -1,   402,
      -1,   396,    -1,   397,    -1,   395,    -1,   385,    -1,   269,
     408,   585,   409,    -1,   712,    -1,   269,   408,   585,   409,
      -1,   718,    -1,   716,    78,   683,    -1,   716,    97,   342,
     381,   718,    -1,   399,   716,    -1,   400,   716,    -1,   403,
     716,    -1,   404,   716,    -1,   716,   403,    -1,   716,   404,
      -1,   716,   399,   716,    -1,   716,   400,   716,    -1,   716,
     401,   716,    -1,   716,   402,   716,    -1,   716,   403,   716,
      -1,   716,   404,   716,    -1,   716,   396,   716,    -1,   716,
     397,   716,    -1,   716,   395,   716,    -1,   716,   714,   716,
      -1,   714,   716,    -1,   716,   714,    -1,   716,    90,   716,
      -1,   716,   271,   716,    -1,   255,   716,    -1,   716,   231,
     716,    -1,   716,   231,   716,   169,   716,    -1,   716,   255,
     231,   716,    -1,   716,   255,   231,   716,   169,   716,    -1,
     716,   198,   716,    -1,   716,   198,   716,   169,   716,    -1,
     716,   255,   198,   716,    -1,   716,   255,   198,   716,   169,
     716,    -1,   716,   323,   344,   716,    -1,   716,   323,   344,
     716,   169,   716,    -1,   716,   255,   323,   344,   716,    -1,
     716,   255,   323,   344,   716,   169,   716,    -1,   716,   221,
      -1,   716,   220,   259,    -1,   716,   258,    -1,   716,   220,
     255,   259,    -1,   716,   220,   351,    -1,   716,   220,   255,
     351,    -1,   716,   220,   178,    -1,   716,   220,   255,   178,
      -1,   716,   220,   358,    -1,   716,   220,   255,   358,    -1,
     716,   220,   159,   187,   716,    -1,   716,   220,   262,   408,
     722,   409,    -1,   716,   220,   255,   262,   408,   722,   409,
      -1,   716,   102,   717,    90,   717,    -1,   716,   255,   102,
     717,    90,   717,    -1,   716,   202,   733,    -1,   716,   255,
     202,   733,    -1,   716,   715,   711,   648,    -1,   716,   715,
     711,   408,   716,   409,    -1,   357,   648,    -1,   708,    -1,
     718,    -1,   717,    78,   683,    -1,   400,   717,    -1,   403,
     717,    -1,   404,   717,    -1,   717,   403,    -1,   717,   404,
      -1,   717,   399,   717,    -1,   717,   400,   717,    -1,   717,
     401,   717,    -1,   717,   402,   717,    -1,   717,   403,   717,
      -1,   717,   404,   717,    -1,   717,   396,   717,    -1,   717,
     397,   717,    -1,   717,   395,   717,    -1,   717,   385,   717,
      -1,   714,   717,    -1,   717,   714,    -1,   717,   220,   159,
     187,   717,    -1,   717,   220,   262,   408,   717,   409,    -1,
     717,   220,   255,   262,   408,   717,   409,    -1,   739,    -1,
     762,    -1,   393,   741,   719,    -1,   408,   716,   409,   741,
     719,    -1,   408,   716,   409,   719,    -1,   734,    -1,   761,
     408,   409,    -1,   761,   408,   720,   409,    -1,   761,   408,
      86,   720,   409,    -1,   761,   408,   159,   720,   409,    -1,
     761,   408,   401,   409,    -1,   138,    -1,   139,   742,    -1,
     139,   408,   768,   409,    -1,   140,   742,    -1,   140,   408,
     768,   409,    -1,   141,   742,    -1,   318,   742,    -1,   363,
     742,    -1,   113,   408,   716,    93,   683,   409,    -1,   177,
     408,   721,   409,    -1,   276,   408,   726,   409,    -1,   283,
     408,   728,   409,    -1,   335,   408,   729,   409,    -1,   348,
     408,   716,    93,   683,   409,    -1,   350,   408,   107,   732,
     409,    -1,   350,   408,   228,   732,   409,    -1,   350,   408,
     346,   732,   409,    -1,   350,   408,   732,   409,    -1,   132,
     408,   716,   364,   541,   409,    -1,   132,   408,   720,   409,
      -1,   648,    -1,   174,   648,    -1,    92,   648,    -1,    92,
     724,    -1,   406,   716,   407,   719,    -1,   406,   716,   416,
     716,   407,   719,    -1,    -1,   716,    -1,   720,   414,   716,
      -1,   725,   187,   716,    -1,    -1,   722,   414,   683,    -1,
     683,    -1,   724,    -1,   723,   414,   724,    -1,   406,   720,
     407,    -1,   406,   723,   407,    -1,   902,    -1,   380,    -1,
     243,    -1,   145,    -1,   197,    -1,   240,    -1,   312,    -1,
     770,    -1,   716,   727,   730,   731,    -1,   716,   727,   730,
      -1,   282,   716,    -1,   717,   202,   717,    -1,    -1,   716,
     730,   731,    -1,   716,   731,   730,    -1,   716,   730,    -1,
     716,   731,    -1,   720,    -1,    -1,   187,   716,    -1,   182,
     716,    -1,   716,   187,   720,    -1,   187,   720,    -1,   720,
      -1,   648,    -1,   408,   720,   409,    -1,   112,   738,   735,
     737,   168,    -1,   260,   408,   716,   414,   716,   409,    -1,
     123,   408,   720,   409,    -1,   735,   736,    -1,   736,    -1,
     374,   716,   341,   716,    -1,   165,   716,    -1,    -1,   716,
      -1,    -1,   751,   719,    -1,   740,   719,    -1,   751,   741,
      -1,   410,   758,    -1,   410,   401,    -1,   410,   758,   741,
      -1,   408,   409,    -1,    -1,   743,   414,   744,    -1,   744,
      -1,   716,    93,   886,    -1,   716,    -1,   401,    -1,   745,
     414,   748,    -1,   408,   746,   409,   395,   408,   747,   409,
      -1,   748,    -1,   883,   719,    -1,   883,   719,   414,   746,
      -1,   716,    -1,   716,   414,   747,    -1,   883,   719,   395,
     716,    -1,   883,   719,   395,   150,    -1,   749,   414,   750,
      -1,   750,    -1,   744,    -1,   150,    -1,   776,    -1,   883,
      -1,   753,    -1,   752,   414,   753,    -1,   751,    -1,   740,
      -1,   755,    -1,   754,   414,   755,    -1,   883,    -1,   883,
      -1,   883,    -1,   883,    -1,   883,    -1,   770,    -1,   885,
      -1,   740,    -1,   774,    -1,   687,   770,    -1,   705,   770,
     707,    -1,   705,   408,   768,   409,   770,   707,    -1,   393,
     719,    -1,   351,    -1,   178,    -1,   259,    -1,   898,    -1,
     392,    -1,   394,    -1,   390,    -1,   391,    -1,   384,    -1,
     763,    -1,   899,    -1,   768,    -1,   400,   768,    -1,   767,
      -1,   899,    -1,   763,    -1,   767,    -1,   899,    -1,   764,
      -1,   763,    -1,   400,   764,    -1,   400,   763,    -1,   899,
      -1,   767,    -1,   772,    -1,   767,    -1,   764,    -1,   763,
      -1,   765,    -1,   766,    -1,   899,    -1,   883,    -1,   266,
      -1,   249,    -1,     9,   344,   778,   784,   785,    -1,     9,
     344,   150,    -1,     9,   786,    -1,   144,   778,    -1,   756,
     781,   783,    -1,   779,   416,   780,   783,   402,   756,   789,
      -1,   770,    -1,   902,   901,    -1,   385,   782,    -1,   780,
      -1,    -1,   883,    -1,   883,   410,   782,    -1,   389,    -1,
     416,   768,    -1,    -1,    93,   778,    -1,    -1,   363,   786,
      -1,    -1,   787,    -1,   787,   402,   787,    -1,   787,    25,
     108,   787,    -1,   787,   364,   787,    -1,   775,    -1,   770,
      -1,   901,    -1,   385,   883,    -1,    -1,   149,   755,   645,
     142,   646,   182,   842,    -1,   146,   286,   842,    -1,   146,
     842,    -1,   793,    -1,   808,    -1,   794,    -1,    -1,   813,
     800,   795,   830,   411,    -1,    -1,   800,   796,   830,   411,
      -1,   820,   411,    -1,   772,    -1,   414,   772,    -1,    -1,
     707,    -1,   380,   344,   240,    -1,   380,   344,   312,    -1,
     145,   344,   145,    -1,   243,   344,   243,    -1,   816,    -1,
     162,    -1,   887,   799,    -1,   824,    -1,    -1,   803,   802,
     805,   804,    -1,   895,   101,   149,    40,   411,    -1,   895,
     168,   149,    40,   411,    -1,    -1,   806,    -1,   810,    -1,
     808,    -1,   806,   810,    -1,   806,   808,    -1,   810,    -1,
     807,   810,    -1,    -1,    77,   809,   817,   833,   887,   684,
     411,    -1,    -1,   813,   817,   811,   830,   411,    -1,    -1,
     817,   812,   830,   411,    -1,   820,   411,    -1,   814,   815,
      -1,   814,    -1,   815,    -1,    63,    -1,    74,    -1,    72,
      -1,    57,    -1,    58,    -1,    76,    -1,   826,    -1,   822,
      -1,   818,    -1,   887,   408,   797,   798,   409,    -1,   816,
      -1,   888,   799,    -1,   824,    -1,    20,   882,   819,    -1,
      20,   819,    -1,    20,   882,    -1,   412,   906,   413,    -1,
      -1,   824,   821,   412,   807,   413,    -1,   820,    -1,    -1,
     825,   823,   412,   807,   413,    -1,    49,   882,    -1,   356,
     882,    -1,    49,    -1,   356,    -1,   827,    -1,   829,   828,
      -1,    50,    41,    -1,    50,    41,   214,    -1,    50,    -1,
      50,   214,    -1,    50,    29,    -1,    50,    29,   214,    -1,
      50,    29,    29,    -1,    50,    29,    29,   214,    -1,    50,
     115,    -1,    41,    -1,    41,   214,    -1,   214,    -1,    29,
      -1,    29,   214,    -1,    29,    29,    -1,    29,    29,   214,
      -1,     5,    -1,   115,    -1,    42,    -1,    -1,   831,    -1,
     830,   414,   831,    -1,   833,   887,   684,   832,    -1,    -1,
     395,   907,    -1,    -1,   401,    -1,   401,   401,    -1,   149,
     329,   902,    -1,    19,   836,    -1,   837,    -1,    13,    -1,
      86,    -1,    -1,   778,    -1,   150,    -1,   173,   199,   841,
      -1,    -1,   173,   842,   839,   840,    -1,   846,   851,    -1,
     851,   846,    -1,   846,    -1,   851,    -1,    -1,   788,    -1,
     386,    -1,   755,    -1,   788,    -1,    22,   755,    -1,    33,
     755,   845,    -1,    -1,   846,    -1,   364,   852,    -1,   364,
     849,    18,   903,    -1,   218,   849,    18,   903,    -1,    -1,
      43,    -1,   851,    -1,   847,    -1,   218,   894,    -1,   848,
      -1,   853,    -1,   853,   414,   852,    -1,   773,    -1,   898,
      -1,   286,   842,   187,   841,    -1,    17,   210,   755,   847,
      -1,    17,   856,   755,   847,    -1,    17,   856,   755,   848,
      -1,    34,    -1,    -1,   146,    18,   903,    -1,     3,    18,
     903,    -1,   901,   395,   860,    -1,    12,    -1,   901,   395,
     862,    -1,     8,    -1,    14,    -1,    15,    -1,    16,    -1,
      26,    -1,    27,    -1,    28,    -1,    30,    -1,    31,    -1,
      32,    -1,   284,    -1,    37,    -1,    38,    -1,    39,    -1,
     354,    -1,   859,    -1,   863,   414,   859,    -1,   861,    -1,
     864,   414,   861,    -1,   190,    18,   903,   863,    -1,   190,
      18,   903,    51,   901,   864,    -1,   190,    18,   903,    51,
     763,   864,    -1,   607,    35,    -1,   319,     4,   395,   869,
      -1,   319,     4,   344,   869,    -1,   267,    -1,   263,    -1,
     319,    10,   344,   837,    -1,   319,    10,   395,   837,    -1,
     319,    10,   837,    -1,    -1,   354,   872,   886,   220,   817,
     684,   873,    -1,    36,    -1,    -1,    -1,    52,   875,   886,
     220,   817,   684,   873,    -1,    53,    44,   877,    -1,    53,
     255,    21,   877,    -1,    53,    46,   877,    -1,    11,    -1,
      45,    -1,    48,    -1,    24,   755,    -1,    23,   344,   755,
      -1,   160,   755,   408,   896,   409,    -1,   160,     6,    -1,
       7,   755,   408,   896,   409,    -1,     7,   755,    -1,   879,
      -1,   880,    -1,     6,    -1,     7,    -1,     8,    -1,    11,
      -1,    12,    -1,    14,    -1,    15,    -1,    16,    -1,    21,
      -1,    23,    -1,    24,    -1,    25,    -1,    26,    -1,    27,
      -1,    28,    -1,    30,    -1,    31,    -1,    32,    -1,    35,
      -1,    37,    -1,    38,    -1,    39,    -1,    40,    -1,    44,
      -1,    45,    -1,    46,    -1,    48,    -1,     9,    -1,    17,
      -1,    19,    -1,    33,    -1,    52,    -1,    53,    -1,     5,
      -1,    29,    -1,    34,    -1,    41,    -1,    49,    -1,    42,
      -1,    50,    -1,   886,    -1,   902,    -1,   890,    -1,   891,
      -1,   878,    -1,   889,    -1,   115,    -1,   902,    -1,   890,
      -1,   878,    -1,   881,    -1,   889,    -1,   902,    -1,   890,
      -1,   892,    -1,   878,    -1,   889,    -1,   888,    -1,   881,
      -1,   115,    -1,   210,    -1,   214,    -1,   356,    -1,   889,
      -1,   902,    -1,   891,    -1,   892,    -1,   879,    -1,   887,
      -1,   890,    -1,   893,    -1,   880,    -1,    57,    -1,    58,
      -1,    63,    -1,    72,    -1,    74,    -1,    77,    -1,    76,
      -1,    79,    -1,    80,    -1,    81,    -1,    82,    -1,    83,
      -1,    84,    -1,    85,    -1,    87,    -1,    95,    -1,    96,
      -1,    97,    -1,    99,    -1,   100,    -1,   101,    -1,   108,
      -1,   109,    -1,   111,    -1,   114,    -1,   117,    -1,   119,
      -1,   120,    -1,   121,    -1,   122,    -1,   126,    -1,   127,
      -1,   128,    -1,   130,    -1,   131,    -1,   133,    -1,   135,
      -1,   136,    -1,   142,    -1,   143,    -1,   144,    -1,   145,
      -1,   146,    -1,   149,    -1,   151,    -1,   153,    -1,   155,
      -1,   156,    -1,   157,    -1,   161,    -1,   162,    -1,   163,
      -1,   164,    -1,   166,    -1,   167,    -1,   169,    -1,   172,
      -1,   171,    -1,   173,    -1,   175,    -1,   179,    -1,   180,
      -1,   183,    -1,   185,    -1,   189,    -1,   191,    -1,   194,
      -1,   196,    -1,   197,    -1,   199,    -1,   200,    -1,   201,
      -1,   203,    -1,   204,    -1,   205,    -1,   206,    -1,   209,
      -1,   211,    -1,   212,    -1,   213,    -1,   222,    -1,   224,
      -1,   225,    -1,   226,    -1,   227,    -1,   230,    -1,   233,
      -1,   234,    -1,   235,    -1,   236,    -1,   237,    -1,   238,
      -1,   239,    -1,   240,    -1,   241,    -1,   242,    -1,   243,
      -1,   244,    -1,   245,    -1,   246,    -1,   250,    -1,   251,
      -1,   252,    -1,   253,    -1,   256,    -1,   257,    -1,   262,
      -1,   265,    -1,   269,    -1,   270,    -1,   273,    -1,   277,
      -1,   278,    -1,   279,    -1,   280,    -1,   281,    -1,   284,
      -1,   286,    -1,   285,    -1,   288,    -1,   289,    -1,   290,
      -1,   291,    -1,   292,    -1,   294,    -1,   296,    -1,   297,
      -1,   298,    -1,   299,    -1,   300,    -1,   301,    -1,   302,
      -1,   303,    -1,   304,    -1,   306,    -1,   308,    -1,   309,
      -1,   310,    -1,   311,    -1,   312,    -1,   315,    -1,   316,
      -1,   317,    -1,   319,    -1,   321,    -1,   322,    -1,   324,
      -1,   327,    -1,   328,    -1,   329,    -1,   330,    -1,   331,
      -1,   332,    -1,   333,    -1,   334,    -1,   336,    -1,   338,
      -1,   339,    -1,   340,    -1,   345,    -1,   347,    -1,   349,
      -1,   352,    -1,   353,    -1,   354,    -1,   355,    -1,   358,
      -1,   359,    -1,   360,    -1,   361,    -1,   362,    -1,   365,
      -1,   366,    -1,   367,    -1,   369,    -1,   371,    -1,   372,
      -1,   376,    -1,   377,    -1,   378,    -1,   379,    -1,   380,
      -1,   381,    -1,   103,    -1,   105,    -1,   116,    -1,   123,
      -1,   132,    -1,   147,    -1,   148,    -1,   174,    -1,   177,
      -1,   181,    -1,   215,    -1,   217,    -1,   248,    -1,   254,
      -1,   260,    -1,   261,    -1,   283,    -1,   293,    -1,   307,
      -1,   320,    -1,   325,    -1,   335,    -1,   342,    -1,   343,
      -1,   348,    -1,   350,    -1,   368,    -1,    98,    -1,   102,
      -1,   104,    -1,   137,    -1,   186,    -1,   188,    -1,   198,
      -1,   202,    -1,   208,    -1,   220,    -1,   221,    -1,   223,
      -1,   229,    -1,   231,    -1,   247,    -1,   258,    -1,   274,
      -1,   275,    -1,   305,    -1,   323,    -1,   370,    -1,    86,
      -1,    88,    -1,    89,    -1,    90,    -1,    91,    -1,    92,
      -1,    93,    -1,    94,    -1,   107,    -1,   112,    -1,   113,
      -1,   118,    -1,   124,    -1,   125,    -1,   129,    -1,   134,
      -1,   138,    -1,   139,    -1,   140,    -1,   141,    -1,   150,
      -1,   152,    -1,   158,    -1,   159,    -1,   160,    -1,   165,
      -1,   168,    -1,   170,    -1,   178,    -1,   182,    -1,   184,
      -1,   187,    -1,   192,    -1,   193,    -1,   195,    -1,   207,
      -1,   216,    -1,   218,    -1,   228,    -1,   232,    -1,   249,
      -1,   255,    -1,   259,    -1,   263,    -1,   264,    -1,   266,
      -1,   267,    -1,   268,    -1,   271,    -1,   272,    -1,   287,
      -1,   295,    -1,   314,    -1,   318,    -1,   326,    -1,   337,
      -1,   341,    -1,   344,    -1,   346,    -1,   351,    -1,   357,
      -1,   363,    -1,   364,    -1,   374,    -1,   375,    -1,   897,
      -1,   894,   414,   897,    -1,    47,    -1,    -1,   906,    -1,
     901,   900,    -1,   901,    -1,   901,   900,    -1,   901,    -1,
     901,    -1,    26,   901,    -1,    26,   755,    -1,   387,    -1,
     383,    -1,   386,    -1,   755,    -1,   788,    -1,   909,    -1,
     408,   409,    -1,   408,   905,   409,    -1,   904,    -1,   905,
     904,    -1,   907,    -1,   906,   414,   907,    -1,   905,    -1,
     412,   906,   413,    -1,   909,    -1,   408,    -1,   409,    -1,
     414,    -1,   411,    -1,   383,    -1,   386,    -1,   763,    -1,
     764,    -1,   767,    -1,   401,    -1,   399,    -1,   400,    -1,
     402,    -1,   403,    -1,   259,    -1,    54,    -1,    55,    -1,
      56,    -1,    57,    -1,    58,    -1,    59,    -1,    60,    -1,
      61,    -1,    62,    -1,    63,    -1,    64,    -1,    65,    -1,
      67,    -1,    66,    -1,    68,    -1,    69,    -1,    70,    -1,
      71,    -1,    72,    -1,    73,    -1,    74,    -1,    75,    -1,
      77,    -1,    76,    -1,     5,    -1,    20,    -1,   197,    -1,
     214,    -1,    29,    -1,   240,    -1,   243,    -1,   312,    -1,
      41,    -1,    42,    -1,    49,    -1,    50,    -1,   380,    -1,
     115,    -1,   181,    -1,   344,    -1,   356,    -1,   368,    -1,
     406,    -1,   407,    -1,   395,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   560,   560,   562,   563,   566,   567,   568,   574,   575,
     576,   577,   578,   581,   593,   594,   595,   596,   597,   598,
     599,   600,   601,   602,   624,   625,   626,   627,   628,   629,
     630,   631,   632,   633,   634,   635,   636,   637,   638,   639,
     640,   641,   642,   644,   645,   646,   647,   648,   649,   650,
     651,   652,   653,   654,   655,   656,   657,   659,   660,   661,
     662,   663,   664,   665,   666,   668,   669,   670,   671,   672,
     673,   674,   675,   676,   682,   683,   684,   685,   686,   687,
     688,   689,   690,   696,   706,   710,   718,   726,   730,   741,
     751,   755,   762,   769,   775,   782,   791,   792,   798,   807,
     816,   823,   844,   848,   849,   860,   862,   866,   868,   878,
     885,   886,   889,   891,   893,   895,   897,   899,   901,   903,
     907,   909,   919,   921,   928,   929,   932,   934,   945,   947,
     957,   968,   970,   974,   975,   978,   979,   986,   987,   988,
    1001,  1003,  1005,  1009,  1011,  1013,  1015,  1017,  1019,  1021,
    1023,  1027,  1029,  1033,  1035,  1039,  1040,  1043,  1044,  1045,
    1048,  1049,  1050,  1051,  1061,  1062,  1063,  1065,  1067,  1069,
    1073,  1074,  1075,  1078,  1079,  1082,  1084,  1086,  1088,  1090,
    1094,  1096,  1098,  1100,  1102,  1106,  1110,  1112,  1116,  1117,
    1123,  1135,  1138,  1141,  1144,  1147,  1150,  1153,  1156,  1159,
    1162,  1165,  1168,  1171,  1176,  1177,  1180,  1181,  1182,  1192,
    1206,  1211,  1212,  1220,  1221,  1222,  1225,  1226,  1229,  1230,
    1231,  1233,  1237,  1238,  1241,  1242,  1249,  1252,  1255,  1256,
    1266,  1269,  1279,  1280,  1281,  1282,  1283,  1284,  1285,  1289,
    1292,  1294,  1296,  1300,  1301,  1302,  1305,  1311,  1312,  1315,
    1317,  1318,  1332,  1334,  1336,  1338,  1340,  1342,  1344,  1359,
    1360,  1361,  1362,  1365,  1372,  1373,  1374,  1381,  1383,  1387,
    1389,  1391,  1393,  1398,  1399,  1402,  1404,  1408,  1411,  1413,
    1419,  1422,  1423,  1424,  1425,  1426,  1429,  1433,  1437,  1438,
    1439,  1440,  1441,  1444,  1447,  1450,  1451,  1452,  1455,  1456,
    1457,  1458,  1468,  1467,  1478,  1481,  1484,  1486,  1490,  1501,
    1505,  1509,  1510,  1513,  1515,  1517,  1519,  1521,  1523,  1525,
    1527,  1529,  1531,  1535,  1536,  1547,  1552,  1553,  1560,  1562,
    1566,  1569,  1572,  1576,  1577,  1588,  1593,  1601,  1602,  1605,
    1607,  1609,  1613,  1614,  1615,  1618,  1621,  1624,  1625,  1628,
    1629,  1632,  1634,  1637,  1640,  1641,  1644,  1645,  1648,  1649,
    1656,  1657,  1666,  1668,  1672,  1674,  1678,  1689,  1697,  1712,
    1714,  1716,  1718,  1722,  1726,  1730,  1731,  1734,  1735,  1739,
    1740,  1741,  1744,  1751,  1752,  1755,  1757,  1759,  1761,  1765,
    1766,  1769,  1770,  1773,  1785,  1789,  1790,  1791,  1792,  1793,
    1794,  1795,  1796,  1799,  1801,  1805,  1807,  1816,  1831,  1836,
    1841,  1846,  1851,  1856,  1861,  1866,  1871,  1873,  1877,  1878,
    1879,  1880,  1881,  1882,  1883,  1884,  1885,  1886,  1887,  1888,
    1889,  1890,  1893,  1896,  1897,  1912,  1914,  1916,  1918,  1920,
    1922,  1924,  1928,  1929,  1930,  1931,  1932,  1933,  1934,  1935,
    1936,  1939,  1940,  1950,  1954,  1961,  1962,  1963,  1966,  1968,
    1972,  1973,  1974,  1975,  1976,  1977,  1978,  1979,  1980,  1981,
    1982,  1983,  1986,  1988,  1990,  1992,  1994,  1996,  2000,  2002,
    2006,  2007,  2010,  2015,  2018,  2023,  2026,  2028,  2032,  2043,
    2048,  2049,  2052,  2055,  2058,  2059,  2062,  2064,  2066,  2070,
    2071,  2072,  2075,  2080,  2081,  2084,  2086,  2090,  2092,  2096,
    2104,  2107,  2108,  2114,  2122,  2124,  2128,  2138,  2140,  2145,
    2147,  2151,  2153,  2155,  2157,  2159,  2161,  2163,  2165,  2167,
    2169,  2171,  2173,  2177,  2178,  2191,  2195,  2199,  2200,  2204,
    2208,  2210,  2212,  2214,  2219,  2221,  2225,  2228,  2233,  2234,
    2238,  2249,  2251,  2255,  2256,  2259,  2260,  2271,  2273,  2275,
    2277,  2279,  2281,  2283,  2285,  2287,  2289,  2291,  2295,  2296,
    2299,  2300,  2311,  2310,  2320,  2321,  2322,  2326,  2328,  2332,
    2333,  2334,  2335,  2336,  2339,  2340,  2344,  2345,  2346,  2347,
    2350,  2351,  2354,  2366,  2370,  2374,  2376,  2389,  2390,  2391,
    2392,  2393,  2394,  2397,  2398,  2399,  2403,  2405,  2407,  2409,
    2414,  2415,  2419,  2420,  2430,  2442,  2454,  2456,  2460,  2462,
    2466,  2468,  2470,  2472,  2474,  2476,  2478,  2480,  2484,  2485,
    2496,  2498,  2509,  2520,  2527,  2529,  2531,  2533,  2535,  2537,
    2541,  2542,  2546,  2560,  2562,  2564,  2577,  2579,  2581,  2585,
    2587,  2591,  2592,  2595,  2596,  2599,  2600,  2603,  2604,  2607,
    2610,  2621,  2626,  2627,  2628,  2629,  2630,  2634,  2635,  2684,
    2688,  2690,  2692,  2694,  2696,  2700,  2702,  2706,  2718,  2722,
    2726,  2729,  2732,  2733,  2734,  2735,  2736,  2737,  2738,  2739,
    2749,  2763,  2796,  2797,  2798,  2799,  2800,  2803,  2807,  2808,
    2818,  2820,  2824,  2826,  2830,  2832,  2834,  2836,  2840,  2841,
    2844,  2848,  2850,  2852,  2856,  2861,  2862,  2872,  2874,  2876,
    2878,  2880,  2882,  2884,  2886,  2890,  2891,  2894,  2895,  2898,
    2900,  2902,  2905,  2908,  2909,  2912,  2916,  2917,  2920,  2922,
    2924,  2926,  2930,  2932,  2934,  2936,  2938,  2942,  2943,  2946,
    2947,  2950,  2960,  2963,  2966,  2969,  2972,  2974,  2978,  2979,
    2982,  2983,  2994,  2995,  2998,  2999,  3009,  3011,  3013,  3015,
    3017,  3019,  3021,  3023,  3025,  3027,  3029,  3050,  3052,  3054,
    3056,  3058,  3060,  3062,  3066,  3068,  3070,  3072,  3076,  3077,
    3078,  3079,  3083,  3084,  3094,  3096,  3100,  3102,  3104,  3106,
    3110,  3112,  3116,  3117,  3120,  3122,  3126,  3139,  3141,  3143,
    3145,  3150,  3156,  3163,  3170,  3171,  3172,  3173,  3174,  3175,
    3176,  3177,  3178,  3181,  3182,  3183,  3184,  3185,  3186,  3188,
    3190,  3194,  3195,  3196,  3197,  3198,  3201,  3209,  3211,  3213,
    3215,  3217,  3219,  3221,  3223,  3225,  3227,  3229,  3233,  3236,
    3239,  3241,  3244,  3247,  3249,  3252,  3260,  3261,  3264,  3265,
    3268,  3272,  3281,  3282,  3285,  3286,  3289,  3293,  3297,  3299,
    3301,  3303,  3305,  3307,  3311,  3314,  3317,  3320,  3323,  3325,
    3327,  3329,  3333,  3337,  3339,  3342,  3345,  3346,  3347,  3348,
    3349,  3350,  3351,  3352,  3353,  3354,  3355,  3356,  3357,  3358,
    3372,  3374,  3376,  3378,  3380,  3382,  3384,  3386,  3388,  3392,
    3394,  3396,  3398,  3402,  3406,  3407,  3408,  3411,  3412,  3415,
    3416,  3417,  3418,  3419,  3420,  3421,  3422,  3423,  3426,  3427,
    3430,  3431,  3450,  3452,  3454,  3465,  3467,  3469,  3471,  3473,
    3475,  3477,  3479,  3481,  3483,  3485,  3487,  3489,  3491,  3493,
    3495,  3497,  3499,  3501,  3503,  3505,  3507,  3509,  3511,  3513,
    3515,  3517,  3519,  3521,  3523,  3525,  3527,  3529,  3531,  3533,
    3535,  3537,  3548,  3550,  3552,  3554,  3556,  3558,  3560,  3562,
    3564,  3566,  3568,  3570,  3572,  3574,  3576,  3578,  3580,  3592,
    3594,  3596,  3598,  3600,  3602,  3604,  3606,  3608,  3610,  3612,
    3614,  3616,  3618,  3620,  3622,  3624,  3626,  3628,  3630,  3632,
    3634,  3646,  3648,  3650,  3652,  3654,  3656,  3658,  3660,  3662,
    3664,  3666,  3668,  3670,  3672,  3674,  3676,  3678,  3680,  3682,
    3684,  3686,  3688,  3690,  3692,  3694,  3697,  3699,  3701,  3703,
    3705,  3707,  3709,  3711,  3713,  3715,  3722,  3724,  3727,  3730,
    3732,  3736,  3739,  3742,  3744,  3748,  3749,  3753,  3754,  3760,
    3761,  3762,  3763,  3764,  3765,  3766,  3767,  3771,  3773,  3778,
    3782,  3785,  3788,  3790,  3792,  3794,  3796,  3799,  3802,  3806,
    3810,  3812,  3814,  3818,  3820,  3839,  3841,  3843,  3847,  3849,
    3853,  3857,  3860,  3863,  3864,  3867,  3869,  3873,  3877,  3879,
    3881,  3885,  3886,  3897,  3899,  3904,  3906,  3908,  3913,  3915,
    3939,  3943,  3952,  3963,  3971,  3981,  3983,  3987,  3989,  3993,
    3994,  4004,  4005,  4008,  4010,  4014,  4016,  4020,  4022,  4027,
    4028,  4029,  4030,  4031,  4033,  4043,  4045,  4053,  4055,  4057,
    4059,  4061,  4063,  4065,  4067,  4069,  4073,  4074,  4075,  4076,
    4077,  4088,  4089,  4092,  4093,  4096,  4097,  4100,  4101,  4102,
    4105,  4106,  4107,  4108,  4109,  4112,  4113,  4116,  4117,  4118,
    4119,  4120,  4121,  4124,  4126,  4133,  4149,  4151,  4154,  4156,
    4160,  4172,  4197,  4220,  4238,  4250,  4251,  4254,  4255,  4256,
    4259,  4260,  4263,  4264,  4267,  4268,  4271,  4273,  4275,  4277,
    4281,  4288,  4311,  4337,  4350,  4357,  4400,  4402,  4409,  4411,
    4412,  4417,  4415,  4430,  4429,  4442,  4448,  4450,  4451,  4454,
    4455,  4456,  4457,  4458,  4461,  4462,  4470,  4556,  4594,  4593,
    4603,  4605,  4607,  4608,  4611,  4612,  4613,  4614,  4617,  4618,
    4622,  4621,  4685,  4683,  4698,  4697,  4710,  4716,  4720,  4724,
    4730,  4731,  4732,  4733,  4736,  4737,  4740,  4748,  4765,  4773,
    4798,  4799,  4893,  4927,  4929,  4931,  4935,  4939,  4938,  4992,
    4994,  4993,  5008,  5014,  5021,  5026,  5029,  5030,  5033,  5034,
    5035,  5036,  5037,  5038,  5039,  5047,  5055,  5058,  5059,  5060,
    5061,  5062,  5063,  5071,  5079,  5080,  5083,  5084,  5087,  5089,
    5093,  5163,  5164,  5171,  5172,  5173,  5179,  5188,  5191,  5192,
    5193,  5194,  5197,  5198,  5204,  5218,  5217,  5235,  5236,  5237,
    5238,  5239,  5242,  5244,  5248,  5249,  5256,  5261,  5263,  5264,
    5267,  5270,  5277,  5284,  5284,  5286,  5287,  5290,  5291,  5294,
    5294,  5296,  5306,  5315,  5321,  5327,  5333,  5341,  5342,  5353,
    5363,  5373,  5377,  5380,  5382,  5383,  5384,  5385,  5386,  5387,
    5388,  5389,  5390,  5391,  5392,  5393,  5394,  5395,  5396,  5399,
    5400,  5403,  5404,  5407,  5412,  5414,  5423,  5442,  5443,  5446,
    5447,  5454,  5455,  5456,  5463,  5462,  5524,  5525,  5532,  5531,
    5600,  5606,  5612,  5620,  5626,  5632,  5638,  5644,  5650,  5656,
    5662,  5668,  5679,  5680,  5683,  5684,  5685,  5686,  5687,  5688,
    5689,  5690,  5691,  5692,  5693,  5694,  5695,  5696,  5697,  5698,
    5699,  5700,  5701,  5702,  5703,  5704,  5705,  5706,  5707,  5708,
    5709,  5712,  5713,  5714,  5715,  5716,  5717,  5721,  5722,  5723,
    5724,  5725,  5726,  5727,  5730,  5746,  5747,  5748,  5749,  5750,
    5751,  5756,  5757,  5758,  5759,  5760,  5765,  5766,  5767,  5768,
    5769,  5775,  5776,  5777,  5778,  5779,  5780,  5781,  5784,  5785,
    5786,  5787,  5790,  5791,  5792,  5793,  5796,  5797,  5798,  5799,
    5800,  5801,  5802,  5817,  5818,  5819,  5820,  5821,  5822,  5823,
    5824,  5825,  5826,  5827,  5828,  5829,  5830,  5831,  5832,  5833,
    5834,  5835,  5836,  5837,  5838,  5839,  5840,  5841,  5842,  5843,
    5844,  5845,  5846,  5847,  5848,  5849,  5850,  5851,  5852,  5853,
    5854,  5855,  5856,  5857,  5858,  5859,  5860,  5861,  5862,  5863,
    5864,  5865,  5866,  5867,  5868,  5869,  5870,  5871,  5872,  5873,
    5874,  5875,  5876,  5877,  5878,  5879,  5880,  5881,  5882,  5883,
    5884,  5885,  5886,  5887,  5888,  5889,  5890,  5891,  5892,  5893,
    5894,  5895,  5896,  5897,  5898,  5899,  5900,  5901,  5902,  5903,
    5904,  5905,  5906,  5907,  5908,  5909,  5910,  5911,  5912,  5913,
    5914,  5915,  5916,  5917,  5918,  5919,  5920,  5921,  5922,  5923,
    5924,  5925,  5926,  5927,  5928,  5929,  5930,  5931,  5932,  5933,
    5934,  5935,  5936,  5937,  5938,  5939,  5940,  5941,  5942,  5943,
    5944,  5945,  5946,  5947,  5948,  5949,  5950,  5951,  5952,  5953,
    5954,  5955,  5956,  5957,  5958,  5959,  5960,  5961,  5962,  5963,
    5964,  5965,  5966,  5967,  5968,  5969,  5970,  5971,  5972,  5973,
    5974,  5975,  5976,  5977,  5978,  5979,  5980,  5981,  5982,  5983,
    5984,  5985,  5986,  5987,  5988,  5989,  5990,  5991,  5992,  6006,
    6007,  6011,  6012,  6013,  6014,  6015,  6016,  6017,  6018,  6022,
    6023,  6024,  6025,  6026,  6027,  6028,  6029,  6030,  6031,  6032,
    6033,  6034,  6035,  6036,  6037,  6038,  6052,  6053,  6054,  6055,
    6056,  6057,  6058,  6059,  6060,  6061,  6062,  6063,  6064,  6065,
    6066,  6067,  6068,  6069,  6070,  6071,  6072,  6082,  6083,  6084,
    6085,  6086,  6087,  6088,  6089,  6090,  6091,  6092,  6093,  6094,
    6095,  6096,  6097,  6098,  6099,  6100,  6101,  6102,  6103,  6104,
    6105,  6106,  6107,  6108,  6109,  6110,  6111,  6112,  6113,  6114,
    6115,  6116,  6117,  6118,  6119,  6120,  6121,  6122,  6123,  6124,
    6125,  6126,  6127,  6128,  6129,  6130,  6131,  6132,  6133,  6134,
    6135,  6136,  6137,  6138,  6139,  6140,  6141,  6145,  6146,  6147,
    6148,  6149,  6153,  6153,  6156,  6159,  6160,  6163,  6165,  6170,
    6180,  6187,  6188,  6189,  6192,  6222,  6223,  6226,  6228,  6236,
    6237,  6238,  6242,  6243,  6247,  6248,  6251,  6252,  6255,  6256,
    6257,  6258,  6259,  6262,  6263,  6264,  6265,  6266,  6267,  6268,
    6269,  6270,  6271,  6272,  6273,  6274,  6275,  6276,  6277,  6278,
    6279,  6280,  6281,  6282,  6283,  6284,  6285,  6286,  6287,  6288,
    6289,  6290,  6291,  6292,  6293,  6294,  6295,  6296,  6297,  6298,
    6299,  6300,  6301,  6302,  6303,  6304,  6305,  6306,  6307,  6308,
    6309,  6310,  6311,  6312,  6313,  6314,  6315,  6316,  6317
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_CONNECTION", "SQL_CONTINUE", "SQL_COUNT", "SQL_CURRENT", 
  "SQL_DATA", "SQL_DATETIME_INTERVAL_CODE", 
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR", 
  "SQL_DISCONNECT", "SQL_ENUM", "SQL_FOUND", "SQL_FREE", "SQL_GO", 
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER", 
  "SQL_LENGTH", "SQL_LONG", "SQL_NAME", "SQL_NULLABLE", 
  "SQL_OCTET_LENGTH", "SQL_OPEN", "SQL_OUTPUT", "SQL_RELEASE", 
  "SQL_REFERENCE", "SQL_RETURNED_LENGTH", "SQL_RETURNED_OCTET_LENGTH", 
  "SQL_SCALE", "SQL_SECTION", "SQL_SHORT", "SQL_SIGNED", "SQL_SQL", 
  "SQL_SQLERROR", "SQL_SQLPRINT", "SQL_SQLWARNING", "SQL_START", 
  "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED", "SQL_VALUE", "SQL_VAR", 
  "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO", "S_CONST", 
  "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN", "S_INC", 
  "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL", "S_NEQUAL", 
  "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB", "S_VOLATILE", 
  "S_TYPEDEF", "TYPECAST", "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION", 
  "ADD", "AFTER", "AGGREGATE", "ALL", "ALTER", "ANALYSE", "ANALYZE", 
  "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION", "ASSIGNMENT", "AT", 
  "AUTHORIZATION", "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", 
  "BINARY", "BIT", "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", 
  "CASCADE", "CASE", "CAST", "CHAIN", "CHAR_P", "CHARACTER", 
  "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER", 
  "COALESCE", "COLLATE", "COLUMN", "COMMENT", "COMMIT", "COMMITTED", 
  "CONSTRAINT", "CONSTRAINTS", "CONVERSION_P", "CONVERT", "COPY", 
  "CREATE", "CREATEDB", "CREATEUSER", "CROSS", "CURRENT_DATE", 
  "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", 
  "DATABASE", "DAY_P", "DEALLOCATE", "DEC", "DECIMAL_P", "DECLARE", 
  "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED", "DEFINER", "DELETE_P", 
  "DELIMITER", "DELIMITERS", "DESC", "DISTINCT", "DO", "DOMAIN_P", 
  "DOUBLE_P", "DROP", "EACH", "ELSE", "ENCODING", "ENCRYPTED", "END_P", 
  "ESCAPE", "EXCEPT", "EXCLUSIVE", "EXCLUDING", "EXECUTE", "EXISTS", 
  "EXPLAIN", "EXTERNAL", "EXTRACT", "FALSE_P", "FETCH", "FIRST_P", 
  "FLOAT_P", "FOR", "FORCE", "FOREIGN", "FORWARD", "FREEZE", "FROM", 
  "FULL", "FUNCTION", "GET", "GLOBAL", "GRANT", "GROUP_P", "HANDLER", 
  "HAVING", "HOLD", "HOUR_P", "ILIKE", "IMMEDIATE", "IMMUTABLE", 
  "IMPLICIT_P", "IN_P", "INCLUDING", "INCREMENT", "INDEX", "INHERITS", 
  "INITIALLY", "INNER_P", "INOUT", "INPUT_P", "INSENSITIVE", "INSERT", 
  "INSTEAD", "INT_P", "INTEGER", "INTERSECT", "INTERVAL", "INTO", 
  "INVOKER", "IS", "ISNULL", "ISOLATION", "JOIN", "KEY", "LANCOMPILER", 
  "LANGUAGE", "LAST_P", "LEADING", "LEFT", "LEVEL", "LIKE", "LIMIT", 
  "LISTEN", "LOAD", "LOCAL", "LOCATION", "LOCK_P", "MATCH", "MAXVALUE", 
  "MINUTE_P", "MINVALUE", "MODE", "MONTH_P", "MOVE", "NAMES", "NATIONAL", 
  "NATURAL", "NCHAR", "NEW", "NEXT", "NO", "NOCREATEDB", "NOCREATEUSER", 
  "NONE", "NOT", "NOTHING", "NOTIFY", "NOTNULL", "NULL_P", "NULLIF", 
  "NUMERIC", "OF", "OFF", "OFFSET", "OIDS", "OLD", "ON", "ONLY", 
  "OPERATOR", "OPTION", "OR", "ORDER", "OUT_P", "OUTER_P", "OVERLAPS", 
  "OVERLAY", "OWNER", "PARTIAL", "PASSWORD", "PATH_P", "PENDANT", 
  "PLACING", "POSITION", "PRECISION", "PRESERVE", "PREPARE", "PRIMARY", 
  "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE", "READ", "REAL", 
  "RECHECK", "REFERENCES", "REINDEX", "RELATIVE_P", "RENAME", "REPLACE", 
  "RESET", "RESTART", "RESTRICT", "RETURNS", "REVOKE", "RIGHT", 
  "ROLLBACK", "ROW", "ROWS", "RULE", "SCHEMA", "SCROLL", "SECOND_P", 
  "SECURITY", "SELECT", "SEQUENCE", "SERIALIZABLE", "SESSION", 
  "SESSION_USER", "SET", "SETOF", "SHARE", "SHOW", "SIMILAR", "SIMPLE", 
  "SMALLINT", "SOME", "STABLE", "START", "STATEMENT", "STATISTICS", 
  "STDIN", "STDOUT", "STORAGE", "STRICT_P", "SUBSTRING", "SYSID", "TABLE", 
  "TEMP", "TEMPLATE", "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TO", 
  "TOAST", "TRAILING", "TRANSACTION", "TREAT", "TRIGGER", "TRIM", 
  "TRUE_P", "TRUNCATE", "TRUSTED", "TYPE_P", "UNENCRYPTED", "UNION", 
  "UNIQUE", "UNKNOWN", "UNLISTEN", "UNTIL", "UPDATE", "USAGE", "USER", 
  "USING", "VACUUM", "VALID", "VALUES", "VARCHAR", "VARYING", "VERBOSE", 
  "VERSION", "VIEW", "VOLATILE", "WHEN", "WHERE", "WITH", "WITHOUT", 
  "WORK", "WRITE", "YEAR_P", "ZONE", "UNIONJOIN", "IDENT", "SCONST", "Op", 
  "CSTRING", "CVARIABLE", "CPP_LINE", "IP", "BCONST", "XCONST", "ICONST", 
  "PARAM", "FCONST", "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", 
  "'*'", "'/'", "'%'", "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", 
  "';'", "'{'", "'}'", "','", "\"=\"", "':'", "$accept", "prog", 
  "statements", "statement", "opt_at", "stmt", "CreateUserStmt", 
  "opt_with", "AlterUserStmt", "AlterUserSetStmt", "DropUserStmt", 
  "OptUserList", "OptUserElem", "user_list", "CreateGroupStmt", 
  "OptGroupList", "OptGroupElem", "AlterGroupStmt", "DropGroupStmt", 
  "CreateSchemaStmt", "OptSchemaName", "OptSchemaEltList", "schema_stmt", 
  "VariableSetStmt", "set_rest", "var_list_or_default", "var_list", 
  "iso_level", "var_value", "opt_boolean", "zone_value", "opt_encoding", 
  "ColId_or_Sconst", "VariableShowStmt", "VariableResetStmt", 
  "ConstraintsSetStmt", "constraints_set_list", "constraints_set_mode", 
  "CheckPointStmt", "AlterTableStmt", "alter_column_default", 
  "opt_drop_behavior", "ClosePortalStmt", "CopyStmt", "copy_from", 
  "copy_file_name", "copy_opt_list", "copy_opt_item", "opt_binary", 
  "opt_oids", "copy_delimiter", "opt_using", "CreateStmt", "OptTemp", 
  "OptTableElementList", "TableElementList", "TableElement", "columnDef", 
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr", 
  "TableLikeClause", "like_including_defaults", "TableConstraint", 
  "ConstraintElem", "opt_column_list", "columnList", "columnElem", 
  "key_match", "key_actions", "key_delete", "key_update", "key_action", 
  "OptInherit", "OptWithOids", "OnCommitOption", "CreateAsStmt", "@1", 
  "OptCreateAs", "CreateAsList", "CreateAsElement", "CreateSeqStmt", 
  "AlterSeqStmt", "OptSeqList", "OptSeqElem", "opt_by", "CreatePLangStmt", 
  "opt_Trusted", "handler_name", "opt_lancompiler", "DropPLangStmt", 
  "opt_procedural", "CreateTrigStmt", "TriggerActionTime", 
  "TriggerEvents", "TriggerOneEvent", "TriggerForSpec", "TriggerForOpt", 
  "TriggerForType", "TriggerFuncArgs", "TriggerFuncArg", 
  "OptConstrFromTable", "ConstraintAttributeSpec", 
  "ConstraintDeferrabilitySpec", "ConstraintTimeSpec", "DropTrigStmt", 
  "CreateAssertStmt", "DropAssertStmt", "DefineStmt", "rowdefinition", 
  "definition", "def_list", "def_elem", "def_arg", "CreateOpClassStmt", 
  "opclass_item_list", "opclass_item", "opt_default", "opt_recheck", 
  "DropOpClassStmt", "DropStmt", "drop_type", "any_name_list", "any_name", 
  "TruncateStmt", "FetchStmt", "fetch_direction", "fetch_count", 
  "from_in", "CommentStmt", "comment_type", "comment_text", "GrantStmt", 
  "RevokeStmt", "privileges", "privilege_list", "privilege", 
  "privilege_target", "grantee_list", "grantee", "opt_grant_grant_option", 
  "opt_revoke_grant_option", "function_with_argtypes_list", 
  "function_with_argtypes", "IndexStmt", "index_opt_unique", 
  "access_method_clause", "index_params", "index_elem", "opt_class", 
  "CreateFunctionStmt", "opt_or_replace", "func_args", "func_args_list", 
  "func_arg", "opt_arg", "func_as", "func_return", "func_type", 
  "createfunc_opt_list", "createfunc_opt_item", "opt_definition", 
  "RemoveFuncStmt", "RemoveAggrStmt", "aggr_argtype", "RemoveOperStmt", 
  "oper_argtypes", "any_operator", "CreateCastStmt", "cast_context", 
  "DropCastStmt", "ReindexStmt", "reindex_type", "opt_force", 
  "RenameStmt", "opt_name", "opt_column", "RuleStmt", "@2", 
  "RuleActionList", "RuleActionMulti", "RuleActionStmt", 
  "RuleActionStmtOrEmpty", "event", "opt_instead", "DropRuleStmt", 
  "NotifyStmt", "ListenStmt", "UnlistenStmt", "TransactionStmt", 
  "opt_transaction", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "transaction_access_mode", "ViewStmt", 
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", 
  "opt_equal", "AlterDatabaseSetStmt", "DropdbStmt", "CreateDomainStmt", 
  "AlterDomainStmt", "opt_as", "CreateConversionStmt", "ClusterStmt", 
  "VacuumStmt", "AnalyzeStmt", "analyze_keyword", "opt_verbose", 
  "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt", 
  "ExplainableStmt", "opt_analyze", "InsertStmt", "insert_rest", 
  "insert_column_list", "insert_column_item", "DeleteStmt", "LockStmt", 
  "opt_lock", "lock_type", "UpdateStmt", "DeclareCursorStmt", 
  "cursor_options", "opt_hold", "SelectStmt", "select_with_parens", 
  "select_no_parens", "select_clause", "simple_select", "into_clause", 
  "OptTempTableName", "opt_table", "opt_all", "opt_distinct", 
  "opt_sort_clause", "sort_clause", "sortby_list", "sortby", 
  "select_limit", "opt_select_limit", "select_limit_value", 
  "select_offset_value", "group_clause", "having_clause", 
  "for_update_clause", "opt_for_update_clause", "update_list", 
  "from_clause", "from_list", "table_ref", "joined_table", "alias_clause", 
  "join_type", "join_outer", "join_qual", "relation_expr", "func_table", 
  "where_clause", "TableFuncElementList", "TableFuncElement", "Typename", 
  "opt_array_bounds", "Iresult", "SimpleTypename", "ConstTypename", 
  "GenericType", "Numeric", "opt_float", "opt_numeric", "opt_decimal", 
  "Bit", "ConstBit", "BitWithLength", "BitWithoutLength", "Character", 
  "ConstCharacter", "CharacterWithLength", "CharacterWithoutLength", 
  "character", "opt_varying", "opt_charset", "ConstDatetime", 
  "ConstInterval", "opt_timezone", "opt_interval", "r_expr", "row", 
  "row_descriptor", "sub_type", "all_Op", "MathOp", "qual_Op", 
  "qual_all_Op", "a_expr", "b_expr", "c_expr", "opt_indirection", 
  "expr_list", "extract_list", "type_list", "array_expr_list", 
  "array_expr", "extract_arg", "overlay_list", "overlay_placing", 
  "position_list", "substr_list", "substr_from", "substr_for", 
  "trim_list", "in_expr", "case_expr", "when_clause_list", "when_clause", 
  "case_default", "case_arg", "columnref", "dotted_name", "attrs", 
  "opt_empty_parentheses", "target_list", "target_el", 
  "update_target_list", "inf_col_list", "inf_val_list", 
  "update_target_el", "insert_target_list", "insert_target_el", 
  "relation_name", "qualified_name_list", "qualified_name", "name_list", 
  "name", "database_name", "access_method", "attr_name", "index_name", 
  "file_name", "func_name", "AexprConst", "Iconst", "Fconst", "Bconst", 
  "Xconst", "Sconst", "PosIntConst", "IntConst", "StringConst", 
  "PosIntStringConst", "NumConst", "AllConst", "PosAllConst", "UserId", 
  "SpecialRuleRelation", "ECPGConnect", "connection_target", "db_prefix", 
  "server", "opt_server", "server_name", "opt_port", 
  "opt_connection_name", "opt_user", "ora_user", "user_name", 
  "char_variable", "opt_options", "ECPGCursorStmt", "ECPGDeallocate", 
  "ECPGVarDeclaration", "single_vt_declaration", "single_var_declaration", 
  "@3", "@4", "precision", "opt_scale", "ecpg_interval", "single_vt_type", 
  "ECPGDeclaration", "@5", "sql_startdeclare", "sql_enddeclare", 
  "var_type_declarations", "vt_declarations", "variable_declarations", 
  "type_declaration", "@6", "var_declaration", "@7", "@8", 
  "storage_declaration", "storage_clause", "storage_modifier", 
  "common_type", "var_type", "enum_type", "enum_definition", 
  "struct_union_type_with_symbol", "@9", "struct_union_type", "@10", 
  "s_struct_union_symbol", "s_struct_union", "simple_type", 
  "unsigned_type", "signed_type", "opt_signed", "variable_list", 
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare", 
  "ECPGDisconnect", "dis_name", "connection_object", "ECPGExecute", "@11", 
  "execute_rest", "execstring", "prepared_name", "ECPGFree", "ECPGOpen", 
  "opt_ecpg_using", "ecpg_using", "using_descriptor", "into_descriptor", 
  "opt_sql", "ecpg_into_using", "ecpg_into", "using_list", "UsingConst", 
  "ECPGPrepare", "ECPGDescribe", "opt_output", "ECPGDeallocateDescr", 
  "ECPGAllocateDescr", "ECPGGetDescHeaderItem", "desc_header_item", 
  "ECPGGetDescItem", "descriptor_item", "ECPGGetDescHeaderItems", 
  "ECPGGetDescItems", "ECPGGetDescriptorHeader", "ECPGGetDescriptor", 
  "ECPGRelease", "ECPGSetAutocommit", "on_off", "ECPGSetConnection", 
  "ECPGTypedef", "@12", "opt_reference", "ECPGVar", "@13", "ECPGWhenever", 
  "action", "ECPGKeywords", "ECPGKeywords_vanames", "ECPGKeywords_rest", 
  "ECPGTypeName", "symbol", "ColId", "type_name", "function_name", 
  "ColLabel", "ECPGColLabelCommon", "ECPGColLabel", "ECPGCKeywords", 
  "unreserved_keyword", "col_name_keyword", "func_name_keyword", 
  "reserved_keyword", "into_list", "ecpgstart", "c_args", 
  "coutputvariable", "civarind", "civar", "indicator", "cvariable", 
  "ident", "quoted_ident_stringvar", "c_stuff_item", "c_stuff", "c_list", 
  "c_term", "c_thing", "c_anything", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,    61,    60,    62,   650,    43,
      45,    42,    47,    37,    94,   651,    91,    93,    40,    41,
      46,    59,   123,   125,    44,   652,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   417,   418,   419,   419,   420,   420,   420,   420,   420,
     420,   420,   420,   421,   422,   422,   422,   422,   422,   422,
     422,   422,   422,   422,   422,   422,   422,   422,   422,   422,
     422,   422,   422,   422,   422,   422,   422,   422,   422,   422,
     422,   422,   422,   422,   422,   422,   422,   422,   422,   422,
     422,   422,   422,   422,   422,   422,   422,   422,   422,   422,
     422,   422,   422,   422,   422,   422,   422,   422,   422,   422,
     422,   422,   422,   422,   422,   422,   422,   422,   422,   422,
     422,   422,   422,   422,   422,   422,   422,   422,   422,   422,
     422,   422,   422,   422,   422,   422,   422,   422,   422,   422,
     422,   422,   423,   424,   424,   425,   425,   426,   426,   427,
     428,   428,   429,   429,   429,   429,   429,   429,   429,   429,
     430,   430,   431,   431,   432,   432,   433,   433,   434,   434,
     435,   436,   436,   437,   437,   438,   438,   439,   439,   439,
     440,   440,   440,   441,   441,   441,   441,   441,   441,   441,
     441,   442,   442,   443,   443,   444,   444,   445,   445,   445,
     446,   446,   446,   446,   447,   447,   447,   447,   447,   447,
     448,   448,   448,   449,   449,   450,   450,   450,   450,   450,
     451,   451,   451,   451,   451,   452,   453,   453,   454,   454,
     455,   456,   456,   456,   456,   456,   456,   456,   456,   456,
     456,   456,   456,   456,   457,   457,   458,   458,   458,   459,
     460,   461,   461,   462,   462,   462,   463,   463,   464,   464,
     464,   464,   465,   465,   466,   466,   467,   467,   468,   468,
     469,   469,   470,   470,   470,   470,   470,   470,   470,   471,
     471,   472,   472,   473,   473,   473,   474,   475,   475,   476,
     476,   476,   477,   477,   477,   477,   477,   477,   477,   478,
     478,   478,   478,   479,   480,   480,   480,   481,   481,   482,
     482,   482,   482,   483,   483,   484,   484,   485,   486,   486,
     486,   487,   487,   487,   487,   487,   488,   489,   490,   490,
     490,   490,   490,   491,   491,   492,   492,   492,   493,   493,
     493,   493,   495,   494,   496,   496,   497,   497,   498,   499,
     500,   501,   501,   502,   502,   502,   502,   502,   502,   502,
     502,   502,   502,   503,   503,   504,   505,   505,   506,   506,
     507,   507,   508,   509,   509,   510,   510,   511,   511,   512,
     512,   512,   513,   513,   513,   514,   514,   515,   515,   516,
     516,   517,   517,   517,   518,   518,   519,   519,   520,   520,
     520,   520,   521,   521,   522,   522,   523,   524,   525,   526,
     526,   526,   526,   527,   528,   529,   529,   530,   530,   531,
     531,   531,   532,   533,   533,   534,   534,   534,   534,   535,
     535,   536,   536,   537,   538,   539,   539,   539,   539,   539,
     539,   539,   539,   540,   540,   541,   541,   542,   543,   543,
     543,   543,   543,   543,   543,   543,   543,   543,   544,   544,
     544,   544,   544,   544,   544,   544,   544,   544,   544,   544,
     544,   544,   545,   546,   546,   547,   547,   547,   547,   547,
     547,   547,   548,   548,   548,   548,   548,   548,   548,   548,
     548,   549,   549,   550,   551,   552,   552,   552,   553,   553,
     554,   554,   554,   554,   554,   554,   554,   554,   554,   554,
     554,   554,   555,   555,   555,   555,   555,   555,   556,   556,
     557,   557,   558,   558,   559,   559,   560,   560,   561,   562,
     563,   563,   564,   564,   565,   565,   566,   566,   566,   567,
     567,   567,   568,   569,   569,   570,   570,   571,   571,   572,
     572,   573,   573,   573,   574,   574,   575,   576,   576,   577,
     577,   578,   578,   578,   578,   578,   578,   578,   578,   578,
     578,   578,   578,   579,   579,   580,   581,   582,   582,   583,
     584,   584,   584,   584,   585,   585,   586,   586,   587,   587,
     588,   589,   589,   590,   590,   591,   591,   592,   592,   592,
     592,   592,   592,   592,   592,   592,   592,   592,   593,   593,
     594,   594,   596,   595,   597,   597,   597,   598,   598,   599,
     599,   599,   599,   599,   600,   600,   601,   601,   601,   601,
     602,   602,   603,   604,   605,   606,   606,   607,   607,   607,
     607,   607,   607,   608,   608,   608,   609,   609,   609,   609,
     610,   610,   611,   611,   612,   613,   614,   614,   615,   615,
     616,   616,   616,   616,   616,   616,   616,   616,   617,   617,
     618,   618,   619,   620,   621,   621,   621,   621,   621,   621,
     622,   622,   623,   624,   624,   624,   625,   625,   625,   626,
     626,   627,   627,   628,   628,   629,   629,   630,   630,   631,
     631,   632,   633,   633,   633,   633,   633,   634,   634,   635,
     636,   636,   636,   636,   636,   637,   637,   638,   639,   640,
     641,   641,   642,   642,   642,   642,   642,   642,   642,   642,
     643,   644,   645,   645,   645,   645,   645,   646,   646,   646,
     647,   647,   648,   648,   649,   649,   649,   649,   650,   650,
     651,   651,   651,   651,   652,   652,   652,   653,   653,   653,
     653,   653,   653,   653,   653,   654,   654,   655,   655,   656,
     656,   656,   656,   657,   657,   658,   659,   659,   660,   660,
     660,   660,   661,   661,   661,   661,   661,   662,   662,   663,
     663,   664,   665,   665,   666,   666,   667,   667,   668,   668,
     669,   669,   670,   670,   671,   671,   672,   672,   672,   672,
     672,   672,   672,   672,   672,   672,   672,   673,   673,   673,
     673,   673,   673,   673,   674,   674,   674,   674,   675,   675,
     675,   675,   676,   676,   677,   677,   678,   678,   678,   678,
     679,   679,   680,   680,   681,   681,   682,   683,   683,   683,
     683,   684,   684,   684,   685,   685,   685,   685,   685,   685,
     685,   685,   685,   686,   686,   686,   686,   686,   686,   686,
     686,   687,   687,   687,   687,   687,   688,   689,   689,   689,
     689,   689,   689,   689,   689,   689,   689,   689,   690,   690,
     691,   691,   691,   692,   692,   692,   693,   693,   694,   694,
     695,   696,   697,   697,   698,   698,   699,   700,   701,   701,
     701,   701,   701,   701,   702,   702,   703,   703,   704,   704,
     704,   704,   705,   706,   706,   706,   707,   707,   707,   707,
     707,   707,   707,   707,   707,   707,   707,   707,   707,   707,
     708,   708,   708,   708,   708,   708,   708,   708,   708,   709,
     709,   709,   709,   710,   711,   711,   711,   712,   712,   713,
     713,   713,   713,   713,   713,   713,   713,   713,   714,   714,
     715,   715,   716,   716,   716,   716,   716,   716,   716,   716,
     716,   716,   716,   716,   716,   716,   716,   716,   716,   716,
     716,   716,   716,   716,   716,   716,   716,   716,   716,   716,
     716,   716,   716,   716,   716,   716,   716,   716,   716,   716,
     716,   716,   716,   716,   716,   716,   716,   716,   716,   716,
     716,   716,   716,   716,   716,   716,   716,   716,   716,   717,
     717,   717,   717,   717,   717,   717,   717,   717,   717,   717,
     717,   717,   717,   717,   717,   717,   717,   717,   717,   717,
     717,   718,   718,   718,   718,   718,   718,   718,   718,   718,
     718,   718,   718,   718,   718,   718,   718,   718,   718,   718,
     718,   718,   718,   718,   718,   718,   718,   718,   718,   718,
     718,   718,   718,   718,   718,   718,   719,   719,   719,   720,
     720,   721,   721,   722,   722,   723,   723,   724,   724,   725,
     725,   725,   725,   725,   725,   725,   725,   726,   726,   727,
     728,   728,   729,   729,   729,   729,   729,   729,   730,   731,
     732,   732,   732,   733,   733,   734,   734,   734,   735,   735,
     736,   737,   737,   738,   738,   739,   739,   740,   741,   741,
     741,   742,   742,   743,   743,   744,   744,   744,   745,   745,
     745,   746,   746,   747,   747,   748,   748,   749,   749,   750,
     750,   751,   751,   752,   752,   753,   753,   754,   754,   755,
     756,   757,   758,   759,   760,   761,   761,   762,   762,   762,
     762,   762,   762,   762,   762,   762,   763,   764,   765,   766,
     767,   768,   768,   769,   769,   770,   770,   771,   771,   771,
     772,   772,   772,   772,   772,   773,   773,   774,   774,   774,
     774,   774,   774,   775,   776,   776,   777,   777,   777,   777,
     778,   778,   778,   779,   780,   781,   781,   782,   782,   782,
     783,   783,   784,   784,   785,   785,   786,   786,   786,   786,
     787,   787,   788,   789,   789,   790,   791,   791,   792,   793,
     793,   795,   794,   796,   794,   794,   797,   798,   798,   799,
     799,   799,   799,   799,   800,   800,   800,   800,   802,   801,
     803,   804,   805,   805,   806,   806,   806,   806,   807,   807,
     809,   808,   811,   810,   812,   810,   810,   813,   813,   813,
     814,   814,   814,   814,   815,   815,   816,   816,   816,   816,
     817,   817,   817,   818,   818,   818,   819,   821,   820,   822,
     823,   822,   824,   824,   825,   825,   826,   826,   827,   827,
     827,   827,   827,   827,   827,   827,   827,   828,   828,   828,
     828,   828,   828,   828,   828,   828,   829,   829,   830,   830,
     831,   832,   832,   833,   833,   833,   834,   835,   836,   836,
     836,   836,   837,   837,   838,   839,   838,   840,   840,   840,
     840,   840,   841,   841,   842,   842,   843,   844,   845,   845,
     846,   847,   848,   849,   849,   850,   850,   851,   851,   852,
     852,   853,   853,   854,   855,   855,   855,   856,   856,   857,
     858,   859,   860,   861,   862,   862,   862,   862,   862,   862,
     862,   862,   862,   862,   862,   862,   862,   862,   862,   863,
     863,   864,   864,   865,   866,   866,   867,   868,   868,   869,
     869,   870,   870,   870,   872,   871,   873,   873,   875,   874,
     876,   876,   876,   877,   877,   877,   877,   877,   877,   877,
     877,   877,   878,   878,   879,   879,   879,   879,   879,   879,
     879,   879,   879,   879,   879,   879,   879,   879,   879,   879,
     879,   879,   879,   879,   879,   879,   879,   879,   879,   879,
     879,   880,   880,   880,   880,   880,   880,   881,   881,   881,
     881,   881,   881,   881,   882,   883,   883,   883,   883,   883,
     883,   884,   884,   884,   884,   884,   885,   885,   885,   885,
     885,   886,   886,   886,   886,   886,   886,   886,   887,   887,
     887,   887,   888,   888,   888,   888,   889,   889,   889,   889,
     889,   889,   889,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   890,
     890,   890,   890,   890,   890,   890,   890,   890,   890,   891,
     891,   891,   891,   891,   891,   891,   891,   891,   891,   891,
     891,   891,   891,   891,   891,   891,   891,   891,   891,   891,
     891,   891,   891,   891,   891,   891,   892,   892,   892,   892,
     892,   892,   892,   892,   892,   892,   892,   892,   892,   892,
     892,   892,   892,   892,   892,   892,   892,   893,   893,   893,
     893,   893,   893,   893,   893,   893,   893,   893,   893,   893,
     893,   893,   893,   893,   893,   893,   893,   893,   893,   893,
     893,   893,   893,   893,   893,   893,   893,   893,   893,   893,
     893,   893,   893,   893,   893,   893,   893,   893,   893,   893,
     893,   893,   893,   893,   893,   893,   893,   893,   893,   893,
     893,   893,   893,   893,   893,   893,   893,   893,   893,   893,
     893,   893,   894,   894,   895,   896,   896,   897,   897,   898,
     899,   900,   900,   900,   901,   902,   902,   903,   903,   904,
     904,   904,   905,   905,   906,   906,   907,   907,   908,   908,
     908,   908,   908,   909,   909,   909,   909,   909,   909,   909,
     909,   909,   909,   909,   909,   909,   909,   909,   909,   909,
     909,   909,   909,   909,   909,   909,   909,   909,   909,   909,
     909,   909,   909,   909,   909,   909,   909,   909,   909,   909,
     909,   909,   909,   909,   909,   909,   909,   909,   909,   909,
     909,   909,   909,   909,   909,   909,   909,   909,   909
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     0,     2,     4,     3,     2,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     5,     1,     0,     4,     5,     5,     4,     3,
       2,     0,     2,     2,     1,     1,     1,     1,     3,     3,
       3,     1,     4,     5,     2,     0,     2,     2,     6,     6,
       3,     7,     4,     1,     0,     2,     0,     1,     1,     1,
       2,     3,     3,     3,     3,     3,     2,     5,     2,     3,
       3,     1,     1,     1,     3,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     3,     6,     1,     1,
       1,     1,     0,     1,     1,     2,     3,     4,     3,     2,
       2,     3,     4,     3,     2,     4,     1,     1,     1,     1,
       1,     6,     7,     9,     9,     9,     9,     7,     5,     7,
       6,     6,     6,     6,     3,     2,     1,     1,     0,     2,
       9,     1,     1,     1,     1,     1,     2,     0,     1,     1,
       3,     3,     1,     0,     2,     0,     3,     0,     1,     0,
      10,    11,     1,     1,     2,     2,     2,     2,     0,     1,
       0,     1,     3,     1,     1,     1,     3,     2,     0,     3,
       1,     1,     2,     1,     1,     2,     4,     2,     5,     1,
       2,     2,     2,     3,     2,     2,     0,     3,     1,     4,
       4,     5,    11,     3,     0,     3,     1,     1,     2,     2,
       0,     1,     1,     2,     2,     0,     3,     3,     2,     1,
       1,     2,     2,     4,     0,     2,     2,     0,     3,     4,
       4,     0,     0,     8,     3,     0,     3,     1,     1,     5,
       4,     2,     0,     2,     1,     2,     3,     2,     2,     2,
       2,     3,     3,     1,     0,     8,     1,     0,     1,     1,
       2,     0,     5,     1,     0,    14,    19,     1,     1,     1,
       3,     5,     1,     1,     1,     3,     0,     1,     0,     1,
       1,     1,     3,     0,     1,     1,     0,     2,     1,     2,
       1,     2,     2,     1,     2,     2,     6,     8,     3,     4,
       4,     4,     5,     3,     3,     1,     3,     3,     1,     1,
       1,     1,    12,     1,     3,     4,     7,     4,     2,     1,
       0,     1,     0,     7,     4,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     1,     1,     3,     5,     4,
       4,     3,     4,     3,     3,     2,     4,     2,     1,     1,
       1,     1,     2,     2,     1,     1,     1,     2,     2,     1,
       2,     2,     1,     1,     1,     6,     9,     7,     9,     8,
       8,     6,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     7,     8,     2,     1,     1,     1,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     2,     2,     2,     1,     3,
       1,     2,     3,     0,     3,     0,     1,     3,     2,    11,
       1,     0,     2,     0,     1,     3,     2,     5,     4,     1,
       2,     0,     9,     2,     0,     3,     2,     1,     3,     2,
       1,     1,     1,     1,     1,     3,     1,     1,     4,     1,
       2,     2,     2,     1,     1,     1,     4,     5,     1,     3,
       3,     2,     2,     2,     0,     5,     7,     1,     1,     7,
       1,     3,     3,     3,     1,     3,    11,    10,     2,     0,
       8,     4,     4,     1,     1,     1,     0,     9,     6,     6,
       7,     6,     6,     9,     6,     8,     8,     6,     1,     0,
       1,     0,     0,    14,     1,     1,     3,     3,     1,     1,
       1,     1,     1,     1,     1,     0,     1,     1,     1,     1,
       1,     0,     6,     2,     2,     2,     2,     2,     2,     3,
       2,     2,     2,     1,     1,     0,     3,     1,     4,     4,
       1,     0,     2,     2,     7,     2,     5,     3,     1,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     1,     0,
       5,     4,     3,     6,     4,     6,     6,     5,     7,     6,
       1,     0,    10,     4,     2,     1,     4,     5,     5,     2,
       4,     1,     1,     1,     0,     1,     0,     1,     0,     3,
       0,     4,     1,     1,     1,     1,     1,     1,     0,     4,
       4,     2,     1,     7,     4,     3,     1,     2,     4,     4,
       3,     0,     2,     2,     2,     3,     1,     3,     1,     2,
       6,     7,     0,     2,     2,     2,     3,     0,     2,     2,
       1,     1,     3,     3,     1,     2,     4,     4,     1,     1,
       8,     4,     4,     4,     2,     1,     0,     3,     3,     4,
       4,     4,     4,     2,     1,     1,     0,     1,     0,     1,
       5,     1,     0,     1,     0,     3,     1,     3,     3,     2,
       2,     1,     4,     4,     2,     2,     4,     1,     0,     1,
       1,     1,     3,     0,     2,     0,     3,     3,     1,     0,
       2,     0,     2,     0,     3,     1,     1,     2,     1,     2,
       5,     6,     5,     1,     2,     1,     4,     3,     4,     3,
       5,     4,     5,     4,     5,     2,     4,     1,     2,     2,
       2,     1,     1,     0,     4,     2,     1,     2,     2,     4,
       3,     4,     2,     0,     1,     3,     2,     2,     3,     5,
       6,     3,     4,     0,     1,     3,     3,     3,     3,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     2,     5,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     2,     2,     2,     1,     3,     0,
       5,     3,     0,     5,     3,     0,     1,     1,     1,     1,
       5,     2,     1,     1,     1,     1,     5,     2,     2,     2,
       1,     3,     3,     2,     1,     0,     3,     0,     5,     2,
       5,     2,     1,     3,     3,     0,     1,     1,     1,     1,
       1,     1,     3,     3,     3,     3,     3,     3,     3,     0,
       3,     4,     4,     3,     3,     3,     4,     3,     5,     4,
       4,     3,     3,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     4,
       1,     4,     1,     3,     5,     2,     2,     2,     2,     2,
       2,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     2,     2,     3,     3,     2,     3,     5,     4,     6,
       3,     5,     4,     6,     4,     6,     5,     7,     2,     3,
       2,     4,     3,     4,     3,     4,     3,     4,     5,     6,
       7,     5,     6,     3,     4,     4,     6,     2,     1,     1,
       3,     2,     2,     2,     2,     2,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     2,     2,     5,     6,
       7,     1,     1,     3,     5,     4,     1,     3,     4,     5,
       5,     4,     1,     2,     4,     2,     4,     2,     2,     2,
       6,     4,     4,     4,     4,     6,     5,     5,     5,     4,
       6,     4,     1,     2,     2,     2,     4,     6,     0,     1,
       3,     3,     0,     3,     1,     1,     3,     3,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     4,     3,     2,
       3,     0,     3,     3,     2,     2,     1,     0,     2,     2,
       3,     2,     1,     1,     3,     5,     6,     4,     2,     1,
       4,     2,     0,     1,     0,     2,     2,     2,     2,     2,
       3,     2,     0,     3,     1,     3,     1,     1,     3,     7,
       1,     2,     4,     1,     3,     4,     4,     3,     1,     1,
       1,     1,     1,     1,     3,     1,     1,     1,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     3,
       6,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     5,     3,     2,     2,
       3,     7,     1,     2,     2,     1,     0,     1,     3,     1,
       2,     0,     2,     0,     2,     0,     1,     3,     4,     3,
       1,     1,     1,     2,     0,     7,     3,     2,     1,     1,
       1,     0,     5,     0,     4,     2,     1,     2,     0,     1,
       3,     3,     3,     3,     1,     1,     2,     1,     0,     4,
       5,     5,     0,     1,     1,     1,     2,     2,     1,     2,
       0,     7,     0,     5,     0,     4,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     5,
       1,     2,     1,     3,     2,     2,     3,     0,     5,     1,
       0,     5,     2,     2,     1,     1,     1,     2,     2,     3,
       1,     2,     2,     3,     3,     4,     2,     1,     2,     1,
       1,     2,     2,     3,     1,     1,     1,     0,     1,     3,
       4,     0,     2,     0,     1,     2,     3,     2,     1,     1,
       1,     0,     1,     1,     3,     0,     4,     2,     2,     1,
       1,     0,     1,     1,     1,     1,     2,     3,     0,     1,
       2,     4,     4,     0,     1,     1,     1,     2,     1,     1,
       3,     1,     1,     4,     4,     4,     4,     1,     0,     3,
       3,     3,     1,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     1,     3,     4,     6,     6,     2,     4,     4,     1,
       1,     4,     4,     3,     0,     7,     1,     0,     0,     7,
       3,     4,     3,     1,     1,     1,     2,     3,     5,     2,
       5,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     1,     0,     1,     2,     1,     2,
       1,     1,     2,     2,     1,     1,     1,     1,     1,     1,
       2,     3,     1,     2,     1,     3,     1,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
       3,     0,     2,     1,  1838,  1839,  1842,  1846,  1847,  1774,
    1848,  1849,  1814,  1815,  1816,  1817,  1818,  1819,  1820,  1821,
    1822,  1823,  1824,  1825,  1827,  1826,  1828,  1829,  1830,  1831,
    1832,  1833,  1834,  1835,  1837,  1836,  1851,  1852,  1840,  1841,
    1843,  1844,  1813,  1845,  1853,  1854,  1855,  1850,  1803,  1150,
    1804,    10,  1146,  1147,  1858,  1809,  1810,  1808,  1811,  1812,
    1856,  1857,  1799,  1800,  1802,    11,    12,  1801,     4,  1805,
    1806,  1807,     8,  1228,  1297,     9,  1798,  1297,     0,  1404,
    1405,  1406,     0,  1407,  1408,  1409,  1410,  1411,  1348,  1311,
       0,  1412,     0,  1413,  1414,  1415,  1416,  1417,  1418,  1419,
    1420,  1421,     0,  1422,  1423,  1424,  1425,  1426,  1296,  1427,
    1428,  1429,  1430,  1274,  1280,  1388,     0,  1253,  1254,  1250,
    1252,  1251,  1255,  1240,   605,     0,   652,   651,     0,  1686,
     605,  1687,  1659,  1688,  1660,  1661,   190,     0,   645,  1662,
       0,   605,  1663,   223,   504,  1689,     0,     0,  1664,  1665,
       0,     0,  1225,   334,   605,     0,  1666,   668,  1667,     0,
    1668,  1690,  1691,     0,     0,  1692,  1693,  1694,     0,  1669,
    1670,  1695,  1696,  1697,  1698,  1699,     0,     0,   726,     0,
    1700,  1671,  1672,     0,  1701,  1673,  1674,  1702,  1703,  1675,
       0,  1676,     0,     0,   485,  1704,   605,  1677,   732,     0,
    1678,     0,  1705,  1679,     0,  1680,  1681,  1682,  1683,  1684,
     726,  1384,  1275,     0,     0,   656,  1685,  1706,  1785,  1786,
       0,     0,     0,    41,    20,    19,    54,    34,    16,    48,
      37,    78,    79,    80,    26,    22,    18,    23,    27,    39,
      28,    38,    17,    35,    50,    40,    53,    29,    46,    44,
      36,    49,    52,    74,    57,    25,    58,    70,    59,    33,
      68,    66,    67,    30,    47,    65,    69,    71,    51,    64,
      61,    75,    73,    81,    62,    42,    14,    55,    32,    15,
      31,    24,    77,    21,   654,    56,    60,    45,    63,    76,
      43,    72,   709,   700,   734,   708,    83,    84,    85,     7,
    1208,  1210,  1213,  1209,  1297,  1248,  1249,  1224,  1258,  1269,
    1257,  1227,  1270,  1256,  1276,     0,    87,    89,    90,    91,
      94,    95,    88,    86,    82,    93,    92,    96,    97,    98,
      99,   100,   101,  1471,   899,  1469,  1470,  1468,  1431,  1432,
    1433,  1434,  1435,  1436,  1483,  1484,  1485,  1486,  1487,  1488,
    1489,  1707,  1490,  1708,  1709,  1710,  1711,  1712,  1713,  1714,
    1491,  1492,  1493,  1494,  1495,  1496,  1715,  1497,  1498,  1499,
    1716,  1717,  1500,  1501,  1718,  1502,  1503,  1504,  1505,  1719,
    1720,  1506,  1507,  1508,  1721,  1509,  1510,  1511,  1722,  1512,
    1513,  1723,  1724,  1725,  1726,  1514,  1515,  1516,  1517,  1518,
    1519,  1727,  1520,  1728,  1521,  1522,  1523,  1524,  1729,  1730,
    1731,  1525,  1526,  1527,  1528,  1732,  1529,  1530,  1733,  1531,
    1734,  1533,  1532,  1534,  1535,  1735,  1536,  1537,  1736,  1538,
    1737,  1539,  1738,  1540,  1541,  1739,  1740,  1542,  1741,  1543,
    1544,  1545,  1546,  1547,  1548,  1549,  1550,  1551,  1742,  1552,
    1553,  1554,  1555,  1743,  1744,  1556,  1557,  1558,  1559,  1560,
    1745,  1561,  1746,  1562,  1563,  1564,  1565,  1566,  1567,  1568,
    1569,  1570,  1571,  1572,  1573,  1574,  1575,  1747,  1576,  1577,
    1578,  1579,  1748,  1580,  1581,  1749,  1582,  1750,  1751,  1583,
    1752,  1753,  1754,  1584,  1585,  1755,  1756,  1586,  1587,  1588,
    1589,  1590,  1591,  1592,  1594,  1593,  1757,  1595,  1596,  1597,
    1598,  1599,  1600,  1758,  1601,  1602,  1603,  1604,  1605,  1606,
    1607,  1608,  1609,  1610,  1611,  1612,  1613,  1614,  1615,  1759,
    1616,  1617,  1618,  1760,  1619,  1620,  1621,  1622,  1761,  1623,
    1624,  1625,  1626,  1627,  1628,  1629,  1630,  1631,  1762,  1632,
    1633,  1634,  1763,  1764,  1635,  1765,  1636,  1637,  1766,  1638,
    1639,  1640,  1641,  1767,  1642,  1643,  1644,  1645,  1646,  1768,
    1769,  1647,  1648,  1649,  1650,  1651,  1652,  1770,  1771,  1653,
    1654,  1655,  1656,  1657,  1658,     0,  1297,  1235,  1234,  1297,
    1260,  1244,  1269,  1262,  1475,  1472,   899,  1473,  1474,     0,
    1476,  1477,  1478,  1479,  1480,  1482,  1481,  1450,     0,  1784,
    1155,  1201,  1200,  1178,  1196,  1448,  1402,  1403,  1173,  1449,
    1446,  1447,  1156,  1780,  1445,  1347,     0,     0,  1309,  1310,
    1313,  1186,  1182,  1312,     0,  1307,  1308,  1130,  1445,  1437,
    1438,  1439,  1440,  1442,  1441,  1443,  1463,  1464,  1465,  1466,
       0,  1264,  1462,  1265,  1444,  1472,  1461,  1467,  1326,  1129,
    1328,  1272,  1282,  1278,  1286,  1281,     0,     0,     0,     0,
    1297,   604,   603,   597,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    13,     0,   598,
     209,  1175,  1174,  1126,  1125,   644,     0,  1121,  1122,     0,
     600,   222,     0,     0,     0,     0,     0,     0,   389,     0,
       0,     0,     0,     0,     0,     0,   233,   232,     0,   326,
       0,   490,     0,     0,   334,     0,     0,     0,  1179,     0,
    1593,  1324,  1325,  1207,  1202,  1625,   692,     0,     0,     0,
       0,   401,     0,   400,     0,     0,   398,     0,   333,     0,
     402,   396,   395,     0,   399,     0,   397,     0,     0,   601,
    1545,  1315,   667,   654,  1484,   425,   429,   420,   426,   434,
     433,   421,   418,   419,  1602,     0,     0,   424,     0,   415,
    1151,  1153,   432,  1152,     0,   456,   469,   463,   467,   461,
     465,   464,   460,   471,   470,   466,   462,   468,     0,   457,
     458,     0,   594,  1122,   615,  1134,   725,     0,     0,   417,
     593,     0,     0,   553,   554,     0,   184,  1618,  1681,  1636,
     180,     0,     0,   602,   731,   729,     0,     0,     0,  1509,
    1564,  1574,  1618,  1681,  1636,   140,     0,   179,  1618,  1681,
    1636,   175,   611,     0,     0,  1273,   596,   595,     0,     0,
     796,   655,   658,   709,     0,   605,     0,     6,  1376,   653,
     649,   728,   728,     0,   728,     0,   705,  1303,  1211,  1269,
    1247,  1215,     0,     0,  1294,  1290,  1287,  1295,  1289,  1277,
     888,   889,   890,   887,   891,   886,     0,  1219,  1226,  1229,
       0,  1237,  1236,  1242,  1303,  1246,  1261,  1787,  1788,  1350,
    1177,  1193,     0,     0,     0,     0,     0,     0,  1185,  1191,
       0,  1183,     0,     0,  1792,  1796,     0,  1794,  1789,  1263,
       0,  1327,  1329,  1284,  1283,  1279,     0,     0,  1393,     0,
       0,  1394,  1395,     0,  1390,  1392,     0,  1303,  1136,     0,
       0,  1448,  1135,  1449,  1446,  1458,  1445,     0,   406,   405,
       0,     0,     0,     0,     0,     0,     0,   312,     0,   796,
       0,   111,     0,     0,  1097,     0,     0,   442,   443,   448,
       0,   445,     0,     0,   444,   446,   447,     0,   449,   450,
       0,   225,     0,     0,     0,     0,   617,   641,   237,   236,
     125,   235,   234,     0,   917,   927,   925,   926,   919,   920,
     921,   924,   922,   923,     0,   918,   503,   134,  1173,     0,
       0,   104,     0,     0,     0,     0,     0,     0,     0,     0,
    1349,  1206,  1306,     0,   803,     0,   368,     0,   632,     0,
     130,     0,     0,     0,     0,   109,   121,     0,   208,   403,
    1323,  1322,  1314,  1321,     0,   422,   431,   430,   428,   427,
     423,  1154,     0,   413,   414,  1333,  1333,  1336,  1338,   411,
    1335,     0,   455,     0,     0,     0,   681,  1123,     0,     0,
     556,   556,   183,   181,     0,     0,     0,     0,     0,  1659,
    1660,   847,  1094,     0,  1450,  1661,  1662,  1663,  1022,  1102,
    1102,  1102,  1664,  1665,  1526,  1666,  1667,  1143,  1668,   837,
    1669,  1670,  1575,  1671,     0,  1144,  1673,  1674,  1584,     0,
    1675,  1676,  1677,  1102,  1679,  1680,  1681,  1682,  1683,  1684,
    1142,     0,  1102,  1685,   928,  1148,  1149,  1048,     0,     0,
    1107,     0,     0,     0,  1042,     0,   831,   833,   834,   858,
     859,   835,   864,   865,   877,   832,     0,   988,     0,     0,
    1106,   932,  1016,  1011,  1048,   716,  1104,  1048,     0,  1012,
    1169,  1168,  1170,  1171,  1167,  1137,  1448,  1454,   836,  1449,
    1446,  1145,  1172,  1780,  1445,     0,     0,     0,     0,  1383,
     186,     0,   187,  1127,  1618,   141,   171,   148,   170,     0,
    1501,   142,     0,     0,     0,   146,   607,     0,     0,   178,
     176,     0,   610,   599,   407,     0,     0,   798,     0,   797,
     657,   654,   703,   702,     5,   660,   727,     0,     0,     0,
       0,     0,     0,     0,   759,   748,  1304,     0,  1298,     0,
    1303,  1297,  1297,  1292,  1291,  1288,     0,     0,     0,     0,
       0,     0,  1161,  1160,  1216,  1218,  1164,     0,  1303,     0,
       0,  1195,     0,  1199,  1197,  1344,  1333,  1345,  1346,  1189,
    1184,  1187,     0,  1180,  1191,  1790,     0,     0,  1793,  1266,
       0,  1165,  1166,  1341,  1330,  1339,  1342,  1285,  1297,  1401,
       0,  1396,  1399,     0,  1391,     0,     0,     0,     0,     0,
     631,     0,     0,     0,     0,   634,     0,     0,     0,     0,
       0,     0,     0,     0,   310,   571,   571,   571,   571,     0,
       0,     0,     0,     0,     0,     0,   111,   105,   108,  1230,
    1099,  1098,  1132,   643,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   369,     0,   840,   875,   875,   875,   855,
     855,   849,   838,   882,   875,   852,   841,     0,   839,   885,
     885,   870,     0,   813,   823,   825,   826,   856,   857,   827,
     862,   863,   824,   899,  1453,   836,  1455,  1452,  1451,     0,
       0,   640,     0,   125,   122,   390,   370,     0,   133,   132,
     338,   337,     0,     0,   371,   103,   111,   312,   305,     0,
       0,     0,  1133,     0,     0,   274,   693,   697,   694,     0,
     695,     0,   678,     0,     0,   208,     0,     0,     0,     0,
       0,   208,   206,   207,     0,   394,  1316,  1319,  1320,     0,
     661,   663,   665,   664,   666,   662,   412,   409,   410,  1334,
       0,  1337,  1772,  1778,     0,     0,  1369,  1373,     0,  1516,
    1540,  1559,  1613,     0,     0,   472,   459,     0,     0,     0,
     669,   672,     0,     0,   679,   416,  1343,   555,   552,   551,
     182,   484,     0,     0,     0,  1044,  1045,   874,   861,  1093,
       0,     0,   869,   868,     0,     0,     0,  1023,     0,  1025,
       0,  1027,     0,   845,   844,   843,  1043,  1052,     0,   842,
     875,   875,   873,   955,     0,     0,   846,     0,     0,  1071,
       0,  1028,  1077,     0,     0,     0,   881,     0,   879,     0,
       0,   987,  1029,     0,  1141,  1048,   935,   936,   937,   938,
    1042,     0,  1049,     0,  1138,     0,     0,   867,     0,   899,
       0,     0,     0,     0,     0,   930,     0,   951,     0,     0,
       0,     0,     0,     0,     0,     0,   968,     0,     0,   970,
       0,     0,     0,   928,   927,   925,   926,   919,   920,   921,
     924,   939,   940,   952,     0,  1096,  1333,     0,   763,   715,
    1095,     0,     0,  1779,  1781,  1380,  1379,  1378,  1377,  1381,
    1382,   188,   189,   185,     0,     0,   150,   149,   174,   173,
       0,   168,   169,   145,     0,   164,   165,     0,   612,   613,
       0,   152,   161,   163,   162,   160,   143,   151,   153,   157,
     158,   159,   144,   177,  1297,     0,     0,   763,  1110,  1048,
     646,     0,   650,   709,   713,   708,   712,   735,   736,   741,
     711,     0,   761,   750,   744,   749,   745,   751,   758,   707,
     747,   706,  1305,  1214,  1303,   813,     0,  1297,  1238,  1297,
    1293,  1222,   893,   894,   895,   896,   898,   897,  1223,  1220,
     892,  1221,  1163,  1162,     0,     0,     0,     0,  1245,  1192,
       0,  1176,  1198,     0,  1190,     0,  1791,  1797,  1795,     0,
     813,  1775,  1397,  1775,   813,   538,     0,   537,     0,     0,
     630,     0,     0,     0,     0,     0,   637,   268,     0,   205,
       0,     0,     0,     0,   511,   513,   512,   506,     0,   507,
       0,   510,   517,   836,     0,     0,     0,     0,     0,     0,
       0,     0,   314,   324,     0,     0,     0,   104,   104,   311,
     570,   198,     0,     0,     0,     0,   569,     0,     0,     0,
       0,     0,     0,   107,   106,   114,   116,     0,   115,   117,
       0,     0,     0,   110,  1100,     0,     0,     0,     0,     0,
       0,     0,   224,   212,   211,     0,     0,   375,   378,     0,
     813,     0,     0,     0,   807,   888,   887,   886,     0,   828,
     830,     0,   629,   629,   629,   629,   616,   618,   248,   123,
       0,     0,   124,     0,     0,   238,   135,   137,   138,   139,
     343,   342,   344,     0,   339,     0,   372,   102,   309,     0,
     240,     0,     0,     0,     0,     0,   572,     0,     0,     0,
       0,     0,   696,   802,     0,     0,   535,     0,     0,     0,
     540,   208,   208,   120,   332,   404,  1317,  1318,   692,   408,
       0,     0,  1777,     0,     0,     0,     0,     0,   475,   474,
     486,     0,   476,   477,   473,     0,   671,     0,     0,   676,
    1048,     0,   688,     0,   686,     0,  1124,     0,  1049,     0,
       0,     0,  1055,     0,     0,  1092,  1089,     0,     0,  1049,
       0,  1101,     0,     0,     0,  1062,  1063,  1064,  1061,  1065,
    1060,     0,     0,  1066,  1059,     0,   872,   871,     0,     0,
       0,   544,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   989,     0,   911,     0,  1049,  1049,  1076,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1049,  1082,
       0,     0,  1013,   912,  1048,     0,     0,     0,     0,  1139,
     900,     0,     0,   905,     0,     0,     0,     0,   907,   916,
     914,   915,     0,   903,   904,     0,   933,   953,  1105,     0,
       0,   960,     0,  1083,   983,     0,   974,     0,   969,     0,
     972,   976,   956,     0,     0,     0,     0,     0,     0,   954,
       0,   949,   947,   948,   941,   942,   943,   944,   945,   946,
     950,     0,  1541,  1564,     0,   726,   726,   714,   724,  1103,
       0,   803,     0,     0,     0,  1017,     0,  1783,  1782,  1128,
       0,     0,   899,     0,   156,   606,     0,     0,   813,   799,
       0,  1048,     0,   803,     0,   648,   647,     0,     0,   739,
     740,     0,   757,     0,   756,     0,     0,     0,  1299,  1301,
    1212,  1268,  1239,  1271,  1217,  1259,     0,  1243,  1194,  1188,
       0,  1340,  1387,     0,  1776,     0,     0,     0,   558,   559,
       0,     0,     0,     0,     0,   208,   635,   639,   204,   636,
     505,     0,   509,   830,     0,   128,   129,   561,   562,     0,
    1131,   564,   313,   323,     0,   317,   318,   315,   319,   320,
       0,     0,   191,     0,     0,   208,   208,     0,   568,   200,
     203,   201,   202,     0,   567,     0,   112,   113,     0,     0,
       0,     0,   452,   441,   451,     0,     0,   435,   214,   215,
     227,   213,   374,     0,     0,     0,     0,   808,     0,     0,
     813,     0,     0,   821,   814,   822,     0,     0,     0,     0,
     628,     0,     0,     0,     0,   619,   633,   127,   126,     0,
     136,     0,     0,     0,     0,     0,   804,     0,     0,     0,
       0,   239,   241,   243,   244,   245,     0,   307,   308,   302,
       0,     0,   493,     0,     0,     0,   276,   277,     0,   698,
     699,     0,   208,     0,   208,     0,   208,     0,   592,   366,
       0,  1332,  1773,  1331,  1371,  1375,     0,  1374,  1370,  1352,
    1351,     0,   488,     0,   483,   478,   480,  1120,  1119,     0,
    1118,     0,     0,   677,   689,   682,   684,   683,     0,     0,
     680,     0,   730,     0,  1057,  1058,     0,     0,     0,     0,
    1088,     0,     0,  1087,     0,  1041,  1024,  1026,   854,     0,
    1031,     0,   848,     0,   851,     0,   929,     0,     0,     0,
    1032,   991,   992,   993,     0,  1006,     0,     0,     0,     0,
     928,     0,     0,     0,     0,     0,     0,     0,   994,   995,
    1007,  1033,   909,   910,     0,     0,  1074,  1075,  1034,   883,
     884,   885,   885,     0,     0,  1081,     0,     0,     0,  1039,
    1048,     0,  1015,  1048,   913,   876,   877,     0,     0,   906,
     901,     0,   902,     0,     0,     0,     0,     0,   975,   971,
       0,   973,   977,     0,     0,     0,   962,   984,   958,     0,
       0,   964,     0,   985,   726,   726,   726,   726,   723,     0,
       0,     0,   773,   762,   765,   775,   766,   768,  1126,     0,
     753,     0,     0,  1021,  1018,   147,     0,   166,   155,   608,
     609,   154,  1387,     0,  1111,  1108,   690,     0,   659,   737,
     738,   760,   742,   746,   743,     0,  1300,  1231,  1204,  1386,
    1389,  1400,  1398,  1241,     0,     0,   267,     0,     0,     0,
     638,   508,     0,   560,     0,   316,   322,   321,   248,     0,
       0,   192,   199,   197,     0,     0,   118,   119,     0,   437,
       0,     0,     0,   228,   104,     0,   376,  1584,   920,   377,
     379,   516,   380,   381,     0,     0,     0,     0,   811,     0,
       0,     0,     0,     0,     0,   813,   899,     0,   625,  1157,
    1158,   624,  1159,   621,   620,   627,   626,   623,   622,     0,
       0,     0,   259,     0,     0,   253,     0,     0,   254,   247,
     250,   251,     0,   131,     0,   346,   340,   373,     0,   806,
     240,   266,   294,     0,   304,     0,     0,   331,   329,   328,
    1129,     0,     0,     0,     0,     0,   273,     0,   614,   691,
    1205,   536,   208,   393,   542,   539,   543,   541,   697,     0,
       0,   487,   481,     0,     0,   453,   670,     0,     0,   674,
     675,   687,   685,   208,  1050,  1056,   860,     0,  1091,  1085,
       0,     0,     0,  1051,     0,     0,   545,  1069,  1068,   990,
    1070,     0,     0,     0,  1005,  1004,  1002,  1003,   996,   997,
     998,   999,  1000,  1001,  1079,  1078,  1072,  1073,   880,   878,
       0,  1036,  1037,  1038,  1080,  1046,     0,  1014,   866,   899,
     908,   931,   934,   981,   961,  1084,   978,     0,  1054,     0,
     957,     0,     0,     0,   966,   929,     0,     0,     0,     0,
       0,     0,   718,   717,   773,     0,   775,     0,   774,   787,
       0,     0,   793,   791,     0,   793,     0,   793,     0,     0,
     767,     0,   769,   787,     0,     0,   755,  1019,  1020,     0,
    1385,     0,     0,  1116,  1115,  1302,     0,  1181,     0,   269,
       0,     0,   270,   518,     0,   246,     0,     0,     0,     0,
     565,   566,     0,     0,   440,   439,   217,     0,   363,     0,
       0,   367,   358,   360,     0,     0,     0,   809,   815,   816,
     817,   818,   819,   820,   812,   829,   356,     0,     0,   257,
     261,   262,   260,   252,   255,   274,     0,     0,   348,     0,
       0,   805,     0,     0,     0,   263,     0,   297,   242,   306,
     308,   303,     0,   325,     0,   492,     0,     0,     0,     0,
     523,     0,     0,     0,   524,   528,   525,   534,   519,   588,
     589,   586,   587,     0,   275,   550,     0,  1372,  1354,  1355,
    1356,  1357,  1358,  1359,  1360,  1361,  1362,  1363,  1365,  1366,
    1367,  1364,  1368,  1353,     0,   479,  1117,     0,   454,  1090,
    1030,  1040,   853,  1086,   850,  1067,     0,     0,     0,  1035,
    1048,  1140,     0,   979,     0,   982,   963,   959,     0,   965,
     986,   722,   721,   720,   719,   777,   785,     0,   764,     0,
     792,   788,     0,   789,     0,     0,   790,   779,     0,     0,
     785,     0,   800,     0,     0,     0,   710,   899,     0,  1112,
    1203,   557,     0,   271,   563,   193,   194,   195,   196,   436,
     438,   210,   226,   365,   364,   362,   359,   361,   810,     0,
     549,     0,     0,     0,     0,   249,   280,     0,   240,   347,
       0,     0,   341,   297,   265,   264,     0,     0,     0,   301,
     330,     0,     0,     0,   494,   501,     0,  1132,   521,   514,
       0,     0,   522,     0,   531,   532,     0,   520,   502,     0,
       0,   482,     0,  1008,     0,     0,  1047,   980,  1053,   967,
     776,     0,     0,   778,     0,     0,   781,   783,     0,     0,
       0,     0,     0,  1129,   801,   752,   754,   167,  1113,     0,
       0,   218,   641,   641,   219,   216,   549,     0,   547,   357,
       0,   256,     0,   285,     0,   349,   350,   345,     0,   301,
       0,   295,   296,     0,   230,   642,     0,   803,     0,     0,
     499,   496,     0,     0,     0,   529,   530,     0,   533,   803,
     673,     0,  1009,     0,   786,   795,     0,   782,   780,   770,
       0,   772,     0,  1109,   274,     0,     0,   546,   548,     0,
     278,   279,     0,   258,   281,   282,     0,     0,   231,   293,
       0,   501,   489,   495,   500,     0,   515,   526,     0,     0,
    1010,   784,     0,   771,  1114,   280,   220,   221,     0,     0,
       0,     0,   283,     0,   284,     0,     0,     0,   382,   383,
     353,     0,   298,     0,   498,   501,   527,   591,   794,   285,
       0,   290,     0,   289,     0,   286,   287,     0,     0,   388,
       0,     0,   351,   354,   355,   299,   300,   497,   590,     0,
       0,     0,   288,   291,   292,     0,   392,   384,   335,     0,
     574,   585,   573,   575,   583,   580,   582,   581,   579,   272,
       0,   387,   391,     0,   385,   352,     0,   584,   578,   709,
     700,     0,     0,   576,   585,   353,   392,   577,     0,   386,
     336
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,     2,    68,   221,   222,   223,  1386,   224,   225,
     226,  1317,  1753,  1035,   227,  1374,  1792,   228,   229,   230,
    1377,  1379,  1796,   231,   835,  1606,  1607,  2015,  1608,  1609,
    1593,  1187,  1587,   232,   233,   234,  1181,  1583,   235,   236,
    1295,  1415,   237,   238,  1765,  2120,  2781,  2865,   702,  1331,
    2404,  2405,   239,   723,  2160,  2161,  2162,  2163,  2146,  2449,
    2450,  2451,  2164,  2665,  2165,  1697,  1818,  2175,  2176,  2873,
    2923,  2924,  2925,  2975,  2667,  2809,  2884,   240,  2466,  1811,
    2166,  2167,   241,   242,  1304,  1729,  2084,   243,   724,  2467,
    2673,   244,   757,   245,  1382,  1803,  1804,  2659,  2800,  2877,
    2981,  2982,  2792,  2631,  2632,  2633,   246,   247,   248,   249,
    1806,  1333,  1766,  1767,  2409,   250,  2958,  2959,   725,  3014,
     251,   252,   758,  1038,  2890,   253,   254,   776,   777,   778,
     255,   980,  2113,   256,   257,   798,   799,   800,  1444,  2204,
    2205,  2495,   822,  1849,  1850,   258,   726,  2473,  2813,  2814,
    2891,   259,   727,  1297,  1708,  1709,  1710,  2818,  2410,  1711,
    2687,  2688,  2828,   260,   261,  1686,   262,  1829,  1900,   263,
    2868,   264,   265,   815,  1458,   266,  2097,  1732,   267,  2174,
    3002,  3016,  3017,  3018,  2693,  2989,   268,  3004,   270,   271,
     272,   689,  1195,  1203,  1196,   273,   274,   275,  1786,  1787,
    2141,   276,   277,   278,   279,  1372,   280,   281,   282,   283,
     284,   860,   852,  1211,  1622,   285,  1420,   763,  3005,  1450,
    1858,  1859,  3006,   288,  1454,  1865,  3007,   290,  1023,  1821,
    3008,  1134,   293,   294,   295,  1568,  1997,   807,  1217,   826,
     865,   866,  1627,  1628,  1224,  1641,  1634,  1636,  2596,  2766,
    1225,  1639,  2034,  2001,  2333,  2334,  2335,  2578,  2589,  2751,
    2846,  2336,  2337,  1402,  2155,  2156,  1712,  1774,  2132,  1353,
    1135,  1136,  1137,  1489,  1496,  1483,  1356,  1138,  1139,  1140,
    1359,  1141,  1142,  1143,  1144,  1468,  1527,  1145,  1146,  1506,
     887,  1147,  1148,  1521,  1955,  1535,  1005,  1149,  1564,  1868,
    1910,  1151,  1514,  1523,  1891,  2559,  1871,  1466,  1892,  1904,
    2249,  1912,  1918,  2276,  2277,  1930,  1964,  1152,  1875,  1876,
    2231,  1470,  1153,  1154,   964,  1477,  1155,  2208,  1617,  2020,
    2859,  1618,  2209,  2210,  1157,  1445,   850,  2842,  1183,   631,
    2079,  2815,   696,   804,  1158,  1159,  1160,  1161,  1162,  1163,
    1164,  2134,   782,   632,  2431,  1272,  1610,  1165,   612,   697,
     296,   633,   634,   908,   909,  1260,  1263,  1251,  1671,   613,
     614,   732,  2607,   297,   298,   299,   300,   301,  1230,   867,
    1245,  1665,   888,   302,    72,    77,    73,   889,   585,   586,
    1647,   303,   670,  1648,  1248,   894,   589,   305,   306,   590,
     591,   308,   651,   592,   872,   310,   873,   593,   312,   313,
     314,   879,   315,  1227,  1228,  2366,  1229,   316,   317,   635,
     636,   318,  1043,  1416,  1042,   733,   319,   320,   921,   922,
    1057,  1058,  1430,  1059,  1060,  1274,  1275,   321,   322,   627,
     323,   324,  1436,  2200,  2194,  2713,  1437,  2195,   325,   326,
     327,   328,  1577,   329,   330,   844,  2370,   331,   666,   332,
     934,   615,   616,   617,  1167,   653,   803,  1168,   942,   654,
     595,   596,   619,   620,   621,   945,   598,  1431,    74,  2053,
    1432,  1171,  1172,  1573,  1173,   624,   899,   914,   915,  2054,
     917,    75,   918
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -2648
static const int yypact[] =
{
   -2648,   255,  9987, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, 14595, -2648, -2648, 39950,   299, -2648,
   -2648, -2648, 34984, -2648, -2648, -2648, -2648, -2648,   190, 34220,
   13444, -2648, 47951, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, 47951, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, 33839,   201, -2648,   162, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648,   -55,    70, -2648, -2648, 36512, -2648,
     157, -2648, -2648, -2648, -2648, -2648, -2648, 47951, 43760, -2648,
     360,   -55, -2648,   474,  2621, -2648, 36512, 36894, -2648, -2648,
   48332,   400, -2648,  1649,   -55, 37276, -2648,  1024, -2648, 31538,
   -2648, -2648, -2648,   791,  2667, -2648, -2648, -2648,   458, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, 43760,   719,   377, 31920,
   -2648, -2648, -2648, 43760, -2648, -2648, -2648, -2648, -2648, -2648,
   37658, -2648,    97, 44522,   558, -2648,   -55, -2648,   721, 33457,
   -2648, 44903, -2648, -2648,   482, -2648, -2648, -2648, -2648, -2648,
     377, -2648, 33839, 29996, 42617,   653, -2648, -2648, -2648, -2648,
     231, 14922,   480, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648,   912, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648,   608, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648,   105, -2648,   586,   109, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, 49475,   256, -2648, -2648, -2648,   524,
   -2648,   579, -2648, -2648, -2648,   915, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648,   153, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648,   957, 40331, -2648, -2648, 41093,
   -2648, -2648,   603,   579, -2648,   617,   633, -2648, -2648, 37658,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, 35366, -2648,
   -2648, -2648, -2648, -2648,    72, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, 47951, 47951, -2648, -2648,
   -2648,   648, -2648, -2648,   635, -2648, -2648, -2648,   689, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   12593, -2648, -2648,   722, -2648, -2648, -2648, -2648, -2648, -2648,
     799, -2648,   192,   956, -2648, -2648, 33839,  1885,  1885,  1159,
   41093, -2648, -2648, -2648, 41474, 43760, 47951, 43760, 41474, 47951,
   47951,  1083, 47951, 43760, 42617, 47951, 47951, -2648,  1147, -2648,
   -2648, -2648, -2648, -2648,   800, -2648,   950, -2648,   961,  1625,
   -2648, -2648, 43760, 41474, 47951,   832,   895, 47951, -2648, 43760,
     402, 47951,   785,  1875,   951, 47951, -2648, -2648, 47951, -2648,
   43760, -2648, 47951,   669,   980,  1157,  1073,    33, -2648, 37658,
   37658, -2648, -2648, -2648, -2648,   683, -2648, 42617, 41474, 47951,
     887, -2648, 47951, -2648, 41474, 47951, -2648,  1934, -2648, 47951,
   -2648, -2648, -2648, 47951, -2648, 47951, -2648,  1058, 43760, -2648,
    1203, -2648, -2648,   608,   686, -2648,   259,   434,   505, -2648,
   -2648,   451,   478,   521,   686,   623, 44141, -2648, 47951,    31,
   -2648, -2648, -2648, -2648, 37658,  1010, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,  1041,   937,
   -2648, 43760, -2648, -2648, -2648, -2648, -2648, 43760,   820, -2648,
   -2648,  1170, 47951, -2648, -2648, 43760, -2648,  1263,   994,  1160,
   -2648,  1126,  2667, -2648, -2648,  1152, 18151,  -106, 32302, 45284,
   48713,   202, 45665,  1048,    56, -2648,   -71, -2648,  1354,  1100,
    1249, -2648,    56, 43760, 33839, -2648, -2648, -2648, 26886,  1173,
    1077, -2648,  1316,  1145,  1156,   -55,  1098, -2648, -2648, -2648,
   43760,  1486,  1486,  1471,  1486,   634,   816,  1180, -2648, -2648,
   -2648, -2648,  1171,  1205, -2648,   194,  1399, -2648, -2648, -2648,
    1281,  1285,  1287,  1289, -2648,  1291,   696, -2648, -2648, -2648,
    1451, -2648, -2648, -2648,  1180, -2648, -2648, -2648, -2648, -2648,
   -2648,  1528,  1538, 36512, 36512,  1293,    50, 33073, -2648,  1235,
     648, -2648, 16863, 12593, -2648, 24534,  1197, -2648, -2648, -2648,
    1050, -2648, -2648,  1445, -2648, -2648,  1458, 47951, -2648,  1338,
   47951, -2648, -2648, 49094, -2648, -2648,  1885,  1180, -2648,   800,
    1288,  1306, -2648,  1308,  1312, -2648,  1322,  1391, -2648,  1331,
     900,   441,  1324,   228,  1405, 43760,  1449, -2648,   239,    47,
    1484,   699,  1359, 30377, -2648, 43760, 41474, -2648, -2648, -2648,
   41474, -2648,  2055, 47951, -2648, -2648, -2648, 47951, -2648, -2648,
   47951,  1398,  1371,  1659, 39187, 47951,  1407,  1691, -2648, -2648,
    1414, -2648, -2648, 43760, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648,  1371, -2648, -2648, 47951,    98,   870,
      51,  1416, 43760, 43760,  1568, 43760, 47951, 41474, 47951, 43760,
   -2648, -2648, -2648,   520,  1420,  1390, -2648, 39187, -2648,  1324,
   -2648, 43760,  1408,  1532,  1551,  1406, -2648,   719,    35, -2648,
   -2648, -2648, -2648,   448,   545, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, 47951,    31,    31,    99,  1776, -2648, -2648, -2648,
   -2648,    69, -2648, 42998,  2018,    55,   -10, -2648, 47951,  1203,
    1638,  1638, -2648, -2648,  1592,  1641,  1557,  1417,   735,   845,
     732, -2648, 20575,  1429,    54,    54,  1437,  1438, -2648,  1439,
    1440,  1441,   801,   801,  1556,  1442,  1443, -2648,   815, -2648,
     954,   888,  1569,    54, 20575, -2648,  1444,   923,  1447,  1453,
    1456,  1056,  1457,  1441,  1067,  1459,   917,  1017,  1460,  1462,
   -2648,  1442,  1441,    68, -2648, -2648, -2648,   173, 20575, 20575,
   -2648, 20575, 20575, 18555, -2648,   719, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648,    49, -2648,   942, -2648,  3038, 20575,
    7882, -2648, -2648, -2648,   840,   334, -2648,   173,  1464, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648,   948, -2648, -2648,   968,
    1000, -2648, -2648,    83,  1002,   868,   868, 35748, 35748, -2648,
   -2648,   747,  1463, -2648,   705, -2648, -2648, -2648, -2648, 36130,
    1766, -2648,   593,  1644,   -22, -2648,  1654, 30758, 30758, -2648,
   -2648,  1652, -2648, -2648, -2648,  1665, 43760, -2648, 28044, -2648,
   -2648,   608, -2648, -2648, -2648,  1479, -2648,   231,   231, 20575,
     231,   313, 18959, 20575,  1697,   537,  1489,  1049, -2648, 49841,
    1180, 40712, 40712,  1677, -2648, -2648,   741,    18,  1583,  1655,
     581,   973, -2648, -2648, -2648,  1483, -2648,  1750,  1180,  1068,
   36512,  1537, 36512, -2648, -2648, -2648,  1776, -2648, -2648, -2648,
   -2648,  1491,   623, -2648,  1235, -2648, 16938,  1311, -2648, -2648,
   12593, -2648, -2648, -2648, -2648,  1488, -2648, -2648, 41093,  1496,
   47951, -2648,  1505,  1506, -2648, 49841, 29615,  1571,  1572, 48713,
   -2648,   577,   626,  1573,   121, -2648, 16498,  1621,  1560,  1561,
    1576,  1581,  1562,  1584,  1140,   865,  1802,  1031,  1802,  1552,
    1669,  1587,  1593, 42617,  1594, 48713, -2648,  1610, -2648, -2648,
   -2648,   800, -2648, -2648,  1534,  1324,  1535,    61,  1680,  1724,
    1685,   196, 33839, -2648,  1543, -2648,  1585,  1585,  1585,  1544,
    1544,  1545, -2648, -2648,  1585,  1547, -2648, 39569, -2648,   -89,
     -72, -2648,  1863,    91, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648,   690, -2648,   800, -2648, -2648, -2648,  1876,
     647, -2648, 39187, -2648,   -42,  1813, -2648,  1868, -2648,   146,
   -2648, -2648,    57,  1559, -2648, -2648, -2648, -2648,   -11, 36512,
    1786,  1702, -2648,  1324,  1877,  1564, -2648,  1360, -2648,  1664,
   -2648, 20575, -2648, 29615,  1887,   107,  1614, 38041, 43760, 43760,
   47951,   107, -2648, -2648, 43760, -2648, -2648,  1764,   799, 47951,
   -2648, -2648, -2648, -2648, -2648, -2648,    31, -2648, -2648, -2648,
    1975,  1580, -2648,    83,  1978,   623, -2648,  1586,  1604, 47951,
   41474, 47951, 47951, 43760,  1657,  1590, -2648,  1635,  1597, 27658,
   -2648, -2648,   253, 43760, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, 42998, 20575, 19363, -2648, -2648, -2648,  1598, 10226,
    1633, 20575, -2648, -2648, 20575, 20575,   490, -2648,   490, -2648,
    1599, -2648,   623, -2648, -2648, -2648, -2648,  1172,   623, -2648,
    1585,  1585, -2648,  3096, 20575,   623, -2648, 29215, 20575, 20979,
   15688, -2648, 20575,  1668,  1671,   623, -2648,   623, -2648, 20575,
   17343, -2648, -2648, 20575, -2648,  1605,  1936,  1936,    76,   843,
     989,  1607,  4320,  1608, -2648,  1699,   623, -2648,   623,   712,
    1442,   568,  1817,  1615,   -54, -2648,   113,   169, 39187, 20575,
   33839,  1682, 20979, 20575,  1617,  1104, -2648, 20575,   706, -2648,
    1618, 20575,  1683,   125, 20575, 20575, 20575, 20575, 20575, 20575,
   20575, 22581, 22985, 21383,   159, -2648, 34602, 18151,  1841, -2648,
   -2648, 15283, 37658, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, 47951,  1766, -2648, -2648, -2648, -2648,
    1684, -2648, -2648, -2648,  1040, -2648, -2648,   755, -2648, -2648,
    1799, -2648, -2648, -2648, -2648, -2648, -2648,  1619, -2648, -2648,
   -2648, -2648, -2648, -2648, 41093,  1626, 47951,     7, -2648,  1605,
   42236, 47951, -2648, -2648,  1818, -2648, -2648,  1622, -2648,  7693,
    1818,  1769,  1778, -2648,   -35, 10226,  1806, 10226, -2648, -2648,
   -2648, -2648, -2648, -2648,  1180,  1637,  1074, 13827, -2648, 14211,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648,   696,  1632,  2004,  1097, -2648, -2648,
   36512, -2648, -2648, 33073, -2648,  1646, -2648, -2648, -2648,  1050,
    1637, 12593, -2648, 12593,  1637, -2648,  1642, -2648, 47951, 47951,
   -2648,  1647, 47951,  1822,  1826,  1650, -2648, -2648, 47951, -2648,
    1793, 47951, 20575,  1798, -2648,   311,   320, -2648,   628, -2648,
   39187, -2648, -2648,   800,  1715, 47951, 47951, 47951, 47951, 47951,
   47951,   696, -2648,  1952,   696,   696,   133,  1416,  1416, -2648,
   -2648, -2648, 47951, 47951, 47951, 47951, 47951,  1796, 47951,  1725,
   47951,  1765, 47951, -2648,  1610, -2648, -2648,  1872, -2648, -2648,
    1686,   623,  1706, -2648, -2648, 29615,  1848, 38041,   -26, 43760,
   43760,   -26, -2648, -2648, -2648,   882,   675, -2648,  1674, 20575,
     101, 39187,  1666, 26095, -2648,  1727, -2648,  1729,   623, -2648,
   -2648,    57,  1679,  1679,  1679,  1679,   647, -2648, -2648,   -42,
     623, 47951, -2648,  1893, 47951,  1540, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648,  1810,  1807, 47951, -2648,  1610,  1140, 43760,
   41855,  1986,  1890,   719, 43760,  1783, -2648, 47951,  1997,  1895,
    1896,  1911, -2648, 10226,  1687, 39187, -2648, 47951,  1688,  1689,
    1692,   107,   107, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   37658,   689, -2648, 37658,   689,   689,   689,  2085,  1463,  1693,
   -2648,  1324,  1463,  1463,  1590, 46046, -2648, 17747,   700, -2648,
    1605,   411, -2648,   426,   -21,  1858, -2648,  1916, 10226,   777,
     658,   710, -2648,   623, 20575,    37, -2648,  8128,   827,  8153,
     838, -2648,  1696,  1701,   914, -2648, -2648, -2648, -2648, -2648,
   -2648,  1704,  1924, -2648, -2648,  1705, -2648, -2648,  3570,   986,
    1711, -2648,  1713,  8223,  1712, 20979, 20979, 20979, 18555, 20979,
     565, -2648,  1719, -2648,  1721,  5047,  7407,  1710,  1723,  1734,
    1752,  1728,  1731,  9035, 19767, 20575, 19767, 19767,  9343,  1710,
    1732,  2470, -2648, -2648,   173, 20575, 47951,  1737,  1751, -2648,
   -2648,  1947,  1879, -2648,  1442, 29215,  1457, 20575, -2648, -2648,
   -2648, -2648, 18555, -2648, -2648,  1442, -2648,  3096, -2648,  1755,
     308,  3899, 18555, -2648, -2648,  1972, -2648,    41, -2648,  1753,
   -2648, -2648,  4696, 20979, 20575,  1617, 20575,  1819, 29215,  6127,
   20575,  3374,  1432,  1432,   234,   234,    76,    76,    76,   843,
     169,  1754,   919,  1033, 43760,  2734,  4351, -2648, -2648, -2648,
   25323,  1420, 20575, 20575,  1756, -2648,  1004, -2648, -2648, -2648,
      56,   623,   712,  2036, -2648,  1878,   755, 31148,  1637, -2648,
    1758,  1605, 47951,  1420,  1773, -2648, -2648,  1014, 20575, -2648,
   -2648,  1588, -2648, 47951, -2648, 20575, 20575, 18959, -2648,  1774,
   -2648, -2648, -2648, -2648, -2648, -2648,  1760, -2648, -2648, -2648,
   47951, -2648,  2138,  1767,  1768,  1771,  1781,  1880, -2648, -2648,
   20575,    78,  1779,  1785, 47951,   107, -2648, -2648, 10226, -2648,
   -2648, 38423, -2648,  1791, 47951,  1406,  1406, -2648, -2648,  1886,
   -2648, -2648, -2648, -2648,   696, -2648, -2648, -2648, -2648, -2648,
     696,   696, -2648, 39187,    32,   107,   107,  1845, -2648, -2648,
   -2648, -2648, -2648,  1851, -2648, 47951, -2648, -2648,  1686,  1787,
     -26,  1790, -2648, -2648, -2648,  1980,  1981, -2648, -2648, -2648,
     163, -2648, -2648, 33839, 28816,  5067,  1797, -2648,  1795,   623,
    1637, 26498,  1201, -2648, -2648, -2648,    75,  1959,  1800,  1938,
   -2648,   276,    53, 46427, 46808, -2648,  1369, -2648,  1406,  1852,
   -2648,  1871,  1839, 43760,    57,  1022, -2648, 39187,  1804, 43760,
    1805,  1801, -2648, -2648, -2648, -2648,  1090, -2648, 39187, -2648,
   43760,  1883,  1856, 39187,  1955,  1103, -2648, -2648,   231, -2648,
   -2648, 27272,   107,  1815,   107, 39187,   107, 38805, -2648, -2648,
     904, -2648, -2648, -2648, -2648,  1814,  1836,  1814, -2648, -2648,
   -2648, 41474, -2648, 47951,   -85, -2648, -2648, -2648, -2648,  1109,
   -2648,   248, 47951, -2648, -2648, -2648, -2648, -2648,  2062,  2063,
   -2648, 46046, -2648, 20575, -2648, -2648,  1829,  1827,  9689, 20575,
   -2648,  2070, 39187, -2648, 43760, -2648, -2648, -2648, -2648,   623,
   -2648, 20575, -2648, 20575, -2648,   623, -2648, 29215, 20575,  2053,
   -2648,  2164,    90,  2164,  4320,   278, 39187, 20979,   460,  1447,
   22177, 20979, 20979, 20979, 20979, 20979, 20979, 20979, 23375, 23779,
   -2648, -2648, -2648, -2648, 20575, 20575,  2065,  2053, -2648, -2648,
   -2648,  1363,  1363, 39187,  1842,  1710,  1846,  1847, 20575, -2648,
    1605, 20575, -2648,  1605,  4261, -2648,  2129,   719,   -54, -2648,
   -2648,  1849, -2648, 21787, 20979, 20575,  1111, 20575, -2648, -2648,
    1840, -2648, -2648, 39187, 20575,   659,  5629, -2648,  5792, 20575,
    1854,  5866, 18555, -2648,   377,   377,   377,   377, -2648, 43760,
   43760, 24937, 47189,  1850,  1209, -2648, 47189, 47570,  1853,  1861,
    2061,  1119,  1139, -2648, -2648, -2648,  1864, -2648, -2648, -2648,
   -2648, -2648,  2138,  1888,  1867, -2648, -2648, 20171, -2648, -2648,
   -2648,  1463, -2648, -2648, -2648, 12593, -2648, -2648,  1897, -2648,
   -2648, -2648, -2648, -2648,  1942,  5382, -2648, 47951, 47951,  1153,
   -2648, -2648,  1933, -2648,  1944, -2648, -2648, -2648, -2648,   417,
     403, -2648, -2648, -2648, 47951, 47951,  1406, -2648,  2069, -2648,
    2071,   -26,   -26, -2648,  1416,  2133, -2648,  1615,   973, -2648,
   -2648, -2648, -2648, -2648,   589,   623,  1387,  1892, -2648,  1185,
   26498, 26498, 26498, 26498, 26498,  1637,   712, 43760, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,  1884,
   47951, 20979, -2648,   750,   100, -2648,  2077, 43760, -2648, -2648,
   -2648, -2648, 39187,   146, 43760,  2111,  2023, -2648, 47951, -2648,
   41855,   723,  2089, 41855, -2648, 47951,   231,  2078, -2648, -2648,
    1331,   719, 47951,  1898,   819,   438, -2648, 47951, -2648, -2648,
   -2648, -2648,   107, -2648, -2648, -2648, -2648, -2648,  1360,   689,
     148, -2648, -2648,  2112, 46046, -2648, -2648, 17747,  1899, -2648,
   -2648, -2648, -2648,    39, 10226, -2648, -2648, 20575, 10226, -2648,
    1900,  1901,  1902, 10226,  6365,  1903, -2648, 10226,  2065, -2648,
    1142,  2118,  2054,  1909,   278,  1142,  1357,  1357,    80,    80,
      90,    90,    90,  2164, 10226, 10226, -2648, -2648, -2648, -2648,
    1912, -2648, -2648, -2648,  1710, -2648,  7377, -2648, -2648,   712,
   -2648, -2648, -2648,   380,  1237, -2648,   230, 39187, -2648,  1154,
    1237, 20979, 20575, 20575,  6401,   191, 20575,  6753, 43760, 43760,
   43760, 43760, -2648, -2648, 24169,  1209,  1913, 47951, -2648,  1910,
   25323,  2097,  2051, -2648, 25323,  2051,   879,  2051, 25323,  2103,
   -2648, 28430, -2648,  1931, 16093,  2232,  2146, -2648, -2648,   719,
   -2648,  1935, 47951, -2648, 10226, -2648, 47951, -2648, 47951, -2648,
    1198,  1234, -2648, -2648, 47951,  1369,  2083,  2086,   623, 47951,
   -2648, -2648,   -26,   -26, -2648, -2648, -2648,   719, -2648,   790,
    2192, -2648,  2139,   662,  1940,  2160,  2161, -2648, -2648,  1273,
    1273, -2648, -2648, -2648, -2648, -2648,  2165, 20575,   601,  1142,
   -2648, -2648, -2648, -2648, -2648,  1564,  1987,     5,  2189,  2182,
      57, -2648,  1948,  2208,  2209, -2648,  1953,  1389, -2648, -2648,
   -2648, -2648,   719, -2648,  2177, -2648, 25709,   719,  2098,  2056,
   -2648, 36512,  2107,   651, -2648, -2648, -2648,  1188, -2648, -2648,
   -2648, -2648, -2648,  2024, -2648, -2648,  2188, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -2648, -2648,  2106, -2648, -2648, 17747, -2648, 10226,
   -2648, -2648, -2648, -2648, -2648, -2648, 20979,  1965, 20979, -2648,
    1605, -2648,  1236, -2648, 39187,   380,  1237,  1237, 20575,  1237,
   -2648, -2648, -2648, -2648, -2648, 47189,  1969, 47951,  1209, 25323,
   -2648, -2648,  1125, -2648, 25323,  2155, -2648, -2648, 25323, 47951,
    1973, 47951, -2648,  1240, 20575, 20575, -2648,   712, 20575, -2648,
   -2648, -2648,  2087, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648,   123, -2648, -2648, -2648, -2648, -2648, -2648, -2648, 41474,
    2290, 43760,   589,  6843,  2125, -2648,  2147, 47951, 41855, -2648,
       6,  2095, -2648,  1389, -2648, -2648, 43760,  2123,  2124,  2127,
   -2648, 43760, 20575,  1246, -2648, 43379,  1982,  1331, -2648,  1977,
    2137,   682, -2648,  2132, -2648, -2648,  1371, -2648, -2648, 43760,
     231, -2648,  1256,   391, 20979,   147, -2648, -2648, -2648,  1237,
   -2648, 47951,  1257, -2648, 20575,  1984, -2648, -2648, 25323,  1125,
    1259, 47951,  1277, 39187, -2648,  1710, 10226, -2648,  4592,  1991,
   43760, -2648,  1691,  1691, -2648, -2648,  2290,  2306, -2648, -2648,
    2221, -2648,   457,  2140,  2315, -2648, -2648, -2648, 47951,  2127,
    1279, -2648, -2648,  2282, -2648, -2648,  7117,  1420, 25709, 43760,
   -2648, -2648, 20575,   719,  2200, -2648, -2648,  2152, -2648,  1420,
   -2648,   288, -2648,  1283, -2648, 10226, 47951, -2648, -2648, -2648,
    1286, -2648, 20575, -2648,  1564,   719,   719, -2648, -2648,  2248,
   -2648, -2648,   128, -2648,  2148,  2149,   598,  2006, -2648, -2648,
      85, 43379, -2648, -2648, -2648,  1295, -2648, -2648,  2207,  2264,
   -2648, -2648,  1297, -2648, -2648,  2147, -2648, -2648,  2119,   487,
     487,  2064, -2648,  2272, -2648,   623,   623, 39187,  2014, -2648,
   32684,  2121, -2648,  2126, -2648, 43379, -2648,  2219, -2648,  2140,
    2260, -2648,  2353, -2648,    94, -2648, -2648, 41474, 29215, -2648,
     598,  1303, -2648, -2648, -2648, -2648, -2648, -2648, -2648,   760,
     589,  2145, -2648, -2648, -2648,  1324,   -59, -2648, -2648, 32684,
   -2648,   793, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   41474, -2648, -2648, 38041, -2648, -2648,   931, -2648, -2648,  1121,
    1156,  2030,  2033, -2648,   793, 32684,  2150, -2648,  1304, -2648,
   -2648
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -2648, -2648, -2648, -2648, -2648,  2218, -2648, -1645, -2648, -2648,
   -2648, -1023, -2648, -1609, -2648,  1089, -2648, -2648, -2648, -2648,
   -2648,   296, -2648, -2648,  -713,  1265, -2648,   431,   447, -2648,
   -2648, -2648, -1365, -2648,  -286, -2648, -2648, -2648, -2648, -2648,
     371, -1321, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648, -1327,   671,     8, -2648,    11,   737,    82, -2648,
    -177, -2648, -2648, -2648,  -473,   416, -2489, -1917,     1,  -466,
    -497,  -445,  -442,  -465, -2648,  -316,  -391, -2648, -2648, -2648,
   -2648,    24, -2648, -2648,  1105, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648,  1772, -2648, -2648,   709, -2066, -2648, -2648, -2648,
    -534,  -506, -2648, -2467,  -136,  -134, -2648, -2648, -2648, -2648,
   -2648,  -985, -2648,   378, -2648, -2648, -2648,  -480,  1127,  -522,
   -2648, -2648, -2648, -2648,  -660, -2648, -2648,  2326,   409,   149,
   -2648, -2648, -1700, -1326, -2648,  1690, -2648,  1450,  1044,   287,
      19, -2648, -2648, -2648, -2122, -2648, -2648, -2648, -2648,  -371,
   -2647, -2648,   727, -1018, -2648,   445, -2648, -2648,   345, -1618,
   -2648,  -164, -2648, -2648, -2648, -1291, -2648, -1722, -1901, -2648,
    -342, -2648, -2648, -2648,  1455, -2648, -2648,   421, -2648, -2648,
   -2648, -2648,  -456,  -490, -2648, -2648, -2648,   160, -2648, -2648,
   -2648,   847,  -813, -2648,   522, -1325, -2648, -2648, -2648,   749,
    -378, -2648, -2648, -2648, -2648, -1095, -2648, -2648, -2648,   920,
    2382,  -672, -2648, -2648, -2648, -2648, -2648, -2648,   -12, -2648,
   -2648,   329,    -8, -2648, -2648, -2648,    -4,  1498,   708,    62,
     -62,   -69,  -214,    59,   252, -2648, -2648,  -169,   687, -2648,
   -2648, -2648, -2648,   515,  1326, -2648,   510,  -263, -2648, -2648,
    1328, -2648, -2648,   936, -2648, -2220,   223, -2232,   -31, -1016,
    -293,  -183, -2648, -1936, -2152,   104,  -372, -1550, -1978,  1210,
   -2648,  1301,  1968, -2648, -2648,  -893, -2648, -2648,  2279,  2795,
   -2648, -2648,  3999,  4269, -2648,  -960,   262,  4803,  1275, -1075,
   -1341, -2648, -1460,  1059,   999,  -711, -2648, 10561, -1090,  8681,
   -1414,  -460, -1114, -1361, -2648,    12, -2648, -1389, -2648, -2648,
   -2648, -2648, -2648, -1624, -2087,  -605,   590, -2648, -2648,   691,
   -2648, -2648, -2648,  8308, -1056,   103, -2648,  -748, -2648,   -38,
    -344,   548,  -144,    77,  8906,  -789,   290,  -821,  2644,  -648,
   -1759,  1612,  1565, -2648,  -623, -2648,    -2,   224, -2648, -2648,
     108,  -158, -2648,   -78, -2648,  -853,  -882, -2385,  -622, -2648,
   -2648,   -83, -2648,  1667, -2648,   903,  1314, -2648, -2648,   910,
    -764,  -569, -2648, -2648, -2648, -2648, -2648, -2648, -2648, -2648,
   -2648, -2648,  1988,  2278, -2648, -2648, -2648, -2648, -2648, -2648,
    1351,     9, -2648,   -50, -2648, -2648,  2512, -2648,  2283,   183,
    -533, -2648,  1937,   -48, -2648, -2648, -2648,   186, -2648, -2648,
   -2648, -2648, -2648,  -776,   947, -2648,  1656, -2648, -2648, -2648,
    -699, -2648, -2648, -2648,  1523,  -142, -2648, -2648, -2648,  -947,
     876,  1694,  1539,  -927,  -942,   922, -2648, -2648, -2648, -2648,
   -2648, -2648,   752, -2648,   115, -2648, -2648,   751, -2648, -2648,
   -2648, -2648,  1426, -2648, -2648, -2648,   254, -2648, -2648, -2648,
    -507,  9998,   -67,   -74,   -81,   161,  1468,  5112, -2648,  -646,
     -40,   -76,  6636,  5144,    -5,    58, -2648, -2648,  2020,   924,
     767,  -839,  7544,  1176,  2348,  3652,  -662,  -799,  1698,  -483,
   -1223, -2648,  2609
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1635
static const short yytable[] =
{
      69,   781,  1004,   594,   611,   292,   854,   333,  1182,   652,
     333,  1405,   291,   761,   656,   947,   594,   951,  1066,  1376,
     926,   781,  1779,   333,  1812,  1384,   309,   588,   950,  1202,
     898,   849,   652,  1244,   334,  2111,  1032,   656,  1273,   594,
    1565,   843,  1508,  1570,  2301,   687,   333,  1678,   811,   987,
     655,   940,  1797,  1798,  1799,   952,   893,   953,  1536,   986,
    1010,  2117,   286,   728,   961,  2340,   287,  1020,  2184,   335,
     289,  1515,   335,   655,  1948,  1872,  1954,  2320,  1156,  2491,
     982,  1276,  2090,  2091,  1826,   335,   587,  2356,  2456,   990,
    1834,  1044,  2072,  1007,  1028,  2039,  1417,   902,  1039,   805,
    1011,  1418,  1869,  1870,  2590,  2592,  2075,  2076,   335,  1572,
      71,  2575,  1824,  1878,  1880,  1025,  1268,  1185,  1249,  1191,
    1435,  1029,  1061,  1030,  1472,  1473,  1427,  1428,  1960,  1179,
    2052,   652,   336,  1036,  2056,   336,   656,   937,   594,  1253,
    1254,  1917,  1429,  1492,  1383,   333,  1412,  2379,   336,  1929,
    1412,   853,   292,  2419,  1538,   674,  2698,   780,  2256,   291,
     898,   935,  2699,  2700,  2701,  1525,  2796,   916,  2256,  1310,
    -875,   336,   655,  1541,  2702,  2703,  2704,   780,  2705,  2706,
    2707,  1311,  2148,  1772,  -870,  2708,  2709,  2710,  1939,  2536,
     610,  1041,  1452,  2126,  2000,  2389,  1691,   610,  1205,  1949,
    1484,   675,  2229,  2433,  1950,  1447,   667,   335,   668,   286,
    2006,  -917,  1800,   287,   676,   898,  -917,   289,  1412,  2308,
    2127,   923,  1017,  1233,   625,  2256,    70,  2861,  1569,  2035,
     662,   677,  -136,  2112,   269,  3012,   610,   333,  1175,  -701,
    2961,   812,   663,  -704,  2993,  1949,  1598,  1538,  2962,  1055,
    1950,  1809,  2652,  1946,   610,     3,   869,   307,  1655,   678,
     311,  1326,  1693,   679,   334,  1754,  1541,  1809,  1256,  1801,
     336,  1702,  1652,  1197,   661,  1508,  2087,  -931,  1193,  2862,
    1795,  1758,  -931,  2949,  2964,   610,  2218,  1503,  1504,  1176,
    -136,  2493,   671,  1744,  1790,  1302,   680,  -701,   880,   335,
    2309,  -704,   813,  2310,  1503,  1504,   688,  1756,  1538,  1780,
    1595,  1298,  1538,  2875,   118,  1653,   664,   599,  2987,  1505,
    -229,  1791,  1305,   672,  1312,  2870,  1306,  1541,  1759,  2494,
    1656,  1541,   122,  1375,  1861,  2876,  1507,  1413,   164,   681,
    2219,  1413,  1018,  1324,  1198,  1046,  2516,  1325,  1194,  3013,
     881,  2390,  1186,  2994,  1947,  1390,  2256,  1599,    49,  2653,
    2748,   609,   336,  1807,  2752,  1694,  2256,  2258,  2757,   198,
    2963,  1406,  2088,   845,  2089,  1815,  1703,  1472,  1473,  2036,
     682,   269,  2863,  1763,  1492,   683,  2256,  1654,  2864,  1545,
    1546,  1299,  2311,   882,  1393,  1056,   883,  1810,  2304,  2312,
     626,  1932,  1307, -1552,  1453,  1019,   924,   684,  1234,  1413,
    2399,  1874, -1586,  2798,  1056,   665,  2259,   669,  1802,   685,
    1946,  2022,  1448,  1467,  1862,  2945,  2428,  1549,   695,  1284,
    1267,  2725,  2711,   686,   814,  1695,   903,    49,  -875,  1951,
     609,  -875,  2639,  2640,  2641,  2642,  2643,  1484,  1209,  1414,
   -1635,  -917,  -870,  2494,  1646,  -870,   609,  1526,  2256,  1332,
    2610,  2611,  -875,  1449,  2109,   884,   802,  1268,  2352,  2256,
     609,  1837,  1667,   810,   904,  1836,  -870, -1494,  1579,  1580,
    1562,  2266,  2267,  2268,  2269,  1951,   609,   307,  1672,  2950,
     311,  2251,  2252,  2253,  2269,  2255,  2396,  1773,  2258,  1839,
    1041,   958,  2712,   847,   671,  2024,  2411,  1773,  2258,  -136,
    2188,  2189,   594,  2840,  -701,   594,  -701,  -931,  -704,   333,
    -704,  1952,   333,  3009,  1291,   901,  1300,  2403,  2258,  2843,
    1896,  1897,  2260,   885,  2847,   672,   892,  1308,  2849,  1620,
    1764,   869,  2261,  2262,  2263,   198,  2264,  2265,  2266,  2267,
    2268,  2269,  1566,  1702,  1024,  2411,  2902,  2259,  1309,  2315,
    1863,   886,   198,  1929,  2285,  1929,  1929,  1699,  1557,  1558,
    1559,  1560,  1561,  1562,  1864,  2983,  1690,  2259,   701,  1513,
    2418,   335,  2214,   963,   335,   652,    49,   737,  1021,   609,
     656,  1048,   594,  2689,  2802,   891,   594,  2216,  2971,   333,
    2258,  2306,  1743,   333,  1292,  1631,   781,  2850,   781,  2852,
     781, -1635,  1352,  -172,  2983,  2498,   781,  1051,  1848,  2521,
    1852,  1853,   869, -1494,  1396,  2518,   655,   699,  2907,  1557,
    1558,  1559,  1560,  1561,  1562,  1559,  1560,  1561,  1562,   220,
    2983,  2341,  2342,  2256,   336,  2920,   609,   336,    69,  2259,
    2690,    52, -1537,  2537,  1854,  1404,   220,  2073,  2617,   775,
      49,   335,  1397,   609,  1290,   335,  1055,  2866,    52, -1560,
   -1494,  2347,  2616,  2260,  1632,  1318,   801,  2264,  2265,  2266,
    2267,  2268,  2269,  2261,  2262,  2263,  1768,  2264,  2265,  2266,
    2267,  2268,  2269,  2260,  1419,  1691, -1576,  2940,  1056,  2910,
     151,  2624,  2625,  2261,  2262,  2263,  1692,  2264,  2265,  2266,
    2267,  2268,  2269,  2675,   806,  2522,   610, -1552,  1293,  2439,
   -1552, -1552,  2523, -1539,   336, -1552, -1586,  1941,   336, -1586,
   -1586,  1398,  2215,  2618, -1586,  2921,  2619,  2256,  2972, -1595,
     988,  2628,   989,  1591,  2380,  1680,  2213,  2217,  1567,  2561,
     821,  2441,  2691,  1188,  1835,  1698,   861,   168,    71,  2626,
    1294,  1693,   780,   652,   780,  2260,   780,  2257,   656,  1222,
     594,  1399,   780,   780,  2392,  2393,  1699,   333,   880,  2264,
    2265,  2266,  2267,  2268,  2269,  2258,  1901,  2955,  1833,  2973,
    2264,  2265,  2266,  2267,  2268,  2269,  2629,  1273, -1537,  2692,
    2027,  1223,   862,  1189,   655,  2824,  2974,   824,  1973,   784,
    1343,  2044,   920,  1782,  2628, -1560,  1221,  1851,  1696,  1999,
    2292,  1659,  1585,  1942,  1660,   611,   611,  1943,  1592,   842,
     881,  1400,  1731,  2202,  2259,  1775,  2895,  2505,  2550,   335,
    1276,   851, -1576,  2520,  2630, -1537,  2524,  2525,  2526,  2527,
    2528,  2529,  2530,  2531,  2532,  2533,  2794,  1775,   863,   198,
    2445,  2481, -1560,  2483,  1694,  2485,  1222,  2956,  2082, -1539,
    2825,  2085,  2086,   882,    70,  2644,   883,   609,  2293,  2258,
     825,  1700,    52,  1783,  1242, -1595,  1651,   881,  2446, -1576,
    2553,   857,   609,  1661,  1958,  2663,  2447,    52,  1223,  1881,
    1581,  2896,   336,  2650,  1974,   775,   214,  2354,  1975,   881,
      69,    69,  2677,    69,  1687,   151, -1539,  2630,  1242,   854,
     874,  1538,  2779,  2780,  1784,  1052,  2664,  2544,  2259,  2678,
     882,  2957, -1595,  1776,  1695,   871,   610,  1976,  1652,   610,
    1541,  2360,   864,  2783,   875,   884,  1582,   858,   151,  2651,
    2260,  2932,   882,   220,  1380,  1776,   876,  1068,  2448,  1411,
    2261,  2262,  2263,  2939,  2264,  2265,  2266,  2267,  2268,  2269,
    1381,   673,   168,   957,   959,   292,   218,    49,   859,   219,
     609,  1653,  1425,  1691,  1012,    52,  1785,    53,   700,  2784,
    1730, -1267,   981,  1241,  1692,  2679,   292,  1314,  -733,   193,
    1788,   759,   884,  1451,     9,   168,  1013,   769,  1396,  1465,
     609,   610,   610,   885,   895,    52,  3000,   183,  1315,  2680,
      71,    71,   770,    71,   884,   886,  1486,  2649,  1271,  1977,
     877,  1687,  1421,   907,  2412,  1830,  1422,  2070,  2874,  1911,
    1423,  2059,  2071,   823,  2260,  2681,  2488,  2013,  -733,  1693,
     183,   910,  1511,  1654,  2261,  2262,  2263,  1524,  2264,  2265,
    2266,  2267,  2268,  2269,  1520,  2224,   218,  2582,  1529,   219,
    1777,  2014,  2223,   609,   198,  1316,   609,  2996,    52,  2067,
    -733,  2018,  1911,   609,  2122,  2645,   775,  2583,    52,  2123,
      53,  1065,  1777,  1036,  1036,  2077,  1241,  1067,  1778,  2115,
    2116,  1467,  2754,    49,  1674,  1071,   609,   198,  2585,  2211,
    1243,  1588,   126,   127,  2212,  1398,  -875,  2225,  2102,  -875,
    2104,   214,  2682,   991,  2226,   992,  1797,  1798,  1799,   878,
    1741,  1575,  2683,  1204,   650,  1576,    70,    70,  1207,    70,
    -875,  1464,  2605,   220,  1243,   610,  2684,  2735,  1623,  1623,
    1215,  1623,  1694,  2685,   214,  1399,  1730,   594,   594,  -709,
    1734,  2695,   333,   920,   333,   333,  1956,  1669,  3001,  1036,
     925,  -709,  2150,  1045,   611,  1047,  2545,  1049,  2191,  2547,
     936,  2193,  2718,  1050,  2587,  -855,  2222,   962,  -855,  1645,
    1242,  2223,  2686,  1479,  1481,  1242,  1242,  2345,  1288,  -849,
     193,   220,  -849,   955,   594,  -709,  2538,  2539,  2731,  1482,
     963,   333,  2361,  2118,  2119,  1400,  1501,   965,   333,  1289,
    2256,  -709,  1695,  1488,   335,  1512,   335,   335, -1133,  -840,
     869,  2385,  -840,  2763,  1901,   854,  2233,  2386,  2387,  1662,
     984,  2223,  2413,   610,   985,  1684,  1513,  2235, -1136,  1721,
    1006,   652,  2223,  -709,   610,  1323,   656,  2324,   594,  2325,
     780,  -709,  2581,  1965,    69,   333,    49,  1901,    69,   609,
     748,   898,  -882,   335,   898,  -882,  1624,  1626,  1016,  1630,
     335,  2677,  1966,  1722,  1037,   610,   610,   336,  1015,   336,
     336,  3022,   655,  1503,  1504,  1027,  -882,   610,  2678,  1062,
    1271,  -885,  1387,  1388,  -885,  1271,  1271,  -852,  1063,  1395,
    -852,  1588,  2833,  2582,  2835,  1538,  2822,  1885,  1882,  2284,
    1883,  2286,  2287,  2238,  1884,  1505,    49,   335,  2239,   609,
    1895,  1495, -1453,  2583,  1541, -1453,   336,  1899,  -838,  1542,
    3023,  -838,  3024,   336,  1723,  -709,  2581,  1921,  2584,  1922,
    1528,  1064, -1455,  1067,  2585, -1455, -1459,  1069,   610,  1967,
     610,  1072,  2258,  1968,  2679,    52,  1969,    53,  1937,  1886,
    1938,  2326,  2586,  2327,    71,  1073, -1460,  2339,    71,  1724,
     853,  1725,  1074,  1687, -1452,  1830, -1451, -1452,  2680, -1451,
     336,  1726,  2844,  1503,  1504,  2244,  1075,  2582,  1212,  2128,
    2245,  -885,  2368,  2855,  -885,  2142,  2143,  2144, -1457,  1893,
   -1456,  2259,  1887,  2344,  2681,  1888,  1243,  2583,  2223,  1077,
    2901,  1243,  1243,  2358,    49,  1507,  2857,   609,  1584,  1192,
    2587,  2457,  2584,  1844,    49,  2256,  2458,   609,  2585,  1544,
    -841,  1727,    52,  -841,    53,  1911,  1911,  1911,  2011,  1911,
    1241,  -839,  1199,  2183,  -839,  1970,  2586,  1545,  1546,   652,
    1643,  1940,  1971,  1644,   656,  1663,   594,  1953,  1728,  1625,
    1625,  1201,  1625,   333,   780,  1963,   780,  1768,  1209,  1668,
     780,  1200,  1644,  1036,  1889,  2040,   780,  2439,  1644,  2845,
      70,  2682,  1208,   780,    70,  1549,  1615,   610,  2440,  2464,
     655,  2683,  1210,   780,  2465,   780,  1550,  2588,  2047,  1214,
    1538,  1644,  2476,  1911,  2587,  2684,  2012,  2477,  2496,  2441,
    2555,  2442,  2685,  2497,   780,  2223,   780,  2260,  2597,  1541,
    1212,  2935,  -701,  2223,  1542,   335,  1901,  2261,  2262,  2263,
     594,  2264,  2265,  2266,  2267,  2268,  2269,   333,  2598,  1218,
     618,  1220,  1890,  2223,  1212,   218,    49,   637,   219,   609,
     659,  2686,  2612,  2733,  2826,  1213,   869,  2477,  2734,  2753,
     659,  2756,  1216,   594,  2511,   594,  2443,  2258,  1851,  1219,
     333,  1226,   333,  1231,  2420,  2421,  2422,  2423,  2424,  1040,
     609,  2588,   611,  2107,  2638,   610,   637,  2042,   336,  2042,
    2420,  2421,  2422,  2423,  2424,   659,   698,  2772,  2425,   335,
    1269,  1270,  2477,  1235,   637,   659,  2836,  1232,   659,  1247,
    2138,  1250,  1553,   659,  2444,  1236,  2259,   659,  2445,  1237,
    1543,  1238,  2147,  1239,  1544,  1240,  1557,  1558,  1559,  1560,
    1561,  1562,   335,  2773,   335,  2837,  1252,   659,  2477,  2854,
    2734,  1262,  1545,  1546,  2223,  2887,  2446,  1056,   659,  1277,
    2888,   820,  1242,  1547,  2447,  2900,  2904,   836,  2909,   841,
    2497,  1584,   336,  2458,  2422,  2423,  2424,  1242,  1278,    69,
    2114,    69,  1280,  2114,  1490,  1491,  2911,  2121,  2929,  1287,
    1549,  2458,  2941,  1453,   854,  2943,  1286,  1584,  1831,  1832,
    2458,  1550,   610,  1301,  2965,   336,  2968,   336,  2339,  2223,
     966,  1584,  2998,  3030, -1459,  2227, -1460,  2999,  2999,  1242,
   -1457,  2388,  1242,  1242,  1677,  1270,  2448,  1733,  1735,  1736,
   -1456,   710,  1296,  1067,   738,  2171,  1819,  1820,   854,  1503,
    1504, -1122,  2260,  1866,   739,  1745,  1746,  1303,   854,   780,
     967,  1313,  1067, -1635, -1635,  1552,  2264,  2265,  2266,  2267,
    2268,  2269,   740,  2635,  2636,  2807,  2808,  2915,  2916,   968,
    1319,   780,  2362,  2363,  1330,   712,   780,  1334,   610,  1332,
     741,  1255,  1257,  1370,  1371,  2459,   969,  1271,   780,    71,
    1373,    71,  1385,   742,  1389,  1401,  2388,  1911,  1403,  1408,
    1911,  1911,  1911,  1911,  1911,  1911,  1911,  1911,  1911,  1911,
     743,   714,  1747,  2484,   970,  2487,  1407,  1553,  1409,  1429,
    1410,  1457,  1460,  1461,  1462,  1463,  2329,  2330, -1635, -1635,
     971,  1557,  1558,  1559,  1560,  1561,  1562,  1471,   744,  1520,
    1485,  2898,   745,  2552,  1911,  1474,  1475,  1476,  1478,  1480,
     220,  1487,  1494,  2346,   746,  1497,  1998,  1533,  2106,  1590,
    2510,  1498,  1748,  1749,  1499,  1500,   610,  1502,  1509,   610,
    1510,   780,  1571,   610,  1597,  2300,  1600,  1584,   716,  1221,
     717,  2133,  1613,  1520,  2519,  1614,  2302,  1621,  1243,  1750,
    1642,  1650,   927,  1520,   972,  1657,   928,  1664,  1658,  1666,
    1670,  1673,  1679,  1243,  1681,    70,  1963,    70,   929,   930,
    2026,  2540,  -504, -1404,  1683,  1688,  1689,  1701,   747,  1714,
    1717,   610,  2323,  1715,  1716,  1718,  1719,  1730,  1720,  1737,
     931,  2332,  1739,   932,   973,   974,  1738,  1740,  1742,   748,
     975,  2558,  1755,  1757,  1761,  1243,  1751,  1760,  1243,  1243,
    1762,  1769,  1482,  1488,  1467,  1495,  1771,  2339,   749,   750,
    1781,  2339,   976,   708,   751,  2339,  1794,  1805,  1813,  1814,
    1816,  2417,  1817,   994,   977,  1822,  1752,  3011,  1827,   978,
    1825,  1911,  1055,   995,   996,   997,   752,   998,   999,  1000,
    1001,  1002,  1003,  1840,  1841,   993,  1843,   979,   753,  1847,
    1846,  1855,  1856,   754,  1453,  1857,  1873,  1874,  1881,   780,
    1919,  1513,   755,  1920,  1538,  1242,  1933,  2880,  1936,  1944,
    2903,   756,  1935,  1945,  1959,  1962,  1978,  1980,  2000,  2016,
    2903,  2010,  2114,  2017,   862,  2019,  2028,  2032,  2037,  2480,
    2033,  2045,   652,  1773,  2046,   933,  2062,   656,  2050,   594,
    2063,  2057,  2066,  2816,  1031,  2060,   333,  2069,  2064,  2074,
    2083,  2099,  2101,  2103,  2434,  2105,  2108,   659,  2110,  2124,
      49,  2136,  2129,  2137,  2140,  2149,   637,  2153,  2154,  2169,
    2656,  2512,  1242,   655,  2170,  2942,  2173,  2515,  1242,  1242,
    2178,  2179,  2180,  2181,   659,   659,  2182,  2199,  2186,  2158,
    2220,  1911,  2185,  2221,  2172,  2236,  2187,  2201,   854,   292,
    2237,  2241,   292,  2240,  2242,  2279,  2478,   854,   335,  2479,
    2246,  2250,  1242,  2247,  2223,  1271,  2339,   780,  2271,   780,
    2272,  2339,  2278,  2280,  2298,  2339,  2303,  2281,  2299,  2429,
    2282,  2289,   292,   949,   637,   949,  2296,   618,   659,  2499,
     659,  2885,   786,   659,   618,  2568,  2569,  2570,  2571,  2307,
    2297,  2313,  2322,  2319,  2348,  2343,  1851,  2353,  2357,  2365,
    1194,  2367,   659,   787,  2369,   637,  2371,   949,  2374,   618,
    2372,   336,  1270,  1008,  2384,  2558,   659,  2377,   949,  2394,
     618,   788,  2373,  2378,  2382,  2395,  2398,   659,   659,  2400,
    2401,  2402,  1660,  2415,  2416,  2427,  2452,   659,  2454,  2426,
     637,  1019,  2460,   618,  2462,  2463,  2397,   659,   610,  2549,
    2472,   659,  2475,   618,  2482,  2339,   949,  2471,  2489,  2934,
     789,  2490,  1271,  2501,  2502,  1464,  2506,   780,  2509,  2133,
    2275,  1243,  2256,   780,   659,  1525,   659,  2274,  2557,  2430,
     610,  2541,   659,  1520,  2595,  2542,  2543,  2634,  2551,  1363,
     994, -1136,  2574,  2565,  2580,  2816,  1911,  1901,  1911,  2594,
     995,   996,   997,  2599,   998,   999,  1000,  1001,  1002,  1003,
     659,  2602,  2606,  2601,  2328,  1354,  2608,  2613,  2614,  2622,
    2627,  2623,  2647,  2658,  2660,  2666,   637,   659,   836,  2637,
     836,  2654,  1363,  2672,  2714,  2726,  2676,  2717,  1243,  2720,
    2721,  2722,  2724,   790,  1243,  1243,  2727,  2728,  2747,   994,
    2749,  2729,  2745,  2114,  2114,  2750,  2758,   791,  1354,   995,
     996,   997,   792,   998,   999,  1000,  1001,  1002,  1003,  2761,
    2764,  2765,  2775,  2768,  2785,  2776,  2629,  2788,  1243,  2789,
    2790,  2797,  2791,  2799,  2995,  2801,   793,  2803,   794,  2804,
    2805,  2806,  2838,    69,  2811,  2820,  2823,   795,  2829,  2821,
    2830,   618,   618,  2834,  1911,  1261,  2831,  2841,  2848,   796,
     797,  2851,  2860,  2867,  2653,  2872,  2878,  3021,  2881,  2882,
    2892,  2893,  2906,  2674,  2883,   659,  2894,   292,   659,  2897,
    2913,   659,  2918,  2919,  2671,   610,  1662,  2922,  2926,  2930,
    2937,  2938,  2948,   780,  2960,  2951,  2953,  2966,   780,   780,
     780,   780,   780,   949,  2967,  2950,  2970,  2949,  2980,  2985,
     623,  1322,  2988,  2991,  2986,  2992,  3010,   623,  3025,   856,
     994,   659,  3026,  2455,  3012,   659,  2453,  2350,   659,  2461,
     995,   996,   997,   659,   998,   999,  1000,  1001,  1002,  1003,
    2777,   949,  1789,  1612,  2351,  2391,  2151,  1594,  2662,  2092,
    2615,  2795,  2990,    71,  2668,  1378,   623,  2376,  2694,  2969,
    2954,  2459,  2952,   949,  1392,  2976,   659,  2879,  2928,  2669,
    2139,  3028,  1808,  3015,   623,   734,  1014,  2787,  2786,   949,
    2997,  2406,  1793,   734,  3029,   808,  1867,   623,  2503,   610,
     610,  2332,  1076,  2715,  1446,  2332,  2381,  2933,  2474,  2332,
     659,  2767,  2152,  2827,  2917,   623,  1459,   623,  2133,  2133,
    2133,  2133,  2133,  3003,  3027,  2145,   659,  2349,   734,   762,
    2025,  2500,  1424,  2359,  2114,  2114,  2190,  2364,  1538,  2782,
    2696,  1640,  1638,  2023,  2576,  2755,  2908,  1770,  2548,  1914,
    1539,  1363,  2661,  1991,  2769,  2317,  2230,  1541,  2944,  2732,
    2355,  1363,  1542,  2832,  2716,  1321,  2049,  1264,  1675,   610,
    2048,  1391,   868,  1649,   896,  2979,   304,  1354,   870,    70,
     919,  2038,  1456,  1285,  2810,  1434,  2197,  1354,  2198,  2819,
    1258,  2051,  1578,  1588,  2697,   890,  2600,  2055,  2192,  1842,
    1266,    76,     0,     0,     0,     0,   780,     0,     0,  2572,
    2573,     0,  1363,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1663,     0,     0,     0,     0,     0,     0,     0,
       0,  1830,     0,     0,     0,   637,   637,  1363,  1354,     0,
       0,     0,     0,     0,     0,     0,     0,  1589,     0,     0,
       0,     0,     0,     0,     0,  1611,  1611,     0,  1543,     0,
       0,     0,  1544,  1354,     0,     0,  1619,     0,  1363,     0,
    2332,     0,  1363,     0,     0,  2332,     0,     0,     0,  2332,
    1545,  1546,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1547,     0,     0,  1354,     0,   703,   610,  1354,     0,
       0,     0,     0,     0,     0,     0,   704,  2646,   637,     0,
     618,     0,     0,     0,     0,  1548,     0,     0,  1549,     0,
     610,   610,     0,     0,   705,   610,   658,  2655,     0,  1550,
       0,  1551,     0,     0,  2657,     0,   660,     0,   659,     0,
     706,     0,  -390,   785,     0,     0,     0,   836,     0,     0,
       0,   292,     0,     0,     0,   707,     0,     0,  2479,     0,
       0,   708,     0,     0,     0,     0,     0,     0,     0,  2332,
     610,   690,   709,   836,     0,   610,     0,  3020,     0,   610,
       0,   731,     0,  1552,   736,     0,     0,  2977,  2978,   731,
       0,   786,     0,   779,     0,     0,     0,     0,     0,     0,
       0,     0,   710,  1363,   711,  2936,     0,     0,     0,     0,
       0,     0,   787,   809,     0,     0,  -491,     0,     0,     0,
       0,     0,     0,     0,   731,     0,     0,  2946,  2947,  1354,
     788,     0,     0,     0,     0,     0,     0,  -327,     0,     0,
       0,     0,     0,     0,     0,  1553,   712,  1589,  2741,  2742,
    2743,  2744,     0,     0,     0,  1554,  1555,  1556, -1632,  1557,
    1558,  1559,  1560,  1561,  1562,     0,     0,  2290,   618,   789,
       0,     0,   949,     0,     0,     0,  2291,   659,     0,     0,
     713,     0,   714,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -1632,     0,     0,   659,     0,   659,
     659,  -327,     0,     0,     0,     0, -1632,  1860,     0,     0,
     292, -1632,     0,     0,     0,     0, -1632, -1632,     0, -1632,
       0,   715,  3019,     0,     0,     0,  -238,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   734,     0,     0,
   -1632,     0,  1355,   780,   780,   292,   623,     0,  -238,   716,
       0,   717,   790,     0,     0,  1902, -1632,     0,     0,     0,
     718,     0,     0,     0,   719,   720,   791,     0,   721,     0,
       0,   792,     0,     0,   722,  1363,   911,     0,     0,     0,
       0,     0,     0,     0,     0,  1355,     0,     0, -1632,     0,
       0,   610,     0,     0,     0,   793, -1632,   794,     0,     0,
       0,  1354,     0,     0,     0,     0,   795,     0,     0,     0,
       0,     0,     0,   610,   610,     0,     0,     0,   796,   797,
    1363,     0,  1363,     0,     0,     0,     0,     0,     0,     0,
     659,     0,     0,     0,     0,     0,  1363,     0,     0,     0,
       0,     0,   659,     0,     0,     0,  1354,     0,  1354,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   806,  1354,     0,     0,     0,     0,   734,   734,     0,
       0,  2869,     0,     0,  2021,     0,     0,     0,     0,   659,
   -1632,     0,     0,     0,     0,     0,  1067,     0,     0,     0,
    1363,     0,     0,     0,     0,     0,     0,     0,   734, -1632,
       0,     0,   623,     0,   623,     0,   623,     0,     0,  2899,
       0,     0,   623,   623,     0,     0,  1354,     0,     0,     0,
       0,     0,   734,     0,     0,     0,     0,     0,   618,     0,
       0,  1261,     0, -1632, -1632, -1632,     0,     0,     0,     0,
    2914,     0,     0,     0,     0,     0,   659,   637,     0,     0,
     659,     0,     0,     0,     0,     0,   659,     0,     0,   618,
       0,     0,     0,     0,  1538,     0,   623,     0,     0,   623,
       0,     0,     0,   618,   618,   618,   659,  2080,   659,     0,
       0,     0,     0,  1541,     0,     0,     0,     0,  1542,     0,
    2093,  2094,   659,  2096,   659,     0,   659,     0,   618,     0,
     618,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   949,   949,     0,
       0,     0,     0,     0,   623,     0,     0,     0,     0,     0,
    1530,  2135,     0,   897,     0,     0,     0,     0,     0,     0,
       0,   623,   623,     0,  1355,     0,     0,     0,  1531,   618,
       0,     0,   618,  1357,  1355,     0,     0,     0,     0,     0,
     905,   906,     0,  2157,     0,     0,     0,     0,  2168,     0,
       0,     0,     0,     0,     0,  2177,     0,     0,     0,     0,
       0,     0,     0,  1532,  1543,  2080,     0,     0,  1544,     0,
       0,     0,     0,     0,     0,     0,  1357,  1533,   659,     0,
       0,   659,     0,  1534,     0,  1355,  1545,  1546,     0,     0,
       0,     0,     0,  2206,   954,     0,   956,  1547,     0,   960,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1355,     0,     0,     0,     0,     0,  1363,     0,   983,     0,
       0,  1548,     0,     0,  1549,     0,     0,     0,     0,     0,
       0,     0,  1009,     0,     0,  1550,     0,     0,  1363,     0,
       0,  1355,  1354,   897,   731,  1355,     0,     0,     0,     0,
       0,     0,     0,  1026,     0,   623,     0,     0,     0,     0,
       0,     0,     0,  1033,  1354,     0,     0,  1034,     0,  1363,
       0,     0,     0,  1433,  2295,     0,     0,     0,     0,  1438,
       0,     0,     0,  1902,     0,     0,     0,   734,     0,  1552,
    1053,     0,  1054,   994,     0,  1354,     0,     0,   897,     0,
       0,     0,  1363,   995,   996,   997,     0,   998,   999,  1000,
    1001,  1002,  1003,  1363,     0,     0,  1902,     0,  1363,     0,
       0,     0,  1538,     0,     0,     0,  1070,     0,  1354,     0,
    1363,     0,  1363,     0,     0,     0,     0,     0,     0,  1354,
       0,  1541,     0,     0,  1354,     0,  1542,     0,     0,     0,
       0,  1553,     0,   623,     0,  1611,  1354,     0,  1354,     0,
    1619,  1554,  1555,  1556,   623,  1557,  1558,  1559,  1560,  1561,
    1562,   659,     0,     0,     0,     0,  1355,  1363,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   637,     0,
       0,  1574,     0,     0,     0,   623,   623,     0,     0,     0,
       0,  1363,  2177,  1354,     0,     0,     0,   623,     0,     0,
     623,     0,   659,     0,     0,   623,   623,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1354,  1363,     0,
       0,     0,     0,     0,     0,  1357,     0,     0,     0,     0,
       0,  1279,  1543,   618,  1281,  1357,  1544,  1283,     0,     0,
       0,     0,     0,     0,  1354,     0,     0,     0,  1363,     0,
       0,     0,     0,     0,  1545,  1546,     0,     0,   623,  2135,
     623,     0,     0,     0,     0,  1547,     0,     0,     0,     0,
     623,   659,   659,     0,  1354,     0,     0,  1327,     0,     0,
       0,  1328,     0,     0,  1329,     0,  1357,     0,     0,  1369,
       0,     0,  1549,     0,     0,     0,     0,     0,  2470,     0,
       0,     0,     0,  1550,     0,     0,     0,     0,  1538,   659,
       0,  1357,     0,     0,     0,     0,     0,     0,     0,     0,
    1539,     0,  1394,     0,     0,     0,     0,  1541,     0,     0,
       0,  2492,  1542,     0,     0,     0,     0,     0,  1355,     0,
    1860,     0,  1357,     0,     0,     0,  1357,     0,     0,  2206,
       0,     0,     0,     0,     0,     0,  1426,  1552,     0,     0,
       0,     0,   949,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1455,     0,     0,  1902,     0,     0,     0,     0,
       0,     0,     0,  1355,     0,  1355,   337,  1363,     0,   337,
       0,     0,     0,     0,     0,     0,     0,   623,     0,  1355,
       0,   638,   337,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1354,     0,     0,     0,     0,     0,  1553,
       0,     0,     0,     0,     0,   337,     0,     0,  1543,  1554,
    1555,  1556,  1544,  1557,  1558,  1559,  1560,  1561,  1562,  1358,
     638,  1574,     0,  1845,     0,     0,     0,     0,     0,     0,
    1545,  1546,     0,  1355,     0,     0,     0,     0,   638,     0,
    2579,  1547,     0,     0,  2579,  2593,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1357,     0,     0,
       0,     0,  1358,     0,   623,  1548,   623,     0,  1549,     0,
     623,     0,  1363,     0,     0,   623,   623,     0,     0,  1550,
       0,  1551,     0,   623,     0,  2177,  2177,     0,     0,     0,
       0,     0,     0,   623,     0,   623,     0,     0,  1354,     0,
       0,     0,   659,   659,   337,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   623,     0,   623,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2135,  2135,
    2135,  2135,  2135,  1552,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   659,     0,
       0,     0,     0,     0,  1433,     0,     0,     0,     0,     0,
    2008,     0,     0,     0,  1682,     0,  2157,     0,  2093,     0,
       0,  2093,     0,  2670,     0,     0,     0,     0,     0,     0,
    2080,     0,   623,     0,     0,  2177,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1553,   337,     0,     0,     0,
       0,     0,  2206,     0,     0,  1554,  1555,  1556,     0,  1557,
    1558,  1559,  1560,  1561,  1562,     0,     0,  1538,     0,     0,
       0,     0,     0,     0,  2243,     0,     0,     0,     0,  1357,
       0,     0,     0,     0,     0,     0,  1541,     0,     0,     0,
       0,  1542,     0,     0,     0,     0,     0,     0,     0,  1363,
       0,     0,   623,     0,     0,     0,     0,     0,   623,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1357,  1354,  1357,     0,     0,  1355,
       0,     0,  2579,     0,     0,  2746,     0,     0,     0,     0,
    1357,     0,     0,     0,     0,     0,     0,     0,     0,  2760,
       0,  1355,     0,  1838,     0,     0,     0,     0,  2305,   623,
    2021,     0,   623,   623,  2770,     0,   659,     0,     0,     0,
       0,  1358,   659,     0,     0,     0,     0,  2778,     0,     0,
       0,  1358,  1355,     0,     0,     0,     0, -1635,     0,   623,
       0,  1544,     0,     0,  1357,     0,   623,     0,     0,   623,
       0,     0,     0,   623,     0,     0,     0,     0,     0,  1545,
    1546,   623,     0,     0,     0,  1355,   623,     0,  1363,     0,
   -1635,     0,     0,     0,     0,     0,  1355,     0,   623,     0,
       0,  1355,  1358,     0,  2817,     0,     0,     0,     0,  1589,
       0,     0,     0,  1355,  1354,  1355,     0,  1549,     0,     0,
       0,   623,     0,     0,     0,     0,     0,  1358,  1550,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   734,  1433,
       0,   734,  2196,  2196,  1438,     0,     0,     0,  1358,     0,
    1355,     0,  1358,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2579,     0,   659,  2007,     0,     0,     0,
       0,   623, -1635,     0,  1355,     0,     0,  2157,  2009,  2853,
       0,     0,  1363,     0,     0,     0,     0,     0,   337,     0,
       0,   337,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1355,     0,     0,     0,     0,     0,     0,  1354,     0,
     638,     0,     0,     0,     0,  2080,  2093,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   949,
       0,  1355,     0,   949,  1553,     0,     0,     0,  1363,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1557,  1558,
    1559,  1560,  1561,  1562,     0,     0,     0,     0,     0,   659,
       0,     0,     0,     0,  1354,     0,     0,     0,   337,  2853,
       0,     0,   337,     0,     0,     0,   946,     0,     0,     0,
     946,     0,  2058,  1358,     0,     0,  2061,     0,     0,  1538,
       0,     0,  2065,     0,     0,     0,   659,     0,     0,     0,
    1357,  1539,     0,     0,     0,   946,  2817,   949,  1541,   623,
       0,     0,  2078,  1542,  2081,   623,     0,     0,     0,     0,
       0,     0,  1357,     0,   659,     0,     0,     0,  2095,     0,
    2098,     0,  2100,     0,     0,     0,     0,  1022,     0,     0,
     946,     0,     0,     0,     0,     0,   946,     0,  1538,   949,
       0,     0,     0,  1357,     0,     0,     0,     0,     0,     0,
    1539,     0,     0,     0,     0,     0,     0,  1541,     0,     0,
    1355,     0,  1542,     0,     0,     0,     0,     0,  2984,     0,
       0,     0,   623,   949,     0,     0,  1357,     0,   623,   623,
       0,     0,     0,     0,     0,     0,  1902,  1357,     0,     0,
       0,     0,  1357,     0,     0,     0,     0,     0,   623,  1543,
       0,     0,     0,  1544,  1357,     0,  1357,  2984,     0,     0,
       0,     0,   623,     0,     0,     0,     0,   623,  1174,   623,
     638,  1545,  1546,     0,   897, -1634,     0,   897,     0,   623,
     623,     0,  1547,  2984,     0,     0,   337,     0,     0,     0,
       0,     0,     0,     0,     0,  1358,     0,     0,     0,     0,
       0,  1357,     0,     0,     0,     0,  1548,     0,  1543,  1549,
       0, -1634,  1544,     0,     0,  1355,     0,     0,     0,   734,
    1550,     0,  1551, -1634,     0,  1357,     0,     0, -1634,     0,
    1545,  1546,     0, -1634, -1634,     0, -1634,     0,     0,     0,
    1358,  1547,  1358,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1357,     0,     0,     0,  1358, -1634,     0,     0,
       0,     0,     0,     0,     0,  1548,     0,     0,  1549,     0,
       0,     0,     0, -1634,  1552,     0,     0,   623,     0,  1550,
       0,  1551,  1357,   623,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -1634,     0,     0,   946,     0,
    1358,     0,   946, -1634,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1368,     0,     0,     0,
       0,     0,     0,  1552,     0,   623,  1553,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1554,  1555,  1556,     0,
    1557,  1558,  1559,  1560,  1561,  1562,     0,     0,     0,   946,
    1538,     0,     0,     0,     0, -1050,     0,     0,     0,  1368,
       0,     0,  1539,     0,     0,     0,     0,     0,   806,  1541,
       0,     0,     0,     0,  1542,     0,     0,     0,     0,     0,
       0,     0,  1355,     0,     0,  1553,     0, -1634,     0,     0,
       0,     0,     0,     0,     0,  1554,  1555,  1556,  2383,  1557,
    1558,  1559,  1560,  1561,  1562,     0, -1634,     0,     0,  1934,
       0,  1357,     0,     0,  1174,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   623,
     623,     0,     0,     0,     0,     0,  1174,     0,     0,     0,
   -1634, -1634, -1634,   623,     0,     0,     0,     0,   623,   623,
     623,   623,   623,     0,  1538,     0,     0,     0,     0,     0,
    1174,  1174,     0,  1174,  1174,  1174,     0,  2436,  2438,     0,
    1543,     0,     0,  1541,  1544,     0,     0,     0,  1542,     0,
       0,  1174,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1545,  1546,  2469,     0,     0,     0,     0,   623,
       0,  1355,     0,  1547,     0,   731,     0,     0,     0,   638,
     638,     0,     0,     0,     0,     0,  1357,  2196,     0,     0,
       0,     0,     0,     0,  1596,     0,     0,  1548,     0,     0,
    1549,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1550,     0,  1551,     0,  2314,  1358,     0,     0,     0,
       0,  1174,     0,     0,  1174,  1174,     0,     0,     0,     0,
       0,   337,     0,   337,   337,     0,     0,     0,  1358,     0,
       0,     0,     0,     0, -1635,     0,     0,     0,  1544,     0,
       0,     0,   638,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1552,  1545,  1546,     0,  1358,
       0,     0,     0,     0,     0,  1355,     0, -1635,     0,     0,
     337,     0,     0,     0,     0,     0,     0,   337,  1368,     0,
       0,     0,     0,     0,     0,     0,     0,   623,  1368,     0,
       0,     0,  1358,     0,  1549,     0,     0,     0,     0,     0,
       0,     0,     0,  1358,     0,  1550,   623,     0,  1358,     0,
     623,   623,     0,     0,     0,   623,     0,  1553,     0,     0,
    1358,  1355,  1358,  1360,   337,     0,     0,  1554,  1555,  1556,
       0,  1557,  1558,  1559,  1560,  1561,  1562,     0,     0,  1368,
       0,     0,     0,     0,     0,     0,  2912,     0,     0,     0,
       0,     0,     0,  1357,     0,     0,     0,     0,     0, -1635,
     623,     0,     0,     0,  1368,   623,  1360,  1358,     0,   623,
       0,     0,     0,     0,     0,     0,     0,     0,  2620,  2621,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1358,     0,  1174,     0,  1368,     0,     0,     0,  1368,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1358,     0,
       0,  1553,     0,     0,  2648,     0,     0,     0,     0,     0,
       0,     0,   946,     0,     0,  1557,  1558,  1559,  1560,  1561,
    1562,     0,     0,     0,     0,     0,     0,     0,  1358,     0,
       0,     0,     0,     0,     0,  1174,  1174,     0,     0,     0,
       0,     0,     0,  1174,     0,  1538,  1174,  1174,     0,     0,
       0,     0,  1357,     0,     0,     0,     0,  1539,     0,  1894,
       0,     0,     0,     0,  1541,  1538,  1174,     0,     0,  1542,
    1174,  1174,  1174,     0,  1174,     0,     0,  1539,     0,     0,
       0,  1174,  1174,     0,  1541,  1174,     0,     0,     0,  1542,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1368,  1174,   337,     0,  1174,  1174,     0,     0,     0,  1174,
       0,     0,     0,  1174,     0,     0,  1174,  1174,  1174,  1174,
    1174,  1174,  1174,  1174,  1174,  1174,     0,     0,     0,  1174,
       0,   597,     0,  1174,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   597,     0,  1357,     0,     0,     0,
       0,   623,     0,     0,     0,  1543,     0,  1358,     0,  1544,
       0,     0,  2771,  1361,     0,     0,     0,   597,  2774,     0,
       0,     0,     0,   623,   623,  1543,   337,  1545,  1546,  1544,
       0,     0,     0,     0,     0,     0,     0,     0,  1547,     0,
       0,     0,     0,     0,     0,  1360,     0,  1545,  1546,     0,
       0,     0,  1357,     0,     0,  1360,  1361,     0,  1547,   337,
       0,   337,  1548,   623,   623,  1549,     0,     0,   623,     0,
       0,     0,     0,     0,     0,     0,  1550,     0,  1551,     0,
       0,     0,  1548,     0,     0,  1549,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1550,     0,  1551,     0,
       0,     0,     0,     0,     0,     0,  1360,   623,     0,     0,
       0,     0,  1358,     0,  1174,     0,   597,     0,     0,     0,
       0,     0,  1368,     0,     0,     0,     0,     0,     0,     0,
    1552,  1360,     0,   623,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1552,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1360,     0,     0,     0,  1360,  1368,     0,  1368,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1174,     0,  1368,     0,     0,     0,     0,     0,     0,
       0,     0,  1553,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1554,  1555,  1556,     0,  1557,  1558,  1559,  1560,
    1561,  1562,  1553,     0,     0,     0,  2273,     0,     0,     0,
    1538,     0,  1554,  1555,  1556,     0,  1557,  1558,  1559,  1560,
    1561,  1562,  1539,     0,     0,     0,  2414,  1368,     0,  1541,
       0,     0,     0,     0,  1542,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1174,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2927,     0,     0,     0,  1174,     0,     0,  1358,
       0,     0,     0,     0,     0,     0,     0,  1360,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1361,     0,  1174,  1174,  1174,
    1174,  1174,     0,     0,     0,  1361,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1174,  1174,  1174,  1174,
    1543,     0,     0,     0,  1544,     0,     0,  1174,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1174,
       0,     0,  1545,  1546,  1174,     0,     0,     0,     0,     0,
       0,     0,     0,  1547,  1174,     0,  1361,     0,     0,     0,
       0,     0,     0,     0,     0,  1174,  1174,     0,  1174,     0,
       0,     0,  1174,     0,     0,     0,     0,  1548,     0,     0,
    1549,  1361,     0,     0,     0,     0,     0,     0,  1358,     0,
       0,  1550,   946,  1551,  1174,  1174,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1361,     0,     0,     0,  1361,     0,     0,     0,
    1174,     0,     0,     0,     0,     0,     0,  1174,  1174,  1174,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1552,     0,  1538,     0,  1360,
       0,     0,  1174,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1368,     0,     0,  1541,     0,     0,     0,
     597,  1542,     0,   597,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1368,     0,     0,     0,     0,
       0,     0,  1358,     0,  1360,     0,  1360,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1553,     0,     0,
    1360,     0,     0,     0,     0,   337,  1368,  1554,  1555,  1556,
       0,  1557,  1558,  1559,  1560,  1561,  1562,  1362,     0,     0,
       0,  2609,     0,     0,     0,     0,     0,     0,  2562,     0,
       0,     0,     0,     0,     0,     0,     0,  1361,  1358,  1368,
     597,     0,     0,     0,   597,     0,     0,     0,   944,     0,
    1368,     0,   944,     0,  1360,  1368,     0, -1635,     0,     0,
    1362,  1544,     0,     0,     0,     0,     0,  1368,     0,  1368,
       0,     0,     0,     0,     0,     0,     0,   944,     0,  1545,
    1546,     0,     0,   946,     0,     0,     0,     0,     0,     0,
   -1635,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1538,     0,     0,     0,     0,  1174,     0,     0,     0,     0,
       0,  1174,   944,     0,  1368,     0,     0,  1549,   944,  1541,
       0,     0,     0,  1174,  1542,  1174,     0,     0,  1550,     0,
    1174,     0,     0,     0,     0,     0,     0,     0,  1368,  1174,
       0,     0,  1174,  1174,  1174,  1174,  1174,  1174,  1174,  1174,
    1174,  1174,     0,     0,     0,     0,  1174,  1174,     0,     0,
       0,     0,     0,     0,     0,  1368,     0,     0,     0,     0,
    1174,     0,     0,  1174,  1538,     0,     0,     0,     0,     0,
       0,     0, -1635,     0,     0,  1174,  1174,  1174,     0,  1174,
       0,  2563,     0,  1541,     0,  1368,  1174,     0,  1542,     0,
    1170,  1174,     0,     0,  1174,     0,     0,     0,     0,  1361,
       0,     0,     0,   946,     0,     0,     0,     0,   597,     0,
   -1635,     0,     0,     0,  1544,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1174,
       0,     0,  1545,  1546,  1553,     0,     0,     0,     0,     0,
       0,     0,     0, -1635,  1361,     0,  1361,     0,  1557,  1558,
    1559,  1560,  1561,  1562,     0,  2566,     0,     0,     0,     0,
    1361,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1549,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1550,     0,     0, -1635,     0,     0,     0,  1544,     0,
    1360,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1545,  1546,     0,  1362,
       0,     0,  1360,  1174,  1361,     0,  1365, -1635,     0,  1362,
       0,     0,     0,     0,  1368,     0,     0,     0,     0,     0,
     944,     0,     0,     0,   944, -1635,     0,     0,     0,     0,
       0,     0,     0,  1360,  1549,     0,     0,     0,  1367,     0,
       0,     0,     0,     0,     0,  1550,     0,     0,     0,  1365,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1174,
    1362,     0,     0,     0,     0,     0,  1360,     0,     0,  1174,
       0,   944,     0,     0,     0,     0,     0,  1360,     0,     0,
       0,  1367,  1360,     0,     0,  1362,     0,  1553,     0,     0,
       0,     0,     0,     0,  1360,     0,  1360,     0,     0, -1635,
       0,  1557,  1558,  1559,  1560,  1561,  1562,     0,     0,     0,
       0,     0,     0,     0,     0,  1538,  1362,     0,     0,  1368,
    1362,     0,     0,  1174,  1174,  1174,     0,  1539,  1174,     0,
       0,     0,     0,     0,  1541,     0,  1170,     0,     0,  1542,
       0,  1360,   946,     0,     0,     0,   946,     0,     0,     0,
     946,     0,     0,     0,     0,     0,  1174,     0,  1170,     0,
       0,  1553,     0,     0,     0,  1360,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1557,  1558,  1559,  1560,  1561,
    1562,     0,  1170,  1170,     0,  1170,  1170,  1170,     0,     0,
       0,     0,  1360,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1170,     0,     0,     0,     0,     0,  1174,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1360,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1543,     0,     0,   946,  1544,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1361,  1362,     0,     0,     0,     0,     0,  1545,  1546,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1547,     0,
       0,     0,  1361,  1170,     0,     0,  1170,  1170,     0,  1174,
       0,     0,     0,     0,     0,   597,   597,     0,  1174,     0,
    1174,     0,  1548,     0,     0,  1549,  1368,     0,     0,     0,
    1174,     0,     0,  1361,     0,     0,  1550,     0,  1365,     0,
       0,   946,     0,     0,     0,     0,   946,     0,  1713,     0,
     946,     0,     0,     0,     0,     0,  1174,  1174,     0,     0,
    1174,     0,   597,     0,     0,     0,  1361,     0,     0,     0,
    1367,     0,     0,     0,     0,     0,     0,  1361,     0,     0,
    1367,   946,  1361,  1538,     0,     0,     0,     0,     0,     0,
    1552,  1360,     0,     0,  1361,  1539,  1361,     0,     0,  1365,
       0,     0,  1541,     0,  1174,     0,     0,  1542,     0,     0,
       0,     0,     0,     0,     0,     0,   597,     0,     0,  1538,
       0,     0,     0,     0,  1365,     0,  1174,     0,     0,     0,
       0,  1367,     0,     0,     0,     0,  1174,     0,  1541,     0,
     946,  1361,     0,  1542,     0,  1368,     0,     0,     0,     0,
       0,     0,  1553,  1362,     0,  1365,  1367,     0,     0,  1365,
       0,     0,  1554,  1555,  1556,  1361,  1557,  1558,  1559,  1560,
    1561,  1562,     0,     0,     0,     0,     0,     0,     0,     0,
     946,     0,     0,     0,  1174,  1170,     0,  1367,     0,     0,
       0,  1367,  1361,     0,     0,     0,  1360,     0,  1362,     0,
    1362,     0,     0,  1543,  1174,     0,     0,  1544,     0,     0,
    2738,     0,     0,     0,  1362,     0,     0,     0,     0,     0,
       0,     0,  1361,     0,   944,  1545,  1546,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1547,     0,     0, -1635,
       0,     0,     0,  1544,     0,     0,     0,  1170,  1170,  1368,
       0,     0,     0,     0,     0,  1170,     0,     0,  1170,  1170,
    1548,  1545,  1546,  1549,     0,     0,     0,     0,  1362,   946,
       0,     0, -1635,     0,  1550,     0,  1551,     0,  1170,     0,
       0,     0,  1170,  1170,  1170,     0,  1170,     0,     0,     0,
    1365,     0,     0,  1170,  1170,     0,     0,  1170,     0,  1549,
       0,     0,   946,     0,     0,  1368,     0,     0,     0,     0,
    1550,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1367,  1170,   597,     0,  1170,  1170,  1552,     0,
       0,  1170,     0,     0,     0,  1170,     0,     0,  1170,  1170,
    1170,  1170,  1170,  1170,  1170,  1170,  1170,  1170,     0,     0,
       0,  1170,     0,     0,     0,  1170,     0,     0,     0,     0,
       0,  1361,     0,     0, -1635,     0,   657,     0,     0,     0,
       0,     0,     0,  1360,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   657,
    1553,     0,     0,     0,     0,     0,     0,     0,   597,     0,
    1554,  1555,  1556,     0,  1557,  1558,  1559,  1560,  1561,  1562,
       0,     0,     0,     0,  2723,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1553,     0,     0,     0,
       0,   597,     0,   597,     0,     0,     0,     0,     0,     0,
    1557,  1558,  1559,  1560,  1561,  1562,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1713,     0,     0,     0,  1361,     0,     0,     0,
       0,  1538,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1539,     0,     0,  1170,     0,   657,     0,
    1541,     0,  1360,     0,  1367,  1542,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1365,     0,  1365,
       0,     0,     0,     0,  1362,     0,     0,     0,     0,     0,
       0,     0,     0,  1365,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1362,     0,     0,  1367,
       0,  1367,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1170,     0,  1367,     0,     0,     0,     0,
       0,  1538,     0,     0,     0,     0,     0,  1362,     0,     0,
       0,     0,     0,  1539,     0,     0,     0,  1365,     0,     0,
    1541,     0,     0,     0,     0,  1542,     0,     0,     0,     0,
       0,  1543,     0,     0,     0,  1544,  1360,     0,     0,     0,
    1362,     0,     0,     0,     0,     0,     0,     0,     0,  1367,
       0,  1362,     0,  1545,  1546,     0,  1362,     0,     0,     0,
       0,     0,     0,     0,  1547,     0,     0,     0,  1362,     0,
    1362,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1170,     0,  1361,     0,     0,     0,     0,  1548,     0,
       0,  1549,  1360,     0,     0,     0,     0,     0,  1170,     0,
       0,     0,  1550,     0,  1551,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1362,     0,     0,     0,     0,
       0,  1543,     0,     0,     0,  1544,     0,     0,     0,  1170,
    1170,  1170,  1170,  1170,     0,     0,     0,     0,     0,  1362,
       0,     0,     0,  1545,  1546,     0,     0,     0,  1170,  1170,
    1170,  1170,     0,     0,  1547,     0,  1552,     0,     0,  1170,
       0,     0,     0,     0,     0,     0,  1362,     0,     0,     0,
       0,  1170,     0,     0,     0,     0,  1170,     0,  1548,     0,
       0,  1549,     0,     0,     0,     0,  1170,     0,     0,     0,
       0,     0,  1550,     0,  1551,     0,  1362,  1170,  1170,     0,
    1170,     0,  1361,     0,  1170,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1553,     0,
       0,     0,     0,     0,   944,     0,  1170,  1170,  1554,  1555,
    1556,     0,  1557,  1558,  1559,  1560,  1561,  1562,     0,     0,
       0,     0,  2740,     0,     0,     0,  1552,     0,     0,     0,
       0,     0,  1170,     0,     0,     0,     0,     0,     0,  1170,
    1170,  1170,     0,  1713,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1538,     0,     0,     0,     0,
       0,     0,     0,     0,  1170,  1365,     0,  1539,     0,     0,
       0,     0,     0,     0,  1541,  1367,     0,     0,     0,  1542,
       0,     0,     0,     0,     0,     0,  1361,     0,  1553,     0,
       0,     0,     0,     0,     0,     0,  1713,  1367,  1554,  1555,
    1556,     0,  1557,  1558,  1559,  1560,  1561,  1562,     0,     0,
       0,     0,  2871,     0,     0,  1362,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   597,  1367,  1365,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1365,     0,  1361,     0,     0,  1713,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1365,     0,  1365,
       0,  1367,   657,     0,     0,     0,     0,     0,     0,     0,
     943,     0,  1367,     0,   943,  1543,     0,  1367,     0,  1544,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1367,
       0,  1367,     0,     0,     0,     0,     0,  1545,  1546,   943,
       0,     0,     0,     0,  1365,   944,     0,     0,  1547,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1362,     0,     0,     0,     0,     0,     0,  1170,  1365,     0,
       0,     0,  1548,  1170,   943,  1549,  1367,     0,     0,     0,
     943,     0,     0,     0,     0,  1170,  1550,  1170,  1551,     0,
       0,     0,  1170,     0,     0,  1365,     0,     0,     0,     0,
    1367,  1170,     0,     0,  1170,  1170,  1170,  1170,  1170,  1170,
    1170,  1170,  1170,  1170,     0,     0,     0,     0,  1170,  1170,
       0,     0,     0,     0,     0,  1365,     0,  1367,     0,     0,
       0,     0,  1170,     0,     0,  1170,     0,     0,     0,     0,
    1552,     0,     0,     0,     0,     0,     0,  1170,  1170,  1170,
       0,  1170,     0,     0,     0,  1538,     0,  1367,  1170,     0,
       0,     0,  1169,  1170,     0,     0,  1170,  1539,     0,     0,
       0,     0,     0,     0,  1541,   944,     0,     0,     0,  1542,
     657,     0,     0,     0,     0,  1538,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1539,     0,     0,
       0,  1170,  1553,     0,  1541,     0,     0,     0,     0,  1542,
       0,     0,  1554,  1555,  1556,     0,  1557,  1558,  1559,  1560,
    1561,  1562,     0,     0,     0,     0,  2931,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1362,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1365,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1543,     0,     0,     0,  1544,
       0,     0,     0,     0,     0,  1170,     0,     0,     0,  2274,
       0,     0,     0,     0,  2275,     0,  1367,  1545,  1546,     0,
       0,     0,   943,     0,     0,  1543,   943,     0,  1547,  1544,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1366,     0,     0,     0,     0,     0,   622,  1545,  1546,     0,
       0,     0,  1548,   622,     0,  1549,     0,     0,  1547,     0,
       0,  1170,     0,     0,     0,     0,  1550,     0,  1551,     0,
       0,  1170,     0,   943,     0,     0,  1362,     0,     0,     0,
       0,     0,  1548,  1366,     0,  1549,     0,     0,     0,  1365,
       0,     0,   622,     0,     0,     0,  1550,     0,  1551,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     622,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1552,  1367,     0,   783,     0,  1170,  1170,  1170,     0,     0,
    1170,     0,     0,     0,     0,     0,     0,     0,  1169,     0,
       0,   622,     0,   783,   944,     0,     0,     0,   944,     0,
    1552,     0,   944,     0,     0,     0,     0,     0,  1170,     0,
    1169,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1362,     0,  1553,     0,  1169,  1169,     0,  1169,  1169,  1169,
       0,  1538,  1554,  1555,  1556,     0,  1557,  1558,  1559,  1560,
    1561,  1562,     0,  1539,  2730,  1169,     0,  2029,     0,     0,
    1541,  1170,  1553,     0,     0,  1542,     0,     0,     0,     0,
       0,     0,  1554,  1555,  1556,     0,  1557,  1558,  1559,  1560,
    1561,  1562,     0,     0,     0,     0,  1362,     0,     0,     0,
     944,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1365,     0,     0,     0,
       0,  2030,     0,     0,     0,  1169,     0,     0,  1169,  1169,
       0,  1170,     0,     0,     0,     0,     0,     0,     0,     0,
    1170,     0,  1170,     0,     0,     0,     0,     0,  1367,     0,
       0,     0,  1170,     0,     0,     0,     0,     0,     0,     0,
       0,  1543,     0,   944,     0,  1544,     0,     0,   944,     0,
       0,     0,   944,     0,     0,     0,     0,     0,  1170,  1170,
       0,     0,  1170,  1545,  1546,     0,     0,     0,     0,     0,
       0,     0,  1366,     0,  1547,     0,     0,     0,     0,     0,
       0,     0,  1366,   944,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1548,     0,
       0,  1549,     0,     0,     0,     0,  1170,     0,     0,     0,
    1538,     0,  1550,     0,  1551,  1365,     0,     0,   657,     0,
       0,     0,  1539,     0,     0,  1540,     0,     0,  1170,  1541,
       0,     0,     0,  1366,  1542,     0,     0,     0,  1170,     0,
       0,     0,   944,     0,     0,     0,     0,  1367,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1366,     0,
       0,     0,     0,     0,     0,     0,  1552,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   944,     0,     0,     0,  1170,  1169,     0,  1366,
       0,     0,     0,  1366,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1170,  2031,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1365,
       0,     0,     0,     0,     0,     0,   943,     0,  1553,     0,
    1543,     0,     0,     0,  1544,     0,     0,     0,  1554,  1555,
    1556,     0,  1557,  1558,  1559,  1560,  1561,  1562,     0,  1169,
    1169,  1367,  1545,  1546,     0,     0,     0,  1169,     0,     0,
    1169,  1169,     0,  1547,     0,     0,     0,     0,     0,     0,
       0,   944,     0,     0,     0,  1365,     0,     0,     0,     0,
    1169,     0,     0,     0,  1169,  1169,  1169,  1548,  1169,     0,
    1549,     0,     0,     0,     0,  1169,  1169,     0,     0,  1169,
       0,  1550,   622,  1551,   944,     0,     0,  1367,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1366,  1169,   657,     0,  1169,  1169,
       0,     0,     0,  1169,     0,     0,     0,  1169,     0,     0,
    1169,  1169,  1169,  1169,  1169,  1169,  1169,  1169,  1169,  1169,
       0,     0,     0,  1169,     0,  1552,  1538,  1169,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1539,     0,
       0,  2232,     0,     0,     0,  1541,     0,     0,     0,     0,
    1542,  1538,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1539,     0,     0,     0,     0,     0,     0,
    1541,     0,     0,     0,     0,  1542,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1553,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1554,  1555,  1556,
       0,  1557,  1558,  1559,  1560,  1561,  1562,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1538,     0,     0,     0,     0,     0,     0,   783,     0,
     783,     0,   783,  1539,     0,     0,     0,     0,   783,   783,
    1541,     0,     0,     0,     0,  1542,  1543,     0,     0,     0,
    1544,     0,     0,     0,     0,     0,     0,     0,  1169,     0,
       0,     0,     0,     0,     0,     0,  1366,     0,  1545,  1546,
       0,  1543,     0,     0,     0,  1544,     0,     0,     0,  1547,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   622,  1545,  1546,   622,     0,     0,     0,     0,
       0,     0,     0,  1548,  1547,     0,  1549,     0,     0,     0,
       0,  1366,     0,  1366,     0,     0,     0,  1550,     0,  1551,
       0,     0,     0,     0,     0,  1169,     0,  1366,  1548,     0,
       0,  1549,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1543,  1550,     0,  1551,  1544,     0,     0,     0,     0,
    1246,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1545,  1546,     0,   693,   622,   622,     0,
       0,  1552,     0,     0,  1547,     0,     0,     0,     0,     0,
       0,  1366,     0,     0,  1246,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1552,     0,  1548,     0,
       0,  1549,     0,     0,   693,     0,     0,     0,     0,     0,
       0,   693,  1550,  1169,  1551,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2248,     0,     0,     0,     0,
    1169,     0,     0,  1553,     0,     0,     0,  2234,     0,     0,
       0,   693,   693,  1554,  1555,  1556,     0,  1557,  1558,  1559,
    1560,  1561,  1562,     0,     0,     0,     0,     0,  1553,     0,
       0,  1169,  1169,  1169,  1169,  1169,  1552,     0,  1554,  1555,
    1556,     0,  1557,  1558,  1559,  1560,  1561,  1562,     0,     0,
    1169,  1169,  1169,  1169,     0,     0,     0,     0,     0,     0,
       0,  1169,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   622,     0,  1169,     0,     0,     0,     0,  1169,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1169,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1553,  1169,
    1169,     0,  1169,     0,     0,     0,  1169,     0,  1554,  1555,
    1556,     0,  1557,  1558,  1559,  1560,  1561,  1562,     0,     0,
       0,     0,     0,     0,     0,     0,   943,     0,  1169,  1169,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1169,     0,     0,     0,     0,     0,
       0,  1169,  1169,  1169,     0,     0,     0,     0,     0,   622,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     622,     0,     0,     0,     0,     0,  1169,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1366,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   622,   622,     0,     0,     0,     0,     0,     0,  1366,
       0,     0,     0,   622,     0,     0,  1246,     0,     0,     0,
       0,  1246,  1246,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   657,
    1366,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1366,   622,     0,   622,     0,     0,     0,
       0,     0,     0,     0,  1366,     0,   783,     0,     0,  1366,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1366,     0,  1366,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   943,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1169,
       0,     0,     0,     0,     0,  1169,     0,     0,  1366,     0,
       0,     0,     0,     0,     0,     0,     0,  1169,     0,  1169,
       0,     0,     0,     0,  1169,     0,     0,     0,     0,     0,
       0,     0,  1366,  1169,     0,     0,  1169,  1169,  1169,  1169,
    1169,  1169,  1169,  1169,  1169,  1169,     0,     0,     0,     0,
    1169,  1169,     0,     0,     0,     0,     0,     0,     0,  1366,
       0,     0,     0,     0,  1169,     0,     0,  1169,     0,     0,
       0,     0,     0,   622,     0,     0,     0,     0,     0,  1169,
    1169,  1169,     0,  1169,     0,     0,     0,     0,     0,  1366,
    1169,     0,     0,     0,     0,  1169,     0,     0,  1169,     0,
       0,     0,     0,     0,     0,     0,     0,   943,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   938,   948,     0,   948,   938,     0,     0,     0,
       0,   693,   693,  1169,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     693,   938,     0,     0,     0,     0,     0,   948,     0,     0,
     783,     0,   783,     0,     0,     0,   783,     0,   948,     0,
       0,   622,   783,     0,     0,     0,     0,     0,     0,   783,
       0,     0,     0,     0,   694,   693,   938,     0,     0,   783,
       0,   783,   938,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   948,     0,     0,     0,
     783,     0,   783,     0,     0,     0,     0,  1169,     0,     0,
       0,     0,   694,     0,     0,     0,     0,     0,  1366,   694,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   693,
       0,     0,     0,  1538,     0,   693,     0,     0,     0,   694,
     694,     0,     0,   693,     0,  1539,     0,     0,  2283,     0,
       0,     0,  1541,  1169,     0,     0,     0,  1542,   622,     0,
       0,     0,     0,  1169,     0,     0,     0,     0,     0,     0,
       0,   693,     0,     0,     0,     0,   693,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1366,     0,     0,     0,  1169,  1169,  1169,
       0,     0,  1169,     0,     0,     0,     0,     0,  1246,     0,
       0,     0,     0,     0,   622,     0,   943,     0,     0,     0,
     943,     0,     0,  1246,   943,     0,     0,     0,     0,     0,
    1169,     0,     0,  1543,     0,     0,     0,  1544,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1545,  1546,     0,     0,     0,
       0,     0,     0,   948,     0,  1246,  1547,     0,  1246,  1246,
       0,     0,     0,   693,   938,     0,     0,     0,   938,     0,
       0,     0,     0,  1169,     0,     0,     0,     0,     0,     0,
    1548,     0,     0,  1549,     0,   783,     0,     0,     0,     0,
       0,   948,   622,     0,  1550,   622,  1551,     0,     0,   622,
       0,     0,   943,     0,     0,     0,     0,   783,     0,     0,
     693,   693,   783,   948,     0,   938,     0,   693,     0,     0,
       0,     0,     0,     0,   783,     0,     0,     0,     0,   948,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1169,     0,     0,     0,   622,  1552,     0,
       0,     0,  1169,     0,  1169,     0,     0,     0,     0,     0,
    1366,   693,     0,     0,  1169,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   943,     0,     0,     0,     0,
     943,     0,     0,     0,   943,     0,     0,     0,     0,     0,
    1169,  1169,     0,     0,  1169,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   783,     0,     0,
    1553,  1538,     0,     0,     0,   943,     0,     0,     0,     0,
    1554,  1555,  1556,  1539,  1557,  1558,  1559,  1560,  1561,  1562,
    1541,     0,     0,     0,     0,  1542,     0,     0,  1169,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1169,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1169,     0,     0,     0,   943,     0,     0,     0,     0,  1366,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1150,     0,     0,
       0,     0,     0,     0,   693,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   943,     0,     0,     0,  1169,     0,
    2288,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1543,     0,     0,     0,  1544,     0,     0,  1169,     0,
       0,     0,     0,     0,     0,   783,     0,     0,     0,     0,
       0,  1246,     0,  1545,  1546,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1547,     0,     0,     0,     0,     0,
     939,   939,     0,   939,   939,     0,     0,     0,     0,   694,
     694,     0,     0,  1366,     0,     0,     0,     0,  1548,     0,
       0,  1549,     0,     0,     0,     0,     0,     0,   694,   939,
       0,     0,  1550,   943,  1551,   939,     0,     0,     0,     0,
       0,   693,     0,     0,     0,     0,   939,     0,  1246,     0,
       0,     0,     0,     0,  1246,  1246,     0,     0,     0,     0,
       0,     0,     0,   694,   939,     0,   943,     0,     0,  1366,
     939,     0,     0,     0,   622,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   939,     0,  1552,     0,  1246,     0,
       0,     0,     0,   783,     0,   783,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2432,   622,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   694,     0,     0,
       0,     0,     0,   694,     0,     0,   693,   693,     0,     0,
       0,   694,   948,     0,     0,     0,     0,     0,  1553,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1554,  1555,
    1556,     0,  1557,  1558,  1559,  1560,  1561,  1562,   938,   694,
       0,   693,     0,     0,   694,     0,     0,     0,     0,     0,
       0,   693,     0,  1469,     0,     0,   694,  1538,     0,     0,
     693,     0,     0,     0,     0,     0,     0,     0,     0,  1539,
       0,     0,     0,   783,     0,  1493,  1541,     0,     0,   783,
       0,  1542,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1516,
    1517,     0,  1518,  1519,  1522,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1537,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   622,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   939,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   694,   939,     0,   693,     0,   939,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1543,     0,     0,
       0,  1544,     0,     0,     0,     0,     0,     0,     0,   939,
    1629,     0,     0,  1635,  1637,     0,     0,     0,     0,  1545,
    1546,     0,     0,     0,     0,     0,     0,     0,   694,   694,
    1547,   939,     0,   939,     0,   694,     0,     0,   693,     0,
       0,     0,     0,     0,     0,     0,     0,   939,     0,     0,
       0,     0,     0,     0,  1548,   622,   622,  1549,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1550,   783,
    1551,     0,     0,     0,   783,   783,   783,   783,   783,   694,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     4,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     5,     0,     0,
       0,     0,  1552,     0,     0,   622,     6,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     7,     8,
    2507,     0,     0,     0,     9,     0,    10,    11,     0,     0,
       0,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,     0,     0,   948,   948,     0,
       0,     0,     0,     0,  1553,     0,     0,     0,     0,     0,
       0,     0,  1823,     0,  1554,  1555,  1556,     0,  1557,  1558,
    1559,  1560,  1561,  1562,     0,     0,     0,     0,     0,     0,
       0,     0,    36,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   694,     0,     0,     0,     0,   693,     0,     0,
       0,     0,   693,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   622,     0,     0,     0,     0,     0,     0,
       0,     0,  1877,     0,     0,     0,  1879,     0,     0,     0,
       0,     0,   783,     0,     0,     0,   622,   622,    37,     0,
       0,   622,     0,     0,     0,  1898,     0,     0,     0,  1903,
       0,  1915,     0,  1916,    38,     0,     0,     0,     0,     0,
    1923,  1928,     0,     0,  1931,     0,     0,     0,     0,     0,
       0,    39,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   622,     0,     0,   694,
    1957,   622,     0,     0,  1961,   622,     0,    40,  1972,     0,
      41,     0,  1979,     0,     0,  1981,  1982,  1983,  1984,  1985,
    1986,  1987,  1988,  1989,  1990,     0,    42,     0,  1150,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    43,
       0,     0,   693,     0,  1538,     0,     0,     0,  2338,     0,
       0,     0,     0,     0,   694,   694,  1539,     0,     0,     0,
     939,     0,     0,  1541,     0,     0,     0,     0,  1542,     0,
       0,    44,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    45,     0,     0,   939,     0,     0,   694,
       0,     0,     0,     0,     0,    46,     0,     0,     0,   694,
       0,     0,     0,     0,     0,     0,     0,    47,   694,     0,
      48,    49,     0,    50,     0,    51,     0,     0,     0,    52,
       0,    53,    54,  2068,     0,     0,    55,    56,    57,    58,
      59,     0,     0,    60,    61,    62,    63,     0,    64,    65,
      66,    67,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1543,     0,     0,     0,  1544,     0,
       0,     0,     0,     0,     0,     0,     0,   622,     0,     0,
       0,     0,     0,     0,     0,     0,  1545,  1546,     0,     0,
    2125,     0,     0,     0,     0,     0,     0,  1547,     0,   622,
     622,   693,     0,     0,     0,     0,     0,   693,     0,     0,
       0,     0,   694,     0,     0,     0,     0,     0,  2468,     0,
       0,  1548,     0,     0,  1549,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1550,     0,  1551,     0,   783,
     783,     0,     0,     0,     0,     0,     0,     0,     0,   938,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   694,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1150,     0,
       0,     0,   948,     0,     0,     0,     0,     0,     0,  1552,
       0,     0,     0,     0,     0,  2228,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2254,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1928,     0,  1928,  1928,     0,
       0,  1553,     0,     0,     0,     0,  2294,     0,     0,     0,
       0,  1554,  1555,  1556,     0,  1557,  1558,  1559,  1560,  1561,
    1562,     0,     0,     0,     0,     0,     0,   693,   693,  2338,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2316,     0,  2318,     0,     0,
       0,  2321,     0,     0,     0,   939,   939,     0,     0,     0,
       0,     0,   941,     0,     0,     0,   941,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   941,     0,     0,     0,     0,     0,     0,     0,  1629,
       0,     0,     0,     0,     0,   694,  1637,  1637,  1635,     0,
     694,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   693,   941,     0,     0,     0,
       0,  2375,   941,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   693,     0,     0,     0,     0,
       0,     0,   693,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1166,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   693,   693,   693,   693,
       0,     0,     0,     0,     0,     0,     0,     0,  2338,     0,
       0,     0,  2338,     0,     0,     0,  2338,     0,     0,     0,
     694,     0,     0,     0,  2504,     0,   694,     0,     0,     0,
    2508,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2513,     0,  2514,     0,     0,     0,     0,  2517,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2534,  2535,     0,     0,     0,
       0,     0,     0,     0,   941,     0,     0,     0,   941,     0,
       0,     0,  2546,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1364,     0,   938,     0,  2554,     0,  2556,     0,
       0,     0,     0,     0,     0,  2560,     0,     0,     0,     0,
    2564,     0,     0,  2567,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   941,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1364,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2604,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2338,     0,   694,
       0,     0,  2338,     0,     0,   694,  2338,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   939,     0,     0,     0,
    1166,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   938,     0,   693,
       0,     0,  1166,     0,     0,     0,     0,   939,     0,     0,
       0,     0,     0,     0,   693,     0,     0,     0,     0,   948,
       0,     0,     0,   948,     0,     0,  1166,  1166,     0,  1166,
    1166,  1166,     0,     0,     0,     0,     0,   693,     0,     0,
     939,     0,     0,     0,     0,     0,     0,  1166,     0,     0,
       0,     0,     0,     0,     0,     0,  2338,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   693,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1150,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2719,     0,
       0,     0,     0,     0,     0,     0,   938,   948,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1166,     0,     0,
    1166,  1166,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   694,   694,   694,     0,   948,
       0,     0,     0,  2736,  2737,     0,     0,  2739,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   948,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1364,   938,     0,     0,     0,     0,
       0,     0,     0,     0,  1364,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   938,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2793,     0,
       0,     0,     0,   694,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1364,     0,     0,     0,     0,
       0,     0,     0,   694,     0,     0,     0,     0,     0,     0,
     694,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1364,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1150,  1166,
       0,  1364,     0,     0,     0,  1364,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2839,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   941,     0,
       0,     0,     0,     0,     0,     0,  2856,     0,     0,  2858,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1166,  1166,     0,     0,     0,     0,     0,     0,  1166,
       0,     0,  1166,  1166,   694,   694,   694,   694,     0,     0,
       0,     0,     0,     0,     0,     0,   694,     0,     0,     0,
     694,     0,  1166,  2886,   694,     0,  1166,  1166,  1166,     0,
    1166,     0,     0,     0,     0,     0,     0,  1166,  1166,     0,
       0,  1166,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2905,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1364,  1166,     0,     0,
    1166,  1166,     0,     0,     0,  1166,     0,     0,     0,  1166,
       0,     0,  1166,  1166,  1166,  1166,  1166,  1166,  1166,  1166,
    1166,  1166,     0,     0,     0,  1166,     0,     0,     0,  1166,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   939,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2858,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   694,     0,     0,     0,     0,
     694,     0,     0,     0,   694,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   939,     0,   694,     0,     0,
    1166,     0,     0,     0,     0,     0,     0,     0,  1364,     0,
       0,  1563,   694,     0,     0,     0,     0,   939,     0,     0,
       0,   939,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   694,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1364,   694,  1364,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   694,  1166,     0,  1364,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   939,   939,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1364,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   939,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1166,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   939,  1166,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   939,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1166,  1166,  1166,  1166,  1166,     0,     0,
       0,     0,     0,     0,     0,     0,   939,     0,     0,     0,
       0,     0,  1166,  1166,  1166,  1166,     0,     0,     0,     0,
       0,     0,     0,  1166,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1166,     0,     0,     0,     0,
    1166,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1166,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1166,  1166,     0,  1166,     0,     0,     0,  1166,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   941,     0,
    1166,  1166,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1166,     0,     0,     0,
    1563,     0,     0,  1166,  1166,  1166,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1563,     0,     0,     0,  1166,     0,
    1909,     0,     0,     0,     0,     0,     0,     0,     0,  1364,
       0,     0,     0,     0,     0,     0,     0,  1563,  1563,  1563,
    1563,     0,     0,  1563,     0,     0,     0,     0,     0,     0,
       0,  1364,     0,     0,     0,     0,     0,     0,  1563,     0,
       0,     0,     0,  1909,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1364,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1364,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1364,     0,     0,     0,
       0,  1364,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1364,     0,  1364,     0,     0,     0,     0,
    1563,     0,     0,     0,     0,     0,  1563,     0,  1563,   941,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1166,     0,     0,     0,     0,     0,  1166,     0,     0,
    1364,     0,     0,     0,     0,     0,     0,     0,     0,  1166,
       0,  1166,     0,     0,     0,     0,  1166,     0,     0,     0,
       0,     0,     0,     0,  1364,  1166,     0,     0,  1166,  1166,
    1166,  1166,  1166,  1166,  1166,  1166,  1166,  1166,     0,     0,
       0,     0,  1166,  1166,     0,     0,     0,     0,     0,     0,
       0,  1364,     0,     0,     0,     0,  1166,     0,     0,  1166,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1166,  1166,  1166,     0,  1166,     0,     0,     0,     0,
       0,  1364,  1166,     0,     0,     0,     0,  1166,     0,     0,
    1166,     0,     0,     0,     0,     0,     0,     0,     0,   941,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1166,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1563,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1563,
       0,     0,     0,     0,     0,     0,     0,     0,  1563,  1166,
    1563,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1364,     0,     0,     0,     0,     0,     0,     0,     0,  1563,
       0,     0,     0,     0,  1563,     0,  1909,  1909,  1909,     0,
    1909,  2270,     0,     0,     0,     0,  1563,  1563,     0,     0,
       0,     0,     0,     0,  1563,     0,     0,     0,     0,  1563,
       0,     0,  1563,     0,     0,  1166,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1166,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1563,     0,
       0,  2270,  1563,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1563,  1909,     0,     0,     0,     0,     0,
    1563,     0,  1563,  1563,  1563,  1563,  1563,  1563,  1563,  1563,
    1563,  1563,     0,     0,     0,  1364,     0,     0,     0,  1166,
    1166,  1166,     0,     0,  1166,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   941,     0,
       0,     0,   941,     0,     0,     0,   941,     0,     0,     0,
       0,     0,  1166,     0,     0,     0,     0,     0,     4,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     5,     0,     0,     0,     0,     0,     0,
       0,     0,     6,     0,     0,     0,     0,     0,     0,  1563,
       0,     0,     0,     0,     7,     8,     0,     0,     0,     0,
       0,     0,    10,    11,     0,  1166,     0,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,     0,     0,     0,   941,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1563,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    36,     0,
       0,     0,     0,     0,     0,  1166,     0,     0,     0,     0,
       0,     0,     0,     0,  1166,     0,  1166,     0,     0,     0,
       0,     0,  1364,     0,     0,     0,  1166,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   941,     0,     0,
       0,     0,   941,     0,     0,     0,   941,     0,     0,     0,
       0,     0,  1166,  1166,     0,     0,  1166,     0,     0,     0,
       0,     0,     0,     0,    37,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   941,     0,  1563,
      38,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    39,     0,     0,
    1166,     0,  2270,  2270,  2270,  1563,  2270,     0,  1909,     0,
       0,  1909,  1909,  1909,  1909,  1909,  1909,  1909,  1909,  1909,
    1909,     0,  1166,    40,     0,     0,    41,     0,     0,     0,
       0,     0,  1166,     0,     0,     0,   941,     0,     0,     0,
       0,  1364,    42,     0,     0,  1563,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1909,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2270,  1563,     0,  1563,
       0,     0,  1563,     0,     0,     0,   941,     0,     0,     0,
    1166,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    43,     0,     0,     0,     0,
    1166,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1563,    44,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    45,
       0,     0,     0,     0,     0,  1364,     0,     0,     0,     0,
       0,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    47,     0,   941,    48,    49,     0,    50,
       0,     0,     0,     0,     0,    52,     0,    53,    54,     0,
       0,     0,    55,    56,    57,    58,    59,     0,     0,    60,
      61,   912,  1909,     0,     0,   913,     0,     0,   941,     0,
       0,  1364,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1563,     0,     0,     0,  1563,
       0,     0,     0,     0,  1563,  1563,     0,     0,  1563,     0,
       0,  2270,     0,     0,     0,  2270,  2270,  2270,  2270,  2270,
    2270,  2270,  2270,  2270,  2270,  1563,  1563,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1563,     0,     0,
       0,     0,     0,     0,  2270,  1563,     0,  1563,     0,     0,
       0,  1563,  1909,     0,     0,  1563,     0,     0,  1563,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1563,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2270,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1563,     0,     0,     0,     0,     0,     0,  1909,     0,  1909,
       0,     0,     0,     0,     0,     0,  2270,  1563,  1563,     0,
    1563,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1563,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2270,  1909,  2270,     0,     0,     0,
    1563,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1563,     0,  1563,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1563,     0,   639,
      79,    80,    81,   338,     0,    83,    84,     0,    85,    86,
      87,   339,  2270,   340,     0,    91,  1563,    93,    94,    95,
      96,    97,    98,   640,    99,   100,   101,   341,   641,   103,
       0,   104,   105,   106,   107,   642,   643,     0,   109,   110,
     111,     0,   112,   644,   645,     0,   342,   343,     0,     0,
       0,   600,   601,     0,     0,     0,     0,   602,     0,     0,
       0,     0,     0,     0,     0,     0,   603,     0,   604,     0,
     605,   606,     0,   344,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,   129,   363,   364,   365,   131,   132,   133,   134,
       0,   366,   367,   368,     0,   369,   370,   371,   372,   646,
     135,   373,   374,   375,   376,   377,   378,   139,   379,   380,
     381,   382,   383,   384,   385,   386,   142,   387,   388,   389,
     390,   145,   391,   392,   393,   394,   395,   396,   397,   398,
     399,   148,   149,   400,   401,   402,   403,   404,     0,   405,
     406,   407,   408,   409,   410,   411,   412,   413,   414,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   156,   424,
       0,   158,   425,   426,   427,   160,   428,   429,   430,   431,
     161,   432,   162,   433,     0,   434,   435,   436,   437,   438,
     439,   440,   165,   441,   442,   443,   166,   444,   445,   446,
     447,   448,   167,   449,   647,   450,   451,   452,   648,   169,
     453,   170,   454,     0,   171,   172,   455,   173,   456,   457,
     458,   459,   460,   174,   461,   175,   462,   463,   464,   465,
     466,   467,   468,   469,   470,   471,   472,   473,   474,   475,
     476,   180,   181,   477,   478,   479,   480,   481,   182,   482,
     483,   484,   184,   485,   185,   186,   486,   487,   488,   489,
     490,   491,   492,   493,   494,   495,   496,   497,   187,   188,
       0,   498,   499,   500,   501,   502,     0,   189,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   191,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,   522,   195,
     523,   197,   524,   525,   526,   527,   528,     0,   529,   530,
     531,   532,   533,   534,   200,   535,   536,   202,   537,   203,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   205,
     547,   548,   549,   550,   551,   552,   206,   207,   553,   554,
     555,   556,   208,   557,   209,   558,   559,   560,   561,   562,
     649,   563,   564,   565,   566,   567,   568,   569,   570,   571,
     572,   573,   216,   574,   217,   575,   576,     0,   577,   578,
     579,   580,   581,   582,   583,   584,     0,   218,     0,     0,
     219,     0,     0,    79,    80,    81,   338,     0,    83,    84,
       0,    85,    86,    87,   339,     0,   340,    90,    91,     0,
      93,    94,    95,    96,    97,    98,   650,    99,   100,   101,
     341,     0,   103,     0,   104,   105,   106,   107,     0,   108,
       0,   109,   110,   111,     0,   112,   113,   114,     0,   342,
     343,     0,     0,     0,   117,   118,     0,     0,     0,     0,
     119,     0,     0,     0,     0,     0,     0,     0,     0,   120,
       0,   121,     0,   122,     0,     0,   344,   345,   346,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   129,   363,   364,   365,   131,
     132,   133,   134,     0,   366,   367,   368,     0,   369,   370,
     371,   372,     0,   135,   373,   374,   375,   376,   377,   378,
     139,   379,   380,   381,   382,   383,   384,   385,   386,   142,
     387,   388,   389,   390,   145,   391,   392,   393,   394,   395,
     396,   397,   398,   399,   148,   149,   400,   401,   402,   403,
     404,     0,   405,   406,   407,   408,   409,   410,   411,   412,
     413,   414,   415,   416,   417,   418,   419,   420,   421,   422,
     423,   156,   424,     0,   158,   425,   426,   427,   160,   428,
     429,   430,   431,   161,   432,   162,   433,     0,   434,   435,
     436,   437,   438,   439,   440,   165,   441,   442,   443,   166,
     444,   445,   446,   447,   448,   167,   449,     0,   450,   451,
     452,     0,   169,   453,   170,   454,     0,   171,   172,   455,
     173,   456,   457,   458,   459,   460,   174,   461,   175,   462,
     463,   464,   465,   466,   467,   468,   469,   470,   471,   472,
     473,   474,   475,   476,   180,   181,   477,   478,   479,   480,
     481,   182,   482,   483,   484,   184,   485,   185,   186,   486,
     487,   488,   489,   490,   491,   492,   493,   494,   495,   496,
     497,   187,   188,     0,   498,   499,   500,   501,   502,     0,
     189,   503,   504,   505,   506,   507,   508,   509,   510,   511,
     191,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,   522,   195,   523,   197,   524,   525,   526,   527,   528,
       0,   529,   530,   531,   532,   533,   534,   200,   535,   536,
     202,   537,   203,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   205,   547,   548,   549,   550,   551,   552,   206,
     207,   553,   554,   555,   556,   208,   557,   209,   558,   559,
     560,   561,   562,   212,   563,   564,   565,   566,   567,   568,
     569,   570,   571,   572,   573,   216,   574,   217,   575,   576,
       0,   577,   578,   579,   580,   581,   582,   583,   584,     0,
     218,     0,     0,   219,     0,     0,     0,    79,    80,    81,
     338,     0,    83,    84,     0,    85,    86,    87,   339,     0,
     340,    90,    91,     0,    93,    94,    95,    96,    97,    98,
    2041,    99,   100,   101,   341,     0,   103,     0,   104,   105,
     106,   107,     0,   108,     0,   109,   110,   111,     0,   112,
     113,   114,     0,   342,   343,     0,     0,     0,   117,   118,
       0,     0,     0,     0,   119,     0,     0,     0,     0,     0,
       0,     0,     0,   120,     0,   121,     0,   122,     0,     0,
     344,   345,   346,   347,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   129,
     363,   364,   365,   131,   132,   133,   134,     0,   366,   367,
     368,     0,   369,   370,   371,   372,     0,   135,   373,   374,
     375,   376,   377,   378,   139,   379,   380,   381,   382,   383,
     384,   385,   386,   142,   387,   388,   389,   390,   145,   391,
     392,   393,   394,   395,   396,   397,   398,   399,   148,   149,
     400,   401,   402,   403,   404,     0,   405,   406,   407,   408,
     409,   410,   411,   412,   413,   414,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   156,   424,     0,   158,   425,
     426,   427,   160,   428,   429,   430,   431,   161,   432,   162,
     433,     0,   434,   435,   436,   437,   438,   439,   440,   165,
     441,   442,   443,   166,   444,   445,   446,   447,   448,   167,
     449,     0,   450,   451,   452,     0,   169,   453,   170,   454,
       0,   171,   172,   455,   173,   456,   457,   458,   459,   460,
     174,   461,   175,   462,   463,   464,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   474,   475,   476,   180,   181,
     477,   478,   479,   480,   481,   182,   482,   483,   484,   184,
     485,   185,   186,   486,   487,   488,   489,   490,   491,   492,
     493,   494,   495,   496,   497,   187,   188,     0,   498,   499,
     500,   501,   502,     0,   189,   503,   504,   505,   506,   507,
     508,   509,   510,   511,   191,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,   522,   195,   523,   197,   524,
     525,   526,   527,   528,     0,   529,   530,   531,   532,   533,
     534,   200,   535,   536,   202,   537,   203,   538,   539,   540,
     541,   542,   543,   544,   545,   546,   205,   547,   548,   549,
     550,   551,   552,   206,   207,   553,   554,   555,   556,   208,
     557,   209,   558,   559,   560,   561,   562,   212,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   216,
     574,   217,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   584,     0,   218,     0,     0,   219,    78,     0,
       0,    79,    80,    81,    82,     0,    83,    84,     0,    85,
      86,    87,    88,     0,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,  2043,    99,   100,   101,   102,     0,
     103,     0,   104,   105,   106,   107,     0,   108,     0,   109,
     110,   111,     0,   112,   113,   114,     0,   115,   116,     0,
       0,     0,   117,   118,     0,     0,     0,     0,   119,     0,
       0,     0,     0,     0,     0,     0,     0,   120,     0,   121,
       0,   122,   123,     0,   124,     0,     0,     0,     0,     0,
       0,     0,   125,   126,   127,     0,     0,     0,     0,     0,
       0,     0,   128,   129,     0,     0,   130,   131,   132,   133,
     134,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   135,     0,     0,   136,     0,   137,   138,   139,     0,
       0,   140,   141,     0,     0,     0,     0,   142,   143,   144,
       0,     0,   145,     0,     0,     0,     0,     0,     0,   146,
       0,   147,   148,   149,   150,     0,     0,     0,     0,     0,
     151,     0,     0,     0,     0,     0,     0,   152,   153,     0,
       0,     0,     0,   154,     0,     0,     0,     0,   155,   156,
     157,     0,   158,     0,   159,     0,   160,     0,     0,     0,
       0,   161,     0,   162,     0,   163,     0,   164,     0,     0,
       0,     0,     0,   165,     0,     0,     0,   166,     0,     0,
       0,     0,     0,   167,     0,     0,     0,   168,     0,     0,
     169,     0,   170,     0,     0,   171,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,     0,   176,   177,
       0,     0,   178,     0,     0,     0,     0,     0,     0,   179,
       0,     0,   180,   181,     0,     0,     0,     0,     0,   182,
       0,     0,   183,   184,     0,   185,   186,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   187,
     188,     0,     0,     0,     0,     0,     0,     0,   189,     0,
       0,   190,     0,     0,     0,     0,     0,     0,   191,     0,
       0,   192,     0,     0,     0,   193,     0,     0,     0,   194,
     195,   196,   197,     0,     0,     0,     0,     0,     0,   198,
       0,     0,     0,     0,   199,   200,     0,   201,   202,     0,
     203,     0,     0,   204,     0,    78,     0,     0,     0,     0,
     205,    82,     0,     0,     0,     0,     0,   206,   207,    88,
       0,    89,     0,   208,    92,   209,     0,   210,     0,   211,
       0,   212,     0,     0,   213,   102,   214,     0,     0,     0,
     215,     0,     0,   216,     0,   217,     0,     0,     0,     0,
       0,     0,     0,     0,   115,   116,     0,     0,   218,     0,
       0,   219,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   124,     0,   220,     0,     0,     0,     0,     0,   125,
     126,   127,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   855,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   136,     0,   137,   138,     0,     0,     0,   140,   141,
       0,     0,     0,     0,     0,   143,   144,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   146,     0,   147,     0,
       0,   150,     0,     0,     0,     0,     0,   151,     0,     0,
       0,     0,     0,     0,     0,   153,     0,     0,     0,     0,
     154,     0,     0,     0,     0,   155,     0,   157,     0,     0,
       0,   159,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   163,     0,   164,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   168,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   176,   177,     0,     0,   178,
       0,     0,     0,     0,     0,     0,   179,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   183,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   190,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   192,     0,
       0,     0,   193,     0,     0,     0,   194,     0,   196,     0,
       0,     0,     0,     0,     0,     0,   198,     0,     0,     0,
       0,   199,     0,     0,   201,     0,     0,     0,     0,     0,
     204,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   210,     0,   211,     0,     0,     0,
       0,   213,     0,   214,     0,     0,     0,   215,   639,    79,
      80,    81,   338,     0,    83,    84,     0,    85,    86,    87,
     339,     0,   340,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   640,    99,   100,   101,   341,   641,   103,     0,
     104,   105,   106,   107,   642,   643,     0,   109,   110,   111,
     220,   112,   644,   645,     0,   342,   343,     0,     0,     0,
     600,   601,     0,     0,     0,     0,   602,     0,     0,     0,
       0,     0,     0,     0,     0,   603,     0,   604,     0,   605,
     606,     0,   344,   345,   346,   347,   348,   349,   350,  2002,
     352,     0,     0,     0,     0,  1078,     0,     0,   360,   361,
     362,   129,   363,   364,   365,   131,  1079,   133,  1080,  1081,
       0,   367,   368,     0,   369,  1082,  1083,   372,  1084,  1085,
     373,     0,   375,   376,   377,   378,  1086,     0,     0,   381,
     382,   383,     0,   385,   386,  1087,   387,     0,   389,   390,
     145,  1088,  1089,  1090,  1091,   395,   396,   397,   398,   399,
    1092,  1093,   400,     0,   402,     0,   404,     0,   405,   406,
     407,     0,  2003,     0,   411,  1094,   413,   414,     0,   416,
     417,     0,   419,     0,   421,   422,   423,  1095,   424,     0,
    1096,  1097,   426,   427,  1098,     0,   429,     0,   431,   161,
       0,   162,   433,     0,   434,     0,     0,   437,     0,   439,
     440,   165,   441,   442,   443,   166,   444,   445,   446,   447,
       0,   167,   449,     0,   450,   451,   452,  1099,  1100,     0,
    1101,     0,     0,   171,   172,   455,   173,   456,   457,   458,
     459,     0,   174,   461,   175,     0,   463,   464,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,   475,  1102,
     180,  1103,   691,   478,   479,   480,   481,   182,  1104,   483,
     484,   184,  1105,  1106,  1107,   486,     0,     0,   489,   692,
       0,     0,  1108,   494,     0,     0,   497,   187,   188,  1109,
     498,   499,   500,   501,   502,     0,  1110,   503,   504,   505,
       0,   507,   508,   509,   510,   511,  1111,   512,     0,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   195,   523,
    1112,   524,   525,   526,   527,   528,     0,     0,   530,   531,
     532,  1113,   534,   200,   535,   536,   202,   537,  1114,     0,
     539,   540,   541,   542,   543,   544,   545,   546,  1115,   547,
       0,   549,   550,   551,     0,  1116,  1117,     0,   554,     0,
     556,  1118,   557,  1119,  1120,   559,   560,   561,   562,     0,
    1121,   564,   565,   566,   567,   568,  1122,     0,   571,   572,
     573,  1123,   574,   217,   575,   576,     0,     0,     0,   579,
     580,   581,   582,   583,   584,     0,   218,    49,  1124,   219,
     609,     0,     0,  1125,  1126,    52,  1127,    53,     0,     0,
       0,     0,  1128,  1129,  2004,     0,  1131,  1132,     0,     0,
       0,  1133,  2005,   639,    79,    80,    81,   338,     0,    83,
      84,     0,    85,    86,    87,   339,     0,   340,     0,    91,
       0,    93,    94,    95,    96,    97,    98,   640,    99,   100,
     101,   341,   641,   103,     0,   104,   105,   106,   107,   642,
     643,     0,   109,   110,   111,     0,   112,   644,   645,     0,
     342,   343,     0,     0,     0,   600,   601,     0,     0,     0,
       0,   602,     0,     0,     0,     0,     0,     0,     0,     0,
     603,     0,   604,     0,   605,   606,     0,   344,   345,   346,
     347,   348,   349,   350,     0,   352,     0,     0,     0,     0,
    1078,     0,     0,   360,   361,   362,   129,   363,   364,   365,
     131,  1079,   133,  1080,  1081,     0,   367,   368,     0,   369,
    1082,  1083,   372,  1084,  1085,   373,     0,   375,   376,   377,
     378,  1086,     0,     0,   381,   382,   383,     0,   385,   386,
    1087,   387,     0,   389,   390,   145,  1088,  1089,  1090,  1091,
     395,   396,   397,   398,   399,  1092,  1093,   400,     0,   402,
       0,   404,     0,   405,   406,   407,     0,     0,     0,   411,
    1094,   413,   414,     0,   416,   417,     0,   419,     0,   421,
     422,   423,  1095,   424,     0,  1096,  1097,   426,   427,  1098,
       0,   429,     0,   431,   161,     0,   162,   433,     0,   434,
       0,     0,   437,     0,   439,   440,   165,   441,   442,   443,
     166,   444,   445,   446,   447,     0,   167,   449,     0,   450,
     451,   452,  1099,  1100,     0,  1101,     0,     0,   171,   172,
     455,   173,   456,   457,   458,   459,     0,   174,   461,   175,
       0,   463,   464,   465,   466,   467,   468,   469,   470,   471,
     472,   473,   474,   475,  1102,   180,  1103,   691,   478,   479,
     480,   481,   182,  1104,   483,   484,   184,  1105,  1106,  1107,
     486,     0,     0,   489,   692,     0,     0,  1108,   494,     0,
       0,   497,   187,   188,  1109,   498,   499,   500,   501,   502,
       0,  1110,   503,   504,   505,     0,   507,   508,   509,   510,
     511,  1111,   512,     0,   514,   515,   516,   517,   518,   519,
     520,   521,   522,   195,   523,  1112,   524,   525,   526,   527,
     528,     0,     0,   530,   531,   532,  1113,   534,   200,   535,
     536,   202,   537,  1114,     0,   539,   540,   541,   542,   543,
     544,   545,   546,  1115,   547,     0,   549,   550,   551,     0,
    1116,  1117,     0,   554,     0,   556,  1118,   557,  1119,  1120,
     559,   560,   561,   562,     0,  1121,   564,   565,   566,   567,
     568,  1122,     0,   571,   572,   573,  1123,   574,   217,   575,
     576,     0,     0,     0,   579,   580,   581,   582,   583,   584,
       0,   218,    49,  1124,   219,   609,     0,     0,  1125,  1126,
      52,  1127,    53,     0,     0,     0,     0,  1128,  1129,     0,
       0,  1131,  1132,     0,     0,     0,  1133,  1913,   639,    79,
      80,    81,   338,     0,    83,    84,     0,    85,    86,    87,
     339,     0,   340,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   640,    99,   100,   101,   341,   641,   103,     0,
     104,   105,   106,   107,   642,   643,     0,   109,   110,   111,
       0,   112,   644,   645,     0,   342,   343,     0,     0,     0,
     600,   601,     0,     0,     0,     0,   602,     0,     0,     0,
       0,     0,     0,     0,     0,   603,     0,   604,     0,   605,
     606,     0,   344,   345,   346,   347,   348,   349,   350,     0,
     352,     0,     0,     0,     0,  1078,     0,     0,   360,   361,
     362,   129,   363,   364,   365,   131,  1079,   133,  1080,  1081,
       0,   367,   368,     0,   369,  1082,  1083,   372,  1084,  1085,
     373,     0,   375,   376,   377,   378,  1086,     0,     0,   381,
     382,   383,     0,   385,   386,  1087,   387,     0,   389,   390,
     145,  1088,  1089,  1090,  1091,   395,   396,   397,   398,   399,
    1092,  1093,   400,     0,   402,     0,   404,     0,   405,   406,
     407,     0,     0,     0,   411,  1094,   413,   414,     0,   416,
     417,     0,   419,     0,   421,   422,   423,  1095,   424,     0,
    1096,  1097,   426,   427,  1098,     0,   429,     0,   431,   161,
       0,   162,   433,     0,   434,     0,     0,   437,     0,   439,
     440,   165,   441,   442,   443,   166,   444,   445,   446,   447,
       0,   167,   449,     0,   450,   451,   452,  1099,  1100,     0,
    1101,     0,     0,   171,   172,   455,   173,   456,   457,   458,
     459,     0,   174,   461,   175,     0,   463,   464,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,   475,  1102,
     180,  1103,   691,   478,   479,   480,   481,   182,  1104,   483,
     484,   184,  1105,  1106,  1107,   486,     0,     0,   489,   692,
       0,     0,  1108,   494,     0,     0,   497,   187,   188,  1109,
     498,   499,   500,   501,   502,     0,  1110,   503,   504,   505,
       0,   507,   508,   509,   510,   511,  1111,   512,     0,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   195,   523,
    1112,   524,   525,   526,   527,   528,     0,     0,   530,   531,
     532,  1113,   534,   200,   535,   536,   202,   537,  1114,     0,
     539,   540,   541,   542,   543,   544,   545,   546,  1115,   547,
       0,   549,   550,   551,     0,  1116,  1117,     0,   554,     0,
     556,  1118,   557,  1119,  1120,   559,   560,   561,   562,     0,
    1121,   564,   565,   566,   567,   568,  1122,     0,   571,   572,
     573,  1123,   574,   217,   575,   576,     0,     0,     0,   579,
     580,   581,   582,   583,   584,     0,   218,    49,  1124,   219,
     609,     0,     0,  1125,  1126,    52,  1127,    53,     0,     0,
       0,     0,  1128,  1129,     0,     0,  1131,  1132,     0,     0,
       0,  1133,  2762,   639,    79,    80,    81,   338,     0,    83,
      84,     0,    85,    86,    87,   339,     0,   340,     0,    91,
       0,    93,    94,    95,    96,    97,    98,   640,    99,   100,
     101,   341,   641,   103,     0,   104,   105,   106,   107,   642,
     643,     0,   109,   110,   111,     0,   112,   644,   645,     0,
     342,   343,     0,     0,     0,   600,   601,     0,     0,     0,
       0,   602,     0,     0,     0,     0,     0,     0,     0,     0,
     603,     0,   604,     0,   605,   606,     0,   344,   345,   346,
     347,   348,   349,   350,     0,   352,     0,     0,     0,     0,
       0,     0,     0,   360,   361,   362,     0,   363,   364,   365,
       0,  1335,     0,  1336,  1081,     0,   367,   368,     0,   369,
       0,     0,   372,  1337,  1338,   373,     0,   375,   376,   377,
     378,     0,     0,     0,   381,   382,   383,     0,   385,   386,
       0,   387,     0,   389,   390,     0,     0,     0,     0,     0,
     395,   396,   397,   398,   399,  1339,  1340,   400,     0,   402,
       0,   404,     0,   405,   406,   407,     0,     0,     0,   411,
    1094,   413,   414,     0,   416,   417,     0,   419,     0,   421,
     422,   423,     0,   424,     0,     0,     0,   426,   427,  1341,
       0,   429,     0,   431,     0,     0,     0,   433,     0,   434,
       0,     0,   437,     0,   439,   440,     0,   441,   442,   443,
    1704,   444,   445,   446,   447,     0,     0,  1705,     0,   450,
     451,   452,  1099,  1342,     0,  1343,     0,     0,     0,     0,
     455,     0,   456,   457,   458,   459,     0,     0,   461,     0,
       0,   463,   464,   465,   466,   467,   468,   469,   470,   471,
     472,   473,   474,   475,  1102,     0,  1344,     0,   478,   479,
     480,   481,     0,     0,   483,   484,     0,     0,     0,  1345,
     486,     0,     0,   489,     0,     0,     0,   493,   494,     0,
       0,  1706,     0,     0,     0,   498,   499,   500,   501,   502,
       0,     0,   503,   504,   505,     0,   507,   508,   509,   510,
     511,  1346,   512,     0,   514,   515,   516,   517,   518,   519,
     520,   521,   522,     0,   523,     0,   524,   525,   526,   527,
     528,     0,     0,   530,   531,   532,     0,   534,  1347,   535,
     536,     0,   537,  1348,     0,   539,   540,   541,   542,   543,
     544,   545,   546,     0,   547,     0,   549,   550,   551,     0,
    1349,  1350,     0,   554,     0,   556,     0,   557,     0,     0,
     559,   560,   561,   562,     0,     0,   564,   565,   566,   567,
     568,     0,     0,   571,   572,   573,  1351,   574,     4,   575,
     576,     0,     0,     0,   579,   580,   581,   582,   583,   584,
       0,   218,     0,     5,   219,     0,     0,     0,     0,     0,
       0,     0,     6,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     7,     8,     0,  1707,     0,     0,
       0,     0,    10,    11,     0,     0,     0,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,     0,     0,     4,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     5,     0,
       0,     0,     0,     0,     0,     0,     0,     6,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    36,     7,
       8,     0,     0,     0,     0,     0,     0,    10,    11,     0,
       0,     0,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    37,     0,     0,     0,     0,     0,
       0,     0,     0,    36,     0,     0,     0,     0,     0,     0,
      38,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    39,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    40,     0,     0,    41,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    37,
       0,     0,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    38,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    39,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    43,     0,     0,    40,     0,
       0,    41,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    44,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    45,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    47,     0,     0,    48,    49,     0,    50,
      43,     0,     0,     0,     0,    52,     0,    53,    54,     0,
       0,     0,    55,    56,    57,    58,    59,     0,     0,    60,
      61,   912,  1265,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    45,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    47,     0,
       0,    48,    49,     0,    50,     0,     0,     0,     0,     0,
      52,     0,    53,    54,     0,     0,     0,    55,    56,    57,
      58,    59,     0,     0,    60,    61,   912,  1676,   639,    79,
      80,    81,   338,     0,    83,    84,     0,    85,    86,    87,
     339,     0,   340,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   640,    99,   100,   101,   341,   641,   103,     0,
     104,   105,   106,   107,   642,   643,     0,   109,   110,   111,
       0,   112,   644,   645,     0,   342,   343,     0,     0,     0,
     600,   601,     0,     0,     0,     0,   602,     0,     0,     0,
       0,     0,     0,     0,     0,   603,     0,   604,     0,   605,
     606,     0,   344,   345,   346,   347,   348,   349,   350,     0,
     352,     0,     0,     0,     0,  1078,     0,     0,   360,   361,
     362,   129,   363,   364,   365,   131,  1079,   133,  1080,  1081,
    1924,   367,   368,     0,   369,  1082,  1083,   372,  1084,  1085,
     373,     0,   375,   376,   377,   378,  1086,     0,     0,   381,
     382,   383,     0,   385,   386,  1087,   387,     0,   389,   390,
     145,  1088,  1089,  1090,  1091,   395,   396,   397,   398,   399,
    1092,  1093,   400,     0,   402,     0,   404,     0,   405,   406,
     407,     0,     0,     0,   411,  1094,   413,   414,     0,   416,
     417,     0,   419,     0,   421,   422,   423,  1095,   424,     0,
    1096,  1097,   426,   427,  1098,     0,   429,     0,   431,   161,
    1925,   162,   433,     0,   434,     0,     0,   437,     0,   439,
     440,   165,   441,   442,   443,   166,   444,   445,   446,   447,
       0,   167,   449,     0,   450,   451,   452,  1099,  1100,     0,
    1101,     0,     0,   171,   172,   455,   173,   456,   457,   458,
     459,  1926,   174,   461,   175,     0,   463,   464,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,   475,  1102,
     180,  1103,   691,   478,   479,   480,   481,   182,  1104,   483,
     484,   184,  1105,  1106,  1107,   486,     0,     0,   489,   692,
       0,     0,  1108,   494,     0,     0,   497,   187,   188,  1109,
     498,   499,   500,   501,   502,     0,  1110,   503,   504,   505,
       0,   507,   508,   509,   510,   511,  1111,   512,     0,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   195,   523,
    1112,   524,   525,   526,   527,   528,     0,     0,   530,   531,
     532,  1113,   534,   200,   535,   536,   202,   537,  1114,     0,
     539,   540,   541,   542,   543,   544,   545,   546,  1115,   547,
       0,   549,   550,   551,     0,  1116,  1117,     0,   554,  1927,
     556,  1118,   557,  1119,  1120,   559,   560,   561,   562,     0,
    1121,   564,   565,   566,   567,   568,  1122,     0,   571,   572,
     573,  1123,   574,   217,   575,   576,     0,     0,     0,   579,
     580,   581,   582,   583,   584,     0,   218,    49,  1124,   219,
     609,     0,     0,  1125,  1126,    52,  1127,    53,     0,     0,
       0,     0,  1128,  1129,     0,     0,  1131,  1132,     0,     0,
       0,  1133,   639,    79,    80,    81,   338,     0,    83,    84,
       0,    85,    86,    87,   339,     0,   340,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   640,    99,   100,   101,
     341,   641,   103,     0,   104,   105,   106,   107,   642,   643,
       0,   109,   110,   111,     0,   112,   644,   645,     0,   342,
     343,     0,     0,     0,   600,   601,     0,     0,     0,     0,
     602,     0,     0,     0,     0,     0,     0,     0,     0,   603,
       0,   604,     0,   605,   606,     0,   344,   345,   346,   347,
     348,   349,   350,     0,   352,     0,     0,     0,     0,  1078,
       0,     0,   360,   361,   362,   129,   363,   364,   365,   131,
    1079,   133,  1080,  1081,     0,   367,   368,     0,   369,  1082,
    1083,   372,  1084,  1085,   373,     0,   375,   376,   377,   378,
    1086,     0,     0,   381,   382,   383,     0,   385,   386,  1087,
     387,     0,   389,   390,   145,  1088,  1089,  1090,  1091,   395,
     396,   397,   398,   399,  1092,  1093,   400,  2207,   402,     0,
     404,     0,   405,   406,   407,     0,     0,     0,   411,  1094,
     413,   414,     0,   416,   417,     0,   419,     0,   421,   422,
     423,  1095,   424,     0,  1096,  1097,   426,   427,  1098,     0,
     429,     0,   431,   161,     0,   162,   433,     0,   434,     0,
       0,   437,     0,   439,   440,   165,   441,   442,   443,   166,
     444,   445,   446,   447,     0,   167,   449,     0,   450,   451,
     452,  1099,  1100,     0,  1101,     0,     0,   171,   172,   455,
     173,   456,   457,   458,   459,     0,   174,   461,   175,     0,
     463,   464,   465,   466,   467,   468,   469,   470,   471,   472,
     473,   474,   475,  1102,   180,  1103,   691,   478,   479,   480,
     481,   182,  1104,   483,   484,   184,  1105,  1106,  1107,   486,
       0,     0,   489,   692,     0,     0,  1108,   494,     0,     0,
     497,   187,   188,  1109,   498,   499,   500,   501,   502,     0,
    1110,   503,   504,   505,     0,   507,   508,   509,   510,   511,
    1111,   512,     0,   514,   515,   516,   517,   518,   519,   520,
     521,   522,   195,   523,  1112,   524,   525,   526,   527,   528,
       0,     0,   530,   531,   532,  1113,   534,   200,   535,   536,
     202,   537,  1114,     0,   539,   540,   541,   542,   543,   544,
     545,   546,  1115,   547,     0,   549,   550,   551,     0,  1116,
    1117,     0,   554,     0,   556,  1118,   557,  1119,  1120,   559,
     560,   561,   562,     0,  1121,   564,   565,   566,   567,   568,
    1122,     0,   571,   572,   573,  1123,   574,   217,   575,   576,
       0,     0,     0,   579,   580,   581,   582,   583,   584,     0,
     218,    49,  1124,   219,   609,     0,     0,  1125,  1126,    52,
    1127,    53,     0,     0,     0,     0,  1128,  1129,  1130,     0,
    1131,  1132,     0,     0,     0,  1133,   639,    79,    80,    81,
     338,     0,    83,    84,     0,    85,    86,    87,   339,     0,
     340,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     640,    99,   100,   101,   341,   641,   103,     0,   104,   105,
     106,   107,   642,   643,     0,   109,   110,   111,     0,   112,
     644,   645,     0,   342,   343,     0,     0,     0,   600,   601,
       0,     0,     0,     0,   602,     0,     0,     0,     0,     0,
       0,     0,     0,   603,     0,   604,     0,   605,   606,     0,
     344,   345,   346,   347,   348,   349,   350,     0,   352,     0,
       0,     0,     0,  1078,     0,     0,   360,   361,   362,   129,
     363,   364,   365,   131,  1079,   133,  1080,  1081,     0,   367,
     368,     0,   369,  1082,  1083,   372,  1084,  1085,   373,     0,
     375,   376,   377,   378,  1086,     0,     0,   381,   382,   383,
       0,   385,   386,  1087,   387,     0,   389,   390,   145,  1088,
    1089,  1090,  1091,   395,   396,   397,   398,   399,  1092,  1093,
     400,     0,   402,     0,   404,     0,   405,   406,   407,     0,
       0,     0,   411,  1094,   413,   414,     0,   416,   417,     0,
     419,     0,   421,   422,   423,  1095,   424,     0,  1096,  1097,
     426,   427,  1098,     0,   429,     0,   431,   161,     0,   162,
     433,     0,   434,     0,     0,   437,     0,   439,   440,   165,
     441,   442,   443,   166,   444,   445,   446,   447,     0,   167,
     449,     0,   450,   451,   452,  1099,  1100,     0,  1101,     0,
       0,   171,   172,   455,   173,   456,   457,   458,   459,     0,
     174,   461,   175,     0,   463,   464,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   474,   475,  1102,   180,  1103,
     691,   478,   479,   480,   481,   182,  1104,   483,   484,   184,
    1105,  1106,  1107,   486,     0,     0,   489,   692,     0,     0,
    1108,   494,     0,     0,   497,   187,   188,  1109,   498,   499,
     500,   501,   502,     0,  1110,   503,   504,   505,     0,   507,
     508,   509,   510,   511,  1111,   512,     0,   514,   515,   516,
     517,   518,   519,   520,   521,   522,   195,   523,  1112,   524,
     525,   526,   527,   528,     0,     0,   530,   531,   532,  1113,
     534,   200,   535,   536,   202,   537,  1114,     0,   539,   540,
     541,   542,   543,   544,   545,   546,  1115,   547,     0,   549,
     550,   551,     0,  1116,  1117,     0,   554,     0,   556,  1118,
     557,  1119,  1120,   559,   560,   561,   562,     0,  1121,   564,
     565,   566,   567,   568,  1122,     0,   571,   572,   573,  1123,
     574,   217,   575,   576,     0,     0,     0,   579,   580,   581,
     582,   583,   584,     0,   218,    49,  1124,   219,   609,     0,
       0,  1125,  1126,    52,  1127,    53,     0,     0,     0,     0,
    1128,  1129,  1130,     0,  1131,  1132,     0,     0,     0,  1133,
     639,    79,    80,    81,   338,     0,    83,    84,     0,    85,
      86,    87,   339,     0,   340,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   640,    99,   100,   101,   341,   641,
     103,     0,   104,   105,   106,   107,   642,   643,     0,   109,
     110,   111,     0,   112,   644,   645,     0,   342,   343,     0,
       0,     0,   600,   601,     0,     0,     0,     0,   602,     0,
       0,     0,     0,     0,     0,     0,     0,   603,     0,   604,
       0,   605,   606,     0,   344,   345,   346,   347,   348,   349,
     350,     0,   352,     0,     0,     0,     0,  1078,     0,     0,
     360,   361,   362,   129,   363,   364,   365,   131,  1079,   133,
    1080,  1081,     0,   367,   368,     0,   369,  1082,  1083,   372,
    1084,  1085,   373,     0,   375,   376,   377,   378,  1086,     0,
       0,   381,   382,   383,     0,   385,   386,  1087,   387,     0,
     389,   390,   145,  1088,  1089,  1090,  1091,   395,   396,   397,
     398,   399,  1092,  1093,   400,     0,   402,     0,   404,     0,
     405,   406,   407,     0,     0,     0,   411,  1094,   413,   414,
       0,   416,   417,     0,   419,     0,   421,   422,   423,  1095,
     424,     0,  1096,  1097,   426,   427,  1098,     0,   429,     0,
     431,   161,     0,   162,   433,     0,   434,     0,     0,   437,
       0,   439,   440,   165,   441,   442,   443,   166,   444,   445,
     446,   447,     0,   167,   449,     0,   450,   451,   452,  1099,
    1100,     0,  1101,     0,     0,   171,   172,   455,   173,   456,
     457,   458,   459,     0,   174,   461,   175,     0,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,  1102,   180,  1103,   691,   478,   479,   480,   481,   182,
    1104,   483,   484,   184,  1105,  1106,  1107,   486,     0,     0,
     489,   692,     0,     0,  1108,   494,     0,     0,   497,   187,
     188,  1109,   498,   499,   500,   501,   502,     0,  1110,   503,
     504,   505,     0,   507,   508,   509,   510,   511,  1111,   512,
       0,   514,   515,   516,   517,   518,   519,   520,   521,   522,
     195,   523,  1112,   524,   525,   526,   527,   528,     0,   198,
     530,   531,   532,  1113,   534,   200,   535,   536,   202,   537,
    1114,     0,   539,   540,   541,   542,   543,   544,   545,   546,
    1115,   547,     0,   549,   550,   551,     0,  1116,  1117,     0,
     554,     0,   556,  1118,   557,  1119,  1120,   559,   560,   561,
     562,     0,  1121,   564,   565,   566,   567,   568,  1122,     0,
     571,   572,   573,  1123,   574,   217,   575,   576,     0,     0,
       0,   579,   580,   581,   582,   583,   584,     0,   218,    49,
    1124,   219,   609,     0,     0,  1125,  1126,    52,  1127,    53,
       0,     0,     0,     0,  1128,  1129,     0,     0,  1131,  1132,
       0,     0,     0,  1133,   639,    79,    80,    81,   338,     0,
      83,    84,     0,    85,    86,    87,   339,     0,   340,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   640,    99,
     100,   101,   341,   641,   103,     0,   104,   105,   106,   107,
     642,   643,     0,   109,   110,   111,     0,   112,   644,   645,
       0,   342,   343,     0,     0,     0,   600,   601,     0,     0,
       0,     0,   602,     0,     0,     0,     0,     0,     0,     0,
       0,   603,     0,   604,     0,   605,   606,     0,   344,   345,
     346,   347,   348,   349,   350,  1633,   352,     0,     0,     0,
       0,  1078,     0,     0,   360,   361,   362,   129,   363,   364,
     365,   131,  1079,   133,  1080,  1081,     0,   367,   368,     0,
     369,  1082,  1083,   372,  1084,  1085,   373,     0,   375,   376,
     377,   378,  1086,     0,     0,   381,   382,   383,     0,   385,
     386,  1087,   387,     0,   389,   390,   145,  1088,  1089,  1090,
    1091,   395,   396,   397,   398,   399,  1092,  1093,   400,     0,
     402,     0,   404,     0,   405,   406,   407,     0,     0,     0,
     411,  1094,   413,   414,     0,   416,   417,     0,   419,     0,
     421,   422,   423,  1095,   424,     0,  1096,  1097,   426,   427,
    1098,     0,   429,     0,   431,   161,     0,   162,   433,     0,
     434,     0,     0,   437,     0,   439,   440,   165,   441,   442,
     443,   166,   444,   445,   446,   447,     0,   167,   449,     0,
     450,   451,   452,  1099,  1100,     0,  1101,     0,     0,   171,
     172,   455,   173,   456,   457,   458,   459,     0,   174,   461,
     175,     0,   463,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   474,   475,  1102,   180,  1103,   691,   478,
     479,   480,   481,   182,  1104,   483,   484,   184,  1105,  1106,
    1107,   486,     0,     0,   489,   692,     0,     0,  1108,   494,
       0,     0,   497,   187,   188,  1109,   498,   499,   500,   501,
     502,     0,  1110,   503,   504,   505,     0,   507,   508,   509,
     510,   511,  1111,   512,     0,   514,   515,   516,   517,   518,
     519,   520,   521,   522,   195,   523,  1112,   524,   525,   526,
     527,   528,     0,     0,   530,   531,   532,  1113,   534,   200,
     535,   536,   202,   537,  1114,     0,   539,   540,   541,   542,
     543,   544,   545,   546,  1115,   547,     0,   549,   550,   551,
       0,  1116,  1117,     0,   554,     0,   556,  1118,   557,  1119,
    1120,   559,   560,   561,   562,     0,  1121,   564,   565,   566,
     567,   568,  1122,     0,   571,   572,   573,  1123,   574,   217,
     575,   576,     0,     0,     0,   579,   580,   581,   582,   583,
     584,     0,   218,    49,  1124,   219,   609,     0,     0,  1125,
    1126,    52,  1127,    53,     0,     0,     0,     0,  1128,  1129,
       0,     0,  1131,  1132,     0,     0,     0,  1133,   639,    79,
      80,    81,   338,     0,    83,    84,     0,    85,    86,    87,
     339,     0,   340,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   640,    99,   100,   101,   341,   641,   103,     0,
     104,   105,   106,   107,   642,   643,     0,   109,   110,   111,
       0,   112,   644,   645,     0,   342,   343,     0,     0,     0,
     600,   601,     0,     0,     0,     0,   602,     0,     0,     0,
       0,     0,     0,     0,     0,   603,     0,   604,     0,   605,
     606,     0,   344,   345,   346,   347,   348,   349,   350,     0,
     352,     0,     0,     0,     0,  1078,     0,     0,   360,   361,
     362,   129,   363,   364,   365,   131,  1079,   133,  1080,  1081,
       0,   367,   368,     0,   369,  1082,  1083,   372,  1084,  1085,
     373,     0,   375,   376,   377,   378,  1086,     0,     0,   381,
     382,   383,     0,   385,   386,  1087,   387,     0,   389,   390,
     145,  1088,  1089,  1090,  1091,   395,   396,   397,   398,   399,
    1092,  1093,   400,     0,   402,     0,   404,     0,   405,   406,
     407,     0,     0,     0,   411,  1094,   413,   414,     0,   416,
     417,     0,   419,     0,   421,   422,   423,  1095,   424,     0,
    1096,  1097,   426,   427,  1098,     0,   429,     0,   431,   161,
       0,   162,   433,     0,   434,     0,     0,   437,     0,   439,
     440,   165,   441,   442,   443,   166,   444,   445,   446,   447,
       0,   167,   449,     0,   450,   451,   452,  1099,  1100,     0,
    1101,     0,     0,   171,   172,   455,   173,   456,   457,   458,
     459,     0,   174,   461,   175,     0,   463,   464,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,   475,  1102,
     180,  1103,   691,   478,   479,   480,   481,   182,  1104,   483,
     484,   184,  1105,  1106,  1107,   486,     0,     0,   489,   692,
       0,     0,  1108,   494,     0,     0,   497,   187,   188,  1109,
     498,   499,   500,   501,   502,     0,  1110,   503,   504,   505,
       0,   507,   508,   509,   510,   511,  1111,   512,     0,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   195,   523,
    1112,   524,   525,   526,   527,   528,     0,     0,   530,   531,
     532,  1113,   534,   200,   535,   536,   202,   537,  1114,     0,
     539,   540,   541,   542,   543,   544,   545,   546,  1115,   547,
       0,   549,   550,   551,     0,  1116,  1117,     0,   554,     0,
     556,  1118,   557,  1119,  1120,   559,   560,   561,   562,     0,
    1121,   564,   565,   566,   567,   568,  1122,     0,   571,   572,
     573,  1123,   574,   217,   575,   576,     0,     0,     0,   579,
     580,   581,   582,   583,   584,     0,   218,    49,  1124,   219,
     609,     0,     0,  1125,  1126,    52,  1127,    53,     0,     0,
       0,     0,  1128,  1129,     0,     0,  1131,  1132,     0,  1464,
       0,  1133,   639,    79,    80,    81,   338,     0,    83,    84,
       0,    85,    86,    87,   339,     0,   340,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   640,    99,   100,   101,
     341,   641,   103,     0,   104,   105,   106,   107,   642,   643,
       0,   109,   110,   111,     0,   112,   644,   645,     0,   342,
     343,     0,     0,     0,   600,   601,     0,     0,     0,     0,
     602,     0,     0,     0,     0,     0,     0,     0,     0,   603,
       0,   604,     0,   605,   606,     0,   344,   345,   346,   347,
     348,   349,   350,     0,   352,     0,     0,     0,     0,  1078,
       0,     0,   360,   361,   362,   129,   363,   364,   365,   131,
    1079,   133,  1080,  1081,     0,   367,   368,     0,   369,  1082,
    1083,   372,  1084,  1085,   373,     0,   375,   376,   377,   378,
    1086,     0,     0,   381,   382,   383,     0,   385,   386,  1087,
     387,     0,   389,   390,   145,  1088,  1089,  1090,  1091,   395,
     396,   397,   398,   399,  1092,  1093,   400,     0,   402,     0,
     404,     0,   405,   406,   407,     0,     0,     0,   411,  1094,
     413,   414,     0,   416,   417,     0,   419,     0,   421,   422,
     423,  1095,   424,     0,  1096,  1097,   426,   427,  1098,     0,
     429,     0,   431,   161,  1925,   162,   433,     0,   434,     0,
       0,   437,     0,   439,   440,   165,   441,   442,   443,   166,
     444,   445,   446,   447,     0,   167,   449,     0,   450,   451,
     452,  1099,  1100,     0,  1101,     0,     0,   171,   172,   455,
     173,   456,   457,   458,   459,     0,   174,   461,   175,     0,
     463,   464,   465,   466,   467,   468,   469,   470,   471,   472,
     473,   474,   475,  1102,   180,  1103,   691,   478,   479,   480,
     481,   182,  1104,   483,   484,   184,  1105,  1106,  1107,   486,
       0,     0,   489,   692,     0,     0,  1108,   494,     0,     0,
     497,   187,   188,  1109,   498,   499,   500,   501,   502,     0,
    1110,   503,   504,   505,     0,   507,   508,   509,   510,   511,
    1111,   512,     0,   514,   515,   516,   517,   518,   519,   520,
     521,   522,   195,   523,  1112,   524,   525,   526,   527,   528,
       0,     0,   530,   531,   532,  1113,   534,   200,   535,   536,
     202,   537,  1114,     0,   539,   540,   541,   542,   543,   544,
     545,   546,  1115,   547,     0,   549,   550,   551,     0,  1116,
    1117,     0,   554,     0,   556,  1118,   557,  1119,  1120,   559,
     560,   561,   562,     0,  1121,   564,   565,   566,   567,   568,
    1122,     0,   571,   572,   573,  1123,   574,   217,   575,   576,
       0,     0,     0,   579,   580,   581,   582,   583,   584,     0,
     218,    49,  1124,   219,   609,     0,     0,  1125,  1126,    52,
    1127,    53,     0,     0,     0,     0,  1128,  1129,     0,     0,
    1131,  1132,     0,     0,     0,  1133,   639,    79,    80,    81,
     338,     0,    83,    84,     0,    85,    86,    87,   339,     0,
     340,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     640,    99,   100,   101,   341,   641,   103,     0,   104,   105,
     106,   107,   642,   643,     0,   109,   110,   111,     0,   112,
     644,   645,     0,   342,   343,     0,     0,     0,   600,   601,
       0,     0,     0,     0,   602,     0,     0,     0,     0,     0,
       0,     0,     0,   603,     0,   604,     0,   605,   606,     0,
     344,   345,   346,   347,   348,   349,   350,     0,   352,     0,
       0,     0,     0,  1078,     0,     0,   360,   361,   362,   129,
     363,   364,   365,   131,  1079,   133,  1080,  1081,     0,   367,
     368,     0,   369,  1082,  1083,   372,  1084,  1085,   373,     0,
     375,   376,   377,   378,  1086,     0,     0,   381,   382,   383,
       0,   385,   386,  1087,   387,     0,   389,   390,   145,  1088,
    1089,  1090,  1091,   395,   396,   397,   398,   399,  1092,  1093,
     400,  2603,   402,     0,   404,     0,   405,   406,   407,     0,
       0,     0,   411,  1094,   413,   414,     0,   416,   417,     0,
     419,     0,   421,   422,   423,  1095,   424,     0,  1096,  1097,
     426,   427,  1098,     0,   429,     0,   431,   161,     0,   162,
     433,     0,   434,     0,     0,   437,     0,   439,   440,   165,
     441,   442,   443,   166,   444,   445,   446,   447,     0,   167,
     449,     0,   450,   451,   452,  1099,  1100,     0,  1101,     0,
       0,   171,   172,   455,   173,   456,   457,   458,   459,     0,
     174,   461,   175,     0,   463,   464,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   474,   475,  1102,   180,  1103,
     691,   478,   479,   480,   481,   182,  1104,   483,   484,   184,
    1105,  1106,  1107,   486,     0,     0,   489,   692,     0,     0,
    1108,   494,     0,     0,   497,   187,   188,  1109,   498,   499,
     500,   501,   502,     0,  1110,   503,   504,   505,     0,   507,
     508,   509,   510,   511,  1111,   512,     0,   514,   515,   516,
     517,   518,   519,   520,   521,   522,   195,   523,  1112,   524,
     525,   526,   527,   528,     0,     0,   530,   531,   532,  1113,
     534,   200,   535,   536,   202,   537,  1114,     0,   539,   540,
     541,   542,   543,   544,   545,   546,  1115,   547,     0,   549,
     550,   551,     0,  1116,  1117,     0,   554,     0,   556,  1118,
     557,  1119,  1120,   559,   560,   561,   562,     0,  1121,   564,
     565,   566,   567,   568,  1122,     0,   571,   572,   573,  1123,
     574,   217,   575,   576,     0,     0,     0,   579,   580,   581,
     582,   583,   584,     0,   218,    49,  1124,   219,   609,     0,
       0,  1125,  1126,    52,  1127,    53,     0,     0,     0,     0,
    1128,  1129,     0,     0,  1131,  1132,     0,     0,     0,  1133,
     639,    79,    80,    81,   338,     0,    83,    84,     0,    85,
      86,    87,   339,     0,   340,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   640,    99,   100,   101,   341,   641,
     103,     0,   104,   105,   106,   107,   642,   643,     0,   109,
     110,   111,     0,   112,   644,   645,     0,   342,   343,     0,
       0,     0,   600,   601,     0,     0,     0,     0,   602,     0,
       0,     0,     0,     0,     0,     0,     0,   603,     0,   604,
       0,   605,   606,     0,   344,   345,   346,   347,   348,   349,
     350,     0,   352,     0,     0,     0,     0,  1078,     0,     0,
     360,   361,   362,   129,   363,   364,   365,   131,  1079,   133,
    1080,  1081,     0,   367,   368,     0,   369,  1082,  1083,   372,
    1084,  1085,   373,     0,   375,   376,   377,   378,  1086,     0,
       0,   381,   382,   383,     0,   385,   386,  1087,   387,     0,
     389,   390,   145,  1088,  1089,  1090,  1091,   395,   396,   397,
     398,   399,  1092,  1093,   400,     0,   402,     0,   404,     0,
     405,   406,   407,     0,     0,     0,   411,  1094,   413,   414,
       0,   416,   417,     0,   419,     0,   421,   422,   423,  1095,
     424,     0,  1096,  1097,   426,   427,  1098,     0,   429,     0,
     431,   161,     0,   162,   433,     0,   434,     0,     0,   437,
       0,   439,   440,   165,   441,   442,   443,   166,   444,   445,
     446,   447,     0,   167,   449,     0,   450,   451,   452,  1099,
    1100,     0,  1101,     0,     0,   171,   172,   455,   173,   456,
     457,   458,   459,     0,   174,   461,   175,     0,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,  1102,   180,  1103,   691,   478,   479,   480,   481,   182,
    1104,   483,   484,   184,  1105,  1106,  1107,   486,     0,     0,
     489,   692,     0,     0,  1108,   494,     0,     0,   497,   187,
     188,  1109,   498,   499,   500,   501,   502,     0,  1110,   503,
     504,   505,     0,   507,   508,   509,   510,   511,  1111,   512,
       0,   514,   515,   516,   517,   518,   519,   520,   521,   522,
     195,   523,  1112,   524,   525,   526,   527,   528,     0,     0,
     530,   531,   532,  1113,   534,   200,   535,   536,   202,   537,
    1114,     0,   539,   540,   541,   542,   543,   544,   545,   546,
    1115,   547,     0,   549,   550,   551,     0,  1116,  1117,     0,
     554,     0,   556,  1118,   557,  1119,  1120,   559,   560,   561,
     562,     0,  1121,   564,   565,   566,   567,   568,  1122,     0,
     571,   572,   573,  1123,   574,   217,   575,   576,     0,     0,
       0,   579,   580,   581,   582,   583,   584,     0,   218,    49,
    1124,   219,   609,     0,     0,  1125,  1126,    52,  1127,    53,
       0,     0,     0,     0,  1128,  1129,     0,     0,  1131,  1132,
       0,     0,     0,  1133,   639,    79,    80,    81,   338,     0,
      83,    84,     0,    85,    86,    87,   339,     0,   340,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   640,    99,
     100,   101,   341,   641,   103,     0,   104,   105,   106,   107,
     642,   643,     0,   109,   110,   111,     0,   112,   644,   645,
       0,   342,   343,     0,     0,     0,   600,   601,     0,     0,
       0,     0,   602,     0,     0,     0,     0,     0,     0,     0,
       0,   603,     0,   604,     0,   605,   606,     0,   344,   345,
     346,   347,   348,   349,   350,     0,   352,     0,     0,     0,
       0,  1078,     0,     0,   360,   361,   362,   129,   363,   364,
     365,   131,  1079,   133,  1080,  1081,     0,   367,   368,     0,
     369,  1082,  1083,   372,  1084,  1085,   373,     0,   375,   376,
     377,   378,  1086,     0,     0,   381,   382,   383,     0,   385,
     386,  1087,   387,     0,   389,   390,   145,  1088,  1089,  1090,
    1091,   395,   396,   397,   398,   399,  1092,  1093,   400,     0,
     402,     0,   404,     0,   405,   406,   407,     0,     0,     0,
     411,  1094,   413,   414,     0,   416,   417,     0,   419,     0,
     421,   422,   423,  1095,   424,     0,  1096,  1097,   426,   427,
    1098,     0,   429,     0,   431,   161,     0,   162,   433,     0,
     434,     0,     0,   437,     0,   439,   440,   165,   441,   442,
     443,   166,   444,   445,   446,   447,     0,   167,   449,     0,
     450,   451,   452,  1099,  1100,     0,  1101,     0,     0,   171,
     172,   455,   173,   456,   457,   458,   459,     0,   174,   461,
     175,     0,   463,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   474,   475,  1102,   180,  1103,   691,   478,
     479,   480,   481,   182,     0,   483,   484,   184,  1105,  1106,
    1107,   486,     0,     0,   489,   692,     0,     0,  1108,   494,
       0,     0,   497,   187,   188,  1109,   498,   499,   500,   501,
     502,     0,  1110,   503,   504,   505,     0,   507,   508,   509,
     510,   511,  1111,   512,     0,   514,   515,   516,   517,   518,
     519,   520,   521,   522,   195,   523,   197,   524,   525,   526,
     527,   528,     0,     0,   530,   531,   532,  1113,   534,   200,
     535,   536,   202,   537,  1114,     0,   539,   540,   541,   542,
     543,   544,   545,   546,  1115,   547,     0,   549,   550,   551,
       0,  1116,  1117,     0,   554,     0,   556,  1118,   557,  1119,
    1120,   559,   560,   561,   562,     0,     0,   564,   565,   566,
     567,   568,  1122,     0,   571,   572,   573,  1123,   574,   217,
     575,   576,     0,     0,     0,   579,   580,   581,   582,   583,
     584,     0,   218,    49,  1124,   219,   609,     0,     0,  1125,
    1126,    52,  1127,    53,     0,     0,     0,     0,     0,  1905,
       0,     0,  1906,  1907,     0,     0,     0,  1908,   639,    79,
      80,    81,   338,     0,    83,    84,     0,    85,    86,    87,
     339,     0,   340,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   640,    99,   100,   101,   341,   641,   103,     0,
     104,   105,   106,   107,   642,   643,     0,   109,   110,   111,
       0,   112,   644,   645,     0,   342,   343,     0,     0,     0,
     600,   601,     0,     0,     0,     0,   602,     0,     0,     0,
       0,     0,     0,     0,     0,   603,     0,   604,     0,   605,
     606,     0,   344,   345,   346,   347,   348,   349,   350,     0,
     352,     0,     0,     0,     0,  1078,     0,     0,   360,   361,
     362,   129,   363,   364,   365,     0,  1079,   133,  1080,  1081,
       0,   367,   368,     0,   369,  1082,  1083,   372,  1084,  1085,
     373,     0,   375,   376,   377,   378,  1086,     0,     0,   381,
     382,   383,     0,   385,   386,  1087,   387,     0,   389,   390,
     145,  1088,  1089,  1090,  1091,   395,   396,   397,   398,   399,
    1092,  1093,   400,     0,   402,     0,   404,     0,   405,   406,
     407,     0,     0,     0,   411,  1094,   413,   414,     0,   416,
     417,     0,     0,     0,   421,   422,   423,  1095,   424,     0,
    1096,  1097,   426,   427,  1098,     0,   429,     0,   431,   161,
       0,   162,   433,     0,   434,     0,     0,   437,     0,   439,
     440,     0,   441,   442,   443,     0,   444,   445,   446,   447,
       0,   167,   449,     0,   450,   451,   452,  1099,  1100,     0,
    1101,     0,     0,   171,   172,   455,   173,   456,   457,   458,
     459,     0,   174,   461,     0,     0,   463,   464,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,   475,  1102,
     180,  1103,   691,   478,   479,   480,   481,   182,     0,   483,
     484,   184,  1105,  1106,  1107,   486,     0,     0,   489,   692,
       0,     0,  1108,   494,     0,     0,   497,   187,   188,  1109,
     498,   499,   500,   501,   502,     0,  1110,   503,   504,   505,
       0,   507,   508,   509,   510,   511,  1111,   512,     0,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   195,   523,
    1112,   524,   525,   526,   527,   528,     0,     0,   530,   531,
     532,  1113,   534,   200,   535,   536,     0,   537,  1114,     0,
     539,   540,   541,   542,   543,   544,   545,   546,  1115,   547,
       0,   549,   550,   551,     0,  1116,  1117,     0,   554,     0,
     556,  1118,   557,  1119,  1120,   559,   560,   561,   562,     0,
    1121,   564,   565,   566,   567,   568,  1122,     0,   571,   572,
     573,  1123,   574,   217,   575,   576,     0,     0,     0,   579,
     580,   581,   582,   583,   584,     0,   218,    49,  1124,   219,
     609,     0,     0,  1125,  1126,    52,  1127,    53,     0,     0,
       0,     0,  1128,  1129,     0,     0,  1131,  1132,     0,     0,
       0,  1133,   639,    79,    80,    81,   338,     0,    83,    84,
       0,    85,    86,    87,   339,     0,   340,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   640,    99,   100,   101,
     341,   641,   103,     0,   104,   105,   106,   107,   642,   643,
       0,   109,   110,   111,     0,   112,   644,   645,     0,   342,
     343,     0,     0,     0,   600,   601,     0,     0,     0,     0,
     602,     0,     0,     0,     0,     0,     0,     0,     0,   603,
       0,   604,     0,   605,   606,     0,   344,   345,   346,   347,
     348,   349,   350,     0,   352,     0,     0,     0,     0,  1078,
       0,     0,   360,   361,   362,   129,   363,   364,   365,   131,
    1079,   133,  1080,  1081,     0,   367,   368,     0,   369,  1082,
    1083,   372,  1084,  1085,   373,     0,   375,   376,   377,   378,
    1086,     0,     0,   381,   382,   383,     0,   385,   386,  1087,
     387,     0,   389,   390,   145,  1088,  1089,  1090,  1091,   395,
     396,   397,   398,   399,  1092,  1093,   400,     0,   402,     0,
     404,     0,   405,   406,   407,     0,     0,     0,   411,  1094,
     413,   414,     0,   416,   417,     0,   419,     0,   421,   422,
     423,  1095,   424,     0,  1096,  1097,   426,   427,  1098,     0,
     429,     0,   431,   161,     0,   162,   433,     0,   434,     0,
       0,   437,     0,   439,   440,   165,   441,   442,   443,   166,
     444,   445,   446,   447,     0,   167,   449,     0,   450,   451,
     452,  1099,  1100,     0,  1101,     0,     0,   171,   172,   455,
     173,   456,   457,   458,   459,     0,   174,   461,   175,     0,
     463,   464,   465,   466,   467,   468,   469,   470,   471,   472,
     473,   474,   475,  1102,   180,  1103,   691,   478,   479,   480,
     481,   182,     0,   483,   484,   184,  1105,  1106,  1107,   486,
       0,     0,   489,   692,     0,     0,   493,   494,     0,     0,
     497,   187,   188,  1109,   498,   499,   500,   501,   502,     0,
    1110,   503,   504,   505,     0,   507,   508,   509,   510,   511,
    1111,   512,     0,   514,   515,   516,   517,   518,   519,   520,
     521,   522,   195,   523,   197,   524,   525,   526,   527,   528,
       0,     0,   530,   531,   532,  1113,   534,   200,   535,   536,
     202,   537,  1114,     0,   539,   540,   541,   542,   543,   544,
     545,   546,  1115,   547,     0,   549,   550,   551,     0,  1116,
    1117,     0,   554,     0,   556,  1118,   557,  1119,  1120,   559,
     560,   561,   562,     0,     0,   564,   565,   566,   567,   568,
    1122,     0,   571,   572,   573,  1123,   574,   217,   575,   576,
       0,     0,     0,   579,   580,   581,   582,   583,   584,     0,
     218,    49,     0,   219,   609,     0,     0,  1125,  1126,    52,
    1127,    53,   639,    79,    80,    81,   338,     0,    83,    84,
       0,    85,    86,    87,   339,  1908,   340,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   640,    99,   100,   101,
     341,   641,   103,     0,   104,   105,   106,   107,   642,   643,
       0,   109,   110,   111,     0,   112,   644,   645,     0,   342,
     343,     0,     0,     0,   600,   601,     0,     0,     0,     0,
     602,     0,     0,     0,     0,     0,     0,     0,     0,   603,
       0,   604,     0,   605,   606,     0,   344,   345,   346,   347,
     348,   349,   350,     0,   352,     0,     0,     0,     0,  1078,
       0,     0,   360,   361,   362,   129,   363,   364,   365,     0,
    1079,   133,  1080,  1081,     0,   367,   368,     0,   369,  1082,
    1083,   372,  1084,  1085,   373,     0,   375,   376,   377,   378,
    1086,     0,     0,   381,   382,   383,     0,   385,   386,  1087,
     387,     0,   389,   390,   145,  1088,  1089,  1090,  1091,   395,
     396,   397,   398,   399,  1092,  1093,   400,     0,   402,     0,
     404,     0,   405,   406,   407,     0,     0,     0,   411,  1094,
     413,   414,     0,   416,   417,     0,     0,     0,   421,   422,
     423,  1095,   424,     0,  1096,  1097,   426,   427,  1098,     0,
     429,     0,   431,   161,     0,   162,   433,     0,   434,     0,
       0,   437,     0,   439,   440,     0,   441,   442,   443,     0,
     444,   445,   446,   447,     0,   167,   449,     0,   450,   451,
     452,  1099,  1100,     0,  1101,     0,     0,   171,   172,   455,
     173,   456,   457,   458,   459,     0,   174,   461,     0,     0,
     463,   464,   465,   466,   467,   468,   469,   470,   471,   472,
     473,   474,   475,  1102,   180,  1103,   691,   478,   479,   480,
     481,   182,     0,   483,   484,   184,  1105,  1106,  1107,   486,
       0,     0,   489,   692,     0,     0,     0,   494,     0,     0,
     497,   187,   188,  1109,   498,   499,   500,   501,   502,     0,
    1110,   503,   504,   505,     0,   507,   508,   509,   510,   511,
    1111,   512,     0,   514,   515,   516,   517,   518,   519,   520,
     521,   522,   195,   523,   197,   524,   525,   526,   527,   528,
       0,     0,   530,   531,   532,  1113,   534,   200,   535,   536,
       0,   537,  1114,     0,   539,   540,   541,   542,   543,   544,
     545,   546,  1115,   547,     0,   549,   550,   551,     0,  1116,
    1117,     0,   554,     0,   556,  1118,   557,  1119,  1120,   559,
     560,   561,   562,     0,     0,   564,   565,   566,   567,   568,
    1122,     0,   571,   572,   573,  1123,   574,   217,   575,   576,
       0,     0,     0,   579,   580,   581,   582,   583,   584,     0,
     218,    49,     0,   219,   609,     0,     0,  1125,  1126,    52,
    1127,    53,     0,     0,     0,     0,     0,  1905,     0,     0,
    1906,  1907,     0,     0,     0,  1908,   639,    79,    80,    81,
     338,     0,    83,    84,     0,    85,    86,    87,   339,     0,
     340,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     640,    99,   100,   101,   341,   641,   103,     0,   104,   105,
     106,   107,   642,   643,     0,   109,   110,   111,     0,   112,
     644,   645,     0,   342,   343,     0,     0,     0,   600,   601,
       0,     0,     0,     0,   602,     0,     0,     0,     0,     0,
       0,     0,     0,   603,     0,   604,     0,   605,   606,     0,
     344,   345,   346,   347,   348,   349,   350,  -922,   352,     0,
       0,     0,  -922,  1078,     0,     0,   360,   361,   362,   129,
     363,   364,   365,     0,  1079,   133,  1080,  1081,     0,   367,
     368,     0,   369,  1082,  1083,   372,  1084,  1085,   373,     0,
     375,   376,   377,   378,  1086,     0,     0,   381,   382,   383,
       0,   385,   386,  1087,   387,     0,   389,   390,   145,  1088,
    1089,  1090,  1091,   395,   396,   397,   398,   399,  1092,  1093,
     400,     0,   402,     0,   404,     0,   405,   406,   407,     0,
       0,     0,   411,  1094,   413,   414,     0,   416,   417,     0,
       0,     0,   421,   422,   423,  1095,   424,     0,  1096,  1097,
     426,   427,  1098,     0,   429,     0,   431,   161,     0,   162,
     433,     0,   434,     0,     0,   437,     0,   439,   440,     0,
     441,   442,   443,     0,   444,   445,   446,   447,     0,   167,
     449,     0,   450,   451,   452,  1099,  1100,     0,  1101,     0,
       0,     0,     0,   455,   173,   456,   457,   458,   459,     0,
     174,   461,     0,     0,   463,   464,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   474,   475,  1102,   180,  1103,
     691,   478,   479,   480,   481,   182,     0,   483,   484,     0,
    1105,  1106,  1107,   486,     0,     0,   489,   692,     0,     0,
       0,   494,     0,     0,   497,   187,   188,  1109,   498,   499,
     500,   501,   502,     0,  1110,   503,   504,   505,     0,   507,
     508,   509,   510,   511,  1111,   512,     0,   514,   515,   516,
     517,   518,   519,   520,   521,   522,   195,   523,  1112,   524,
     525,   526,   527,   528,     0,     0,   530,   531,   532,  1113,
     534,   200,   535,   536,     0,   537,  1114,  -922,   539,   540,
     541,   542,   543,   544,   545,   546,  1115,   547,     0,   549,
     550,   551,     0,  1116,  1117,     0,   554,     0,   556,  1118,
     557,  1119,  1120,   559,   560,   561,   562,     0,  1121,   564,
     565,   566,   567,   568,  1122,     0,   571,   572,   573,  1123,
     574,   217,   575,   576,     0,     0,     0,   579,   580,   581,
     582,   583,   584,     0,   218,    49,     0,   219,   609,     0,
       0,  1125,  1126,    52,  1127,    53,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1132,     0,     0,     0,  1133,
     639,    79,    80,    81,   338,     0,    83,    84,     0,    85,
      86,    87,   339,     0,   340,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   640,    99,   100,   101,   341,   641,
     103,     0,   104,   105,   106,   107,   642,   643,     0,   109,
     110,   111,     0,   112,   644,   645,     0,   342,   343,     0,
       0,     0,   600,   601,     0,     0,     0,     0,   602,     0,
       0,     0,     0,     0,     0,     0,     0,   603,     0,   604,
       0,   605,   606,     0,   344,   345,   346,   347,   348,   349,
     350,  -923,   352,     0,     0,     0,  -923,  1078,     0,     0,
     360,   361,   362,   129,   363,   364,   365,     0,  1079,   133,
    1080,  1081,     0,   367,   368,     0,   369,  1082,  1083,   372,
    1084,  1085,   373,     0,   375,   376,   377,   378,  1086,     0,
       0,   381,   382,   383,     0,   385,   386,  1087,   387,     0,
     389,   390,   145,  1088,  1089,  1090,  1091,   395,   396,   397,
     398,   399,  1092,  1093,   400,     0,   402,     0,   404,     0,
     405,   406,   407,     0,     0,     0,   411,  1094,   413,   414,
       0,   416,   417,     0,     0,     0,   421,   422,   423,  1095,
     424,     0,  1096,  1097,   426,   427,  1098,     0,   429,     0,
     431,   161,     0,   162,   433,     0,   434,     0,     0,   437,
       0,   439,   440,     0,   441,   442,   443,     0,   444,   445,
     446,   447,     0,   167,   449,     0,   450,   451,   452,  1099,
    1100,     0,  1101,     0,     0,     0,     0,   455,   173,   456,
     457,   458,   459,     0,   174,   461,     0,     0,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,  1102,   180,  1103,   691,   478,   479,   480,   481,   182,
       0,   483,   484,     0,  1105,  1106,  1107,   486,     0,     0,
     489,   692,     0,     0,     0,   494,     0,     0,   497,   187,
     188,  1109,   498,   499,   500,   501,   502,     0,  1110,   503,
     504,   505,     0,   507,   508,   509,   510,   511,  1111,   512,
       0,   514,   515,   516,   517,   518,   519,   520,   521,   522,
     195,   523,  1112,   524,   525,   526,   527,   528,     0,     0,
     530,   531,   532,  1113,   534,   200,   535,   536,     0,   537,
    1114,  -923,   539,   540,   541,   542,   543,   544,   545,   546,
    1115,   547,     0,   549,   550,   551,     0,  1116,  1117,     0,
     554,     0,   556,  1118,   557,  1119,  1120,   559,   560,   561,
     562,     0,  1121,   564,   565,   566,   567,   568,  1122,     0,
     571,   572,   573,  1123,   574,   217,   575,   576,     0,     0,
       0,   579,   580,   581,   582,   583,   584,     0,   218,    49,
       0,   219,   609,     0,     0,  1125,  1126,    52,  1127,    53,
     639,    79,    80,    81,   338,     0,    83,    84,     0,    85,
      86,    87,   339,  1133,   340,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   640,    99,   100,   101,   341,   641,
     103,     0,   104,   105,   106,   107,   642,   643,     0,   109,
     110,   111,     0,   112,   644,   645,     0,   342,   343,     0,
       0,     0,   600,   601,     0,     0,     0,     0,   602,     0,
       0,     0,     0,     0,     0,     0,     0,   603,     0,   604,
       0,   605,   606,     0,   344,   345,   346,   347,   348,   349,
     350,     0,   352,     0,     0,     0,     0,  1078,     0,     0,
     360,   361,   362,   129,   363,   364,   365,     0,  1079,   133,
    1080,  1081,     0,   367,   368,     0,   369,  1082,  1083,   372,
    1084,  1085,   373,     0,   375,   376,   377,   378,  1086,     0,
       0,   381,   382,   383,     0,   385,   386,  1087,   387,     0,
     389,   390,   145,  1088,  1089,  1090,  1091,   395,   396,   397,
     398,   399,  1092,  1093,   400,     0,   402,     0,   404,     0,
     405,   406,   407,     0,     0,     0,   411,  1094,   413,   414,
       0,   416,   417,     0,     0,     0,   421,   422,   423,  1095,
     424,     0,  1096,  1097,   426,   427,  1098,     0,   429,     0,
     431,   161,     0,   162,   433,     0,   434,     0,     0,   437,
       0,   439,   440,     0,   441,   442,   443,     0,   444,   445,
     446,   447,     0,   167,   449,     0,   450,   451,   452,  1099,
    1100,     0,  1101,     0,     0,     0,     0,   455,   173,   456,
     457,   458,   459,     0,   174,   461,     0,     0,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,  1102,   180,  1103,   691,   478,   479,   480,   481,   182,
       0,   483,   484,     0,     0,  1106,  1107,   486,     0,     0,
     489,   692,     0,     0,     0,   494,     0,     0,   497,   187,
     188,  1109,   498,   499,   500,   501,   502,     0,  1110,   503,
     504,   505,     0,   507,   508,   509,   510,   511,  1111,   512,
       0,   514,   515,   516,   517,   518,   519,   520,   521,   522,
     195,   523,   197,   524,   525,   526,   527,   528,     0,     0,
     530,   531,   532,  1113,   534,   200,   535,   536,     0,   537,
    1114,     0,   539,   540,   541,   542,   543,   544,   545,   546,
    1115,   547,     0,   549,   550,   551,     0,  1116,  1117,     0,
     554,     0,   556,  1118,   557,  1119,  1120,   559,   560,   561,
     562,     0,     0,   564,   565,   566,   567,   568,  1122,     0,
     571,   572,   573,  1123,   574,   217,   575,   576,     0,     0,
       0,   579,   580,   581,   582,   583,   584,     0,   218,    49,
       0,   219,   609,     0,     0,  1125,  1126,    52,  1127,    53,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1907,
       0,     0,     0,  1908,   639,    79,    80,    81,   338,     0,
      83,    84,     0,    85,    86,    87,   339,     0,   340,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   640,    99,
     100,   101,   341,   641,   103,     0,   104,   105,   106,   107,
     642,   643,     0,   109,   110,   111,     0,   112,   644,   645,
       0,   342,   343,     0,     0,     0,   600,   601,     0,     0,
       0,     0,   602,     0,     0,     0,     0,     0,     0,     0,
       0,   603,     0,   604,     0,   605,   606,     0,   344,   345,
     346,   347,   348,   349,   350,     0,   352,     0,     0,     0,
       0,  1078,     0,     0,   360,   361,   362,   129,   363,   364,
     365,     0,  1079,   133,  1080,  1081,     0,   367,   368,     0,
     369,  1082,  1083,   372,  1084,  1085,   373,     0,   375,   376,
     377,   378,  1086,     0,     0,   381,   382,   383,     0,   385,
     386,  1087,   387,     0,   389,   390,   145,  1088,  1089,  1090,
    1091,   395,   396,   397,   398,   399,  1092,  1093,   400,     0,
     402,     0,   404,     0,   405,   406,   407,     0,     0,     0,
     411,  1094,   413,   414,     0,   416,   417,     0,     0,     0,
     421,   422,   423,  1095,   424,     0,  1096,  1097,   426,   427,
    1098,     0,   429,     0,   431,   161,     0,   162,   433,     0,
     434,     0,     0,   437,     0,   439,   440,     0,   441,   442,
     443,     0,   444,   445,   446,   447,     0,   167,   449,     0,
     450,   451,   452,  1099,  1100,     0,  1101,     0,     0,     0,
       0,   455,   173,   456,   457,   458,   459,     0,   174,   461,
       0,     0,   463,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   474,   475,  1102,   180,  1103,   691,   478,
     479,   480,   481,   182,     0,   483,   484,     0,     0,  1106,
    1107,   486,     0,     0,   489,   692,     0,     0,     0,   494,
       0,     0,   497,   187,   188,  1109,   498,   499,   500,   501,
     502,     0,  1110,   503,   504,   505,     0,   507,   508,   509,
     510,   511,  1111,   512,     0,   514,   515,   516,   517,   518,
     519,   520,   521,   522,   195,   523,   197,   524,   525,   526,
     527,   528,     0,     0,   530,   531,   532,  1113,   534,   200,
     535,   536,     0,   537,  1114,     0,   539,   540,   541,   542,
     543,   544,   545,   546,  1115,   547,     0,   549,   550,   551,
       0,  1116,  1117,     0,   554,     0,   556,  1118,   557,  1119,
    1120,   559,   560,   561,   562,     0,     0,   564,   565,   566,
     567,   568,  1122,     0,   571,   572,   573,  1123,   574,   217,
     575,   576,     0,     0,     0,   579,   580,   581,   582,   583,
     584,     0,   218,    49,     0,   219,   609,     0,     0,  1125,
    1126,    52,  1127,    53,     0,    79,    80,    81,   338,     0,
      83,    84,     0,    85,    86,    87,   339,  1908,   340,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   341,     0,   103,     0,   104,   105,   106,   107,
       0,     0,     0,   109,   110,   111,     0,   112,     0,     0,
       0,   342,   343,     0,     0,     0,   600,   601,     0,     0,
       0,     0,   602,     0,     0,     0,     0,     0,     0,     0,
       0,   603,     0,   604,     0,   605,   606,     0,   344,   345,
     346,   347,   348,   349,   350,     0,   352,     0,     0,     0,
       0,     0,  2577,     0,   360,   361,   362,     0,   363,   364,
     365,     0,   132,     0,   134,     0,     0,   367,   368,     0,
     369,     0,     0,   372,   607,   135,   373,     0,   375,   376,
     377,   378,   139,     0,     0,   381,   382,   383,     0,   385,
     386,   142,   387,     0,   389,   390,     0,     0,     0,     0,
       0,   395,   396,   397,   398,   399,   148,   149,   400,     0,
     402,     0,   404,     0,   405,   406,   407,     0,     0,     0,
     411,   412,   413,   414,     0,   416,   417,     0,   419,  -709,
     421,   422,   423,   156,   424,     0,   158,     0,   426,   427,
     160,  -709,   429,     0,   431,     0,     0,     0,   433,     0,
     434,     0,     0,   437,     0,   439,   440,     0,   441,   442,
     443,     0,   444,   445,   446,   447,     0,     0,   449,     0,
     450,   451,   452,     0,   169,  -709,   170,     0,     0,     0,
       0,   455,     0,   456,   457,   458,   459,     0,     0,   461,
       0,  -709,   463,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   474,   475,   476,     0,   181,     0,   478,
     479,   480,   481,   182,     0,   483,   484,     0,     0,   185,
     186,   486,     0,  -709,   489,     0,     0,     0,   493,   494,
       0,  -709,   497,     0,     0,     0,   498,   499,   500,   501,
     502,     0,   189,   503,   504,   505,     0,   507,   508,   509,
     510,   511,   191,   512,     0,   514,   515,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   197,   524,   525,   526,
     527,   528,     0,     0,   530,   531,   532,     0,   534,   200,
     535,   536,     0,   537,   203,     0,   539,   540,   541,   542,
     543,   544,   545,   546,   205,   547,     0,   549,   550,   551,
       0,   206,   207,     0,   554,     0,   556,   208,   557,   209,
       0,   559,   560,   561,   562,  -709,     0,   564,   565,   566,
     567,   568,     0,     0,   571,   572,   573,   216,   574,     4,
     575,   576,     0,     0,     0,   579,   580,   581,   582,   583,
     584,     0,   218,     0,     5,   219,     0,     0,     0,     0,
       0,     0,     0,     6,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     7,     8,     0,  1212,     0,
       0,     0,     0,    10,    11,     0,     0,     0,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    36,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    37,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    38,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    39,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    40,     0,     0,    41,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    43,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    44,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      45,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    46,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,    48,    49,     0,
      50,     0,     0,     0,     0,     0,    52,     0,    53,    54,
       0,     0,     0,    55,    56,    57,    58,    59,     0,     0,
      60,    61,   912,    79,    80,    81,   338,     0,    83,    84,
       0,    85,    86,    87,   339,     0,   340,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     341,     0,   103,     0,   104,   105,   106,   107,     0,     0,
       0,   109,   110,   111,     0,   112,     0,     0,     0,   342,
     343,     0,     0,     0,   600,   601,     0,     0,     0,     0,
     602,     0,     0,     0,     0,     0,     0,     0,     0,   603,
       0,   604,     0,   605,   606,     0,   344,   345,   346,   347,
     348,   349,   350,     0,   352,     0,     0,     0,     0,     0,
       0,     0,   360,   361,   362,   129,   363,   364,   365,   131,
     132,   133,   134,     0,     0,   367,   368,     0,   369,     0,
       0,   372,   607,   135,   373,     0,   375,   376,   377,   378,
     139,     0,     0,   381,   382,   383,     0,   385,   386,   142,
     387,     0,   389,   390,   145,     0,     0,     0,     0,   395,
     396,   397,   398,   399,   148,   149,   400,     0,   402,     0,
     404,     0,   405,   406,   407,     0,     0,     0,   411,   412,
     413,   414,     0,   416,   417,     0,   419,     0,   421,   422,
     423,   156,   424,     0,   158,     0,   426,   427,   160,     0,
     429,     0,   431,   161,     0,   162,   433,     0,   434,     0,
       0,   437,     0,   439,   440,   165,   441,   442,   443,   166,
     444,   445,   446,   447,     0,   167,   449,     0,   450,   451,
     452,     0,   169,     0,   170,     0,     0,   171,   172,   455,
     173,   456,   457,   458,   459,     0,   174,   461,   175,     0,
     463,   464,   465,   466,   467,   468,   469,   470,   471,   472,
     473,   474,   475,   476,   180,   181,   691,   478,   479,   480,
     481,   182,     0,   483,   484,   184,     0,   185,   186,   486,
       0,     0,   489,   692,     0,   848,   493,   494,     0,     0,
     497,   187,   188,     0,   498,   499,   500,   501,   502,     0,
     189,   503,   504,   505,     0,   507,   508,   509,   510,   511,
     191,   512,     0,   514,   515,   516,   517,   518,   519,   520,
     521,   522,   195,   523,   197,   524,   525,   526,   527,   528,
       0,   198,   530,   531,   532,     0,   534,   200,   535,   536,
     202,   537,   203,     0,   539,   540,   541,   542,   543,   544,
     545,   546,   205,   547,     0,   549,   550,   551,     0,   206,
     207,     0,   554,     0,   556,   208,   557,   209,     0,   559,
     560,   561,   562,     0,     0,   564,   565,   566,   567,   568,
       0,     0,   571,   572,   573,   216,   574,   217,   575,   576,
       0,     0,     0,   579,   580,   581,   582,   583,   584,     0,
     218,     0,     0,   219,     0,     0,     0,     0,     0,    79,
      80,    81,   338,     0,    83,    84,     0,    85,    86,    87,
     339,     0,   340,     0,    91,  2331,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   341,     0,   103,     0,
     104,   105,   106,   107,     0,     0,     0,   109,   110,   111,
       0,   112,     0,     0,     0,   342,   343,     0,     0,     0,
     600,   601,     0,     0,     0,     0,   602,     0,     0,     0,
       0,     0,     0,     0,     0,   603,     0,   604,     0,   605,
     606,     0,   344,   345,   346,   347,   348,   349,   350,     0,
     352,     0,     0,     0,     0,     0,     0,     0,   360,   361,
     362,   129,   363,   364,   365,   131,   132,   133,   134,     0,
       0,   367,   368,     0,   369,     0,     0,   372,   607,   135,
     373,     0,   375,   376,   377,   378,   139,     0,     0,   381,
     382,   383,     0,   385,   386,   142,   387,     0,   389,   390,
     145,     0,     0,     0,     0,   395,   396,   397,   398,   399,
     148,   149,   400,     0,   402,     0,   404,     0,   405,   406,
     407,     0,     0,     0,   411,   412,   413,   414,     0,   416,
     417,     0,   419,     0,   421,   422,   423,   156,   424,     0,
     158,     0,   426,   427,   160,     0,   429,     0,   431,   161,
       0,   162,   433,     0,   434,     0,     0,   437,     0,   439,
     440,   165,   441,   442,   443,   166,   444,   445,   446,   447,
       0,   167,   449,     0,   450,   451,   452,     0,   169,     0,
     170,     0,     0,   171,   172,   455,   173,   456,   457,   458,
     459,     0,   174,   461,   175,     0,   463,   464,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,   475,   476,
     180,   181,   691,   478,   479,   480,   481,   182,     0,   483,
     484,   184,     0,   185,   186,   486,     0,     0,   489,   692,
       0,   848,   493,   494,     0,     0,   497,   187,   188,     0,
     498,   499,   500,   501,   502,     0,   189,   503,   504,   505,
       0,   507,   508,   509,   510,   511,   191,   512,     0,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   195,   523,
     197,   524,   525,   526,   527,   528,     0,     0,   530,   531,
     532,     0,   534,   200,   535,   536,   202,   537,   203,     0,
     539,   540,   541,   542,   543,   544,   545,   546,   205,   547,
       0,   549,   550,   551,     0,   206,   207,     0,   554,     0,
     556,   208,   557,   209,     0,   559,   560,   561,   562,     0,
       0,   564,   565,   566,   567,   568,     0,     0,   571,   572,
     573,   216,   574,   217,   575,   576,     0,     0,     0,   579,
     580,   581,   582,   583,   584,     0,   218,     0,     0,   219,
       0,     0,     0,     0,     0,    79,    80,    81,   338,     0,
      83,    84,     0,    85,    86,    87,   339,     0,   340,     0,
      91,  2331,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   341,     0,   103,     0,   104,   105,   106,   107,
       0,     0,     0,   109,   110,   111,     0,   112,     0,     0,
       0,   342,   343,     0,     0,     0,   600,   601,     0,     0,
       0,     0,   602,     0,     0,     0,     0,     0,     0,     0,
       0,   603,     0,   604,     0,   605,   606,     0,   344,   345,
     346,   347,   348,   349,   350,     0,   352,     0,     0,     0,
       0,     0,     0,     0,   360,   361,   362,   129,   363,   364,
     365,   131,   132,   133,   134,     0,     0,   367,   368,     0,
     369,     0,     0,   372,   607,   135,   373,     0,   375,   376,
     377,   378,   139,     0,     0,   381,   382,   383,     0,   385,
     386,   142,   387,     0,   389,   390,   145,     0,     0,     0,
       0,   395,   396,   397,   398,   399,   148,   149,   400,     0,
     402,     0,   404,     0,   405,   406,   407,     0,     0,     0,
     411,   412,   413,   414,     0,   416,   417,     0,   419,     0,
     421,   422,   423,   156,   424,     0,   158,     0,   426,   427,
     160,     0,   429,     0,   431,   161,     0,   162,   433,     0,
     434,     0,     0,   437,     0,   439,   440,   165,   441,   442,
     443,   166,   444,   445,   446,   447,     0,   167,   449,     0,
     450,   451,   452,     0,   169,     0,   170,     0,     0,   171,
     172,   455,   173,   456,   457,   458,   459,     0,   174,   461,
     175,     0,   463,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   474,   475,   476,   180,   181,   691,   478,
     479,   480,   481,   182,     0,   483,   484,   184,     0,   185,
     186,   486,     0,     0,   489,   692,     0,     0,   493,   494,
       0,     0,   497,   187,   188,     0,   498,   499,   500,   501,
     502,     0,   189,   503,   504,   505,     0,   507,   508,   509,
     510,   511,   191,   512,     0,   514,   515,   516,   517,   518,
     519,   520,   521,   522,   195,   523,   197,   524,   525,   526,
     527,   528,     0,     0,   530,   531,   532,     0,   534,   200,
     535,   536,   202,   537,   203,     0,   539,   540,   541,   542,
     543,   544,   545,   546,   205,   547,     0,   549,   550,   551,
       0,   206,   207,     0,   554,     0,   556,   208,   557,   209,
       0,   559,   560,   561,   562,     0,     0,   564,   565,   566,
     567,   568,     0,     0,   571,   572,   573,   216,   574,   217,
     575,   576,     0,     0,     0,   579,   580,   581,   582,   583,
     584,     0,   218,     0,     0,   219,     0,     0,     0,     0,
       0,    79,    80,    81,   338,     0,    83,    84,     0,    85,
      86,    87,   339,     0,   340,     0,    91,  2812,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   341,     0,
     103,     0,   104,   105,   106,   107,     0,     0,     0,   109,
     110,   111,     0,   112,     0,     0,     0,   342,   343,     0,
       0,     0,   600,   601,     0,     0,     0,     0,   602,     0,
       0,     0,     0,     0,     0,     0,     0,   603,     0,   604,
       0,   605,   606,     0,   344,   345,   346,   347,   348,   349,
     350,     0,   352,     0,     0,     0,     0,     0,     0,     0,
     360,   361,   362,     0,   363,   364,   365,     0,   132,     0,
     134,     0,     0,   367,   368,     0,   369,     0,     0,   372,
     607,   135,   373,     0,   375,   376,   377,   378,   139,     0,
       0,   381,   382,   383,     0,   385,   386,   142,   387,     0,
     389,   390,     0,     0,     0,     0,     0,   395,   396,   397,
     398,   399,   148,   149,   400,     0,   402,     0,   404,     0,
     405,   406,   407,     0,     0,     0,   411,   412,   413,   414,
       0,   416,   417,     0,   419,     0,   421,   422,   423,   156,
     424,     0,   158,     0,   426,   427,   160,     0,   429,     0,
     431,     0,     0,     0,   433,     0,   434,     0,     0,   437,
       0,   439,   440,     0,   441,   442,   443,     0,   444,   445,
     446,   447,     0,     0,   449,     0,   450,   451,   452,     0,
     169,     0,   170,     0,     0,     0,     0,   455,     0,   456,
     457,   458,   459,     0,     0,   461,     0,     0,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,     0,   181,     0,   478,   479,   480,   481,   182,
       0,   483,   484,     0,     0,   185,   186,   486,     0,     0,
     489,     0,     0,     0,   493,   494,     0,     0,   497,     0,
       0,     0,   498,   499,   500,   501,   502,     0,   189,   503,
     504,   505,     0,   507,   508,   509,   510,   511,   191,   512,
       0,   514,   515,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   197,   524,   525,   526,   527,   528,     0,     0,
     530,   531,   532,     0,   534,   200,   535,   536,     0,   537,
     203,     0,   539,   540,   541,   542,   543,   544,   545,   546,
     205,   547,     0,   549,   550,   551,     0,   206,   207,     0,
     554,     0,   556,   208,   557,   209,     0,   559,   560,   561,
     562,     0,     0,   564,   565,   566,   567,   568,     0,     0,
     571,   572,   573,   216,   574,     0,   575,   576,     0,     0,
       0,   579,   580,   581,   582,   583,   584,     0,   218,    49,
       0,   219,   609,     0,     0,     0,     0,    52,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2130,  2131,    79,    80,    81,   338,     0,    83,
      84,     0,    85,    86,    87,   339,     0,   340,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   341,     0,   103,     0,   104,   105,   106,   107,     0,
       0,     0,   109,   110,   111,     0,   112,     0,     0,     0,
     342,   343,     0,     0,     0,   600,   601,     0,     0,     0,
       0,   602,     0,     0,     0,     0,     0,     0,     0,     0,
     603,     0,   604,     0,   605,   606,     0,   344,   345,   346,
     347,   348,   349,   350,     0,   352,     0,     0,     0,     0,
       0,     0,     0,   360,   361,   362,     0,   363,   364,   365,
       0,   132,     0,   134,     0,     0,   367,   368,     0,   369,
       0,     0,   372,   607,   135,   373,     0,   375,   376,   377,
     378,   139,     0,     0,   381,   382,   383,     0,   385,   386,
     142,   387,     0,   389,   390,     0,     0,     0,     0,     0,
     395,   396,   397,   398,   399,   148,   149,   400,     0,   402,
       0,   404,     0,   405,   406,   407,     0,     0,     0,   411,
     412,   413,   414,     0,   416,   417,     0,   419,     0,   421,
     422,   423,   156,   424,     0,   158,     0,   426,   427,   160,
       0,   429,     0,   431,     0,     0,     0,   433,     0,   434,
       0,     0,   437,     0,   439,   440,     0,   441,   442,   443,
       0,   444,   445,   446,   447,     0,     0,   449,     0,   450,
     451,   452,     0,   169,     0,   170,     0,     0,     0,     0,
     455,     0,   456,   457,   458,   459,     0,     0,   461,     0,
       0,   463,   464,   465,   466,   467,   468,   469,   470,   471,
     472,   473,   474,   475,   476,     0,   181,     0,   478,   479,
     480,   481,   182,     0,   483,   484,     0,     0,   185,   186,
     486,     0,     0,   489,     0,     0,     0,   493,   494,     0,
       0,   497,     0,     0,     0,   498,   499,   500,   501,   502,
       0,   189,   503,   504,   505,     0,   507,   508,   509,   510,
     511,   191,   512,     0,   514,   515,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   197,   524,   525,   526,   527,
     528,     0,     0,   530,   531,   532,     0,   534,   200,   535,
     536,     0,   537,   203,     0,   539,   540,   541,   542,   543,
     544,   545,   546,   205,   547,     0,   549,   550,   551,     0,
     206,   207,     0,   554,     0,   556,   208,   557,   209,     0,
     559,   560,   561,   562,     0,     0,   564,   565,   566,   567,
     568,     0,     0,   571,   572,   573,   216,   574,     0,   575,
     576,     0,     0,     0,   579,   580,   581,   582,   583,   584,
       0,   218,    49,     0,   219,   609,     0,     0,     0,     0,
      52,     0,    79,    80,    81,   338,     0,    83,    84,     0,
      85,    86,    87,   339,     0,   340,  2131,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   341,
       0,   103,     0,   104,   105,   106,   107,     0,     0,     0,
     109,   110,   111,     0,   112,     0,     0,     0,   342,   343,
       0,     0,     0,   600,   601,     0,     0,     0,     0,   602,
       0,     0,     0,     0,     0,     0,     0,     0,   603,     0,
     604,     0,   605,   606,     0,   344,   345,   346,   347,   348,
     349,   350,     0,   352,     0,     0,     0,     0,     0,     0,
       0,   360,   361,   362,     0,   363,   364,   365,     0,   132,
       0,   134,     0,     0,   367,   368,     0,   369,     0,     0,
     372,   607,   135,   373,     0,   375,   376,   377,   378,   139,
       0,     0,   381,   382,   383,     0,   385,   386,   142,   387,
       0,   389,   390,     0,     0,     0,     0,     0,   395,   396,
     397,   398,   399,   148,   149,   400,     0,   402,     0,   404,
       0,   405,   406,   407,     0,     0,     0,   411,   412,   413,
     414,     0,   416,   417,     0,   419,     0,   421,   422,   423,
     156,   424,     0,   158,     0,   426,   427,   160,     0,   429,
       0,   431,     0,     0,     0,   433,     0,   434,     0,     0,
     437,     0,   439,   440,     0,   441,   442,   443,     0,   444,
     445,   446,   447,     0,     0,   449,     0,   450,   451,   452,
       0,   169,     0,   170,     0,     0,     0,     0,   455,     0,
     456,   457,   458,   459,     0,     0,   461,     0,     0,   463,
     464,   465,   466,   467,   468,   469,   470,   471,   472,   473,
     474,   475,   476,     0,   181,   691,   478,   479,   480,   481,
     182,     0,   483,   484,     0,     0,   185,   186,   486,     0,
       0,   489,   692,     0,     0,   493,   494,     0,     0,   497,
       0,     0,     0,   498,   499,   500,   501,   502,     0,   189,
     503,   504,   505,     0,   507,   508,   509,   510,   511,   191,
     512,     0,   514,   515,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   197,   524,   525,   526,   527,   528,     0,
       0,   530,   531,   532,     0,   534,   200,   535,   536,     0,
     537,   203,     0,   539,   540,   541,   542,   543,   544,   545,
     546,   205,   547,     0,   549,   550,   551,     0,   206,   207,
       0,   554,     0,   556,   208,   557,   209,     0,   559,   560,
     561,   562,     0,     0,   564,   565,   566,   567,   568,     0,
       0,   571,   572,   573,   216,   574,     0,   575,   576,     0,
       0,     0,   579,   580,   581,   582,   583,   584,     0,   218,
       0,     0,   219,     0,     0,     0,     0,     0,    79,    80,
      81,   338,     0,    83,    84,     0,    85,    86,    87,   339,
       0,   340,     0,    91,  1206,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   341,     0,   103,     0,   104,
     105,   106,   107,     0,     0,     0,   109,   110,   111,     0,
     112,     0,     0,     0,   342,   343,     0,     0,     0,   600,
     601,     0,     0,     0,     0,   602,     0,     0,     0,     0,
       0,     0,     0,     0,   603,     0,   604,     0,   605,   606,
       0,   344,   345,   346,   347,   348,   349,   350,     0,   352,
       0,     0,     0,     0,     0,     0,     0,   360,   361,   362,
       0,   363,   364,   365,     0,   132,     0,   134,     0,     0,
     367,   368,     0,   369,     0,     0,   372,   607,   135,   373,
       0,   375,   376,   377,   378,   139,     0,     0,   381,   382,
     383,     0,   385,   386,   142,   387,     0,   389,   390,     0,
       0,     0,     0,     0,   395,   396,   397,   398,   399,   148,
     149,   400,     0,   402,     0,   404,     0,   405,   406,   407,
       0,     0,     0,   411,   412,   413,   414,     0,   416,   417,
       0,   419,     0,   421,   422,   423,   156,   424,     0,   158,
       0,   426,   427,   160,     0,   429,     0,   431,     0,     0,
       0,   433,     0,   434,     0,     0,   437,     0,   439,   440,
       0,   441,   442,   443,     0,   444,   445,   446,   447,     0,
       0,   449,     0,   450,   451,   452,     0,   169,     0,   170,
       0,     0,     0,     0,   455,     0,   456,   457,   458,   459,
       0,     0,   461,     0,     0,   463,   464,   465,   466,   467,
     468,   469,   470,   471,   472,   473,   474,   475,   476,     0,
     181,     0,   478,   479,   480,   481,   182,     0,   483,   484,
       0,     0,   185,   186,   486,     0,     0,   489,     0,     0,
       0,   493,   494,     0,     0,   497,     0,     0,     0,   498,
     499,   500,   501,   502,     0,   189,   503,   504,   505,     0,
     507,   508,   509,   510,   511,   191,   512,     0,   514,   515,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   197,
     524,   525,   526,   527,   528,     0,   198,   530,   531,   532,
       0,   534,   200,   535,   536,     0,   537,   203,     0,   539,
     540,   541,   542,   543,   544,   545,   546,   205,   547,     0,
     549,   550,   551,     0,   206,   207,     0,   554,     0,   556,
     208,   557,   209,     0,   559,   560,   561,   562,     0,     0,
     564,   565,   566,   567,   568,     0,     0,   571,   572,   573,
     216,   574,     0,   575,   576,     0,     0,     0,   579,   580,
     581,   582,   583,   584,     0,   218,     0,     0,   219,   609,
       0,     0,     0,     0,    79,    80,    81,   338,     0,    83,
      84,     0,    85,    86,    87,   339,     0,   340,     0,    91,
     220,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   341,     0,   103,     0,   104,   105,   106,   107,     0,
       0,     0,   109,   110,   111,     0,   112,     0,     0,     0,
     342,   343,     0,     0,     0,   600,   601,     0,     0,     0,
       0,   602,     0,     0,     0,     0,     0,     0,     0,     0,
     603,     0,   604,     0,   605,   606,     0,   344,   345,   346,
     347,   348,   349,   350,     0,   352,     0,     0,     0,     0,
       0,     0,     0,   360,   361,   362,     0,   363,   364,   365,
       0,   132,     0,   134,     0,     0,   367,   368,     0,   369,
       0,     0,   372,   607,   135,   373,     0,   375,   376,   377,
     378,   139,     0,     0,   381,   382,   383,     0,   385,   386,
     142,   387,     0,   389,   390,     0,     0,     0,     0,     0,
     395,   396,   397,   398,   399,   148,   149,   400,     0,   402,
       0,   404,     0,   405,   406,   407,     0,     0,     0,   411,
     412,   413,   414,     0,   416,   417,     0,   419,     0,   421,
     422,   423,   156,   424,     0,   158,     0,   426,   427,   160,
       0,   429,     0,   431,     0,     0,     0,   433,     0,   434,
       0,     0,   437,     0,   439,   440,     0,   441,   442,   443,
       0,   444,   445,   446,   447,     0,     0,   449,     0,   450,
     451,   452,     0,   169,     0,   170,     0,     0,     0,     0,
     455,     0,   456,   457,   458,   459,     0,     0,   461,     0,
       0,   463,   464,   465,   466,   467,   468,   469,   470,   471,
     472,   473,   474,   475,   476,     0,   181,     0,   478,   479,
     480,   481,   182,     0,   483,   484,     0,     0,   185,   186,
     486,     0,     0,   489,     0,     0,     0,   493,   494,     0,
       0,   497,     0,     0,     0,   498,   499,   500,   501,   502,
       0,   189,   503,   504,   505,     0,   507,   508,   509,   510,
     511,   191,   512,     0,   514,   515,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   197,   524,   525,   526,   527,
     528,     0,   198,   530,   531,   532,     0,   534,   200,   535,
     536,     0,   537,   203,     0,   539,   540,   541,   542,   543,
     544,   545,   546,   205,   547,     0,   549,   550,   551,     0,
     206,   207,     0,   554,     0,   556,   208,   557,   209,     0,
     559,   560,   561,   562,     0,     0,   564,   565,   566,   567,
     568,     0,     0,   571,   572,   573,   216,   574,     0,   575,
     576,     0,     0,     0,   579,   580,   581,   582,   583,   584,
       0,   218,     0,     0,   219,     0,     0,     0,     0,     0,
      79,    80,    81,   338,     0,    83,    84,     0,    85,    86,
      87,   339,     0,   340,     0,    91,   220,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   341,     0,   103,
       0,   104,   105,   106,   107,     0,     0,     0,   109,   110,
     111,     0,   112,     0,     0,     0,   342,   343,     0,     0,
       0,   600,   601,     0,     0,     0,     0,   602,     0,     0,
       0,     0,     0,     0,     0,     0,   603,     0,   604,     0,
     605,   606,     0,   344,   345,   346,   347,   348,   349,   350,
       0,   352,     0,     0,     0,     0,     0,     0,     0,   360,
     361,   362,     0,   363,   364,   365,     0,   132,     0,   134,
       0,     0,   367,   368,     0,   369,     0,     0,   372,   607,
     135,   373,     0,   375,   376,   377,   378,   139,     0,     0,
     381,   382,   383,     0,   385,   386,   142,   387,     0,   389,
     390,     0,     0,     0,     0,     0,   395,   396,   397,   398,
     399,   148,   149,   400,     0,   402,     0,   404,     0,   405,
     406,   407,     0,     0,     0,   411,   412,   413,   414,     0,
     416,   417,     0,   419,     0,   421,   422,   423,   156,   424,
       0,   158,     0,   426,   427,   160,     0,   429,     0,   431,
       0,     0,     0,   433,     0,   434,     0,     0,   437,     0,
     439,   440,     0,   441,   442,   443,     0,   444,   445,   446,
     447,     0,     0,   449,     0,   450,   451,   452,     0,   169,
       0,   170,     0,     0,     0,     0,   455,     0,   456,   457,
     458,   459,     0,     0,   461,     0,     0,   463,   464,   465,
     466,   467,   468,   469,   470,   471,   472,   473,   474,   475,
     476,     0,   181,     0,   478,   479,   480,   481,   182,     0,
     483,   484,     0,     0,   185,   186,   486,     0,     0,   489,
       0,     0,     0,   493,   494,     0,     0,   497,     0,     0,
       0,   498,   499,   500,   501,   502,     0,   189,   503,   504,
     505,     0,   507,   508,   509,   510,   511,   191,   512,     0,
     514,   515,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   197,   524,   525,   526,   527,   528,     0,     0,   530,
     531,   532,     0,   534,   200,   535,   536,     0,   537,   203,
       0,   539,   540,   541,   542,   543,   544,   545,   546,   205,
     547,     0,   549,   550,   551,     0,   206,   207,     0,   554,
       0,   556,   208,   557,   209,     0,   559,   560,   561,   562,
       0,     0,   564,   565,   566,   567,   568,     0,     0,   571,
     572,   573,   216,   574,     0,   575,   576,     0,     0,     0,
     579,   580,   581,   582,   583,   584,     0,   218,     0,     0,
     219,     0,     0,     0,     0,     0,    79,    80,    81,   338,
       0,    83,    84,     0,    85,    86,    87,   339,     0,   340,
       0,    91,  1616,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   341,     0,   103,     0,   104,   105,   106,
     107,     0,     0,     0,   109,   110,   111,     0,   112,     0,
       0,     0,   342,   343,     0,     0,     0,   600,   601,     0,
       0,     0,     0,   602,     0,     0,     0,     0,     0,     0,
       0,     0,   603,     0,   604,     0,   605,   606,     0,   344,
     345,   346,   347,   348,   349,   350,     0,   352,     0,     0,
       0,     0,     0,     0,     0,   360,   361,   362,     0,   363,
     364,   365,     0,   132,     0,   134,     0,     0,   367,   368,
       0,   369,     0,     0,   372,   607,   135,   373,     0,   375,
     376,   377,   378,   139,     0,     0,   381,   382,   383,     0,
     385,   386,   142,   387,     0,   389,   390,     0,     0,     0,
       0,     0,   395,   396,   397,   398,   399,   148,   149,   400,
       0,   402,     0,   404,     0,   405,   406,   407,     0,     0,
       0,   411,   412,   413,   414,     0,   416,   417,     0,   419,
       0,   421,   422,   423,   156,   424,     0,   158,     0,   426,
     427,   160,     0,   429,     0,   431,     0,     0,     0,   433,
       0,   434,     0,     0,   437,     0,   439,   440,     0,   441,
     442,   443,     0,   444,   445,   446,   447,     0,     0,   449,
       0,   450,   451,   452,     0,   169,     0,   170,     0,     0,
       0,     0,   455,     0,   456,   457,   458,   459,     0,     0,
     461,     0,     0,   463,   464,   465,   466,   467,   468,   469,
     470,   471,   472,   473,   474,   475,   476,     0,   181,     0,
     478,   479,   480,   481,   182,     0,   483,   484,     0,     0,
     185,   186,   486,     0,     0,   489,     0,     0,     0,   493,
     494,     0,     0,   497,     0,     0,     0,   498,   499,   500,
     501,   502,     0,   189,   503,   504,   505,     0,   507,   508,
     509,   510,   511,   191,   512,     0,   514,   515,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   197,   524,   525,
     526,   527,   528,     0,     0,   530,   531,   532,     0,   534,
     200,   535,   536,     0,   537,   203,     0,   539,   540,   541,
     542,   543,   544,   545,   546,   205,   547,     0,   549,   550,
     551,     0,   206,   207,     0,   554,     0,   556,   208,   557,
     209,     0,   559,   560,   561,   562,     0,     0,   564,   565,
     566,   567,   568,     0,     0,   571,   572,   573,   216,   574,
       0,   575,   576,     0,     0,     0,   579,   580,   581,   582,
     583,   584,     0,   218,     0,     0,   219,     0,     0,     0,
       0,   639,    79,    80,    81,   338,     0,    83,    84,     0,
      85,    86,    87,   339,     0,   340,     0,    91,  2759,    93,
      94,    95,    96,    97,    98,   640,    99,   100,   101,   341,
     641,   103,     0,   104,   105,   106,   107,   642,   643,     0,
     109,   110,   111,     0,   112,   644,   645,     0,   342,   343,
       0,     0,     0,   600,   601,     0,     0,     0,     0,   602,
       0,     0,     0,     0,     0,     0,     0,     0,   603,     0,
     604,     0,   605,   606,     0,   344,   345,   346,   347,   348,
     349,   350,     0,   352,     0,     0,     0,     0,     0,     0,
       0,   360,   361,   362,     0,   363,   364,   365,     0,  1335,
       0,  1336,  1081,     0,   367,   368,     0,   369,     0,     0,
     372,  1337,  1338,   373,     0,   375,   376,   377,   378,     0,
       0,     0,   381,   382,   383,     0,   385,   386,     0,   387,
       0,   389,   390,     0,     0,     0,     0,     0,   395,   396,
     397,   398,   399,  1339,  1340,   400,     0,   402,     0,   404,
       0,   405,   406,   407,     0,     0,     0,   411,  1094,   413,
     414,     0,   416,   417,     0,   419,     0,   421,   422,   423,
       0,   424,     0,     0,     0,   426,   427,  1341,     0,   429,
       0,   431,     0,     0,     0,   433,     0,   434,     0,     0,
     437,     0,   439,   440,     0,   441,   442,   443,     0,   444,
     445,   446,   447,     0,     0,   449,     0,   450,   451,   452,
    1099,  1342,     0,  1343,     0,     0,     0,     0,   455,     0,
     456,   457,   458,   459,     0,     0,   461,     0,     0,   463,
     464,   465,   466,   467,   468,   469,   470,   471,   472,   473,
     474,   475,  1102,     0,  1344,     0,   478,   479,   480,   481,
       0,     0,   483,   484,     0,     0,     0,  1345,   486,     0,
       0,   489,     0,     0,     0,  2407,   494,     0,     0,   497,
       0,     0,     0,   498,   499,   500,   501,   502,     0,     0,
     503,   504,   505,     0,   507,   508,   509,   510,   511,  1346,
     512,     0,   514,   515,   516,   517,   518,   519,   520,   521,
     522,     0,   523,     0,   524,   525,   526,   527,   528,     0,
       0,   530,   531,   532,     0,   534,  1347,   535,   536,     0,
     537,  1348,     0,   539,   540,   541,   542,   543,   544,   545,
     546,     0,   547,     0,   549,   550,   551,     0,  1349,  1350,
       0,   554,     0,   556,     0,   557,     0,     0,   559,   560,
     561,   562,     0,     0,   564,   565,   566,   567,   568,     0,
       0,   571,   572,   573,  1351,   574,     0,   575,   576,     0,
       0,     0,   579,   580,   581,   582,   583,   584,     0,   218,
      49,   994,   219,   609,     0,     0,     0,     0,    52,     0,
      53,   995,   996,   997,     0,   998,  2408,  1000,  1001,  1002,
    1003,    79,    80,    81,   338,     0,    83,    84,     0,    85,
      86,    87,   339,     0,   340,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   341,     0,
     103,     0,   104,   105,   106,   107,     0,     0,     0,   109,
     110,   111,     0,   112,     0,     0,     0,   342,   343,     0,
       0,     0,   600,   601,     0,     0,     0,     0,   602,     0,
       0,     0,     0,     0,     0,     0,     0,   603,     0,   604,
       0,   605,   606,     0,   344,   345,   346,   347,   348,   349,
     350,     0,   352,     0,     0,     0,     0,     0,     0,     0,
     360,   361,   362,     0,   363,   364,   365,     0,   132,     0,
     134,     0,     0,   367,   368,     0,   369,     0,     0,   372,
     607,   135,   373,     0,   375,   376,   377,   378,   139,     0,
       0,   381,   382,   383,     0,   385,   386,   142,   387,     0,
     389,   390,     0,     0,     0,     0,     0,   395,   396,   397,
     398,   399,   148,   149,   400,     0,   402,     0,   404,     0,
     405,   406,   407,     0,     0,     0,   411,   412,   413,   414,
       0,   416,   417,     0,   419,     0,   421,   422,   423,   156,
     424,     0,   158,     0,   426,   427,   160,     0,   429,     0,
     431,     0,     0,     0,   433,     0,   434,     0,     0,   437,
       0,   439,   440,     0,   441,   442,   443,     0,   444,   445,
     446,   447,     0,     0,   449,     0,   450,   451,   452,     0,
     169,     0,   170,     0,     0,     0,     0,   455,     0,   456,
     457,   458,   459,     0,     0,   461,     0,     0,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,     0,   181,     0,   478,   479,   480,   481,   182,
       0,   483,   484,     0,     0,   185,   186,   486,     0,     0,
     489,     0,     0,     0,   493,   494,     0,     0,   497,     0,
       0,     0,   498,   499,   500,   501,   502,     0,   189,   503,
     504,   505,     0,   507,   508,   509,   510,   511,   191,   512,
       0,   514,   515,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   197,   524,   525,   526,   527,   528,     0,     0,
     530,   531,   532,     0,   534,   200,   535,   536,     0,   537,
     203,     0,   539,   540,   541,   542,   543,   544,   545,   546,
     205,   547,     0,   549,   550,   551,     0,   206,   207,     0,
     554,     0,   556,   208,   557,   209,     0,   559,   560,   561,
     562,     0,     0,   564,   565,   566,   567,   568,     0,     0,
     571,   572,   573,   216,   574,     0,   575,   576,     0,     0,
       0,   579,   580,   581,   582,   583,   584,     0,   218,     0,
     994,   219,     0,     0,     0,     0,     0,     0,     0,     0,
     995,   996,   997,     0,   998,   999,  1000,  1001,  1002,  1003,
     639,    79,    80,    81,   338,     0,    83,    84,     0,    85,
      86,    87,   339,     0,   340,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   640,    99,   100,   101,   341,   641,
     103,     0,   104,   105,   106,   107,   642,   643,     0,   109,
     110,   111,     0,   112,   644,   645,     0,   342,   343,     0,
       0,     0,   600,   601,     0,     0,     0,     0,   602,     0,
       0,     0,     0,     0,     0,     0,     0,   603,     0,   604,
       0,   605,   606,     0,   344,   345,   346,   347,   348,   349,
     350,     0,   352,     0,     0,     0,     0,     0,     0,     0,
     360,   361,   362,     0,   363,   364,   365,     0,  1335,     0,
    1336,  1081,     0,   367,   368,     0,   369,     0,     0,   372,
    1337,  1338,   373,     0,   375,   376,   377,   378,     0,     0,
       0,   381,   382,   383,     0,   385,   386,     0,   387,     0,
     389,   390,     0,     0,     0,     0,     0,   395,   396,   397,
     398,   399,  1339,  1340,   400,     0,   402,     0,   404,     0,
     405,   406,   407,     0,     0,     0,   411,  1094,   413,   414,
       0,   416,   417,     0,   419,     0,   421,   422,   423,     0,
     424,     0,     0,     0,   426,   427,  1341,     0,   429,     0,
     431,     0,     0,     0,   433,     0,   434,     0,     0,   437,
       0,   439,   440,     0,   441,   442,   443,     0,   444,   445,
     446,   447,     0,     0,   449,     0,   450,   451,   452,  1099,
    1342,     0,  1343,     0,     0,     0,     0,   455,     0,   456,
     457,   458,   459,     0,     0,   461,     0,     0,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,  1102,     0,  1344,     0,   478,   479,   480,   481,     0,
       0,   483,   484,     0,     0,     0,  1345,   486,     0,     0,
     489,     0,     0,     0,   493,   494,     0,     0,   497,     0,
       0,     0,   498,   499,   500,   501,   502,     0,     0,   503,
     504,   505,     0,   507,   508,   509,   510,   511,  1346,   512,
       0,   514,   515,   516,   517,   518,   519,   520,   521,   522,
       0,   523,     0,   524,   525,   526,   527,   528,     0,     0,
     530,   531,   532,     0,   534,  1347,   535,   536,     0,   537,
    1348,     0,   539,   540,   541,   542,   543,   544,   545,   546,
       0,   547,     0,   549,   550,   551,     0,  1349,  1350,     0,
     554,     0,   556,     0,   557,     0,     0,   559,   560,   561,
     562,     0,     0,   564,   565,   566,   567,   568,     0,     0,
     571,   572,   573,  1351,   574,     0,   575,   576,     0,     0,
       0,   579,   580,   581,   582,   583,   584,     0,   218,     0,
       0,   219,    79,    80,    81,   338,     0,    83,    84,     0,
      85,    86,    87,   339,     0,   340,  1685,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   341,
       0,   103,     0,   104,   105,   106,   107,     0,     0,     0,
     109,   110,   111,     0,   112,     0,     0,     0,   342,   343,
       0,     0,     0,   600,   601,     0,     0,     0,     0,   602,
       0,     0,     0,     0,     0,     0,     0,     0,   603,     0,
     604,     0,   605,   606,     0,   344,   345,   346,   347,   348,
     349,   350,     0,   352,     0,     0,     0,     0,     0,     0,
       0,   360,   361,   362,     0,   363,   364,   365,     0,   132,
       0,   134,     0,     0,   367,   368,     0,   369,     0,     0,
     372,   607,   135,   373,     0,   375,   376,   377,   378,   139,
       0,     0,   381,   382,   383,     0,   385,   386,   142,   387,
       0,   389,   390,     0,     0,     0,     0,     0,   395,   396,
     397,   398,   399,   148,   149,   400,     0,   402,     0,   404,
       0,   405,   406,   407,     0,     0,     0,   411,   412,   413,
     414,     0,   416,   417,     0,   419,     0,   421,   422,   423,
     156,   424,     0,   158,     0,   426,   427,   160,     0,   429,
       0,   431,     0,     0,     0,   433,     0,   434,     0,     0,
     437,     0,   439,   440,     0,   441,   442,   443,     0,   444,
     445,   446,   447,     0,     0,   449,     0,   450,   451,   452,
       0,   169,     0,   170,     0,     0,     0,     0,   455,     0,
     456,   457,   458,   459,     0,     0,   461,     0,     0,   463,
     464,   465,   466,   467,   468,   469,   470,   471,   472,   473,
     474,   475,   476,     0,   181,   691,   478,   479,   480,   481,
     182,     0,   483,   484,     0,     0,   185,   186,   486,     0,
       0,   489,   692,     0,     0,   493,   494,     0,     0,   497,
       0,     0,     0,   498,   499,   500,   501,   502,     0,   189,
     503,   504,   505,     0,   507,   508,   509,   510,   511,   191,
     512,     0,   514,   515,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   197,   524,   525,   526,   527,   528,     0,
       0,   530,   531,   532,     0,   534,   200,   535,   536,     0,
     537,   203,     0,   539,   540,   541,   542,   543,   544,   545,
     546,   205,   547,     0,   549,   550,   551,     0,   206,   207,
       0,   554,     0,   556,   208,   557,   209,     0,   559,   560,
     561,   562,     0,     0,   564,   565,   566,   567,   568,     0,
       0,   571,   572,   573,   216,   574,     0,   575,   576,     0,
       0,     0,   579,   580,   581,   582,   583,   584,     0,   218,
       0,     0,   219,    79,    80,    81,   338,     0,    83,    84,
       0,    85,    86,    87,   339,     0,   340,   846,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     341,     0,   103,     0,   104,   105,   106,   107,     0,     0,
       0,   109,   110,   111,     0,   112,     0,     0,     0,   342,
     343,     0,     0,     0,   600,   601,     0,     0,     0,     0,
     602,     0,     0,     0,     0,     0,     0,     0,     0,   603,
       0,   604,     0,   605,   606,     0,   344,   345,   346,   347,
     348,   349,   350,     0,   352,     0,     0,     0,     0,     0,
       0,     0,   360,   361,   362,     0,   363,   364,   365,     0,
     132,     0,   134,     0,     0,   367,   368,     0,   369,     0,
       0,   372,   607,   135,   373,     0,   375,   376,   377,   378,
     139,     0,     0,   381,   382,   383,     0,   385,   386,   142,
     387,     0,   389,   390,     0,     0,     0,     0,     0,   395,
     396,   397,   398,   399,   148,   149,   400,     0,   402,     0,
     404,     0,   405,   406,   407,     0,     0,     0,   411,   412,
     413,   414,     0,   416,   417,     0,   419,     0,   421,   422,
     423,   156,   424,     0,   158,     0,   426,   427,   160,     0,
     429,     0,   431,     0,     0,     0,   433,     0,   434,     0,
       0,   437,     0,   439,   440,     0,   441,   442,   443,     0,
     444,   445,   446,   447,     0,     0,   449,     0,   450,   451,
     452,     0,   169,     0,   170,     0,     0,     0,     0,   455,
       0,   456,   457,   458,   459,     0,     0,   461,     0,     0,
     463,   464,   465,   466,   467,   468,   469,   470,   471,   472,
     473,   474,   475,   476,     0,   181,     0,   478,   479,   480,
     481,   182,     0,   483,   484,     0,     0,   185,   186,   486,
       0,     0,   489,     0,     0,     0,   493,   494,     0,     0,
     497,     0,     0,     0,   498,   499,   500,   501,   502,     0,
     189,   503,   504,   505,     0,   507,   508,   509,   510,   511,
     191,   512,     0,   514,   515,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   197,   524,   525,   526,   527,   528,
       0,     0,   530,   531,   532,     0,   534,   200,   535,   536,
       0,   537,   203,     0,   539,   540,   541,   542,   543,   544,
     545,   546,   205,   547,     0,   549,   550,   551,     0,   206,
     207,     0,   554,     0,   556,   208,   557,   209,     0,   559,
     560,   561,   562,     0,     0,   564,   565,   566,   567,   568,
       0,     0,   571,   572,   573,   216,   574,     0,   575,   576,
       0,     0,     0,   579,   580,   581,   582,   583,   584,     0,
     218,     0,     0,   219,    79,    80,    81,   338,     0,    83,
      84,     0,    85,    86,    87,   339,     0,   340,  1320,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   341,     0,   103,     0,   104,   105,   106,   107,     0,
       0,     0,   109,   110,   111,     0,   112,     0,     0,     0,
     342,   343,     0,     0,     0,   600,   601,     0,     0,     0,
       0,   602,     0,     0,     0,     0,     0,     0,     0,     0,
     603,     0,   604,     0,   605,   606,     0,   344,   345,   346,
     347,   348,   349,   350,     0,   352,     0,     0,     0,     0,
       0,     0,     0,   360,   361,   362,     0,   363,   364,   365,
       0,   132,     0,   134,     0,     0,   367,   368,     0,   369,
       0,     0,   372,   607,   135,   373,     0,   375,   376,   377,
     378,   139,     0,     0,   381,   382,   383,     0,   385,   386,
     142,   387,     0,   389,   390,     0,     0,     0,     0,     0,
     395,   396,   397,   398,   399,   148,   149,   400,  1601,   402,
       0,   404,     0,   405,   406,   407,     0,     0,     0,   411,
     412,   413,   414,     0,   416,   417,     0,   419,     0,   421,
     422,   423,   156,   424,     0,   158,  1602,   426,   427,   160,
       0,   429,     0,   431,     0,     0,     0,   433,     0,   434,
       0,     0,   437,     0,   439,   440,     0,   441,   442,   443,
       0,   444,   445,   446,   447,     0,     0,   449,     0,   450,
     451,   452,     0,   169,     0,   170,     0,     0,     0,     0,
     455,     0,   456,   457,   458,   459,     0,     0,   461,     0,
       0,   463,   464,   465,   466,   467,   468,   469,   470,   471,
     472,   473,   474,   475,   476,     0,   181,     0,   478,   479,
     480,   481,   182,     0,   483,   484,     0,     0,   185,   186,
     486,  1603,     0,   489,     0,  1604,     0,   493,   494,     0,
       0,   497,     0,     0,     0,   498,   499,   500,   501,   502,
       0,   189,   503,   504,   505,     0,   507,   508,   509,   510,
     511,   191,   512,     0,   514,   515,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   197,   524,   525,   526,   527,
     528,     0,     0,   530,   531,   532,     0,   534,   200,   535,
     536,     0,   537,   203,     0,   539,   540,   541,   542,   543,
     544,   545,   546,   205,   547,     0,   549,   550,   551,     0,
     206,   207,     0,   554,     0,   556,   208,   557,   209,  1605,
     559,   560,   561,   562,     0,     0,   564,   565,   566,   567,
     568,     0,     0,   571,   572,   573,   216,   574,     0,   575,
     576,     0,     0,     0,   579,   580,   581,   582,   583,   584,
       0,   218,    49,     0,   219,   609,     0,     0,     0,     0,
      52,     0,    53,     0,    79,    80,    81,   338,  1241,    83,
      84,     0,    85,    86,    87,   339,     0,   340,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   341,     0,   103,     0,   104,   105,   106,   107,     0,
       0,     0,   109,   110,   111,     0,   112,     0,     0,     0,
     342,   343,     0,     0,     0,   600,   601,     0,     0,     0,
       0,   602,     0,     0,     0,     0,     0,     0,     0,     0,
     603,     0,   604,     0,   605,   606,     0,   344,   345,   346,
     347,   348,   349,   350,     0,   352,     0,     0,     0,     0,
       0,     0,     0,   360,   361,   362,     0,   363,   364,   365,
       0,   132,     0,   134,     0,     0,   367,   368,     0,   369,
       0,     0,   372,   607,   135,   373,     0,   375,   376,   377,
     378,   139,     0,     0,   381,   382,   383,     0,   385,   386,
     142,   387,     0,   389,   390,     0,     0,     0,     0,     0,
     395,   396,   397,   398,   399,   148,   149,   400,     0,   402,
       0,   404,     0,   405,   406,   407,     0,     0,     0,   411,
     412,   413,   414,     0,   416,   417,     0,   419,     0,   421,
     422,   423,   156,   424,     0,   158,  1602,   426,   427,   160,
       0,   429,     0,   431,     0,     0,     0,   433,     0,   434,
       0,     0,   437,     0,   439,   440,     0,   441,   442,   443,
       0,   444,   445,   446,   447,     0,     0,   449,     0,   450,
     451,   452,     0,   169,     0,   170,     0,     0,     0,     0,
     455,     0,   456,   457,   458,   459,     0,     0,   461,     0,
       0,   463,   464,   465,   466,   467,   468,   469,   470,   471,
     472,   473,   474,   475,   476,     0,   181,     0,   478,   479,
     480,   481,   182,     0,   483,   484,     0,     0,   185,   186,
     486,  1603,     0,   489,     0,  1604,     0,   493,   494,     0,
       0,   497,     0,     0,     0,   498,   499,   500,   501,   502,
       0,   189,   503,   504,   505,     0,   507,   508,   509,   510,
     511,   191,   512,     0,   514,   515,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   197,   524,   525,   526,   527,
     528,     0,     0,   530,   531,   532,     0,   534,   200,   535,
     536,     0,   537,   203,     0,   539,   540,   541,   542,   543,
     544,   545,   546,   205,   547,     0,   549,   550,   551,     0,
     206,   207,     0,   554,     0,   556,   208,   557,   209,  1605,
     559,   560,   561,   562,     0,     0,   564,   565,   566,   567,
     568,     0,     0,   571,   572,   573,   216,   574,     0,   575,
     576,     0,     0,     0,   579,   580,   581,   582,   583,   584,
       0,   218,    49,     0,   219,   609,     0,     0,     0,     0,
      52,     0,    53,     0,    79,    80,    81,   338,  1241,    83,
      84,     0,    85,    86,    87,   339,     0,   340,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   341,     0,   103,     0,   104,   105,   106,   107,     0,
       0,     0,   109,   110,   111,     0,   112,     0,     0,     0,
     342,   343,     0,     0,     0,   600,   601,     0,     0,     0,
       0,   602,     0,     0,     0,     0,     0,     0,     0,     0,
     603,     0,   604,     0,   605,   606,     0,   344,   764,   346,
     347,   348,   349,   350,   765,   352,     0,     0,     0,     0,
       0,     0,     0,   360,   361,   362,     0,   766,   364,   365,
       0,   132,     0,   134,     0,     0,   367,   368,     0,   369,
       0,     0,   372,   607,   135,   373,     0,   375,   376,   377,
     378,   139,     0,     0,   381,   382,   383,     0,   385,   386,
     142,   387,     0,   389,   390,     0,     0,     0,     0,     0,
     395,   396,   397,   398,   399,   148,   149,   400,     0,   402,
       0,   404,     0,   405,   406,   407,     0,     0,     0,   411,
     412,   413,   414,     0,   416,   417,     0,   419,     0,   421,
     422,   423,   156,   424,     0,   158,     0,   426,   767,   160,
       0,   429,     0,   768,     0,   769,     0,   433,     0,   434,
       0,     0,   437,     0,   439,   440,     0,   441,   442,   443,
     770,   444,   445,   446,   447,     0,     0,   449,     0,   450,
     451,   452,     0,   169,     0,   170,     0,     0,     0,     0,
     455,     0,   456,   457,   458,   771,     0,     0,   461,     0,
       0,   463,   464,   465,   466,   467,   468,   469,   470,   471,
     472,   473,   474,   475,   476,     0,   181,     0,   772,   479,
     480,   481,   182,     0,   483,   484,     0,     0,   185,   186,
     486,     0,     0,   489,     0,     0,     0,   493,   494,     0,
       0,   497,     0,     0,     0,   498,   499,   500,   501,   502,
       0,   189,   503,   504,   505,     0,   773,   508,   509,   510,
     511,   191,   512,     0,   514,   774,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   197,   524,   525,   526,   527,
     528,     0,     0,   530,   531,   532,     0,   534,   200,   535,
     536,     0,   537,   203,     0,   539,   540,   541,   542,   543,
     544,   545,   546,   205,   547,     0,   549,   550,   551,     0,
     206,   207,     0,   554,     0,   556,   208,   557,   209,     0,
     559,   560,   561,   562,     0,     0,   564,   565,   566,   567,
     568,     0,     0,   571,   572,   573,   216,   574,     0,   575,
     576,     0,     0,     0,   579,   580,   581,   582,   583,   584,
       0,   218,     0,     0,   219,   609,    79,    80,    81,   338,
      52,    83,    84,     0,    85,    86,    87,   339,   775,   340,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   341,     0,   103,     0,   104,   105,   106,
     107,     0,     0,     0,   109,   110,   111,     0,   112,     0,
       0,     0,   342,   343,     0,     0,     0,   600,   601,     0,
       0,     0,     0,   602,     0,     0,     0,     0,     0,     0,
       0,     0,   603,     0,   604,     0,   605,   606,     0,   344,
     764,   346,   347,   348,   349,   350,   765,   352,     0,     0,
       0,     0,     0,     0,     0,   360,   361,   362,     0,   766,
     364,   365,     0,   132,     0,   134,     0,     0,   367,   368,
       0,   369,     0,     0,   372,   607,   135,   373,     0,   375,
     376,   377,   378,   139,     0,     0,   381,   382,   383,     0,
     385,   386,   142,   387,     0,   389,   390,     0,     0,     0,
       0,     0,   395,   396,   397,   398,   399,   148,   149,   400,
       0,   402,     0,   404,     0,   405,   406,   407,     0,     0,
       0,   411,   412,   413,   414,     0,   416,   417,     0,   419,
       0,   421,   422,   423,   156,   424,     0,   158,     0,   426,
     767,   160,     0,   429,     0,   768,     0,     0,     0,   433,
       0,   434,     0,     0,   437,     0,   439,   440,     0,   441,
     442,   443,     0,   444,   445,   446,   447,     0,     0,   449,
       0,   450,   451,   452,     0,   169,     0,   170,     0,     0,
       0,     0,   455,     0,   456,   457,   458,   771,     0,     0,
     461,     0,     0,   463,   464,   465,   466,   467,   468,   469,
     470,   471,   472,   473,   474,   475,   476,     0,   181,     0,
     772,   479,   480,   481,   182,     0,   483,   484,     0,     0,
     185,   186,   486,     0,     0,   489,     0,     0,     0,   493,
     494,     0,     0,   497,     0,     0,     0,   498,   499,   500,
     501,   502,     0,   189,   503,   504,   505,     0,   773,   508,
     509,   510,   511,   191,   512,     0,   514,   774,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   197,   524,   525,
     526,   527,   528,     0,     0,   530,   531,   532,     0,   534,
     200,   535,   536,     0,   537,   203,     0,   539,   540,   541,
     542,   543,   544,   545,   546,   205,   547,     0,   549,   550,
     551,     0,   206,   207,     0,   554,     0,   556,   208,   557,
     209,     0,   559,   560,   561,   562,     0,     0,   564,   565,
     566,   567,   568,     0,     0,   571,   572,   573,   216,   574,
       0,   575,   576,     0,     0,     0,   579,   580,   581,   582,
     583,   584,     0,   218,     0,     0,   219,   609,    79,    80,
      81,   338,    52,    83,    84,     0,    85,    86,    87,   339,
     775,   340,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   341,     0,   103,     0,   104,
     105,   106,   107,     0,     0,     0,   109,   110,   111,     0,
     112,     0,     0,     0,   342,   343,     0,     0,     0,   600,
     601,     0,     0,     0,     0,   602,     0,     0,     0,     0,
       0,     0,     0,     0,   603,     0,   604,     0,   605,   606,
       0,   344,   345,   346,   347,   348,   349,   350,     0,   352,
       0,     0,     0,     0,     0,     0,     0,   360,   361,   362,
       0,   363,   364,   365,     0,   132,     0,   134,     0,     0,
     367,   368,     0,   369,     0,     0,   372,   607,   135,   373,
       0,   375,   376,   377,   378,   139,     0,     0,   381,   382,
     383,     0,   385,   386,   142,   387,     0,   389,   390,     0,
       0,     0,     0,     0,   395,   396,   397,   398,   399,   148,
     149,   400,   630,   402,     0,   404,     0,   405,   406,   407,
       0,     0,     0,   411,   412,   413,   414,     0,   416,   417,
       0,   419,     0,   421,   422,   423,   156,   424,     0,   158,
       0,   426,   427,   160,     0,   429,     0,   431,     0,     0,
       0,   433,     0,   434,     0,     0,   437,     0,   439,   440,
       0,   441,   442,   443,     0,   444,   445,   446,   447,     0,
       0,   449,     0,   450,   451,   452,     0,   169,     0,   170,
       0,     0,     0,     0,   455,     0,   456,   457,   458,   459,
       0,     0,   461,     0,     0,   463,   464,   465,   466,   467,
     468,   469,   470,   471,   472,   473,   474,   475,   476,     0,
     181,     0,   478,   479,   480,   481,   182,     0,   483,   484,
       0,     0,   185,   186,   486,     0,     0,   489,     0,     0,
       0,   493,   494,     0,     0,   497,     0,     0,     0,   498,
     499,   500,   501,   502,     0,   189,   503,   504,   505,     0,
     507,   508,   509,   510,   511,   191,   512,     0,   514,   515,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   197,
     524,   525,   526,   527,   528,     0,     0,   530,   531,   532,
       0,   534,   200,   535,   536,     0,   537,   203,     0,   539,
     540,   541,   542,   543,   544,   545,   546,   205,   547,     0,
     549,   550,   551,     0,   206,   207,  1177,   554,     0,   556,
     208,   557,   209,     0,   559,   560,   561,   562,     0,     0,
     564,   565,   566,   567,   568,     0,     0,   571,   572,   573,
     216,   574,     0,   575,   576,     0,     0,     0,   579,   580,
     581,   582,   583,   584,     0,   218,    49,     0,   219,   609,
      79,    80,    81,   338,     0,    83,    84,  1178,    85,    86,
      87,   339,     0,   340,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   341,     0,   103,
       0,   104,   105,   106,   107,     0,     0,     0,   109,   110,
     111,     0,   112,     0,     0,     0,   342,   343,     0,     0,
       0,   600,   601,     0,     0,     0,     0,   602,     0,     0,
       0,     0,     0,     0,     0,     0,   603,     0,   604,     0,
     605,   606,     0,   344,   345,   346,   347,   348,   349,   350,
       0,   352,     0,     0,     0,     0,     0,     0,     0,   360,
     361,   362,     0,   363,   364,   365,     0,   132,     0,   134,
       0,     0,   367,   368,     0,   369,     0,     0,   372,   607,
     135,   373,     0,   375,   376,   377,   378,   139,     0,     0,
     381,   382,   383,     0,   385,   386,   142,   387,     0,   389,
     390,     0,     0,     0,     0,     0,   395,   396,   397,   398,
     399,   148,   149,   400,     0,   402,     0,   404,     0,   405,
     406,   407,     0,     0,     0,   411,   412,   413,   414,     0,
     416,   417,     0,   419,     0,   421,   422,   423,   156,   424,
       0,   158,     0,   426,   427,   160,     0,   429,     0,   431,
       0,     0,     0,   433,     0,   434,     0,     0,   437,     0,
     439,   440,     0,   441,   442,   443,     0,   444,   445,   446,
     447,     0,     0,   449,     0,   450,   451,   452,     0,   169,
       0,   170,     0,     0,     0,     0,   455,     0,   456,   457,
     458,   459,     0,     0,   461,     0,     0,   463,   464,   465,
     466,   467,   468,   469,   470,   471,   472,   473,   474,   475,
     476,     0,   181,     0,   478,   479,   480,   481,   182,     0,
     483,   484,     0,     0,   185,   186,   486,     0,     0,   489,
       0,     0,     0,   493,   494,     0,     0,   497,     0,     0,
       0,   498,   499,   500,   501,   502,     0,   189,   503,   504,
     505,     0,   507,   508,   509,   510,   511,   191,   512,     0,
     514,   515,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   197,   524,   525,   526,   527,   528,     0,     0,   530,
     531,   532,     0,   534,   200,   535,   536,     0,   537,   203,
       0,   539,   540,   541,   542,   543,   544,   545,   546,   205,
     547,     0,   549,   550,   551,     0,   206,   207,     0,   554,
       0,   556,   208,   557,   209,     0,   559,   560,   561,   562,
       0,     0,   564,   565,   566,   567,   568,     0,     0,   571,
     572,   573,   216,   574,     0,   575,   576,     0,     0,     0,
     579,   580,   581,   582,   583,   584,     0,   218,    49,     0,
     219,   609,     0,     0,  1125,  1126,    52,     0,    53,    79,
      80,    81,   338,     0,    83,    84,     0,    85,    86,    87,
     339,     0,   340,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   341,     0,   103,     0,
     104,   105,   106,   107,     0,     0,     0,   109,   110,   111,
       0,   112,     0,     0,     0,   342,   343,     0,     0,     0,
     600,   601,     0,     0,     0,     0,   602,     0,     0,     0,
       0,     0,     0,     0,     0,   603,     0,   604,     0,   605,
     606,     0,   344,   345,   346,   347,   348,   349,   350,     0,
     352,     0,     0,     0,     0,     0,     0,     0,   360,   361,
     362,     0,   363,   364,   365,     0,   132,     0,   134,     0,
       0,   367,   368,     0,   369,     0,     0,   372,   607,   135,
     373,     0,   375,   376,   377,   378,   139,     0,     0,   381,
     382,   383,     0,   385,   386,   142,   387,     0,   389,   390,
       0,     0,     0,     0,     0,   395,   396,   397,   398,   399,
     148,   149,   400,     0,   402,     0,   404,     0,   405,   406,
     407,     0,     0,     0,   411,   412,   413,   414,     0,   416,
     417,     0,   419,     0,   421,   422,   423,   156,   424,     0,
     158,     0,   426,   427,   160,     0,   429,     0,   431,     0,
       0,     0,   433,     0,   434,     0,     0,   437,     0,   439,
     440,     0,   441,   442,   443,     0,   444,   445,   446,   447,
       0,     0,   449,     0,   450,   451,   452,     0,   169,     0,
     170,     0,     0,     0,     0,   455,     0,   456,   457,   458,
     459,     0,     0,   461,     0,     0,   463,   464,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,   475,   476,
       0,   181,     0,   478,   479,   480,   481,   182,     0,   483,
     484,     0,     0,   185,   186,   486,     0,     0,   489,     0,
       0,     0,   493,   494,     0,     0,   497,     0,     0,     0,
     498,   499,   500,   501,   502,     0,   189,   503,   504,   505,
       0,   507,   508,   509,   510,   511,   191,   512,     0,   514,
     515,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     197,   524,   525,   526,   527,   528,     0,     0,   530,   531,
     532,     0,   534,   200,   535,   536,     0,   537,   203,     0,
     539,   540,   541,   542,   543,   544,   545,   546,   205,   547,
       0,   549,   550,   551,     0,   206,   207,     0,   554,     0,
     556,   208,   557,   209,     0,   559,   560,   561,   562,     0,
       0,   564,   565,   566,   567,   568,     0,     0,   571,   572,
     573,   216,   574,     0,   575,   576,     0,     0,     0,   579,
     580,   581,   582,   583,   584,     0,   218,     0,     0,   219,
       0,   827,  1259,    79,    80,    81,   338,   828,    83,    84,
       0,    85,    86,    87,   339,     0,   340,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     341,     0,   103,     0,   104,   105,   106,   107,     0,     0,
       0,   109,   110,   111,     0,   112,     0,     0,     0,   342,
     343,     0,     0,     0,   600,   601,     0,     0,     0,     0,
     602,     0,     0,     0,     0,     0,     0,     0,     0,   603,
       0,   604,     0,   605,   606,     0,   344,   345,   346,   347,
     348,   349,   350,     0,   352,     0,     0,     0,     0,     0,
       0,     0,   360,   361,   362,     0,   363,   364,   365,     0,
     132,     0,   134,     0,     0,   367,   368,     0,   369,     0,
       0,   372,   607,   135,   373,     0,   375,   376,   377,   378,
     139,     0,     0,   381,   382,   383,     0,   829,   386,   142,
     387,     0,   389,   390,     0,     0,     0,     0,     0,   395,
     396,   397,   398,   399,   148,   149,   400,     0,   402,     0,
     404,     0,   405,   406,   407,     0,     0,     0,   411,   412,
     413,   414,     0,   416,   417,     0,   419,     0,   421,   422,
     423,   156,   424,     0,   158,     0,   426,   427,   160,     0,
     429,     0,   431,     0,     0,     0,   433,     0,   434,     0,
       0,   437,     0,   439,   440,     0,   441,   442,   443,     0,
     444,   445,   446,   447,     0,     0,   449,     0,   450,   451,
     452,     0,   169,     0,   170,     0,     0,     0,     0,   455,
       0,   456,   457,   458,   459,     0,     0,   461,     0,     0,
     463,   464,   830,   466,   467,   468,   469,   470,   471,   472,
     473,   474,   831,   476,     0,   181,     0,   478,   479,   480,
     481,   182,     0,   483,   484,     0,     0,   185,   186,   486,
       0,     0,   489,     0,     0,     0,   493,   494,     0,     0,
     497,     0,     0,     0,   498,   499,   500,   501,   502,     0,
     189,   503,   504,   505,     0,   507,   508,   509,   510,   511,
     191,   512,     0,   514,   515,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   197,   524,   525,   526,   527,   528,
       0,     0,   530,   531,   832,     0,   534,   200,   535,   536,
       0,   537,   203,     0,   539,   540,   541,   542,   543,   544,
     545,   546,   205,   547,     0,   549,   550,   551,     0,   833,
     207,     0,   554,     0,   834,   208,   557,   209,     0,   559,
     560,   561,   562,     0,     0,   564,   565,   566,   567,   568,
       0,     0,   571,   572,   573,   216,   574,     0,   575,   576,
       0,     0,     0,   579,   580,   581,   582,   583,   584,     0,
     218,     0,     0,   219,   639,    79,    80,    81,   338,     0,
      83,    84,     0,    85,    86,    87,   339,     0,   340,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   640,    99,
     100,   101,   341,   641,   103,     0,   104,   105,   106,   107,
     642,   643,     0,   109,   110,   111,     0,   112,   644,   645,
       0,   342,   343,     0,     0,     0,   600,   601,     0,     0,
       0,     0,   602,     0,     0,     0,     0,     0,     0,     0,
       0,   603,     0,   604,     0,   605,   606,     0,   344,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   129,   363,   364,
     365,   131,   132,   133,   134,     0,   366,   367,   368,     0,
     369,   370,   371,   372,   646,   135,   373,   374,   375,   376,
     377,   378,   139,   379,   380,   381,   382,   383,   384,   385,
     386,   142,   387,   388,   389,   390,   145,   391,   392,   393,
     394,   395,   396,   397,   398,   399,   148,   149,   400,   401,
     402,   403,   404,     0,   405,   406,   407,   408,   409,   410,
     411,   412,   413,   414,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   156,   424,     0,   158,   425,   426,   427,
     160,   428,   429,   430,   431,   161,   432,   162,   433,     0,
     434,   435,   436,   437,   438,   439,   440,   165,   441,   442,
     443,   166,   444,   445,   446,   447,   448,   167,   449,   647,
     450,   451,   452,   648,   169,   453,   170,   454,     0,   171,
     172,   455,   173,   456,   457,   458,   459,   460,   174,   461,
     175,   462,   463,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   474,   475,   476,   180,   181,   477,   478,
     479,   480,   481,   182,   482,   483,   484,   184,   485,   185,
     186,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   187,   188,     0,   498,   499,   500,   501,
     502,     0,   189,   503,   504,   505,   506,   507,   508,   509,
     510,   511,   191,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,   522,   195,   523,   197,   524,   525,   526,
     527,   528,     0,   529,   530,   531,   532,   533,   534,   200,
     535,   536,   202,   537,   203,   538,   539,   540,   541,   542,
     543,   544,   545,   546,   205,   547,   548,   549,   550,   551,
     552,   206,   207,   553,   554,   555,   556,   208,   557,   209,
     558,   559,   560,   561,   562,   649,   563,   564,   565,   566,
     567,   568,   569,   570,   571,   572,   573,   216,   574,   217,
     575,   576,     0,   577,   578,   579,   580,   581,   582,   583,
     584,     0,   218,     0,     0,   219,    79,    80,    81,   338,
       0,    83,    84,   628,    85,    86,    87,   339,     0,   340,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   341,     0,   103,     0,   104,   105,   106,
     107,     0,     0,     0,   109,   110,   111,     0,   112,     0,
       0,     0,   342,   343,     0,     0,     0,   600,   601,     0,
       0,     0,     0,   602,     0,     0,     0,     0,     0,     0,
       0,     0,   603,     0,   604,     0,   605,   606,     0,   344,
     345,   346,   347,   348,   349,   350,   629,   352,     0,     0,
       0,     0,     0,     0,     0,   360,   361,   362,     0,   363,
     364,   365,     0,   132,     0,   134,     0,     0,   367,   368,
       0,   369,     0,     0,   372,   607,   135,   373,     0,   375,
     376,   377,   378,   139,     0,     0,   381,   382,   383,     0,
     385,   386,   142,   387,     0,   389,   390,     0,     0,     0,
       0,     0,   395,   396,   397,   398,   399,   148,   149,   400,
     630,   402,     0,   404,     0,   405,   406,   407,     0,     0,
       0,   411,   412,   413,   414,     0,   416,   417,     0,   419,
       0,   421,   422,   423,   156,   424,     0,   158,     0,   426,
     427,   160,     0,   429,     0,   431,     0,     0,     0,   433,
       0,   434,     0,     0,   437,     0,   439,   440,     0,   441,
     442,   443,     0,   444,   445,   446,   447,     0,     0,   449,
       0,   450,   451,   452,     0,   169,     0,   170,     0,     0,
       0,     0,   455,     0,   456,   457,   458,   459,     0,     0,
     461,     0,     0,   463,   464,   465,   466,   467,   468,   469,
     470,   471,   472,   473,   474,   475,   476,     0,   181,     0,
     478,   479,   480,   481,   182,     0,   483,   484,     0,     0,
     185,   186,   486,     0,     0,   489,     0,     0,     0,   493,
     494,     0,     0,   497,     0,     0,     0,   498,   499,   500,
     501,   502,     0,   189,   503,   504,   505,     0,   507,   508,
     509,   510,   511,   191,   512,     0,   514,   515,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   197,   524,   525,
     526,   527,   528,     0,     0,   530,   531,   532,     0,   534,
     200,   535,   536,     0,   537,   203,     0,   539,   540,   541,
     542,   543,   544,   545,   546,   205,   547,     0,   549,   550,
     551,     0,   206,   207,     0,   554,     0,   556,   208,   557,
     209,     0,   559,   560,   561,   562,     0,     0,   564,   565,
     566,   567,   568,     0,     0,   571,   572,   573,   216,   574,
       0,   575,   576,     0,     0,     0,   579,   580,   581,   582,
     583,   584,     0,   218,    49,     0,   219,   609,    79,    80,
      81,   338,     0,    83,    84,     0,    85,    86,    87,   339,
       0,   340,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   341,     0,   103,     0,   104,
     105,   106,   107,     0,     0,  1429,   109,   110,   111,     0,
     112,     0,     0,     0,   342,   343,     0,     0,     0,   600,
     601,     0,     0,     0,     0,   602,     0,     0,     0,     0,
       0,     0,     0,     0,   603,     0,   604,     0,   605,   606,
       0,   344,   345,   346,   347,   348,   349,   350,     0,   352,
       0,     0,     0,     0,     0,     0,     0,   360,   361,   362,
       0,   363,   364,   365,     0,   132,     0,   134,     0,     0,
     367,   368,     0,   369,     0,     0,   372,   607,   135,   373,
       0,   375,   376,   377,   378,   139,     0,     0,   381,   382,
     383,     0,   385,   386,   142,   387,     0,   389,   390,     0,
       0,     0,     0,     0,   395,   396,   397,   398,   399,   148,
     149,   400,     0,   402,     0,   404,     0,   405,   406,   407,
       0,     0,     0,   411,   412,   413,   414,     0,   416,   417,
       0,   419,     0,   421,   422,   423,   156,   424,     0,   158,
       0,   426,   427,   160,     0,   429,     0,   431,     0,     0,
       0,   433,     0,  1992,     0,     0,   437,     0,   439,   440,
       0,   441,   442,   443,     0,   444,   445,   446,   447,     0,
       0,   449,     0,   450,   451,   452,     0,   169,     0,   170,
       0,     0,     0,     0,   455,     0,   456,   457,   458,   459,
       0,     0,   461,     0,     0,   463,   464,  1993,   466,   467,
     468,   469,   470,   471,   472,   473,   474,   475,   476,     0,
     181,   691,   478,   479,   480,   481,   182,     0,   483,   484,
       0,     0,   185,   186,   486,     0,     0,   489,   692,     0,
       0,   493,   494,     0,     0,   497,     0,     0,     0,   498,
     499,   500,   501,   502,     0,   189,   503,   504,   505,     0,
     507,   508,   509,   510,   511,   191,   512,     0,   514,   515,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   197,
     524,   525,   526,   527,   528,     0,     0,   530,   531,   532,
       0,   534,   200,   535,   536,     0,   537,   203,     0,   539,
     540,   541,   542,   543,   544,   545,   546,   205,   547,  1994,
    1995,   550,  1996,     0,   206,   207,     0,   554,     0,   556,
     208,   557,   209,     0,   559,   560,   561,   562,     0,     0,
     564,   565,   566,   567,   568,     0,     0,   571,   572,   573,
     216,   574,     0,   575,   576,     0,     0,     0,   579,   580,
     581,   582,   583,   584,     0,   218,     0,     0,   219,   609,
      79,    80,    81,   338,     0,    83,    84,     0,    85,    86,
      87,   339,     0,   340,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   341,     0,   103,
       0,   104,   105,   106,   107,     0,     0,     0,   109,   110,
     111,     0,   112,     0,     0,     0,   342,   343,     0,     0,
       0,   600,   601,     0,     0,     0,     0,   602,     0,     0,
       0,     0,     0,     0,     0,     0,   603,     0,   604,     0,
     605,   606,     0,   344,   345,   346,   347,   348,   349,   350,
       0,   352,     0,     0,     0,     0,     0,     0,     0,   360,
     361,   362,     0,   363,   364,   365,     0,   132,     0,   134,
       0,     0,   367,   368,     0,   369,     0,     0,   372,   607,
     135,   373,     0,   375,   376,   377,   378,   139,     0,     0,
     381,   382,   383,     0,   385,   386,   142,   387,     0,   389,
     390,     0,     0,     0,     0,     0,   395,   396,   397,   398,
     399,   148,   149,   400,     0,   402,     0,   404,     0,   405,
     406,   407,     0,     0,     0,   411,   412,   413,   414,     0,
     416,   417,     0,   419,     0,   421,   422,   423,   156,   424,
       0,   158,     0,   426,   427,   160,     0,   429,     0,   431,
       0,     0,     0,   433,     0,   434,     0,     0,   437,     0,
     439,   440,     0,   441,   442,   443,     0,   444,   445,   446,
     447,     0,     0,   449,     0,   450,   451,   452,     0,   169,
       0,   170,     0,     0,     0,     0,   455,     0,   456,   457,
     458,   459,     0,     0,   461,     0,     0,   463,   464,   465,
     466,   467,   468,   469,   470,   471,   472,   473,   474,   475,
     476,     0,   181,     0,   478,   479,   480,   481,   182,     0,
     483,   484,     0,     0,   185,   186,   486,     0,     0,   489,
       0,     0,     0,   493,   494,     0,     0,   497,     0,     0,
       0,   498,   499,   500,   501,   502,     0,   189,   503,   504,
     505,     0,   507,   508,   509,   510,   511,   191,   512,     0,
     514,   515,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   197,   524,   525,   526,   527,   528,     0,     0,   530,
     531,   532,     0,   534,   200,   535,   536,     0,   537,   203,
       0,   539,   540,   541,   542,   543,   544,   545,   546,   205,
     547,     0,   549,   550,   551,     0,   206,   207,   608,   554,
       0,   556,   208,   557,   209,     0,   559,   560,   561,   562,
       0,     0,   564,   565,   566,   567,   568,     0,     0,   571,
     572,   573,   216,   574,     0,   575,   576,     0,     0,     0,
     579,   580,   581,   582,   583,   584,     0,   218,    49,     0,
     219,   609,    79,    80,    81,   338,     0,    83,    84,     0,
      85,    86,    87,   339,     0,   340,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   341,
       0,   103,     0,   104,   105,   106,   107,     0,     0,     0,
     109,   110,   111,     0,   112,     0,     0,     0,   342,   343,
       0,     0,     0,   600,   601,     0,     0,     0,     0,   602,
       0,     0,     0,     0,     0,     0,     0,     0,   603,     0,
     604,     0,   605,   606,     0,   344,   345,   346,   347,   348,
     349,   350,     0,   352,     0,     0,     0,     0,     0,     0,
       0,   360,   361,   362,     0,   363,   364,   365,     0,   132,
       0,   134,     0,     0,   367,   368,     0,   369,     0,     0,
     372,   607,   135,   373,     0,   375,   376,   377,   378,   139,
       0,     0,   381,   382,   383,     0,   385,   386,   142,   387,
       0,   389,   390,     0,     0,     0,     0,     0,   395,   396,
     397,   398,   399,   148,   149,   400,   900,   402,     0,   404,
       0,   405,   406,   407,     0,     0,     0,   411,   412,   413,
     414,     0,   416,   417,     0,   419,     0,   421,   422,   423,
     156,   424,     0,   158,     0,   426,   427,   160,     0,   429,
       0,   431,     0,     0,     0,   433,     0,   434,     0,     0,
     437,     0,   439,   440,     0,   441,   442,   443,     0,   444,
     445,   446,   447,     0,     0,   449,     0,   450,   451,   452,
       0,   169,     0,   170,     0,     0,     0,     0,   455,     0,
     456,   457,   458,   459,     0,     0,   461,     0,     0,   463,
     464,   465,   466,   467,   468,   469,   470,   471,   472,   473,
     474,   475,   476,     0,   181,     0,   478,   479,   480,   481,
     182,     0,   483,   484,     0,     0,   185,   186,   486,     0,
       0,   489,     0,     0,     0,   493,   494,     0,     0,   497,
       0,     0,     0,   498,   499,   500,   501,   502,     0,   189,
     503,   504,   505,     0,   507,   508,   509,   510,   511,   191,
     512,     0,   514,   515,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   197,   524,   525,   526,   527,   528,     0,
       0,   530,   531,   532,     0,   534,   200,   535,   536,     0,
     537,   203,     0,   539,   540,   541,   542,   543,   544,   545,
     546,   205,   547,     0,   549,   550,   551,     0,   206,   207,
       0,   554,     0,   556,   208,   557,   209,     0,   559,   560,
     561,   562,     0,     0,   564,   565,   566,   567,   568,     0,
       0,   571,   572,   573,   216,   574,     0,   575,   576,     0,
       0,     0,   579,   580,   581,   582,   583,   584,     0,   218,
      49,     0,   219,   609,    79,    80,    81,   338,     0,    83,
      84,     0,    85,    86,    87,   339,     0,   340,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   341,     0,   103,     0,   104,   105,   106,   107,     0,
       0,     0,   109,   110,   111,     0,   112,     0,     0,     0,
     342,   343,     0,     0,     0,   600,   601,     0,     0,     0,
       0,   602,     0,     0,     0,     0,     0,     0,     0,     0,
     603,     0,   604,     0,   605,   606,     0,   344,   345,   346,
     347,   348,   349,   350,     0,   352,     0,     0,     0,     0,
       0,     0,     0,   360,   361,   362,     0,   363,   364,   365,
       0,   132,     0,   134,     0,     0,   367,   368,     0,   369,
       0,     0,   372,   607,   135,   373,     0,   375,   376,   377,
     378,   139,     0,     0,   381,   382,   383,     0,   385,   386,
     142,   387,     0,   389,   390,     0,     0,     0,     0,     0,
     395,   396,   397,   398,   399,   148,   149,   400,   630,   402,
       0,   404,     0,   405,   406,   407,     0,     0,     0,   411,
     412,   413,   414,     0,   416,   417,     0,   419,     0,   421,
     422,   423,   156,   424,     0,   158,     0,   426,   427,   160,
       0,   429,     0,   431,     0,     0,     0,   433,     0,   434,
       0,     0,   437,     0,   439,   440,     0,   441,   442,   443,
       0,   444,   445,   446,   447,     0,     0,   449,     0,   450,
     451,   452,     0,   169,     0,   170,     0,     0,     0,     0,
     455,     0,   456,   457,   458,   459,     0,     0,   461,     0,
       0,   463,   464,   465,   466,   467,   468,   469,   470,   471,
     472,   473,   474,   475,   476,     0,   181,     0,   478,   479,
     480,   481,   182,     0,   483,   484,     0,     0,   185,   186,
     486,     0,     0,   489,     0,     0,     0,   493,   494,     0,
       0,   497,     0,     0,     0,   498,   499,   500,   501,   502,
       0,   189,   503,   504,   505,     0,   507,   508,   509,   510,
     511,   191,   512,     0,   514,   515,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   197,   524,   525,   526,   527,
     528,     0,     0,   530,   531,   532,     0,   534,   200,   535,
     536,     0,   537,   203,     0,   539,   540,   541,   542,   543,
     544,   545,   546,   205,   547,     0,   549,   550,   551,     0,
     206,   207,     0,   554,     0,   556,   208,   557,   209,     0,
     559,   560,   561,   562,     0,     0,   564,   565,   566,   567,
     568,     0,     0,   571,   572,   573,   216,   574,     0,   575,
     576,     0,     0,     0,   579,   580,   581,   582,   583,   584,
       0,   218,    49,     0,   219,   609,    79,    80,    81,   338,
       0,    83,    84,     0,    85,    86,    87,   339,     0,   340,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   341,     0,   103,     0,   104,   105,   106,
     107,     0,     0,     0,   109,   110,   111,     0,   112,     0,
       0,     0,   342,   343,     0,     0,     0,   600,   601,     0,
       0,     0,     0,   602,     0,     0,     0,     0,     0,     0,
       0,     0,   603,     0,   604,     0,   605,   606,     0,   344,
     345,   346,   347,   348,   349,   350,     0,   352,     0,     0,
       0,     0,     0,     0,     0,   360,   361,   362,     0,   363,
     364,   365,     0,   132,     0,   134,     0,     0,   367,   368,
       0,   369,     0,     0,   372,   607,   135,   373,     0,   375,
     376,   377,   378,   139,     0,     0,   381,   382,   383,     0,
     385,   386,   142,   387,     0,   389,   390,     0,     0,     0,
       0,     0,   395,   396,   397,   398,   399,   148,   149,   400,
    1586,   402,     0,   404,     0,   405,   406,   407,     0,     0,
       0,   411,   412,   413,   414,     0,   416,   417,     0,   419,
       0,   421,   422,   423,   156,   424,     0,   158,     0,   426,
     427,   160,     0,   429,     0,   431,     0,     0,     0,   433,
       0,   434,     0,     0,   437,     0,   439,   440,     0,   441,
     442,   443,     0,   444,   445,   446,   447,     0,     0,   449,
       0,   450,   451,   452,     0,   169,     0,   170,     0,     0,
       0,     0,   455,     0,   456,   457,   458,   459,     0,     0,
     461,     0,     0,   463,   464,   465,   466,   467,   468,   469,
     470,   471,   472,   473,   474,   475,   476,     0,   181,     0,
     478,   479,   480,   481,   182,     0,   483,   484,     0,     0,
     185,   186,   486,     0,     0,   489,     0,     0,     0,   493,
     494,     0,     0,   497,     0,     0,     0,   498,   499,   500,
     501,   502,     0,   189,   503,   504,   505,     0,   507,   508,
     509,   510,   511,   191,   512,     0,   514,   515,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   197,   524,   525,
     526,   527,   528,     0,     0,   530,   531,   532,     0,   534,
     200,   535,   536,     0,   537,   203,     0,   539,   540,   541,
     542,   543,   544,   545,   546,   205,   547,     0,   549,   550,
     551,     0,   206,   207,     0,   554,     0,   556,   208,   557,
     209,     0,   559,   560,   561,   562,     0,     0,   564,   565,
     566,   567,   568,     0,     0,   571,   572,   573,   216,   574,
       0,   575,   576,     0,     0,     0,   579,   580,   581,   582,
     583,   584,     0,   218,    49,     0,   219,   609,    79,    80,
      81,   338,     0,    83,    84,     0,    85,    86,    87,   339,
       0,   340,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   341,     0,   103,     0,   104,
     105,   106,   107,     0,     0,     0,   109,   110,   111,     0,
     112,     0,     0,     0,   342,   343,     0,     0,     0,   600,
     601,     0,     0,     0,     0,   602,     0,     0,     0,     0,
       0,     0,     0,     0,   603,     0,   604,     0,   605,   606,
       0,   344,   345,   346,   347,   348,   349,   350,     0,   352,
       0,     0,     0,     0,     0,     0,     0,   360,   361,   362,
       0,   363,   364,   365,     0,   132,     0,   134,     0,     0,
     367,   368,     0,   369,     0,     0,   372,   607,   135,   373,
       0,   375,   376,   377,   378,   139,     0,     0,   381,   382,
     383,     0,   385,   386,   142,   387,     0,   389,   390,     0,
       0,     0,     0,     0,   395,   396,   397,   398,   399,   148,
     149,   400,     0,   402,     0,   404,     0,   405,   406,   407,
       0,     0,     0,   411,   412,   413,   414,     0,   416,   417,
       0,   419,     0,   421,   422,   423,   156,   424,     0,   158,
       0,   426,   427,   160,     0,   429,     0,   431,     0,     0,
       0,   433,     0,   434,     0,     0,   437,     0,   439,   440,
       0,   441,   442,   443,     0,   444,   445,   446,   447,     0,
       0,   449,     0,   450,   451,   452,     0,   169,     0,   170,
       0,     0,     0,     0,   455,     0,   456,   457,   458,   459,
       0,     0,   461,     0,     0,   463,   464,   465,   466,   467,
     468,   469,   470,   471,   472,   473,   474,   475,   476,     0,
     181,     0,   478,   479,   480,   481,   182,     0,   483,   484,
       0,     0,   185,   186,   486,     0,     0,   489,     0,     0,
       0,   493,   494,     0,     0,   497,     0,     0,     0,   498,
     499,   500,   501,   502,     0,   189,   503,   504,   505,     0,
     507,   508,   509,   510,   511,   191,   512,     0,   514,   515,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   197,
     524,   525,   526,   527,   528,     0,     0,   530,   531,   532,
       0,   534,   200,   535,   536,     0,   537,   203,     0,   539,
     540,   541,   542,   543,   544,   545,   546,   205,   547,     0,
     549,   550,   551,     0,   206,   207,     0,   554,     0,   556,
     208,   557,   209,     0,   559,   560,   561,   562,     0,     0,
     564,   565,   566,   567,   568,     0,     0,   571,   572,   573,
     216,   574,     0,   575,   576,     0,     0,     0,   579,   580,
     581,   582,   583,   584,     0,   218,    49,     0,   219,   609,
      79,    80,    81,   338,     0,    83,    84,     0,    85,    86,
      87,   339,   729,   340,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   341,     0,   103,
       0,   104,   105,   106,   107,     0,     0,     0,   109,   110,
     111,     0,   112,     0,     0,     0,   342,   343,     0,     0,
       0,   600,   601,     0,     0,     0,     0,   602,     0,     0,
       0,     0,     0,     0,     0,     0,   603,     0,   604,     0,
     605,   606,     0,   344,   345,   346,   347,   348,   349,   350,
       0,   352,     0,     0,     0,     0,     0,     0,     0,   360,
     361,   362,     0,   363,   364,   365,     0,   132,     0,   134,
       0,     0,   367,   368,     0,   369,     0,     0,   372,   607,
     135,   373,     0,   375,   376,   377,   378,   139,     0,     0,
     381,   382,   383,     0,   385,   386,   142,   387,     0,   389,
     390,     0,     0,     0,     0,     0,   395,   396,   397,   398,
     399,   148,   149,   400,     0,   402,     0,   404,     0,   405,
     406,   407,     0,     0,     0,   411,   412,   413,   414,     0,
     416,   417,     0,   419,     0,   421,   422,   423,   156,   424,
       0,   158,     0,   426,   427,   160,     0,   429,     0,   431,
       0,     0,     0,   433,     0,   434,     0,     0,   437,     0,
     439,   440,     0,   441,   442,   443,     0,   444,   445,   446,
     447,     0,     0,   449,     0,   450,   451,   452,     0,   169,
       0,   170,     0,     0,     0,     0,   455,     0,   456,   457,
     458,   459,     0,     0,   461,     0,     0,   463,   464,   465,
     466,   467,   468,   469,   470,   471,   472,   473,   474,   475,
     476,     0,   181,     0,   478,   479,   480,   481,   182,     0,
     483,   484,     0,     0,   185,   186,   486,     0,     0,   489,
       0,     0,     0,   493,   494,     0,     0,   497,     0,     0,
       0,   498,   499,   500,   501,   502,     0,   189,   503,   504,
     730,     0,   507,   508,   509,   510,   511,   191,   512,     0,
     514,   515,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   197,   524,   525,   526,   527,   528,     0,     0,   530,
     531,   532,     0,   534,   200,   535,   536,     0,   537,   203,
       0,   539,   540,   541,   542,   543,   544,   545,   546,   205,
     547,     0,   549,   550,   551,     0,   206,   207,     0,   554,
       0,   556,   208,   557,   209,     0,   559,   560,   561,   562,
       0,     0,   564,   565,   566,   567,   568,     0,     0,   571,
     572,   573,   216,   574,     0,   575,   576,     0,     0,     0,
     579,   580,   581,   582,   583,   584,     0,   218,     0,     0,
     219,   609,    79,    80,    81,   338,     0,    83,    84,     0,
      85,    86,    87,   339,     0,   340,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   341,
       0,   103,     0,   104,   105,   106,   107,     0,     0,     0,
     109,   110,   111,     0,   112,     0,     0,     0,   342,   343,
       0,     0,     0,   600,   601,     0,     0,     0,     0,   602,
       0,     0,     0,     0,     0,     0,     0,     0,   603,     0,
     604,     0,   605,   606,     0,   344,   345,   346,   347,   348,
     349,   350,     0,   352,     0,     0,     0,     0,     0,     0,
       0,   360,   361,   362,     0,   363,   364,   365,     0,   132,
       0,   134,     0,     0,   367,   368,     0,   369,     0,     0,
     372,   607,   135,   373,     0,   375,   376,   377,   378,   139,
       0,     0,   381,   382,   383,     0,   385,   386,   142,   387,
       0,   389,   390,     0,     0,     0,     0,     0,   395,   396,
     397,   398,   399,   148,   149,   400,     0,   402,     0,   404,
       0,   405,   406,   407,     0,     0,     0,   411,   412,   413,
     414,     0,   416,   417,     0,   419,     0,   421,   422,   423,
     156,   424,     0,   158,     0,   426,   427,   160,     0,   429,
       0,   431,     0,     0,     0,   433,     0,   434,     0,     0,
     437,     0,   439,   440,     0,   760,   442,   443,     0,   444,
     445,   446,   447,     0,     0,   449,     0,   450,   451,   452,
       0,   169,     0,   170,     0,     0,     0,     0,   455,     0,
     456,   457,   458,   459,     0,     0,   461,     0,     0,   463,
     464,   465,   466,   467,   468,   469,   470,   471,   472,   473,
     474,   475,   476,     0,   181,     0,   478,   479,   480,   481,
     182,     0,   483,   484,     0,     0,   185,   186,   486,     0,
       0,   489,     0,     0,     0,   493,   494,     0,     0,   497,
       0,     0,     0,   498,   499,   500,   501,   502,     0,   189,
     503,   504,   505,     0,   507,   508,   509,   510,   511,   191,
     512,     0,   514,   515,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   197,   524,   525,   526,   527,   528,     0,
       0,   530,   531,   532,     0,   534,   200,   535,   536,     0,
     537,   203,     0,   539,   540,   541,   542,   543,   544,   545,
     546,   205,   547,     0,   549,   550,   551,     0,   206,   207,
       0,   554,     0,   556,   208,   557,   209,     0,   559,   560,
     561,   562,     0,     0,   564,   565,   566,   567,   568,     0,
       0,   571,   572,   573,   216,   574,     0,   575,   576,     0,
       0,     0,   579,   580,   581,   582,   583,   584,     0,   218,
       0,     0,   219,   609,    79,    80,    81,   338,     0,    83,
      84,     0,    85,    86,    87,   339,     0,   340,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   341,     0,   103,     0,   104,   105,   106,   107,     0,
       0,     0,   109,   110,   111,     0,   112,     0,     0,     0,
     342,   343,     0,     0,     0,   600,   601,     0,     0,     0,
       0,   602,     0,     0,     0,     0,     0,     0,     0,     0,
     603,     0,   604,     0,   605,   606,     0,   344,   345,   346,
     347,   348,   349,   350,     0,   352,     0,     0,     0,     0,
       0,     0,     0,   360,   361,   362,     0,   363,   364,   365,
       0,   132,     0,   134,     0,     0,   367,   368,     0,   369,
       0,     0,   372,   607,   135,   373,     0,   375,   376,   377,
     378,   139,     0,     0,   381,   382,   383,     0,   385,   386,
     142,   387,     0,   389,   390,     0,     0,     0,     0,     0,
     395,   396,   397,   398,   399,   148,   149,   400,     0,   402,
       0,   404,     0,   405,   406,   407,     0,     0,     0,   411,
     412,   413,   414,     0,   416,   417,     0,   419,     0,   421,
     422,   423,   156,   424,     0,   158,     0,   426,   427,   160,
       0,   429,     0,   431,     0,     0,     0,   433,     0,   434,
       0,     0,   437,     0,   439,   440,     0,   441,   442,   443,
       0,   444,   445,   446,   447,     0,     0,   449,     0,   450,
     451,   452,     0,   169,     0,   170,     0,     0,     0,     0,
     455,     0,   456,   457,   458,   459,     0,     0,   461,     0,
       0,   463,   464,   465,   466,   467,   468,   469,   470,   471,
     472,   473,   474,   475,   476,     0,   181,     0,   478,   479,
     480,   481,   182,     0,   483,   484,     0,     0,   185,   186,
     486,     0,     0,   489,     0,     0,     0,   493,   494,     0,
       0,   497,     0,     0,     0,   498,   499,   500,   501,   502,
       0,   189,   503,   504,   505,     0,   507,   508,   509,   510,
     511,   191,   512,     0,   514,   515,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   197,   524,   525,   526,   527,
     528,     0,     0,   530,   531,   532,     0,   534,   200,   535,
     536,     0,   537,   203,     0,   539,   540,   541,   542,   543,
     544,   545,   546,   205,   547,     0,   549,   550,   551,     0,
     206,   207,     0,   554,     0,   556,   208,   557,   209,     0,
     559,   560,   561,   562,     0,     0,   564,   565,   566,   567,
     568,     0,     0,   571,   572,   573,   216,   574,     0,   575,
     576,     0,     0,     0,   579,   580,   581,   582,   583,   584,
       0,   218,     0,     0,   219,   609,   639,    79,    80,    81,
     338,     0,    83,    84,     0,    85,    86,    87,   339,     0,
     340,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     640,    99,   100,   101,   341,   641,   103,     0,   104,   105,
     106,   107,   642,   643,     0,   109,   110,   111,     0,   112,
     644,   645,     0,   342,   343,     0,     0,     0,   600,   601,
       0,     0,     0,     0,   602,     0,     0,     0,     0,     0,
       0,     0,     0,   603,     0,   604,     0,   605,   606,     0,
     344,   345,   346,   347,   348,   349,   350,     0,   352,     0,
       0,     0,     0,     0,     0,     0,   360,   361,   362,     0,
     363,   364,   365,     0,  1335,     0,  1336,  1081,     0,   367,
     368,     0,   369,     0,     0,   372,  1337,  1338,   373,     0,
     375,   376,   377,   378,     0,     0,     0,   381,   382,   383,
       0,   385,   386,     0,   387,     0,   389,   390,     0,     0,
       0,     0,     0,   395,   396,   397,   398,   399,  1339,  1340,
     400,     0,   402,     0,   404,     0,   405,   406,   407,     0,
       0,     0,   411,  1094,   413,   414,     0,   416,   417,     0,
     419,     0,   421,   422,   423,     0,   424,     0,     0,     0,
     426,   427,  1341,     0,   429,     0,   431,     0,     0,     0,
     433,     0,   434,     0,     0,   437,     0,   439,   440,     0,
     441,   442,   443,     0,   444,   445,   446,   447,     0,     0,
     449,     0,   450,   451,   452,  1099,  1342,     0,  1343,     0,
       0,     0,     0,   455,     0,   456,   457,   458,   459,     0,
       0,   461,     0,     0,   463,   464,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   474,   475,  1102,     0,  1344,
       0,   478,   479,   480,   481,  1828,     0,   483,   484,     0,
       0,     0,  1345,   486,     0,     0,   489,     0,     0,     0,
     493,   494,     0,     0,   497,     0,     0,     0,   498,   499,
     500,   501,   502,     0,     0,   503,   504,   505,     0,   507,
     508,   509,   510,   511,  1346,   512,     0,   514,   515,   516,
     517,   518,   519,   520,   521,   522,     0,   523,     0,   524,
     525,   526,   527,   528,     0,     0,   530,   531,   532,     0,
     534,  1347,   535,   536,     0,   537,  1348,     0,   539,   540,
     541,   542,   543,   544,   545,   546,     0,   547,     0,   549,
     550,   551,     0,  1349,  1350,     0,   554,     0,   556,     0,
     557,     0,     0,   559,   560,   561,   562,     0,     0,   564,
     565,   566,   567,   568,     0,     0,   571,   572,   573,  1351,
     574,     0,   575,   576,     0,     0,     0,   579,   580,   581,
     582,   583,   584,     0,   218,     0,     0,   219,   639,    79,
      80,    81,   338,     0,    83,    84,     0,    85,    86,    87,
     339,     0,   340,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   640,    99,   100,   101,   341,   641,   103,     0,
     104,   105,   106,   107,   642,   643,     0,   109,   110,   111,
       0,   112,   644,   645,     0,   342,   343,     0,     0,     0,
     600,   601,     0,     0,     0,     0,   602,     0,     0,     0,
       0,     0,     0,     0,     0,   603,     0,   604,     0,   605,
     606,     0,   344,   345,   346,   347,   348,   349,   350,     0,
     352,     0,     0,     0,     0,     0,     0,     0,   360,   361,
     362,     0,   363,   364,   365,     0,  1335,     0,  1336,  1081,
       0,   367,   368,     0,   369,     0,     0,   372,  1337,  1338,
     373,     0,   375,   376,   377,   378,     0,     0,     0,   381,
     382,   383,     0,   385,   386,     0,   387,     0,   389,   390,
       0,     0,     0,     0,     0,   395,   396,   397,   398,   399,
    1339,  1340,   400,     0,   402,     0,   404,     0,   405,   406,
     407,     0,     0,     0,   411,  1094,   413,   414,     0,   416,
     417,     0,   419,     0,   421,   422,   423,     0,   424,     0,
       0,     0,   426,   427,  1341,     0,   429,     0,   431,     0,
       0,     0,   433,     0,   434,     0,     0,   437,     0,   439,
     440,     0,   441,   442,   443,  1704,   444,   445,   446,   447,
       0,     0,  1705,     0,   450,   451,   452,  1099,  1342,     0,
    1343,     0,     0,     0,     0,   455,     0,   456,   457,   458,
     459,     0,     0,   461,     0,     0,   463,   464,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,   475,  1102,
       0,  1344,     0,   478,   479,   480,   481,     0,     0,   483,
     484,     0,     0,     0,  1345,   486,     0,     0,   489,     0,
       0,     0,   493,   494,     0,     0,  1706,     0,     0,     0,
     498,   499,   500,   501,   502,     0,     0,   503,   504,   505,
       0,   507,   508,   509,   510,   511,  1346,   512,     0,   514,
     515,   516,   517,   518,   519,   520,   521,   522,     0,   523,
       0,   524,   525,   526,   527,   528,     0,     0,   530,   531,
     532,     0,   534,  1347,   535,   536,     0,   537,  1348,     0,
     539,   540,   541,   542,   543,   544,   545,   546,     0,   547,
       0,   549,   550,   551,     0,  1349,  1350,     0,   554,     0,
     556,     0,   557,     0,     0,   559,   560,   561,   562,     0,
       0,   564,   565,   566,   567,   568,     0,     0,   571,   572,
     573,  1351,   574,     0,   575,   576,     0,     0,     0,   579,
     580,   581,   582,   583,   584,     0,   218,     0,     0,   219,
     639,    79,    80,    81,   338,     0,    83,    84,     0,    85,
      86,    87,   339,     0,   340,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   640,    99,   100,   101,   341,   641,
     103,     0,   104,   105,   106,   107,   642,   643,     0,   109,
     110,   111,     0,   112,   644,   645,     0,   342,   343,     0,
       0,     0,   600,   601,     0,     0,     0,     0,   602,     0,
       0,     0,     0,     0,     0,     0,     0,   603,     0,   604,
       0,   605,   606,     0,   344,   345,   346,   347,   348,   349,
     350,     0,   352,     0,     0,     0,     0,     0,     0,     0,
     360,   361,   362,     0,   363,   364,   365,     0,  1335,     0,
    1336,  1081,     0,   367,   368,     0,   369,     0,     0,   372,
    1337,  1338,   373,     0,   375,   376,   377,   378,     0,     0,
       0,   381,   382,   383,     0,   385,   386,     0,   387,     0,
     389,   390,     0,     0,     0,     0,     0,   395,   396,   397,
     398,   399,  1339,  1340,   400,     0,   402,     0,   404,     0,
     405,   406,   407,     0,     0,     0,   411,  1094,   413,   414,
       0,   416,   417,     0,   419,     0,   421,   422,   423,     0,
     424,     0,     0,     0,   426,   427,  1341,     0,   429,     0,
     431,     0,     0,     0,   433,     0,   434,     0,     0,   437,
       0,   439,   440,     0,   441,   442,   443,     0,   444,   445,
     446,   447,     0,     0,   449,     0,   450,   451,   452,  1099,
    1342,     0,  1343,     0,     0,     0,     0,   455,     0,   456,
     457,   458,   459,     0,     0,   461,     0,     0,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,  1102,     0,  1344,     0,   478,   479,   480,   481,  2486,
       0,   483,   484,     0,     0,     0,  1345,   486,     0,     0,
     489,     0,     0,     0,   493,   494,     0,     0,   497,     0,
       0,     0,   498,   499,   500,   501,   502,     0,     0,   503,
     504,   505,     0,   507,   508,   509,   510,   511,  1346,   512,
       0,   514,   515,   516,   517,   518,   519,   520,   521,   522,
       0,   523,     0,   524,   525,   526,   527,   528,     0,     0,
     530,   531,   532,     0,   534,  1347,   535,   536,     0,   537,
    1348,     0,   539,   540,   541,   542,   543,   544,   545,   546,
       0,   547,     0,   549,   550,   551,     0,  1349,  1350,     0,
     554,     0,   556,     0,   557,     0,     0,   559,   560,   561,
     562,     0,     0,   564,   565,   566,   567,   568,     0,     0,
     571,   572,   573,  1351,   574,     0,   575,   576,     0,     0,
       0,   579,   580,   581,   582,   583,   584,     0,   218,     0,
       0,   219,   639,    79,    80,    81,   338,     0,    83,    84,
       0,    85,    86,    87,   339,     0,   340,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   640,    99,   100,   101,
     341,   641,   103,     0,   104,   105,   106,   107,   642,   643,
       0,   109,   110,   111,     0,   112,   644,   645,     0,   342,
     343,     0,     0,     0,   600,   601,     0,     0,     0,     0,
     602,     0,     0,     0,     0,     0,     0,     0,     0,   603,
       0,   604,     0,   605,   606,     0,   344,   345,   346,   347,
     348,   349,   350,     0,   352,     0,     0,     0,     0,     0,
       0,     0,   360,   361,   362,     0,   363,   364,   365,     0,
    1335,     0,  1336,  1081,     0,   367,   368,     0,   369,     0,
       0,   372,  1337,  1338,   373,     0,   375,   376,   377,   378,
       0,     0,     0,   381,   382,   383,     0,   385,   386,     0,
     387,     0,   389,   390,     0,     0,     0,     0,     0,   395,
     396,   397,   398,   399,  1339,  1340,   400,     0,   402,     0,
     404,     0,   405,   406,   407,     0,     0,     0,   411,  1094,
     413,   414,     0,   416,   417,     0,   419,     0,   421,   422,
     423,     0,   424,     0,     0,     0,   426,   427,  1341,     0,
     429,     0,   431,     0,     0,     0,   433,     0,   434,     0,
       0,   437,     0,   439,   440,     0,   441,   442,   443,     0,
     444,   445,   446,   447,     0,     0,   449,     0,   450,   451,
     452,  1099,  1342,     0,  1343,     0,     0,     0,     0,   455,
       0,   456,   457,   458,   459,     0,     0,   461,     0,     0,
     463,   464,   465,   466,   467,   468,   469,   470,   471,   472,
     473,   474,   475,  1102,     0,  1344,     0,   478,   479,   480,
     481,     0,     0,   483,   484,     0,     0,     0,  1345,   486,
       0,     0,   489,     0,     0,     0,   493,   494,     0,     0,
     497,     0,     0,     0,   498,   499,   500,   501,   502,     0,
       0,   503,   504,   505,     0,   507,   508,   509,   510,   511,
    1346,   512,     0,   514,   515,   516,   517,   518,   519,   520,
     521,   522,     0,   523,     0,   524,   525,   526,   527,   528,
       0,     0,   530,   531,   532,     0,   534,  1347,   535,   536,
       0,   537,  1348,     0,   539,   540,   541,   542,   543,   544,
     545,   546,     0,   547,     0,   549,   550,   551,     0,  1349,
    1350,     0,   554,     0,   556,     0,   557,     0,     0,   559,
     560,   561,   562,     0,     0,   564,   565,   566,   567,   568,
       0,     0,   571,   572,   573,  1351,   574,     0,   575,   576,
       0,     0,     0,   579,   580,   581,   582,   583,   584,     0,
     218,     0,     0,   219,   639,    79,    80,    81,   338,     0,
      83,    84,     0,    85,    86,    87,   339,     0,   340,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   640,    99,
     100,   101,   341,   641,   103,     0,   104,   105,   106,   107,
     642,   643,     0,   109,   110,   111,     0,   112,   644,   645,
       0,   342,   343,     0,     0,     0,   600,   601,     0,     0,
       0,     0,   602,     0,     0,     0,     0,     0,     0,     0,
       0,   603,     0,   604,     0,   605,   606,     0,   344,   345,
     346,   347,   348,   349,   350,     0,   352,     0,     0,     0,
       0,     0,     0,     0,   360,   361,   362,     0,   363,   364,
     365,     0,  1335,     0,  1336,  1081,     0,   367,   368,     0,
     369,     0,     0,   372,  1337,  1338,   373,     0,   375,   376,
     377,   378,     0,     0,     0,   381,   382,   383,     0,   385,
     386,     0,   387,     0,   389,   390,     0,     0,     0,     0,
       0,   395,   396,   397,   398,   399,  1339,  1340,   400,     0,
     402,     0,   404,     0,   405,   406,   407,     0,     0,     0,
     411,  1094,   413,   414,     0,   416,   417,     0,   419,     0,
     421,   422,   423,     0,   424,     0,     0,     0,   426,   427,
    1341,     0,   429,     0,   431,     0,     0,     0,   433,     0,
     434,     0,     0,   437,     0,   439,   440,     0,   441,   442,
     443,     0,   444,   445,   446,   447,     0,     0,   449,     0,
     450,   451,   452,  1099,  1342,     0,  1343,     0,     0,     0,
       0,   455,     0,   456,   457,   458,   459,     0,     0,   461,
       0,     0,   463,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   474,   475,  1102,     0,  1344,     0,   478,
     479,   480,   481,     0,     0,   483,   484,     0,     0,     0,
    1345,   486,     0,     0,   489,     0,     0,     0,   493,   494,
       0,     0,   497,     0,     0,     0,   498,   499,   500,   501,
     502,     0,     0,   503,   504,   505,     0,   507,   508,   509,
     510,   511,  1346,   512,     0,   514,   515,   516,   517,   518,
     519,   520,   521,   522,     0,   523,     0,   524,   525,   526,
     527,   528,     0,     0,   530,   531,   532,     0,   534,     0,
     535,   536,     0,   537,  1348,     0,   539,   540,   541,   542,
     543,   544,   545,   546,     0,   547,     0,   549,   550,   551,
       0,  1349,  1350,     0,   554,     0,   556,     0,   557,     0,
       0,   559,   560,   561,   562,     0,     0,   564,   565,   566,
     567,   568,     0,     0,   571,   572,   573,  1351,   574,     0,
     575,   576,     0,     0,     0,   579,   580,   581,   582,   583,
     584,     0,   218,     0,     0,   219,    79,    80,    81,   338,
       0,    83,    84,     0,    85,    86,    87,   339,     0,   340,
      90,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   341,     0,   103,     0,   104,   105,   106,
     107,     0,   108,     0,   109,   110,   111, -1232,   112,   113,
     114,     0,   342,   343,     0,     0,     0,   117,   118,     0,
       0,     0,     0,   119,     0,     0,     0,     0,     0,     0,
       0,     0,   120,     0,   121,     0,   122,   123,     0,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   129,   363,
     364,   365,   131,   132,   133,   134,     0,   366,   367,   368,
       0,   369,   370,   371,   372,     0,   135,   373,   374,   375,
     376,   377,   378,   139,   379,   380,   381,   382,   383,   384,
     385,   386,   142,   387,   388,   389,   390,   145,   391,   392,
     393,   394,   395,   396,   397,   398,   399,   148,   149,   400,
     401,   402,   403,   404,     0,   405,   406,   407,   408,   409,
     410,   411,   412,   413,   414,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   156,   424,     0,   158,   425,   426,
     427,   160,   428,   429,   430,   431,   161,   432,   162,   433,
       0,   434,   435,   436,   437,   438,   439,   440,   165,   441,
     442,   443,   166,   444,   445,   446,   447,   448,   167,   449,
       0,   450,   451,   452,     0,   169,   453,   170,   454,     0,
     171,   172,   455,   173,   456,   457,   458,   459,   460,   174,
     461,   175,   462,   463,   464,   465,   466,   467,   468,   469,
     470,   471,   472,   473,   474,   475,   476,   180,   181,   477,
     478,   479,   480,   481,   182,   482,   483,   484,   184,   485,
     185,   186,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,   497,   187,   188,     0,   498,   499,   500,
     501,   502,     0,   189,   503,   504,   505,   506,   507,   508,
     509,   510,   511,   191,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,   522,   195,   523,   197,   524,   525,
     526,   527,   528,     0,   529,   530,   531,   532,   533,   534,
     200,   535,   536,   202,   537,   203,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   205,   547,   548,   549,   550,
     551,   552,   206,   207,   553,   554,   555,   556,   208,   557,
     209,   558,   559,   560,   561,   562,   212,   563,   564,   565,
     566,   567,   568,   569,   570,   571,   572,   573,   216,   574,
     217,   575,   576,     0,   577,   578,   579,   580,   581,   582,
     583,   584,     0,   218,     0,     0,   219,    79,    80,    81,
     338,     0,    83,    84,     0,    85,    86,    87,   339,     0,
     340,    90,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   341,     0,   103,     0,   104,   105,
     106,   107,     0,   108,     0,   109,   110,   111, -1233,   112,
     113,   114,     0,   342,   343,     0,     0,     0,   117,   118,
       0,     0,     0,     0,   119,     0,     0,     0,     0,     0,
       0,     0,     0,   120,     0,   121,     0,   122,   123,     0,
     344,   345,   346,   347,   348,   349,   350,   351,   352,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,   129,
     363,   364,   365,   131,   132,   133,   134,     0,   366,   367,
     368,     0,   369,   370,   371,   372,     0,   135,   373,   374,
     375,   376,   377,   378,   139,   379,   380,   381,   382,   383,
     384,   385,   386,   142,   387,   388,   389,   390,   145,   391,
     392,   393,   394,   395,   396,   397,   398,   399,   148,   149,
     400,   401,   402,   403,   404,     0,   405,   406,   407,   408,
     409,   410,   411,   412,   413,   414,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   156,   424,     0,   158,   425,
     426,   427,   160,   428,   429,   430,   431,   161,   432,   162,
     433,     0,   434,   435,   436,   437,   438,   439,   440,   165,
     441,   442,   443,   166,   444,   445,   446,   447,   448,   167,
     449,     0,   450,   451,   452,     0,   169,   453,   170,   454,
       0,   171,   172,   455,   173,   456,   457,   458,   459,   460,
     174,   461,   175,   462,   463,   464,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   474,   475,   476,   180,   181,
     477,   478,   479,   480,   481,   182,   482,   483,   484,   184,
     485,   185,   186,   486,   487,   488,   489,   490,   491,   492,
     493,   494,   495,   496,   497,   187,   188,     0,   498,   499,
     500,   501,   502,     0,   189,   503,   504,   505,   506,   507,
     508,   509,   510,   511,   191,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,   522,   195,   523,   197,   524,
     525,   526,   527,   528,     0,   529,   530,   531,   532,   533,
     534,   200,   535,   536,   202,   537,   203,   538,   539,   540,
     541,   542,   543,   544,   545,   546,   205,   547,   548,   549,
     550,   551,   552,   206,   207,   553,   554,   555,   556,   208,
     557,   209,   558,   559,   560,   561,   562,   212,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   216,
     574,   217,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   584,     0,   218,     0,     0,   219,    79,    80,
      81,   338,     0,    83,    84,     0,    85,    86,    87,   339,
       0,   340,    90,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   341,     0,   103,     0,   104,
     105,   106,   107,     0,   108,     0,   109,   110,   111,     0,
     112,   113,   114,     0,   342,   343,     0,     0,     0,   117,
     118,     0,     0,     0,     0,   119,     0,     0,     0,     0,
       0,     0,     0,     0,   120,     0,   121,     0,   122,     0,
       0,   344,   345,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     129,   363,   364,   365,   131,   132,   133,   134,     0,   366,
     367,   368,     0,   369,   370,   371,   372,     0,   135,   373,
     374,   375,   376,   377,   378,   139,   379,   380,   381,   382,
     383,   384,   385,   386,   142,   387,   388,   389,   390,   145,
     391,   392,   393,   394,   395,   396,   397,   398,   399,   148,
     149,   400,   401,   402,   403,   404,     0,   405,   406,   407,
     408,   409,   410,   411,   412,   413,   414,   415,   416,   417,
     418,   419,   420,   421,   422,   423,   156,   424,     0,   158,
     425,   426,   427,   160,   428,   429,   430,   431,   161,   432,
     162,   433,     0,   434,   435,   436,   437,   438,   439,   440,
     165,   441,   442,   443,   166,   444,   445,   446,   447,   448,
     167,   449,     0,   450,   451,   452,     0,   169,   453,   170,
     454,     0,   171,   172,   455,   173,   456,   457,   458,   459,
     460,   174,   461,   175,   462,   463,   464,   465,   466,   467,
     468,   469,   470,   471,   472,   473,   474,   475,   476,   180,
     181,   477,   478,   479,   480,   481,   182,   482,   483,   484,
     184,   485,   185,   186,   486,   487,   488,   489,   490,   491,
     492,   493,   494,   495,   496,   497,   187,   188,     0,   498,
     499,   500,   501,   502,     0,   189,   503,   504,   505,   506,
     507,   508,   509,   510,   511,   191,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,   522,   195,   523,   197,
     524,   525,   526,   527,   528,     0,   529,   530,   531,   532,
     533,   534,   200,   535,   536,   202,   537,   203,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   205,   547,   548,
     549,   550,   551,   552,   206,   207,   553,   554,   555,   556,
     208,   557,   209,   558,   559,   560,   561,   562,   212,   563,
     564,   565,   566,   567,   568,   569,   570,   571,   572,   573,
     216,   574,   217,   575,   576,     0,   577,   578,   579,   580,
     581,   582,   583,   584,     0,   218,     0,     0,   219,    79,
      80,    81,   338,     0,    83,    84,     0,    85,    86,    87,
     339,     0,   340,    90,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   341,     0,   103,     0,
     104,   105,   106,   107,     0,   108,     0,   109,   110,   111,
       0,   112,   113,   114,     0,   342,   343,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   344,   345,   346,   347,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,   129,   363,   364,   365,   131,   132,   133,   134,     0,
     366,   367,   368,     0,   369,   370,   371,   372,     0,   135,
     373,   374,   375,   376,   377,   378,   139,   379,   380,   381,
     382,   383,   384,   385,   386,   142,   387,   388,   389,   390,
     145,   391,   392,   393,   394,   395,   396,   397,   398,   399,
     148,   149,   400,   401,   402,   403,   404,     0,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   156,   424,     0,
     158,   425,   426,   427,   160,   428,   429,   430,   431,   161,
     432,   162,   433,     0,   434,   435,   436,   437,   438,   439,
     440,   165,   441,   442,   443,   166,   444,   445,   446,   447,
     448,   167,   449,     0,   450,   451,   452,     0,   169,   453,
     170,   454,     0,   171,   172,   455,   173,   456,   457,   458,
     459,   460,   174,   461,   175,   462,   463,   464,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,   475,   476,
     180,   181,   477,   478,   479,   480,   481,   182,   482,   483,
     484,   184,   485,   185,   186,   486,   487,   488,   489,   490,
     491,   492,   493,   494,   495,   496,   497,   187,   188,     0,
     498,   499,   500,   501,   502,     0,   189,   503,   504,   505,
     506,   507,   508,   509,   510,   511,   191,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   195,   523,
     197,   524,   525,   526,   527,   528,     0,   529,   530,   531,
     532,   533,   534,   200,   535,   536,   202,   537,   203,   538,
     539,   540,   541,   542,   543,   544,   545,   546,   205,   547,
     548,   549,   550,   551,   552,   206,   207,   553,   554,   555,
     556,   208,   557,   209,   558,   559,   560,   561,   562,   212,
     563,   564,   565,   566,   567,   568,   569,   570,   571,   572,
     573,   216,   574,   217,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   584,     0,   218,     0,     0,   219,
      79,    80,    81,   338,     0,    83,    84,     0,    85,    86,
      87,   339,     0,   340,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   341,     0,   103,
       0,   104,   105,   106,   107,     0,     0,     0,   109,   110,
     111,     0,   112,     0,     0,     0,   342,   343,     0,     0,
       0,   600,   601,     0,     0,     0,     0,   602,     0,     0,
       0,     0,     0,     0,     0,     0,   603,     0,   604,     0,
     605,   606,     0,   344,   345,   346,   347,   348,   349,   350,
       0,   352,     0,     0,     0,     0,     0,     0,     0,   360,
     361,   362,   129,   363,   364,   365,   131,   132,   133,   134,
       0,     0,   367,   368,     0,   369,     0,     0,   372,   607,
     135,   373,     0,   375,   376,   377,   378,   139,     0,     0,
     381,   382,   383,     0,   385,   386,   142,   387,     0,   389,
     390,   145,     0,     0,     0,     0,   395,   396,   397,   398,
     399,   148,   149,   400,     0,   402,     0,   404,     0,   405,
     406,   407,     0,     0,     0,   411,   412,   413,   414,     0,
     416,   417,     0,   419,     0,   421,   422,   423,   156,   424,
       0,   158,     0,   426,   427,   160,     0,   429,     0,   431,
     161,     0,   162,   433,     0,   434,     0,     0,   437,     0,
     439,   440,   165,   441,   442,   443,   166,   444,   445,   446,
     447,     0,   167,   449,     0,   450,   451,   452,     0,   169,
       0,   170,     0,     0,   171,   172,   455,   173,   456,   457,
     458,   459,     0,   174,   461,   175,     0,   463,   464,   465,
     466,   467,   468,   469,   470,   471,   472,   473,   474,   475,
     476,   180,   181,   691,   478,   479,   480,   481,   182,     0,
     483,   484,   184,     0,   185,   186,   486,     0,     0,   489,
     692,     0,     0,   493,   494,     0,     0,   497,   187,   188,
       0,   498,   499,   500,   501,   502,     0,   189,   503,   504,
     505,     0,   507,   508,   509,   510,   511,   191,   512,     0,
     514,   515,   516,   517,   518,   519,   520,   521,   522,   195,
     523,   197,   524,   525,   526,   527,   528,     0,     0,   530,
     531,   532,     0,   534,   200,   535,   536,   202,   537,   203,
       0,   539,   540,   541,   542,   543,   544,   545,   546,   205,
     547,     0,   549,   550,   551,     0,   206,   207,     0,   554,
       0,   556,   208,   557,   209,     0,   559,   560,   561,   562,
       0,     0,   564,   565,   566,   567,   568,     0,     0,   571,
     572,   573,   216,   574,   217,   575,   576,     0,     0,     0,
     579,   580,   581,   582,   583,   584,     0,   218,     0,     0,
     219,    79,    80,    81,   338,     0,    83,    84,     0,    85,
      86,    87,   339,     0,   340,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   341,     0,
     103,     0,   104,   105,   106,   107,     0,     0,     0,   109,
     110,   111,     0,   112,     0,     0,     0,   342,   343,     0,
       0,     0,   600,   601,     0,     0,     0,     0,   602,     0,
       0,     0,     0,     0,     0,     0,     0,   603,     0,   604,
       0,   605,   606,     0,   344,   345,   346,   347,   348,   349,
     350,     0,   352,     0,     0,     0,     0,     0,     0,     0,
     360,   361,   362,     0,   363,   364,   365,     0,   132,     0,
     134,     0,     0,   367,   368,     0,   369,     0,     0,   372,
     607,   135,   373,  1691,   375,   376,   377,   378,   139,     0,
       0,   381,   382,   383,  1692,   385,   386,   142,   387,     0,
     389,   390,     0,     0,     0,     0,     0,   395,   396,   397,
     398,   399,   148,   149,   400,     0,   402,     0,   404,     0,
     405,   406,   407,     0,     0,     0,   411,   412,   413,   414,
       0,   416,   417,     0,   419,     0,   421,   422,   423,   156,
     424,     0,   158,     0,   426,   427,   160,     0,   429,  1693,
     431,     0,     0,     0,   433,     0,   434,     0,     0,   437,
       0,   439,   440,     0,   441,   442,   443,     0,   444,   445,
     446,   447,     0,     0,   449,     0,   450,   451,   452,     0,
     169,     0,   170,     0,     0,     0,     0,   455,     0,   456,
     457,   458,   459,     0,     0,   461,  2159,     0,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,     0,   181,     0,   478,   479,   480,   481,   182,
       0,   483,   484,     0,     0,   185,   186,   486,     0,     0,
     489,     0,     0,     0,   493,   494,     0,     0,   497,     0,
       0,     0,   498,   499,   500,   501,   502,     0,   189,   503,
     504,   505,  1694,   507,   508,   509,   510,   511,   191,   512,
       0,   514,   515,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   197,   524,   525,   526,   527,   528,     0,     0,
     530,   531,   532,     0,   534,   200,   535,   536,     0,   537,
     203,     0,   539,   540,   541,   542,   543,   544,   545,   546,
     205,   547,     0,   549,   550,   551,     0,   206,   207,     0,
     554,     0,   556,   208,   557,   209,     0,   559,   560,   561,
     562,     0,  1695,   564,   565,   566,   567,   568,     0,     0,
     571,   572,   573,   216,   574,     0,   575,   576,     0,     0,
       0,   579,   580,   581,   582,   583,   584,     0,   218,     0,
       0,   219,    79,    80,    81,   338,     0,    83,    84,     0,
      85,    86,    87,   339,     0,   340,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   341,
       0,   103,     0,   104,   105,   106,   107,     0,     0,     0,
     109,   110,   111,     0,   112,     0,     0,     0,   342,   343,
       0,     0,     0,   600,   601,     0,     0,     0,     0,   602,
       0,     0,     0,     0,     0,     0,     0,     0,   603,     0,
     604,     0,   605,   606,     0,   344,   345,   346,   347,   348,
     349,   350,     0,   352,   126,   127,     0,     0,     0,     0,
       0,   360,   361,   362,     0,   363,   364,   365,     0,   132,
       0,   134,     0,     0,   367,   368,     0,   369,     0,     0,
     372,   607,   135,   373,     0,   375,   376,   377,   378,   139,
       0,     0,   381,   382,   383,     0,   385,   386,   142,   387,
       0,   389,   390,     0,     0,     0,     0,     0,   395,   396,
     397,   398,   399,   148,   149,   400,     0,   402,     0,   404,
       0,   405,   406,   407,     0,     0,     0,   411,   412,   413,
     414,     0,   416,   417,     0,   419,     0,   421,   422,   423,
     156,   424,     0,   158,     0,   426,   427,   160,     0,   429,
       0,   431,     0,     0,     0,   433,     0,   434,     0,     0,
     437,     0,   439,   440,     0,   441,   442,   443,     0,   444,
     445,   446,   447,     0,     0,   449,     0,   450,   451,   452,
       0,   169,     0,   170,     0,     0,     0,     0,   455,     0,
     456,   457,   458,   459,     0,     0,   461,     0,     0,   463,
     464,   465,   466,   467,   468,   469,   470,   471,   472,   473,
     474,   475,   476,     0,   181,   691,   478,   479,   480,   481,
     182,     0,   483,   484,     0,     0,   185,   186,   486,     0,
       0,   489,   692,     0,     0,   493,   494,     0,     0,   497,
       0,     0,     0,   498,   499,   500,   501,   502,     0,   189,
     503,   504,   505,     0,   507,   508,   509,   510,   511,   191,
     512,     0,   514,   515,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   197,   524,   525,   526,   527,   528,     0,
       0,   530,   531,   532,     0,   534,   200,   535,   536,     0,
     537,   203,     0,   539,   540,   541,   542,   543,   544,   545,
     546,   205,   547,     0,   549,   550,   551,     0,   206,   207,
       0,   554,     0,   556,   208,   557,   209,     0,   559,   560,
     561,   562,     0,     0,   564,   565,   566,   567,   568,     0,
       0,   571,   572,   573,   216,   574,     0,   575,   576,     0,
       0,     0,   579,   580,   581,   582,   583,   584,     0,   218,
       0,     0,   219,    79,    80,    81,   338,     0,    83,    84,
       0,    85,    86,    87,   339,     0,   340,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     341,     0,   103,     0,   104,   105,   106,   107,     0,     0,
       0,   109,   110,   111,     0,   112,     0,     0,     0,   342,
     343,     0,     0,     0,   600,   601,     0,     0,     0,     0,
     602,     0,     0,     0,     0,     0,     0,     0,     0,   603,
       0,   604,     0,   605,   606,     0,   344,   345,   346,   347,
     348,   349,   350,     0,   352,     0,     0,     0,     0,     0,
       0,     0,   360,   361,   362,     0,   363,   364,   365,     0,
     132,     0,   134,     0,     0,   367,   368,     0,   369,     0,
       0,   372,   607,   135,   373,     0,   375,   376,   377,   378,
     139,     0,     0,   381,   382,   383,     0,   385,   386,   142,
     387,     0,   389,   390,     0,     0,     0,     0,     0,   395,
     396,   397,   398,   399,   148,   149,   400,     0,   402,     0,
     404,     0,   405,   406,   407,     0,     0,     0,   411,   412,
     413,   414,     0,   416,   417,     0,   419,     0,   421,   422,
     423,   156,   424,     0,   158,     0,   426,   427,   160,     0,
     429,     0,   431,     0,     0,     0,   433,     0,   434,     0,
       0,   437,     0,   439,   440,     0,   441,   442,   443,     0,
     444,   445,   446,   447,     0,     0,   449,     0,   450,   451,
     452,     0,   169,     0,   170,     0,     0,     0,     0,   455,
       0,   456,   457,   458,   459,     0,     0,   461,     0,     0,
     463,   464,   465,   466,   467,   468,   469,   470,   471,   472,
     473,   474,   475,   476,     0,   181,   691,   478,   479,   480,
     481,   182,     0,   483,   484,     0,     0,   185,   186,   486,
       0,     0,   489,   692,     0,   848,   493,   494,     0,     0,
     497,     0,     0,     0,   498,   499,   500,   501,   502,     0,
     189,   503,   504,   505,     0,   507,   508,   509,   510,   511,
     191,   512,     0,   514,   515,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   197,   524,   525,   526,   527,   528,
       0,     0,   530,   531,   532,     0,   534,   200,   535,   536,
       0,   537,   203,     0,   539,   540,   541,   542,   543,   544,
     545,   546,   205,   547,     0,   549,   550,   551,     0,   206,
     207,     0,   554,     0,   556,   208,   557,   209,     0,   559,
     560,   561,   562,     0,     0,   564,   565,   566,   567,   568,
       0,     0,   571,   572,   573,   216,   574,     0,   575,   576,
       0,     0,     0,   579,   580,   581,   582,   583,   584,     0,
     218,     0,     0,   219,    79,    80,    81,   338,     0,    83,
      84,     0,    85,    86,    87,   339,     0,   340,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   341,     0,   103,     0,   104,   105,   106,   107,     0,
       0,     0,   109,   110,   111,     0,   112,     0,     0,     0,
     342,   343,     0,     0,     0,   600,   601,     0,     0,     0,
       0,   602,     0,     0,     0,     0,     0,     0,     0,     0,
     603,     0,   604,     0,   605,   606,     0,   344,   345,   346,
     347,   348,   349,   350,     0,   352,     0,     0,     0,     0,
       0,     0,     0,   360,   361,   362,     0,   363,   364,   365,
       0,   132,     0,   134,     0,     0,   367,   368,     0,   369,
       0,     0,   372,   607,   135,   373,     0,   375,   376,   377,
     378,   139,     0,     0,   381,   382,   383,     0,   385,   386,
     142,   387,     0,   389,   390,     0,     0,     0,     0,     0,
     395,   396,  1439,   398,   399,   148,   149,   400,     0,   402,
       0,   404,     0,   405,   406,   407,     0,     0,     0,   411,
     412,   413,   414,     0,   416,   417,     0,   419,     0,   421,
     422,   423,   156,   424,     0,   158,     0,   426,   427,   160,
       0,   429,     0,   431,     0,     0,     0,  1440,     0,   434,
       0,     0,   437,     0,   439,   440,     0,   441,   442,   443,
       0,   444,   445,   446,   447,     0,     0,   449,     0,   450,
     451,   452,     0,   169,     0,   170,     0,     0,     0,     0,
     455,     0,   456,   457,  1441,   459,     0,     0,   461,     0,
       0,   463,   464,   465,   466,   467,   468,   469,   470,   471,
     472,   473,   474,   475,   476,     0,   181,   691,   478,   479,
     480,   481,   182,     0,   483,   484,     0,     0,   185,   186,
     486,     0,     0,   489,   692,     0,     0,   493,   494,     0,
       0,   497,     0,     0,     0,   498,   499,   500,   501,   502,
       0,   189,   503,   504,   505,     0,   507,   508,   509,   510,
     511,   191,   512,     0,   514,   515,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   197,   524,   525,  1442,   527,
     528,     0,     0,   530,   531,   532,     0,   534,   200,   535,
     536,     0,   537,   203,     0,   539,   540,   541,   542,   543,
     544,   545,   546,   205,   547,  1443,   549,   550,   551,     0,
     206,   207,     0,   554,     0,   556,   208,   557,   209,     0,
     559,   560,   561,   562,     0,     0,   564,   565,   566,   567,
     568,     0,     0,   571,   572,   573,   216,   574,     0,   575,
     576,     0,     0,     0,   579,   580,   581,   582,   583,   584,
       0,   218,     0,     0,   219,    79,    80,    81,   338,     0,
      83,    84,     0,    85,    86,    87,   339,     0,   340,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   341,     0,   103,     0,   104,   105,   106,   107,
       0,     0,     0,   109,   110,   111,     0,   112,     0,     0,
       0,   342,   343,     0,     0,     0,   600,   601,     0,     0,
       0,     0,   602,     0,     0,     0,     0,     0,     0,     0,
       0,   603,     0,   604,     0,   605,   606,     0,   344,   345,
     346,   347,   348,   349,   350,     0,   352,     0,     0,     0,
       0,     0,     0,     0,   360,   361,   362,     0,   363,   364,
     365,     0,   132,     0,   134,     0,     0,   367,   368,     0,
     369,     0,     0,   372,   607,   135,   373,     0,   375,   376,
     377,   378,   139,     0,     0,   381,   382,   383,     0,   385,
     386,   142,   387,     0,   389,   390,     0,     0,     0,     0,
       0,   395,   396,   397,   398,   399,   148,   149,   400,     0,
     402,     0,   404,     0,   405,   406,   407,     0,     0,     0,
     411,   412,   413,   414,     0,   416,   417,     0,   419,     0,
     421,   422,   423,   156,   424,     0,   158,     0,   426,   427,
     160,     0,   429,     0,   431,     0,     0,     0,   433,     0,
     434,     0,     0,   437,     0,   439,   440,     0,   441,   442,
     443,     0,   444,   445,   446,   447,     0,     0,   449,     0,
     450,   451,   452,     0,   169,     0,   170,     0,     0,     0,
       0,   455,     0,   456,   457,   458,   459,     0,     0,   461,
       0,     0,   463,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   474,   475,   476,     0,   181,   691,   478,
     479,   480,   481,   182,     0,   483,   484,     0,     0,   185,
     186,   486,     0,     0,   489,   692,     0,     0,   493,   494,
       0,     0,   497,     0,     0,     0,   498,   499,   500,   501,
     502,     0,   189,   503,   504,   505,     0,   507,   508,   509,
     510,   511,   191,   512,     0,   514,   515,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   197,   524,   525,   526,
     527,   528,     0,     0,   530,   531,   532,     0,   534,   200,
     535,   536,     0,   537,   203,     0,   539,   540,   541,   542,
     543,   544,   545,   546,   205,   547,     0,   549,   550,   551,
       0,   206,   207,     0,   554,     0,   556,   208,   557,   209,
       0,   559,   560,   561,   562,     0,     0,   564,   565,   566,
     567,   568,     0,  2889,   571,   572,   573,   216,   574,     0,
     575,   576,     0,     0,     0,   579,   580,   581,   582,   583,
     584,     0,   218,     0,     0,   219,    79,    80,    81,   338,
       0,    83,    84,     0,    85,    86,    87,   339,     0,   340,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   341,     0,   103,     0,   104,   105,   106,
     107,     0,     0,     0,   109,   110,   111,     0,   112,     0,
       0,     0,   342,   343,     0,     0,     0,   600,   601,     0,
       0,     0,     0,   602,     0,     0,     0,     0,     0,     0,
       0,     0,   603,     0,   604,     0,   605,   606,     0,   344,
     345,   346,   347,   348,   349,   350,     0,   352,     0,     0,
       0,     0,     0,     0,     0,   360,   361,   362,     0,   363,
     364,   365,     0,   132,     0,   134,     0,     0,   367,   368,
       0,   369,     0,     0,   372,   607,   135,   373,     0,   375,
     376,   377,   378,   139,     0,     0,   381,   382,   383,     0,
     385,   386,   142,   387,     0,   389,   390,     0,     0,     0,
       0,     0,   395,   396,   397,   398,   399,   148,   149,   400,
       0,   402,     0,   404,     0,   405,   406,   407,     0,     0,
       0,   411,   412,   413,   414,     0,   416,   417,     0,   419,
       0,   421,   422,   423,   156,   424,     0,   158,     0,   426,
     427,   160,     0,   429,     0,   431,     0,     0,     0,   433,
       0,   434,     0,     0,   437,     0,   439,   440,     0,   441,
     442,   443,     0,   444,   445,   446,   447,     0,     0,   449,
       0,   450,   451,   452,     0,   169,     0,   170,     0,     0,
       0,     0,   455,     0,   456,   457,   458,   459,     0,     0,
     461,     0,     0,   463,   464,   465,   466,   467,   468,   469,
     470,   471,   472,   473,   474,   475,   476,     0,   181,   691,
     478,   479,   480,   481,   182,     0,   483,   484,     0,     0,
     185,   186,   486,     0,     0,   489,   692,     0,     0,   493,
     494,     0,     0,   497,     0,     0,     0,   498,   499,   500,
     501,   502,     0,   189,   503,   504,   505,     0,   507,   508,
     509,   510,   511,   191,   512,     0,   514,   515,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   197,   524,   525,
     526,   527,   528,     0,     0,   530,   531,   532,     0,   534,
     200,   535,   536,     0,   537,   203,     0,   539,   540,   541,
     542,   543,   544,   545,   546,   205,   547,     0,   549,   550,
     551,     0,   206,   207,     0,   554,     0,   556,   208,   557,
     209,     0,   559,   560,   561,   562,     0,     0,   564,   565,
     566,   567,   568,     0,     0,   571,   572,   573,   216,   574,
       0,   575,   576,     0,     0,     0,   579,   580,   581,   582,
     583,   584,     0,   218,     0,     0,   219,    79,    80,    81,
     338,     0,    83,    84,     0,    85,    86,    87,   339,     0,
     340,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   341,     0,   103,     0,   104,   105,
     106,   107,     0,     0,     0,   109,   110,   111,     0,   112,
       0,     0,     0,   342,   343,     0,     0,     0,   600,   601,
       0,     0,     0,     0,   602,     0,     0,     0,     0,     0,
       0,     0,     0,   603,     0,   604,     0,   605,   606,     0,
     344,   345,   346,   347,   348,   349,   350,     0,   352,     0,
       0,     0,     0,     0,     0,     0,   360,   361,   362,     0,
     363,   364,   365,     0,   132,     0,   134,     0,     0,   367,
     368,     0,   369,     0,     0,   372,   607,   135,   373,     0,
     375,   376,   377,   378,   139,     0,     0,   381,   382,   383,
       0,   385,   386,   142,   387,     0,   389,   390,     0,     0,
       0,     0,     0,   395,   396,   397,   398,   399,   148,   149,
     400,     0,   402,     0,   404,     0,   405,   406,   407,     0,
       0,     0,   411,   412,   413,   414,     0,   416,   417,     0,
     419,     0,   421,   422,   423,   156,   424,     0,   158,     0,
     426,   427,   160,     0,   429,     0,   431,     0,   769,     0,
     433,     0,   434,     0,     0,   437,     0,   439,   440,     0,
     441,   442,   443,   770,   444,   445,   446,   447,     0,     0,
     449,     0,   450,   451,   452,     0,   169,     0,   170,     0,
       0,     0,     0,   455,     0,   456,   457,   458,   459,     0,
       0,   461,     0,     0,   463,   464,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   474,   475,   476,     0,   181,
       0,   478,   479,   480,   481,   182,     0,   483,   484,     0,
       0,   185,   186,   486,     0,     0,   489,     0,     0,     0,
     493,   494,     0,     0,   497,     0,     0,     0,   498,   499,
     500,   501,   502,     0,   189,   503,   504,   505,     0,   507,
     508,   509,   510,   511,   191,   512,     0,   514,   515,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   197,   524,
     525,   526,   527,   528,     0,     0,   530,   531,   532,     0,
     534,   200,   535,   536,     0,   537,   203,     0,   539,   540,
     541,   542,   543,   544,   545,   546,   205,   547,     0,   549,
     550,   551,     0,   206,   207,     0,   554,     0,   556,   208,
     557,   209,     0,   559,   560,   561,   562,     0,     0,   564,
     565,   566,   567,   568,     0,     0,   571,   572,   573,   216,
     574,     0,   575,   576,     0,     0,     0,   579,   580,   581,
     582,   583,   584,     0,   218,     0,     0,   219,    79,    80,
      81,   338,     0,    83,    84,     0,    85,    86,    87,   339,
       0,   340,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   341,     0,   103,     0,   104,
     105,   106,   107,     0,     0,     0,   109,   110,   111,     0,
     112,     0,     0,     0,   342,   343,     0,     0,     0,   600,
     601,     0,     0,     0,     0,   602,     0,     0,     0,     0,
       0,     0,     0,     0,   603,     0,   604,     0,   605,   606,
       0,   344,   345,   346,   347,   348,   349,   350,   816,   352,
       0,     0,     0,     0,     0,     0,     0,   360,   361,   362,
       0,   363,   364,   365,     0,   132,     0,   134,     0,     0,
     367,   368,     0,   369,     0,     0,   372,   607,   135,   373,
       0,   375,   376,   377,   378,   139,     0,     0,   381,   382,
     383,     0,   385,   386,   142,   387,     0,   389,   390,     0,
       0,     0,     0,     0,   395,   396,   397,   398,   399,   148,
     149,   400,     0,   402,     0,   404,     0,   405,   406,   407,
       0,     0,     0,   411,   412,   413,   414,     0,   416,   417,
       0,   419,     0,   421,   422,   423,   156,   424,     0,   158,
       0,   426,   427,   160,     0,   429,     0,   431,     0,     0,
       0,   433,     0,   434,     0,     0,   437,     0,   439,   440,
       0,   441,   442,   443,     0,   444,   445,   446,   447,     0,
       0,   449,     0,   450,   451,   452,     0,   169,     0,   170,
       0,     0,     0,     0,   455,     0,   456,   457,   458,   459,
       0,     0,   461,     0,     0,   463,   464,   465,   466,   467,
     468,   469,   470,   471,   472,   473,   474,   475,   476,     0,
     181,     0,   478,   479,   480,   481,   182,     0,   483,   484,
       0,     0,   185,   186,   486,     0,     0,   489,     0,     0,
       0,   493,   494,     0,     0,   497,     0,     0,     0,   498,
     499,   500,   501,   502,     0,   189,   503,   504,   505,     0,
     507,   508,   509,   510,   511,   191,   512,     0,   514,   515,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   197,
     524,   525,   526,   527,   528,     0,     0,   530,   531,   817,
       0,   534,   200,   535,   536,     0,   537,   203,     0,   539,
     540,   541,   542,   543,   544,   545,   546,   205,   547,     0,
     549,   550,   551,     0,   818,   207,     0,   554,     0,   819,
     208,   557,   209,     0,   559,   560,   561,   562,     0,     0,
     564,   565,   566,   567,   568,     0,     0,   571,   572,   573,
     216,   574,     0,   575,   576,     0,     0,     0,   579,   580,
     581,   582,   583,   584,     0,   218,     0,     0,   219,    79,
      80,    81,   338,     0,    83,    84,     0,    85,    86,    87,
     339,     0,   340,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   341,     0,   103,     0,
     104,   105,   106,   107,     0,     0,     0,   109,   110,   111,
       0,   112,     0,     0,     0,   342,   343,     0,     0,     0,
     600,   601,     0,     0,     0,     0,   602,     0,     0,     0,
       0,     0,     0,     0,     0,   603,     0,   604,     0,   605,
     606,     0,   344,   345,   346,   347,   348,   349,   350,   837,
     352,     0,     0,     0,     0,     0,     0,     0,   360,   361,
     362,     0,   363,   364,   365,     0,   132,     0,   134,     0,
       0,   367,   368,     0,   369,     0,     0,   372,   607,   135,
     373,     0,   375,   376,   377,   378,   139,     0,     0,   381,
     382,   383,     0,   385,   386,   142,   387,     0,   389,   390,
       0,     0,     0,     0,     0,   395,   396,   397,   398,   399,
     148,   149,   400,     0,   402,     0,   404,     0,   405,   406,
     407,     0,     0,     0,   411,   412,   413,   414,     0,   416,
     417,     0,   419,     0,   421,   422,   423,   156,   424,     0,
     158,     0,   426,   427,   160,     0,   429,     0,   431,     0,
       0,     0,   433,     0,   434,     0,     0,   437,     0,   439,
     440,     0,   441,   442,   443,     0,   444,   445,   446,   447,
       0,     0,   449,     0,   450,   451,   452,     0,   169,     0,
     170,     0,     0,     0,     0,   455,     0,   456,   457,   458,
     459,     0,     0,   461,     0,     0,   463,   464,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,   475,   476,
       0,   181,     0,   478,   479,   480,   481,   182,     0,   483,
     484,     0,     0,   185,   186,   486,     0,     0,   489,     0,
       0,     0,   493,   494,     0,     0,   497,     0,     0,     0,
     498,   499,   500,   501,   502,     0,   189,   503,   504,   505,
       0,   507,   508,   509,   510,   511,   191,   512,     0,   514,
     515,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     197,   524,   525,   526,   527,   528,     0,     0,   530,   531,
     838,     0,   534,   200,   535,   536,     0,   537,   203,     0,
     539,   540,   541,   542,   543,   544,   545,   546,   205,   547,
       0,   549,   550,   551,     0,   839,   207,     0,   554,     0,
     840,   208,   557,   209,     0,   559,   560,   561,   562,     0,
       0,   564,   565,   566,   567,   568,     0,     0,   571,   572,
     573,   216,   574,     0,   575,   576,     0,     0,     0,   579,
     580,   581,   582,   583,   584,     0,   218,     0,     0,   219,
      79,    80,    81,   338,     0,    83,    84,     0,    85,    86,
      87,   339,     0,   340,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   341,     0,   103,
       0,   104,   105,   106,   107,     0,     0,     0,   109,   110,
     111,     0,   112,     0,     0,     0,   342,   343,     0,     0,
       0,   600,   601,     0,     0,     0,     0,   602,     0,     0,
       0,     0,     0,     0,     0,     0,   603,     0,   604,     0,
     605,   606,     0,   344,   345,   346,   347,   348,   349,   350,
    1180,   352,     0,     0,     0,     0,     0,     0,     0,   360,
     361,   362,     0,   363,   364,   365,     0,   132,     0,   134,
       0,     0,   367,   368,     0,   369,     0,     0,   372,   607,
     135,   373,     0,   375,   376,   377,   378,   139,     0,     0,
     381,   382,   383,     0,   385,   386,   142,   387,     0,   389,
     390,     0,     0,     0,     0,     0,   395,   396,   397,   398,
     399,   148,   149,   400,     0,   402,     0,   404,     0,   405,
     406,   407,     0,     0,     0,   411,   412,   413,   414,     0,
     416,   417,     0,   419,     0,   421,   422,   423,   156,   424,
       0,   158,     0,   426,   427,   160,     0,   429,     0,   431,
       0,     0,     0,   433,     0,   434,     0,     0,   437,     0,
     439,   440,     0,   441,   442,   443,     0,   444,   445,   446,
     447,     0,     0,   449,     0,   450,   451,   452,     0,   169,
       0,   170,     0,     0,     0,     0,   455,     0,   456,   457,
     458,   459,     0,     0,   461,     0,     0,   463,   464,   465,
     466,   467,   468,   469,   470,   471,   472,   473,   474,   475,
     476,     0,   181,     0,   478,   479,   480,   481,   182,     0,
     483,   484,     0,     0,   185,   186,   486,     0,     0,   489,
       0,     0,     0,   493,   494,     0,     0,   497,     0,     0,
       0,   498,   499,   500,   501,   502,     0,   189,   503,   504,
     505,     0,   507,   508,   509,   510,   511,   191,   512,     0,
     514,   515,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   197,   524,   525,   526,   527,   528,     0,     0,   530,
     531,   532,     0,   534,   200,   535,   536,     0,   537,   203,
       0,   539,   540,   541,   542,   543,   544,   545,   546,   205,
     547,     0,   549,   550,   551,     0,   206,   207,     0,   554,
       0,   556,   208,   557,   209,     0,   559,   560,   561,   562,
       0,     0,   564,   565,   566,   567,   568,     0,     0,   571,
     572,   573,   216,   574,     0,   575,   576,     0,     0,     0,
     579,   580,   581,   582,   583,   584,     0,   218,     0,     0,
     219,    79,    80,    81,   338,     0,    83,    84,     0,    85,
      86,    87,   339,     0,   340,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   341,     0,
     103,     0,   104,   105,   106,   107,     0,     0,     0,   109,
     110,   111,     0,   112,     0,     0,     0,   342,   343,     0,
       0,     0,   600,   601,     0,     0,     0,     0,   602,     0,
       0,     0,     0,     0,     0,     0,     0,   603,     0,   604,
       0,   605,   606,     0,   344,   345,   346,   347,   348,   349,
     350,     0,   352,     0,     0,     0,     0,     0,     0,     0,
     360,   361,   362,  1189,   363,   364,   365,     0,   132,     0,
     134,     0,     0,   367,   368,     0,   369,     0,     0,   372,
     607,   135,  1190,     0,   375,   376,   377,   378,   139,     0,
       0,   381,   382,   383,     0,   385,   386,   142,   387,     0,
     389,   390,     0,     0,     0,     0,     0,   395,   396,   397,
     398,   399,   148,   149,   400,     0,   402,     0,   404,     0,
     405,   406,   407,     0,     0,     0,   411,   412,   413,   414,
       0,   416,   417,     0,   419,     0,   421,   422,   423,   156,
     424,     0,   158,     0,   426,   427,   160,     0,   429,     0,
     431,     0,     0,     0,   433,     0,   434,     0,     0,   437,
       0,   439,   440,     0,   441,   442,   443,     0,   444,   445,
     446,   447,     0,     0,   449,     0,   450,   451,   452,     0,
     169,     0,   170,     0,     0,     0,     0,   455,     0,   456,
     457,   458,   459,     0,     0,   461,     0,     0,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     831,   476,     0,   181,     0,   478,   479,   480,   481,   182,
       0,   483,   484,     0,     0,   185,   186,   486,     0,     0,
     489,     0,     0,     0,   493,   494,     0,     0,   497,     0,
       0,     0,   498,   499,   500,   501,   502,     0,   189,   503,
     504,   505,     0,   507,   508,   509,   510,   511,   191,   512,
       0,   514,   515,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   197,   524,   525,   526,   527,   528,     0,     0,
     530,   531,  1184,     0,   534,   200,   535,   536,     0,   537,
     203,     0,   539,   540,   541,   542,   543,   544,   545,   546,
     205,   547,     0,   549,   550,   551,     0,   833,   207,     0,
     554,     0,   834,   208,   557,   209,     0,   559,   560,   561,
     562,     0,     0,   564,   565,   566,   567,   568,     0,     0,
     571,   572,   573,   216,   574,     0,   575,   576,     0,     0,
       0,   579,   580,   581,   582,   583,   584,     0,   218,     0,
       0,   219,    79,    80,    81,   338,     0,    83,    84,     0,
      85,    86,    87,   339,     0,   340,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   341,
       0,   103,     0,   104,   105,   106,   107,     0,     0,     0,
     109,   110,   111,     0,   112,     0,     0,     0,   342,   343,
       0,     0,     0,   600,   601,     0,     0,     0,     0,   602,
       0,     0,     0,     0,     0,     0,     0,     0,   603,     0,
     604,     0,   605,   606,     0,   344,   345,   346,   347,   348,
     349,   350,     0,   352,     0,     0,     0,     0,     0,     0,
       0,   360,   361,   362,     0,   363,   364,   365,     0,   132,
       0,   134,     0,     0,   367,   368,     0,   369,     0,     0,
     372,   607,   135,   373,     0,   375,   376,   377,   378,   139,
       0,     0,   381,   382,   383,     0,   385,   386,   142,   387,
       0,   389,   390,     0,     0,     0,     0,     0,   395,   396,
     397,   398,   399,   148,   149,   400,     0,   402,     0,   404,
       0,   405,   406,   407,     0,     0,     0,   411,   412,   413,
     414,     0,   416,   417,     0,   419,     0,   421,   422,   423,
     156,   424,     0,   158,     0,   426,   427,   160,     0,   429,
       0,   431,     0,     0,     0,   433,     0,   434,     0,  2203,
     437,     0,   439,   440,     0,   441,   442,   443,     0,   444,
     445,   446,   447,     0,     0,   449,     0,   450,   451,   452,
       0,   169,     0,   170,     0,     0,     0,     0,   455,     0,
     456,   457,   458,   459,     0,     0,   461,     0,     0,   463,
     464,   465,   466,   467,   468,   469,   470,   471,   472,   473,
     474,   475,   476,     0,   181,     0,   478,   479,   480,   481,
     182,     0,   483,   484,     0,     0,   185,   186,   486,     0,
       0,   489,     0,     0,     0,   493,   494,     0,     0,   497,
       0,     0,     0,   498,   499,   500,   501,   502,     0,   189,
     503,   504,   505,     0,   507,   508,   509,   510,   511,   191,
     512,     0,   514,   515,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   197,   524,   525,   526,   527,   528,     0,
       0,   530,   531,   532,     0,   534,   200,   535,   536,     0,
     537,   203,     0,   539,   540,   541,   542,   543,   544,   545,
     546,   205,   547,     0,   549,   550,   551,     0,   206,   207,
       0,   554,     0,   556,   208,   557,   209,     0,   559,   560,
     561,   562,     0,     0,   564,   565,   566,   567,   568,     0,
       0,   571,   572,   573,   216,   574,     0,   575,   576,     0,
       0,     0,   579,   580,   581,   582,   583,   584,     0,   218,
       0,     0,   219,    79,    80,    81,   338,     0,    83,    84,
       0,    85,    86,    87,   339,     0,   340,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     341,     0,   103,     0,   104,   105,   106,   107,     0,     0,
       0,   109,   110,   111,     0,   112,     0,     0,     0,   342,
     343,     0,     0,     0,   600,   601,     0,     0,     0,     0,
     602,     0,     0,     0,     0,     0,     0,     0,     0,   603,
       0,   604,     0,   605,   606,     0,   344,   345,   346,   347,
     348,   349,   350,     0,   352,     0,     0,     0,     0,     0,
       0,     0,   360,   361,   362,     0,   363,   364,   365,     0,
     132,     0,   134,     0,     0,   367,   368,     0,   369,     0,
       0,   372,   607,   135,   373,     0,   375,   376,   377,   378,
     139,     0,     0,   381,   382,   383,     0,   385,   386,   142,
     387,     0,   389,   390,     0,     0,     0,     0,     0,   395,
     396,   397,   398,   399,   148,   149,   400,  2435,   402,     0,
     404,     0,   405,   406,   407,     0,     0,     0,   411,   412,
     413,   414,     0,   416,   417,     0,   419,     0,   421,   422,
     423,   156,   424,     0,   158,     0,   426,   427,   160,     0,
     429,     0,   431,     0,     0,     0,   433,     0,   434,     0,
       0,   437,     0,   439,   440,     0,   441,   442,   443,     0,
     444,   445,   446,   447,     0,     0,   449,     0,   450,   451,
     452,     0,   169,     0,   170,     0,     0,     0,     0,   455,
       0,   456,   457,   458,   459,     0,     0,   461,     0,     0,
     463,   464,   465,   466,   467,   468,   469,   470,   471,   472,
     473,   474,   475,   476,     0,   181,     0,   478,   479,   480,
     481,   182,     0,   483,   484,     0,     0,   185,   186,   486,
       0,     0,   489,     0,     0,     0,   493,   494,     0,     0,
     497,     0,     0,     0,   498,   499,   500,   501,   502,     0,
     189,   503,   504,   505,     0,   507,   508,   509,   510,   511,
     191,   512,     0,   514,   515,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   197,   524,   525,   526,   527,   528,
       0,     0,   530,   531,   532,     0,   534,   200,   535,   536,
       0,   537,   203,     0,   539,   540,   541,   542,   543,   544,
     545,   546,   205,   547,     0,   549,   550,   551,     0,   206,
     207,     0,   554,     0,   556,   208,   557,   209,     0,   559,
     560,   561,   562,     0,     0,   564,   565,   566,   567,   568,
       0,     0,   571,   572,   573,   216,   574,     0,   575,   576,
       0,     0,     0,   579,   580,   581,   582,   583,   584,     0,
     218,     0,     0,   219,    79,    80,    81,   338,     0,    83,
      84,     0,    85,    86,    87,   339,     0,   340,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   341,     0,   103,     0,   104,   105,   106,   107,     0,
       0,     0,   109,   110,   111,     0,   112,     0,     0,     0,
     342,   343,     0,     0,     0,   600,   601,     0,     0,     0,
       0,   602,     0,     0,     0,     0,     0,     0,     0,     0,
     603,     0,   604,     0,   605,   606,     0,   344,   345,   346,
     347,   348,   349,   350,     0,   352,     0,     0,     0,     0,
       0,     0,     0,   360,   361,   362,     0,   363,   364,   365,
       0,   132,     0,   134,     0,     0,   367,   368,     0,   369,
       0,     0,   372,   607,   135,   373,     0,   375,   376,   377,
     378,   139,     0,     0,   381,   382,   383,     0,   385,   386,
     142,   387,     0,   389,   390,     0,     0,     0,     0,     0,
     395,   396,   397,   398,   399,   148,   149,   400,  2437,   402,
       0,   404,     0,   405,   406,   407,     0,     0,     0,   411,
     412,   413,   414,     0,   416,   417,     0,   419,     0,   421,
     422,   423,   156,   424,     0,   158,     0,   426,   427,   160,
       0,   429,     0,   431,     0,     0,     0,   433,     0,   434,
       0,     0,   437,     0,   439,   440,     0,   441,   442,   443,
       0,   444,   445,   446,   447,     0,     0,   449,     0,   450,
     451,   452,     0,   169,     0,   170,     0,     0,     0,     0,
     455,     0,   456,   457,   458,   459,     0,     0,   461,     0,
       0,   463,   464,   465,   466,   467,   468,   469,   470,   471,
     472,   473,   474,   475,   476,     0,   181,     0,   478,   479,
     480,   481,   182,     0,   483,   484,     0,     0,   185,   186,
     486,     0,     0,   489,     0,     0,     0,   493,   494,     0,
       0,   497,     0,     0,     0,   498,   499,   500,   501,   502,
       0,   189,   503,   504,   505,     0,   507,   508,   509,   510,
     511,   191,   512,     0,   514,   515,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   197,   524,   525,   526,   527,
     528,     0,     0,   530,   531,   532,     0,   534,   200,   535,
     536,     0,   537,   203,     0,   539,   540,   541,   542,   543,
     544,   545,   546,   205,   547,     0,   549,   550,   551,     0,
     206,   207,     0,   554,     0,   556,   208,   557,   209,     0,
     559,   560,   561,   562,     0,     0,   564,   565,   566,   567,
     568,     0,     0,   571,   572,   573,   216,   574,     0,   575,
     576,     0,     0,     0,   579,   580,   581,   582,   583,   584,
       0,   218,     0,     0,   219,    79,    80,    81,   338,     0,
      83,    84,     0,    85,    86,    87,   339,     0,   340,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   341,     0,   103,     0,   104,   105,   106,   107,
       0,     0,     0,   109,   110,   111,     0,   112,     0,     0,
       0,   342,   343,     0,     0,     0,   600,   601,     0,     0,
       0,     0,   602,     0,     0,     0,     0,     0,     0,     0,
       0,   603,     0,   604,     0,   605,   606,     0,   344,   345,
     346,   347,   348,   349,   350,     0,   352,     0,     0,     0,
       0,     0,  2577,     0,   360,   361,   362,     0,   363,   364,
     365,     0,   132,     0,   134,     0,     0,   367,   368,     0,
     369,     0,     0,   372,   607,   135,   373,     0,   375,   376,
     377,   378,   139,     0,     0,   381,   382,   383,     0,   385,
     386,   142,   387,     0,   389,   390,     0,     0,     0,     0,
       0,   395,   396,   397,   398,   399,   148,   149,   400,     0,
     402,     0,   404,     0,   405,   406,   407,     0,     0,     0,
     411,   412,   413,   414,     0,   416,   417,     0,   419,     0,
     421,   422,   423,   156,   424,     0,   158,     0,   426,   427,
     160,     0,   429,     0,   431,     0,     0,     0,   433,     0,
     434,     0,     0,   437,     0,   439,   440,     0,   441,   442,
     443,     0,   444,   445,   446,   447,     0,     0,   449,     0,
     450,   451,   452,     0,   169,     0,   170,     0,     0,     0,
       0,   455,     0,   456,   457,   458,   459,     0,     0,   461,
       0,     0,   463,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   474,   475,   476,     0,   181,     0,   478,
     479,   480,   481,   182,     0,   483,   484,     0,     0,   185,
     186,   486,     0,     0,   489,     0,     0,     0,   493,   494,
       0,     0,   497,     0,     0,     0,   498,   499,   500,   501,
     502,     0,   189,   503,   504,   505,     0,   507,   508,   509,
     510,   511,   191,   512,     0,   514,   515,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   197,   524,   525,   526,
     527,   528,     0,     0,   530,   531,   532,     0,   534,   200,
     535,   536,     0,   537,   203,     0,   539,   540,   541,   542,
     543,   544,   545,   546,   205,   547,     0,   549,   550,   551,
       0,   206,   207,     0,   554,     0,   556,   208,   557,   209,
       0,   559,   560,   561,   562,     0,     0,   564,   565,   566,
     567,   568,     0,     0,   571,   572,   573,   216,   574,     0,
     575,   576,     0,     0,     0,   579,   580,   581,   582,   583,
     584,     0,   218,     0,     0,   219,    79,    80,    81,   338,
       0,    83,    84,     0,    85,    86,    87,   339,     0,   340,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   341,     0,   103,     0,   104,   105,   106,
     107,     0,     0,     0,   109,   110,   111,     0,   112,     0,
       0,     0,   342,   343,     0,     0,     0,   600,   601,     0,
       0,     0,     0,   602,     0,     0,     0,     0,     0,     0,
       0,     0,   603,     0,   604,     0,   605,   606,     0,   344,
     345,   346,   347,   348,   349,   350,     0,   352,     0,     0,
       0,     0,     0,  2591,     0,   360,   361,   362,     0,   363,
     364,   365,     0,   132,     0,   134,     0,     0,   367,   368,
       0,   369,     0,     0,   372,   607,   135,   373,     0,   375,
     376,   377,   378,   139,     0,     0,   381,   382,   383,     0,
     385,   386,   142,   387,     0,   389,   390,     0,     0,     0,
       0,     0,   395,   396,   397,   398,   399,   148,   149,   400,
       0,   402,     0,   404,     0,   405,   406,   407,     0,     0,
       0,   411,   412,   413,   414,     0,   416,   417,     0,   419,
       0,   421,   422,   423,   156,   424,     0,   158,     0,   426,
     427,   160,     0,   429,     0,   431,     0,     0,     0,   433,
       0,   434,     0,     0,   437,     0,   439,   440,     0,   441,
     442,   443,     0,   444,   445,   446,   447,     0,     0,   449,
       0,   450,   451,   452,     0,   169,     0,   170,     0,     0,
       0,     0,   455,     0,   456,   457,   458,   459,     0,     0,
     461,     0,     0,   463,   464,   465,   466,   467,   468,   469,
     470,   471,   472,   473,   474,   475,   476,     0,   181,     0,
     478,   479,   480,   481,   182,     0,   483,   484,     0,     0,
     185,   186,   486,     0,     0,   489,     0,     0,     0,   493,
     494,     0,     0,   497,     0,     0,     0,   498,   499,   500,
     501,   502,     0,   189,   503,   504,   505,     0,   507,   508,
     509,   510,   511,   191,   512,     0,   514,   515,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   197,   524,   525,
     526,   527,   528,     0,     0,   530,   531,   532,     0,   534,
     200,   535,   536,     0,   537,   203,     0,   539,   540,   541,
     542,   543,   544,   545,   546,   205,   547,     0,   549,   550,
     551,     0,   206,   207,     0,   554,     0,   556,   208,   557,
     209,     0,   559,   560,   561,   562,     0,     0,   564,   565,
     566,   567,   568,     0,     0,   571,   572,   573,   216,   574,
       0,   575,   576,     0,     0,     0,   579,   580,   581,   582,
     583,   584,     0,   218,     0,     0,   219,    79,    80,    81,
     338,     0,    83,    84,     0,    85,    86,    87,   339,     0,
     340,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   341,     0,   103,     0,   104,   105,
     106,   107,     0,     0,     0,   109,   110,   111,     0,   112,
       0,     0,     0,   342,   343,     0,     0,     0,   600,   601,
       0,     0,     0,     0,   602,     0,     0,     0,     0,     0,
       0,     0,     0,   603,     0,   604,     0,   605,   606,     0,
     344,   345,   346,   347,   348,   349,   350,     0,   352,     0,
       0,     0,     0,     0,     0,     0,   360,   361,   362,     0,
     363,   364,   365,     0,   132,     0,   134,     0,     0,   367,
     368,     0,   369,     0,     0,   372,   607,   135,   373,     0,
     375,   376,   377,   378,   139,     0,     0,   381,   382,   383,
       0,   385,   386,   142,   387,     0,   389,   390,     0,     0,
       0,     0,     0,   395,   396,   397,   398,   399,   148,   149,
     400,     0,   402,     0,   404,     0,   405,   406,   407,     0,
       0,     0,   411,   412,   413,   414,     0,   416,   417,     0,
     419,     0,   421,   422,   423,   156,   424,     0,   158,     0,
     426,   427,   160,     0,   429,     0,   431,     0,     0,     0,
     433,     0,   434,     0,     0,   437,     0,   439,   440,     0,
     441,   442,   443,     0,   444,   445,   446,   447,     0,     0,
     449,     0,   450,   451,   452,     0,   169,     0,   170,     0,
       0,     0,     0,   455,     0,   456,   457,   458,   459,     0,
       0,   461,     0,     0,   463,   464,   465,   466,   467,   468,
     469,   470,   471,   472,   473,   474,   475,   476,     0,   181,
       0,   478,   479,   480,   481,   182,     0,   483,   484,     0,
       0,   185,   186,   486,     0,     0,   489,     0,     0,     0,
     493,   494,     0,     0,   497,     0,     0,     0,   498,   499,
     500,   501,   502,     0,   189,   503,   504,   505,     0,   507,
     508,   509,   510,   511,   191,   512,     0,   514,   515,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   197,   524,
     525,   526,   527,   528,     0,     0,   530,   531,   532,     0,
     534,   200,   535,   536,     0,   537,   203,     0,   539,   540,
     541,   542,   543,   544,   545,   546,   205,   547,     0,   549,
     550,   551,     0,   206,   207,     0,   554,     0,   556,   208,
     557,   209,     0,   559,   560,   561,   562,     0,     0,   564,
     565,   566,   567,   568,     0,     0,   571,   572,   573,   216,
     574,     0,   575,   576,     0,     0,     0,   579,   580,   581,
     582,   583,   584,     0,   218,     0,     0,   219,    79,    80,
      81,   338,     0,    83,    84,     0,    85,    86,    87,   339,
       0,   340,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   341,     0,   103,     0,   104,
     105,   106,   107,     0,     0,     0,   109,   110,   111,     0,
     112,     0,     0,     0,   342,   343,     0,     0,     0,   600,
     601,     0,     0,     0,     0,   602,     0,     0,     0,     0,
       0,     0,     0,     0,   603,     0,   604,     0,   605,   606,
       0,   344,   345,   346,   347,   348,   349,   350,     0,   352,
       0,     0,     0,     0,     0,     0,     0,   360,   361,   362,
       0,   363,   364,   365,     0,   132,     0,   134,     0,     0,
     367,   368,     0,   369,     0,     0,   372,   607,   135,   373,
       0,   375,   376,   377,   378,   139,     0,     0,   381,   382,
     383,     0,   385,   386,   142,   387,     0,   389,   390,     0,
       0,     0,     0,     0,   395,   396,   397,   398,   399,   148,
     149,   400,     0,   402,     0,   404,     0,   405,   406,   407,
       0,     0,     0,   411,   412,   413,   414,     0,   416,   417,
       0,   419,     0,   421,   422,   423,   156,   424,     0,   158,
       0,   426,   427,   160,     0,   429,     0,   431,     0,     0,
       0,   433,     0,   434,     0,     0,   437,     0,   439,   440,
       0,   441,   442,   443,     0,   444,   445,   446,   447,     0,
       0,   449,     0,   450,   451,   452,     0,   169,     0,   170,
       0,     0,     0,     0,   455,     0,   456,   457,   458,   459,
       0,     0,   461,     0,     0,   463,   464,   465,   466,   467,
     468,   469,   470,   471,   472,   473,   474,   475,   476,     0,
     181,     0,   478,   479,   480,   481,   182,     0,   483,   484,
       0,     0,   185,   186,   486,     0,     0,   489,     0,     0,
       0,   493,   494,     0,     0,   497,     0,     0,     0,   498,
     499,   500,   501,   502,     0,   189,   503,   504,   505,     0,
     507,   508,   509,   510,   511,   191,   512,     0,   514,   515,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   197,
     524,   525,   526,   527,   528,     0,     0,   530,   531,   532,
       0,   534,   200,   535,   536,     0,   537,   203,     0,   539,
     540,   735,   542,   543,   544,   545,   546,   205,   547,     0,
     549,   550,   551,     0,   206,   207,     0,   554,     0,   556,
     208,   557,   209,     0,   559,   560,   561,   562,     0,     0,
     564,   565,   566,   567,   568,     0,     0,   571,   572,   573,
     216,   574,     0,   575,   576,     0,     0,     0,   579,   580,
     581,   582,   583,   584,     0,   218,     0,     0,   219,    79,
      80,    81,   338,     0,    83,    84,     0,    85,    86,    87,
     339,     0,   340,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   341,     0,   103,     0,
     104,   105,   106,   107,     0,     0,     0,   109,   110,   111,
       0,   112,     0,     0,     0,   342,   343,     0,     0,     0,
     600,   601,     0,     0,     0,     0,   602,     0,     0,     0,
       0,     0,     0,     0,     0,   603,     0,   604,     0,   605,
     606,     0,   344,   345,   346,   347,   348,   349,   350,     0,
     352,     0,     0,     0,     0,     0,     0,     0,   360,   361,
     362,     0,   363,   364,   365,     0,   132,     0,   134,     0,
       0,   367,   368,     0,   369,     0,     0,   372,   607,   135,
     373,     0,   375,   376,   377,   378,   139,     0,     0,   381,
     382,   383,     0,   385,   386,   142,   387,     0,   389,   390,
       0,     0,     0,     0,     0,   395,   396,   397,   398,   399,
     148,   149,   400,     0,   402,     0,   404,     0,   405,   406,
     407,     0,     0,     0,   411,   412,   413,   414,     0,   416,
     417,     0,   419,     0,   421,   422,   423,   156,   424,     0,
     158,     0,   426,   427,   160,     0,   429,     0,   431,     0,
       0,     0,   433,     0,   434,     0,     0,   437,     0,   439,
     440,     0,   441,   442,   443,     0,   444,   445,   446,   447,
       0,     0,   449,     0,   450,   451,   452,     0,   169,     0,
     170,     0,     0,     0,     0,   455,     0,   456,   457,   458,
     459,     0,     0,   461,     0,     0,   463,   464,   465,   466,
     467,   468,   469,   470,   471,   472,   473,   474,   831,   476,
       0,   181,     0,   478,   479,   480,   481,   182,     0,   483,
     484,     0,     0,   185,   186,   486,     0,     0,   489,     0,
       0,     0,   493,   494,     0,     0,   497,     0,     0,     0,
     498,   499,   500,   501,   502,     0,   189,   503,   504,   505,
       0,   507,   508,   509,   510,   511,   191,   512,     0,   514,
     515,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     197,   524,   525,   526,   527,   528,     0,     0,   530,   531,
    1184,     0,   534,   200,   535,   536,     0,   537,   203,     0,
     539,   540,   541,   542,   543,   544,   545,   546,   205,   547,
       0,   549,   550,   551,     0,   833,   207,     0,   554,     0,
     834,   208,   557,   209,     0,   559,   560,   561,   562,     0,
       0,   564,   565,   566,   567,   568,     0,     0,   571,   572,
     573,   216,   574,     0,   575,   576,     0,     0,     0,   579,
     580,   581,   582,   583,   584,     0,   218,     0,     0,   219,
    1282,    80,    81,   338,     0,    83,    84,     0,    85,    86,
      87,   339,     0,   340,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   341,     0,   103,
       0,   104,   105,   106,   107,     0,     0,     0,   109,   110,
     111,     0,   112,     0,     0,     0,   342,   343,     0,     0,
       0,   600,   601,     0,     0,     0,     0,   602,     0,     0,
       0,     0,     0,     0,     0,     0,   603,     0,   604,     0,
     605,   606,     0,   344,   345,   346,   347,   348,   349,   350,
       0,   352,     0,     0,     0,     0,     0,     0,     0,   360,
     361,   362,     0,   363,   364,   365,     0,   132,     0,   134,
       0,     0,   367,   368,     0,   369,     0,     0,   372,   607,
     135,   373,     0,   375,   376,   377,   378,   139,     0,     0,
     381,   382,   383,     0,   385,   386,   142,   387,     0,   389,
     390,     0,     0,     0,     0,     0,   395,   396,   397,   398,
     399,   148,   149,   400,     0,   402,     0,   404,     0,   405,
     406,   407,     0,     0,     0,   411,   412,   413,   414,     0,
     416,   417,     0,   419,     0,   421,   422,   423,   156,   424,
       0,   158,     0,   426,   427,   160,     0,   429,     0,   431,
       0,     0,     0,   433,     0,   434,     0,     0,   437,     0,
     439,   440,     0,   441,   442,   443,     0,   444,   445,   446,
     447,     0,     0,   449,     0,   450,   451,   452,     0,   169,
       0,   170,     0,     0,     0,     0,   455,     0,   456,   457,
     458,   459,     0,     0,   461,     0,     0,   463,   464,   465,
     466,   467,   468,   469,   470,   471,   472,   473,   474,   475,
     476,     0,   181,     0,   478,   479,   480,   481,   182,     0,
     483,   484,     0,     0,   185,   186,   486,     0,     0,   489,
       0,     0,     0,   493,   494,     0,     0,   497,     0,     0,
       0,   498,   499,   500,   501,   502,     0,   189,   503,   504,
     505,     0,   507,   508,   509,   510,   511,   191,   512,     0,
     514,   515,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   197,   524,   525,   526,   527,   528,     0,     0,   530,
     531,   532,     0,   534,   200,   535,   536,     0,   537,   203,
       0,   539,   540,   541,   542,   543,   544,   545,   546,   205,
     547,     0,   549,   550,   551,     0,   206,   207,     0,   554,
       0,   556,   208,   557,   209,     0,   559,   560,   561,   562,
       0,     0,   564,   565,   566,   567,   568,     0,     0,   571,
     572,   573,   216,   574,     0,   575,   576,     0,     0,     0,
     579,   580,   581,   582,   583,   584,     0,   218,     0,     0,
     219,    79,    80,    81,     0,     0,    83,    84,     0,    85,
      86,    87,     0,     0,     0,    90,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,     0,     0,
     103,     0,   104,   105,   106,   107,     0,   108,     0,   109,
     110,   111,     0,   112,   113,   114,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   129,     0,     0,     0,   131,   132,   133,
     134,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   135,     0,     0,     0,     0,     0,     0,   139,     0,
       0,     0,     0,     0,     0,     0,     0,   142,     0,     0,
       0,     0,   145,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   148,   149,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   152,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   156,
       0,     0,   158,     0,     0,     0,   160,     0,     0,     0,
       0,   161,     0,   162,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   165,     0,     0,     0,   166,     0,     0,
       0,     0,     0,   167,     0,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,   171,   172,     0,   173,     0,
       0,     0,     0,     0,   174,     0,   175,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   180,   181,     0,     0,     0,     0,     0,   182,
       0,     0,     0,   184,     0,   185,   186,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   187,
     188,     0,     0,     0,     0,     0,     0,     0,   189,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   191,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     195,     0,   197,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   200,     0,     0,   202,     0,
     203,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     205,     0,     0,     0,     0,     0,     0,   206,   207,     0,
       0,     0,     0,   208,     0,   209,     0,     0,     0,     0,
       0,   212,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   216,     0,   217,     0,    79,    80,    81,
       0,     0,    83,    84,     0,    85,    86,    87,   218,     0,
       0,   219,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,     0,     0,   103,     0,   104,   105,
     106,   107,     0,     0,     0,   109,   110,   111,     0,   112,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   129,
       0,     0,     0,   131,   132,   133,   134,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   135,     0,     0,
       0,     0,     0,     0,   139,     0,     0,     0,     0,     0,
       0,     0,     0,   142,     0,     0,     0,     0,   145,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   148,   149,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   156,     0,     0,   158,     0,
       0,     0,   160,     0,     0,     0,     0,   161,     0,   162,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   165,
       0,     0,     0,   166,     0,     0,     0,     0,     0,   167,
       0,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,   171,   172,     0,   173,     0,     0,     0,     0,     0,
     174,     0,   175,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   180,   181,
       0,     0,     0,     0,     0,   182,     0,     0,     0,   184,
       0,   185,   186,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   187,   188,     0,     0,     0,
       0,     0,     0,     0,   189,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   191,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   195,     0,   197,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   200,     0,     0,   202,     0,   203,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   205,     0,     0,     0,
       0,     0,     0,   206,   207,     0,     0,     0,     0,   208,
       0,   209,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   216,
       0,   217,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   218,     0,     0,   219
};

static const short yycheck[] =
{
       2,   159,   713,    77,    82,    74,   220,    74,   829,    90,
      77,  1029,    74,   155,    90,   675,    90,   677,   807,  1004,
     666,   179,  1363,    90,  1389,  1010,    74,    77,   676,   842,
     599,   214,   113,   886,    74,  1757,   747,   113,   920,   113,
    1154,   210,  1117,  1157,  1945,   128,   113,  1270,   190,   709,
      90,   674,  1379,  1379,  1379,   678,   589,   679,  1148,   707,
     720,  1761,    74,   146,   686,  2001,    74,   729,  1827,    74,
      74,  1127,    77,   113,  1534,  1464,  1536,  1978,   826,  2201,
     703,   920,  1727,  1728,  1405,    90,    77,  2023,  2154,   711,
    1411,   763,  1710,   715,   742,  1645,  1043,    25,   758,   177,
     722,  1043,  1463,  1464,  2336,  2337,  1715,  1716,   113,    26,
       2,  2331,  1403,  1474,  1475,   738,   915,   830,   894,   832,
      51,   744,   784,   745,  1084,  1085,  1053,  1054,  1542,   828,
    1680,   212,    74,   755,  1684,    77,   212,   670,   212,   903,
     904,  1502,    43,  1103,    93,   212,   111,  2064,    90,  1510,
     111,   220,   221,  2131,    78,    85,     8,   159,    78,   221,
     729,   668,    14,    15,    16,   116,  2655,   650,    78,   122,
     116,   113,   212,    97,    26,    27,    28,   179,    30,    31,
      32,   134,  1791,    92,   116,    37,    38,    39,  1529,  2276,
      82,   760,   202,    92,   187,   163,   118,    89,   844,    86,
    1093,   131,   165,   150,    91,   150,    44,   212,    46,   221,
    1571,    86,   155,   221,   144,   784,    91,   221,   111,   178,
    1770,    29,   189,    29,    34,    78,     2,   104,  1155,   264,
      29,   161,   134,   259,    74,   294,   128,   304,   344,   134,
     155,   144,    41,   134,   150,    86,   268,    78,   163,   218,
      91,   262,   152,   307,   146,     0,   304,    74,   240,   189,
      74,   972,   184,   193,   304,  1321,    97,   262,   218,   212,
     212,   150,   197,   344,   113,  1350,   143,    86,   222,   156,
     134,   220,    91,   155,  2931,   177,   307,   376,   377,   395,
     192,   376,   347,  1316,   336,   955,   226,   192,   145,   304,
     259,   192,   205,   262,   376,   377,   149,  1325,    78,  1365,
    1192,    83,    78,   307,    58,   240,   115,    18,  2965,   408,
     157,   363,    83,   378,   277,  2792,    87,    97,   267,   414,
     312,    97,    76,   993,    81,   329,   408,   302,   192,   269,
     361,   302,   309,   966,   415,    86,  2247,   970,   292,   408,
     197,   319,   150,   259,   408,  1015,    78,   379,   384,   259,
    2580,   387,   304,  1386,  2584,   287,    78,   220,  2588,   314,
     285,  1031,   239,   212,   241,  1393,   255,  1337,  1338,   414,
     310,   221,   259,   187,  1344,   315,    78,   312,   265,   220,
     221,   163,   351,   240,  1017,   364,   243,   408,    90,   358,
     210,  1515,   163,    92,   414,   372,   214,   337,   214,   302,
    2110,   374,    92,   408,   364,   214,   269,   255,   361,   349,
     307,   414,   367,   369,   171,  2914,   150,   258,   138,   936,
     913,  2518,   284,   363,   337,   357,   364,   384,   384,   326,
     387,   387,  2420,  2421,  2422,  2423,  2424,  1340,   401,   414,
     220,   326,   384,   414,  1230,   387,   387,   408,    78,   408,
    2377,  2378,   408,   408,  1755,   312,   176,  1266,  2018,    78,
     387,  1418,  1248,   183,   402,  1417,   408,   218,  1177,  1178,
     404,   401,   402,   403,   404,   326,   387,   304,  1252,   361,
     304,  1905,  1906,  1907,   404,  1909,  2105,   406,   220,  1426,
    1069,   684,   354,   213,   347,  1619,  2124,   406,   220,   411,
    1831,  1832,   586,  2745,   409,   589,   411,   326,   409,   586,
     411,   408,   589,  2990,    83,   608,   298,   364,   220,  2749,
    1490,  1491,   385,   380,  2754,   378,   586,   298,  2758,  1211,
     344,   589,   395,   396,   397,   314,   399,   400,   401,   402,
     403,   404,   218,   150,   737,  2173,   409,   269,   319,  1973,
     307,   408,   314,  1924,  1925,  1926,  1927,   150,   399,   400,
     401,   402,   403,   404,   321,  2960,  1289,   269,   104,   406,
    2130,   586,   171,   410,   589,   666,   384,   187,   730,   387,
     666,    86,   666,   155,  2660,   586,   670,   171,   111,   666,
     220,  1962,  1315,   670,   163,   292,   764,  2759,   766,  2761,
     768,   220,   984,   411,  2999,   367,   774,   775,  1439,   159,
    1441,  1442,   670,   364,   104,  2249,   666,   267,  2848,   399,
     400,   401,   402,   403,   404,   401,   402,   403,   404,   408,
    3025,  2002,  2003,    78,   586,   188,   387,   589,   650,   269,
     212,   392,   218,  2277,  1443,  1027,   408,  1713,   255,   400,
     384,   666,   142,   387,   950,   670,   218,  2789,   392,   218,
     411,  2012,   255,   385,   361,   961,   218,   399,   400,   401,
     402,   403,   404,   395,   396,   397,  1332,   399,   400,   401,
     402,   403,   404,   385,   149,   118,   218,   409,   364,  2851,
     155,  2401,  2402,   395,   396,   397,   129,   399,   400,   401,
     402,   403,   404,  2472,   337,   255,   608,   406,   277,   118,
     409,   410,   262,   218,   666,   414,   406,   159,   670,   409,
     410,   211,   321,   330,   414,   278,   333,    78,   251,   218,
     338,   152,   340,   150,  2065,  1278,  1860,   321,   414,    90,
     192,   150,   314,   831,  1414,   129,   170,   212,   650,  2404,
     319,   184,   764,   844,   766,   385,   768,   202,   844,   232,
     844,   251,   774,   775,  2095,  2096,   150,   844,   145,   399,
     400,   401,   402,   403,   404,   220,  1497,   189,  1410,   302,
     399,   400,   401,   402,   403,   404,   207,  1679,   364,   361,
    1621,   264,   216,    98,   844,   154,   319,    86,   102,    18,
     217,  1664,   364,   166,   152,   364,   182,  1440,  1291,  1567,
    1934,   240,   117,   255,   243,   903,   904,   259,   235,   347,
     197,   311,  1305,  1851,   269,   145,   154,  2226,  2298,   844,
    1679,   188,   364,  2257,   255,   411,  2260,  2261,  2262,  2263,
    2264,  2265,  2266,  2267,  2268,  2269,   255,   145,   272,   314,
     259,  2182,   411,  2184,   287,  2186,   232,   269,  1721,   364,
     219,  1724,  1725,   240,   650,  2425,   243,   387,  1934,   220,
     159,   255,   392,   236,   886,   364,   145,   197,   287,   411,
    2304,   411,   387,   312,  1540,   172,   295,   392,   264,   409,
     153,   219,   844,   153,   198,   400,   361,  2021,   202,   197,
     912,   913,    93,   915,  1286,   155,   411,   255,   920,  1133,
       5,    78,  2622,  2623,   277,   776,   203,  2288,   269,   110,
     240,   333,   411,   243,   357,   411,   828,   231,   197,   831,
      97,  2031,   356,   153,    29,   312,   199,    35,   155,   199,
     385,  2887,   240,   408,    84,   243,    41,   808,   357,  1037,
     395,   396,   397,  2899,   399,   400,   401,   402,   403,   404,
     100,   124,   212,   683,   684,  1044,   383,   384,   370,   386,
     387,   240,  1044,   118,   315,   392,   339,   394,   141,   199,
     125,   412,   702,   400,   129,   176,  1065,   298,   182,   300,
    1372,   154,   312,  1065,    47,   212,   337,   187,   104,  1078,
     387,   903,   904,   380,   411,   392,   256,   257,   319,   200,
     912,   913,   202,   915,   312,   408,  1095,  2441,   920,   323,
     115,  1403,  1044,   385,  2124,  1407,  1044,   409,  2797,  1499,
    1044,  1689,   414,   196,   385,   226,   142,   292,   232,   184,
     257,   416,  1121,   312,   395,   396,   397,  1135,   399,   400,
     401,   402,   403,   404,  1133,   407,   383,   188,  1146,   386,
     380,   316,   414,   387,   314,   376,   387,  2978,   392,  1701,
     264,  1614,  1542,   387,   409,  2426,   400,   208,   392,   414,
     394,   801,   380,  1715,  1716,  1717,   400,   807,   408,  1759,
    1760,   369,   223,   384,  1262,   815,   387,   314,   229,   409,
     886,  1189,    88,    89,   414,   211,   384,   407,  1740,   387,
    1742,   361,   303,   338,   414,   340,  2453,  2453,  2453,   214,
    1313,   263,   313,   843,   412,   267,   912,   913,   848,   915,
     408,   406,  2365,   408,   920,  1037,   327,  2561,  1217,  1218,
     860,  1220,   287,   334,   361,   251,   125,  1231,  1232,   170,
     129,  2482,  1229,   364,  1231,  1232,  1538,  1250,   408,  1791,
     214,   182,  1794,   764,  1252,   766,  2290,   768,  1840,  2293,
      21,  1843,  2503,   774,   305,   384,   409,    40,   387,  1229,
    1192,   414,   373,  1090,  1091,  1197,  1198,  2010,   298,   384,
     300,   408,   387,   120,  1278,   216,  2281,  2282,  2549,   408,
     410,  1278,  2033,   331,   332,   311,  1113,   267,  1285,   319,
      78,   232,   357,   408,  1229,  1122,  1231,  1232,   267,   384,
    1278,  2084,   387,  2594,  1945,  1449,   409,  2090,  2091,  1241,
     408,   414,  2124,  1135,   349,  1285,   406,   409,   408,   109,
     299,  1332,   414,   264,  1146,   965,  1332,   338,  1332,   340,
    1262,   272,   137,   159,  1266,  1332,   384,  1978,  1270,   387,
     290,  1840,   384,  1278,  1843,   387,  1217,  1218,   205,  1220,
    1285,    93,   178,   143,   226,  1177,  1178,  1229,   131,  1231,
    1232,  3013,  1332,   376,   377,   408,   408,  1189,   110,   289,
    1192,   384,  1012,  1013,   387,  1197,  1198,   384,   267,  1019,
     387,  1389,  2726,   188,  2728,    78,  2681,   145,  1476,  1924,
    1478,  1926,  1927,   409,  1482,   408,   384,  1332,   414,   387,
    1488,   408,   384,   208,    97,   387,  1278,  1495,   384,   102,
     409,   387,   411,  1285,   204,   356,   137,  1505,   223,  1507,
     408,   414,   384,  1063,   229,   387,   408,   187,  1250,   255,
    1252,    98,   220,   259,   176,   392,   262,   394,  1526,   197,
    1528,   338,   247,   340,  1266,   381,   408,  2000,  1270,   239,
    1449,   241,   222,  1755,   384,  1757,   384,   387,   200,   387,
    1332,   251,   267,   376,   377,   409,   270,   188,   409,  1771,
     414,   384,  2050,  2764,   387,  1783,  1784,  1785,   408,  1487,
     408,   269,   240,   409,   226,   243,  1192,   208,   414,   267,
    2834,  1197,  1198,   409,   384,   408,  2767,   387,   414,   381,
     305,   409,   223,  1435,   384,    78,   414,   387,   229,   202,
     384,   301,   392,   387,   394,  1905,  1906,  1907,   408,  1909,
     400,   384,    98,  1825,   387,   351,   247,   220,   221,  1540,
     411,  1530,   358,   414,  1540,  1241,  1540,  1536,   328,  1217,
    1218,   222,  1220,  1540,  1476,  1544,  1478,  2123,   401,   411,
    1482,   381,   414,  2105,   312,   411,  1488,   118,   414,   364,
    1266,   303,   319,  1495,  1270,   258,  1206,  1389,   129,   409,
    1540,   313,   186,  1505,   414,  1507,   269,   382,   411,   411,
      78,   414,   409,  1973,   305,   327,  1594,   414,   409,   150,
     409,   152,   334,   414,  1526,   414,  1528,   385,   409,    97,
     409,  2892,   411,   414,   102,  1540,  2247,   395,   396,   397,
    1614,   399,   400,   401,   402,   403,   404,  1614,   409,   862,
      82,   864,   380,   414,   409,   383,   384,    89,   386,   387,
      92,   373,   409,   409,   376,   409,  1614,   414,   414,  2585,
     102,  2587,    86,  1647,  2234,  1649,   207,   220,  2201,   108,
    1647,   401,  1649,   412,   399,   400,   401,   402,   403,   386,
     387,   382,  1670,  1751,   409,  1487,   128,  1647,  1540,  1649,
     399,   400,   401,   402,   403,   137,   138,   409,   407,  1614,
     413,   414,   414,   214,   146,   147,  2730,   412,   150,   168,
    1778,    93,   385,   155,   255,   344,   269,   159,   259,   344,
     198,   344,  1790,   344,   202,   344,   399,   400,   401,   402,
     403,   404,  1647,   409,  1649,   409,   108,   179,   414,   409,
     414,   416,   220,   221,   414,   409,   287,   364,   190,   214,
     414,   193,  1664,   231,   295,   409,   409,   199,   409,   201,
     414,   414,  1614,   414,   401,   402,   403,  1679,   220,  1681,
    1758,  1683,   344,  1761,   115,   116,   409,  1765,   409,   298,
     258,   414,   409,   414,  1908,   409,   408,   414,  1408,  1409,
     414,   269,  1594,   298,   409,  1647,   409,  1649,  2331,   414,
      85,   414,   409,   409,   408,  1873,   408,   414,   414,  1721,
     408,  2093,  1724,  1725,   413,   414,   357,  1306,  1307,  1308,
     408,   191,   408,  1443,    85,  1813,   376,   377,  1952,   376,
     377,   410,   385,  1453,    95,   135,   136,   298,  1962,  1751,
     125,   267,  1462,   396,   397,   323,   399,   400,   401,   402,
     403,   404,   113,   376,   377,   376,   377,  2862,  2863,   144,
     411,  1773,  2035,  2036,   376,   235,  1778,   118,  1670,   408,
     131,   905,   906,   376,    93,  2157,   161,  1679,  1790,  1681,
     376,  1683,   376,   144,   226,   375,  2168,  2257,   408,   267,
    2260,  2261,  2262,  2263,  2264,  2265,  2266,  2267,  2268,  2269,
     161,   271,   202,  2185,   189,  2187,   408,   385,   267,    43,
     414,   183,   230,   182,   267,   408,  1995,  1996,   396,   397,
     205,   399,   400,   401,   402,   403,   404,   408,   189,  1908,
     284,  2826,   193,  2303,  2304,   408,   408,   408,   408,   408,
     408,   408,   408,  2011,   205,   408,  1566,   269,  1750,    93,
    2232,   408,   252,   253,   408,   408,  1758,   408,   408,  1761,
     408,  1873,   408,  1765,   230,  1944,   222,   414,   338,   182,
     340,  1773,   230,  1952,  2256,   220,  1955,   408,  1664,   279,
     401,   214,     7,  1962,   269,   312,    11,   414,   243,   149,
     363,   410,   414,  1679,   408,  1681,  1975,  1683,    23,    24,
    1620,  2283,   372,   408,   408,   344,   344,   344,   269,   298,
     344,  1813,  1991,   363,   363,   344,   364,   125,   344,   377,
      45,  2000,   345,    48,   309,   310,   267,   344,   344,   290,
     315,  2313,   408,   408,   220,  1721,   336,   267,  1724,  1725,
     265,   408,   408,   408,   369,   408,    93,  2580,   309,   310,
      84,  2584,   337,   150,   315,  2588,    98,   408,   182,   267,
      93,  2129,   408,   385,   349,   311,   366,  2995,   364,   354,
      93,  2441,   218,   395,   396,   397,   337,   399,   400,   401,
     402,   403,   404,    18,   414,   120,    18,   372,   349,   395,
     414,   344,   367,   354,   414,   408,   408,   374,   409,  2011,
     342,   406,   363,   342,    78,  2017,   409,  2806,   319,   202,
    2841,   372,   414,   408,   342,   408,   408,   344,   187,   230,
    2851,   347,  2110,   414,   216,   409,   414,   268,   232,  2181,
     262,   409,  2123,   406,    40,   160,   224,  2123,   402,  2123,
     224,   409,   259,  2676,   120,   408,  2123,   259,   408,   344,
     108,   265,   337,   298,  2142,   193,   360,   599,   220,   395,
     384,   344,   406,   344,   395,   182,   608,   267,   271,    93,
    2452,  2239,  2084,  2123,   194,  2906,   303,  2245,  2090,  2091,
      93,   196,   196,   182,   626,   627,   409,    12,   409,  1809,
     242,  2561,   414,   187,  1814,   409,   414,   414,  2322,  2178,
     409,   187,  2181,   409,   409,   381,  2178,  2331,  2123,  2181,
     409,   409,  2124,   410,   414,  2017,  2749,  2129,   409,  2131,
     409,  2754,   409,   381,   187,  2758,   381,   409,   259,  2141,
     409,   409,  2211,   675,   676,   677,   409,   679,   680,  2211,
     682,  2811,   134,   685,   686,  2324,  2325,  2326,  2327,   187,
     409,   408,   408,   344,   128,   409,  2789,   409,   395,   395,
     292,   411,   704,   155,    36,   707,   409,   709,   298,   711,
     409,  2123,   414,   715,   298,  2557,   718,   408,   720,   344,
     722,   173,   411,   408,   403,   344,   409,   729,   730,   409,
     220,   220,   243,   406,   409,   267,   354,   739,   337,   409,
     742,   372,   408,   745,   409,   414,  2108,   749,  2110,  2297,
     364,   753,   267,   755,   409,  2848,   758,   344,   414,  2889,
     212,   395,  2124,   171,   171,   406,   409,  2239,   168,  2131,
     187,  2017,    78,  2245,   776,   116,   778,   182,   408,  2141,
    2142,   409,   784,  2322,   193,   409,   409,  2415,   409,   984,
     385,   408,  2331,   409,   414,  2888,  2726,  2978,  2728,   408,
     395,   396,   397,   409,   399,   400,   401,   402,   403,   404,
     812,   414,   385,   395,  1994,   984,   344,   354,   344,   220,
     157,   220,   408,   182,   271,   206,   828,   829,   830,   407,
     832,   224,  1027,   225,   192,   187,   408,   408,  2084,   409,
     409,   409,   409,   295,  2090,  2091,   262,   408,   408,   385,
     223,   409,   409,  2401,  2402,   274,   223,   309,  1027,   395,
     396,   397,   314,   399,   400,   401,   402,   403,   404,   408,
     108,   195,   259,   408,   152,   259,   207,   407,  2124,   189,
     189,   364,   187,   164,  2977,   173,   338,   409,   340,   151,
     151,   408,  2734,  2365,   187,   267,   259,   349,   344,   313,
     182,   903,   904,   408,  2834,   907,   270,   408,   223,   361,
     362,   408,   295,    93,   259,   238,   291,  3010,   265,   265,
     408,   414,   408,  2471,   267,   927,   259,  2466,   930,   267,
     409,   933,    96,   182,  2466,  2297,  2408,   267,    93,   127,
     210,   259,   164,  2415,   408,   267,   267,   210,  2420,  2421,
    2422,  2423,  2424,   955,   160,   361,   307,   155,   414,   308,
      82,   963,   213,   173,   308,    82,   291,    89,   408,   221,
     385,   973,   409,  2153,   294,   977,  2150,  2016,   980,  2159,
     395,   396,   397,   985,   399,   400,   401,   402,   403,   404,
    2618,   993,  1373,  1198,  2017,  2094,  1795,  1192,  2460,  1732,
    2388,  2648,  2969,  2365,  2463,  1007,   128,  2061,  2477,  2945,
    2925,  2853,  2924,  1015,  1016,  2950,  1018,  2803,  2879,  2465,
    1781,  3025,  1387,  2999,   146,   147,   724,  2633,  2632,  1031,
    2980,  2123,  1375,   155,  3026,   179,  1462,   159,  2221,  2401,
    2402,  2580,   822,  2494,  1064,  2584,  2071,  2888,  2173,  2588,
    1052,  2599,  1795,  2687,  2866,   177,  1071,   179,  2420,  2421,
    2422,  2423,  2424,  2989,  3024,  1786,  1068,  2015,   190,   157,
    1620,  2212,  1044,  2028,  2622,  2623,  1838,  2037,    78,  2627,
    2488,  1225,  1224,  1617,  2331,  2586,  2849,  1347,  2296,  1500,
      90,  1286,  2458,  1564,  2602,  1975,  1875,    97,  2912,  2557,
    2022,  1296,   102,  2717,  2497,   963,  1673,   910,  1264,  2471,
    1670,  1016,   304,  1232,   596,  2957,    74,  1286,   305,  2365,
     653,  1644,  1069,   937,  2672,  1056,  1845,  1296,  1846,  2677,
     906,  1679,  1176,  2681,  2489,   585,  2352,  1683,  1841,  1433,
     912,     2,    -1,    -1,    -1,    -1,  2618,    -1,    -1,  2329,
    2330,    -1,  1347,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2408,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3013,    -1,    -1,    -1,  1177,  1178,  1372,  1347,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1189,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1197,  1198,    -1,   198,    -1,
      -1,    -1,   202,  1372,    -1,    -1,  1208,    -1,  1403,    -1,
    2749,    -1,  1407,    -1,    -1,  2754,    -1,    -1,    -1,  2758,
     220,   221,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   231,    -1,    -1,  1403,    -1,    85,  2599,  1407,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,  2427,  1250,    -1,
    1252,    -1,    -1,    -1,    -1,   255,    -1,    -1,   258,    -1,
    2622,  2623,    -1,    -1,   113,  2627,    92,  2447,    -1,   269,
      -1,   271,    -1,    -1,  2454,    -1,   102,    -1,  1280,    -1,
     129,    -1,   131,    86,    -1,    -1,    -1,  1289,    -1,    -1,
      -1,  2830,    -1,    -1,    -1,   144,    -1,    -1,  2830,    -1,
      -1,   150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2848,
    2672,   137,   161,  1315,    -1,  2677,    -1,  3001,    -1,  2681,
      -1,   147,    -1,   323,   150,    -1,    -1,  2955,  2956,   155,
      -1,   134,    -1,   159,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   191,  1538,   193,  2893,    -1,    -1,    -1,    -1,
      -1,    -1,   155,   179,    -1,    -1,   205,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   190,    -1,    -1,  2915,  2916,  1538,
     173,    -1,    -1,    -1,    -1,    -1,    -1,   226,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   385,   235,  1389,  2568,  2569,
    2570,  2571,    -1,    -1,    -1,   395,   396,   397,   134,   399,
     400,   401,   402,   403,   404,    -1,    -1,   407,  1410,   212,
      -1,    -1,  1414,    -1,    -1,    -1,   416,  1419,    -1,    -1,
     269,    -1,   271,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   170,    -1,    -1,  1439,    -1,  1441,
    1442,   290,    -1,    -1,    -1,    -1,   182,  1449,    -1,    -1,
    2989,   187,    -1,    -1,    -1,    -1,   192,   193,    -1,   195,
      -1,   310,  3001,    -1,    -1,    -1,   315,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   599,    -1,    -1,
     216,    -1,   984,  2955,  2956,  3024,   608,    -1,   337,   338,
      -1,   340,   295,    -1,    -1,  1497,   232,    -1,    -1,    -1,
     349,    -1,    -1,    -1,   353,   354,   309,    -1,   357,    -1,
      -1,   314,    -1,    -1,   363,  1710,   638,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1027,    -1,    -1,   264,    -1,
      -1,  2893,    -1,    -1,    -1,   338,   272,   340,    -1,    -1,
      -1,  1710,    -1,    -1,    -1,    -1,   349,    -1,    -1,    -1,
      -1,    -1,    -1,  2915,  2916,    -1,    -1,    -1,   361,   362,
    1755,    -1,  1757,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1572,    -1,    -1,    -1,    -1,    -1,  1771,    -1,    -1,    -1,
      -1,    -1,  1584,    -1,    -1,    -1,  1755,    -1,  1757,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   337,  1771,    -1,    -1,    -1,    -1,   729,   730,    -1,
      -1,  2791,    -1,    -1,  1616,    -1,    -1,    -1,    -1,  1621,
     356,    -1,    -1,    -1,    -1,    -1,  2806,    -1,    -1,    -1,
    1825,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   760,   375,
      -1,    -1,   764,    -1,   766,    -1,   768,    -1,    -1,  2829,
      -1,    -1,   774,   775,    -1,    -1,  1825,    -1,    -1,    -1,
      -1,    -1,   784,    -1,    -1,    -1,    -1,    -1,  1670,    -1,
      -1,  1673,    -1,   409,   410,   411,    -1,    -1,    -1,    -1,
    2860,    -1,    -1,    -1,    -1,    -1,  1688,  1689,    -1,    -1,
    1692,    -1,    -1,    -1,    -1,    -1,  1698,    -1,    -1,  1701,
      -1,    -1,    -1,    -1,    78,    -1,   828,    -1,    -1,   831,
      -1,    -1,    -1,  1715,  1716,  1717,  1718,  1719,  1720,    -1,
      -1,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,    -1,
    1732,  1733,  1734,  1735,  1736,    -1,  1738,    -1,  1740,    -1,
    1742,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1759,  1760,    -1,
      -1,    -1,    -1,    -1,   886,    -1,    -1,    -1,    -1,    -1,
     202,  1773,    -1,   599,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   903,   904,    -1,  1286,    -1,    -1,    -1,   220,  1791,
      -1,    -1,  1794,   984,  1296,    -1,    -1,    -1,    -1,    -1,
     626,   627,    -1,  1805,    -1,    -1,    -1,    -1,  1810,    -1,
      -1,    -1,    -1,    -1,    -1,  1817,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   255,   198,  1827,    -1,    -1,   202,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1027,   269,  1840,    -1,
      -1,  1843,    -1,   275,    -1,  1347,   220,   221,    -1,    -1,
      -1,    -1,    -1,  1855,   680,    -1,   682,   231,    -1,   685,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1372,    -1,    -1,    -1,    -1,    -1,  2071,    -1,   704,    -1,
      -1,   255,    -1,    -1,   258,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   718,    -1,    -1,   269,    -1,    -1,  2093,    -1,
      -1,  1403,  2071,   729,   730,  1407,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   739,    -1,  1037,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   749,  2093,    -1,    -1,   753,    -1,  2124,
      -1,    -1,    -1,  1055,  1936,    -1,    -1,    -1,    -1,  1061,
      -1,    -1,    -1,  1945,    -1,    -1,    -1,  1069,    -1,   323,
     776,    -1,   778,   385,    -1,  2124,    -1,    -1,   784,    -1,
      -1,    -1,  2157,   395,   396,   397,    -1,   399,   400,   401,
     402,   403,   404,  2168,    -1,    -1,  1978,    -1,  2173,    -1,
      -1,    -1,    78,    -1,    -1,    -1,   812,    -1,  2157,    -1,
    2185,    -1,  2187,    -1,    -1,    -1,    -1,    -1,    -1,  2168,
      -1,    97,    -1,    -1,  2173,    -1,   102,    -1,    -1,    -1,
      -1,   385,    -1,  1135,    -1,  2017,  2185,    -1,  2187,    -1,
    2022,   395,   396,   397,  1146,   399,   400,   401,   402,   403,
     404,  2033,    -1,    -1,    -1,    -1,  1538,  2232,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2050,    -1,
      -1,  1173,    -1,    -1,    -1,  1177,  1178,    -1,    -1,    -1,
      -1,  2256,  2064,  2232,    -1,    -1,    -1,  1189,    -1,    -1,
    1192,    -1,  2074,    -1,    -1,  1197,  1198,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2256,  2283,    -1,
      -1,    -1,    -1,    -1,    -1,  1286,    -1,    -1,    -1,    -1,
      -1,   927,   198,  2105,   930,  1296,   202,   933,    -1,    -1,
      -1,    -1,    -1,    -1,  2283,    -1,    -1,    -1,  2313,    -1,
      -1,    -1,    -1,    -1,   220,   221,    -1,    -1,  1250,  2131,
    1252,    -1,    -1,    -1,    -1,   231,    -1,    -1,    -1,    -1,
    1262,  2143,  2144,    -1,  2313,    -1,    -1,   973,    -1,    -1,
      -1,   977,    -1,    -1,   980,    -1,  1347,    -1,    -1,   985,
      -1,    -1,   258,    -1,    -1,    -1,    -1,    -1,  2170,    -1,
      -1,    -1,    -1,   269,    -1,    -1,    -1,    -1,    78,  2181,
      -1,  1372,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      90,    -1,  1018,    -1,    -1,    -1,    -1,    97,    -1,    -1,
      -1,  2203,   102,    -1,    -1,    -1,    -1,    -1,  1710,    -1,
    2212,    -1,  1403,    -1,    -1,    -1,  1407,    -1,    -1,  2221,
      -1,    -1,    -1,    -1,    -1,    -1,  1052,   323,    -1,    -1,
      -1,    -1,  2234,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1068,    -1,    -1,  2247,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1755,    -1,  1757,    74,  2452,    -1,    77,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1389,    -1,  1771,
      -1,    89,    90,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2452,    -1,    -1,    -1,    -1,    -1,   385,
      -1,    -1,    -1,    -1,    -1,   113,    -1,    -1,   198,   395,
     396,   397,   202,   399,   400,   401,   402,   403,   404,   984,
     128,  1433,    -1,  1435,    -1,    -1,    -1,    -1,    -1,    -1,
     220,   221,    -1,  1825,    -1,    -1,    -1,    -1,   146,    -1,
    2332,   231,    -1,    -1,  2336,  2337,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1538,    -1,    -1,
      -1,    -1,  1027,    -1,  1476,   255,  1478,    -1,   258,    -1,
    1482,    -1,  2557,    -1,    -1,  1487,  1488,    -1,    -1,   269,
      -1,   271,    -1,  1495,    -1,  2377,  2378,    -1,    -1,    -1,
      -1,    -1,    -1,  1505,    -1,  1507,    -1,    -1,  2557,    -1,
      -1,    -1,  2394,  2395,   212,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1526,    -1,  1528,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2420,  2421,
    2422,  2423,  2424,   323,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2440,    -1,
      -1,    -1,    -1,    -1,  1566,    -1,    -1,    -1,    -1,    -1,
    1572,    -1,    -1,    -1,  1280,    -1,  2458,    -1,  2460,    -1,
      -1,  2463,    -1,  2465,    -1,    -1,    -1,    -1,    -1,    -1,
    2472,    -1,  1594,    -1,    -1,  2477,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   385,   304,    -1,    -1,    -1,
      -1,    -1,  2494,    -1,    -1,   395,   396,   397,    -1,   399,
     400,   401,   402,   403,   404,    -1,    -1,    78,    -1,    -1,
      -1,    -1,    -1,    -1,   414,    -1,    -1,    -1,    -1,  1710,
      -1,    -1,    -1,    -1,    -1,    -1,    97,    -1,    -1,    -1,
      -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2734,
      -1,    -1,  1664,    -1,    -1,    -1,    -1,    -1,  1670,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1755,  2734,  1757,    -1,    -1,  2071,
      -1,    -1,  2574,    -1,    -1,  2577,    -1,    -1,    -1,    -1,
    1771,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2591,
      -1,  2093,    -1,  1419,    -1,    -1,    -1,    -1,   169,  1721,
    2602,    -1,  1724,  1725,  2606,    -1,  2608,    -1,    -1,    -1,
      -1,  1286,  2614,    -1,    -1,    -1,    -1,  2619,    -1,    -1,
      -1,  1296,  2124,    -1,    -1,    -1,    -1,   198,    -1,  1751,
      -1,   202,    -1,    -1,  1825,    -1,  1758,    -1,    -1,  1761,
      -1,    -1,    -1,  1765,    -1,    -1,    -1,    -1,    -1,   220,
     221,  1773,    -1,    -1,    -1,  2157,  1778,    -1,  2853,    -1,
     231,    -1,    -1,    -1,    -1,    -1,  2168,    -1,  1790,    -1,
      -1,  2173,  1347,    -1,  2676,    -1,    -1,    -1,    -1,  2681,
      -1,    -1,    -1,  2185,  2853,  2187,    -1,   258,    -1,    -1,
      -1,  1813,    -1,    -1,    -1,    -1,    -1,  1372,   269,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1840,  1841,
      -1,  1843,  1844,  1845,  1846,    -1,    -1,    -1,  1403,    -1,
    2232,    -1,  1407,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2745,    -1,  2747,  1572,    -1,    -1,    -1,
      -1,  1873,   323,    -1,  2256,    -1,    -1,  2759,  1584,  2761,
      -1,    -1,  2957,    -1,    -1,    -1,    -1,    -1,   586,    -1,
      -1,   589,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2283,    -1,    -1,    -1,    -1,    -1,    -1,  2957,    -1,
     608,    -1,    -1,    -1,    -1,  2797,  2798,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2811,
      -1,  2313,    -1,  2815,   385,    -1,    -1,    -1,  3013,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   399,   400,
     401,   402,   403,   404,    -1,    -1,    -1,    -1,    -1,  2841,
      -1,    -1,    -1,    -1,  3013,    -1,    -1,    -1,   666,  2851,
      -1,    -1,   670,    -1,    -1,    -1,   674,    -1,    -1,    -1,
     678,    -1,  1688,  1538,    -1,    -1,  1692,    -1,    -1,    78,
      -1,    -1,  1698,    -1,    -1,    -1,  2878,    -1,    -1,    -1,
    2071,    90,    -1,    -1,    -1,   703,  2888,  2889,    97,  2011,
      -1,    -1,  1718,   102,  1720,  2017,    -1,    -1,    -1,    -1,
      -1,    -1,  2093,    -1,  2906,    -1,    -1,    -1,  1734,    -1,
    1736,    -1,  1738,    -1,    -1,    -1,    -1,   735,    -1,    -1,
     738,    -1,    -1,    -1,    -1,    -1,   744,    -1,    78,  2931,
      -1,    -1,    -1,  2124,    -1,    -1,    -1,    -1,    -1,    -1,
      90,    -1,    -1,    -1,    -1,    -1,    -1,    97,    -1,    -1,
    2452,    -1,   102,    -1,    -1,    -1,    -1,    -1,  2960,    -1,
      -1,    -1,  2084,  2965,    -1,    -1,  2157,    -1,  2090,  2091,
      -1,    -1,    -1,    -1,    -1,    -1,  2978,  2168,    -1,    -1,
      -1,    -1,  2173,    -1,    -1,    -1,    -1,    -1,  2110,   198,
      -1,    -1,    -1,   202,  2185,    -1,  2187,  2999,    -1,    -1,
      -1,    -1,  2124,    -1,    -1,    -1,    -1,  2129,   826,  2131,
     828,   220,   221,    -1,  1840,   134,    -1,  1843,    -1,  2141,
    2142,    -1,   231,  3025,    -1,    -1,   844,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1710,    -1,    -1,    -1,    -1,
      -1,  2232,    -1,    -1,    -1,    -1,   255,    -1,   198,   258,
      -1,   170,   202,    -1,    -1,  2557,    -1,    -1,    -1,  2181,
     269,    -1,   271,   182,    -1,  2256,    -1,    -1,   187,    -1,
     220,   221,    -1,   192,   193,    -1,   195,    -1,    -1,    -1,
    1755,   231,  1757,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2283,    -1,    -1,    -1,  1771,   216,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   255,    -1,    -1,   258,    -1,
      -1,    -1,    -1,   232,   323,    -1,    -1,  2239,    -1,   269,
      -1,   271,  2313,  2245,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   264,    -1,    -1,   966,    -1,
    1825,    -1,   970,   272,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   984,    -1,    -1,    -1,
      -1,    -1,    -1,   323,    -1,  2297,   385,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   395,   396,   397,    -1,
     399,   400,   401,   402,   403,   404,    -1,    -1,    -1,  1017,
      78,    -1,    -1,    -1,    -1,   414,    -1,    -1,    -1,  1027,
      -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,   337,    97,
      -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2734,    -1,    -1,   385,    -1,   356,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   395,   396,   397,  2074,   399,
     400,   401,   402,   403,   404,    -1,   375,    -1,    -1,   409,
      -1,  2452,    -1,    -1,  1082,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2401,
    2402,    -1,    -1,    -1,    -1,    -1,  1104,    -1,    -1,    -1,
     409,   410,   411,  2415,    -1,    -1,    -1,    -1,  2420,  2421,
    2422,  2423,  2424,    -1,    78,    -1,    -1,    -1,    -1,    -1,
    1128,  1129,    -1,  1131,  1132,  1133,    -1,  2143,  2144,    -1,
     198,    -1,    -1,    97,   202,    -1,    -1,    -1,   102,    -1,
      -1,  1149,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   220,   221,  2170,    -1,    -1,    -1,    -1,  2471,
      -1,  2853,    -1,   231,    -1,  2181,    -1,    -1,    -1,  1177,
    1178,    -1,    -1,    -1,    -1,    -1,  2557,  2489,    -1,    -1,
      -1,    -1,    -1,    -1,  1192,    -1,    -1,   255,    -1,    -1,
     258,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   269,    -1,   271,    -1,   169,  2071,    -1,    -1,    -1,
      -1,  1219,    -1,    -1,  1222,  1223,    -1,    -1,    -1,    -1,
      -1,  1229,    -1,  1231,  1232,    -1,    -1,    -1,  2093,    -1,
      -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,   202,    -1,
      -1,    -1,  1250,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   323,   220,   221,    -1,  2124,
      -1,    -1,    -1,    -1,    -1,  2957,    -1,   231,    -1,    -1,
    1278,    -1,    -1,    -1,    -1,    -1,    -1,  1285,  1286,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2599,  1296,    -1,
      -1,    -1,  2157,    -1,   258,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2168,    -1,   269,  2618,    -1,  2173,    -1,
    2622,  2623,    -1,    -1,    -1,  2627,    -1,   385,    -1,    -1,
    2185,  3013,  2187,   984,  1332,    -1,    -1,   395,   396,   397,
      -1,   399,   400,   401,   402,   403,   404,    -1,    -1,  1347,
      -1,    -1,    -1,    -1,    -1,    -1,   414,    -1,    -1,    -1,
      -1,    -1,    -1,  2734,    -1,    -1,    -1,    -1,    -1,   323,
    2672,    -1,    -1,    -1,  1372,  2677,  1027,  2232,    -1,  2681,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2394,  2395,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2256,    -1,  1401,    -1,  1403,    -1,    -1,    -1,  1407,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2283,    -1,
      -1,   385,    -1,    -1,  2440,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1440,    -1,    -1,   399,   400,   401,   402,   403,
     404,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2313,    -1,
      -1,    -1,    -1,    -1,    -1,  1463,  1464,    -1,    -1,    -1,
      -1,    -1,    -1,  1471,    -1,    78,  1474,  1475,    -1,    -1,
      -1,    -1,  2853,    -1,    -1,    -1,    -1,    90,    -1,  1487,
      -1,    -1,    -1,    -1,    97,    78,  1494,    -1,    -1,   102,
    1498,  1499,  1500,    -1,  1502,    -1,    -1,    90,    -1,    -1,
      -1,  1509,  1510,    -1,    97,  1513,    -1,    -1,    -1,   102,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1538,  1539,  1540,    -1,  1542,  1543,    -1,    -1,    -1,  1547,
      -1,    -1,    -1,  1551,    -1,    -1,  1554,  1555,  1556,  1557,
    1558,  1559,  1560,  1561,  1562,  1563,    -1,    -1,    -1,  1567,
      -1,    77,    -1,  1571,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    90,    -1,  2957,    -1,    -1,    -1,
      -1,  2893,    -1,    -1,    -1,   198,    -1,  2452,    -1,   202,
      -1,    -1,  2608,   984,    -1,    -1,    -1,   113,  2614,    -1,
      -1,    -1,    -1,  2915,  2916,   198,  1614,   220,   221,   202,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   231,    -1,
      -1,    -1,    -1,    -1,    -1,  1286,    -1,   220,   221,    -1,
      -1,    -1,  3013,    -1,    -1,  1296,  1027,    -1,   231,  1647,
      -1,  1649,   255,  2955,  2956,   258,    -1,    -1,  2960,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   269,    -1,   271,    -1,
      -1,    -1,   255,    -1,    -1,   258,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   269,    -1,   271,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1347,  2999,    -1,    -1,
      -1,    -1,  2557,    -1,  1702,    -1,   212,    -1,    -1,    -1,
      -1,    -1,  1710,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     323,  1372,    -1,  3025,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     323,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1403,    -1,    -1,    -1,  1407,  1755,    -1,  1757,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1769,    -1,  1771,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   385,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   395,   396,   397,    -1,   399,   400,   401,   402,
     403,   404,   385,    -1,    -1,    -1,   409,    -1,    -1,    -1,
      78,    -1,   395,   396,   397,    -1,   399,   400,   401,   402,
     403,   404,    90,    -1,    -1,    -1,   409,  1825,    -1,    97,
      -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1857,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2878,    -1,    -1,    -1,  1874,    -1,    -1,  2734,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1538,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1286,    -1,  1905,  1906,  1907,
    1908,  1909,    -1,    -1,    -1,  1296,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1924,  1925,  1926,  1927,
     198,    -1,    -1,    -1,   202,    -1,    -1,  1935,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1947,
      -1,    -1,   220,   221,  1952,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   231,  1962,    -1,  1347,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1973,  1974,    -1,  1976,    -1,
      -1,    -1,  1980,    -1,    -1,    -1,    -1,   255,    -1,    -1,
     258,  1372,    -1,    -1,    -1,    -1,    -1,    -1,  2853,    -1,
      -1,   269,  2000,   271,  2002,  2003,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1403,    -1,    -1,    -1,  1407,    -1,    -1,    -1,
    2028,    -1,    -1,    -1,    -1,    -1,    -1,  2035,  2036,  2037,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   323,    -1,    78,    -1,  1710,
      -1,    -1,  2060,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2071,    -1,    -1,    97,    -1,    -1,    -1,
     586,   102,    -1,   589,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2093,    -1,    -1,    -1,    -1,
      -1,    -1,  2957,    -1,  1755,    -1,  1757,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   385,    -1,    -1,
    1771,    -1,    -1,    -1,    -1,  2123,  2124,   395,   396,   397,
      -1,   399,   400,   401,   402,   403,   404,   984,    -1,    -1,
      -1,   409,    -1,    -1,    -1,    -1,    -1,    -1,   169,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1538,  3013,  2157,
     666,    -1,    -1,    -1,   670,    -1,    -1,    -1,   674,    -1,
    2168,    -1,   678,    -1,  1825,  2173,    -1,   198,    -1,    -1,
    1027,   202,    -1,    -1,    -1,    -1,    -1,  2185,    -1,  2187,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   703,    -1,   220,
     221,    -1,    -1,  2201,    -1,    -1,    -1,    -1,    -1,    -1,
     231,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      78,    -1,    -1,    -1,    -1,  2223,    -1,    -1,    -1,    -1,
      -1,  2229,   738,    -1,  2232,    -1,    -1,   258,   744,    97,
      -1,    -1,    -1,  2241,   102,  2243,    -1,    -1,   269,    -1,
    2248,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2256,  2257,
      -1,    -1,  2260,  2261,  2262,  2263,  2264,  2265,  2266,  2267,
    2268,  2269,    -1,    -1,    -1,    -1,  2274,  2275,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2283,    -1,    -1,    -1,    -1,
    2288,    -1,    -1,  2291,    78,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   323,    -1,    -1,  2303,  2304,  2305,    -1,  2307,
      -1,   169,    -1,    97,    -1,  2313,  2314,    -1,   102,    -1,
     826,  2319,    -1,    -1,  2322,    -1,    -1,    -1,    -1,  1710,
      -1,    -1,    -1,  2331,    -1,    -1,    -1,    -1,   844,    -1,
     198,    -1,    -1,    -1,   202,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2357,
      -1,    -1,   220,   221,   385,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   231,  1755,    -1,  1757,    -1,   399,   400,
     401,   402,   403,   404,    -1,   169,    -1,    -1,    -1,    -1,
    1771,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     258,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   269,    -1,    -1,   198,    -1,    -1,    -1,   202,    -1,
    2071,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   220,   221,    -1,  1286,
      -1,    -1,  2093,  2441,  1825,    -1,   984,   231,    -1,  1296,
      -1,    -1,    -1,    -1,  2452,    -1,    -1,    -1,    -1,    -1,
     966,    -1,    -1,    -1,   970,   323,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2124,   258,    -1,    -1,    -1,   984,    -1,
      -1,    -1,    -1,    -1,    -1,   269,    -1,    -1,    -1,  1027,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2497,
    1347,    -1,    -1,    -1,    -1,    -1,  2157,    -1,    -1,  2507,
      -1,  1017,    -1,    -1,    -1,    -1,    -1,  2168,    -1,    -1,
      -1,  1027,  2173,    -1,    -1,  1372,    -1,   385,    -1,    -1,
      -1,    -1,    -1,    -1,  2185,    -1,  2187,    -1,    -1,   323,
      -1,   399,   400,   401,   402,   403,   404,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    78,  1403,    -1,    -1,  2557,
    1407,    -1,    -1,  2561,  2562,  2563,    -1,    90,  2566,    -1,
      -1,    -1,    -1,    -1,    97,    -1,  1082,    -1,    -1,   102,
      -1,  2232,  2580,    -1,    -1,    -1,  2584,    -1,    -1,    -1,
    2588,    -1,    -1,    -1,    -1,    -1,  2594,    -1,  1104,    -1,
      -1,   385,    -1,    -1,    -1,  2256,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   399,   400,   401,   402,   403,
     404,    -1,  1128,  1129,    -1,  1131,  1132,  1133,    -1,    -1,
      -1,    -1,  2283,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1149,    -1,    -1,    -1,    -1,    -1,  2647,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2313,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   198,    -1,    -1,  2676,   202,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2071,  1538,    -1,    -1,    -1,    -1,    -1,   220,   221,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   231,    -1,
      -1,    -1,  2093,  1219,    -1,    -1,  1222,  1223,    -1,  2717,
      -1,    -1,    -1,    -1,    -1,  1231,  1232,    -1,  2726,    -1,
    2728,    -1,   255,    -1,    -1,   258,  2734,    -1,    -1,    -1,
    2738,    -1,    -1,  2124,    -1,    -1,   269,    -1,  1286,    -1,
      -1,  2749,    -1,    -1,    -1,    -1,  2754,    -1,  1296,    -1,
    2758,    -1,    -1,    -1,    -1,    -1,  2764,  2765,    -1,    -1,
    2768,    -1,  1278,    -1,    -1,    -1,  2157,    -1,    -1,    -1,
    1286,    -1,    -1,    -1,    -1,    -1,    -1,  2168,    -1,    -1,
    1296,  2789,  2173,    78,    -1,    -1,    -1,    -1,    -1,    -1,
     323,  2452,    -1,    -1,  2185,    90,  2187,    -1,    -1,  1347,
      -1,    -1,    97,    -1,  2812,    -1,    -1,   102,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1332,    -1,    -1,    78,
      -1,    -1,    -1,    -1,  1372,    -1,  2834,    -1,    -1,    -1,
      -1,  1347,    -1,    -1,    -1,    -1,  2844,    -1,    97,    -1,
    2848,  2232,    -1,   102,    -1,  2853,    -1,    -1,    -1,    -1,
      -1,    -1,   385,  1710,    -1,  1403,  1372,    -1,    -1,  1407,
      -1,    -1,   395,   396,   397,  2256,   399,   400,   401,   402,
     403,   404,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2888,    -1,    -1,    -1,  2892,  1401,    -1,  1403,    -1,    -1,
      -1,  1407,  2283,    -1,    -1,    -1,  2557,    -1,  1755,    -1,
    1757,    -1,    -1,   198,  2912,    -1,    -1,   202,    -1,    -1,
     169,    -1,    -1,    -1,  1771,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2313,    -1,  1440,   220,   221,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   231,    -1,    -1,   198,
      -1,    -1,    -1,   202,    -1,    -1,    -1,  1463,  1464,  2957,
      -1,    -1,    -1,    -1,    -1,  1471,    -1,    -1,  1474,  1475,
     255,   220,   221,   258,    -1,    -1,    -1,    -1,  1825,  2977,
      -1,    -1,   231,    -1,   269,    -1,   271,    -1,  1494,    -1,
      -1,    -1,  1498,  1499,  1500,    -1,  1502,    -1,    -1,    -1,
    1538,    -1,    -1,  1509,  1510,    -1,    -1,  1513,    -1,   258,
      -1,    -1,  3010,    -1,    -1,  3013,    -1,    -1,    -1,    -1,
     269,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1538,  1539,  1540,    -1,  1542,  1543,   323,    -1,
      -1,  1547,    -1,    -1,    -1,  1551,    -1,    -1,  1554,  1555,
    1556,  1557,  1558,  1559,  1560,  1561,  1562,  1563,    -1,    -1,
      -1,  1567,    -1,    -1,    -1,  1571,    -1,    -1,    -1,    -1,
      -1,  2452,    -1,    -1,   323,    -1,    90,    -1,    -1,    -1,
      -1,    -1,    -1,  2734,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   113,
     385,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1614,    -1,
     395,   396,   397,    -1,   399,   400,   401,   402,   403,   404,
      -1,    -1,    -1,    -1,   409,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   385,    -1,    -1,    -1,
      -1,  1647,    -1,  1649,    -1,    -1,    -1,    -1,    -1,    -1,
     399,   400,   401,   402,   403,   404,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1710,    -1,    -1,    -1,  2557,    -1,    -1,    -1,
      -1,    78,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    90,    -1,    -1,  1702,    -1,   212,    -1,
      97,    -1,  2853,    -1,  1710,   102,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1755,    -1,  1757,
      -1,    -1,    -1,    -1,  2071,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1771,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2093,    -1,    -1,  1755,
      -1,  1757,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1769,    -1,  1771,    -1,    -1,    -1,    -1,
      -1,    78,    -1,    -1,    -1,    -1,    -1,  2124,    -1,    -1,
      -1,    -1,    -1,    90,    -1,    -1,    -1,  1825,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,
      -1,   198,    -1,    -1,    -1,   202,  2957,    -1,    -1,    -1,
    2157,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1825,
      -1,  2168,    -1,   220,   221,    -1,  2173,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   231,    -1,    -1,    -1,  2185,    -1,
    2187,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1857,    -1,  2734,    -1,    -1,    -1,    -1,   255,    -1,
      -1,   258,  3013,    -1,    -1,    -1,    -1,    -1,  1874,    -1,
      -1,    -1,   269,    -1,   271,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2232,    -1,    -1,    -1,    -1,
      -1,   198,    -1,    -1,    -1,   202,    -1,    -1,    -1,  1905,
    1906,  1907,  1908,  1909,    -1,    -1,    -1,    -1,    -1,  2256,
      -1,    -1,    -1,   220,   221,    -1,    -1,    -1,  1924,  1925,
    1926,  1927,    -1,    -1,   231,    -1,   323,    -1,    -1,  1935,
      -1,    -1,    -1,    -1,    -1,    -1,  2283,    -1,    -1,    -1,
      -1,  1947,    -1,    -1,    -1,    -1,  1952,    -1,   255,    -1,
      -1,   258,    -1,    -1,    -1,    -1,  1962,    -1,    -1,    -1,
      -1,    -1,   269,    -1,   271,    -1,  2313,  1973,  1974,    -1,
    1976,    -1,  2853,    -1,  1980,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   385,    -1,
      -1,    -1,    -1,    -1,  2000,    -1,  2002,  2003,   395,   396,
     397,    -1,   399,   400,   401,   402,   403,   404,    -1,    -1,
      -1,    -1,   409,    -1,    -1,    -1,   323,    -1,    -1,    -1,
      -1,    -1,  2028,    -1,    -1,    -1,    -1,    -1,    -1,  2035,
    2036,  2037,    -1,  2071,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    78,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2060,  2093,    -1,    90,    -1,    -1,
      -1,    -1,    -1,    -1,    97,  2071,    -1,    -1,    -1,   102,
      -1,    -1,    -1,    -1,    -1,    -1,  2957,    -1,   385,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2124,  2093,   395,   396,
     397,    -1,   399,   400,   401,   402,   403,   404,    -1,    -1,
      -1,    -1,   409,    -1,    -1,  2452,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2123,  2124,  2157,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2168,    -1,  3013,    -1,    -1,  2173,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2185,    -1,  2187,
      -1,  2157,   666,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     674,    -1,  2168,    -1,   678,   198,    -1,  2173,    -1,   202,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2185,
      -1,  2187,    -1,    -1,    -1,    -1,    -1,   220,   221,   703,
      -1,    -1,    -1,    -1,  2232,  2201,    -1,    -1,   231,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2557,    -1,    -1,    -1,    -1,    -1,    -1,  2223,  2256,    -1,
      -1,    -1,   255,  2229,   738,   258,  2232,    -1,    -1,    -1,
     744,    -1,    -1,    -1,    -1,  2241,   269,  2243,   271,    -1,
      -1,    -1,  2248,    -1,    -1,  2283,    -1,    -1,    -1,    -1,
    2256,  2257,    -1,    -1,  2260,  2261,  2262,  2263,  2264,  2265,
    2266,  2267,  2268,  2269,    -1,    -1,    -1,    -1,  2274,  2275,
      -1,    -1,    -1,    -1,    -1,  2313,    -1,  2283,    -1,    -1,
      -1,    -1,  2288,    -1,    -1,  2291,    -1,    -1,    -1,    -1,
     323,    -1,    -1,    -1,    -1,    -1,    -1,  2303,  2304,  2305,
      -1,  2307,    -1,    -1,    -1,    78,    -1,  2313,  2314,    -1,
      -1,    -1,   826,  2319,    -1,    -1,  2322,    90,    -1,    -1,
      -1,    -1,    -1,    -1,    97,  2331,    -1,    -1,    -1,   102,
     844,    -1,    -1,    -1,    -1,    78,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,
      -1,  2357,   385,    -1,    97,    -1,    -1,    -1,    -1,   102,
      -1,    -1,   395,   396,   397,    -1,   399,   400,   401,   402,
     403,   404,    -1,    -1,    -1,    -1,   409,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2734,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2452,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,   202,
      -1,    -1,    -1,    -1,    -1,  2441,    -1,    -1,    -1,   182,
      -1,    -1,    -1,    -1,   187,    -1,  2452,   220,   221,    -1,
      -1,    -1,   966,    -1,    -1,   198,   970,    -1,   231,   202,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     984,    -1,    -1,    -1,    -1,    -1,    82,   220,   221,    -1,
      -1,    -1,   255,    89,    -1,   258,    -1,    -1,   231,    -1,
      -1,  2497,    -1,    -1,    -1,    -1,   269,    -1,   271,    -1,
      -1,  2507,    -1,  1017,    -1,    -1,  2853,    -1,    -1,    -1,
      -1,    -1,   255,  1027,    -1,   258,    -1,    -1,    -1,  2557,
      -1,    -1,   128,    -1,    -1,    -1,   269,    -1,   271,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     146,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     323,  2557,    -1,   159,    -1,  2561,  2562,  2563,    -1,    -1,
    2566,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1082,    -1,
      -1,   177,    -1,   179,  2580,    -1,    -1,    -1,  2584,    -1,
     323,    -1,  2588,    -1,    -1,    -1,    -1,    -1,  2594,    -1,
    1104,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2957,    -1,   385,    -1,  1128,  1129,    -1,  1131,  1132,  1133,
      -1,    78,   395,   396,   397,    -1,   399,   400,   401,   402,
     403,   404,    -1,    90,   407,  1149,    -1,    94,    -1,    -1,
      97,  2647,   385,    -1,    -1,   102,    -1,    -1,    -1,    -1,
      -1,    -1,   395,   396,   397,    -1,   399,   400,   401,   402,
     403,   404,    -1,    -1,    -1,    -1,  3013,    -1,    -1,    -1,
    2676,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2734,    -1,    -1,    -1,
      -1,   158,    -1,    -1,    -1,  1219,    -1,    -1,  1222,  1223,
      -1,  2717,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2726,    -1,  2728,    -1,    -1,    -1,    -1,    -1,  2734,    -1,
      -1,    -1,  2738,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   198,    -1,  2749,    -1,   202,    -1,    -1,  2754,    -1,
      -1,    -1,  2758,    -1,    -1,    -1,    -1,    -1,  2764,  2765,
      -1,    -1,  2768,   220,   221,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1286,    -1,   231,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1296,  2789,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   255,    -1,
      -1,   258,    -1,    -1,    -1,    -1,  2812,    -1,    -1,    -1,
      78,    -1,   269,    -1,   271,  2853,    -1,    -1,  1332,    -1,
      -1,    -1,    90,    -1,    -1,    93,    -1,    -1,  2834,    97,
      -1,    -1,    -1,  1347,   102,    -1,    -1,    -1,  2844,    -1,
      -1,    -1,  2848,    -1,    -1,    -1,    -1,  2853,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1372,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   323,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2888,    -1,    -1,    -1,  2892,  1401,    -1,  1403,
      -1,    -1,    -1,  1407,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2912,   364,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2957,
      -1,    -1,    -1,    -1,    -1,    -1,  1440,    -1,   385,    -1,
     198,    -1,    -1,    -1,   202,    -1,    -1,    -1,   395,   396,
     397,    -1,   399,   400,   401,   402,   403,   404,    -1,  1463,
    1464,  2957,   220,   221,    -1,    -1,    -1,  1471,    -1,    -1,
    1474,  1475,    -1,   231,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2977,    -1,    -1,    -1,  3013,    -1,    -1,    -1,    -1,
    1494,    -1,    -1,    -1,  1498,  1499,  1500,   255,  1502,    -1,
     258,    -1,    -1,    -1,    -1,  1509,  1510,    -1,    -1,  1513,
      -1,   269,   608,   271,  3010,    -1,    -1,  3013,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1538,  1539,  1540,    -1,  1542,  1543,
      -1,    -1,    -1,  1547,    -1,    -1,    -1,  1551,    -1,    -1,
    1554,  1555,  1556,  1557,  1558,  1559,  1560,  1561,  1562,  1563,
      -1,    -1,    -1,  1567,    -1,   323,    78,  1571,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,
      -1,    93,    -1,    -1,    -1,    97,    -1,    -1,    -1,    -1,
     102,    78,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,
      97,    -1,    -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   385,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   395,   396,   397,
      -1,   399,   400,   401,   402,   403,   404,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    78,    -1,    -1,    -1,    -1,    -1,    -1,   764,    -1,
     766,    -1,   768,    90,    -1,    -1,    -1,    -1,   774,   775,
      97,    -1,    -1,    -1,    -1,   102,   198,    -1,    -1,    -1,
     202,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1702,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1710,    -1,   220,   221,
      -1,   198,    -1,    -1,    -1,   202,    -1,    -1,    -1,   231,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   828,   220,   221,   831,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   255,   231,    -1,   258,    -1,    -1,    -1,
      -1,  1755,    -1,  1757,    -1,    -1,    -1,   269,    -1,   271,
      -1,    -1,    -1,    -1,    -1,  1769,    -1,  1771,   255,    -1,
      -1,   258,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   198,   269,    -1,   271,   202,    -1,    -1,    -1,    -1,
     886,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   220,   221,    -1,   138,   903,   904,    -1,
      -1,   323,    -1,    -1,   231,    -1,    -1,    -1,    -1,    -1,
      -1,  1825,    -1,    -1,   920,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   323,    -1,   255,    -1,
      -1,   258,    -1,    -1,   176,    -1,    -1,    -1,    -1,    -1,
      -1,   183,   269,  1857,   271,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   282,    -1,    -1,    -1,    -1,
    1874,    -1,    -1,   385,    -1,    -1,    -1,   364,    -1,    -1,
      -1,   213,   214,   395,   396,   397,    -1,   399,   400,   401,
     402,   403,   404,    -1,    -1,    -1,    -1,    -1,   385,    -1,
      -1,  1905,  1906,  1907,  1908,  1909,   323,    -1,   395,   396,
     397,    -1,   399,   400,   401,   402,   403,   404,    -1,    -1,
    1924,  1925,  1926,  1927,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1935,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1037,    -1,  1947,    -1,    -1,    -1,    -1,  1952,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1962,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   385,  1973,
    1974,    -1,  1976,    -1,    -1,    -1,  1980,    -1,   395,   396,
     397,    -1,   399,   400,   401,   402,   403,   404,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2000,    -1,  2002,  2003,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2028,    -1,    -1,    -1,    -1,    -1,
      -1,  2035,  2036,  2037,    -1,    -1,    -1,    -1,    -1,  1135,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1146,    -1,    -1,    -1,    -1,    -1,  2060,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2071,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1177,  1178,    -1,    -1,    -1,    -1,    -1,    -1,  2093,
      -1,    -1,    -1,  1189,    -1,    -1,  1192,    -1,    -1,    -1,
      -1,  1197,  1198,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2123,
    2124,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2157,  1250,    -1,  1252,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2168,    -1,  1262,    -1,    -1,  2173,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2185,    -1,  2187,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2201,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2223,
      -1,    -1,    -1,    -1,    -1,  2229,    -1,    -1,  2232,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2241,    -1,  2243,
      -1,    -1,    -1,    -1,  2248,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2256,  2257,    -1,    -1,  2260,  2261,  2262,  2263,
    2264,  2265,  2266,  2267,  2268,  2269,    -1,    -1,    -1,    -1,
    2274,  2275,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2283,
      -1,    -1,    -1,    -1,  2288,    -1,    -1,  2291,    -1,    -1,
      -1,    -1,    -1,  1389,    -1,    -1,    -1,    -1,    -1,  2303,
    2304,  2305,    -1,  2307,    -1,    -1,    -1,    -1,    -1,  2313,
    2314,    -1,    -1,    -1,    -1,  2319,    -1,    -1,  2322,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2331,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   674,   675,    -1,   677,   678,    -1,    -1,    -1,
      -1,   683,   684,  2357,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     702,   703,    -1,    -1,    -1,    -1,    -1,   709,    -1,    -1,
    1476,    -1,  1478,    -1,    -1,    -1,  1482,    -1,   720,    -1,
      -1,  1487,  1488,    -1,    -1,    -1,    -1,    -1,    -1,  1495,
      -1,    -1,    -1,    -1,   138,   737,   738,    -1,    -1,  1505,
      -1,  1507,   744,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   758,    -1,    -1,    -1,
    1526,    -1,  1528,    -1,    -1,    -1,    -1,  2441,    -1,    -1,
      -1,    -1,   176,    -1,    -1,    -1,    -1,    -1,  2452,   183,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   801,
      -1,    -1,    -1,    78,    -1,   807,    -1,    -1,    -1,   213,
     214,    -1,    -1,   815,    -1,    90,    -1,    -1,    93,    -1,
      -1,    -1,    97,  2497,    -1,    -1,    -1,   102,  1594,    -1,
      -1,    -1,    -1,  2507,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   843,    -1,    -1,    -1,    -1,   848,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   860,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2557,    -1,    -1,    -1,  2561,  2562,  2563,
      -1,    -1,  2566,    -1,    -1,    -1,    -1,    -1,  1664,    -1,
      -1,    -1,    -1,    -1,  1670,    -1,  2580,    -1,    -1,    -1,
    2584,    -1,    -1,  1679,  2588,    -1,    -1,    -1,    -1,    -1,
    2594,    -1,    -1,   198,    -1,    -1,    -1,   202,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   220,   221,    -1,    -1,    -1,
      -1,    -1,    -1,   955,    -1,  1721,   231,    -1,  1724,  1725,
      -1,    -1,    -1,   965,   966,    -1,    -1,    -1,   970,    -1,
      -1,    -1,    -1,  2647,    -1,    -1,    -1,    -1,    -1,    -1,
     255,    -1,    -1,   258,    -1,  1751,    -1,    -1,    -1,    -1,
      -1,   993,  1758,    -1,   269,  1761,   271,    -1,    -1,  1765,
      -1,    -1,  2676,    -1,    -1,    -1,    -1,  1773,    -1,    -1,
    1012,  1013,  1778,  1015,    -1,  1017,    -1,  1019,    -1,    -1,
      -1,    -1,    -1,    -1,  1790,    -1,    -1,    -1,    -1,  1031,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2717,    -1,    -1,    -1,  1813,   323,    -1,
      -1,    -1,  2726,    -1,  2728,    -1,    -1,    -1,    -1,    -1,
    2734,  1063,    -1,    -1,  2738,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2749,    -1,    -1,    -1,    -1,
    2754,    -1,    -1,    -1,  2758,    -1,    -1,    -1,    -1,    -1,
    2764,  2765,    -1,    -1,  2768,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1873,    -1,    -1,
     385,    78,    -1,    -1,    -1,  2789,    -1,    -1,    -1,    -1,
     395,   396,   397,    90,   399,   400,   401,   402,   403,   404,
      97,    -1,    -1,    -1,    -1,   102,    -1,    -1,  2812,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2834,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2844,    -1,    -1,    -1,  2848,    -1,    -1,    -1,    -1,  2853,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   826,    -1,    -1,
      -1,    -1,    -1,    -1,  1206,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2888,    -1,    -1,    -1,  2892,    -1,
     187,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   198,    -1,    -1,    -1,   202,    -1,    -1,  2912,    -1,
      -1,    -1,    -1,    -1,    -1,  2011,    -1,    -1,    -1,    -1,
      -1,  2017,    -1,   220,   221,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   231,    -1,    -1,    -1,    -1,    -1,
     674,   675,    -1,   677,   678,    -1,    -1,    -1,    -1,   683,
     684,    -1,    -1,  2957,    -1,    -1,    -1,    -1,   255,    -1,
      -1,   258,    -1,    -1,    -1,    -1,    -1,    -1,   702,   703,
      -1,    -1,   269,  2977,   271,   709,    -1,    -1,    -1,    -1,
      -1,  1313,    -1,    -1,    -1,    -1,   720,    -1,  2084,    -1,
      -1,    -1,    -1,    -1,  2090,  2091,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   737,   738,    -1,  3010,    -1,    -1,  3013,
     744,    -1,    -1,    -1,  2110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   758,    -1,   323,    -1,  2124,    -1,
      -1,    -1,    -1,  2129,    -1,  2131,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2141,  2142,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   801,    -1,    -1,
      -1,    -1,    -1,   807,    -1,    -1,  1408,  1409,    -1,    -1,
      -1,   815,  1414,    -1,    -1,    -1,    -1,    -1,   385,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   395,   396,
     397,    -1,   399,   400,   401,   402,   403,   404,  1440,   843,
      -1,  1443,    -1,    -1,   848,    -1,    -1,    -1,    -1,    -1,
      -1,  1453,    -1,  1082,    -1,    -1,   860,    78,    -1,    -1,
    1462,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,
      -1,    -1,    -1,  2239,    -1,  1104,    97,    -1,    -1,  2245,
      -1,   102,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1128,
    1129,    -1,  1131,  1132,  1133,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1149,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2297,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   955,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   965,   966,    -1,  1566,    -1,   970,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   198,    -1,    -1,
      -1,   202,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   993,
    1219,    -1,    -1,  1222,  1223,    -1,    -1,    -1,    -1,   220,
     221,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1012,  1013,
     231,  1015,    -1,  1017,    -1,  1019,    -1,    -1,  1620,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1031,    -1,    -1,
      -1,    -1,    -1,    -1,   255,  2401,  2402,   258,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   269,  2415,
     271,    -1,    -1,    -1,  2420,  2421,  2422,  2423,  2424,  1063,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     5,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    20,    -1,    -1,
      -1,    -1,   323,    -1,    -1,  2471,    29,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    41,    42,
     341,    -1,    -1,    -1,    47,    -1,    49,    50,    -1,    -1,
      -1,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    -1,    -1,  1759,  1760,    -1,
      -1,    -1,    -1,    -1,   385,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1401,    -1,   395,   396,   397,    -1,   399,   400,
     401,   402,   403,   404,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   115,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1206,    -1,    -1,    -1,    -1,  1809,    -1,    -1,
      -1,    -1,  1814,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2599,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1471,    -1,    -1,    -1,  1475,    -1,    -1,    -1,
      -1,    -1,  2618,    -1,    -1,    -1,  2622,  2623,   181,    -1,
      -1,  2627,    -1,    -1,    -1,  1494,    -1,    -1,    -1,  1498,
      -1,  1500,    -1,  1502,   197,    -1,    -1,    -1,    -1,    -1,
    1509,  1510,    -1,    -1,  1513,    -1,    -1,    -1,    -1,    -1,
      -1,   214,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2672,    -1,    -1,  1313,
    1539,  2677,    -1,    -1,  1543,  2681,    -1,   240,  1547,    -1,
     243,    -1,  1551,    -1,    -1,  1554,  1555,  1556,  1557,  1558,
    1559,  1560,  1561,  1562,  1563,    -1,   259,    -1,  1567,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   312,
      -1,    -1,  1994,    -1,    78,    -1,    -1,    -1,  2000,    -1,
      -1,    -1,    -1,    -1,  1408,  1409,    90,    -1,    -1,    -1,
    1414,    -1,    -1,    97,    -1,    -1,    -1,    -1,   102,    -1,
      -1,   344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   356,    -1,    -1,  1440,    -1,    -1,  1443,
      -1,    -1,    -1,    -1,    -1,   368,    -1,    -1,    -1,  1453,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   380,  1462,    -1,
     383,   384,    -1,   386,    -1,   388,    -1,    -1,    -1,   392,
      -1,   394,   395,  1702,    -1,    -1,   399,   400,   401,   402,
     403,    -1,    -1,   406,   407,   408,   409,    -1,   411,   412,
     413,   414,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,   202,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2893,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   220,   221,    -1,    -1,
    1769,    -1,    -1,    -1,    -1,    -1,    -1,   231,    -1,  2915,
    2916,  2153,    -1,    -1,    -1,    -1,    -1,  2159,    -1,    -1,
      -1,    -1,  1566,    -1,    -1,    -1,    -1,    -1,  2170,    -1,
      -1,   255,    -1,    -1,   258,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   269,    -1,   271,    -1,  2955,
    2956,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2201,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1620,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1857,    -1,
      -1,    -1,  2234,    -1,    -1,    -1,    -1,    -1,    -1,   323,
      -1,    -1,    -1,    -1,    -1,  1874,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1908,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1924,    -1,  1926,  1927,    -1,
      -1,   385,    -1,    -1,    -1,    -1,  1935,    -1,    -1,    -1,
      -1,   395,   396,   397,    -1,   399,   400,   401,   402,   403,
     404,    -1,    -1,    -1,    -1,    -1,    -1,  2329,  2330,  2331,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1974,    -1,  1976,    -1,    -1,
      -1,  1980,    -1,    -1,    -1,  1759,  1760,    -1,    -1,    -1,
      -1,    -1,   674,    -1,    -1,    -1,   678,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   703,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2028,
      -1,    -1,    -1,    -1,    -1,  1809,  2035,  2036,  2037,    -1,
    1814,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2427,   738,    -1,    -1,    -1,
      -1,  2060,   744,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2447,    -1,    -1,    -1,    -1,
      -1,    -1,  2454,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   826,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2568,  2569,  2570,  2571,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2580,    -1,
      -1,    -1,  2584,    -1,    -1,    -1,  2588,    -1,    -1,    -1,
    1994,    -1,    -1,    -1,  2223,    -1,  2000,    -1,    -1,    -1,
    2229,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2241,    -1,  2243,    -1,    -1,    -1,    -1,  2248,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2274,  2275,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   966,    -1,    -1,    -1,   970,    -1,
      -1,    -1,  2291,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   984,    -1,  2676,    -1,  2305,    -1,  2307,    -1,
      -1,    -1,    -1,    -1,    -1,  2314,    -1,    -1,    -1,    -1,
    2319,    -1,    -1,  2322,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1017,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1027,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2357,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2749,    -1,  2153,
      -1,    -1,  2754,    -1,    -1,  2159,  2758,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2170,    -1,    -1,    -1,
    1082,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2789,    -1,  2791,
      -1,    -1,  1104,    -1,    -1,    -1,    -1,  2201,    -1,    -1,
      -1,    -1,    -1,    -1,  2806,    -1,    -1,    -1,    -1,  2811,
      -1,    -1,    -1,  2815,    -1,    -1,  1128,  1129,    -1,  1131,
    1132,  1133,    -1,    -1,    -1,    -1,    -1,  2829,    -1,    -1,
    2234,    -1,    -1,    -1,    -1,    -1,    -1,  1149,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2848,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2860,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2497,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2507,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2888,  2889,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1219,    -1,    -1,
    1222,  1223,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2329,  2330,  2331,    -1,  2931,
      -1,    -1,    -1,  2562,  2563,    -1,    -1,  2566,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2965,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1286,  2977,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1296,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3010,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2647,    -1,
      -1,    -1,    -1,  2427,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1347,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2447,    -1,    -1,    -1,    -1,    -1,    -1,
    2454,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1372,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2717,  1401,
      -1,  1403,    -1,    -1,    -1,  1407,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2738,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1440,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2765,    -1,    -1,  2768,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1463,  1464,    -1,    -1,    -1,    -1,    -1,    -1,  1471,
      -1,    -1,  1474,  1475,  2568,  2569,  2570,  2571,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2580,    -1,    -1,    -1,
    2584,    -1,  1494,  2812,  2588,    -1,  1498,  1499,  1500,    -1,
    1502,    -1,    -1,    -1,    -1,    -1,    -1,  1509,  1510,    -1,
      -1,  1513,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2844,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1538,  1539,    -1,    -1,
    1542,  1543,    -1,    -1,    -1,  1547,    -1,    -1,    -1,  1551,
      -1,    -1,  1554,  1555,  1556,  1557,  1558,  1559,  1560,  1561,
    1562,  1563,    -1,    -1,    -1,  1567,    -1,    -1,    -1,  1571,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2676,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2912,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2749,    -1,    -1,    -1,    -1,
    2754,    -1,    -1,    -1,  2758,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2789,    -1,  2791,    -1,    -1,
    1702,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1710,    -1,
      -1,  1150,  2806,    -1,    -1,    -1,    -1,  2811,    -1,    -1,
      -1,  2815,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2829,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1755,  2848,  1757,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2860,  1769,    -1,  1771,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2888,  2889,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1825,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2931,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1857,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2965,  1874,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2977,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1905,  1906,  1907,  1908,  1909,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3010,    -1,    -1,    -1,
      -1,    -1,  1924,  1925,  1926,  1927,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1935,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1947,    -1,    -1,    -1,    -1,
    1952,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1962,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1973,  1974,    -1,  1976,    -1,    -1,    -1,  1980,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2000,    -1,
    2002,  2003,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2028,    -1,    -1,    -1,
    1469,    -1,    -1,  2035,  2036,  2037,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1493,    -1,    -1,    -1,  2060,    -1,
    1499,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2071,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1516,  1517,  1518,
    1519,    -1,    -1,  1522,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2093,    -1,    -1,    -1,    -1,    -1,    -1,  1537,    -1,
      -1,    -1,    -1,  1542,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2124,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2157,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2168,    -1,    -1,    -1,
      -1,  2173,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2185,    -1,  2187,    -1,    -1,    -1,    -1,
    1629,    -1,    -1,    -1,    -1,    -1,  1635,    -1,  1637,  2201,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2223,    -1,    -1,    -1,    -1,    -1,  2229,    -1,    -1,
    2232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2241,
      -1,  2243,    -1,    -1,    -1,    -1,  2248,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2256,  2257,    -1,    -1,  2260,  2261,
    2262,  2263,  2264,  2265,  2266,  2267,  2268,  2269,    -1,    -1,
      -1,    -1,  2274,  2275,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2283,    -1,    -1,    -1,    -1,  2288,    -1,    -1,  2291,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2303,  2304,  2305,    -1,  2307,    -1,    -1,    -1,    -1,
      -1,  2313,  2314,    -1,    -1,    -1,    -1,  2319,    -1,    -1,
    2322,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2331,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2357,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1823,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1868,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1877,  2441,
    1879,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2452,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1898,
      -1,    -1,    -1,    -1,  1903,    -1,  1905,  1906,  1907,    -1,
    1909,  1910,    -1,    -1,    -1,    -1,  1915,  1916,    -1,    -1,
      -1,    -1,    -1,    -1,  1923,    -1,    -1,    -1,    -1,  1928,
      -1,    -1,  1931,    -1,    -1,  2497,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2507,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1957,    -1,
      -1,  1960,  1961,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1972,  1973,    -1,    -1,    -1,    -1,    -1,
    1979,    -1,  1981,  1982,  1983,  1984,  1985,  1986,  1987,  1988,
    1989,  1990,    -1,    -1,    -1,  2557,    -1,    -1,    -1,  2561,
    2562,  2563,    -1,    -1,  2566,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2580,    -1,
      -1,    -1,  2584,    -1,    -1,    -1,  2588,    -1,    -1,    -1,
      -1,    -1,  2594,    -1,    -1,    -1,    -1,    -1,     5,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    20,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    29,    -1,    -1,    -1,    -1,    -1,    -1,  2068,
      -1,    -1,    -1,    -1,    41,    42,    -1,    -1,    -1,    -1,
      -1,    -1,    49,    50,    -1,  2647,    -1,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    -1,    -1,    -1,  2676,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2125,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   115,    -1,
      -1,    -1,    -1,    -1,    -1,  2717,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2726,    -1,  2728,    -1,    -1,    -1,
      -1,    -1,  2734,    -1,    -1,    -1,  2738,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2749,    -1,    -1,
      -1,    -1,  2754,    -1,    -1,    -1,  2758,    -1,    -1,    -1,
      -1,    -1,  2764,  2765,    -1,    -1,  2768,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   181,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2789,    -1,  2228,
     197,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   214,    -1,    -1,
    2812,    -1,  2251,  2252,  2253,  2254,  2255,    -1,  2257,    -1,
      -1,  2260,  2261,  2262,  2263,  2264,  2265,  2266,  2267,  2268,
    2269,    -1,  2834,   240,    -1,    -1,   243,    -1,    -1,    -1,
      -1,    -1,  2844,    -1,    -1,    -1,  2848,    -1,    -1,    -1,
      -1,  2853,   259,    -1,    -1,  2294,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2304,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2315,  2316,    -1,  2318,
      -1,    -1,  2321,    -1,    -1,    -1,  2888,    -1,    -1,    -1,
    2892,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   312,    -1,    -1,    -1,    -1,
    2912,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2375,   344,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   356,
      -1,    -1,    -1,    -1,    -1,  2957,    -1,    -1,    -1,    -1,
      -1,   368,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   380,    -1,  2977,   383,   384,    -1,   386,
      -1,    -1,    -1,    -1,    -1,   392,    -1,   394,   395,    -1,
      -1,    -1,   399,   400,   401,   402,   403,    -1,    -1,   406,
     407,   408,  2441,    -1,    -1,   412,    -1,    -1,  3010,    -1,
      -1,  3013,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2504,    -1,    -1,    -1,  2508,
      -1,    -1,    -1,    -1,  2513,  2514,    -1,    -1,  2517,    -1,
      -1,  2520,    -1,    -1,    -1,  2524,  2525,  2526,  2527,  2528,
    2529,  2530,  2531,  2532,  2533,  2534,  2535,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2546,    -1,    -1,
      -1,    -1,    -1,    -1,  2553,  2554,    -1,  2556,    -1,    -1,
      -1,  2560,  2561,    -1,    -1,  2564,    -1,    -1,  2567,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2604,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2649,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2719,    -1,    -1,    -1,    -1,    -1,    -1,  2726,    -1,  2728,
      -1,    -1,    -1,    -1,    -1,    -1,  2735,  2736,  2737,    -1,
    2739,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2793,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2833,  2834,  2835,    -1,    -1,    -1,
    2839,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2856,    -1,  2858,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2886,    -1,     5,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,  2901,    19,    -1,    21,  2905,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      -1,    37,    38,    39,    40,    41,    42,    -1,    44,    45,
      46,    -1,    48,    49,    50,    -1,    52,    53,    -1,    -1,
      -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,
      76,    77,    -1,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
      -1,   107,   108,   109,    -1,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,    -1,   155,
     156,   157,   158,   159,   160,   161,   162,   163,   164,   165,
     166,   167,   168,   169,   170,   171,   172,   173,   174,   175,
      -1,   177,   178,   179,   180,   181,   182,   183,   184,   185,
     186,   187,   188,   189,    -1,   191,   192,   193,   194,   195,
     196,   197,   198,   199,   200,   201,   202,   203,   204,   205,
     206,   207,   208,   209,   210,   211,   212,   213,   214,   215,
     216,   217,   218,    -1,   220,   221,   222,   223,   224,   225,
     226,   227,   228,   229,   230,   231,   232,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
      -1,   277,   278,   279,   280,   281,    -1,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,    -1,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,   344,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,   370,   371,   372,    -1,   374,   375,
     376,   377,   378,   379,   380,   381,    -1,   383,    -1,    -1,
     386,    -1,    -1,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    20,    21,    -1,
      23,    24,    25,    26,    27,    28,   412,    30,    31,    32,
      33,    -1,    35,    -1,    37,    38,    39,    40,    -1,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    -1,    -1,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,    -1,   107,   108,   109,    -1,   111,   112,
     113,   114,    -1,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,    -1,   155,   156,   157,   158,   159,   160,   161,   162,
     163,   164,   165,   166,   167,   168,   169,   170,   171,   172,
     173,   174,   175,    -1,   177,   178,   179,   180,   181,   182,
     183,   184,   185,   186,   187,   188,   189,    -1,   191,   192,
     193,   194,   195,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,   207,   208,   209,    -1,   211,   212,
     213,    -1,   215,   216,   217,   218,    -1,   220,   221,   222,
     223,   224,   225,   226,   227,   228,   229,   230,   231,   232,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,    -1,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,   287,   288,   289,   290,   291,   292,
     293,   294,   295,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
      -1,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,   370,   371,   372,
      -1,   374,   375,   376,   377,   378,   379,   380,   381,    -1,
     383,    -1,    -1,   386,    -1,    -1,    -1,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    20,    21,    -1,    23,    24,    25,    26,    27,    28,
     413,    30,    31,    32,    33,    -1,    35,    -1,    37,    38,
      39,    40,    -1,    42,    -1,    44,    45,    46,    -1,    48,
      49,    50,    -1,    52,    53,    -1,    -1,    -1,    57,    58,
      -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    74,    -1,    76,    -1,    -1,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,    -1,   107,   108,
     109,    -1,   111,   112,   113,   114,    -1,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,    -1,   155,   156,   157,   158,
     159,   160,   161,   162,   163,   164,   165,   166,   167,   168,
     169,   170,   171,   172,   173,   174,   175,    -1,   177,   178,
     179,   180,   181,   182,   183,   184,   185,   186,   187,   188,
     189,    -1,   191,   192,   193,   194,   195,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     209,    -1,   211,   212,   213,    -1,   215,   216,   217,   218,
      -1,   220,   221,   222,   223,   224,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,    -1,   277,   278,
     279,   280,   281,    -1,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,    -1,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,   370,   371,   372,    -1,   374,   375,   376,   377,   378,
     379,   380,   381,    -1,   383,    -1,    -1,   386,     3,    -1,
      -1,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,   413,    30,    31,    32,    33,    -1,
      35,    -1,    37,    38,    39,    40,    -1,    42,    -1,    44,
      45,    46,    -1,    48,    49,    50,    -1,    52,    53,    -1,
      -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,
      -1,    76,    77,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    87,    88,    89,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    97,    98,    -1,    -1,   101,   102,   103,   104,
     105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   116,    -1,    -1,   119,    -1,   121,   122,   123,    -1,
      -1,   126,   127,    -1,    -1,    -1,    -1,   132,   133,   134,
      -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,   144,
      -1,   146,   147,   148,   149,    -1,    -1,    -1,    -1,    -1,
     155,    -1,    -1,    -1,    -1,    -1,    -1,   162,   163,    -1,
      -1,    -1,    -1,   168,    -1,    -1,    -1,    -1,   173,   174,
     175,    -1,   177,    -1,   179,    -1,   181,    -1,    -1,    -1,
      -1,   186,    -1,   188,    -1,   190,    -1,   192,    -1,    -1,
      -1,    -1,    -1,   198,    -1,    -1,    -1,   202,    -1,    -1,
      -1,    -1,    -1,   208,    -1,    -1,    -1,   212,    -1,    -1,
     215,    -1,   217,    -1,    -1,   220,   221,    -1,   223,    -1,
      -1,    -1,    -1,    -1,   229,    -1,   231,    -1,   233,   234,
      -1,    -1,   237,    -1,    -1,    -1,    -1,    -1,    -1,   244,
      -1,    -1,   247,   248,    -1,    -1,    -1,    -1,    -1,   254,
      -1,    -1,   257,   258,    -1,   260,   261,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   274,
     275,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   283,    -1,
      -1,   286,    -1,    -1,    -1,    -1,    -1,    -1,   293,    -1,
      -1,   296,    -1,    -1,    -1,   300,    -1,    -1,    -1,   304,
     305,   306,   307,    -1,    -1,    -1,    -1,    -1,    -1,   314,
      -1,    -1,    -1,    -1,   319,   320,    -1,   322,   323,    -1,
     325,    -1,    -1,   328,    -1,     3,    -1,    -1,    -1,    -1,
     335,     9,    -1,    -1,    -1,    -1,    -1,   342,   343,    17,
      -1,    19,    -1,   348,    22,   350,    -1,   352,    -1,   354,
      -1,   356,    -1,    -1,   359,    33,   361,    -1,    -1,    -1,
     365,    -1,    -1,   368,    -1,   370,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    52,    53,    -1,    -1,   383,    -1,
      -1,   386,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    79,    -1,   408,    -1,    -1,    -1,    -1,    -1,    87,
      88,    89,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   101,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   119,    -1,   121,   122,    -1,    -1,    -1,   126,   127,
      -1,    -1,    -1,    -1,    -1,   133,   134,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   144,    -1,   146,    -1,
      -1,   149,    -1,    -1,    -1,    -1,    -1,   155,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   163,    -1,    -1,    -1,    -1,
     168,    -1,    -1,    -1,    -1,   173,    -1,   175,    -1,    -1,
      -1,   179,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   190,    -1,   192,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   212,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   233,   234,    -1,    -1,   237,
      -1,    -1,    -1,    -1,    -1,    -1,   244,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   257,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   286,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   296,    -1,
      -1,    -1,   300,    -1,    -1,    -1,   304,    -1,   306,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   314,    -1,    -1,    -1,
      -1,   319,    -1,    -1,   322,    -1,    -1,    -1,    -1,    -1,
     328,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   352,    -1,   354,    -1,    -1,    -1,
      -1,   359,    -1,   361,    -1,    -1,    -1,   365,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    -1,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
     408,    48,    49,    50,    -1,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
      -1,   108,   109,    -1,   111,   112,   113,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,    -1,   151,    -1,   153,    -1,   155,   156,
     157,    -1,   159,    -1,   161,   162,   163,   164,    -1,   166,
     167,    -1,   169,    -1,   171,   172,   173,   174,   175,    -1,
     177,   178,   179,   180,   181,    -1,   183,    -1,   185,   186,
      -1,   188,   189,    -1,   191,    -1,    -1,   194,    -1,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
      -1,   208,   209,    -1,   211,   212,   213,   214,   215,    -1,
     217,    -1,    -1,   220,   221,   222,   223,   224,   225,   226,
     227,    -1,   229,   230,   231,    -1,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,    -1,    -1,   265,   266,
      -1,    -1,   269,   270,    -1,    -1,   273,   274,   275,   276,
     277,   278,   279,   280,   281,    -1,   283,   284,   285,   286,
      -1,   288,   289,   290,   291,   292,   293,   294,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,   325,    -1,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
      -1,   338,   339,   340,    -1,   342,   343,    -1,   345,    -1,
     347,   348,   349,   350,   351,   352,   353,   354,   355,    -1,
     357,   358,   359,   360,   361,   362,   363,    -1,   365,   366,
     367,   368,   369,   370,   371,   372,    -1,    -1,    -1,   376,
     377,   378,   379,   380,   381,    -1,   383,   384,   385,   386,
     387,    -1,    -1,   390,   391,   392,   393,   394,    -1,    -1,
      -1,    -1,   399,   400,   401,    -1,   403,   404,    -1,    -1,
      -1,   408,   409,     5,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    -1,    37,    38,    39,    40,    41,
      42,    -1,    44,    45,    46,    -1,    48,    49,    50,    -1,
      52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,
      -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      72,    -1,    74,    -1,    76,    77,    -1,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,
      92,    -1,    -1,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   104,   105,   106,    -1,   108,   109,    -1,   111,
     112,   113,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,   137,   138,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,    -1,   151,
      -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,   166,   167,    -1,   169,    -1,   171,
     172,   173,   174,   175,    -1,   177,   178,   179,   180,   181,
      -1,   183,    -1,   185,   186,    -1,   188,   189,    -1,   191,
      -1,    -1,   194,    -1,   196,   197,   198,   199,   200,   201,
     202,   203,   204,   205,   206,    -1,   208,   209,    -1,   211,
     212,   213,   214,   215,    -1,   217,    -1,    -1,   220,   221,
     222,   223,   224,   225,   226,   227,    -1,   229,   230,   231,
      -1,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,    -1,    -1,   265,   266,    -1,    -1,   269,   270,    -1,
      -1,   273,   274,   275,   276,   277,   278,   279,   280,   281,
      -1,   283,   284,   285,   286,    -1,   288,   289,   290,   291,
     292,   293,   294,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,    -1,    -1,   315,   316,   317,   318,   319,   320,   321,
     322,   323,   324,   325,    -1,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,    -1,   338,   339,   340,    -1,
     342,   343,    -1,   345,    -1,   347,   348,   349,   350,   351,
     352,   353,   354,   355,    -1,   357,   358,   359,   360,   361,
     362,   363,    -1,   365,   366,   367,   368,   369,   370,   371,
     372,    -1,    -1,    -1,   376,   377,   378,   379,   380,   381,
      -1,   383,   384,   385,   386,   387,    -1,    -1,   390,   391,
     392,   393,   394,    -1,    -1,    -1,    -1,   399,   400,    -1,
      -1,   403,   404,    -1,    -1,    -1,   408,   409,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    -1,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    49,    50,    -1,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    -1,
      87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
      -1,   108,   109,    -1,   111,   112,   113,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,    -1,   151,    -1,   153,    -1,   155,   156,
     157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,
     167,    -1,   169,    -1,   171,   172,   173,   174,   175,    -1,
     177,   178,   179,   180,   181,    -1,   183,    -1,   185,   186,
      -1,   188,   189,    -1,   191,    -1,    -1,   194,    -1,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
      -1,   208,   209,    -1,   211,   212,   213,   214,   215,    -1,
     217,    -1,    -1,   220,   221,   222,   223,   224,   225,   226,
     227,    -1,   229,   230,   231,    -1,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,    -1,    -1,   265,   266,
      -1,    -1,   269,   270,    -1,    -1,   273,   274,   275,   276,
     277,   278,   279,   280,   281,    -1,   283,   284,   285,   286,
      -1,   288,   289,   290,   291,   292,   293,   294,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,   325,    -1,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
      -1,   338,   339,   340,    -1,   342,   343,    -1,   345,    -1,
     347,   348,   349,   350,   351,   352,   353,   354,   355,    -1,
     357,   358,   359,   360,   361,   362,   363,    -1,   365,   366,
     367,   368,   369,   370,   371,   372,    -1,    -1,    -1,   376,
     377,   378,   379,   380,   381,    -1,   383,   384,   385,   386,
     387,    -1,    -1,   390,   391,   392,   393,   394,    -1,    -1,
      -1,    -1,   399,   400,    -1,    -1,   403,   404,    -1,    -1,
      -1,   408,   409,     5,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    -1,    37,    38,    39,    40,    41,
      42,    -1,    44,    45,    46,    -1,    48,    49,    50,    -1,
      52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,
      -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      72,    -1,    74,    -1,    76,    77,    -1,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,   106,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,    -1,    -1,    -1,   126,   127,   128,    -1,   130,   131,
      -1,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,
     142,   143,   144,   145,   146,   147,   148,   149,    -1,   151,
      -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,   166,   167,    -1,   169,    -1,   171,
     172,   173,    -1,   175,    -1,    -1,    -1,   179,   180,   181,
      -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,
      -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,   201,
     202,   203,   204,   205,   206,    -1,    -1,   209,    -1,   211,
     212,   213,   214,   215,    -1,   217,    -1,    -1,    -1,    -1,
     222,    -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,
      -1,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,    -1,   248,    -1,   250,   251,
     252,   253,    -1,    -1,   256,   257,    -1,    -1,    -1,   261,
     262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,
      -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,   281,
      -1,    -1,   284,   285,   286,    -1,   288,   289,   290,   291,
     292,   293,   294,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,    -1,   306,    -1,   308,   309,   310,   311,
     312,    -1,    -1,   315,   316,   317,    -1,   319,   320,   321,
     322,    -1,   324,   325,    -1,   327,   328,   329,   330,   331,
     332,   333,   334,    -1,   336,    -1,   338,   339,   340,    -1,
     342,   343,    -1,   345,    -1,   347,    -1,   349,    -1,    -1,
     352,   353,   354,   355,    -1,    -1,   358,   359,   360,   361,
     362,    -1,    -1,   365,   366,   367,   368,   369,     5,   371,
     372,    -1,    -1,    -1,   376,   377,   378,   379,   380,   381,
      -1,   383,    -1,    20,   386,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    41,    42,    -1,   409,    -1,    -1,
      -1,    -1,    49,    50,    -1,    -1,    -1,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    -1,    -1,     5,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    20,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    29,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   115,    41,
      42,    -1,    -1,    -1,    -1,    -1,    -1,    49,    50,    -1,
      -1,    -1,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   181,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   115,    -1,    -1,    -1,    -1,    -1,    -1,
     197,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   214,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   240,    -1,    -1,   243,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   181,
      -1,    -1,   259,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   197,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   214,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   312,    -1,    -1,   240,    -1,
      -1,   243,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   259,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   344,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   356,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   368,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   380,    -1,    -1,   383,   384,    -1,   386,
     312,    -1,    -1,    -1,    -1,   392,    -1,   394,   395,    -1,
      -1,    -1,   399,   400,   401,   402,   403,    -1,    -1,   406,
     407,   408,   409,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   356,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   368,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   380,    -1,
      -1,   383,   384,    -1,   386,    -1,    -1,    -1,    -1,    -1,
     392,    -1,   394,   395,    -1,    -1,    -1,   399,   400,   401,
     402,   403,    -1,    -1,   406,   407,   408,   409,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    -1,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    49,    50,    -1,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    -1,
      87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
     107,   108,   109,    -1,   111,   112,   113,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,    -1,   151,    -1,   153,    -1,   155,   156,
     157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,
     167,    -1,   169,    -1,   171,   172,   173,   174,   175,    -1,
     177,   178,   179,   180,   181,    -1,   183,    -1,   185,   186,
     187,   188,   189,    -1,   191,    -1,    -1,   194,    -1,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
      -1,   208,   209,    -1,   211,   212,   213,   214,   215,    -1,
     217,    -1,    -1,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,    -1,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,    -1,    -1,   265,   266,
      -1,    -1,   269,   270,    -1,    -1,   273,   274,   275,   276,
     277,   278,   279,   280,   281,    -1,   283,   284,   285,   286,
      -1,   288,   289,   290,   291,   292,   293,   294,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,   325,    -1,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
      -1,   338,   339,   340,    -1,   342,   343,    -1,   345,   346,
     347,   348,   349,   350,   351,   352,   353,   354,   355,    -1,
     357,   358,   359,   360,   361,   362,   363,    -1,   365,   366,
     367,   368,   369,   370,   371,   372,    -1,    -1,    -1,   376,
     377,   378,   379,   380,   381,    -1,   383,   384,   385,   386,
     387,    -1,    -1,   390,   391,   392,   393,   394,    -1,    -1,
      -1,    -1,   399,   400,    -1,    -1,   403,   404,    -1,    -1,
      -1,   408,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    -1,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,    92,
      -1,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,   108,   109,    -1,   111,   112,
     113,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,    -1,
     153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,
     163,   164,    -1,   166,   167,    -1,   169,    -1,   171,   172,
     173,   174,   175,    -1,   177,   178,   179,   180,   181,    -1,
     183,    -1,   185,   186,    -1,   188,   189,    -1,   191,    -1,
      -1,   194,    -1,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,    -1,   208,   209,    -1,   211,   212,
     213,   214,   215,    -1,   217,    -1,    -1,   220,   221,   222,
     223,   224,   225,   226,   227,    -1,   229,   230,   231,    -1,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
      -1,    -1,   265,   266,    -1,    -1,   269,   270,    -1,    -1,
     273,   274,   275,   276,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,    -1,   288,   289,   290,   291,   292,
     293,   294,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
      -1,    -1,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,   325,    -1,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,    -1,   338,   339,   340,    -1,   342,
     343,    -1,   345,    -1,   347,   348,   349,   350,   351,   352,
     353,   354,   355,    -1,   357,   358,   359,   360,   361,   362,
     363,    -1,   365,   366,   367,   368,   369,   370,   371,   372,
      -1,    -1,    -1,   376,   377,   378,   379,   380,   381,    -1,
     383,   384,   385,   386,   387,    -1,    -1,   390,   391,   392,
     393,   394,    -1,    -1,    -1,    -1,   399,   400,   401,    -1,
     403,   404,    -1,    -1,    -1,   408,     5,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    -1,    37,    38,
      39,    40,    41,    42,    -1,    44,    45,    46,    -1,    48,
      49,    50,    -1,    52,    53,    -1,    -1,    -1,    57,    58,
      -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    -1,
      -1,    -1,    -1,    92,    -1,    -1,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,    -1,   108,
     109,    -1,   111,   112,   113,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,    -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,   166,   167,    -1,
     169,    -1,   171,   172,   173,   174,   175,    -1,   177,   178,
     179,   180,   181,    -1,   183,    -1,   185,   186,    -1,   188,
     189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,   206,    -1,   208,
     209,    -1,   211,   212,   213,   214,   215,    -1,   217,    -1,
      -1,   220,   221,   222,   223,   224,   225,   226,   227,    -1,
     229,   230,   231,    -1,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,    -1,    -1,   265,   266,    -1,    -1,
     269,   270,    -1,    -1,   273,   274,   275,   276,   277,   278,
     279,   280,   281,    -1,   283,   284,   285,   286,    -1,   288,
     289,   290,   291,   292,   293,   294,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,    -1,    -1,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,   325,    -1,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,    -1,   338,
     339,   340,    -1,   342,   343,    -1,   345,    -1,   347,   348,
     349,   350,   351,   352,   353,   354,   355,    -1,   357,   358,
     359,   360,   361,   362,   363,    -1,   365,   366,   367,   368,
     369,   370,   371,   372,    -1,    -1,    -1,   376,   377,   378,
     379,   380,   381,    -1,   383,   384,   385,   386,   387,    -1,
      -1,   390,   391,   392,   393,   394,    -1,    -1,    -1,    -1,
     399,   400,   401,    -1,   403,   404,    -1,    -1,    -1,   408,
       5,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    -1,    37,    38,    39,    40,    41,    42,    -1,    44,
      45,    46,    -1,    48,    49,    50,    -1,    52,    53,    -1,
      -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,
      -1,    76,    77,    -1,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,   108,   109,    -1,   111,   112,   113,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,    -1,   151,    -1,   153,    -1,
     155,   156,   157,    -1,    -1,    -1,   161,   162,   163,   164,
      -1,   166,   167,    -1,   169,    -1,   171,   172,   173,   174,
     175,    -1,   177,   178,   179,   180,   181,    -1,   183,    -1,
     185,   186,    -1,   188,   189,    -1,   191,    -1,    -1,   194,
      -1,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,    -1,   208,   209,    -1,   211,   212,   213,   214,
     215,    -1,   217,    -1,    -1,   220,   221,   222,   223,   224,
     225,   226,   227,    -1,   229,   230,   231,    -1,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,    -1,    -1,
     265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,   274,
     275,   276,   277,   278,   279,   280,   281,    -1,   283,   284,
     285,   286,    -1,   288,   289,   290,   291,   292,   293,   294,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,    -1,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,    -1,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,    -1,   338,   339,   340,    -1,   342,   343,    -1,
     345,    -1,   347,   348,   349,   350,   351,   352,   353,   354,
     355,    -1,   357,   358,   359,   360,   361,   362,   363,    -1,
     365,   366,   367,   368,   369,   370,   371,   372,    -1,    -1,
      -1,   376,   377,   378,   379,   380,   381,    -1,   383,   384,
     385,   386,   387,    -1,    -1,   390,   391,   392,   393,   394,
      -1,    -1,    -1,    -1,   399,   400,    -1,    -1,   403,   404,
      -1,    -1,    -1,   408,     5,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    -1,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    -1,    48,    49,    50,
      -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,
      -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    -1,    -1,    -1,
      -1,    92,    -1,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,    -1,   108,   109,    -1,
     111,   112,   113,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,    -1,
     151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,
     161,   162,   163,   164,    -1,   166,   167,    -1,   169,    -1,
     171,   172,   173,   174,   175,    -1,   177,   178,   179,   180,
     181,    -1,   183,    -1,   185,   186,    -1,   188,   189,    -1,
     191,    -1,    -1,   194,    -1,   196,   197,   198,   199,   200,
     201,   202,   203,   204,   205,   206,    -1,   208,   209,    -1,
     211,   212,   213,   214,   215,    -1,   217,    -1,    -1,   220,
     221,   222,   223,   224,   225,   226,   227,    -1,   229,   230,
     231,    -1,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,    -1,    -1,   265,   266,    -1,    -1,   269,   270,
      -1,    -1,   273,   274,   275,   276,   277,   278,   279,   280,
     281,    -1,   283,   284,   285,   286,    -1,   288,   289,   290,
     291,   292,   293,   294,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,    -1,    -1,   315,   316,   317,   318,   319,   320,
     321,   322,   323,   324,   325,    -1,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,    -1,   338,   339,   340,
      -1,   342,   343,    -1,   345,    -1,   347,   348,   349,   350,
     351,   352,   353,   354,   355,    -1,   357,   358,   359,   360,
     361,   362,   363,    -1,   365,   366,   367,   368,   369,   370,
     371,   372,    -1,    -1,    -1,   376,   377,   378,   379,   380,
     381,    -1,   383,   384,   385,   386,   387,    -1,    -1,   390,
     391,   392,   393,   394,    -1,    -1,    -1,    -1,   399,   400,
      -1,    -1,   403,   404,    -1,    -1,    -1,   408,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    -1,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    49,    50,    -1,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    -1,
      87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
      -1,   108,   109,    -1,   111,   112,   113,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,    -1,   151,    -1,   153,    -1,   155,   156,
     157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,
     167,    -1,   169,    -1,   171,   172,   173,   174,   175,    -1,
     177,   178,   179,   180,   181,    -1,   183,    -1,   185,   186,
      -1,   188,   189,    -1,   191,    -1,    -1,   194,    -1,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
      -1,   208,   209,    -1,   211,   212,   213,   214,   215,    -1,
     217,    -1,    -1,   220,   221,   222,   223,   224,   225,   226,
     227,    -1,   229,   230,   231,    -1,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,    -1,    -1,   265,   266,
      -1,    -1,   269,   270,    -1,    -1,   273,   274,   275,   276,
     277,   278,   279,   280,   281,    -1,   283,   284,   285,   286,
      -1,   288,   289,   290,   291,   292,   293,   294,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,   325,    -1,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
      -1,   338,   339,   340,    -1,   342,   343,    -1,   345,    -1,
     347,   348,   349,   350,   351,   352,   353,   354,   355,    -1,
     357,   358,   359,   360,   361,   362,   363,    -1,   365,   366,
     367,   368,   369,   370,   371,   372,    -1,    -1,    -1,   376,
     377,   378,   379,   380,   381,    -1,   383,   384,   385,   386,
     387,    -1,    -1,   390,   391,   392,   393,   394,    -1,    -1,
      -1,    -1,   399,   400,    -1,    -1,   403,   404,    -1,   406,
      -1,   408,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    -1,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,    92,
      -1,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,   108,   109,    -1,   111,   112,
     113,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,    -1,   151,    -1,
     153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,
     163,   164,    -1,   166,   167,    -1,   169,    -1,   171,   172,
     173,   174,   175,    -1,   177,   178,   179,   180,   181,    -1,
     183,    -1,   185,   186,   187,   188,   189,    -1,   191,    -1,
      -1,   194,    -1,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,    -1,   208,   209,    -1,   211,   212,
     213,   214,   215,    -1,   217,    -1,    -1,   220,   221,   222,
     223,   224,   225,   226,   227,    -1,   229,   230,   231,    -1,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
      -1,    -1,   265,   266,    -1,    -1,   269,   270,    -1,    -1,
     273,   274,   275,   276,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,    -1,   288,   289,   290,   291,   292,
     293,   294,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
      -1,    -1,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,   325,    -1,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,    -1,   338,   339,   340,    -1,   342,
     343,    -1,   345,    -1,   347,   348,   349,   350,   351,   352,
     353,   354,   355,    -1,   357,   358,   359,   360,   361,   362,
     363,    -1,   365,   366,   367,   368,   369,   370,   371,   372,
      -1,    -1,    -1,   376,   377,   378,   379,   380,   381,    -1,
     383,   384,   385,   386,   387,    -1,    -1,   390,   391,   392,
     393,   394,    -1,    -1,    -1,    -1,   399,   400,    -1,    -1,
     403,   404,    -1,    -1,    -1,   408,     5,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    -1,    37,    38,
      39,    40,    41,    42,    -1,    44,    45,    46,    -1,    48,
      49,    50,    -1,    52,    53,    -1,    -1,    -1,    57,    58,
      -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    -1,
      -1,    -1,    -1,    92,    -1,    -1,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,    -1,   108,
     109,    -1,   111,   112,   113,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,    -1,   153,    -1,   155,   156,   157,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,   166,   167,    -1,
     169,    -1,   171,   172,   173,   174,   175,    -1,   177,   178,
     179,   180,   181,    -1,   183,    -1,   185,   186,    -1,   188,
     189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,   206,    -1,   208,
     209,    -1,   211,   212,   213,   214,   215,    -1,   217,    -1,
      -1,   220,   221,   222,   223,   224,   225,   226,   227,    -1,
     229,   230,   231,    -1,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,    -1,    -1,   265,   266,    -1,    -1,
     269,   270,    -1,    -1,   273,   274,   275,   276,   277,   278,
     279,   280,   281,    -1,   283,   284,   285,   286,    -1,   288,
     289,   290,   291,   292,   293,   294,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,    -1,    -1,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,   325,    -1,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,    -1,   338,
     339,   340,    -1,   342,   343,    -1,   345,    -1,   347,   348,
     349,   350,   351,   352,   353,   354,   355,    -1,   357,   358,
     359,   360,   361,   362,   363,    -1,   365,   366,   367,   368,
     369,   370,   371,   372,    -1,    -1,    -1,   376,   377,   378,
     379,   380,   381,    -1,   383,   384,   385,   386,   387,    -1,
      -1,   390,   391,   392,   393,   394,    -1,    -1,    -1,    -1,
     399,   400,    -1,    -1,   403,   404,    -1,    -1,    -1,   408,
       5,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    -1,    37,    38,    39,    40,    41,    42,    -1,    44,
      45,    46,    -1,    48,    49,    50,    -1,    52,    53,    -1,
      -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,
      -1,    76,    77,    -1,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,   108,   109,    -1,   111,   112,   113,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,    -1,   151,    -1,   153,    -1,
     155,   156,   157,    -1,    -1,    -1,   161,   162,   163,   164,
      -1,   166,   167,    -1,   169,    -1,   171,   172,   173,   174,
     175,    -1,   177,   178,   179,   180,   181,    -1,   183,    -1,
     185,   186,    -1,   188,   189,    -1,   191,    -1,    -1,   194,
      -1,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,    -1,   208,   209,    -1,   211,   212,   213,   214,
     215,    -1,   217,    -1,    -1,   220,   221,   222,   223,   224,
     225,   226,   227,    -1,   229,   230,   231,    -1,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,    -1,    -1,
     265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,   274,
     275,   276,   277,   278,   279,   280,   281,    -1,   283,   284,
     285,   286,    -1,   288,   289,   290,   291,   292,   293,   294,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,    -1,    -1,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,    -1,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,    -1,   338,   339,   340,    -1,   342,   343,    -1,
     345,    -1,   347,   348,   349,   350,   351,   352,   353,   354,
     355,    -1,   357,   358,   359,   360,   361,   362,   363,    -1,
     365,   366,   367,   368,   369,   370,   371,   372,    -1,    -1,
      -1,   376,   377,   378,   379,   380,   381,    -1,   383,   384,
     385,   386,   387,    -1,    -1,   390,   391,   392,   393,   394,
      -1,    -1,    -1,    -1,   399,   400,    -1,    -1,   403,   404,
      -1,    -1,    -1,   408,     5,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    -1,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    -1,    48,    49,    50,
      -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,
      -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,
      -1,    92,    -1,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,    -1,   108,   109,    -1,
     111,   112,   113,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,    -1,
     151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,
     161,   162,   163,   164,    -1,   166,   167,    -1,   169,    -1,
     171,   172,   173,   174,   175,    -1,   177,   178,   179,   180,
     181,    -1,   183,    -1,   185,   186,    -1,   188,   189,    -1,
     191,    -1,    -1,   194,    -1,   196,   197,   198,   199,   200,
     201,   202,   203,   204,   205,   206,    -1,   208,   209,    -1,
     211,   212,   213,   214,   215,    -1,   217,    -1,    -1,   220,
     221,   222,   223,   224,   225,   226,   227,    -1,   229,   230,
     231,    -1,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,    -1,   256,   257,   258,   259,   260,
     261,   262,    -1,    -1,   265,   266,    -1,    -1,   269,   270,
      -1,    -1,   273,   274,   275,   276,   277,   278,   279,   280,
     281,    -1,   283,   284,   285,   286,    -1,   288,   289,   290,
     291,   292,   293,   294,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,    -1,    -1,   315,   316,   317,   318,   319,   320,
     321,   322,   323,   324,   325,    -1,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,    -1,   338,   339,   340,
      -1,   342,   343,    -1,   345,    -1,   347,   348,   349,   350,
     351,   352,   353,   354,   355,    -1,    -1,   358,   359,   360,
     361,   362,   363,    -1,   365,   366,   367,   368,   369,   370,
     371,   372,    -1,    -1,    -1,   376,   377,   378,   379,   380,
     381,    -1,   383,   384,   385,   386,   387,    -1,    -1,   390,
     391,   392,   393,   394,    -1,    -1,    -1,    -1,    -1,   400,
      -1,    -1,   403,   404,    -1,    -1,    -1,   408,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    -1,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    49,    50,    -1,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    -1,
      87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,
      97,    98,    99,   100,   101,    -1,   103,   104,   105,   106,
      -1,   108,   109,    -1,   111,   112,   113,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,    -1,   151,    -1,   153,    -1,   155,   156,
     157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,
     167,    -1,    -1,    -1,   171,   172,   173,   174,   175,    -1,
     177,   178,   179,   180,   181,    -1,   183,    -1,   185,   186,
      -1,   188,   189,    -1,   191,    -1,    -1,   194,    -1,   196,
     197,    -1,   199,   200,   201,    -1,   203,   204,   205,   206,
      -1,   208,   209,    -1,   211,   212,   213,   214,   215,    -1,
     217,    -1,    -1,   220,   221,   222,   223,   224,   225,   226,
     227,    -1,   229,   230,    -1,    -1,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,    -1,   256,
     257,   258,   259,   260,   261,   262,    -1,    -1,   265,   266,
      -1,    -1,   269,   270,    -1,    -1,   273,   274,   275,   276,
     277,   278,   279,   280,   281,    -1,   283,   284,   285,   286,
      -1,   288,   289,   290,   291,   292,   293,   294,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,   315,   316,
     317,   318,   319,   320,   321,   322,    -1,   324,   325,    -1,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
      -1,   338,   339,   340,    -1,   342,   343,    -1,   345,    -1,
     347,   348,   349,   350,   351,   352,   353,   354,   355,    -1,
     357,   358,   359,   360,   361,   362,   363,    -1,   365,   366,
     367,   368,   369,   370,   371,   372,    -1,    -1,    -1,   376,
     377,   378,   379,   380,   381,    -1,   383,   384,   385,   386,
     387,    -1,    -1,   390,   391,   392,   393,   394,    -1,    -1,
      -1,    -1,   399,   400,    -1,    -1,   403,   404,    -1,    -1,
      -1,   408,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    -1,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,    92,
      -1,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,   108,   109,    -1,   111,   112,
     113,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,    -1,   151,    -1,
     153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,
     163,   164,    -1,   166,   167,    -1,   169,    -1,   171,   172,
     173,   174,   175,    -1,   177,   178,   179,   180,   181,    -1,
     183,    -1,   185,   186,    -1,   188,   189,    -1,   191,    -1,
      -1,   194,    -1,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,    -1,   208,   209,    -1,   211,   212,
     213,   214,   215,    -1,   217,    -1,    -1,   220,   221,   222,
     223,   224,   225,   226,   227,    -1,   229,   230,   231,    -1,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,    -1,   256,   257,   258,   259,   260,   261,   262,
      -1,    -1,   265,   266,    -1,    -1,   269,   270,    -1,    -1,
     273,   274,   275,   276,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,    -1,   288,   289,   290,   291,   292,
     293,   294,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
      -1,    -1,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,   325,    -1,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,    -1,   338,   339,   340,    -1,   342,
     343,    -1,   345,    -1,   347,   348,   349,   350,   351,   352,
     353,   354,   355,    -1,    -1,   358,   359,   360,   361,   362,
     363,    -1,   365,   366,   367,   368,   369,   370,   371,   372,
      -1,    -1,    -1,   376,   377,   378,   379,   380,   381,    -1,
     383,   384,    -1,   386,   387,    -1,    -1,   390,   391,   392,
     393,   394,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,   408,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    -1,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,    92,
      -1,    -1,    95,    96,    97,    98,    99,   100,   101,    -1,
     103,   104,   105,   106,    -1,   108,   109,    -1,   111,   112,
     113,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,    -1,   151,    -1,
     153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,
     163,   164,    -1,   166,   167,    -1,    -1,    -1,   171,   172,
     173,   174,   175,    -1,   177,   178,   179,   180,   181,    -1,
     183,    -1,   185,   186,    -1,   188,   189,    -1,   191,    -1,
      -1,   194,    -1,   196,   197,    -1,   199,   200,   201,    -1,
     203,   204,   205,   206,    -1,   208,   209,    -1,   211,   212,
     213,   214,   215,    -1,   217,    -1,    -1,   220,   221,   222,
     223,   224,   225,   226,   227,    -1,   229,   230,    -1,    -1,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,    -1,   256,   257,   258,   259,   260,   261,   262,
      -1,    -1,   265,   266,    -1,    -1,    -1,   270,    -1,    -1,
     273,   274,   275,   276,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,    -1,   288,   289,   290,   291,   292,
     293,   294,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
      -1,    -1,   315,   316,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,    -1,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,    -1,   338,   339,   340,    -1,   342,
     343,    -1,   345,    -1,   347,   348,   349,   350,   351,   352,
     353,   354,   355,    -1,    -1,   358,   359,   360,   361,   362,
     363,    -1,   365,   366,   367,   368,   369,   370,   371,   372,
      -1,    -1,    -1,   376,   377,   378,   379,   380,   381,    -1,
     383,   384,    -1,   386,   387,    -1,    -1,   390,   391,   392,
     393,   394,    -1,    -1,    -1,    -1,    -1,   400,    -1,    -1,
     403,   404,    -1,    -1,    -1,   408,     5,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    -1,    37,    38,
      39,    40,    41,    42,    -1,    44,    45,    46,    -1,    48,
      49,    50,    -1,    52,    53,    -1,    -1,    -1,    57,    58,
      -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    -1,
      -1,    -1,    91,    92,    -1,    -1,    95,    96,    97,    98,
      99,   100,   101,    -1,   103,   104,   105,   106,    -1,   108,
     109,    -1,   111,   112,   113,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,    -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,   166,   167,    -1,
      -1,    -1,   171,   172,   173,   174,   175,    -1,   177,   178,
     179,   180,   181,    -1,   183,    -1,   185,   186,    -1,   188,
     189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,
     199,   200,   201,    -1,   203,   204,   205,   206,    -1,   208,
     209,    -1,   211,   212,   213,   214,   215,    -1,   217,    -1,
      -1,    -1,    -1,   222,   223,   224,   225,   226,   227,    -1,
     229,   230,    -1,    -1,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,    -1,   256,   257,    -1,
     259,   260,   261,   262,    -1,    -1,   265,   266,    -1,    -1,
      -1,   270,    -1,    -1,   273,   274,   275,   276,   277,   278,
     279,   280,   281,    -1,   283,   284,   285,   286,    -1,   288,
     289,   290,   291,   292,   293,   294,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,    -1,    -1,   315,   316,   317,   318,
     319,   320,   321,   322,    -1,   324,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,    -1,   338,
     339,   340,    -1,   342,   343,    -1,   345,    -1,   347,   348,
     349,   350,   351,   352,   353,   354,   355,    -1,   357,   358,
     359,   360,   361,   362,   363,    -1,   365,   366,   367,   368,
     369,   370,   371,   372,    -1,    -1,    -1,   376,   377,   378,
     379,   380,   381,    -1,   383,   384,    -1,   386,   387,    -1,
      -1,   390,   391,   392,   393,   394,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   404,    -1,    -1,    -1,   408,
       5,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    -1,    37,    38,    39,    40,    41,    42,    -1,    44,
      45,    46,    -1,    48,    49,    50,    -1,    52,    53,    -1,
      -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,
      -1,    76,    77,    -1,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    -1,    -1,    -1,    91,    92,    -1,    -1,
      95,    96,    97,    98,    99,   100,   101,    -1,   103,   104,
     105,   106,    -1,   108,   109,    -1,   111,   112,   113,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,    -1,   151,    -1,   153,    -1,
     155,   156,   157,    -1,    -1,    -1,   161,   162,   163,   164,
      -1,   166,   167,    -1,    -1,    -1,   171,   172,   173,   174,
     175,    -1,   177,   178,   179,   180,   181,    -1,   183,    -1,
     185,   186,    -1,   188,   189,    -1,   191,    -1,    -1,   194,
      -1,   196,   197,    -1,   199,   200,   201,    -1,   203,   204,
     205,   206,    -1,   208,   209,    -1,   211,   212,   213,   214,
     215,    -1,   217,    -1,    -1,    -1,    -1,   222,   223,   224,
     225,   226,   227,    -1,   229,   230,    -1,    -1,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
      -1,   256,   257,    -1,   259,   260,   261,   262,    -1,    -1,
     265,   266,    -1,    -1,    -1,   270,    -1,    -1,   273,   274,
     275,   276,   277,   278,   279,   280,   281,    -1,   283,   284,
     285,   286,    -1,   288,   289,   290,   291,   292,   293,   294,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,    -1,    -1,
     315,   316,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,    -1,   338,   339,   340,    -1,   342,   343,    -1,
     345,    -1,   347,   348,   349,   350,   351,   352,   353,   354,
     355,    -1,   357,   358,   359,   360,   361,   362,   363,    -1,
     365,   366,   367,   368,   369,   370,   371,   372,    -1,    -1,
      -1,   376,   377,   378,   379,   380,   381,    -1,   383,   384,
      -1,   386,   387,    -1,    -1,   390,   391,   392,   393,   394,
       5,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,   408,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    -1,    37,    38,    39,    40,    41,    42,    -1,    44,
      45,    46,    -1,    48,    49,    50,    -1,    52,    53,    -1,
      -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,
      -1,    76,    77,    -1,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,
      95,    96,    97,    98,    99,   100,   101,    -1,   103,   104,
     105,   106,    -1,   108,   109,    -1,   111,   112,   113,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,    -1,   151,    -1,   153,    -1,
     155,   156,   157,    -1,    -1,    -1,   161,   162,   163,   164,
      -1,   166,   167,    -1,    -1,    -1,   171,   172,   173,   174,
     175,    -1,   177,   178,   179,   180,   181,    -1,   183,    -1,
     185,   186,    -1,   188,   189,    -1,   191,    -1,    -1,   194,
      -1,   196,   197,    -1,   199,   200,   201,    -1,   203,   204,
     205,   206,    -1,   208,   209,    -1,   211,   212,   213,   214,
     215,    -1,   217,    -1,    -1,    -1,    -1,   222,   223,   224,
     225,   226,   227,    -1,   229,   230,    -1,    -1,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
      -1,   256,   257,    -1,    -1,   260,   261,   262,    -1,    -1,
     265,   266,    -1,    -1,    -1,   270,    -1,    -1,   273,   274,
     275,   276,   277,   278,   279,   280,   281,    -1,   283,   284,
     285,   286,    -1,   288,   289,   290,   291,   292,   293,   294,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,    -1,    -1,
     315,   316,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,    -1,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,    -1,   338,   339,   340,    -1,   342,   343,    -1,
     345,    -1,   347,   348,   349,   350,   351,   352,   353,   354,
     355,    -1,    -1,   358,   359,   360,   361,   362,   363,    -1,
     365,   366,   367,   368,   369,   370,   371,   372,    -1,    -1,
      -1,   376,   377,   378,   379,   380,   381,    -1,   383,   384,
      -1,   386,   387,    -1,    -1,   390,   391,   392,   393,   394,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   404,
      -1,    -1,    -1,   408,     5,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    -1,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    -1,    48,    49,    50,
      -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,
      -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,
      -1,    92,    -1,    -1,    95,    96,    97,    98,    99,   100,
     101,    -1,   103,   104,   105,   106,    -1,   108,   109,    -1,
     111,   112,   113,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,    -1,
     151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,
     161,   162,   163,   164,    -1,   166,   167,    -1,    -1,    -1,
     171,   172,   173,   174,   175,    -1,   177,   178,   179,   180,
     181,    -1,   183,    -1,   185,   186,    -1,   188,   189,    -1,
     191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,
     201,    -1,   203,   204,   205,   206,    -1,   208,   209,    -1,
     211,   212,   213,   214,   215,    -1,   217,    -1,    -1,    -1,
      -1,   222,   223,   224,   225,   226,   227,    -1,   229,   230,
      -1,    -1,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,    -1,   256,   257,    -1,    -1,   260,
     261,   262,    -1,    -1,   265,   266,    -1,    -1,    -1,   270,
      -1,    -1,   273,   274,   275,   276,   277,   278,   279,   280,
     281,    -1,   283,   284,   285,   286,    -1,   288,   289,   290,
     291,   292,   293,   294,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,    -1,    -1,   315,   316,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,    -1,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,    -1,   338,   339,   340,
      -1,   342,   343,    -1,   345,    -1,   347,   348,   349,   350,
     351,   352,   353,   354,   355,    -1,    -1,   358,   359,   360,
     361,   362,   363,    -1,   365,   366,   367,   368,   369,   370,
     371,   372,    -1,    -1,    -1,   376,   377,   378,   379,   380,
     381,    -1,   383,   384,    -1,   386,   387,    -1,    -1,   390,
     391,   392,   393,   394,    -1,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,   408,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    35,    -1,    37,    38,    39,    40,
      -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,
      -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,
      -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,
      -1,    -1,    93,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,
      -1,   142,   143,   144,   145,   146,   147,   148,   149,    -1,
     151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,
     161,   162,   163,   164,    -1,   166,   167,    -1,   169,   170,
     171,   172,   173,   174,   175,    -1,   177,    -1,   179,   180,
     181,   182,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,
     191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,
     201,    -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,
     211,   212,   213,    -1,   215,   216,   217,    -1,    -1,    -1,
      -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,   230,
      -1,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,    -1,   248,    -1,   250,
     251,   252,   253,   254,    -1,   256,   257,    -1,    -1,   260,
     261,   262,    -1,   264,   265,    -1,    -1,    -1,   269,   270,
      -1,   272,   273,    -1,    -1,    -1,   277,   278,   279,   280,
     281,    -1,   283,   284,   285,   286,    -1,   288,   289,   290,
     291,   292,   293,   294,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,    -1,   306,   307,   308,   309,   310,
     311,   312,    -1,    -1,   315,   316,   317,    -1,   319,   320,
     321,   322,    -1,   324,   325,    -1,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,    -1,   338,   339,   340,
      -1,   342,   343,    -1,   345,    -1,   347,   348,   349,   350,
      -1,   352,   353,   354,   355,   356,    -1,   358,   359,   360,
     361,   362,    -1,    -1,   365,   366,   367,   368,   369,     5,
     371,   372,    -1,    -1,    -1,   376,   377,   378,   379,   380,
     381,    -1,   383,    -1,    20,   386,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    29,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    41,    42,    -1,   409,    -1,
      -1,    -1,    -1,    49,    50,    -1,    -1,    -1,    54,    55,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   115,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   181,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   197,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   214,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   240,    -1,    -1,   243,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   259,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   312,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   344,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     356,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   368,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   380,    -1,    -1,   383,   384,    -1,
     386,    -1,    -1,    -1,    -1,    -1,   392,    -1,   394,   395,
      -1,    -1,    -1,   399,   400,   401,   402,   403,    -1,    -1,
     406,   407,   408,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,
      -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,   137,    -1,    -1,    -1,    -1,   142,
     143,   144,   145,   146,   147,   148,   149,    -1,   151,    -1,
     153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,
     163,   164,    -1,   166,   167,    -1,   169,    -1,   171,   172,
     173,   174,   175,    -1,   177,    -1,   179,   180,   181,    -1,
     183,    -1,   185,   186,    -1,   188,   189,    -1,   191,    -1,
      -1,   194,    -1,   196,   197,   198,   199,   200,   201,   202,
     203,   204,   205,   206,    -1,   208,   209,    -1,   211,   212,
     213,    -1,   215,    -1,   217,    -1,    -1,   220,   221,   222,
     223,   224,   225,   226,   227,    -1,   229,   230,   231,    -1,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,   252,
     253,   254,    -1,   256,   257,   258,    -1,   260,   261,   262,
      -1,    -1,   265,   266,    -1,   268,   269,   270,    -1,    -1,
     273,   274,   275,    -1,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,    -1,   288,   289,   290,   291,   292,
     293,   294,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
      -1,   314,   315,   316,   317,    -1,   319,   320,   321,   322,
     323,   324,   325,    -1,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,    -1,   338,   339,   340,    -1,   342,
     343,    -1,   345,    -1,   347,   348,   349,   350,    -1,   352,
     353,   354,   355,    -1,    -1,   358,   359,   360,   361,   362,
      -1,    -1,   365,   366,   367,   368,   369,   370,   371,   372,
      -1,    -1,    -1,   376,   377,   378,   379,   380,   381,    -1,
     383,    -1,    -1,   386,    -1,    -1,    -1,    -1,    -1,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,   408,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    35,    -1,
      37,    38,    39,    40,    -1,    -1,    -1,    44,    45,    46,
      -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    -1,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
     137,    -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,
     147,   148,   149,    -1,   151,    -1,   153,    -1,   155,   156,
     157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,
     167,    -1,   169,    -1,   171,   172,   173,   174,   175,    -1,
     177,    -1,   179,   180,   181,    -1,   183,    -1,   185,   186,
      -1,   188,   189,    -1,   191,    -1,    -1,   194,    -1,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
      -1,   208,   209,    -1,   211,   212,   213,    -1,   215,    -1,
     217,    -1,    -1,   220,   221,   222,   223,   224,   225,   226,
     227,    -1,   229,   230,   231,    -1,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,    -1,   256,
     257,   258,    -1,   260,   261,   262,    -1,    -1,   265,   266,
      -1,   268,   269,   270,    -1,    -1,   273,   274,   275,    -1,
     277,   278,   279,   280,   281,    -1,   283,   284,   285,   286,
      -1,   288,   289,   290,   291,   292,   293,   294,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,   315,   316,
     317,    -1,   319,   320,   321,   322,   323,   324,   325,    -1,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
      -1,   338,   339,   340,    -1,   342,   343,    -1,   345,    -1,
     347,   348,   349,   350,    -1,   352,   353,   354,   355,    -1,
      -1,   358,   359,   360,   361,   362,    -1,    -1,   365,   366,
     367,   368,   369,   370,   371,   372,    -1,    -1,    -1,   376,
     377,   378,   379,   380,   381,    -1,   383,    -1,    -1,   386,
      -1,    -1,    -1,    -1,    -1,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,   408,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    35,    -1,    37,    38,    39,    40,
      -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,
      -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,
      -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,   137,    -1,    -1,    -1,
      -1,   142,   143,   144,   145,   146,   147,   148,   149,    -1,
     151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,
     161,   162,   163,   164,    -1,   166,   167,    -1,   169,    -1,
     171,   172,   173,   174,   175,    -1,   177,    -1,   179,   180,
     181,    -1,   183,    -1,   185,   186,    -1,   188,   189,    -1,
     191,    -1,    -1,   194,    -1,   196,   197,   198,   199,   200,
     201,   202,   203,   204,   205,   206,    -1,   208,   209,    -1,
     211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,   220,
     221,   222,   223,   224,   225,   226,   227,    -1,   229,   230,
     231,    -1,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,    -1,   256,   257,   258,    -1,   260,
     261,   262,    -1,    -1,   265,   266,    -1,    -1,   269,   270,
      -1,    -1,   273,   274,   275,    -1,   277,   278,   279,   280,
     281,    -1,   283,   284,   285,   286,    -1,   288,   289,   290,
     291,   292,   293,   294,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,    -1,    -1,   315,   316,   317,    -1,   319,   320,
     321,   322,   323,   324,   325,    -1,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,    -1,   338,   339,   340,
      -1,   342,   343,    -1,   345,    -1,   347,   348,   349,   350,
      -1,   352,   353,   354,   355,    -1,    -1,   358,   359,   360,
     361,   362,    -1,    -1,   365,   366,   367,   368,   369,   370,
     371,   372,    -1,    -1,    -1,   376,   377,   378,   379,   380,
     381,    -1,   383,    -1,    -1,   386,    -1,    -1,    -1,    -1,
      -1,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,   408,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,
      45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,
      -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,
      -1,    76,    77,    -1,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,
     145,   146,   147,   148,   149,    -1,   151,    -1,   153,    -1,
     155,   156,   157,    -1,    -1,    -1,   161,   162,   163,   164,
      -1,   166,   167,    -1,   169,    -1,   171,   172,   173,   174,
     175,    -1,   177,    -1,   179,   180,   181,    -1,   183,    -1,
     185,    -1,    -1,    -1,   189,    -1,   191,    -1,    -1,   194,
      -1,   196,   197,    -1,   199,   200,   201,    -1,   203,   204,
     205,   206,    -1,    -1,   209,    -1,   211,   212,   213,    -1,
     215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,
     225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,    -1,   248,    -1,   250,   251,   252,   253,   254,
      -1,   256,   257,    -1,    -1,   260,   261,   262,    -1,    -1,
     265,    -1,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,
      -1,    -1,   277,   278,   279,   280,   281,    -1,   283,   284,
     285,   286,    -1,   288,   289,   290,   291,   292,   293,   294,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
      -1,   306,   307,   308,   309,   310,   311,   312,    -1,    -1,
     315,   316,   317,    -1,   319,   320,   321,   322,    -1,   324,
     325,    -1,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,    -1,   338,   339,   340,    -1,   342,   343,    -1,
     345,    -1,   347,   348,   349,   350,    -1,   352,   353,   354,
     355,    -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,    -1,
      -1,   376,   377,   378,   379,   380,   381,    -1,   383,   384,
      -1,   386,   387,    -1,    -1,    -1,    -1,   392,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   407,   408,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    35,    -1,    37,    38,    39,    40,    -1,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,
      52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,
      -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      72,    -1,    74,    -1,    76,    77,    -1,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,
     142,   143,   144,   145,   146,   147,   148,   149,    -1,   151,
      -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,   166,   167,    -1,   169,    -1,   171,
     172,   173,   174,   175,    -1,   177,    -1,   179,   180,   181,
      -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,
      -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,   201,
      -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,   211,
     212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,
     222,    -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,
      -1,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,    -1,   248,    -1,   250,   251,
     252,   253,   254,    -1,   256,   257,    -1,    -1,   260,   261,
     262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,
      -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,   281,
      -1,   283,   284,   285,   286,    -1,   288,   289,   290,   291,
     292,   293,   294,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,    -1,   306,   307,   308,   309,   310,   311,
     312,    -1,    -1,   315,   316,   317,    -1,   319,   320,   321,
     322,    -1,   324,   325,    -1,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,    -1,   338,   339,   340,    -1,
     342,   343,    -1,   345,    -1,   347,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,    -1,   358,   359,   360,   361,
     362,    -1,    -1,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,    -1,    -1,   376,   377,   378,   379,   380,   381,
      -1,   383,   384,    -1,   386,   387,    -1,    -1,    -1,    -1,
     392,    -1,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,   408,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,
      -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,
      74,    -1,    76,    77,    -1,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,
     144,   145,   146,   147,   148,   149,    -1,   151,    -1,   153,
      -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,   163,
     164,    -1,   166,   167,    -1,   169,    -1,   171,   172,   173,
     174,   175,    -1,   177,    -1,   179,   180,   181,    -1,   183,
      -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,    -1,
     194,    -1,   196,   197,    -1,   199,   200,   201,    -1,   203,
     204,   205,   206,    -1,    -1,   209,    -1,   211,   212,   213,
      -1,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,
     224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,    -1,   248,   249,   250,   251,   252,   253,
     254,    -1,   256,   257,    -1,    -1,   260,   261,   262,    -1,
      -1,   265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,
      -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,   283,
     284,   285,   286,    -1,   288,   289,   290,   291,   292,   293,
     294,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,    -1,   306,   307,   308,   309,   310,   311,   312,    -1,
      -1,   315,   316,   317,    -1,   319,   320,   321,   322,    -1,
     324,   325,    -1,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,    -1,   338,   339,   340,    -1,   342,   343,
      -1,   345,    -1,   347,   348,   349,   350,    -1,   352,   353,
     354,   355,    -1,    -1,   358,   359,   360,   361,   362,    -1,
      -1,   365,   366,   367,   368,   369,    -1,   371,   372,    -1,
      -1,    -1,   376,   377,   378,   379,   380,   381,    -1,   383,
      -1,    -1,   386,    -1,    -1,    -1,    -1,    -1,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,   408,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    57,
      58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,
      -1,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
      -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,   147,
     148,   149,    -1,   151,    -1,   153,    -1,   155,   156,   157,
      -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,   167,
      -1,   169,    -1,   171,   172,   173,   174,   175,    -1,   177,
      -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,
      -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,
      -1,   199,   200,   201,    -1,   203,   204,   205,   206,    -1,
      -1,   209,    -1,   211,   212,   213,    -1,   215,    -1,   217,
      -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,
      -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,    -1,
     248,    -1,   250,   251,   252,   253,   254,    -1,   256,   257,
      -1,    -1,   260,   261,   262,    -1,    -1,   265,    -1,    -1,
      -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,
     278,   279,   280,   281,    -1,   283,   284,   285,   286,    -1,
     288,   289,   290,   291,   292,   293,   294,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,    -1,   306,   307,
     308,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
      -1,   319,   320,   321,   322,    -1,   324,   325,    -1,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,    -1,
     338,   339,   340,    -1,   342,   343,    -1,   345,    -1,   347,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,    -1,
     358,   359,   360,   361,   362,    -1,    -1,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,
     378,   379,   380,   381,    -1,   383,    -1,    -1,   386,   387,
      -1,    -1,    -1,    -1,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
     408,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    35,    -1,    37,    38,    39,    40,    -1,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,
      52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,
      -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      72,    -1,    74,    -1,    76,    77,    -1,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,
     142,   143,   144,   145,   146,   147,   148,   149,    -1,   151,
      -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,   166,   167,    -1,   169,    -1,   171,
     172,   173,   174,   175,    -1,   177,    -1,   179,   180,   181,
      -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,
      -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,   201,
      -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,   211,
     212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,
     222,    -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,
      -1,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,    -1,   248,    -1,   250,   251,
     252,   253,   254,    -1,   256,   257,    -1,    -1,   260,   261,
     262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,
      -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,   281,
      -1,   283,   284,   285,   286,    -1,   288,   289,   290,   291,
     292,   293,   294,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,    -1,   306,   307,   308,   309,   310,   311,
     312,    -1,   314,   315,   316,   317,    -1,   319,   320,   321,
     322,    -1,   324,   325,    -1,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,    -1,   338,   339,   340,    -1,
     342,   343,    -1,   345,    -1,   347,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,    -1,   358,   359,   360,   361,
     362,    -1,    -1,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,    -1,    -1,   376,   377,   378,   379,   380,   381,
      -1,   383,    -1,    -1,   386,    -1,    -1,    -1,    -1,    -1,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,   408,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    35,
      -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,
      -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,
      76,    77,    -1,    79,    80,    81,    82,    83,    84,    85,
      -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,
     146,   147,   148,   149,    -1,   151,    -1,   153,    -1,   155,
     156,   157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,   167,    -1,   169,    -1,   171,   172,   173,   174,   175,
      -1,   177,    -1,   179,   180,   181,    -1,   183,    -1,   185,
      -1,    -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,
     196,   197,    -1,   199,   200,   201,    -1,   203,   204,   205,
     206,    -1,    -1,   209,    -1,   211,   212,   213,    -1,   215,
      -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,
     226,   227,    -1,    -1,   230,    -1,    -1,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,    -1,   248,    -1,   250,   251,   252,   253,   254,    -1,
     256,   257,    -1,    -1,   260,   261,   262,    -1,    -1,   265,
      -1,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,    -1,
      -1,   277,   278,   279,   280,   281,    -1,   283,   284,   285,
     286,    -1,   288,   289,   290,   291,   292,   293,   294,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,    -1,
     306,   307,   308,   309,   310,   311,   312,    -1,    -1,   315,
     316,   317,    -1,   319,   320,   321,   322,    -1,   324,   325,
      -1,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,    -1,   338,   339,   340,    -1,   342,   343,    -1,   345,
      -1,   347,   348,   349,   350,    -1,   352,   353,   354,   355,
      -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,   365,
     366,   367,   368,   369,    -1,   371,   372,    -1,    -1,    -1,
     376,   377,   378,   379,   380,   381,    -1,   383,    -1,    -1,
     386,    -1,    -1,    -1,    -1,    -1,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,   408,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      -1,    -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,
      -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,    -1,    -1,
      -1,    -1,   142,   143,   144,   145,   146,   147,   148,   149,
      -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,
      -1,   161,   162,   163,   164,    -1,   166,   167,    -1,   169,
      -1,   171,   172,   173,   174,   175,    -1,   177,    -1,   179,
     180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,
      -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,
     200,   201,    -1,   203,   204,   205,   206,    -1,    -1,   209,
      -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,
      -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,
     230,    -1,    -1,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,    -1,   248,    -1,
     250,   251,   252,   253,   254,    -1,   256,   257,    -1,    -1,
     260,   261,   262,    -1,    -1,   265,    -1,    -1,    -1,   269,
     270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,
     280,   281,    -1,   283,   284,   285,   286,    -1,   288,   289,
     290,   291,   292,   293,   294,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,    -1,   306,   307,   308,   309,
     310,   311,   312,    -1,    -1,   315,   316,   317,    -1,   319,
     320,   321,   322,    -1,   324,   325,    -1,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,    -1,   338,   339,
     340,    -1,   342,   343,    -1,   345,    -1,   347,   348,   349,
     350,    -1,   352,   353,   354,   355,    -1,    -1,   358,   359,
     360,   361,   362,    -1,    -1,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,   379,
     380,   381,    -1,   383,    -1,    -1,   386,    -1,    -1,    -1,
      -1,     5,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,   408,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    -1,    37,    38,    39,    40,    41,    42,    -1,
      44,    45,    46,    -1,    48,    49,    50,    -1,    52,    53,
      -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,
      74,    -1,    76,    77,    -1,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,   106,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,    -1,
      -1,    -1,   126,   127,   128,    -1,   130,   131,    -1,   133,
      -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,
     144,   145,   146,   147,   148,   149,    -1,   151,    -1,   153,
      -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,   163,
     164,    -1,   166,   167,    -1,   169,    -1,   171,   172,   173,
      -1,   175,    -1,    -1,    -1,   179,   180,   181,    -1,   183,
      -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,    -1,
     194,    -1,   196,   197,    -1,   199,   200,   201,    -1,   203,
     204,   205,   206,    -1,    -1,   209,    -1,   211,   212,   213,
     214,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,
     224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,    -1,   248,    -1,   250,   251,   252,   253,
      -1,    -1,   256,   257,    -1,    -1,    -1,   261,   262,    -1,
      -1,   265,    -1,    -1,    -1,   269,   270,    -1,    -1,   273,
      -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,    -1,
     284,   285,   286,    -1,   288,   289,   290,   291,   292,   293,
     294,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,    -1,   306,    -1,   308,   309,   310,   311,   312,    -1,
      -1,   315,   316,   317,    -1,   319,   320,   321,   322,    -1,
     324,   325,    -1,   327,   328,   329,   330,   331,   332,   333,
     334,    -1,   336,    -1,   338,   339,   340,    -1,   342,   343,
      -1,   345,    -1,   347,    -1,   349,    -1,    -1,   352,   353,
     354,   355,    -1,    -1,   358,   359,   360,   361,   362,    -1,
      -1,   365,   366,   367,   368,   369,    -1,   371,   372,    -1,
      -1,    -1,   376,   377,   378,   379,   380,   381,    -1,   383,
     384,   385,   386,   387,    -1,    -1,    -1,    -1,   392,    -1,
     394,   395,   396,   397,    -1,   399,   400,   401,   402,   403,
     404,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,
      45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,
      -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,
      -1,    76,    77,    -1,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,
     145,   146,   147,   148,   149,    -1,   151,    -1,   153,    -1,
     155,   156,   157,    -1,    -1,    -1,   161,   162,   163,   164,
      -1,   166,   167,    -1,   169,    -1,   171,   172,   173,   174,
     175,    -1,   177,    -1,   179,   180,   181,    -1,   183,    -1,
     185,    -1,    -1,    -1,   189,    -1,   191,    -1,    -1,   194,
      -1,   196,   197,    -1,   199,   200,   201,    -1,   203,   204,
     205,   206,    -1,    -1,   209,    -1,   211,   212,   213,    -1,
     215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,
     225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,    -1,   248,    -1,   250,   251,   252,   253,   254,
      -1,   256,   257,    -1,    -1,   260,   261,   262,    -1,    -1,
     265,    -1,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,
      -1,    -1,   277,   278,   279,   280,   281,    -1,   283,   284,
     285,   286,    -1,   288,   289,   290,   291,   292,   293,   294,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
      -1,   306,   307,   308,   309,   310,   311,   312,    -1,    -1,
     315,   316,   317,    -1,   319,   320,   321,   322,    -1,   324,
     325,    -1,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,    -1,   338,   339,   340,    -1,   342,   343,    -1,
     345,    -1,   347,   348,   349,   350,    -1,   352,   353,   354,
     355,    -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,    -1,
      -1,   376,   377,   378,   379,   380,   381,    -1,   383,    -1,
     385,   386,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     395,   396,   397,    -1,   399,   400,   401,   402,   403,   404,
       5,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    -1,    37,    38,    39,    40,    41,    42,    -1,    44,
      45,    46,    -1,    48,    49,    50,    -1,    52,    53,    -1,
      -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,
      -1,    76,    77,    -1,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,   106,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,    -1,    -1,
      -1,   126,   127,   128,    -1,   130,   131,    -1,   133,    -1,
     135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,
     145,   146,   147,   148,   149,    -1,   151,    -1,   153,    -1,
     155,   156,   157,    -1,    -1,    -1,   161,   162,   163,   164,
      -1,   166,   167,    -1,   169,    -1,   171,   172,   173,    -1,
     175,    -1,    -1,    -1,   179,   180,   181,    -1,   183,    -1,
     185,    -1,    -1,    -1,   189,    -1,   191,    -1,    -1,   194,
      -1,   196,   197,    -1,   199,   200,   201,    -1,   203,   204,
     205,   206,    -1,    -1,   209,    -1,   211,   212,   213,   214,
     215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,
     225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,    -1,   248,    -1,   250,   251,   252,   253,    -1,
      -1,   256,   257,    -1,    -1,    -1,   261,   262,    -1,    -1,
     265,    -1,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,
      -1,    -1,   277,   278,   279,   280,   281,    -1,    -1,   284,
     285,   286,    -1,   288,   289,   290,   291,   292,   293,   294,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
      -1,   306,    -1,   308,   309,   310,   311,   312,    -1,    -1,
     315,   316,   317,    -1,   319,   320,   321,   322,    -1,   324,
     325,    -1,   327,   328,   329,   330,   331,   332,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,   342,   343,    -1,
     345,    -1,   347,    -1,   349,    -1,    -1,   352,   353,   354,
     355,    -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,    -1,
      -1,   376,   377,   378,   379,   380,   381,    -1,   383,    -1,
      -1,   386,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,   401,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,
      -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,
      74,    -1,    76,    77,    -1,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,
     144,   145,   146,   147,   148,   149,    -1,   151,    -1,   153,
      -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,   163,
     164,    -1,   166,   167,    -1,   169,    -1,   171,   172,   173,
     174,   175,    -1,   177,    -1,   179,   180,   181,    -1,   183,
      -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,    -1,
     194,    -1,   196,   197,    -1,   199,   200,   201,    -1,   203,
     204,   205,   206,    -1,    -1,   209,    -1,   211,   212,   213,
      -1,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,
     224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,    -1,   248,   249,   250,   251,   252,   253,
     254,    -1,   256,   257,    -1,    -1,   260,   261,   262,    -1,
      -1,   265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,
      -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,   283,
     284,   285,   286,    -1,   288,   289,   290,   291,   292,   293,
     294,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,    -1,   306,   307,   308,   309,   310,   311,   312,    -1,
      -1,   315,   316,   317,    -1,   319,   320,   321,   322,    -1,
     324,   325,    -1,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,    -1,   338,   339,   340,    -1,   342,   343,
      -1,   345,    -1,   347,   348,   349,   350,    -1,   352,   353,
     354,   355,    -1,    -1,   358,   359,   360,   361,   362,    -1,
      -1,   365,   366,   367,   368,   369,    -1,   371,   372,    -1,
      -1,    -1,   376,   377,   378,   379,   380,   381,    -1,   383,
      -1,    -1,   386,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,   401,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,
      -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,
     143,   144,   145,   146,   147,   148,   149,    -1,   151,    -1,
     153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,
     163,   164,    -1,   166,   167,    -1,   169,    -1,   171,   172,
     173,   174,   175,    -1,   177,    -1,   179,   180,   181,    -1,
     183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,
      -1,   194,    -1,   196,   197,    -1,   199,   200,   201,    -1,
     203,   204,   205,   206,    -1,    -1,   209,    -1,   211,   212,
     213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,
      -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,    -1,   248,    -1,   250,   251,   252,
     253,   254,    -1,   256,   257,    -1,    -1,   260,   261,   262,
      -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,    -1,
     273,    -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,    -1,   288,   289,   290,   291,   292,
     293,   294,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,    -1,   306,   307,   308,   309,   310,   311,   312,
      -1,    -1,   315,   316,   317,    -1,   319,   320,   321,   322,
      -1,   324,   325,    -1,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,    -1,   338,   339,   340,    -1,   342,
     343,    -1,   345,    -1,   347,   348,   349,   350,    -1,   352,
     353,   354,   355,    -1,    -1,   358,   359,   360,   361,   362,
      -1,    -1,   365,   366,   367,   368,   369,    -1,   371,   372,
      -1,    -1,    -1,   376,   377,   378,   379,   380,   381,    -1,
     383,    -1,    -1,   386,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,   401,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    35,    -1,    37,    38,    39,    40,    -1,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,
      52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,
      -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      72,    -1,    74,    -1,    76,    77,    -1,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
      -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,   166,   167,    -1,   169,    -1,   171,
     172,   173,   174,   175,    -1,   177,   178,   179,   180,   181,
      -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,
      -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,   201,
      -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,   211,
     212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,
     222,    -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,
      -1,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,    -1,   248,    -1,   250,   251,
     252,   253,   254,    -1,   256,   257,    -1,    -1,   260,   261,
     262,   263,    -1,   265,    -1,   267,    -1,   269,   270,    -1,
      -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,   281,
      -1,   283,   284,   285,   286,    -1,   288,   289,   290,   291,
     292,   293,   294,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,    -1,   306,   307,   308,   309,   310,   311,
     312,    -1,    -1,   315,   316,   317,    -1,   319,   320,   321,
     322,    -1,   324,   325,    -1,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,    -1,   338,   339,   340,    -1,
     342,   343,    -1,   345,    -1,   347,   348,   349,   350,   351,
     352,   353,   354,   355,    -1,    -1,   358,   359,   360,   361,
     362,    -1,    -1,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,    -1,    -1,   376,   377,   378,   379,   380,   381,
      -1,   383,   384,    -1,   386,   387,    -1,    -1,    -1,    -1,
     392,    -1,   394,    -1,     6,     7,     8,     9,   400,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    35,    -1,    37,    38,    39,    40,    -1,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,
      52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,
      -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      72,    -1,    74,    -1,    76,    77,    -1,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,
     142,   143,   144,   145,   146,   147,   148,   149,    -1,   151,
      -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,   166,   167,    -1,   169,    -1,   171,
     172,   173,   174,   175,    -1,   177,   178,   179,   180,   181,
      -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,
      -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,   201,
      -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,   211,
     212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,
     222,    -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,
      -1,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,    -1,   248,    -1,   250,   251,
     252,   253,   254,    -1,   256,   257,    -1,    -1,   260,   261,
     262,   263,    -1,   265,    -1,   267,    -1,   269,   270,    -1,
      -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,   281,
      -1,   283,   284,   285,   286,    -1,   288,   289,   290,   291,
     292,   293,   294,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,    -1,   306,   307,   308,   309,   310,   311,
     312,    -1,    -1,   315,   316,   317,    -1,   319,   320,   321,
     322,    -1,   324,   325,    -1,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,    -1,   338,   339,   340,    -1,
     342,   343,    -1,   345,    -1,   347,   348,   349,   350,   351,
     352,   353,   354,   355,    -1,    -1,   358,   359,   360,   361,
     362,    -1,    -1,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,    -1,    -1,   376,   377,   378,   379,   380,   381,
      -1,   383,   384,    -1,   386,   387,    -1,    -1,    -1,    -1,
     392,    -1,   394,    -1,     6,     7,     8,     9,   400,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    35,    -1,    37,    38,    39,    40,    -1,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,
      52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,
      -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      72,    -1,    74,    -1,    76,    77,    -1,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,
     142,   143,   144,   145,   146,   147,   148,   149,    -1,   151,
      -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,   166,   167,    -1,   169,    -1,   171,
     172,   173,   174,   175,    -1,   177,    -1,   179,   180,   181,
      -1,   183,    -1,   185,    -1,   187,    -1,   189,    -1,   191,
      -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,   201,
     202,   203,   204,   205,   206,    -1,    -1,   209,    -1,   211,
     212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,
     222,    -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,
      -1,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,    -1,   248,    -1,   250,   251,
     252,   253,   254,    -1,   256,   257,    -1,    -1,   260,   261,
     262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,
      -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,   281,
      -1,   283,   284,   285,   286,    -1,   288,   289,   290,   291,
     292,   293,   294,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,    -1,   306,   307,   308,   309,   310,   311,
     312,    -1,    -1,   315,   316,   317,    -1,   319,   320,   321,
     322,    -1,   324,   325,    -1,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,    -1,   338,   339,   340,    -1,
     342,   343,    -1,   345,    -1,   347,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,    -1,   358,   359,   360,   361,
     362,    -1,    -1,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,    -1,    -1,   376,   377,   378,   379,   380,   381,
      -1,   383,    -1,    -1,   386,   387,     6,     7,     8,     9,
     392,    11,    12,    -1,    14,    15,    16,    17,   400,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      -1,    -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,
      -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,    -1,    -1,
      -1,    -1,   142,   143,   144,   145,   146,   147,   148,   149,
      -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,
      -1,   161,   162,   163,   164,    -1,   166,   167,    -1,   169,
      -1,   171,   172,   173,   174,   175,    -1,   177,    -1,   179,
     180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,
      -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,
     200,   201,    -1,   203,   204,   205,   206,    -1,    -1,   209,
      -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,
      -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,
     230,    -1,    -1,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,    -1,   248,    -1,
     250,   251,   252,   253,   254,    -1,   256,   257,    -1,    -1,
     260,   261,   262,    -1,    -1,   265,    -1,    -1,    -1,   269,
     270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,
     280,   281,    -1,   283,   284,   285,   286,    -1,   288,   289,
     290,   291,   292,   293,   294,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,    -1,   306,   307,   308,   309,
     310,   311,   312,    -1,    -1,   315,   316,   317,    -1,   319,
     320,   321,   322,    -1,   324,   325,    -1,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,    -1,   338,   339,
     340,    -1,   342,   343,    -1,   345,    -1,   347,   348,   349,
     350,    -1,   352,   353,   354,   355,    -1,    -1,   358,   359,
     360,   361,   362,    -1,    -1,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,   379,
     380,   381,    -1,   383,    -1,    -1,   386,   387,     6,     7,
       8,     9,   392,    11,    12,    -1,    14,    15,    16,    17,
     400,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    57,
      58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,
      -1,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
      -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,    -1,   153,    -1,   155,   156,   157,
      -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,   167,
      -1,   169,    -1,   171,   172,   173,   174,   175,    -1,   177,
      -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,
      -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,
      -1,   199,   200,   201,    -1,   203,   204,   205,   206,    -1,
      -1,   209,    -1,   211,   212,   213,    -1,   215,    -1,   217,
      -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,
      -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,    -1,
     248,    -1,   250,   251,   252,   253,   254,    -1,   256,   257,
      -1,    -1,   260,   261,   262,    -1,    -1,   265,    -1,    -1,
      -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,
     278,   279,   280,   281,    -1,   283,   284,   285,   286,    -1,
     288,   289,   290,   291,   292,   293,   294,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,    -1,   306,   307,
     308,   309,   310,   311,   312,    -1,    -1,   315,   316,   317,
      -1,   319,   320,   321,   322,    -1,   324,   325,    -1,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,    -1,
     338,   339,   340,    -1,   342,   343,   344,   345,    -1,   347,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,    -1,
     358,   359,   360,   361,   362,    -1,    -1,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,
     378,   379,   380,   381,    -1,   383,   384,    -1,   386,   387,
       6,     7,     8,     9,    -1,    11,    12,   395,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    35,
      -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,
      -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,
      76,    77,    -1,    79,    80,    81,    82,    83,    84,    85,
      -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,
     146,   147,   148,   149,    -1,   151,    -1,   153,    -1,   155,
     156,   157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,   167,    -1,   169,    -1,   171,   172,   173,   174,   175,
      -1,   177,    -1,   179,   180,   181,    -1,   183,    -1,   185,
      -1,    -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,
     196,   197,    -1,   199,   200,   201,    -1,   203,   204,   205,
     206,    -1,    -1,   209,    -1,   211,   212,   213,    -1,   215,
      -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,
     226,   227,    -1,    -1,   230,    -1,    -1,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,    -1,   248,    -1,   250,   251,   252,   253,   254,    -1,
     256,   257,    -1,    -1,   260,   261,   262,    -1,    -1,   265,
      -1,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,    -1,
      -1,   277,   278,   279,   280,   281,    -1,   283,   284,   285,
     286,    -1,   288,   289,   290,   291,   292,   293,   294,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,    -1,
     306,   307,   308,   309,   310,   311,   312,    -1,    -1,   315,
     316,   317,    -1,   319,   320,   321,   322,    -1,   324,   325,
      -1,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,    -1,   338,   339,   340,    -1,   342,   343,    -1,   345,
      -1,   347,   348,   349,   350,    -1,   352,   353,   354,   355,
      -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,   365,
     366,   367,   368,   369,    -1,   371,   372,    -1,    -1,    -1,
     376,   377,   378,   379,   380,   381,    -1,   383,   384,    -1,
     386,   387,    -1,    -1,   390,   391,   392,    -1,   394,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    35,    -1,
      37,    38,    39,    40,    -1,    -1,    -1,    44,    45,    46,
      -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    -1,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,
     147,   148,   149,    -1,   151,    -1,   153,    -1,   155,   156,
     157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,
     167,    -1,   169,    -1,   171,   172,   173,   174,   175,    -1,
     177,    -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,
      -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,
     197,    -1,   199,   200,   201,    -1,   203,   204,   205,   206,
      -1,    -1,   209,    -1,   211,   212,   213,    -1,   215,    -1,
     217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,
     227,    -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
      -1,   248,    -1,   250,   251,   252,   253,   254,    -1,   256,
     257,    -1,    -1,   260,   261,   262,    -1,    -1,   265,    -1,
      -1,    -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,
     277,   278,   279,   280,   281,    -1,   283,   284,   285,   286,
      -1,   288,   289,   290,   291,   292,   293,   294,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,    -1,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,   315,   316,
     317,    -1,   319,   320,   321,   322,    -1,   324,   325,    -1,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
      -1,   338,   339,   340,    -1,   342,   343,    -1,   345,    -1,
     347,   348,   349,   350,    -1,   352,   353,   354,   355,    -1,
      -1,   358,   359,   360,   361,   362,    -1,    -1,   365,   366,
     367,   368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,
     377,   378,   379,   380,   381,    -1,   383,    -1,    -1,   386,
      -1,     4,   389,     6,     7,     8,     9,    10,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,
      -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,
     143,   144,   145,   146,   147,   148,   149,    -1,   151,    -1,
     153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,
     163,   164,    -1,   166,   167,    -1,   169,    -1,   171,   172,
     173,   174,   175,    -1,   177,    -1,   179,   180,   181,    -1,
     183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,
      -1,   194,    -1,   196,   197,    -1,   199,   200,   201,    -1,
     203,   204,   205,   206,    -1,    -1,   209,    -1,   211,   212,
     213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,
      -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,    -1,   248,    -1,   250,   251,   252,
     253,   254,    -1,   256,   257,    -1,    -1,   260,   261,   262,
      -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,    -1,
     273,    -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,    -1,   288,   289,   290,   291,   292,
     293,   294,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,    -1,   306,   307,   308,   309,   310,   311,   312,
      -1,    -1,   315,   316,   317,    -1,   319,   320,   321,   322,
      -1,   324,   325,    -1,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,    -1,   338,   339,   340,    -1,   342,
     343,    -1,   345,    -1,   347,   348,   349,   350,    -1,   352,
     353,   354,   355,    -1,    -1,   358,   359,   360,   361,   362,
      -1,    -1,   365,   366,   367,   368,   369,    -1,   371,   372,
      -1,    -1,    -1,   376,   377,   378,   379,   380,   381,    -1,
     383,    -1,    -1,   386,     5,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    -1,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    -1,    48,    49,    50,
      -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,
      -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,    -1,   107,   108,   109,    -1,
     111,   112,   113,   114,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,    -1,   155,   156,   157,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   167,   168,   169,   170,
     171,   172,   173,   174,   175,    -1,   177,   178,   179,   180,
     181,   182,   183,   184,   185,   186,   187,   188,   189,    -1,
     191,   192,   193,   194,   195,   196,   197,   198,   199,   200,
     201,   202,   203,   204,   205,   206,   207,   208,   209,   210,
     211,   212,   213,   214,   215,   216,   217,   218,    -1,   220,
     221,   222,   223,   224,   225,   226,   227,   228,   229,   230,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,    -1,   277,   278,   279,   280,
     281,    -1,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,    -1,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,   370,
     371,   372,    -1,   374,   375,   376,   377,   378,   379,   380,
     381,    -1,   383,    -1,    -1,   386,     6,     7,     8,     9,
      -1,    11,    12,    13,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      -1,    -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,
      -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,    -1,    -1,
      -1,    -1,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,
      -1,   161,   162,   163,   164,    -1,   166,   167,    -1,   169,
      -1,   171,   172,   173,   174,   175,    -1,   177,    -1,   179,
     180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,
      -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,
     200,   201,    -1,   203,   204,   205,   206,    -1,    -1,   209,
      -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,
      -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,
     230,    -1,    -1,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,    -1,   248,    -1,
     250,   251,   252,   253,   254,    -1,   256,   257,    -1,    -1,
     260,   261,   262,    -1,    -1,   265,    -1,    -1,    -1,   269,
     270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,
     280,   281,    -1,   283,   284,   285,   286,    -1,   288,   289,
     290,   291,   292,   293,   294,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,    -1,   306,   307,   308,   309,
     310,   311,   312,    -1,    -1,   315,   316,   317,    -1,   319,
     320,   321,   322,    -1,   324,   325,    -1,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,    -1,   338,   339,
     340,    -1,   342,   343,    -1,   345,    -1,   347,   348,   349,
     350,    -1,   352,   353,   354,   355,    -1,    -1,   358,   359,
     360,   361,   362,    -1,    -1,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,   379,
     380,   381,    -1,   383,   384,    -1,   386,   387,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    -1,    43,    44,    45,    46,    -1,
      48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    57,
      58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,
      -1,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
      -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,   147,
     148,   149,    -1,   151,    -1,   153,    -1,   155,   156,   157,
      -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,   167,
      -1,   169,    -1,   171,   172,   173,   174,   175,    -1,   177,
      -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,
      -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,
      -1,   199,   200,   201,    -1,   203,   204,   205,   206,    -1,
      -1,   209,    -1,   211,   212,   213,    -1,   215,    -1,   217,
      -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,
      -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,    -1,
     248,   249,   250,   251,   252,   253,   254,    -1,   256,   257,
      -1,    -1,   260,   261,   262,    -1,    -1,   265,   266,    -1,
      -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,
     278,   279,   280,   281,    -1,   283,   284,   285,   286,    -1,
     288,   289,   290,   291,   292,   293,   294,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,    -1,   306,   307,
     308,   309,   310,   311,   312,    -1,    -1,   315,   316,   317,
      -1,   319,   320,   321,   322,    -1,   324,   325,    -1,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,    -1,   342,   343,    -1,   345,    -1,   347,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,    -1,
     358,   359,   360,   361,   362,    -1,    -1,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,
     378,   379,   380,   381,    -1,   383,    -1,    -1,   386,   387,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    35,
      -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,
      -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,
      76,    77,    -1,    79,    80,    81,    82,    83,    84,    85,
      -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,
     146,   147,   148,   149,    -1,   151,    -1,   153,    -1,   155,
     156,   157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,   167,    -1,   169,    -1,   171,   172,   173,   174,   175,
      -1,   177,    -1,   179,   180,   181,    -1,   183,    -1,   185,
      -1,    -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,
     196,   197,    -1,   199,   200,   201,    -1,   203,   204,   205,
     206,    -1,    -1,   209,    -1,   211,   212,   213,    -1,   215,
      -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,
     226,   227,    -1,    -1,   230,    -1,    -1,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,    -1,   248,    -1,   250,   251,   252,   253,   254,    -1,
     256,   257,    -1,    -1,   260,   261,   262,    -1,    -1,   265,
      -1,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,    -1,
      -1,   277,   278,   279,   280,   281,    -1,   283,   284,   285,
     286,    -1,   288,   289,   290,   291,   292,   293,   294,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,    -1,
     306,   307,   308,   309,   310,   311,   312,    -1,    -1,   315,
     316,   317,    -1,   319,   320,   321,   322,    -1,   324,   325,
      -1,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,    -1,   338,   339,   340,    -1,   342,   343,   344,   345,
      -1,   347,   348,   349,   350,    -1,   352,   353,   354,   355,
      -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,   365,
     366,   367,   368,   369,    -1,   371,   372,    -1,    -1,    -1,
     376,   377,   378,   379,   380,   381,    -1,   383,   384,    -1,
     386,   387,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,
      -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,
      74,    -1,    76,    77,    -1,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,    -1,   153,
      -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,   163,
     164,    -1,   166,   167,    -1,   169,    -1,   171,   172,   173,
     174,   175,    -1,   177,    -1,   179,   180,   181,    -1,   183,
      -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,    -1,
     194,    -1,   196,   197,    -1,   199,   200,   201,    -1,   203,
     204,   205,   206,    -1,    -1,   209,    -1,   211,   212,   213,
      -1,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,
     224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,    -1,   248,    -1,   250,   251,   252,   253,
     254,    -1,   256,   257,    -1,    -1,   260,   261,   262,    -1,
      -1,   265,    -1,    -1,    -1,   269,   270,    -1,    -1,   273,
      -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,   283,
     284,   285,   286,    -1,   288,   289,   290,   291,   292,   293,
     294,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,    -1,   306,   307,   308,   309,   310,   311,   312,    -1,
      -1,   315,   316,   317,    -1,   319,   320,   321,   322,    -1,
     324,   325,    -1,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,    -1,   338,   339,   340,    -1,   342,   343,
      -1,   345,    -1,   347,   348,   349,   350,    -1,   352,   353,
     354,   355,    -1,    -1,   358,   359,   360,   361,   362,    -1,
      -1,   365,   366,   367,   368,   369,    -1,   371,   372,    -1,
      -1,    -1,   376,   377,   378,   379,   380,   381,    -1,   383,
     384,    -1,   386,   387,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    35,    -1,    37,    38,    39,    40,    -1,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,
      52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,
      -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      72,    -1,    74,    -1,    76,    77,    -1,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
      -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,   166,   167,    -1,   169,    -1,   171,
     172,   173,   174,   175,    -1,   177,    -1,   179,   180,   181,
      -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,
      -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,   201,
      -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,   211,
     212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,
     222,    -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,
      -1,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,    -1,   248,    -1,   250,   251,
     252,   253,   254,    -1,   256,   257,    -1,    -1,   260,   261,
     262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,
      -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,   281,
      -1,   283,   284,   285,   286,    -1,   288,   289,   290,   291,
     292,   293,   294,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,    -1,   306,   307,   308,   309,   310,   311,
     312,    -1,    -1,   315,   316,   317,    -1,   319,   320,   321,
     322,    -1,   324,   325,    -1,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,    -1,   338,   339,   340,    -1,
     342,   343,    -1,   345,    -1,   347,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,    -1,   358,   359,   360,   361,
     362,    -1,    -1,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,    -1,    -1,   376,   377,   378,   379,   380,   381,
      -1,   383,   384,    -1,   386,   387,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      -1,    -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,
      -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,    -1,    -1,
      -1,    -1,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,
      -1,   161,   162,   163,   164,    -1,   166,   167,    -1,   169,
      -1,   171,   172,   173,   174,   175,    -1,   177,    -1,   179,
     180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,
      -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,
     200,   201,    -1,   203,   204,   205,   206,    -1,    -1,   209,
      -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,
      -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,
     230,    -1,    -1,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,    -1,   248,    -1,
     250,   251,   252,   253,   254,    -1,   256,   257,    -1,    -1,
     260,   261,   262,    -1,    -1,   265,    -1,    -1,    -1,   269,
     270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,
     280,   281,    -1,   283,   284,   285,   286,    -1,   288,   289,
     290,   291,   292,   293,   294,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,    -1,   306,   307,   308,   309,
     310,   311,   312,    -1,    -1,   315,   316,   317,    -1,   319,
     320,   321,   322,    -1,   324,   325,    -1,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,    -1,   338,   339,
     340,    -1,   342,   343,    -1,   345,    -1,   347,   348,   349,
     350,    -1,   352,   353,   354,   355,    -1,    -1,   358,   359,
     360,   361,   362,    -1,    -1,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,   379,
     380,   381,    -1,   383,   384,    -1,   386,   387,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    57,
      58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,
      -1,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
      -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,   147,
     148,   149,    -1,   151,    -1,   153,    -1,   155,   156,   157,
      -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,   167,
      -1,   169,    -1,   171,   172,   173,   174,   175,    -1,   177,
      -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,
      -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,
      -1,   199,   200,   201,    -1,   203,   204,   205,   206,    -1,
      -1,   209,    -1,   211,   212,   213,    -1,   215,    -1,   217,
      -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,
      -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,    -1,
     248,    -1,   250,   251,   252,   253,   254,    -1,   256,   257,
      -1,    -1,   260,   261,   262,    -1,    -1,   265,    -1,    -1,
      -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,
     278,   279,   280,   281,    -1,   283,   284,   285,   286,    -1,
     288,   289,   290,   291,   292,   293,   294,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,    -1,   306,   307,
     308,   309,   310,   311,   312,    -1,    -1,   315,   316,   317,
      -1,   319,   320,   321,   322,    -1,   324,   325,    -1,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,    -1,
     338,   339,   340,    -1,   342,   343,    -1,   345,    -1,   347,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,    -1,
     358,   359,   360,   361,   362,    -1,    -1,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,
     378,   379,   380,   381,    -1,   383,   384,    -1,   386,   387,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    18,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    35,
      -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,
      -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,
      76,    77,    -1,    79,    80,    81,    82,    83,    84,    85,
      -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,
     146,   147,   148,   149,    -1,   151,    -1,   153,    -1,   155,
     156,   157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,   167,    -1,   169,    -1,   171,   172,   173,   174,   175,
      -1,   177,    -1,   179,   180,   181,    -1,   183,    -1,   185,
      -1,    -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,
     196,   197,    -1,   199,   200,   201,    -1,   203,   204,   205,
     206,    -1,    -1,   209,    -1,   211,   212,   213,    -1,   215,
      -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,
     226,   227,    -1,    -1,   230,    -1,    -1,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,    -1,   248,    -1,   250,   251,   252,   253,   254,    -1,
     256,   257,    -1,    -1,   260,   261,   262,    -1,    -1,   265,
      -1,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,    -1,
      -1,   277,   278,   279,   280,   281,    -1,   283,   284,   285,
     286,    -1,   288,   289,   290,   291,   292,   293,   294,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,    -1,
     306,   307,   308,   309,   310,   311,   312,    -1,    -1,   315,
     316,   317,    -1,   319,   320,   321,   322,    -1,   324,   325,
      -1,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,    -1,   338,   339,   340,    -1,   342,   343,    -1,   345,
      -1,   347,   348,   349,   350,    -1,   352,   353,   354,   355,
      -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,   365,
     366,   367,   368,   369,    -1,   371,   372,    -1,    -1,    -1,
     376,   377,   378,   379,   380,   381,    -1,   383,    -1,    -1,
     386,   387,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,
      -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,
      74,    -1,    76,    77,    -1,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,
     144,   145,   146,   147,   148,   149,    -1,   151,    -1,   153,
      -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,   163,
     164,    -1,   166,   167,    -1,   169,    -1,   171,   172,   173,
     174,   175,    -1,   177,    -1,   179,   180,   181,    -1,   183,
      -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,    -1,
     194,    -1,   196,   197,    -1,   199,   200,   201,    -1,   203,
     204,   205,   206,    -1,    -1,   209,    -1,   211,   212,   213,
      -1,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,
     224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,    -1,   248,    -1,   250,   251,   252,   253,
     254,    -1,   256,   257,    -1,    -1,   260,   261,   262,    -1,
      -1,   265,    -1,    -1,    -1,   269,   270,    -1,    -1,   273,
      -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,   283,
     284,   285,   286,    -1,   288,   289,   290,   291,   292,   293,
     294,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,    -1,   306,   307,   308,   309,   310,   311,   312,    -1,
      -1,   315,   316,   317,    -1,   319,   320,   321,   322,    -1,
     324,   325,    -1,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,    -1,   338,   339,   340,    -1,   342,   343,
      -1,   345,    -1,   347,   348,   349,   350,    -1,   352,   353,
     354,   355,    -1,    -1,   358,   359,   360,   361,   362,    -1,
      -1,   365,   366,   367,   368,   369,    -1,   371,   372,    -1,
      -1,    -1,   376,   377,   378,   379,   380,   381,    -1,   383,
      -1,    -1,   386,   387,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    35,    -1,    37,    38,    39,    40,    -1,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,
      52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,
      -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      72,    -1,    74,    -1,    76,    77,    -1,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,
     142,   143,   144,   145,   146,   147,   148,   149,    -1,   151,
      -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,   166,   167,    -1,   169,    -1,   171,
     172,   173,   174,   175,    -1,   177,    -1,   179,   180,   181,
      -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,
      -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,   201,
      -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,   211,
     212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,
     222,    -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,
      -1,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,    -1,   248,    -1,   250,   251,
     252,   253,   254,    -1,   256,   257,    -1,    -1,   260,   261,
     262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,
      -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,   281,
      -1,   283,   284,   285,   286,    -1,   288,   289,   290,   291,
     292,   293,   294,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,    -1,   306,   307,   308,   309,   310,   311,
     312,    -1,    -1,   315,   316,   317,    -1,   319,   320,   321,
     322,    -1,   324,   325,    -1,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,    -1,   338,   339,   340,    -1,
     342,   343,    -1,   345,    -1,   347,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,    -1,   358,   359,   360,   361,
     362,    -1,    -1,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,    -1,    -1,   376,   377,   378,   379,   380,   381,
      -1,   383,    -1,    -1,   386,   387,     5,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    -1,    37,    38,
      39,    40,    41,    42,    -1,    44,    45,    46,    -1,    48,
      49,    50,    -1,    52,    53,    -1,    -1,    -1,    57,    58,
      -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,   106,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,    -1,    -1,    -1,   126,   127,   128,
      -1,   130,   131,    -1,   133,    -1,   135,   136,    -1,    -1,
      -1,    -1,    -1,   142,   143,   144,   145,   146,   147,   148,
     149,    -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,   166,   167,    -1,
     169,    -1,   171,   172,   173,    -1,   175,    -1,    -1,    -1,
     179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,
     189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,
     199,   200,   201,    -1,   203,   204,   205,   206,    -1,    -1,
     209,    -1,   211,   212,   213,   214,   215,    -1,   217,    -1,
      -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,
      -1,   230,    -1,    -1,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,    -1,   248,
      -1,   250,   251,   252,   253,   254,    -1,   256,   257,    -1,
      -1,    -1,   261,   262,    -1,    -1,   265,    -1,    -1,    -1,
     269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,
     279,   280,   281,    -1,    -1,   284,   285,   286,    -1,   288,
     289,   290,   291,   292,   293,   294,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,    -1,   306,    -1,   308,
     309,   310,   311,   312,    -1,    -1,   315,   316,   317,    -1,
     319,   320,   321,   322,    -1,   324,   325,    -1,   327,   328,
     329,   330,   331,   332,   333,   334,    -1,   336,    -1,   338,
     339,   340,    -1,   342,   343,    -1,   345,    -1,   347,    -1,
     349,    -1,    -1,   352,   353,   354,   355,    -1,    -1,   358,
     359,   360,   361,   362,    -1,    -1,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,
     379,   380,   381,    -1,   383,    -1,    -1,   386,     5,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    -1,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    49,    50,    -1,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    -1,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,   106,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,    -1,    -1,    -1,   126,
     127,   128,    -1,   130,   131,    -1,   133,    -1,   135,   136,
      -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,
     147,   148,   149,    -1,   151,    -1,   153,    -1,   155,   156,
     157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,
     167,    -1,   169,    -1,   171,   172,   173,    -1,   175,    -1,
      -1,    -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,
      -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,
     197,    -1,   199,   200,   201,   202,   203,   204,   205,   206,
      -1,    -1,   209,    -1,   211,   212,   213,   214,   215,    -1,
     217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,
     227,    -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
      -1,   248,    -1,   250,   251,   252,   253,    -1,    -1,   256,
     257,    -1,    -1,    -1,   261,   262,    -1,    -1,   265,    -1,
      -1,    -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,
     277,   278,   279,   280,   281,    -1,    -1,   284,   285,   286,
      -1,   288,   289,   290,   291,   292,   293,   294,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,    -1,   306,
      -1,   308,   309,   310,   311,   312,    -1,    -1,   315,   316,
     317,    -1,   319,   320,   321,   322,    -1,   324,   325,    -1,
     327,   328,   329,   330,   331,   332,   333,   334,    -1,   336,
      -1,   338,   339,   340,    -1,   342,   343,    -1,   345,    -1,
     347,    -1,   349,    -1,    -1,   352,   353,   354,   355,    -1,
      -1,   358,   359,   360,   361,   362,    -1,    -1,   365,   366,
     367,   368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,
     377,   378,   379,   380,   381,    -1,   383,    -1,    -1,   386,
       5,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    -1,    37,    38,    39,    40,    41,    42,    -1,    44,
      45,    46,    -1,    48,    49,    50,    -1,    52,    53,    -1,
      -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,
      -1,    76,    77,    -1,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,   106,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,    -1,    -1,
      -1,   126,   127,   128,    -1,   130,   131,    -1,   133,    -1,
     135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,
     145,   146,   147,   148,   149,    -1,   151,    -1,   153,    -1,
     155,   156,   157,    -1,    -1,    -1,   161,   162,   163,   164,
      -1,   166,   167,    -1,   169,    -1,   171,   172,   173,    -1,
     175,    -1,    -1,    -1,   179,   180,   181,    -1,   183,    -1,
     185,    -1,    -1,    -1,   189,    -1,   191,    -1,    -1,   194,
      -1,   196,   197,    -1,   199,   200,   201,    -1,   203,   204,
     205,   206,    -1,    -1,   209,    -1,   211,   212,   213,   214,
     215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,
     225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,    -1,   248,    -1,   250,   251,   252,   253,   254,
      -1,   256,   257,    -1,    -1,    -1,   261,   262,    -1,    -1,
     265,    -1,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,
      -1,    -1,   277,   278,   279,   280,   281,    -1,    -1,   284,
     285,   286,    -1,   288,   289,   290,   291,   292,   293,   294,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
      -1,   306,    -1,   308,   309,   310,   311,   312,    -1,    -1,
     315,   316,   317,    -1,   319,   320,   321,   322,    -1,   324,
     325,    -1,   327,   328,   329,   330,   331,   332,   333,   334,
      -1,   336,    -1,   338,   339,   340,    -1,   342,   343,    -1,
     345,    -1,   347,    -1,   349,    -1,    -1,   352,   353,   354,
     355,    -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,    -1,
      -1,   376,   377,   378,   379,   380,   381,    -1,   383,    -1,
      -1,   386,     5,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    -1,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    49,    50,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,   106,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
      -1,    -1,    -1,   126,   127,   128,    -1,   130,   131,    -1,
     133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,
     143,   144,   145,   146,   147,   148,   149,    -1,   151,    -1,
     153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,
     163,   164,    -1,   166,   167,    -1,   169,    -1,   171,   172,
     173,    -1,   175,    -1,    -1,    -1,   179,   180,   181,    -1,
     183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,
      -1,   194,    -1,   196,   197,    -1,   199,   200,   201,    -1,
     203,   204,   205,   206,    -1,    -1,   209,    -1,   211,   212,
     213,   214,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,
      -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,    -1,   248,    -1,   250,   251,   252,
     253,    -1,    -1,   256,   257,    -1,    -1,    -1,   261,   262,
      -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,    -1,
     273,    -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,
      -1,   284,   285,   286,    -1,   288,   289,   290,   291,   292,
     293,   294,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,    -1,   306,    -1,   308,   309,   310,   311,   312,
      -1,    -1,   315,   316,   317,    -1,   319,   320,   321,   322,
      -1,   324,   325,    -1,   327,   328,   329,   330,   331,   332,
     333,   334,    -1,   336,    -1,   338,   339,   340,    -1,   342,
     343,    -1,   345,    -1,   347,    -1,   349,    -1,    -1,   352,
     353,   354,   355,    -1,    -1,   358,   359,   360,   361,   362,
      -1,    -1,   365,   366,   367,   368,   369,    -1,   371,   372,
      -1,    -1,    -1,   376,   377,   378,   379,   380,   381,    -1,
     383,    -1,    -1,   386,     5,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    -1,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    -1,    48,    49,    50,
      -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,
      -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,   106,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,    -1,    -1,    -1,   126,   127,   128,    -1,   130,
     131,    -1,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,
      -1,   142,   143,   144,   145,   146,   147,   148,   149,    -1,
     151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,
     161,   162,   163,   164,    -1,   166,   167,    -1,   169,    -1,
     171,   172,   173,    -1,   175,    -1,    -1,    -1,   179,   180,
     181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,
     191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,
     201,    -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,
     211,   212,   213,   214,   215,    -1,   217,    -1,    -1,    -1,
      -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,   230,
      -1,    -1,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,    -1,   248,    -1,   250,
     251,   252,   253,    -1,    -1,   256,   257,    -1,    -1,    -1,
     261,   262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,
      -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,
     281,    -1,    -1,   284,   285,   286,    -1,   288,   289,   290,
     291,   292,   293,   294,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,    -1,   306,    -1,   308,   309,   310,
     311,   312,    -1,    -1,   315,   316,   317,    -1,   319,    -1,
     321,   322,    -1,   324,   325,    -1,   327,   328,   329,   330,
     331,   332,   333,   334,    -1,   336,    -1,   338,   339,   340,
      -1,   342,   343,    -1,   345,    -1,   347,    -1,   349,    -1,
      -1,   352,   353,   354,   355,    -1,    -1,   358,   359,   360,
     361,   362,    -1,    -1,   365,   366,   367,   368,   369,    -1,
     371,   372,    -1,    -1,    -1,   376,   377,   378,   379,   380,
     381,    -1,   383,    -1,    -1,   386,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      20,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    42,    -1,    44,    45,    46,    47,    48,    49,
      50,    -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,
      -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,    -1,   107,   108,   109,
      -1,   111,   112,   113,   114,    -1,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,    -1,   155,   156,   157,   158,   159,
     160,   161,   162,   163,   164,   165,   166,   167,   168,   169,
     170,   171,   172,   173,   174,   175,    -1,   177,   178,   179,
     180,   181,   182,   183,   184,   185,   186,   187,   188,   189,
      -1,   191,   192,   193,   194,   195,   196,   197,   198,   199,
     200,   201,   202,   203,   204,   205,   206,   207,   208,   209,
      -1,   211,   212,   213,    -1,   215,   216,   217,   218,    -1,
     220,   221,   222,   223,   224,   225,   226,   227,   228,   229,
     230,   231,   232,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,    -1,   277,   278,   279,
     280,   281,    -1,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,   344,   345,   346,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
     370,   371,   372,    -1,   374,   375,   376,   377,   378,   379,
     380,   381,    -1,   383,    -1,    -1,   386,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    20,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    35,    -1,    37,    38,
      39,    40,    -1,    42,    -1,    44,    45,    46,    47,    48,
      49,    50,    -1,    52,    53,    -1,    -1,    -1,    57,    58,
      -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,    -1,   107,   108,
     109,    -1,   111,   112,   113,   114,    -1,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,    -1,   155,   156,   157,   158,
     159,   160,   161,   162,   163,   164,   165,   166,   167,   168,
     169,   170,   171,   172,   173,   174,   175,    -1,   177,   178,
     179,   180,   181,   182,   183,   184,   185,   186,   187,   188,
     189,    -1,   191,   192,   193,   194,   195,   196,   197,   198,
     199,   200,   201,   202,   203,   204,   205,   206,   207,   208,
     209,    -1,   211,   212,   213,    -1,   215,   216,   217,   218,
      -1,   220,   221,   222,   223,   224,   225,   226,   227,   228,
     229,   230,   231,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,    -1,   277,   278,
     279,   280,   281,    -1,   283,   284,   285,   286,   287,   288,
     289,   290,   291,   292,   293,   294,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,    -1,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,   352,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,   370,   371,   372,    -1,   374,   375,   376,   377,   378,
     379,   380,   381,    -1,   383,    -1,    -1,   386,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    20,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    42,    -1,    44,    45,    46,    -1,
      48,    49,    50,    -1,    52,    53,    -1,    -1,    -1,    57,
      58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,    -1,
      -1,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,    -1,   107,
     108,   109,    -1,   111,   112,   113,   114,    -1,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,    -1,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   167,
     168,   169,   170,   171,   172,   173,   174,   175,    -1,   177,
     178,   179,   180,   181,   182,   183,   184,   185,   186,   187,
     188,   189,    -1,   191,   192,   193,   194,   195,   196,   197,
     198,   199,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   209,    -1,   211,   212,   213,    -1,   215,   216,   217,
     218,    -1,   220,   221,   222,   223,   224,   225,   226,   227,
     228,   229,   230,   231,   232,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,    -1,   277,
     278,   279,   280,   281,    -1,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,   370,   371,   372,    -1,   374,   375,   376,   377,
     378,   379,   380,   381,    -1,   383,    -1,    -1,   386,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    20,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    35,    -1,
      37,    38,    39,    40,    -1,    42,    -1,    44,    45,    46,
      -1,    48,    49,    50,    -1,    52,    53,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,    -1,
     107,   108,   109,    -1,   111,   112,   113,   114,    -1,   116,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,   152,   153,    -1,   155,   156,
     157,   158,   159,   160,   161,   162,   163,   164,   165,   166,
     167,   168,   169,   170,   171,   172,   173,   174,   175,    -1,
     177,   178,   179,   180,   181,   182,   183,   184,   185,   186,
     187,   188,   189,    -1,   191,   192,   193,   194,   195,   196,
     197,   198,   199,   200,   201,   202,   203,   204,   205,   206,
     207,   208,   209,    -1,   211,   212,   213,    -1,   215,   216,
     217,   218,    -1,   220,   221,   222,   223,   224,   225,   226,
     227,   228,   229,   230,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,    -1,
     277,   278,   279,   280,   281,    -1,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,    -1,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
     347,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,   370,   371,   372,    -1,   374,   375,   376,
     377,   378,   379,   380,   381,    -1,   383,    -1,    -1,   386,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    35,
      -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,
      -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,
      76,    77,    -1,    79,    80,    81,    82,    83,    84,    85,
      -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,   137,    -1,    -1,    -1,    -1,   142,   143,   144,   145,
     146,   147,   148,   149,    -1,   151,    -1,   153,    -1,   155,
     156,   157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,   167,    -1,   169,    -1,   171,   172,   173,   174,   175,
      -1,   177,    -1,   179,   180,   181,    -1,   183,    -1,   185,
     186,    -1,   188,   189,    -1,   191,    -1,    -1,   194,    -1,
     196,   197,   198,   199,   200,   201,   202,   203,   204,   205,
     206,    -1,   208,   209,    -1,   211,   212,   213,    -1,   215,
      -1,   217,    -1,    -1,   220,   221,   222,   223,   224,   225,
     226,   227,    -1,   229,   230,   231,    -1,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,   253,   254,    -1,
     256,   257,   258,    -1,   260,   261,   262,    -1,    -1,   265,
     266,    -1,    -1,   269,   270,    -1,    -1,   273,   274,   275,
      -1,   277,   278,   279,   280,   281,    -1,   283,   284,   285,
     286,    -1,   288,   289,   290,   291,   292,   293,   294,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,    -1,    -1,   315,
     316,   317,    -1,   319,   320,   321,   322,   323,   324,   325,
      -1,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,    -1,   338,   339,   340,    -1,   342,   343,    -1,   345,
      -1,   347,   348,   349,   350,    -1,   352,   353,   354,   355,
      -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,   365,
     366,   367,   368,   369,   370,   371,   372,    -1,    -1,    -1,
     376,   377,   378,   379,   380,   381,    -1,   383,    -1,    -1,
     386,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,
      45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,
      -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,
      -1,    76,    77,    -1,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    -1,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,   129,   130,   131,   132,   133,    -1,
     135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,
     145,   146,   147,   148,   149,    -1,   151,    -1,   153,    -1,
     155,   156,   157,    -1,    -1,    -1,   161,   162,   163,   164,
      -1,   166,   167,    -1,   169,    -1,   171,   172,   173,   174,
     175,    -1,   177,    -1,   179,   180,   181,    -1,   183,   184,
     185,    -1,    -1,    -1,   189,    -1,   191,    -1,    -1,   194,
      -1,   196,   197,    -1,   199,   200,   201,    -1,   203,   204,
     205,   206,    -1,    -1,   209,    -1,   211,   212,   213,    -1,
     215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,
     225,   226,   227,    -1,    -1,   230,   231,    -1,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,    -1,   248,    -1,   250,   251,   252,   253,   254,
      -1,   256,   257,    -1,    -1,   260,   261,   262,    -1,    -1,
     265,    -1,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,
      -1,    -1,   277,   278,   279,   280,   281,    -1,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
      -1,   306,   307,   308,   309,   310,   311,   312,    -1,    -1,
     315,   316,   317,    -1,   319,   320,   321,   322,    -1,   324,
     325,    -1,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,    -1,   338,   339,   340,    -1,   342,   343,    -1,
     345,    -1,   347,   348,   349,   350,    -1,   352,   353,   354,
     355,    -1,   357,   358,   359,   360,   361,   362,    -1,    -1,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,    -1,
      -1,   376,   377,   378,   379,   380,   381,    -1,   383,    -1,
      -1,   386,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,
      -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,
      74,    -1,    76,    77,    -1,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    88,    89,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,
     144,   145,   146,   147,   148,   149,    -1,   151,    -1,   153,
      -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,   163,
     164,    -1,   166,   167,    -1,   169,    -1,   171,   172,   173,
     174,   175,    -1,   177,    -1,   179,   180,   181,    -1,   183,
      -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,    -1,
     194,    -1,   196,   197,    -1,   199,   200,   201,    -1,   203,
     204,   205,   206,    -1,    -1,   209,    -1,   211,   212,   213,
      -1,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,
     224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,    -1,   248,   249,   250,   251,   252,   253,
     254,    -1,   256,   257,    -1,    -1,   260,   261,   262,    -1,
      -1,   265,   266,    -1,    -1,   269,   270,    -1,    -1,   273,
      -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,   283,
     284,   285,   286,    -1,   288,   289,   290,   291,   292,   293,
     294,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,    -1,   306,   307,   308,   309,   310,   311,   312,    -1,
      -1,   315,   316,   317,    -1,   319,   320,   321,   322,    -1,
     324,   325,    -1,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,    -1,   338,   339,   340,    -1,   342,   343,
      -1,   345,    -1,   347,   348,   349,   350,    -1,   352,   353,
     354,   355,    -1,    -1,   358,   359,   360,   361,   362,    -1,
      -1,   365,   366,   367,   368,   369,    -1,   371,   372,    -1,
      -1,    -1,   376,   377,   378,   379,   380,   381,    -1,   383,
      -1,    -1,   386,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,
      -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,
     143,   144,   145,   146,   147,   148,   149,    -1,   151,    -1,
     153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,
     163,   164,    -1,   166,   167,    -1,   169,    -1,   171,   172,
     173,   174,   175,    -1,   177,    -1,   179,   180,   181,    -1,
     183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,
      -1,   194,    -1,   196,   197,    -1,   199,   200,   201,    -1,
     203,   204,   205,   206,    -1,    -1,   209,    -1,   211,   212,
     213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,
      -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,    -1,   248,   249,   250,   251,   252,
     253,   254,    -1,   256,   257,    -1,    -1,   260,   261,   262,
      -1,    -1,   265,   266,    -1,   268,   269,   270,    -1,    -1,
     273,    -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,    -1,   288,   289,   290,   291,   292,
     293,   294,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,    -1,   306,   307,   308,   309,   310,   311,   312,
      -1,    -1,   315,   316,   317,    -1,   319,   320,   321,   322,
      -1,   324,   325,    -1,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,    -1,   338,   339,   340,    -1,   342,
     343,    -1,   345,    -1,   347,   348,   349,   350,    -1,   352,
     353,   354,   355,    -1,    -1,   358,   359,   360,   361,   362,
      -1,    -1,   365,   366,   367,   368,   369,    -1,   371,   372,
      -1,    -1,    -1,   376,   377,   378,   379,   380,   381,    -1,
     383,    -1,    -1,   386,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    35,    -1,    37,    38,    39,    40,    -1,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,
      52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,
      -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      72,    -1,    74,    -1,    76,    77,    -1,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,
     142,   143,   144,   145,   146,   147,   148,   149,    -1,   151,
      -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,   166,   167,    -1,   169,    -1,   171,
     172,   173,   174,   175,    -1,   177,    -1,   179,   180,   181,
      -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,
      -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,   201,
      -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,   211,
     212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,
     222,    -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,
      -1,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,    -1,   248,   249,   250,   251,
     252,   253,   254,    -1,   256,   257,    -1,    -1,   260,   261,
     262,    -1,    -1,   265,   266,    -1,    -1,   269,   270,    -1,
      -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,   281,
      -1,   283,   284,   285,   286,    -1,   288,   289,   290,   291,
     292,   293,   294,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,    -1,   306,   307,   308,   309,   310,   311,
     312,    -1,    -1,   315,   316,   317,    -1,   319,   320,   321,
     322,    -1,   324,   325,    -1,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,    -1,
     342,   343,    -1,   345,    -1,   347,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,    -1,   358,   359,   360,   361,
     362,    -1,    -1,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,    -1,    -1,   376,   377,   378,   379,   380,   381,
      -1,   383,    -1,    -1,   386,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    35,    -1,    37,    38,    39,    40,
      -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,
      -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,
      -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,
      -1,   142,   143,   144,   145,   146,   147,   148,   149,    -1,
     151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,
     161,   162,   163,   164,    -1,   166,   167,    -1,   169,    -1,
     171,   172,   173,   174,   175,    -1,   177,    -1,   179,   180,
     181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,
     191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,
     201,    -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,
     211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,
      -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,   230,
      -1,    -1,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,    -1,   248,   249,   250,
     251,   252,   253,   254,    -1,   256,   257,    -1,    -1,   260,
     261,   262,    -1,    -1,   265,   266,    -1,    -1,   269,   270,
      -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,
     281,    -1,   283,   284,   285,   286,    -1,   288,   289,   290,
     291,   292,   293,   294,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,    -1,   306,   307,   308,   309,   310,
     311,   312,    -1,    -1,   315,   316,   317,    -1,   319,   320,
     321,   322,    -1,   324,   325,    -1,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,    -1,   338,   339,   340,
      -1,   342,   343,    -1,   345,    -1,   347,   348,   349,   350,
      -1,   352,   353,   354,   355,    -1,    -1,   358,   359,   360,
     361,   362,    -1,   364,   365,   366,   367,   368,   369,    -1,
     371,   372,    -1,    -1,    -1,   376,   377,   378,   379,   380,
     381,    -1,   383,    -1,    -1,   386,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      -1,    -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,
      -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,    -1,    -1,
      -1,    -1,   142,   143,   144,   145,   146,   147,   148,   149,
      -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,
      -1,   161,   162,   163,   164,    -1,   166,   167,    -1,   169,
      -1,   171,   172,   173,   174,   175,    -1,   177,    -1,   179,
     180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,
      -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,
     200,   201,    -1,   203,   204,   205,   206,    -1,    -1,   209,
      -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,
      -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,
     230,    -1,    -1,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,    -1,   248,   249,
     250,   251,   252,   253,   254,    -1,   256,   257,    -1,    -1,
     260,   261,   262,    -1,    -1,   265,   266,    -1,    -1,   269,
     270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,
     280,   281,    -1,   283,   284,   285,   286,    -1,   288,   289,
     290,   291,   292,   293,   294,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,    -1,   306,   307,   308,   309,
     310,   311,   312,    -1,    -1,   315,   316,   317,    -1,   319,
     320,   321,   322,    -1,   324,   325,    -1,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,    -1,   338,   339,
     340,    -1,   342,   343,    -1,   345,    -1,   347,   348,   349,
     350,    -1,   352,   353,   354,   355,    -1,    -1,   358,   359,
     360,   361,   362,    -1,    -1,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,   379,
     380,   381,    -1,   383,    -1,    -1,   386,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    35,    -1,    37,    38,
      39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,
      -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    57,    58,
      -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,    -1,
      -1,    -1,    -1,   142,   143,   144,   145,   146,   147,   148,
     149,    -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,   166,   167,    -1,
     169,    -1,   171,   172,   173,   174,   175,    -1,   177,    -1,
     179,   180,   181,    -1,   183,    -1,   185,    -1,   187,    -1,
     189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,
     199,   200,   201,   202,   203,   204,   205,   206,    -1,    -1,
     209,    -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,
      -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,
      -1,   230,    -1,    -1,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,    -1,   248,
      -1,   250,   251,   252,   253,   254,    -1,   256,   257,    -1,
      -1,   260,   261,   262,    -1,    -1,   265,    -1,    -1,    -1,
     269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,
     279,   280,   281,    -1,   283,   284,   285,   286,    -1,   288,
     289,   290,   291,   292,   293,   294,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,    -1,   306,   307,   308,
     309,   310,   311,   312,    -1,    -1,   315,   316,   317,    -1,
     319,   320,   321,   322,    -1,   324,   325,    -1,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,    -1,   338,
     339,   340,    -1,   342,   343,    -1,   345,    -1,   347,   348,
     349,   350,    -1,   352,   353,   354,   355,    -1,    -1,   358,
     359,   360,   361,   362,    -1,    -1,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,
     379,   380,   381,    -1,   383,    -1,    -1,   386,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    57,
      58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,
      -1,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
      -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,   147,
     148,   149,    -1,   151,    -1,   153,    -1,   155,   156,   157,
      -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,   167,
      -1,   169,    -1,   171,   172,   173,   174,   175,    -1,   177,
      -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,
      -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,
      -1,   199,   200,   201,    -1,   203,   204,   205,   206,    -1,
      -1,   209,    -1,   211,   212,   213,    -1,   215,    -1,   217,
      -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,
      -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,    -1,
     248,    -1,   250,   251,   252,   253,   254,    -1,   256,   257,
      -1,    -1,   260,   261,   262,    -1,    -1,   265,    -1,    -1,
      -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,
     278,   279,   280,   281,    -1,   283,   284,   285,   286,    -1,
     288,   289,   290,   291,   292,   293,   294,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,    -1,   306,   307,
     308,   309,   310,   311,   312,    -1,    -1,   315,   316,   317,
      -1,   319,   320,   321,   322,    -1,   324,   325,    -1,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,    -1,
     338,   339,   340,    -1,   342,   343,    -1,   345,    -1,   347,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,    -1,
     358,   359,   360,   361,   362,    -1,    -1,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,
     378,   379,   380,   381,    -1,   383,    -1,    -1,   386,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    35,    -1,
      37,    38,    39,    40,    -1,    -1,    -1,    44,    45,    46,
      -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,
     147,   148,   149,    -1,   151,    -1,   153,    -1,   155,   156,
     157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,
     167,    -1,   169,    -1,   171,   172,   173,   174,   175,    -1,
     177,    -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,
      -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,
     197,    -1,   199,   200,   201,    -1,   203,   204,   205,   206,
      -1,    -1,   209,    -1,   211,   212,   213,    -1,   215,    -1,
     217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,
     227,    -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
      -1,   248,    -1,   250,   251,   252,   253,   254,    -1,   256,
     257,    -1,    -1,   260,   261,   262,    -1,    -1,   265,    -1,
      -1,    -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,
     277,   278,   279,   280,   281,    -1,   283,   284,   285,   286,
      -1,   288,   289,   290,   291,   292,   293,   294,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,    -1,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,   315,   316,
     317,    -1,   319,   320,   321,   322,    -1,   324,   325,    -1,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
      -1,   338,   339,   340,    -1,   342,   343,    -1,   345,    -1,
     347,   348,   349,   350,    -1,   352,   353,   354,   355,    -1,
      -1,   358,   359,   360,   361,   362,    -1,    -1,   365,   366,
     367,   368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,
     377,   378,   379,   380,   381,    -1,   383,    -1,    -1,   386,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    35,
      -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,
      -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,
      76,    77,    -1,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,
     146,   147,   148,   149,    -1,   151,    -1,   153,    -1,   155,
     156,   157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,   167,    -1,   169,    -1,   171,   172,   173,   174,   175,
      -1,   177,    -1,   179,   180,   181,    -1,   183,    -1,   185,
      -1,    -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,
     196,   197,    -1,   199,   200,   201,    -1,   203,   204,   205,
     206,    -1,    -1,   209,    -1,   211,   212,   213,    -1,   215,
      -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,
     226,   227,    -1,    -1,   230,    -1,    -1,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,    -1,   248,    -1,   250,   251,   252,   253,   254,    -1,
     256,   257,    -1,    -1,   260,   261,   262,    -1,    -1,   265,
      -1,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,    -1,
      -1,   277,   278,   279,   280,   281,    -1,   283,   284,   285,
     286,    -1,   288,   289,   290,   291,   292,   293,   294,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,    -1,
     306,   307,   308,   309,   310,   311,   312,    -1,    -1,   315,
     316,   317,    -1,   319,   320,   321,   322,    -1,   324,   325,
      -1,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,    -1,   338,   339,   340,    -1,   342,   343,    -1,   345,
      -1,   347,   348,   349,   350,    -1,   352,   353,   354,   355,
      -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,   365,
     366,   367,   368,   369,    -1,   371,   372,    -1,    -1,    -1,
     376,   377,   378,   379,   380,   381,    -1,   383,    -1,    -1,
     386,     6,     7,     8,     9,    -1,    11,    12,    -1,    14,
      15,    16,    17,    -1,    19,    -1,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    33,    -1,
      35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,
      45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,
      -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,
      -1,    76,    77,    -1,    79,    80,    81,    82,    83,    84,
      85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    97,    98,    99,   100,   101,    -1,   103,    -1,
     105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,
     115,   116,   117,    -1,   119,   120,   121,   122,   123,    -1,
      -1,   126,   127,   128,    -1,   130,   131,   132,   133,    -1,
     135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,
     145,   146,   147,   148,   149,    -1,   151,    -1,   153,    -1,
     155,   156,   157,    -1,    -1,    -1,   161,   162,   163,   164,
      -1,   166,   167,    -1,   169,    -1,   171,   172,   173,   174,
     175,    -1,   177,    -1,   179,   180,   181,    -1,   183,    -1,
     185,    -1,    -1,    -1,   189,    -1,   191,    -1,    -1,   194,
      -1,   196,   197,    -1,   199,   200,   201,    -1,   203,   204,
     205,   206,    -1,    -1,   209,    -1,   211,   212,   213,    -1,
     215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,
     225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,    -1,   248,    -1,   250,   251,   252,   253,   254,
      -1,   256,   257,    -1,    -1,   260,   261,   262,    -1,    -1,
     265,    -1,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,
      -1,    -1,   277,   278,   279,   280,   281,    -1,   283,   284,
     285,   286,    -1,   288,   289,   290,   291,   292,   293,   294,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
      -1,   306,   307,   308,   309,   310,   311,   312,    -1,    -1,
     315,   316,   317,    -1,   319,   320,   321,   322,    -1,   324,
     325,    -1,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,    -1,   338,   339,   340,    -1,   342,   343,    -1,
     345,    -1,   347,   348,   349,   350,    -1,   352,   353,   354,
     355,    -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,    -1,
      -1,   376,   377,   378,   379,   380,   381,    -1,   383,    -1,
      -1,   386,     6,     7,     8,     9,    -1,    11,    12,    -1,
      14,    15,    16,    17,    -1,    19,    -1,    21,    -1,    23,
      24,    25,    26,    27,    28,    -1,    30,    31,    32,    33,
      -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,    53,
      -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,    63,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,
      74,    -1,    76,    77,    -1,    79,    80,    81,    82,    83,
      84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    97,    -1,    99,   100,   101,    -1,   103,
      -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,    -1,
     114,   115,   116,   117,    -1,   119,   120,   121,   122,   123,
      -1,    -1,   126,   127,   128,    -1,   130,   131,   132,   133,
      -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,   143,
     144,   145,   146,   147,   148,   149,    -1,   151,    -1,   153,
      -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,   163,
     164,    -1,   166,   167,    -1,   169,    -1,   171,   172,   173,
     174,   175,    -1,   177,    -1,   179,   180,   181,    -1,   183,
      -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,   193,
     194,    -1,   196,   197,    -1,   199,   200,   201,    -1,   203,
     204,   205,   206,    -1,    -1,   209,    -1,   211,   212,   213,
      -1,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,    -1,
     224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,    -1,   248,    -1,   250,   251,   252,   253,
     254,    -1,   256,   257,    -1,    -1,   260,   261,   262,    -1,
      -1,   265,    -1,    -1,    -1,   269,   270,    -1,    -1,   273,
      -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,   283,
     284,   285,   286,    -1,   288,   289,   290,   291,   292,   293,
     294,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,    -1,   306,   307,   308,   309,   310,   311,   312,    -1,
      -1,   315,   316,   317,    -1,   319,   320,   321,   322,    -1,
     324,   325,    -1,   327,   328,   329,   330,   331,   332,   333,
     334,   335,   336,    -1,   338,   339,   340,    -1,   342,   343,
      -1,   345,    -1,   347,   348,   349,   350,    -1,   352,   353,
     354,   355,    -1,    -1,   358,   359,   360,   361,   362,    -1,
      -1,   365,   366,   367,   368,   369,    -1,   371,   372,    -1,
      -1,    -1,   376,   377,   378,   379,   380,   381,    -1,   383,
      -1,    -1,   386,     6,     7,     8,     9,    -1,    11,    12,
      -1,    14,    15,    16,    17,    -1,    19,    -1,    21,    -1,
      23,    24,    25,    26,    27,    28,    -1,    30,    31,    32,
      33,    -1,    35,    -1,    37,    38,    39,    40,    -1,    -1,
      -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,    52,
      53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,    -1,
      63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    72,
      -1,    74,    -1,    76,    77,    -1,    79,    80,    81,    82,
      83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    97,    -1,    99,   100,   101,    -1,
     103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,    -1,
      -1,   114,   115,   116,   117,    -1,   119,   120,   121,   122,
     123,    -1,    -1,   126,   127,   128,    -1,   130,   131,   132,
     133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,    -1,
     153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,   162,
     163,   164,    -1,   166,   167,    -1,   169,    -1,   171,   172,
     173,   174,   175,    -1,   177,    -1,   179,   180,   181,    -1,
     183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,    -1,
      -1,   194,    -1,   196,   197,    -1,   199,   200,   201,    -1,
     203,   204,   205,   206,    -1,    -1,   209,    -1,   211,   212,
     213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,   222,
      -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,    -1,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,    -1,   248,    -1,   250,   251,   252,
     253,   254,    -1,   256,   257,    -1,    -1,   260,   261,   262,
      -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,    -1,
     273,    -1,    -1,    -1,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,    -1,   288,   289,   290,   291,   292,
     293,   294,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,    -1,   306,   307,   308,   309,   310,   311,   312,
      -1,    -1,   315,   316,   317,    -1,   319,   320,   321,   322,
      -1,   324,   325,    -1,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,    -1,   338,   339,   340,    -1,   342,
     343,    -1,   345,    -1,   347,   348,   349,   350,    -1,   352,
     353,   354,   355,    -1,    -1,   358,   359,   360,   361,   362,
      -1,    -1,   365,   366,   367,   368,   369,    -1,   371,   372,
      -1,    -1,    -1,   376,   377,   378,   379,   380,   381,    -1,
     383,    -1,    -1,   386,     6,     7,     8,     9,    -1,    11,
      12,    -1,    14,    15,    16,    17,    -1,    19,    -1,    21,
      -1,    23,    24,    25,    26,    27,    28,    -1,    30,    31,
      32,    33,    -1,    35,    -1,    37,    38,    39,    40,    -1,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,    -1,
      52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,    -1,
      -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      72,    -1,    74,    -1,    76,    77,    -1,    79,    80,    81,
      82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    97,    -1,    99,   100,   101,
      -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,   111,
      -1,    -1,   114,   115,   116,   117,    -1,   119,   120,   121,
     122,   123,    -1,    -1,   126,   127,   128,    -1,   130,   131,
     132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,    -1,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
      -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,   166,   167,    -1,   169,    -1,   171,
     172,   173,   174,   175,    -1,   177,    -1,   179,   180,   181,
      -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,   191,
      -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,   201,
      -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,   211,
     212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,    -1,
     222,    -1,   224,   225,   226,   227,    -1,    -1,   230,    -1,
      -1,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,    -1,   248,    -1,   250,   251,
     252,   253,   254,    -1,   256,   257,    -1,    -1,   260,   261,
     262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,    -1,
      -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,   281,
      -1,   283,   284,   285,   286,    -1,   288,   289,   290,   291,
     292,   293,   294,    -1,   296,   297,   298,   299,   300,   301,
     302,   303,   304,    -1,   306,   307,   308,   309,   310,   311,
     312,    -1,    -1,   315,   316,   317,    -1,   319,   320,   321,
     322,    -1,   324,   325,    -1,   327,   328,   329,   330,   331,
     332,   333,   334,   335,   336,    -1,   338,   339,   340,    -1,
     342,   343,    -1,   345,    -1,   347,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,    -1,   358,   359,   360,   361,
     362,    -1,    -1,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,    -1,    -1,   376,   377,   378,   379,   380,   381,
      -1,   383,    -1,    -1,   386,     6,     7,     8,     9,    -1,
      11,    12,    -1,    14,    15,    16,    17,    -1,    19,    -1,
      21,    -1,    23,    24,    25,    26,    27,    28,    -1,    30,
      31,    32,    33,    -1,    35,    -1,    37,    38,    39,    40,
      -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,    -1,
      -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,    -1,
      -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,    80,
      81,    82,    83,    84,    85,    -1,    87,    -1,    -1,    -1,
      -1,    -1,    93,    -1,    95,    96,    97,    -1,    99,   100,
     101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,    -1,
     111,    -1,    -1,   114,   115,   116,   117,    -1,   119,   120,
     121,   122,   123,    -1,    -1,   126,   127,   128,    -1,   130,
     131,   132,   133,    -1,   135,   136,    -1,    -1,    -1,    -1,
      -1,   142,   143,   144,   145,   146,   147,   148,   149,    -1,
     151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,    -1,
     161,   162,   163,   164,    -1,   166,   167,    -1,   169,    -1,
     171,   172,   173,   174,   175,    -1,   177,    -1,   179,   180,
     181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,    -1,
     191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,   200,
     201,    -1,   203,   204,   205,   206,    -1,    -1,   209,    -1,
     211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,    -1,
      -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,   230,
      -1,    -1,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,    -1,   248,    -1,   250,
     251,   252,   253,   254,    -1,   256,   257,    -1,    -1,   260,
     261,   262,    -1,    -1,   265,    -1,    -1,    -1,   269,   270,
      -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,   280,
     281,    -1,   283,   284,   285,   286,    -1,   288,   289,   290,
     291,   292,   293,   294,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,    -1,   306,   307,   308,   309,   310,
     311,   312,    -1,    -1,   315,   316,   317,    -1,   319,   320,
     321,   322,    -1,   324,   325,    -1,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,    -1,   338,   339,   340,
      -1,   342,   343,    -1,   345,    -1,   347,   348,   349,   350,
      -1,   352,   353,   354,   355,    -1,    -1,   358,   359,   360,
     361,   362,    -1,    -1,   365,   366,   367,   368,   369,    -1,
     371,   372,    -1,    -1,    -1,   376,   377,   378,   379,   380,
     381,    -1,   383,    -1,    -1,   386,     6,     7,     8,     9,
      -1,    11,    12,    -1,    14,    15,    16,    17,    -1,    19,
      -1,    21,    -1,    23,    24,    25,    26,    27,    28,    -1,
      30,    31,    32,    33,    -1,    35,    -1,    37,    38,    39,
      40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      -1,    -1,    52,    53,    -1,    -1,    -1,    57,    58,    -1,
      -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,    79,
      80,    81,    82,    83,    84,    85,    -1,    87,    -1,    -1,
      -1,    -1,    -1,    93,    -1,    95,    96,    97,    -1,    99,
     100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,   109,
      -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,   119,
     120,   121,   122,   123,    -1,    -1,   126,   127,   128,    -1,
     130,   131,   132,   133,    -1,   135,   136,    -1,    -1,    -1,
      -1,    -1,   142,   143,   144,   145,   146,   147,   148,   149,
      -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,    -1,
      -1,   161,   162,   163,   164,    -1,   166,   167,    -1,   169,
      -1,   171,   172,   173,   174,   175,    -1,   177,    -1,   179,
     180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,   189,
      -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,   199,
     200,   201,    -1,   203,   204,   205,   206,    -1,    -1,   209,
      -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,    -1,
      -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,    -1,
     230,    -1,    -1,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,    -1,   248,    -1,
     250,   251,   252,   253,   254,    -1,   256,   257,    -1,    -1,
     260,   261,   262,    -1,    -1,   265,    -1,    -1,    -1,   269,
     270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,   279,
     280,   281,    -1,   283,   284,   285,   286,    -1,   288,   289,
     290,   291,   292,   293,   294,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,    -1,   306,   307,   308,   309,
     310,   311,   312,    -1,    -1,   315,   316,   317,    -1,   319,
     320,   321,   322,    -1,   324,   325,    -1,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,    -1,   338,   339,
     340,    -1,   342,   343,    -1,   345,    -1,   347,   348,   349,
     350,    -1,   352,   353,   354,   355,    -1,    -1,   358,   359,
     360,   361,   362,    -1,    -1,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,   379,
     380,   381,    -1,   383,    -1,    -1,   386,     6,     7,     8,
       9,    -1,    11,    12,    -1,    14,    15,    16,    17,    -1,
      19,    -1,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    33,    -1,    35,    -1,    37,    38,
      39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,
      -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    57,    58,
      -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,    -1,
      79,    80,    81,    82,    83,    84,    85,    -1,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,    -1,
      99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,   108,
     109,    -1,   111,    -1,    -1,   114,   115,   116,   117,    -1,
     119,   120,   121,   122,   123,    -1,    -1,   126,   127,   128,
      -1,   130,   131,   132,   133,    -1,   135,   136,    -1,    -1,
      -1,    -1,    -1,   142,   143,   144,   145,   146,   147,   148,
     149,    -1,   151,    -1,   153,    -1,   155,   156,   157,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,   166,   167,    -1,
     169,    -1,   171,   172,   173,   174,   175,    -1,   177,    -1,
     179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,    -1,
     189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,    -1,
     199,   200,   201,    -1,   203,   204,   205,   206,    -1,    -1,
     209,    -1,   211,   212,   213,    -1,   215,    -1,   217,    -1,
      -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,    -1,
      -1,   230,    -1,    -1,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,    -1,   248,
      -1,   250,   251,   252,   253,   254,    -1,   256,   257,    -1,
      -1,   260,   261,   262,    -1,    -1,   265,    -1,    -1,    -1,
     269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,   278,
     279,   280,   281,    -1,   283,   284,   285,   286,    -1,   288,
     289,   290,   291,   292,   293,   294,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,    -1,   306,   307,   308,
     309,   310,   311,   312,    -1,    -1,   315,   316,   317,    -1,
     319,   320,   321,   322,    -1,   324,   325,    -1,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,    -1,   338,
     339,   340,    -1,   342,   343,    -1,   345,    -1,   347,   348,
     349,   350,    -1,   352,   353,   354,   355,    -1,    -1,   358,
     359,   360,   361,   362,    -1,    -1,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,   378,
     379,   380,   381,    -1,   383,    -1,    -1,   386,     6,     7,
       8,     9,    -1,    11,    12,    -1,    14,    15,    16,    17,
      -1,    19,    -1,    21,    -1,    23,    24,    25,    26,    27,
      28,    -1,    30,    31,    32,    33,    -1,    35,    -1,    37,
      38,    39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,    57,
      58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,    77,
      -1,    79,    80,    81,    82,    83,    84,    85,    -1,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    97,
      -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,    -1,
     108,   109,    -1,   111,    -1,    -1,   114,   115,   116,   117,
      -1,   119,   120,   121,   122,   123,    -1,    -1,   126,   127,
     128,    -1,   130,   131,   132,   133,    -1,   135,   136,    -1,
      -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,   147,
     148,   149,    -1,   151,    -1,   153,    -1,   155,   156,   157,
      -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,   167,
      -1,   169,    -1,   171,   172,   173,   174,   175,    -1,   177,
      -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,    -1,
      -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,   197,
      -1,   199,   200,   201,    -1,   203,   204,   205,   206,    -1,
      -1,   209,    -1,   211,   212,   213,    -1,   215,    -1,   217,
      -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,   227,
      -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,    -1,
     248,    -1,   250,   251,   252,   253,   254,    -1,   256,   257,
      -1,    -1,   260,   261,   262,    -1,    -1,   265,    -1,    -1,
      -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,   277,
     278,   279,   280,   281,    -1,   283,   284,   285,   286,    -1,
     288,   289,   290,   291,   292,   293,   294,    -1,   296,   297,
     298,   299,   300,   301,   302,   303,   304,    -1,   306,   307,
     308,   309,   310,   311,   312,    -1,    -1,   315,   316,   317,
      -1,   319,   320,   321,   322,    -1,   324,   325,    -1,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,    -1,
     338,   339,   340,    -1,   342,   343,    -1,   345,    -1,   347,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,    -1,
     358,   359,   360,   361,   362,    -1,    -1,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,   377,
     378,   379,   380,   381,    -1,   383,    -1,    -1,   386,     6,
       7,     8,     9,    -1,    11,    12,    -1,    14,    15,    16,
      17,    -1,    19,    -1,    21,    -1,    23,    24,    25,    26,
      27,    28,    -1,    30,    31,    32,    33,    -1,    35,    -1,
      37,    38,    39,    40,    -1,    -1,    -1,    44,    45,    46,
      -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,
      57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,    76,
      77,    -1,    79,    80,    81,    82,    83,    84,    85,    -1,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      97,    -1,    99,   100,   101,    -1,   103,    -1,   105,    -1,
      -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,   116,
     117,    -1,   119,   120,   121,   122,   123,    -1,    -1,   126,
     127,   128,    -1,   130,   131,   132,   133,    -1,   135,   136,
      -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,   146,
     147,   148,   149,    -1,   151,    -1,   153,    -1,   155,   156,
     157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,   166,
     167,    -1,   169,    -1,   171,   172,   173,   174,   175,    -1,
     177,    -1,   179,   180,   181,    -1,   183,    -1,   185,    -1,
      -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,   196,
     197,    -1,   199,   200,   201,    -1,   203,   204,   205,   206,
      -1,    -1,   209,    -1,   211,   212,   213,    -1,   215,    -1,
     217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,   226,
     227,    -1,    -1,   230,    -1,    -1,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
      -1,   248,    -1,   250,   251,   252,   253,   254,    -1,   256,
     257,    -1,    -1,   260,   261,   262,    -1,    -1,   265,    -1,
      -1,    -1,   269,   270,    -1,    -1,   273,    -1,    -1,    -1,
     277,   278,   279,   280,   281,    -1,   283,   284,   285,   286,
      -1,   288,   289,   290,   291,   292,   293,   294,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,    -1,   306,
     307,   308,   309,   310,   311,   312,    -1,    -1,   315,   316,
     317,    -1,   319,   320,   321,   322,    -1,   324,   325,    -1,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
      -1,   338,   339,   340,    -1,   342,   343,    -1,   345,    -1,
     347,   348,   349,   350,    -1,   352,   353,   354,   355,    -1,
      -1,   358,   359,   360,   361,   362,    -1,    -1,   365,   366,
     367,   368,   369,    -1,   371,   372,    -1,    -1,    -1,   376,
     377,   378,   379,   380,   381,    -1,   383,    -1,    -1,   386,
       6,     7,     8,     9,    -1,    11,    12,    -1,    14,    15,
      16,    17,    -1,    19,    -1,    21,    -1,    23,    24,    25,
      26,    27,    28,    -1,    30,    31,    32,    33,    -1,    35,
      -1,    37,    38,    39,    40,    -1,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,
      -1,    57,    58,    -1,    -1,    -1,    -1,    63,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    72,    -1,    74,    -1,
      76,    77,    -1,    79,    80,    81,    82,    83,    84,    85,
      -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    97,    -1,    99,   100,   101,    -1,   103,    -1,   105,
      -1,    -1,   108,   109,    -1,   111,    -1,    -1,   114,   115,
     116,   117,    -1,   119,   120,   121,   122,   123,    -1,    -1,
     126,   127,   128,    -1,   130,   131,   132,   133,    -1,   135,
     136,    -1,    -1,    -1,    -1,    -1,   142,   143,   144,   145,
     146,   147,   148,   149,    -1,   151,    -1,   153,    -1,   155,
     156,   157,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,   167,    -1,   169,    -1,   171,   172,   173,   174,   175,
      -1,   177,    -1,   179,   180,   181,    -1,   183,    -1,   185,
      -1,    -1,    -1,   189,    -1,   191,    -1,    -1,   194,    -1,
     196,   197,    -1,   199,   200,   201,    -1,   203,   204,   205,
     206,    -1,    -1,   209,    -1,   211,   212,   213,    -1,   215,
      -1,   217,    -1,    -1,    -1,    -1,   222,    -1,   224,   225,
     226,   227,    -1,    -1,   230,    -1,    -1,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,    -1,   248,    -1,   250,   251,   252,   253,   254,    -1,
     256,   257,    -1,    -1,   260,   261,   262,    -1,    -1,   265,
      -1,    -1,    -1,   269,   270,    -1,    -1,   273,    -1,    -1,
      -1,   277,   278,   279,   280,   281,    -1,   283,   284,   285,
     286,    -1,   288,   289,   290,   291,   292,   293,   294,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,    -1,
     306,   307,   308,   309,   310,   311,   312,    -1,    -1,   315,
     316,   317,    -1,   319,   320,   321,   322,    -1,   324,   325,
      -1,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,    -1,   338,   339,   340,    -1,   342,   343,    -1,   345,
      -1,   347,   348,   349,   350,    -1,   352,   353,   354,   355,
      -1,    -1,   358,   359,   360,   361,   362,    -1,    -1,   365,
     366,   367,   368,   369,    -1,   371,   372,    -1,    -1,    -1,
     376,   377,   378,   379,   380,   381,    -1,   383,    -1,    -1,
     386,     6,     7,     8,    -1,    -1,    11,    12,    -1,    14,
      15,    16,    -1,    -1,    -1,    20,    21,    -1,    23,    24,
      25,    26,    27,    28,    -1,    30,    31,    32,    -1,    -1,
      35,    -1,    37,    38,    39,    40,    -1,    42,    -1,    44,
      45,    46,    -1,    48,    49,    50,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    98,    -1,    -1,    -1,   102,   103,   104,
     105,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   116,    -1,    -1,    -1,    -1,    -1,    -1,   123,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,
      -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   147,   148,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   162,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   174,
      -1,    -1,   177,    -1,    -1,    -1,   181,    -1,    -1,    -1,
      -1,   186,    -1,   188,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   198,    -1,    -1,    -1,   202,    -1,    -1,
      -1,    -1,    -1,   208,    -1,    -1,    -1,    -1,    -1,    -1,
     215,    -1,   217,    -1,    -1,   220,   221,    -1,   223,    -1,
      -1,    -1,    -1,    -1,   229,    -1,   231,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   247,   248,    -1,    -1,    -1,    -1,    -1,   254,
      -1,    -1,    -1,   258,    -1,   260,   261,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   274,
     275,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   283,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   293,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     305,    -1,   307,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   320,    -1,    -1,   323,    -1,
     325,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     335,    -1,    -1,    -1,    -1,    -1,    -1,   342,   343,    -1,
      -1,    -1,    -1,   348,    -1,   350,    -1,    -1,    -1,    -1,
      -1,   356,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   368,    -1,   370,    -1,     6,     7,     8,
      -1,    -1,    11,    12,    -1,    14,    15,    16,   383,    -1,
      -1,   386,    21,    -1,    23,    24,    25,    26,    27,    28,
      -1,    30,    31,    32,    -1,    -1,    35,    -1,    37,    38,
      39,    40,    -1,    -1,    -1,    44,    45,    46,    -1,    48,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,
      -1,    -1,    -1,   102,   103,   104,   105,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   116,    -1,    -1,
      -1,    -1,    -1,    -1,   123,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,    -1,    -1,    -1,   137,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   147,   148,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   174,    -1,    -1,   177,    -1,
      -1,    -1,   181,    -1,    -1,    -1,    -1,   186,    -1,   188,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   198,
      -1,    -1,    -1,   202,    -1,    -1,    -1,    -1,    -1,   208,
      -1,    -1,    -1,    -1,    -1,    -1,   215,    -1,   217,    -1,
      -1,   220,   221,    -1,   223,    -1,    -1,    -1,    -1,    -1,
     229,    -1,   231,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   247,   248,
      -1,    -1,    -1,    -1,    -1,   254,    -1,    -1,    -1,   258,
      -1,   260,   261,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   274,   275,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   283,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   293,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   305,    -1,   307,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   320,    -1,    -1,   323,    -1,   325,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   335,    -1,    -1,    -1,
      -1,    -1,    -1,   342,   343,    -1,    -1,    -1,    -1,   348,
      -1,   350,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   368,
      -1,   370,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   383,    -1,    -1,   386
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned short yystos[] =
{
       0,   418,   419,     0,     5,    20,    29,    41,    42,    47,
      49,    50,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,   115,   181,   197,   214,
     240,   243,   259,   312,   344,   356,   368,   380,   383,   384,
     386,   388,   392,   394,   395,   399,   400,   401,   402,   403,
     406,   407,   408,   409,   411,   412,   413,   414,   420,   763,
     764,   767,   801,   803,   895,   908,   909,   802,     3,     6,
       7,     8,     9,    11,    12,    14,    15,    16,    17,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    30,
      31,    32,    33,    35,    37,    38,    39,    40,    42,    44,
      45,    46,    48,    49,    50,    52,    53,    57,    58,    63,
      72,    74,    76,    77,    79,    87,    88,    89,    97,    98,
     101,   102,   103,   104,   105,   116,   119,   121,   122,   123,
     126,   127,   132,   133,   134,   137,   144,   146,   147,   148,
     149,   155,   162,   163,   168,   173,   174,   175,   177,   179,
     181,   186,   188,   190,   192,   198,   202,   208,   212,   215,
     217,   220,   221,   223,   229,   231,   233,   234,   237,   244,
     247,   248,   254,   257,   258,   260,   261,   274,   275,   283,
     286,   293,   296,   300,   304,   305,   306,   307,   314,   319,
     320,   322,   323,   325,   328,   335,   342,   343,   348,   350,
     352,   354,   356,   359,   361,   365,   368,   370,   383,   386,
     408,   421,   422,   423,   425,   426,   427,   431,   434,   435,
     436,   440,   450,   451,   452,   455,   456,   459,   460,   469,
     494,   499,   500,   504,   508,   510,   523,   524,   525,   526,
     532,   537,   538,   542,   543,   547,   550,   551,   562,   568,
     580,   581,   583,   586,   588,   589,   592,   595,   603,   604,
     605,   606,   607,   612,   613,   614,   618,   619,   620,   621,
     623,   624,   625,   626,   627,   632,   635,   639,   640,   643,
     644,   647,   648,   649,   650,   651,   777,   790,   791,   792,
     793,   794,   800,   808,   813,   814,   815,   816,   818,   820,
     822,   824,   825,   826,   827,   829,   834,   835,   838,   843,
     844,   854,   855,   857,   858,   865,   866,   867,   868,   870,
     871,   874,   876,   879,   887,   891,   892,   902,     9,    17,
      19,    33,    52,    53,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    99,   100,   101,   107,   108,   109,   111,
     112,   113,   114,   117,   118,   119,   120,   121,   122,   124,
     125,   126,   127,   128,   129,   130,   131,   133,   134,   135,
     136,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     149,   150,   151,   152,   153,   155,   156,   157,   158,   159,
     160,   161,   162,   163,   164,   165,   166,   167,   168,   169,
     170,   171,   172,   173,   175,   178,   179,   180,   182,   183,
     184,   185,   187,   189,   191,   192,   193,   194,   195,   196,
     197,   199,   200,   201,   203,   204,   205,   206,   207,   209,
     211,   212,   213,   216,   218,   222,   224,   225,   226,   227,
     228,   230,   232,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   249,   250,   251,
     252,   253,   255,   256,   257,   259,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   277,   278,
     279,   280,   281,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   294,   295,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   306,   308,   309,   310,   311,   312,   314,
     315,   316,   317,   318,   319,   321,   322,   324,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   336,   337,   338,
     339,   340,   341,   344,   345,   346,   347,   349,   351,   352,
     353,   354,   355,   357,   358,   359,   360,   361,   362,   363,
     364,   365,   366,   367,   369,   371,   372,   374,   375,   376,
     377,   378,   379,   380,   381,   805,   806,   808,   810,   813,
     816,   817,   820,   824,   880,   887,   888,   890,   893,    18,
      57,    58,    63,    72,    74,    76,    77,   115,   344,   387,
     767,   770,   775,   786,   787,   878,   879,   880,   883,   889,
     890,   891,   899,   901,   902,    34,   210,   856,    13,    86,
     150,   756,   770,   778,   779,   836,   837,   883,   902,     5,
      29,    34,    41,    42,    49,    50,   115,   210,   214,   356,
     412,   819,   881,   882,   886,   887,   888,   889,   755,   883,
     755,   882,    29,    41,   115,   214,   875,    44,    46,   255,
     809,   347,   378,   608,    85,   131,   144,   161,   189,   193,
     226,   269,   310,   315,   337,   349,   363,   778,   149,   608,
     755,   249,   266,   740,   751,   753,   759,   776,   883,   267,
     608,   104,   465,    85,    95,   113,   129,   144,   150,   161,
     191,   193,   235,   269,   271,   310,   338,   340,   349,   353,
     354,   357,   363,   470,   505,   535,   563,   569,   778,    18,
     286,   755,   788,   842,   901,   329,   755,   187,    85,    95,
     113,   131,   144,   161,   189,   193,   205,   269,   290,   309,
     310,   315,   337,   349,   354,   363,   372,   509,   539,   608,
     199,   842,   627,   634,    80,    86,    99,   180,   185,   187,
     202,   227,   250,   288,   297,   400,   544,   545,   546,   755,
     763,   768,   769,   899,    18,    86,   134,   155,   173,   212,
     295,   309,   314,   338,   340,   349,   361,   362,   552,   553,
     554,   218,   753,   883,   760,   770,   337,   654,   544,   755,
     753,   842,   144,   205,   337,   590,    86,   317,   342,   347,
     883,   192,   559,   608,    86,   159,   656,     4,    10,   130,
     235,   245,   317,   342,   347,   441,   883,    86,   317,   342,
     347,   883,   347,   654,   872,   882,   401,   753,   268,   678,
     753,   188,   629,   648,   649,   101,   422,   411,    35,   370,
     628,   170,   216,   272,   356,   657,   658,   796,   800,   820,
     815,   411,   821,   823,     5,    29,    41,   115,   214,   828,
     145,   197,   240,   243,   312,   380,   408,   707,   799,   804,
     895,   808,   810,   817,   812,   411,   799,   755,   788,   903,
     150,   778,    25,   364,   402,   755,   755,   385,   780,   781,
     416,   901,   408,   412,   904,   905,   906,   907,   909,   819,
     364,   845,   846,    29,   214,   214,   886,     7,    11,    23,
      24,    45,    48,   160,   877,   877,    21,   817,   740,   751,
     761,   878,   885,   889,   890,   892,   902,   541,   740,   883,
     756,   541,   761,   775,   755,   120,   755,   753,   678,   753,
     755,   775,    40,   410,   741,   267,    85,   125,   144,   161,
     189,   205,   269,   309,   310,   315,   337,   349,   354,   372,
     548,   753,   761,   755,   408,   349,   756,   541,   338,   340,
     775,   338,   340,   120,   385,   395,   396,   397,   399,   400,
     401,   402,   403,   404,   712,   713,   299,   775,   883,   755,
     541,   775,   315,   337,   509,   131,   205,   189,   309,   372,
     903,   842,   902,   645,   678,   761,   755,   408,   756,   761,
     775,   120,   712,   755,   755,   430,   775,   226,   540,   541,
     386,   788,   841,   839,   628,   545,    86,   545,    86,   545,
     545,   768,   546,   755,   755,   218,   364,   847,   848,   850,
     851,   903,   289,   267,   414,   753,   752,   753,   546,   187,
     755,   753,    98,   381,   222,   270,   552,   267,    92,   103,
     105,   106,   112,   113,   115,   116,   123,   132,   138,   139,
     140,   141,   147,   148,   162,   174,   177,   178,   181,   214,
     215,   217,   246,   248,   255,   259,   260,   261,   269,   276,
     283,   293,   307,   318,   325,   335,   342,   343,   348,   350,
     351,   357,   363,   368,   385,   390,   391,   393,   399,   400,
     401,   403,   404,   408,   648,   687,   688,   689,   694,   695,
     696,   698,   699,   700,   701,   704,   705,   708,   709,   714,
     716,   718,   734,   739,   740,   743,   744,   751,   761,   762,
     763,   764,   765,   766,   767,   774,   878,   881,   884,   889,
     890,   898,   899,   901,   902,   344,   395,   344,   395,   837,
      86,   453,   754,   755,   317,   441,   150,   448,   770,    98,
     117,   441,   381,   222,   292,   609,   611,   344,   415,    98,
     381,   222,   609,   610,   753,   886,   408,   753,   319,   401,
     186,   630,   409,   409,   411,   753,    86,   655,   655,   108,
     655,   182,   232,   264,   661,   667,   401,   830,   831,   833,
     795,   412,   412,    29,   214,   214,   344,   344,   344,   344,
     344,   400,   763,   764,   772,   797,   899,   168,   811,   830,
      93,   784,   108,   787,   787,   847,   218,   847,   848,   389,
     782,   883,   416,   783,   780,   409,   905,   906,   904,   413,
     414,   767,   772,   773,   852,   853,   898,   214,   220,   755,
     344,   755,     6,   755,   877,   833,   408,   298,   298,   319,
     451,    83,   163,   277,   319,   457,   408,   570,    83,   163,
     298,   298,   541,   298,   501,    83,    87,   163,   298,   319,
     122,   134,   277,   267,   298,   319,   376,   428,   451,   411,
     401,   758,   883,   753,   761,   761,   712,   755,   755,   755,
     376,   466,   408,   528,   118,   103,   105,   115,   116,   147,
     148,   181,   215,   217,   248,   261,   293,   320,   325,   342,
     343,   368,   683,   686,   688,   689,   693,   695,   696,   697,
     699,   700,   704,   705,   878,   884,   889,   890,   902,   755,
     376,    93,   622,   376,   432,   541,   528,   437,   883,   438,
      84,   100,   511,    93,   528,   376,   424,   753,   753,   226,
     541,   759,   883,   761,   755,   753,   104,   142,   211,   251,
     311,   375,   680,   408,   683,   570,   541,   408,   267,   267,
     414,   770,   111,   302,   414,   458,   840,   846,   851,   149,
     633,   635,   639,   643,   644,   647,   755,   850,   850,    43,
     849,   894,   897,   901,   849,    51,   859,   863,   901,   144,
     189,   226,   310,   337,   555,   752,   554,   150,   367,   408,
     636,   647,   202,   414,   641,   755,   841,   183,   591,   591,
     230,   182,   267,   408,   406,   648,   724,   369,   702,   716,
     738,   408,   702,   702,   408,   408,   408,   742,   408,   742,
     408,   742,   408,   692,   692,   284,   648,   408,   408,   690,
     115,   116,   702,   716,   408,   408,   691,   408,   408,   408,
     408,   742,   408,   376,   377,   408,   706,   408,   706,   408,
     408,   648,   742,   406,   719,   741,   716,   716,   716,   716,
     648,   710,   716,   720,   770,   116,   408,   703,   408,   770,
     202,   220,   255,   269,   275,   712,   715,   716,    78,    90,
      93,    97,   102,   198,   202,   220,   221,   231,   255,   258,
     269,   271,   323,   385,   395,   396,   397,   399,   400,   401,
     402,   403,   404,   714,   715,   719,   218,   414,   652,   850,
     719,   408,    26,   900,   901,   263,   267,   869,   869,   837,
     837,   153,   199,   454,   414,   117,   150,   449,   770,   883,
      93,   150,   235,   447,   705,   773,   902,   230,   268,   379,
     222,   150,   178,   263,   267,   351,   442,   443,   445,   446,
     773,   883,   442,   230,   220,   753,   408,   745,   748,   883,
     628,   408,   631,   648,   650,   651,   650,   659,   660,   716,
     650,   292,   361,    86,   663,   716,   664,   716,   667,   668,
     661,   662,   401,   411,   414,   887,   830,   807,   810,   807,
     214,   145,   197,   240,   312,   240,   312,   312,   243,   240,
     243,   312,   763,   764,   414,   798,   149,   830,   411,   778,
     363,   785,   787,   410,   768,   783,   409,   413,   907,   414,
     817,   408,   755,   408,   887,   401,   582,   683,   344,   344,
     441,   118,   129,   184,   287,   357,   481,   482,   129,   150,
     255,   344,   150,   255,   202,   209,   273,   409,   571,   572,
     573,   576,   683,   884,   298,   363,   363,   344,   344,   364,
     344,   109,   143,   204,   239,   241,   251,   301,   328,   502,
     125,   481,   594,   594,   129,   594,   594,   377,   267,   345,
     344,   678,   344,   441,   428,   135,   136,   202,   252,   253,
     279,   336,   366,   429,   741,   408,   570,   408,   220,   267,
     267,   220,   265,   187,   344,   461,   529,   530,   886,   408,
     686,    93,    92,   406,   684,   145,   243,   380,   408,   707,
     741,    84,   166,   236,   277,   339,   615,   616,   683,   432,
     336,   363,   433,   535,    98,   134,   439,   469,   550,   612,
     155,   212,   361,   512,   513,   408,   527,   428,   501,   262,
     408,   496,   449,   182,   267,   570,    93,   408,   483,   376,
     377,   646,   311,   716,   582,    93,   458,   364,   254,   584,
     683,   753,   753,   775,   458,   541,   851,   846,   755,   850,
      18,   414,   900,    18,   763,   901,   414,   395,   754,   560,
     561,   761,   754,   754,   752,   344,   367,   408,   637,   638,
     883,    81,   171,   307,   321,   642,   753,   555,   716,   720,
     720,   723,   724,   408,   374,   735,   736,   716,   720,   716,
     720,   409,   768,   768,   768,   145,   197,   240,   243,   312,
     380,   721,   725,   770,   902,   768,   702,   702,   716,   768,
     585,   712,   883,   716,   726,   400,   403,   404,   408,   714,
     717,   718,   728,   409,   710,   716,   716,   720,   729,   342,
     342,   768,   768,   716,   107,   187,   228,   346,   716,   720,
     732,   716,   719,   409,   409,   414,   319,   768,   768,   707,
     648,   159,   255,   259,   202,   408,   307,   408,   709,    86,
      91,   326,   408,   648,   709,   711,   683,   716,   886,   342,
     717,   716,   408,   648,   733,   159,   178,   255,   259,   262,
     351,   358,   716,   102,   198,   202,   231,   323,   408,   716,
     344,   716,   716,   716,   716,   716,   716,   716,   716,   716,
     716,   711,   191,   235,   337,   338,   340,   653,   753,   744,
     187,   670,    86,   159,   401,   409,   720,   755,   901,   755,
     347,   408,   770,   292,   316,   444,   230,   414,   817,   409,
     746,   883,   414,   670,   719,   626,   753,   754,   414,    94,
     158,   364,   268,   262,   669,   264,   414,   232,   831,   684,
     411,   413,   810,   413,   772,   409,    40,   411,   786,   782,
     402,   852,   684,   896,   906,   896,   684,   409,   755,   756,
     408,   755,   224,   224,   408,   755,   259,   775,   716,   259,
     409,   414,   576,   741,   344,   430,   430,   775,   755,   757,
     883,   755,   772,   108,   503,   772,   772,   143,   239,   241,
     424,   424,   474,   883,   883,   755,   883,   593,   755,   265,
     755,   337,   775,   298,   775,   193,   767,   768,   360,   582,
     220,   584,   259,   549,   770,   541,   541,   549,   331,   332,
     462,   770,   409,   414,   395,   716,    92,   684,   683,   406,
     407,   408,   685,   767,   768,   883,   344,   344,   768,   512,
     395,   617,   617,   617,   617,   616,   475,   768,   430,   182,
     775,   470,   569,   267,   271,   681,   682,   883,   753,   231,
     471,   472,   473,   474,   479,   481,   497,   498,   883,    93,
     194,   770,   753,   303,   596,   484,   485,   883,    93,   196,
     196,   182,   409,   683,   757,   414,   409,   414,   458,   458,
     645,   903,   897,   903,   861,   864,   901,   864,   859,    12,
     860,   414,   570,   193,   556,   557,   883,   150,   744,   749,
     750,   409,   414,   719,   171,   321,   171,   321,   307,   361,
     242,   187,   409,   414,   407,   407,   414,   768,   716,   165,
     736,   737,    93,   409,   364,   409,   409,   409,   409,   414,
     409,   187,   409,   414,   409,   414,   409,   410,   282,   727,
     409,   717,   717,   717,   716,   717,    78,   202,   220,   269,
     385,   395,   396,   397,   399,   400,   401,   402,   403,   404,
     714,   409,   409,   409,   182,   187,   730,   731,   409,   381,
     381,   409,   409,    93,   732,   720,   732,   732,   187,   409,
     407,   416,   719,   741,   716,   883,   409,   409,   187,   259,
     648,   585,   648,   381,    90,   169,   720,   187,   178,   259,
     262,   351,   358,   408,   169,   717,   716,   733,   716,   344,
     585,   716,   408,   648,   338,   340,   338,   340,   753,   654,
     654,   408,   648,   671,   672,   673,   678,   679,   740,   761,
     680,   720,   720,   409,   409,   609,   768,   707,   128,   611,
     444,   445,   684,   409,   719,   748,   680,   395,   409,   660,
     715,   754,   664,   664,   663,   395,   832,   411,   756,    36,
     873,   409,   409,   411,   298,   716,   482,   408,   408,   484,
     458,   572,   403,   755,   298,   772,   772,   772,   683,   163,
     319,   457,   458,   458,   344,   344,   430,   767,   409,   549,
     409,   220,   220,   364,   467,   468,   530,   269,   400,   531,
     575,   576,   715,   773,   409,   406,   409,   768,   684,   685,
     399,   400,   401,   402,   403,   407,   409,   267,   150,   763,
     767,   771,   899,   150,   770,   150,   755,   150,   755,   118,
     129,   150,   152,   207,   255,   259,   287,   295,   357,   476,
     477,   478,   354,   438,   337,   753,   513,   409,   414,   683,
     408,   753,   409,   414,   409,   414,   495,   506,   740,   755,
     883,   344,   364,   564,   575,   267,   409,   414,   647,   647,
     842,   458,   409,   458,   683,   458,   254,   683,   142,   414,
     395,   561,   883,   376,   414,   558,   409,   414,   367,   647,
     638,   171,   171,   556,   716,   724,   409,   341,   716,   168,
     683,   541,   768,   716,   716,   768,   585,   716,   730,   683,
     717,   159,   255,   262,   717,   717,   717,   717,   717,   717,
     717,   717,   717,   717,   716,   716,   731,   730,   706,   706,
     683,   409,   409,   409,   720,   719,   716,   719,   703,   770,
     709,   409,   718,   717,   716,   409,   716,   408,   683,   722,
     716,    90,   169,   169,   716,   409,   169,   716,   654,   654,
     654,   654,   753,   753,   648,   672,   673,    93,   674,   883,
     414,   137,   188,   208,   223,   229,   247,   305,   382,   675,
     674,    93,   674,   883,   408,   193,   665,   409,   409,   409,
     873,   395,   414,   150,   716,   907,   385,   789,   344,   409,
     484,   484,   409,   354,   344,   475,   255,   255,   330,   333,
     755,   755,   220,   220,   549,   549,   424,   157,   152,   207,
     255,   520,   521,   522,   768,   376,   377,   407,   409,   685,
     685,   685,   685,   685,   684,   707,   753,   408,   755,   717,
     153,   199,   152,   259,   224,   753,   683,   753,   182,   514,
     271,   682,   471,   172,   203,   480,   206,   491,   473,   498,
     883,   647,   225,   507,   770,   757,   408,    93,   110,   176,
     200,   226,   303,   313,   327,   334,   373,   577,   578,   155,
     212,   314,   361,   601,   485,   458,   646,   861,     8,    14,
      15,    16,    26,    27,    28,    30,    31,    32,    37,    38,
      39,   284,   354,   862,   192,   557,   750,   408,   458,   716,
     409,   409,   409,   409,   409,   731,   187,   262,   408,   409,
     407,   707,   722,   409,   414,   717,   716,   716,   169,   716,
     409,   753,   753,   753,   753,   409,   883,   408,   672,   223,
     274,   676,   672,   676,   223,   675,   676,   672,   223,   408,
     883,   408,   409,   720,   108,   195,   666,   770,   408,   746,
     883,   755,   409,   409,   755,   259,   259,   768,   883,   549,
     549,   463,   770,   153,   199,   152,   522,   521,   407,   189,
     189,   187,   519,   716,   255,   477,   483,   364,   408,   164,
     515,   173,   513,   409,   151,   151,   408,   376,   377,   492,
     770,   187,   408,   565,   566,   758,   761,   883,   574,   770,
     267,   313,   449,   259,   154,   219,   376,   578,   579,   344,
     182,   270,   749,   717,   408,   717,   719,   409,   683,   716,
     674,   408,   754,   672,   267,   364,   677,   672,   223,   672,
     681,   408,   681,   883,   409,   720,   716,   707,   716,   747,
     295,   104,   156,   259,   265,   464,   561,    93,   587,   753,
     520,   409,   238,   486,   757,   307,   329,   516,   291,   492,
     752,   265,   265,   267,   493,   541,   716,   409,   414,   364,
     541,   567,   408,   414,   259,   154,   219,   267,   528,   753,
     409,   717,   409,   754,   409,   716,   408,   672,   677,   409,
     681,   409,   414,   409,   753,   622,   622,   587,    96,   182,
     188,   278,   267,   487,   488,   489,    93,   755,   493,   409,
     127,   409,   680,   566,   541,   720,   770,   210,   259,   680,
     409,   409,   754,   409,   747,   483,   770,   770,   164,   155,
     361,   267,   489,   267,   488,   189,   269,   333,   533,   534,
     408,   155,   163,   285,   567,   409,   210,   160,   409,   486,
     307,   111,   251,   302,   319,   490,   490,   768,   768,   683,
     414,   517,   518,   774,   883,   308,   308,   567,   213,   602,
     487,   173,    82,   150,   259,   761,   585,   534,   409,   414,
     256,   408,   597,   599,   604,   635,   639,   643,   647,   520,
     291,   570,   294,   408,   536,   518,   598,   599,   600,   648,
     649,   761,   584,   409,   411,   408,   409,   600,   517,   536,
     409
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1

/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 5:
#line 566 "preproc.y"
    { connection = NULL; }
    break;

  case 7:
#line 569 "preproc.y"
    {
			fprintf(yyout, "%s", yyvsp[0].str);
                        free(yyvsp[0].str);
			output_line_number();
		}
    break;

  case 9:
#line 575 "preproc.y"
    { fprintf(yyout, "%s", yyvsp[0].str); free(yyvsp[0].str); }
    break;

  case 10:
#line 576 "preproc.y"
    { fprintf(yyout, "%s", yyvsp[0].str); free(yyvsp[0].str); }
    break;

  case 11:
#line 577 "preproc.y"
    { braces_open++; fputs("{", yyout); }
    break;

  case 12:
#line 578 "preproc.y"
    { remove_typedefs(braces_open); remove_variables(braces_open--); fputs("}", yyout); }
    break;

  case 13:
#line 582 "preproc.y"
    {
			connection = yyvsp[0].str;
			/*
			 *	Do we have a variable as connection target?
			 *	Remove the variable from the variable
			 *	list or else it will be used twice
			 */
			if (argsinsert != NULL)
				argsinsert = NULL;
		}
    break;

  case 14:
#line 593 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 15:
#line 594 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 16:
#line 595 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 17:
#line 596 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 18:
#line 597 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 19:
#line 598 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 20:
#line 599 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 21:
#line 600 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 22:
#line 601 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 23:
#line 603 "preproc.y"
    {
			if (INFORMIX_MODE)
			{
				/* Informix also has a CLOSE DATABASE command that
				   essantially works like a DISCONNECT CURRENT 
				   as far as I know. */
				if (strcasecmp(yyvsp[0].str+strlen("close "), "database") == 0)
				{
					if (connection)
		                                mmerror(PARSE_ERROR, ET_ERROR, "no at option for close database statement.\n");
								
					fprintf(yyout, "{ ECPGdisconnect(__LINE__, \"CURRENT\");");
		                        whenever_action(2);
		                        free(yyvsp[0].str);
				}
				else
					output_statement(yyvsp[0].str, 0, connection);
			}
			else
				output_statement(yyvsp[0].str, 0, connection);
		}
    break;

  case 24:
#line 624 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 25:
#line 625 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 26:
#line 626 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 27:
#line 627 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 28:
#line 628 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 29:
#line 629 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 30:
#line 630 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 31:
#line 631 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 32:
#line 632 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 33:
#line 633 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 34:
#line 634 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 35:
#line 635 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 36:
#line 636 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 37:
#line 637 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 38:
#line 638 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 39:
#line 639 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 40:
#line 640 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 41:
#line 641 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 42:
#line 642 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 43:
#line 644 "preproc.y"
    { output_simple_statement(yyvsp[0].str); }
    break;

  case 44:
#line 645 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 45:
#line 646 "preproc.y"
    { output_statement(yyvsp[0].str, 1, connection); }
    break;

  case 46:
#line 647 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 47:
#line 648 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 48:
#line 649 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 49:
#line 650 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 50:
#line 651 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 51:
#line 652 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 52:
#line 653 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 53:
#line 654 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 54:
#line 655 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 55:
#line 656 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 56:
#line 657 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 57:
#line 659 "preproc.y"
    { output_statement(yyvsp[0].str, 1, connection); }
    break;

  case 58:
#line 660 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 59:
#line 661 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 60:
#line 662 "preproc.y"
    { output_statement(yyvsp[0].str, 1, connection); }
    break;

  case 61:
#line 663 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 62:
#line 664 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 63:
#line 665 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 64:
#line 666 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 65:
#line 668 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 66:
#line 669 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 67:
#line 670 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 68:
#line 671 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 69:
#line 672 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 70:
#line 673 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 71:
#line 674 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 72:
#line 675 "preproc.y"
    { output_statement(yyvsp[0].str, 1, connection); }
    break;

  case 73:
#line 677 "preproc.y"
    {
			fprintf(yyout, "{ ECPGtrans(__LINE__, %s, \"%s\");", connection ? connection : "NULL", yyvsp[0].str);
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 74:
#line 682 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 75:
#line 683 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 76:
#line 684 "preproc.y"
    { output_statement(yyvsp[0].str, 1, connection); }
    break;

  case 77:
#line 685 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 78:
#line 686 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 79:
#line 687 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 80:
#line 688 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 81:
#line 689 "preproc.y"
    { output_statement(yyvsp[0].str, 0, connection); }
    break;

  case 82:
#line 691 "preproc.y"
    {
			fprintf(yyout,"ECPGallocate_desc(__LINE__, %s);",yyvsp[0].str);
			whenever_action(0);
			free(yyvsp[0].str);
		}
    break;

  case 83:
#line 697 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for connect statement.\n");

			fprintf(yyout, "{ ECPGconnect(__LINE__, %d, %s, %d); ", compat, yyvsp[0].str, autocommit);
			reset_variables();
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 84:
#line 707 "preproc.y"
    {
			output_simple_statement(yyvsp[0].str);
		}
    break;

  case 85:
#line 711 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for deallocate statement.\n");
			fprintf(yyout, "{ ECPGdeallocate(__LINE__, %d, %s);", compat, yyvsp[0].str);
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 86:
#line 719 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for deallocate statement.\n");
			fprintf(yyout,"ECPGdeallocate_desc(__LINE__, %s);",yyvsp[0].str);
			whenever_action(0);
			free(yyvsp[0].str);
		}
    break;

  case 87:
#line 727 "preproc.y"
    {
			output_simple_statement(yyvsp[0].str);
		}
    break;

  case 88:
#line 731 "preproc.y"
    {
			fprintf(yyout, "{ ECPGdescribe(__LINE__, %s,", yyvsp[0].str);
			dump_variables(argsresult, 1);
			fputs("ECPGt_EORT);", yyout);
			fprintf(yyout, "}");
			output_line_number();
				
			/* whenever_action(2); */
			free(yyvsp[0].str);
		}
    break;

  case 89:
#line 742 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for disconnect statement.\n");

			fprintf(yyout, "{ ECPGdisconnect(__LINE__, %s);",
					yyvsp[0].str ? yyvsp[0].str : "\"CURRENT\"");
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 90:
#line 752 "preproc.y"
    {
			output_statement(yyvsp[0].str, 0, connection);
		}
    break;

  case 91:
#line 756 "preproc.y"
    {
			fprintf(yyout, "{ ECPGdeallocate(__LINE__, %d, \"%s\");", compat, yyvsp[0].str);

			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 92:
#line 763 "preproc.y"
    {
			lookup_descriptor(yyvsp[0].descriptor.name, connection);
			output_get_descr(yyvsp[0].descriptor.name, yyvsp[0].descriptor.str);
			free(yyvsp[0].descriptor.name);
			free(yyvsp[0].descriptor.str);
		}
    break;

  case 93:
#line 770 "preproc.y"
    {
			lookup_descriptor(yyvsp[0].str, connection);
			output_get_descr_header(yyvsp[0].str);
			free(yyvsp[0].str);
		}
    break;

  case 94:
#line 776 "preproc.y"
    {
			struct cursor *ptr;

			if ((ptr = add_additional_variables(yyvsp[0].str, true)) != NULL)
				output_statement(mm_strdup(ptr->command), 0, ptr->connection ? mm_strdup(ptr->connection) : NULL);
		}
    break;

  case 95:
#line 783 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for prepare statement.\n");

			fprintf(yyout, "{ ECPGprepare(__LINE__, %s);", yyvsp[0].str);
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 96:
#line 791 "preproc.y"
    { /* output already done */ }
    break;

  case 97:
#line 793 "preproc.y"
    {
			fprintf(yyout, "{ ECPGsetcommit(__LINE__, \"%s\", %s);", yyvsp[0].str, connection ? connection : "NULL");
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 98:
#line 799 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for set connection statement.\n");

			fprintf(yyout, "{ ECPGsetconn(__LINE__, %s);", yyvsp[0].str);
			whenever_action(2);
			free(yyvsp[0].str);
		}
    break;

  case 99:
#line 808 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for typedef statement.\n");

			fprintf(yyout, "%s", yyvsp[0].str);
			free(yyvsp[0].str);
			output_line_number();
		}
    break;

  case 100:
#line 817 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for var statement.\n");

			output_simple_statement(yyvsp[0].str);
		}
    break;

  case 101:
#line 824 "preproc.y"
    {
			if (connection)
				mmerror(PARSE_ERROR, ET_ERROR, "no at option for whenever statement.\n");

			output_simple_statement(yyvsp[0].str);
		}
    break;

  case 102:
#line 845 "preproc.y"
    { yyval.str = cat_str(4, make_str("create user"), yyvsp[-2].str, make_str("with"), yyvsp[0].str); }
    break;

  case 103:
#line 848 "preproc.y"
    { yyval.str = make_str("with"); }
    break;

  case 104:
#line 849 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 105:
#line 861 "preproc.y"
    { yyval.str = cat_str(3, make_str("alter user"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 106:
#line 863 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter user"), yyvsp[-2].str, make_str("with"), yyvsp[0].str); }
    break;

  case 107:
#line 867 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter user"), yyvsp[-2].str, make_str("set"), yyvsp[0].str); }
    break;

  case 108:
#line 869 "preproc.y"
    { yyval.str = cat_str(3, make_str("alter user"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 109:
#line 879 "preproc.y"
    { yyval.str = cat2_str(make_str("drop user"), yyvsp[0].str);}
    break;

  case 110:
#line 885 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 111:
#line 886 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 112:
#line 890 "preproc.y"
    { yyval.str = cat2_str(make_str("password"), yyvsp[0].str); }
    break;

  case 113:
#line 892 "preproc.y"
    { yyval.str = cat2_str(make_str("sysid"), yyvsp[0].str); }
    break;

  case 114:
#line 894 "preproc.y"
    { yyval.str = make_str("createdb"); }
    break;

  case 115:
#line 896 "preproc.y"
    { yyval.str = make_str("nocreatedb"); }
    break;

  case 116:
#line 898 "preproc.y"
    { yyval.str = make_str("createuser"); }
    break;

  case 117:
#line 900 "preproc.y"
    { yyval.str = make_str("nocreateuser"); }
    break;

  case 118:
#line 902 "preproc.y"
    { yyval.str = cat2_str(make_str("in group"), yyvsp[0].str); }
    break;

  case 119:
#line 904 "preproc.y"
    { yyval.str = cat2_str(make_str("valid until"), yyvsp[0].str); }
    break;

  case 120:
#line 908 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str(","), yyvsp[0].str); }
    break;

  case 121:
#line 910 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 122:
#line 920 "preproc.y"
    { yyval.str = cat_str(3, make_str("create group"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 123:
#line 922 "preproc.y"
    { yyval.str = cat_str(4, make_str("create group"), yyvsp[-2].str, make_str("with"), yyvsp[0].str); }
    break;

  case 124:
#line 928 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 125:
#line 929 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 126:
#line 933 "preproc.y"
    { yyval.str = cat2_str(make_str("user"), yyvsp[0].str); }
    break;

  case 127:
#line 935 "preproc.y"
    { yyval.str = cat2_str(make_str("sysid"), yyvsp[0].str); }
    break;

  case 128:
#line 946 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter group"), yyvsp[-3].str, make_str("add user"), yyvsp[0].str); }
    break;

  case 129:
#line 948 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter group"), yyvsp[-3].str, make_str("drop user"), yyvsp[0].str); }
    break;

  case 130:
#line 958 "preproc.y"
    { yyval.str = cat2_str(make_str("drop group"), yyvsp[0].str); }
    break;

  case 131:
#line 969 "preproc.y"
    { yyval.str = cat_str(6, make_str("create schema"), yyvsp[-4].str, yyvsp[-3].str, make_str("authorization"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 132:
#line 971 "preproc.y"
    { yyval.str = cat_str(3, make_str("create schema"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 133:
#line 974 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 134:
#line 975 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 135:
#line 978 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 136:
#line 979 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 137:
#line 986 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 138:
#line 987 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 139:
#line 988 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 140:
#line 1002 "preproc.y"
    { yyval.str = cat2_str(make_str("set"), yyvsp[0].str ); }
    break;

  case 141:
#line 1004 "preproc.y"
    { yyval.str = cat2_str(make_str("set local"), yyvsp[0].str ); }
    break;

  case 142:
#line 1006 "preproc.y"
    { yyval.str = cat2_str(make_str("set session"), yyvsp[0].str ); }
    break;

  case 143:
#line 1010 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str("to"), yyvsp[0].str); }
    break;

  case 144:
#line 1012 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str("="), yyvsp[0].str); }
    break;

  case 145:
#line 1014 "preproc.y"
    { yyval.str = cat2_str(make_str("time zone"), yyvsp[0].str); }
    break;

  case 146:
#line 1016 "preproc.y"
    { yyval.str = cat2_str(make_str("transaction"), yyvsp[0].str); }
    break;

  case 147:
#line 1018 "preproc.y"
    { yyval.str = cat2_str(make_str("session characteristics as transaction"), yyvsp[0].str); }
    break;

  case 148:
#line 1020 "preproc.y"
    { yyval.str = cat2_str(make_str("names"), yyvsp[0].str); }
    break;

  case 149:
#line 1022 "preproc.y"
    { yyval.str = cat2_str(make_str("session authorization"), yyvsp[0].str); }
    break;

  case 150:
#line 1024 "preproc.y"
    { yyval.str = make_str("session authorization default"); }
    break;

  case 151:
#line 1028 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 152:
#line 1030 "preproc.y"
    { yyval.str = make_str("default"); }
    break;

  case 153:
#line 1034 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 154:
#line 1036 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str(","), yyvsp[0].str); }
    break;

  case 155:
#line 1039 "preproc.y"
    { yyval.str = make_str("read committed"); }
    break;

  case 156:
#line 1040 "preproc.y"
    { yyval.str = make_str("serializable"); }
    break;

  case 157:
#line 1043 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 158:
#line 1044 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 159:
#line 1045 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 160:
#line 1048 "preproc.y"
    { yyval.str = make_str("true"); }
    break;

  case 161:
#line 1049 "preproc.y"
    { yyval.str = make_str("false"); }
    break;

  case 162:
#line 1050 "preproc.y"
    { yyval.str = make_str("on"); }
    break;

  case 163:
#line 1051 "preproc.y"
    { yyval.str = make_str("off"); }
    break;

  case 164:
#line 1061 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 165:
#line 1062 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 166:
#line 1064 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 167:
#line 1066 "preproc.y"
    { yyval.str = cat_str(6, yyvsp[-5].str, make_str("("), yyvsp[-3].str, make_str(")"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 168:
#line 1068 "preproc.y"
    { yyval.str = make_str("default"); }
    break;

  case 169:
#line 1070 "preproc.y"
    { yyval.str = make_str("local"); }
    break;

  case 170:
#line 1073 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 171:
#line 1074 "preproc.y"
    { yyval.str = make_str("default"); }
    break;

  case 172:
#line 1075 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 173:
#line 1078 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 174:
#line 1079 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 175:
#line 1083 "preproc.y"
    { yyval.str = cat2_str(make_str("show"), yyvsp[0].str); }
    break;

  case 176:
#line 1085 "preproc.y"
    { yyval.str = make_str("show time zone"); }
    break;

  case 177:
#line 1087 "preproc.y"
    { yyval.str = make_str("show transaction isolation level"); }
    break;

  case 178:
#line 1089 "preproc.y"
    { yyval.str = make_str("show session authorization"); }
    break;

  case 179:
#line 1091 "preproc.y"
    { yyval.str = make_str("show all"); }
    break;

  case 180:
#line 1095 "preproc.y"
    { yyval.str = cat2_str(make_str("reset"), yyvsp[0].str); }
    break;

  case 181:
#line 1097 "preproc.y"
    { yyval.str = make_str("reset time zone"); }
    break;

  case 182:
#line 1099 "preproc.y"
    { yyval.str = make_str("reset transaction isolation level"); }
    break;

  case 183:
#line 1101 "preproc.y"
    { yyval.str = make_str("reset session authorization"); }
    break;

  case 184:
#line 1103 "preproc.y"
    { yyval.str = make_str("reset all"); }
    break;

  case 185:
#line 1107 "preproc.y"
    { yyval.str = cat_str(3, make_str("set constraints"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 186:
#line 1111 "preproc.y"
    { yyval.str = make_str("all"); }
    break;

  case 187:
#line 1113 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 188:
#line 1116 "preproc.y"
    { yyval.str = make_str("deferred"); }
    break;

  case 189:
#line 1117 "preproc.y"
    { yyval.str = make_str("immediate"); }
    break;

  case 190:
#line 1123 "preproc.y"
    { yyval.str= make_str("checkpoint"); }
    break;

  case 191:
#line 1136 "preproc.y"
    { yyval.str = cat_str(5, make_str("alter table"), yyvsp[-3].str, make_str("add"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 192:
#line 1139 "preproc.y"
    { yyval.str = cat_str(6, make_str("alter table"), yyvsp[-4].str, make_str("alter"), yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 193:
#line 1142 "preproc.y"
    { yyval.str = cat_str(6, make_str("alter table"), yyvsp[-6].str, make_str("alter"), yyvsp[-4].str, yyvsp[-3].str, make_str("drop not null")); }
    break;

  case 194:
#line 1145 "preproc.y"
    { yyval.str = cat_str(6, make_str("alter table"), yyvsp[-6].str, make_str("alter"), yyvsp[-4].str, yyvsp[-3].str, make_str("set not null")); }
    break;

  case 195:
#line 1148 "preproc.y"
    { yyval.str = cat_str(7, make_str("alter table"), yyvsp[-6].str, make_str("alter"), yyvsp[-4].str, yyvsp[-3].str, make_str("set statistics"), yyvsp[0].str); }
    break;

  case 196:
#line 1151 "preproc.y"
    { yyval.str = cat_str(7, make_str("alter table"), yyvsp[-6].str, make_str("alter"), yyvsp[-4].str, yyvsp[-3].str, make_str("set storage"), yyvsp[0].str); }
    break;

  case 197:
#line 1154 "preproc.y"
    { yyval.str = cat_str(6, make_str("alter table"), yyvsp[-4].str, make_str("drop"), yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 198:
#line 1157 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter table"), yyvsp[-2].str, make_str("add"), yyvsp[0].str); }
    break;

  case 199:
#line 1160 "preproc.y"
    { yyval.str = cat_str(5, make_str("alter table"), yyvsp[-4].str, make_str("drop constraint"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 200:
#line 1163 "preproc.y"
    { yyval.str = cat_str(3, make_str("alter table"), yyvsp[-3].str, make_str("set without oids")); }
    break;

  case 201:
#line 1166 "preproc.y"
    { yyval.str = cat_str(3, make_str("alter table"), yyvsp[-3].str, make_str("create toast table")); }
    break;

  case 202:
#line 1169 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter table"), yyvsp[-3].str, make_str("owner to"), yyvsp[0].str); }
    break;

  case 203:
#line 1172 "preproc.y"
    { yyval.str = cat_str(4, make_str("alter table"), yyvsp[-3].str, make_str("cluster on"), yyvsp[0].str); }
    break;

  case 204:
#line 1176 "preproc.y"
    { yyval.str = cat2_str(make_str("set default"), yyvsp[0].str); }
    break;

  case 205:
#line 1177 "preproc.y"
    { yyval.str = make_str("drop default"); }
    break;

  case 206:
#line 1180 "preproc.y"
    { yyval.str = make_str("cascade"); }
    break;

  case 207:
#line 1181 "preproc.y"
    { yyval.str = make_str("restrict"); }
    break;

  case 208:
#line 1182 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 209:
#line 1193 "preproc.y"
    {
			yyval.str = cat2_str(make_str("close"), yyvsp[0].str);
		}
    break;

  case 210:
#line 1208 "preproc.y"
    { yyval.str = cat_str(9, make_str("copy"), yyvsp[-7].str, yyvsp[-6].str, yyvsp[-5].str, yyvsp[-4].str, yyvsp[-3].str, yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 211:
#line 1211 "preproc.y"
    { yyval.str = make_str("to"); }
    break;

  case 212:
#line 1212 "preproc.y"
    { yyval.str = make_str("from"); }
    break;

  case 213:
#line 1220 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 214:
#line 1221 "preproc.y"
    { yyval.str = make_str("stdin"); }
    break;

  case 215:
#line 1222 "preproc.y"
    { yyval.str = make_str("stdout"); }
    break;

  case 216:
#line 1225 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 217:
#line 1226 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 218:
#line 1229 "preproc.y"
    { yyval.str = make_str("binary"); }
    break;

  case 219:
#line 1230 "preproc.y"
    { yyval.str = make_str("oids"); }
    break;

  case 220:
#line 1232 "preproc.y"
    { yyval.str = cat_str(3, make_str("delimiter"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 221:
#line 1234 "preproc.y"
    { yyval.str = cat_str(3, make_str("null"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 222:
#line 1237 "preproc.y"
    { yyval.str = make_str("binary"); }
    break;

  case 223:
#line 1238 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 224:
#line 1241 "preproc.y"
    { yyval.str = make_str("with oids"); }
    break;

  case 225:
#line 1242 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 226:
#line 1250 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str("delimiters"), yyvsp[0].str); }
    break;

  case 227:
#line 1252 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 228:
#line 1255 "preproc.y"
    { yyval.str = make_str("using"); }
    break;

  case 229:
#line 1256 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 230:
#line 1268 "preproc.y"
    { yyval.str = cat_str(10, make_str("create"), yyvsp[-8].str, make_str("table"), yyvsp[-6].str, make_str("("), yyvsp[-4].str, make_str(")"), yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 231:
#line 1271 "preproc.y"
    { yyval.str = cat_str(11, make_str("create"), yyvsp[-9].str, make_str("table"), yyvsp[-7].str, make_str("of"), yyvsp[-5].str, make_str("("), yyvsp[-3].str, make_str(")"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 232:
#line 1279 "preproc.y"
    { yyval.str = make_str("temporary"); }
    break;

  case 233:
#line 1280 "preproc.y"
    { yyval.str = make_str("temp"); }
    break;

  case 234:
#line 1281 "preproc.y"
    { yyval.str = make_str("local temporary"); }
    break;

  case 235:
#line 1282 "preproc.y"
    { yyval.str = make_str("local temp"); }
    break;

  case 236:
#line 1283 "preproc.y"
    { yyval.str = make_str("global temporary"); }
    break;

  case 237:
#line 1284 "preproc.y"
    { yyval.str = make_str("global temp"); }
    break;

  case 238:
#line 1285 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 239:
#line 1290 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 240:
#line 1292 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 241:
#line 1295 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 242:
#line 1297 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str, make_str(","), yyvsp[0].str); }
    break;

  case 243:
#line 1300 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 244:
#line 1301 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 245:
#line 1302 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 246:
#line 1306 "preproc.y"
    {
			yyval.str = cat_str(3, yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str);
		}
    break;

  case 247:
#line 1311 "preproc.y"
    { yyval.str = cat2_str(yyvsp[-1].str,yyvsp[0].str); }
    break;

  case 248:
#line 1312 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 249:
#line 1316 "preproc.y"
    { yyval.str = cat_str(3, make_str("constraint"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 250:
#line 1317 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 251:
#line 1318 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 252:
#line 1333 "preproc.y"
    { yyval.str = make_str("not null"); }
    break;

  case 253:
#line 1335 "preproc.y"
    { yyval.str = make_str("null"); }
    break;

  case 254:
#line 1337 "preproc.y"
    { yyval.str = make_str("unique"); }
    break;

  case 255:
#line 1339 "preproc.y"
    { yyval.str = make_str("primary key"); }
    break;

  case 256:
#line 1341 "preproc.y"
    { yyval.str = cat_str(3, make_str("check ("), yyvsp[-1].str, make_str(")")); }
    break;

  case 257:
#line 1343 "preproc.y"
    { yyval.str = cat2_str(make_str("default"), yyvsp[0].str); }
    break;

  case 258:
#line 1345 "preproc.y"
    { yyval.str = cat_str(5, make_str("references"), yyvsp[-3].str, yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 259:
#line 1359 "preproc.y"
    { yyval.str = make_str("deferrable"); }
    break;

  case 260:
#line 1360 "preproc.y"
    { yyval.str = make_str("not deferrable"); }
    break;

  case 261:
#line 1361 "preproc.y"
    { yyval.str = make_str("initially deferred"); }
    break;

  case 262:
#line 1362 "preproc.y"
    { yyval.str = make_str("initially immediate"); }
    break;

  case 263:
#line 1366 "preproc.y"
    {
			yyval.str = cat_str(3, make_str("like"), yyvsp[-1].str, yyvsp[0].str);
		}
    break;

  case 264:
#line 1372 "preproc.y"
    { yyval.str = make_str("including defaults"); }
    break;

  case 265:
#line 1373 "preproc.y"
    { yyval.str = make_str("excluding defaults"); }
    break;

  case 266:
#line 1374 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 267:
#line 1382 "preproc.y"
    { yyval.str = cat_str(3, make_str("constraint"), yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 268:
#line 1384 "preproc.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 269:
#line 1388 "preproc.y"
    { yyval.str = cat_str(3, make_str("check("), yyvsp[-1].str, make_str(")")); }
    break;

  case 270:
#line 1390 "preproc.y"
    { yyval.str = cat_str(3, make_str("unique("), yyvsp[-1].str, make_str(")")); }
    break;

  case 271:
#line 1392 "preproc.y"
    { yyval.str = cat_str(3, make_str("primary key("), yyvsp[-1].str, make_str(")")); }
    break;

  case 272:
#line 1395 "preproc.y"
    { yyval.str = cat_str(8, make_str("foreign key("), yyvsp[-7].str, make_str(") references"), yyvsp[-4].str, yyvsp[-3].str, yyvsp[-2].str, yyvsp[-1].str, yyvsp[0].str); }
    break;

  case 273:
#line 1398 "preproc.y"
    { yyval.str = cat_str(3, make_str("("), yyvsp[-1].str, make_str(")")); }
    break;

  case 274:
#line 1399 "preproc.y"
    { yyval.str = EMPTY; }
    break;

  case 275:
#line 1403 "preproc.y"
    { yyval.str = cat_str(3, yyvsp[-2].str,