/* contrib/btree_gist/btree_gist--1.5--1.6.sql */

-- complain if script is sourced in psql, rather than via CREATE EXTENSION
\echo Use "ALTER EXTENSION btree_gist UPDATE TO '1.6'" to load this file. \quit

-- This upgrade script marks all btree_gist functions as parallel safe.

-- Input/output functions for GiST key types (gbtreekey*)
ALTER FUNCTION gbtreekey4_in(cstring) PARALLEL SAFE;
ALTER FUNCTION gbtreekey4_out(gbtreekey4) PARALLEL SAFE;
ALTER FUNCTION gbtreekey8_in(cstring) PARALLEL SAFE;
ALTER FUNCTION gbtreekey8_out(gbtreekey8) PARALLEL SAFE;
ALTER FUNCTION gbtreekey16_in(cstring) PARALLEL SAFE;
ALTER FUNCTION gbtreekey16_out(gbtreekey16) PARALLEL SAFE;
ALTER FUNCTION gbtreekey32_in(cstring) PARALLEL SAFE;
ALTER FUNCTION gbtreekey32_out(gbtreekey32) PARALLEL SAFE;
ALTER FUNCTION gbtreekey_var_in(cstring) PARALLEL SAFE;
ALTER FUNCTION gbtreekey_var_out(gbtreekey_var) PARALLEL SAFE;

-- Functions, which implement distance operators (<->)
ALTER FUNCTION cash_dist(money, money) PARALLEL SAFE;
ALTER FUNCTION date_dist(date, date) PARALLEL SAFE;
ALTER FUNCTION float4_dist(real, real) PARALLEL SAFE;
ALTER FUNCTION float8_dist(double precision, double precision) PARALLEL SAFE;
ALTER FUNCTION int2_dist(smallint, smallint) PARALLEL SAFE;
ALTER FUNCTION int4_dist(integer, integer) PARALLEL SAFE;
ALTER FUNCTION int8_dist(bigint, bigint) PARALLEL SAFE;
ALTER FUNCTION interval_dist(interval, interval) PARALLEL SAFE;
ALTER FUNCTION oid_dist(oid, oid) PARALLEL SAFE;
ALTER FUNCTION time_dist(time without time zone, time without time zone) PARALLEL SAFE;
ALTER FUNCTION ts_dist(timestamp without time zone, timestamp without time zone) PARALLEL SAFE;
ALTER FUNCTION tstz_dist(timestamp with time zone, timestamp with time zone) PARALLEL SAFE;

-- GiST support methods
ALTER FUNCTION gbt_oid_consistent(internal, oid, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_oid_distance(internal, oid, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_oid_fetch(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_oid_compress(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_decompress(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_var_decompress(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_var_fetch(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_oid_penalty(internal, internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_oid_picksplit(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_oid_union(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_oid_same(gbtreekey8, gbtreekey8, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_int2_consistent(internal, smallint, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_int2_distance(internal, smallint, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_int2_compress(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_int2_fetch(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_int2_penalty(internal, internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_int2_picksplit(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_int2_union(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_int2_same(gbtreekey4, gbtreekey4, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_int4_consistent(internal, integer, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_int4_distance(internal, integer, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_int4_compress(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_int4_fetch(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_int4_penalty(internal, internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_int4_picksplit(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_int4_union(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_int4_same(gbtreekey8, gbtreekey8, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_int8_consistent(internal, bigint, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_int8_distance(internal, bigint, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_int8_compress(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_int8_fetch(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_int8_penalty(internal, internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_int8_picksplit(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_int8_union(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_int8_same(gbtreekey16, gbtreekey16, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_float4_consistent(internal, real, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_float4_distance(internal, real, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_float4_compress(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_float4_fetch(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_float4_penalty(internal, internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_float4_picksplit(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_float4_union(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_float4_same(gbtreekey8, gbtreekey8, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_float8_consistent(internal, double precision, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_float8_distance(internal, double precision, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_float8_compress(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_float8_fetch(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_float8_penalty(internal, internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_float8_picksplit(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_float8_union(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_float8_same(gbtreekey16, gbtreekey16, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_ts_consistent(internal, timestamp without time zone, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_ts_distance(internal, timestamp without time zone, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_tstz_consistent(internal, timestamp with time zone, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_tstz_distance(internal, timestamp with time zone, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_ts_compress(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_tstz_compress(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_ts_fetch(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_ts_penalty(internal, internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_ts_picksplit(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_ts_union(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_ts_same(gbtreekey16, gbtreekey16, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_time_consistent(internal, time without time zone, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_time_distance(internal, time without time zone, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_timetz_consistent(internal, time with time zone, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_time_compress(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_timetz_compress(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_time_fetch(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_time_penalty(internal, internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_time_picksplit(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_time_union(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_time_same(gbtreekey16, gbtreekey16, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_date_consistent(internal, date, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_date_distance(internal, date, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_date_compress(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_date_fetch(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_date_penalty(internal, internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_date_picksplit(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_date_union(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_date_same(gbtreekey8, gbtreekey8, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_intv_consistent(internal, interval, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_intv_distance(internal, interval, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_intv_compress(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_intv_decompress(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_intv_fetch(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_intv_penalty(internal, internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_intv_picksplit(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_intv_union(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_intv_same(gbtreekey32, gbtreekey32, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_cash_consistent(internal, money, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_cash_distance(internal, money, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_cash_compress(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_cash_fetch(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_cash_penalty(internal, internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_cash_picksplit(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_cash_union(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_cash_same(gbtreekey16, gbtreekey16, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_macad_consistent(internal, macaddr, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_macad_compress(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_macad_fetch(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_macad_penalty(internal, internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_macad_picksplit(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_macad_union(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_macad_same(gbtreekey16, gbtreekey16, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_text_consistent(internal, text, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_bpchar_consistent(internal, character, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_text_compress(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_bpchar_compress(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_text_penalty(internal, internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_text_picksplit(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_text_union(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_text_same(gbtreekey_var, gbtreekey_var, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_bytea_consistent(internal, bytea, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_bytea_compress(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_bytea_penalty(internal, internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_bytea_picksplit(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_bytea_union(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_bytea_same(gbtreekey_var, gbtreekey_var, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_numeric_consistent(internal, numeric, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_numeric_compress(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_numeric_penalty(internal, internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_numeric_picksplit(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_numeric_union(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_numeric_same(gbtreekey_var, gbtreekey_var, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_bit_consistent(internal, bit, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_bit_compress(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_bit_penalty(internal, internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_bit_picksplit(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_bit_union(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_bit_same(gbtreekey_var, gbtreekey_var, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_inet_consistent(internal, inet, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_inet_compress(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_inet_penalty(internal, internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_inet_picksplit(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_inet_union(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_inet_same(gbtreekey16, gbtreekey16, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_uuid_consistent(internal, uuid, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_uuid_fetch(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_uuid_compress(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_uuid_penalty(internal, internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_uuid_picksplit(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_uuid_union(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_uuid_same(gbtreekey32, gbtreekey32, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_macad8_consistent(internal, macaddr8, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_macad8_compress(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_macad8_fetch(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_macad8_penalty(internal, internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_macad8_picksplit(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_macad8_union(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_macad8_same(gbtreekey16, gbtreekey16, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_enum_consistent(internal, anyenum, smallint, oid, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_enum_compress(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_enum_fetch(internal) PARALLEL SAFE;
ALTER FUNCTION gbt_enum_penalty(internal, internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_enum_picksplit(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_enum_union(internal, internal) PARALLEL SAFE;
ALTER FUNCTION gbt_enum_same(gbtreekey8, gbtreekey8, internal) PARALLEL SAFE;
