--
-- pg_batch_cluster_on_pkey.sql
--
-- Set a primary keys as a cluster key for each unclustered tables.
--
SELECT 'ALTER TABLE ' || oid::regclass || ' CLUSTER ON ' || indexrelid::regclass
  FROM pg_class, pg_index
 WHERE relkind = 'r'
   AND indrelid = oid
   AND indisprimary
   AND NOT EXISTS (SELECT 1 FROM pg_index WHERE indrelid = oid AND indisclustered);
