-- setup pg_batch.sql
SET search_path = public;

SET client_min_messages = warning;
\set ECHO none
\i pg_batch.sql

CREATE FUNCTION create_target_tables(ntables INTEGER, ndead_tuples INTEGER) RETURNS VOID AS
$$
DECLARE
	table_name TEXT;
BEGIN
	SET client_min_messages = warning;
	FOR i IN 1..$1 LOOP
		table_name := 'tab_' || to_char(i, 'FM0000');
		EXECUTE 'DROP TABLE IF EXISTS ' || table_name;
		EXECUTE 'CREATE TABLE ' || table_name || ' (col INTEGER)';
		EXECUTE 'INSERT INTO ' || table_name || ' VALUES (generate_series(1, ' || $2 || '))';
		EXECUTE 'DELETE FROM ' || table_name;
	END LOOP;
	RESET client_min_messages;
END;
$$ LANGUAGE 'plpgsql';

CREATE VIEW show_target AS
	SELECT query, dead_tuples, age FROM pg_vacuum_jobs(0.5) WHERE dead_tuples > 0 OR age > 0;
\set ECHO all
RESET client_min_messages;

-- check GUC parameter.
SELECT * FROM current_setting('autovacuum') AS autovacuum;

-- FU1-0003
VACUUM;
\! sleep 1
SELECT create_target_tables(1, 100);
\! sleep 1
SELECT * FROM show_target;
\! perl sql/log_wrap.pl ./pg_batch -E error ./pg_batch_vacuum.sql ; echo "ret=${?}"
\! sleep 1
SELECT * FROM show_target;

-- FU1-0013
\! perl sql/log_wrap.pl "echo \"SELECT 'SELECT ' || i || ', pg_sleep(1)' FROM generate_series(1,5) AS t(i)\" | ./pg_batch -" ; echo "ret=${?}"

-- FU1-0014
\! perl sql/log_wrap.pl "echo \"SELECT 'SELECT ' || i || ', pg_sleep(1)', i - 3 FROM generate_series(1,5) AS t(i)\" | ./pg_batch -" ; echo "ret=${?}"

-- FU1-0015
BEGIN;
CREATE TABLE tab_01 (col INTEGER);
CREATE TABLE tab_02 (col INTEGER);
INSERT INTO tab_01 VALUES (generate_series(1,100));
INSERT INTO tab_02 VALUES (generate_series(1,101));
DELETE FROM tab_01;
DELETE FROM tab_02;
COMMIT;
\! perl sql/log_wrap.pl ./pg_batch ./sql/pg_batch_vacuum_custom.sql 1 50 ; echo "ret=${?}"

-- FU1-0016
\! perl sql/log_wrap.pl "echo \"SELECT 'VACUUM VERBOSE'; SELECT 'SELECT ' || i || ', pg_sleep(1)' FROM generate_series(1,3) AS t(i)\" | ./pg_batch -" ; echo "ret=${?}"

-- FU1-0018
BEGIN;
CREATE TABLE tab (col INTEGER PRIMARY KEY);
CLUSTER tab USING tab_pkey;
COMMIT;
\! perl sql/log_wrap.pl "echo \"SELECT 'CLUSTER VERBOSE tab'\" | ./pg_batch -" ; echo "ret=${?}"
DROP TABLE tab;

-- FU1-0019
BEGIN;
CREATE TABLE tab (col INTEGER);
COMMIT;
\! perl sql/log_wrap.pl "echo \"SELECT 'ANALYZE VERBOSE tab'\" | ./pg_batch -" ; echo "ret=${?}"
DROP TABLE tab;

-- FU1-0020
BEGIN;
CREATE TABLE tab (col INTEGER);
CREATE INDEX idx ON tab (col);
COMMIT;
\! perl sql/log_wrap.pl "echo \"SELECT 'REINDEX TABLE tab'\" | ./pg_batch -" ; echo "ret=${?}"
DROP TABLE tab;

-- FU1-0021
\! perl sql/log_wrap.pl "echo \"SELECT 'COPY pg_database TO ''/tmp/pg_database.copy'''\" | ./pg_batch -" ; echo "ret=${?}"

-- FU1-0022
\! perl sql/log_wrap.pl "echo \"SELECT 'CHECKPOINT'\" | ./pg_batch -" ; echo "ret=${?}"

-- FU1-0023
BEGIN;
CREATE TABLE tab (col INTEGER);
COMMIT;
\! perl sql/log_wrap.pl "echo \"SELECT 'TRUNCATE tab'\" | ./pg_batch -" ; echo "ret=${?}"
DROP TABLE tab;

-- FU1-0024
BEGIN;
CREATE TABLE tab (col INTEGER PRIMARY KEY);
COMMIT;
\! perl sql/log_wrap.pl "echo \"SELECT 'ALTER TABLE tab CLUSTER ON tab_pkey'\" | ./pg_batch -" ; echo "ret=${?}"
DROP TABLE tab;

-- FU1-0025
BEGIN;
CREATE TABLE tab (col TEXT);
COMMIT;
\! perl sql/log_wrap.pl "echo \"SELECT 'INSERT INTO tab VALUES (''test'')'\" | ./pg_batch -" ; echo "ret=${?}"
DROP TABLE tab;

-- FU1-0026
BEGIN;
CREATE TABLE tab (col TEXT);
INSERT INTO tab VALUES ('test');
COMMIT;
\! perl sql/log_wrap.pl "echo \"SELECT 'UPDATE tab SET col = ''green'''\" | ./pg_batch -" ; echo "ret=${?}"
DROP TABLE tab;

-- FU1-0027
BEGIN;
CREATE TABLE tab (col TEXT);
INSERT INTO tab VALUES ('test');
COMMIT;
\! perl sql/log_wrap.pl "echo \"SELECT 'DELETE FROM tab'\" | ./pg_batch -" ; echo "ret=${?}"
DROP TABLE tab;

-- FU1-0028
\! perl sql/log_wrap.pl "echo \"SELECT 'SELECT * FROM pg_class'\" | ./pg_batch -" ; echo "ret=${?}"

-- FU1-0029
BEGIN;
CREATE TABLE tab (col INTEGER);
COMMIT;
\! perl sql/log_wrap.pl "echo \"SELECT 'INSERT INTO tab VALUES (1); INSERT INTO tab VALUES (2); INSERT INTO tab VALUES (3);'\" | ./pg_batch -" ; echo "ret=${?}"
SELECT * FROM tab;
DROP TABLE tab;

-- FU1-0030
BEGIN;
CREATE TABLE tab (col INTEGER NOT NULL);
COMMIT;
\! perl sql/log_wrap.pl "echo \"SELECT 'INSERT INTO tab VALUES (1); INSERT INTO tab VALUES (2); INSERT INTO tab VALUES (NULL);'\" | ./pg_batch -" ; echo "ret=${?}"
SELECT * FROM tab;
DROP TABLE tab;

-- FU1-0031
VACUUM;
\! sleep 1
SELECT * FROM show_target;
\! perl sql/log_wrap.pl ./pg_batch ./pg_batch_vacuum.sql ; echo "ret=${?}"

-- FU1-0032
VACUUM;
\! sleep 1
SELECT create_target_tables(1, 100);
\! sleep 1
SELECT * FROM show_target;
\! perl sql/log_wrap.pl ./pg_batch ./pg_batch_vacuum.sql ; echo "ret=${?}"

-- FU1-0033
VACUUM;
\! sleep 1
SELECT create_target_tables(2, 100);
\! sleep 1
SELECT * FROM show_target;
\! perl sql/log_wrap.pl ./pg_batch ./pg_batch_vacuum.sql ; echo "ret=${?}"

-- FU1-0063
\! perl sql/log_wrap.pl "echo \"SELECT 'VACUUM VERBOSE xxx', 0, 0\" | ./pg_batch -" ; echo "ret=${?}"

-- FU1-0064
\! perl sql/log_wrap.pl "echo \"SELECT 'VACUUM VERBOSE xxx', 'abc'\" | ./pg_batch -" ; echo "ret=${?}"

-- FU1-0065
\! ./pg_batch nofile.sql ; echo "ret=${?}"
