/* $Id: conv.h,v 1.4 2005/05/12 19:29:34 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * be/src/conv.h,v 1.1.1.1 2004/12/16 00:32:18 flaw
 * imp/src/conv.h,v 1.4 2004/12/15 04:58:42 flaw
 * if/src/conv.h,v 1.4 2004/09/28 15:28:58 flaw
 *//*
 * Conversion functions
 */
#ifndef PyPg_conv_H
#define PyPg_conv_H 0
#ifdef __cplusplus
extern "C" {
#endif

PyObj PyObject_FromTypeTupleAndDatum(HeapTuple, Datum);

PyObj PySequence_FromTupleDescAndTuplestore(TupleDesc, Tuplestorestate *);
PyObj PySequence_FromPgTupDAndTuplestore(PyObj, Tuplestorestate *);
PyObj PyPgFill_PySequence(PyObj, PyObj, FunctionCallInfo);

HeapTuple HeapTuple_FromTupleDescAndPyObject(TupleDesc, PyObj);
HeapTuple HeapTuple_FromTupleDescAndIterable(TupleDesc, PyObj);

typedef HeapTuple (*HT_FromTDAndPyObj_Con)(TupleDesc, PyObj);

HeapTuple HeapTuple_FromRelationOidAndIterable(Oid, PyObj);

ArrayType * Array_FromPySequence(PyObj, Oid, bool, int2, char);
ArrayType * Array_FromTypeTupleAndPySequence(HeapTuple, PyObj);
ArrayType * Array_FromTypeOidAndPySequence(Oid, PyObj);

Datum Datum_FromTypeTupleAndPyObject(HeapTuple, PyObj);
Datum Datum_FromTypeOidAndPyObject(Oid, PyObj);

Oid Oid_FromPyObject(PyObj);

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_conv_H */
/*
 * vim: ts=3:sw=3:noet:
 */
