#!/bin/sh

# The purpose of this script is to generate a Windows binary distribution in
# a specific folder (see OUTPUT_FOLDER) that needs to be zipped afterwards.

################################
## Script options - Beginning ##
################################

# The folder where to put the distribution
OUTPUT_FOLDER="pgScript"

# README, COPYING, etc.
SPECIAL_FILES=( "AUTHORS" "COPYING" "NEWS" "README" )

##########################
## Script options - End ##
##########################

echo "This script prepares a Windows binary package in $OUTPUT_FOLDER."
echo "Usage: $0"

################################################################################

DIR=`dirname $0`"/"

# Delete the output folder if it exists
if test -d "$OUTPUT_FOLDER"
then
	echo ""
	echo -n "Removing $OUTPUT_FOLDER... "
	rm -r "$OUTPUT_FOLDER"
	echo "done"
fi

# Create the output folder
echo ""
echo -n "Creating $OUTPUT_FOLDER... "
mkdir "$OUTPUT_FOLDER"
echo "done"

# Create the documentation folder
echo ""
echo -n "Creating $OUTPUT_FOLDER/doc... "
mkdir "$OUTPUT_FOLDER/doc"
echo "done"

# Create the files folder
echo ""
echo -n "Creating $OUTPUT_FOLDER/files... "
mkdir "$OUTPUT_FOLDER/files"
echo "done"

# Find pgScript.exe
echo ""
echo -n "Finding pgScript.exe... "
executable_found="no"
for src in `find "$DIR" -name "pgScript.exe"`; do
	executable_found="yes"
done
if test "$executable_found" == "no"
then
	echo "Cannot find pgScript.exe"
	exit 1
fi
echo "done"

# Copy pgScript
echo ""
echo "cp $src $OUTPUT_FOLDER/pgScript.exe"
cp "$src" "$OUTPUT_FOLDER/pgScript.exe"

# Copy documentation
echo ""
for src in `find "$DIR/doc" -name "*.html"`; do
	dest=`basename $src`
	dest="$OUTPUT_FOLDER/doc/$dest"
	echo "cp $src $dest"
	cp "$src" "$dest"
done
for src in `find "$DIR/doc" -name "*.css"`; do
	dest=`basename $src`
	dest="$OUTPUT_FOLDER/doc/$dest"
	echo "cp $src $dest"
	cp "$src" "$dest"
done

# Copy input files
echo ""
for src in `find "$DIR/files/inputs" -name "*.pgs"`; do
	dest=`basename $src`
	dest="$OUTPUT_FOLDER/files/$dest"
	echo "cp $src $dest"
	cp "$src" "$dest"
done

# Copy special files
echo ""
for file in "${SPECIAL_FILES[@]}"
do
	echo "cp $DIR/$file $OUTPUT_FOLDER/$file"
	cp "$DIR/$file" "$OUTPUT_FOLDER/$file"
done

################################################################################
