#!/bin/sh

echo "Runs integration tests"
echo "Usage: $0 [parameters for db connection]"
echo ""

# Get parameters for database connections
if test "$*" == ""
then
	PARAMETERS="-h 127.0.0.1 -U postgres -d testbase"
else
	PARAMETERS="$*"
fi
echo "Using '$PARAMETERS' for database connection"

# Try to find pgScript
PGS1=`dirname $0`"/../../src/pgScript"
PGS2=`dirname $0`"/../../bin/pgScript"
if test -f "$PGS1"
then
	PGS="$PGS1"
else
	if test -f "$PGS2"
	then
		PGS="$PGS2"
	else
		echo "pgScript at '$PGS' not found: please configure script"
		exit
	fi
fi
echo "pgScript at '$PGS' found"
echo ""

# Execute pgScript programs
echo "############# RUNNING  TESTS #############"
for src in `ls ./sources/*.sql.pgs`; do
	$PGS $PARAMETERS -f "$src" -e cp1252
done
echo "################## DONE ##################"
