#!/bin/sh

# Deletes useless and generated files. See options to choose what files must
# be deleted.

################################
## Script options - Beginning ##
################################

# Files to delete in the whole tree of directories (recursive deletes)
# Files to delete in every directory of the project
RECURSIVE_DELETES=( "Makefile" "Makefile.in" )
# Folders to explore and concerned by FOLDER_DELETES & FILE_DELETES
EXPLORE_FOLDERS=( "." "./lib" "./src" "./test" "./lib/include/pgscript" )
# Folders to delete in each $EXPLORE_FOLDERS
FOLDER_DELETES=( "autom4te.cache" ".deps" )
# Files to delete in each $EXPLORE_FOLDERS
FILE_DELETES=( "aclocal.m4" "stamp-h1" "config.h" "config.log" \
	"config.status" "configure" "depcomp" "install-sh" "missing" \
	"mkinstalldirs" "*.exe" "*.exe.stackdump" "*.a" "*.o" )

##########################
## Script options - End ##
##########################

echo "This script deletes generated files. Use it carefully."
echo "Usage: $0"
echo "Press a key to continue or Ctrl + C to exit..."
read KEY

for file in ${RECURSIVE_DELETES[@]}
do
	echo "rm -f */$file"
	for src in `find ./ -name "$file"`; do
		rm -f "$src"
	done
done

for dir in ${EXPLORE_FOLDERS[@]}
do
	echo ""
	cd $dir
	echo "Entering $dir"
	
	for file in ${FOLDER_DELETES[@]}
	do
		echo "rm -rf $file"
		rm -rf "$file"
	done
	for file in ${FILE_DELETES[@]}
	do
		echo "rm -f $file"
		rm -f "$file"
	done
	
	if test "$dir" != "." -a "$dir" != "./"
	then
		cd ..
	fi
	echo "Leaving $dir"
done

echo ""
