//////////////////////////////////////////////////////////////////////////
//
// pgScript - PostgreSQL Tools
// RCS-ID:      $Id: pgsPrintStmt.cpp,v 1.1 2008/06/27 18:19:17 pgunittest Exp $
// Copyright (C) 2008 The pgScript Development Team
// This software is released under the Artistic Licence
//
//////////////////////////////////////////////////////////////////////////


#include "pgAdmin3.h"
#include "pgscript/statements/pgsPrintStmt.h"

#include "pgscript/utilities/pgsUtilities.h"

pgsPrintStmt::pgsPrintStmt(const pgsExpression * var, pgsOutputStream & cout,
		pgsThread * app) :
	pgsStmt(app), m_var(var), m_cout(cout)
{

}

pgsPrintStmt::~pgsPrintStmt()
{
	pdelete(m_var);
}

void pgsPrintStmt::eval(pgsVarMap & vars) const
{
	m_cout << wx_static_cast(const wxString, m_var->eval(vars)->value()) << wxT("\n");
}
