/*--------------------------------------------------------------------
 * FILE:
 *     probe_exec_cluster.c
 *
 * NOTE:
 *     This file is composed of the probe process 
 *     Low level I/O functions that called by in these functions are 
 *     contained in 'replicate_com.c'.
 *
 *--------------------------------------------------------------------
 */
#include "postgres.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/file.h>

#ifdef MULTIBYTE
#include "mb/pg_wchar.h"
#endif

#include "pgc_admin.h"

uint16_t PGC_Probe_Exec_Cluster(Probe_Header * header, char * packet);

static int set_cluster_2_exec(Exec_Info * exec, Cluster_Info *cluster);
static int16_t get_cluster_status(Cluster_Info * cluster);

uint16_t
PGC_Probe_Exec_Cluster(Probe_Header * header, char * packet)
{
	char * func = "PGC_Probe_Exec_Cluster()";
	Cluster_Info * cluster_key = NULL;
	Cluster_Info * cluster = NULL;
	uint16_t status = DATA_ERR;
	Exec_Info exec;
	char * exec_result = NULL;
	int i = 0;

	if ((header == NULL ) || (packet == NULL) || (ClusterDbTbl == NULL))
	{
		show_error("%s: table is not allocated",func);
		return DATA_ERR;
	}
	if (ntohl(header->body_length) < sizeof(Cluster_Info))
	{
		show_error("%s: there is no packet data ",func);
		return DATA_ERR;
	}
	cluster_key = (Cluster_Info *) packet;
	cluster = PGC_Get_ClusterDbTbl_Rec((Cluster_Info *)cluster_key);
	if (cluster == NULL)
	{
		show_error("%s: there is no such cluster in ClusterTbl",func);
		return DATA_ERR;
	}
	set_cluster_2_exec(&exec, cluster);
	switch (ntohs(header->packet_no))
	{
		case START_REQ_PKT:
			i = 0;
			strcpy(exec.options[i++],"start");
			exec.options[i++][0] = '\0';
			exec_result = PGC_Exec_Server(&exec);
			if (exec_result != NULL)
				status = DATA_USE;
			break;
		case STOP_REQ_PKT:
			i = 0;
			strcpy(exec.options[i++],"stop");
			exec.options[i++][0] = '\0';
			exec_result = PGC_Exec_Server(&exec);
			if (exec_result != NULL)
				status = DATA_USE;
			break;
		case RECOVERY_REQ_PKT:
			i = 0;
			strcpy(exec.options[i++],"stop");
			exec.options[i++][0] = '\0';
			exec_result = PGC_Exec_Server(&exec);
			i -= 2;
			strcpy(exec.options[i++],"-o");
			strcpy(exec.options[i++],"'-R'");
			strcpy(exec.options[i++],"start");
			exec.options[i++][0] = '\0';
			exec_result = PGC_Exec_Server(&exec);
			if (exec_result != NULL)
				status = DATA_USE;
			break;
		case STATUS_REQ_PKT:
			status = get_cluster_status(cluster);
			break;
		default :
			break;
	}
	return status;
}

static int16_t
get_cluster_status(Cluster_Info * cluster)
{
	char * func = "get_cluster_status()";
	FILE *fd;
	char fname[256];
	char pidbuf[128];
	pid_t pid;
	int16_t status = DATA_INIT;

	if (cluster == NULL)
	{
		return DATA_ERR;
	}
	snprintf(fname, sizeof(fname), "%s/%s", cluster->workPath, CLUSTER_PID_FILE);
	fd = fopen(fname, "r");
	if (!fd)
	{
		show_error("%s:could not open pid file as %s. reason: %s",
				   func,fname, strerror(errno));
		return DATA_ERR;
	}
	memset(pidbuf,0,sizeof(pidbuf));
	fgets(pidbuf, sizeof(pidbuf), fd);
	fclose(fd);
	pid = atoi(pidbuf);

	if (kill (pid,0) == 0)
	{
		status = DATA_USE;
	}
	else
	{
		status = DATA_ERR;
	}
	return status;
}

static int
set_cluster_2_exec(Exec_Info * exec, Cluster_Info *cluster)
{
	if ((exec == NULL) || (cluster == NULL))
	{
		return STATUS_ERROR;
	}
	memset(exec, 0, sizeof(Exec_Info));
	exec->portNumber = cluster->portNumber;
	strncpy(exec->workPath, cluster->workPath, sizeof(exec->workPath));
	strncpy(exec->binPath, cluster->binPath, sizeof(exec->binPath));
	strcpy(exec->command,"pg_ctl");

	return STATUS_OK;
}
