/*--------------------------------------------------------------------
 * FILE:
 *     admin_set_status.c
 *
 * NOTE:
 *     This file is composed of the admin process 
 *     Low level I/O functions that called by in these functions are 
 *     contained in 'replicate_com.c'.
 *
 *--------------------------------------------------------------------
 */
#include "postgres.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/file.h>

#ifdef MULTIBYTE
#include "mb/pg_wchar.h"
#endif

#include "pgc_admin.h"

int
PGC_Admin_Set_Status(SSL_Info * ssl_tbl, Probe_Header * header, char * packet)
{
	char * func = "PGC_Admin_Set_Status()";
	int status = STATUS_OK;

	switch (ntohs(header->serverType))
	{
		case SERVER_TYPE_PGLB:
			status = PGC_Admin_Set_Pglb_Status(header, (char*)packet);
			show_debug("%s:PGC_Admin_Set_Pglb_Status[%d]\n",func,status);
			break;
		case SERVER_TYPE_CLUSTER:
			status = PGC_Admin_Set_Cluster_Status(header, (char*)packet);
			show_debug("%s:PGC_Admin_Set_Cluster_Status[%d]\n",func,status);
			break;
		case SERVER_TYPE_PGRP:
			status = PGC_Admin_Set_Pgrp_Status(header, (char*)packet);
			show_debug("%s:PGC_Admin_Set_Pgrp_Status[%d]\n",func,status);
			break;
		default :
			break;
	}

	return status;
}
