/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_CONTINUE = 265,
     SQL_COUNT = 266,
     SQL_CURRENT = 267,
     SQL_DATA = 268,
     SQL_DATETIME_INTERVAL_CODE = 269,
     SQL_DATETIME_INTERVAL_PRECISION = 270,
     SQL_DESCRIBE = 271,
     SQL_DESCRIPTOR = 272,
     SQL_DISCONNECT = 273,
     SQL_ENUM = 274,
     SQL_FOUND = 275,
     SQL_FREE = 276,
     SQL_GO = 277,
     SQL_GOTO = 278,
     SQL_IDENTIFIED = 279,
     SQL_INDICATOR = 280,
     SQL_KEY_MEMBER = 281,
     SQL_LENGTH = 282,
     SQL_LONG = 283,
     SQL_NAME = 284,
     SQL_NULLABLE = 285,
     SQL_OCTET_LENGTH = 286,
     SQL_OPEN = 287,
     SQL_OUTPUT = 288,
     SQL_REFERENCE = 289,
     SQL_RETURNED_LENGTH = 290,
     SQL_RETURNED_OCTET_LENGTH = 291,
     SQL_SCALE = 292,
     SQL_SECTION = 293,
     SQL_SHORT = 294,
     SQL_SIGNED = 295,
     SQL_SQL = 296,
     SQL_SQLERROR = 297,
     SQL_SQLPRINT = 298,
     SQL_SQLWARNING = 299,
     SQL_START = 300,
     SQL_STOP = 301,
     SQL_STRUCT = 302,
     SQL_UNSIGNED = 303,
     SQL_VALUE = 304,
     SQL_VAR = 305,
     SQL_WHENEVER = 306,
     S_ADD = 307,
     S_AND = 308,
     S_ANYTHING = 309,
     S_AUTO = 310,
     S_CONST = 311,
     S_DEC = 312,
     S_DIV = 313,
     S_DOTPOINT = 314,
     S_EQUAL = 315,
     S_EXTERN = 316,
     S_INC = 317,
     S_LSHIFT = 318,
     S_MEMPOINT = 319,
     S_MEMBER = 320,
     S_MOD = 321,
     S_MUL = 322,
     S_NEQUAL = 323,
     S_OR = 324,
     S_REGISTER = 325,
     S_RSHIFT = 326,
     S_STATIC = 327,
     S_SUB = 328,
     S_VOLATILE = 329,
     S_TYPEDEF = 330,
     TYPECAST = 331,
     ABORT_P = 332,
     ABSOLUTE_P = 333,
     ACCESS = 334,
     ACTION = 335,
     ADD_P = 336,
     ADMIN = 337,
     AFTER = 338,
     AGGREGATE = 339,
     ALL = 340,
     ALSO = 341,
     ALTER = 342,
     ANALYSE = 343,
     ANALYZE = 344,
     AND = 345,
     ANY = 346,
     ARRAY = 347,
     AS = 348,
     ASC = 349,
     ASSERTION = 350,
     ASSIGNMENT = 351,
     ASYMMETRIC = 352,
     AT = 353,
     AUTHORIZATION = 354,
     BACKWARD = 355,
     BEFORE = 356,
     BEGIN_P = 357,
     BETWEEN = 358,
     BIGINT = 359,
     BINARY = 360,
     BIT = 361,
     BOOLEAN_P = 362,
     BOTH = 363,
     BY = 364,
     CACHE = 365,
     CALLED = 366,
     CASCADE = 367,
     CASCADED = 368,
     CASE = 369,
     CAST = 370,
     CHAIN = 371,
     CHAR_P = 372,
     CHARACTER = 373,
     CHARACTERISTICS = 374,
     CHECK = 375,
     CHECKPOINT = 376,
     CLASS = 377,
     CLOSE = 378,
     CLUSTER = 379,
     COALESCE = 380,
     COLLATE = 381,
     COLUMN = 382,
     COMMENT = 383,
     COMMIT = 384,
     COMMITTED = 385,
     CONCURRENTLY = 386,
     CONNECTION = 387,
     CONSTRAINT = 388,
     CONSTRAINTS = 389,
     CONVERSION_P = 390,
     CONVERT = 391,
     COPY = 392,
     CREATE = 393,
     CREATEDB = 394,
     CREATEROLE = 395,
     CREATEUSER = 396,
     CROSS = 397,
     CSV = 398,
     CURRENT_DATE = 399,
     CURRENT_ROLE = 400,
     CURRENT_TIME = 401,
     CURRENT_TIMESTAMP = 402,
     CURRENT_USER = 403,
     CURSOR = 404,
     CYCLE = 405,
     DATABASE = 406,
     DAY_P = 407,
     DEALLOCATE = 408,
     DEC = 409,
     DECIMAL_P = 410,
     DECLARE = 411,
     DEFAULT = 412,
     DEFAULTS = 413,
     DEFERRABLE = 414,
     DEFERRED = 415,
     DEFINER = 416,
     DELETE_P = 417,
     DELIMITER = 418,
     DELIMITERS = 419,
     DESC = 420,
     DISABLE_P = 421,
     DISTINCT = 422,
     DO = 423,
     DOMAIN_P = 424,
     DOUBLE_P = 425,
     DROP = 426,
     EACH = 427,
     ELSE = 428,
     ENABLE_P = 429,
     ENCODING = 430,
     ENCRYPTED = 431,
     END_P = 432,
     ESCAPE = 433,
     EXCEPT = 434,
     EXCLUSIVE = 435,
     EXCLUDING = 436,
     EXECUTE = 437,
     EXISTS = 438,
     EXPLAIN = 439,
     EXTERNAL = 440,
     EXTRACT = 441,
     FALSE_P = 442,
     FETCH = 443,
     FIRST_P = 444,
     FLOAT_P = 445,
     FOR = 446,
     FORCE = 447,
     FOREIGN = 448,
     FORWARD = 449,
     FREEZE = 450,
     FROM = 451,
     FULL = 452,
     FUNCTION = 453,
     GET = 454,
     GLOBAL = 455,
     GRANT = 456,
     GRANTED = 457,
     GREATEST = 458,
     GROUP_P = 459,
     HANDLER = 460,
     HAVING = 461,
     HEADER_P = 462,
     HOLD = 463,
     HOUR_P = 464,
     IF_P = 465,
     ILIKE = 466,
     IMMEDIATE = 467,
     IMMUTABLE = 468,
     IMPLICIT_P = 469,
     IN_P = 470,
     INCLUDING = 471,
     INCREMENT = 472,
     INDEX = 473,
     INDEXES = 474,
     INHERIT = 475,
     INHERITS = 476,
     INITIALLY = 477,
     INNER_P = 478,
     INOUT = 479,
     INPUT_P = 480,
     INSENSITIVE = 481,
     INSERT = 482,
     INSTEAD = 483,
     INT_P = 484,
     INTEGER = 485,
     INTERSECT = 486,
     INTERVAL = 487,
     INTO = 488,
     INVOKER = 489,
     IS = 490,
     ISNULL = 491,
     ISOLATION = 492,
     JOIN = 493,
     KEY = 494,
     LANCOMPILER = 495,
     LANGUAGE = 496,
     LARGE_P = 497,
     LAST_P = 498,
     LEADING = 499,
     LEAST = 500,
     LEFT = 501,
     LEVEL = 502,
     LIKE = 503,
     LIMIT = 504,
     LISTEN = 505,
     LOAD = 506,
     LOCAL = 507,
     LOCALTIME = 508,
     LOCALTIMESTAMP = 509,
     LOCATION = 510,
     LOCK_P = 511,
     LOGIN_P = 512,
     MATCH = 513,
     MAXVALUE = 514,
     MINUTE_P = 515,
     MINVALUE = 516,
     MODE = 517,
     MONTH_P = 518,
     MOVE = 519,
     NAMES = 520,
     NATIONAL = 521,
     NATURAL = 522,
     NCHAR = 523,
     NEW = 524,
     NEXT = 525,
     NO = 526,
     NOCREATEDB = 527,
     NOCREATEROLE = 528,
     NOCREATEUSER = 529,
     NOINHERIT = 530,
     NOLOGIN_P = 531,
     NONE = 532,
     NOSUPERUSER = 533,
     NOT = 534,
     NOTHING = 535,
     NOTIFY = 536,
     NOTNULL = 537,
     NOWAIT = 538,
     NULL_P = 539,
     NULLIF = 540,
     NUMERIC = 541,
     OBJECT_P = 542,
     OF = 543,
     OFF = 544,
     OFFSET = 545,
     OIDS = 546,
     OLD = 547,
     ON = 548,
     ONLY = 549,
     OPERATOR = 550,
     OPTION = 551,
     OR = 552,
     ORDER = 553,
     OUT_P = 554,
     OUTER_P = 555,
     OVERLAPS = 556,
     OVERLAY = 557,
     OWNED = 558,
     OWNER = 559,
     PARTIAL = 560,
     PASSWORD = 561,
     PLACING = 562,
     POSITION = 563,
     PRECISION = 564,
     PRESERVE = 565,
     PREPARE = 566,
     PREPARED = 567,
     PRIMARY = 568,
     PRIOR = 569,
     PRIVILEGES = 570,
     PROCEDURAL = 571,
     PROCEDURE = 572,
     QUOTE = 573,
     READ = 574,
     REAL = 575,
     REASSIGN = 576,
     RECHECK = 577,
     REFERENCES = 578,
     REINDEX = 579,
     RELATIVE_P = 580,
     RELEASE = 581,
     RENAME = 582,
     REPEATABLE = 583,
     REPLACE = 584,
     RESET = 585,
     RESTART = 586,
     RESTRICT = 587,
     RETURNING = 588,
     RETURNS = 589,
     REVOKE = 590,
     RIGHT = 591,
     ROLE = 592,
     ROLLBACK = 593,
     ROW = 594,
     ROWS = 595,
     RULE = 596,
     SAVEPOINT = 597,
     SCHEMA = 598,
     SCROLL = 599,
     SECOND_P = 600,
     SECURITY = 601,
     SELECT = 602,
     SEQUENCE = 603,
     SERIALIZABLE = 604,
     SESSION = 605,
     SESSION_USER = 606,
     SET = 607,
     SETOF = 608,
     SHARE = 609,
     SHOW = 610,
     SIMILAR = 611,
     SIMPLE = 612,
     SMALLINT = 613,
     SOME = 614,
     STABLE = 615,
     START = 616,
     STATEMENT = 617,
     STATISTICS = 618,
     STDIN = 619,
     STDOUT = 620,
     STORAGE = 621,
     STRICT_P = 622,
     SUBSTRING = 623,
     SUPERUSER_P = 624,
     SYMMETRIC = 625,
     SYSID = 626,
     SYSTEM_P = 627,
     TABLE = 628,
     TABLESPACE = 629,
     TEMP = 630,
     TEMPLATE = 631,
     TEMPORARY = 632,
     THEN = 633,
     TIME = 634,
     TIMESTAMP = 635,
     TO = 636,
     TRAILING = 637,
     TRANSACTION = 638,
     TREAT = 639,
     TRIGGER = 640,
     TRIM = 641,
     TRUE_P = 642,
     TRUNCATE = 643,
     TRUSTED = 644,
     TYPE_P = 645,
     UNCOMMITTED = 646,
     UNENCRYPTED = 647,
     UNION = 648,
     UNIQUE = 649,
     UNKNOWN = 650,
     UNLISTEN = 651,
     UNTIL = 652,
     UPDATE = 653,
     USER = 654,
     USING = 655,
     VACUUM = 656,
     VALID = 657,
     VALIDATOR = 658,
     VALUES = 659,
     VARCHAR = 660,
     VARYING = 661,
     VERBOSE = 662,
     VIEW = 663,
     VOLATILE = 664,
     WHEN = 665,
     WHERE = 666,
     WITH = 667,
     WITHOUT = 668,
     WORK = 669,
     WRITE = 670,
     YEAR_P = 671,
     ZONE = 672,
     WITH_CASCADED = 673,
     WITH_LOCAL = 674,
     WITH_CHECK = 675,
     IDENT = 676,
     SCONST = 677,
     Op = 678,
     CSTRING = 679,
     CVARIABLE = 680,
     CPP_LINE = 681,
     IP = 682,
     BCONST = 683,
     XCONST = 684,
     DOLCONST = 685,
     ICONST = 686,
     PARAM = 687,
     FCONST = 688,
     POSTFIXOP = 689,
     UMINUS = 690
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_CONTINUE 265
#define SQL_COUNT 266
#define SQL_CURRENT 267
#define SQL_DATA 268
#define SQL_DATETIME_INTERVAL_CODE 269
#define SQL_DATETIME_INTERVAL_PRECISION 270
#define SQL_DESCRIBE 271
#define SQL_DESCRIPTOR 272
#define SQL_DISCONNECT 273
#define SQL_ENUM 274
#define SQL_FOUND 275
#define SQL_FREE 276
#define SQL_GO 277
#define SQL_GOTO 278
#define SQL_IDENTIFIED 279
#define SQL_INDICATOR 280
#define SQL_KEY_MEMBER 281
#define SQL_LENGTH 282
#define SQL_LONG 283
#define SQL_NAME 284
#define SQL_NULLABLE 285
#define SQL_OCTET_LENGTH 286
#define SQL_OPEN 287
#define SQL_OUTPUT 288
#define SQL_REFERENCE 289
#define SQL_RETURNED_LENGTH 290
#define SQL_RETURNED_OCTET_LENGTH 291
#define SQL_SCALE 292
#define SQL_SECTION 293
#define SQL_SHORT 294
#define SQL_SIGNED 295
#define SQL_SQL 296
#define SQL_SQLERROR 297
#define SQL_SQLPRINT 298
#define SQL_SQLWARNING 299
#define SQL_START 300
#define SQL_STOP 301
#define SQL_STRUCT 302
#define SQL_UNSIGNED 303
#define SQL_VALUE 304
#define SQL_VAR 305
#define SQL_WHENEVER 306
#define S_ADD 307
#define S_AND 308
#define S_ANYTHING 309
#define S_AUTO 310
#define S_CONST 311
#define S_DEC 312
#define S_DIV 313
#define S_DOTPOINT 314
#define S_EQUAL 315
#define S_EXTERN 316
#define S_INC 317
#define S_LSHIFT 318
#define S_MEMPOINT 319
#define S_MEMBER 320
#define S_MOD 321
#define S_MUL 322
#define S_NEQUAL 323
#define S_OR 324
#define S_REGISTER 325
#define S_RSHIFT 326
#define S_STATIC 327
#define S_SUB 328
#define S_VOLATILE 329
#define S_TYPEDEF 330
#define TYPECAST 331
#define ABORT_P 332
#define ABSOLUTE_P 333
#define ACCESS 334
#define ACTION 335
#define ADD_P 336
#define ADMIN 337
#define AFTER 338
#define AGGREGATE 339
#define ALL 340
#define ALSO 341
#define ALTER 342
#define ANALYSE 343
#define ANALYZE 344
#define AND 345
#define ANY 346
#define ARRAY 347
#define AS 348
#define ASC 349
#define ASSERTION 350
#define ASSIGNMENT 351
#define ASYMMETRIC 352
#define AT 353
#define AUTHORIZATION 354
#define BACKWARD 355
#define BEFORE 356
#define BEGIN_P 357
#define BETWEEN 358
#define BIGINT 359
#define BINARY 360
#define BIT 361
#define BOOLEAN_P 362
#define BOTH 363
#define BY 364
#define CACHE 365
#define CALLED 366
#define CASCADE 367
#define CASCADED 368
#define CASE 369
#define CAST 370
#define CHAIN 371
#define CHAR_P 372
#define CHARACTER 373
#define CHARACTERISTICS 374
#define CHECK 375
#define CHECKPOINT 376
#define CLASS 377
#define CLOSE 378
#define CLUSTER 379
#define COALESCE 380
#define COLLATE 381
#define COLUMN 382
#define COMMENT 383
#define COMMIT 384
#define COMMITTED 385
#define CONCURRENTLY 386
#define CONNECTION 387
#define CONSTRAINT 388
#define CONSTRAINTS 389
#define CONVERSION_P 390
#define CONVERT 391
#define COPY 392
#define CREATE 393
#define CREATEDB 394
#define CREATEROLE 395
#define CREATEUSER 396
#define CROSS 397
#define CSV 398
#define CURRENT_DATE 399
#define CURRENT_ROLE 400
#define CURRENT_TIME 401
#define CURRENT_TIMESTAMP 402
#define CURRENT_USER 403
#define CURSOR 404
#define CYCLE 405
#define DATABASE 406
#define DAY_P 407
#define DEALLOCATE 408
#define DEC 409
#define DECIMAL_P 410
#define DECLARE 411
#define DEFAULT 412
#define DEFAULTS 413
#define DEFERRABLE 414
#define DEFERRED 415
#define DEFINER 416
#define DELETE_P 417
#define DELIMITER 418
#define DELIMITERS 419
#define DESC 420
#define DISABLE_P 421
#define DISTINCT 422
#define DO 423
#define DOMAIN_P 424
#define DOUBLE_P 425
#define DROP 426
#define EACH 427
#define ELSE 428
#define ENABLE_P 429
#define ENCODING 430
#define ENCRYPTED 431
#define END_P 432
#define ESCAPE 433
#define EXCEPT 434
#define EXCLUSIVE 435
#define EXCLUDING 436
#define EXECUTE 437
#define EXISTS 438
#define EXPLAIN 439
#define EXTERNAL 440
#define EXTRACT 441
#define FALSE_P 442
#define FETCH 443
#define FIRST_P 444
#define FLOAT_P 445
#define FOR 446
#define FORCE 447
#define FOREIGN 448
#define FORWARD 449
#define FREEZE 450
#define FROM 451
#define FULL 452
#define FUNCTION 453
#define GET 454
#define GLOBAL 455
#define GRANT 456
#define GRANTED 457
#define GREATEST 458
#define GROUP_P 459
#define HANDLER 460
#define HAVING 461
#define HEADER_P 462
#define HOLD 463
#define HOUR_P 464
#define IF_P 465
#define ILIKE 466
#define IMMEDIATE 467
#define IMMUTABLE 468
#define IMPLICIT_P 469
#define IN_P 470
#define INCLUDING 471
#define INCREMENT 472
#define INDEX 473
#define INDEXES 474
#define INHERIT 475
#define INHERITS 476
#define INITIALLY 477
#define INNER_P 478
#define INOUT 479
#define INPUT_P 480
#define INSENSITIVE 481
#define INSERT 482
#define INSTEAD 483
#define INT_P 484
#define INTEGER 485
#define INTERSECT 486
#define INTERVAL 487
#define INTO 488
#define INVOKER 489
#define IS 490
#define ISNULL 491
#define ISOLATION 492
#define JOIN 493
#define KEY 494
#define LANCOMPILER 495
#define LANGUAGE 496
#define LARGE_P 497
#define LAST_P 498
#define LEADING 499
#define LEAST 500
#define LEFT 501
#define LEVEL 502
#define LIKE 503
#define LIMIT 504
#define LISTEN 505
#define LOAD 506
#define LOCAL 507
#define LOCALTIME 508
#define LOCALTIMESTAMP 509
#define LOCATION 510
#define LOCK_P 511
#define LOGIN_P 512
#define MATCH 513
#define MAXVALUE 514
#define MINUTE_P 515
#define MINVALUE 516
#define MODE 517
#define MONTH_P 518
#define MOVE 519
#define NAMES 520
#define NATIONAL 521
#define NATURAL 522
#define NCHAR 523
#define NEW 524
#define NEXT 525
#define NO 526
#define NOCREATEDB 527
#define NOCREATEROLE 528
#define NOCREATEUSER 529
#define NOINHERIT 530
#define NOLOGIN_P 531
#define NONE 532
#define NOSUPERUSER 533
#define NOT 534
#define NOTHING 535
#define NOTIFY 536
#define NOTNULL 537
#define NOWAIT 538
#define NULL_P 539
#define NULLIF 540
#define NUMERIC 541
#define OBJECT_P 542
#define OF 543
#define OFF 544
#define OFFSET 545
#define OIDS 546
#define OLD 547
#define ON 548
#define ONLY 549
#define OPERATOR 550
#define OPTION 551
#define OR 552
#define ORDER 553
#define OUT_P 554
#define OUTER_P 555
#define OVERLAPS 556
#define OVERLAY 557
#define OWNED 558
#define OWNER 559
#define PARTIAL 560
#define PASSWORD 561
#define PLACING 562
#define POSITION 563
#define PRECISION 564
#define PRESERVE 565
#define PREPARE 566
#define PREPARED 567
#define PRIMARY 568
#define PRIOR 569
#define PRIVILEGES 570
#define PROCEDURAL 571
#define PROCEDURE 572
#define QUOTE 573
#define READ 574
#define REAL 575
#define REASSIGN 576
#define RECHECK 577
#define REFERENCES 578
#define REINDEX 579
#define RELATIVE_P 580
#define RELEASE 581
#define RENAME 582
#define REPEATABLE 583
#define REPLACE 584
#define RESET 585
#define RESTART 586
#define RESTRICT 587
#define RETURNING 588
#define RETURNS 589
#define REVOKE 590
#define RIGHT 591
#define ROLE 592
#define ROLLBACK 593
#define ROW 594
#define ROWS 595
#define RULE 596
#define SAVEPOINT 597
#define SCHEMA 598
#define SCROLL 599
#define SECOND_P 600
#define SECURITY 601
#define SELECT 602
#define SEQUENCE 603
#define SERIALIZABLE 604
#define SESSION 605
#define SESSION_USER 606
#define SET 607
#define SETOF 608
#define SHARE 609
#define SHOW 610
#define SIMILAR 611
#define SIMPLE 612
#define SMALLINT 613
#define SOME 614
#define STABLE 615
#define START 616
#define STATEMENT 617
#define STATISTICS 618
#define STDIN 619
#define STDOUT 620
#define STORAGE 621
#define STRICT_P 622
#define SUBSTRING 623
#define SUPERUSER_P 624
#define SYMMETRIC 625
#define SYSID 626
#define SYSTEM_P 627
#define TABLE 628
#define TABLESPACE 629
#define TEMP 630
#define TEMPLATE 631
#define TEMPORARY 632
#define THEN 633
#define TIME 634
#define TIMESTAMP 635
#define TO 636
#define TRAILING 637
#define TRANSACTION 638
#define TREAT 639
#define TRIGGER 640
#define TRIM 641
#define TRUE_P 642
#define TRUNCATE 643
#define TRUSTED 644
#define TYPE_P 645
#define UNCOMMITTED 646
#define UNENCRYPTED 647
#define UNION 648
#define UNIQUE 649
#define UNKNOWN 650
#define UNLISTEN 651
#define UNTIL 652
#define UPDATE 653
#define USER 654
#define USING 655
#define VACUUM 656
#define VALID 657
#define VALIDATOR 658
#define VALUES 659
#define VARCHAR 660
#define VARYING 661
#define VERBOSE 662
#define VIEW 663
#define VOLATILE 664
#define WHEN 665
#define WHERE 666
#define WITH 667
#define WITHOUT 668
#define WORK 669
#define WRITE 670
#define YEAR_P 671
#define ZONE 672
#define WITH_CASCADED 673
#define WITH_LOCAL 674
#define WITH_CHECK 675
#define IDENT 676
#define SCONST 677
#define Op 678
#define CSTRING 679
#define CVARIABLE 680
#define CPP_LINE 681
#define IP 682
#define BCONST 683
#define XCONST 684
#define DOLCONST 685
#define ICONST 686
#define PARAM 687
#define FCONST 688
#define POSTFIXOP 689
#define UMINUS 690




/* Copy the first part of user declarations.  */
#line 4 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
int ecpg_informix_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	QueryIsRule = 0, FoundInto = 0;
static int	initializer = 0;
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, 0L, NULL, {NULL}};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, 0L, NULL, {NULL}};

/* INFORMIX workaround, no longer needed
static struct inf_compat_col
{
	char *name;
	char *indirection;
	struct inf_compat_col *next;
} *informix_col;

static struct inf_compat_val
{
	char *val;
	struct inf_compat_val *next;
} *informix_val;
*/

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, char * error, ...)
{
	va_list ap;

	fprintf(stderr, "%s:%d: ", input_filename, yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, "WARNING: ");
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, "ERROR: ");
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	char * name = (char *)mm_alloc(yyleng + 1);

	strncpy(name, yytext, yyleng);
	name[yyleng] = '\0';
	return(name);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
		result = cat2_str(result, make_str("? , "));

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_informix(struct arguments *list)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
 	 * for instance you can declare variables in a function, and then subsequently use them
	 * {
	 *      declare_vars();
	 *      exec sql ... which uses vars declared in the above function
	 *
	 * This breaks standard and leads to some very dangerous programming.
	 * Since they do, we have to work around and accept their syntax as well.
	 * But we will do so ONLY in Informix mode.
	 * We have to change the variables to our own struct and just store the pointer instead of the variable
	 */

	 struct arguments *ptr;
	 char *result = make_str("");

	 for (ptr = list; ptr != NULL; ptr = ptr->next)
	 {
	 	char temp[20]; /* this should be sufficient unless you have 8 byte integers */
		char *original_var;

	 	/* change variable name to "ECPG_informix_get_var(<counter>)" */
		original_var = ptr->variable->name;
		sprintf(temp, "%d))", ecpg_informix_var);

		if ((ptr->variable->type->type != ECPGt_varchar && ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->variable->type->u.element->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, make_str("1")), ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else if ((ptr->variable->type->type == ECPGt_varchar || ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else
		{
			ptr->variable = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size), 0);
			sprintf(temp, "%d, &(", ecpg_informix_var++);
		}

		/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
		result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));

		/* now the indicator if there is one */
		if (ptr->indicator->type->type != ECPGt_NO_INDICATOR)
		{
			/* change variable name to "ECPG_informix_get_var(<counter>)" */
			original_var = ptr->indicator->name;
			sprintf(temp, "%d))", ecpg_informix_var);

			/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
			if (atoi(ptr->indicator->type->size) > 1)
			{
				ptr->indicator = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, (", ecpg_informix_var++);
			}
			else
			{
				ptr->indicator = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, &(", ecpg_informix_var++);
			}
			result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		}
	 }

	 return result;
}

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "trying to access an undeclared cursor %s\n", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = ptr->argsinsert; p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = ptr->argsresult; p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 314 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
} YYSTYPE;
/* Line 186 of yacc.c.  */
#line 1269 "y.tab.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1281 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   62941

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  456
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  545
/* YYNRULES -- Number of rules. */
#define YYNRULES  2100
/* YYNRULES -- Number of states. */
#define YYNSTATES  3537

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   691

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   442,     2,     2,
     447,   448,   440,   438,   454,   439,   449,   441,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   455,   450,
     435,   434,   436,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   445,     2,   446,   443,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   451,     2,   452,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   437,
     444,   453
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     6,     9,    14,    18,    21,    23,
      25,    27,    29,    31,    34,    36,    38,    40,    42,    44,
      46,    48,    50,    52,    54,    56,    58,    60,    62,    64,
      66,    68,    70,    72,    74,    76,    78,    80,    82,    84,
      86,    88,    90,    92,    94,    96,    98,   100,   102,   104,
     106,   108,   110,   112,   114,   116,   118,   120,   122,   124,
     126,   128,   130,   132,   134,   136,   138,   140,   142,   144,
     146,   148,   150,   152,   154,   156,   158,   160,   162,   164,
     166,   168,   170,   172,   174,   176,   178,   180,   182,   184,
     186,   188,   190,   192,   194,   196,   198,   200,   202,   204,
     206,   208,   210,   212,   214,   216,   218,   220,   222,   224,
     226,   228,   230,   232,   234,   236,   238,   244,   246,   247,
     250,   253,   257,   261,   263,   265,   267,   269,   271,   273,
     275,   277,   279,   281,   285,   289,   292,   295,   298,   301,
     305,   309,   315,   321,   327,   332,   338,   344,   349,   353,
     359,   363,   369,   375,   382,   384,   386,   390,   396,   403,
     408,   410,   411,   414,   415,   417,   419,   421,   423,   425,
     427,   430,   434,   438,   442,   446,   450,   453,   459,   462,
     465,   469,   473,   475,   479,   481,   483,   485,   489,   492,
     495,   498,   500,   502,   504,   506,   508,   510,   512,   514,
     516,   518,   522,   529,   531,   533,   535,   537,   538,   540,
     542,   546,   551,   557,   562,   565,   568,   572,   577,   581,
     584,   589,   591,   593,   595,   597,   599,   604,   609,   611,
     615,   619,   624,   631,   638,   645,   652,   657,   664,   667,
     672,   676,   680,   684,   688,   692,   696,   700,   704,   708,
     711,   715,   717,   719,   723,   727,   731,   734,   737,   741,
     744,   746,   748,   749,   752,   753,   756,   766,   773,   775,
     777,   779,   781,   783,   786,   787,   789,   791,   795,   799,
     801,   803,   807,   811,   815,   820,   822,   823,   826,   827,
     831,   832,   834,   835,   847,   860,   862,   864,   867,   870,
     873,   876,   877,   879,   880,   882,   886,   888,   890,   892,
     896,   899,   900,   904,   906,   908,   911,   913,   917,   922,
     927,   930,   936,   938,   941,   944,   947,   951,   954,   955,
     958,   961,   964,   967,   970,   973,   977,   979,   984,   991,
     999,  1011,  1015,  1016,  1020,  1022,  1024,  1027,  1030,  1031,
    1033,  1035,  1038,  1041,  1042,  1046,  1050,  1053,  1055,  1057,
    1060,  1063,  1068,  1069,  1072,  1075,  1078,  1079,  1083,  1088,
    1093,  1094,  1097,  1098,  1103,  1104,  1105,  1117,  1121,  1122,
    1126,  1128,  1130,  1136,  1141,  1144,  1145,  1148,  1150,  1153,
    1157,  1160,  1163,  1166,  1169,  1173,  1177,  1181,  1183,  1184,
    1190,  1200,  1202,  1203,  1205,  1208,  1211,  1212,  1215,  1216,
    1222,  1230,  1232,  1233,  1240,  1243,  1244,  1248,  1254,  1269,
    1289,  1291,  1293,  1295,  1299,  1305,  1307,  1309,  1311,  1315,
    1316,  1318,  1319,  1321,  1323,  1325,  1329,  1330,  1332,  1334,
    1335,  1338,  1340,  1343,  1345,  1348,  1349,  1352,  1354,  1357,
    1360,  1367,  1376,  1385,  1389,  1395,  1400,  1405,  1410,  1414,
    1422,  1426,  1428,  1432,  1436,  1438,  1440,  1442,  1444,  1446,
    1448,  1452,  1456,  1458,  1462,  1466,  1468,  1472,  1476,  1489,
    1491,  1495,  1500,  1508,  1513,  1516,  1518,  1519,  1521,  1522,
    1530,  1540,  1546,  1553,  1560,  1565,  1567,  1569,  1571,  1573,
    1575,  1577,  1579,  1581,  1583,  1587,  1589,  1592,  1595,  1599,
    1604,  1610,  1615,  1620,  1624,  1629,  1633,  1637,  1640,  1645,
    1648,  1650,  1652,  1654,  1656,  1659,  1662,  1664,  1666,  1668,
    1671,  1674,  1676,  1679,  1682,  1684,  1686,  1693,  1701,  1709,
    1719,  1728,  1737,  1744,  1754,  1762,  1773,  1781,  1783,  1785,
    1787,  1789,  1791,  1793,  1795,  1797,  1799,  1801,  1803,  1805,
    1807,  1809,  1817,  1825,  1836,  1839,  1841,  1843,  1845,  1849,
    1851,  1853,  1855,  1857,  1859,  1862,  1865,  1868,  1871,  1874,
    1877,  1880,  1882,  1886,  1888,  1891,  1895,  1896,  1898,  1902,
    1905,  1912,  1919,  1923,  1924,  1928,  1929,  1943,  1958,  1960,
    1961,  1964,  1965,  1967,  1971,  1974,  1977,  1982,  1984,  1987,
    1988,  1998,  2006,  2009,  2010,  2014,  2017,  2019,  2023,  2027,
    2031,  2034,  2037,  2039,  2041,  2043,  2045,  2048,  2050,  2054,
    2056,  2058,  2064,  2066,  2071,  2073,  2076,  2081,  2087,  2089,
    2091,  2093,  2095,  2099,  2103,  2106,  2109,  2112,  2115,  2117,
    2120,  2121,  2127,  2129,  2132,  2134,  2135,  2141,  2149,  2155,
    2163,  2171,  2181,  2183,  2187,  2191,  2195,  2197,  2201,  2213,
    2224,  2227,  2228,  2238,  2241,  2242,  2247,  2252,  2257,  2259,
    2261,  2263,  2264,  2272,  2279,  2286,  2294,  2301,  2308,  2318,
    2325,  2332,  2339,  2348,  2357,  2364,  2371,  2373,  2374,  2382,
    2389,  2397,  2404,  2411,  2418,  2426,  2433,  2440,  2447,  2455,
    2465,  2475,  2482,  2489,  2496,  2497,  2512,  2514,  2516,  2520,
    2524,  2526,  2528,  2530,  2532,  2534,  2536,  2538,  2539,  2541,
    2543,  2545,  2547,  2549,  2551,  2552,  2559,  2568,  2571,  2574,
    2577,  2580,  2583,  2587,  2591,  2594,  2597,  2600,  2603,  2607,
    2610,  2616,  2621,  2625,  2629,  2633,  2635,  2637,  2638,  2642,
    2645,  2648,  2650,  2654,  2657,  2659,  2660,  2669,  2680,  2683,
    2687,  2691,  2692,  2695,  2701,  2705,  2707,  2710,  2714,  2718,
    2722,  2726,  2730,  2734,  2738,  2742,  2747,  2751,  2755,  2757,
    2758,  2764,  2770,  2775,  2778,  2779,  2784,  2788,  2794,  2801,
    2806,  2813,  2820,  2826,  2834,  2836,  2837,  2848,  2853,  2856,
    2858,  2863,  2869,  2875,  2878,  2883,  2885,  2887,  2889,  2890,
    2892,  2893,  2895,  2896,  2900,  2901,  2906,  2908,  2910,  2912,
    2914,  2916,  2918,  2919,  2925,  2927,  2932,  2935,  2939,  2941,
    2944,  2947,  2948,  2955,  2958,  2959,  2965,  2969,  2970,  2973,
    2976,  2979,  2983,  2985,  2989,  2991,  2994,  2996,  2997,  3005,
    3007,  3011,  3013,  3015,  3019,  3025,  3028,  3030,  3034,  3042,
    3043,  3046,  3049,  3052,  3056,  3057,  3060,  3063,  3065,  3067,
    3071,  3075,  3077,  3080,  3085,  3090,  3092,  3094,  3103,  3105,
    3110,  3115,  3120,  3123,  3125,  3126,  3130,  3134,  3139,  3144,
    3149,  3154,  3157,  3159,  3161,  3162,  3164,  3165,  3167,  3173,
    3175,  3176,  3178,  3179,  3183,  3185,  3189,  3193,  3196,  3199,
    3201,  3206,  3211,  3214,  3217,  3222,  3224,  3225,  3227,  3229,
    3231,  3235,  3236,  3239,  3240,  3242,  3246,  3248,  3249,  3251,
    3254,  3259,  3264,  3267,  3268,  3271,  3275,  3278,  3279,  3283,
    3285,  3287,  3290,  3292,  3295,  3301,  3308,  3314,  3316,  3319,
    3321,  3326,  3330,  3335,  3341,  3346,  3352,  3357,  3363,  3366,
    3371,  3373,  3376,  3379,  3382,  3384,  3386,  3387,  3392,  3395,
    3397,  3400,  3403,  3408,  3410,  3413,  3417,  3419,  3422,  3423,
    3425,  3429,  3432,  3435,  3439,  3445,  3452,  3456,  3461,  3462,
    3464,  3468,  3472,  3476,  3480,  3484,  3488,  3490,  3492,  3494,
    3496,  3498,  3500,  3502,  3505,  3511,  3514,  3516,  3518,  3520,
    3522,  3524,  3526,  3528,  3530,  3532,  3534,  3536,  3539,  3542,
    3545,  3548,  3551,  3553,  3557,  3558,  3564,  3568,  3569,  3575,
    3579,  3580,  3582,  3584,  3586,  3588,  3594,  3597,  3599,  3601,
    3603,  3605,  3611,  3614,  3617,  3620,  3622,  3626,  3630,  3633,
    3635,  3636,  3640,  3641,  3647,  3650,  3656,  3659,  3661,  3665,
    3669,  3670,  3672,  3674,  3676,  3678,  3680,  3682,  3686,  3690,
    3694,  3698,  3702,  3706,  3710,  3711,  3713,  3717,  3723,  3726,
    3729,  3733,  3737,  3741,  3745,  3749,  3753,  3757,  3761,  3765,
    3769,  3772,  3775,  3779,  3783,  3786,  3790,  3796,  3801,  3808,
    3812,  3818,  3823,  3830,  3835,  3842,  3848,  3856,  3859,  3863,
    3866,  3871,  3875,  3879,  3884,  3888,  3893,  3897,  3902,  3908,
    3915,  3922,  3930,  3937,  3945,  3952,  3960,  3964,  3969,  3974,
    3981,  3984,  3986,  3990,  3993,  3997,  4001,  4005,  4009,  4013,
    4017,  4021,  4025,  4029,  4033,  4036,  4039,  4045,  4052,  4059,
    4067,  4069,  4071,  4074,  4079,  4081,  4083,  4085,  4088,  4091,
    4094,  4096,  4100,  4105,  4111,  4117,  4122,  4124,  4126,  4131,
    4133,  4138,  4140,  4145,  4147,  4152,  4154,  4156,  4158,  4160,
    4167,  4172,  4177,  4182,  4187,  4194,  4200,  4206,  4212,  4217,
    4224,  4229,  4236,  4241,  4246,  4251,  4256,  4260,  4266,  4268,
    4270,  4272,  4274,  4276,  4278,  4280,  4282,  4284,  4286,  4288,
    4290,  4292,  4294,  4296,  4301,  4303,  4308,  4310,  4315,  4317,
    4320,  4322,  4325,  4327,  4331,  4335,  4336,  4340,  4342,  4344,
    4348,  4352,  4356,  4358,  4360,  4362,  4364,  4366,  4368,  4370,
    4372,  4377,  4381,  4384,  4388,  4389,  4393,  4397,  4400,  4403,
    4405,  4406,  4409,  4412,  4416,  4419,  4421,  4423,  4427,  4433,
    4436,  4438,  4443,  4446,  4447,  4449,  4450,  4452,  4455,  4458,
    4461,  4465,  4471,  4473,  4476,  4477,  4480,  4482,  4483,  4485,
    4487,  4489,  4493,  4497,  4501,  4503,  4507,  4509,  4511,  4513,
    4515,  4517,  4521,  4523,  4526,  4528,  4532,  4534,  4536,  4538,
    4540,  4542,  4544,  4546,  4549,  4551,  4554,  4558,  4565,  4567,
    4569,  4571,  4573,  4575,  4577,  4579,  4581,  4583,  4585,  4587,
    4589,  4591,  4594,  4596,  4598,  4600,  4602,  4605,  4608,  4610,
    4612,  4614,  4616,  4618,  4620,  4622,  4624,  4627,  4630,  4632,
    4634,  4636,  4638,  4640,  4642,  4644,  4646,  4648,  4650,  4652,
    4654,  4660,  4664,  4667,  4670,  4674,  4682,  4684,  4686,  4688,
    4689,  4692,  4695,  4697,  4698,  4700,  4704,  4706,  4709,  4710,
    4713,  4714,  4717,  4718,  4720,  4724,  4729,  4733,  4735,  4737,
    4739,  4742,  4743,  4751,  4755,  4758,  4760,  4762,  4764,  4765,
    4771,  4772,  4777,  4780,  4782,  4785,  4786,  4788,  4792,  4796,
    4800,  4804,  4805,  4810,  4816,  4822,  4823,  4825,  4827,  4829,
    4831,  4834,  4837,  4840,  4842,  4845,  4846,  4854,  4855,  4861,
    4862,  4867,  4870,  4873,  4874,  4877,  4879,  4881,  4883,  4885,
    4887,  4889,  4891,  4893,  4895,  4897,  4899,  4905,  4908,  4910,
    4914,  4917,  4920,  4924,  4925,  4931,  4933,  4934,  4940,  4943,
    4946,  4948,  4950,  4952,  4955,  4958,  4962,  4964,  4967,  4970,
    4974,  4978,  4983,  4986,  4988,  4991,  4993,  4995,  4998,  5001,
    5005,  5007,  5009,  5011,  5013,  5014,  5016,  5020,  5026,  5027,
    5030,  5031,  5033,  5036,  5040,  5043,  5045,  5047,  5049,  5050,
    5052,  5054,  5056,  5060,  5061,  5066,  5069,  5072,  5074,  5076,
    5077,  5079,  5081,  5083,  5085,  5088,  5092,  5093,  5095,  5098,
    5100,  5105,  5110,  5111,  5113,  5116,  5118,  5120,  5124,  5126,
    5128,  5133,  5138,  5143,  5148,  5150,  5151,  5155,  5159,  5164,
    5166,  5170,  5174,  5179,  5181,  5185,  5189,  5191,  5198,  5200,
    5204,  5208,  5215,  5217,  5221,  5225,  5227,  5229,  5231,  5233,
    5235,  5237,  5239,  5241,  5243,  5245,  5247,  5249,  5251,  5253,
    5255,  5260,  5265,  5267,  5269,  5274,  5279,  5283,  5284,  5292,
    5294,  5295,  5296,  5304,  5308,  5313,  5317,  5319,  5321,  5323,
    5326,  5330,  5336,  5339,  5345,  5348,  5350,  5352,  5354,  5356,
    5358,  5360,  5362,  5364,  5366,  5368,  5370,  5372,  5374,  5376,
    5378,  5380,  5382,  5384,  5386,  5388,  5390,  5392,  5394,  5396,
    5398,  5400,  5402,  5404,  5406,  5408,  5410,  5412,  5414,  5416,
    5418,  5420,  5422,  5424,  5426,  5428,  5430,  5432,  5434,  5436,
    5438,  5440,  5442,  5444,  5446,  5448,  5450,  5452,  5454,  5456,
    5458,  5460,  5462,  5464,  5466,  5468,  5470,  5472,  5474,  5476,
    5478,  5480,  5482,  5484,  5486,  5488,  5490,  5492,  5494,  5496,
    5498,  5500,  5502,  5504,  5506,  5508,  5510,  5512,  5514,  5516,
    5518,  5520,  5522,  5524,  5526,  5528,  5530,  5532,  5534,  5536,
    5538,  5540,  5542,  5544,  5546,  5548,  5550,  5552,  5554,  5556,
    5558,  5560,  5562,  5564,  5566,  5568,  5570,  5572,  5574,  5576,
    5578,  5580,  5582,  5584,  5586,  5588,  5590,  5592,  5594,  5596,
    5598,  5600,  5602,  5604,  5606,  5608,  5610,  5612,  5614,  5616,
    5618,  5620,  5622,  5624,  5626,  5628,  5630,  5632,  5634,  5636,
    5638,  5640,  5642,  5644,  5646,  5648,  5650,  5652,  5654,  5656,
    5658,  5660,  5662,  5664,  5666,  5668,  5670,  5672,  5674,  5676,
    5678,  5680,  5682,  5684,  5686,  5688,  5690,  5692,  5694,  5696,
    5698,  5700,  5702,  5704,  5706,  5708,  5710,  5712,  5714,  5716,
    5718,  5720,  5722,  5724,  5726,  5728,  5730,  5732,  5734,  5736,
    5738,  5740,  5742,  5744,  5746,  5748,  5750,  5752,  5754,  5756,
    5758,  5760,  5762,  5764,  5766,  5768,  5770,  5772,  5774,  5776,
    5778,  5780,  5782,  5784,  5786,  5788,  5790,  5792,  5794,  5796,
    5798,  5800,  5802,  5804,  5806,  5808,  5810,  5812,  5814,  5816,
    5818,  5820,  5822,  5824,  5826,  5828,  5830,  5832,  5834,  5836,
    5838,  5840,  5842,  5844,  5846,  5848,  5850,  5852,  5854,  5856,
    5858,  5860,  5862,  5864,  5866,  5868,  5870,  5872,  5874,  5876,
    5878,  5880,  5882,  5884,  5886,  5888,  5890,  5892,  5894,  5896,
    5898,  5900,  5902,  5904,  5906,  5908,  5910,  5912,  5914,  5916,
    5918,  5920,  5922,  5924,  5926,  5928,  5930,  5932,  5934,  5936,
    5938,  5940,  5942,  5944,  5946,  5948,  5950,  5952,  5954,  5956,
    5958,  5960,  5962,  5964,  5966,  5968,  5970,  5972,  5974,  5976,
    5978,  5980,  5982,  5984,  5986,  5988,  5990,  5992,  5994,  5996,
    5998,  6000,  6002,  6004,  6006,  6008,  6010,  6012,  6014,  6016,
    6018,  6020,  6022,  6024,  6026,  6028,  6030,  6032,  6034,  6036,
    6038,  6040,  6042,  6044,  6046,  6048,  6050,  6052,  6054,  6056,
    6058,  6060,  6062,  6064,  6066,  6068,  6070,  6072,  6074,  6076,
    6078,  6080,  6082,  6084,  6086,  6088,  6090,  6092,  6094,  6096,
    6098,  6100,  6102,  6104,  6106,  6108,  6110,  6112,  6114,  6116,
    6118,  6120,  6122,  6124,  6126,  6128,  6130,  6132,  6134,  6136,
    6138,  6140,  6142,  6144,  6146,  6148,  6150,  6152,  6154,  6156,
    6158,  6160,  6162,  6164,  6166,  6168,  6170,  6172,  6174,  6176,
    6178,  6180,  6182,  6184,  6186,  6190,  6192,  6193,  6195,  6198,
    6200,  6203,  6205,  6207,  6210,  6213,  6215,  6217,  6219,  6221,
    6223,  6225,  6228,  6232,  6234,  6237,  6239,  6243,  6245,  6249,
    6251,  6253,  6255,  6257,  6259,  6261,  6263,  6265,  6267,  6269,
    6271,  6273,  6275,  6277,  6279,  6281,  6283,  6285,  6287,  6289,
    6291,  6293,  6295,  6297,  6299,  6301,  6303,  6305,  6307,  6309,
    6311,  6313,  6315,  6317,  6319,  6321,  6323,  6325,  6327,  6329,
    6331,  6333,  6335,  6337,  6339,  6341,  6343,  6345,  6347,  6349,
    6351,  6353,  6355,  6357,  6359,  6361,  6363,  6365,  6367,  6369,
    6371
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     457,     0,    -1,   458,    -1,    -1,   458,   459,    -1,   986,
     460,   461,   450,    -1,   986,   461,   450,    -1,   986,   876,
      -1,   884,    -1,   999,    -1,   426,    -1,   451,    -1,   452,
      -1,    98,   920,    -1,   686,    -1,   687,    -1,   692,    -1,
     643,    -1,   472,    -1,   660,    -1,   661,    -1,   548,    -1,
     496,    -1,   467,    -1,   466,    -1,   468,    -1,   697,    -1,
     495,    -1,   504,    -1,   695,    -1,   605,    -1,   492,    -1,
     505,    -1,   542,    -1,   576,    -1,   651,    -1,   694,    -1,
     691,    -1,   629,    -1,   471,    -1,   552,    -1,   588,    -1,
     462,    -1,   475,    -1,   547,    -1,   514,    -1,   559,    -1,
     562,    -1,   465,    -1,   682,    -1,   724,    -1,   578,    -1,
     711,    -1,   577,    -1,   653,    -1,   474,    -1,   593,    -1,
     594,    -1,   557,    -1,   469,    -1,   670,    -1,   596,    -1,
     561,    -1,   575,    -1,   470,    -1,   690,    -1,   703,    -1,
     602,    -1,   608,    -1,   619,    -1,   623,    -1,   706,    -1,
     672,    -1,   681,    -1,   713,    -1,   671,    -1,   595,    -1,
     655,    -1,   647,    -1,   648,    -1,   646,    -1,   658,    -1,
     609,    -1,   620,    -1,   662,    -1,   727,    -1,   674,    -1,
     601,    -1,   673,    -1,   717,    -1,   696,    -1,   479,    -1,
     490,    -1,   491,    -1,   679,    -1,   939,    -1,   860,    -1,
     874,    -1,   875,    -1,   940,    -1,   917,    -1,   937,    -1,
     918,    -1,   921,    -1,   926,    -1,   948,    -1,   941,    -1,
     927,    -1,   936,    -1,   955,    -1,   957,    -1,   951,    -1,
     944,    -1,   958,    -1,   961,    -1,   963,    -1,   138,   337,
     858,   463,   464,    -1,   412,    -1,    -1,   306,   848,    -1,
     306,   284,    -1,   176,   306,   848,    -1,   392,   306,   848,
      -1,   369,    -1,   278,    -1,   220,    -1,   275,    -1,   139,
      -1,   272,    -1,   140,    -1,   273,    -1,   257,    -1,   276,
      -1,   132,   249,   850,    -1,   402,   397,   848,    -1,   399,
     835,    -1,   371,   849,    -1,    82,   835,    -1,   337,   835,
      -1,   215,   337,   835,    -1,   215,   204,   835,    -1,   138,
     399,   858,   463,   464,    -1,    87,   337,   858,   463,   464,
      -1,    87,   337,   858,   352,   480,    -1,    87,   337,   858,
     491,    -1,    87,   399,   858,   463,   464,    -1,    87,   399,
     858,   352,   480,    -1,    87,   399,   858,   491,    -1,   171,
     337,   835,    -1,   171,   337,   210,   183,   835,    -1,   171,
     399,   835,    -1,   171,   399,   210,   183,   835,    -1,   138,
     204,   858,   463,   464,    -1,    87,   204,   858,   473,   399,
     835,    -1,    81,    -1,   171,    -1,   171,   204,   835,    -1,
     171,   204,   210,   183,   835,    -1,   138,   343,   476,    99,
     858,   477,    -1,   138,   343,   971,   477,    -1,   971,    -1,
      -1,   477,   478,    -1,    -1,   514,    -1,   623,    -1,   547,
      -1,   562,    -1,   608,    -1,   679,    -1,   352,   480,    -1,
     352,   252,   480,    -1,   352,   350,   480,    -1,   481,   381,
     482,    -1,   481,   453,   482,    -1,   379,   417,   487,    -1,
     383,   677,    -1,   350,   119,    93,   383,   677,    -1,   265,
     488,    -1,   337,   489,    -1,   350,    99,   489,    -1,   350,
      99,   157,    -1,   970,    -1,   481,   449,   971,    -1,   483,
      -1,   157,    -1,   485,    -1,   483,   454,   485,    -1,   319,
     391,    -1,   319,   130,    -1,   328,   319,    -1,   349,    -1,
     486,    -1,   856,    -1,   971,    -1,   387,    -1,   187,    -1,
     293,    -1,   289,    -1,   856,    -1,   993,    -1,   789,   853,
     791,    -1,   789,   447,   849,   448,   853,   791,    -1,   157,
      -1,   252,    -1,   853,    -1,   157,    -1,    -1,   971,    -1,
     853,    -1,   355,   481,   933,    -1,   355,   379,   417,   933,
      -1,   355,   383,   237,   247,   933,    -1,   355,   350,    99,
     933,    -1,   355,    85,    -1,   330,   481,    -1,   330,   379,
     417,    -1,   330,   383,   237,   247,    -1,   330,   350,    99,
      -1,   330,    85,    -1,   352,   134,   493,   494,    -1,    85,
      -1,   833,    -1,   160,    -1,   212,    -1,   121,    -1,    87,
     373,   761,   497,    -1,    87,   218,   761,   499,    -1,   498,
      -1,   497,   454,   498,    -1,    81,   659,   519,    -1,    87,
     659,   971,   501,    -1,    87,   659,   971,   171,   279,   284,
      -1,    87,   659,   971,   352,   279,   284,    -1,    87,   659,
     971,   352,   363,   849,    -1,    87,   659,   971,   352,   366,
     971,    -1,   171,   659,   971,   502,    -1,    87,   659,   971,
     390,   767,   503,    -1,    81,   527,    -1,   171,   133,   836,
     502,    -1,   352,   413,   291,    -1,   124,   293,   836,    -1,
     352,   413,   124,    -1,   174,   385,   836,    -1,   174,   385,
      85,    -1,   174,   385,   399,    -1,   166,   385,   836,    -1,
     166,   385,    85,    -1,   166,   385,   399,    -1,   220,   834,
      -1,   271,   220,   834,    -1,   500,    -1,   500,    -1,   499,
     454,   500,    -1,   304,   381,   858,    -1,   352,   374,   836,
      -1,   352,   579,    -1,   330,   579,    -1,   352,   157,   792,
      -1,   171,   157,    -1,   112,    -1,   332,    -1,    -1,   400,
     792,    -1,    -1,   123,   836,    -1,   137,   510,   834,   511,
     506,   507,   512,   463,   508,    -1,   137,   728,   381,   507,
     463,   508,    -1,   381,    -1,   196,    -1,   853,    -1,   364,
      -1,   365,    -1,   508,   509,    -1,    -1,   105,    -1,   291,
      -1,   163,   693,   853,    -1,   284,   693,   853,    -1,   143,
      -1,   207,    -1,   318,   693,   848,    -1,   178,   693,   848,
      -1,   192,   318,   530,    -1,   192,   279,   284,   530,    -1,
     105,    -1,    -1,   412,   291,    -1,    -1,   513,   164,   853,
      -1,    -1,   400,    -1,    -1,   138,   515,   373,   834,   447,
     516,   448,   537,   538,   539,   540,    -1,   138,   515,   373,
     834,   288,   834,   447,   516,   448,   538,   539,   540,    -1,
     377,    -1,   375,    -1,   252,   377,    -1,   252,   375,    -1,
     200,   377,    -1,   200,   375,    -1,    -1,   517,    -1,    -1,
     518,    -1,   517,   454,   518,    -1,   519,    -1,   524,    -1,
     527,    -1,   971,   767,   520,    -1,   520,   521,    -1,    -1,
     133,   836,   522,    -1,   522,    -1,   523,    -1,   279,   284,
      -1,   284,    -1,   394,   642,   541,    -1,   313,   239,   642,
     541,    -1,   120,   447,   792,   448,    -1,   157,   793,    -1,
     323,   834,   529,   532,   533,    -1,   159,    -1,   279,   159,
      -1,   222,   160,    -1,   222,   212,    -1,   248,   834,   525,
      -1,   525,   526,    -1,    -1,   216,   158,    -1,   181,   158,
      -1,   216,   134,    -1,   181,   134,    -1,   216,   219,    -1,
     181,   219,    -1,   133,   836,   528,    -1,   528,    -1,   120,
     447,   792,   448,    -1,   394,   447,   530,   448,   642,   541,
      -1,   313,   239,   447,   530,   448,   642,   541,    -1,   193,
     239,   447,   530,   448,   323,   834,   529,   532,   533,   572,
      -1,   447,   530,   448,    -1,    -1,   530,   454,   531,    -1,
     531,    -1,   971,    -1,   258,   197,    -1,   258,   305,    -1,
      -1,   534,    -1,   535,    -1,   534,   535,    -1,   535,   534,
      -1,    -1,   293,   162,   536,    -1,   293,   398,   536,    -1,
     271,    80,    -1,   332,    -1,   112,    -1,   352,   157,    -1,
     352,   284,    -1,   221,   447,   833,   448,    -1,    -1,   412,
     579,    -1,   412,   291,    -1,   413,   291,    -1,    -1,   293,
     129,   171,    -1,   293,   129,   162,   340,    -1,   293,   129,
     310,   340,    -1,    -1,   374,   836,    -1,    -1,   400,   218,
     374,   836,    -1,    -1,    -1,   138,   515,   373,   834,   544,
     538,   539,   540,    93,   543,   727,    -1,   447,   545,   448,
      -1,    -1,   545,   454,   546,    -1,   546,    -1,   971,    -1,
     138,   515,   348,   834,   549,    -1,    87,   348,   834,   549,
      -1,   549,   550,    -1,    -1,   110,   855,    -1,   150,    -1,
     271,   150,    -1,   217,   551,   855,    -1,   259,   855,    -1,
     261,   855,    -1,   271,   259,    -1,   271,   261,    -1,   303,
     109,   599,    -1,   361,   463,   855,    -1,   331,   463,   855,
      -1,   109,    -1,    -1,   138,   553,   558,   241,   489,    -1,
     138,   553,   558,   241,   489,   205,   554,   555,   556,    -1,
     389,    -1,    -1,   836,    -1,   836,   600,    -1,   403,   554,
      -1,    -1,   240,   853,    -1,    -1,   171,   558,   241,   853,
     502,    -1,   171,   558,   241,   210,   183,   853,   502,    -1,
     316,    -1,    -1,   138,   374,   836,   560,   255,   848,    -1,
     304,   836,    -1,    -1,   171,   374,   836,    -1,   171,   374,
     210,   183,   836,    -1,   138,   385,   836,   563,   564,   293,
     834,   566,   182,   317,   836,   447,   569,   448,    -1,   138,
     133,   385,   836,    83,   564,   293,   834,   571,   572,   191,
     172,   339,   182,   317,   842,   447,   569,   448,    -1,   101,
      -1,    83,    -1,   565,    -1,   565,   297,   565,    -1,   565,
     297,   565,   297,   565,    -1,   227,    -1,   162,    -1,   398,
      -1,   191,   567,   568,    -1,    -1,   172,    -1,    -1,   339,
      -1,   362,    -1,   570,    -1,   569,   454,   570,    -1,    -1,
     857,    -1,   971,    -1,    -1,   196,   834,    -1,   573,    -1,
     573,   574,    -1,   574,    -1,   574,   573,    -1,    -1,   279,
     159,    -1,   159,    -1,   222,   212,    -1,   222,   160,    -1,
     171,   385,   836,   293,   834,   502,    -1,   171,   385,   210,
     183,   836,   293,   834,   502,    -1,   138,    95,   836,   120,
     447,   792,   448,   572,    -1,   171,    95,   836,    -1,   138,
      84,   842,   583,   579,    -1,   138,    84,   842,   585,    -1,
     138,   295,   798,   579,    -1,   138,   390,   599,   579,    -1,
     138,   390,   599,    -1,   138,   390,   599,    93,   447,   765,
     448,    -1,   447,   580,   448,    -1,   581,    -1,   580,   454,
     581,    -1,   974,   434,   582,    -1,   974,    -1,   638,    -1,
     983,    -1,   984,    -1,   801,    -1,   856,    -1,   447,   584,
     448,    -1,   447,   440,   448,    -1,   767,    -1,   584,   454,
     767,    -1,   447,   586,   448,    -1,   587,    -1,   586,   454,
     587,    -1,   993,   434,   582,    -1,   138,   295,   122,   599,
     591,   191,   390,   767,   400,   838,    93,   589,    -1,   590,
      -1,   589,   454,   590,    -1,   295,   849,   650,   592,    -1,
     295,   849,   650,   447,   649,   448,   592,    -1,   198,   849,
     842,   631,    -1,   366,   767,    -1,   157,    -1,    -1,   322,
      -1,    -1,   171,   295,   122,   599,   400,   838,   502,    -1,
     171,   295,   122,   210,   183,   599,   400,   838,   502,    -1,
     171,   303,   109,   835,   502,    -1,   321,   303,   109,   835,
     381,   836,    -1,   171,   597,   210,   183,   598,   502,    -1,
     171,   597,   598,   502,    -1,   373,    -1,   348,    -1,   408,
      -1,   218,    -1,   390,    -1,   169,    -1,   135,    -1,   343,
      -1,   599,    -1,   598,   454,   599,    -1,   971,    -1,   971,
     600,    -1,   449,   839,    -1,   600,   449,   839,    -1,   388,
     734,   833,   502,    -1,   188,   603,   604,   836,   933,    -1,
     188,   603,   836,   933,    -1,   188,   604,   836,   933,    -1,
     188,   836,   933,    -1,   188,   603,   604,   836,    -1,   188,
     603,   836,    -1,   188,   604,   836,    -1,   188,   836,    -1,
     264,   603,   604,   836,    -1,   264,   836,    -1,   270,    -1,
     314,    -1,   189,    -1,   243,    -1,    78,   850,    -1,   325,
     850,    -1,   850,    -1,    85,    -1,   194,    -1,   194,   850,
      -1,   194,    85,    -1,   100,    -1,   100,   850,    -1,   100,
      85,    -1,   215,    -1,   196,    -1,   128,   293,   606,   836,
     235,   607,    -1,   128,   293,    84,   842,   583,   235,   607,
      -1,   128,   293,   198,   842,   631,   235,   607,    -1,   128,
     293,   295,   798,   447,   649,   448,   235,   607,    -1,   128,
     293,   385,   836,   293,   599,   235,   607,    -1,   128,   293,
     341,   836,   293,   599,   235,   607,    -1,   128,   293,   341,
     836,   235,   607,    -1,   128,   293,   295,   122,   599,   400,
     838,   235,   607,    -1,   128,   293,   242,   287,   855,   235,
     607,    -1,   128,   293,   115,   447,   767,    93,   767,   448,
     235,   607,    -1,   128,   293,   558,   241,   599,   235,   607,
      -1,   127,    -1,   151,    -1,   343,    -1,   218,    -1,   348,
      -1,   373,    -1,   169,    -1,   390,    -1,   408,    -1,   135,
      -1,   374,    -1,   337,    -1,   853,    -1,   284,    -1,   201,
     610,   293,   613,   381,   614,   616,    -1,   335,   610,   293,
     613,   196,   614,   502,    -1,   335,   201,   296,   191,   610,
     293,   613,   196,   614,   502,    -1,    85,   315,    -1,    85,
      -1,   611,    -1,   612,    -1,   611,   454,   612,    -1,   347,
      -1,   323,    -1,   138,    -1,   971,    -1,   833,    -1,   373,
     833,    -1,   348,   833,    -1,   198,   617,    -1,   151,   835,
      -1,   241,   835,    -1,   343,   835,    -1,   374,   835,    -1,
     615,    -1,   614,   454,   615,    -1,   858,    -1,   204,   858,
      -1,   412,   201,   296,    -1,    -1,   618,    -1,   617,   454,
     618,    -1,   842,   631,    -1,   201,   611,   381,   835,   621,
     622,    -1,   335,   611,   196,   835,   622,   502,    -1,   412,
      82,   296,    -1,    -1,   202,   109,   858,    -1,    -1,   138,
     624,   218,   840,   293,   834,   625,   447,   626,   448,   642,
     540,   764,    -1,   138,   624,   218,   131,   840,   293,   834,
     625,   447,   626,   448,   642,   540,   764,    -1,   394,    -1,
      -1,   400,   838,    -1,    -1,   627,    -1,   626,   454,   627,
      -1,   971,   628,    -1,   795,   628,    -1,   447,   792,   448,
     628,    -1,   599,    -1,   400,   599,    -1,    -1,   138,   630,
     198,   842,   631,   334,   637,   639,   642,    -1,   138,   630,
     198,   842,   631,   639,   642,    -1,   297,   329,    -1,    -1,
     447,   632,   448,    -1,   447,   448,    -1,   633,    -1,   632,
     454,   633,    -1,   634,   636,   638,    -1,   636,   634,   638,
      -1,   636,   638,    -1,   634,   638,    -1,   638,    -1,   215,
      -1,   299,    -1,   224,    -1,   215,   299,    -1,   853,    -1,
     853,   454,   853,    -1,   973,    -1,   638,    -1,   353,   972,
     600,   442,   390,    -1,   767,    -1,   972,   600,   442,   390,
      -1,   641,    -1,   639,   641,    -1,   111,   293,   284,   225,
      -1,   334,   284,   293,   284,   225,    -1,   367,    -1,   213,
      -1,   360,    -1,   409,    -1,   185,   346,   161,    -1,   185,
     346,   234,    -1,   346,   161,    -1,   346,   234,    -1,    93,
     635,    -1,   241,   489,    -1,   640,    -1,   412,   579,    -1,
      -1,    87,   198,   618,   644,   645,    -1,   640,    -1,   644,
     640,    -1,   332,    -1,    -1,   171,   198,   842,   631,   502,
      -1,   171,   198,   210,   183,   842,   631,   502,    -1,   171,
      84,   842,   583,   502,    -1,   171,    84,   210,   183,   842,
     583,   502,    -1,   171,   295,   798,   447,   649,   448,   502,
      -1,   171,   295,   210,   183,   650,   447,   649,   448,   502,
      -1,   767,    -1,   767,   454,   767,    -1,   277,   454,   767,
      -1,   767,   454,   277,    -1,   798,    -1,   971,   449,   650,
      -1,   138,   115,   447,   767,    93,   767,   448,   412,   198,
     618,   652,    -1,   138,   115,   447,   767,    93,   767,   448,
     413,   198,   652,    -1,    93,    96,    -1,    -1,   171,   115,
     654,   447,   767,    93,   767,   448,   502,    -1,   210,   183,
      -1,    -1,   324,   656,   834,   657,    -1,   324,   372,   836,
     657,    -1,   324,   151,   836,   657,    -1,   218,    -1,   373,
      -1,   192,    -1,    -1,    87,    84,   842,   583,   327,   381,
     836,    -1,    87,   135,   599,   327,   381,   836,    -1,    87,
     151,   837,   327,   381,   837,    -1,    87,   198,   842,   631,
     327,   381,   836,    -1,    87,   204,   858,   327,   381,   858,
      -1,    87,   241,   836,   327,   381,   836,    -1,    87,   295,
     122,   599,   400,   838,   327,   381,   836,    -1,    87,   343,
     836,   327,   381,   836,    -1,    87,   373,   761,   327,   381,
     836,    -1,    87,   218,   761,   327,   381,   836,    -1,    87,
     373,   761,   327,   659,   836,   381,   836,    -1,    87,   385,
     836,   293,   761,   327,   381,   836,    -1,    87,   399,   858,
     327,   381,   858,    -1,    87,   374,   836,   327,   381,   836,
      -1,   127,    -1,    -1,    87,    84,   842,   583,   352,   343,
     836,    -1,    87,   169,   599,   352,   343,   836,    -1,    87,
     198,   842,   631,   352,   343,   836,    -1,    87,   348,   761,
     352,   343,   836,    -1,    87,   373,   761,   352,   343,   836,
      -1,    87,   390,   599,   352,   343,   836,    -1,    87,    84,
     842,   583,   304,   381,   858,    -1,    87,   135,   599,   304,
     381,   858,    -1,    87,   151,   837,   304,   381,   858,    -1,
      87,   169,   837,   304,   381,   858,    -1,    87,   198,   842,
     631,   304,   381,   858,    -1,    87,   295,   650,   447,   649,
     448,   304,   381,   858,    -1,    87,   295,   122,   599,   400,
     838,   304,   381,   858,    -1,    87,   343,   836,   304,   381,
     858,    -1,    87,   390,   599,   304,   381,   858,    -1,    87,
     374,   836,   304,   381,   858,    -1,    -1,   138,   630,   341,
     836,    93,   663,   293,   668,   381,   834,   764,   168,   669,
     664,    -1,   280,    -1,   666,    -1,   447,   665,   448,    -1,
     665,   450,   667,    -1,   667,    -1,   727,    -1,   706,    -1,
     717,    -1,   711,    -1,   671,    -1,   666,    -1,    -1,   347,
      -1,   398,    -1,   162,    -1,   227,    -1,   228,    -1,    86,
      -1,    -1,   171,   341,   836,   293,   834,   502,    -1,   171,
     341,   210,   183,   836,   293,   834,   502,    -1,   281,   834,
      -1,   250,   834,    -1,   396,   834,    -1,   396,   440,    -1,
      77,   675,    -1,   102,   675,   678,    -1,   361,   383,   678,
      -1,   129,   675,    -1,   177,   675,    -1,   338,   675,    -1,
     342,   971,    -1,   326,   342,   971,    -1,   326,   971,    -1,
     338,   675,   381,   342,   971,    -1,   338,   675,   381,   971,
      -1,   311,   383,   853,    -1,   129,   312,   853,    -1,   338,
     312,   853,    -1,   414,    -1,   383,    -1,    -1,   237,   247,
     484,    -1,   319,   294,    -1,   319,   415,    -1,   676,    -1,
     677,   454,   676,    -1,   677,   676,    -1,   677,    -1,    -1,
     138,   515,   408,   834,   529,    93,   727,   680,    -1,   138,
     297,   329,   515,   408,   834,   529,    93,   727,   680,    -1,
     420,   296,    -1,   418,   120,   296,    -1,   419,   120,   296,
      -1,    -1,   251,   841,    -1,   138,   151,   837,   412,   683,
      -1,   138,   151,   837,    -1,   684,    -1,   683,   684,    -1,
     374,   685,   836,    -1,   374,   685,   157,    -1,   255,   685,
     853,    -1,   255,   685,   157,    -1,   376,   685,   836,    -1,
     376,   685,   157,    -1,   175,   685,   854,    -1,   175,   685,
     157,    -1,   132,   249,   685,   849,    -1,   304,   685,   836,
      -1,   304,   685,   157,    -1,   434,    -1,    -1,    87,   151,
     837,   463,   688,    -1,    87,   151,   837,   352,   480,    -1,
      87,   151,   837,   491,    -1,   688,   689,    -1,    -1,   132,
     249,   685,   849,    -1,   171,   151,   837,    -1,   171,   151,
     210,   183,   837,    -1,   138,   169,   599,   693,   767,   520,
      -1,    87,   169,   599,   501,    -1,    87,   169,   599,   171,
     279,   284,    -1,    87,   169,   599,   352,   279,   284,    -1,
      87,   169,   599,    81,   527,    -1,    87,   169,   599,   171,
     133,   836,   502,    -1,    93,    -1,    -1,   138,   591,   135,
     599,   191,   853,   381,   853,   196,   599,    -1,   124,   840,
     293,   834,    -1,   124,   834,    -1,   124,    -1,   401,   700,
     701,   699,    -1,   401,   700,   701,   699,   834,    -1,   401,
     700,   701,   699,   697,    -1,   698,   699,    -1,   698,   699,
     834,   702,    -1,    89,    -1,    88,    -1,   407,    -1,    -1,
     197,    -1,    -1,   195,    -1,    -1,   447,   835,   448,    -1,
      -1,   184,   705,   699,   704,    -1,   727,    -1,   706,    -1,
     717,    -1,   711,    -1,   724,    -1,   698,    -1,    -1,   227,
     233,   834,   707,   710,    -1,   727,    -1,   447,   708,   448,
     727,    -1,   157,   404,    -1,   708,   454,   709,    -1,   709,
      -1,   971,   825,    -1,   333,   830,    -1,    -1,   162,   196,
     762,   712,   764,   710,    -1,   400,   754,    -1,    -1,   256,
     734,   833,   714,   716,    -1,   215,   715,   262,    -1,    -1,
      79,   354,    -1,   339,   354,    -1,   339,   180,    -1,   354,
     398,   180,    -1,   354,    -1,   354,   339,   180,    -1,   180,
      -1,    79,   180,    -1,   283,    -1,    -1,   398,   762,   352,
     718,   753,   764,   710,    -1,   719,    -1,   718,   454,   719,
      -1,   720,    -1,   721,    -1,   722,   434,   827,    -1,   447,
     723,   448,   434,   829,    -1,   971,   825,    -1,   722,    -1,
     723,   454,   722,    -1,   156,   836,   725,   149,   726,   191,
     727,    -1,    -1,   725,   105,    -1,   725,   226,    -1,   725,
     344,    -1,   725,   271,   344,    -1,    -1,   412,   208,    -1,
     413,   208,    -1,   729,    -1,   728,    -1,   447,   729,   448,
      -1,   447,   728,   448,    -1,   731,    -1,   730,   738,    -1,
     730,   737,   747,   742,    -1,   730,   737,   741,   748,    -1,
     731,    -1,   728,    -1,   347,   736,   830,   732,   753,   764,
     745,   746,    -1,   752,    -1,   730,   393,   735,   730,    -1,
     730,   231,   735,   730,    -1,   730,   179,   735,   730,    -1,
     233,   733,    -1,   933,    -1,    -1,   377,   734,   834,    -1,
     375,   734,   834,    -1,   252,   377,   734,   834,    -1,   252,
     375,   734,   834,    -1,   200,   377,   734,   834,    -1,   200,
     375,   734,   834,    -1,   373,   834,    -1,   834,    -1,   373,
      -1,    -1,    85,    -1,    -1,   167,    -1,   167,   293,   447,
     803,   448,    -1,    85,    -1,    -1,   738,    -1,    -1,   298,
     109,   739,    -1,   740,    -1,   739,   454,   740,    -1,   792,
     400,   801,    -1,   792,    94,    -1,   792,   165,    -1,   792,
      -1,   249,   743,   290,   744,    -1,   290,   744,   249,   743,
      -1,   249,   743,    -1,   290,   744,    -1,   249,   743,   454,
     744,    -1,   741,    -1,    -1,   792,    -1,    85,    -1,   792,
      -1,   204,   109,   803,    -1,    -1,   206,   792,    -1,    -1,
     749,    -1,   191,   319,   294,    -1,   747,    -1,    -1,   750,
      -1,   749,   750,    -1,   191,   398,   751,   716,    -1,   191,
     354,   751,   716,    -1,   288,   835,    -1,    -1,   404,   829,
      -1,   752,   454,   829,    -1,   196,   754,    -1,    -1,   754,
     454,   755,    -1,   755,    -1,   761,    -1,   761,   757,    -1,
     763,    -1,   763,   757,    -1,   763,    93,   447,   765,   448,
      -1,   763,    93,   971,   447,   765,   448,    -1,   763,   971,
     447,   765,   448,    -1,   728,    -1,   728,   757,    -1,   756,
      -1,   447,   756,   448,   757,    -1,   447,   756,   448,    -1,
     755,   142,   238,   755,    -1,   755,   758,   238,   755,   760,
      -1,   755,   238,   755,   760,    -1,   755,   267,   758,   238,
     755,    -1,   755,   267,   238,   755,    -1,    93,   971,   447,
     835,   448,    -1,    93,   971,    -1,   971,   447,   835,   448,
      -1,   971,    -1,   197,   759,    -1,   246,   759,    -1,   336,
     759,    -1,   223,    -1,   300,    -1,    -1,   400,   447,   835,
     448,    -1,   293,   792,    -1,   834,    -1,   834,   440,    -1,
     294,   834,    -1,   294,   447,   834,   448,    -1,   761,    -1,
     761,   971,    -1,   761,    93,   971,    -1,   795,    -1,   411,
     792,    -1,    -1,   766,    -1,   765,   454,   766,    -1,   971,
     767,    -1,   770,   768,    -1,   353,   770,   768,    -1,   770,
      92,   445,   849,   446,    -1,   353,   770,    92,   445,   849,
     446,    -1,   445,   446,   768,    -1,   445,   769,   446,   768,
      -1,    -1,   849,    -1,   447,   769,   448,    -1,   769,   438,
     769,    -1,   769,   439,   769,    -1,   769,   440,   769,    -1,
     769,   441,   769,    -1,   769,   442,   769,    -1,   848,    -1,
     971,    -1,   772,    -1,   788,    -1,   773,    -1,   777,    -1,
     781,    -1,   789,   791,    -1,   789,   447,   849,   448,   791,
      -1,   972,   600,    -1,   772,    -1,   788,    -1,   773,    -1,
     778,    -1,   782,    -1,   972,    -1,   229,    -1,   230,    -1,
     358,    -1,   104,    -1,   320,    -1,   190,   774,    -1,   170,
     309,    -1,   155,   776,    -1,   154,   776,    -1,   286,   775,
      -1,   107,    -1,   447,   849,   448,    -1,    -1,   447,   849,
     454,   849,   448,    -1,   447,   849,   448,    -1,    -1,   447,
     849,   454,   849,   448,    -1,   447,   849,   448,    -1,    -1,
     779,    -1,   780,    -1,   779,    -1,   780,    -1,   106,   786,
     447,   849,   448,    -1,   106,   786,    -1,   783,    -1,   784,
      -1,   783,    -1,   784,    -1,   785,   447,   849,   448,   787,
      -1,   785,   787,    -1,   118,   786,    -1,   117,   786,    -1,
     405,    -1,   266,   118,   786,    -1,   266,   117,   786,    -1,
     268,   786,    -1,   406,    -1,    -1,   118,   352,   971,    -1,
      -1,   380,   447,   849,   448,   790,    -1,   380,   790,    -1,
     379,   447,   849,   448,   790,    -1,   379,   790,    -1,   232,
      -1,   412,   379,   417,    -1,   413,   379,   417,    -1,    -1,
     416,    -1,   263,    -1,   152,    -1,   209,    -1,   260,    -1,
     345,    -1,   416,   381,   263,    -1,   152,   381,   209,    -1,
     152,   381,   260,    -1,   152,   381,   345,    -1,   209,   381,
     260,    -1,   260,   381,   345,    -1,   209,   381,   345,    -1,
      -1,   794,    -1,   792,    76,   767,    -1,   792,    98,   379,
     417,   792,    -1,   438,   792,    -1,   439,   792,    -1,   792,
     438,   792,    -1,   792,   439,   792,    -1,   792,   440,   792,
      -1,   792,   441,   792,    -1,   792,   442,   792,    -1,   792,
     443,   792,    -1,   792,   435,   792,    -1,   792,   436,   792,
      -1,   792,   434,   792,    -1,   792,   800,   792,    -1,   800,
     792,    -1,   792,   800,    -1,   792,    90,   792,    -1,   792,
     297,   792,    -1,   279,   792,    -1,   792,   248,   792,    -1,
     792,   248,   792,   178,   792,    -1,   792,   279,   248,   792,
      -1,   792,   279,   248,   792,   178,   792,    -1,   792,   211,
     792,    -1,   792,   211,   792,   178,   792,    -1,   792,   279,
     211,   792,    -1,   792,   279,   211,   792,   178,   792,    -1,
     792,   356,   381,   792,    -1,   792,   356,   381,   792,   178,
     792,    -1,   792,   279,   356,   381,   792,    -1,   792,   279,
     356,   381,   792,   178,   792,    -1,   792,   236,    -1,   792,
     235,   284,    -1,   792,   282,    -1,   792,   235,   279,   284,
      -1,   796,   301,   796,    -1,   792,   235,   387,    -1,   792,
     235,   279,   387,    -1,   792,   235,   187,    -1,   792,   235,
     279,   187,    -1,   792,   235,   395,    -1,   792,   235,   279,
     395,    -1,   792,   235,   167,   196,   792,    -1,   792,   235,
     279,   167,   196,   792,    -1,   792,   235,   288,   447,   805,
     448,    -1,   792,   235,   279,   288,   447,   805,   448,    -1,
     792,   103,   826,   793,    90,   793,    -1,   792,   279,   103,
     826,   793,    90,   793,    -1,   792,   103,   370,   793,    90,
     793,    -1,   792,   279,   103,   370,   793,    90,   793,    -1,
     792,   215,   816,    -1,   792,   279,   215,   816,    -1,   792,
     802,   797,   728,    -1,   792,   802,   797,   447,   792,   448,
      -1,   394,   728,    -1,   794,    -1,   793,    76,   767,    -1,
     439,   793,    -1,   793,   438,   793,    -1,   793,   439,   793,
      -1,   793,   440,   793,    -1,   793,   441,   793,    -1,   793,
     442,   793,    -1,   793,   443,   793,    -1,   793,   435,   793,
      -1,   793,   436,   793,    -1,   793,   434,   793,    -1,   793,
     423,   793,    -1,   800,   793,    -1,   793,   800,    -1,   793,
     235,   167,   196,   793,    -1,   793,   235,   279,   167,   196,
     793,    -1,   793,   235,   288,   447,   793,   448,    -1,   793,
     235,   279,   288,   447,   793,   448,    -1,   822,    -1,   843,
      -1,   432,   825,    -1,   447,   792,   448,   825,    -1,   817,
      -1,   795,    -1,   728,    -1,   183,   728,    -1,    92,   728,
      -1,    92,   807,    -1,   796,    -1,   842,   447,   448,    -1,
     842,   447,   803,   448,    -1,   842,   447,    85,   803,   448,
      -1,   842,   447,   167,   803,   448,    -1,   842,   447,   440,
     448,    -1,   144,    -1,   146,    -1,   146,   447,   849,   448,
      -1,   147,    -1,   147,   447,   849,   448,    -1,   253,    -1,
     253,   447,   849,   448,    -1,   254,    -1,   254,   447,   849,
     448,    -1,   145,    -1,   148,    -1,   351,    -1,   399,    -1,
     115,   447,   792,    93,   767,   448,    -1,   186,   447,   804,
     448,    -1,   302,   447,   809,   448,    -1,   308,   447,   811,
     448,    -1,   368,   447,   812,   448,    -1,   384,   447,   792,
      93,   767,   448,    -1,   386,   447,   108,   815,   448,    -1,
     386,   447,   244,   815,   448,    -1,   386,   447,   382,   815,
     448,    -1,   386,   447,   815,   448,    -1,   136,   447,   792,
     400,   599,   448,    -1,   136,   447,   803,   448,    -1,   285,
     447,   792,   454,   792,   448,    -1,   125,   447,   803,   448,
      -1,   203,   447,   803,   448,    -1,   245,   447,   803,   448,
      -1,   339,   447,   803,   448,    -1,   339,   447,   448,    -1,
     447,   803,   454,   792,   448,    -1,    91,    -1,   359,    -1,
      85,    -1,   423,    -1,   799,    -1,   438,    -1,   439,    -1,
     440,    -1,   442,    -1,   443,    -1,   441,    -1,   435,    -1,
     436,    -1,   434,    -1,   423,    -1,   295,   447,   650,   448,
      -1,   798,    -1,   295,   447,   650,   448,    -1,   798,    -1,
     295,   447,   650,   448,    -1,   248,    -1,   279,   248,    -1,
     211,    -1,   279,   211,    -1,   792,    -1,   803,   454,   792,
      -1,   808,   196,   792,    -1,    -1,   805,   454,   767,    -1,
     767,    -1,   807,    -1,   806,   454,   807,    -1,   445,   803,
     446,    -1,   445,   806,   446,    -1,   993,    -1,   416,    -1,
     263,    -1,   152,    -1,   209,    -1,   260,    -1,   345,    -1,
     853,    -1,   792,   810,   813,   814,    -1,   792,   810,   813,
      -1,   307,   792,    -1,   793,   215,   793,    -1,    -1,   792,
     813,   814,    -1,   792,   814,   813,    -1,   792,   813,    -1,
     792,   814,    -1,   803,    -1,    -1,   196,   792,    -1,   191,
     792,    -1,   792,   196,   803,    -1,   196,   803,    -1,   803,
      -1,   728,    -1,   447,   803,   448,    -1,   114,   821,   818,
     820,   177,    -1,   818,   819,    -1,   819,    -1,   410,   792,
     378,   792,    -1,   173,   792,    -1,    -1,   792,    -1,    -1,
     832,    -1,   832,   824,    -1,   449,   839,    -1,   449,   440,
      -1,   445,   792,   446,    -1,   445,   792,   455,   792,   446,
      -1,   823,    -1,   824,   823,    -1,    -1,   825,   823,    -1,
      97,    -1,    -1,   792,    -1,   157,    -1,   827,    -1,   828,
     454,   827,    -1,   447,   828,   448,    -1,   830,   454,   831,
      -1,   831,    -1,   792,    93,   974,    -1,   792,    -1,   440,
      -1,   859,    -1,   971,    -1,   834,    -1,   833,   454,   834,
      -1,   832,    -1,   832,   824,    -1,   836,    -1,   835,   454,
     836,    -1,   971,    -1,   971,    -1,   971,    -1,   974,    -1,
     971,    -1,   853,    -1,   973,    -1,   832,   824,    -1,   857,
      -1,   771,   853,    -1,   789,   853,   791,    -1,   789,   447,
     849,   448,   853,   791,    -1,   387,    -1,   187,    -1,   284,
      -1,   989,    -1,   431,    -1,   433,    -1,   428,    -1,   429,
      -1,   422,    -1,   430,    -1,   844,    -1,   990,    -1,   849,
      -1,   439,   849,    -1,   844,    -1,   992,    -1,   845,    -1,
     851,    -1,   439,   845,    -1,   439,   844,    -1,   848,    -1,
     848,    -1,   990,    -1,   844,    -1,   848,    -1,   990,    -1,
     845,    -1,   844,    -1,   439,   845,    -1,   439,   844,    -1,
     990,    -1,   848,    -1,   855,    -1,   848,    -1,   845,    -1,
     844,    -1,   846,    -1,   847,    -1,   990,    -1,   971,    -1,
     292,    -1,   269,    -1,     9,   381,   861,   868,   869,    -1,
       9,   381,   157,    -1,     9,   870,    -1,   151,   861,    -1,
     862,   865,   867,    -1,   863,   455,   864,   867,   441,   862,
     873,    -1,   872,    -1,   848,    -1,   837,    -1,    -1,   993,
     992,    -1,   423,   866,    -1,   864,    -1,    -1,   971,    -1,
     971,   449,   866,    -1,   427,    -1,   455,   849,    -1,    -1,
      93,   920,    -1,    -1,   399,   870,    -1,    -1,   871,    -1,
     871,   441,   871,    -1,   871,    24,   109,   871,    -1,   871,
     400,   871,    -1,   858,    -1,   853,    -1,   992,    -1,   423,
     971,    -1,    -1,   156,   836,   725,   149,   726,   191,   925,
      -1,   153,   311,   925,    -1,   153,   925,    -1,   877,    -1,
     891,    -1,   878,    -1,    -1,   897,   900,   879,   913,   450,
      -1,    -1,   900,   880,   913,   450,    -1,   903,   450,    -1,
     855,    -1,   454,   855,    -1,    -1,   791,    -1,   416,   381,
     260,    -1,   416,   381,   345,    -1,   152,   381,   152,    -1,
     263,   381,   263,    -1,    -1,   886,   885,   888,   887,    -1,
     986,   102,   156,    38,   450,    -1,   986,   177,   156,    38,
     450,    -1,    -1,   889,    -1,   426,    -1,   893,    -1,   891,
      -1,   889,   893,    -1,   889,   891,    -1,   889,   426,    -1,
     893,    -1,   890,   893,    -1,    -1,    75,   892,   900,   916,
     975,   768,   450,    -1,    -1,   897,   900,   894,   913,   450,
      -1,    -1,   900,   895,   913,   450,    -1,   903,   450,    -1,
     455,   844,    -1,    -1,   898,   899,    -1,   898,    -1,   899,
      -1,    61,    -1,    72,    -1,    70,    -1,    55,    -1,    56,
      -1,    74,    -1,   909,    -1,   905,    -1,   901,    -1,   975,
     447,   881,   882,   448,    -1,   975,   883,    -1,   907,    -1,
      19,   969,   902,    -1,    19,   902,    -1,    19,   969,    -1,
     451,   997,   452,    -1,    -1,   907,   904,   451,   890,   452,
      -1,   903,    -1,    -1,   908,   906,   451,   890,   452,    -1,
      47,   969,    -1,   393,   969,    -1,    47,    -1,   393,    -1,
     910,    -1,   912,   911,    -1,    48,    39,    -1,    48,    39,
     229,    -1,    48,    -1,    48,   229,    -1,    48,    28,    -1,
      48,    28,   229,    -1,    48,    28,    28,    -1,    48,    28,
      28,   229,    -1,    48,   117,    -1,    39,    -1,    39,   229,
      -1,   229,    -1,    28,    -1,    28,   229,    -1,    28,    28,
      -1,    28,    28,   229,    -1,     5,    -1,   117,    -1,   170,
      -1,    40,    -1,    -1,   914,    -1,   913,   454,   914,    -1,
     916,   976,   768,   896,   915,    -1,    -1,   434,   998,    -1,
      -1,   440,    -1,   440,   440,    -1,   156,   362,   993,    -1,
      18,   919,    -1,   920,    -1,    12,    -1,    85,    -1,    -1,
     837,    -1,   157,    -1,   872,    -1,   182,   212,   924,    -1,
      -1,   182,   925,   922,   923,    -1,   929,   933,    -1,   933,
     929,    -1,   929,    -1,   933,    -1,    -1,   872,    -1,   424,
      -1,   836,    -1,   872,    -1,    21,   836,    -1,    32,   836,
     928,    -1,    -1,   929,    -1,   400,   934,    -1,   930,    -1,
     400,   932,    17,   994,    -1,   233,   932,    17,   994,    -1,
      -1,    41,    -1,   233,   985,    -1,   931,    -1,   935,    -1,
     935,   454,   934,    -1,   856,    -1,   989,    -1,   311,   925,
     196,   924,    -1,    16,   225,   836,   930,    -1,    16,   938,
     836,   930,    -1,    16,   938,   836,   931,    -1,    33,    -1,
      -1,     3,    17,   994,    -1,   153,    17,   994,    -1,   199,
      17,   994,   942,    -1,   943,    -1,   942,   454,   943,    -1,
     992,   434,   947,    -1,   352,    17,   994,   945,    -1,   946,
      -1,   945,   454,   946,    -1,   947,   434,   851,    -1,    11,
      -1,   199,    17,   994,    49,   851,   949,    -1,   950,    -1,
     949,   454,   950,    -1,   992,   434,   954,    -1,   352,    17,
     994,    49,   851,   952,    -1,   953,    -1,   952,   454,   953,
      -1,   954,   434,   852,    -1,     8,    -1,    13,    -1,    14,
      -1,    15,    -1,    25,    -1,    26,    -1,    27,    -1,    29,
      -1,    30,    -1,    31,    -1,   309,    -1,    35,    -1,    36,
      -1,    37,    -1,   390,    -1,   352,     4,   434,   956,    -1,
     352,     4,   381,   956,    -1,   293,    -1,   289,    -1,   352,
     132,   381,   920,    -1,   352,   132,   434,   920,    -1,   352,
     132,   920,    -1,    -1,   390,   959,   975,   235,   900,   768,
     960,    -1,    34,    -1,    -1,    -1,    50,   962,   974,   235,
     900,   768,   960,    -1,    51,    42,   964,    -1,    51,   279,
      20,   964,    -1,    51,    44,   964,    -1,    10,    -1,    43,
      -1,    46,    -1,    23,   836,    -1,    22,   381,   836,    -1,
     168,   836,   447,   987,   448,    -1,   168,     6,    -1,     7,
     836,   447,   987,   448,    -1,     7,   836,    -1,   966,    -1,
     967,    -1,     6,    -1,     7,    -1,     8,    -1,    10,    -1,
      11,    -1,    13,    -1,    14,    -1,    15,    -1,    20,    -1,
      22,    -1,    23,    -1,    24,    -1,    25,    -1,    26,    -1,
      27,    -1,    29,    -1,    30,    -1,    31,    -1,    35,    -1,
      36,    -1,    37,    -1,    38,    -1,    42,    -1,    43,    -1,
      44,    -1,    46,    -1,    49,    -1,     9,    -1,    16,    -1,
      18,    -1,    32,    -1,    50,    -1,    51,    -1,     5,    -1,
      28,    -1,    33,    -1,    39,    -1,    47,    -1,    40,    -1,
      48,    -1,   974,    -1,   993,    -1,   979,    -1,   981,    -1,
     982,    -1,   965,    -1,   977,    -1,   117,    -1,   404,    -1,
     993,    -1,   978,    -1,   982,    -1,   965,    -1,   977,    -1,
     117,    -1,   404,    -1,   993,    -1,   978,    -1,   965,    -1,
     968,    -1,   977,    -1,   993,    -1,   978,    -1,   983,    -1,
     965,    -1,   977,    -1,   976,    -1,   968,    -1,   117,    -1,
     225,    -1,   229,    -1,   393,    -1,   381,    -1,   977,    -1,
     979,    -1,   993,    -1,   982,    -1,   983,    -1,   966,    -1,
     975,    -1,   984,    -1,   980,    -1,   967,    -1,    55,    -1,
      56,    -1,    61,    -1,    70,    -1,    72,    -1,    75,    -1,
      74,    -1,   979,    -1,   980,    -1,   152,    -1,   209,    -1,
     260,    -1,   263,    -1,   345,    -1,   416,    -1,   981,    -1,
     132,    -1,    77,    -1,    78,    -1,    79,    -1,    80,    -1,
      81,    -1,    82,    -1,    83,    -1,    84,    -1,    86,    -1,
      87,    -1,    95,    -1,    96,    -1,    98,    -1,   100,    -1,
     101,    -1,   102,    -1,   109,    -1,   110,    -1,   112,    -1,
     113,    -1,   116,    -1,   119,    -1,   121,    -1,   122,    -1,
     123,    -1,   124,    -1,   128,    -1,   129,    -1,   130,    -1,
     131,    -1,   134,    -1,   135,    -1,   137,    -1,   139,    -1,
     140,    -1,   141,    -1,   143,    -1,   149,    -1,   150,    -1,
     151,    -1,   153,    -1,   156,    -1,   158,    -1,   160,    -1,
     162,    -1,   163,    -1,   164,    -1,   166,    -1,   169,    -1,
     170,    -1,   171,    -1,   172,    -1,   174,    -1,   175,    -1,
     176,    -1,   178,    -1,   181,    -1,   180,    -1,   182,    -1,
     184,    -1,   188,    -1,   189,    -1,   192,    -1,   194,    -1,
     198,    -1,   200,    -1,   202,    -1,   205,    -1,   207,    -1,
     208,    -1,   210,    -1,   212,    -1,   213,    -1,   214,    -1,
     216,    -1,   217,    -1,   218,    -1,   219,    -1,   220,    -1,
     221,    -1,   226,    -1,   227,    -1,   228,    -1,   237,    -1,
     239,    -1,   240,    -1,   241,    -1,   242,    -1,   243,    -1,
     247,    -1,   250,    -1,   251,    -1,   252,    -1,   255,    -1,
     256,    -1,   257,    -1,   258,    -1,   259,    -1,   261,    -1,
     262,    -1,   264,    -1,   265,    -1,   270,    -1,   271,    -1,
     272,    -1,   273,    -1,   274,    -1,   275,    -1,   276,    -1,
     278,    -1,   280,    -1,   281,    -1,   283,    -1,   287,    -1,
     288,    -1,   291,    -1,   295,    -1,   296,    -1,   303,    -1,
     304,    -1,   305,    -1,   306,    -1,   311,    -1,   312,    -1,
     310,    -1,   314,    -1,   315,    -1,   316,    -1,   317,    -1,
     318,    -1,   319,    -1,   321,    -1,   322,    -1,   324,    -1,
     325,    -1,   326,    -1,   327,    -1,   328,    -1,   329,    -1,
     330,    -1,   331,    -1,   332,    -1,   334,    -1,   335,    -1,
     337,    -1,   338,    -1,   340,    -1,   341,    -1,   342,    -1,
     343,    -1,   344,    -1,   348,    -1,   349,    -1,   350,    -1,
     352,    -1,   354,    -1,   355,    -1,   357,    -1,   360,    -1,
     361,    -1,   362,    -1,   363,    -1,   364,    -1,   365,    -1,
     366,    -1,   369,    -1,   367,    -1,   372,    -1,   371,    -1,
     374,    -1,   375,    -1,   376,    -1,   377,    -1,   383,    -1,
     385,    -1,   388,    -1,   389,    -1,   390,    -1,   391,    -1,
     392,    -1,   395,    -1,   396,    -1,   397,    -1,   398,    -1,
     401,    -1,   402,    -1,   406,    -1,   408,    -1,   412,    -1,
     413,    -1,   414,    -1,   415,    -1,   417,    -1,   104,    -1,
     106,    -1,   118,    -1,   125,    -1,   136,    -1,   154,    -1,
     155,    -1,   183,    -1,   186,    -1,   190,    -1,   203,    -1,
     224,    -1,   230,    -1,   232,    -1,   245,    -1,   266,    -1,
     268,    -1,   277,    -1,   285,    -1,   286,    -1,   299,    -1,
     302,    -1,   308,    -1,   309,    -1,   320,    -1,   339,    -1,
     353,    -1,   358,    -1,   368,    -1,   379,    -1,   380,    -1,
     384,    -1,   386,    -1,   405,    -1,    99,    -1,   103,    -1,
     105,    -1,   142,    -1,   195,    -1,   197,    -1,   211,    -1,
     223,    -1,   235,    -1,   236,    -1,   238,    -1,   246,    -1,
     248,    -1,   267,    -1,   282,    -1,   300,    -1,   301,    -1,
     336,    -1,   356,    -1,   407,    -1,    85,    -1,    88,    -1,
      89,    -1,    90,    -1,    91,    -1,    92,    -1,    93,    -1,
      94,    -1,    97,    -1,   108,    -1,   114,    -1,   115,    -1,
     120,    -1,   126,    -1,   127,    -1,   133,    -1,   138,    -1,
     144,    -1,   146,    -1,   147,    -1,   145,    -1,   148,    -1,
     157,    -1,   159,    -1,   165,    -1,   167,    -1,   168,    -1,
     173,    -1,   177,    -1,   179,    -1,   187,    -1,   191,    -1,
     193,    -1,   196,    -1,   201,    -1,   204,    -1,   206,    -1,
     215,    -1,   222,    -1,   231,    -1,   233,    -1,   244,    -1,
     249,    -1,   269,    -1,   279,    -1,   284,    -1,   289,    -1,
     290,    -1,   292,    -1,   293,    -1,   294,    -1,   297,    -1,
     298,    -1,   313,    -1,   323,    -1,   333,    -1,   347,    -1,
     351,    -1,   359,    -1,   370,    -1,   373,    -1,   378,    -1,
     382,    -1,   387,    -1,   394,    -1,   399,    -1,   400,    -1,
     410,    -1,   411,    -1,   988,    -1,   985,   454,   988,    -1,
      45,    -1,    -1,   997,    -1,   992,   991,    -1,   992,    -1,
     992,   991,    -1,   992,    -1,   992,    -1,    25,   992,    -1,
      25,   836,    -1,   425,    -1,   421,    -1,   424,    -1,   836,
      -1,   872,    -1,  1000,    -1,   447,   448,    -1,   447,   996,
     448,    -1,   995,    -1,   996,   995,    -1,   998,    -1,   997,
     454,   998,    -1,   996,    -1,   451,   997,   452,    -1,  1000,
      -1,   447,    -1,   448,    -1,   454,    -1,   450,    -1,   421,
      -1,   424,    -1,   844,    -1,   845,    -1,   848,    -1,   440,
      -1,   438,    -1,   439,    -1,   441,    -1,   442,    -1,   284,
      -1,    52,    -1,    53,    -1,    54,    -1,    55,    -1,    56,
      -1,    57,    -1,    58,    -1,    59,    -1,    60,    -1,    61,
      -1,    62,    -1,    63,    -1,    65,    -1,    64,    -1,    66,
      -1,    67,    -1,    68,    -1,    69,    -1,    70,    -1,    71,
      -1,    72,    -1,    73,    -1,    75,    -1,    74,    -1,     5,
      -1,    19,    -1,   209,    -1,   229,    -1,    28,    -1,   260,
      -1,   263,    -1,   345,    -1,    39,    -1,    40,    -1,    47,
      -1,    48,    -1,   416,    -1,   117,    -1,   190,    -1,   381,
      -1,   393,    -1,   405,    -1,   445,    -1,   446,    -1,   434,
      -1,   455,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   610,   610,   612,   613,   616,   617,   618,   624,   625,
     626,   627,   628,   631,   643,   644,   645,   646,   647,   648,
     649,   650,   651,   652,   653,   654,   655,   656,   657,   681,
     682,   683,   684,   685,   686,   687,   688,   689,   690,   691,
     692,   693,   694,   695,   696,   697,   698,   699,   700,   701,
     703,   704,   705,   706,   707,   708,   709,   710,   711,   712,
     713,   714,   715,   716,   717,   718,   719,   721,   722,   723,
     724,   725,   726,   727,   728,   729,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   747,   748,   749,
     750,   751,   752,   753,   754,   755,   761,   771,   775,   783,
     791,   795,   806,   816,   820,   827,   834,   840,   851,   861,
     867,   876,   883,   889,   898,   905,   926,   930,   931,   940,
     941,   942,   943,   944,   945,   946,   947,   948,   949,   950,
     951,   952,   953,   954,   955,   956,   957,   958,   959,   960,
     961,   971,   982,   986,   988,   998,  1001,  1003,  1013,  1015,
    1025,  1027,  1038,  1048,  1052,  1053,  1062,  1064,  1075,  1077,
    1081,  1082,  1085,  1086,  1093,  1094,  1095,  1096,  1097,  1098,
    1111,  1113,  1115,  1119,  1121,  1123,  1125,  1127,  1129,  1131,
    1133,  1135,  1139,  1140,  1144,  1146,  1150,  1152,  1156,  1157,
    1158,  1159,  1162,  1163,  1164,  1167,  1168,  1169,  1170,  1180,
    1181,  1182,  1184,  1186,  1188,  1192,  1193,  1194,  1197,  1198,
    1201,  1203,  1205,  1207,  1209,  1213,  1215,  1217,  1219,  1221,
    1225,  1229,  1231,  1235,  1236,  1242,  1253,  1255,  1261,  1262,
    1266,  1270,  1273,  1276,  1279,  1282,  1285,  1288,  1291,  1294,
    1297,  1300,  1303,  1306,  1309,  1312,  1315,  1318,  1321,  1324,
    1327,  1329,  1333,  1334,  1340,  1343,  1345,  1347,  1352,  1353,
    1356,  1357,  1358,  1361,  1362,  1372,  1376,  1388,  1397,  1398,
    1401,  1402,  1403,  1406,  1407,  1410,  1411,  1412,  1414,  1416,
    1417,  1418,  1420,  1422,  1424,  1429,  1430,  1433,  1434,  1441,
    1444,  1447,  1448,  1458,  1461,  1471,  1472,  1473,  1474,  1475,
    1476,  1477,  1481,  1484,  1486,  1488,  1492,  1493,  1494,  1497,
    1501,  1502,  1505,  1507,  1508,  1522,  1524,  1526,  1528,  1530,
    1532,  1534,  1549,  1550,  1551,  1552,  1555,  1559,  1561,  1565,
    1566,  1567,  1568,  1569,  1570,  1577,  1579,  1583,  1585,  1587,
    1589,  1594,  1595,  1598,  1600,  1604,  1607,  1609,  1615,  1618,
    1619,  1620,  1621,  1622,  1625,  1629,  1633,  1634,  1635,  1636,
    1637,  1640,  1643,  1646,  1647,  1648,  1649,  1652,  1653,  1654,
    1655,  1658,  1659,  1662,  1663,  1672,  1671,  1682,  1685,  1688,
    1690,  1694,  1705,  1709,  1713,  1714,  1717,  1719,  1721,  1723,
    1725,  1727,  1729,  1731,  1733,  1735,  1737,  1741,  1742,  1753,
    1755,  1760,  1761,  1768,  1769,  1772,  1775,  1777,  1780,  1783,
    1785,  1789,  1790,  1800,  1804,  1805,  1819,  1821,  1834,  1838,
    1845,  1846,  1849,  1851,  1853,  1857,  1858,  1859,  1862,  1865,
    1868,  1869,  1872,  1873,  1876,  1878,  1881,  1884,  1885,  1888,
    1889,  1892,  1893,  1900,  1901,  1909,  1914,  1916,  1920,  1922,
    1926,  1928,  1939,  1947,  1962,  1964,  1966,  1968,  1970,  1972,
    1976,  1980,  1981,  1984,  1985,  1989,  1990,  1991,  1992,  1993,
    1996,  1997,  2001,  2002,  2005,  2008,  2009,  2012,  2016,  2023,
    2024,  2027,  2029,  2031,  2033,  2037,  2038,  2041,  2042,  2045,
    2047,  2060,  2065,  2077,  2079,  2083,  2084,  2085,  2086,  2087,
    2088,  2089,  2090,  2093,  2095,  2099,  2100,  2103,  2104,  2113,
    2128,  2133,  2138,  2143,  2148,  2153,  2158,  2163,  2168,  2170,
    2174,  2175,  2176,  2177,  2178,  2179,  2180,  2181,  2182,  2183,
    2184,  2185,  2186,  2187,  2190,  2191,  2194,  2196,  2198,  2200,
    2202,  2204,  2206,  2208,  2210,  2212,  2214,  2218,  2219,  2220,
    2221,  2222,  2223,  2224,  2225,  2226,  2227,  2228,  2229,  2232,
    2233,  2243,  2247,  2249,  2253,  2254,  2255,  2258,  2260,  2264,
    2265,  2266,  2267,  2270,  2272,  2274,  2276,  2278,  2280,  2282,
    2284,  2288,  2290,  2294,  2295,  2298,  2303,  2306,  2308,  2312,
    2321,  2326,  2330,  2331,  2334,  2335,  2351,  2354,  2359,  2360,
    2363,  2366,  2369,  2370,  2373,  2375,  2377,  2381,  2382,  2383,
    2386,  2389,  2394,  2395,  2398,  2400,  2404,  2406,  2410,  2411,
    2412,  2413,  2414,  2417,  2418,  2419,  2420,  2423,  2425,  2429,
    2431,  2439,  2443,  2445,  2450,  2452,  2457,  2459,  2461,  2463,
    2465,  2467,  2469,  2471,  2473,  2475,  2478,  2480,  2482,  2486,
    2487,  2491,  2495,  2496,  2499,  2500,  2513,  2515,  2519,  2521,
    2525,  2527,  2531,  2533,  2535,  2537,  2542,  2544,  2548,  2551,
    2556,  2557,  2561,  2565,  2566,  2576,  2578,  2580,  2584,  2585,
    2588,  2589,  2600,  2602,  2604,  2606,  2608,  2610,  2612,  2614,
    2616,  2618,  2620,  2622,  2624,  2626,  2630,  2631,  2641,  2643,
    2645,  2647,  2649,  2651,  2661,  2663,  2665,  2667,  2669,  2671,
    2673,  2675,  2677,  2679,  2691,  2690,  2700,  2701,  2702,  2706,
    2708,  2712,  2713,  2714,  2715,  2716,  2719,  2720,  2724,  2725,
    2726,  2727,  2730,  2731,  2732,  2735,  2737,  2749,  2753,  2757,
    2759,  2772,  2773,  2774,  2775,  2776,  2777,  2778,  2779,  2780,
    2781,  2782,  2783,  2784,  2785,  2788,  2789,  2790,  2794,  2796,
    2797,  2801,  2802,  2803,  2807,  2808,  2819,  2821,  2830,  2832,
    2834,  2837,  2847,  2859,  2861,  2865,  2867,  2871,  2873,  2875,
    2877,  2879,  2881,  2883,  2885,  2887,  2889,  2891,  2895,  2896,
    2907,  2911,  2913,  2918,  2919,  2923,  2933,  2935,  2946,  2953,
    2955,  2957,  2959,  2961,  2965,  2966,  2970,  2984,  2986,  2988,
    3001,  3003,  3005,  3009,  3011,  3015,  3016,  3019,  3020,  3023,
    3024,  3027,  3028,  3031,  3034,  3045,  3050,  3051,  3052,  3053,
    3054,  3058,  3059,  3109,  3114,  3116,  3118,  3122,  3124,  3128,
    3132,  3133,  3143,  3147,  3148,  3151,  3155,  3158,  3161,  3162,
    3163,  3164,  3165,  3166,  3167,  3168,  3171,  3172,  3182,  3191,
    3192,  3196,  3197,  3201,  3204,  3207,  3210,  3211,  3220,  3251,
    3252,  3253,  3254,  3255,  3259,  3265,  3266,  3276,  3278,  3282,
    3284,  3288,  3290,  3292,  3294,  3298,  3299,  3302,  3306,  3308,
    3310,  3312,  3316,  3321,  3322,  3332,  3334,  3336,  3338,  3340,
    3342,  3344,  3346,  3350,  3351,  3354,  3355,  3358,  3360,  3362,
    3365,  3368,  3369,  3372,  3376,  3377,  3380,  3382,  3384,  3386,
    3390,  3392,  3394,  3396,  3398,  3402,  3403,  3406,  3407,  3410,
    3420,  3423,  3426,  3429,  3433,  3434,  3438,  3439,  3443,  3444,
    3448,  3450,  3455,  3456,  3459,  3461,  3473,  3474,  3477,  3478,
    3488,  3490,  3492,  3494,  3496,  3498,  3500,  3502,  3504,  3506,
    3508,  3529,  3531,  3533,  3535,  3537,  3539,  3543,  3545,  3547,
    3549,  3553,  3554,  3555,  3556,  3560,  3561,  3571,  3573,  3577,
    3579,  3581,  3583,  3587,  3589,  3591,  3595,  3598,  3599,  3602,
    3604,  3608,  3621,  3623,  3625,  3627,  3632,  3638,  3645,  3652,
    3653,  3654,  3655,  3656,  3657,  3658,  3659,  3660,  3663,  3664,
    3665,  3666,  3667,  3668,  3670,  3672,  3676,  3677,  3678,  3679,
    3680,  3683,  3691,  3693,  3695,  3697,  3699,  3701,  3703,  3705,
    3707,  3709,  3711,  3715,  3718,  3721,  3723,  3726,  3729,  3731,
    3734,  3742,  3743,  3746,  3747,  3750,  3754,  3763,  3764,  3767,
    3768,  3771,  3775,  3779,  3781,  3783,  3785,  3787,  3789,  3793,
    3796,  3799,  3802,  3805,  3807,  3809,  3811,  3815,  3819,  3821,
    3824,  3827,  3828,  3829,  3830,  3831,  3832,  3833,  3834,  3835,
    3836,  3837,  3838,  3839,  3840,  3866,  3868,  3870,  3881,  3883,
    3885,  3887,  3889,  3891,  3893,  3895,  3897,  3899,  3901,  3903,
    3905,  3907,  3909,  3911,  3913,  3915,  3917,  3919,  3921,  3923,
    3925,  3927,  3929,  3931,  3933,  3935,  3937,  3939,  3941,  3943,
    3945,  3947,  3958,  3960,  3962,  3964,  3966,  3968,  3970,  3972,
    3974,  3976,  3978,  3980,  3982,  3984,  3986,  3988,  3990,  3992,
    3994,  4006,  4008,  4010,  4012,  4014,  4016,  4018,  4020,  4022,
    4024,  4026,  4028,  4030,  4032,  4034,  4036,  4038,  4040,  4042,
    4054,  4056,  4058,  4060,  4062,  4064,  4066,  4068,  4070,  4072,
    4074,  4086,  4088,  4090,  4092,  4094,  4096,  4098,  4100,  4102,
    4104,  4106,  4108,  4110,  4112,  4114,  4116,  4118,  4120,  4122,
    4124,  4126,  4128,  4130,  4132,  4135,  4137,  4139,  4141,  4143,
    4145,  4147,  4149,  4151,  4153,  4158,  4160,  4162,  4166,  4167,
    4168,  4171,  4172,  4175,  4176,  4177,  4178,  4179,  4180,  4181,
    4182,  4183,  4186,  4187,  4190,  4191,  4194,  4195,  4196,  4197,
    4198,  4199,  4202,  4204,  4208,  4211,  4214,  4216,  4220,  4221,
    4225,  4226,  4232,  4233,  4234,  4235,  4236,  4237,  4238,  4239,
    4243,  4245,  4250,  4254,  4257,  4260,  4262,  4264,  4266,  4268,
    4271,  4274,  4278,  4282,  4284,  4286,  4290,  4292,  4299,  4303,
    4305,  4309,  4313,  4316,  4319,  4320,  4323,  4324,  4328,  4329,
    4330,  4331,  4334,  4335,  4339,  4340,  4343,  4344,  4348,  4349,
    4353,  4354,  4357,  4365,  4367,  4372,  4374,  4376,  4452,  4453,
    4456,  4458,  4462,  4464,  4468,  4470,  4475,  4476,  4477,  4478,
    4479,  4481,  4483,  4485,  4493,  4495,  4497,  4499,  4501,  4503,
    4505,  4507,  4511,  4512,  4513,  4514,  4515,  4525,  4531,  4532,
    4535,  4536,  4539,  4547,  4550,  4558,  4559,  4568,  4577,  4589,
    4590,  4593,  4594,  4595,  4598,  4599,  4600,  4601,  4602,  4605,
    4606,  4609,  4610,  4611,  4612,  4613,  4614,  4617,  4619,  4626,
    4642,  4644,  4647,  4649,  4653,  4665,  4681,  4685,  4696,  4697,
    4700,  4712,  4721,  4722,  4725,  4726,  4727,  4730,  4731,  4734,
    4735,  4738,  4739,  4742,  4744,  4746,  4748,  4752,  4759,  4782,
    4814,  4824,  4831,  4871,  4873,  4880,  4882,  4883,  4888,  4886,
    4901,  4900,  4913,  4919,  4921,  4922,  4925,  4926,  4927,  4928,
    4929,  4936,  4935,  4945,  4947,  4949,  4950,  4951,  4954,  4955,
    4956,  4957,  4958,  4961,  4962,  4966,  4965,  5023,  5021,  5036,
    5035,  5048,  5054,  5055,  5058,  5060,  5061,  5064,  5065,  5066,
    5067,  5070,  5071,  5074,  5082,  5099,  5107,  5130,  5224,  5258,
    5260,  5262,  5266,  5270,  5269,  5320,  5322,  5321,  5336,  5342,
    5349,  5354,  5357,  5358,  5361,  5362,  5363,  5364,  5365,  5366,
    5367,  5375,  5383,  5386,  5387,  5388,  5389,  5390,  5391,  5399,
    5407,  5408,  5409,  5412,  5413,  5416,  5418,  5422,  5504,  5505,
    5512,  5513,  5514,  5520,  5529,  5532,  5533,  5534,  5535,  5538,
    5539,  5540,  5546,  5560,  5559,  5577,  5578,  5579,  5580,  5581,
    5584,  5586,  5590,  5591,  5598,  5603,  5605,  5606,  5609,  5610,
    5613,  5620,  5627,  5627,  5629,  5630,  5633,  5633,  5635,  5645,
    5654,  5661,  5667,  5673,  5681,  5682,  5694,  5705,  5716,  5720,
    5721,  5724,  5729,  5733,  5734,  5737,  5744,  5751,  5755,  5756,
    5759,  5762,  5766,  5767,  5770,  5777,  5778,  5779,  5780,  5781,
    5782,  5783,  5784,  5785,  5786,  5787,  5788,  5789,  5790,  5791,
    5821,  5822,  5825,  5826,  5833,  5834,  5835,  5842,  5841,  5900,
    5901,  5908,  5907,  5976,  5982,  5988,  5996,  6002,  6008,  6014,
    6020,  6026,  6032,  6038,  6044,  6055,  6056,  6059,  6060,  6061,
    6062,  6063,  6064,  6065,  6066,  6067,  6068,  6069,  6070,  6071,
    6072,  6073,  6074,  6075,  6076,  6077,  6078,  6079,  6080,  6081,
    6082,  6083,  6084,  6085,  6088,  6089,  6090,  6091,  6092,  6093,
    6097,  6098,  6099,  6100,  6101,  6102,  6103,  6106,  6120,  6121,
    6122,  6123,  6124,  6125,  6126,  6127,  6131,  6132,  6133,  6134,
    6135,  6136,  6137,  6141,  6142,  6143,  6144,  6145,  6150,  6151,
    6152,  6153,  6154,  6160,  6161,  6162,  6163,  6164,  6165,  6166,
    6167,  6168,  6171,  6172,  6173,  6174,  6177,  6178,  6179,  6180,
    6183,  6184,  6185,  6186,  6187,  6188,  6189,  6207,  6207,  6209,
    6210,  6211,  6212,  6213,  6214,  6220,  6221,  6224,  6225,  6226,
    6227,  6228,  6229,  6230,  6231,  6232,  6233,  6234,  6235,  6236,
    6237,  6238,  6239,  6240,  6241,  6242,  6243,  6244,  6245,  6246,
    6247,  6248,  6249,  6250,  6251,  6252,  6253,  6255,  6256,  6257,
    6258,  6259,  6260,  6261,  6262,  6263,  6264,  6266,  6267,  6268,
    6269,  6270,  6271,  6272,  6273,  6274,  6275,  6276,  6277,  6278,
    6279,  6280,  6281,  6282,  6283,  6284,  6285,  6286,  6287,  6288,
    6289,  6290,  6291,  6292,  6293,  6294,  6295,  6297,  6298,  6299,
    6300,  6301,  6302,  6303,  6304,  6305,  6306,  6307,  6308,  6309,
    6310,  6311,  6312,  6313,  6314,  6315,  6316,  6317,  6318,  6319,
    6320,  6321,  6322,  6323,  6324,  6326,  6327,  6329,  6330,  6331,
    6332,  6333,  6334,  6335,  6336,  6337,  6338,  6339,  6340,  6341,
    6342,  6343,  6344,  6345,  6346,  6347,  6348,  6349,  6350,  6351,
    6352,  6353,  6354,  6355,  6356,  6357,  6358,  6359,  6360,  6361,
    6362,  6363,  6364,  6365,  6366,  6367,  6368,  6369,  6370,  6371,
    6372,  6373,  6374,  6375,  6376,  6377,  6378,  6379,  6381,  6382,
    6383,  6384,  6385,  6386,  6387,  6388,  6389,  6390,  6391,  6392,
    6393,  6394,  6395,  6396,  6397,  6398,  6399,  6400,  6401,  6402,
    6403,  6404,  6405,  6406,  6407,  6408,  6409,  6410,  6411,  6412,
    6413,  6414,  6415,  6416,  6417,  6418,  6419,  6420,  6421,  6423,
    6437,  6438,  6442,  6443,  6444,  6445,  6446,  6447,  6448,  6449,
    6450,  6451,  6455,  6456,  6457,  6458,  6459,  6460,  6461,  6462,
    6463,  6464,  6465,  6466,  6467,  6468,  6469,  6470,  6471,  6472,
    6473,  6474,  6475,  6478,  6492,  6493,  6494,  6495,  6496,  6497,
    6498,  6499,  6500,  6501,  6502,  6503,  6504,  6505,  6506,  6507,
    6508,  6509,  6510,  6511,  6521,  6522,  6523,  6524,  6525,  6526,
    6527,  6528,  6529,  6530,  6531,  6532,  6533,  6534,  6535,  6536,
    6537,  6538,  6539,  6540,  6541,  6542,  6543,  6544,  6545,  6546,
    6547,  6548,  6549,  6550,  6551,  6552,  6553,  6554,  6555,  6556,
    6557,  6558,  6559,  6560,  6561,  6562,  6563,  6564,  6565,  6566,
    6567,  6568,  6569,  6570,  6571,  6572,  6573,  6574,  6575,  6576,
    6577,  6578,  6579,  6580,  6581,  6582,  6586,  6587,  6591,  6592,
    6593,  6594,  6595,  6599,  6599,  6602,  6605,  6606,  6609,  6611,
    6616,  6626,  6633,  6634,  6635,  6638,  6670,  6671,  6674,  6676,
    6684,  6685,  6686,  6690,  6691,  6695,  6696,  6699,  6700,  6703,
    6704,  6705,  6706,  6707,  6710,  6711,  6712,  6713,  6714,  6715,
    6716,  6717,  6718,  6719,  6720,  6721,  6722,  6723,  6724,  6725,
    6726,  6727,  6728,  6729,  6730,  6731,  6732,  6733,  6734,  6735,
    6736,  6737,  6738,  6739,  6740,  6741,  6742,  6743,  6744,  6745,
    6746,  6747,  6748,  6749,  6750,  6751,  6752,  6753,  6754,  6755,
    6756,  6757,  6758,  6759,  6760,  6761,  6762,  6763,  6764,  6765,
    6766
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_CONTINUE", "SQL_COUNT", "SQL_CURRENT", "SQL_DATA", 
  "SQL_DATETIME_INTERVAL_CODE", "SQL_DATETIME_INTERVAL_PRECISION", 
  "SQL_DESCRIBE", "SQL_DESCRIPTOR", "SQL_DISCONNECT", "SQL_ENUM", 
  "SQL_FOUND", "SQL_FREE", "SQL_GO", "SQL_GOTO", "SQL_IDENTIFIED", 
  "SQL_INDICATOR", "SQL_KEY_MEMBER", "SQL_LENGTH", "SQL_LONG", "SQL_NAME", 
  "SQL_NULLABLE", "SQL_OCTET_LENGTH", "SQL_OPEN", "SQL_OUTPUT", 
  "SQL_REFERENCE", "SQL_RETURNED_LENGTH", "SQL_RETURNED_OCTET_LENGTH", 
  "SQL_SCALE", "SQL_SECTION", "SQL_SHORT", "SQL_SIGNED", "SQL_SQL", 
  "SQL_SQLERROR", "SQL_SQLPRINT", "SQL_SQLWARNING", "SQL_START", 
  "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED", "SQL_VALUE", "SQL_VAR", 
  "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO", "S_CONST", 
  "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN", "S_INC", 
  "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL", "S_NEQUAL", 
  "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB", "S_VOLATILE", 
  "S_TYPEDEF", "TYPECAST", "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION", 
  "ADD_P", "ADMIN", "AFTER", "AGGREGATE", "ALL", "ALSO", "ALTER", 
  "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION", 
  "ASSIGNMENT", "ASYMMETRIC", "AT", "AUTHORIZATION", "BACKWARD", "BEFORE", 
  "BEGIN_P", "BETWEEN", "BIGINT", "BINARY", "BIT", "BOOLEAN_P", "BOTH", 
  "BY", "CACHE", "CALLED", "CASCADE", "CASCADED", "CASE", "CAST", "CHAIN", 
  "CHAR_P", "CHARACTER", "CHARACTERISTICS", "CHECK", "CHECKPOINT", 
  "CLASS", "CLOSE", "CLUSTER", "COALESCE", "COLLATE", "COLUMN", "COMMENT", 
  "COMMIT", "COMMITTED", "CONCURRENTLY", "CONNECTION", "CONSTRAINT", 
  "CONSTRAINTS", "CONVERSION_P", "CONVERT", "COPY", "CREATE", "CREATEDB", 
  "CREATEROLE", "CREATEUSER", "CROSS", "CSV", "CURRENT_DATE", 
  "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", 
  "CURSOR", "CYCLE", "DATABASE", "DAY_P", "DEALLOCATE", "DEC", 
  "DECIMAL_P", "DECLARE", "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED", 
  "DEFINER", "DELETE_P", "DELIMITER", "DELIMITERS", "DESC", "DISABLE_P", 
  "DISTINCT", "DO", "DOMAIN_P", "DOUBLE_P", "DROP", "EACH", "ELSE", 
  "ENABLE_P", "ENCODING", "ENCRYPTED", "END_P", "ESCAPE", "EXCEPT", 
  "EXCLUSIVE", "EXCLUDING", "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", 
  "EXTRACT", "FALSE_P", "FETCH", "FIRST_P", "FLOAT_P", "FOR", "FORCE", 
  "FOREIGN", "FORWARD", "FREEZE", "FROM", "FULL", "FUNCTION", "GET", 
  "GLOBAL", "GRANT", "GRANTED", "GREATEST", "GROUP_P", "HANDLER", 
  "HAVING", "HEADER_P", "HOLD", "HOUR_P", "IF_P", "ILIKE", "IMMEDIATE", 
  "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", "INCREMENT", "INDEX", 
  "INDEXES", "INHERIT", "INHERITS", "INITIALLY", "INNER_P", "INOUT", 
  "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", "INT_P", "INTEGER", 
  "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", "ISNULL", "ISOLATION", 
  "JOIN", "KEY", "LANCOMPILER", "LANGUAGE", "LARGE_P", "LAST_P", 
  "LEADING", "LEAST", "LEFT", "LEVEL", "LIKE", "LIMIT", "LISTEN", "LOAD", 
  "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", "LOCATION", "LOCK_P", "LOGIN_P", 
  "MATCH", "MAXVALUE", "MINUTE_P", "MINVALUE", "MODE", "MONTH_P", "MOVE", 
  "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEW", "NEXT", "NO", 
  "NOCREATEDB", "NOCREATEROLE", "NOCREATEUSER", "NOINHERIT", "NOLOGIN_P", 
  "NONE", "NOSUPERUSER", "NOT", "NOTHING", "NOTIFY", "NOTNULL", "NOWAIT", 
  "NULL_P", "NULLIF", "NUMERIC", "OBJECT_P", "OF", "OFF", "OFFSET", 
  "OIDS", "OLD", "ON", "ONLY", "OPERATOR", "OPTION", "OR", "ORDER", 
  "OUT_P", "OUTER_P", "OVERLAPS", "OVERLAY", "OWNED", "OWNER", "PARTIAL", 
  "PASSWORD", "PLACING", "POSITION", "PRECISION", "PRESERVE", "PREPARE", 
  "PREPARED", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE", 
  "QUOTE", "READ", "REAL", "REASSIGN", "RECHECK", "REFERENCES", "REINDEX", 
  "RELATIVE_P", "RELEASE", "RENAME", "REPEATABLE", "REPLACE", "RESET", 
  "RESTART", "RESTRICT", "RETURNING", "RETURNS", "REVOKE", "RIGHT", 
  "ROLE", "ROLLBACK", "ROW", "ROWS", "RULE", "SAVEPOINT", "SCHEMA", 
  "SCROLL", "SECOND_P", "SECURITY", "SELECT", "SEQUENCE", "SERIALIZABLE", 
  "SESSION", "SESSION_USER", "SET", "SETOF", "SHARE", "SHOW", "SIMILAR", 
  "SIMPLE", "SMALLINT", "SOME", "STABLE", "START", "STATEMENT", 
  "STATISTICS", "STDIN", "STDOUT", "STORAGE", "STRICT_P", "SUBSTRING", 
  "SUPERUSER_P", "SYMMETRIC", "SYSID", "SYSTEM_P", "TABLE", "TABLESPACE", 
  "TEMP", "TEMPLATE", "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TO", 
  "TRAILING", "TRANSACTION", "TREAT", "TRIGGER", "TRIM", "TRUE_P", 
  "TRUNCATE", "TRUSTED", "TYPE_P", "UNCOMMITTED", "UNENCRYPTED", "UNION", 
  "UNIQUE", "UNKNOWN", "UNLISTEN", "UNTIL", "UPDATE", "USER", "USING", 
  "VACUUM", "VALID", "VALIDATOR", "VALUES", "VARCHAR", "VARYING", 
  "VERBOSE", "VIEW", "VOLATILE", "WHEN", "WHERE", "WITH", "WITHOUT", 
  "WORK", "WRITE", "YEAR_P", "ZONE", "WITH_CASCADED", "WITH_LOCAL", 
  "WITH_CHECK", "IDENT", "SCONST", "Op", "CSTRING", "CVARIABLE", 
  "CPP_LINE", "IP", "BCONST", "XCONST", "DOLCONST", "ICONST", "PARAM", 
  "FCONST", "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", "'*'", "'/'", 
  "'%'", "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", "';'", "'{'", 
  "'}'", "\"=\"", "','", "':'", "$accept", "prog", "statements", 
  "statement", "opt_at", "stmt", "CreateRoleStmt", "opt_with", 
  "OptRoleList", "CreateUserStmt", "AlterRoleStmt", "AlterRoleSetStmt", 
  "AlterUserStmt", "DropRoleStmt", "DropUserStmt", "CreateGroupStmt", 
  "AlterGroupStmt", "add_drop", "DropGroupStmt", "CreateSchemaStmt", 
  "OptSchemaName", "OptSchemaEltList", "schema_stmt", "VariableSetStmt", 
  "set_rest", "var_name", "var_list_or_default", "var_list", "iso_level", 
  "var_value", "opt_boolean", "zone_value", "opt_encoding", 
  "ColId_or_Sconst", "VariableShowStmt", "VariableResetStmt", 
  "ConstraintsSetStmt", "constraints_set_list", "constraints_set_mode", 
  "CheckPointStmt", "AlterTableStmt", "alter_table_cmds", 
  "alter_table_cmd", "alter_rel_cmds", "alter_rel_cmd", 
  "alter_column_default", "opt_drop_behavior", "alter_using", 
  "ClosePortalStmt", "CopyStmt", "copy_from", "copy_file_name", 
  "copy_opt_list", "copy_opt_item", "opt_binary", "opt_oids", 
  "copy_delimiter", "opt_using", "CreateStmt", "OptTemp", 
  "OptTableElementList", "TableElementList", "TableElement", "columnDef", 
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr", 
  "TableLikeClause", "TableLikeOptionList", "TableLikeOption", 
  "TableConstraint", "ConstraintElem", "opt_column_list", "columnList", 
  "columnElem", "key_match", "key_actions", "key_delete", "key_update", 
  "key_action", "OptInherit", "OptWith", "OnCommitOption", 
  "OptTableSpace", "OptConsTableSpace", "CreateAsStmt", "@1", 
  "OptCreateAs", "CreateAsList", "CreateAsElement", "CreateSeqStmt", 
  "AlterSeqStmt", "OptSeqList", "OptSeqElem", "opt_by", "CreatePLangStmt", 
  "opt_trusted", "handler_name", "opt_validator", "opt_lancompiler", 
  "DropPLangStmt", "opt_procedural", "CreateTableSpaceStmt", 
  "OptTableSpaceOwner", "DropTableSpaceStmt", "CreateTrigStmt", 
  "TriggerActionTime", "TriggerEvents", "TriggerOneEvent", 
  "TriggerForSpec", "TriggerForOpt", "TriggerForType", "TriggerFuncArgs", 
  "TriggerFuncArg", "OptConstrFromTable", "ConstraintAttributeSpec", 
  "ConstraintDeferrabilitySpec", "ConstraintTimeSpec", "DropTrigStmt", 
  "CreateAssertStmt", "DropAssertStmt", "DefineStmt", "definition", 
  "def_list", "def_elem", "def_arg", "aggr_args", "aggr_args_list", 
  "old_aggr_definition", "old_aggr_list", "old_aggr_elem", 
  "CreateOpClassStmt", "opclass_item_list", "opclass_item", "opt_default", 
  "opt_recheck", "DropOpClassStmt", "DropOwnedStmt", "ReassignOwnedStmt", 
  "DropStmt", "drop_type", "any_name_list", "any_name", "attrs", 
  "TruncateStmt", "FetchStmt", "fetch_direction", "from_in", 
  "CommentStmt", "comment_type", "comment_text", "GrantStmt", 
  "RevokeStmt", "privileges", "privilege_list", "privilege", 
  "privilege_target", "grantee_list", "grantee", "opt_grant_grant_option", 
  "function_with_argtypes_list", "function_with_argtypes", 
  "GrantRoleStmt", "RevokeRoleStmt", "opt_grant_admin_option", 
  "opt_granted_by", "IndexStmt", "index_opt_unique", 
  "access_method_clause", "index_params", "index_elem", "opt_class", 
  "CreateFunctionStmt", "opt_or_replace", "func_args", "func_args_list", 
  "func_arg", "arg_class", "func_as", "param_name", "func_return", 
  "func_type", "createfunc_opt_list", "common_func_opt_item", 
  "createfunc_opt_item", "opt_definition", "AlterFunctionStmt", 
  "alterfunc_opt_list", "opt_restrict", "RemoveFuncStmt", 
  "RemoveAggrStmt", "RemoveOperStmt", "oper_argtypes", "any_operator", 
  "CreateCastStmt", "cast_context", "DropCastStmt", "opt_if_exists", 
  "ReindexStmt", "reindex_type", "opt_force", "RenameStmt", "opt_column", 
  "AlterObjectSchemaStmt", "AlterOwnerStmt", "RuleStmt", "@2", 
  "RuleActionList", "RuleActionMulti", "RuleActionStmt", 
  "RuleActionStmtOrEmpty", "event", "opt_instead", "DropRuleStmt", 
  "NotifyStmt", "ListenStmt", "UnlistenStmt", "TransactionStmt", 
  "opt_transaction", "transaction_mode_item", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option", 
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", 
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt", 
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", 
  "CreateDomainStmt", "AlterDomainStmt", "opt_as", "CreateConversionStmt", 
  "ClusterStmt", "VacuumStmt", "AnalyzeStmt", "analyze_keyword", 
  "opt_verbose", "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt", 
  "ExplainableStmt", "opt_analyze", "InsertStmt", "insert_rest", 
  "insert_column_list", "insert_column_item", "returning_clause", 
  "DeleteStmt", "using_clause", "LockStmt", "opt_lock", "lock_type", 
  "opt_nowait", "UpdateStmt", "set_clause_list", "set_clause", 
  "single_set_clause", "multiple_set_clause", "set_target", 
  "set_target_list", "DeclareCursorStmt", "cursor_options", "opt_hold", 
  "SelectStmt", "select_with_parens", "select_no_parens", "select_clause", 
  "simple_select", "into_clause", "OptTempTableName", "opt_table", 
  "opt_all", "opt_distinct", "opt_sort_clause", "sort_clause", 
  "sortby_list", "sortby", "select_limit", "opt_select_limit", 
  "select_limit_value", "select_offset_value", "group_clause", 
  "having_clause", "for_locking_clause", "opt_for_locking_clause", 
  "for_locking_items", "for_locking_item", "locked_rels_list", 
  "values_clause", "from_clause", "from_list", "table_ref", 
  "joined_table", "alias_clause", "join_type", "join_outer", "join_qual", 
  "relation_expr", "relation_expr_opt_alias", "func_table", 
  "where_clause", "TableFuncElementList", "TableFuncElement", "Typename", 
  "opt_array_bounds", "Iresult", "SimpleTypename", "ConstTypename", 
  "GenericType", "Numeric", "opt_float", "opt_numeric", "opt_decimal", 
  "Bit", "ConstBit", "BitWithLength", "BitWithoutLength", "Character", 
  "ConstCharacter", "CharacterWithLength", "CharacterWithoutLength", 
  "character", "opt_varying", "opt_charset", "ConstDatetime", 
  "ConstInterval", "opt_timezone", "opt_interval", "a_expr", "b_expr", 
  "c_expr", "func_expr", "row", "sub_type", "all_Op", "MathOp", "qual_Op", 
  "qual_all_Op", "subquery_Op", "expr_list", "extract_list", "type_list", 
  "array_expr_list", "array_expr", "extract_arg", "overlay_list", 
  "overlay_placing", "position_list", "substr_list", "substr_from", 
  "substr_for", "trim_list", "in_expr", "case_expr", "when_clause_list", 
  "when_clause", "case_default", "case_arg", "columnref", 
  "indirection_el", "indirection", "opt_indirection", "opt_asymmetric", 
  "ctext_expr", "ctext_expr_list", "ctext_row", "target_list", 
  "target_el", "relation_name", "qualified_name_list", "qualified_name", 
  "name_list", "name", "database_name", "access_method", "attr_name", 
  "index_name", "file_name", "func_name", "AexprConst", "Iconst", 
  "Fconst", "Bconst", "Xconst", "Sconst", "PosIntConst", "IntConst", 
  "IntConstVar", "AllConstVar", "StringConst", "PosIntStringConst", 
  "NumConst", "AllConst", "PosAllConst", "RoleId", "SpecialRuleRelation", 
  "ECPGConnect", "connection_target", "opt_database_name", "db_prefix", 
  "server", "opt_server", "server_name", "opt_port", 
  "opt_connection_name", "opt_user", "ora_user", "user_name", 
  "char_variable", "opt_options", "ECPGCursorStmt", "ECPGDeallocate", 
  "ECPGVarDeclaration", "single_vt_declaration", "single_var_declaration", 
  "@3", "@4", "precision", "opt_scale", "ecpg_interval", 
  "ECPGDeclaration", "@5", "sql_startdeclare", "sql_enddeclare", 
  "var_type_declarations", "vt_declarations", "variable_declarations", 
  "type_declaration", "@6", "var_declaration", "@7", "@8", 
  "opt_bit_field", "storage_declaration", "storage_clause", 
  "storage_modifier", "var_type", "enum_type", "enum_definition", 
  "struct_union_type_with_symbol", "@9", "struct_union_type", "@10", 
  "s_struct_union_symbol", "s_struct_union", "simple_type", 
  "unsigned_type", "signed_type", "opt_signed", "variable_list", 
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare", 
  "ECPGDisconnect", "dis_name", "connection_object", "ECPGExecute", "@11", 
  "execute_rest", "execstring", "prepared_name", "ECPGFree", "ECPGOpen", 
  "opt_ecpg_using", "ecpg_using", "using_descriptor", "into_descriptor", 
  "opt_sql", "ecpg_into", "using_list", "UsingConst", "ECPGPrepare", 
  "ECPGDescribe", "opt_output", "ECPGAllocateDescr", 
  "ECPGDeallocateDescr", "ECPGGetDescriptorHeader", 
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem", 
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems", 
  "ECPGSetDescHeaderItem", "desc_header_item", "ECPGGetDescriptor", 
  "ECPGGetDescItems", "ECPGGetDescItem", "ECPGSetDescriptor", 
  "ECPGSetDescItems", "ECPGSetDescItem", "descriptor_item", 
  "ECPGSetAutocommit", "on_off", "ECPGSetConnection", "ECPGTypedef", 
  "@12", "opt_reference", "ECPGVar", "@13", "ECPGWhenever", "action", 
  "ECPGKeywords", "ECPGKeywords_vanames", "ECPGKeywords_rest", 
  "ECPGTypeName", "symbol", "ECPGColId", "ColId", "type_name", 
  "function_name", "ColLabel", "ECPGColLabelCommon", "ECPGColLabel", 
  "ECPGCKeywords", "unreserved_keyword", "ECPGunreserved_interval", 
  "ECPGunreserved", "ECPGunreserved_con", "col_name_keyword", 
  "func_name_keyword", "reserved_keyword", "into_list", "ecpgstart", 
  "c_args", "coutputvariable", "civarind", "civar", "indicator", 
  "cvariable", "ident", "quoted_ident_stringvar", "c_stuff_item", 
  "c_stuff", "c_list", "c_term", "c_thing", "c_anything", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,    61,    60,    62,   689,    43,    45,
      42,    47,    37,    94,   690,    91,    93,    40,    41,    46,
      59,   123,   125,   691,    44,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   456,   457,   458,   458,   459,   459,   459,   459,   459,
     459,   459,   459,   460,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   461,   461,   461,   461,
     461,   461,   461,   461,   461,   461,   462,   463,   463,   464,
     464,   464,   464,   464,   464,   464,   464,   464,   464,   464,
     464,   464,   464,   464,   464,   464,   464,   464,   464,   464,
     464,   465,   466,   467,   467,   468,   467,   467,   469,   469,
     470,   470,   471,   472,   473,   473,   474,   474,   475,   475,
     476,   476,   477,   477,   478,   478,   478,   478,   478,   478,
     479,   479,   479,   480,   480,   480,   480,   480,   480,   480,
     480,   480,   481,   481,   482,   482,   483,   483,   484,   484,
     484,   484,   485,   485,   485,   486,   486,   486,   486,   487,
     487,   487,   487,   487,   487,   488,   488,   488,   489,   489,
     490,   490,   490,   490,   490,   491,   491,   491,   491,   491,
     492,   493,   493,   494,   494,   495,   496,   496,   497,   497,
     498,   498,   498,   498,   498,   498,   498,   498,   498,   498,
     498,   498,   498,   498,   498,   498,   498,   498,   498,   498,
     498,   498,   499,   499,   500,   500,   500,   500,   501,   501,
     502,   502,   502,   503,   503,   504,   505,   505,   506,   506,
     507,   507,   507,   508,   508,   509,   509,   509,   509,   509,
     509,   509,   509,   509,   509,   510,   510,   511,   511,   512,
     512,   513,   513,   514,   514,   515,   515,   515,   515,   515,
     515,   515,   516,   516,   517,   517,   518,   518,   518,   519,
     520,   520,   521,   521,   521,   522,   522,   522,   522,   522,
     522,   522,   523,   523,   523,   523,   524,   525,   525,   526,
     526,   526,   526,   526,   526,   527,   527,   528,   528,   528,
     528,   529,   529,   530,   530,   531,   532,   532,   532,   533,
     533,   533,   533,   533,   534,   535,   536,   536,   536,   536,
     536,   537,   537,   538,   538,   538,   538,   539,   539,   539,
     539,   540,   540,   541,   541,   543,   542,   544,   544,   545,
     545,   546,   547,   548,   549,   549,   550,   550,   550,   550,
     550,   550,   550,   550,   550,   550,   550,   551,   551,   552,
     552,   553,   553,   554,   554,   555,   555,   556,   556,   557,
     557,   558,   558,   559,   560,   560,   561,   561,   562,   562,
     563,   563,   564,   564,   564,   565,   565,   565,   566,   566,
     567,   567,   568,   568,   569,   569,   569,   570,   570,   571,
     571,   572,   572,   572,   572,   572,   573,   573,   574,   574,
     575,   575,   576,   577,   578,   578,   578,   578,   578,   578,
     579,   580,   580,   581,   581,   582,   582,   582,   582,   582,
     583,   583,   584,   584,   585,   586,   586,   587,   588,   589,
     589,   590,   590,   590,   590,   591,   591,   592,   592,   593,
     593,   594,   595,   596,   596,   597,   597,   597,   597,   597,
     597,   597,   597,   598,   598,   599,   599,   600,   600,   601,
     602,   602,   602,   602,   602,   602,   602,   602,   602,   602,
     603,   603,   603,   603,   603,   603,   603,   603,   603,   603,
     603,   603,   603,   603,   604,   604,   605,   605,   605,   605,
     605,   605,   605,   605,   605,   605,   605,   606,   606,   606,
     606,   606,   606,   606,   606,   606,   606,   606,   606,   607,
     607,   608,   609,   609,   610,   610,   610,   611,   611,   612,
     612,   612,   612,   613,   613,   613,   613,   613,   613,   613,
     613,   614,   614,   615,   615,   616,   616,   617,   617,   618,
     619,   620,   621,   621,   622,   622,   623,   623,   624,   624,
     625,   625,   626,   626,   627,   627,   627,   628,   628,   628,
     629,   629,   630,   630,   631,   631,   632,   632,   633,   633,
     633,   633,   633,   634,   634,   634,   634,   635,   635,   636,
     637,   637,   638,   638,   639,   639,   640,   640,   640,   640,
     640,   640,   640,   640,   640,   640,   641,   641,   641,   642,
     642,   643,   644,   644,   645,   645,   646,   646,   647,   647,
     648,   648,   649,   649,   649,   649,   650,   650,   651,   651,
     652,   652,   653,   654,   654,   655,   655,   655,   656,   656,
     657,   657,   658,   658,   658,   658,   658,   658,   658,   658,
     658,   658,   658,   658,   658,   658,   659,   659,   660,   660,
     660,   660,   660,   660,   661,   661,   661,   661,   661,   661,
     661,   661,   661,   661,   663,   662,   664,   664,   664,   665,
     665,   666,   666,   666,   666,   666,   667,   667,   668,   668,
     668,   668,   669,   669,   669,   670,   670,   671,   672,   673,
     673,   674,   674,   674,   674,   674,   674,   674,   674,   674,
     674,   674,   674,   674,   674,   675,   675,   675,   676,   676,
     676,   677,   677,   677,   678,   678,   679,   679,   680,   680,
     680,   680,   681,   682,   682,   683,   683,   684,   684,   684,
     684,   684,   684,   684,   684,   684,   684,   684,   685,   685,
     686,   687,   687,   688,   688,   689,   690,   690,   691,   692,
     692,   692,   692,   692,   693,   693,   694,   695,   695,   695,
     696,   696,   696,   697,   697,   698,   698,   699,   699,   700,
     700,   701,   701,   702,   702,   703,   704,   704,   704,   704,
     704,   705,   705,   706,   707,   707,   707,   708,   708,   709,
     710,   710,   711,   712,   712,   713,   714,   714,   715,   715,
     715,   715,   715,   715,   715,   715,   716,   716,   717,   718,
     718,   719,   719,   720,   721,   722,   723,   723,   724,   725,
     725,   725,   725,   725,   726,   726,   726,   727,   727,   728,
     728,   729,   729,   729,   729,   730,   730,   731,   731,   731,
     731,   731,   732,   732,   732,   733,   733,   733,   733,   733,
     733,   733,   733,   734,   734,   735,   735,   736,   736,   736,
     736,   737,   737,   738,   739,   739,   740,   740,   740,   740,
     741,   741,   741,   741,   741,   742,   742,   743,   743,   744,
     745,   745,   746,   746,   747,   747,   748,   748,   749,   749,
     750,   750,   751,   751,   752,   752,   753,   753,   754,   754,
     755,   755,   755,   755,   755,   755,   755,   755,   755,   755,
     755,   756,   756,   756,   756,   756,   756,   757,   757,   757,
     757,   758,   758,   758,   758,   759,   759,   760,   760,   761,
     761,   761,   761,   762,   762,   762,   763,   764,   764,   765,
     765,   766,   767,   767,   767,   767,   768,   768,   768,   769,
     769,   769,   769,   769,   769,   769,   769,   769,   770,   770,
     770,   770,   770,   770,   770,   770,   771,   771,   771,   771,
     771,   772,   773,   773,   773,   773,   773,   773,   773,   773,
     773,   773,   773,   774,   774,   775,   775,   775,   776,   776,
     776,   777,   777,   778,   778,   779,   780,   781,   781,   782,
     782,   783,   784,   785,   785,   785,   785,   785,   785,   786,
     786,   787,   787,   788,   788,   788,   788,   789,   790,   790,
     790,   791,   791,   791,   791,   791,   791,   791,   791,   791,
     791,   791,   791,   791,   791,   792,   792,   792,   792,   792,
     792,   792,   792,   792,   792,   792,   792,   792,   792,   792,
     792,   792,   792,   792,   792,   792,   792,   792,   792,   792,
     792,   792,   792,   792,   792,   792,   792,   792,   792,   792,
     792,   792,   792,   792,   792,   792,   792,   792,   792,   792,
     792,   792,   792,   792,   792,   792,   792,   792,   792,   792,
     792,   793,   793,   793,   793,   793,   793,   793,   793,   793,
     793,   793,   793,   793,   793,   793,   793,   793,   793,   793,
     794,   794,   794,   794,   794,   794,   794,   794,   794,   794,
     794,   795,   795,   795,   795,   795,   795,   795,   795,   795,
     795,   795,   795,   795,   795,   795,   795,   795,   795,   795,
     795,   795,   795,   795,   795,   795,   795,   795,   795,   795,
     795,   795,   795,   795,   795,   796,   796,   796,   797,   797,
     797,   798,   798,   799,   799,   799,   799,   799,   799,   799,
     799,   799,   800,   800,   801,   801,   802,   802,   802,   802,
     802,   802,   803,   803,   804,   804,   805,   805,   806,   806,
     807,   807,   808,   808,   808,   808,   808,   808,   808,   808,
     809,   809,   810,   811,   811,   812,   812,   812,   812,   812,
     812,   813,   814,   815,   815,   815,   816,   816,   817,   818,
     818,   819,   820,   820,   821,   821,   822,   822,   823,   823,
     823,   823,   824,   824,   825,   825,   826,   826,   827,   827,
     828,   828,   829,   830,   830,   831,   831,   831,   832,   832,
     833,   833,   834,   834,   835,   835,   836,   837,   838,   839,
     840,   841,   842,   842,   843,   843,   843,   843,   843,   843,
     843,   843,   844,   845,   846,   847,   848,   848,   849,   849,
     850,   850,   851,   851,   852,   852,   852,   852,   852,   853,
     853,   854,   854,   854,   855,   855,   855,   855,   855,   856,
     856,   857,   857,   857,   857,   857,   857,   858,   859,   859,
     860,   860,   860,   860,   861,   861,   861,   861,   862,   862,
     863,   864,   865,   865,   866,   866,   866,   867,   867,   868,
     868,   869,   869,   870,   870,   870,   870,   871,   871,   872,
     873,   873,   874,   875,   875,   876,   877,   877,   879,   878,
     880,   878,   878,   881,   882,   882,   883,   883,   883,   883,
     883,   885,   884,   886,   887,   888,   888,   888,   889,   889,
     889,   889,   889,   890,   890,   892,   891,   894,   893,   895,
     893,   893,   896,   896,   897,   897,   897,   898,   898,   898,
     898,   899,   899,   900,   900,   900,   900,   900,   900,   901,
     901,   901,   902,   904,   903,   905,   906,   905,   907,   907,
     908,   908,   909,   909,   910,   910,   910,   910,   910,   910,
     910,   910,   910,   911,   911,   911,   911,   911,   911,   911,
     911,   911,   911,   912,   912,   913,   913,   914,   915,   915,
     916,   916,   916,   917,   918,   919,   919,   919,   919,   920,
     920,   920,   921,   922,   921,   923,   923,   923,   923,   923,
     924,   924,   925,   925,   926,   927,   928,   928,   929,   929,
     930,   931,   932,   932,   933,   933,   934,   934,   935,   935,
     936,   937,   937,   937,   938,   938,   939,   940,   941,   942,
     942,   943,   944,   945,   945,   946,   947,   948,   949,   949,
     950,   951,   952,   952,   953,   954,   954,   954,   954,   954,
     954,   954,   954,   954,   954,   954,   954,   954,   954,   954,
     955,   955,   956,   956,   957,   957,   957,   959,   958,   960,
     960,   962,   961,   963,   963,   963,   964,   964,   964,   964,
     964,   964,   964,   964,   964,   965,   965,   966,   966,   966,
     966,   966,   966,   966,   966,   966,   966,   966,   966,   966,
     966,   966,   966,   966,   966,   966,   966,   966,   966,   966,
     966,   966,   966,   966,   967,   967,   967,   967,   967,   967,
     968,   968,   968,   968,   968,   968,   968,   969,   970,   970,
     970,   970,   970,   970,   970,   970,   971,   971,   971,   971,
     971,   971,   971,   972,   972,   972,   972,   972,   973,   973,
     973,   973,   973,   974,   974,   974,   974,   974,   974,   974,
     974,   974,   975,   975,   975,   975,   976,   976,   976,   976,
     977,   977,   977,   977,   977,   977,   977,   978,   978,   979,
     979,   979,   979,   979,   979,   980,   980,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     981,   981,   981,   981,   981,   981,   981,   981,   981,   981,
     982,   982,   982,   982,   982,   982,   982,   982,   982,   982,
     982,   982,   982,   982,   982,   982,   982,   982,   982,   982,
     982,   982,   982,   982,   982,   982,   982,   982,   982,   982,
     982,   982,   982,   982,   983,   983,   983,   983,   983,   983,
     983,   983,   983,   983,   983,   983,   983,   983,   983,   983,
     983,   983,   983,   983,   984,   984,   984,   984,   984,   984,
     984,   984,   984,   984,   984,   984,   984,   984,   984,   984,
     984,   984,   984,   984,   984,   984,   984,   984,   984,   984,
     984,   984,   984,   984,   984,   984,   984,   984,   984,   984,
     984,   984,   984,   984,   984,   984,   984,   984,   984,   984,
     984,   984,   984,   984,   984,   984,   984,   984,   984,   984,
     984,   984,   984,   984,   984,   984,   984,   984,   984,   984,
     984,   984,   984,   985,   985,   986,   987,   987,   988,   988,
     989,   990,   991,   991,   991,   992,   993,   993,   994,   994,
     995,   995,   995,   996,   996,   997,   997,   998,   998,   999,
     999,   999,   999,   999,  1000,  1000,  1000,  1000,  1000,  1000,
    1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,
    1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,
    1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,
    1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,
    1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,  1000,
    1000
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     0,     2,     4,     3,     2,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     5,     1,     0,     2,
       2,     3,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     3,     2,     2,     2,     2,     3,
       3,     5,     5,     5,     4,     5,     5,     4,     3,     5,
       3,     5,     5,     6,     1,     1,     3,     5,     6,     4,
       1,     0,     2,     0,     1,     1,     1,     1,     1,     1,
       2,     3,     3,     3,     3,     3,     2,     5,     2,     2,
       3,     3,     1,     3,     1,     1,     1,     3,     2,     2,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     6,     1,     1,     1,     1,     0,     1,     1,
       3,     4,     5,     4,     2,     2,     3,     4,     3,     2,
       4,     1,     1,     1,     1,     1,     4,     4,     1,     3,
       3,     4,     6,     6,     6,     6,     4,     6,     2,     4,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     2,
       3,     1,     1,     3,     3,     3,     2,     2,     3,     2,
       1,     1,     0,     2,     0,     2,     9,     6,     1,     1,
       1,     1,     1,     2,     0,     1,     1,     3,     3,     1,
       1,     3,     3,     3,     4,     1,     0,     2,     0,     3,
       0,     1,     0,    11,    12,     1,     1,     2,     2,     2,
       2,     0,     1,     0,     1,     3,     1,     1,     1,     3,
       2,     0,     3,     1,     1,     2,     1,     3,     4,     4,
       2,     5,     1,     2,     2,     2,     3,     2,     0,     2,
       2,     2,     2,     2,     2,     3,     1,     4,     6,     7,
      11,     3,     0,     3,     1,     1,     2,     2,     0,     1,
       1,     2,     2,     0,     3,     3,     2,     1,     1,     2,
       2,     4,     0,     2,     2,     2,     0,     3,     4,     4,
       0,     2,     0,     4,     0,     0,    11,     3,     0,     3,
       1,     1,     5,     4,     2,     0,     2,     1,     2,     3,
       2,     2,     2,     2,     3,     3,     3,     1,     0,     5,
       9,     1,     0,     1,     2,     2,     0,     2,     0,     5,
       7,     1,     0,     6,     2,     0,     3,     5,    14,    19,
       1,     1,     1,     3,     5,     1,     1,     1,     3,     0,
       1,     0,     1,     1,     1,     3,     0,     1,     1,     0,
       2,     1,     2,     1,     2,     0,     2,     1,     2,     2,
       6,     8,     8,     3,     5,     4,     4,     4,     3,     7,
       3,     1,     3,     3,     1,     1,     1,     1,     1,     1,
       3,     3,     1,     3,     3,     1,     3,     3,    12,     1,
       3,     4,     7,     4,     2,     1,     0,     1,     0,     7,
       9,     5,     6,     6,     4,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     1,     2,     2,     3,     4,
       5,     4,     4,     3,     4,     3,     3,     2,     4,     2,
       1,     1,     1,     1,     2,     2,     1,     1,     1,     2,
       2,     1,     2,     2,     1,     1,     6,     7,     7,     9,
       8,     8,     6,     9,     7,    10,     7,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     7,     7,    10,     2,     1,     1,     1,     3,     1,
       1,     1,     1,     1,     2,     2,     2,     2,     2,     2,
       2,     1,     3,     1,     2,     3,     0,     1,     3,     2,
       6,     6,     3,     0,     3,     0,    13,    14,     1,     0,
       2,     0,     1,     3,     2,     2,     4,     1,     2,     0,
       9,     7,     2,     0,     3,     2,     1,     3,     3,     3,
       2,     2,     1,     1,     1,     1,     2,     1,     3,     1,
       1,     5,     1,     4,     1,     2,     4,     5,     1,     1,
       1,     1,     3,     3,     2,     2,     2,     2,     1,     2,
       0,     5,     1,     2,     1,     0,     5,     7,     5,     7,
       7,     9,     1,     3,     3,     3,     1,     3,    11,    10,
       2,     0,     9,     2,     0,     4,     4,     4,     1,     1,
       1,     0,     7,     6,     6,     7,     6,     6,     9,     6,
       6,     6,     8,     8,     6,     6,     1,     0,     7,     6,
       7,     6,     6,     6,     7,     6,     6,     6,     7,     9,
       9,     6,     6,     6,     0,    14,     1,     1,     3,     3,
       1,     1,     1,     1,     1,     1,     1,     0,     1,     1,
       1,     1,     1,     1,     0,     6,     8,     2,     2,     2,
       2,     2,     3,     3,     2,     2,     2,     2,     3,     2,
       5,     4,     3,     3,     3,     1,     1,     0,     3,     2,
       2,     1,     3,     2,     1,     0,     8,    10,     2,     3,
       3,     0,     2,     5,     3,     1,     2,     3,     3,     3,
       3,     3,     3,     3,     3,     4,     3,     3,     1,     0,
       5,     5,     4,     2,     0,     4,     3,     5,     6,     4,
       6,     6,     5,     7,     1,     0,    10,     4,     2,     1,
       4,     5,     5,     2,     4,     1,     1,     1,     0,     1,
       0,     1,     0,     3,     0,     4,     1,     1,     1,     1,
       1,     1,     0,     5,     1,     4,     2,     3,     1,     2,
       2,     0,     6,     2,     0,     5,     3,     0,     2,     2,
       2,     3,     1,     3,     1,     2,     1,     0,     7,     1,
       3,     1,     1,     3,     5,     2,     1,     3,     7,     0,
       2,     2,     2,     3,     0,     2,     2,     1,     1,     3,
       3,     1,     2,     4,     4,     1,     1,     8,     1,     4,
       4,     4,     2,     1,     0,     3,     3,     4,     4,     4,
       4,     2,     1,     1,     0,     1,     0,     1,     5,     1,
       0,     1,     0,     3,     1,     3,     3,     2,     2,     1,
       4,     4,     2,     2,     4,     1,     0,     1,     1,     1,
       3,     0,     2,     0,     1,     3,     1,     0,     1,     2,
       4,     4,     2,     0,     2,     3,     2,     0,     3,     1,
       1,     2,     1,     2,     5,     6,     5,     1,     2,     1,
       4,     3,     4,     5,     4,     5,     4,     5,     2,     4,
       1,     2,     2,     2,     1,     1,     0,     4,     2,     1,
       2,     2,     4,     1,     2,     3,     1,     2,     0,     1,
       3,     2,     2,     3,     5,     6,     3,     4,     0,     1,
       3,     3,     3,     3,     3,     3,     1,     1,     1,     1,
       1,     1,     1,     2,     5,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     2,     2,
       2,     2,     1,     3,     0,     5,     3,     0,     5,     3,
       0,     1,     1,     1,     1,     5,     2,     1,     1,     1,
       1,     5,     2,     2,     2,     1,     3,     3,     2,     1,
       0,     3,     0,     5,     2,     5,     2,     1,     3,     3,
       0,     1,     1,     1,     1,     1,     1,     3,     3,     3,
       3,     3,     3,     3,     0,     1,     3,     5,     2,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       2,     2,     3,     3,     2,     3,     5,     4,     6,     3,
       5,     4,     6,     4,     6,     5,     7,     2,     3,     2,
       4,     3,     3,     4,     3,     4,     3,     4,     5,     6,
       6,     7,     6,     7,     6,     7,     3,     4,     4,     6,
       2,     1,     3,     2,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     2,     2,     5,     6,     6,     7,
       1,     1,     2,     4,     1,     1,     1,     2,     2,     2,
       1,     3,     4,     5,     5,     4,     1,     1,     4,     1,
       4,     1,     4,     1,     4,     1,     1,     1,     1,     6,
       4,     4,     4,     4,     6,     5,     5,     5,     4,     6,
       4,     6,     4,     4,     4,     4,     3,     5,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     4,     1,     4,     1,     4,     1,     2,
       1,     2,     1,     3,     3,     0,     3,     1,     1,     3,
       3,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       4,     3,     2,     3,     0,     3,     3,     2,     2,     1,
       0,     2,     2,     3,     2,     1,     1,     3,     5,     2,
       1,     4,     2,     0,     1,     0,     1,     2,     2,     2,
       3,     5,     1,     2,     0,     2,     1,     0,     1,     1,
       1,     3,     3,     3,     1,     3,     1,     1,     1,     1,
       1,     3,     1,     2,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     2,     1,     2,     3,     6,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     1,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       5,     3,     2,     2,     3,     7,     1,     1,     1,     0,
       2,     2,     1,     0,     1,     3,     1,     2,     0,     2,
       0,     2,     0,     1,     3,     4,     3,     1,     1,     1,
       2,     0,     7,     3,     2,     1,     1,     1,     0,     5,
       0,     4,     2,     1,     2,     0,     1,     3,     3,     3,
       3,     0,     4,     5,     5,     0,     1,     1,     1,     1,
       2,     2,     2,     1,     2,     0,     7,     0,     5,     0,
       4,     2,     2,     0,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     5,     2,     1,     3,
       2,     2,     3,     0,     5,     1,     0,     5,     2,     2,
       1,     1,     1,     2,     2,     3,     1,     2,     2,     3,
       3,     4,     2,     1,     2,     1,     1,     2,     2,     3,
       1,     1,     1,     1,     0,     1,     3,     5,     0,     2,
       0,     1,     2,     3,     2,     1,     1,     1,     0,     1,
       1,     1,     3,     0,     4,     2,     2,     1,     1,     0,
       1,     1,     1,     1,     2,     3,     0,     1,     2,     1,
       4,     4,     0,     1,     2,     1,     1,     3,     1,     1,
       4,     4,     4,     4,     1,     0,     3,     3,     4,     1,
       3,     3,     4,     1,     3,     3,     1,     6,     1,     3,
       3,     6,     1,     3,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       4,     4,     1,     1,     4,     4,     3,     0,     7,     1,
       0,     0,     7,     3,     4,     3,     1,     1,     1,     2,
       3,     5,     2,     5,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     1,     0,     1,     2,     1,
       2,     1,     1,     2,     2,     1,     1,     1,     1,     1,
       1,     2,     3,     1,     2,     1,     3,     1,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
       3,     0,     2,     1,  2079,  2080,  2083,  2087,  2088,  2015,
    2089,  2090,  2055,  2056,  2057,  2058,  2059,  2060,  2061,  2062,
    2063,  2064,  2065,  2066,  2068,  2067,  2069,  2070,  2071,  2072,
    2073,  2074,  2075,  2076,  2078,  2077,  2092,  2093,  2081,  2082,
    2084,  2085,  2054,  2086,  2094,  2095,  2096,  2091,  2044,  1326,
    2045,    10,  1327,  1322,  1323,  2099,  2050,  2051,  2049,  2052,
    2053,  2097,  2098,  2040,  2041,  2043,    11,    12,  2042,  2100,
       4,  2046,  2047,  2048,     8,  1411,  1484,     9,  2039,  1484,
       0,  1597,  1598,  1599,     0,  1600,  1601,  1602,  1603,  1604,
    1535,  1498,     0,  1605,     0,  1606,  1607,  1608,  1609,  1610,
    1611,  1612,  1613,  1614,     0,  1615,  1616,  1617,  1618,  1483,
    1619,  1620,  1621,  1622,  1460,  1466,  1623,  1581,     0,  1440,
    1441,  1437,  1439,  1438,  1442,  1425,   757,     0,   816,   815,
       0,  1924,   757,  1925,  1890,  1926,  1891,  1892,   225,     0,
     809,  1893,     0,   757,  1894,   286,   301,  1927,  1369,     0,
    1895,  1896,     0,     0,   412,   757,     0,  1897,   832,  1898,
       0,  1899,  1928,  1929,     0,     0,  1900,  1930,  1931,  1901,
       0,  1902,  1903,  1932,  1933,  1934,  1904,  1935,  1936,     0,
       0,   904,     0,  1905,  1937,  1906,  1907,     0,  1938,  1908,
    1909,  1910,  1939,  1940,  1911,  1912,  1913,     0,  1914,     0,
       0,     0,     0,     0,  1941,   757,  1915,     0,   910,     0,
    1916,     0,  1942,  1917,     0,  1918,  1919,  1920,  1921,  1922,
     904,  1577,  1461,     0,     0,   820,     0,  1923,  1943,  2026,
    2027,     0,     0,     0,    42,    48,    24,    23,    25,    59,
      64,    39,    18,    55,    43,    91,    92,    93,    31,    27,
      22,    28,    32,    45,    33,    44,    21,    40,    58,    46,
      62,    47,    63,    34,    53,    51,    41,    56,    57,    76,
      61,    87,    67,    30,    68,    82,    69,    83,    70,    38,
      17,    80,    78,    79,    35,    54,    77,    81,    19,    20,
      84,    60,    75,    72,    88,    86,    94,    73,    49,    14,
      15,    65,    37,    16,    36,    29,    90,    26,   818,    66,
      71,    52,    74,    89,    50,    85,   878,   877,   912,   881,
     888,    96,    97,    98,     7,  1395,  1397,  1396,  1484,  1435,
    1436,  1400,  1445,  1455,  1444,  1448,  1456,  1443,  1462,     0,
     100,   102,   103,   104,   107,   108,   101,    95,    99,   106,
     112,   105,   111,   109,   110,   113,   114,   115,  1675,  1084,
    1673,  1674,  1672,  1417,     0,  1484,  1419,  1418,  1484,  1429,
    1455,     0,  1624,  1625,  1626,  1627,  1628,  1629,  1680,  1681,
    1682,  1683,  1684,  1686,  1685,  1697,  1698,  1699,  1700,  1701,
    1702,  1703,  1704,  1705,  1706,  1707,  1708,  1709,  1710,  1711,
    1712,  1713,  1714,  1715,  1716,  1717,  1651,  1718,  1719,  1720,
    1721,  1722,  1723,  1724,  1725,  1726,  1696,  1727,  1728,  1729,
    1730,  1731,  1732,  1733,  1734,  1735,  1736,  1689,  1737,  1738,
    1739,  1740,  1741,  1742,  1743,  1744,  1745,  1746,  1747,  1748,
    1749,  1750,  1751,  1752,  1754,  1753,  1755,  1756,  1757,  1758,
    1759,  1760,  1761,  1762,  1763,  1764,  1765,  1766,  1690,  1767,
    1768,  1769,  1770,  1771,  1772,  1773,  1774,  1775,  1776,  1777,
    1778,  1779,  1780,  1781,  1782,  1783,  1784,  1785,  1786,  1787,
    1788,  1789,  1790,  1791,  1792,  1793,  1794,  1691,  1795,  1796,
    1692,  1797,  1798,  1799,  1800,  1801,  1802,  1803,  1804,  1805,
    1806,  1807,  1808,  1809,  1810,  1811,  1812,  1813,  1814,  1815,
    1816,  1817,  1818,  1821,  1819,  1820,  1822,  1823,  1824,  1825,
    1826,  1827,  1828,  1829,  1830,  1831,  1832,  1833,  1834,  1835,
    1836,  1837,  1838,  1839,  1840,  1841,  1842,  1843,  1844,  1845,
    1846,  1847,  1693,  1848,  1849,  1850,  1851,  1852,  1853,  1854,
    1855,  1856,  1857,  1858,  1859,  1860,  1861,  1863,  1862,  1865,
    1864,  1866,  1867,  1868,  1869,  1369,  1870,  1871,  1872,  1873,
    1874,  1875,  1876,  1877,  1878,  1879,  1880,  1881,  1882,  1652,
    1883,  1884,  1885,  1886,  1887,  1888,  1694,  1889,  2025,  1339,
    1388,  1387,  1362,  1383,  1649,  1595,  1596,  1357,  1650,  1647,
    1687,  1688,  1695,  1648,  1340,  2021,  1646,  1534,     0,     0,
    1496,  1497,  1500,  1499,  1501,  1494,  1495,  1307,  1389,  1630,
    1631,  1632,  1633,  1635,  1634,  1636,  1944,  1945,  1946,  1947,
    1948,  1949,  1950,  1951,  1952,  1953,  1954,  1955,  1665,  1956,
    1957,  1958,  1959,  1960,  1961,  1964,  1962,  1963,  1965,  1966,
    1967,  1968,  1969,  1970,  1971,  1972,  1973,  1974,  1975,  1976,
    1977,  1978,  1979,  1980,  1981,  1982,  1666,  1667,  1983,  1984,
    1985,  1986,  1987,  1988,  1989,  1990,  1991,  1992,  1993,  1994,
    1995,  1996,  1997,  1998,  1999,  2000,  2001,  2002,  2003,  2004,
    2005,  1669,  2006,  2007,  1668,  2008,  2009,  2010,  2011,  2012,
       0,  1450,  1679,  1664,  1451,  1637,  1676,  1663,  1670,  1671,
    1678,  1677,  1514,  1306,  1516,  1458,  1468,  1464,  1472,  1467,
       0,     0,     0,     0,  1484,   756,   755,   741,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    13,     0,   765,   265,  1359,
    1358,  1302,   808,     0,  1298,  1299,   412,     0,   744,   285,
       0,     0,     0,     0,     0,     0,     0,   485,     0,     0,
       0,     0,     0,     0,     0,   161,     0,   296,   295,     0,
     401,     0,   598,     0,     0,   412,     0,     0,     0,  1368,
    1367,  1363,  1373,     0,  1366,  1646,     0,  1819,  1512,  1513,
    1394,  1857,   869,     0,     0,     0,   674,   501,     0,   500,
       0,     0,   498,     0,     0,   411,     0,     0,   502,   496,
     495,     0,     0,   499,     0,   497,     0,     0,   745,  1768,
    1503,   831,   818,  1698,   527,   531,   522,   528,   535,   534,
     523,   520,   521,  1831,     0,     0,     0,   517,  1328,  1330,
     526,  1329,     0,   565,   571,   570,   569,     0,   566,   567,
     572,     0,   738,  1299,   772,  1311,   903,     0,     0,   519,
     737,  1870,     0,     0,     0,   678,     0,   679,     0,  1845,
     749,   219,  1644,  1850,  1919,  1870,  1645,   215,  1642,   182,
    1643,  1639,  1640,  1641,  1638,     0,     0,   566,     0,   746,
     747,   909,   907,     0,     0,     0,     0,  1727,  1789,  1798,
    1841,  1850,  1919,  1870,   170,     0,   214,  1850,  1919,  1870,
       0,   765,     0,     0,  1459,   740,   739,     0,   983,     0,
     979,   819,   822,     0,   944,   886,     0,   757,     0,     6,
     817,   813,   906,   906,     0,   906,     0,   882,     0,  1398,
    1455,  1434,  1490,  1402,     0,     0,  1480,  1476,  1473,  1481,
    1482,  1475,  1463,  1073,  1074,  1075,  1072,  1076,  1071,     0,
    1406,  1447,  1412,     0,  1422,  1421,  1420,  1427,  1490,  1431,
    2028,  2029,  1536,  1361,  1380,     0,     0,     0,     0,     0,
       0,     0,  2033,  2037,     0,  2035,  2030,  1449,  1522,  1515,
    1517,  1519,  1470,  1469,  1465,     0,     0,  1586,     0,     0,
    1587,  1588,     0,  1583,  1585,     0,  1490,     0,     0,  1649,
    1312,  1650,  1647,  1660,  1646,     0,   505,   118,     0,     0,
     505,     0,     0,     0,     0,     0,  1720,  1211,  1221,  1219,
    1220,  1213,  1214,  1215,  1218,  1216,  1217,     0,   666,  1212,
       0,   118,     0,     0,   385,     0,     0,     0,     0,   118,
       0,     0,     0,   761,   764,   742,     0,     0,  1282,  1303,
       0,     0,     0,   547,   556,   548,   553,     0,   550,     0,
       0,   558,     0,   549,   551,   552,   557,     0,   554,   555,
       0,     0,   753,   288,     0,     0,     0,     0,     0,   774,
     805,   300,   299,   118,   298,   297,     0,     0,   612,   118,
       0,   163,   415,     0,   458,   118,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1372,  1378,     0,  1370,  1537,
    1393,  1493,     0,   844,  1767,     0,   453,     0,     0,  1767,
     796,  1767,     0,  1767,   156,  1304,     0,     0,     0,     0,
    1767,   148,  1767,     0,  1767,   416,  1767,     0,  1767,   150,
       0,  1767,   262,   503,  1511,  1510,  1502,  1509,     0,   524,
     533,   532,   530,   529,   525,  1331,     0,   515,   516,  1522,
    1525,   513,     0,   564,     0,     0,     0,     0,   847,  1300,
       0,   752,     0,     0,   681,   681,   681,   748,   218,   216,
       0,     0,     0,     0,     0,   754,     0,     0,     0,  1890,
    1891,  1032,  1275,     0,  1651,  1892,  1893,  1894,  1176,  1185,
    1177,  1179,  1186,  1895,  1896,  1746,  1897,  1898,  1319,  1899,
    1900,  1022,  1902,  1903,  1904,  1181,  1183,  1905,  1906,     0,
    1320,  1908,  1909,  1813,  1911,  1912,  1914,  1915,  1187,  1917,
    1918,  1919,  1920,  1921,  1922,  1318,     0,  1188,  1923,  1222,
    1324,  1325,  1284,     0,     0,  1297,     0,  1166,     0,  1016,
    1018,  1019,  1043,  1044,  1020,  1049,  1050,  1062,  1017,     0,
    1296,  1085,  1165,  1170,     0,  1164,  1160,   894,  1294,  1276,
       0,  1161,  1353,  1352,  1354,  1355,  1351,  1314,  1649,  1656,
    1021,  1650,  1647,  1321,  1356,  2021,  1646,     0,     0,     0,
       0,     0,  1576,   221,     0,   222,  1850,   171,   206,   178,
     205,   179,   209,   208,     0,  1718,   172,     0,   176,     0,
       0,     0,     0,     0,   210,   743,   262,     0,     0,   981,
       0,   984,     0,   980,   821,   818,  1289,  1288,  1290,     0,
     880,   879,     5,   824,   905,     0,     0,     0,     0,     0,
       0,     0,   937,   926,   934,   938,   945,  1490,  1491,     0,
    1485,     0,  1484,  1484,  1478,  1477,  1474,     0,     0,     0,
       0,     0,     0,  1345,  1344,  1403,  1405,  1348,     0,  1490,
       0,     0,  1382,     0,  1386,  1384,  1522,  1531,  1522,  1532,
    1533,  2031,     0,     0,  2034,  1452,     0,  1523,  1349,  1350,
    1528,     0,  1518,  1526,  1529,  1471,  1484,  1594,     0,  1589,
    1592,     0,  1584,     0,  1313,     0,     0,     0,     0,     0,
     506,     0,     0,     0,   117,   794,   792,     0,     0,     0,
     799,     0,     0,     0,   639,     0,     0,   640,   638,   641,
     652,   655,     0,   589,   154,   155,     0,     0,     0,     0,
       0,     0,   227,   252,     0,     0,     0,     0,     0,     0,
     144,     0,     0,     0,   383,   697,   697,     0,     0,   697,
       0,     0,     0,   697,     0,   226,   228,   251,     0,     0,
       0,     0,     0,     0,     0,     0,   147,  1413,     0,   759,
     760,     0,   763,     0,  1279,  1278,  1309,  1283,   807,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   271,   272,   118,   270,     0,     0,   455,     0,  1025,
    1060,  1060,  1060,  1040,  1040,  1034,  1023,  1067,     0,  1060,
    1037,  1026,     0,  1024,  1070,  1070,  1055,     0,   998,  1008,
    1010,  1011,  1041,  1042,  1012,  1047,  1048,  1009,  1084,  1655,
    1021,  1657,  1654,  1653,     0,     0,   804,     0,     0,   486,
       0,   456,     0,     0,     0,   159,     0,     0,   421,   420,
       0,     0,   457,     0,   385,   378,   342,     0,     0,  1726,
       0,  1310,     0,     0,  1376,  1371,  1374,     0,  1364,  1378,
     870,   874,   871,     0,   872,     0,   988,     0,   262,   673,
       0,     0,     0,   262,     0,     0,  1767,     0,     0,     0,
     262,     0,     0,     0,     0,     0,     0,     0,     0,   262,
       0,   260,   261,     0,   494,  1504,  1507,  1508,     0,   825,
     827,   829,   828,   830,   826,   514,   511,   512,     0,  1524,
    2013,  2019,     0,  1538,  1539,     0,  1736,  1761,  1783,  1846,
    1848,     0,  1866,     0,   573,   593,   568,     0,     0,   841,
     834,     0,     0,   857,   518,  1530,     0,   680,   677,   676,
     675,   217,   183,     0,     0,   595,  1845,   751,     0,     0,
    1168,  1169,  1059,  1046,  1274,     0,     0,  1054,  1053,     0,
       0,     0,     0,     0,  1030,  1029,  1028,  1167,  1235,     0,
    1027,     0,     0,     0,     0,  1060,  1060,  1058,  1104,     0,
       0,  1031,     0,     0,  1254,     0,  1260,     0,     0,     0,
    1066,     0,  1064,     0,     0,  1140,  1162,  1088,  1089,  1652,
    1166,  1232,     0,  1315,     0,     0,  1052,     0,  1084,     0,
       0,     0,     0,  1287,  1230,     0,     0,  1117,  1228,     0,
    1119,     0,     0,     0,  1222,  1221,  1219,  1220,  1213,  1214,
    1215,  1218,  1216,  1217,  1226,  1101,     0,     0,  1100,  1522,
       0,   947,   893,  1277,     0,     0,  2020,  2022,  1573,  1572,
    1571,  1570,  1546,     0,  1542,  1543,     0,  1574,  1575,   223,
     224,   220,     0,   181,   180,     0,   203,   204,   175,     0,
     199,   200,   185,   196,   198,   197,   195,   173,   184,   186,
     192,   193,   194,   174,   213,   211,     0,   509,  1484,     0,
     985,     0,   947,   859,   861,   862,     0,  1284,   810,  1292,
       0,     0,   814,   886,   891,   885,   890,   913,   914,   919,
     889,     0,   943,   943,   928,   922,   927,   923,   929,   936,
     884,   925,   883,     0,   939,     0,  1492,  1401,  1490,   998,
    1484,  1423,  1484,  1479,  1409,  1078,  1079,  1080,  1081,  1083,
    1082,  1410,  1407,  1077,  1408,  1347,  1346,     0,     0,     0,
       0,  1430,  1379,     0,  1360,  1385,  2032,  2038,  2036,     0,
       0,   998,  2016,  1590,  2016,   998,     0,     0,   472,     0,
       0,     0,     0,     0,   507,     0,     0,     0,   791,   790,
       0,     0,     0,     0,     0,   802,   336,     0,   259,     0,
       0,     0,     0,     0,     0,     0,     0,   644,   645,   654,
     653,   651,   623,   625,   624,   615,     0,   616,     0,     0,
     622,   632,  1661,  1021,   629,  1662,  1659,  1658,     0,     0,
       0,     0,     0,     0,     0,   257,     0,   256,     0,     0,
       0,     0,     0,   662,   667,   143,     0,     0,   127,   129,
       0,     0,   125,   131,   128,   130,   126,   132,   124,     0,
       0,   123,     0,     0,     0,     0,   142,     0,     0,     0,
       0,   387,   398,     0,     0,     0,     0,   118,   118,   384,
     696,   238,     0,     0,     0,     0,     0,     0,     0,   249,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   146,   145,     0,     0,   191,   758,   762,  1280,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   287,   269,   268,     0,   274,     0,   475,  1653,
     454,     0,   998,     0,     0,     0,   992,  1073,  1072,  1071,
       0,  1013,  1015,     0,     0,   789,   789,   789,   789,   789,
     773,   775,   311,   152,     0,     0,   461,   464,     0,   116,
     163,   301,     0,   162,   164,   166,   167,   168,   165,   169,
     414,     0,   426,   425,   427,     0,   422,     0,   141,   382,
       0,   303,   366,     0,     0,   399,     0,     0,     0,     0,
     714,     0,  1377,     0,     0,     0,     0,   873,     0,   957,
     843,   949,   959,   950,   952,   986,  1302,     0,   841,     0,
     658,     0,   797,     0,   656,   157,  1305,     0,     0,     0,
       0,   491,   149,     0,   262,   417,     0,   262,   151,     0,
     409,   262,   504,  1505,  1506,   869,   510,     0,     0,  2018,
    1332,     0,  1333,     0,     0,   577,   576,   587,     0,   578,
     579,   575,   574,   580,     0,     0,   595,   836,     0,   838,
    1284,     0,   833,     0,   854,     0,   852,     0,  1301,   856,
     845,     0,     0,   566,     0,     0,   262,   750,  1232,     0,
       0,     0,  1238,     0,     0,  1273,  1270,     0,     0,  1232,
       0,     0,     0,     0,  1245,  1246,  1247,  1244,  1248,  1243,
       0,     0,  1249,  1242,     0,     0,     0,     0,     0,  1057,
    1056,     0,     0,     0,     0,     0,     0,     0,  1141,  1170,
       0,     0,  1206,     0,  1232,  1259,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1232,  1265,     0,  1285,
    1284,     0,     0,     0,     0,  1316,  1086,  1102,  1295,     0,
    1286,     0,     0,  1109,     0,  1266,  1136,     0,  1124,     0,
    1118,     0,  1122,  1126,  1105,  1287,  1231,     0,  1229,     0,
       0,  1103,     0,  1098,  1096,  1097,  1090,  1091,  1092,  1093,
    1094,  1095,  1099,  1210,  1208,  1209,     0,     0,     0,  1121,
    1762,  1789,     0,   904,   904,   892,   902,  1293,     0,   988,
       0,     0,     0,  1171,     0,  2024,  2023,     0,     0,     0,
       0,     0,  1084,     0,   212,   998,   982,   866,     0,     0,
     988,     0,   865,   812,   811,  1291,     0,     0,   917,   918,
       0,   935,     0,   857,   857,     0,     0,     0,  1399,  1486,
    1433,  1454,  1424,  1457,  1404,  1446,     0,  1428,  1381,  1520,
    1527,  1580,     0,  2017,     0,     0,   471,   470,     0,     0,
       0,     0,   705,   683,   508,   706,   684,     0,   793,     0,
       0,     0,     0,     0,   262,   800,   258,   801,   699,   707,
       0,   642,   643,     0,   626,   614,     0,     0,   621,     0,
     620,  1015,     0,     0,     0,   686,   153,   254,   691,   255,
     253,   687,     0,  1308,     0,     0,     0,   137,     0,     0,
       0,     0,   120,   119,   138,   136,     0,   135,     0,   711,
     689,   701,   386,   397,     0,   390,   391,   388,   392,   393,
       0,     0,     0,   230,     0,     0,   241,   247,   248,   246,
     262,   262,   244,   245,   243,   250,   690,     0,   702,   242,
     240,     0,   229,   713,   695,     0,   712,   703,   694,   189,
     188,   190,     0,     0,     0,     0,     0,     0,     0,   560,
     542,   559,     0,     0,     0,   536,   290,   267,   474,     0,
       0,     0,     0,   993,     0,     0,   998,     0,     0,  1006,
     999,  1007,     0,     0,     0,     0,   789,   788,     0,     0,
       0,     0,     0,   776,   798,     0,   460,     0,     0,   342,
     158,     0,     0,   413,     0,     0,     0,   989,     0,     0,
       0,     0,   302,   304,   306,   307,   308,     0,   380,   381,
       0,     0,   370,     0,   344,   345,     0,     0,     0,     0,
     601,     0,     0,     0,   650,   648,   634,     0,  1375,  1369,
     875,   876,     0,   886,     0,   959,     0,   958,   970,     0,
       0,   976,   974,     0,   976,     0,   976,     0,   951,     0,
     953,   970,  1303,   987,   842,   262,     0,   262,     0,   262,
       0,   262,     0,   735,     0,   450,   262,   493,     0,  1521,
    2014,  1547,  1548,     0,  1540,  1541,     0,   589,     0,   586,
     581,   583,     0,   590,     0,     0,   839,   840,   855,   848,
     850,   849,     0,     0,   846,   492,     0,   262,     0,   591,
     908,     0,  1240,  1241,     0,     0,     0,     0,  1269,     0,
       0,  1202,     0,  1200,  1178,  1180,  1039,     0,  1190,     0,
    1033,  1203,  1204,  1182,  1184,     0,  1036,     0,  1223,     0,
       0,  1191,  1143,     0,     0,     0,     0,  1222,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1155,  1154,  1192,
    1205,     0,     0,  1257,  1258,  1193,  1068,  1069,  1070,  1070,
       0,     0,  1264,     0,     0,     0,  1198,  1163,  1233,  1061,
    1062,     0,     0,     0,     0,     0,     0,     0,     0,  1125,
    1120,     0,  1123,  1127,     0,     0,     0,     0,  1111,  1137,
    1107,     0,     0,  1113,     0,  1138,   904,   904,   904,   904,
     901,     0,     0,   946,   931,     0,     0,  1175,  1172,  1555,
    1556,  1557,  1558,  1559,  1560,  1561,  1562,  1563,  1564,  1566,
    1567,  1568,  1565,  1569,  1551,  1552,     0,  1544,  1545,   177,
       0,   201,   187,  1580,     0,     0,   860,   841,   863,   823,
     915,     0,  1224,   916,   942,   941,   940,   920,   924,   921,
       0,  1488,  1414,  1579,  1582,  1593,  1591,  1426,   473,   704,
     682,   698,   789,     0,   335,     0,     0,     0,   803,   636,
       0,   617,   618,   619,     0,   708,   685,   700,     0,     0,
     664,     0,   665,   663,   133,   121,   140,   139,   122,   134,
     389,   394,   396,   395,   311,     0,     0,     0,   231,   239,
     236,     0,     0,  1281,   537,     0,   538,   544,     0,     0,
       0,     0,   546,   291,   118,     0,   275,   279,   805,   805,
       0,   280,   805,   276,   805,   273,   476,     0,  1813,  1214,
     477,   465,   468,   469,   466,   467,   445,     0,     0,     0,
     996,     0,     0,     0,     0,     0,     0,   998,  1084,     0,
       0,   784,  1341,  1342,   783,  1343,   780,   779,   787,   786,
     778,   777,   782,   781,     0,     0,     0,   322,     0,     0,
     316,     0,     0,   650,   310,   313,   314,     0,   462,   463,
       0,   301,     0,   429,   423,   459,     0,   991,   303,   328,
     362,     0,   377,     0,   364,   363,   365,     0,   372,   341,
       0,   771,   406,   403,     0,   601,     0,     0,   646,   627,
     647,     0,     0,   630,     0,   635,   611,     0,  1391,   868,
    1392,   961,   968,     0,   948,     0,   975,   971,     0,   972,
       0,     0,   973,     0,     0,   968,     0,   659,     0,   657,
       0,   489,     0,   660,   262,   262,   410,   874,     0,     0,
     588,   584,     0,     0,   561,   592,   835,   837,   853,   851,
       0,   562,   594,  1233,  1239,  1045,     0,  1272,  1268,     0,
       0,     0,  1234,     0,     0,  1252,  1251,  1142,  1253,     0,
       0,     0,  1153,  1152,  1150,  1151,  1144,  1145,  1146,  1147,
    1148,  1149,  1262,  1261,  1255,  1256,  1065,  1063,     0,  1195,
    1196,  1197,  1263,  1207,  1051,  1084,  1087,     0,     0,  1110,
    1267,  1128,     0,     0,  1237,     0,  1106,     0,     0,     0,
       0,  1115,  1223,     0,     0,     0,     0,     0,     0,   896,
     895,     0,   933,  1173,  1174,     0,     0,     0,  1578,     0,
     867,   858,     0,  1432,     0,  1487,     0,   337,     0,     0,
     650,   637,   633,     0,     0,     0,   309,     0,     0,     0,
       0,   264,   692,   693,     0,     0,     0,   541,   540,   274,
       0,     0,     0,     0,     0,     0,     0,   447,     0,     0,
     452,   441,   443,     0,     0,     0,   994,  1000,  1001,  1002,
    1003,  1004,  1005,   997,  1014,   439,   785,     0,     0,   320,
     324,   325,   323,   315,   650,   342,   374,     0,     0,     0,
     431,     0,     0,   990,     0,   326,     0,   366,   305,   379,
     381,     0,     0,     0,   343,     0,     0,     0,   766,     0,
     408,   404,     0,     0,   600,     0,     0,  1021,   650,   649,
     730,   731,   728,   729,     0,     0,  1365,   960,     0,     0,
     962,     0,     0,   964,   966,     0,     0,     0,     0,     0,
    1306,   262,   262,   262,   736,   451,     0,  1549,  1550,     0,
     582,     0,  1271,  1189,  1199,  1038,  1201,  1035,  1250,     0,
       0,     0,     0,  1194,  1317,  1134,  1132,  1129,     0,  1130,
       0,     0,     0,  1112,  1108,     0,  1114,  1139,   900,   899,
     898,   897,     0,     0,   887,  1553,     0,  1334,  1338,  1335,
    1554,  1084,   864,     0,  1489,   795,     0,   650,   374,   710,
     688,   709,   232,   233,   234,   235,     0,   237,     0,   543,
     539,   266,   289,   277,   282,     0,   283,   278,   281,   449,
     448,   446,   442,   444,   995,     0,   671,     0,   445,     0,
       0,   312,   374,   348,     0,   317,     0,   771,   303,   430,
       0,     0,   424,   366,     0,     0,   327,     0,   370,     0,
     367,     0,   371,   375,     0,     0,   768,   405,     0,   400,
       0,     0,     0,     0,   602,   609,   609,   628,  1015,   610,
       0,  1390,     0,   969,   978,     0,   965,   963,   954,     0,
     956,   672,   490,   661,     0,   585,   262,  1156,     0,     0,
       0,  1131,  1236,  1135,  1133,  1116,   930,   932,  1337,  1336,
     202,  1225,     0,   374,   338,   263,   545,   284,   671,     0,
     669,   440,     0,   319,   318,     0,   353,     0,     0,   767,
     432,   433,   428,     0,   370,   332,   330,   334,   331,   329,
     333,     0,   372,   368,   369,     0,   769,   770,   407,   806,
       0,     0,   650,     0,     0,   607,   605,   604,     0,   988,
     967,     0,   955,   563,  1157,     0,  1158,   342,   339,   668,
     670,     0,   346,   347,     0,   321,   349,   350,     0,     0,
       0,   372,   361,   293,   376,   650,   609,   372,   603,   608,
     631,     0,   977,  1159,   348,     0,     0,     0,     0,   351,
       0,   352,   373,     0,     0,     0,   478,   479,   436,   294,
     372,   606,   988,   734,   353,     0,   358,     0,   357,     0,
     354,   355,     0,     0,   484,     0,     0,   434,   437,   438,
     988,   596,   733,   732,     0,   445,     0,   356,   359,   360,
       0,   488,   480,   418,     0,   597,   716,   727,   715,   717,
     725,   722,   724,   723,   721,   340,     0,   483,   487,     0,
     481,   435,     0,   726,   720,   886,   877,     0,     0,   718,
     727,   436,   488,   719,     0,   482,   419
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,     2,    70,   232,   233,   234,  1435,  1996,   235,
     236,   237,   238,   239,   240,   241,   242,  1457,   243,   244,
    1110,  1575,  2093,   245,   914,   915,  1817,  1818,  2037,  1819,
    1820,  1808,  1319,  1321,   246,   247,   248,  1314,  1801,   249,
     250,  1485,  1486,  1462,  1487,  1440,  1634,  3277,   251,   252,
    2055,  1523,  2507,  2875,   760,  1520,  2864,  2865,   253,  1572,
    2551,  2552,  2553,  2554,  2534,  2924,  2925,  2926,  2555,  3165,
    3316,  2556,  1926,  2114,  2563,  2564,  3386,  3435,  3436,  3437,
    3480,  3167,  2562,  2948,  3173,  3305,   254,  3405,  2112,  2557,
    2558,   255,   256,  1474,  2009,  2454,   257,   785,  2952,  3180,
    3329,   258,   826,   259,  1577,   260,   261,  1580,  2105,  2106,
    3161,  3310,  3392,  3486,  3487,  3298,  3130,  3131,  3132,   262,
     263,   264,   265,  1967,  2085,  2086,  2880,  1426,  1907,  1527,
    2057,  2058,   266,  3466,  3467,   786,  3520,   267,   268,   269,
     270,   827,  1162,  3415,  1430,   271,   272,   845,   846,   273,
    1091,  2500,   274,   275,   857,  2203,   859,  1663,  2629,  2630,
    3004,  2176,  1031,   276,   277,  2186,  2206,   278,   787,  2957,
    3333,  3334,  3416,   279,   788,  1453,  1946,  1947,  1948,  2958,
    1949,  2962,  1950,  2574,  2575,  2576,  2966,   280,  1451,  1941,
     281,   282,   283,  1972,  1047,   284,  3380,   285,  1138,   286,
     878,  1678,   287,  2012,   288,   289,   290,  2577,  3508,  3522,
    3523,  3524,  3194,  3494,   291,  3510,   293,   294,   295,   747,
    1063,  1064,  1065,   296,  3178,   297,   298,  2080,  2081,  2528,
     299,   300,  1919,  2398,   301,   302,   303,  1567,   304,   305,
     306,   307,   308,   941,   932,  1345,  1842,   309,  1639,   832,
    3511,  1669,  2188,  2189,  2192,  3512,  1606,   312,  1673,  2197,
    2200,  3513,  1832,  1833,  1834,  1835,  1836,  2348,   314,  1132,
    2126,  3514,  1267,   317,   318,   319,  1781,  2325,   867,  1355,
     903,   946,   947,  1847,  1848,  1362,  1862,  1855,  1857,  3082,
    3254,  1363,  1860,  1364,  1365,  2363,   320,  2329,  2130,  2131,
    2132,  2587,  2597,  2977,  3203,  2133,   929,  2134,  2138,  2546,
    2547,  1951,  2066,  2518,  1548,  1268,  1269,  1270,  1710,  1721,
    1704,  1551,  1271,  1272,  1273,  1554,  1274,  1275,  1276,  1277,
    1693,  1746,  1278,  1279,  1730,   970,  2208,  2247,  1281,  1282,
    1283,  2316,  1774,  1049,  1284,  2882,  1776,  2267,  2230,  3065,
    2211,  1691,  2231,  2245,  2680,  2251,  2256,  2703,  2704,  2268,
    2286,  1285,  2215,  2216,  2659,  1695,  1286,  1068,  1069,  1736,
    2282,  1348,  1349,   934,  1287,  1288,  1289,  1664,   930,  3199,
    1145,   613,  2432,  1505,   753,   864,  1290,  1291,  1292,  1293,
    1294,  1295,  1296,   849,   850,  2171,  3260,  2501,  2904,  1409,
    1821,  1297,   591,   754,   321,   791,   792,   793,  1125,  1126,
    1595,  1598,  1392,  1894,   592,   593,   614,  3196,   322,   323,
     324,   325,   326,  1367,   952,  1386,  1888,   971,    74,    79,
      75,   972,   364,   365,  1870,   327,   724,  1871,  1389,   978,
    2801,   368,   329,   330,   369,   332,   701,   370,   954,   334,
     955,   335,   336,   337,   338,   962,   339,  1369,  1370,  3095,
    1371,   340,   341,   615,   616,   342,  1167,  1635,  1166,   800,
     343,   344,   999,  1000,  1001,  1180,  1648,  1181,  1412,  1413,
     345,   346,   609,   347,   348,   349,  1653,  1654,   350,  1794,
    1795,  1796,   351,  2621,  2622,   352,  2774,  2775,  2776,   353,
    1790,   354,   355,   923,  2804,   356,   720,   357,  1013,   594,
     595,   596,  1299,   704,   889,   863,  1300,  1020,   705,   359,
     707,   598,   599,   600,   601,   602,   603,  1023,   711,  1649,
      76,  2382,  1650,  1303,  1304,  1786,  1305,   606,   982,   992,
     993,  2383,   995,    77,   996
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3169
static const int yypact[] =
{
   -3169,   340, 14089, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, 16842, -3169, -3169, 36139,
     694, -3169, -3169, -3169, 33605, -3169, -3169, -3169, -3169, -3169,
     646, 38661, 15592, -3169, 53338, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, 53338, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, 36982,   214, -3169, -3169,   226, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169,  1014,  3488, -3169, -3169,
   39081, -3169,   233, -3169, -3169, -3169, -3169, -3169, -3169, 53338,
   48729, -3169,   445,   542, -3169,    87,  9763, -3169, 34880, 39501,
   -3169, -3169, 53757,   557,  4323,  1014, 39921, -3169,   941, -3169,
   31901, -3169, -3169, -3169,   817, 46215, -3169, -3169, -3169, -3169,
     637, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, 48729,
    1029,   507, 32328, -3169, -3169, -3169, -3169, 48729, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, 40341, -3169,   612,
     467, 54176, 54595, 45796, -3169,   585, -3169, 53338,   191, 35727,
   -3169, 55014, -3169, -3169,   677, -3169, -3169, -3169, -3169, -3169,
     507, -3169, 36982, 30614, 47053,   880,   657, -3169, -3169, -3169,
   -3169,   681,  5846,   676, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,   755, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169,  1725, -3169,   631,  1826,
     791, -3169, -3169, -3169, -3169, -3169, -3169, -3169, 62114,   712,
   -3169, -3169, -3169,   809, -3169,   758, -3169, -3169, -3169,  1127,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,   648,
   -3169, -3169, -3169, -3169,  1219, 36560, -3169, -3169, 62114, -3169,
     856, 40761, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, 34030, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169,   123, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, 53338, 53338,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   14592, -3169, -3169, -3169,   887, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169,   970, -3169,   237,  1208, -3169, -3169,
   36982,   770,   770,  1427, 62114, -3169, -3169, -3169, 44120, 53338,
   53338, 53338, 44120, 53338, 47053, 53338, 28897, 53338, 53338, 47053,
   47053, 53338, 53338, 53338, 53338, -3169,  1489,    60, -3169, -3169,
   -3169,  1220, -3169,  1256, -3169,  1283,  2494,  1029, -3169, -3169,
   48729,  1097, 44120, 53338,  1088,  1202, 53338, -3169, 53338,   609,
   53338,   635,   537,  1184, 53338, 53338, 53338, -3169, -3169, 53338,
   -3169, 53338, -3169, 53338,   746,  1367,  1464,  1455,   384, -3169,
   -3169, -3169,  1281,  1253, -3169,  1307, 40761, 40761, -3169, -3169,
   -3169,   717, -3169, 47053, 44539, 53338,  1558, -3169, 55433, -3169,
   44958, 55852, -3169,  1414,  1680, -3169, 56271, 56690, -3169, -3169,
   -3169, 57109, 57528, -3169, 57947, -3169,  1551, 58366, -3169,   763,
   -3169, -3169,   755,  -106, -3169,   219,   154,   224, -3169, -3169,
     217,   232,   423,  -106,  1112, 49148, 53338,  1567, -3169, -3169,
   -3169, -3169, 40761,  1492, -3169, -3169, -3169,  1528,   -85, -3169,
   -3169, 48729, -3169, -3169, -3169, -3169, -3169, 48729,   952, -3169,
   -3169,  1029,  1621,  1715, 53338, -3169, 53338, -3169, 48729, 53338,
   -3169, -3169, -3169,  1770,  1454,  1694, -3169,  1486, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169,  1646,  1657,    24,  1029,  1576,
   -3169, -3169,  1665, 19439,   514, 40761, 32755, 47472, 61299,    52,
   34880, 58785,  1545,    60, -3169,   736, -3169,  1866,  1553,  1740,
     -18,    60, 48729, 62517, -3169, -3169, -3169, 26350, 59204,  1629,
    1542, -3169,  1804, 19882, -3169,  1577,  1579,  1014,  1580, -3169,
   -3169, 48729,  1943,  1943,  1936,  1943,   951,  1030,   657, -3169,
   -3169, -3169,  1608, -3169,  1605,  1618, -3169,   433,  1830, -3169,
   -3169, -3169, -3169,  1691,  1700,  1704,  1705, -3169,  1716,  1061,
   -3169, -3169, -3169,  1927, -3169, -3169, -3169, -3169,  1608, -3169,
   -3169, -3169, -3169, -3169,  2016,  2004, 34880, 34880,  1721,    34,
   14673, 14592, -3169, 15149,  1004, -3169, -3169, -3169,   153, -3169,
   -3169, -3169,  1893, -3169, -3169,  1921, 53338, -3169,  1777, 53338,
   -3169, -3169, 59623, -3169, -3169,   770,  1608,  1220,  1714,  1717,
   -3169,  1723,  1729, -3169,  1730,  1060,  1719,   454,   248,  1859,
     -35,   311,  1732,   136,   969,  1845, 53338, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169,  1734, -3169, -3169,
    1735,   -40,  1105,  1834,   -69,  2500,  1135,  1895,     2,   888,
    1741,  1946,    -5, -3169,   -41, -3169, 22065, 29774, -3169,  1220,
   48729, 44120,  1743, -3169, -3169, -3169, -3169, 44120, -3169,  1907,
     796, -3169, 53338, -3169, -3169, -3169, -3169, 53338, -3169, -3169,
    1956, 53338, -3169,  1788,   943,  1755,  2083, 42862, 53338,  1793,
    2115, -3169, -3169,  1800, -3169, -3169, 53338,  1771,   665,  1800,
    2118,  2126,  1924,  1266,   100,  1800, 48729, 48729, 48729,  1989,
   53338, 60042, 44120, 53338, 35305, -3169,  1780,  1281, -3169, -3169,
   -3169, -3169,   630,  1836,  2055,  1714, -3169,  2057,  1799,  2064,
   -3169,  2066,  1732,  2071,  1801, -3169, 60461,  2073,  1815, 53338,
    2084,  1801,  2085,  1973,  2086, -3169,  2088,  1981,  2096,  1801,
     392,  2099,    64, -3169, -3169, -3169, -3169,    44,   414, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, 53338,  1567,  1567,   118,
   -3169, -3169,   113, -3169, 47891, 53338, 48310,    51,    49, -3169,
   53338, -3169,   763, 53338,  2091,  2091,  2091, -3169, -3169, -3169,
    2037, 53338,  2094, 47891, 53338, -3169, 60880,  1839,  1052,  1101,
    1055, -3169, 22065,  1841,    69,    69,  1843,  1844, -3169, -3169,
    1855,  1860, -3169,   929,   929,  1997,  1861,  1873, -3169,  1128,
    1874, -3169,  1335,  1189,  1875,  1877,  1878,  1503,    69, 22065,
   -3169,  1881,  1242,  1884,  1886,  1887,  1404,  1891, -3169,  1453,
    1896,  1337,  1339,  1898,  1899, -3169,  1861, -3169,    70, -3169,
   -3169, -3169, -3169, 22065, 22065, -3169, 20317, -3169,  1029, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169,    66, -3169,  1376,
    7352, -3169, -3169,  2012, 22065, -3169, -3169,   157, -3169,  1220,
    1900, -3169, -3169, -3169, -3169, -3169, -3169, -3169,  1417, -3169,
   -3169,  1524,  1624, -3169, -3169,   124,  1640,   915,   915,  1165,
   39081, 39081, -3169, -3169,   182,  1869,   884, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, 34455,  2247, -3169,  1357,   -41, 31033,
   31033,  1567,  1567,  2102, -3169, -3169,    73,  2121, 48729, -3169,
   53338, -3169, 27614, -3169, -3169,   755, -3169,  9335, -3169,  1098,
   -3169, -3169, -3169,  1916, -3169,   681,   681, 22065,   681,   607,
   20752, 22065,  2173,   862,  2175, -3169, -3169,  1608,  1930,  1107,
   -3169, 43701, 61711, 61711,  2138, -3169, -3169,   754,   450,  2026,
    2112,   649,  1075, -3169, -3169, -3169,  1922, -3169,  2223,  1608,
    1144, 39081,  1982, 34880, -3169, -3169,  2341, -3169,  2341, -3169,
   -3169, -3169, 15077,  1066, -3169, -3169, 14592, -3169, -3169, -3169,
   -3169,  2367, -3169,  1933, -3169, -3169, 62114,  1942, 53338, -3169,
    1947,  1955, -3169, 62517,  1220, 30195,   920,  2009,  2022, 36982,
    1958,  2023,  2028, 61299, -3169, -3169, -3169,   223,   142,   602,
   -3169,  2029,  2119,  2067, -3169,  2132,   847, -3169, -3169, -3169,
   -3169,  1173, 18156,  1090, -3169, -3169,  2038,  2021,  2040,  2042,
    1771,   420,  1964, -3169,  2045,  2030, 41602, 29335, 61299,  4523,
   -3169,  2047,  2048,  2090,  1928,   127,  2307,  2144,  2053,  1438,
    2054, 48729,  2220,    98,   642,  1987, -3169, -3169,  2062,  2063,
   47053,  2068,  2105,  2070, 61299,  4523, -3169, -3169,  1095, -3169,
   -3169,    60, -3169,  3282, -3169, -3169, -3169, -3169, -3169,  1714,
   42862,  1732,  1061, 53338,  1998,   857,  2161, 53338,  2226,  2171,
      43, -3169, -3169,  1800, -3169, 30195,  1771, -3169,  2017, -3169,
    2060,  2060,  2060,  2020,  2020,  2024, -3169, -3169,  1503,  2060,
    2025, -3169, 43282, -3169,   864,   948, -3169,  2370,   105, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,   778, -3169,
    1719, -3169, -3169, -3169,  2385,  1048, -3169, 42862,  4523,  2312,
   36982, -3169,  2072,  4523, 53338,   556, 53338,  2215, -3169, -3169,
     253,  2032, -3169,  4523, -3169,    -6,  2035, 34880,  2294, 53338,
    2194, -3169,  1732,  2400, -3169, -3169,  2046,  1112, -3169,  1780,
   -3169,  1310, -3169,  2156, -3169, 24644,  2092, 44120,   220, -3169,
   42862, 53338, 44120,   220, 53338, 53338,  2321,  2116, 29335, 41602,
      79, 53338, 53338, 48729, 53338, 53338, 48729, 53338,  2323,   220,
   53338, -3169, -3169, 53338, -3169, -3169,  1567,   970, 53338, -3169,
   -3169, -3169, -3169, -3169, -3169,  1567, -3169, -3169,  2516,  2081,
   -3169,   124,  1112,  2087, -3169,  2100, 53338, 44120, 53338, 53338,
   48729, 48729, 53338,  2158,  1869,   -99, -3169,  2133, 27195,  2207,
   -3169,   171, 48729,  2259, -3169, -3169,   653, -3169, -3169, -3169,
   -3169, -3169, -3169, 46215,  2351,    -1, 53338, -3169, 22065, 21187,
   -3169, -3169, -3169,  2109,  9335,  2142, 22065, -3169, -3169, 22065,
   22065,  1112,  1112,  1112, -3169, -3169, -3169, -3169,  1562,  1112,
   -3169, 22065, 22065,  1112,  1112,  2060,  2060, -3169,  3499, 22065,
    1112, -3169, 29335, 22065, 22500, 17712, 22065,  2174,  2179,  1112,
   -3169,  1112, -3169, 22065, 19004, -3169,  1220,  2484,  2484,   657,
     909,  2559,  2110, -3169,  2213,  1112, -3169,  1112,   175, 42862,
   22065, 36982,  2187,   144, 22065,  2120,  1440, -3169, 22065,   159,
   -3169,  2122, 22065,  2191,   122, 22065, 22065, 22065, 22065, 22065,
   22065, 22065, 22065, 22065, -3169, 22935,   145,   -83,   306, 38241,
   19439,  2372, -3169,  1185, 17268, 40761, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169,  1112,  2125, -3169,  2139, -3169, -3169, -3169,
   -3169, -3169,  2247, -3169, -3169,  2193, -3169, -3169, -3169,  1701,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,  2128, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169,  1567, -3169, 62114,  2140,
   -3169, 53338,    53, -3169, -3169, -3169,  2146, -3169, 46634, -3169,
   19882, 53338, -3169, -3169,  2355, -3169, -3169,  2136, -3169,  6995,
    2355,  2297,  2305,  2305, -3169,   -52,  9335,  2347,  9335, -3169,
   -3169, -3169, -3169,   566, -3169,  1271, -3169, -3169,  1608,  2153,
   16004, -3169, 16423, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169,  1061,  2154,  2568,
    1290, -3169, -3169, 34880, -3169, -3169, -3169, -3169, -3169, 40761,
    1443,  2153, 14592, -3169, 14592,  2153,  2159,  1118, -3169,  2227,
    2229,  2268, 53338, 53338, -3169, 36982, 53338, 53338, -3169,  2480,
    2166, 53338,  2375,  2376,  2170, -3169, -3169, 53338, -3169,  2335,
   22065,  2336, 53338, 53338,  2339,   874,  2332, -3169, -3169, -3169,
   -3169, -3169,  2327, -3169, -3169, -3169,  1131, -3169, 37822, 41182,
   -3169, -3169,    81,  1719, -3169,   247,   258,   269,  2249,  2250,
    2290, 53338, 53338, 53338, 53338, -3169, 53338, -3169,  1001, 53338,
   53338,  2180,  2188,  2183, -3169, -3169, 53338,  2389, -3169, -3169,
    2333,   509, -3169, -3169, -3169, -3169, -3169, -3169, -3169,   492,
   53338, -3169,  1112,  2337, 53338,  2244, -3169, 53338, 53338, 53338,
    1061, -3169,  2533,  1061,  1061,   633,  2535,  1800,  1800, -3169,
   -3169, -3169, 53338, 53338, 53338, 49567, 53338, 53338, 49986, -3169,
   48729, 53338, 53338, 53338,   155,  2795, 53338, 53338,  2320, 53338,
   53338, 53338, -3169, -3169,   110,  2329, -3169, -3169, -3169, -3169,
   22065,  2416,  2560,  2419,  2420,  2256, 41602,   768, 53338, 53338,
    2423,   768, -3169, -3169, -3169,   943, -3169,  1132, -3169,  2225,
   -3169, 22065,   106, 42862,  2216, 25482, -3169,  2279, -3169,  2283,
    1112, -3169,  1958,   253,  2418,  2234,  2234,  2234,  2234,  2234,
    1048, -3169, -3169, -3169,  2479,  1149, -3169,  2238, 48729, -3169,
   -3169,  2080, 46215, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169,   -92, -3169, -3169, -3169,  2380,  2379, 53338, -3169,  1928,
   48729, 45377,  1343, 53338,  2584,  2473,  1029,  2386, 48729,  1371,
   -3169, 35305, -3169,  2239,  2477,  2478,  2490, -3169, 24225, 50405,
    2233,  2106, -3169, 50405, 50824, -3169,  1220, 22065,  2207,  1714,
   -3169,  2595, -3169,  1732, -3169,  1801, -3169, 53338, 53338,  2242,
    2243, -3169,  1801,  2397,   220, -3169,  2401,   220,  1801,  1029,
   -3169,    64, -3169, -3169, -3169, -3169, -3169, 40761,  1307, -3169,
   -3169,  1307, -3169,  1307,  2682,  1801,  2241, -3169,  1732,  1801,
    1801,  1869,  1869,  1801, 51243,  2614,  2495, -3169,  1177, -3169,
   -3169, 19439, -3169,   410, -3169,   529,   -38,  2436, -3169, -3169,
   -3169, 53338,  2406,  2248, 51243,  2592,   220, -3169,  9335,  1205,
    1042,  1063, -3169,  1112, 22065,    41, -3169,  7812,  1233,  7842,
    1236,  2257,  2258,  1272, -3169, -3169, -3169, -3169, -3169, -3169,
    2260,  2508, -3169, -3169,  2263,  1294,  1299,  2265,  2266, -3169,
   -3169,  3670,  1351,  2267,  8257,  2269, 22500,  1876, -3169, -3169,
   22500,  2270, -3169,  1366,  7048,  2253,  2271,  2299,  2304,  2274,
    2276,  8778, 21630, 22065, 21630, 21630,  8816,  2253,  2277, -3169,
   -3169, 22065, 53338,  2278,  2282, -3169, -3169,  3499, -3169,  2314,
   -3169, 22500, 22500,  4236, 20317, -3169, -3169,  2531, -3169,  1137,
   -3169,  2286, -3169, -3169,  4458,   158, 22065,  2120, 22065,  2354,
   29335,  3987, 22065,  2723,  3551,  3551,   183,   183,   102,   102,
     102,   823,   306, -3169, -3169, -3169,  2291,  1891, 22065, -3169,
    1167,  1260, 48729,  5055,  5876, -3169, -3169, -3169, 24644,  2092,
   22065, 22065,  2289, -3169,  1384, -3169, -3169,   197,  2682,  1112,
      60,  1112,   175, 31467, -3169,  2153, -3169, -3169,  1392, 27614,
    2092, 19882,  1220, -3169, -3169, -3169,  1441, 22065, -3169, -3169,
    1660, -3169, 53338,  2259,  2259, 22065, 22065, 20752, -3169, -3169,
    2285, -3169, -3169, -3169, -3169, -3169,  2292, -3169, -3169, -3169,
   -3169,  2709,  2296,  2295,  2298,  2300, -3169, -3169, 42862, 53338,
   53338, 53338, -3169, -3169, -3169, -3169, -3169,  2496, -3169, 22065,
     117,  2301,  2308, 53338,   220, -3169,  9335, -3169, -3169, -3169,
    2527, -3169, -3169,  2476, -3169, -3169, 37402, 42862, -3169, 42862,
   -3169,   867, 53338, 53338, 53338, -3169,  1801, -3169, -3169, -3169,
   -3169, -3169,  1146, -3169, 42862,  2457, 42022,  1801,  -106,   -92,
   53338, 53338, -3169, -3169,  1801, -3169,   -92,  1801,   -92, -3169,
   -3169, -3169, -3169, -3169,  1061, -3169, -3169, -3169, -3169, -3169,
   53338,  1061,  1061, -3169, 42862,   506, -3169, -3169, -3169, -3169,
     220,   220, -3169, -3169, -3169, -3169, -3169,  2381, -3169, -3169,
   -3169,   750, -3169, -3169, -3169,  2382, -3169, -3169, -3169, -3169,
   -3169, -3169,  5202,   768, 42862,   768,   768, 53338,  2316, -3169,
   -3169, -3169,  2530,  2532,   768, -3169,    39,  2310, -3169,   717,
   28459,  4713,  2324, -3169,  2318,  1112,  2153, 25924,  1711, -3169,
   -3169, -3169,    48,  2505,  2325,  2482,  2234, -3169,   141,   463,
   51662, 52081, 52500, -3169,  2104,  2387, -3169, 36982, 28459,  2035,
     556,  2443,   838, -3169, 48729,   253,  1449, -3169, 42862,  2331,
   48729,  2328,  2326, -3169, -3169, -3169, -3169,  1465, -3169, 42862,
     -20,  2492,  2491,  1470, -3169, -3169,   681, 53338,  2404, 48729,
    2388,  1029, 34880, 42442,  2165, -3169, -3169,  2493, -3169, 53338,
   -3169, -3169, 26769, 23805,  2106,  2345, 53338, -3169,  2340, 24644,
    2562,  2501, -3169, 24644,  2501,  1091,  2501,  2564, -3169, 28033,
   -3169,  2356,  1185,  9335, -3169,   220, 42862,   220,  2405,   220,
   41602,   220, 48729, -3169, 48729, -3169,   220, -3169,   774, -3169,
   -3169,  2357, -3169,  2374, -3169, -3169, 44120, -3169, 53338,   285,
   -3169, -3169,  2518, -3169,   681, 53338,  1220,  2358, -3169, -3169,
   -3169, -3169,  2635,  2636, -3169, -3169, 47891,   104, 53338, -3169,
   -3169, 22065, -3169, -3169,  2373,  2371,  9375, 22065, -3169,  2643,
   42862, -3169, 53338, -3169, -3169, -3169, -3169,  1112, -3169, 22065,
   -3169, -3169, -3169, -3169, -3169, 22065, -3169,  1112, -3169, 22065,
    2628, -3169,  2749, 42862, 22500,   598,  1884, 23370, 22500, 22500,
   22500, 22500, 22500, 22500, 22500, 22500, 22500, -3169,   731, -3169,
   -3169, 22065, 22065,  2637,  2628, -3169, -3169, -3169,  1364,  1364,
   42862,  2391,  2253,  2392,  2395, 22065, -3169,  1220,  5127, -3169,
    2715,  1029, 22065,  1498,  1601, 22065,  1475, 22065,  2638, -3169,
   -3169,  2398, -3169, -3169, 42862, 22065, 22500, 22500,  5234, -3169,
    6809, 22065,  2396,  7881, 20317, -3169,   507,   507,   507,   507,
   -3169, 48729, 48729,  2233,  2632,  1497,  1499, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169,  2393, -3169,  2412, -3169, -3169,   -41,
    2403, -3169, -3169,  2709,  2414, 53338, -3169,  2207, -3169, -3169,
   -3169,  2402, -3169, -3169,  1801, -3169, -3169, -3169, -3169, -3169,
    2422,  2421, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169,  2234,  5157, -3169, 53338, 53338,  1531, -3169, -3169,
    2634, -3169, -3169, -3169,  2467, -3169, -3169, -3169,  2481,  2488,
   -3169,  2489, -3169, -3169, -3169, -3169,  1801,  1801, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169,   574,   565, 42862, -3169, -3169,
   -3169, 53338, 53338, -3169, -3169,  2413, -3169, -3169,  2630,  2639,
     768,   768, -3169, -3169,  1800,  2707, -3169, -3169,  2115,  2115,
     788, -3169,  2115, -3169,  2115, -3169, -3169,  2225,  2402,  1075,
   -3169, -3169, -3169, -3169, -3169, -3169,   831,  1112,  1391,  2426,
   -3169,  1254, 25924, 25924, 25924, 25924, 25924,  2153,   175, 48729,
    1112, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169,  2428, 53338, 22500, -3169,   592,   134,
   -3169,  2642, 48729,  2461, -3169, -3169, -3169, 42862, -3169, -3169,
    2785,   759, 48729,  2692,  2590, -3169, 53338, -3169, 45377, -3169,
    2667, 45377, -3169, 53338, -3169, -3169, -3169,  2760,  2521, -3169,
   53338,  1049,  2503,  1719,  1029,  2388, 53338,  2449, -3169,  2445,
   -3169, 43282,  2237, -3169,  1771, -3169, -3169,   686,  2486, -3169,
   -3169, 50405,  2456, 53338,  2106, 24644, -3169, -3169,  1783, -3169,
   24644,  2666, -3169, 24644, 53338,  2460, 53338, -3169,  2462, -3169,
   53338, -3169,  2463, -3169,   220,   220, -3169,  1310,  1307,   197,
   -3169, -3169,  2712, 51243, -3169, -3169, -3169, -3169, -3169, -3169,
    2718, -3169, -3169,  9335, -3169, -3169, 22065,  9335, -3169,  2469,
    2470,  2472,  9335,  6201,  2475,  9335,  2637, -3169,   851,  2725,
     532,  2483,   731,   851,  1206,  1206,   196,   196,   103,   103,
     103,  2749,  9335,  9335, -3169, -3169, -3169, -3169,  2485, -3169,
   -3169, -3169,  2253, -3169, -3169,   175,  2484, 22500, 22500,   386,
   -3169,   190, 22065, 42862, -3169,  1546,   386,  1919,  1957, 22065,
   22065,  8193,   160, 22065,  6418, 48729, 48729, 48729, 48729, -3169,
   -3169,  2815,  2719, -3169, -3169,   197,  2124,  1029, -3169,   657,
   -3169, -3169, 29335, -3169, 14592, -3169,  1112, -3169,  1549,  1565,
    2461, -3169, -3169, 53338, 53338, 53338,  2104,  2644,  2645,  1112,
   53338,  2536, -3169, -3169,  2697,   768,   768, -3169, -3169, -3169,
    1029,  1029,   -92,  2651, 53338,  1029,   -92, -3169,   786,  2768,
   -3169,  2717,   570,  2497,  2739,  2742, -3169, -3169,  1792,  1792,
   -3169, -3169, -3169, -3169, -3169,  2746, -3169, 22065,  1518,   851,
   -3169, -3169, -3169, -3169,  2461,  2035,  2544,  2545,   681,   376,
    2775,  2766,   253, -3169,  2502,   538,  2504,  1343, -3169, -3169,
   -3169,    90, 53338,  2856, -3169,  2832,  2833,  2658, -3169, 53338,
    2716,  1958,  2759,  2510, -3169, 25063,  1029,  1719,  2165, -3169,
   -3169, -3169, -3169, -3169,  2581, 53338, -3169, -3169, 53338,  1566,
   -3169, 22065,  2517, -3169, -3169, 24644,  1783,  1568, 53338,  1578,
   42862,   220,   220,   220, -3169, -3169,  2772, -3169, -3169,  2669,
   -3169, 51243,  9335, -3169, -3169, -3169, -3169, -3169, -3169, 22500,
    2771,  2523, 22500, -3169, -3169,   332,   332,   190,  1604, -3169,
   42862, 22500, 22500,   386,   386, 22065,   386, -3169, -3169, -3169,
   -3169, -3169, 22065, 22065, -3169, -3169,  1075, -3169, -3169, -3169,
   -3169,   175, -3169,  2524, -3169, -3169,  2653,  2461,  2544, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, 22065, -3169,   768, -3169,
   -3169,  2310, -3169, -3169, -3169, 53338,  2520, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, 44120,  2884, 48729,   831,  6517,
    2694, -3169,  2544,  2721,  2762, -3169, 53338,  1049, 45377, -3169,
     -21,  2664, -3169,  1343,   568,   925, -3169, 48729,  2491,  2647,
   -3169,  2649, -3169, -3169,  2687,  2688, -3169, -3169,  1029, -3169,
   53338, 25063, 22065,  1607, -3169, 52919, 18576, -3169,   957, -3169,
   48729, -3169,  1612, -3169,  9335, 53338, -3169, -3169, -3169,  1626,
   -3169, -3169, -3169, -3169,   681, -3169,   104,   814, 22500, 22500,
     501, -3169, -3169,   332,   332,   386,  2253,  9335, -3169, -3169,
   -3169, -3169, 48729,  2544, -3169,  9335, -3169,  2520,  2884,  2889,
   -3169, -3169,  2799, -3169, -3169,   554,  2698,  2618,  2903, -3169,
   -3169, -3169, -3169, 53338,  2491, -3169, -3169, -3169, -3169, -3169,
   -3169,  1634,  2521, -3169, -3169,   681, -3169, -3169, -3169, -3169,
    1636,  6939,  2461, 25063, 53338, -3169, -3169, -3169,  2613,  2092,
   -3169,  1666, -3169, -3169,   814,   827, -3169,  2035, -3169, -3169,
   -3169,  2834, -3169, -3169,   164, -3169,  2711,  2726, 53338,   442,
    2561,  2521, -3169, -3169, -3169,  2461, 52919,  2521, -3169, -3169,
   -3169,  2841, -3169, -3169,  2721,  2672,   618,   618,  2624, -3169,
    2854, -3169, -3169,  1112,  1112, 42862,  2571, -3169, 33177, -3169,
    2521, -3169,  2092,   619,  2698,  2845, -3169,  2948, -3169,   101,
   -3169, -3169, 44120, 29335, -3169,   442,  1685, -3169, -3169, -3169,
    2092, -3169, -3169, -3169,   968,   831,  2713, -3169, -3169, -3169,
    1732,   -59, -3169, -3169, 33177, -3169, -3169,  1051, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, 44120, -3169, -3169, 41602,
   -3169, -3169,  1204, -3169, -3169,  1238,  1579,  2586,  2583, -3169,
    1051, 33177,  2714, -3169,  1690, -3169, -3169
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -3169, -3169, -3169, -3169, -3169,  2802, -3169, -1001,  -356, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169,   945, -3169, -3169,  -779,  1194,  1708, -3169, -3169,   697,
   -3169, -3169, -3169, -1259, -3169,   375, -3169, -3169, -3169, -3169,
   -3169, -3169,  1016, -3169,  -931,   577,   652, -3169, -3169, -3169,
   -3169,   988,   -74, -3169, -3169, -3169, -3169, -3169, -1501,  -122,
     108, -3169,   107,  1032,   203, -3169,   -98, -3169, -3169, -3169,
   -3169,  -177,   651, -2423, -2260,   109,  -402,  -420,  -377,  -374,
    -394, -3169, -2502, -3026, -2219, -2310, -3169, -3169, -3169, -3169,
     121, -1486, -3169,  1484, -3169, -3169, -3169, -3169,  -110, -3169,
   -3169, -3169,  -441, -3169, -3169, -3169, -1479, -3169,   997, -2428,
   -3169, -3169, -3169,  -459,  -433, -3169, -3067,   -58,   -53, -3169,
   -3169, -3169, -3169, -1084, -3169,   536,   539, -1012, -3169, -3169,
   -3169,   567, -3169, -3169,  -410,  1511,  -451, -3169, -3169, -3169,
   -3169, -3169,  1457,  -714, -1508, -3169, -3169,  2906,   621, -3169,
   -3169, -1956, -1471, -3169,  -168,  1130,  1905, -1162, -2116,    92,
   -3169, -3169, -1624, -3169, -3169, -3169,   907, -1469, -3169,   146,
    -233,  -313, -2648, -3169, -3169, -1128, -3169,   687,  1153, -3169,
    1156, -3169, -1810,   147,  -891, -2455, -2797, -3169, -3169, -3169,
   -3169, -3169, -3169, -1609, -1449, -3169,  -273, -3169, -3169, -3169,
   -3169,   692, -3169,   187, -3169, -3169, -3169, -3169, -3169, -3169,
    -388,  -422, -3169, -3169, -3169,   143, -3169, -3169, -3169,  1248,
   -1043,  -877,  2189, -1468,  -196, -3169, -3169, -3169,  1033, -1912,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -1264, -3169, -3169,
   -3169,  1276,  2957,  -710, -3169, -3169, -3169, -3169, -3169, -3169,
      11, -3169, -3169,   481, -2027,    14, -3169, -3169, -3169, -3169,
    -472,    16, -3169,   769, -3169, -3169, -1738, -3169,  1951,   955,
     129,   -72,   -75,  -220,   417,   504, -3169, -3169,  -218,   885,
   -3169, -3169, -3169, -3169,   771,  1764, -3169,   764,  -460, -3169,
   -3169,  1772, -3169, -3169,  1768,  1280, -3169,  1306,   811, -2028,
    1012, -2009,   547,  -751,   -63,  -160,  2342, -3169, -2270, -2700,
     213,  1825, -1760, -2299, -1489, -3169,  1587,  3190, -3169, -3169,
   -1025, -3169, -3169,  3216,  5159, -3169, -3169,  5279,  6902, -3169,
   -1063,   430,  7816,  -309, -1197, -1527, 11250, -1348,   898, -1523,
     926, -3169,  -727, -3169, 11567,   792, -3169, -1240, -3169,    88,
   -3169, -1579, -3169, -3169, -3169, -3169, -3169, -2357, -2514,  -854,
     858, -3169, -3169,   953, -3169, -3169, -3169,  -951,  -940, -1702,
     865, -1709, -3169,  -942,   962,  1387,  2019,  -859,  4180,  -784,
     -55,  -132, -2080, -1296,  -977, -3169,  -725, -3169,    -2,    89,
   -3169, -3169,  7588,  -600,  -762, -1736, -3169,   111, -3169,  -839,
    -947, -3168,  -371, -3169, -3169,  2604,   591, -3169,  2044, -3169,
    1053,  1574, -3169, -3169,  1284,  -804,  -136, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169, -3169,
   -3169, -3169, -3169, -3169,  1805,   125, -3169,   -60, -3169, -3169,
   -3169,  3105, -3169,  2853,   -34, -3169,  2487,   -33, -3169, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169,  -808,  1317, -3169,
    2172, -3169, -3169, -3169,   -68, -3169, -3169, -3169,  1994,  -151,
   -3169, -3169, -3169, -1031,   938,  2198,  -827,  -800,  1289, -3169,
   -3169, -3169, -3169, -3169, -3169, -3169, -3169,  1017, -3169, -3169,
     854,  1019, -3169, -3169,   198, -3169, -3169,   114,   195, -3169,
    1892, -3169, -3169, -3169,   412, -3169, -3169, -3169,  -532,  9118,
      58,   -45,   -36,   173, -3169,  1399,  8458, -1340,  -686,   -16,
    1831,  6461, 10504,   -48,     7,   -56,   245,   -54, -2193, -3169,
    2837,  1300,  1037,  -883,  7673,  1560,  3319,  4619,  -724,  -845,
    2219,  -498, -1378, -3169,  3210
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1870
static const short yytable[] =
{
      71,   316,   922,  1018,   315,   830,  1366,  1032,  1188,  1048,
    2150,   936,   794,   799,  1613,  1025,   789,  1028,  1974,   367,
     799,  1502,   361,  1571,   784,   361,  1742,  1144,  1898,  1058,
    1582,  2071,  1151,  2177,  1005,   896,  1328,  1095,   361,   712,
    1159,  1684,   331,   333,   709,  1107,   872,   702,  1315,   714,
    1469,  1410,  2072,  2062,  1100,  1732,   703,  2337,  1495,  2754,
     361,   799,   745,  1336,   928,  1804,   709,  1114,  2609,   702,
     761,  1169,  1129,  1171,  2094,  1173,   706,  1424,   703,  1135,
    2787,  1174,  2135,  1526,   748,  1142,  1148,   310,  2647,  2095,
     311,    72,   313,  2347,   798,  2505,  2096,   802,   706,   710,
    2584,   798,  1568,  1463,  2097,   847,  2098,  2099,  1573,  2370,
    2212,  2604,  1954,  1163,  1583,  1414,  2930,  2934,  1507,  2965,
    1334,   710,  1168,  1608,  2598,  2600,  3156,   869,  1182,  1317,
    1385,  2355,  1326,  1914,   358,  2352,  1636,   358,  2418,  2420,
    1450,  2381,   798,  2817,  1590,  2385,   892,   985,  1404,  1785,
     358,  1697,  1698,   892,   891,   892,   935,   316,   848,  1407,
     315,   891,  1652,   891,  2529,  2530,  2531,  2532,   361,  2149,
    1390,  1411,   358, -1655,   709,  1717,  1631,   702,  1749,  2683,
     848,  1309,  1394,  1395,  1744,  1631,   703, -1060, -1055,  3044,
    1014,  1631,   759,  1581,  1407,   590,  1061,  2064,  2512,  1705,
    1752,  2205,   994,  -292,   366,  2759,   706, -1211,  1667,  1318,
    2760,  2761,  2762, -1211,  2657,  1179,  1631,  1454,  2891,   292,
    1204,  2275,  2763,  2764,  2765,  2010,  2766,  2767,  2768,   710,
    2313,  3382,  2769,  2770,  2771,   981,  2314,  1920,  2365,  2053,
    2489,  2280,   716,   310,  1175, -1227,   311,  1920,   313,  2328,
    2193, -1227,  3319,   717,  2010,  2280,  2317,  1875,  3498,  1749,
    1921,  3320,  2295,  3518,  1671,  1002,  1749,  1398,   721, -1307,
     722,  2944,  2683,  2243,   361,  1927,   901,  1179,  1062,  2479,
     358,  1752,  2110,  -979,  3207,  1502,  3209,   715,  1752,  1499,
     202,   865,  3402,  3152,   949,   950,  1185,  1061,  2901,  1928,
    3488,  2642,  2513,  3268,  1170,   976,  1491,  1455,  1876,  1172,
    1922,   361,  1468,  2185,   361,  1090,   980,  2885,  3390,   588,
    1922,   360,  1465,  3026,   360,    53,  3456,  2067,  2115,  1437,
      49,   718,  1631,   844,   977,   950,  3488,   360,    52, -1657,
       3,  3391,  1799,  1920,  1119,  2885,  1509,  3045,  1732,  1783,
   -1654,  2194,  1511,  1514,  1492,  1615,  1921,  3302,   902,   360,
    2643, -1653,  1033,  3488,  2318,  1620,  1051,  1637,  3441,  1186,
    2296,  1343,  1434,  1059,  2297,   292,  1965,  1646,  1647,  1062,
    1810,  1506,  1749,  2043,   964,  3499,   358, -1758,  3519,   746,
    1779,  3339,  1569,  1877,  1800,   924,  1632,  1592,   208,  1103,
    3321,  1665,  2366,  1109,  1752,  1632,  1588,  2298,  2683,  1676,
    1500,  1632,  1115,  1501,  1429,  2102,  1922,  2858,  3153,  1438,
    1685,  1929,  1442,   358,  2054, -1870,   358,  1570,  3515,   794,
    1923,  1201,  1617,   789,  1396,   965,  1632,  2498,  2068,  2863,
    1923,  2111,  2060,   719,   998,  2421,  2480,   893,  2209,  2210,
   -1785,  2214, -1710,  1615,   893,   226,   893, -1760,  2038,  2218,
    2220,  1374,  1749,  1456,  2119, -1799,  1003,   360,  1697,  1698,
    3373,  2235,  2236,  1507,    49,  1692,  1717,   588,  1186,  2021,
    2103, -1211,    52,  1422,  1752,  2253,  2255,  1782,  2636,  1753,
     975, -1060, -1055,  1403, -1060, -1055,  1443,  2041,  1668, -1060,
   -1055,  2490,  -207,  1672,  2315,   723,  2772,  2349,  3349,  1705,
    2195,  1924,  3228,  1745,  2281,  2299, -1060, -1055,  1633, -1227,
     967,  1924,  2056,   986,  1444,  2196, -1655,  1672,  2736, -1655,
   -1655,  1824,  1825,  1615,   231, -1655,  1923,  2854,   588,  2856,
    2857,  1756,  1757,   588,  2334,  1773,  2696,  1570,  2862,   588,
    2065,  2065,  1632,   988,   989,  3098,  3099,  1404,  3003,  1865,
    1940,  2974,  3457,    49,   987,  2978,   588,  2685,  2717,  1411,
    1638,    52,    53,   360,  1034,    49,   153,  2683,   588,  1053,
    1055,  1890,  1122,    52,    53,  2783,    54,  2773,  1760,  1895,
    2638,  2069,  1382,  3138,  3139,  3140,  3141,  3142,  1027,  1029,
    1439,  1755,  1628,  2778, -1758,  2135,  2164,  2822,  1954,  2823,
     360,  1780,  2117,   360,  2900,  3447,   725,  1924,   874,  2394,
    2906,  1756,  1757,  1770,  1771,  1772,  1773,  2686,  1768,  1769,
    1770,  1771,  1772,  1773,  1099,  1838,  2693,  2694,  2695,  2696,
    3463,   170,  2788,   928,   588,  1445,  1130,   726,  3470,   588,
      53,  2104,  2239,  2240,  1918,    53, -1822,  1446,   844,  1106,
     981,   799,  1375,   844,  2110,  3318,   361, -1785,  1760, -1710,
     361,  1447,   709,  2044, -1760,   702,  1140,  2845,  1448,   607,
    1035,  1761, -1799,  1052,   703,   875,  1056,  1057,  3417,  1975,
    1016,   950, -1657,  1165,  2091, -1657, -1657,  3002,    71,  3230,
    2881, -1657,  3395, -1654,   706,  3492, -1654, -1654,  1096,  2640,
    1878,   371, -1654,  2440, -1653,  2032,   981, -1653, -1653,  3314,
    1449,  1112,  1930, -1653,  1113,  1123,  3396,   710,  2881,  3127,
    3476,  1928,  3303,  2965,  3312,  1600,  2685,  3464,   756,  3003,
    1048,   980,   798,  1506,  1768,  1769,  1770,  1771,  1772,  1773,
    1136,  3432,  3150,   803,  3315,  2687,  2890,  2092,  1431,  1930,
    3091,   208,  1153,  2963,  2639,  3029,  1155,  1157,   120,   981,
    2691,  2692,  2693,  2694,  2695,  2696,  2442,  1006,   358,  1601,
    1007,  1432,   358,  2457,   202,  2269,   124,  3397,  1558,    72,
    1177,  1178,  1008,  1009,  1966,  1879,  2686,   980,  3471,  2045,
     963,  2181,  2182,  2050,  3151,  2135,  1433,  2683,  3465,  1764,
     942,  3394,   224,  1010,    49,  2781,  1011,   588,   226,  1194,
    3231,  1195,    52,  3308,  1768,  1769,  1770,  1771,  1772,  1773,
    2145,   848,  1507,   848,   852,   848,  2163,  2152,  1312,   876,
     877,   848,   848,  2158,  3108,  2166,  2441,  3493,  3190,  3129,
     980,  2742,   892,  3107,   757,   892,  1602,   964,  2846,  3433,
     891,   231,   943,   891,  3286,   769,  1434,  1570,  1092,   361,
     861,   608,  2175, -1822,  2179,  2180,  3184,  3030,  2183,  1600,
     866,  1931,  2139,  2641,  2087,    49,  3031,  2143,   588,  3477,
    2683,  1048,  2458,    52,  2459,  1307,  2847,   898,  2682,  1749,
    3096,  1603,  2698,  2683,  3117,  3118,  1874,  1337,   965,  1882,
    3212,   966,  1883,  3191,    49,   873,  1163,   771,  1513,  2162,
    1852,  1752,    52,  2997,  2687,   725,  1851,  2683,  3109,   944,
    2067,  3110,  2178,  2723,  2724,  2688,  2689,  2690,  1012,  2691,
    2692,  2693,  2694,  2695,  2696,  1932,  3289,  3200,  1308,  3426,
    3478,  1417,  3204,  1410,  1419,  3206,   726,  1421,  3374,   769,
    1037,  1852,  3197,  1875,  1853,   360,  2685,  1383,   725,   360,
    3479,  1038,  1039,  1040,  1604,  1041,  1042,  1043,  1044,  1045,
    1046,   358,  1191,  1324,  1101,  2023,  1102,   964,    71,    71,
    3127,    71,  3384,   967,  1884,  1048,  1383,  2122,  3290,   726,
    1602,  2992,  3000,  1802,  3454,  1853,  2461,  2462,  1937,  1205,
    1104,   771,  1105,   361,  1876,  2607,  1966,  1414,  1809,   709,
    1320,  1322,   702,  2712,   945,  3377,  2344,  1515,   208,   128,
     129,   703,  1516,  3192,  2201,  2411,  1518,  2430,   965,  2094,
     777,  2068,   778,  1564,  2726,  1603,   936,  3090,  2374, -1870,
    2627,   706,  2499,  3128,  2095,  2024,  1165,  2356,  1384,  3398,
     921,  2096,  2685,  3428,   968,  2278,  2135,  3123,  1593,  2097,
    2135,  2098,  2099,  -301,   710,  3014,  1954,   931,  1742,    72,
      72,  1938,    72,  3399,  3193,   226,  2685,  1384,  -886,  1570,
    2755,  2756,  2047,   316,  1116,   969,  1644,   590,   590,  1877,
    -886,  2221,  2222,  2223,   933,  3356,  3124,  1615,  2412,  2234,
    3129,  1360,   316,  2237,  2238,  1670,  1558,  1329,  1604,  1117,
    2242,  1645,  2686,   967,  1966,   358,   939,  2605,   231,  2259,
     153,  2260,   956,  1690,   777,  1674,   778,  3143,   229,  2033,
    -886,   230,  1359,  1558,  3400,  2273,  2686,  2274,   838,  3451,
    2048,  1707,  1361,   893,  1118,   957,   893,  1558,  -886,  3279,
    3280,  2452,   940,  2024,  2455,  2456,   958,   839,   360,  2691,
    2692,  2693,  2694,  2695,  2696,  2379,  1792,  3346,  2426,  1640,
    2074,  1735,  1641,  3443,  1642,  1201,  1116,  1164,   588,  1330,
      49,  1740,  2437,   588,  2069,   170,  2602,  1570,    52,  -886,
    1360,  1558,  3491,  2090,  1788,  1524,  2444,  -886,  1789, -1453,
    2447,  2932,  2083,   153,  1793,  1493,  1558,  2089,   202,  1037,
    3505,  -911,  3469,  2075,  1909,  2070,  3388,  2108,  3472,  1506,
    1038,  1039,  1040,  1558,  1041,  1042,  1043,  1044,  1045,  1046,
    1494,  1361,  1797,  1798,   959,   948,  1118,  1910,  3506,   187,
    2687,  3490,  2691,  2692,  2693,  2694,  2695,  2696,  1558,   953,
    1925,  2688,  2689,  2690,     9,  2691,  2692,  2693,  2694,  2695,
    2696,  1629,  1911,  1458,  2687,  3453,  1727,  1728,   170,  -911,
    1843,  1843,  2683,  1843,  1442,  2688,  2689,  2690,  2591,  2691,
    2692,  2693,  2694,  2695,  2696,   858,  1459,   960,  2011,  1460,
    1434,  1558,  -886,  2076,  2728,  1458,   979,  1521,  1522,  2824,
    1558,  1729,   360,  2960,  2592,   208,  1915,   361,   361,   361,
    -911,  1461,  3376,  1892,  2729,  1383,   702,  1383,  1383,  2980,
    2028,  1460,   187,   897,  2502,  2503,  3028,  2594,   700,  3032,
    3033,  3034,  3035,  3036,  3037,  3038,  3039,  3040,  3041,  1578,
    3259, -1040,  2077,  1461, -1040,   706,   961,  1350,  1443, -1040,
    1727,  1728,   361,  1903,  1427,    49,   224,  1579,   588,   361,
     998,  3144,   226,    52,   727,   361,  1703,   892,   710,  1743,
    1885,   709,  1901,   950,   702,   891,  1444,  1428,  3067,  3068,
    1748,   758,  2445,   703,  1958,  1731,   887,   725,   208,  3418,
      71,  2269,  1436,   828,    71,   920,  1915,  1905,  2711,  1471,
    2713,  2714,   892,   706,  2034,  3507,  1384,  1959,  1384,  1384,
     891,  2730,  2078,  2035,  2079,  2731,  1470,  2596,   726,   358,
     358,   358,  1472,  2608,  1496,  1322,   710,  1004,   892,  1488,
    1558,  2685,  1960,  2619,  2036,  3181,   891,  1015,   936,   224,
    2828,    49,  2135,   899,   588,   226,  1405,  2135,  1406,    52,
    2135,  1692,  1489,  2779,  2571,  2520,  1176,  3175,  3176,  3177,
    2524,  1886,  2062,  2829,   358,  3052,  2945, -1060,  1094,  2142,
   -1060,   358,  1442,   597,  3010, -1060,   588,   358,  2652,  1190,
     617,    72,    53,   713,    54,    72,  2651,  1689,   231,   231,
    1382,  2686, -1060,   713,   590,  1939,    53,  1445,    54,  2653,
    1383,  3046,  3047,  1108,  1806,  2202,   361,  2654,  1897,  1446,
    1406,  2100,   709, -1025,  2732,   702, -1025,  1060,  3234,   617,
    2129, -1025,  2733,  1447,   703,  1097,  1146,   588,   713,   755,
    1448,  2392,  2746,    53,  2747,  2395,  1839,   617,   713,  1070,
   -1034,   713,  1840, -1034,   706,   713,  1443,  1867, -1034,   713,
    2146,  1868,  2409,  2883,   860,  2010,  2387,  2153,  3149,  2155,
    2156,  2016,  2388,  1048,  2683,  1709, -1310,   710,  2794,  2415,
    2508,   713,  1449,  2165,  1444,  2416,  2509,  1098,  3057,  1537,
    2425,  2883,  2427,   935,  1891,   848,   713,  2536,  1868,  1120,
     880,  1384,   860,  2537,  3121,  3122,   900,  2287,  3125,  1807,
    3126, -1067,  2572,  2655, -1067,  2840,   360,   360,   360, -1067,
    1715,  1716,  2842,  2843,  1147,  2634,  2449,  2288,   358,  2687,
    1066,  2635, -1313,  2792,  1067,  2748, -1067,  2749,  2914,  1558,
    1558, -1870, -1870,  3263,  2691,  2692,  2693,  2694,  2695,  2696,
    2170,  1507,  3529,  2650,  3530,  2483,  2836,  2837,  2486,  2651,
    2488,   360,  3335,  2013, -1037,  1066,  2017, -1037,   360,  1067,
    2022,  3378, -1037,  1121,   360,  2916,  2834,  2683,   893,  3338,
    2285,  2661,  2135,   815,  2663,  2269,  1350,  2651,  -878,  1720,
    2651,  3058,  2892,  2893,  2894,  2895,  2896,   361,  1322,   848,
     848,   848,  3137,   709,  1124,  2573,   702,   848,  1127,  3235,
    3236,   848,   848,   893,  2224,   703,  3264,  1446,   848,  2289,
    2666,  2368,  2124,  2125,  2290,  1868,  2667,   848,  2291,   848,
    2335,  1447,   588,  2685,  3370,   706,  1502,  1558,  1448,   893,
    2377,  2780,  2671,   848,  1868,   848,  2841,  2672,  2651,  1727,
    1728,  1727,  1728,  2651,  1558,  2560,  2561, -1023,   710, -1070,
   -1023, -1070, -1070,   981, -1070, -1023,  2269, -1070,  1137, -1070,
     713,  2225,  1844,  1846,   361,  1850,  1727,  1728,   229,    49,
    1449,   230,   588,  2792,  1729,  2396,  1731,    52,    53,  1149,
      54,  2170,  1160,  2686,  2345,   950,  1382,  3300,    49,  2676,
    1179,   588,  2920,  3134,  3135,  2677,    52,  1183,  3335,   358,
    2372,  2792,  2372,  2631,  2700,   360,   361,  1192,   361,  2232,
    2651,  1184,  2226,  1747,  1193,  2227, -1026,  2292,  1356, -1026,
    1358,  2921,  2758,  2631, -1026,  2293,  2685,  1037,  2651, -1655,
    2784,  2922, -1655,  2979,   980,  2982,  2785, -1655,  1038,  1039,
    1040,  2087,  1041,  1042,  1043,  1044,  1045,  1046,  2393,  1845,
    1845,   361,  1845,  3119, -1661,    49,  2400,   709,   588,  1198,
     702,  1199,  2404,    52,    53, -1024,    54,  2408, -1024,   703,
    3189,  3357,  1382, -1024,  3360,  1383,   358,  1679,  1680,  2789,
    3335,  2795,  2796,  3363,  3364,  1615,  2686,  2935,  1383,   706,
      71,  2178,    71,  2936,  -886,  2797,  2798,  2228,   936,  2428,
    3528,  2429,  2923,  2942,  2431,  2889,  -886,  2520,  2949,  2943,
    2342,  2687,   710,  3060,  2950,  2590,  1397,  1399,   358,  2651,
     358,  1200,  2688,  2689,  2690,  1201,  2691,  2692,  2693,  2694,
    2695,  2696,  1202,  2450,  2451,  3083, -1657,  3084,  3020, -1657,
    1203,  2651,  2683,  2651, -1657,  2791,  -886,  1206,  1207,  2466,
    2469,  2470,  1327,  2474,   617,  1331,  2476,  2477,  2478,  2542,
    1332, -1662,  2484,   358,  -886,  2487,  1384,  1333,  2229,  3100,
    2591,  1342,  1343,   229,    49,  2950,   230,   588,  1827,  1384,
     848,    72,    52,    72,  3239,  2683,   360,  3266,  1383,  1344,
    3240,  1383,  1383,  2950,   590,  -885,  2592,   713,   713,  3241,
    3424,  3425,  3366,  3267,  3343,  -886,  3348,  -885,  2809,  2950,
    1615,  2593,  2936,  -886,  2687,  1350,  3350,  1351,  1354,  2594,
    1352,   981,  2936,  2683,  3501,  2688,  2689,  2690,  2000,  2691,
    2692,  2693,  2694,  2695,  2696,  1357, -1654,  3242,  1368, -1654,
    2595,  2825,  3361,  2583, -1654,  3412,  1372,  -885,  3240,  1376,
    3420,  3413, -1653,   848,   936, -1653,  1615,  3021,   848,  1373,
   -1653, -1659,  1377,   360,  3422,  -885,  3201,  3024,  2001,  1558,
    2936,  1378,  3442,  1037,  3445,  1379,  1380, -1658,  1672,  1384,
    3413,  2684,  1384,  1384,  1038,  1039,  1040,  1381,  1041,  1042,
    1043,  1044,  1045,  1046,  1388,  2751,  2752,  1558,  1558,  1391,
    1558,  2685,   980,  1393,  3452,   360,  -885,   360,  -886,  2596,
    1615,  1396,  1415,    49,  -885,  1558,   588,  1558,  1026,   617,
    1030,    52,   597,  3503,   713,  1050,   597,   713,  3536,  3504,
     713,   713,  1026,   597,  3504,  2002,  2645,  3262,  2341,  2892,
    2893,  2894,  2895,  2896,  2685,  1558,  1416,  2897,  1418,   751,
     360,  1425,   713,  1441, -1661,   617,  1524,  1026,  1429,   597,
   -1662,  2686,  1464,   597,  1111,   713, -1659, -1658,   713,  1452,
    1026,  1466,   597,  3202,  1467,  1558,  1473,  2003,  1490,  2004,
    1510,  1497,  2685,  1498,  1512,   713,   713,  1517,   751,  2005,
    1519,  1558,  1525,  1528,   713,  1565,   751,   617,  1566,  1740,
     713,   848,  1434,   765,  2686,   713,   713,  1574,  1570,  -885,
     713,   713,  2285,   713,  2914,  -160,  1026,  2568,  1576,  1558,
    1587,  2006,  2894,  2895,  2896,  1597,  1605,  2915,  1607,  1558,
    1609,  2745,   751,   751,   713,   713,  1610,  1611,  2590,  1612,
    1558,   713,  2686,  2129,  1614,  1615,  1618,  3001,  2571,  2007,
    2140,  2916,  1619,  2917,  1558,  2144,  1623,  1621,  1622,  1624,
    2616,  1625,  2151,   713,  1626,   713,  1442,  3012,  1197,  1627,
     769,  2160,  1630,  1677,  1681,  1683,  1688,  3133,  1696,  2008,
    1699,  1700,  2520,  2520,  2520,  2520,  2520,  1558,  -599,  2687,
    3146,  1558,  1701,  2591,   713,   617,  1706,  1702,   231,  1323,
    2688,  2689,  2690,  1777,  2691,  2692,  2693,  2694,  2695,  2696,
    1708,  1711,  1712,  1672,  1713,  1714,  2918,  1341,  1719,  2592,
    2571,  1722,   771,  1723,  1724,  2810,  2811,  2170,  1725,   848,
    1805,  1383,  2687,  1726,  2593,  1733,  1734,  1784,  1442,  1826,
    1443,  1558,  2594,  2688,  2689,  2690,  1828,  2691,  2692,  2693,
    2694,  2695,  2696,  1841,  1359,  1048,  1863,  1873,  2826,  2827,
    1866,  1880,  3517,  2595,  1558,  1881,  1887,  2541,  1444,  1889,
    2687,  1893,  1407,  2919,  1899,   597,   597,  1900,  2920,  1902,
    1912,  2688,  2689,  2690, -1597,  2691,  2692,  2693,  2694,  2695,
    2696,  1558,  1904,  1913,  1916,   713,  2572,  1915,   713,  1917,
    1933,   713,  1934,  1935,  3342,  2866,  1936,  2921,  1968,  1961,
    1962,  1963,  1443,  1964,  3342,  1558,  1969,  2922,  1997,  1998,
    1970,  2970,  1384,  1999,  2010,  1026,   848,  2014,  2015,  2018,
    2020,  2025,  2596,  2026,  2027,  2046,   799,   789,  2030,  2029,
    1444,  2031,  1383,  2867,  2049,   777,  2884,   778,  3401,  1383,
    1383,  2051,  2052,  2063,  2061,   779,  1692,  1703,  2073,   767,
    2101,  1709,  1720,  2868,   782,  2909,  2911,  2913,  2572,  2107,
    2088,   713,  2113,   361,  2884,  2116,   713,  2118,  2869,   709,
     713,   316,   702,  2120,  2951,  2121,  3265,   713,  2923,  1445,
    2127,   703,  2870,  2137,  2147,  1026,  2159,   316,  1383,  3274,
    2969,  1446,  2953,   848,  2129,   848,  2148,  2871,  2129,  1026,
    1591,   706,   713,  1596,   936,  1447,  2902,   798,  3075,  3076,
    3077,  3078,  1448,  2167,  2174,  2168,  1383,  2187,  1558,  2184,
    2191,  2173,  2199,  1384,   710,  1026,    49,  2204,   713,   588,
    1384,  1384,  2214,  2257,    52,    53,  2213,    54,  2258,   316,
    1749,  3421,  3006,  3256,  2271,  2272,  2279,  2284,  2328,  2300,
    2178,  1445,  2302,  2339,  1449,   713,  2340,  2964,  1071,  2338,
    2351,  1475,  2343,  1446,   713,   860,   943,  1476,  2346,   713,
    2357,  2361,   713,  2362,  2872,   358,  2367,  1447,  2065,  1384,
    1682,  2873,  2375,   713,  1448,  1687,  2376,  2386,  2389,  1072,
    2390,  2391,  2397,  2399,  2401,  2402,  3409,  2403,  1558,  2405,
    2407,  1073,  2248,  2410,  1477,  2413,  2414,  1384,  2874,  1074,
    2422,  2423,  2631,  2424,  2434,  1749,  2435,  2436,  2438,  2439,
    2907,  2448,  2453,  2446,  2460,  1075,  1449,  2485,  2491,  1750,
    2249,  2493,  1558,  2494,  2495,  2496,  2497,  1752,  2504,  2510,
    2522,  2515,  1753,  1076,  2523,   848,  1478,  2526,  2527,  1740,
    2535,  1479,  2538,  2544,  1480,   848,  2545,  2566,  2567,  2569,
    2579,  2582,  2959,  1322,  1549,  2580,  2581,  2589,  2606,  2610,
    2612,  2611,  1077,  1792,  2614,  2626,  2632,  2205,  2644,  2646,
    3449,  2648,  1186,  2319,  2669,  2664,  2665,  2651,  2668,   617,
     617,  2670,  1078,  2673,  2674,  2678,  2706,  2681,  2699,  2705,
    1481,  2707,  2708,  1323,  2709,  2716,  2720,  2727,  1822,  1822,
    2721,  2722,  3269,  2734,  3271,  2741,  1079,  2757,  2744,  1830,
    2800,  1837,  2802,  2803,  2805,  2812,  2806,  1017,  2815,  1406,
    2807,  1017,  2819,   751,  1558,  2816,  1048,  3500,   751,   751,
    2820,  2831,  2851,  2852,  2859,  2860,  2888,  2861,  1883,  2887,
    1754,  1482,  2931,  2898,  1755,  2899,  2940,  2927,  2938,   751,
    2941,  1017,   360,  2946,  2947,  2954,  2967,  2973,  2956,  1080,
     617,  3527,   597,  2971,  1756,  1757,  3112,  3113,  3093,  1749,
    2975,  2976,  2983,  2986,  1458,  2990,  2613,  1758,  2999,  2615,
     815,  2998,  1780,  2617,  3005,  3008,  3009,   713,  1689,  3015,
    3018,  1752,   751,  1017,  2702,  2683,  1753,  1483,  2701,  1017,
    1460,  1081,  3055,  1744,  3062,  1082,  3081,  1083,  1759,  3049,
    3050,  1760,  1084,  3051,  3072,  3063,  3086,  3085,  3089,  3092,
    2631,  3087,  1484,    53,  1761,  3094,  1762,  3102,  2649,  3101,
    3148,  3114,  3103,  3482,  3483,  3115,  1050,  1085,  1086,  3104,
    3105,  3120,  3136,  2964,  3116,  3147,  1475,  1885,  3158,  1087,
     751,  3154,  1476,  3160,  1088,   848,   751,  3162,  3166,  3171,
     848,   848,   848,   848,   848,  3172,  3185,   751,   848,  3186,
    2129,  1558,  1089,  3198,  3205,  2129,  3179,  3208,  2129,  3195,
    3211,  3213,  1026,  3219,  3221,  1763,  1026,  3223,  3224,  1477,
    3225,  3229,  1547,  3227,  3252,  3253,   751,  3291,  3272,  3273,
    3232,  1558,  3278,  3233,  1754,  3285,  3276,  3295,  1755,  3128,
    3296,   751,  3297,  3294,  3304,  3306,   751,  3309,  3311,  3323,
    3313,  3317,  3324,  3325,  3326,  3330,  3328,  3331,  1756,  1757,
     751,  1478,  3340,  3354,  3345,  3355,  1479,  3358,  1886,  1480,
    3359,  1758,  3371,   597,  2950,   713,  3372,  3379,  3153,  3385,
    3387,  3393,  1764,  3406,  3407,  3430,  1323,  3403,  1591,  3404,
    3431,  3434,  3438,  1765,  1766,  1767,  3439,  1768,  1769,  1770,
    1771,  1772,  1773,  3450,  3458,  1760,  3455,  2270,  3468,  3473,
     617,  3475,  1549,   713,   713,  1481,  3456,  1050,  1761,  3460,
     713,   713,  3457,   713,   713,  3485,   713,  3496,  3497,  1026,
    3516,  3532,  1026,  3531,   938,  2540,  3518,   713,  1823,  1549,
    2782,  2482,  2848,  2506,  2463,  3281,  3164,  3106,  3168,  3270,
    3301,  2814,  3474,  1549,  3495,   713,  2818,   713,   713,  3174,
    3461,   713,  3459,  3481,  3169,  3182,  1482,  2190,  2109,  3327,
    2525,  3521,  3534,  2928,  3293,  3502,  2876,  2929,  3292,  1763,
    2084,  3535,   860,   316,  2170,  2207,  3307,  2161,   868,   751,
    1017,  1666,    71,  2633,   848,  3220,  1017,  1549,  3410,  1458,
    3448,  3183,  2419,  2821,  2417,  3429,  3509,   848,  3533,  3188,
    1335,  3389,  1549,  2533,  2353,   831,  3007,  3322,  2786,  1643,
    2618,  1050,  2849,  2850,  2953,  1460,  3216,  1861,  2790,  1549,
    2129,  2799,  1864,  2364,  1859,   751,   751,   751,  2350,  2753,
    2585,  1017,  2981,  3347,  2248,  1133,  1764,  2481,  2248,  3163,
    3054,  3238,  2793,  2637,  1549,  2739,  1558,  1765,  1766,  1767,
    2737,  1768,  1769,  1770,  1771,  1772,  1773,  2327,  2658,   984,
    2968,  1599,  2249,  2123,  2578,  3257,  2249,  2378,  1872,  2248,
    2248,   328,   951,    72,   713,  2369,  1675,  1400,  1423,  2380,
    2624,   997,  2777,  2625,  3218,  3088,  3217,  1549,  3261,  3255,
    1791,   973,  1869,   751,  2384,  2620,  1549,  2249,  2249,  1402,
    1558,  2169,    78,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   751,     0,     0,     0,     0,     0,     0,     0,
    1837,  3282,  3283,     0,     0,     0,  3287,     0,     0,     0,
     713,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1908,     0,     0,     0,  3368,     0,     0,  2987,     0,  2989,
       0,  2991,     0,  2993,     0,     0,     0,     0,  2996,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   316,
       0,     0,  2969,     0,     0,     0,     0,  3526,     0,     0,
       0,  1973,   597,     0,     0,     0,     0,  3337,   713,  3011,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   597,   713,     0,     0,   597,   617,     0,     0,     0,
     713,     0,     0,     0,     0,     0,   713,     0,     0,     0,
     316,   713,   597,  3444,     0,  2042,  1549,     0,  3440,     0,
       0,     0,     0,     0,     0,  3369,     0,     0,     0,     0,
    1908,     0,     0,     0,     0,     0,     0,   751,  1749,     0,
     597,   713,   597,   713,     0,   713,     0,     0,   713,  2433,
       0,     0,  1750,     0,     0,   713,     0,     0,     0,     0,
    1752,     0,     0,  3462,     0,  1753,     0,     0,     0,   713,
       0,     0,  2082,   713,     0,     0,   597,   713,   713,     0,
       0,     0,     0,   605,     0,     0,     0,     0,     0,     0,
     618,  2464,  2465,   713,   713,   713,  2471,   713,     0,   316,
     713,   713,   713,     0,     0,   597,   713,     0,   597,   713,
     597,     0,  3525,     0,     0,  2141,     0,     0,     0,  3408,
       0,     0,     0,     0,  1973,     0,     0,  1026,  1026,   618,
       0,     0,     0,     0,     0,   316,     0,     0,     0,     0,
       0,   848,   848,     0,  2521,     0,     0,   618,   618,     0,
       0,     0,     0,     0,     0,   618,     0,     0,     0,   605,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   860,     0,  1754,     0,     0,     0,  1755,     0,   605,
     751,   605,     0,     0,     0,     0,  2548,     0,     0,   751,
    2559,     0,  2565,     0,     0,     0,   618,  1756,  1757,     0,
    1596,     0,     0,     0,     0,     0,     0,     0,  2588,     0,
    1758,     0,  2588,  2601,     0,  1549,  1549,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1026,  2433,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1759,     0,     0,  1760,     0,   713,     0,     0,     0,
       0,     0,   728,     0,  2276,  1749,     0,  1761,     0,  1762,
       0,     0,  2248,   597,     0,  2248,  2248,  2248,  2248,  2248,
    2248,  2248,  2248,  2248,  2248,     0,     0,  1752,     0,     0,
     713,     0,  1753,   597,     0,     0,     0,     0,     0,     0,
    2249,     0,     0,  2249,  2249,  2249,  2249,  2249,  2249,  2249,
    2249,  2249,  2249,   729,  2136,     0,  1017,  1749,     0,     0,
       0,  1017,     0,  1549,  2248,  2248,     0,     0,  1763,   730,
       0,     0,   751,     0,     0,   751,  3214,  3215,     0,  1752,
    1549,     0,     0,     0,  1753,     0,     0,   731,     0,     0,
       0,     0,  2249,  2249,     0,     0,     0,     0,     0,     0,
       0,  2719,     0,     0,     0,     0,  1017,     0,     0,   751,
     751,     0,     0,     0,     0,     0,   732,     0,     0,     0,
     618,   751,   733,     0,     0,     0,     0,     0,     0,  1050,
       0,     0,     0,     0,     0,  1764,   734,     0,     0,     0,
    1754,     0,     0,     0,  1755,     0,  1765,  1766,  1767,     0,
    1768,  1769,  1770,  1771,  1772,  1773,     0,     0,  2039,   735,
       0,     0,     0,     0,  1756,  1757,     0,  2040,     0,     0,
       0,     0,  1822,     0,     0,     0,  1749,  1758,  1837,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1750,   713,  1754,     0,     0,     0,  1755,     0,  1752,     0,
       0,     0,     0,  1753,     0,     0,     0,     0,  1759,     0,
       0,  1760,     0,   736,     0,     0,  1756,  1757,   597,   713,
     713,     0,     0,     0,  1761,     0,     0,     0,   751,  1758,
       0,     0,  2565,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2248,     0,     0,     0,     0,     0,
       0,   597,   713,   713,     0,   737,     0,     0,     0,     0,
       0,   738,     0,  1760,     0,     0,   739,     0,     0,   713,
     713,     0,  2249,     0,     0,     0,  1761,     0,     0,     0,
       0,     0,     0,     0,     0,  1763,     0,   751,     0,  1026,
       0,   740,   741,  3351,  3352,  3353,     0,     0,     0,     0,
       0,  1973,     0,   742,     0,     0,     0,     0,   743,     0,
       0,  1754,     0,     0,   618,  1755,     0,   744,  2514,     0,
       0,     0,     0,     0,     0,     0,  2433,     0,     0,     0,
       0,     0,     0,     0,     0,  1756,  1757,  1763,     0,     0,
       0,     0,     0,     0,     0,     0,  2521,     0,  1758,     0,
       0,     0,  1764,     0,     0,     0,     0,     0,     0,   713,
     713,   713,     0,  1765,  1766,  1767,     0,  1768,  1769,  1770,
    1771,  1772,  1773,     0,     0,     0,     0,     0,     0,  1759,
       0,     0,  1760,     0,     0,  2248,  2248,     0,     0,     0,
       0,     0,     0,     0,     0,  1761,   713,  1762,     0,     0,
       0,  1323,     0,     0,  1764,  1549,     0,     0,   617,     0,
       0,   713,  2588,  2249,  2249,  2972, -1870, -1870,     0,  1768,
    1769,  1770,  1771,  1772,  1773,     0,     0,     0,  2985,     0,
       0,     0,     0,  1549,  1549,     0,  1549,     0,  3423,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1549,     0,  1549,     0,     0,  1763,   597,     0,     0,
       0,     0,     0,     0,  2190,     0,     0,     0,     0,   751,
       0,     0,     0,     0,     0,     0,     0,   597,     0,     0,
       0,  1549,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1026,     0,  1749,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   605,  1750,     0,     0,
       0,  1549,     0,     0,     0,  1752,     0,     0,     0,     0,
    1753,     0,     0,  1764,     0,     0,     0,  1549,     0,     0,
       0,     0,     0,     0,  1765,  1766,  1767,   751,  1768,  1769,
    1770,  1771,  1772,  1773,  1128,   618,   618,     0,     0,     0,
       0,     0,     0,     0,  2675,  1549,     0,  2248,     0,   751,
    2248,     0,     0,     0,     0,  1549,     0,   751,     0,  2248,
    2248,     0,     0,     0,     0,     0,  1549,  2136,   618,     0,
       0,     0,   605,     0,   605,  2249,   605,     0,  2249,     0,
    1549,     0,   605,   605,     0,     0,     0,  2249,  2249,     0,
       0,   618,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1837,     0,     0,     0,     0,     0,
     605,     0,     0,  1549,     0,     0,     0,  1549,  1754,     0,
       0,     0,  1755,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2808,  2565,  2565,     0,   605,     0,     0,
       0,     0,  1756,  1757,   618,   618,     0,     0,   605,   605,
       0,     0,     0,     0,     0,  1758,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1549,     0,     0,
     713,   713,     0,     0,     0,     0,  2248,  2248,     0,  2830,
       0,  2833,     0,     0,     0,     0,  1759,     0,     0,  1760,
    1549,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1761,     0,  2249,  2249,     0,  1550,   605,  2844,
       0,  2521,  2521,  2521,  2521,  2521,     0,  1549,     0,     0,
       0,     0,     0,     0,     0,   605,   605,     0,     0,     0,
       0,     0,  1749,  1552,   713,     0,     0,     0,     0,  2855,
     752,  1549,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1752,  2548,     0,  2464,     0,  1753,
    2464,   751,  3170,  1763,     0,     0,     0,  2136,     0,  2565,
       0,     0,     0,     0,     0,  2433,     0,     0,     0,   862,
       0,     0,     0,     0,     0,     0,     0,   870,     0,     0,
    2588,     0,   713,  2937,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2548,  2844,  3210,     0,     0,     0,  2433,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   597,   926,     0,     0,     0,   804,     0,     0,
    1764,     0,     0,   605,  2725,     0,     0,     0,   805,     0,
       0,  1765,  1766,  1767,     0,  1768,  1769,  1770,  1771,  1772,
    1773,  2988,     0,     0,  1549,  1973,     0,     0,   806,     0,
       0,     0,     0,     0,     0,     0,     0, -1870,     0,     0,
       0,  1755,     0,     0,     0,     0,     0,     0,   807,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1756,  1757,     0,   808,     0,     0,     0,     0,   605,
       0,     0,     0,     0, -1870,  3019,     0,     0,     0,     0,
       0,  1050,   809,     0,     0,     0,     0,     0,  1651,     0,
       0,  1655,   597,   713,   597,     0,     0,     0,  3027,  3275,
       0,   618,     0,     0,  1549,     0,     0,     0,  1760,     0,
       0,   810,     0,  2565,     0,     0,     0,   811,     0,     0,
       0,  1761,     0,     0,  1749,  3048,     0,     0,     0,     0,
       0,   812,     0,     0,     0,     0,     0,     0,  1549,     0,
       0,     0,     0,     0,     0,     0,  1752,     0,     0,  3064,
       0,  1753,     0,   751,     0,     0,     0,     0,     0,   751,
       0,   713,     0,     0,     0,     0,     0,     0,   713,     0,
       0,     0,     0,     0,  3336,     0,     0,   605,   751,     0,
       0,     0, -1870,     0,  3341,     0,     0,   713,   605,     0,
       0,     0,     0,     0,     0,  1976,     0,  3210,  2136,     0,
       0,     0,  2136,     0,     0,  1550,     0,     0,   813,     0,
     597,     0,     0,     0,  1787,     0,   814,     0,     0,   618,
     618,   751,     0,   751,     0,     0,  2735,     0,     0,   815,
       0,  1552,  1550,   605,     0,  1017,   605,     0,   605,   605,
    1549,     0,     0,     0,     0,  1977,  1550,     0,     0,  1764,
     816,     0,  1978,  1979,   817,   751,   818,     0,  1552, -1870,
       0,   819,  3111,  1755,  1768,  1769,  1770,  1771,  1772,  1773,
       0,     0,  1552,     0,  2565,     0,     0,     0,     0,     0,
       0,     0,     0,  1756,  1757,   362,   820,   821,   362,  1980,
    1550,     0,     0,     0,     0,  2433, -1870,  2464,   822,     0,
     618,   362,   605,   823,     0,  1550,     0,     0,     0,     0,
       0,     0,   824,     0,     0,     0,  1552,     0,     0,  1026,
    3336,   825,  1550,   362,  1026,  1026,     0,     0,  1981,     0,
    1760,  1552,     0,  1982,   713,     0,     0,     0,     0,     0,
       0,     0,  3157,  1761,     0,     0,     0,  1550,  1552,     0,
       0,     0,     0,     0,     0,     0,     0,   795,     0,     0,
     751,   751,     0,     0,     0,     0,     0,     0,     0,     0,
    1983,     0,     0,  1552,     0,     0,     0,     0,     0,  1749,
       0,     0,   713,     0,     0,  1984,  1985,  1549,  1986,  1987,
    1550,  1988,     0,  1750,     0,     0,     0,     0,     0,  1550,
       0,  1752,  3336,  1026, -1870,     0,  1753,     0,     0,     0,
       0,   894,     0,     0,     0,     0,  1552,  1549,   894,  1989,
     894,   605,     0,     0,     0,  1552,     0,   713,     0,     0,
       0,   362,     0,     0,     0,  1026,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1990,     0,     0,     0,     0,     0,     0,  3489,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1764,  1050,     0,     0,     0,     0,     0,  3064,     0,
       0,     0,  1991,     0,  1992,     0,  1768,  1769,  1770,  1771,
    1772,  1773,     0,  3489,     0,     0,   605,     0,     0,     0,
       0,     0,     0,     0,     0,  1993,   605,     0,   751,  1054,
       0,     0,  1994,     0,  1754,  1995,     0,     0,  1755,     0,
    3489,     0,     0,     0,     0,     0,     0,     0,     0,  1550,
    1093,   751,     0,     0,     0,     0,     0,   362,  1756,  1757,
       0,   751,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1758,     0,     0,     0,  1552,     0,     0,     0,     0,
    1787,  2172,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   362,     0,     0,   362,     0,     0,
       0,     0,  1759,     0,  2136,  1760,     0,     0,     0,  2136,
       0,     0,  2136,     0,     0,     0,     0,     0,  1761,     0,
    1762,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     605,   605,   605,     0,     0,     0,     0,   605,   605,     0,
       0,     0,   605,   605,     0,  2937,     0,     0,     0,   605,
       0,  1187,     0,     0,     0,     0,     0,  1189,   605,     0,
     605,     0,  1549,     0,     0,     0,     0,     0,  1196,     0,
       0,     0,     0,     0,   605,  3362,   605,     0,     0,  1763,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1189,     0,     0,
       0,     0,     0,     0,   751,   751,   751,   751,  1651,     0,
       0,     0,  1189,     0,  2336,     0,  1549,  1339,     0,     0,
       0,     0,  2172,     0,     0,     0,     0,     0,     0,     0,
       0,  1353,     0,     0,     0,     0,     0,     0,   605,     0,
       0,     0,     0,     0,     0,     0,  1764,     0,  1550,  1550,
       0,     0,     0,     0,     0,     0,     0,  1765,  1766,  1767,
       0,  1768,  1769,  1770,  1771,  1772,  1773,     0,     0,     0,
       0,  2886,     0,     0,  1552,  1552,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   795,     0,     0,     0,     0,     0,
       0,     0,     0, -1867,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1749,  1017,     0,   605,     0,     0,     0,
       0,     0,   605,     0,     0,     0,     0,  1750,   618,     0,
       0,     0,     0,     0,  2136,  1752,     0,     0,     0,     0,
    1753,     0,     0,  1749, -1867,     0,  1550,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -1867,  1750,     0,     0,
    1508, -1867,     0,  1550,     0,  1752, -1867,     0,     0, -1867,
    1753, -1867,  1552,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1749,  1552,
       0,     0,     0,     0,     0,     0, -1867,     0,     0,     0,
    3484,     0,  1750,     0,     0,     0,  1584,  1585,  1586,     0,
    1752,     0,     0,     0, -1867,  1753,     0,     0,     0,     0,
    1749,   605,     0,     0,  1017,     0,   751,     0,     0,   605,
       0,     0,   605,   605,     0,     0,     0,     0,     0,     0,
       0,     0,  1752,     0,     0,     0,   751,  1753,  1754,   362,
       0,     0,  1755,   362,  1973, -1867,     0,  1024,     0,     0,
    1017,  1024,     0, -1867,     0,     0,     0,     0,     0,   751,
       0,     0,  1756,  1757,  1189,     0,   605,     0,  1754,     0,
     605,     0,  1755,     0,   605,  1758,     0,     0,     0,     0,
       0,  1024,     0,  1189,   605,     0,     0,     0, -1867,   605,
       0,   751,  1756,  1757,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1758,  1759,     0,     0,  1760,
       0,     0,  3069,  1754,     0,     0,     0,  1755,     0,     0,
    1131,     0,  1761,  1024,  1762,     0,     0,     0,   866,  1024,
       0,     0,  1017,     0,     0,   605,  1759,  1756,  1757,  1760,
       0,     0,     0,     0,     0, -1870,     0,     0, -1867,  1755,
    1758,     0,  1761,     0,  1762,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -1867,     0,     0,  1756,
    1757,     0,     0, -1867, -1867, -1867,     0,     0,   605,     0,
       0,  1759, -1870,  1763,  1760,     0,   618,  1651,     0,     0,
    2623,     0,  1655,     0,     0,     0,     0,  1761,     0,  1762,
   -1867,  1017,     0, -1867, -1867, -1867,     0,     0,     0,     0,
       0,     0,     0,  1763,     0,     0,  1760,     0,  1829,     0,
       0,     0,  1306,     0,     0,     0,     0,   894,     0,  1761,
     894,     0,   605,     0,     0,  1017,     0,     0,     0,     0,
       0,     0,   362,     0,     0,     0,     0,     0,     0,     0,
    1764,     0,  1306,     0,     0,     0,     0,     0,  1763,     0,
       0,  1765,  1766,  1767,     0,  1768,  1769,  1770,  1771,  1772,
    1773,     0,     0,     0,     0,  3053,     0,     0,  1550,     0,
    1764,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -1870,  1765,  1766,  1767,     0,  1768,  1769,  1770,  1771,  1772,
    1773,     0,     0,     0,  1552,  3097,  1550,  1550,     0,  1550,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1550,  1764,  1550,     0,     0,     0,
       0,     0,  1552,  1552,     0,  1552,  1765,  1766,  1767,     0,
    1768,  1769,  1770,  1771,  1772,  1773,     0,     0,  2853,     0,
    1552,     0,  1552,     0,  1550,     0,     0,  1764,  2172,     0,
     605,  2019,   605,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1768,  1769,  1770,  1771,  1772,  1773,     0,     0,
    1552,     0,     0,     0,  1550,  1306,   362,     0,     0,     0,
    1024,     0,     0,     0,     0,     0,  1024,     0,     0,     0,
    1550,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1552,     0,     0,     0,     0,     0,  1563,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1552,     0,  1550,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1550,     0,
       0,  1024,     0,     0,     0,     0,     0,     0,     0,  1550,
       0,     0,     0,     0,  1552,     0,     0,   605,     0,     0,
       0,     0,     0,  1550,  1552,     0,     0,     0,     0,     0,
       0,     0,     0,   605,     0,  1552,     0,     0,     0,     0,
     605,   605,     0,     0,     0,     0,     0,     0,     0,  1552,
       0,     0,     0,     0,     0,     0,  1550,     0,     0,     0,
    1550,     0,     0,  2154,     0,     0,  2157,     0,     0,     0,
       0,     0,   605,     0,   605,   605,     0,     0,     0,     0,
       0,     0,  1552,   605,     0,     0,  1552,     0,     0,   605,
       0,  1306,     0,     0,   605,     0,   605,     0,     0,     0,
    1189,  1189,     0,     0,     0,     0,     0,   605,   605,    80,
    1550,     0,  2198,     0,     0,    84,     0,   605,  1306,     0,
       0,     0,    90,     0,    91,     0,     0,    94,     0,     0,
       0,     0,     0,  1550,     0,     0,  1552,     0,   104,     0,
       0,     0,  1306,  1306,     0,  1306,     0,     0,     0,     0,
     605,   605,     0,     0,     0,     0,   117,   118,     0,  1552,
    1550,   618,     0,  1306,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   126,  1550,     0,  1552,     0,     0,     0,
       0,     0,     0,   127,   128,   129,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1811,     0,   937,     0,
    1552,     0,     0,     0,     0,     0,     0,     0,     0,  2326,
       0,     0,     0,     0,     0,     0,     0,   138,     0,   139,
     140,     0,     0,     0,   142,   143,  1306,     0,     0,  1306,
    1306,     0,     0,   145,   146,     0,   605,     0,     0,     0,
     362,   362,   362,     0,     0,     0,   605,   148,     0,   149,
       0,     0,   152,     0,     0,     0,     0,     0,   153,     0,
       0,     0,     0,     0, -1869,     0,     0,   154,  2354,     0,
       0,     0,     0,   155,     0,     0,     0,     0,   156,     0,
     158,     0,     0,     0,   160,   362,     0,  1550,     0,     0,
     605,     0,   362,     0,  1563,   164,     0,   165,   362,     0,
       0,     0,   894,     0,     0, -1869,     0,     0,     0,     0,
       0,     0,     0,  1552,     0,     0,     0, -1869,     0,     0,
       0,  1957, -1869,   170,     0,     0,     0, -1869,     0,     0,
   -1869,     0, -1869,     0,     0,  1563,     0,   894,     0,     0,
       0,     0,     0,     0,     0,     0,   179,   180,     0,     0,
       0,     0,   181,     0,     0,     0,     0, -1869,     0,     0,
     182,     0,     0,   894,     0,     0,     0,  1550,     0,     0,
       0,     0,     0,     0,     0, -1869,     0,   187,     0,  1563,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1552,  2059,     0,     0,     0,     0,     0,
       0,  1550,     0,     0,     0,     0,     0,   197,     0,     0,
       0,  1563,     0,     0,     0,     0, -1869,   199,     0,     0,
     200,     0,   201,     0, -1869,     0,   202,  1552,     0,   605,
     605,   203,     0,     0,   205,     0,  1563,     0,   207,   362,
       0,     0,     0,   208,     0,     0,     0,     0,   209,     0,
    2475,   211,     0,     0,     0,     0,   605,   214,     0, -1869,
       0,   605,   605,   605,   605,   605,     0,     0,     0,   605,
       0,     0,     0,     0,  1024,     0,  1024,     0,     0,  1563,
       0,  1024,     0,     0,   220,     0,   221,     0,  1563,     0,
       0,     0,   223,     0,   224,     0,     0,   225,     0,   866,
     226,     0,     0,  1550,     0,     0,  1553,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2539, -1869,
       0,     0,     0,   605,     0,     0,  1024,  1749,     0,  1552,
       0,     0,     0,     0,     0,     0,     0, -1869,     0,     0,
    2549,  1750,     0,   231, -1869, -1869, -1869,     0,  2570,  1752,
       0,     0,     0,     0,  1753,     0,     0,  1306,  1306,     0,
       0,     0,     0,     0,     0,  1306,     0,  2623,  1306,  1306,
       0, -1869,     0,     0, -1869, -1869, -1869,  2233,     0,     0,
    1306,  1306,     0,     0,     0,     0,     0,     0,  1306,     0,
       0,     0,  1306,  1306,  1306,  1306,     0,     0,     0,     0,
       0,     0,  1306,  1306,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1563,  1306,
     362,     0,     0,  1306,     0,     0,  1555,  1306,     0,     0,
       0,  1306,     0,     0,  1306,  1306,  1306,  1306,  1306,  1306,
    1306,  1306,  1306,     0,  1306,     0,     0,     0,     0,  1306,
    1550,     0,     0,  1306,     0,  2172,   605,     0,     0,     0,
       0,     0,  1754,     0,     0,   605,  1755,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1552,     0,   605,     0,
    1550,     0,     0,     0,   605,   605,  1756,  1757,     0,   605,
     605,     0,     0,     0,   605,     0,     0,   362,     0,  1758,
       0,     0,     0,     0,     0,     0,  1552,     0,     0,  1306,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1759,     0,     0,  1760,     0,     0,     0,     0,     0,   362,
       0,   362,     0,     0,  1749,     0,  1761,     0,  1762,     0,
       0,     0,  2750,     0,     0,   605,     0,     0,  1750,     0,
       0,     0,     0,     0,     0,     0,  1752,     0,     0,     0,
       0,  1753,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   362,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1306,
       0,     0,     0,   708,     0,     0,     0,  1763,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1957,  1563,     0,
       0,     0,     0,     0,     0,   708,     0,     0,     0,     0,
       0,     0,     0,     0,  1553,     0,     0,     0,     0,     0,
       0,     0,     0,  1749,     0,     0,     0,   605,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1750,     0,     0,
       0,  1553,     0,     0,     0,  1752,     0,     0,     0,     0,
    1753,     0,     0,     0,  1764,  1553,     0,     0,     0,  1754,
       0,     0,     0,  1755,     0,  1765,  1766,  1767,     0,  1768,
    1769,  1770,  1771,  1772,  1773,     0,     0,   605,     0,  3226,
       0,     0,     0,  1756,  1757,  1550,     0,     0,     0,  1306,
       0,     0,     0,   890,     0,  1563,  1758,     0,     0,  1553,
     890,     0,   890,     0,     0,     0,     0,     0,     0,     0,
    1306,  1552,  1563,   708,  1553,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1759,     0,     0,
    1760,  1553,     0,     0,  1555,     0,     0,     0,     0,  1550,
       0,     0,     0,  1761,     0,  1762,     0,     0,     0,     0,
       0,     0,     0,     0,  2933,     0,  1553,     0,  1754,     0,
    2939,  1555,  1755,     0,     0,  1552,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1555,     0,  1024,     0,  2955,
       0,     0,  1756,  1757,     0,     0,  1306,     0,     0,     0,
       0,     0,     0,     0,     0,  1758,     0,     0,     0,  1553,
       0,     0,     0,     0,  1763,     0,     0,     0,  1553,     0,
       0,     0,   605,   605,     0,     0,     0,   605,     0,  1555,
       0,     0,  2994,     0,  2995,     0,  1759,     0,     0,  1760,
       0,     0,     0,     0,  1555,     0,     0,     0,     0,     0,
    1306,     0,  1761,     0,  1762,     0,     0,     0,     0,     0,
       0,  1555,     0,   605,     0,     0,  1189,     0,     0,     0,
       0,     0,     0,  1306,     0,     0,     0,     0,     0,     0,
       0,  1764,     0,     0,     0,     0,  1555,     0,     0,     0,
     605,     0,  1765,  1766,  1767,     0,  1768,  1769,  1770,  1771,
    1772,  1773,     0,     0,     0,  1306,  3247,     0,     0,  1306,
       0,     0,     0,  1763,     0,     0,     0,     0,     0,     0,
       0,  1306,  1306,  1306,  1306,  1749,     0,     0,     0,  1555,
    1306,     0,     0,     0,     0,     0,     0,     0,  1555,     0,
    1306,  1306,     0,  1306,     0,     0,     0,  1752,  1553,     0,
       0,     0,  1753,     0,     0,  1306,     0,  1306,     0,     0,
       0,  1306,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3079,  3080,     0,     0,     0,     0,  1306,     0,     0,
    1764,     0,     0,     0,     0,     0,     0,  1024,     0,  1306,
    1306,  1765,  1766,  1767,     0,  1768,  1769,  1770,  1771,  1772,
    1773,     0,     0,     0,     0,  3383,     0,     0,     0,     0,
    1306,     0,     0,     0,     0,     0,  1306,     0,     0,     0,
       0,     0,     0,     0,  1306,  1306,  1306,  3070,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1563,     0,     0,
       0,     0,     0,     0,     0,  1749,     0,     0,  1306,     0,
   -1870,     0,     0,     0,  1755,     0,     0,     0,  1555,  1750,
       0,     0,     0,     0,     0,  1957,  1563,  1752,  1563,     0,
       0,     0,  1753,     0,  1756,  1757,     0,     0,     0,     0,
       0,     0,     0,  1563,     0,  1563,     0, -1870,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1749,     0,     0,     0,     0,     0,     0,     0,  3145,
       0,     0,     0,  1563,     0,  1750,     0,     0,     0,  2358,
       0,  1760,     0,  1752,     0,     0,     0,     0,  1753,     0,
       0,     0,  3155,     0,  1761,     0,     0,  1553,  1553,     0,
       0,     0,  3159,  1563,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1749,     0,     0,     0,  2877,  1563,
       0,     0,     0,     0,     0,     0,     0,     0,  1750,     0,
       0,     0,     0,     0,     0,     0,  1752,     0,     0,     0,
    1754,  1753,     0,     0,  1755,     0,   362,  1563,     0,     0,
    2359,     0,     0,     0,     0, -1870,     0,  1563,     0,     0,
       0,     0,     0,     0,  1756,  1757,     0,     0,  1563,     0,
       0,   708,     0,     0,     0,     0,     0,  1758,     0,  1021,
       0,     0,  1563,  1021,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1553,  1754,     0,  1024,     0,
    1755,     0,  1024,     0,     0,     0,     0,     0,  1759,     0,
       0,  1760,  1553,  1021,     0,  1563,     0,  1555,  1555,  1563,
    1756,  1757,  1764,     0,  1761,     0,  1762,     0,     0,  2701,
       0,     0,     0,  1758,  2702,  1024,     0,  1768,  1769,  1770,
    1771,  1772,  1773,     0,     0,  3248,  3249,  3250,  3251,  1754,
       0,     0,     0,  1755,     0,  1021,     0,     0,     0,     0,
    1306,  1021,     0,     0,  1759,     0,  1306,  1760,     0,  1563,
       0,     0,     0,  1756,  1757,     0,     0,     0,  1306,     0,
    1761,     0,  1762,     0,  1306,  1763,  1758,     0,  1306,     0,
       0,     0,  1563,  1306,     0,     0,  1306,  1306,  1306,  1306,
    1306,  1306,  1306,  1306,  1306,  1306,     0,     0,     0,     0,
    1306,  1306,     0,     0,     0,  1555,     0,  1759,     0,  1563,
    1760,     0,     0,     0,  1306,     0,     0,     0,     0,     0,
       0,  1306,  1555,  1761,  1306,  1762,  1306,     0,     0,     0,
       0,  1763,     0,  1563,  1306,  1306,  1306,     0,     0,     0,
    1306,     0,  1764,  1306,  1301,     0,     0,     0,     0,   890,
       0,     0,   890,  1765,  1766,  1767,     0,  1768,  1769,  1770,
    1771,  1772,  1773,     0,     0,     0,     0,  3446,     0,     0,
       0,     0,     0,     0,  1301,  2360,     0,     0,     0,     0,
       0,     0,     0,     0,  1763,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1764,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1749,  1765,
    1766,  1767,     0,  1768,  1769,  1770,  1771,  1772,  1773,     0,
       0,     0,  1750,     0,     0,  1751,     0,     0,     0,     0,
    1752,     0,     0,     0,     0,  1753,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1563,     0,     0,     0,
       0,  1764,     0,     0,     0,     0,     0,  3381,     0,     0,
       0,     0,  1765,  1766,  1767,     0,  1768,  1769,  1770,  1771,
    1772,  1773,     0,     0,     0,     0,     0,  1189,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3419,     0,     0,     0,     0,     0,     0,  1301,   708,     0,
       0,     0,  1021,     0,     0,  1306,     0,     0,  1021,     0,
       0,     0,     0,     0,     0,     0,  1563,  1553,     0,     0,
       0,     0,  3427,     0,     0,     0,     0,     0,  1561,     0,
       0,     0,     0,  1754,     0,     0,     0,  1755,     0,     0,
       0,     0,     0,     0,     0,  1553,  1553,     0,  1553,     0,
    1563,     0,     0,  1021,     0,     0,     0,  1756,  1757,     0,
      73,     0,     0,  1553,  1024,  1553,     0,     0,     0,  1024,
    1758,     0,  1024,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1553,     0,     0,     0,     0,     0,     0,
       0,  1759,     0,     0,  1760,  1306,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1761,     0,  1762,
       0,     0,     0,  1553,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1555,     0,  1553,
       0,     0,   589,  1301,     0,     0,  1306,  1306,     0,     0,
       0,  1306,  1563,     0,     0,     0,     0,     0,  1306,  1306,
       0,     0,  1306,     0,     0,  1555,  1555,  1553,  1555,     0,
    1301,     0,     0,     0,     0,     0,     0,  1553,  1763,     0,
       0,     0,     0,  1555,     0,  1555,     0,     0,  1553,     0,
       0,     0,     0,     0,  1301,  1301,     0,  1301,     0,     0,
       0,     0,  1553,     0,     0,     0,   790,     0,     0,     0,
       0,     0,     0,  1555,     0,  1301,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   604,     0,     0,
       0,     0,     0,     0,     0,  1553,  1306,     0,   589,  1553,
       0,     0,     0,  1555,     0,  1764,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1765,  1766,  1767,  1555,
    1768,  1769,  1770,  1771,  1772,  1773,     0,     0,     0,     0,
       0,     0,     0,     0,  1024,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1555,  1301,  1553,
    1306,  1301,  1301,     0,  1024,     0,     0,  1555,     0,  1563,
       0,     0,     0,   851,     0,     0,     0,     0,  1555,     0,
       0,     0,  1553,     0,     0,     0,     0,     0,  1306,     0,
       0,  1306,  1555,   604,     0,   851,     0,     0,     0,  1563,
    1306,  1306,     0,     0,  1306,     0,     0,     0,     0,  1553,
       0,  1306,  1306,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1555,  1561,     0,  1749,  1555,
     708,     0,     0,  1553,   890,  1306,     0,     0,     0,     0,
       0,     0,  1750,     0,     0,  2660,     0,     0,     0,     0,
    1752,     0,     0,  1955,  1024,  1753,     0,     0,  1749,     0,
       0,     0,     0,     0,     0,     0,     0,  1561,     0,   890,
       0,     0,  1750,     0,     0,     0,     0,     0,     0,  1555,
    1752,     0,     0,     0,     0,  1753,     0,     0,     0,     0,
    1024,  1306,     0,     0,     0,   890,     0,  1749,     0,     0,
       0,     0,  1555,     0,     0,     0,     0,     0,     0,     0,
       0,  1561,     0,     0,     0,     0,     0,  1306,  1306,  1752,
       0,     0,     0,     0,  1753,     0,  1561,     0,     0,  1555,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1556,
       0,     0,     0,  1561,     0,     0,  1553,     0,     0,     0,
       0,     0,     0,  1555,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1754,     0,     0,     0,  1755,  1561,     0,
       0,   708,  1024,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1756,  1757,     0,
       0,     0,     0,  1754,     0,     0,     0,  1755,     0,  3073,
    1758,     0,     0,     0,     0,     0,  1021,     0,  1021,     0,
       0,  1561,     0,  1021,     0,     0,     0,  1756,  1757,     0,
    1561,     0,     0,     0,  1563,     0,  1553,     0,     0,     0,
    1758,  1759, -1870,     0,  1760,     0,  1755,     0,     0,     0,
       0,  1024,     0,     0,     0,     0,     0,  1761,     0,  1762,
       0,     0,     0,     0,     0,     0,  1756,  1757,  1021,     0,
    1553,  1759,     0,     0,  1760,     0,  1555,     0,     0, -1870,
       0,     0,     0,     0,     0,  1024,     0,  1761,  1563,  1762,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1301,
    1301,     0,     0,   790,     0,     0,     0,  1301,     0,     0,
    1301,  1301,     0,  1760,     0,     0,     0,     0,  1763,     0,
       0,     0,  1301,  1301,     0,     0,  1761,     0,     0,     0,
    1301,     0,     0,     0,  1301,  1301,  1301,  1301,     0,     0,
       0,     0,     0,     0,  1301,  1301,     0,     0,  1763,     0,
       0,     0,     0,     0,     0,     0,  1555,     0,     0,     0,
    1561,  1301,   708,     0,     0,  1301,     0,     0,     0,  1301,
       0,     0,  1553,  1301,     0,     0,  1301,  1301,  1301,  1301,
    1301,  1301,  1301,  1301,  1301,  1764,  1301, -1870,     0,     0,
    1555,  1301,  2662,     0,     0,  1301,  1765,  1766,  1767,     0,
    1768,  1769,  1770,  1771,  1772,  1773,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1764,     0,     0,     0,  1749,
       0,     0,     0,     0,     0,     0,  1765,  1766,  1767,     0,
    1768,  1769,  1770,  1771,  1772,  1773,     0,     0,    73,     0,
       0,  1752,     0,     0,     0,     0,  1753,     0,     0,     0,
       0,  1301,     0,     0,  1764,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1768,
    1769,  1770,  1771,  1772,  1773,     0,     0,  1556,     0,     0,
       0,     0,     0,  1749,     0,     0,     0,     0,     0,     0,
       0,     0,  1555,     0,     0,   589,     0,  1750,     0,     0,
       0,     0,     0,     0,  1556,  1752,     0,     0,     0,     0,
    1753,     0,     0,     0,     0,     0,     0,     0,  1556,  1553,
       0,  3245,     0,     0,     0,     0,   708,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1301,     0,     0,     0,     0,     0,     0,     0,  1553,
       0,     0,     0,     0, -1870,     0,     0,     0,  1755,  1955,
    1561,     0,  1556,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1556,  1756,  1757,
     604,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -1870,     0,     0,  1556,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   589,
       0,     0,     0,     0,     0,     0,     0,     0,  1754,  1556,
       0,     0,  1755,     0,     0,  1760,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   589,     0,  1761,  1555,
       0,     0,  1756,  1757,     0,     0,     0,   589,   589,     0,
       0,  1301,     0,     0,     0,  1758,   851,  1561,   851,     0,
     851,     0,  1556,     0,     0,     0,   851,   851,     0,  1555,
       0,  1556,  1301,     0,  1561,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1759,     0,     0,  1760,
       0,     0,     0,     0,   604,     0,     0,     0,     0, -1870,
       0,     0,  1761,     0,  1762,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2679,     0,     0,     0,     0,     0,
       0,   604,     0,     0,   589,   589,     0,     0,    73,    73,
       0,    73,   604,   604,     0,     0,  1408,     0,     0,  1021,
       0,     0,     0,     0,     0,     0,     0,     0,  1301,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1763,     0,     0,  1764,     0,     0,     0,
       0,     0,     0,     0,  1553,     0,     0,     0,     0,     0,
       0,  1768,  1769,  1770,  1771,  1772,  1773,     0,     0,     0,
       0,     0,  1387,     0,     0,     0,     0,     0,     0,     0,
       0,  1556,  1301,     0,     0,     0,     0,     0,     0,   604,
     604,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1387,     0,     0,     0,  1301,     0,     0,  1553,     0,
    1764,     0,   589,     0,     0,     0,     0,     0,     0,     0,
       0,  1765,  1766,  1767,     0,  1768,  1769,  1770,  1771,  1772,
    1773,     0,     0,     0,     0,     0,     0,  1301,     0,     0,
       0,  1301,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1301,  1301,  1301,  1301,     0,     0,     0,
       0,     0,  1301,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1301,  1301,  1555,  1301,     0,     0,   589,     0,
       0,     0,     0,     0,     0,     0,     0,  1301,     0,  1301,
       0,     0,     0,  1301,     0,     0,     0,   604,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1301,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1021,
       0,  1301,  1301,     0,     0,     0,     0,     0,  1555,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1301,     0,     0,     0,     0,     0,  1301,     0,
       0,     0,     0,     0,     0,     0,  1301,  1301,  1301,     0,
       0,     0,     0,   604,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1561,
    1556,  1556,     0,     0,  1749,     0,   589,     0,     0,     0,
    1301,     0,     0,     0,     0,     0,     0,   589,  1750,     0,
       0,  2710,     0,     0,     0,     0,  1752,  1955,  1561,     0,
    1561,  1753,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1749,     0,     0,  1561,     0,  1561,     0,     0,
       0,     0,     0,     0,     0,     0,  1750,     0,     0,     0,
       0,     0,   589,  1557,  1752,  1408,     0,  1408,  1408,  1753,
       0,     0,     0,     0,     0,  1561,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   604,     0,     0,     0,     0,     0,     0,  1556,     0,
       0,     0,   604,     0,     0,  1561,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1556,     0,     0,     0,     0,
       0,  1561,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   589,     0,     0,     0,     0,     0,     0,     0,  1754,
      73,     0,     0,  1755,    73,     0,     0,   604,   708,  1561,
    1387,     0,  1387,  1387,     0,     0,     0,     0,     0,  1561,
       0,     0,  2715,  1756,  1757,     0,     0,     0,     0,     0,
    1561,     0,     0,     0,     0,     0,  1758,  1754,     0,     0,
       0,  1755,     0,     0,  1561,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1021,  1756,  1757,     0,  1021,     0,     0,  1759,     0,     0,
    1760,     0,     0,     0,  1758,     0,   604,  1561,     0,     0,
       0,  1561,     0,  1761,     0,  1762,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1021,     0,     0,
       0,     0,     0,     0,     0,  1759,     0,     0,  1760,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1761,  1301,  1762,     0,     0,     0,     0,  1301,     0,
       0,  1561,     0,     0,     0,     0,     0,     0,     0,     0,
    1301,     0,     0,     0,  1763,     0,  1301,     0,     0,     0,
    1301,     0,     0,     0,  1561,  1301,     0,     0,  1301,  1301,
    1301,  1301,  1301,  1301,  1301,  1301,  1301,  1301,     0,     0,
       0,     0,  1301,  1301,     0,     0,     0,     0,     0,     0,
       0,  1561,  1763,     0,     0,   589,  1301,     0,     0,     0,
       0,     0,     0,  1301,     0,  1387,  1301,     0,  1301,     0,
       0,     0,     0,     0,     0,  1561,  1301,  1301,  1301,     0,
       0,  1764,  1301,     0,     0,  1301,     0,     0,     0,     0,
       0,     0,  1765,  1766,  1767,     0,  1768,  1769,  1770,  1771,
    1772,  1773,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1764,
       0,  1557,     0,     0,     0,     0,     0,     0,     0,     0,
    1765,  1766,  1767,     0,  1768,  1769,  1770,  1771,  1772,  1773,
     604,     0,     0,     0,     0,     0,     0,     0,  1557,     0,
     851,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1557,     0,     0,     0,     0,     0,     0,     0,
    1556,     0,     0,     0,     0,     0,   589,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1561,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1556,  1556,
     888,  1556,     0,     0,     0,     0,  1557,   888,     0,   888,
       0,     0,     0,     0,     0,     0,  1556,     0,  1556,     0,
       0,  1557,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1557,     0,
       0,     0,     0,     0,     0,     0,  1556,     0,     0,     0,
       0,     0,     0,     0,   851,   851,   851,  1301,     0,     0,
       0,   604,   851,  1557,     0,     0,   851,   851,  1561,     0,
       0,     0,     0,   851,     0,     0,  1556,   589,     0,     0,
       0,     0,   851,     0,   851,     0,     0,     0,     0,     0,
       0,  1749,  1556,     0,     0,     0,     0,     0,   851,     0,
     851,     0,  1561,     0,     0,  1750,  1557,     0,     0,     0,
       0,     0,     0,  1752,     0,  1557,  1021,     0,  1753,     0,
    1556,  1021,     0,     0,  1021,     0,     0,     0,     0,     0,
    1556,  1749,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1556,     0,     0,     0,  1750,     0,     0,     0,     0,
       0,     0,     0,  1752,     0,  1556,     0,  1301,  1753,     0,
       0,   589,   604,     0,     0,     0,     0,     0,  1408,     0,
      73,     0,    73,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1556,     0,
       0,     0,  1556,     0,     0,     0,     0,     0,  1301,  1301,
       0,     0,     0,  1301,  1561,     0,     0,     0,     0,     0,
    1301,  1301,     0,     0,  1301,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1754,     0,     0,     0,
    1755,     0,     0,     0,     0,  1560,     0,     0,     0,     0,
    1387,     0,  1556,     0,     0,  1557,   604,     0,     0,     0,
    1756,  1757,     0,  1387,     0,     0,     0,  2443,     0,     0,
       0,     0,     0,  1758,     0,  1556,  1754,     0,     0,     0,
    1755,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1301,     0,
    1756,  1757,  1556,     0,  1759,     0,     0,  1760,     0,     0,
       0,     0,     0,  1758,     0,     0,     0,     0,     0,     0,
    1761,     0,  1762,     0,     0,   589,  1556,     0,     0,   589,
       0,     0,     0,   589,     0,     0,  1021,     0,     0,     0,
       0,     0,     0,  2519,  1759,     0,     0,  1760,     0,     0,
       0,     0,  1301,     0,     0,   851,  1021,     0,     0,     0,
    1761,  1561,  1762,  1387,     0,     0,  1387,  1387,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2543,
    1301,  1763,     0,  1301,     0,     0,     0,     0,     0,     0,
       0,  1561,  1301,  1301,   589,     0,  1301,     0,     0,     0,
       0,     0,     0,  1301,  1301,     0,     0,     0,     0,     0,
     604,     0,     0,     0,   604,     0,     0,     0,   604,     0,
       0,  1763,     0,     0,     0,     0,     0,  1301,   851,     0,
       0,     0,     0,   851,     0,     0,     0,   589,     0,  1556,
       0,     0,     0,  3016,     0,     0,  1021,     0,  1764,     0,
       0,     0,     0,     0,  1557,  1557,     0,     0,     0,  1765,
    1766,  1767,     0,  1768,  1769,  1770,  1771,  1772,  1773,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   604,
       0,     0,  1021,  1301,     0,     0,     0,     0,  1764,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1765,
    1766,  1767,     0,  1768,  1769,  1770,  1771,  1772,  1773,  1301,
    1301,     0,     0,     0,     0,     0,     0,     0,     0,  1556,
       0,     0,   604,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1019,   762,     0,     0,
    1019,     0,     0,     0,     0,     0,     0,     0,   763,     0,
       0,     0,  1557,  1556,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1021,     0,     0,     0,   764,  1557,
    1019,     0,     0,  1560,     0,     0,   851,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   765,     0,  -486,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1953,     0,     0,     0,   766,     0,     0,     0,     0,     0,
     767,     0,  1019,     0,  1560,     0,  1561,     0,  1019,     0,
       0,  1408,   768,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1021,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -613,     0,   769,     0,  1556,     0,   770,  1560,     0,
       0,     0,     0,     0,     0,     0,     0,  1021,     0,     0,
    1561,  -599,     0,  1560,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1560,     0,     0,     0,  -402,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   851,   771,  1387,     0,     0,     0,
       0,  1298,     0,     0,     0,  1560,   888,  2835,     0,   888,
       0,     0,     0,     0,  2838,     0,  2839,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1298,     0,     0,     0,     0,     0,     0,   772,     0,
     773,     0,     0,     0,     0,     0,     0,     0,  1560,     0,
       0,     0,     0,     0,     0,     0,     0,  1560,     0,  -402,
       0,   589,     0,   589,   589,     0,     0,     0,     0,     0,
       0,     0,   589,     0,     0,     0,     0,     0,  1408,     0,
     774,     0,     0,     0,  -613,  2519,   775,     0,     0,     0,
       0,   851,  1556,     0,     0,     0,  2903,   589,     0,     0,
       0,     0,     0,     0,     0,     0,  1408,  1387,     0,     0,
       0,     0,     0,     0,  1387,  1387,     0,   776,   777,     0,
     778,     0,  1556,     0,     0,     0,     0,     0,   779,     0,
       0,     0,   780,   781,     0,     0,     0,   782,     0,   589,
     589,     0,   783,     0,     0,     0,   604,     0,   604,   604,
       0,     0,     0,     0,     0,     0,     0,   604,     0,     0,
       0,     0,     0,  1387,  1298,     0,     0,     0,   851,  1019,
     851,     0,     0,     0,     0,  1019,     0,     0,     0,     0,
       0,  2905,   604,     0,  1557,     0,     0,  1560,     0,     0,
       0,  1387,     0,     0,     0,  1559,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1557,  1557,     0,  1557,     0,     0,     0,     0,
    1019,     0,     0,     0,   604,   604,     0,     0,     0,     0,
    1557,     0,  1557,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1557,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   589,
    1557,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1557,     0,     0,     0,
    1298,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     851,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     851,     0,     0,     0,  1557,     0,     0,  1298,     0,     0,
       0,     0,     0,     0,  1557,     0,     0,  1556,     0,     0,
       0,     0,     0,     0,     0,  1557,     0,     0,     0,     0,
       0,  1298,  1298,     0,  1298,     0,     0,     0,     0,  1557,
       0,     0,     0,     0,   604,     0,     0,     0,     0,     0,
       0,     0,  1298,     0,     0,     0,  1953,  1953,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1556,  1557,     0,     0,     0,  1557,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   589,   589,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1298,  1557,     0,  1298,  1298,
    2519,  2519,  2519,  2519,  2519,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1557,
       0,     0,     0,     0,  1560,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1560,     0,     0,     0,     0,  1557,     0,     0,     0,
       0,     0,     0,   604,   604,     0,     0,     0,     0,     0,
       0,     0,   589,  1559,     0,     0,     0,     0,     0,     0,
    1557,   888,     0,     0,     0,     0,     0,     0,     0,     0,
     851,     0,     0,     0,     0,   851,   851,   851,   851,   851,
    1952,     0,     0,   851,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1559,     0,   888,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   888,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   604,  1559,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1559,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1559,     0,     0,  1557,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3258,   589,     0,     0,     0,     0,
       0,     0,    73,     0,     0,  1559,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   589,   589,     0,     0,     0,   589,   589,
    3284,     0,     0,   589,  3288,     0,     0,     0,     0,     0,
       0,     0,     0,  1019,     0,  1019,     0,     0,  1559,     0,
    1019,     0,     0,     0,     0,     0,     0,  1559,     0,     0,
       0,     0,     0,  1557,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     604,     0,     0,     0,     0,     0,     0,     0,     0,   851,
       0,     0,     0,     0,   589,  1019,     0,  1557,     0,     0,
       0,     0,   851,     0,     0,     0,     0,     0,   604,   604,
       0,     0,     0,   604,   604,     0,     0,     0,   604,     0,
       0,     0,     0,     0,     0,     0,  1298,  1298,     0,     0,
       0,     0,     0,     0,  1298,     0,     0,  1298,  1298,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1298,
    1298,     0,     0,     0,     0,     0,     0,  1298,     0,     0,
       0,  1298,  1298,  1298,  1298,     0,  1560,     0,     0,     0,
       0,  1298,  1298,     0,     0,     0,     0,     0,     0,   604,
       0,     0,     0,     0,     0,     0,   589,  1559,  1298,     0,
       0,     0,  1298,     0,  1953,  1953,  1298,  1953,     0,  1557,
    1298,     0,     0,  1298,  1298,  1298,  1298,  1298,  1298,  1298,
    1298,  1298,  1560,  1298,  1560,     0,     0,     0,  1298,     0,
       0,     0,  1298,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   589,     0,     0,     0,
       0,     0,  1560,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   604,  1560,     0,     0,     0,     0,     0,  1298,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1953,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1953,     0,     0,     0,
       0,   604,     0,     0,     0,     0,  1560,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1560,     0,     0,
       0,     0,     0,     0,     0,     0,  1557,     0,     0,     0,
       0,  1953,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1298,     0,
       0,     0,     0,     0,     0,     0,  1557,     0,     0,     0,
       0,     0,     0,     0,  1560,     0,  1952,  1559,  1560,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1560,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   851,   851,     0,     0,
       0,  1560,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1298,     0,
       0,     0,     0,     0,  1559,     0,     0,     0,  1560,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1298,
       0,  1559,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1560,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1022,     0,     0,     0,  1022,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1019,     0,     0,     0,
       0,     0,     0,     0,     0,  1298,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1022,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1557,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1560,     0,     0,  1022,  1298,
       0,     0,     0,     0,  1022,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1298,     0,     0,  1557,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1298,     0,     0,     0,  1298,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1298,  1298,  1298,  1298,     0,  1560,     0,     0,     0,  1298,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1298,
    1298,     0,  1298,     0,     0,     0,     0,  1302,     0,     0,
       0,     0,     0,     0,  1298,     0,  1298,     0,     0,  3187,
    1298,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1298,  1302,     0,     0,
       0,     0,     0,     0,     0,     0,  1019,     0,  1298,  1298,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1298,
       0,     0,     0,     0,     0,  1298,     0,     0,     0,     0,
       0,     0,     0,  1298,  1298,  1298,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1559,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1298,     0,     0,
       0,  1560,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1952,  1559,     0,  1559,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1559,     0,  1559,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1302,     0,     0,     0,     0,  1022,     0,     0,     0,     0,
       0,  1022,  1559,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1562,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1559,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1022,     0,  1559,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1559,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1559,     0,  1560,     0,
       0,     0,     0,     0,     0,     0,     0,  1559,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1559,     0,     0,     0,     0,     0,     0,  1560,     0,
       0,     0,     0,     0,     0,     0,     0,  1019,     0,     0,
       0,  1019,     0,     0,     0,     0,  1302,     0,     0,     0,
       0,     0,     0,     0,  1559,     0,     0,     0,  1559,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1302,  1019,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1302,  1302,  1298,
    1302,     0,     0,     0,     0,  1298,     0,     0,  1559,     0,
       0,     0,     0,     0,     0,     0,     0,  1298,  1302,     0,
       0,     0,     0,  1298,     0,     0,     0,  1298,     0,     0,
       0,  1559,  1298,     0,     0,  1298,  1298,  1298,  1298,  1298,
    1298,  1298,  1298,  1298,  1298,     0,     0,     0,     0,  1298,
    1298,     0,     0,     0,     0,     0,     0,     0,  1559,     0,
       0,     0,     0,  1298,     0,     0,     0,     0,     0,     0,
    1298,     0,     0,  1298,     0,  1298,     0,     0,     0,     0,
       0,     0,  1559,  1298,  1298,  1298,     0,     0,     0,  1298,
       0,  1302,  1298,     0,  1302,  1302,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1560,     0,     0,     0,     0,     0,  1562,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1956,     0,     0,     0,
       0,     0,     0,     0,     0,  1559,     0,     0,     0,     0,
    1562,     0,     0,     0,     0,     0,     0,  1560,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1562,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1562,
       0,     0,     0,     0,  1298,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1559,  1562,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1562,     0,     0,     0,     0,     0,     0,     0,  1559,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1019,     0,     0,     0,     0,  1019,     0,
       0,  1019,     0,     0,     0,     0,     0,     0,     0,  1022,
       0,  1022,     0,     0,  1562,     0,  1022,     0,     0,     0,
       0,     0,     0,  1562,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1298,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1280,     0,     0,     0,     0,     0,     0,
       0,  1022,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1298,  1298,     0,     0,     0,
    1298,  1559,     0,  1347,     0,     0,     0,  1298,  1298,     0,
       0,  1298,  1302,  1302,     0,     0,     0,     0,     0,     0,
    1302,     0,     0,  1302,  1302,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1302,  1302,     0,     0,     0,
       0,     0,     0,  1302,     0,     0,     0,  1302,  1302,  1302,
    1302,     0,     0,     0,     0,     0,     0,  1302,  1302,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1562,  1302,     0,     0,     0,  1302,     0,
       0,     0,  1302,     0,     0,  1298,  1302,     0,     0,  1302,
    1302,  1302,  1302,  1302,  1302,  1302,  1302,  1302,     0,  1302,
       0,     0,     0,     0,  1302,     0,     0,     0,  1302,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1019,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1503,     0,     0,  1298,
       0,     0,     0,  1019,     0,     0,     0,     0,  1559,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1302,     0,     0,  1298,     0,     0,
    1298,     0,     0,     0,     0,     0,     0,     0,  1559,  1298,
    1298,     0,     0,  1298,     0,     0,     0,     0,     0,     0,
    1298,  1298,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1298,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1019,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1302,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1019,
    1298,     0,  1956,  1562,     0,     0,     0,     0,     0,     0,
       0,     0,  1694,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1298,  1298,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1718,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1737,  1738,     0,  1741,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1019,     0,     0,  1778,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1302,     0,     0,     0,     0,     0,
    1562,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1302,     0,  1562,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1559,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1019,     0,     0,     0,     0,     0,     0,  1849,     0,     0,
    1856,  1858,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1022,     0,  1019,     0,     0,  1559,     0,     0,
       0,  1302,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1302,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1302,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1302,     0,     0,     0,  1302,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1302,  1302,  1302,  1302,
       0,     0,     0,     0,     0,  1302,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1302,  1302,     0,  1302,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1302,     0,  1302,     0,     0,     0,  1302,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1302,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1022,     0,  1302,  1302,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1775,     0,     0,
       0,     0,     0,     0,     0,  1302,     0,     0,     0,     0,
       0,  1302,     0,     0,     0,     0,     0,     0,     0,  1302,
    1302,  1302,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1562,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1302,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1775,     0,     0,     0,     0,     0,
    1956,  1562,     0,  1562,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1562,     0,
    1562,     0,     0,     0,     0,     0,  2217,     0,     0,     0,
    2219,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1562,  2241,
       0,     0,     0,  2244,     0,     0,  2254,     0,     0,     0,
       0,     0,     0,  2261,  2266,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1562,     0,
    2277,     0,     0,     0,  2283,     0,     0,     0,  2294,     0,
       0,     0,  2301,     0,  1562,  2303,  2304,  2305,  2306,  2307,
    2308,  2309,  2310,  2311,     0,  2312,     0,     0,     0,     0,
    1280,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1562,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1562,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1562,     0,     0,     0,     0,     0,     0,
    1775,     0,     0,     0,     0,     0,     0,  1562,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1347,     0,     0,  1022,     0,     0,     0,  1022,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1562,     0,     0,     0,  1562,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1022,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1302,     0,     0,     0,     0,
       0,  1302,     0,     0,  1562,     0,     0,     0,     0,     0,
       0,     0,     0,  1302,     0,     0,     0,     0,     0,  1302,
    2406,     0,     0,  1302,     0,     0,     0,  1562,  1302,     0,
       0,  1302,  1302,  1302,  1302,  1302,  1302,  1302,  1302,  1302,
    1302,     0,     0,     0,     0,  1302,  1302,     0,     0,     0,
       0,     0,     0,     0,  1562,     0,     0,     0,     0,  1302,
       0,     0,     0,     0,     0,     0,  1302,     0,     0,  1302,
       0,  1302,     0,     0,     0,     0,     0,     0,  1562,  1302,
    1302,  1302,     0,     0,     0,  1302,     0,     0,  1302,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1775,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1775,     0,     0,     0,     0,
    2492,  2250,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1775,  1775,     0,     0,  1775,     0,
       0,  2511,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1775,     0,     0,     0,     0,
       0,  1562,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2603,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1775,     0,     0,     0,
    1302,     0,     0,  1775,     0,  1775,     0,     0,     0,     0,
       0,  1562,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1280,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2656,  1562,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1022,
       0,     0,     0,     0,  1022,     0,     0,  1022,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2266,     0,  2266,  2266,     0,     0,     0,     0,
    1302,  2718,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2738,     0,  2740,     0,
       0,     0,  2743,     0,     0,     0,     0,     0,     0,     0,
       0,  1302,  1302,     0,     0,     0,  1302,  1562,     0,     0,
       0,     0,     0,  1302,  1302,     0,     0,  1302,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1347,     0,     0,     0,     0,     0,  1849,     0,     0,
       0,     0,     0,     0,     0,  1858,  1858,  1856,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2813,
       0,  1302,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1022,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1302,     0,     0,     0,  1022,
       0,     0,     0,     0,  1562,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1302,     0,     0,  1302,     0,     0,     0,
       0,     0,     0,     0,  1562,  1302,  1302,     0,     0,  1302,
       0,     0,     0,     0,     0,     0,  1302,  1302,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1775,     0,     0,     0,     0,
    1302,     0,     0,     0,  1775,     0,  1775,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1022,
       0,     0,     0,     0,     0,     0,     0,     0,  1775,     0,
       0,  1775,     0,  2250,  2697,     0,     0,  2250,     0,     0,
       0,  1775,     0,     0,     0,     0,     0,     0,  1775,     0,
       0,     0,     0,  1775,     0,  1022,  1302,     0,     0,     0,
       0,     0,     0,     0,  1775,     0,     0,     0,  2250,  2250,
    1775,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1775,  1302,  1302,     0,     0,     0,     0,  1775,     0,
    1775,  1775,  1775,  1775,  1775,  1775,  1775,  1775,  1775,  1775,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3013,     0,     0,     0,     0,     0,  3017,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1022,     0,  3022,
       0,     0,     0,     0,     0,  3023,     0,     0,     0,  3025,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3042,  3043,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1562,
       0,     0,  3056,  1775,     0,  3059,     0,  3061,     0,     0,
       0,     0,     0,     0,     0,  3066,  1022,     0,     0,     0,
       0,  3071,     0,     0,  3074,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1022,     0,     0,  1562,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1775,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1775,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     4,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     5,     0,
       0,     0,     0,     0,     0,     0,     0,     6,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     7,     8,
       0,     0,     0,     0,     9,     0,    10,    11,     0,     0,
       0,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,     0,     0,     0,     0,     0,
    1775,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    36,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1775,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2697,
       0,  2250,     0,     0,  2250,  2250,  2250,  2250,  2250,  2250,
    2250,  2250,  2250,  2250,     0,  2697,  3222,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    37,
       0,     0,     0,     0,     0,  1775,     0,     0,     0,     0,
    2697,  2697,     0,     0,     0,     0,     0,     0,    38,     0,
       0,     0,     0,  2250,  2250,  1775,     0,  1775,     0,     0,
    1775,     0,  3237,     0,     0,     0,     0,     0,    39,  3243,
    3244,     0,     0,  3246,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    40,
       0,     0,    41,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    42,     0,     0,     0,     0,     0,     0,
    1775,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3299,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    43,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3344,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    45,  2250,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    46,  3365,     0,     0,     0,     0,
       0,     0,     0,  3367,     0,    47,     0,     0,     0,     0,
      48,    49,     0,    50,     0,    51,     0,     0,     0,    52,
      53,     0,    54,    55,     0,     0,  3375,    56,    57,    58,
      59,    60,     0,     0,    61,    62,    63,    64,     0,    65,
      66,    67,     0,    68,    69,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1775,     0,  3411,     0,  1775,     0,     0,     0,     0,  1775,
    1775,     0,  1775,     0,     0,  2697,     0,     4,     0,  2697,
    2697,  2697,  2697,  2697,  2697,  2697,  2697,  2697,  2697,  1775,
    1775,     5,     0,     0,     0,     0,     0,     0,     0,     0,
       6,     0,     0,  1775,  2250,  2250,  1775,     0,  1775,     0,
       0,     7,     8,  1775,  2697,  2697,     0,     0,  1775,    10,
      11,  1775,     0,     0,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     4,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     5,     0,     0,     0,     0,     0,     0,     0,
       0,     6,     0,     0,     0,     0,     0,     0,     0,    36,
       0,     0,     7,     8,     0,     0,  2697,     0,     0,     0,
      10,    11,     0,     0,     0,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    37,     0,     0,     0,     0,     0,     0,  1775,
      36,     0,     0,     0,     0,     0,  2250,     0,     0,  2250,
       0,    38,  2697,  2697,  1775,     0,     0,     0,  2250,  2250,
    1775,  1775,     0,  1775,     0,     0,     0,     0,     0,     0,
       0,    39,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    40,     0,     0,    41,     0,     0,     0,     0,
       0,     0,     0,    37,     0,     0,  1775,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    42,     0,     0,     0,
       0,     0,    38,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    39,     0,     0,     0,     0,     0,     0,     0,
       0,  1775,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2697,  2250,  2250,  2697,     0,     0,
    2697,  2697,  1775,    40,  1775,     0,    41,    43,     0,     0,
       0,     0,  1775,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    44,     0,     0,     0,     0,  1775,     0,
       0,     0,     0,     0,     0,    45,     0,     0,     0,     0,
       0,  2697,  2697,     0,     0,     0,     0,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    47,     0,
       0,     0,     0,    48,    49,     0,    50,     0,    43,     0,
       0,     0,    52,    53,     0,    54,    55,     0,     0,     0,
      56,    57,    58,    59,    60,     0,     0,    61,    62,   990,
       0,     0,     0,   991,     0,     0,     0,    69,     0,     0,
       0,     0,     0,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    45,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    46,     0,
       0,     0,     4,     0,     0,     0,     0,     0,     0,    47,
       0,     0,     0,     0,    48,    49,     5,    50,     0,     0,
       0,     0,     0,    52,    53,     6,    54,    55,     0,     0,
       0,    56,    57,    58,    59,    60,     7,     8,    61,    62,
     990,  1401,     0,     0,    10,    11,     0,     0,    69,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,     0,     4,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     5,     0,
       0,     0,     0,     0,     0,     0,     0,     6,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     7,     8,
       0,     0,     0,     0,    36,     0,    10,    11,     0,     0,
       0,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    36,    37,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    38,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    39,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    40,     0,    37,
      41,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    38,     0,
       0,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    39,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    40,
       0,     0,    41,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    43,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    44,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      45,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    46,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    47,    43,     0,     0,     0,    48,    49,
       0,    50,     0,     0,     0,     0,     0,    52,    53,     0,
      54,    55,     0,     0,     0,    56,    57,    58,    59,    60,
       0,     0,    61,    62,   990,  1896,     0,     0,     0,     0,
      44,     0,    69,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    45,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,     0,     0,     0,     0,
      48,    49,     0,    50,     0,     0,     0,     0,     0,    52,
      53,     0,    54,    55,     0,     0,     0,    56,    57,    58,
      59,    60,     0,     0,    61,    62,   990,   619,    81,    82,
      83,   372,    85,    86,    69,    87,    88,    89,   373,     0,
     374,     0,    93,     0,    95,    96,    97,    98,    99,   100,
     620,   101,   102,   103,   375,   621,     0,   105,   106,   107,
     108,   622,   623,     0,   110,   111,   112,     0,   113,   624,
     625,   116,   376,   377,     0,     0,     0,   378,   379,     0,
       0,     0,     0,   380,     0,     0,     0,     0,     0,     0,
       0,     0,   381,     0,   382,     0,   383,   384,     0,   385,
     386,   387,   388,   389,   390,   391,   392,   626,   393,   394,
     627,   628,   629,   630,   631,   632,   633,   395,   396,   634,
     397,   131,   398,   399,   400,   133,   134,   135,   136,     0,
     635,   401,   402,     0,   403,   404,   636,   637,   405,   638,
     137,   407,   639,   408,   409,   410,   411,   141,   640,   641,
     412,   413,   414,   415,   416,   642,   417,   418,   144,   419,
     643,   420,   421,   422,   147,   423,   644,   645,   646,   647,
     648,   424,   425,   426,   427,   428,   150,   151,   429,   649,
     430,   650,   431,     0,   432,   433,   434,   651,   435,   652,
     653,   436,   437,   438,   439,   654,   440,   441,   442,   655,
     443,   656,   444,   445,   446,   157,   447,     0,   159,   657,
     448,   449,   161,   658,   450,   659,   451,   162,   660,   163,
     452,     0,   453,   661,   454,   166,   662,   455,   663,   456,
     457,   458,   459,   167,   460,   461,   462,   664,   463,   464,
     465,   466,   467,   468,   665,   168,   169,   666,   469,   470,
     471,   667,   171,   668,   172,   669,     0,   173,   174,   472,
     175,   473,   474,   475,   476,   477,   670,   176,   177,   478,
     178,   671,   479,   480,   481,     0,     0,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   183,   184,
     185,   672,   493,   494,   495,   496,   497,   498,   499,   186,
     500,   673,   501,   502,   188,   503,   674,   189,   190,   504,
     505,   675,   676,   506,   677,   678,   679,   507,   508,   680,
     681,   191,   192,   193,   194,   509,   510,   511,   512,     0,
     195,   196,   513,   514,   515,   682,   516,   517,   518,   519,
     520,   521,   198,   522,   523,   683,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   684,   533,   534,   204,   535,
     536,   206,   537,   538,   539,   540,   541,   542,     0,   685,
     543,   544,   545,   686,   546,   210,   547,   548,   212,   549,
     213,   687,   550,   551,   552,   553,   554,   555,   556,   557,
     215,   558,   688,   559,   560,   689,   561,   562,   563,   564,
     690,   216,   217,   691,   692,   566,   218,   567,   219,   693,
     568,   569,   570,   571,   572,   694,   695,   573,   574,   575,
     576,   696,   697,   577,   578,     0,     0,   227,   580,   228,
     581,     0,   698,   699,   582,   583,   584,   585,   586,   587,
      81,    82,    83,   229,    85,    86,   230,    87,    88,    89,
       0,     0,     0,    92,    93,     0,    95,    96,    97,    98,
      99,   100,     0,   101,   102,   103,     0,     0,     0,   105,
     106,   107,   108,   700,   109,     0,   110,   111,   112,     0,
     113,   114,   115,   116,     0,     0,     0,     0,     0,   119,
     120,     0,     0,     0,     0,   121,     0,     0,     0,     0,
       0,     0,     0,     0,   122,     0,   123,     0,   124,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   131,     0,     0,     0,   133,   134,   135,
     136,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   137,     0,     0,     0,     0,     0,     0,   141,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     144,     0,     0,     0,     0,     0,   147,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   150,   151,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   157,     0,     0,
     159,     0,     0,     0,   161,     0,     0,     0,     0,   162,
       0,   163,     0,     0,     0,     0,     0,   166,     0,     0,
       0,     0,     0,     0,     0,   167,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   168,   169,     0,
       0,     0,     0,     0,   171,     0,   172,     0,     0,   173,
     174,     0,   175,     0,     0,     0,     0,     0,     0,   176,
     177,     0,   178,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     183,   184,   185,     0,     0,     0,     0,     0,     0,     0,
       0,   186,     0,     0,     0,     0,   188,     0,     0,   189,
     190,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   191,   192,   193,   194,     0,     0,     0,
       0,     0,   195,   196,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   198,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     204,     0,     0,   206,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   210,     0,     0,
     212,     0,   213,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   215,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   216,   217,     0,     0,     0,   218,     0,
     219,     0,     0,     0,     0,     0,     0,   222,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   227,
       0,   228,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   229,     0,     0,   230,    81,
      82,    83,     0,    85,    86,     0,    87,    88,    89,     0,
       0,     0,    92,    93,     0,    95,    96,    97,    98,    99,
     100,     0,   101,   102,   103,     0,  2371,     0,   105,   106,
     107,   108,     0,   109,     0,   110,   111,   112,     0,   113,
     114,   115,   116,     0,     0,     0,     0,     0,   119,   120,
       0,     0,     0,     0,   121,     0,     0,     0,     0,     0,
       0,     0,     0,   122,     0,   123,     0,   124,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   131,     0,     0,     0,   133,   134,   135,   136,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   137,     0,     0,     0,     0,     0,     0,   141,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   144,
       0,     0,     0,     0,     0,   147,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   150,   151,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   157,     0,     0,   159,
       0,     0,     0,   161,     0,     0,     0,     0,   162,     0,
     163,     0,     0,     0,     0,     0,   166,     0,     0,     0,
       0,     0,     0,     0,   167,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   168,   169,     0,     0,
       0,     0,     0,   171,     0,   172,     0,     0,   173,   174,
       0,   175,     0,     0,     0,     0,     0,     0,   176,   177,
       0,   178,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   183,
     184,   185,     0,     0,     0,     0,     0,     0,     0,     0,
     186,     0,     0,     0,     0,   188,     0,     0,   189,   190,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   191,   192,   193,   194,     0,     0,     0,     0,
       0,   195,   196,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   198,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   204,
       0,     0,   206,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   210,     0,     0,   212,
       0,   213,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   215,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   216,   217,     0,     0,     0,   218,     0,   219,
       0,     0,     0,     0,     0,     0,   222,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   227,     0,
     228,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   229,    80,     0,   230,    81,    82,
      83,    84,    85,    86,     0,    87,    88,    89,    90,     0,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
       0,   101,   102,   103,   104,  2373,     0,   105,   106,   107,
     108,     0,   109,     0,   110,   111,   112,     0,   113,   114,
     115,   116,   117,   118,     0,     0,     0,   119,   120,     0,
       0,     0,     0,   121,     0,     0,     0,     0,     0,     0,
       0,     0,   122,     0,   123,     0,   124,   125,     0,   126,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   127,
     128,   129,     0,     0,     0,     0,     0,     0,     0,     0,
     130,   131,     0,     0,   132,   133,   134,   135,   136,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     137,     0,     0,   138,     0,   139,   140,   141,     0,     0,
     142,   143,     0,     0,     0,     0,     0,     0,   144,   145,
     146,     0,     0,     0,   147,     0,     0,     0,     0,     0,
       0,     0,     0,   148,     0,   149,   150,   151,   152,     0,
       0,     0,     0,     0,   153,     0,     0,     0,     0,     0,
       0,     0,     0,   154,     0,     0,     0,     0,     0,   155,
       0,     0,     0,     0,   156,   157,   158,     0,   159,     0,
     160,     0,   161,     0,     0,     0,     0,   162,     0,   163,
       0,   164,     0,   165,     0,   166,     0,     0,     0,     0,
       0,     0,     0,   167,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   168,   169,     0,     0,   170,
       0,     0,   171,     0,   172,     0,     0,   173,   174,     0,
     175,     0,     0,     0,     0,     0,     0,   176,   177,     0,
     178,     0,   179,   180,     0,     0,     0,     0,   181,     0,
       0,     0,     0,     0,     0,     0,   182,     0,   183,   184,
     185,     0,     0,     0,     0,     0,     0,     0,     0,   186,
       0,     0,     0,   187,   188,     0,     0,   189,   190,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   191,   192,   193,   194,     0,     0,     0,     0,     0,
     195,   196,     0,   197,     0,     0,     0,     0,     0,     0,
       0,     0,   198,   199,     0,     0,   200,     0,   201,     0,
       0,     0,   202,     0,     0,     0,     0,   203,   204,     0,
     205,   206,     0,     0,   207,     0,     0,     0,     0,   208,
       0,     0,     0,     0,   209,   210,     0,   211,   212,     0,
     213,     0,     0,   214,     0,     0,     0,     0,     0,     0,
     215,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   216,   217,     0,     0,     0,   218,     0,   219,     0,
     220,     0,   221,     0,     0,   222,     0,     0,   223,     0,
     224,     0,     0,   225,     0,     0,   226,   227,     0,   228,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   229,     0,     0,   230,     0,     0,     0,
       0,     0,     0,   619,    81,    82,    83,   372,    85,    86,
       0,    87,    88,    89,   373,     0,   374,     0,    93,   231,
      95,    96,    97,    98,    99,   100,   620,   101,   102,   103,
     375,   621,     0,   105,   106,   107,   108,   622,   623,     0,
     110,   111,   112,     0,   113,   624,   625,   116,   376,   377,
       0,     0,     0,   378,   379,     0,     0,     0,     0,   380,
       0,     0,     0,     0,     0,     0,     0,     0,   381,     0,
     382,     0,   383,   384,     0,   385,   386,   387,   388,   389,
     390,   391,   392,  2330,   393,   394,     0,     0,     0,     0,
    1208,     0,     0,   395,   396,     0,   397,   131,   398,   399,
     400,   133,  1209,   135,  1210,  1211,     0,   401,   402,     0,
     403,   404,  1212,  1213,   405,  1214,  1215,   407,     0,   408,
     409,   410,   411,  1216,     0,     0,   412,   413,   414,   415,
     416,     0,   417,   418,  1217,   419,     0,   420,   421,   422,
     147,   423,  1218,  1219,  1220,  1221,  1222,   424,   425,   426,
     427,   428,  1223,  1224,   429,     0,   430,     0,   431,     0,
     432,   433,   434,     0,   435,  2331,     0,   436,  1225,   438,
     439,     0,   440,   441,   442,     0,   443,     0,   444,   445,
     446,  1226,   447,     0,  1227,  1228,   448,   449,  1229,     0,
     450,     0,   451,   162,     0,   163,   452,     0,   453,     0,
     454,  1230,     0,   455,     0,   456,   457,   458,   459,   167,
     460,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,   168,   169,     0,   469,   470,   471,  1231,  1232,     0,
    1233,     0,     0,   173,   174,   472,   175,   473,   474,   475,
     476,   477,     0,  1234,   177,   478,   178,     0,   479,   480,
     481,  1235,  1236,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,  1237,   184,  1238,   749,   493,   494,
     495,   496,   497,   498,   499,   186,   500,  1239,   501,   502,
     188,   503,  1240,  1241,  1242,   504,   505,     0,     0,   506,
     750,     0,     0,  1243,   508,     0,     0,   191,   192,   193,
    1244,   509,   510,   511,   512,     0,  1245,   196,   513,   514,
     515,     0,   516,   517,   518,   519,   520,   521,  1246,   522,
     523,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,     0,   533,   534,   204,   535,   536,  1247,   537,   538,
     539,   540,   541,   542,     0,     0,   543,   544,   545,  1248,
     546,   210,   547,   548,   212,   549,  1249,     0,   550,   551,
     552,   553,   554,   555,   556,   557,  1250,   558,     0,   559,
     560,     0,   561,   562,   563,   564,     0,  1251,  1252,     0,
       0,   566,  1253,   567,  1254,  1255,   568,   569,   570,   571,
     572,     0,  1256,   573,   574,   575,   576,  1257,     0,   577,
     578,     0,   579,  1258,   580,   228,   581,     0,     0,     0,
     582,   583,   584,   585,   586,   587,     0,     0,     0,   229,
      49,  1259,   230,   588,     0,     0,  1260,  1261,    52,    53,
    1262,    54,     0,     0,     0,     0,  1263,  1264,  2332,     0,
       0,     0,     0,     0,     0,  1266,  2333,   619,    81,    82,
      83,   372,    85,    86,     0,    87,    88,    89,   373,     0,
     374,     0,    93,     0,    95,    96,    97,    98,    99,   100,
     620,   101,   102,   103,   375,   621,     0,   105,   106,   107,
     108,   622,   623,     0,   110,   111,   112,     0,   113,   624,
     625,   116,   376,   377,     0,     0,     0,   378,   379,     0,
       0,     0,     0,   380,     0,     0,     0,     0,     0,     0,
       0,     0,   381,     0,   382,     0,   383,   384,     0,   385,
     386,   387,   388,   389,   390,   391,   392,     0,   393,   394,
       0,     0,     0,     0,  1208,     0,     0,   395,   396,     0,
     397,   131,   398,   399,   400,   133,  1209,   135,  1210,  1211,
       0,   401,   402,     0,   403,   404,  1212,  1213,   405,  1214,
    1215,   407,     0,   408,   409,   410,   411,  1216,     0,     0,
     412,   413,   414,   415,   416,     0,   417,   418,  1217,   419,
       0,   420,   421,   422,   147,   423,  1218,  1219,  1220,  1221,
    1222,   424,   425,   426,   427,   428,  1223,  1224,   429,     0,
     430,     0,   431,     0,   432,   433,   434,     0,   435,     0,
       0,   436,  1225,   438,   439,     0,   440,   441,   442,     0,
     443,     0,   444,   445,   446,  1226,   447,     0,  1227,  1228,
     448,   449,  1229,     0,   450,     0,   451,   162,     0,   163,
     452,     0,   453,     0,   454,  1230,     0,   455,     0,   456,
     457,   458,   459,   167,   460,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,   168,   169,     0,   469,   470,
     471,  1231,  1232,     0,  1233,     0,     0,   173,   174,   472,
     175,   473,   474,   475,   476,   477,     0,  1234,   177,   478,
     178,     0,   479,   480,   481,  1235,  1236,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,  1237,   184,
    1238,   749,   493,   494,   495,   496,   497,   498,   499,   186,
     500,  1239,   501,   502,   188,   503,  1240,  1241,  1242,   504,
     505,     0,     0,   506,   750,     0,     0,  1243,   508,     0,
       0,   191,   192,   193,  1244,   509,   510,   511,   512,     0,
    1245,   196,   513,   514,   515,     0,   516,   517,   518,   519,
     520,   521,  1246,   522,   523,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,     0,   533,   534,   204,   535,
     536,  1247,   537,   538,   539,   540,   541,   542,     0,     0,
     543,   544,   545,  1248,   546,   210,   547,   548,   212,   549,
    1249,     0,   550,   551,   552,   553,   554,   555,   556,   557,
    1250,   558,     0,   559,   560,     0,   561,   562,   563,   564,
       0,  1251,  1252,     0,     0,   566,  1253,   567,  1254,  1255,
     568,   569,   570,   571,   572,     0,  1256,   573,   574,   575,
     576,  1257,     0,   577,   578,     0,   579,  1258,   580,   228,
     581,     0,     0,     0,   582,   583,   584,   585,   586,   587,
       0,     0,     0,   229,    49,  1259,   230,   588,     0,     0,
    1260,  1261,    52,    53,  1262,    54,     0,     0,     0,     0,
    1263,  1264,     0,     0,     0,     0,     0,     0,     0,  1266,
    2252,   619,    81,    82,    83,   372,    85,    86,     0,    87,
      88,    89,   373,     0,   374,     0,    93,     0,    95,    96,
      97,    98,    99,   100,   620,   101,   102,   103,   375,   621,
       0,   105,   106,   107,   108,   622,   623,     0,   110,   111,
     112,     0,   113,   624,   625,   116,   376,   377,     0,     0,
       0,   378,   379,     0,     0,     0,     0,   380,     0,     0,
       0,     0,     0,     0,     0,     0,   381,     0,   382,     0,
     383,   384,     0,   385,   386,   387,   388,   389,   390,   391,
     392,     0,   393,   394,     0,     0,     0,     0,     0,     0,
       0,   395,   396,     0,   397,   131,   398,   399,   400,   133,
    1529,   135,  1530,  1211,     0,   401,   402,     0,   403,   404,
       0,     0,   405,  1531,  1532,   407,     0,   408,   409,   410,
     411,     0,     0,     0,   412,   413,   414,   415,   416,     0,
     417,   418,     0,   419,     0,   420,   421,   422,   147,   423,
       0,     0,     0,     0,     0,   424,   425,   426,   427,   428,
    1533,  1534,   429,     0,   430,     0,   431,     0,   432,   433,
     434,     0,   435,     0,     0,   436,  1225,   438,   439,     0,
     440,   441,   442,     0,   443,     0,   444,   445,   446,     0,
     447,     0,     0,     0,   448,   449,  1535,     0,   450,     0,
     451,   162,     0,   163,   452,     0,   453,     0,   454,     0,
       0,   455,     0,   456,   457,   458,   459,   167,   460,   461,
     462,  1942,   463,   464,   465,   466,   467,   468,     0,   168,
    1943,     0,   469,   470,   471,  1231,  1536,     0,  1537,     0,
       0,   173,   174,   472,   175,   473,   474,   475,   476,   477,
       0,     0,   177,   478,   178,     0,   479,   480,   481,     0,
       0,   482,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,  1538,   184,  1539,     0,   493,   494,   495,   496,
     497,   498,   499,     0,   500,     0,   501,   502,   188,   503,
       0,     0,  1540,   504,   505,     0,     0,   506,     0,     0,
       0,   507,   508,     0,     0,  1944,   192,   193,     0,   509,
     510,   511,   512,     0,     0,     0,   513,   514,   515,     0,
     516,   517,   518,   519,   520,   521,  1541,   522,   523,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,     0,
     533,   534,   204,   535,   536,     0,   537,   538,   539,   540,
     541,   542,     0,     0,   543,   544,   545,     0,   546,  1542,
     547,   548,   212,   549,  1543,     0,   550,   551,   552,   553,
     554,   555,   556,   557,     0,   558,     0,   559,   560,     0,
     561,   562,   563,   564,     0,  1544,  1545,     0,     0,   566,
       0,   567,     0,     0,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,   576,     0,     0,   577,   578,     0,
       0,  1546,   580,   228,   581,     0,     0,     0,   582,   583,
     584,   585,   586,   587,     0,     0,     0,   229,     0,     0,
     230,     0,    81,    82,    83,   372,    85,    86,     0,    87,
      88,    89,   373,     0,   374,     0,    93,     0,    95,    96,
      97,    98,    99,   100,  1945,   101,   102,   103,   375,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   116,   376,   377,     0,     0,
       0,   378,   379,     0,     0,     0,     0,   380,     0,     0,
       0,     0,     0,     0,     0,     0,   381,     0,   382,     0,
     383,   384,     0,   385,   386,   387,   388,   389,   390,   391,
     392,     0,   393,   394,     0,     0,     0,     0,     0,     0,
       0,   395,   396,     0,   397,     0,   398,   399,   400,     0,
     134,     0,   136,     0,     0,   401,   402,     0,   403,   404,
       0,     0,   405,   406,   137,   407,     0,   408,   409,   410,
     411,   141,     0,     0,   412,   413,   414,   415,   416,     0,
     417,   418,   144,   419,     0,   420,   421,   422,     0,   423,
       0,     0,     0,     0,     0,   424,   425,   426,   427,   428,
     150,   151,   429,     0,   430,     0,   431,     0,   432,   433,
     434,     0,   435,     0,     0,   436,   437,   438,   439,     0,
     440,   441,   442,     0,   443,     0,   444,   445,   446,   157,
     447,     0,   159,     0,   448,   449,   161,     0,   450,     0,
     451,     0,     0,     0,   452,     0,   453,     0,   454,   166,
       0,   455,     0,   456,   457,   458,   459,     0,   460,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,     0,
     169,     0,   469,   470,   471,     0,   171,     0,   172,     0,
       0,     0,     0,   472,     0,   473,   474,   475,   476,   477,
       0,   176,     0,   478,     0,     0,   479,   480,   481,     0,
       0,   482,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   183,     0,   185,     0,   493,   494,   495,   496,
     497,   498,   499,   186,   500,     0,   501,   502,     0,   503,
       0,   189,   190,   504,   505,     0,     0,   506,     0,     0,
       0,   507,   508,     0,     0,   191,     0,     0,   194,   509,
     510,   511,   512,     0,   195,   196,   513,   514,   515,     0,
     516,   517,   518,   519,   520,   521,   198,   522,   523,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,     0,
     533,   534,     0,   535,   536,   206,   537,   538,   539,   540,
     541,   542,     0,     0,   543,   544,   545,     0,   546,   210,
     547,   548,     0,   549,   213,     0,   550,   551,   552,   553,
     554,   555,   556,   557,   215,   558,     0,   559,   560,     0,
     561,   562,   563,   564,     0,   216,   217,     0,     0,   566,
     218,   567,   219,     0,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,   576,     0,  3414,   577,   578,     0,
     579,   227,   580,     0,   581,     0,     0,     0,   582,   583,
     584,   585,   586,   587,     0,     0,     0,   229,     0,     0,
     230,     0,     0,     0,     0,     0,     0,     0,     0,   619,
      81,    82,    83,   372,    85,    86,     0,    87,    88,    89,
     373, -1299,   374,     0,    93, -1299,    95,    96,    97,    98,
      99,   100,   620,   101,   102,   103,   375,   621,     0,   105,
     106,   107,   108,   622,   623,     0,   110,   111,   112,     0,
     113,   624,   625,   116,   376,   377,     0,     0,     0,   378,
     379,     0,     0,     0,     0,   380,     0,     0,     0,     0,
       0,     0,     0,     0,   381,     0,   382,     0,   383,   384,
       0,   385,   386,   387,   388,   389,   390,   391,   392,     0,
     393,   394,     0,     0,     0,     0,  1208,     0,     0,   395,
     396,     0,   397,   131,   398,   399,   400,   133,  1209,   135,
    1210,  1211,  2262,   401,   402,     0,   403,   404,  1212,  1213,
     405,  1214,  1215,   407,     0,   408,   409,   410,   411,  1216,
       0,     0,   412,   413,   414,   415,   416,     0,   417,   418,
    1217,   419,     0,   420,   421,   422,   147,   423,  1218,  1219,
    1220,  1221,  1222,   424,   425,   426,   427,   428,  1223,  1224,
     429,     0,   430,     0,   431,     0,   432,   433,   434,     0,
     435,     0,     0,   436,  1225,   438,   439,     0,   440,   441,
     442,     0,   443,     0,   444,   445,   446,  1226,   447,     0,
    1227,  1228,   448,   449,  1229,     0,   450,     0,   451,   162,
    2263,   163,   452,     0,   453,     0,   454,  1230,     0,   455,
       0,   456,   457,   458,   459,   167,   460,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,   168,   169,     0,
     469,   470,   471,  1231,  1232,     0,  1233,     0,     0,   173,
     174,   472,   175,   473,   474,   475,   476,   477,  2264,  1234,
     177,   478,   178,     0,   479,   480,   481,  1235,  1236,   482,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
    1237,   184,  1238,   749,   493,   494,   495,   496,   497,   498,
     499,   186,   500,  1239,   501,   502,   188,   503,  1240,  1241,
    1242,   504,   505,     0,     0,   506,   750,     0,     0,  1243,
     508,     0,     0,   191,   192,   193,  1244,   509,   510,   511,
     512,     0,  1245,   196,   513,   514,   515,     0,   516,   517,
     518,   519,   520,   521,  1246,   522,   523,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,     0,   533,   534,
     204,   535,   536,  1247,   537,   538,   539,   540,   541,   542,
       0,     0,   543,   544,   545,  1248,   546,   210,   547,   548,
     212,   549,  1249,     0,   550,   551,   552,   553,   554,   555,
     556,   557,  1250,   558,     0,   559,   560,     0,   561,   562,
     563,   564,     0,  1251,  1252,     0,  2265,   566,  1253,   567,
    1254,  1255,   568,   569,   570,   571,   572,     0,  1256,   573,
     574,   575,   576,  1257,     0,   577,   578,     0,   579,  1258,
     580,   228,   581,     0,     0,     0,   582,   583,   584,   585,
     586,   587,     0,     0,     0,   229,    49,  1259,   230,   588,
       0,     0,  1260,  1261,    52,    53,  1262,    54,     0,     0,
       0,     0,  1263,  1264,   619,    81,    82,    83,   372,    85,
      86,  1266,    87,    88,    89,   373,     0,   374,     0,    93,
       0,    95,    96,    97,    98,    99,   100,   620,   101,   102,
     103,   375,   621,     0,   105,   106,   107,   108,   622,   623,
       0,   110,   111,   112,     0,   113,   624,   625,   116,   376,
     377,     0,     0,     0,   378,   379,     0,     0,     0,     0,
     380,     0,     0,     0,     0,     0,     0,     0,     0,   381,
       0,   382,     0,   383,   384,     0,   385,   386,   387,   388,
     389,   390,   391,   392,     0,   393,   394,     0,     0,     0,
       0,  1208,     0,     0,   395,   396,     0,   397,   131,   398,
     399,   400,   133,  1209,   135,  1210,  1211,     0,   401,   402,
       0,   403,   404,  1212,  1213,   405,  1214,  1215,   407,     0,
     408,   409,   410,   411,  1216,     0,     0,   412,   413,   414,
     415,   416,     0,   417,   418,  1217,   419,     0,   420,   421,
     422,   147,   423,  1218,  1219,  1220,  1221,  1222,   424,   425,
     426,   427,   428,  1223,  1224,   429,     0,   430,     0,   431,
       0,   432,   433,   434,     0,   435,     0,     0,   436,  1225,
     438,   439,     0,   440,   441,   442,     0,   443,     0,   444,
     445,   446,  1226,   447,     0,  1227,  1228,   448,   449,  1229,
       0,   450,     0,   451,   162,     0,   163,   452,     0,   453,
       0,   454,  1230,     0,   455,     0,   456,   457,   458,   459,
     167,   460,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,   168,   169,     0,   469,   470,   471,  1231,  1232,
       0,  1233,     0,     0,   173,   174,   472,   175,   473,   474,
     475,   476,   477,     0,  1234,   177,   478,   178,     0,   479,
     480,   481,  1235,  1236,   482,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,  1237,   184,  1238,   749,   493,
     494,   495,   496,   497,   498,   499,   186,   500,  1239,   501,
     502,   188,   503,  1240,  1241,  1242,   504,   505,     0,     0,
     506,   750,     0,     0,  1243,   508,     0,     0,   191,   192,
     193,  1244,   509,   510,   511,   512,     0,  1245,   196,   513,
     514,   515,     0,   516,   517,   518,   519,   520,   521,  1246,
     522,   523,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,     0,   533,   534,   204,   535,   536,  1247,   537,
     538,   539,   540,   541,   542,     0,     0,   543,   544,   545,
    1248,   546,   210,   547,   548,   212,   549,  1249,     0,   550,
     551,   552,   553,   554,   555,   556,   557,  1250,   558,     0,
     559,   560,     0,   561,   562,   563,   564,     0,  1251,  1252,
       0,     0,   566,  1253,   567,  1254,  1255,   568,   569,   570,
     571,   572,     0,  1256,   573,   574,   575,   576,  1257,     0,
     577,   578,     0,   579,  1258,   580,   228,   581,     0,     0,
       0,   582,   583,   584,   585,   586,   587,     0,     0,     0,
     229,    49,  1259,   230,   588,     0,     0,  1260,  1261,    52,
      53,  1262,    54,     0,     0,     0,     0,  1263,  1264,  1265,
       0,     0,     0,     0,     0,     0,  1266,   619,    81,    82,
      83,   372,    85,    86,     0,    87,    88,    89,   373,     0,
     374,     0,    93,     0,    95,    96,    97,    98,    99,   100,
     620,   101,   102,   103,   375,   621,     0,   105,   106,   107,
     108,   622,   623,     0,   110,   111,   112,     0,   113,   624,
     625,   116,   376,   377,     0,     0,     0,   378,   379,     0,
       0,     0,     0,   380,     0,     0,     0,     0,     0,     0,
       0,     0,   381,     0,   382,     0,   383,   384,     0,   385,
     386,   387,   388,   389,   390,   391,   392,     0,   393,   394,
       0,     0,     0,     0,  1208,     0,     0,   395,   396,     0,
     397,   131,   398,   399,   400,   133,  1209,   135,  1210,  1211,
       0,   401,   402,     0,   403,   404,  1212,  1213,   405,  1214,
    1215,   407,     0,   408,   409,   410,   411,  1216,     0,     0,
     412,   413,   414,   415,   416,     0,   417,   418,  1217,   419,
       0,   420,   421,   422,   147,   423,  1218,  1219,  1220,  1221,
    1222,   424,   425,   426,   427,   428,  1223,  1224,   429,  1346,
     430,     0,   431,     0,   432,   433,   434,     0,   435,     0,
       0,   436,  1225,   438,   439,     0,   440,   441,   442,     0,
     443,     0,   444,   445,   446,  1226,   447,     0,  1227,  1228,
     448,   449,  1229,     0,   450,     0,   451,   162,     0,   163,
     452,     0,   453,     0,   454,  1230,     0,   455,     0,   456,
     457,   458,   459,   167,   460,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,   168,   169,     0,   469,   470,
     471,  1231,  1232,     0,  1233,     0,     0,   173,   174,   472,
     175,   473,   474,   475,   476,   477,     0,  1234,   177,   478,
     178,     0,   479,   480,   481,  1235,  1236,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,  1237,   184,
    1238,   749,   493,   494,   495,   496,   497,   498,   499,   186,
     500,  1239,   501,   502,   188,   503,  1240,  1241,  1242,   504,
     505,     0,     0,   506,   750,     0,     0,  1243,   508,     0,
       0,   191,   192,   193,  1244,   509,   510,   511,   512,     0,
    1245,   196,   513,   514,   515,     0,   516,   517,   518,   519,
     520,   521,  1246,   522,   523,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,     0,   533,   534,   204,   535,
     536,  1247,   537,   538,   539,   540,   541,   542,     0,     0,
     543,   544,   545,  1248,   546,   210,   547,   548,   212,   549,
    1249,     0,   550,   551,   552,   553,   554,   555,   556,   557,
    1250,   558,     0,   559,   560,     0,   561,   562,   563,   564,
       0,  1251,  1252,     0,     0,   566,  1253,   567,  1254,  1255,
     568,   569,   570,   571,   572,     0,  1256,   573,   574,   575,
     576,  1257,     0,   577,   578,     0,   579,  1258,   580,   228,
     581,     0,     0,     0,   582,   583,   584,   585,   586,   587,
       0,     0,     0,   229,    49,  1259,   230,   588,     0,     0,
    1260,  1261,    52,    53,  1262,    54,     0,     0,     0,     0,
    1263,  1264,   619,    81,    82,    83,   372,    85,    86,  1266,
      87,    88,    89,   373,     0,   374,     0,    93,     0,    95,
      96,    97,    98,    99,   100,   620,   101,   102,   103,   375,
     621,     0,   105,   106,   107,   108,   622,   623,     0,   110,
     111,   112,     0,   113,   624,   625,   116,   376,   377,     0,
       0,     0,   378,   379,     0,     0,     0,     0,   380,     0,
       0,     0,     0,     0,     0,     0,     0,   381,     0,   382,
       0,   383,   384,     0,   385,   386,   387,   388,   389,   390,
     391,   392,     0,   393,   394,     0,     0,     0,     0,  1208,
       0,     0,   395,   396,     0,   397,   131,   398,   399,   400,
     133,  1209,   135,  1210,  1211,     0,   401,   402,     0,   403,
     404,  1212,  1213,   405,  1214,  1215,   407,     0,   408,   409,
     410,   411,  1216,     0,     0,   412,   413,   414,   415,   416,
       0,   417,   418,  1217,   419,     0,   420,   421,   422,   147,
     423,  1218,  1219,  1220,  1221,  1222,   424,   425,   426,   427,
     428,  1223,  1224,   429,     0,   430,     0,   431,     0,   432,
     433,   434,     0,   435,     0,     0,   436,  1225,   438,   439,
       0,   440,   441,   442,     0,   443,     0,   444,   445,   446,
    1226,   447,     0,  1227,  1228,   448,   449,  1229,     0,   450,
       0,   451,   162,     0,   163,   452,     0,   453,     0,   454,
    1230,     0,   455,     0,   456,   457,   458,   459,   167,   460,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
     168,   169,     0,   469,   470,   471,  1231,  1232,     0,  1233,
       0,     0,   173,   174,   472,   175,   473,   474,   475,   476,
     477,     0,  1234,   177,   478,   178,     0,   479,   480,   481,
    1235,  1236,   482,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,  1237,   184,  1238,   749,   493,   494,   495,
     496,   497,   498,   499,   186,   500,  1239,   501,   502,   188,
     503,  1240,  1241,  1242,   504,   505,     0,     0,   506,   750,
       0,     0,  1243,   508,     0,     0,   191,   192,   193,  1244,
     509,   510,   511,   512,     0,  1245,   196,   513,   514,   515,
       0,   516,   517,   518,   519,   520,   521,  1246,   522,   523,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
       0,   533,   534,   204,   535,   536,  1247,   537,   538,   539,
     540,   541,   542,     0,   208,   543,   544,   545,  1248,   546,
     210,   547,   548,   212,   549,  1249,     0,   550,   551,   552,
     553,   554,   555,   556,   557,  1250,   558,     0,   559,   560,
       0,   561,   562,   563,   564,     0,  1251,  1252,     0,     0,
     566,  1253,   567,  1254,  1255,   568,   569,   570,   571,   572,
       0,  1256,   573,   574,   575,   576,  1257,     0,   577,   578,
       0,  1739,  1258,   580,   228,   581,     0,     0,     0,   582,
     583,   584,   585,   586,   587,     0,     0,     0,   229,    49,
    1259,   230,   588,     0,     0,  1260,  1261,    52,    53,  1262,
      54,     0,     0,     0,     0,  1263,  1264,   619,    81,    82,
      83,   372,    85,    86,  1266,    87,    88,    89,   373,     0,
     374,     0,    93,     0,    95,    96,    97,    98,    99,   100,
     620,   101,   102,   103,   375,   621,     0,   105,   106,   107,
     108,   622,   623,     0,   110,   111,   112,     0,   113,   624,
     625,   116,   376,   377,     0,     0,     0,   378,   379,     0,
       0,     0,     0,   380,     0,     0,     0,     0,     0,     0,
       0,     0,   381,     0,   382,     0,   383,   384,     0,   385,
     386,   387,   388,   389,   390,   391,   392,  1854,   393,   394,
       0,     0,     0,     0,  1208,     0,     0,   395,   396,     0,
     397,   131,   398,   399,   400,   133,  1209,   135,  1210,  1211,
       0,   401,   402,     0,   403,   404,  1212,  1213,   405,  1214,
    1215,   407,     0,   408,   409,   410,   411,  1216,     0,     0,
     412,   413,   414,   415,   416,     0,   417,   418,  1217,   419,
       0,   420,   421,   422,   147,   423,  1218,  1219,  1220,  1221,
    1222,   424,   425,   426,   427,   428,  1223,  1224,   429,     0,
     430,     0,   431,     0,   432,   433,   434,     0,   435,     0,
       0,   436,  1225,   438,   439,     0,   440,   441,   442,     0,
     443,     0,   444,   445,   446,  1226,   447,     0,  1227,  1228,
     448,   449,  1229,     0,   450,     0,   451,   162,     0,   163,
     452,     0,   453,     0,   454,  1230,     0,   455,     0,   456,
     457,   458,   459,   167,   460,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,   168,   169,     0,   469,   470,
     471,  1231,  1232,     0,  1233,     0,     0,   173,   174,   472,
     175,   473,   474,   475,   476,   477,     0,  1234,   177,   478,
     178,     0,   479,   480,   481,  1235,  1236,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,  1237,   184,
    1238,   749,   493,   494,   495,   496,   497,   498,   499,   186,
     500,  1239,   501,   502,   188,   503,  1240,  1241,  1242,   504,
     505,     0,     0,   506,   750,     0,     0,  1243,   508,     0,
       0,   191,   192,   193,  1244,   509,   510,   511,   512,     0,
    1245,   196,   513,   514,   515,     0,   516,   517,   518,   519,
     520,   521,  1246,   522,   523,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,     0,   533,   534,   204,   535,
     536,  1247,   537,   538,   539,   540,   541,   542,     0,     0,
     543,   544,   545,  1248,   546,   210,   547,   548,   212,   549,
    1249,     0,   550,   551,   552,   553,   554,   555,   556,   557,
    1250,   558,     0,   559,   560,     0,   561,   562,   563,   564,
       0,  1251,  1252,     0,     0,   566,  1253,   567,  1254,  1255,
     568,   569,   570,   571,   572,     0,  1256,   573,   574,   575,
     576,  1257,     0,   577,   578,     0,   579,  1258,   580,   228,
     581,     0,     0,     0,   582,   583,   584,   585,   586,   587,
       0,     0,     0,   229,    49,  1259,   230,   588,     0,     0,
    1260,  1261,    52,    53,  1262,    54,     0,     0,     0,     0,
    1263,  1264,   619,    81,    82,    83,   372,    85,    86,  1266,
      87,    88,    89,   373,     0,   374,     0,    93,     0,    95,
      96,    97,    98,    99,   100,   620,   101,   102,   103,   375,
     621,     0,   105,   106,   107,   108,   622,   623,     0,   110,
     111,   112,     0,   113,   624,   625,   116,   376,   377,     0,
       0,     0,   378,   379,     0,     0,     0,     0,   380,     0,
       0,     0,     0,     0,     0,     0,     0,   381,     0,   382,
       0,   383,   384,     0,   385,   386,   387,   388,   389,   390,
     391,   392,     0,   393,   394,     0,     0,     0,     0,  1208,
       0,     0,   395,   396,     0,   397,   131,   398,   399,   400,
     133,  1209,   135,  1210,  1211,     0,   401,   402,     0,   403,
     404,  1212,  1213,   405,  1214,  1215,   407,     0,   408,   409,
     410,   411,  1216,     0,     0,   412,   413,   414,   415,   416,
       0,   417,   418,  1217,   419,     0,   420,   421,   422,   147,
     423,  1218,  1219,  1220,  1221,  1222,   424,   425,   426,   427,
     428,  1223,  1224,   429,     0,   430,     0,   431,     0,   432,
     433,   434,     0,   435,     0,     0,   436,  1225,   438,   439,
       0,   440,   441,   442,     0,   443,     0,   444,   445,   446,
    1226,   447,     0,  1227,  1228,   448,   449,  1229,     0,   450,
       0,   451,   162,     0,   163,   452,     0,   453,     0,   454,
    1230,     0,   455,     0,   456,   457,   458,   459,   167,   460,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
     168,   169,     0,   469,   470,   471,  1231,  1232,     0,  1233,
       0,     0,   173,   174,   472,   175,   473,   474,   475,   476,
     477,     0,  1234,   177,   478,   178,     0,   479,   480,   481,
    1235,  1236,   482,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,  1237,   184,  1238,   749,   493,   494,   495,
     496,   497,   498,   499,   186,   500,  1239,   501,   502,   188,
     503,  1240,  1241,  1242,   504,   505,     0,     0,   506,   750,
       0,     0,  1243,   508,     0,     0,   191,   192,   193,  1244,
     509,   510,   511,   512,     0,  1245,   196,   513,   514,   515,
       0,   516,   517,   518,   519,   520,   521,  1246,   522,   523,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
       0,   533,   534,   204,   535,   536,  1247,   537,   538,   539,
     540,   541,   542,     0,     0,   543,   544,   545,  1248,   546,
     210,   547,   548,   212,   549,  1249,     0,   550,   551,   552,
     553,   554,   555,   556,   557,  1250,   558,     0,   559,   560,
       0,   561,   562,   563,   564,     0,  1251,  1252,     0,     0,
     566,  1253,   567,  1254,  1255,   568,   569,   570,   571,   572,
       0,  1256,   573,   574,   575,   576,  1257,     0,   577,   578,
       0,   579,  1258,   580,   228,   581,     0,     0,     0,   582,
     583,   584,   585,   586,   587,     0,     0,     0,   229,    49,
    1259,   230,   588,     0,     0,  1260,  1261,    52,    53,  1262,
      54,     0,     0,     0,     0,  1263,  1264,     0,     0,     0,
       0,     0,  1689,     0,  1266,   619,    81,    82,    83,   372,
      85,    86,     0,    87,    88,    89,   373,     0,   374,     0,
      93,     0,    95,    96,    97,    98,    99,   100,   620,   101,
     102,   103,   375,   621,     0,   105,   106,   107,   108,   622,
     623,     0,   110,   111,   112,     0,   113,   624,   625,   116,
     376,   377,     0,     0,     0,   378,   379,     0,     0,     0,
       0,   380,     0,     0,     0,     0,     0,     0,     0,     0,
     381,     0,   382,     0,   383,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,     0,   393,   394,     0,     0,
       0,     0,  1208,     0,     0,   395,   396,     0,   397,   131,
     398,   399,   400,   133,  1209,   135,  1210,  1211,     0,   401,
     402,     0,   403,   404,  1212,  1213,   405,  1214,  1215,   407,
       0,   408,   409,   410,   411,  1216,     0,     0,   412,   413,
     414,   415,   416,     0,   417,   418,  1217,   419,     0,   420,
     421,   422,   147,   423,  1218,  1219,  1220,  1221,  1222,   424,
     425,   426,   427,   428,  1223,  1224,   429,     0,   430,     0,
     431,     0,   432,   433,   434,     0,   435,     0,     0,   436,
    1225,   438,   439,     0,   440,   441,   442,     0,   443,     0,
     444,   445,   446,  1226,   447,     0,  1227,  1228,   448,   449,
    1229,     0,   450,     0,   451,   162,  2263,   163,   452,     0,
     453,     0,   454,  1230,     0,   455,     0,   456,   457,   458,
     459,   167,   460,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,   168,   169,     0,   469,   470,   471,  1231,
    1232,     0,  1233,     0,     0,   173,   174,   472,   175,   473,
     474,   475,   476,   477,     0,  1234,   177,   478,   178,     0,
     479,   480,   481,  1235,  1236,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,  1237,   184,  1238,   749,
     493,   494,   495,   496,   497,   498,   499,   186,   500,  1239,
     501,   502,   188,   503,  1240,  1241,  1242,   504,   505,     0,
       0,   506,   750,     0,     0,  1243,   508,     0,     0,   191,
     192,   193,  1244,   509,   510,   511,   512,     0,  1245,   196,
     513,   514,   515,     0,   516,   517,   518,   519,   520,   521,
    1246,   522,   523,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,     0,   533,   534,   204,   535,   536,  1247,
     537,   538,   539,   540,   541,   542,     0,     0,   543,   544,
     545,  1248,   546,   210,   547,   548,   212,   549,  1249,     0,
     550,   551,   552,   553,   554,   555,   556,   557,  1250,   558,
       0,   559,   560,     0,   561,   562,   563,   564,     0,  1251,
    1252,     0,     0,   566,  1253,   567,  1254,  1255,   568,   569,
     570,   571,   572,     0,  1256,   573,   574,   575,   576,  1257,
       0,   577,   578,     0,   579,  1258,   580,   228,   581,     0,
       0,     0,   582,   583,   584,   585,   586,   587,     0,     0,
       0,   229,    49,  1259,   230,   588,     0,     0,  1260,  1261,
      52,    53,  1262,    54,     0,     0,     0,     0,  1263,  1264,
     619,    81,    82,    83,   372,    85,    86,  1266,    87,    88,
      89,   373,     0,   374,     0,    93,     0,    95,    96,    97,
      98,    99,   100,   620,   101,   102,   103,   375,   621,     0,
     105,   106,   107,   108,   622,   623,     0,   110,   111,   112,
       0,   113,   624,   625,   116,   376,   377,     0,     0,     0,
     378,   379,     0,     0,     0,     0,   380,     0,     0,     0,
       0,     0,     0,     0,     0,   381,     0,   382,     0,   383,
     384,     0,   385,   386,   387,   388,   389,   390,   391,   392,
       0,   393,   394,     0,     0,     0,     0,  1208,     0,     0,
     395,   396,     0,   397,   131,   398,   399,   400,   133,  1209,
     135,  1210,  1211,     0,   401,   402,     0,   403,   404,  1212,
    1213,   405,  1214,  1215,   407,     0,   408,   409,   410,   411,
    1216,     0,     0,   412,   413,   414,   415,   416,     0,   417,
     418,  1217,   419,     0,   420,   421,   422,   147,   423,  1218,
    1219,  1220,  1221,  1222,   424,   425,   426,   427,   428,  1223,
    1224,   429,     0,   430,     0,   431,     0,   432,   433,   434,
       0,   435,     0,     0,   436,  1225,   438,   439,     0,   440,
     441,   442,     0,   443,     0,   444,   445,   446,  1226,   447,
       0,  1227,  1228,   448,   449,  1229,     0,   450,     0,   451,
     162,     0,   163,   452,     0,   453,     0,   454,  1230,     0,
     455,     0,   456,   457,   458,   459,   167,   460,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,   168,   169,
       0,   469,   470,   471,  1231,  1232,     0,  1233,     0,     0,
     173,   174,   472,   175,   473,   474,   475,   476,   477,     0,
    1234,   177,   478,   178,     0,   479,   480,   481,  1235,  1236,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,  1237,   184,  1238,   749,   493,   494,   495,   496,   497,
     498,   499,   186,   500,  1239,   501,   502,   188,   503,  1240,
    1241,  1242,   504,   505,     0,     0,   506,   750,     0,     0,
    1243,   508,     0,     0,   191,   192,   193,  1244,   509,   510,
     511,   512,     0,  1245,   196,   513,   514,   515,     0,   516,
     517,   518,   519,   520,   521,  1246,   522,   523,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,     0,   533,
     534,   204,   535,   536,  1247,   537,   538,   539,   540,   541,
     542,     0,     0,   543,   544,   545,  1248,   546,   210,   547,
     548,   212,   549,  1249,     0,   550,   551,   552,   553,   554,
     555,   556,   557,  1250,   558,     0,   559,   560,     0,   561,
     562,   563,   564,     0,  1251,  1252,     0,     0,   566,  1253,
     567,  1254,  1255,   568,   569,   570,   571,   572,     0,  1256,
     573,   574,   575,   576,  1257,     0,   577,   578,     0,   579,
    1258,   580,   228,   581,     0,     0,     0,   582,   583,   584,
     585,   586,   587,     0,     0,     0,   229,    49,  1259,   230,
     588,     0,     0,  1260,  1261,    52,    53,  1262,    54,     0,
       0,     0,     0,  1263,  1264,   619,    81,    82,    83,   372,
      85,    86,  1266,    87,    88,    89,   373,     0,   374,     0,
      93,     0,    95,    96,    97,    98,    99,   100,   620,   101,
     102,   103,   375,   621,     0,   105,   106,   107,   108,   622,
     623,     0,   110,   111,   112,     0,   113,   624,   625,   116,
     376,   377,     0,     0,     0,   378,   379,     0,     0,     0,
       0,   380,     0,     0,     0,     0,     0,     0,     0,     0,
     381,     0,   382,     0,   383,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,     0,   393,   394,     0,     0,
       0,     0,  1208,     0,     0,   395,   396,     0,   397,   131,
     398,   399,   400,   133,  1209,   135,  1210,  1211,     0,   401,
     402,     0,   403,   404,  1212,  1213,   405,  1214,  1215,   407,
       0,   408,   409,   410,   411,  1216,     0,     0,   412,   413,
     414,   415,   416,     0,   417,   418,  1217,   419,     0,   420,
     421,   422,   147,   423,  1218,  1219,  1220,  1221,  1222,   424,
     425,   426,   427,   428,  1223,  1224,   429,     0,   430,     0,
     431,     0,   432,   433,   434,     0,   435,     0,     0,   436,
    1225,   438,   439,     0,   440,   441,   442,     0,   443,     0,
     444,   445,   446,  1226,   447,     0,  1227,  1228,   448,   449,
    1229,     0,   450,     0,   451,   162,     0,   163,   452,     0,
     453,     0,   454,  1230,     0,   455,     0,   456,   457,   458,
     459,   167,   460,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,   168,   169,     0,   469,   470,   471,  1231,
    1232,     0,  1233,     0,     0,   173,   174,   472,   175,   473,
     474,   475,   476,   477,     0,  1234,   177,   478,   178,     0,
     479,   480,   481,  1235,  1236,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,  1237,   184,  1238,   749,
     493,   494,   495,   496,   497,   498,   499,   186,   500,     0,
     501,   502,   188,   503,  1240,  1241,  1242,   504,   505,     0,
       0,   506,   750,     0,     0,  1243,   508,     0,     0,   191,
     192,   193,  1244,   509,   510,   511,   512,     0,  1245,   196,
     513,   514,   515,     0,   516,   517,   518,   519,   520,   521,
    1246,   522,   523,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,     0,   533,   534,   204,   535,   536,  1247,
     537,   538,   539,   540,   541,   542,     0,     0,   543,   544,
     545,  1248,   546,   210,   547,   548,   212,   549,  1249,     0,
     550,   551,   552,   553,   554,   555,   556,   557,  1250,   558,
       0,   559,   560,     0,   561,   562,   563,   564,     0,  1251,
    1252,     0,     0,   566,  1253,   567,  1254,  1255,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,   576,  1257,
       0,   577,   578,     0,   579,  1258,   580,   228,   581,     0,
       0,     0,   582,   583,   584,   585,   586,   587,     0,     0,
       0,   229,    49,  1259,   230,   588,     0,     0,  1260,  1261,
      52,    53,  1262,    54,     0,     0,     0,     0,     0,  2246,
     619,    81,    82,    83,   372,    85,    86,  1266,    87,    88,
      89,   373,     0,   374,     0,    93,     0,    95,    96,    97,
      98,    99,   100,   620,   101,   102,   103,   375,   621,     0,
     105,   106,   107,   108,   622,   623,     0,   110,   111,   112,
       0,   113,   624,   625,   116,   376,   377,     0,     0,     0,
     378,   379,     0,     0,     0,     0,   380,     0,     0,     0,
       0,     0,     0,     0,     0,   381,     0,   382,     0,   383,
     384,     0,   385,   386,   387,   388,   389,   390,   391,   392,
       0,   393,   394,     0,     0,     0,     0,  1208,     0,     0,
     395,   396,     0,   397,   131,   398,   399,   400,     0,  1209,
     135,  1210,  1211,     0,   401,   402,     0,   403,   404,  1212,
    1213,   405,  1214,  1215,   407,     0,   408,   409,   410,   411,
    1216,     0,     0,   412,   413,   414,   415,   416,     0,   417,
     418,  1217,   419,     0,   420,   421,   422,   147,   423,  1218,
    1219,  1220,  1221,  1222,   424,   425,   426,   427,   428,  1223,
    1224,   429,     0,   430,     0,   431,     0,   432,   433,   434,
       0,   435,     0,     0,   436,  1225,   438,   439,     0,   440,
     441,   442,     0,     0,     0,   444,   445,   446,  1226,   447,
       0,  1227,  1228,   448,   449,  1229,     0,   450,     0,   451,
     162,     0,   163,   452,     0,   453,     0,   454,  1230,     0,
     455,     0,   456,   457,   458,   459,     0,   460,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,   168,   169,
       0,   469,   470,   471,  1231,  1232,     0,  1233,     0,     0,
     173,   174,   472,   175,   473,   474,   475,   476,   477,     0,
    1234,   177,   478,     0,     0,   479,   480,   481,  1235,  1236,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,  1237,   184,  1238,   749,   493,   494,   495,   496,   497,
     498,   499,   186,   500,     0,   501,   502,   188,   503,  1240,
    1241,  1242,   504,   505,     0,     0,   506,   750,     0,     0,
    1243,   508,     0,     0,   191,   192,   193,  1244,   509,   510,
     511,   512,     0,  1245,   196,   513,   514,   515,     0,   516,
     517,   518,   519,   520,   521,  1246,   522,   523,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,     0,   533,
     534,   204,   535,   536,  1247,   537,   538,   539,   540,   541,
     542,     0,     0,   543,   544,   545,  1248,   546,   210,   547,
     548,     0,   549,  1249,     0,   550,   551,   552,   553,   554,
     555,   556,   557,  1250,   558,     0,   559,   560,     0,   561,
     562,   563,   564,     0,  1251,  1252,     0,     0,   566,  1253,
     567,  1254,  1255,   568,   569,   570,   571,   572,     0,  1256,
     573,   574,   575,   576,  1257,     0,   577,   578,     0,   579,
    1258,   580,   228,   581,     0,     0,     0,   582,   583,   584,
     585,   586,   587,     0,     0,     0,   229,    49,  1259,   230,
     588,     0,     0,  1260,  1261,    52,    53,  1262,    54,     0,
       0,     0,     0,  1263,  1264,   619,    81,    82,    83,   372,
      85,    86,  1266,    87,    88,    89,   373,     0,   374,     0,
      93,     0,    95,    96,    97,    98,    99,   100,   620,   101,
     102,   103,   375,   621,     0,   105,   106,   107,   108,   622,
     623,     0,   110,   111,   112,     0,   113,   624,   625,   116,
     376,   377,     0,     0,     0,   378,   379,     0,     0,     0,
       0,   380,     0,     0,     0,     0,     0,     0,     0,     0,
     381,     0,   382,     0,   383,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,     0,   393,   394,     0,     0,
       0,     0,  1208,     0,     0,   395,   396,     0,   397,   131,
     398,   399,   400,     0,  1209,   135,  1210,  1211,     0,   401,
     402,     0,   403,   404,  1212,  1213,   405,  1214,  1215,   407,
       0,   408,   409,   410,   411,  1216,     0,     0,   412,   413,
     414,   415,   416,     0,   417,   418,  1217,   419,     0,   420,
     421,   422,   147,   423,  1218,  1219,  1220,  1221,  1222,   424,
     425,   426,   427,   428,  1223,  1224,   429,     0,   430,     0,
     431,     0,   432,   433,   434,     0,   435,     0,     0,   436,
    1225,   438,   439,     0,   440,   441,   442,     0,     0,     0,
     444,   445,   446,  1226,   447,     0,  1227,  1228,   448,   449,
    1229,     0,   450,     0,   451,   162,     0,   163,   452,     0,
     453,     0,   454,  1230,     0,   455,     0,   456,   457,   458,
     459,     0,   460,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,   168,   169,     0,   469,   470,   471,  1231,
    1232,     0,  1233,     0,     0,   173,   174,   472,   175,   473,
     474,   475,   476,   477,     0,  1234,   177,   478,     0,     0,
     479,   480,   481,  1235,  1236,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,  1237,   184,  1238,   749,
     493,   494,   495,   496,   497,   498,   499,   186,   500,     0,
     501,   502,   188,   503,  1240,  1241,  1242,   504,   505,     0,
       0,   506,   750,     0,     0,     0,   508,     0,     0,   191,
     192,   193,  1244,   509,   510,   511,   512,     0,  1245,   196,
     513,   514,   515,     0,   516,   517,   518,   519,   520,   521,
    1246,   522,   523,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,     0,   533,   534,   204,   535,   536,  1247,
     537,   538,   539,   540,   541,   542,     0,     0,   543,   544,
     545,  1248,   546,   210,   547,   548,     0,   549,  1249,     0,
     550,   551,   552,   553,   554,   555,   556,   557,  1250,   558,
       0,   559,   560,     0,   561,   562,   563,   564,     0,  1251,
    1252,     0,     0,   566,  1253,   567,  1254,  1255,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,   576,  1257,
       0,   577,   578,     0,   579,  1258,   580,   228,   581,     0,
       0,     0,   582,   583,   584,   585,   586,   587,     0,     0,
       0,   229,    49,     0,   230,   588,     0,     0,  1260,  1261,
      52,    53,  1262,    54,     0,     0,     0,     0,     0,  2246,
       0,    81,    82,    83,   372,    85,    86,  1266,    87,    88,
      89,   373,     0,   374,     0,    93,     0,    95,    96,    97,
      98,    99,   100,     0,   101,   102,   103,   375,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   116,   376,   377,     0,     0,     0,
     378,   379,     0,     0,     0,     0,   380,     0,     0,     0,
       0,     0,     0,     0,     0,   381,     0,   382,     0,   383,
     384,     0,   385,   386,   387,   388,   389,   390,   391,   392,
       0,   393,   394,     0,     0,     0,     0,     0,  2586,     0,
     395,   396,     0,   397,     0,   398,   399,   400,     0,   134,
       0,   136,     0,     0,   401,   402,     0,   403,   404,     0,
       0,   405,   406,   137,   407,     0,   408,   409,   410,   411,
     141,     0,     0,   412,   413,   414,   415,   416,     0,   417,
     418,   144,   419,     0,   420,   421,   422,  -957,   423,     0,
       0,     0,     0,     0,   424,   425,   426,   427,   428,   150,
     151,   429,     0,   430,     0,   431,     0,   432,   433,   434,
       0,   435,     0,     0,   436,   437,   438,   439,     0,   440,
     441,   442,     0,   443,     0,   444,   445,   446,   157,   447,
       0,   159,     0,   448,   449,   161,     0,   450,     0,   451,
       0,     0,  -957,   452,     0,   453,     0,   454,   166,     0,
     455,     0,   456,   457,   458,   459,     0,   460,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,  -957,   169,
       0,   469,   470,   471,     0,   171,     0,   172,     0,     0,
       0,     0,   472,  -957,   473,   474,   475,   476,   477,     0,
     176,  -957,   478,     0,     0,   479,   480,   481,     0,     0,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   183,  -957,   185,     0,   493,   494,   495,   496,   497,
     498,   499,   186,   500,     0,   501,   502,     0,   503,     0,
     189,   190,   504,   505,     0,     0,   506,     0,     0,     0,
     507,   508,     0,     0,   191,     0,     0,   194,   509,   510,
     511,   512,     0,   195,   196,   513,   514,   515,     0,   516,
     517,   518,   519,   520,   521,   198,   522,   523,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,     0,   533,
     534,  -957,   535,   536,   206,   537,   538,   539,   540,   541,
     542,     0,     0,   543,   544,   545,     0,   546,   210,   547,
     548,     0,   549,   213,     0,   550,   551,   552,   553,   554,
     555,   556,   557,   215,   558,     0,   559,   560,     0,   561,
     562,   563,   564,     0,   216,   217,     0,     0,   566,   218,
     567,   219,     0,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,   576,     0,     0,   577,   578,     0,   579,
     227,   580,     0,   581,     0,     0,     0,   582,   583,   584,
     585,   586,   587,     0,     0,     0,   229,     0,     0,   230,
       0,    81,    82,    83,   372,    85,    86,     0,    87,    88,
      89,   373,     0,   374,     0,    93,     0,    95,    96,    97,
      98,    99,   100,  1350,   101,   102,   103,   375,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   116,   376,   377,     0,     0,     0,
     378,   379,     0,     0,     0,     0,   380,     0,     0,     0,
       0,     0,     0,     0,     0,   381,     0,   382,     0,   383,
     384,     0,   385,   386,   387,   388,   389,   390,   391,   392,
       0,   393,   394,     0,     0,     0,     0,     0,     0,     0,
     395,   396,     0,   397,   131,   398,   399,   400,   133,   134,
     135,   136,     0,     0,   401,   402,     0,   403,   404,     0,
    1213,   405,   406,   137,   407,     0,   408,   409,   410,   411,
    1216,     0,     0,   412,   413,   414,   415,   416,     0,   417,
     418,  1217,   419,     0,   420,   421,   422,   147,   423,  1218,
    1219,  1220,  1221,  1222,   424,   425,   426,   427,   428,   150,
     151,   429,     0,   430,     0,   431,     0,   432,   433,   434,
       0,   435,     0,     0,   436,   437,   438,   439,     0,   440,
     441,   442,     0,   443,     0,   444,   445,   446,   157,   447,
       0,  1227,     0,   448,   449,   161,     0,   450,     0,   451,
     162,     0,   163,   452,     0,   453,     0,   454,  1230,     0,
     455,     0,   456,   457,   458,   459,   167,   460,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,   168,   169,
       0,   469,   470,   471,     0,   171,     0,   172,     0,     0,
     173,   174,   472,   175,   473,   474,   475,   476,   477,     0,
    1234,   177,   478,   178,     0,   479,   480,   481,  1235,  1236,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   183,   184,   185,   749,   493,   494,   495,   496,   497,
     498,   499,   186,   500,     0,   501,   502,   188,   503,     0,
    1241,   190,   504,   505,     0,     0,   506,   750,     0,   927,
     507,   508,     0,     0,   191,   192,   193,  1244,   509,   510,
     511,   512,     0,  1245,   196,   513,   514,   515,     0,   516,
     517,   518,   519,   520,   521,   198,   522,   523,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,     0,   533,
     534,   204,   535,   536,   206,   537,   538,   539,   540,   541,
     542,     0,   208,   543,   544,   545,  1248,   546,   210,   547,
     548,   212,   549,   213,     0,   550,   551,   552,   553,   554,
     555,   556,   557,  1250,   558,     0,   559,   560,     0,   561,
     562,   563,   564,     0,   216,   217,     0,     0,   566,  1253,
     567,  1254,     0,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,   576,  1257,     0,   577,   578,     0,  1739,
     227,   580,   228,   581,     0,     0,     0,   582,   583,   584,
     585,   586,   587,     0,     0,     0,   229,     0,     0,   230,
      81,    82,    83,   372,    85,    86,     0,    87,    88,    89,
     373,     0,   374,     0,    93,     0,    95,    96,    97,    98,
      99,   100,  2128,   101,   102,   103,   375,     0,     0,   105,
     106,   107,   108,     0,     0,     0,   110,   111,   112,     0,
     113,     0,     0,   116,   376,   377,     0,     0,     0,   378,
     379,     0,     0,     0,     0,   380,     0,     0,     0,     0,
       0,     0,     0,     0,   381,     0,   382,     0,   383,   384,
       0,   385,   386,   387,   388,   389,   390,   391,   392,     0,
     393,   394,     0,     0,     0,     0,     0,     0,     0,   395,
     396,     0,   397,   131,   398,   399,   400,   133,   134,   135,
     136,     0,     0,   401,   402,     0,   403,   404,     0,  1213,
     405,   406,   137,   407,     0,   408,   409,   410,   411,  1216,
       0,     0,   412,   413,   414,   415,   416,     0,   417,   418,
    1217,   419,     0,   420,   421,   422,   147,   423,  1218,  1219,
    1220,  1221,  1222,   424,   425,   426,   427,   428,   150,   151,
     429,     0,   430,     0,   431,     0,   432,   433,   434,     0,
     435,     0,     0,   436,   437,   438,   439,     0,   440,   441,
     442,     0,   443,     0,   444,   445,   446,   157,   447,     0,
    1227,     0,   448,   449,   161,     0,   450,     0,   451,   162,
       0,   163,   452,     0,   453,     0,   454,  1230,     0,   455,
       0,   456,   457,   458,   459,   167,   460,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,   168,   169,     0,
     469,   470,   471,     0,   171,     0,   172,     0,     0,   173,
     174,   472,   175,   473,   474,   475,   476,   477,     0,  1234,
     177,   478,   178,     0,   479,   480,   481,  1235,  1236,   482,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     183,   184,   185,   749,   493,   494,   495,   496,   497,   498,
     499,   186,   500,     0,   501,   502,   188,   503,     0,  1241,
     190,   504,   505,     0,     0,   506,   750,     0,   927,   507,
     508,     0,     0,   191,   192,   193,  1244,   509,   510,   511,
     512,     0,  1245,   196,   513,   514,   515,     0,   516,   517,
     518,   519,   520,   521,   198,   522,   523,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,     0,   533,   534,
     204,   535,   536,   206,   537,   538,   539,   540,   541,   542,
       0,     0,   543,   544,   545,  1248,   546,   210,   547,   548,
     212,   549,   213,     0,   550,   551,   552,   553,   554,   555,
     556,   557,  1250,   558,     0,   559,   560,     0,   561,   562,
     563,   564,     0,   216,   217,     0,     0,   566,  1253,   567,
    1254,     0,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,   576,  1257,     0,   577,   578,     0,   579,   227,
     580,   228,   581,     0,     0,     0,   582,   583,   584,   585,
     586,   587,     0,     0,     0,   229,     0,     0,   230,    81,
      82,    83,   372,    85,    86,     0,    87,    88,    89,   373,
       0,   374,     0,    93,     0,    95,    96,    97,    98,    99,
     100,  2128,   101,   102,   103,   375,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   116,   376,   377,     0,     0,     0,   378,   379,
       0,     0,     0,     0,   380,     0,     0,     0,     0,     0,
       0,     0,     0,   381,     0,   382,     0,   383,   384,     0,
     385,   386,   387,   388,   389,   390,   391,   392,     0,   393,
     394,     0,     0,     0,     0,     0,     0,     0,   395,   396,
       0,   397,   131,   398,   399,   400,   133,   134,   135,   136,
       0,     0,   401,   402,     0,   403,   404,     0,  1213,   405,
     406,   137,   407,     0,   408,   409,   410,   411,  1216,     0,
       0,   412,   413,   414,   415,   416,     0,   417,   418,  1217,
     419,     0,   420,   421,   422,   147,   423,  1218,  1219,  1220,
    1221,  1222,   424,   425,   426,   427,   428,   150,   151,   429,
       0,   430,     0,   431,     0,   432,   433,   434,     0,   435,
       0,     0,   436,   437,   438,   439,     0,   440,   441,   442,
       0,   443,     0,   444,   445,   446,   157,   447,     0,  1227,
       0,   448,   449,   161,     0,   450,     0,   451,   162,     0,
     163,   452,     0,   453,     0,   454,  1230,     0,   455,     0,
     456,   457,   458,   459,   167,   460,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,   168,   169,     0,   469,
     470,   471,     0,   171,     0,   172,     0,     0,   173,   174,
     472,   175,   473,   474,   475,   476,   477,     0,  1234,   177,
     478,   178,     0,   479,   480,   481,  1235,  1236,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   183,
     184,   185,   749,   493,   494,   495,   496,   497,   498,   499,
     186,   500,     0,   501,   502,   188,   503,     0,  1241,   190,
     504,   505,     0,     0,   506,   750,     0,     0,   507,   508,
       0,     0,   191,   192,   193,  1244,   509,   510,   511,   512,
       0,  1245,   196,   513,   514,   515,     0,   516,   517,   518,
     519,   520,   521,   198,   522,   523,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,     0,   533,   534,   204,
     535,   536,   206,   537,   538,   539,   540,   541,   542,     0,
       0,   543,   544,   545,  1248,   546,   210,   547,   548,   212,
     549,   213,     0,   550,   551,   552,   553,   554,   555,   556,
     557,  1250,   558,     0,   559,   560,     0,   561,   562,   563,
     564,     0,   216,   217,     0,     0,   566,  1253,   567,  1254,
       0,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,   576,  1257,     0,   577,   578,     0,   579,   227,   580,
     228,   581,     0,     0,     0,   582,   583,   584,   585,   586,
     587,     0,     0,     0,   229,     0,     0,   230,    81,    82,
      83,   372,    85,    86,     0,    87,    88,    89,   373,     0,
     374,     0,    93,     0,    95,    96,    97,    98,    99,   100,
    3332,   101,   102,   103,   375,     0,     0,   105,   106,   107,
     108,     0,     0,     0,   110,   111,   112,     0,   113,     0,
       0,   116,   376,   377,     0,     0,     0,   378,   379,     0,
       0,     0,     0,   380,     0,     0,     0,     0,     0,     0,
       0,     0,   381,     0,   382,     0,   383,   384,     0,   385,
     386,   387,   388,   389,   390,   391,   392,     0,   393,   394,
       0,     0,     0,     0,     0,     0,     0,   395,   396,     0,
     397,     0,   398,   399,   400,     0,   134,     0,   136,     0,
       0,   401,   402,     0,   403,   404,     0,     0,   405,   406,
     137,   407,     0,   408,   409,   410,   411,   141,     0,     0,
     412,   413,   414,   415,   416,     0,   417,   418,   144,   419,
       0,   420,   421,   422,     0,   423,     0,     0,     0,     0,
       0,   424,   425,   426,   427,   428,   150,   151,   429,     0,
     430,     0,   431,     0,   432,   433,   434,     0,   435,     0,
       0,   436,   437,   438,   439,     0,   440,   441,   442,     0,
     443,     0,   444,   445,   446,   157,   447,     0,   159,     0,
     448,   449,   161,     0,   450,     0,   451,     0,     0,     0,
     452,     0,   453,     0,   454,   166,     0,   455,     0,   456,
     457,   458,   459,     0,   460,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   169,     0,   469,   470,
     471,     0,   171,     0,   172,     0,     0,     0,     0,   472,
       0,   473,   474,   475,   476,   477,     0,   176,     0,   478,
       0,     0,   479,   480,   481,     0,     0,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   183,     0,
     185,     0,   493,   494,   495,   496,   497,   498,   499,   186,
     500,     0,   501,   502,     0,   503,     0,   189,   190,   504,
     505,     0,     0,   506,     0,     0,     0,   507,   508,     0,
       0,   191,     0,     0,   194,   509,   510,   511,   512,     0,
     195,   196,   513,   514,   515,     0,   516,   517,   518,   519,
     520,   521,   198,   522,   523,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,     0,   533,   534,     0,   535,
     536,   206,   537,   538,   539,   540,   541,   542,     0,     0,
     543,   544,   545,     0,   546,   210,   547,   548,     0,   549,
     213,     0,   550,   551,   552,   553,   554,   555,   556,   557,
     215,   558,     0,   559,   560,     0,   561,   562,   563,   564,
       0,   216,   217,     0,     0,   566,   218,   567,   219,     0,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
     576,     0,     0,   577,   578,     0,   579,   227,   580,     0,
     581,     0,     0,     0,   582,   583,   584,   585,   586,   587,
       0,     0,     0,   229,    49,     0,   230,   588,     0,     0,
       0,     0,    52,    53,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2516,  2517,
      81,    82,    83,   372,    85,    86,     0,    87,    88,    89,
     373,     0,   374,     0,    93,     0,    95,    96,    97,    98,
      99,   100,     0,   101,   102,   103,   375,     0,     0,   105,
     106,   107,   108,     0,     0,     0,   110,   111,   112,     0,
     113,     0,     0,   116,   376,   377,     0,     0,     0,   378,
     379,     0,     0,     0,     0,   380,     0,     0,     0,     0,
       0,     0,     0,     0,   381,     0,   382,     0,   383,   384,
       0,   385,   386,   387,   388,   389,   390,   391,   392,     0,
     393,   394,     0,     0,     0,     0,     0,     0,     0,   395,
     396,     0,   397,     0,   398,   399,   400,     0,   134,     0,
     136,     0,     0,   401,   402,     0,   403,   404,     0,     0,
     405,   406,   137,   407,     0,   408,   409,   410,   411,   141,
       0,     0,   412,   413,   414,   415,   416,     0,   417,   418,
     144,   419,     0,   420,   421,   422,     0,   423,     0,     0,
       0,     0,     0,   424,   425,   426,   427,   428,   150,   151,
     429,     0,   430,     0,   431,     0,   432,   433,   434,     0,
     435,     0,     0,   436,   437,   438,   439,     0,   440,   441,
     442,     0,   443,     0,   444,   445,   446,   157,   447,     0,
     159,     0,   448,   449,   161,     0,   450,     0,   451,     0,
       0,     0,   452,     0,   453,     0,   454,   166,     0,   455,
       0,   456,   457,   458,   459,     0,   460,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   169,     0,
     469,   470,   471,     0,   171,     0,   172,     0,     0,     0,
       0,   472,     0,   473,   474,   475,   476,   477,     0,   176,
       0,   478,     0,     0,   479,   480,   481,     0,     0,   482,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     183,     0,   185,     0,   493,   494,   495,   496,   497,   498,
     499,   186,   500,     0,   501,   502,     0,   503,     0,   189,
     190,   504,   505,     0,     0,   506,     0,     0,     0,   507,
     508,     0,     0,   191,     0,     0,   194,   509,   510,   511,
     512,     0,   195,   196,   513,   514,   515,     0,   516,   517,
     518,   519,   520,   521,   198,   522,   523,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,     0,   533,   534,
       0,   535,   536,   206,   537,   538,   539,   540,   541,   542,
       0,     0,   543,   544,   545,     0,   546,   210,   547,   548,
       0,   549,   213,     0,   550,   551,   552,   553,   554,   555,
     556,   557,   215,   558,     0,   559,   560,     0,   561,   562,
     563,   564,     0,   216,   217,     0,     0,   566,   218,   567,
     219,     0,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,   576,     0,     0,   577,   578,     0,   579,   227,
     580,     0,   581,     0,     0,     0,   582,   583,   584,   585,
     586,   587,     0,     0,     0,   229,    49,     0,   230,   588,
       0,     0,     0,     0,    52,    53,    81,    82,    83,   372,
      85,    86,     0,    87,    88,    89,   373,     0,   374,     0,
      93,  2517,    95,    96,    97,    98,    99,   100,     0,   101,
     102,   103,   375,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   116,
     376,   377,     0,     0,     0,   378,   379,     0,     0,     0,
       0,   380,     0,     0,     0,     0,     0,     0,     0,     0,
     381,     0,   382,     0,   383,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,     0,   393,   394,     0,     0,
       0,     0,     0,     0,     0,   395,   396,     0,   397,     0,
     398,   399,   400,     0,   134,     0,   136,     0,     0,   401,
     402,     0,   403,   404,     0,     0,   405,   406,   137,   407,
       0,   408,   409,   410,   411,   141,     0,     0,   412,   413,
     414,   415,   416,     0,   417,   418,   144,   419,     0,   420,
     421,   422,     0,   423,     0,     0,     0,     0,     0,   424,
     425,   426,   427,   428,   150,   151,   429,     0,   430,     0,
     431,     0,   432,   433,   434,     0,   435,     0,     0,   436,
     437,   438,   439,     0,   440,   441,   442,     0,   443,     0,
     444,   445,   446,   157,   447,     0,   159,     0,   448,   449,
     161,     0,   450,     0,   451,     0,     0,     0,   452,     0,
     453,     0,   454,   166,     0,   455,     0,   456,   457,   458,
     459,     0,   460,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   169,     0,   469,   470,   471,     0,
     171,     0,   172,     0,     0,     0,     0,   472,     0,   473,
     474,   475,   476,   477,     0,   176,     0,   478,     0,     0,
     479,   480,   481,     0,     0,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   183,     0,   185,   749,
     493,   494,   495,   496,   497,   498,   499,   186,   500,     0,
     501,   502,     0,   503,     0,   189,   190,   504,   505,     0,
       0,   506,   750,     0,     0,   507,   508,     0,     0,   191,
       0,     0,   194,   509,   510,   511,   512,     0,   195,   196,
     513,   514,   515,     0,   516,   517,   518,   519,   520,   521,
     198,   522,   523,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,     0,   533,   534,     0,   535,   536,   206,
     537,   538,   539,   540,   541,   542,     0,     0,   543,   544,
     545,     0,   546,   210,   547,   548,     0,   549,   213,     0,
     550,   551,   552,   553,   554,   555,   556,   557,   215,   558,
       0,   559,   560,     0,   561,   562,   563,   564,     0,   216,
     217,     0,     0,   566,   218,   567,   219,     0,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,   576,     0,
       0,   577,   578,     0,   579,   227,   580,     0,   581,     0,
       0,     0,   582,   583,   584,   585,   586,   587,     0,     0,
       0,   229,     0,     0,   230,    81,    82,    83,   372,    85,
      86,     0,    87,    88,    89,   373,     0,   374,     0,    93,
       0,    95,    96,    97,    98,    99,   100,  1338,   101,   102,
     103,   375,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   116,   376,
     377,     0,     0,     0,   378,   379,     0,     0,     0,     0,
     380,     0,     0,     0,     0,     0,     0,     0,     0,   381,
       0,   382,     0,   383,   384,     0,   385,   386,   387,   388,
     389,   390,   391,   392,     0,   393,   394,     0,     0,     0,
       0,     0,     0,     0,   395,   396,     0,   397,     0,   398,
     399,   400,     0,   134,     0,   136,     0,     0,   401,   402,
       0,   403,   404,     0,     0,   405,   406,   137,   407,     0,
     408,   409,   410,   411,   141,     0,     0,   412,   413,   414,
     415,   416,     0,   417,   418,   144,   419,     0,   420,   421,
     422,     0,   423,     0,     0,     0,     0,     0,   424,   425,
     426,   427,   428,   150,   151,   429,     0,   430,     0,   431,
       0,   432,   433,   434,     0,   435,     0,     0,   436,   437,
     438,   439,     0,   440,   441,   442,     0,   443,     0,   444,
     445,   446,   157,   447,     0,   159,     0,   448,   449,   161,
       0,   450,     0,   451,     0,     0,     0,   452,     0,   453,
       0,   454,   166,     0,   455,     0,   456,   457,   458,   459,
       0,   460,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   169,     0,   469,   470,   471,     0,   171,
       0,   172,     0,     0,     0,     0,   472,     0,   473,   474,
     475,   476,   477,     0,   176,     0,   478,     0,     0,   479,
     480,   481,     0,     0,   482,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   183,     0,   185,     0,   493,
     494,   495,   496,   497,   498,   499,   186,   500,     0,   501,
     502,     0,   503,     0,   189,   190,   504,   505,     0,     0,
     506,     0,     0,     0,   507,   508,     0,     0,   191,     0,
       0,   194,   509,   510,   511,   512,     0,   195,   196,   513,
     514,   515,     0,   516,   517,   518,   519,   520,   521,   198,
     522,   523,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,     0,   533,   534,     0,   535,   536,   206,   537,
     538,   539,   540,   541,   542,     0,   208,   543,   544,   545,
       0,   546,   210,   547,   548,     0,   549,   213,     0,   550,
     551,   552,   553,   554,   555,   556,   557,   215,   558,     0,
     559,   560,     0,   561,   562,   563,   564,     0,   216,   217,
       0,     0,   566,   218,   567,   219,     0,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,   576,     0,     0,
     577,   578,     0,  1739,   227,   580,     0,   581,     0,     0,
       0,   582,   583,   584,   585,   586,   587,     0,     0,     0,
     229,     0,     0,   230,   588,     0,     0,     0,     0,     0,
       0,    81,    82,    83,   372,    85,    86,     0,    87,    88,
      89,   373,     0,   374,     0,    93,   231,    95,    96,    97,
      98,    99,   100,     0,   101,   102,   103,   375,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   116,   376,   377,     0,     0,     0,
     378,   379,     0,     0,     0,     0,   380,     0,     0,     0,
       0,     0,     0,     0,     0,   381,     0,   382,     0,   383,
     384,     0,   385,   386,   387,   388,   389,   390,   391,   392,
       0,   393,   394,     0,     0,     0,     0,     0,     0,     0,
     395,   396,     0,   397,     0,   398,   399,   400,     0,   134,
       0,   136,     0,     0,   401,   402,     0,   403,   404,     0,
       0,   405,   406,   137,   407,     0,   408,   409,   410,   411,
     141,     0,     0,   412,   413,   414,   415,   416,     0,   417,
     418,   144,   419,     0,   420,   421,   422,     0,   423,     0,
       0,     0,     0,     0,   424,   425,   426,   427,   428,   150,
     151,   429,     0,   430,     0,   431,     0,   432,   433,   434,
       0,   435,     0,     0,   436,   437,   438,   439,     0,   440,
     441,   442,     0,   443,     0,   444,   445,   446,   157,   447,
       0,   159,     0,   448,   449,   161,     0,   450,     0,   451,
       0,     0,     0,   452,     0,   453,     0,   454,   166,     0,
     455,     0,   456,   457,   458,   459,     0,   460,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   169,
       0,   469,   470,   471,     0,   171,     0,   172,     0,     0,
       0,     0,   472,     0,   473,   474,   475,   476,   477,     0,
     176,     0,   478,     0,     0,   479,   480,   481,     0,     0,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   183,     0,   185,     0,   493,   494,   495,   496,   497,
     498,   499,   186,   500,     0,   501,   502,     0,   503,     0,
     189,   190,   504,   505,     0,     0,   506,     0,     0,     0,
     507,   508,     0,     0,   191,     0,     0,   194,   509,   510,
     511,   512,     0,   195,   196,   513,   514,   515,     0,   516,
     517,   518,   519,   520,   521,   198,   522,   523,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,     0,   533,
     534,     0,   535,   536,   206,   537,   538,   539,   540,   541,
     542,     0,   208,   543,   544,   545,     0,   546,   210,   547,
     548,     0,   549,   213,     0,   550,   551,   552,   553,   554,
     555,   556,   557,   215,   558,     0,   559,   560,     0,   561,
     562,   563,   564,     0,   216,   217,     0,     0,   566,   218,
     567,   219,     0,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,   576,     0,     0,   577,   578,     0,  1739,
     227,   580,     0,   581,     0,     0,     0,   582,   583,   584,
     585,   586,   587,     0,     0,     0,   229,     0,     0,   230,
      81,    82,    83,   372,    85,    86,     0,    87,    88,    89,
     373,     0,   374,     0,    93,     0,    95,    96,    97,    98,
      99,   100,   231,   101,   102,   103,   375,     0,     0,   105,
     106,   107,   108,     0,     0,     0,   110,   111,   112,     0,
     113,     0,     0,   116,   376,   377,     0,     0,     0,   378,
     379,     0,     0,     0,     0,   380,     0,     0,     0,     0,
       0,     0,     0,     0,   381,     0,   382,     0,   383,   384,
       0,   385,   386,   387,   388,   389,   390,   391,   392,     0,
     393,   394,     0,     0,     0,     0,     0,     0,     0,   395,
     396,     0,   397,     0,   398,   399,   400,     0,   134,     0,
     136,     0,     0,   401,   402,     0,   403,   404,     0,     0,
     405,   406,   137,   407,     0,   408,   409,   410,   411,   141,
       0,     0,   412,   413,   414,   415,   416,     0,   417,   418,
     144,   419,     0,   420,   421,   422,     0,   423,     0,     0,
       0,     0,     0,   424,   425,   426,   427,   428,   150,   151,
     429,     0,   430,     0,   431,     0,   432,   433,   434,     0,
     435,     0,     0,   436,   437,   438,   439,     0,   440,   441,
     442,     0,   443,     0,   444,   445,   446,   157,   447,     0,
     159,     0,   448,   449,   161,     0,   450,     0,   451,     0,
       0,     0,   452,     0,   453,     0,   454,   166,     0,   455,
       0,   456,   457,   458,   459,     0,   460,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   169,     0,
     469,   470,   471,     0,   171,     0,   172,     0,     0,     0,
       0,   472,     0,   473,   474,   475,   476,   477,     0,   176,
       0,   478,     0,     0,   479,   480,   481,     0,     0,   482,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     183,     0,   185,     0,   493,   494,   495,   496,   497,   498,
     499,   186,   500,     0,   501,   502,     0,   503,     0,   189,
     190,   504,   505,     0,     0,   506,     0,     0,     0,   507,
     508,     0,     0,   191,     0,     0,   194,   509,   510,   511,
     512,     0,   195,   196,   513,   514,   515,     0,   516,   517,
     518,   519,   520,   521,   198,   522,   523,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,     0,   533,   534,
       0,   535,   536,   206,   537,   538,   539,   540,   541,   542,
       0,     0,   543,   544,   545,     0,   546,   210,   547,   548,
       0,   549,   213,     0,   550,   551,   552,   553,   554,   555,
     556,   557,   215,   558,     0,   559,   560,     0,   561,   562,
     563,   564,     0,   216,   217,     0,     0,   566,   218,   567,
     219,     0,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,   576,     0,     0,   577,   578,     0,   579,   227,
     580,     0,   581,     0,     0,     0,   582,   583,   584,   585,
     586,   587,     0,     0,     0,   229,     0,     0,   230,    81,
      82,    83,   372,    85,    86,     0,    87,    88,    89,   373,
       0,   374,     0,    93,     0,    95,    96,    97,    98,    99,
     100,  1831,   101,   102,   103,   375,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   116,   376,   377,     0,     0,     0,   378,   379,
       0,     0,     0,     0,   380,     0,     0,     0,     0,     0,
       0,     0,     0,   381,     0,   382,     0,   383,   384,     0,
     385,   386,   387,   388,   389,   390,   391,   392,     0,   393,
     394,     0,     0,     0,     0,     0,     0,     0,   395,   396,
       0,   397,     0,   398,   399,   400,     0,   134,     0,   136,
       0,     0,   401,   402,     0,   403,   404,     0,     0,   405,
     406,   137,   407,     0,   408,   409,   410,   411,   141,     0,
       0,   412,   413,   414,   415,   416,     0,   417,   418,   144,
     419,     0,   420,   421,   422,     0,   423,     0,     0,     0,
       0,     0,   424,   425,   426,   427,   428,   150,   151,   429,
       0,   430,     0,   431,     0,   432,   433,   434,     0,   435,
       0,     0,   436,   437,   438,   439,     0,   440,   441,   442,
       0,   443,     0,   444,   445,   446,   157,   447,     0,   159,
       0,   448,   449,   161,     0,   450,     0,   451,     0,     0,
       0,   452,     0,   453,     0,   454,   166,     0,   455,     0,
     456,   457,   458,   459,     0,   460,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   169,     0,   469,
     470,   471,     0,   171,     0,   172,     0,     0,     0,     0,
     472,     0,   473,   474,   475,   476,   477,     0,   176,     0,
     478,     0,     0,   479,   480,   481,     0,     0,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   183,
       0,   185,     0,   493,   494,   495,   496,   497,   498,   499,
     186,   500,     0,   501,   502,     0,   503,     0,   189,   190,
     504,   505,     0,     0,   506,     0,     0,     0,   507,   508,
       0,     0,   191,     0,     0,   194,   509,   510,   511,   512,
       0,   195,   196,   513,   514,   515,     0,   516,   517,   518,
     519,   520,   521,   198,   522,   523,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,     0,   533,   534,     0,
     535,   536,   206,   537,   538,   539,   540,   541,   542,     0,
       0,   543,   544,   545,     0,   546,   210,   547,   548,     0,
     549,   213,     0,   550,   551,   552,   553,   554,   555,   556,
     557,   215,   558,     0,   559,   560,     0,   561,   562,   563,
     564,     0,   216,   217,     0,     0,   566,   218,   567,   219,
       0,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,   576,     0,     0,   577,   578,     0,   579,   227,   580,
       0,   581,     0,     0,     0,   582,   583,   584,   585,   586,
     587,     0,     0,     0,   229,     0,     0,   230,     0,     0,
       0,     0,     0,     0,   619,    81,    82,    83,   372,    85,
      86,     0,    87,    88,    89,   373,     0,   374,     0,    93,
    2984,    95,    96,    97,    98,    99,   100,   620,   101,   102,
     103,   375,   621,     0,   105,   106,   107,   108,   622,   623,
       0,   110,   111,   112,     0,   113,   624,   625,   116,   376,
     377,     0,     0,     0,   378,   379,     0,     0,     0,     0,
     380,     0,     0,     0,     0,     0,     0,     0,     0,   381,
       0,   382,     0,   383,   384,     0,   385,   386,   387,   388,
     389,   390,   391,   392,   626,   393,   394,   627,   628,   629,
     630,   631,   632,   633,   395,   396,   634,   397,   131,   398,
     399,   400,   133,  1529,   135,  1530,  1211,   635,   401,   402,
       0,   403,   404,   636,   637,   405,  1531,  1532,   407,   639,
     408,   409,   410,   411,     0,   640,   641,   412,   413,   414,
     415,   416,   642,   417,   418,     0,   419,   643,   420,   421,
     422,   147,   423,   644,   645,   646,   647,   648,   424,   425,
     426,   427,   428,  1533,  1534,   429,   649,   430,   650,   431,
       0,   432,   433,   434,   651,   435,   652,   653,   436,  1225,
     438,   439,   654,   440,   441,   442,   655,   443,   656,   444,
     445,   446,     0,   447,     0,     0,   657,   448,   449,  1535,
     658,   450,   659,   451,   162,   660,   163,   452,     0,   453,
     661,   454,     0,   662,   455,   663,   456,   457,   458,   459,
     167,   460,   461,   462,   664,   463,   464,   465,   466,   467,
     468,   665,   168,     0,     0,   469,   470,   471,  1231,  1536,
     668,  1537,   669,     0,   173,   174,   472,   175,   473,   474,
     475,   476,   477,   670,     0,   177,   478,   178,   671,   479,
     480,   481,     0,     0,   482,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,  1538,   184,  1539,   672,   493,
     494,   495,   496,   497,   498,   499,     0,   500,   673,   501,
     502,   188,   503,   674,     0,  1540,   504,   505,   675,   676,
     506,   677,   678,   679,  2878,   508,   680,   681,     0,   192,
     193,     0,   509,   510,   511,   512,     0,     0,     0,   513,
     514,   515,   682,   516,   517,   518,   519,   520,   521,  1541,
     522,   523,   683,   524,   525,   526,   527,   528,   529,   530,
     531,   532,   684,   533,   534,   204,   535,   536,     0,   537,
     538,   539,   540,   541,   542,     0,   685,   543,   544,   545,
     686,   546,  1542,   547,   548,   212,   549,  1543,   687,   550,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   688,
     559,   560,   689,   561,   562,   563,   564,   690,  1544,  1545,
       0,   692,   566,     0,   567,     0,   693,   568,   569,   570,
     571,   572,     0,   695,   573,   574,   575,   576,   696,   697,
     577,   578,     0,     0,  1546,   580,   228,   581,     0,   698,
     699,   582,   583,   584,   585,   586,   587,     0,     0,     0,
     229,    49,  1037,   230,   588,     0,     0,     0,     0,    52,
      53,     0,    54,  1038,  1039,  1040,     0,  1041,  2879,  1043,
    1044,  1045,  1046,    81,    82,    83,   372,    85,    86,     0,
      87,    88,    89,   373,     0,   374,     0,    93,     0,    95,
      96,    97,    98,    99,   100,     0,   101,   102,   103,   375,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   116,   376,   377,     0,
       0,     0,   378,   379,     0,     0,     0,     0,   380,     0,
       0,     0,     0,     0,     0,     0,     0,   381,     0,   382,
       0,   383,   384,     0,   385,   386,   387,   388,   389,   390,
     391,   392,     0,   393,   394,     0,     0,     0,     0,     0,
       0,     0,   395,   396,     0,   397,     0,   398,   399,   400,
       0,   134,     0,   136,     0,     0,   401,   402,     0,   403,
     404,     0,     0,   405,   406,   137,   407,     0,   408,  1036,
     410,   411,   141,     0,     0,   412,   413,   414,   415,   416,
       0,   417,   418,   144,   419,     0,   420,   421,   422,     0,
     423,     0,     0,     0,     0,     0,   424,   425,   426,   427,
     428,   150,   151,   429,     0,   430,     0,   431,     0,   432,
     433,   434,     0,   435,     0,     0,   436,   437,   438,   439,
       0,   440,   441,   442,     0,   443,     0,   444,   445,   446,
     157,   447,     0,   159,     0,   448,   449,   161,     0,   450,
       0,   451,     0,     0,     0,   452,     0,   453,     0,   454,
     166,     0,   455,     0,   456,   457,   458,   459,     0,   460,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   169,     0,   469,   470,   471,     0,   171,     0,   172,
       0,     0,     0,     0,   472,     0,   473,   474,   475,   476,
     477,     0,   176,     0,   478,     0,     0,   479,   480,   481,
       0,     0,   482,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   183,     0,   185,     0,   493,   494,   495,
     496,   497,   498,   499,   186,   500,     0,   501,   502,     0,
     503,     0,   189,   190,   504,   505,     0,     0,   506,     0,
       0,     0,   507,   508,     0,     0,   191,     0,     0,   194,
     509,   510,   511,   512,     0,   195,   196,   513,   514,   515,
       0,   516,   517,   518,   519,   520,   521,   198,   522,   523,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
       0,   533,   534,     0,   535,   536,   206,   537,   538,   539,
     540,   541,   542,     0,     0,   543,   544,   545,     0,   546,
     210,   547,   548,     0,   549,   213,     0,   550,   551,   552,
     553,   554,   555,   556,   557,   215,   558,     0,   559,   560,
       0,   561,   562,   563,   564,     0,   216,   217,     0,     0,
     566,   218,   567,   219,     0,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,   576,     0,     0,   577,   578,
       0,   579,   227,   580,     0,   581,     0,     0,     0,   582,
     583,   584,   585,   586,   587,     0,     0,     0,   229,     0,
    1037,   230,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1038,  1039,  1040,     0,  1041,  1042,  1043,  1044,  1045,
    1046,    81,    82,    83,   372,    85,    86,     0,    87,    88,
      89,   373,     0,   374,     0,    93,     0,    95,    96,    97,
      98,    99,   100,     0,   101,   102,   103,   375,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   116,   376,   377,     0,     0,     0,
     378,   379,     0,     0,     0,     0,   380,     0,     0,     0,
       0,     0,     0,     0,     0,   381,     0,   382,     0,   383,
     384,     0,   385,   386,   387,   388,   389,   390,   391,   392,
       0,   393,   394,     0,     0,     0,     0,     0,     0,     0,
     395,   396,     0,   397,     0,   398,   399,   400,     0,   134,
       0,   136,     0,     0,   401,   402,     0,   403,   404,     0,
       0,   405,   406,   137,   407,     0,   408,   409,   410,   411,
     141,     0,     0,   412,   413,   414,   415,   416,     0,   417,
     418,   144,   419,     0,   420,   421,   422,     0,   423,     0,
       0,     0,     0,     0,   424,   425,   426,   427,   428,   150,
     151,   429,     0,   430,     0,   431,     0,   432,   433,   434,
       0,   435,     0,     0,   436,   437,   438,   439,     0,   440,
     441,   442,     0,   443,     0,   444,   445,   446,   157,   447,
       0,   159,     0,   448,   449,   161,     0,   450,     0,   451,
       0,     0,     0,   452,     0,   453,     0,   454,   166,     0,
     455,     0,   456,   457,   458,   459,     0,   460,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   169,
       0,   469,   470,   471,     0,   171,     0,   172,     0,     0,
       0,     0,   472,     0,   473,   474,   475,   476,   477,     0,
     176,     0,   478,     0,     0,   479,   480,   481,     0,     0,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   183,     0,   185,     0,   493,   494,   495,   496,   497,
     498,   499,   186,   500,     0,   501,   502,     0,   503,     0,
     189,   190,   504,   505,     0,     0,   506,     0,     0,     0,
     507,   508,     0,     0,   191,     0,     0,   194,   509,   510,
     511,   512,     0,   195,   196,   513,   514,   515,     0,   516,
     517,   518,   519,   520,   521,   198,   522,   523,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,     0,   533,
     534,     0,   535,   536,   206,   537,   538,   539,   540,   541,
     542,     0,     0,   543,   544,   545,     0,   546,   210,   547,
     548,     0,   549,   213,     0,   550,   551,   552,   553,   554,
     555,   556,   557,   215,   558,     0,   559,   560,     0,   561,
     562,   563,   564,     0,   216,   217,     0,     0,   566,   218,
     567,   219,     0,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,   576,     0,     0,   577,   578,     0,   579,
     227,   580,     0,   581,     0,     0,     0,   582,   583,   584,
     585,   586,   587,     0,     0,     0,   229,     0,  1037,   230,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1038,
    1039,  1040,     0,  1041,  1042,  1043,  1044,  1045,  1046,   619,
      81,    82,    83,   372,    85,    86,     0,    87,    88,    89,
     373,     0,   374,     0,    93,     0,    95,    96,    97,    98,
      99,   100,   620,   101,   102,   103,   375,   621,     0,   105,
     106,   107,   108,   622,   623,     0,   110,   111,   112,     0,
     113,   624,   625,   116,   376,   377,     0,     0,     0,   378,
     379,     0,     0,     0,     0,   380,     0,     0,     0,     0,
       0,     0,     0,     0,   381,     0,   382,     0,   383,   384,
       0,   385,   386,   387,   388,   389,   390,   391,   392,   626,
     393,   394,   627,   628,   629,   630,   631,   632,   633,   395,
     396,   634,   397,   131,   398,   399,   400,   133,   134,   135,
     136,     0,   635,   401,   402,     0,   403,   404,   636,   637,
     405,   638,   137,   407,   639,   408,   409,   410,   411,   141,
     640,   641,   412,   413,   414,   415,   416,   642,   417,   418,
     144,   419,   643,   420,   421,   422,   147,   423,   644,   645,
     646,   647,   648,   424,   425,   426,   427,   428,   150,   151,
     429,   649,   430,   650,   431,     0,   432,   433,   434,   651,
     435,   652,   653,   436,   437,   438,   439,   654,   440,   441,
     442,   655,   443,   656,   444,   445,   446,   157,   447,     0,
     159,   657,   448,   449,   161,   658,   450,   659,   451,   162,
     660,   163,   452,     0,   453,   661,   454,   166,   662,   455,
     663,   456,   457,   458,   459,   167,   460,   461,   462,   664,
     463,   464,   465,   466,   467,   468,   665,   168,   169,   666,
     469,   470,   471,   667,   171,   668,   172,   669,     0,   173,
     174,   472,   175,   473,   474,   475,   476,   477,   670,   176,
     177,   478,   178,   671,   479,   480,   481,     0,     0,   482,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     183,   184,   185,   672,   493,   494,   495,   496,   497,   498,
     499,   186,   500,   673,   501,   502,   188,   503,   674,   189,
     190,   504,   505,   675,   676,   506,   677,   678,   679,   507,
     508,   680,   681,   191,   192,   193,   194,   509,   510,   511,
     512,     0,   195,   196,   513,   514,   515,   682,   516,   517,
     518,   519,   520,   521,   198,   522,   523,   683,   524,   525,
     526,   527,   528,   529,   530,   531,   532,   684,   533,   534,
     204,   535,   536,   206,   537,   538,   539,   540,   541,   542,
       0,   685,   543,   544,   545,   686,   546,   210,   547,   548,
     212,   549,   213,   687,   550,   551,   552,   553,   554,   555,
     556,   557,   215,   558,   688,   559,   560,   689,   561,   562,
     563,   564,   690,   216,   217,   691,   692,   566,   218,   567,
     219,   693,   568,   569,   570,   571,   572,   694,   695,   573,
     574,   575,   576,   696,   697,   577,   578,     0,     0,   227,
     580,   228,   581,     0,   698,   699,   582,   583,   584,   585,
     586,   587,     0,     0,     0,   229,     0,     0,   230,     0,
     619,    81,    82,    83,   372,    85,    86,     0,    87,    88,
      89,   373,     0,   374,  1504,    93,     0,    95,    96,    97,
      98,    99,   100,   620,   101,   102,   103,   375,   621,     0,
     105,   106,   107,   108,   622,   623,     0,   110,   111,   112,
       0,   113,   624,   625,   116,   376,   377,     0,     0,     0,
     378,   379,     0,     0,     0,     0,   380,     0,     0,     0,
       0,     0,     0,     0,     0,   381,     0,   382,     0,   383,
     384,     0,   385,   386,   387,   388,   389,   390,   391,   392,
       0,   393,   394,     0,     0,     0,     0,     0,     0,     0,
     395,   396,     0,   397,     0,   398,   399,   400,     0,  1529,
       0,  1530,  1211,     0,   401,   402,     0,   403,   404,     0,
       0,   405,  1531,  1532,   407,     0,   408,   409,   410,   411,
       0,     0,     0,   412,   413,   414,   415,   416,     0,   417,
     418,     0,   419,     0,   420,   421,   422,     0,   423,     0,
       0,     0,     0,     0,   424,   425,   426,   427,   428,  1533,
    1534,   429,     0,   430,     0,   431,     0,   432,   433,   434,
       0,   435,     0,     0,   436,  1225,   438,   439,     0,   440,
     441,   442,     0,   443,     0,   444,   445,   446,     0,   447,
       0,     0,     0,   448,   449,  1535,     0,   450,     0,   451,
       0,     0,     0,   452,     0,   453,     0,   454,     0,     0,
     455,     0,   456,   457,   458,   459,     0,   460,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,     0,
       0,   469,   470,   471,  1231,  1536,     0,  1537,     0,     0,
       0,     0,   472,     0,   473,   474,   475,   476,   477,     0,
       0,     0,   478,     0,     0,   479,   480,   481,     0,     0,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,  1538,     0,  1539,     0,   493,   494,   495,   496,   497,
     498,   499,     0,   500,     0,   501,   502,     0,   503,     0,
       0,  1540,   504,   505,     0,     0,   506,     0,     0,     0,
     507,   508,     0,     0,     0,     0,     0,     0,   509,   510,
     511,   512,     0,     0,     0,   513,   514,   515,     0,   516,
     517,   518,   519,   520,   521,  1541,   522,   523,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,     0,   533,
     534,     0,   535,   536,     0,   537,   538,   539,   540,   541,
     542,     0,     0,   543,   544,   545,     0,   546,  1542,   547,
     548,     0,   549,  1543,     0,   550,   551,   552,   553,   554,
     555,   556,   557,     0,   558,     0,   559,   560,     0,   561,
     562,   563,   564,     0,  1544,  1545,     0,     0,   566,     0,
     567,     0,     0,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,   576,     0,     0,   577,   578,     0,     0,
    1546,   580,     0,   581,     0,     0,     0,   582,   583,   584,
     585,   586,   587,     0,     0,     0,   229,     0,     0,   230,
      81,    82,    83,   372,    85,    86,     0,    87,    88,    89,
     373,     0,   374,     0,    93,  1906,    95,    96,    97,    98,
      99,   100,     0,   101,   102,   103,   375,     0,     0,   105,
     106,   107,   108,     0,     0,     0,   110,   111,   112,     0,
     113,     0,     0,   116,   376,   377,     0,     0,     0,   378,
     379,     0,     0,     0,     0,   380,     0,     0,     0,     0,
       0,     0,     0,     0,   381,     0,   382,     0,   383,   384,
       0,   385,   386,   387,   388,   389,   390,   391,   392,     0,
     393,   394,     0,     0,     0,     0,     0,     0,     0,   395,
     396,     0,   397,     0,   398,   399,   400,     0,   134,     0,
     136,     0,     0,   401,   402,     0,   403,   404,     0,     0,
     405,   406,   137,   407,     0,   408,   409,   410,   411,   141,
       0,     0,   412,   413,   414,   415,   416,     0,   417,   418,
     144,   419,     0,   420,   421,   422,     0,   423,     0,     0,
       0,     0,     0,   424,   425,   426,   427,   428,   150,   151,
     429,     0,   430,     0,   431,     0,   432,   433,   434,     0,
     435,     0,     0,   436,   437,   438,   439,     0,   440,   441,
     442,     0,   443,     0,   444,   445,   446,   157,   447,     0,
     159,     0,   448,   449,   161,     0,   450,     0,   451,     0,
       0,     0,   452,     0,   453,     0,   454,   166,     0,   455,
       0,   456,   457,   458,   459,     0,   460,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   169,     0,
     469,   470,   471,     0,   171,     0,   172,     0,     0,     0,
       0,   472,     0,   473,   474,   475,   476,   477,     0,   176,
       0,   478,     0,     0,   479,   480,   481,     0,     0,   482,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     183,     0,   185,   749,   493,   494,   495,   496,   497,   498,
     499,   186,   500,     0,   501,   502,     0,   503,     0,   189,
     190,   504,   505,     0,     0,   506,   750,     0,     0,   507,
     508,     0,     0,   191,     0,     0,   194,   509,   510,   511,
     512,     0,   195,   196,   513,   514,   515,     0,   516,   517,
     518,   519,   520,   521,   198,   522,   523,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,     0,   533,   534,
       0,   535,   536,   206,   537,   538,   539,   540,   541,   542,
       0,     0,   543,   544,   545,     0,   546,   210,   547,   548,
       0,   549,   213,     0,   550,   551,   552,   553,   554,   555,
     556,   557,   215,   558,     0,   559,   560,     0,   561,   562,
     563,   564,     0,   216,   217,     0,     0,   566,   218,   567,
     219,     0,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,   576,     0,     0,   577,   578,     0,   579,   227,
     580,     0,   581,     0,     0,     0,   582,   583,   584,   585,
     586,   587,     0,     0,     0,   229,     0,     0,   230,    81,
      82,    83,   372,    85,    86,     0,    87,    88,    89,   373,
       0,   374,     0,    93,   925,    95,    96,    97,    98,    99,
     100,     0,   101,   102,   103,   375,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   116,   376,   377,     0,     0,     0,   378,   379,
       0,     0,     0,     0,   380,     0,     0,     0,     0,     0,
       0,     0,     0,   381,     0,   382,     0,   383,   384,     0,
     385,   386,   387,   388,   389,   390,   391,   392,     0,   393,
     394,     0,     0,     0,     0,     0,     0,     0,   395,   396,
       0,   397,     0,   398,   399,   400,     0,   134,     0,   136,
       0,     0,   401,   402,     0,   403,   404,     0,     0,   405,
     406,   137,   407,     0,   408,   409,   410,   411,   141,     0,
       0,   412,   413,   414,   415,   416,     0,   417,   418,   144,
     419,     0,   420,   421,   422,     0,   423,     0,     0,     0,
       0,     0,   424,   425,   426,   427,   428,   150,   151,   429,
    1812,   430,     0,   431,     0,   432,   433,   434,     0,   435,
       0,     0,   436,   437,   438,   439,     0,   440,   441,   442,
       0,   443,     0,   444,   445,   446,   157,   447,     0,   159,
    1813,   448,   449,   161,     0,   450,     0,   451,     0,     0,
       0,   452,     0,   453,     0,   454,   166,     0,   455,     0,
     456,   457,   458,   459,     0,   460,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   169,     0,   469,
     470,   471,     0,   171,     0,   172,     0,     0,     0,     0,
     472,     0,   473,   474,   475,   476,   477,     0,   176,     0,
     478,     0,     0,   479,   480,   481,     0,     0,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   183,
       0,   185,     0,   493,   494,   495,   496,   497,   498,   499,
     186,   500,     0,   501,   502,     0,   503,     0,   189,   190,
     504,   505,  1814,     0,   506,     0,  1815,     0,   507,   508,
       0,     0,   191,     0,     0,   194,   509,   510,   511,   512,
       0,   195,   196,   513,   514,   515,     0,   516,   517,   518,
     519,   520,   521,   198,   522,   523,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,     0,   533,   534,     0,
     535,   536,   206,   537,   538,   539,   540,   541,   542,     0,
       0,   543,   544,   545,     0,   546,   210,   547,   548,     0,
     549,   213,     0,   550,   551,   552,   553,   554,   555,   556,
     557,   215,   558,     0,   559,   560,     0,   561,   562,   563,
     564,     0,   216,   217,     0,     0,   566,   218,   567,   219,
    1816,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,   576,     0,     0,   577,   578,     0,   579,   227,   580,
       0,   581,     0,     0,     0,   582,   583,   584,   585,   586,
     587,     0,     0,     0,   229,    49,     0,   230,   588,     0,
       0,     0,     0,    52,    53,     0,    54,     0,     0,     0,
       0,     0,  1382,    81,    82,    83,   372,    85,    86,     0,
      87,    88,    89,   373,     0,   374,     0,    93,     0,    95,
      96,    97,    98,    99,   100,     0,   101,   102,   103,   375,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   116,   376,   377,     0,
       0,     0,   378,   379,     0,     0,     0,     0,   380,     0,
       0,     0,     0,     0,     0,     0,     0,   381,     0,   382,
       0,   383,   384,     0,   385,   386,   387,   388,   389,   390,
     391,   392,     0,   393,   394,     0,     0,     0,     0,     0,
       0,     0,   395,   396,     0,   397,     0,   398,   399,   400,
       0,   134,     0,   136,     0,     0,   401,   402,     0,   403,
     404,     0,     0,   405,   406,   137,   407,     0,   408,   409,
     410,   411,   141,     0,     0,   412,   413,   414,   415,   416,
       0,   417,   418,   144,   419,     0,   420,   421,   422,     0,
     423,     0,     0,     0,     0,     0,   424,   425,   426,   427,
     428,   150,   151,   429,     0,   430,     0,   431,     0,   432,
     433,   434,     0,   435,     0,     0,   436,   437,   438,   439,
       0,   440,   441,   442,     0,   443,     0,   444,   445,   446,
     157,   447,     0,   159,  1813,   448,   449,   161,     0,   450,
       0,   451,     0,     0,     0,   452,     0,   453,     0,   454,
     166,     0,   455,     0,   456,   457,   458,   459,     0,   460,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   169,     0,   469,   470,   471,     0,   171,     0,   172,
       0,     0,     0,     0,   472,     0,   473,   474,   475,   476,
     477,     0,   176,     0,   478,     0,     0,   479,   480,   481,
       0,     0,   482,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   183,     0,   185,     0,   493,   494,   495,
     496,   497,   498,   499,   186,   500,     0,   501,   502,     0,
     503,     0,   189,   190,   504,   505,  1814,     0,   506,     0,
    1815,     0,   507,   508,     0,     0,   191,     0,     0,   194,
     509,   510,   511,   512,     0,   195,   196,   513,   514,   515,
       0,   516,   517,   518,   519,   520,   521,   198,   522,   523,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
       0,   533,   534,     0,   535,   536,   206,   537,   538,   539,
     540,   541,   542,     0,     0,   543,   544,   545,     0,   546,
     210,   547,   548,     0,   549,   213,     0,   550,   551,   552,
     553,   554,   555,   556,   557,   215,   558,     0,   559,   560,
       0,   561,   562,   563,   564,     0,   216,   217,     0,     0,
     566,   218,   567,   219,  1816,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,   576,     0,     0,   577,   578,
       0,   579,   227,   580,     0,   581,     0,     0,     0,   582,
     583,   584,   585,   586,   587,     0,     0,     0,   229,    49,
       0,   230,   588,     0,     0,     0,     0,    52,    53,     0,
      54,     0,     0,     0,     0,     0,  1382,    81,    82,    83,
     372,    85,    86,     0,    87,    88,    89,   373,     0,   374,
       0,    93,     0,    95,    96,    97,    98,    99,   100,     0,
     101,   102,   103,   375,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     116,   376,   377,     0,     0,     0,   378,   379,     0,     0,
       0,     0,   380,     0,     0,     0,     0,     0,     0,     0,
       0,   381,     0,   382,     0,   383,   384,     0,   385,   833,
     387,   388,   389,   390,   391,   392,   834,   393,   394,     0,
       0,     0,     0,     0,     0,     0,   395,   396,     0,   397,
       0,   835,   399,   400,     0,   134,     0,   136,     0,     0,
     401,   402,     0,   403,   404,     0,     0,   405,   406,   137,
     407,     0,   408,   409,   410,   411,   141,     0,     0,   412,
     413,   414,   415,   416,     0,   417,   418,   144,   419,     0,
     420,   421,   422,     0,   423,     0,     0,     0,     0,     0,
     424,   425,   426,   427,   428,   150,   151,   429,     0,   430,
       0,   431,     0,   432,   433,   434,     0,   435,     0,     0,
     436,   437,   438,   439,     0,   440,   441,   442,     0,   443,
       0,   444,   445,   446,   157,   447,     0,   159,     0,   448,
     836,   161,     0,   450,     0,   837,     0,   838,     0,   452,
       0,   453,     0,   454,   166,     0,   455,     0,   456,   457,
     458,   459,     0,   460,   461,   462,   839,   463,   464,   465,
     466,   467,   468,     0,     0,   169,     0,   469,   470,   471,
       0,   171,     0,   172,     0,     0,     0,     0,   472,     0,
     473,   474,   475,   476,   840,     0,   176,     0,   478,     0,
       0,   479,   480,   481,     0,     0,   482,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   183,     0,   185,
       0,   841,   494,   495,   496,   497,   498,   499,   186,   500,
       0,   501,   502,     0,   503,     0,   189,   190,   504,   505,
       0,     0,   506,     0,     0,     0,   507,   508,     0,     0,
     191,     0,     0,   194,   509,   510,   511,   512,     0,   195,
     196,   513,   514,   515,     0,   842,   517,   518,   519,   520,
     521,   198,   522,   523,     0,   524,   843,   526,   527,   528,
     529,   530,   531,   532,     0,   533,   534,     0,   535,   536,
     206,   537,   538,   539,   540,   541,   542,     0,     0,   543,
     544,   545,     0,   546,   210,   547,   548,     0,   549,   213,
       0,   550,   551,   552,   553,   554,   555,   556,   557,   215,
     558,     0,   559,   560,     0,   561,   562,   563,   564,     0,
     216,   217,     0,     0,   566,   218,   567,   219,     0,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,   576,
       0,     0,   577,   578,     0,   579,   227,   580,     0,   581,
       0,     0,     0,   582,   583,   584,   585,   586,   587,     0,
       0,     0,   229,     0,     0,   230,   588,     0,     0,     0,
       0,     0,    53,     0,    81,    82,    83,   372,    85,    86,
     844,    87,    88,    89,   373,     0,   374,     0,    93,     0,
      95,    96,    97,    98,    99,   100,     0,   101,   102,   103,
     375,     0,     0,   105,   106,   107,   108,     0,     0,     0,
     110,   111,   112,     0,   113,     0,     0,   116,   376,   377,
       0,     0,     0,   378,   379,     0,     0,     0,     0,   380,
       0,     0,     0,     0,     0,     0,     0,     0,   381,     0,
     382,     0,   383,   384,     0,   385,   833,   387,   388,   389,
     390,   391,   392,   834,   393,   394,     0,     0,     0,     0,
       0,     0,     0,   395,   396,     0,   397,     0,   835,   399,
     400,     0,   134,     0,   136,     0,     0,   401,   402,     0,
     403,   404,     0,     0,   405,   406,   137,   407,     0,   408,
     409,   410,   411,   141,     0,     0,   412,   413,   414,   415,
     416,     0,   417,   418,   144,   419,     0,   420,   421,   422,
       0,   423,     0,     0,     0,     0,     0,   424,   425,   426,
     427,   428,   150,   151,   429,     0,   430,     0,   431,     0,
     432,   433,   434,     0,   435,     0,     0,   436,   437,   438,
     439,     0,   440,   441,   442,     0,   443,     0,   444,   445,
     446,   157,   447,     0,   159,     0,   448,   836,   161,     0,
     450,     0,   837,     0,     0,     0,   452,     0,   453,     0,
     454,   166,     0,   455,     0,   456,   457,   458,   459,     0,
     460,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   169,     0,   469,   470,   471,     0,   171,     0,
     172,     0,     0,     0,     0,   472,     0,   473,   474,   475,
     476,   840,     0,   176,     0,   478,     0,     0,   479,   480,
     481,     0,     0,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   183,     0,   185,     0,   841,   494,
     495,   496,   497,   498,   499,   186,   500,     0,   501,   502,
       0,   503,     0,   189,   190,   504,   505,     0,     0,   506,
       0,     0,     0,   507,   508,     0,     0,   191,     0,     0,
     194,   509,   510,   511,   512,     0,   195,   196,   513,   514,
     515,     0,   842,   517,   518,   519,   520,   521,   198,   522,
     523,     0,   524,   843,   526,   527,   528,   529,   530,   531,
     532,     0,   533,   534,     0,   535,   536,   206,   537,   538,
     539,   540,   541,   542,     0,     0,   543,   544,   545,     0,
     546,   210,   547,   548,     0,   549,   213,     0,   550,   551,
     552,   553,   554,   555,   556,   557,   215,   558,     0,   559,
     560,     0,   561,   562,   563,   564,     0,   216,   217,     0,
       0,   566,   218,   567,   219,     0,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,   576,     0,     0,   577,
     578,     0,   579,   227,   580,     0,   581,     0,     0,     0,
     582,   583,   584,   585,   586,   587,     0,     0,     0,   229,
       0,     0,   230,   588,     0,     0,     0,     0,     0,    53,
       0,    81,    82,    83,   372,    85,    86,   844,    87,    88,
      89,   373,     0,   374,     0,    93,     0,    95,    96,    97,
      98,    99,   100,     0,   101,   102,   103,   375,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   116,   376,   377,     0,     0,     0,
     378,   379,     0,     0,     0,     0,   380,     0,     0,     0,
       0,     0,     0,     0,     0,   381,     0,   382,     0,   383,
     384,     0,   385,   386,   387,   388,   389,   390,   391,   392,
       0,   393,   394,     0,     0,     0,     0,     0,     0,     0,
     395,   396,     0,   397,     0,   398,   399,   400,     0,   134,
       0,   136,     0,     0,   401,   402,     0,   403,   404,     0,
       0,   405,   406,   137,   407,     0,   408,   409,   410,   411,
     141,     0,     0,   412,   413,   414,   415,   416,     0,   417,
     418,   144,   419,     0,   420,   421,   422,     0,   423,     0,
       0,     0,     0,     0,   424,   425,   426,   427,   428,   150,
     151,   429,   612,   430,     0,   431,     0,   432,   433,   434,
       0,   435,     0,     0,   436,   437,   438,   439,     0,   440,
     441,   442,     0,   443,     0,   444,   445,   446,   157,   447,
       0,   159,     0,   448,   449,   161,     0,   450,     0,   451,
       0,     0,     0,   452,     0,   453,     0,   454,   166,     0,
     455,     0,   456,   457,   458,   459,     0,   460,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   169,
       0,   469,   470,   471,     0,   171,     0,   172,     0,     0,
       0,     0,   472,     0,   473,   474,   475,   476,   477,     0,
     176,     0,   478,     0,     0,   479,   480,   481,     0,     0,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   183,     0,   185,     0,   493,   494,   495,   496,   497,
     498,   499,   186,   500,     0,   501,   502,     0,   503,     0,
     189,   190,   504,   505,     0,     0,   506,     0,     0,     0,
     507,   508,     0,     0,   191,     0,     0,   194,   509,   510,
     511,   512,     0,   195,   196,   513,   514,   515,     0,   516,
     517,   518,   519,   520,   521,   198,   522,   523,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,     0,   533,
     534,     0,   535,   536,   206,   537,   538,   539,   540,   541,
     542,     0,     0,   543,   544,   545,     0,   546,   210,   547,
     548,     0,   549,   213,     0,   550,   551,   552,   553,   554,
     555,   556,   557,   215,   558,     0,   559,   560,     0,   561,
     562,   563,   564,     0,   216,   217,  1310,     0,   566,   218,
     567,   219,     0,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,   576,     0,     0,   577,   578,     0,   579,
     227,   580,     0,   581,     0,     0,     0,   582,   583,   584,
     585,   586,   587,     0,     0,     0,   229,     0,     0,   230,
     588,     0,     0,    81,    82,    83,   372,    85,    86,  1311,
      87,    88,    89,   373,     0,   374,     0,    93,     0,    95,
      96,    97,    98,    99,   100,     0,   101,   102,   103,   375,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   116,   376,   377,     0,
       0,     0,   378,   379,     0,     0,     0,     0,   380,     0,
       0,     0,     0,     0,     0,     0,     0,   381,     0,   382,
       0,   383,   384,     0,   385,   386,   387,   388,   389,   390,
     391,   392,     0,   393,   394,     0,     0,     0,     0,     0,
       0,     0,   395,   396,     0,   397,     0,   398,   399,   400,
       0,   134,     0,   136,     0,     0,   401,   402,     0,   403,
     404,     0,     0,   405,   406,   137,   407,     0,   408,   409,
     410,   411,   141,     0,     0,   412,   413,   414,   415,   416,
       0,   417,   418,   144,   419,     0,   420,   421,   422,     0,
     423,     0,     0,     0,     0,     0,   424,   425,   426,   427,
     428,   150,   151,   429,     0,   430,     0,   431,     0,   432,
     433,   434,     0,   435,     0,     0,   436,   437,   438,   439,
       0,   440,   441,   442,     0,   443,     0,   444,   445,   446,
     157,   447,     0,   159,     0,   448,   449,   161,     0,   450,
       0,   451,     0,     0,     0,   452,     0,   453,     0,   454,
     166,     0,   455,     0,   456,   457,   458,   459,     0,   460,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   169,     0,   469,   470,   471,     0,   171,     0,   172,
       0,     0,     0,     0,   472,     0,   473,   474,   475,   476,
     477,     0,   176,     0,   478,     0,     0,   479,   480,   481,
       0,     0,   482,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   183,     0,   185,     0,   493,   494,   495,
     496,   497,   498,   499,   186,   500,     0,   501,   502,     0,
     503,     0,   189,   190,   504,   505,     0,     0,   506,     0,
       0,     0,   507,   508,     0,     0,   191,     0,     0,   194,
     509,   510,   511,   512,     0,   195,   196,   513,   514,   515,
       0,   516,   517,   518,   519,   520,   521,   198,   522,   523,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
       0,   533,   534,     0,   535,   536,   206,   537,   538,   539,
     540,   541,   542,     0,     0,   543,   544,   545,     0,   546,
     210,   547,   548,     0,   549,   213,     0,   550,   551,   552,
     553,   554,   555,   556,   557,   215,   558,     0,   559,   560,
       0,   561,   562,   563,   564,     0,   216,   217,     0,     0,
     566,   218,   567,   219,     0,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,   576,     0,     0,   577,   578,
       0,   579,   227,   580,     0,   581,     0,     0,     0,   582,
     583,   584,   585,   586,   587,     0,     0,     0,   229,    49,
       0,   230,   588,     0,     0,  1260,  1261,    52,    53,     0,
      54,    81,    82,    83,   372,    85,    86,     0,    87,    88,
      89,   373,     0,   374,     0,    93,     0,    95,    96,    97,
      98,    99,   100,     0,   101,   102,   103,   375,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   116,   376,   377,     0,     0,     0,
     378,   379,     0,     0,     0,     0,   380,     0,     0,     0,
       0,     0,     0,     0,     0,   381,     0,   382,     0,   383,
     384,     0,   385,   386,   387,   388,   389,   390,   391,   392,
       0,   393,   394,     0,     0,     0,     0,     0,     0,     0,
     395,   396,     0,   397,     0,   398,   399,   400,     0,   134,
       0,   136,     0,     0,   401,   402,     0,   403,   404,     0,
       0,   405,   406,   137,   407,     0,   408,   409,   410,   411,
     141,     0,     0,   412,   413,   414,   415,   416,     0,   417,
     418,   144,   419,     0,   420,   421,   422,     0,   423,     0,
       0,     0,     0,     0,   424,   425,   426,   427,   428,   150,
     151,   429,     0,   430,     0,   431,     0,   432,   433,   434,
       0,   435,     0,     0,   436,   437,   438,   439,     0,   440,
     441,   442,     0,   443,     0,   444,   445,   446,   157,   447,
       0,   159,     0,   448,   449,   161,     0,   450,     0,   451,
       0,     0,     0,   452,     0,   453,     0,   454,   166,     0,
     455,     0,   456,   457,   458,   459,     0,   460,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   169,
       0,   469,   470,   471,     0,   171,     0,   172,     0,     0,
       0,     0,   472,     0,   473,   474,   475,   476,   477,     0,
     176,     0,   478,     0,     0,   479,   480,   481,     0,     0,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   183,     0,   185,     0,   493,   494,   495,   496,   497,
     498,   499,   186,   500,     0,   501,   502,     0,   503,     0,
     189,   190,   504,   505,     0,     0,   506,     0,     0,     0,
     507,   508,     0,     0,   191,     0,     0,   194,   509,   510,
     511,   512,     0,   195,   196,   513,   514,   515,     0,   516,
     517,   518,   519,   520,   521,   198,   522,   523,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,     0,   533,
     534,     0,   535,   536,   206,   537,   538,   539,   540,   541,
     542,     0,     0,   543,   544,   545,     0,   546,   210,   547,
     548,     0,   549,   213,     0,   550,   551,   552,   553,   554,
     555,   556,   557,   215,   558,     0,   559,   560,     0,   561,
     562,   563,   564,     0,   216,   217,   565,     0,   566,   218,
     567,   219,     0,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,   576,     0,     0,   577,   578,     0,   579,
     227,   580,     0,   581,     0,     0,     0,   582,   583,   584,
     585,   586,   587,     0,     0,     0,   229,    49,     0,   230,
     588,     0,     0,     0,     0,    52,    81,    82,    83,   372,
      85,    86,     0,    87,    88,    89,   373,     0,   374,     0,
      93,     0,    95,    96,    97,    98,    99,   100,     0,   101,
     102,   103,   375,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   116,
     376,   377,     0,     0,     0,   378,   379,     0,     0,     0,
       0,   380,     0,     0,     0,     0,     0,     0,     0,     0,
     381,     0,   382,     0,   383,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,     0,   393,   394,     0,     0,
       0,     0,     0,     0,     0,   395,   396,     0,   397,     0,
     398,   399,   400,     0,   134,     0,   136,     0,     0,   401,
     402,     0,   403,   404,     0,     0,   405,   406,   137,   407,
       0,   408,   409,   410,   411,   141,     0,     0,   412,   413,
     414,   415,   416,     0,   417,   418,   144,   419,     0,   420,
     421,   422,     0,   423,     0,     0,     0,     0,     0,   424,
     425,   426,   427,   428,   150,   151,   429,   983,   430,     0,
     431,     0,   432,   433,   434,     0,   435,     0,     0,   436,
     437,   438,   439,     0,   440,   441,   442,     0,   443,     0,
     444,   445,   446,   157,   447,     0,   159,     0,   448,   449,
     161,     0,   450,     0,   451,     0,     0,     0,   452,     0,
     453,     0,   454,   166,     0,   455,     0,   456,   457,   458,
     459,     0,   460,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   169,     0,   469,   470,   471,     0,
     171,     0,   172,     0,     0,     0,     0,   472,     0,   473,
     474,   475,   476,   477,     0,   176,     0,   478,     0,     0,
     479,   480,   481,     0,     0,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   183,     0,   185,     0,
     493,   494,   495,   496,   497,   498,   499,   186,   500,     0,
     501,   502,     0,   503,     0,   189,   190,   504,   505,     0,
       0,   506,     0,     0,     0,   507,   508,     0,     0,   191,
       0,     0,   194,   509,   510,   511,   512,     0,   195,   196,
     513,   514,   515,     0,   516,   517,   518,   519,   520,   521,
     198,   522,   523,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,     0,   533,   534,     0,   535,   536,   206,
     537,   538,   539,   540,   541,   542,     0,     0,   543,   544,
     545,     0,   546,   210,   547,   548,     0,   549,   213,     0,
     550,   551,   552,   553,   554,   555,   556,   557,   215,   558,
       0,   559,   560,     0,   561,   562,   563,   564,     0,   216,
     217,     0,     0,   566,   218,   567,   219,     0,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,   576,     0,
       0,   577,   578,     0,   579,   227,   580,     0,   581,     0,
       0,     0,   582,   583,   584,   585,   586,   587,     0,     0,
       0,   229,    49,     0,   230,   588,     0,     0,     0,     0,
      52,    81,    82,    83,   372,    85,    86,     0,    87,    88,
      89,   373,     0,   374,     0,    93,     0,    95,    96,    97,
      98,    99,   100,     0,   101,   102,   103,   375,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   116,   376,   377,     0,     0,     0,
     378,   379,     0,     0,     0,     0,   380,     0,     0,     0,
       0,     0,     0,     0,     0,   381,     0,   382,     0,   383,
     384,     0,   385,   386,   387,   388,   389,   390,   391,   392,
       0,   393,   394,     0,     0,     0,     0,     0,     0,     0,
     395,   396,     0,   397,     0,   398,   399,   400,     0,   134,
       0,   136,     0,     0,   401,   402,     0,   403,   404,     0,
       0,   405,   406,   137,   407,     0,   408,   409,   410,   411,
     141,     0,     0,   412,   413,   414,   415,   416,     0,   417,
     418,   144,   419,     0,   420,   421,   422,     0,   423,     0,
       0,     0,     0,     0,   424,   425,   426,   427,   428,   150,
     151,   429,  1803,   430,     0,   431,     0,   432,   433,   434,
       0,   435,     0,     0,   436,   437,   438,   439,     0,   440,
     441,   442,     0,   443,     0,   444,   445,   446,   157,   447,
       0,   159,     0,   448,   449,   161,     0,   450,     0,   451,
       0,     0,     0,   452,     0,   453,     0,   454,   166,     0,
     455,     0,   456,   457,   458,   459,     0,   460,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   169,
       0,   469,   470,   471,     0,   171,     0,   172,     0,     0,
       0,     0,   472,     0,   473,   474,   475,   476,   477,     0,
     176,     0,   478,     0,     0,   479,   480,   481,     0,     0,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   183,     0,   185,     0,   493,   494,   495,   496,   497,
     498,   499,   186,   500,     0,   501,   502,     0,   503,     0,
     189,   190,   504,   505,     0,     0,   506,     0,     0,     0,
     507,   508,     0,     0,   191,     0,     0,   194,   509,   510,
     511,   512,     0,   195,   196,   513,   514,   515,     0,   516,
     517,   518,   519,   520,   521,   198,   522,   523,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,     0,   533,
     534,     0,   535,   536,   206,   537,   538,   539,   540,   541,
     542,     0,     0,   543,   544,   545,     0,   546,   210,   547,
     548,     0,   549,   213,     0,   550,   551,   552,   553,   554,
     555,   556,   557,   215,   558,     0,   559,   560,     0,   561,
     562,   563,   564,     0,   216,   217,     0,     0,   566,   218,
     567,   219,     0,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,   576,     0,     0,   577,   578,     0,   579,
     227,   580,     0,   581,     0,     0,     0,   582,   583,   584,
     585,   586,   587,     0,     0,     0,   229,    49,     0,   230,
     588,     0,     0,     0,     0,    52,    81,    82,    83,   372,
      85,    86,     0,    87,    88,    89,   373,     0,   374,     0,
      93,     0,    95,    96,    97,    98,    99,   100,     0,   101,
     102,   103,   375,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   116,
     376,   377,     0,     0,     0,   378,   379,     0,     0,     0,
       0,   380,     0,     0,     0,     0,     0,     0,     0,     0,
     381,     0,   382,     0,   383,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,     0,   393,   394,     0,     0,
       0,     0,     0,     0,     0,   395,   396,     0,   397,     0,
     398,   399,   400,     0,   134,     0,   136,     0,     0,   401,
     402,     0,   403,   404,     0,     0,   405,   406,   137,   407,
       0,   408,   409,   410,   411,   141,     0,     0,   412,   413,
     414,   415,   416,     0,   417,   418,   144,   419,     0,   420,
     421,   422,     0,   423,     0,     0,     0,     0,     0,   424,
     425,   426,   427,   428,   150,   151,   429,     0,   430,     0,
     431,     0,   432,   433,   434,     0,   435,     0,     0,   436,
     437,   438,   439,     0,   440,   441,   442,     0,   443,     0,
     444,   445,   446,   157,   447,     0,   159,     0,   448,   449,
     161,     0,   450,     0,   451,     0,     0,     0,   452,     0,
     453,     0,   454,   166,     0,   455,     0,   456,   457,   458,
     459,     0,   460,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   169,     0,   469,   470,   471,     0,
     171,     0,   172,     0,     0,     0,     0,   472,     0,   473,
     474,   475,   476,   477,     0,   176,     0,   478,     0,     0,
     479,   480,   481,     0,     0,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   183,     0,   185,     0,
     493,   494,   495,   496,   497,   498,   499,   186,   500,     0,
     501,   502,     0,   503,     0,   189,   190,   504,   505,     0,
       0,   506,     0,     0,     0,   507,   508,     0,     0,   191,
       0,     0,   194,   509,   510,   511,   512,     0,   195,   196,
     513,   514,   515,     0,   516,   517,   518,   519,   520,   521,
     198,   522,   523,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,     0,   533,   534,     0,   535,   536,   206,
     537,   538,   539,   540,   541,   542,     0,     0,   543,   544,
     545,     0,   546,   210,   547,   548,     0,   549,   213,     0,
     550,   551,   552,   553,   554,   555,   556,   557,   215,   558,
       0,   559,   560,     0,   561,   562,   563,   564,     0,   216,
     217,     0,     0,   566,   218,   567,   219,     0,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,   576,     0,
       0,   577,   578,     0,   579,   227,   580,     0,   581,     0,
       0,     0,   582,   583,   584,   585,   586,   587,     0,     0,
       0,   229,    49,     0,   230,   588,     0,     0,     0,     0,
      52,    81,    82,    83,   372,    85,    86,     0,    87,    88,
      89,   373,     0,   374,     0,    93,     0,    95,    96,    97,
      98,    99,   100,     0,   101,   102,   103,   375,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   116,   376,   377,     0,     0,     0,
     378,   379,     0,     0,     0,     0,   380,     0,     0,     0,
       0,     0,     0,     0,     0,   381,     0,   382,     0,   383,
     384,     0,   385,   386,   387,   388,   389,   390,   391,   392,
       0,   393,   394,     0,     0,     0,     0,     0,     0,     0,
     395,   396,     0,   397,     0,   398,   399,   400,     0,   134,
       0,   136,     0,     0,   401,   402,     0,   403,   404,     0,
       0,   405,   406,   137,   407,     0,   408,   409,   410,   411,
     141,     0,     0,   412,   413,   414,   415,   416,     0,   417,
     418,   144,   419,     0,   420,   421,   422,     0,   423,     0,
       0,     0,     0,     0,   424,   425,   426,   427,   428,   150,
     151,   429,     0,   430,     0,   431,     0,   432,   433,   434,
       0,   435,     0,     0,   436,   437,   438,   439,     0,   440,
     441,   442,     0,   443,     0,   444,   445,   446,   157,   447,
       0,   159,     0,   448,   449,   161,     0,   450,     0,   451,
       0,     0,     0,   452,     0,   453,     0,   454,   166,     0,
     455,     0,   456,   457,   458,   459,     0,   460,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   169,
       0,   469,   470,   471,     0,   171,     0,   172,     0,     0,
       0,     0,   472,     0,   473,   474,   475,   476,   477,     0,
     176,     0,   478,     0,     0,   479,   480,   481,     0,     0,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   183,     0,   185,     0,   493,   494,   495,   496,   497,
     498,   499,   186,   500,     0,   501,   502,     0,   503,     0,
     189,   190,   504,   505,     0,     0,   506,     0,     0,     0,
     507,   508,     0,     0,   191,     0,     0,   194,   509,   510,
     511,   512,     0,   195,   196,   513,   514,   515,     0,   516,
     517,   518,   519,   520,   521,   198,   522,   523,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,     0,   533,
     534,     0,   535,   536,   206,   537,   538,   539,   540,   541,
     542,     0,     0,   543,   544,   545,     0,   546,   210,   547,
     548,     0,   549,   213,     0,   550,   551,   552,   553,   554,
     555,   556,   557,   215,   558,     0,   559,   560,     0,   561,
     562,   563,   564,     0,   216,   217,     0,     0,   566,   218,
     567,   219,     0,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,   576,     0,     0,   577,   578,     0,   579,
     227,   580,     0,   581,     0,     0,     0,   582,   583,   584,
     585,   586,   587,     0,     0,     0,   229,     0,     0,   230,
       0,   904,  1594,    81,    82,    83,   372,    85,    86,     0,
      87,    88,    89,   373,   905,   374,     0,    93,     0,    95,
      96,    97,    98,    99,   100,     0,   101,   102,   103,   375,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   116,   376,   377,     0,
       0,     0,   378,   379,     0,     0,     0,     0,   380,     0,
       0,     0,     0,     0,     0,     0,     0,   381,     0,   382,
       0,   383,   384,     0,   385,   386,   387,   388,   389,   390,
     391,   392,     0,   393,   394,     0,     0,     0,     0,     0,
       0,     0,   395,   396,     0,   397,     0,   398,   399,   400,
       0,   134,     0,   136,     0,     0,   401,   402,     0,   403,
     404,     0,     0,   405,   882,   137,   407,     0,   408,   409,
     410,   411,   141,     0,     0,   412,   413,   414,   415,   906,
       0,   907,   418,   144,   419,     0,   420,   421,   422,     0,
     423,     0,     0,     0,     0,     0,   424,   425,   426,   427,
     428,   150,   151,   429,     0,   430,     0,   431,     0,   432,
     433,   434,     0,   435,     0,     0,   436,   437,   438,   439,
       0,   440,   441,   442,     0,   443,     0,   444,   445,   446,
     157,   447,     0,   159,     0,   448,   449,   161,     0,   450,
       0,   451,     0,     0,     0,   452,     0,   453,     0,   454,
     166,     0,   455,     0,   456,   457,   458,   459,     0,   460,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   169,     0,   469,   470,   471,     0,   171,     0,   172,
       0,     0,     0,     0,   472,     0,   473,   474,   475,   476,
     477,     0,   176,     0,   478,     0,     0,   479,   480,   908,
       0,     0,   482,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   909,   183,     0,   185,     0,   493,   494,   495,
     496,   497,   498,   499,   186,   500,     0,   501,   502,     0,
     503,     0,   189,   190,   504,   505,     0,     0,   506,     0,
       0,     0,   507,   508,     0,     0,   191,     0,     0,   194,
     509,   510,   511,   512,     0,   195,   196,   513,   514,   515,
       0,   516,   517,   518,   519,   520,   521,   198,   522,   523,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
       0,   533,   534,     0,   910,   536,   206,   537,   538,   539,
     540,   541,   542,     0,     0,   543,   544,   911,     0,   546,
     210,   547,   548,     0,   549,   213,     0,   550,   551,   552,
     553,   554,   555,   556,   557,   215,   558,     0,   559,   560,
       0,   561,   562,   563,   564,     0,   912,   217,     0,     0,
     913,   218,   567,   219,     0,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,   576,     0,     0,   577,   578,
       0,   886,   227,   580,     0,   581,     0,     0,     0,   582,
     583,   584,   585,   586,   587,    81,    82,    83,   229,    85,
      86,   230,    87,    88,    89,     0,     0,     0,    92,    93,
       0,    95,    96,    97,    98,    99,   100,     0,   101,   102,
     103,     0,     0,     0,   105,   106,   107,   108,     0,   109,
       0,   110,   111,   112, -1415,   113,   114,   115,   116,     0,
       0,     0,     0,     0,   119,   120,     0,     0,     0,     0,
     121,     0,     0,     0,     0,     0,     0,     0,     0,   122,
       0,   123,     0,   124,   125,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   131,     0,
       0,     0,   133,   134,   135,   136,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   137,     0,     0,
       0,     0,     0,     0,   141,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   144,     0,     0,     0,     0,
       0,   147,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   150,   151,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   157,     0,     0,   159,     0,     0,     0,   161,
       0,     0,     0,     0,   162,     0,   163,     0,     0,     0,
       0,     0,   166,     0,     0,     0,     0,     0,     0,     0,
     167,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   168,   169,     0,     0,     0,     0,     0,   171,
       0,   172,     0,     0,   173,   174,     0,   175,     0,     0,
       0,     0,     0,     0,   176,   177,     0,   178,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   183,   184,   185,     0,     0,
       0,     0,     0,     0,     0,     0,   186,     0,     0,     0,
       0,   188,     0,     0,   189,   190,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   191,   192,
     193,   194,     0,     0,     0,     0,     0,   195,   196,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   198,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   204,     0,     0,   206,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   210,     0,     0,   212,     0,   213,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   215,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   216,   217,
       0,     0,     0,   218,     0,   219,     0,     0,     0,     0,
       0,     0,   222,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   227,     0,   228,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     229,     0,     0,   230,     0,   363,    81,    82,    83,     0,
      85,    86,     0,    87,    88,    89,     0,     0,     0,    92,
      93,     0,    95,    96,    97,    98,    99,   100,     0,   101,
     102,   103,     0,     0,     0,   105,   106,   107,   108,     0,
     109,     0,   110,   111,   112, -1416,   113,   114,   115,   116,
       0,     0,     0,     0,     0,   119,   120,     0,     0,     0,
       0,   121,     0,     0,     0,     0,     0,     0,     0,     0,
     122,     0,   123,     0,   124,   125,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   131,
       0,     0,     0,   133,   134,   135,   136,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   137,     0,
       0,     0,     0,     0,     0,   141,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   144,     0,     0,     0,
       0,     0,   147,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   150,   151,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   157,     0,     0,   159,     0,     0,     0,
     161,     0,     0,     0,     0,   162,     0,   163,     0,     0,
       0,     0,     0,   166,     0,     0,     0,     0,     0,     0,
       0,   167,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   168,   169,     0,     0,     0,     0,     0,
     171,     0,   172,     0,     0,   173,   174,     0,   175,     0,
       0,     0,     0,     0,     0,   176,   177,     0,   178,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   183,   184,   185,     0,
       0,     0,     0,     0,     0,     0,     0,   186,     0,     0,
       0,     0,   188,     0,     0,   189,   190,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   191,
     192,   193,   194,     0,     0,     0,     0,     0,   195,   196,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     198,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   204,     0,     0,   206,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   210,     0,     0,   212,     0,   213,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   215,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   216,
     217,     0,     0,     0,   218,     0,   219,     0,     0,     0,
       0,     0,     0,   222,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   227,     0,   228,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   229,     0,     0,   230,     0,   974,   619,    81,    82,
      83,   372,    85,    86,     0,    87,    88,    89,   373,     0,
     374,     0,    93,     0,    95,    96,    97,    98,    99,   100,
     620,   101,   102,   103,   375,   621,     0,   105,   106,   107,
     108,   622,   623,     0,   110,   111,   112,     0,   113,   624,
     625,   116,   376,   377,     0,     0,     0,   378,   379,     0,
       0,     0,     0,   380,     0,     0,     0,     0,     0,     0,
       0,     0,   381,     0,   382,     0,   383,   384,     0,   385,
     386,   387,   388,   389,   390,   391,   392,   626,   393,   394,
     627,   628,   629,   630,   631,   632,   633,   395,   396,   634,
     397,   131,   398,   399,   400,   133,   134,   135,   136,     0,
     635,   401,   402,     0,   403,   404,   636,   637,   405,   638,
     137,   407,   639,   408,   409,   410,   411,   141,   640,   641,
     412,   413,   414,   415,   416,   642,   417,   418,   144,   419,
     643,   420,   421,   422,   147,   423,   644,   645,   646,   647,
     648,   424,   425,   426,   427,   428,   150,   151,   429,   649,
     430,   650,   431,     0,   432,   433,   434,   651,   435,   652,
     653,   436,   437,   438,   439,   654,   440,   441,   442,   655,
     443,   656,   444,   445,   446,   157,   447,     0,   159,   657,
     448,   449,   161,   658,   450,   659,   451,   162,   660,   163,
     452,     0,   453,   661,   454,   166,   662,   455,   663,   456,
     457,   458,   459,   167,   460,   461,   462,   664,   463,   464,
     465,   466,   467,   468,   665,   168,   169,   666,   469,   470,
     471,   667,   171,   668,   172,   669,     0,   173,   174,   472,
     175,   473,   474,   475,   476,   477,   670,   176,   177,   478,
     178,   671,   479,   480,   481,     0,     0,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   183,   184,
     185,   672,   493,   494,   495,   496,   497,   498,   499,   186,
     500,   673,   501,   502,   188,   503,   674,   189,   190,   504,
     505,   675,   676,   506,   677,   678,   679,   507,   508,   680,
     681,   191,   192,   193,   194,   509,   510,   511,   512,     0,
     195,   196,   513,   514,   515,   682,   516,   517,   518,   519,
     520,   521,   198,   522,   523,   683,   524,   525,   526,   527,
     528,   529,   530,   531,   532,   684,   533,   534,   204,   535,
     536,   206,   537,   538,   539,   540,   541,   542,     0,   685,
     543,   544,   545,   686,   546,   210,   547,   548,   212,   549,
     213,   687,   550,   551,   552,   553,   554,   555,   556,   557,
     215,   558,   688,   559,   560,   689,   561,   562,   563,   564,
     690,   216,   217,   691,   692,   566,   218,   567,   219,   693,
     568,   569,   570,   571,   572,   694,   695,   573,   574,   575,
     576,   696,   697,   577,   578,     0,     0,   227,   580,   228,
     581,     0,   698,   699,   582,   583,   584,   585,   586,   587,
       0,     0,     0,   229,     0,     0,   230,   619,    81,    82,
      83,   372,    85,    86,     0,    87,    88,    89,   373,     0,
     374,     0,    93,     0,    95,    96,    97,    98,    99,   100,
     620,   101,   102,   103,   375,   621,     0,   105,   106,   107,
     108,   622,   623,     0,   110,   111,   112,     0,   113,   624,
     625,   116,   376,   377,     0,     0,     0,   378,   379,     0,
       0,     0,     0,   380,     0,     0,     0,     0,     0,     0,
       0,     0,   381,     0,   382,     0,   383,   384,     0,   385,
     386,   387,   388,   389,   390,   391,   392,     0,   393,   394,
       0,     0,     0,     0,     0,     0,     0,   395,   396,     0,
     397,   131,   398,   399,   400,   133,  1529,   135,  1530,  1211,
       0,   401,   402,     0,   403,   404,     0,     0,   405,  1531,
    1532,   407,     0,   408,   409,   410,   411,     0,     0,     0,
     412,   413,   414,   415,   416,     0,   417,   418,     0,   419,
       0,   420,   421,   422,   147,   423,     0,     0,     0,     0,
       0,   424,   425,   426,   427,   428,  1533,  1534,   429,     0,
     430,     0,   431,     0,   432,   433,   434,     0,   435,     0,
       0,   436,  1225,   438,   439,     0,   440,   441,   442,     0,
     443,     0,   444,   445,   446,     0,   447,     0,     0,     0,
     448,   449,  1535,     0,   450,     0,   451,   162,     0,   163,
     452,     0,   453,     0,   454,     0,     0,   455,     0,   456,
     457,   458,   459,   167,   460,   461,   462,  1942,   463,   464,
     465,   466,   467,   468,     0,   168,  1943,     0,   469,   470,
     471,  1231,  1536,     0,  1537,     0,     0,   173,   174,   472,
     175,   473,   474,   475,   476,   477,     0,     0,   177,   478,
     178,     0,   479,   480,   481,     0,     0,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,  1538,   184,
    1539,     0,   493,   494,   495,   496,   497,   498,   499,     0,
     500,     0,   501,   502,   188,   503,     0,     0,  1540,   504,
     505,     0,     0,   506,     0,     0,     0,   507,   508,     0,
       0,  1944,   192,   193,     0,   509,   510,   511,   512,     0,
       0,     0,   513,   514,   515,     0,   516,   517,   518,   519,
     520,   521,  1541,   522,   523,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,     0,   533,   534,   204,   535,
     536,     0,   537,   538,   539,   540,   541,   542,     0,     0,
     543,   544,   545,     0,   546,  1542,   547,   548,   212,   549,
    1543,     0,   550,   551,   552,   553,   554,   555,   556,   557,
       0,   558,     0,   559,   560,     0,   561,   562,   563,   564,
       0,  1544,  1545,     0,     0,   566,     0,   567,     0,     0,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
     576,     0,     0,   577,   578,     0,     0,  1546,   580,   228,
     581,     0,     0,     0,   582,   583,   584,   585,   586,   587,
       0,     0,     0,   229,     0,     0,   230,   619,    81,    82,
      83,   372,    85,    86,     0,    87,    88,    89,   373,     0,
     374,     0,    93,     0,    95,    96,    97,    98,    99,   100,
     620,   101,   102,   103,   375,   621,     0,   105,   106,   107,
     108,   622,   623,     0,   110,   111,   112,     0,   113,   624,
     625,   116,   376,   377,     0,     0,     0,   378,   379,     0,
       0,     0,     0,   380,     0,     0,     0,     0,     0,     0,
       0,     0,   381,     0,   382,     0,   383,   384,     0,   385,
     386,   387,   388,   389,   390,   391,   392,     0,   393,   394,
       0,     0,     0,     0,     0,     0,     0,   395,   396,     0,
     397,   131,   398,   399,   400,   133,  1529,   135,  1530,  1211,
       0,   401,   402,     0,   403,   404,     0,     0,   405,  1531,
    1532,   407,     0,   408,   409,   410,   411,     0,     0,     0,
     412,   413,   414,   415,   416,     0,   417,   418,     0,   419,
       0,   420,   421,   422,   147,   423,     0,     0,     0,     0,
       0,   424,   425,   426,   427,   428,  1533,  1534,   429,     0,
     430,     0,   431,     0,   432,   433,   434,     0,   435,     0,
       0,   436,  1225,   438,   439,     0,   440,   441,   442,     0,
     443,     0,   444,   445,   446,     0,   447,     0,     0,     0,
     448,   449,  1535,     0,   450,     0,   451,   162,     0,   163,
     452,     0,   453,     0,   454,     0,     0,   455,     0,   456,
     457,   458,   459,   167,   460,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,   168,     0,     0,   469,   470,
     471,  1231,  1536,     0,  1537,     0,     0,   173,   174,   472,
     175,   473,   474,   475,   476,   477,     0,     0,   177,   478,
     178,     0,   479,   480,   481,     0,     0,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,  1538,   184,
    1539,     0,   493,   494,   495,   496,   497,   498,   499,     0,
     500,     0,   501,   502,   188,   503,     0,     0,  1540,   504,
     505,     0,     0,   506,     0,     0,     0,   507,   508,     0,
       0,     0,   192,   193,     0,   509,   510,   511,   512,     0,
       0,     0,   513,   514,   515,     0,   516,   517,   518,   519,
     520,   521,  1541,   522,   523,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,     0,   533,   534,   204,   535,
     536,     0,   537,   538,   539,   540,   541,   542,     0,     0,
     543,   544,   545,     0,   546,  1542,   547,   548,   212,   549,
    1543,     0,   550,   551,   552,   553,   554,   555,   556,   557,
       0,   558,     0,   559,   560,     0,   561,   562,   563,   564,
       0,  1544,  1545,     0,     0,   566,     0,   567,     0,     0,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
     576,     0,     0,   577,   578,     0,     0,  1546,   580,   228,
     581,     0,     0,     0,   582,   583,   584,   585,   586,   587,
       0,     0,     0,   229,     0,     0,   230,    81,    82,    83,
     372,    85,    86,     0,    87,    88,    89,   373,     0,   374,
       0,    93,     0,    95,    96,    97,    98,    99,   100,     0,
     101,   102,   103,   375,     0,     0,   105,   106,   107,   108,
       0,     0,  1407,   110,   111,   112,     0,   113,     0,     0,
     116,   376,   377,     0,     0,     0,   378,   379,     0,     0,
       0,     0,   380,     0,     0,     0,     0,     0,     0,     0,
       0,   381,     0,   382,     0,   383,   384,     0,   385,   386,
     387,   388,   389,   390,   391,   392,     0,   393,   394,     0,
       0,     0,     0,     0,     0,     0,   395,   396,     0,   397,
       0,   398,   399,   400,     0,   134,     0,   136,     0,     0,
     401,   402,     0,   403,   404,     0,     0,   405,   406,   137,
     407,     0,   408,   409,   410,   411,   141,     0,     0,   412,
     413,   414,   415,   416,     0,   417,   418,   144,   419,     0,
     420,   421,   422,     0,   423,     0,     0,     0,     0,     0,
     424,   425,   426,   427,   428,   150,   151,   429,     0,   430,
       0,   431,     0,   432,   433,   434,     0,   435,     0,     0,
     436,   437,   438,   439,     0,   440,   441,   442,     0,   443,
       0,   444,   445,   446,   157,   447,     0,   159,     0,   448,
     449,   161,     0,   450,     0,   451,     0,     0,     0,   452,
       0,  2320,     0,   454,   166,     0,   455,     0,   456,   457,
     458,   459,     0,   460,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   169,     0,   469,   470,   471,
       0,   171,     0,   172,     0,     0,     0,     0,   472,     0,
     473,   474,   475,   476,   477,     0,   176,     0,   478,     0,
       0,   479,   480,  2321,     0,     0,   482,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   183,     0,   185,
     749,   493,   494,   495,   496,   497,   498,   499,   186,   500,
       0,   501,   502,     0,   503,     0,   189,   190,   504,   505,
       0,     0,   506,   750,     0,     0,   507,   508,     0,     0,
     191,     0,     0,   194,   509,   510,   511,   512,     0,   195,
     196,   513,   514,   515,     0,   516,   517,   518,   519,   520,
     521,   198,   522,   523,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,     0,   533,   534,     0,   535,   536,
     206,   537,   538,   539,   540,   541,   542,     0,     0,   543,
     544,   545,     0,   546,   210,   547,   548,     0,   549,   213,
       0,   550,   551,   552,   553,   554,   555,   556,   557,   215,
     558,     0,   559,   560,  2322,   561,  2323,   563,  2324,     0,
     216,   217,     0,     0,   566,   218,   567,   219,     0,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,   576,
       0,     0,   577,   578,     0,   579,   227,   580,     0,   581,
       0,     0,     0,   582,   583,   584,   585,   586,   587,     0,
       0,     0,   229,     0,     0,   230,   588,    81,    82,    83,
     372,    85,    86,   610,    87,    88,    89,   373,     0,   374,
       0,    93,     0,    95,    96,    97,    98,    99,   100,     0,
     101,   102,   103,   375,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     116,   376,   377,     0,     0,     0,   378,   379,     0,     0,
       0,     0,   380,     0,     0,     0,     0,     0,     0,     0,
       0,   381,     0,   382,     0,   383,   384,     0,   385,   386,
     387,   388,   389,   390,   391,   392,   611,   393,   394,     0,
       0,     0,     0,     0,     0,     0,   395,   396,     0,   397,
       0,   398,   399,   400,     0,   134,     0,   136,     0,     0,
     401,   402,     0,   403,   404,     0,     0,   405,   406,   137,
     407,     0,   408,   409,   410,   411,   141,     0,     0,   412,
     413,   414,   415,   416,     0,   417,   418,   144,   419,     0,
     420,   421,   422,     0,   423,     0,     0,     0,     0,     0,
     424,   425,   426,   427,   428,   150,   151,   429,   612,   430,
       0,   431,     0,   432,   433,   434,     0,   435,     0,     0,
     436,   437,   438,   439,     0,   440,   441,   442,     0,   443,
       0,   444,   445,   446,   157,   447,     0,   159,     0,   448,
     449,   161,     0,   450,     0,   451,     0,     0,     0,   452,
       0,   453,     0,   454,   166,     0,   455,     0,   456,   457,
     458,   459,     0,   460,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   169,     0,   469,   470,   471,
       0,   171,     0,   172,     0,     0,     0,     0,   472,     0,
     473,   474,   475,   476,   477,     0,   176,     0,   478,     0,
       0,   479,   480,   481,     0,     0,   482,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   183,     0,   185,
       0,   493,   494,   495,   496,   497,   498,   499,   186,   500,
       0,   501,   502,     0,   503,     0,   189,   190,   504,   505,
       0,     0,   506,     0,     0,     0,   507,   508,     0,     0,
     191,     0,     0,   194,   509,   510,   511,   512,     0,   195,
     196,   513,   514,   515,     0,   516,   517,   518,   519,   520,
     521,   198,   522,   523,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,     0,   533,   534,     0,   535,   536,
     206,   537,   538,   539,   540,   541,   542,     0,     0,   543,
     544,   545,     0,   546,   210,   547,   548,     0,   549,   213,
       0,   550,   551,   552,   553,   554,   555,   556,   557,   215,
     558,     0,   559,   560,     0,   561,   562,   563,   564,     0,
     216,   217,     0,     0,   566,   218,   567,   219,     0,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,   576,
       0,     0,   577,   578,     0,   579,   227,   580,     0,   581,
       0,     0,     0,   582,   583,   584,   585,   586,   587,     0,
       0,     0,   229,     0,     0,   230,   588,    81,    82,    83,
     372,    85,    86,     0,    87,    88,    89,   373,     0,   374,
       0,    93,     0,    95,    96,    97,    98,    99,   100,     0,
     101,   102,   103,   375,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     116,   376,   377,     0,     0,     0,   378,   379,     0,     0,
       0,     0,   380,     0,     0,     0,     0,     0,     0,     0,
       0,   381,     0,   382,     0,   383,   384,     0,   385,   386,
     387,   388,   389,   390,   391,   392,     0,   393,   394,     0,
       0,     0,     0,     0,     0,     0,   395,   396,     0,   397,
       0,   398,   399,   400,     0,   134,     0,   136,     0,     0,
     401,   402,     0,   403,   404,     0,     0,   405,   406,   137,
     407,     0,   408,   409,   410,   411,   141,     0,     0,   412,
     413,   414,   415,   416,     0,   417,   418,   144,   419,     0,
     420,   421,   422,     0,   423,     0,     0,     0,     0,     0,
     424,   425,   426,   427,   428,   150,   151,   429,   612,   430,
       0,   431,     0,   432,   433,   434,     0,   435,     0,     0,
     436,   437,   438,   439,     0,   440,   441,   442,     0,   443,
       0,   444,   445,   446,   157,   447,     0,   159,     0,   448,
     449,   161,     0,   450,     0,   451,     0,     0,     0,   452,
       0,   453,     0,   454,   166,     0,   455,     0,   456,   457,
     458,   459,     0,   460,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   169,     0,   469,   470,   471,
       0,   171,     0,   172,     0,     0,     0,     0,   472,     0,
     473,   474,   475,   476,   477,     0,   176,     0,   478,     0,
       0,   479,   480,   481,     0,     0,   482,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   183,     0,   185,
       0,   493,   494,   495,   496,   497,   498,   499,   186,   500,
       0,   501,   502,     0,   503,     0,   189,   190,   504,   505,
       0,     0,   506,     0,     0,     0,   507,   508,     0,     0,
     191,     0,     0,   194,   509,   510,   511,   512,     0,   195,
     196,   513,   514,   515,     0,   516,   517,   518,   519,   520,
     521,   198,   522,   523,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,     0,   533,   534,     0,   535,   536,
     206,   537,   538,   539,   540,   541,   542,     0,     0,   543,
     544,   545,     0,   546,   210,   547,   548,     0,   549,   213,
       0,   550,   551,   552,   553,   554,   555,   556,   557,   215,
     558,     0,   559,   560,     0,   561,   562,   563,   564,     0,
     216,   217,     0,     0,   566,   218,   567,   219,     0,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,   576,
       0,     0,   577,   578,     0,   579,   227,   580,     0,   581,
       0,     0,     0,   582,   583,   584,   585,   586,   587,     0,
       0,     0,   229,     0,     0,   230,   588,    81,    82,    83,
     372,    85,    86,     0,    87,    88,    89,   373,   796,   374,
       0,    93,     0,    95,    96,    97,    98,    99,   100,     0,
     101,   102,   103,   375,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     116,   376,   377,     0,     0,     0,   378,   379,     0,     0,
       0,     0,   380,     0,     0,     0,     0,     0,     0,     0,
       0,   381,     0,   382,     0,   383,   384,     0,   385,   386,
     387,   388,   389,   390,   391,   392,     0,   393,   394,     0,
       0,     0,     0,     0,     0,     0,   395,   396,     0,   397,
       0,   398,   399,   400,     0,   134,     0,   136,     0,     0,
     401,   402,     0,   403,   404,     0,     0,   405,   406,   137,
     407,     0,   408,   409,   410,   411,   141,     0,     0,   412,
     413,   414,   415,   416,     0,   417,   418,   144,   419,     0,
     420,   421,   422,     0,   423,     0,     0,     0,     0,     0,
     424,   425,   426,   427,   428,   150,   151,   429,     0,   430,
       0,   431,     0,   432,   433,   434,     0,   435,     0,     0,
     436,   437,   438,   439,     0,   440,   441,   442,     0,   443,
       0,   444,   445,   446,   157,   447,     0,   159,     0,   448,
     449,   161,     0,   450,     0,   451,     0,     0,     0,   452,
       0,   453,     0,   454,   166,     0,   455,     0,   456,   457,
     458,   459,     0,   460,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   169,     0,   469,   470,   471,
       0,   171,     0,   172,     0,     0,     0,     0,   472,     0,
     473,   474,   475,   476,   477,     0,   176,     0,   478,     0,
       0,   479,   480,   481,     0,     0,   482,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   183,     0,   185,
       0,   493,   494,   495,   496,   497,   498,   499,   186,   500,
       0,   501,   502,     0,   503,     0,   189,   190,   504,   505,
       0,     0,   506,     0,     0,     0,   507,   508,     0,     0,
     191,     0,     0,   194,   509,   510,   511,   512,     0,   195,
     196,   513,   797,   515,     0,   516,   517,   518,   519,   520,
     521,   198,   522,   523,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,     0,   533,   534,     0,   535,   536,
     206,   537,   538,   539,   540,   541,   542,     0,     0,   543,
     544,   545,     0,   546,   210,   547,   548,     0,   549,   213,
       0,   550,   551,   552,   553,   554,   555,   556,   557,   215,
     558,     0,   559,   560,     0,   561,   562,   563,   564,     0,
     216,   217,     0,     0,   566,   218,   567,   219,     0,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,   576,
       0,     0,   577,   578,     0,   579,   227,   580,     0,   581,
       0,     0,     0,   582,   583,   584,   585,   586,   587,     0,
       0,     0,   229,     0,     0,   230,   588,    81,    82,    83,
     372,    85,    86,     0,    87,    88,    89,   373,     0,   374,
       0,    93,     0,    95,    96,    97,    98,    99,   100,     0,
     101,   102,   103,   375,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     116,   376,   377,     0,     0,     0,   378,   379,     0,     0,
       0,     0,   380,     0,     0,     0,     0,     0,     0,     0,
       0,   381,     0,   382,     0,   383,   384,     0,   385,   386,
     387,   388,   389,   390,   391,   392,     0,   393,   394,     0,
       0,     0,     0,     0,     0,     0,   395,   396,     0,   397,
       0,   398,   399,   400,     0,   134,     0,   136,     0,     0,
     401,   402,     0,   403,   404,     0,     0,   405,   406,   137,
     407,     0,   408,   409,   410,   411,   141,     0,     0,   412,
     413,   414,   415,   416,     0,   417,   418,   144,   419,     0,
     420,   421,   422,     0,   423,     0,     0,     0,     0,     0,
     424,   425,   426,   427,   428,   150,   151,   429,     0,   430,
       0,   431,     0,   432,   433,   434,     0,   435,     0,     0,
     436,   437,   438,   439,     0,   440,   441,   442,     0,   443,
       0,   444,   445,   446,   157,   447,     0,   159,     0,   448,
     449,   161,     0,   450,     0,   451,     0,     0,     0,   452,
       0,   453,     0,   454,   166,     0,   455,     0,   456,   457,
     458,   459,     0,   829,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   169,     0,   469,   470,   471,
       0,   171,     0,   172,     0,     0,     0,     0,   472,     0,
     473,   474,   475,   476,   477,     0,   176,     0,   478,     0,
       0,   479,   480,   481,     0,     0,   482,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   183,     0,   185,
       0,   493,   494,   495,   496,   497,   498,   499,   186,   500,
       0,   501,   502,     0,   503,     0,   189,   190,   504,   505,
       0,     0,   506,     0,     0,     0,   507,   508,     0,     0,
     191,     0,     0,   194,   509,   510,   511,   512,     0,   195,
     196,   513,   514,   515,     0,   516,   517,   518,   519,   520,
     521,   198,   522,   523,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,     0,   533,   534,     0,   535,   536,
     206,   537,   538,   539,   540,   541,   542,     0,     0,   543,
     544,   545,     0,   546,   210,   547,   548,     0,   549,   213,
       0,   550,   551,   552,   553,   554,   555,   556,   557,   215,
     558,     0,   559,   560,     0,   561,   562,   563,   564,     0,
     216,   217,     0,     0,   566,   218,   567,   219,     0,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,   576,
       0,     0,   577,   578,     0,   579,   227,   580,     0,   581,
       0,     0,     0,   582,   583,   584,   585,   586,   587,     0,
       0,     0,   229,     0,     0,   230,   588,    81,    82,    83,
     372,    85,    86,     0,    87,    88,    89,   373,     0,   374,
       0,    93,     0,    95,    96,    97,    98,    99,   100,     0,
     101,   102,   103,   375,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     116,   376,   377,     0,     0,     0,   378,   379,     0,     0,
       0,     0,   380,     0,     0,     0,     0,     0,     0,     0,
       0,   381,     0,   382,     0,   383,   384,     0,   385,   386,
     387,   388,   389,   390,   391,   392,     0,   393,   394,     0,
       0,     0,     0,     0,     0,     0,   395,   396,     0,   397,
       0,   398,   399,   400,     0,   134,     0,   136,     0,     0,
     401,   402,     0,   403,   404,     0,     0,   405,   406,   137,
     407,     0,   408,   409,   410,   411,   141,     0,     0,   412,
     413,   414,   415,   416,     0,   417,   418,   144,   419,     0,
     420,   421,   422,     0,   423,     0,     0,     0,     0,     0,
     424,   425,   426,   427,   428,   150,   151,   429,     0,   430,
       0,   431,     0,   432,   433,   434,     0,   435,     0,     0,
     436,   437,   438,   439,     0,   440,   441,   442,     0,   443,
       0,   444,   445,   446,   157,   447,     0,   159,     0,   448,
     449,   161,     0,   450,     0,   451,     0,     0,     0,   452,
       0,   453,     0,   454,   166,     0,   455,     0,   456,   457,
     458,   459,     0,   460,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   169,     0,   469,   470,   471,
       0,   171,     0,   172,     0,     0,     0,     0,   472,     0,
     473,   474,   475,   476,   477,     0,   176,     0,   478,     0,
       0,   479,   480,   481,     0,     0,   482,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   183,     0,   185,
       0,   493,   494,   495,   496,   497,   498,   499,   186,   500,
       0,   501,   502,     0,   503,     0,   189,   190,   504,   505,
       0,     0,   506,     0,     0,     0,   507,   508,     0,     0,
     191,     0,     0,   194,   509,   510,   511,   512,     0,   195,
     196,   513,   514,   515,     0,   516,   517,   518,   519,   520,
     521,   198,   522,   523,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,     0,   533,   534,     0,   535,   536,
     206,   537,   538,   539,   540,   541,   542,     0,     0,   543,
     544,   545,     0,   546,   210,   547,   548,     0,   549,   213,
       0,   550,   551,   552,   553,   554,   555,   556,   557,   215,
     558,     0,   559,   560,     0,   561,   562,   563,   564,     0,
     216,   217,     0,     0,   871,   218,   567,   219,     0,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,   576,
       0,     0,   577,   578,     0,   579,   227,   580,     0,   581,
       0,     0,     0,   582,   583,   584,   585,   586,   587,     0,
       0,     0,   229,     0,     0,   230,   588,    81,    82,    83,
     372,    85,    86,     0,    87,    88,    89,   373,     0,   374,
       0,    93,     0,    95,    96,    97,    98,    99,   100,     0,
     101,   102,   103,   375,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     116,   376,   377,     0,     0,     0,   378,   379,     0,     0,
       0,     0,   380,     0,     0,     0,     0,     0,     0,     0,
       0,   381,     0,   382,     0,   383,   384,     0,   385,   386,
     387,   388,   389,   390,   391,   392,     0,   393,   394,     0,
       0,     0,     0,     0,     0,     0,   395,   396,     0,   397,
       0,   398,   399,   400,     0,   134,     0,   136,     0,     0,
     401,   402,     0,   403,   404,     0,     0,   405,   406,   137,
     407,     0,   408,   409,   410,   411,   141,     0,     0,   412,
     413,   414,   415,   416,     0,   417,   418,   144,   419,     0,
     420,   421,   422,     0,   423,     0,     0,     0,     0,     0,
     424,   425,   426,   427,   428,   150,   151,   429,     0,   430,
       0,   431,     0,   432,   433,   434,     0,   435,     0,     0,
     436,   437,   438,   439,     0,   440,   441,   442,     0,   443,
       0,   444,   445,   446,   157,   447,     0,   159,     0,   448,
     449,   161,     0,   450,     0,   451,     0,     0,     0,   452,
       0,   453,     0,   454,   166,     0,   455,     0,   456,   457,
     458,   459,     0,   460,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   169,     0,   469,   470,   471,
       0,   171,     0,   172,     0,     0,     0,     0,   472,     0,
     473,   474,   475,   476,   477,     0,   176,     0,   478,     0,
       0,   479,   480,   481,     0,     0,   482,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   183,     0,   185,
       0,   493,   494,   495,   496,   497,   498,   499,   186,   500,
       0,   501,   502,     0,   503,     0,   189,   190,   504,   505,
       0,     0,   506,     0,     0,     0,   507,   508,     0,     0,
     191,     0,     0,   194,   509,   510,   511,   512,     0,   195,
     196,   513,   514,   515,     0,   516,   517,   518,   519,   520,
     521,   198,   522,   523,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,     0,   533,   534,     0,   535,   536,
     206,   537,   538,   539,   540,   541,   542,     0,     0,   543,
     544,   545,     0,   546,   210,   547,   548,     0,   549,   213,
       0,   550,   551,   552,   553,   554,   555,   556,   557,   215,
     558,     0,   559,   560,     0,   561,   562,   563,   564,     0,
     216,   217,     0,     0,   566,   218,   567,   219,     0,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,   576,
       0,     0,   577,   578,     0,   579,   227,   580,     0,   581,
       0,     0,     0,   582,   583,   584,   585,   586,   587,     0,
       0,     0,   229,     0,     0,   230,   588,   619,    81,    82,
      83,   372,    85,    86,     0,    87,    88,    89,   373,     0,
     374,     0,    93,     0,    95,    96,    97,    98,    99,   100,
     620,   101,   102,   103,   375,   621,     0,   105,   106,   107,
     108,   622,   623,     0,   110,   111,   112,     0,   113,   624,
     625,   116,   376,   377,     0,     0,     0,   378,   379,     0,
       0,     0,     0,   380,     0,     0,     0,     0,     0,     0,
       0,     0,   381,     0,   382,     0,   383,   384,     0,   385,
     386,   387,   388,   389,   390,   391,   392,     0,   393,   394,
       0,     0,     0,     0,     0,     0,     0,   395,   396,     0,
     397,     0,   398,   399,   400,     0,  1529,     0,  1530,  1211,
       0,   401,   402,     0,   403,   404,     0,     0,   405,  1531,
    1532,   407,     0,   408,   409,   410,   411,     0,     0,     0,
     412,   413,   414,   415,   416,     0,   417,   418,     0,   419,
       0,   420,   421,   422,     0,   423,     0,     0,     0,     0,
       0,   424,   425,   426,   427,   428,  1533,  1534,   429,     0,
     430,     0,   431,     0,   432,   433,   434,     0,   435,     0,
       0,   436,  1225,   438,   439,     0,   440,   441,   442,     0,
     443,     0,   444,   445,   446,     0,   447,     0,     0,     0,
     448,   449,  1535,     0,   450,     0,   451,     0,     0,     0,
     452,     0,   453,     0,   454,     0,     0,   455,     0,   456,
     457,   458,   459,     0,   460,   461,   462,  1942,   463,   464,
     465,   466,   467,   468,     0,     0,  1943,     0,   469,   470,
     471,  1231,  1536,     0,  1537,     0,     0,     0,     0,   472,
       0,   473,   474,   475,   476,   477,     0,     0,     0,   478,
       0,     0,   479,   480,   481,     0,     0,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,  1538,     0,
    1539,     0,   493,   494,   495,   496,   497,   498,   499,     0,
     500,     0,   501,   502,     0,   503,     0,     0,  1540,   504,
     505,     0,     0,   506,     0,     0,     0,   507,   508,     0,
       0,  1944,     0,     0,     0,   509,   510,   511,   512,     0,
       0,     0,   513,   514,   515,     0,   516,   517,   518,   519,
     520,   521,  1541,   522,   523,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,     0,   533,   534,     0,   535,
     536,     0,   537,   538,   539,   540,   541,   542,     0,     0,
     543,   544,   545,     0,   546,  1542,   547,   548,     0,   549,
    1543,     0,   550,   551,   552,   553,   554,   555,   556,   557,
       0,   558,     0,   559,   560,     0,   561,   562,   563,   564,
       0,  1544,  1545,     0,     0,   566,     0,   567,     0,     0,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
     576,     0,     0,   577,   578,     0,     0,  1546,   580,     0,
     581,     0,     0,     0,   582,   583,   584,   585,   586,   587,
       0,     0,     0,   229,     0,     0,   230,   619,    81,    82,
      83,   372,    85,    86,     0,    87,    88,    89,   373,     0,
     374,     0,    93,     0,    95,    96,    97,    98,    99,   100,
     620,   101,   102,   103,   375,   621,     0,   105,   106,   107,
     108,   622,   623,     0,   110,   111,   112,     0,   113,   624,
     625,   116,   376,   377,     0,     0,     0,   378,   379,     0,
       0,     0,     0,   380,     0,     0,     0,     0,     0,     0,
       0,     0,   381,     0,   382,     0,   383,   384,     0,   385,
     386,   387,   388,   389,   390,   391,   392,     0,   393,   394,
       0,     0,     0,     0,     0,     0,     0,   395,   396,     0,
     397,     0,   398,   399,   400,     0,  1529,     0,  1530,  1211,
       0,   401,   402,     0,   403,   404,     0,     0,   405,  1531,
    1532,   407,     0,   408,   409,   410,   411,     0,     0,     0,
     412,   413,   414,   415,   416,     0,   417,   418,     0,   419,
       0,   420,   421,   422,     0,   423,     0,     0,     0,     0,
       0,   424,   425,   426,   427,   428,  1533,  1534,   429,     0,
     430,     0,   431,     0,   432,   433,   434,     0,   435,     0,
       0,   436,  1225,   438,   439,     0,   440,   441,   442,     0,
     443,     0,   444,   445,   446,     0,   447,     0,     0,     0,
     448,   449,  1535,     0,   450,     0,   451,     0,     0,     0,
     452,     0,   453,     0,   454,     0,     0,   455,     0,   456,
     457,   458,   459,     0,   460,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,     0,     0,   469,   470,
     471,  1231,  1536,     0,  1537,     0,     0,     0,     0,   472,
       0,   473,   474,   475,   476,   477,     0,     0,     0,   478,
       0,     0,   479,   480,   481,     0,     0,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,  1538,     0,
    1539,     0,   493,   494,   495,   496,   497,   498,   499,  1971,
     500,     0,   501,   502,     0,   503,     0,     0,  1540,   504,
     505,     0,     0,   506,     0,     0,     0,   507,   508,     0,
       0,     0,     0,     0,     0,   509,   510,   511,   512,     0,
       0,     0,   513,   514,   515,     0,   516,   517,   518,   519,
     520,   521,  1541,   522,   523,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,     0,   533,   534,     0,   535,
     536,     0,   537,   538,   539,   540,   541,   542,     0,     0,
     543,   544,   545,     0,   546,  1542,   547,   548,     0,   549,
    1543,     0,   550,   551,   552,   553,   554,   555,   556,   557,
       0,   558,     0,   559,   560,     0,   561,   562,   563,   564,
       0,  1544,  1545,     0,     0,   566,     0,   567,     0,     0,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
     576,     0,     0,   577,   578,     0,     0,  1546,   580,     0,
     581,     0,     0,     0,   582,   583,   584,   585,   586,   587,
       0,     0,     0,   229,     0,     0,   230,   619,    81,    82,
      83,   372,    85,    86,     0,    87,    88,    89,   373,     0,
     374,     0,    93,     0,    95,    96,    97,    98,    99,   100,
     620,   101,   102,   103,   375,   621,     0,   105,   106,   107,
     108,   622,   623,     0,   110,   111,   112,     0,   113,   624,
     625,   116,   376,   377,     0,     0,     0,   378,   379,     0,
       0,     0,     0,   380,     0,     0,     0,     0,     0,     0,
       0,     0,   381,     0,   382,     0,   383,   384,     0,   385,
     386,   387,   388,   389,   390,   391,   392,     0,   393,   394,
       0,     0,     0,     0,     0,     0,     0,   395,   396,     0,
     397,     0,   398,   399,   400,     0,  1529,     0,  1530,  1211,
       0,   401,   402,     0,   403,   404,     0,     0,   405,  1531,
    1532,   407,     0,   408,   409,   410,   411,     0,     0,     0,
     412,   413,   414,   415,   416,     0,   417,   418,     0,   419,
       0,   420,   421,   422,     0,   423,     0,     0,     0,     0,
       0,   424,   425,   426,   427,   428,  1533,  1534,   429,     0,
     430,     0,   431,     0,   432,   433,   434,     0,   435,     0,
       0,   436,  1225,   438,   439,     0,   440,   441,   442,     0,
     443,     0,   444,   445,   446,     0,   447,     0,     0,     0,
     448,   449,  1535,     0,   450,     0,   451,     0,     0,     0,
     452,     0,   453,     0,   454,     0,     0,   455,     0,   456,
     457,   458,   459,     0,   460,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,     0,     0,   469,   470,
     471,  1231,  1536,     0,  1537,     0,     0,     0,     0,   472,
       0,   473,   474,   475,   476,   477,     0,     0,     0,   478,
       0,     0,   479,   480,   481,     0,     0,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,  1538,     0,
    1539,     0,   493,   494,   495,   496,   497,   498,   499,  2832,
     500,     0,   501,   502,     0,   503,     0,     0,  1540,   504,
     505,     0,     0,   506,     0,     0,     0,   507,   508,     0,
       0,     0,     0,     0,     0,   509,   510,   511,   512,     0,
       0,     0,   513,   514,   515,     0,   516,   517,   518,   519,
     520,   521,  1541,   522,   523,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,     0,   533,   534,     0,   535,
     536,     0,   537,   538,   539,   540,   541,   542,     0,     0,
     543,   544,   545,     0,   546,  1542,   547,   548,     0,   549,
    1543,     0,   550,   551,   552,   553,   554,   555,   556,   557,
       0,   558,     0,   559,   560,     0,   561,   562,   563,   564,
       0,  1544,  1545,     0,     0,   566,     0,   567,     0,     0,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
     576,     0,     0,   577,   578,     0,     0,  1546,   580,     0,
     581,     0,     0,     0,   582,   583,   584,   585,   586,   587,
       0,     0,     0,   229,     0,     0,   230,   619,    81,    82,
      83,   372,    85,    86,     0,    87,    88,    89,   373,     0,
     374,     0,    93,     0,    95,    96,    97,    98,    99,   100,
     620,   101,   102,   103,   375,   621,     0,   105,   106,   107,
     108,   622,   623,     0,   110,   111,   112,     0,   113,   624,
     625,   116,   376,   377,     0,     0,     0,   378,   379,     0,
       0,     0,     0,   380,     0,     0,     0,     0,     0,     0,
       0,     0,   381,     0,   382,     0,   383,   384,     0,   385,
     386,   387,   388,   389,   390,   391,   392,     0,   393,   394,
       0,     0,     0,     0,     0,     0,     0,   395,   396,     0,
     397,     0,   398,   399,   400,     0,  1529,     0,  1530,  1211,
       0,   401,   402,     0,   403,   404,     0,     0,   405,  1531,
    1532,   407,     0,   408,   409,   410,   411,     0,     0,     0,
     412,   413,   414,   415,   416,     0,   417,   418,     0,   419,
       0,   420,   421,   422,     0,   423,     0,     0,     0,     0,
       0,   424,   425,   426,   427,   428,  1533,  1534,   429,     0,
     430,     0,   431,     0,   432,   433,   434,     0,   435,     0,
       0,   436,  1225,   438,   439,     0,   440,   441,   442,     0,
     443,     0,   444,   445,   446,     0,   447,     0,     0,     0,
     448,   449,  1535,     0,   450,     0,   451,     0,     0,     0,
     452,     0,   453,     0,   454,     0,     0,   455,     0,   456,
     457,   458,   459,     0,   460,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,     0,     0,   469,   470,
     471,  1231,  1536,     0,  1537,     0,     0,     0,     0,   472,
       0,   473,   474,   475,   476,   477,     0,     0,     0,   478,
       0,     0,   479,   480,   481,     0,     0,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,  1538,     0,
    1539,     0,   493,   494,   495,   496,   497,   498,   499,     0,
     500,     0,   501,   502,     0,   503,  1936,     0,  1540,   504,
     505,     0,     0,   506,     0,     0,     0,   507,   508,     0,
       0,     0,     0,     0,     0,   509,   510,   511,   512,     0,
       0,     0,   513,   514,   515,     0,   516,   517,   518,   519,
     520,   521,  1541,   522,   523,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,     0,   533,   534,     0,   535,
     536,     0,   537,   538,   539,   540,   541,   542,     0,     0,
     543,   544,   545,     0,   546,  2961,   547,   548,     0,   549,
    1543,     0,   550,   551,   552,   553,   554,   555,   556,   557,
       0,   558,     0,   559,   560,     0,   561,   562,   563,   564,
       0,  1544,  1545,     0,     0,   566,     0,   567,     0,     0,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
     576,     0,     0,   577,   578,     0,     0,  1546,   580,     0,
     581,     0,     0,     0,   582,   583,   584,   585,   586,   587,
       0,     0,     0,   229,     0,     0,   230,   619,    81,    82,
      83,   372,    85,    86,     0,    87,    88,    89,   373,     0,
     374,     0,    93,     0,    95,    96,    97,    98,    99,   100,
     620,   101,   102,   103,   375,   621,     0,   105,   106,   107,
     108,   622,   623,     0,   110,   111,   112,     0,   113,   624,
     625,   116,   376,   377,     0,     0,     0,   378,   379,     0,
       0,     0,     0,   380,     0,     0,     0,     0,     0,     0,
       0,     0,   381,     0,   382,     0,   383,   384,     0,   385,
     386,   387,   388,   389,   390,   391,   392,     0,   393,   394,
       0,     0,     0,     0,     0,     0,     0,   395,   396,     0,
     397,     0,   398,   399,   400,     0,  1529,     0,  1530,  1211,
       0,   401,   402,     0,   403,   404,     0,     0,   405,  1531,
    1532,   407,     0,   408,   409,   410,   411,     0,     0,     0,
     412,   413,   414,   415,   416,     0,   417,   418,     0,   419,
       0,   420,   421,   422,     0,   423,     0,     0,     0,     0,
       0,   424,   425,   426,   427,   428,  1533,  1534,   429,     0,
     430,     0,   431,     0,   432,   433,   434,     0,   435,     0,
       0,   436,  1225,   438,   439,     0,   440,   441,   442,     0,
     443,     0,   444,   445,   446,     0,   447,     0,     0,     0,
     448,   449,  1535,     0,   450,     0,   451,     0,     0,     0,
     452,     0,   453,     0,   454,     0,     0,   455,     0,   456,
     457,   458,   459,     0,   460,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,     0,     0,   469,   470,
     471,  1231,  1536,     0,  1537,     0,     0,     0,     0,   472,
       0,   473,   474,   475,   476,   477,     0,     0,     0,   478,
       0,     0,   479,   480,   481,     0,     0,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,  1538,     0,
    1539,     0,   493,   494,   495,   496,   497,   498,   499,     0,
     500,     0,   501,   502,     0,   503,     0,     0,  1540,   504,
     505,     0,     0,   506,     0,     0,     0,   507,   508,     0,
       0,     0,     0,     0,     0,   509,   510,   511,   512,     0,
       0,     0,   513,   514,   515,     0,   516,   517,   518,   519,
     520,   521,  1541,   522,   523,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,     0,   533,   534,     0,   535,
     536,     0,   537,   538,   539,   540,   541,   542,     0,     0,
     543,   544,   545,     0,   546,  1542,   547,   548,     0,   549,
    1543,     0,   550,   551,   552,   553,   554,   555,   556,   557,
       0,   558,     0,   559,   560,     0,   561,   562,   563,   564,
       0,  1544,  1545,     0,     0,   566,     0,   567,     0,     0,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
     576,     0,     0,   577,   578,     0,     0,  1546,   580,     0,
     581,     0,     0,     0,   582,   583,   584,   585,   586,   587,
       0,     0,     0,   229,     0,     0,   230,   619,    81,    82,
      83,   372,    85,    86,     0,    87,    88,    89,   373,     0,
     374,     0,    93,     0,    95,    96,    97,    98,    99,   100,
     620,   101,   102,   103,   375,   621,     0,   105,   106,   107,
     108,   622,   623,     0,   110,   111,   112,     0,   113,   624,
     625,   116,   376,   377,     0,     0,     0,   378,   379,     0,
       0,     0,     0,   380,     0,     0,     0,     0,     0,     0,
       0,     0,   381,     0,   382,     0,   383,   384,     0,   385,
     386,   387,   388,   389,   390,   391,   392,     0,   393,   394,
       0,     0,     0,     0,     0,     0,     0,   395,   396,     0,
     397,     0,   398,   399,   400,     0,  1529,     0,  1530,  1211,
       0,   401,   402,     0,   403,   404,     0,     0,   405,  1531,
    1532,   407,     0,   408,   409,   410,   411,     0,     0,     0,
     412,   413,   414,   415,   416,     0,   417,   418,     0,   419,
       0,   420,   421,   422,     0,   423,     0,     0,     0,     0,
       0,   424,   425,   426,   427,   428,  1533,  1534,   429,     0,
     430,     0,   431,     0,   432,   433,   434,     0,   435,     0,
       0,   436,  1225,   438,   439,     0,   440,   441,   442,     0,
     443,     0,   444,   445,   446,     0,   447,     0,     0,     0,
     448,   449,  1535,     0,   450,     0,   451,     0,     0,     0,
     452,     0,   453,     0,   454,     0,     0,   455,     0,   456,
     457,   458,   459,     0,   460,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,     0,     0,   469,   470,
     471,  1231,  1536,     0,  1537,     0,     0,     0,     0,   472,
       0,   473,   474,   475,   476,   477,     0,     0,     0,   478,
       0,     0,   479,   480,   481,     0,     0,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,  1538,     0,
    1539,     0,   493,   494,   495,   496,   497,   498,   499,     0,
     500,     0,   501,   502,     0,   503,     0,     0,  1540,   504,
     505,     0,     0,   506,     0,     0,     0,   507,   508,     0,
       0,     0,     0,     0,     0,   509,   510,   511,   512,     0,
       0,     0,   513,   514,   515,     0,   516,   517,   518,   519,
     520,   521,  1541,   522,   523,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,     0,   533,   534,     0,   535,
     536,     0,   537,   538,   539,   540,   541,   542,     0,     0,
     543,   544,   545,     0,   546,     0,   547,   548,     0,   549,
    1543,     0,   550,   551,   552,   553,   554,   555,   556,   557,
       0,   558,     0,   559,   560,     0,   561,   562,   563,   564,
       0,  1544,  1545,     0,     0,   566,     0,   567,     0,     0,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
     576,     0,     0,   577,   578,     0,     0,  1546,   580,     0,
     581,     0,     0,     0,   582,   583,   584,   585,   586,   587,
       0,     0,     0,   229,     0,     0,   230,    81,    82,    83,
     372,    85,    86,     0,    87,    88,    89,   373,     0,   374,
       0,    93,     0,    95,    96,    97,    98,    99,   100,     0,
     101,   102,   103,   375,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     116,   376,   377,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   385,   386,
     387,   388,   389,   390,   391,   392,   626,   393,   394,   627,
     628,   629,   630,   631,   632,   633,   395,   396,   634,   397,
     131,   398,   399,   400,   133,   134,   135,   136,     0,   635,
     401,   402,     0,   403,   404,   636,   637,   405,     0,   137,
     407,   639,   408,   409,   410,   411,   141,   640,   641,   412,
     413,   414,   415,   416,   642,   417,   418,   144,   419,   643,
     420,   421,   422,   147,   423,   644,   645,   646,   647,   648,
     424,   425,   426,     0,   428,   150,   151,   429,   649,   430,
     650,   431,     0,   432,   433,   434,   651,   435,   652,   653,
     436,   437,   438,   439,   654,   440,   441,   442,   655,   443,
     656,   444,   445,   446,   157,   447,     0,   159,   657,   448,
     449,   161,   658,   450,   659,   451,   162,   660,   163,   452,
       0,   453,   661,   454,   166,   662,   455,   663,   456,   457,
       0,   459,   167,   460,   461,   462,   664,   463,   464,   465,
     466,   467,   468,   665,   168,   169,     0,   469,   470,   471,
       0,   171,   668,   172,   669,     0,   173,   174,   472,   175,
     473,   474,   475,   476,   477,   670,   176,   177,   478,   178,
     671,   479,   480,   481,     0,     0,   482,   483,   484,   485,
     486,     0,   488,   489,     0,   491,   492,   183,   184,   185,
     672,   493,   494,   495,   496,   497,   498,   499,   186,   500,
     673,   501,   502,   188,   503,   674,   189,   190,   504,   505,
     675,   676,   506,   677,   678,   679,   507,   508,   680,   681,
     191,   192,   193,   194,   509,   510,   511,   512,     0,   195,
     196,   513,   514,   515,   682,   516,   517,   518,   519,   520,
     521,   198,   522,   523,   683,   524,   525,   526,   527,   528,
     529,   530,   531,   532,   684,   533,   534,   204,   535,   536,
     206,   537,   538,   539,   540,   541,     0,     0,   685,   543,
     544,   545,   686,   546,   210,   547,   548,   212,   549,   213,
     687,   550,   551,   552,   553,   554,   555,   556,   557,   215,
     558,   688,   559,   560,   689,   561,   562,   563,   564,   690,
     216,   217,     0,   692,   566,   218,   567,   219,   693,   568,
     569,   570,   571,   572,     0,   695,   573,   574,   575,   576,
     696,   697,   577,   578,     0,     0,   227,   580,   228,   581,
       0,   698,   699,   582,   583,   584,   585,     0,   587,     0,
       0,     0,   229,     0,     0,   230,    81,    82,    83,   372,
      85,    86,     0,    87,    88,    89,   373,     0,   374,     0,
      93,     0,    95,    96,    97,    98,    99,   100,     0,   101,
     102,   103,   375,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   116,
     376,   377,     0,     0,     0,   378,   379,     0,     0,     0,
       0,   380,     0,     0,     0,     0,     0,     0,     0,     0,
     381,     0,   382,     0,   383,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,     0,   393,   394,     0,     0,
       0,     0,     0,     0,     0,   395,   396,     0,   397,   131,
     398,   399,   400,   133,   134,   135,   136,     0,     0,   401,
     402,     0,   403,   404,     0,     0,   405,   406,   137,   407,
       0,   408,   409,   410,   411,   141,     0,     0,   412,   413,
     414,   415,   416,     0,   417,   418,   144,   419,     0,   420,
     421,   422,   147,   423,     0,     0,     0,     0,     0,   424,
     425,   426,   427,   428,   150,   151,   429,     0,   430,     0,
     431,     0,   432,   433,   434,     0,   435,     0,     0,   436,
     437,   438,   439,     0,   440,   441,   442,     0,   443,     0,
     444,   445,   446,   157,   447,     0,   159,     0,   448,   449,
     161,     0,   450,     0,   451,   162,     0,   163,   452,     0,
     453,     0,   454,   166,     0,   455,     0,   456,   457,   458,
     459,   167,   460,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,   168,   169,     0,   469,   470,   471,     0,
     171,     0,   172,     0,     0,   173,   174,   472,   175,   473,
     474,   475,   476,   477,     0,   176,   177,   478,   178,     0,
     479,   480,   481,     0,     0,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   183,   184,   185,   749,
     493,   494,   495,   496,   497,   498,   499,   186,   500,     0,
     501,   502,   188,   503,     0,   189,   190,   504,   505,     0,
       0,   506,   750,     0,     0,   507,   508,     0,     0,   191,
     192,   193,   194,   509,   510,   511,   512,     0,   195,   196,
     513,   514,   515,     0,   516,   517,   518,   519,   520,   521,
     198,   522,   523,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,     0,   533,   534,   204,   535,   536,   206,
     537,   538,   539,   540,   541,   542,     0,     0,   543,   544,
     545,     0,   546,   210,   547,   548,   212,   549,   213,     0,
     550,   551,   552,   553,   554,   555,   556,   557,   215,   558,
       0,   559,   560,     0,   561,   562,   563,   564,     0,   216,
     217,     0,     0,   566,   218,   567,   219,     0,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,   576,     0,
       0,   577,   578,     0,   579,   227,   580,   228,   581,     0,
       0,     0,   582,   583,   584,   585,   586,   587,     0,     0,
       0,   229,     0,     0,   230,    81,    82,    83,   372,    85,
      86,     0,    87,    88,    89,   373,     0,   374,     0,    93,
       0,    95,    96,    97,    98,    99,   100,     0,   101,   102,
     103,   375,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   116,   376,
     377,     0,     0,     0,   378,   379,     0,     0,     0,     0,
     380,     0,     0,     0,     0,     0,     0,     0,     0,   381,
       0,   382,     0,   383,   384,     0,   385,   386,   387,   388,
     389,   390,   391,   392,     0,   393,   394,     0,     0,     0,
       0,     0,     0,     0,   395,   396,     0,   397,   131,   398,
     399,   400,   133,   134,   135,   136,     0,     0,   401,   402,
       0,   403,   404,     0,     0,   405,   406,   137,   407,     0,
     408,   409,   410,   411,   141,     0,     0,   412,   413,   414,
     415,   416,     0,   417,   418,   144,   419,     0,   420,   421,
     422,   147,   423,     0,     0,     0,     0,     0,   424,   425,
     426,   427,   428,   150,   151,   429,     0,   430,     0,   431,
       0,   432,   433,   434,     0,   435,     0,     0,   436,   437,
     438,   439,     0,   440,   441,   442,     0,   443,     0,   444,
     445,   446,   157,   447,     0,   159,     0,   448,   449,   161,
       0,   450,     0,   451,   162,     0,   163,   452,     0,   453,
       0,   454,   166,     0,   455,     0,   456,   457,   458,  1134,
     167,   460,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,   168,   169,     0,   469,   470,   471,     0,   171,
       0,   172,     0,     0,   173,   174,   472,   175,   473,   474,
     475,   476,   477,     0,   176,   177,   478,   178,     0,   479,
     480,   481,     0,     0,   482,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   183,   184,   185,   749,   493,
     494,   495,   496,   497,   498,   499,   186,   500,     0,   501,
     502,   188,   503,     0,   189,   190,   504,   505,     0,     0,
     506,   750,     0,     0,   507,   508,     0,     0,   191,   192,
     193,   194,   509,   510,   511,   512,     0,   195,   196,   513,
     514,   515,     0,   516,   517,   518,   519,   520,   521,   198,
     522,   523,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,     0,   533,   534,   204,   535,   536,   206,   537,
     538,   539,   540,   541,   542,     0,     0,   543,   544,   545,
       0,   546,   210,   547,   548,   212,   549,   213,     0,   550,
     551,   552,   553,   554,   555,   556,   557,   215,   558,     0,
     559,   560,     0,   561,   562,   563,   564,     0,   216,   217,
       0,     0,   566,   218,   567,   219,     0,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,   576,     0,     0,
     577,   578,     0,   579,   227,   580,   228,   581,     0,     0,
       0,   582,   583,   584,   585,   586,   587,     0,     0,     0,
     229,     0,     0,   230,    81,    82,    83,   372,    85,    86,
       0,    87,    88,    89,   373,     0,   374,     0,    93,     0,
      95,    96,    97,    98,    99,   100,     0,   101,   102,   103,
     375,     0,     0,   105,   106,   107,   108,     0,     0,     0,
     110,   111,   112,     0,   113,     0,     0,   116,   376,   377,
       0,     0,     0,   378,   379,     0,     0,     0,     0,   380,
       0,     0,     0,     0,     0,     0,     0,     0,   381,     0,
     382,     0,   383,   384,     0,   385,   386,   387,   388,   389,
     390,   391,   392,     0,   393,   394,     0,     0,     0,     0,
       0,     0,     0,   395,   396,     0,   397,   131,   398,   399,
     400,   133,   134,   135,   136,     0,     0,   401,   402,     0,
     403,   404,     0,     0,   405,   406,   137,   407,     0,   408,
     409,   410,   411,   141,     0,     0,   412,   413,   414,   415,
     416,     0,   417,   418,   144,   419,     0,   420,   421,   422,
     147,   423,     0,     0,     0,     0,     0,   424,   425,   426,
     427,   428,   150,   151,   429,     0,   430,     0,   431,     0,
     432,   433,   434,     0,   435,     0,     0,   436,   437,   438,
     439,     0,   440,   441,   442,     0,   443,     0,   444,   445,
     446,   157,   447,     0,   159,     0,   448,   449,   161,     0,
     450,     0,   451,   162,     0,   163,   452,     0,   453,     0,
     454,   166,     0,   455,     0,   456,   457,   458,  1141,   167,
     460,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,   168,   169,     0,   469,   470,   471,     0,   171,     0,
     172,     0,     0,   173,   174,   472,   175,   473,   474,   475,
     476,   477,     0,   176,   177,   478,   178,     0,   479,   480,
     481,     0,     0,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   183,   184,   185,   749,   493,   494,
     495,   496,   497,   498,   499,   186,   500,     0,   501,   502,
     188,   503,     0,   189,   190,   504,   505,     0,     0,   506,
     750,     0,     0,   507,   508,     0,     0,   191,   192,   193,
     194,   509,   510,   511,   512,     0,   195,   196,   513,   514,
     515,     0,   516,   517,   518,   519,   520,   521,   198,   522,
     523,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,     0,   533,   534,   204,   535,   536,   206,   537,   538,
     539,   540,   541,   542,     0,     0,   543,   544,   545,     0,
     546,   210,   547,   548,   212,   549,   213,     0,   550,   551,
     552,   553,   554,   555,   556,   557,   215,   558,     0,   559,
     560,     0,   561,   562,   563,   564,     0,   216,   217,     0,
       0,   566,   218,   567,   219,     0,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,   576,     0,     0,   577,
     578,     0,   579,   227,   580,   228,   581,     0,     0,     0,
     582,   583,   584,   585,   586,   587,     0,     0,     0,   229,
       0,     0,   230,    81,    82,    83,   372,    85,    86,     0,
      87,    88,    89,   373,     0,   374,     0,    93,     0,    95,
      96,    97,    98,    99,   100,     0,   101,   102,   103,   375,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   116,   376,   377,     0,
       0,     0,   378,   379,     0,     0,     0,     0,   380,     0,
       0,     0,     0,     0,     0,     0,     0,   381,     0,   382,
       0,   383,   384,     0,   385,   386,   387,   388,   389,   390,
     391,   392,     0,   393,   394,     0,     0,     0,     0,     0,
       0,     0,   395,   396,     0,   397,     0,   398,   399,   400,
       0,   134,     0,   136,     0,     0,   401,   402,     0,   403,
     404,     0,     0,   405,   406,   137,   407,  1920,   408,   409,
     410,   411,   141,     0,     0,   412,   413,   414,   415,   416,
    1921,   417,   418,   144,   419,     0,   420,   421,   422,     0,
     423,     0,     0,     0,     0,     0,   424,   425,   426,   427,
     428,   150,   151,   429,     0,   430,     0,   431,     0,   432,
     433,   434,     0,   435,     0,     0,   436,   437,   438,   439,
       0,   440,   441,   442,     0,   443,     0,   444,   445,   446,
     157,   447,     0,   159,     0,   448,   449,   161,     0,   450,
    1922,   451,     0,     0,     0,   452,     0,   453,     0,   454,
     166,     0,   455,     0,   456,   457,   458,   459,     0,   460,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   169,     0,   469,   470,   471,     0,   171,     0,   172,
       0,     0,     0,     0,   472,     0,   473,   474,   475,   476,
     477,     0,   176,     0,   478,  2550,     0,   479,   480,   481,
       0,     0,   482,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   183,     0,   185,     0,   493,   494,   495,
     496,   497,   498,   499,   186,   500,     0,   501,   502,     0,
     503,     0,   189,   190,   504,   505,     0,     0,   506,     0,
       0,     0,   507,   508,     0,     0,   191,     0,     0,   194,
     509,   510,   511,   512,     0,   195,   196,   513,   514,   515,
    1923,   516,   517,   518,   519,   520,   521,   198,   522,   523,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
       0,   533,   534,     0,   535,   536,   206,   537,   538,   539,
     540,   541,   542,     0,     0,   543,   544,   545,     0,   546,
     210,   547,   548,     0,   549,   213,     0,   550,   551,   552,
     553,   554,   555,   556,   557,   215,   558,     0,   559,   560,
       0,   561,   562,   563,   564,     0,   216,   217,     0,     0,
     566,   218,   567,   219,     0,   568,   569,   570,   571,   572,
       0,  1924,   573,   574,   575,   576,     0,     0,   577,   578,
       0,   579,   227,   580,     0,   581,     0,     0,     0,   582,
     583,   584,   585,   586,   587,     0,     0,     0,   229,     0,
       0,   230,    81,    82,    83,   372,    85,    86,     0,    87,
      88,    89,   373,     0,   374,     0,    93,     0,    95,    96,
      97,    98,    99,   100,     0,   101,   102,   103,   375,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   116,   376,   377,     0,     0,
       0,   378,   379,     0,     0,     0,     0,   380,     0,     0,
       0,     0,     0,     0,     0,     0,   381,     0,   382,     0,
     383,   384,     0,   385,   386,   387,   388,   389,   390,   391,
     392,   853,   393,   394,     0,     0,     0,     0,     0,     0,
       0,   395,   396,     0,   397,     0,   398,   399,   400,     0,
     134,     0,   136,     0,     0,   401,   402,     0,   403,   404,
       0,     0,   405,   406,   137,   407,     0,   408,   409,   410,
     411,   141,     0,     0,   412,   413,   414,   415,   416,     0,
     417,   418,   144,   419,   854,   420,   421,   422,     0,   423,
       0,     0,     0,     0,     0,   424,   425,   426,   427,   428,
     150,   151,   429,     0,   430,     0,   431,     0,   432,   433,
     434,     0,   435,     0,     0,   436,   437,   438,   439,     0,
     440,   441,   442,     0,   443,     0,   444,   445,   446,   157,
     447,     0,   159,     0,   448,   449,   161,     0,   450,     0,
     451,     0,     0,     0,   452,     0,   453,   895,   454,   166,
       0,   455,     0,   456,   457,   458,   459,     0,   460,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,     0,
     169,     0,   469,   470,   471,     0,   171,     0,   172,     0,
       0,     0,     0,   472,     0,   473,   474,   475,   476,   477,
       0,   176,     0,   478,     0,     0,   479,   480,   481,     0,
       0,   482,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   183,     0,   185,     0,   493,   494,   495,   496,
     497,   498,   499,   186,   500,     0,   501,   502,     0,   503,
       0,   189,   190,   504,   505,     0,     0,   506,     0,     0,
       0,   507,   508,     0,     0,   191,     0,     0,   194,   509,
     510,   511,   512,     0,   195,   196,   513,   514,   515,     0,
     516,   517,   518,   519,   520,   521,   198,   522,   523,   855,
     524,   525,   526,   527,   528,   529,   530,   531,   532,     0,
     533,   534,     0,   535,   536,   206,   537,   538,   539,   540,
     541,   542,     0,   856,   543,   544,   545,     0,   546,   210,
     547,   548,     0,   549,   213,     0,   550,   551,   552,   553,
     554,   555,   556,   557,   215,   558,     0,   559,   560,     0,
     561,   562,   563,   564,     0,   216,   217,     0,     0,   566,
     218,   567,   219,     0,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,   576,     0,     0,   577,   578,     0,
     579,   227,   580,     0,   581,     0,     0,     0,   582,   583,
     584,   585,   586,   587,     0,     0,     0,   229,     0,     0,
     230,    81,    82,    83,   372,    85,    86,     0,    87,    88,
      89,   373,     0,   374,     0,    93,     0,    95,    96,    97,
      98,    99,   100,     0,   101,   102,   103,   375,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   116,   376,   377,     0,     0,     0,
     378,   379,     0,     0,     0,     0,   380,     0,     0,     0,
       0,     0,     0,     0,     0,   381,     0,   382,     0,   383,
     384,     0,   385,   386,   387,   388,   389,   390,   391,   392,
     853,   393,   394,     0,     0,     0,     0,     0,     0,     0,
     395,   396,     0,   397,     0,   398,   399,   400,     0,   134,
       0,   136,     0,     0,   401,   402,     0,   403,   404,     0,
       0,   405,   406,   137,   407,     0,   408,   409,   410,   411,
     141,     0,     0,   412,   413,   414,   415,   416,     0,   417,
     418,   144,   419,   854,   420,   421,   422,     0,   423,     0,
       0,     0,     0,     0,   424,   425,   426,   427,   428,   150,
     151,   429,     0,   430,     0,   431,     0,   432,   433,   434,
       0,   435,     0,     0,   436,   437,   438,   439,     0,   440,
     441,   442,     0,   443,     0,   444,   445,   446,   157,   447,
       0,   159,     0,   448,   449,   161,     0,   450,     0,   451,
       0,     0,     0,   452,     0,   453,     0,   454,   166,     0,
     455,     0,   456,   457,   458,   459,     0,   460,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   169,
       0,   469,   470,   471,     0,   171,     0,   172,     0,     0,
       0,     0,   472,     0,   473,   474,   475,   476,   477,     0,
     176,     0,   478,     0,     0,   479,   480,   481,     0,     0,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   183,     0,   185,     0,   493,   494,   495,   496,   497,
     498,   499,   186,   500,     0,   501,   502,     0,   503,     0,
     189,   190,   504,   505,     0,     0,   506,     0,     0,     0,
     507,   508,     0,     0,   191,     0,     0,   194,   509,   510,
     511,   512,     0,   195,   196,   513,   514,   515,     0,   516,
     517,   518,   519,   520,   521,   198,   522,   523,   855,   524,
     525,   526,   527,   528,   529,   530,   531,   532,     0,   533,
     534,     0,   535,   536,   206,   537,   538,   539,   540,   541,
     542,     0,   856,   543,   544,   545,     0,   546,   210,   547,
     548,     0,   549,   213,     0,   550,   551,   552,   553,   554,
     555,   556,   557,   215,   558,     0,   559,   560,     0,   561,
     562,   563,   564,     0,   216,   217,     0,     0,   566,   218,
     567,   219,     0,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,   576,     0,     0,   577,   578,     0,   579,
     227,   580,     0,   581,     0,     0,     0,   582,   583,   584,
     585,   586,   587,     0,     0,     0,   229,     0,     0,   230,
      81,    82,    83,   372,    85,    86,     0,    87,    88,    89,
     373,     0,   374,     0,    93,     0,    95,    96,    97,    98,
      99,   100,     0,   101,   102,   103,   375,     0,     0,   105,
     106,   107,   108,     0,     0,     0,   110,   111,   112,     0,
     113,     0,     0,   116,   376,   377,     0,     0,     0,   378,
     379,     0,     0,     0,     0,   380,     0,     0,     0,     0,
       0,     0,     0,     0,   381,     0,   382,     0,   383,   384,
       0,   385,   386,   387,   388,   389,   390,   391,   392,     0,
     393,   394,   128,   129,     0,     0,     0,     0,     0,   395,
     396,     0,   397,     0,   398,   399,   400,     0,   134,     0,
     136,     0,     0,   401,   402,     0,   403,   404,     0,     0,
     405,   406,   137,   407,     0,   408,   409,   410,   411,   141,
       0,     0,   412,   413,   414,   415,   416,     0,   417,   418,
     144,   419,     0,   420,   421,   422,     0,   423,     0,     0,
       0,     0,     0,   424,   425,   426,   427,   428,   150,   151,
     429,     0,   430,     0,   431,     0,   432,   433,   434,     0,
     435,     0,     0,   436,   437,   438,   439,     0,   440,   441,
     442,     0,   443,     0,   444,   445,   446,   157,   447,     0,
     159,     0,   448,   449,   161,     0,   450,     0,   451,     0,
       0,     0,   452,     0,   453,     0,   454,   166,     0,   455,
       0,   456,   457,   458,   459,     0,   460,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   169,     0,
     469,   470,   471,     0,   171,     0,   172,     0,     0,     0,
       0,   472,     0,   473,   474,   475,   476,   477,     0,   176,
       0,   478,     0,     0,   479,   480,   481,     0,     0,   482,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     183,     0,   185,   749,   493,   494,   495,   496,   497,   498,
     499,   186,   500,     0,   501,   502,     0,   503,     0,   189,
     190,   504,   505,     0,     0,   506,   750,     0,     0,   507,
     508,     0,     0,   191,     0,     0,   194,   509,   510,   511,
     512,     0,   195,   196,   513,   514,   515,     0,   516,   517,
     518,   519,   520,   521,   198,   522,   523,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,     0,   533,   534,
       0,   535,   536,   206,   537,   538,   539,   540,   541,   542,
       0,     0,   543,   544,   545,     0,   546,   210,   547,   548,
       0,   549,   213,     0,   550,   551,   552,   553,   554,   555,
     556,   557,   215,   558,     0,   559,   560,     0,   561,   562,
     563,   564,     0,   216,   217,     0,     0,   566,   218,   567,
     219,     0,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,   576,     0,     0,   577,   578,     0,   579,   227,
     580,     0,   581,     0,     0,     0,   582,   583,   584,   585,
     586,   587,     0,     0,     0,   229,     0,     0,   230,    81,
      82,    83,   372,    85,    86,     0,    87,    88,    89,   373,
       0,   374,     0,    93,     0,    95,    96,    97,    98,    99,
     100,     0,   101,   102,   103,   375,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   116,   376,   377,     0,     0,     0,   378,   379,
       0,     0,     0,     0,   380,     0,     0,     0,     0,     0,
       0,     0,     0,   381,     0,   382,     0,   383,   384,     0,
     385,   386,   387,   388,   389,   390,   391,   392,     0,   393,
     394,     0,     0,     0,     0,     0,     0,     0,   395,   396,
       0,   397,     0,   398,   399,   400,     0,   134,     0,   136,
       0,     0,   401,   402,     0,   403,   404,     0,     0,   405,
     406,   137,   407,     0,   408,   409,   410,   411,   141,     0,
       0,   412,   413,   414,   415,   416,     0,   417,   418,   144,
     419,     0,   420,   421,   422,     0,   423,     0,     0,     0,
       0,     0,   424,   425,   426,   427,   428,   150,   151,   429,
       0,   430,     0,   431,     0,   432,   433,   434,     0,   435,
       0,     0,   436,   437,   438,   439,     0,   440,   441,   442,
       0,   443,     0,   444,   445,   446,   157,   447,     0,   159,
       0,   448,   449,   161,     0,   450,     0,   451,     0,     0,
       0,   452,     0,   453,     0,   454,   166,     0,   455,     0,
     456,   457,   458,   459,     0,   460,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   169,     0,   469,
     470,   471,     0,   171,     0,   172,     0,     0,     0,     0,
     472,     0,   473,   474,   475,   476,   477,     0,   176,     0,
     478,     0,     0,   479,   480,   481,     0,     0,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   183,
       0,   185,   749,   493,   494,   495,   496,   497,   498,   499,
     186,   500,     0,   501,   502,     0,   503,     0,   189,   190,
     504,   505,     0,     0,   506,   750,     0,   927,   507,   508,
       0,     0,   191,     0,     0,   194,   509,   510,   511,   512,
       0,   195,   196,   513,   514,   515,     0,   516,   517,   518,
     519,   520,   521,   198,   522,   523,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,     0,   533,   534,     0,
     535,   536,   206,   537,   538,   539,   540,   541,   542,     0,
       0,   543,   544,   545,     0,   546,   210,   547,   548,     0,
     549,   213,     0,   550,   551,   552,   553,   554,   555,   556,
     557,   215,   558,     0,   559,   560,     0,   561,   562,   563,
     564,     0,   216,   217,     0,     0,   566,   218,   567,   219,
       0,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,   576,     0,     0,   577,   578,     0,   579,   227,   580,
       0,   581,     0,     0,     0,   582,   583,   584,   585,   586,
     587,     0,     0,     0,   229,     0,     0,   230,    81,    82,
      83,   372,    85,    86,     0,    87,    88,    89,   373,     0,
     374,     0,    93,     0,    95,    96,    97,    98,    99,   100,
       0,   101,   102,   103,   375,     0,     0,   105,   106,   107,
     108,     0,     0,     0,   110,   111,   112,     0,   113,     0,
       0,   116,   376,   377,     0,     0,     0,   378,   379,     0,
       0,     0,     0,   380,     0,     0,     0,     0,     0,     0,
       0,     0,   381,     0,   382,     0,   383,   384,     0,   385,
     386,   387,   388,   389,   390,   391,   392,  1313,   393,   394,
       0,     0,     0,     0,     0,     0,     0,   395,   396,     0,
     397,     0,   398,   399,   400,     0,   134,     0,   136,     0,
       0,   401,   402,     0,   403,   404,     0,     0,   405,   406,
     137,   407,     0,   408,   409,   410,   411,   141,     0,     0,
     412,   413,   414,   415,   416,     0,   417,   418,   144,   419,
       0,   420,   421,   422,     0,   423,     0,     0,     0,     0,
       0,   424,   425,   426,   427,   428,   150,   151,   429,     0,
     430,     0,   431,     0,   432,   433,   434,     0,   435,     0,
       0,   436,   437,   438,   439,     0,   440,   441,   442,     0,
     443,     0,   444,   445,   446,   157,   447,     0,   159,     0,
     448,   449,   161,     0,   450,     0,   451,     0,     0,     0,
     452,     0,   453,     0,   454,   166,     0,   455,     0,   456,
     457,   458,   459,     0,   460,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   169,     0,   469,   470,
     471,     0,   171,     0,   172,     0,     0,     0,     0,   472,
       0,   473,   474,   475,   476,   477,     0,   176,     0,   478,
       0,     0,   479,   480,   481,     0,     0,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   183,     0,
     185,   749,   493,   494,   495,   496,   497,   498,   499,   186,
     500,     0,   501,   502,     0,   503,     0,   189,   190,   504,
     505,     0,     0,   506,   750,     0,     0,   507,   508,     0,
       0,   191,     0,     0,   194,   509,   510,   511,   512,     0,
     195,   196,   513,   514,   515,     0,   516,   517,   518,   519,
     520,   521,   198,   522,   523,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,     0,   533,   534,     0,   535,
     536,   206,   537,   538,   539,   540,   541,   542,     0,     0,
     543,   544,   545,     0,   546,   210,   547,   548,     0,   549,
     213,     0,   550,   551,   552,   553,   554,   555,   556,   557,
     215,   558,     0,   559,   560,     0,   561,   562,   563,   564,
       0,   216,   217,     0,     0,   566,   218,   567,   219,     0,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
     576,     0,     0,   577,   578,     0,   579,   227,   580,     0,
     581,     0,     0,     0,   582,   583,   584,   585,   586,   587,
       0,     0,     0,   229,     0,     0,   230,    81,    82,    83,
     372,    85,    86,     0,    87,    88,    89,   373,     0,   374,
       0,    93,     0,    95,    96,    97,    98,    99,   100,     0,
     101,   102,   103,   375,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     116,   376,   377,     0,     0,     0,   378,   379,     0,     0,
       0,     0,   380,     0,     0,     0,     0,     0,     0,     0,
       0,   381,     0,   382,     0,   383,   384,     0,   385,   386,
     387,   388,   389,   390,   391,   392,     0,   393,   394,     0,
       0,     0,     0,     0,     0,     0,   395,   396,     0,   397,
       0,   398,   399,   400,     0,   134,     0,   136,     0,     0,
     401,   402,     0,   403,   404,     0,     0,   405,   406,   137,
     407,     0,   408,   409,   410,   411,   141,     0,     0,   412,
     413,   414,   415,   416,     0,   417,   418,   144,   419,     0,
     420,   421,   422,     0,   423,     0,     0,     0,     0,     0,
     424,   425,  1656,   427,   428,   150,   151,   429,     0,   430,
       0,   431,     0,   432,   433,   434,     0,   435,     0,     0,
     436,   437,   438,   439,     0,   440,   441,   442,     0,   443,
       0,   444,   445,   446,   157,   447,     0,   159,     0,   448,
     449,   161,     0,   450,     0,   451,     0,     0,     0,  1657,
       0,   453,     0,   454,   166,     0,   455,     0,   456,   457,
     458,   459,     0,   460,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   169,     0,   469,   470,   471,
       0,   171,     0,   172,     0,     0,     0,     0,   472,     0,
     473,   474,  1658,   476,   477,     0,   176,     0,   478,     0,
       0,   479,   480,   481,     0,     0,   482,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   183,     0,   185,
     749,   493,   494,   495,   496,   497,   498,   499,   186,   500,
       0,   501,   502,     0,   503,     0,   189,   190,   504,   505,
       0,     0,   506,   750,     0,     0,   507,   508,     0,     0,
     191,     0,     0,   194,   509,   510,   511,   512,     0,   195,
     196,   513,   514,   515,     0,   516,   517,   518,   519,   520,
     521,   198,   522,   523,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,     0,   533,   534,     0,   535,   536,
     206,   537,   538,   539,  1659,   541,   542,     0,     0,  1660,
     544,   545,     0,   546,   210,   547,   548,     0,   549,   213,
       0,   550,   551,   552,   553,   554,   555,   556,   557,   215,
     558,     0,   559,   560,  1661,  1662,   562,   563,   564,     0,
     216,   217,     0,     0,   566,   218,   567,   219,     0,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,   576,
       0,     0,   577,   578,     0,   579,   227,   580,     0,   581,
       0,     0,     0,   582,   583,   584,   585,   586,   587,     0,
       0,     0,   229,     0,     0,   230,    81,    82,    83,   372,
      85,    86,     0,    87,    88,    89,   373,     0,   374,     0,
      93,     0,    95,    96,    97,    98,    99,   100,     0,   101,
     102,   103,   375,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   116,
     376,   377,     0,     0,     0,   378,   379,     0,     0,     0,
       0,   380,     0,     0,     0,     0,     0,     0,     0,     0,
     381,     0,   382,     0,   383,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,     0,   393,   394,     0,     0,
       0,     0,     0,     0,     0,   395,   396,     0,   397,     0,
     398,   399,   400,     0,   134,     0,   136,     0,     0,   401,
     402,     0,   403,   404,     0,     0,   405,   406,   137,   407,
       0,   408,   409,   410,   411,   141,     0,     0,   412,   413,
     414,   415,   416,     0,   417,   418,   144,   419,   854,   420,
     421,   422,     0,   423,     0,     0,     0,     0,     0,   424,
     425,   426,   427,   428,   150,   151,   429,     0,   430,     0,
     431,     0,   432,   433,   434,     0,   435,     0,     0,   436,
     437,   438,   439,     0,   440,   441,   442,     0,   443,     0,
     444,   445,   446,   157,   447,     0,   159,     0,   448,   449,
     161,     0,   450,     0,   451,     0,     0,     0,   452,     0,
     453,     0,   454,   166,     0,   455,     0,   456,   457,   458,
     459,     0,   460,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   169,     0,   469,   470,   471,     0,
     171,     0,   172,     0,     0,     0,     0,   472,     0,   473,
     474,   475,   476,   477,     0,   176,     0,   478,     0,     0,
     479,   480,   481,     0,     0,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   183,     0,   185,     0,
     493,   494,   495,   496,   497,   498,   499,   186,   500,     0,
     501,   502,     0,   503,     0,   189,   190,   504,   505,     0,
       0,   506,     0,     0,     0,   507,   508,     0,     0,   191,
       0,     0,   194,   509,   510,   511,   512,     0,   195,   196,
     513,   514,   515,     0,   516,   517,   518,   519,   520,   521,
     198,   522,   523,   855,   524,   525,   526,   527,   528,   529,
     530,   531,   532,     0,   533,   534,     0,   535,   536,   206,
     537,   538,   539,   540,   541,   542,     0,   856,   543,   544,
     545,     0,   546,   210,   547,   548,     0,   549,   213,     0,
     550,   551,   552,   553,   554,   555,   556,   557,   215,   558,
       0,   559,   560,     0,   561,   562,   563,   564,     0,   216,
     217,     0,     0,   566,   218,   567,   219,     0,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,   576,     0,
       0,   577,   578,     0,   579,   227,   580,     0,   581,     0,
       0,     0,   582,   583,   584,   585,   586,   587,     0,     0,
       0,   229,     0,     0,   230,    81,    82,    83,   372,    85,
      86,     0,    87,    88,    89,   373,     0,   374,     0,    93,
       0,    95,    96,    97,    98,    99,   100,     0,   101,   102,
     103,   375,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   116,   376,
     377,     0,     0,     0,   378,   379,     0,     0,     0,     0,
     380,     0,     0,     0,     0,     0,     0,     0,     0,   381,
       0,   382,     0,   383,   384,     0,   385,   386,   387,   388,
     389,   390,   391,   392,     0,   393,   394,     0,     0,     0,
       0,     0,     0,     0,   395,   396,     0,   397,     0,   398,
     399,   400,     0,   134,     0,   136,     0,     0,   401,   402,
       0,   403,   404,     0,     0,   405,   406,   137,   407,     0,
     408,   409,   410,   411,   141,     0,     0,   412,   413,   414,
     415,   416,     0,   417,   418,   144,   419,     0,   420,   421,
     422,     0,   423,     0,     0,     0,     0,     0,   424,   425,
     426,   427,   428,   150,   151,   429,     0,   430,     0,   431,
       0,   432,   433,   434,     0,   435,     0,     0,   436,   437,
     438,   439,     0,   440,   441,   442,     0,   443,     0,   444,
     445,   446,   157,   447,     0,   159,     0,   448,   449,   161,
       0,   450,     0,   451,     0,     0,     0,   452,     0,   453,
       0,   454,   166,     0,   455,     0,   456,   457,   458,   459,
       0,   460,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   169,     0,   469,   470,   471,     0,   171,
       0,   172,     0,     0,     0,     0,   472,     0,   473,   474,
     475,   476,   477,     0,   176,     0,   478,     0,     0,   479,
     480,   481,     0,     0,   482,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   183,     0,   185,   749,   493,
     494,   495,   496,   497,   498,   499,   186,   500,     0,   501,
     502,     0,   503,     0,   189,   190,   504,   505,     0,     0,
     506,   750,     0,     0,   507,   508,     0,     0,   191,     0,
       0,   194,   509,   510,   511,   512,     0,   195,   196,   513,
     514,   515,     0,   516,   517,   518,   519,   520,   521,   198,
     522,   523,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,     0,   533,   534,     0,   535,   536,   206,   537,
     538,   539,   540,   541,   542,     0,     0,   543,   544,   545,
       0,   546,   210,   547,   548,     0,   549,   213,     0,   550,
     551,   552,   553,   554,   555,   556,   557,   215,   558,     0,
     559,   560,     0,   561,   562,   563,   564,     0,   216,   217,
       0,     0,   566,   218,   567,   219,     0,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,   576,     0,     0,
     577,   578,     0,   579,   227,   580,     0,   581,     0,     0,
       0,   582,   583,   584,   585,   586,   587,     0,     0,     0,
     229,     0,     0,   230,    81,    82,    83,   372,    85,    86,
       0,    87,    88,    89,   373,     0,   374,     0,    93,     0,
      95,    96,    97,    98,    99,   100,     0,   101,   102,   103,
     375,     0,     0,   105,   106,   107,   108,     0,     0,     0,
     110,   111,   112,     0,   113,     0,     0,   116,   376,   377,
       0,     0,     0,   378,   379,     0,     0,     0,     0,   380,
       0,     0,     0,     0,     0,     0,     0,     0,   381,     0,
     382,     0,   383,   384,     0,   385,   386,   387,   388,   389,
     390,   391,   392,     0,   393,   394,     0,     0,     0,     0,
       0,     0,     0,   395,   396,     0,   397,     0,   398,   399,
     400,     0,   134,     0,   136,     0,     0,   401,   402,     0,
     403,   404,     0,     0,   405,   406,   137,   407,     0,   408,
     409,   410,   411,   141,     0,     0,   412,   413,   414,   415,
     416,     0,   417,   418,   144,   419,     0,   420,   421,   422,
       0,   423,     0,     0,     0,     0,     0,   424,   425,   426,
     427,   428,   150,   151,   429,     0,   430,     0,   431,     0,
     432,   433,   434,     0,   435,     0,     0,   436,   437,   438,
     439,     0,   440,   441,   442,     0,   443,     0,   444,   445,
     446,   157,   447,     0,   159,     0,   448,   449,   161,     0,
     450,     0,   451,     0,   838,     0,   452,     0,   453,     0,
     454,   166,     0,   455,     0,   456,   457,   458,   459,     0,
     460,   461,   462,   839,   463,   464,   465,   466,   467,   468,
       0,     0,   169,     0,   469,   470,   471,     0,   171,     0,
     172,     0,     0,     0,     0,   472,     0,   473,   474,   475,
     476,   477,     0,   176,     0,   478,     0,     0,   479,   480,
     481,     0,     0,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   183,     0,   185,     0,   493,   494,
     495,   496,   497,   498,   499,   186,   500,     0,   501,   502,
       0,   503,     0,   189,   190,   504,   505,     0,     0,   506,
       0,     0,     0,   507,   508,     0,     0,   191,     0,     0,
     194,   509,   510,   511,   512,     0,   195,   196,   513,   514,
     515,     0,   516,   517,   518,   519,   520,   521,   198,   522,
     523,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,     0,   533,   534,     0,   535,   536,   206,   537,   538,
     539,   540,   541,   542,     0,     0,   543,   544,   545,     0,
     546,   210,   547,   548,     0,   549,   213,     0,   550,   551,
     552,   553,   554,   555,   556,   557,   215,   558,     0,   559,
     560,     0,   561,   562,   563,   564,     0,   216,   217,     0,
       0,   566,   218,   567,   219,     0,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,   576,     0,     0,   577,
     578,     0,   579,   227,   580,     0,   581,     0,     0,     0,
     582,   583,   584,   585,   586,   587,     0,     0,     0,   229,
       0,     0,   230,    81,    82,    83,   372,    85,    86,     0,
      87,    88,    89,   373,     0,   374,     0,    93,     0,    95,
      96,    97,    98,    99,   100,     0,   101,   102,   103,   375,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   116,   376,   377,     0,
       0,     0,   378,   379,     0,     0,     0,     0,   380,     0,
       0,     0,     0,     0,     0,     0,     0,   381,     0,   382,
       0,   383,   384,     0,   385,   386,   387,   388,   389,   390,
     391,   392,  2467,   393,   394,     0,     0,     0,     0,     0,
       0,     0,   395,   396,     0,   397,     0,   398,   399,   400,
       0,   134,     0,   136,     0,     0,   401,   402,     0,   403,
     404,     0,     0,   405,   406,   137,   407,     0,   408,   409,
     410,   411,   141,     0,     0,   412,   413,   414,   415,   416,
       0,   417,   418,   144,   419,     0,   420,   421,   422,     0,
     423,     0,     0,     0,     0,     0,   424,   425,   426,   427,
     428,   150,   151,   429,     0,   430,     0,   431,     0,   432,
     433,   434,     0,   435,     0,     0,   436,   437,   438,   439,
       0,   440,   441,   442,     0,   443,     0,   444,   445,   446,
     157,   447,     0,   159,     0,   448,   449,   161,     0,   450,
       0,   451,     0,     0,     0,   452,     0,   453,     0,   454,
     166,     0,   455,     0,   456,   457,   458,   459,     0,   460,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   169,     0,   469,   470,   471,     0,   171,     0,   172,
       0,     0,     0,     0,   472,     0,   473,   474,   475,   476,
     477,     0,   176,     0,   478,     0,     0,   479,   480,   481,
       0,     0,   482,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   183,     0,   185,     0,   493,   494,   495,
     496,   497,   498,   499,   186,   500,     0,   501,   502,     0,
     503,     0,   189,   190,   504,   505,     0,     0,   506,     0,
       0,     0,   507,   508,     0,     0,   191,     0,     0,   194,
     509,   510,   511,   512,     0,   195,   196,   513,   514,   515,
       0,   516,   517,   518,   519,   520,   521,   198,   522,   523,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
       0,   533,   534,     0,   535,   536,   206,   537,   538,   539,
     540,   541,   542,     0,     0,   543,   544,   545,     0,   546,
     210,   547,   548,     0,   549,   213,     0,   550,   551,   552,
     553,   554,   555,   556,   557,   215,   558,     0,   559,   560,
       0,   561,   562,   563,   564,     0,   216,   217,     0,     0,
     566,   218,   567,   219,     0,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,   576,  2468,     0,   577,   578,
       0,   579,   227,   580,     0,   581,     0,     0,     0,   582,
     583,   584,   585,   586,   587,     0,     0,     0,   229,     0,
       0,   230,    81,    82,    83,   372,    85,    86,     0,    87,
      88,    89,   373,     0,   374,     0,    93,     0,    95,    96,
      97,    98,    99,   100,     0,   101,   102,   103,   375,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   116,   376,   377,     0,     0,
       0,   378,   379,     0,     0,     0,     0,   380,     0,     0,
       0,     0,     0,     0,     0,     0,   381,     0,   382,     0,
     383,   384,     0,   385,   386,   387,   388,   389,   390,   391,
     392,  2472,   393,   394,     0,     0,     0,     0,     0,     0,
       0,   395,   396,     0,   397,     0,   398,   399,   400,     0,
     134,     0,   136,     0,     0,   401,   402,     0,   403,   404,
       0,     0,   405,   406,   137,   407,     0,   408,   409,   410,
     411,   141,     0,     0,   412,   413,   414,   415,   416,     0,
     417,   418,   144,   419,     0,   420,   421,   422,     0,   423,
       0,     0,     0,     0,     0,   424,   425,   426,   427,   428,
     150,   151,   429,     0,   430,     0,   431,     0,   432,   433,
     434,     0,   435,     0,     0,   436,   437,   438,   439,     0,
     440,   441,   442,     0,   443,     0,   444,   445,   446,   157,
     447,     0,   159,     0,   448,   449,   161,     0,   450,     0,
     451,     0,     0,     0,   452,     0,   453,     0,   454,   166,
       0,   455,     0,   456,   457,   458,   459,     0,   460,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,     0,
     169,     0,   469,   470,   471,     0,   171,     0,   172,     0,
       0,     0,     0,   472,     0,   473,   474,   475,   476,   477,
       0,   176,     0,   478,     0,     0,   479,   480,   481,     0,
       0,   482,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   183,     0,   185,     0,   493,   494,   495,   496,
     497,   498,   499,   186,   500,     0,   501,   502,     0,   503,
       0,   189,   190,   504,   505,     0,     0,   506,     0,     0,
       0,   507,   508,     0,     0,   191,     0,     0,   194,   509,
     510,   511,   512,     0,   195,   196,   513,   514,   515,     0,
     516,   517,   518,   519,   520,   521,   198,   522,   523,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,     0,
     533,   534,     0,   535,   536,   206,   537,   538,   539,   540,
     541,   542,     0,     0,   543,   544,   545,     0,   546,   210,
     547,   548,     0,   549,   213,     0,   550,   551,   552,   553,
     554,   555,   556,   557,   215,   558,     0,   559,   560,     0,
     561,   562,   563,   564,     0,   216,   217,     0,     0,   566,
     218,   567,   219,     0,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,   576,  2473,     0,   577,   578,     0,
     579,   227,   580,     0,   581,     0,     0,     0,   582,   583,
     584,   585,   586,   587,     0,     0,     0,   229,     0,     0,
     230,    81,    82,    83,   372,    85,    86,     0,    87,    88,
      89,   373,     0,   374,     0,    93,     0,    95,    96,    97,
      98,    99,   100,     0,   101,   102,   103,   375,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   116,   376,   377,     0,     0,     0,
     378,   379,     0,     0,     0,     0,   380,     0,     0,     0,
       0,     0,     0,     0,     0,   381,     0,   382,     0,   383,
     384,     0,   385,   386,   387,   388,   389,   390,   391,   392,
       0,   393,   394,     0,     0,     0,     0,     0,  2586,     0,
     395,   396,     0,   397,     0,   398,   399,   400,     0,   134,
       0,   136,     0,     0,   401,   402,     0,   403,   404,     0,
       0,   405,   406,   137,   407,     0,   408,   409,   410,   411,
     141,     0,     0,   412,   413,   414,   415,   416,     0,   417,
     418,   144,   419,     0,   420,   421,   422,     0,   423,     0,
       0,     0,     0,     0,   424,   425,   426,   427,   428,   150,
     151,   429,     0,   430,     0,   431,     0,   432,   433,   434,
       0,   435,     0,     0,   436,   437,   438,   439,     0,   440,
     441,   442,     0,   443,     0,   444,   445,   446,   157,   447,
       0,   159,     0,   448,   449,   161,     0,   450,     0,   451,
       0,     0,     0,   452,     0,   453,     0,   454,   166,     0,
     455,     0,   456,   457,   458,   459,     0,   460,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   169,
       0,   469,   470,   471,     0,   171,     0,   172,     0,     0,
       0,     0,   472,     0,   473,   474,   475,   476,   477,     0,
     176,     0,   478,     0,     0,   479,   480,   481,     0,     0,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   183,     0,   185,     0,   493,   494,   495,   496,   497,
     498,   499,   186,   500,     0,   501,   502,     0,   503,     0,
     189,   190,   504,   505,     0,     0,   506,     0,     0,     0,
     507,   508,     0,     0,   191,     0,     0,   194,   509,   510,
     511,   512,     0,   195,   196,   513,   514,   515,     0,   516,
     517,   518,   519,   520,   521,   198,   522,   523,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,     0,   533,
     534,     0,   535,   536,   206,   537,   538,   539,   540,   541,
     542,     0,     0,   543,   544,   545,     0,   546,   210,   547,
     548,     0,   549,   213,     0,   550,   551,   552,   553,   554,
     555,   556,   557,   215,   558,     0,   559,   560,     0,   561,
     562,   563,   564,     0,   216,   217,     0,     0,   566,   218,
     567,   219,     0,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,   576,     0,     0,   577,   578,     0,   579,
     227,   580,     0,   581,     0,     0,     0,   582,   583,   584,
     585,   586,   587,     0,     0,     0,   229,     0,     0,   230,
      81,    82,    83,   372,    85,    86,     0,    87,    88,    89,
     373,     0,   374,     0,    93,     0,    95,    96,    97,    98,
      99,   100,     0,   101,   102,   103,   375,     0,     0,   105,
     106,   107,   108,     0,     0,     0,   110,   111,   112,     0,
     113,     0,     0,   116,   376,   377,     0,     0,     0,   378,
     379,     0,     0,     0,     0,   380,     0,     0,     0,     0,
       0,     0,     0,     0,   381,     0,   382,     0,   383,   384,
       0,   385,   386,   387,   388,   389,   390,   391,   392,     0,
     393,   394,     0,     0,     0,     0,     0,  2599,     0,   395,
     396,     0,   397,     0,   398,   399,   400,     0,   134,     0,
     136,     0,     0,   401,   402,     0,   403,   404,     0,     0,
     405,   406,   137,   407,     0,   408,   409,   410,   411,   141,
       0,     0,   412,   413,   414,   415,   416,     0,   417,   418,
     144,   419,     0,   420,   421,   422,     0,   423,     0,     0,
       0,     0,     0,   424,   425,   426,   427,   428,   150,   151,
     429,     0,   430,     0,   431,     0,   432,   433,   434,     0,
     435,     0,     0,   436,   437,   438,   439,     0,   440,   441,
     442,     0,   443,     0,   444,   445,   446,   157,   447,     0,
     159,     0,   448,   449,   161,     0,   450,     0,   451,     0,
       0,     0,   452,     0,   453,     0,   454,   166,     0,   455,
       0,   456,   457,   458,   459,     0,   460,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   169,     0,
     469,   470,   471,     0,   171,     0,   172,     0,     0,     0,
       0,   472,     0,   473,   474,   475,   476,   477,     0,   176,
       0,   478,     0,     0,   479,   480,   481,     0,     0,   482,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     183,     0,   185,     0,   493,   494,   495,   496,   497,   498,
     499,   186,   500,     0,   501,   502,     0,   503,     0,   189,
     190,   504,   505,     0,     0,   506,     0,     0,     0,   507,
     508,     0,     0,   191,     0,     0,   194,   509,   510,   511,
     512,     0,   195,   196,   513,   514,   515,     0,   516,   517,
     518,   519,   520,   521,   198,   522,   523,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,     0,   533,   534,
       0,   535,   536,   206,   537,   538,   539,   540,   541,   542,
       0,     0,   543,   544,   545,     0,   546,   210,   547,   548,
       0,   549,   213,     0,   550,   551,   552,   553,   554,   555,
     556,   557,   215,   558,     0,   559,   560,     0,   561,   562,
     563,   564,     0,   216,   217,     0,     0,   566,   218,   567,
     219,     0,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,   576,     0,     0,   577,   578,     0,   579,   227,
     580,     0,   581,     0,     0,     0,   582,   583,   584,   585,
     586,   587,     0,     0,     0,   229,     0,     0,   230,    81,
      82,    83,   372,    85,    86,     0,    87,    88,    89,   373,
       0,   374,     0,    93,     0,    95,    96,    97,    98,    99,
     100,     0,   101,   102,   103,   375,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   116,   376,   377,     0,     0,     0,   378,   379,
       0,     0,     0,     0,   380,     0,     0,     0,     0,     0,
       0,     0,     0,   381,     0,   382,     0,   383,   384,     0,
     385,   386,   387,   388,   389,   390,   391,   392,     0,   393,
     394,     0,     0,     0,     0,     0,     0,     0,   395,   396,
       0,   397,     0,   398,   399,   400,     0,   134,     0,   136,
       0,     0,   401,   402,     0,   403,   404,     0,     0,   405,
     406,   137,   407,     0,   408,   409,   410,   411,   141,     0,
       0,   412,   413,   414,   415,   416,     0,   417,   418,   144,
     419,     0,   420,   421,   422,     0,   423,     0,     0,     0,
       0,     0,   424,   425,   426,   427,   428,   150,   151,   429,
       0,   430,     0,   431,     0,   432,   433,   434,     0,   435,
       0,     0,   436,   437,   438,   439,     0,   440,   441,   442,
       0,   443,     0,   444,   445,   446,   157,   447,     0,   159,
       0,   448,   449,   161,     0,   450,     0,   451,     0,     0,
       0,   452,     0,   453,     0,   454,   166,  2628,   455,     0,
     456,   457,   458,   459,     0,   460,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   169,     0,   469,
     470,   471,     0,   171,     0,   172,     0,     0,     0,     0,
     472,     0,   473,   474,   475,   476,   477,     0,   176,     0,
     478,     0,     0,   479,   480,   481,     0,     0,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   183,
       0,   185,     0,   493,   494,   495,   496,   497,   498,   499,
     186,   500,     0,   501,   502,     0,   503,     0,   189,   190,
     504,   505,     0,     0,   506,     0,     0,     0,   507,   508,
       0,     0,   191,     0,     0,   194,   509,   510,   511,   512,
       0,   195,   196,   513,   514,   515,     0,   516,   517,   518,
     519,   520,   521,   198,   522,   523,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,     0,   533,   534,     0,
     535,   536,   206,   537,   538,   539,   540,   541,   542,     0,
       0,   543,   544,   545,     0,   546,   210,   547,   548,     0,
     549,   213,     0,   550,   551,   552,   553,   554,   555,   556,
     557,   215,   558,     0,   559,   560,     0,   561,   562,   563,
     564,     0,   216,   217,     0,     0,   566,   218,   567,   219,
       0,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,   576,     0,     0,   577,   578,     0,   579,   227,   580,
       0,   581,     0,     0,     0,   582,   583,   584,   585,   586,
     587,     0,     0,     0,   229,     0,     0,   230,    81,    82,
      83,   372,    85,    86,     0,    87,    88,    89,   373,     0,
     374,     0,    93,     0,    95,    96,    97,    98,    99,   100,
       0,   101,   102,   103,   375,     0,     0,   105,   106,   107,
     108,     0,     0,     0,   110,   111,   112,     0,   113,     0,
       0,   116,   376,   377,     0,     0,     0,   378,   379,     0,
       0,     0,     0,   380,     0,     0,     0,     0,     0,     0,
       0,     0,   381,     0,   382,     0,   383,   384,     0,   385,
     386,   387,   388,   389,   390,   391,   392,     0,   393,   394,
       0,     0,     0,     0,     0,     0,     0,   395,   396,     0,
     397,     0,   398,   399,   400,     0,   134,     0,   136,     0,
       0,   401,   402,     0,   403,   404,     0,     0,   405,   406,
     137,   407,     0,   408,   409,   410,   411,   141,     0,     0,
     412,   413,   414,   415,   416,     0,   417,   418,   144,   419,
       0,   420,   421,   422,     0,   423,     0,     0,     0,     0,
       0,   424,   425,   426,   427,   428,   150,   151,   429,  2908,
     430,     0,   431,     0,   432,   433,   434,     0,   435,     0,
       0,   436,   437,   438,   439,     0,   440,   441,   442,     0,
     443,     0,   444,   445,   446,   157,   447,     0,   159,     0,
     448,   449,   161,     0,   450,     0,   451,     0,     0,     0,
     452,     0,   453,     0,   454,   166,     0,   455,     0,   456,
     457,   458,   459,     0,   460,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   169,     0,   469,   470,
     471,     0,   171,     0,   172,     0,     0,     0,     0,   472,
       0,   473,   474,   475,   476,   477,     0,   176,     0,   478,
       0,     0,   479,   480,   481,     0,     0,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   183,     0,
     185,     0,   493,   494,   495,   496,   497,   498,   499,   186,
     500,     0,   501,   502,     0,   503,     0,   189,   190,   504,
     505,     0,     0,   506,     0,     0,     0,   507,   508,     0,
       0,   191,     0,     0,   194,   509,   510,   511,   512,     0,
     195,   196,   513,   514,   515,     0,   516,   517,   518,   519,
     520,   521,   198,   522,   523,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,     0,   533,   534,     0,   535,
     536,   206,   537,   538,   539,   540,   541,   542,     0,     0,
     543,   544,   545,     0,   546,   210,   547,   548,     0,   549,
     213,     0,   550,   551,   552,   553,   554,   555,   556,   557,
     215,   558,     0,   559,   560,     0,   561,   562,   563,   564,
       0,   216,   217,     0,     0,   566,   218,   567,   219,     0,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
     576,     0,     0,   577,   578,     0,   579,   227,   580,     0,
     581,     0,     0,     0,   582,   583,   584,   585,   586,   587,
       0,     0,     0,   229,     0,     0,   230,    81,    82,    83,
     372,    85,    86,     0,    87,    88,    89,   373,     0,   374,
       0,    93,     0,    95,    96,    97,    98,    99,   100,     0,
     101,   102,   103,   375,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     116,   376,   377,     0,     0,     0,   378,   379,     0,     0,
       0,     0,   380,     0,     0,     0,     0,     0,     0,     0,
       0,   381,     0,   382,     0,   383,   384,     0,   385,   386,
     387,   388,   389,   390,   391,   392,     0,   393,   394,     0,
       0,     0,     0,     0,     0,     0,   395,   396,     0,   397,
       0,   398,   399,   400,     0,   134,     0,   136,     0,     0,
     401,   402,     0,   403,   404,     0,     0,   405,   406,   137,
     407,     0,   408,   409,   410,   411,   141,     0,     0,   412,
     413,   414,   415,   416,     0,   417,   418,   144,   419,     0,
     420,   421,   422,     0,   423,     0,     0,     0,     0,     0,
     424,   425,   426,   427,   428,   150,   151,   429,  2910,   430,
       0,   431,     0,   432,   433,   434,     0,   435,     0,     0,
     436,   437,   438,   439,     0,   440,   441,   442,     0,   443,
       0,   444,   445,   446,   157,   447,     0,   159,     0,   448,
     449,   161,     0,   450,     0,   451,     0,     0,     0,   452,
       0,   453,     0,   454,   166,     0,   455,     0,   456,   457,
     458,   459,     0,   460,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   169,     0,   469,   470,   471,
       0,   171,     0,   172,     0,     0,     0,     0,   472,     0,
     473,   474,   475,   476,   477,     0,   176,     0,   478,     0,
       0,   479,   480,   481,     0,     0,   482,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   183,     0,   185,
       0,   493,   494,   495,   496,   497,   498,   499,   186,   500,
       0,   501,   502,     0,   503,     0,   189,   190,   504,   505,
       0,     0,   506,     0,     0,     0,   507,   508,     0,     0,
     191,     0,     0,   194,   509,   510,   511,   512,     0,   195,
     196,   513,   514,   515,     0,   516,   517,   518,   519,   520,
     521,   198,   522,   523,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,     0,   533,   534,     0,   535,   536,
     206,   537,   538,   539,   540,   541,   542,     0,     0,   543,
     544,   545,     0,   546,   210,   547,   548,     0,   549,   213,
       0,   550,   551,   552,   553,   554,   555,   556,   557,   215,
     558,     0,   559,   560,     0,   561,   562,   563,   564,     0,
     216,   217,     0,     0,   566,   218,   567,   219,     0,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,   576,
       0,     0,   577,   578,     0,   579,   227,   580,     0,   581,
       0,     0,     0,   582,   583,   584,   585,   586,   587,     0,
       0,     0,   229,     0,     0,   230,    81,    82,    83,   372,
      85,    86,     0,    87,    88,    89,   373,     0,   374,     0,
      93,     0,    95,    96,    97,    98,    99,   100,     0,   101,
     102,   103,   375,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   116,
     376,   377,     0,     0,     0,   378,   379,     0,     0,     0,
       0,   380,     0,     0,     0,     0,     0,     0,     0,     0,
     381,     0,   382,     0,   383,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,     0,   393,   394,     0,     0,
       0,     0,     0,     0,     0,   395,   396,     0,   397,     0,
     398,   399,   400,     0,   134,     0,   136,     0,     0,   401,
     402,     0,   403,   404,     0,     0,   405,   406,   137,   407,
       0,   408,   409,   410,   411,   141,     0,     0,   412,   413,
     414,   415,   416,     0,   417,   418,   144,   419,     0,   420,
     421,   422,     0,   423,     0,     0,     0,     0,     0,   424,
     425,   426,   427,   428,   150,   151,   429,  2912,   430,     0,
     431,     0,   432,   433,   434,     0,   435,     0,     0,   436,
     437,   438,   439,     0,   440,   441,   442,     0,   443,     0,
     444,   445,   446,   157,   447,     0,   159,     0,   448,   449,
     161,     0,   450,     0,   451,     0,     0,     0,   452,     0,
     453,     0,   454,   166,     0,   455,     0,   456,   457,   458,
     459,     0,   460,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   169,     0,   469,   470,   471,     0,
     171,     0,   172,     0,     0,     0,     0,   472,     0,   473,
     474,   475,   476,   477,     0,   176,     0,   478,     0,     0,
     479,   480,   481,     0,     0,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   183,     0,   185,     0,
     493,   494,   495,   496,   497,   498,   499,   186,   500,     0,
     501,   502,     0,   503,     0,   189,   190,   504,   505,     0,
       0,   506,     0,     0,     0,   507,   508,     0,     0,   191,
       0,     0,   194,   509,   510,   511,   512,     0,   195,   196,
     513,   514,   515,     0,   516,   517,   518,   519,   520,   521,
     198,   522,   523,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,     0,   533,   534,     0,   535,   536,   206,
     537,   538,   539,   540,   541,   542,     0,     0,   543,   544,
     545,     0,   546,   210,   547,   548,     0,   549,   213,     0,
     550,   551,   552,   553,   554,   555,   556,   557,   215,   558,
       0,   559,   560,     0,   561,   562,   563,   564,     0,   216,
     217,     0,     0,   566,   218,   567,   219,     0,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,   576,     0,
       0,   577,   578,     0,   579,   227,   580,     0,   581,     0,
       0,     0,   582,   583,   584,   585,   586,   587,     0,     0,
       0,   229,     0,     0,   230,    81,    82,    83,   372,    85,
      86,     0,    87,    88,    89,   373,     0,   374,     0,    93,
       0,    95,    96,    97,    98,    99,   100,     0,   101,   102,
     103,   375,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   116,   376,
     377,     0,     0,     0,   378,   379,     0,     0,     0,     0,
     380,     0,     0,     0,     0,     0,     0,     0,     0,   381,
       0,   382,     0,   383,   384,     0,   385,   386,   387,   388,
     389,   390,   391,   392,     0,   393,   394,     0,     0,     0,
       0,     0,     0,     0,   395,   396,     0,   397,     0,   398,
     399,   400,     0,   134,     0,   136,     0,     0,   401,   402,
       0,   403,   404,     0,     0,   405,   406,   137,   407,     0,
     408,   409,   410,   411,   141,     0,     0,   412,   413,   414,
     415,   416,     0,   417,   418,   144,   419,     0,   420,   421,
     422,     0,   423,     0,     0,     0,     0,     0,   424,   425,
     426,   427,   428,   150,   151,   429,     0,   430,     0,   431,
       0,   432,   433,   434,     0,   435,     0,     0,   436,   437,
     438,   439,     0,   440,   441,   442,     0,   443,     0,   444,
     445,   446,   157,   447,     0,   159,     0,   448,   449,   161,
       0,   450,     0,   451,     0,     0,     0,   452,     0,   453,
       0,   454,   166,     0,   455,     0,   456,   457,   458,   459,
       0,   460,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   169,     0,   469,   470,   471,     0,   171,
       0,   172,     0,     0,     0,     0,   472,     0,   473,   474,
     475,   476,   477,     0,   176,     0,   478,     0,     0,   479,
     480,   481,     0,     0,   482,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   183,     0,   185,     0,   493,
     494,   495,   496,   497,   498,   499,   186,   500,     0,   501,
     502,     0,   503,     0,   189,   190,   504,   505,     0,     0,
     506,     0,     0,     0,   507,   508,     0,     0,   191,     0,
       0,   194,   509,   510,   511,   512,     0,   195,   196,   513,
     514,   515,     0,   516,   517,   518,   519,   520,   521,   198,
     522,   523,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,     0,   533,   534,     0,   535,   536,   206,   537,
     538,   539,   540,   541,   542,     0,     0,   543,   544,   545,
       0,   546,   210,   547,   548,     0,   549,   213,     0,   550,
     551,   552,   553,   554,   555,   556,   557,   215,   558,     0,
     559,   560,     0,   561,   562,   563,   564,     0,   216,   217,
       0,     0,   566,   218,   567,   219,     0,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,   576,     0,  3414,
     577,   578,     0,   579,   227,   580,     0,   581,     0,     0,
       0,   582,   583,   584,   585,   586,   587,     0,     0,     0,
     229,     0,     0,   230,    81,    82,    83,   372,    85,    86,
       0,    87,    88,    89,   373,     0,   374,     0,    93,     0,
      95,    96,    97,    98,    99,   100,     0,   101,   102,   103,
     375,     0,     0,   105,   106,   107,   108,     0,     0,     0,
     110,   111,   112,     0,   113,     0,     0,   116,   376,   377,
       0,     0,     0,   378,   379,     0,     0,     0,     0,   380,
       0,     0,     0,     0,     0,     0,     0,     0,   381,     0,
     382,     0,   383,   384,     0,   385,   386,   387,   388,   389,
     390,   391,   392,     0,   393,   394,     0,     0,     0,     0,
       0,     0,     0,   395,   396,     0,   397,     0,   398,   399,
     400,     0,   134,     0,   136,     0,     0,   401,   402,     0,
     403,   404,     0,     0,   405,   406,   137,   407,     0,   408,
     409,   410,   411,   141,     0,     0,   412,   413,   414,   415,
     416,     0,   417,   418,   144,   419,     0,   420,   421,   422,
       0,   423,     0,     0,     0,     0,     0,   424,   425,   426,
     427,   428,   150,   151,   429,     0,   430,     0,   431,     0,
     432,   433,   434,     0,   435,     0,     0,   436,   437,   438,
     439,     0,   440,   441,   442,     0,   443,     0,   444,   445,
     446,   157,   447,     0,   159,     0,   448,   449,   161,     0,
     450,     0,   451,     0,     0,     0,   452,     0,   453,     0,
     454,   166,     0,   455,     0,   456,   457,   458,   459,     0,
     460,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   169,     0,   469,   470,   471,     0,   171,     0,
     172,     0,     0,     0,     0,   472,     0,   473,   474,   475,
     476,   477,     0,   176,     0,   478,     0,     0,   479,   480,
     481,     0,     0,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   183,     0,   185,     0,   493,   494,
     495,   496,   497,   498,   499,   186,   500,     0,   501,   502,
       0,   503,     0,   189,   190,   504,   505,     0,     0,   506,
       0,     0,     0,   507,   508,     0,     0,   191,     0,     0,
     194,   509,   510,   511,   512,     0,   195,   196,   513,   514,
     515,     0,   516,   517,   518,   519,   520,   521,   198,   522,
     523,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,     0,   533,   534,     0,   535,   536,   206,   537,   538,
     539,   540,   541,   542,     0,     0,   543,   544,   545,     0,
     546,   210,   547,   548,     0,   549,   213,     0,   550,   551,
     552,   553,   554,   555,   556,   557,   215,   558,     0,   559,
     560,     0,   561,   562,   563,   564,     0,   216,   217,     0,
       0,   566,   218,   567,   219,     0,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,   576,     0,     0,   577,
     578,     0,   579,   227,   580,     0,   581,     0,     0,     0,
     582,   583,   584,   585,   586,   587,     0,     0,     0,   229,
       0,     0,   230,    81,    82,    83,   372,    85,    86,     0,
      87,    88,    89,   373,     0,   374,     0,    93,     0,    95,
      96,    97,    98,    99,   100,     0,   101,   102,   103,   375,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   116,   376,   377,     0,
       0,     0,   378,   379,     0,     0,     0,     0,   380,     0,
       0,     0,     0,     0,     0,     0,     0,   381,     0,   382,
       0,   383,   384,     0,   385,   386,   387,   388,   389,   390,
     391,   392,     0,   393,   394,     0,     0,     0,     0,     0,
       0,     0,   395,   396,     0,   397,     0,   398,   399,   400,
       0,   134,     0,   136,     0,     0,   401,   402,     0,   403,
     404,     0,     0,   405,   406,   137,   407,     0,   408,   409,
     410,   411,   141,     0,     0,   412,   413,   414,   415,   416,
       0,   417,   418,   144,   419,     0,   420,   421,   422,     0,
     423,     0,     0,     0,     0,     0,   424,   425,   426,   427,
     428,   150,   151,   429,     0,   430,     0,   431,     0,   432,
     433,   434,     0,   435,     0,     0,   436,   437,   438,   439,
       0,   440,   441,   442,     0,   443,     0,   444,   445,   446,
     157,   447,     0,   159,     0,   448,   449,   161,     0,   450,
       0,   451,     0,     0,     0,   452,     0,   453,     0,   454,
     166,     0,   455,     0,   456,   457,   458,   459,     0,   460,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   169,     0,   469,   470,   471,     0,   171,     0,   172,
       0,     0,     0,     0,   472,     0,   473,   474,   475,   476,
     477,     0,   176,     0,   478,     0,     0,   479,   480,   481,
       0,     0,   482,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   183,     0,   185,     0,   493,   494,   495,
     496,   497,   498,   499,   186,   500,     0,   501,   502,     0,
     503,     0,   189,   190,   504,   505,     0,     0,   506,     0,
       0,     0,   507,   508,     0,     0,   191,     0,     0,   194,
     509,   510,   511,   512,     0,   195,   196,   513,   514,   515,
       0,   516,   517,   518,   519,   520,   521,   198,   522,   523,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
       0,   533,   534,     0,   535,   536,   206,   537,   538,   539,
     540,   541,   542,     0,     0,   543,   544,   545,     0,   546,
     210,   547,   548,     0,   549,   213,     0,   550,   551,   801,
     553,   554,   555,   556,   557,   215,   558,     0,   559,   560,
       0,   561,   562,   563,   564,     0,   216,   217,     0,     0,
     566,   218,   567,   219,     0,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,   576,     0,     0,   577,   578,
       0,   579,   227,   580,     0,   581,     0,     0,     0,   582,
     583,   584,   585,   586,   587,     0,     0,     0,   229,     0,
       0,   230,    81,    82,    83,   372,    85,    86,     0,    87,
      88,    89,   373,     0,   374,     0,    93,     0,    95,    96,
      97,    98,    99,   100,     0,   101,   102,   103,   375,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   116,   376,   377,     0,     0,
       0,   378,   379,     0,     0,     0,     0,   380,     0,     0,
       0,     0,     0,     0,     0,     0,   381,     0,   382,     0,
     383,   384,     0,   385,   386,   387,   388,   389,   390,   391,
     392,     0,   393,   394,     0,     0,     0,     0,     0,     0,
       0,   395,   396,     0,   397,     0,   398,   399,   400,     0,
     134,     0,   136,     0,     0,   401,   402,     0,   403,   404,
       0,     0,   405,   406,   137,   407,     0,   408,   409,   410,
     411,   141,     0,     0,   412,   413,   414,   415,   416,     0,
     417,   418,   144,   419,     0,   420,   421,   422,     0,   423,
       0,     0,     0,     0,     0,   424,   425,   426,   427,   428,
     150,   151,   429,     0,   430,     0,   431,     0,   432,   433,
     434,     0,   435,     0,     0,   436,   437,   438,   439,     0,
     440,   441,   442,     0,   443,     0,   444,   445,   446,   157,
     447,     0,   159,     0,   448,   449,   161,     0,   450,     0,
     451,     0,     0,     0,   452,     0,   453,     0,   454,   166,
       0,   455,     0,   456,   457,   458,   459,     0,   460,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,     0,
     169,     0,   469,   470,   471,     0,   171,     0,   172,     0,
       0,     0,     0,   472,     0,   473,   474,   475,   476,   477,
       0,   176,     0,   478,     0,     0,   479,   480,   481,     0,
       0,   482,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   183,     0,   185,     0,   493,   494,   495,   496,
     497,   498,   499,   186,   500,     0,   501,   502,     0,   503,
       0,   189,   190,   504,   505,     0,     0,   506,     0,     0,
       0,   507,   508,     0,     0,   191,     0,     0,   194,   509,
     510,   511,   512,     0,   195,   196,   513,   514,   515,     0,
     516,   517,   518,   519,   520,   521,   198,   522,   523,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,     0,
     533,   534,     0,   535,   536,   206,   537,   538,   879,   540,
     541,   542,     0,     0,   543,   544,   545,     0,   546,   210,
     547,   548,     0,   549,   213,     0,   550,   551,   552,   553,
     554,   555,   556,   557,   215,   558,     0,   559,   560,     0,
     561,   562,   563,   564,     0,   216,   217,     0,     0,   566,
     218,   567,   219,     0,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,   576,     0,     0,   577,   578,     0,
     579,   227,   580,     0,   581,     0,     0,     0,   582,   583,
     584,   585,   586,   587,     0,     0,     0,   229,     0,     0,
     230,    81,    82,    83,   372,    85,    86,     0,    87,    88,
      89,   373,     0,   374,     0,    93,     0,    95,    96,    97,
      98,    99,   100,     0,   101,   102,   103,   375,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   116,   376,   377,     0,     0,     0,
     378,   379,     0,     0,     0,     0,   380,     0,     0,     0,
       0,     0,     0,     0,     0,   381,     0,   382,     0,   383,
     384,     0,   385,   386,   387,   388,   389,   390,   391,   392,
     881,   393,   394,     0,     0,     0,     0,     0,     0,     0,
     395,   396,     0,   397,     0,   398,   399,   400,     0,   134,
       0,   136,     0,     0,   401,   402,     0,   403,   404,     0,
       0,   405,   882,   137,   407,     0,   408,   409,   410,   411,
     141,     0,     0,   412,   413,   414,   415,     0,     0,   417,
     418,   144,   419,     0,   420,   421,   422,     0,   423,     0,
       0,     0,     0,     0,   424,   425,   426,   427,   428,   150,
     151,   429,     0,   430,     0,   431,     0,   432,   433,   434,
       0,   435,     0,     0,   436,   437,   438,   439,     0,   440,
     441,   442,     0,   443,     0,   444,   445,   446,   157,   447,
       0,   159,     0,   448,   449,   161,     0,   450,     0,   451,
       0,     0,     0,   452,     0,   453,     0,   454,   166,     0,
     455,     0,   456,   457,   458,   459,     0,   460,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   169,
       0,   469,   470,   471,     0,   171,     0,   172,     0,     0,
       0,     0,   472,     0,   473,   474,   475,   476,   477,     0,
     176,     0,   478,     0,     0,   479,   480,   481,     0,     0,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     492,   183,     0,   185,     0,   493,   494,   495,   496,   497,
     498,   499,   186,   500,     0,   501,   502,     0,   503,     0,
     189,   190,   504,   505,     0,     0,   506,     0,     0,     0,
     507,   508,     0,     0,   191,     0,     0,   194,   509,   510,
     511,   512,     0,   195,   196,   513,   514,   515,     0,   516,
     517,   518,   519,   520,   521,   198,   522,   523,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,     0,   533,
     534,     0,   535,   536,   206,   537,   538,   539,   540,   541,
     542,     0,     0,   543,   544,   883,     0,   546,   210,   547,
     548,     0,   549,   213,     0,   550,   551,   552,   553,   554,
     555,   556,   557,   215,   558,     0,   559,   560,     0,   561,
     562,   563,   564,     0,   884,   217,     0,     0,   885,   218,
     567,   219,     0,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,   576,     0,     0,   577,   578,     0,   886,
     227,   580,     0,   581,     0,     0,     0,   582,   583,   584,
     585,   586,   587,     0,     0,     0,   229,     0,     0,   230,
      81,    82,    83,   372,    85,    86,     0,    87,    88,    89,
     373,     0,   374,     0,    93,     0,    95,    96,    97,    98,
      99,   100,     0,   101,   102,   103,   375,     0,     0,   105,
     106,   107,   108,     0,     0,     0,   110,   111,   112,     0,
     113,     0,     0,   116,   376,   377,     0,     0,     0,   378,
     379,     0,     0,     0,     0,   380,     0,     0,     0,     0,
       0,     0,     0,     0,   381,     0,   382,     0,   383,   384,
       0,   385,   386,   387,   388,   389,   390,   391,   392,   916,
     393,   394,     0,     0,     0,     0,     0,     0,     0,   395,
     396,     0,   397,     0,   398,   399,   400,     0,   134,     0,
     136,     0,     0,   401,   402,     0,   403,   404,     0,     0,
     405,   882,   137,   407,     0,   408,   409,   410,   411,   141,
       0,     0,   412,   413,   414,   415,     0,     0,   417,   418,
     144,   419,     0,   420,   421,   422,     0,   423,     0,     0,
       0,     0,     0,   424,   425,   426,   427,   428,   150,   151,
     429,     0,   430,     0,   431,     0,   432,   433,   434,     0,
     435,     0,     0,   436,   437,   438,   439,     0,   440,   441,
     442,     0,   443,     0,   444,   445,   446,   157,   447,     0,
     159,     0,   448,   449,   161,     0,   450,     0,   451,     0,
       0,     0,   452,     0,   453,     0,   454,   166,     0,   455,
       0,   456,   457,   458,   459,     0,   460,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   169,     0,
     469,   470,   471,     0,   171,     0,   172,     0,     0,     0,
       0,   472,     0,   473,   474,   475,   476,   477,     0,   176,
       0,   478,     0,     0,   479,   480,   481,     0,     0,   482,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     183,     0,   185,     0,   493,   494,   495,   496,   497,   498,
     499,   186,   500,     0,   501,   502,     0,   503,     0,   189,
     190,   504,   505,     0,     0,   506,     0,     0,     0,   507,
     508,     0,     0,   191,     0,     0,   194,   509,   510,   511,
     512,     0,   195,   196,   513,   514,   515,     0,   516,   517,
     518,   519,   520,   521,   198,   522,   523,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,     0,   533,   534,
       0,   535,   536,   206,   537,   538,   539,   540,   541,   542,
       0,     0,   543,   544,   917,     0,   546,   210,   547,   548,
       0,   549,   213,     0,   550,   551,   552,   553,   554,   555,
     556,   557,   215,   558,     0,   559,   560,     0,   561,   562,
     563,   564,     0,   918,   217,     0,     0,   919,   218,   567,
     219,     0,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,   576,     0,     0,   577,   578,     0,   886,   227,
     580,     0,   581,     0,     0,     0,   582,   583,   584,   585,
     586,   587,     0,     0,     0,   229,     0,     0,   230,    81,
      82,    83,   372,    85,    86,     0,    87,    88,    89,   373,
       0,   374,     0,    93,     0,    95,    96,    97,    98,    99,
     100,     0,   101,   102,   103,   375,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   116,   376,   377,     0,     0,     0,   378,   379,
       0,     0,     0,     0,   380,     0,     0,     0,     0,     0,
       0,     0,     0,   381,     0,   382,     0,   383,   384,     0,
     385,   386,   387,   388,   389,   390,   391,   392,     0,   393,
     394,     0,     0,     0,     0,     0,     0,     0,   395,   396,
       0,   397,     0,   398,   399,   400,     0,   134,     0,   136,
       0,     0,   401,   402,     0,   403,   404,     0,     0,   405,
     406,   137,   407,     0,   408,   409,   410,   411,   141,     0,
       0,   412,   413,   414,   415,   416,     0,   417,   418,   144,
     419,     0,   420,   421,   422,     0,   423,     0,     0,     0,
       0,     0,   424,   425,   426,   427,   428,   150,   151,   429,
       0,   430,     0,   431,     0,   432,   433,   434,     0,   435,
       0,     0,   436,   437,   438,   439,     0,   440,   441,   442,
       0,   443,     0,   444,   445,   446,   157,   447,     0,   159,
       0,   448,   449,   161,     0,   450,     0,   451,     0,     0,
       0,   452,     0,   453,     0,   454,   166,     0,   455,     0,
     456,   457,   458,  1139,     0,   460,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   169,     0,   469,
     470,   471,     0,   171,     0,   172,     0,     0,     0,     0,
     472,     0,   473,   474,   475,   476,   477,     0,   176,     0,
     478,     0,     0,   479,   480,   481,     0,     0,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   183,
       0,   185,     0,   493,   494,   495,   496,   497,   498,   499,
     186,   500,     0,   501,   502,     0,   503,     0,   189,   190,
     504,   505,     0,     0,   506,     0,     0,     0,   507,   508,
       0,     0,   191,     0,     0,   194,   509,   510,   511,   512,
       0,   195,   196,   513,   514,   515,     0,   516,   517,   518,
     519,   520,   521,   198,   522,   523,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,     0,   533,   534,     0,
     535,   536,   206,   537,   538,   539,   540,   541,   542,     0,
       0,   543,   544,   545,     0,   546,   210,   547,   548,     0,
     549,   213,     0,   550,   551,   552,   553,   554,   555,   556,
     557,   215,   558,     0,   559,   560,     0,   561,   562,   563,
     564,     0,   216,   217,     0,     0,   566,   218,   567,   219,
       0,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,   576,     0,     0,   577,   578,     0,   579,   227,   580,
       0,   581,     0,     0,     0,   582,   583,   584,   585,   586,
     587,     0,     0,     0,   229,     0,     0,   230,    81,    82,
      83,   372,    85,    86,     0,    87,    88,    89,   373,     0,
     374,     0,    93,     0,    95,    96,    97,    98,    99,   100,
       0,   101,   102,   103,   375,     0,     0,   105,   106,   107,
     108,     0,     0,     0,   110,   111,   112,     0,   113,     0,
       0,   116,   376,   377,     0,     0,     0,   378,   379,     0,
       0,     0,     0,   380,     0,     0,     0,     0,     0,     0,
       0,     0,   381,     0,   382,     0,   383,   384,     0,   385,
     386,   387,   388,   389,   390,   391,   392,     0,   393,   394,
       0,     0,     0,     0,     0,     0,     0,   395,   396,     0,
     397,     0,   398,   399,   400,     0,   134,     0,   136,     0,
       0,   401,   402,     0,   403,   404,     0,     0,   405,   406,
     137,   407,     0,   408,   409,   410,   411,   141,     0,     0,
     412,   413,   414,   415,   416,     0,   417,   418,   144,   419,
       0,   420,   421,   422,     0,   423,     0,     0,     0,     0,
       0,   424,   425,   426,   427,   428,   150,   151,   429,     0,
     430,     0,   431,     0,   432,   433,   434,     0,   435,     0,
       0,   436,   437,   438,   439,     0,   440,   441,   442,     0,
     443,     0,   444,   445,   446,   157,   447,     0,   159,     0,
     448,   449,   161,     0,   450,     0,   451,     0,     0,     0,
     452,     0,   453,     0,   454,   166,     0,   455,     0,   456,
     457,   458,  1143,     0,   460,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   169,     0,   469,   470,
     471,     0,   171,     0,   172,     0,     0,     0,     0,   472,
       0,   473,   474,   475,   476,   477,     0,   176,     0,   478,
       0,     0,   479,   480,   481,     0,     0,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   183,     0,
     185,     0,   493,   494,   495,   496,   497,   498,   499,   186,
     500,     0,   501,   502,     0,   503,     0,   189,   190,   504,
     505,     0,     0,   506,     0,     0,     0,   507,   508,     0,
       0,   191,     0,     0,   194,   509,   510,   511,   512,     0,
     195,   196,   513,   514,   515,     0,   516,   517,   518,   519,
     520,   521,   198,   522,   523,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,     0,   533,   534,     0,   535,
     536,   206,   537,   538,   539,   540,   541,   542,     0,     0,
     543,   544,   545,     0,   546,   210,   547,   548,     0,   549,
     213,     0,   550,   551,   552,   553,   554,   555,   556,   557,
     215,   558,     0,   559,   560,     0,   561,   562,   563,   564,
       0,   216,   217,     0,     0,   566,   218,   567,   219,     0,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
     576,     0,     0,   577,   578,     0,   579,   227,   580,     0,
     581,     0,     0,     0,   582,   583,   584,   585,   586,   587,
       0,     0,     0,   229,     0,     0,   230,    81,    82,    83,
     372,    85,    86,     0,    87,    88,    89,   373,     0,   374,
       0,    93,     0,    95,    96,    97,    98,    99,   100,     0,
     101,   102,   103,   375,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     116,   376,   377,     0,     0,     0,   378,   379,     0,     0,
       0,     0,   380,     0,     0,     0,     0,     0,     0,     0,
       0,   381,     0,   382,     0,   383,   384,     0,   385,   386,
     387,   388,   389,   390,   391,   392,     0,   393,   394,     0,
       0,     0,     0,     0,     0,     0,   395,   396,     0,   397,
       0,   398,   399,   400,     0,   134,     0,   136,     0,     0,
     401,   402,     0,   403,   404,     0,     0,   405,   406,   137,
     407,     0,   408,   409,   410,   411,   141,     0,     0,   412,
     413,   414,   415,   416,     0,   417,   418,   144,   419,     0,
     420,   421,   422,     0,   423,     0,     0,     0,     0,     0,
     424,   425,   426,   427,   428,   150,   151,   429,     0,   430,
       0,   431,     0,   432,   433,   434,     0,   435,     0,     0,
     436,   437,   438,   439,     0,   440,   441,   442,     0,   443,
       0,   444,   445,   446,   157,   447,     0,   159,     0,   448,
     449,   161,     0,   450,     0,   451,     0,     0,     0,   452,
       0,   453,     0,   454,   166,     0,   455,     0,   456,   457,
     458,  1150,     0,   460,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   169,     0,   469,   470,   471,
       0,   171,     0,   172,     0,     0,     0,     0,   472,     0,
     473,   474,   475,   476,   477,     0,   176,     0,   478,     0,
       0,   479,   480,   481,     0,     0,   482,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   183,     0,   185,
       0,   493,   494,   495,   496,   497,   498,   499,   186,   500,
       0,   501,   502,     0,   503,     0,   189,   190,   504,   505,
       0,     0,   506,     0,     0,     0,   507,   508,     0,     0,
     191,     0,     0,   194,   509,   510,   511,   512,     0,   195,
     196,   513,   514,   515,     0,   516,   517,   518,   519,   520,
     521,   198,   522,   523,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,     0,   533,   534,     0,   535,   536,
     206,   537,   538,   539,   540,   541,   542,     0,     0,   543,
     544,   545,     0,   546,   210,   547,   548,     0,   549,   213,
       0,   550,   551,   552,   553,   554,   555,   556,   557,   215,
     558,     0,   559,   560,     0,   561,   562,   563,   564,     0,
     216,   217,     0,     0,   566,   218,   567,   219,     0,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,   576,
       0,     0,   577,   578,     0,   579,   227,   580,     0,   581,
       0,     0,     0,   582,   583,   584,   585,   586,   587,     0,
       0,     0,   229,     0,     0,   230,    81,    82,    83,   372,
      85,    86,     0,    87,    88,    89,   373,     0,   374,     0,
      93,     0,    95,    96,    97,    98,    99,   100,     0,   101,
     102,   103,   375,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   116,
     376,   377,     0,     0,     0,   378,   379,     0,     0,     0,
       0,   380,     0,     0,     0,     0,     0,     0,     0,     0,
     381,     0,   382,     0,   383,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,     0,   393,   394,     0,     0,
       0,     0,     0,     0,     0,   395,   396,     0,   397,     0,
     398,   399,   400,     0,   134,     0,   136,     0,     0,   401,
     402,     0,   403,   404,     0,     0,   405,   406,   137,   407,
       0,   408,   409,   410,   411,   141,     0,     0,   412,   413,
     414,   415,   416,     0,   417,   418,   144,   419,     0,   420,
     421,   422,     0,   423,     0,     0,     0,     0,     0,   424,
     425,   426,   427,   428,   150,   151,   429,     0,   430,     0,
     431,     0,   432,   433,   434,     0,   435,     0,     0,   436,
     437,   438,   439,     0,   440,   441,   442,     0,   443,     0,
     444,   445,   446,   157,   447,     0,   159,     0,   448,   449,
     161,     0,   450,     0,   451,     0,     0,     0,   452,     0,
     453,     0,   454,   166,     0,   455,     0,   456,   457,   458,
    1152,     0,   460,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   169,     0,   469,   470,   471,     0,
     171,     0,   172,     0,     0,     0,     0,   472,     0,   473,
     474,   475,   476,   477,     0,   176,     0,   478,     0,     0,
     479,   480,   481,     0,     0,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   183,     0,   185,     0,
     493,   494,   495,   496,   497,   498,   499,   186,   500,     0,
     501,   502,     0,   503,     0,   189,   190,   504,   505,     0,
       0,   506,     0,     0,     0,   507,   508,     0,     0,   191,
       0,     0,   194,   509,   510,   511,   512,     0,   195,   196,
     513,   514,   515,     0,   516,   517,   518,   519,   520,   521,
     198,   522,   523,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,     0,   533,   534,     0,   535,   536,   206,
     537,   538,   539,   540,   541,   542,     0,     0,   543,   544,
     545,     0,   546,   210,   547,   548,     0,   549,   213,     0,
     550,   551,   552,   553,   554,   555,   556,   557,   215,   558,
       0,   559,   560,     0,   561,   562,   563,   564,     0,   216,
     217,     0,     0,   566,   218,   567,   219,     0,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,   576,     0,
       0,   577,   578,     0,   579,   227,   580,     0,   581,     0,
       0,     0,   582,   583,   584,   585,   586,   587,     0,     0,
       0,   229,     0,     0,   230,    81,    82,    83,   372,    85,
      86,     0,    87,    88,    89,   373,     0,   374,     0,    93,
       0,    95,    96,    97,    98,    99,   100,     0,   101,   102,
     103,   375,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   116,   376,
     377,     0,     0,     0,   378,   379,     0,     0,     0,     0,
     380,     0,     0,     0,     0,     0,     0,     0,     0,   381,
       0,   382,     0,   383,   384,     0,   385,   386,   387,   388,
     389,   390,   391,   392,     0,   393,   394,     0,     0,     0,
       0,     0,     0,     0,   395,   396,     0,   397,     0,   398,
     399,   400,     0,   134,     0,   136,     0,     0,   401,   402,
       0,   403,   404,     0,     0,   405,   406,   137,   407,     0,
     408,   409,   410,   411,   141,     0,     0,   412,   413,   414,
     415,   416,     0,   417,   418,   144,   419,     0,   420,   421,
     422,     0,   423,     0,     0,     0,     0,     0,   424,   425,
     426,   427,   428,   150,   151,   429,     0,   430,     0,   431,
       0,   432,   433,   434,     0,   435,     0,     0,   436,   437,
     438,   439,     0,   440,   441,   442,     0,   443,     0,   444,
     445,   446,   157,   447,     0,   159,     0,   448,   449,   161,
       0,   450,     0,   451,     0,     0,     0,   452,     0,   453,
       0,   454,   166,     0,   455,     0,   456,   457,   458,  1154,
       0,   460,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   169,     0,   469,   470,   471,     0,   171,
       0,   172,     0,     0,     0,     0,   472,     0,   473,   474,
     475,   476,   477,     0,   176,     0,   478,     0,     0,   479,
     480,   481,     0,     0,   482,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   492,   183,     0,   185,     0,   493,
     494,   495,   496,   497,   498,   499,   186,   500,     0,   501,
     502,     0,   503,     0,   189,   190,   504,   505,     0,     0,
     506,     0,     0,     0,   507,   508,     0,     0,   191,     0,
       0,   194,   509,   510,   511,   512,     0,   195,   196,   513,
     514,   515,     0,   516,   517,   518,   519,   520,   521,   198,
     522,   523,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,     0,   533,   534,     0,   535,   536,   206,   537,
     538,   539,   540,   541,   542,     0,     0,   543,   544,   545,
       0,   546,   210,   547,   548,     0,   549,   213,     0,   550,
     551,   552,   553,   554,   555,   556,   557,   215,   558,     0,
     559,   560,     0,   561,   562,   563,   564,     0,   216,   217,
       0,     0,   566,   218,   567,   219,     0,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,   576,     0,     0,
     577,   578,     0,   579,   227,   580,     0,   581,     0,     0,
       0,   582,   583,   584,   585,   586,   587,     0,     0,     0,
     229,     0,     0,   230,    81,    82,    83,   372,    85,    86,
       0,    87,    88,    89,   373,     0,   374,     0,    93,     0,
      95,    96,    97,    98,    99,   100,     0,   101,   102,   103,
     375,     0,     0,   105,   106,   107,   108,     0,     0,     0,
     110,   111,   112,     0,   113,     0,     0,   116,   376,   377,
       0,     0,     0,   378,   379,     0,     0,     0,     0,   380,
       0,     0,     0,     0,     0,     0,     0,     0,   381,     0,
     382,     0,   383,   384,     0,   385,   386,   387,   388,   389,
     390,   391,   392,     0,   393,   394,     0,     0,     0,     0,
       0,     0,     0,   395,   396,     0,   397,     0,   398,   399,
     400,     0,   134,     0,   136,     0,     0,   401,   402,     0,
     403,   404,     0,     0,   405,   406,   137,   407,     0,   408,
     409,   410,   411,   141,     0,     0,   412,   413,   414,   415,
     416,     0,   417,   418,   144,   419,     0,   420,   421,   422,
       0,   423,     0,     0,     0,     0,     0,   424,   425,   426,
     427,   428,   150,   151,   429,     0,   430,     0,   431,     0,
     432,   433,   434,     0,   435,     0,     0,   436,   437,   438,
     439,     0,   440,   441,   442,     0,   443,     0,   444,   445,
     446,   157,   447,     0,   159,     0,   448,   449,   161,     0,
     450,     0,   451,     0,     0,     0,   452,     0,   453,     0,
     454,   166,     0,   455,     0,   456,   457,   458,  1156,     0,
     460,   461,   462,     0,   463,   464,   465,   466,   467,   468,
       0,     0,   169,     0,   469,   470,   471,     0,   171,     0,
     172,     0,     0,     0,     0,   472,     0,   473,   474,   475,
     476,   477,     0,   176,     0,   478,     0,     0,   479,   480,
     481,     0,     0,   482,   483,   484,   485,   486,   487,   488,
     489,   490,   491,   492,   183,     0,   185,     0,   493,   494,
     495,   496,   497,   498,   499,   186,   500,     0,   501,   502,
       0,   503,     0,   189,   190,   504,   505,     0,     0,   506,
       0,     0,     0,   507,   508,     0,     0,   191,     0,     0,
     194,   509,   510,   511,   512,     0,   195,   196,   513,   514,
     515,     0,   516,   517,   518,   519,   520,   521,   198,   522,
     523,     0,   524,   525,   526,   527,   528,   529,   530,   531,
     532,     0,   533,   534,     0,   535,   536,   206,   537,   538,
     539,   540,   541,   542,     0,     0,   543,   544,   545,     0,
     546,   210,   547,   548,     0,   549,   213,     0,   550,   551,
     552,   553,   554,   555,   556,   557,   215,   558,     0,   559,
     560,     0,   561,   562,   563,   564,     0,   216,   217,     0,
       0,   566,   218,   567,   219,     0,   568,   569,   570,   571,
     572,     0,     0,   573,   574,   575,   576,     0,     0,   577,
     578,     0,   579,   227,   580,     0,   581,     0,     0,     0,
     582,   583,   584,   585,   586,   587,     0,     0,     0,   229,
       0,     0,   230,    81,    82,    83,   372,    85,    86,     0,
      87,    88,    89,   373,     0,   374,     0,    93,     0,    95,
      96,    97,    98,    99,   100,     0,   101,   102,   103,   375,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   116,   376,   377,     0,
       0,     0,   378,   379,     0,     0,     0,     0,   380,     0,
       0,     0,     0,     0,     0,     0,     0,   381,     0,   382,
       0,   383,   384,     0,   385,   386,   387,   388,   389,   390,
     391,   392,     0,   393,   394,     0,     0,     0,     0,     0,
       0,     0,   395,   396,     0,   397,     0,   398,   399,   400,
       0,   134,     0,   136,     0,     0,   401,   402,     0,   403,
     404,     0,     0,   405,   406,   137,   407,     0,   408,   409,
     410,   411,   141,     0,     0,   412,   413,   414,   415,   416,
       0,   417,   418,   144,   419,     0,   420,   421,   422,     0,
     423,     0,     0,     0,     0,     0,   424,   425,   426,   427,
     428,   150,   151,   429,     0,   430,     0,   431,     0,   432,
     433,   434,     0,   435,     0,     0,   436,   437,   438,   439,
       0,   440,   441,   442,     0,   443,     0,   444,   445,   446,
     157,   447,     0,   159,     0,   448,   449,   161,     0,   450,
       0,   451,     0,     0,     0,   452,     0,   453,     0,   454,
     166,     0,   455,     0,   456,   457,   458,  1158,     0,   460,
     461,   462,     0,   463,   464,   465,   466,   467,   468,     0,
       0,   169,     0,   469,   470,   471,     0,   171,     0,   172,
       0,     0,     0,     0,   472,     0,   473,   474,   475,   476,
     477,     0,   176,     0,   478,     0,     0,   479,   480,   481,
       0,     0,   482,   483,   484,   485,   486,   487,   488,   489,
     490,   491,   492,   183,     0,   185,     0,   493,   494,   495,
     496,   497,   498,   499,   186,   500,     0,   501,   502,     0,
     503,     0,   189,   190,   504,   505,     0,     0,   506,     0,
       0,     0,   507,   508,     0,     0,   191,     0,     0,   194,
     509,   510,   511,   512,     0,   195,   196,   513,   514,   515,
       0,   516,   517,   518,   519,   520,   521,   198,   522,   523,
       0,   524,   525,   526,   527,   528,   529,   530,   531,   532,
       0,   533,   534,     0,   535,   536,   206,   537,   538,   539,
     540,   541,   542,     0,     0,   543,   544,   545,     0,   546,
     210,   547,   548,     0,   549,   213,     0,   550,   551,   552,
     553,   554,   555,   556,   557,   215,   558,     0,   559,   560,
       0,   561,   562,   563,   564,     0,   216,   217,     0,     0,
     566,   218,   567,   219,     0,   568,   569,   570,   571,   572,
       0,     0,   573,   574,   575,   576,     0,     0,   577,   578,
       0,   579,   227,   580,     0,   581,     0,     0,     0,   582,
     583,   584,   585,   586,   587,     0,     0,     0,   229,     0,
       0,   230,    81,    82,    83,   372,    85,    86,     0,    87,
      88,    89,   373,     0,   374,     0,    93,     0,    95,    96,
      97,    98,    99,   100,     0,   101,   102,   103,   375,     0,
       0,   105,   106,   107,   108,     0,     0,     0,   110,   111,
     112,     0,   113,     0,     0,   116,   376,   377,     0,     0,
       0,   378,   379,     0,     0,     0,     0,   380,     0,     0,
       0,     0,     0,     0,     0,     0,   381,     0,   382,     0,
     383,   384,     0,   385,   386,   387,   388,   389,   390,   391,
     392,     0,   393,   394,     0,     0,     0,     0,     0,     0,
       0,   395,   396,     0,   397,     0,   398,   399,   400,     0,
     134,     0,   136,     0,     0,   401,   402,     0,   403,   404,
       0,     0,   405,   406,   137,   407,     0,   408,   409,   410,
     411,   141,     0,     0,   412,   413,   414,   415,   416,     0,
     417,   418,   144,   419,     0,   420,   421,   422,     0,   423,
       0,     0,     0,     0,     0,   424,   425,   426,   427,   428,
     150,   151,   429,     0,   430,     0,   431,     0,   432,   433,
     434,     0,   435,     0,     0,   436,   437,   438,   439,     0,
     440,   441,   442,     0,   443,     0,   444,   445,   446,   157,
     447,     0,   159,     0,   448,   449,   161,     0,   450,     0,
     451,     0,     0,     0,   452,     0,   453,     0,   454,   166,
       0,   455,     0,   456,   457,   458,  1161,     0,   460,   461,
     462,     0,   463,   464,   465,   466,   467,   468,     0,     0,
     169,     0,   469,   470,   471,     0,   171,     0,   172,     0,
       0,     0,     0,   472,     0,   473,   474,   475,   476,   477,
       0,   176,     0,   478,     0,     0,   479,   480,   481,     0,
       0,   482,   483,   484,   485,   486,   487,   488,   489,   490,
     491,   492,   183,     0,   185,     0,   493,   494,   495,   496,
     497,   498,   499,   186,   500,     0,   501,   502,     0,   503,
       0,   189,   190,   504,   505,     0,     0,   506,     0,     0,
       0,   507,   508,     0,     0,   191,     0,     0,   194,   509,
     510,   511,   512,     0,   195,   196,   513,   514,   515,     0,
     516,   517,   518,   519,   520,   521,   198,   522,   523,     0,
     524,   525,   526,   527,   528,   529,   530,   531,   532,     0,
     533,   534,     0,   535,   536,   206,   537,   538,   539,   540,
     541,   542,     0,     0,   543,   544,   545,     0,   546,   210,
     547,   548,     0,   549,   213,     0,   550,   551,   552,   553,
     554,   555,   556,   557,   215,   558,     0,   559,   560,     0,
     561,   562,   563,   564,     0,   216,   217,     0,     0,   566,
     218,   567,   219,     0,   568,   569,   570,   571,   572,     0,
       0,   573,   574,   575,   576,     0,     0,   577,   578,     0,
     579,   227,   580,     0,   581,     0,     0,     0,   582,   583,
     584,   585,   586,   587,     0,     0,     0,   229,     0,     0,
     230,    81,    82,    83,   372,    85,    86,     0,    87,    88,
      89,   373,     0,   374,     0,    93,     0,    95,    96,    97,
      98,    99,   100,     0,   101,   102,   103,   375,     0,     0,
     105,   106,   107,   108,     0,     0,     0,   110,   111,   112,
       0,   113,     0,     0,   116,   376,   377,     0,     0,     0,
     378,   379,     0,     0,     0,     0,   380,     0,     0,     0,
       0,     0,     0,     0,     0,   381,     0,   382,     0,   383,
     384,     0,   385,   386,   387,   388,   389,   390,   391,   392,
       0,   393,   394,     0,     0,     0,     0,     0,     0,     0,
     395,   396,     0,   397,  1324,   398,   399,   400,     0,   134,
       0,   136,     0,     0,   401,   402,     0,   403,   404,     0,
       0,   405,   882,   137,  1325,     0,   408,   409,   410,   411,
     141,     0,     0,   412,   413,   414,   415,     0,     0,   417,
     418,   144,   419,     0,   420,   421,   422,     0,   423,     0,
       0,     0,     0,     0,   424,   425,   426,   427,   428,   150,
     151,   429,     0,   430,     0,   431,     0,   432,   433,   434,
       0,   435,     0,     0,   436,   437,   438,   439,     0,   440,
     441,   442,     0,   443,     0,   444,   445,   446,   157,   447,
       0,   159,     0,   448,   449,   161,     0,   450,     0,   451,
       0,     0,     0,   452,     0,   453,     0,   454,   166,     0,
     455,     0,   456,   457,   458,   459,     0,   460,   461,   462,
       0,   463,   464,   465,   466,   467,   468,     0,     0,   169,
       0,   469,   470,   471,     0,   171,     0,   172,     0,     0,
       0,     0,   472,     0,   473,   474,   475,   476,   477,     0,
     176,     0,   478,     0,     0,   479,   480,   481,     0,     0,
     482,   483,   484,   485,   486,   487,   488,   489,   490,   491,
     909,   183,     0,   185,     0,   493,   494,   495,   496,   497,
     498,   499,   186,   500,     0,   501,   502,     0,   503,     0,
     189,   190,   504,   505,     0,     0,   506,     0,     0,     0,
     507,   508,     0,     0,   191,     0,     0,   194,   509,   510,
     511,   512,     0,   195,   196,   513,   514,   515,     0,   516,
     517,   518,   519,   520,   521,   198,   522,   523,     0,   524,
     525,   526,   527,   528,   529,   530,   531,   532,     0,   533,
     534,     0,   910,   536,   206,   537,   538,   539,   540,   541,
     542,     0,     0,   543,   544,  1316,     0,   546,   210,   547,
     548,     0,   549,   213,     0,   550,   551,   552,   553,   554,
     555,   556,   557,   215,   558,     0,   559,   560,     0,   561,
     562,   563,   564,     0,   912,   217,     0,     0,   913,   218,
     567,   219,     0,   568,   569,   570,   571,   572,     0,     0,
     573,   574,   575,   576,     0,     0,   577,   578,     0,   886,
     227,   580,     0,   581,     0,     0,     0,   582,   583,   584,
     585,   586,   587,     0,     0,     0,   229,     0,     0,   230,
      81,    82,    83,   372,    85,    86,     0,    87,    88,    89,
     373,     0,   374,     0,    93,     0,    95,    96,    97,    98,
      99,   100,     0,   101,   102,   103,   375,     0,     0,   105,
     106,   107,   108,     0,     0,     0,   110,   111,   112,     0,
     113,     0,     0,   116,   376,   377,     0,     0,     0,   378,
     379,     0,     0,     0,     0,   380,     0,     0,     0,     0,
       0,     0,     0,     0,   381,     0,   382,     0,   383,   384,
       0,   385,   386,   387,   388,   389,   390,   391,   392,     0,
     393,   394,     0,     0,     0,     0,     0,  1340,     0,   395,
     396,     0,   397,     0,   398,   399,   400,     0,   134,     0,
     136,     0,     0,   401,   402,     0,   403,   404,     0,     0,
     405,   406,   137,   407,     0,   408,   409,   410,   411,   141,
       0,     0,   412,   413,   414,   415,   416,     0,   417,   418,
     144,   419,     0,   420,   421,   422,     0,   423,     0,     0,
       0,     0,     0,   424,   425,   426,   427,   428,   150,   151,
     429,     0,   430,     0,   431,     0,   432,   433,   434,     0,
     435,     0,     0,   436,   437,   438,   439,     0,   440,   441,
     442,     0,   443,     0,   444,   445,   446,   157,   447,     0,
     159,     0,   448,   449,   161,     0,   450,     0,   451,     0,
       0,     0,   452,     0,   453,     0,   454,   166,     0,   455,
       0,   456,   457,   458,   459,     0,   460,   461,   462,     0,
     463,   464,   465,   466,   467,   468,     0,     0,   169,     0,
     469,   470,   471,     0,   171,     0,   172,     0,     0,     0,
       0,   472,     0,   473,   474,   475,   476,   477,     0,   176,
       0,   478,     0,     0,   479,   480,   481,     0,     0,   482,
     483,   484,   485,   486,   487,   488,   489,   490,   491,   492,
     183,     0,   185,     0,   493,   494,   495,   496,   497,   498,
     499,   186,   500,     0,   501,   502,     0,   503,     0,   189,
     190,   504,   505,     0,     0,   506,     0,     0,     0,   507,
     508,     0,     0,   191,     0,     0,   194,   509,   510,   511,
     512,     0,   195,   196,   513,   514,   515,     0,   516,   517,
     518,   519,   520,   521,   198,   522,   523,     0,   524,   525,
     526,   527,   528,   529,   530,   531,   532,     0,   533,   534,
       0,   535,   536,   206,   537,   538,   539,   540,   541,   542,
       0,     0,   543,   544,   545,     0,     0,   210,   547,   548,
       0,   549,   213,     0,   550,   551,   552,   553,   554,   555,
     556,   557,   215,   558,     0,   559,   560,     0,   561,   562,
     563,   564,     0,   216,   217,     0,     0,   566,   218,   567,
     219,     0,   568,   569,   570,   571,   572,     0,     0,   573,
     574,   575,   576,     0,     0,   577,   578,     0,   579,   227,
     580,     0,   581,     0,     0,     0,   582,   583,   584,   585,
     586,   587,     0,     0,     0,   229,     0,     0,   230,  1420,
      82,    83,   372,    85,    86,     0,    87,    88,    89,   373,
       0,   374,     0,    93,     0,    95,    96,    97,    98,    99,
     100,     0,   101,   102,   103,   375,     0,     0,   105,   106,
     107,   108,     0,     0,     0,   110,   111,   112,     0,   113,
       0,     0,   116,   376,   377,     0,     0,     0,   378,   379,
       0,     0,     0,     0,   380,     0,     0,     0,     0,     0,
       0,     0,     0,   381,     0,   382,     0,   383,   384,     0,
     385,   386,   387,   388,   389,   390,   391,   392,     0,   393,
     394,     0,     0,     0,     0,     0,     0,     0,   395,   396,
       0,   397,     0,   398,   399,   400,     0,   134,     0,   136,
       0,     0,   401,   402,     0,   403,   404,     0,     0,   405,
     406,   137,   407,     0,   408,   409,   410,   411,   141,     0,
       0,   412,   413,   414,   415,   416,     0,   417,   418,   144,
     419,     0,   420,   421,   422,     0,   423,     0,     0,     0,
       0,     0,   424,   425,   426,   427,   428,   150,   151,   429,
       0,   430,     0,   431,     0,   432,   433,   434,     0,   435,
       0,     0,   436,   437,   438,   439,     0,   440,   441,   442,
       0,   443,     0,   444,   445,   446,   157,   447,     0,   159,
       0,   448,   449,   161,     0,   450,     0,   451,     0,     0,
       0,   452,     0,   453,     0,   454,   166,     0,   455,     0,
     456,   457,   458,   459,     0,   460,   461,   462,     0,   463,
     464,   465,   466,   467,   468,     0,     0,   169,     0,   469,
     470,   471,     0,   171,     0,   172,     0,     0,     0,     0,
     472,     0,   473,   474,   475,   476,   477,     0,   176,     0,
     478,     0,     0,   479,   480,   481,     0,     0,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   183,
       0,   185,     0,   493,   494,   495,   496,   497,   498,   499,
     186,   500,     0,   501,   502,     0,   503,     0,   189,   190,
     504,   505,     0,     0,   506,     0,     0,     0,   507,   508,
       0,     0,   191,     0,     0,   194,   509,   510,   511,   512,
       0,   195,   196,   513,   514,   515,     0,   516,   517,   518,
     519,   520,   521,   198,   522,   523,     0,   524,   525,   526,
     527,   528,   529,   530,   531,   532,     0,   533,   534,     0,
     535,   536,   206,   537,   538,   539,   540,   541,   542,     0,
       0,   543,   544,   545,     0,   546,   210,   547,   548,     0,
     549,   213,     0,   550,   551,   552,   553,   554,   555,   556,
     557,   215,   558,     0,   559,   560,     0,   561,   562,   563,
     564,     0,   216,   217,     0,     0,   566,   218,   567,   219,
       0,   568,   569,   570,   571,   572,     0,     0,   573,   574,
     575,   576,     0,     0,   577,   578,     0,   579,   227,   580,
       0,   581,     0,     0,     0,   582,   583,   584,   585,   586,
     587,     0,     0,     0,   229,     0,     0,   230,    81,    82,
      83,   372,    85,    86,     0,    87,    88,    89,   373,     0,
     374,     0,    93,     0,    95,    96,    97,    98,    99,   100,
       0,   101,   102,   103,   375,     0,     0,   105,   106,   107,
     108,     0,     0,     0,   110,   111,   112,     0,   113,     0,
       0,   116,   376,   377,     0,     0,     0,   378,   379,     0,
       0,     0,     0,   380,     0,     0,     0,     0,     0,     0,
       0,     0,   381,     0,   382,     0,   383,   384,     0,   385,
     386,   387,   388,   389,   390,   391,   392,     0,   393,   394,
       0,     0,     0,     0,     0,     0,     0,   395,   396,     0,
     397,     0,   398,   399,   400,     0,   134,     0,   136,     0,
       0,   401,   402,     0,   403,   404,     0,     0,   405,   406,
     137,   407,     0,   408,   409,   410,   411,   141,     0,     0,
     412,   413,   414,  1589,   416,     0,   417,   418,   144,   419,
       0,   420,   421,   422,     0,   423,     0,     0,     0,     0,
       0,   424,   425,   426,   427,   428,   150,   151,   429,     0,
     430,     0,   431,     0,   432,   433,   434,     0,   435,     0,
       0,   436,   437,   438,   439,     0,   440,   441,   442,     0,
     443,     0,   444,   445,   446,   157,   447,     0,   159,     0,
     448,   449,   161,     0,   450,     0,   451,     0,     0,     0,
     452,     0,   453,     0,   454,   166,     0,   455,     0,   456,
     457,   458,   459,     0,   460,   461,   462,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   169,     0,   469,   470,
     471,     0,   171,     0,   172,     0,     0,     0,     0,   472,
       0,   473,   474,   475,   476,   477,     0,   176,     0,   478,
       0,     0,   479,   480,   481,     0,     0,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   183,     0,
     185,     0,   493,   494,   495,   496,   497,   498,   499,   186,
     500,     0,   501,   502,     0,   503,     0,   189,   190,   504,
     505,     0,     0,   506,     0,     0,     0,   507,   508,     0,
       0,   191,     0,     0,   194,   509,   510,   511,   512,     0,
     195,   196,   513,   514,   515,     0,   516,   517,   518,   519,
     520,   521,   198,   522,   523,     0,   524,   525,   526,   527,
     528,   529,   530,   531,   532,     0,   533,   534,     0,   535,
     536,   206,   537,   538,   539,   540,   541,   542,     0,     0,
     543,   544,   545,     0,   546,   210,   547,   548,     0,   549,
     213,     0,   550,   551,   552,   553,   554,   555,   556,   557,
     215,   558,     0,   559,   560,     0,   561,   562,   563,   564,
       0,   216,   217,     0,     0,   566,   218,   567,   219,     0,
     568,   569,   570,   571,   572,     0,     0,   573,   574,   575,
     576,     0,     0,   577,   578,     0,   579,   227,   580,     0,
     581,     0,     0,     0,   582,   583,   584,   585,   586,   587,
       0,     0,     0,   229,     0,     0,   230,    81,    82,    83,
     372,    85,    86,     0,    87,    88,    89,   373,     0,   374,
       0,    93,     0,    95,    96,    97,    98,    99,   100,     0,
     101,   102,   103,   375,     0,     0,   105,   106,   107,   108,
       0,     0,     0,   110,   111,   112,     0,   113,     0,     0,
     116,   376,   377,     0,     0,     0,   378,   379,     0,     0,
       0,     0,   380,     0,     0,     0,     0,     0,     0,     0,
       0,   381,     0,   382,     0,   383,   384,     0,   385,   386,
     387,   388,   389,   390,   391,   392,     0,   393,   394,     0,
       0,     0,     0,     0,     0,     0,   395,   396,     0,   397,
       0,   398,   399,   400,     0,   134,     0,   136,     0,     0,
     401,   402,     0,   403,   404,     0,     0,   405,   406,   137,
     407,     0,   408,   409,   410,   411,   141,     0,     0,   412,
     413,   414,   415,   416,     0,   417,   418,   144,   419,     0,
     420,   421,   422,     0,   423,     0,     0,     0,     0,     0,
     424,   425,   426,   427,   428,   150,   151,   429,     0,   430,
       0,   431,     0,   432,   433,   434,     0,   435,     0,     0,
     436,   437,   438,   439,     0,   440,   441,   442,     0,   443,
       0,   444,   445,   446,   157,   447,     0,   159,     0,   448,
     449,   161,     0,   450,     0,   451,     0,     0,     0,   452,
       0,   453,     0,   454,   166,     0,   455,     0,   456,   457,
     458,  1616,     0,   460,   461,   462,     0,   463,   464,   465,
     466,   467,   468,     0,     0,   169,     0,   469,   470,   471,
       0,   171,     0,   172,     0,     0,     0,     0,   472,     0,
     473,   474,   475,   476,   477,     0,   176,     0,   478,     0,
       0,   479,   480,   481,     0,     0,   482,   483,   484,   485,
     486,   487,   488,   489,   490,   491,   492,   183,     0,   185,
       0,   493,   494,   495,   496,   497,   498,   499,   186,   500,
       0,   501,   502,     0,   503,     0,   189,   190,   504,   505,
       0,     0,   506,     0,     0,     0,   507,   508,     0,     0,
     191,     0,     0,   194,   509,   510,   511,   512,     0,   195,
     196,   513,   514,   515,     0,   516,   517,   518,   519,   520,
     521,   198,   522,   523,     0,   524,   525,   526,   527,   528,
     529,   530,   531,   532,     0,   533,   534,     0,   535,   536,
     206,   537,   538,   539,   540,   541,   542,     0,     0,   543,
     544,   545,     0,   546,   210,   547,   548,     0,   549,   213,
       0,   550,   551,   552,   553,   554,   555,   556,   557,   215,
     558,     0,   559,   560,     0,   561,   562,   563,   564,     0,
     216,   217,     0,     0,   566,   218,   567,   219,     0,   568,
     569,   570,   571,   572,     0,     0,   573,   574,   575,   576,
       0,     0,   577,   578,     0,   579,   227,   580,     0,   581,
       0,     0,     0,   582,   583,   584,   585,   586,   587,     0,
       0,     0,   229,     0,     0,   230,    81,    82,    83,   372,
      85,    86,     0,    87,    88,    89,   373,     0,   374,     0,
      93,     0,    95,    96,    97,    98,    99,   100,     0,   101,
     102,   103,   375,     0,     0,   105,   106,   107,   108,     0,
       0,     0,   110,   111,   112,     0,   113,     0,     0,   116,
     376,   377,     0,     0,     0,   378,   379,     0,     0,     0,
       0,   380,     0,     0,     0,     0,     0,     0,     0,     0,
     381,     0,   382,     0,   383,   384,     0,   385,   386,   387,
     388,   389,   390,   391,   392,     0,   393,   394,     0,     0,
       0,     0,     0,     0,     0,   395,   396,     0,   397,     0,
     398,   399,   400,     0,   134,     0,   136,     0,     0,   401,
     402,     0,   403,   404,     0,     0,   405,   406,   137,   407,
       0,   408,   409,   410,   411,   141,     0,     0,   412,   413,
     414,   415,   416,     0,   417,   418,   144,   419,     0,   420,
     421,   422,     0,   423,     0,     0,     0,     0,     0,   424,
     425,   426,   427,   428,   150,   151,   429,     0,   430,     0,
     431,     0,   432,   433,   434,     0,   435,     0,     0,   436,
     437,   438,   439,     0,   440,   441,   442,     0,   443,     0,
     444,   445,   446,   157,   447,     0,   159,     0,   448,   449,
     161,     0,   450,     0,   451,     0,     0,     0,   452,     0,
     453,     0,   454,   166,     0,   455,     0,   456,   457,   458,
     459,     0,   460,   461,   462,     0,   463,   464,   465,   466,
     467,   468,     0,     0,   169,     0,   469,   470,   471,     0,
     171,     0,   172,     0,     0,     0,     0,   472,     0,   473,
     474,   475,   476,   477,     0,   176,     0,   478,     0,     0,
     479,   480,   481,     0,     0,   482,   483,   484,   485,   486,
     487,   488,   489,   490,   491,   492,   183,     0,   185,     0,
     493,   494,   495,   496,   497,   498,   499,   186,   500,     0,
     501,   502,     0,   503,     0,   189,   190,   504,   505,     0,
       0,   506,     0,     0,     0,   507,   508,     0,     0,   191,
       0,     0,   194,   509,   510,   511,   512,     0,   195,   196,
     513,   514,   515,     0,   516,   517,   518,   519,   520,   521,
     198,   522,   523,     0,   524,   525,   526,   527,   528,   529,
     530,   531,   532,     0,   533,   534,     0,   535,   536,   206,
     537,   538,  1686,   540,   541,   542,     0,     0,   543,   544,
     545,     0,   546,   210,   547,   548,     0,   549,   213,     0,
     550,   551,   552,   553,   554,   555,   556,   557,   215,   558,
       0,   559,   560,     0,   561,   562,   563,   564,     0,   216,
     217,     0,     0,   566,   218,   567,   219,     0,   568,   569,
     570,   571,   572,     0,     0,   573,   574,   575,   576,     0,
       0,   577,   578,     0,   579,   227,   580,     0,   581,     0,
       0,     0,   582,   583,   584,   585,   586,   587,     0,     0,
       0,   229,     0,     0,   230,    81,    82,    83,   372,    85,
      86,     0,    87,    88,    89,   373,     0,   374,     0,    93,
       0,    95,    96,    97,    98,    99,   100,     0,   101,   102,
     103,   375,     0,     0,   105,   106,   107,   108,     0,     0,
       0,   110,   111,   112,     0,   113,     0,     0,   116,   376,
     377,     0,     0,     0,   378,   379,     0,     0,     0,     0,
     380,     0,     0,     0,     0,     0,     0,     0,     0,   381,
       0,   382,     0,   383,   384,     0,   385,   386,   387,   388,
     389,   390,   391,   392,     0,   393,   394,     0,     0,     0,
       0,     0,     0,     0,   395,   396,     0,   397,     0,   398,
     399,   400,     0,   134,     0,   136,     0,     0,   401,   402,
       0,   403,   404,     0,     0,   405,   882,   137,   407,     0,
     408,   409,   410,   411,   141,     0,     0,   412,   413,   414,
     415,     0,     0,   417,   418,   144,   419,     0,   420,   421,
     422,     0,   423,     0,     0,     0,     0,     0,   424,   425,
     426,   427,   428,   150,   151,   429,     0,   430,     0,   431,
       0,   432,   433,   434,     0,   435,     0,     0,   436,   437,
     438,   439,     0,   440,   441,   442,     0,   443,     0,   444,
     445,   446,   157,   447,     0,   159,     0,   448,   449,   161,
       0,   450,     0,   451,     0,     0,     0,   452,     0,   453,
       0,   454,   166,     0,   455,     0,   456,   457,   458,   459,
       0,   460,   461,   462,     0,   463,   464,   465,   466,   467,
     468,     0,     0,   169,     0,   469,   470,   471,     0,   171,
       0,   172,     0,     0,     0,     0,   472,     0,   473,   474,
     475,   476,   477,     0,   176,     0,   478,     0,     0,   479,
     480,   481,     0,     0,   482,   483,   484,   485,   486,   487,
     488,   489,   490,   491,   909,   183,     0,   185,     0,   493,
     494,   495,   496,   497,   498,   499,   186,   500,     0,   501,
     502,     0,   503,     0,   189,   190,   504,   505,     0,     0,
     506,     0,     0,     0,   507,   508,     0,     0,   191,     0,
       0,   194,   509,   510,   511,   512,     0,   195,   196,   513,
     514,   515,     0,   516,   517,   518,   519,   520,   521,   198,
     522,   523,     0,   524,   525,   526,   527,   528,   529,   530,
     531,   532,     0,   533,   534,     0,   910,   536,   206,   537,
     538,   539,   540,   541,   542,     0,     0,   543,   544,  1316,
       0,   546,   210,   547,   548,     0,   549,   213,     0,   550,
     551,   552,   553,   554,   555,   556,   557,   215,   558,     0,
     559,   560,     0,   561,   562,   563,   564,     0,   912,   217,
       0,     0,   913,   218,   567,   219,     0,   568,   569,   570,
     571,   572,     0,     0,   573,   574,   575,   576,     0,     0,
     577,   578,     0,   886,   227,   580,     0,   581,     0,     0,
       0,   582,   583,   584,   585,   586,   587,    81,    82,    83,
     229,    85,    86,   230,    87,    88,    89,     0,     0,     0,
      92,    93,     0,    95,    96,    97,    98,    99,   100,     0,
     101,   102,   103,     0,     0,     0,   105,   106,   107,   108,
       0,   109,     0,   110,   111,   112,     0,   113,   114,   115,
     116,     0,     0,     0,     0,     0,   119,   120,     0,     0,
       0,     0,   121,     0,     0,     0,     0,     0,     0,     0,
       0,   122,     0,   123,     0,   124,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     131,     0,     0,     0,   133,   134,   135,   136,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   137,
       0,     0,     0,     0,     0,     0,   141,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   144,     0,     0,
       0,     0,     0,   147,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   150,   151,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   157,     0,     0,   159,     0,     0,
       0,   161,     0,     0,     0,     0,   162,     0,   163,     0,
       0,     0,     0,     0,   166,     0,     0,     0,     0,     0,
       0,     0,   167,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   168,   169,     0,     0,     0,     0,
       0,   171,     0,   172,     0,     0,   173,   174,     0,   175,
       0,     0,     0,     0,     0,     0,   176,   177,     0,   178,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   183,   184,   185,
       0,     0,     0,     0,     0,     0,     0,     0,   186,     0,
       0,     0,     0,   188,     0,     0,   189,   190,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     191,   192,   193,   194,     0,     0,     0,     0,     0,   195,
     196,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   198,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   204,     0,     0,
     206,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   210,     0,     0,   212,     0,   213,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   215,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     216,   217,     0,     0,     0,   218,     0,   219,     0,     0,
       0,     0,     0,     0,   222,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   227,     0,   228,     0,
      81,    82,    83,     0,    85,    86,     0,    87,    88,    89,
       0,     0,   229,    92,    93,   230,    95,    96,    97,    98,
      99,   100,     0,   101,   102,   103,     0,     0,     0,   105,
     106,   107,   108,     0,   109,     0,   110,   111,   112,     0,
     113,   114,   115,   116,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   131,     0,     0,     0,   133,   134,   135,
     136,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   137,     0,     0,     0,     0,     0,     0,   141,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     144,     0,     0,     0,     0,     0,   147,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   150,   151,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   157,     0,     0,
     159,     0,     0,     0,   161,     0,     0,     0,     0,   162,
       0,   163,     0,     0,     0,     0,     0,   166,     0,     0,
       0,     0,     0,     0,     0,   167,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   168,   169,     0,
       0,     0,     0,     0,   171,     0,   172,     0,     0,   173,
     174,     0,   175,     0,     0,     0,     0,     0,     0,   176,
     177,     0,   178,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     183,   184,   185,     0,     0,     0,     0,     0,     0,     0,
       0,   186,     0,     0,     0,     0,   188,     0,     0,   189,
     190,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   191,   192,   193,   194,     0,     0,     0,
       0,     0,   195,   196,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   198,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     204,     0,     0,   206,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   210,     0,     0,
     212,     0,   213,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   215,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   216,   217,     0,     0,     0,   218,     0,
     219,     0,     0,     0,     0,     0,     0,   222,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   227,
       0,   228,     0,    81,    82,    83,     0,    85,    86,     0,
      87,    88,    89,     0,     0,   229,     0,    93,   230,    95,
      96,    97,    98,    99,   100,     0,   101,   102,   103,     0,
       0,     0,   105,   106,   107,   108,     0,     0,     0,   110,
     111,   112,     0,   113,     0,     0,   116,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   131,     0,     0,     0,
     133,   134,   135,   136,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   137,     0,     0,     0,     0,
       0,     0,   141,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   144,     0,     0,     0,     0,     0,   147,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   150,   151,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     157,     0,     0,   159,     0,     0,     0,   161,     0,     0,
       0,     0,   162,     0,   163,     0,     0,     0,     0,     0,
     166,     0,     0,     0,     0,     0,     0,     0,   167,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     168,   169,     0,     0,     0,     0,     0,   171,     0,   172,
       0,     0,   173,   174,     0,   175,     0,     0,     0,     0,
       0,     0,   176,   177,     0,   178,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   183,   184,   185,     0,     0,     0,     0,
       0,     0,     0,     0,   186,     0,     0,     0,     0,   188,
       0,     0,   189,   190,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   191,   192,   193,   194,
       0,     0,     0,     0,     0,   195,   196,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   198,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   204,     0,     0,   206,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     210,     0,     0,   212,     0,   213,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   215,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   216,   217,     0,     0,
       0,   218,     0,   219,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   227,     0,   228,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   229,     0,
       0,   230
};

static const short yycheck[] =
{
       2,    76,   220,   728,    76,   156,   948,   732,   867,   736,
    1619,   231,   148,   149,  1142,   729,   148,   731,  1467,    79,
     156,  1064,    76,  1107,   146,    79,  1266,   811,  1406,   743,
    1114,  1558,   816,  1657,   720,   203,   913,   762,    92,    94,
     824,  1203,    76,    76,    92,   772,   197,    92,   907,   104,
    1051,   998,  1560,  1542,   768,  1252,    92,  1793,  1059,  2329,
     114,   197,   130,   922,   224,  1324,   114,   781,  2148,   114,
     145,   833,   796,   835,  1575,   837,    92,  1017,   114,   804,
    2350,   843,  1605,  1095,   139,   810,   813,    76,  2204,  1575,
      76,     2,    76,  1831,   149,  2051,  1575,   152,   114,    92,
    2128,   156,  1103,  1034,  1575,   160,  1575,  1575,  1109,  1869,
    1689,  2138,  1452,   827,  1115,   998,  2539,  2545,  1069,  2574,
     920,   114,   832,  1135,  2133,  2134,  2923,   182,   852,   908,
     969,  1840,   911,  1429,    76,  1837,  1167,    79,  1948,  1949,
    1031,  1901,   197,  2403,  1121,  1905,   202,    24,   993,    25,
      92,  1214,  1215,   209,   202,   211,   231,   232,   160,    41,
     232,   209,    49,   211,  2076,  2077,  2078,  2079,   222,  1618,
     978,   998,   114,    92,   222,  1238,   112,   222,    76,    76,
     182,   905,   986,   987,   118,   112,   222,   118,   118,  2703,
     722,   112,   105,    93,    41,    84,   237,    92,    92,  1224,
      98,   202,   700,   164,    79,     8,   222,    85,   157,   157,
      13,    14,    15,    91,   173,   233,   112,    81,  2517,    76,
     196,  1748,    25,    26,    27,   127,    29,    30,    31,   222,
      85,  3298,    35,    36,    37,   371,    91,   120,   290,   196,
     130,    97,    28,   232,   844,    85,   232,   120,   232,   196,
      79,    91,   162,    39,   127,    97,   339,   209,   157,    76,
     133,   171,   103,   322,   215,    28,    76,   233,    42,   304,
      44,   291,    76,  1722,   328,   133,    85,   233,   319,   124,
     222,    98,   288,   352,  2984,  1328,  2986,   114,    98,   294,
     330,   180,  3318,   159,   328,   328,   381,   237,   157,   157,
    3468,   339,  2062,  3100,    85,   365,   304,   171,   260,    85,
     193,   365,   352,   412,   368,   756,   371,  2510,   339,   425,
     193,    76,  1036,  2680,    79,   431,   162,   152,  1587,    81,
     422,   117,   112,   439,   368,   368,  3504,    92,   430,    92,
       0,   362,   160,   120,   785,  2538,  1071,  2704,  1545,  1289,
      92,   180,  1077,  1080,   352,   454,   133,  3154,   167,   114,
     398,    92,   733,  3531,   447,  1149,   737,  1167,  3394,   454,
     211,   440,   412,   744,   215,   232,  1460,  1177,  1178,   319,
    1327,  1067,    76,  1511,   209,   284,   328,   233,   447,   156,
     233,  3188,  1106,   345,   212,   222,   332,  1122,   347,   770,
     310,  1185,   454,   774,    98,   332,  1120,   248,    76,  1193,
     415,   332,   783,   454,   449,   162,   193,  2497,   284,   171,
    1204,   279,   111,   365,   381,   235,   368,   447,  3495,   565,
     313,   449,  1146,   565,   400,   260,   332,  2046,   263,   400,
     313,   447,  1526,   229,   400,  1953,   291,   202,  1688,  1689,
     233,   410,   233,   454,   209,   404,   211,   233,  1501,  1699,
    1700,    28,    76,   327,  1592,   233,   229,   222,  1531,  1532,
    3267,  1711,  1712,  1424,   422,   406,  1539,   425,   454,   381,
     227,   359,   430,  1015,    98,  1725,  1726,  1287,  2190,   103,
     365,   422,   422,   991,   425,   425,   185,  1509,   447,   430,
     430,   391,   450,   454,   359,   279,   309,   454,  3208,  1534,
     339,   394,  3026,   447,   370,   356,   447,   447,   454,   359,
     345,   394,  1523,   400,   213,   354,   445,   454,   370,   448,
     449,  1331,  1332,   454,   447,   454,   313,  2493,   425,  2495,
    2496,   235,   236,   425,  1784,   443,   443,   447,  2504,   425,
     445,   445,   332,   608,   609,  2815,  2816,  1402,   454,  1367,
    1451,  2589,   398,   422,   441,  2593,   425,   235,  2270,  1396,
     156,   430,   431,   328,   734,   422,   162,    76,   425,   739,
     740,  1389,   198,   430,   431,  2345,   433,   390,   282,  1393,
     180,   416,   439,  2892,  2893,  2894,  2895,  2896,   730,   731,
     352,   215,   210,  2339,   450,  2128,  1637,  2417,  1948,  2419,
     365,   454,  1589,   368,  2526,  3412,   383,   394,   151,  1915,
     157,   235,   236,   440,   441,   442,   443,   295,   438,   439,
     440,   441,   442,   443,   766,  1345,   440,   441,   442,   443,
     198,   227,  2351,   803,   425,   334,   797,   414,  3445,   425,
     431,   398,  1715,  1716,  1433,   431,   233,   346,   439,   122,
     796,   797,   229,   439,   288,  3167,   720,   450,   282,   450,
     724,   360,   720,  1512,   450,   720,   808,   171,   367,    33,
     735,   295,   450,   738,   720,   218,   741,   742,  3336,  1468,
     724,   724,   445,   829,   138,   448,   449,   412,   700,   167,
    2510,   454,   134,   445,   720,    86,   448,   449,   763,   180,
     260,    17,   454,   204,   445,  1494,   852,   448,   449,   181,
     409,   776,   157,   454,   779,   341,   158,   720,  2538,   159,
     112,   157,  3155,  3188,  3162,   105,   235,   295,   293,   454,
    1467,   796,   797,  1429,   438,   439,   440,   441,   442,   443,
     805,   197,   160,   196,   216,   423,  2516,   201,   304,   157,
    2787,   347,   817,  2573,   354,   167,   821,   822,    56,   905,
     438,   439,   440,   441,   442,   443,   284,     7,   720,   149,
      10,   327,   724,   150,   330,  1736,    74,   219,  1097,   700,
     845,   846,    22,    23,   374,   345,   295,   852,  3446,  1513,
     152,  1660,  1661,  1517,   212,  2328,   352,    76,   366,   423,
     179,  3313,   398,    43,   422,  2342,    46,   425,   404,   874,
     288,   876,   430,   447,   438,   439,   440,   441,   442,   443,
    1614,   833,  1783,   835,    17,   837,  1636,  1621,   906,   372,
     373,   843,   844,  1627,   279,  1645,   337,   228,   162,   279,
     905,  2300,   908,   279,   312,   911,   226,   209,   352,   305,
     908,   447,   231,   911,  3124,   200,   412,   447,   757,   923,
     233,   225,  1656,   450,  1658,  1659,  2956,   279,  1662,   105,
     373,   279,  1607,   354,  1570,   422,   288,  1612,   425,   271,
      76,  1618,   259,   430,   261,   381,   390,   312,  2246,    76,
    2812,   271,  2250,    76,  2860,  2861,   152,   923,   260,   260,
    2990,   263,   263,   227,   422,   303,  1630,   252,   122,  1633,
     354,    98,   430,   149,   423,   383,   319,    76,   363,   298,
     152,   366,  1657,  2281,  2282,   434,   435,   436,   168,   438,
     439,   440,   441,   442,   443,   343,   160,  2975,   434,   448,
     332,  1006,  2980,  1900,  1009,  2983,   414,  1012,  3268,   200,
     423,   354,  2971,   209,   398,   720,   235,   969,   383,   724,
     352,   434,   435,   436,   344,   438,   439,   440,   441,   442,
     443,   923,   871,    99,   375,   343,   377,   209,   990,   991,
     159,   993,  3302,   345,   345,  1722,   998,  1597,   212,   414,
     226,  2610,  2626,   119,  3427,   398,  2007,  2008,   161,   898,
     375,   252,   377,  1067,   260,  2143,   374,  1900,  1327,  1067,
     909,   910,  1067,  2263,   393,  3285,  1826,  1082,   347,    88,
      89,  1067,  1087,   347,   381,   161,  1091,  1968,   260,  2540,
     375,   263,   377,  1098,  2284,   271,  1266,  2785,  1887,   235,
    2178,  1067,   284,   222,  2540,   413,  1192,  1841,   969,   134,
     383,  2540,   235,  3373,   416,  1751,  2589,   279,  1123,  2540,
    2593,  2540,  2540,   408,  1067,  2654,  2416,   197,  2318,   990,
     991,   234,   993,   158,   398,   404,   235,   998,   179,   447,
    2330,  2331,   235,  1168,   348,   447,  1168,   986,   987,   345,
     191,  1701,  1702,  1703,   447,  3221,   318,   454,   234,  1709,
     279,   249,  1187,  1713,  1714,  1187,  1425,   381,   344,   373,
    1720,  1176,   295,   345,   374,  1067,   450,  2139,   447,  1729,
     162,  1731,     5,  1208,   375,  1190,   377,  2897,   421,  1495,
     231,   424,   191,  1452,   219,  1745,   295,  1747,   196,  3419,
     293,  1226,   290,   908,   408,    28,   911,  1466,   249,  3115,
    3116,  2000,   407,   413,  2003,  2004,    39,   215,   923,   438,
     439,   440,   441,   442,   443,  1899,    11,  3205,  1962,  1168,
     132,  1256,  1168,  3402,  1168,   449,   348,   424,   425,   453,
     422,  1266,  1976,   425,   416,   227,  2136,   447,   430,   290,
     249,  1510,  3472,  1574,   289,  1094,  1990,   298,   293,   451,
    1994,   373,  1568,   162,    49,   327,  1525,  1573,   330,   423,
    3490,   191,  3441,   175,   304,   447,  3306,  1583,  3447,  1915,
     434,   435,   436,  1542,   438,   439,   440,   441,   442,   443,
     352,   290,  1310,  1311,   117,   454,   408,   327,   280,   281,
     423,  3470,   438,   439,   440,   441,   442,   443,  1567,   450,
    1437,   434,   435,   436,    45,   438,   439,   440,   441,   442,
     443,  1160,   352,   304,   423,   448,   412,   413,   227,   249,
    1355,  1356,    76,  1358,   111,   434,   435,   436,   197,   438,
     439,   440,   441,   442,   443,   165,   327,   170,  1475,   330,
     412,  1610,   393,   255,   167,   304,   450,   364,   365,   442,
    1619,   447,  1067,  2572,   223,   347,   449,  1371,  1372,  1373,
     290,   352,  3278,  1391,   187,  1327,  1371,  1329,  1330,   238,
    1490,   330,   281,   203,  2048,  2049,  2684,   246,   451,  2687,
    2688,  2689,  2690,  2691,  2692,  2693,  2694,  2695,  2696,    83,
    3086,   422,   304,   352,   425,  1371,   229,   448,   185,   430,
     412,   413,  1416,  1418,   304,   422,   398,   101,   425,  1423,
     400,  2898,   404,   430,   126,  1429,   447,  1433,  1371,  1268,
    1382,  1429,  1416,  1416,  1429,  1433,   213,   327,  2736,  2737,
    1279,   143,  1992,  1429,   304,   447,   202,   383,   347,   442,
    1402,  2352,  1027,   155,  1406,   211,   449,  1423,  2262,   304,
    2264,  2265,  1468,  1429,   319,   447,  1327,   327,  1329,  1330,
    1468,   284,   374,   328,   376,   288,  1051,   336,   414,  1371,
    1372,  1373,   327,  2147,  1059,  1324,  1429,   229,  1494,   304,
    1749,   235,   352,  2167,   349,  2953,  1494,    20,  1668,   398,
     304,   422,  2975,   205,   425,   404,   452,  2980,   454,   430,
    2983,   406,   327,  2340,    93,  2065,   845,   418,   419,   420,
    2070,  1382,  2961,   327,  1416,  2715,  2560,   422,   381,  1611,
     425,  1423,   111,    84,  2646,   430,   425,  1429,   446,   868,
      91,  1402,   431,    94,   433,  1406,   454,   445,   447,   447,
     439,   295,   447,   104,  1393,   332,   431,   334,   433,   446,
    1512,  2708,  2709,   329,   157,  1683,  1570,   454,   452,   346,
     454,  1576,  1570,   422,   387,  1570,   425,    38,  3055,   130,
    1605,   430,   395,   360,  1570,   447,   122,   425,   139,   140,
     367,  1912,   375,   431,   377,  1916,   448,   148,   149,   293,
     422,   152,   454,   425,  1570,   156,   185,   450,   430,   160,
    1615,   454,  1933,  2510,   165,   127,   448,  1622,  2916,  1624,
    1625,   133,   454,  2300,    76,   447,   293,  1570,  2362,   448,
     448,   182,   409,  1638,   213,   454,   454,   385,    90,   232,
    1961,  2538,  1963,  1668,   450,  1597,   197,   448,   454,   135,
     201,  1512,   203,   454,  2868,  2869,   207,   167,  2872,   252,
    2874,   422,   241,  2213,   425,  2454,  1371,  1372,  1373,   430,
     117,   118,  2461,  2462,   210,   448,  1997,   187,  1570,   423,
     445,   454,   447,  2360,   449,   375,   447,   377,   120,  1948,
    1949,   435,   436,  3092,   438,   439,   440,   441,   442,   443,
    1652,  2602,   448,   448,   450,  2026,  2440,  2441,  2029,   454,
    2031,  1416,  3185,  1476,   422,   445,  1479,   425,  1423,   449,
    1483,  3295,   430,   218,  1429,   157,  2438,    76,  1433,  3187,
    1755,   448,  3205,   316,   448,  2636,   448,   454,   450,   447,
     454,    90,   438,   439,   440,   441,   442,  1751,  1587,  1701,
    1702,  1703,   448,  1751,   423,   334,  1751,  1709,   455,  3057,
    3058,  1713,  1714,  1468,   152,  1751,  3094,   346,  1720,   279,
     448,   450,   412,   413,   284,   454,   454,  1729,   288,  1731,
    1785,   360,   425,   235,  3261,  1751,  2779,  2046,   367,  1494,
     450,  2341,   448,  1745,   454,  1747,  2460,   448,   454,   412,
     413,   412,   413,   454,  2063,   412,   413,   422,  1751,   422,
     425,   422,   425,  1899,   425,   430,  2717,   430,   210,   430,
     371,   209,  1355,  1356,  1828,  1358,   412,   413,   421,   422,
     409,   424,   425,  2510,   447,  1917,   447,   430,   431,   109,
     433,  1793,   241,   295,  1828,  1828,   439,   279,   422,   448,
     233,   425,   284,   412,   413,   454,   430,   315,  3331,  1751,
    1870,  2538,  1872,  2184,   448,  1570,  1870,   196,  1872,  1708,
     454,   293,   260,   447,   109,   263,   422,   387,   943,   425,
     945,   313,   448,  2204,   430,   395,   235,   423,   454,   422,
     448,   323,   425,  2594,  1899,  2596,   454,   430,   434,   435,
     436,  2537,   438,   439,   440,   441,   442,   443,  1913,  1355,
    1356,  1915,  1358,  2864,   447,   422,  1921,  1915,   425,    99,
    1915,   417,  1927,   430,   431,   422,   433,  1932,   425,  1915,
    2964,  3229,   439,   430,  3232,  1887,  1828,  1195,  1196,   448,
    3413,  2363,  2364,  3241,  3242,   454,   295,   448,  1900,  1915,
    1902,  2626,  1904,   454,   179,  2365,  2366,   345,  2128,  1964,
    3519,  1966,   394,   448,  1969,  2515,   191,  2517,   448,   454,
    1809,   423,  1915,   448,   454,   142,   988,   989,  1870,   454,
    1872,   237,   434,   435,   436,   449,   438,   439,   440,   441,
     442,   443,   296,  1998,  1999,   448,   422,   448,  2662,   425,
     293,   454,    76,   454,   430,   295,   231,   381,   293,  2014,
    2015,  2016,   417,  2018,   565,    99,  2021,  2022,  2023,  2091,
     417,   447,  2027,  1915,   249,  2030,  1887,   237,   416,   448,
     197,   352,   440,   421,   422,   454,   424,   425,  1336,  1900,
    1992,  1902,   430,  1904,   448,    76,  1751,   448,  2000,   195,
     454,  2003,  2004,   454,  1893,   179,   223,   608,   609,    90,
    3358,  3359,  3252,   448,   448,   290,   448,   191,  2389,   454,
     454,   238,   454,   298,   423,   448,   448,   448,    85,   246,
     450,  2167,   454,    76,  3483,   434,   435,   436,   110,   438,
     439,   440,   441,   442,   443,   109,   422,    90,   440,   425,
     267,  2422,   448,  2128,   430,   448,   451,   231,   454,   229,
     448,   454,   422,  2065,  2284,   425,   454,  2667,  2070,   451,
     430,   447,   381,  1828,   448,   249,   293,  2677,   150,  2388,
     454,   381,   448,   423,   448,   381,   381,   447,   454,  2000,
     454,   215,  2003,  2004,   434,   435,   436,   381,   438,   439,
     440,   441,   442,   443,   177,  2323,  2324,  2416,  2417,    93,
    2419,   235,  2167,   109,   448,  1870,   290,  1872,   393,   336,
     454,   400,   229,   422,   298,  2434,   425,  2436,   729,   730,
     731,   430,   733,   448,   735,   736,   737,   738,   448,   454,
     741,   742,   743,   744,   454,   217,  2201,  3089,   447,   438,
     439,   440,   441,   442,   235,  2464,   235,   446,   381,   140,
    1915,   447,   763,   304,   447,   766,  2055,   768,   449,   770,
     447,   295,   327,   774,   775,   776,   447,   447,   779,   447,
     781,   447,   783,   400,   449,  2494,   352,   259,   293,   261,
     447,   450,   235,   247,   287,   796,   797,   241,   179,   271,
     412,  2510,   447,   120,   805,   412,   187,   808,    93,  2284,
     811,  2213,   412,   133,   295,   816,   817,    99,   447,   393,
     821,   822,  2297,   824,   120,    99,   827,  2116,   304,  2538,
     241,   303,   440,   441,   442,   455,   400,   133,   183,  2548,
     183,  2316,   223,   224,   845,   846,   447,   183,   142,   183,
    2559,   852,   295,  2328,   183,   454,   183,  2628,    93,   331,
    1608,   157,   447,   159,  2573,  1613,   293,   183,   183,   183,
    2159,   183,  1620,   874,   293,   876,   111,  2648,   879,   183,
     200,  1629,   183,   192,   247,   191,   447,  2887,   447,   361,
     447,   447,  2892,  2893,  2894,  2895,  2896,  2606,   218,   423,
    2900,  2610,   447,   197,   905,   906,   309,   447,   447,   910,
     434,   435,   436,   301,   438,   439,   440,   441,   442,   443,
     447,   447,   447,   454,   447,   447,   222,   928,   447,   223,
      93,   447,   252,   447,   447,  2390,  2391,  2339,   447,  2341,
      93,  2343,   423,   447,   238,   447,   447,   447,   111,   247,
     185,  2660,   246,   434,   435,   436,   235,   438,   439,   440,
     441,   442,   443,   447,   191,  3092,   191,   229,  2423,  2424,
     440,   345,  3500,   267,  2683,   263,   454,   297,   213,   156,
     423,   399,    41,   279,    17,   986,   987,   454,   284,   447,
     381,   434,   435,   436,   447,   438,   439,   440,   441,   442,
     443,  2710,   447,   381,   381,  1006,   241,   449,  1009,   381,
     381,  1012,   293,   346,  3198,   105,   284,   313,   454,   381,
     399,   381,   185,   381,  3208,  2734,   381,   323,   381,   381,
     400,  2582,  2343,   343,   127,  1036,  2438,   293,   385,   385,
     220,   454,   336,   381,   381,   447,  2582,  2579,   343,   381,
     213,   381,  2454,   143,   293,   375,  2510,   377,  3317,  2461,
    2462,   235,   291,    93,   447,   385,   406,   447,    83,   157,
     255,   447,   447,   163,   394,  2530,  2531,  2532,   241,   447,
     408,  1082,   447,  2537,  2538,   191,  1087,   293,   178,  2537,
    1091,  2566,  2537,    93,  2566,   449,  3096,  1098,   394,   334,
     344,  2537,   192,   411,   183,  1106,   183,  2582,  2510,  3109,
    2582,   346,  2567,  2515,  2589,  2517,   400,   207,  2593,  1120,
    1121,  2537,  1123,  1124,  2744,   360,  2528,  2582,  2746,  2747,
    2748,  2749,   367,    17,   434,   454,  2538,   404,  2847,   381,
     333,   454,   283,  2454,  2537,  1146,   422,   196,  1149,   425,
    2461,  2462,   410,   379,   430,   431,   447,   433,   379,  2634,
      76,  3345,  2634,   439,   454,   352,   379,   447,   196,   447,
    3295,   334,   381,   434,   409,  1176,   383,   412,    84,   454,
     434,    81,   454,   346,  1185,  1186,   231,    87,   448,  1190,
     454,   294,  1193,   288,   284,  2537,   249,   360,   445,  2510,
    1201,   291,   448,  1204,   367,  1206,    38,   448,   381,   115,
     381,   343,   132,   447,   239,   239,  3330,   447,  2927,   284,
     284,   127,  1724,   284,   124,   293,   299,  2538,   318,   135,
     381,   381,  3003,   343,   454,    76,   448,   454,   249,   306,
    2529,   397,   109,   306,   109,   151,   409,   327,   319,    90,
    1724,   235,  2961,    93,   235,   235,   400,    98,   235,   434,
     381,   445,   103,   169,   381,  2667,   166,   249,   434,  2744,
     191,   171,   434,   293,   174,  2677,   297,    93,   205,   293,
     441,   191,  2571,  2572,  1097,   208,   208,   454,    93,   447,
     293,   448,   198,    11,   293,   454,    82,   202,   262,   293,
    3414,   109,   454,  1777,   196,   448,   448,   454,   448,  1310,
    1311,   448,   218,   448,   448,   448,   417,   448,   448,   448,
     220,   417,   448,  1324,   448,   448,   448,   196,  1329,  1330,
     448,   417,  3103,   447,  3105,   381,   242,   448,   447,  1340,
     455,  1342,   450,    34,   448,   249,   448,   728,   447,   454,
     450,   732,   225,   734,  3063,   447,  3483,  3482,   739,   740,
     284,   304,   381,   381,   448,   235,   448,   235,   263,   445,
     211,   271,   329,   448,   215,   293,   448,   390,   447,   760,
     454,   762,  2537,   291,   293,   381,   293,   447,   400,   295,
    1391,  3516,  1393,   448,   235,   236,  2851,  2852,  2800,    76,
     238,   300,   238,   447,   304,   400,  2154,   248,   434,  2157,
     316,   454,   454,  2161,   296,   180,   180,  1418,   445,   448,
     177,    98,   803,   804,   196,    76,   103,   327,   191,   810,
     330,   337,  2721,   118,   196,   341,   204,   343,   279,   448,
     448,   282,   348,   448,   448,   447,   434,   454,   434,   447,
    3221,   448,   352,   431,   295,   434,   297,   390,  2206,   225,
    2915,   448,   381,  3463,  3464,   235,  1467,   373,   374,   381,
     381,   164,   446,   412,   235,   447,    81,  2879,    93,   385,
     861,   239,    87,   191,   390,  2887,   867,   297,   221,   129,
    2892,  2893,  2894,  2895,  2896,   374,   447,   878,  2900,   454,
    2975,  3210,   408,   447,   238,  2980,   403,   447,  2983,   423,
     448,   448,  1513,   201,   196,   356,  1517,   448,   448,   124,
     448,   196,  1097,   448,   109,   206,   907,   159,   284,   284,
     447,  3240,   235,   448,   211,   284,   400,   198,   215,   222,
     198,   922,   196,   446,   400,   400,   927,   172,   182,    93,
     448,   447,   120,   120,   296,   196,   240,   447,   235,   236,
     941,   166,   381,   191,   447,   296,   171,   196,  2879,   174,
     447,   248,   448,  1574,   454,  1576,   323,    93,   284,   258,
     218,   317,   423,   296,   296,    96,  1587,   340,  1589,   340,
     191,   293,   374,   434,   435,   436,    93,   438,   439,   440,
     441,   442,   443,   390,   293,   282,   172,   448,   447,   168,
    1611,   339,  1425,  1614,  1615,   220,   162,  1618,   295,   293,
    1621,  1622,   398,  1624,  1625,   454,  1627,   182,    80,  1630,
     317,   448,  1633,   447,   232,  2090,   322,  1638,  1330,  1452,
    2343,  2025,  2465,  2055,  2012,  3119,  2938,  2844,  2941,  3104,
    3148,  2400,  3454,  1466,  3474,  1656,  2404,  1658,  1659,  2950,
    3437,  1662,  3436,  3457,  2943,  2954,   271,  1668,  1584,  3179,
    2073,  3504,  3531,  2537,  3132,  3485,  2509,  2538,  3131,   356,
    1569,  3532,  1683,  3158,  3086,  1686,  3158,  1630,   182,  1070,
    1071,  1186,  3094,  2186,  3096,  3003,  1077,  1510,  3331,   304,
    3413,  2955,  1949,  2416,  1948,  3378,  3494,  3109,  3530,  2962,
     921,  3307,  1525,  2080,  1838,   158,  2635,  3172,  2349,  1168,
    2165,  1722,  2470,  2471,  3179,   330,  2997,  1363,  2357,  1542,
    3205,  2367,  1364,  1853,  1362,  1116,  1117,  1118,  1832,  2328,
    2128,  1122,  2595,  3206,  2246,   803,   423,   352,  2250,  2936,
    2720,  3063,  2360,  2191,  1567,  2297,  3465,   434,   435,   436,
    2295,   438,   439,   440,   441,   442,   443,  1780,  2215,   565,
    2579,  1127,  2246,  1599,  2121,  3086,  2250,  1893,  1373,  2281,
    2282,    76,   329,  3094,  1785,  1868,  1192,   989,  1016,  1900,
    2173,   704,  2338,  2174,  2999,  2783,  2998,  1610,  3087,  3085,
    1308,   364,  1371,  1184,  1904,  2168,  1619,  2281,  2282,   990,
    3519,  1651,     2,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1203,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1831,  3120,  3121,    -1,    -1,    -1,  3125,    -1,    -1,    -1,
    1841,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1425,    -1,    -1,    -1,  3256,    -1,    -1,  2605,    -1,  2607,
      -1,  2609,    -1,  2611,    -1,    -1,    -1,    -1,  2616,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3354,
      -1,    -1,  3354,    -1,    -1,    -1,    -1,  3507,    -1,    -1,
      -1,  1466,  1893,    -1,    -1,    -1,    -1,  3186,  1899,  2647,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1912,  1913,    -1,    -1,  1916,  1917,    -1,    -1,    -1,
    1921,    -1,    -1,    -1,    -1,    -1,  1927,    -1,    -1,    -1,
    3405,  1932,  1933,  3405,    -1,  1510,  1749,    -1,  3393,    -1,
      -1,    -1,    -1,    -1,    -1,  3256,    -1,    -1,    -1,    -1,
    1525,    -1,    -1,    -1,    -1,    -1,    -1,  1338,    76,    -1,
    1961,  1962,  1963,  1964,    -1,  1966,    -1,    -1,  1969,  1970,
      -1,    -1,    90,    -1,    -1,  1976,    -1,    -1,    -1,    -1,
      98,    -1,    -1,  3438,    -1,   103,    -1,    -1,    -1,  1990,
      -1,    -1,  1567,  1994,    -1,    -1,  1997,  1998,  1999,    -1,
      -1,    -1,    -1,    84,    -1,    -1,    -1,    -1,    -1,    -1,
      91,  2012,  2013,  2014,  2015,  2016,  2017,  2018,    -1,  3494,
    2021,  2022,  2023,    -1,    -1,  2026,  2027,    -1,  2029,  2030,
    2031,    -1,  3507,    -1,    -1,  1610,    -1,    -1,    -1,  3328,
      -1,    -1,    -1,    -1,  1619,    -1,    -1,  2048,  2049,   130,
      -1,    -1,    -1,    -1,    -1,  3530,    -1,    -1,    -1,    -1,
      -1,  3463,  3464,    -1,  2065,    -1,    -1,   148,   149,    -1,
      -1,    -1,    -1,    -1,    -1,   156,    -1,    -1,    -1,   160,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2092,    -1,   211,    -1,    -1,    -1,   215,    -1,   180,
    1481,   182,    -1,    -1,    -1,    -1,  2107,    -1,    -1,  1490,
    2111,    -1,  2113,    -1,    -1,    -1,   197,   235,   236,    -1,
    2121,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2129,    -1,
     248,    -1,  2133,  2134,    -1,  1948,  1949,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2147,  2148,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   279,    -1,    -1,   282,    -1,  2167,    -1,    -1,    -1,
      -1,    -1,    84,    -1,  1749,    76,    -1,   295,    -1,   297,
      -1,    -1,  2684,  2184,    -1,  2687,  2688,  2689,  2690,  2691,
    2692,  2693,  2694,  2695,  2696,    -1,    -1,    98,    -1,    -1,
    2201,    -1,   103,  2204,    -1,    -1,    -1,    -1,    -1,    -1,
    2684,    -1,    -1,  2687,  2688,  2689,  2690,  2691,  2692,  2693,
    2694,  2695,  2696,   135,  1605,    -1,  1607,    76,    -1,    -1,
      -1,  1612,    -1,  2046,  2736,  2737,    -1,    -1,   356,   151,
      -1,    -1,  1623,    -1,    -1,  1626,  2994,  2995,    -1,    98,
    2063,    -1,    -1,    -1,   103,    -1,    -1,   169,    -1,    -1,
      -1,    -1,  2736,  2737,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2272,    -1,    -1,    -1,    -1,  1657,    -1,    -1,  1660,
    1661,    -1,    -1,    -1,    -1,    -1,   198,    -1,    -1,    -1,
     371,  1672,   204,    -1,    -1,    -1,    -1,    -1,    -1,  2300,
      -1,    -1,    -1,    -1,    -1,   423,   218,    -1,    -1,    -1,
     211,    -1,    -1,    -1,   215,    -1,   434,   435,   436,    -1,
     438,   439,   440,   441,   442,   443,    -1,    -1,   446,   241,
      -1,    -1,    -1,    -1,   235,   236,    -1,   455,    -1,    -1,
      -1,    -1,  2343,    -1,    -1,    -1,    76,   248,  2349,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      90,  2362,   211,    -1,    -1,    -1,   215,    -1,    98,    -1,
      -1,    -1,    -1,   103,    -1,    -1,    -1,    -1,   279,    -1,
      -1,   282,    -1,   295,    -1,    -1,   235,   236,  2389,  2390,
    2391,    -1,    -1,    -1,   295,    -1,    -1,    -1,  1779,   248,
      -1,    -1,  2403,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2916,    -1,    -1,    -1,    -1,    -1,
      -1,  2422,  2423,  2424,    -1,   337,    -1,    -1,    -1,    -1,
      -1,   343,    -1,   282,    -1,    -1,   348,    -1,    -1,  2440,
    2441,    -1,  2916,    -1,    -1,    -1,   295,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   356,    -1,  1838,    -1,  2460,
      -1,   373,   374,  3211,  3212,  3213,    -1,    -1,    -1,    -1,
      -1,  2046,    -1,   385,    -1,    -1,    -1,    -1,   390,    -1,
      -1,   211,    -1,    -1,   565,   215,    -1,   399,  2063,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2497,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   235,   236,   356,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2517,    -1,   248,    -1,
      -1,    -1,   423,    -1,    -1,    -1,    -1,    -1,    -1,  2530,
    2531,  2532,    -1,   434,   435,   436,    -1,   438,   439,   440,
     441,   442,   443,    -1,    -1,    -1,    -1,    -1,    -1,   279,
      -1,    -1,   282,    -1,    -1,  3057,  3058,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   295,  2567,   297,    -1,    -1,
      -1,  2572,    -1,    -1,   423,  2388,    -1,    -1,  2579,    -1,
      -1,  2582,  2583,  3057,  3058,  2586,   435,   436,    -1,   438,
     439,   440,   441,   442,   443,    -1,    -1,    -1,  2599,    -1,
      -1,    -1,    -1,  2416,  2417,    -1,  2419,    -1,  3356,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2434,    -1,  2436,    -1,    -1,   356,  2628,    -1,    -1,
      -1,    -1,    -1,    -1,  2635,    -1,    -1,    -1,    -1,  2020,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2648,    -1,    -1,
      -1,  2464,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2662,    -1,    76,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   757,    90,    -1,    -1,
      -1,  2494,    -1,    -1,    -1,    98,    -1,    -1,    -1,    -1,
     103,    -1,    -1,   423,    -1,    -1,    -1,  2510,    -1,    -1,
      -1,    -1,    -1,    -1,   434,   435,   436,  2088,   438,   439,
     440,   441,   442,   443,   795,   796,   797,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   454,  2538,    -1,  3229,    -1,  2110,
    3232,    -1,    -1,    -1,    -1,  2548,    -1,  2118,    -1,  3241,
    3242,    -1,    -1,    -1,    -1,    -1,  2559,  2128,   829,    -1,
      -1,    -1,   833,    -1,   835,  3229,   837,    -1,  3232,    -1,
    2573,    -1,   843,   844,    -1,    -1,    -1,  3241,  3242,    -1,
      -1,   852,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2785,    -1,    -1,    -1,    -1,    -1,
     871,    -1,    -1,  2606,    -1,    -1,    -1,  2610,   211,    -1,
      -1,    -1,   215,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2388,  2815,  2816,    -1,   898,    -1,    -1,
      -1,    -1,   235,   236,   905,   906,    -1,    -1,   909,   910,
      -1,    -1,    -1,    -1,    -1,   248,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2660,    -1,    -1,
    2851,  2852,    -1,    -1,    -1,    -1,  3358,  3359,    -1,  2434,
      -1,  2436,    -1,    -1,    -1,    -1,   279,    -1,    -1,   282,
    2683,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   295,    -1,  3358,  3359,    -1,  1097,   969,  2464,
      -1,  2892,  2893,  2894,  2895,  2896,    -1,  2710,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   986,   987,    -1,    -1,    -1,
      -1,    -1,    76,  1097,  2915,    -1,    -1,    -1,    -1,  2494,
     140,  2734,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    98,  2936,    -1,  2938,    -1,   103,
    2941,  2322,  2943,   356,    -1,    -1,    -1,  2328,    -1,  2950,
      -1,    -1,    -1,    -1,    -1,  2956,    -1,    -1,    -1,   179,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   187,    -1,    -1,
    2971,    -1,  2973,  2548,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2984,  2559,  2986,    -1,    -1,    -1,  2990,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3003,   223,    -1,    -1,    -1,    84,    -1,    -1,
     423,    -1,    -1,  1094,   178,    -1,    -1,    -1,    95,    -1,
      -1,   434,   435,   436,    -1,   438,   439,   440,   441,   442,
     443,  2606,    -1,    -1,  2847,  2610,    -1,    -1,   115,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   211,    -1,    -1,
      -1,   215,    -1,    -1,    -1,    -1,    -1,    -1,   135,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   235,   236,    -1,   151,    -1,    -1,    -1,    -1,  1160,
      -1,    -1,    -1,    -1,   248,  2660,    -1,    -1,    -1,    -1,
      -1,  3092,   169,    -1,    -1,    -1,    -1,    -1,  1179,    -1,
      -1,  1182,  3103,  3104,  3105,    -1,    -1,    -1,  2683,  3110,
      -1,  1192,    -1,    -1,  2927,    -1,    -1,    -1,   282,    -1,
      -1,   198,    -1,  3124,    -1,    -1,    -1,   204,    -1,    -1,
      -1,   295,    -1,    -1,    76,  2710,    -1,    -1,    -1,    -1,
      -1,   218,    -1,    -1,    -1,    -1,    -1,    -1,  2961,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,  2734,
      -1,   103,    -1,  2544,    -1,    -1,    -1,    -1,    -1,  2550,
      -1,  3172,    -1,    -1,    -1,    -1,    -1,    -1,  3179,    -1,
      -1,    -1,    -1,    -1,  3185,    -1,    -1,  1268,  2569,    -1,
      -1,    -1,   356,    -1,  3195,    -1,    -1,  3198,  1279,    -1,
      -1,    -1,    -1,    -1,    -1,    82,    -1,  3208,  2589,    -1,
      -1,    -1,  2593,    -1,    -1,  1425,    -1,    -1,   295,    -1,
    3221,    -1,    -1,    -1,  1305,    -1,   303,    -1,    -1,  1310,
    1311,  2612,    -1,  2614,    -1,    -1,   178,    -1,    -1,   316,
      -1,  1425,  1452,  1324,    -1,  2626,  1327,    -1,  1329,  1330,
    3063,    -1,    -1,    -1,    -1,   132,  1466,    -1,    -1,   423,
     337,    -1,   139,   140,   341,  2646,   343,    -1,  1452,   211,
      -1,   348,  2847,   215,   438,   439,   440,   441,   442,   443,
      -1,    -1,  1466,    -1,  3285,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   235,   236,    76,   373,   374,    79,   176,
    1510,    -1,    -1,    -1,    -1,  3306,   248,  3308,   385,    -1,
    1391,    92,  1393,   390,    -1,  1525,    -1,    -1,    -1,    -1,
      -1,    -1,   399,    -1,    -1,    -1,  1510,    -1,    -1,  3330,
    3331,   408,  1542,   114,  3335,  3336,    -1,    -1,   215,    -1,
     282,  1525,    -1,   220,  3345,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2927,   295,    -1,    -1,    -1,  1567,  1542,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   148,    -1,    -1,
    2751,  2752,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     257,    -1,    -1,  1567,    -1,    -1,    -1,    -1,    -1,    76,
      -1,    -1,  3393,    -1,    -1,   272,   273,  3210,   275,   276,
    1610,   278,    -1,    90,    -1,    -1,    -1,    -1,    -1,  1619,
      -1,    98,  3413,  3414,   356,    -1,   103,    -1,    -1,    -1,
      -1,   202,    -1,    -1,    -1,    -1,  1610,  3240,   209,   306,
     211,  1512,    -1,    -1,    -1,  1619,    -1,  3438,    -1,    -1,
      -1,   222,    -1,    -1,    -1,  3446,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     337,    -1,    -1,    -1,    -1,    -1,    -1,  3468,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   423,  3483,    -1,    -1,    -1,    -1,    -1,  3063,    -1,
      -1,    -1,   369,    -1,   371,    -1,   438,   439,   440,   441,
     442,   443,    -1,  3504,    -1,    -1,  1587,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   392,  1597,    -1,  2899,   739,
      -1,    -1,   399,    -1,   211,   402,    -1,    -1,   215,    -1,
    3531,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1749,
     760,  2922,    -1,    -1,    -1,    -1,    -1,   328,   235,   236,
      -1,  2932,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   248,    -1,    -1,    -1,  1749,    -1,    -1,    -1,    -1,
    1651,  1652,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   365,    -1,    -1,   368,    -1,    -1,
      -1,    -1,   279,    -1,  2975,   282,    -1,    -1,    -1,  2980,
      -1,    -1,  2983,    -1,    -1,    -1,    -1,    -1,   295,    -1,
     297,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1701,  1702,  1703,    -1,    -1,    -1,    -1,  1708,  1709,    -1,
      -1,    -1,  1713,  1714,    -1,  3210,    -1,    -1,    -1,  1720,
      -1,   861,    -1,    -1,    -1,    -1,    -1,   867,  1729,    -1,
    1731,    -1,  3465,    -1,    -1,    -1,    -1,    -1,   878,    -1,
      -1,    -1,    -1,    -1,  1745,  3240,  1747,    -1,    -1,   356,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   907,    -1,    -1,
      -1,    -1,    -1,    -1,  3075,  3076,  3077,  3078,  1779,    -1,
      -1,    -1,   922,    -1,  1785,    -1,  3519,   927,    -1,    -1,
      -1,    -1,  1793,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   941,    -1,    -1,    -1,    -1,    -1,    -1,  1809,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   423,    -1,  1948,  1949,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   434,   435,   436,
      -1,   438,   439,   440,   441,   442,   443,    -1,    -1,    -1,
      -1,   448,    -1,    -1,  1948,  1949,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   565,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   138,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    76,  3185,    -1,  1887,    -1,    -1,    -1,
      -1,    -1,  1893,    -1,    -1,    -1,    -1,    90,  1899,    -1,
      -1,    -1,    -1,    -1,  3205,    98,    -1,    -1,    -1,    -1,
     103,    -1,    -1,    76,   179,    -1,  2046,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   191,    90,    -1,    -1,
    1070,   196,    -1,  2063,    -1,    98,   201,    -1,    -1,   204,
     103,   206,  2046,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,  2063,
      -1,    -1,    -1,    -1,    -1,    -1,   231,    -1,    -1,    -1,
    3465,    -1,    90,    -1,    -1,    -1,  1116,  1117,  1118,    -1,
      98,    -1,    -1,    -1,   249,   103,    -1,    -1,    -1,    -1,
      76,  1992,    -1,    -1,  3295,    -1,  3297,    -1,    -1,  2000,
      -1,    -1,  2003,  2004,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    -1,    -1,    -1,  3317,   103,   211,   720,
      -1,    -1,   215,   724,  3519,   290,    -1,   728,    -1,    -1,
    3331,   732,    -1,   298,    -1,    -1,    -1,    -1,    -1,  3340,
      -1,    -1,   235,   236,  1184,    -1,  2047,    -1,   211,    -1,
    2051,    -1,   215,    -1,  2055,   248,    -1,    -1,    -1,    -1,
      -1,   762,    -1,  1203,  2065,    -1,    -1,    -1,   333,  2070,
      -1,  3372,   235,   236,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   248,   279,    -1,    -1,   282,
      -1,    -1,   178,   211,    -1,    -1,    -1,   215,    -1,    -1,
     801,    -1,   295,   804,   297,    -1,    -1,    -1,   373,   810,
      -1,    -1,  3413,    -1,    -1,  2116,   279,   235,   236,   282,
      -1,    -1,    -1,    -1,    -1,   211,    -1,    -1,   393,   215,
     248,    -1,   295,    -1,   297,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   411,    -1,    -1,   235,
     236,    -1,    -1,   418,   419,   420,    -1,    -1,  2159,    -1,
      -1,   279,   248,   356,   282,    -1,  2167,  2168,    -1,    -1,
    2171,    -1,  2173,    -1,    -1,    -1,    -1,   295,    -1,   297,
     445,  3482,    -1,   448,   449,   450,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   356,    -1,    -1,   282,    -1,  1338,    -1,
      -1,    -1,   903,    -1,    -1,    -1,    -1,   908,    -1,   295,
     911,    -1,  2213,    -1,    -1,  3516,    -1,    -1,    -1,    -1,
      -1,    -1,   923,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     423,    -1,   933,    -1,    -1,    -1,    -1,    -1,   356,    -1,
      -1,   434,   435,   436,    -1,   438,   439,   440,   441,   442,
     443,    -1,    -1,    -1,    -1,   448,    -1,    -1,  2388,    -1,
     423,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     356,   434,   435,   436,    -1,   438,   439,   440,   441,   442,
     443,    -1,    -1,    -1,  2388,   448,  2416,  2417,    -1,  2419,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2434,   423,  2436,    -1,    -1,    -1,
      -1,    -1,  2416,  2417,    -1,  2419,   434,   435,   436,    -1,
     438,   439,   440,   441,   442,   443,    -1,    -1,   446,    -1,
    2434,    -1,  2436,    -1,  2464,    -1,    -1,   423,  2339,    -1,
    2341,  1481,  2343,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   438,   439,   440,   441,   442,   443,    -1,    -1,
    2464,    -1,    -1,    -1,  2494,  1066,  1067,    -1,    -1,    -1,
    1071,    -1,    -1,    -1,    -1,    -1,  1077,    -1,    -1,    -1,
    2510,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2494,    -1,    -1,    -1,    -1,    -1,  1097,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2510,    -1,  2538,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2548,    -1,
      -1,  1122,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2559,
      -1,    -1,    -1,    -1,  2538,    -1,    -1,  2438,    -1,    -1,
      -1,    -1,    -1,  2573,  2548,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2454,    -1,  2559,    -1,    -1,    -1,    -1,
    2461,  2462,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2573,
      -1,    -1,    -1,    -1,    -1,    -1,  2606,    -1,    -1,    -1,
    2610,    -1,    -1,  1623,    -1,    -1,  1626,    -1,    -1,    -1,
      -1,    -1,  2493,    -1,  2495,  2496,    -1,    -1,    -1,    -1,
      -1,    -1,  2606,  2504,    -1,    -1,  2610,    -1,    -1,  2510,
      -1,  1212,    -1,    -1,  2515,    -1,  2517,    -1,    -1,    -1,
    1660,  1661,    -1,    -1,    -1,    -1,    -1,  2528,  2529,     3,
    2660,    -1,  1672,    -1,    -1,     9,    -1,  2538,  1239,    -1,
      -1,    -1,    16,    -1,    18,    -1,    -1,    21,    -1,    -1,
      -1,    -1,    -1,  2683,    -1,    -1,  2660,    -1,    32,    -1,
      -1,    -1,  1263,  1264,    -1,  1266,    -1,    -1,    -1,    -1,
    2571,  2572,    -1,    -1,    -1,    -1,    50,    51,    -1,  2683,
    2710,  2582,    -1,  1284,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    77,  2734,    -1,  2710,    -1,    -1,    -1,
      -1,    -1,    -1,    87,    88,    89,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1327,    -1,   102,    -1,
    2734,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1779,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   121,    -1,   123,
     124,    -1,    -1,    -1,   128,   129,  1357,    -1,    -1,  1360,
    1361,    -1,    -1,   137,   138,    -1,  2667,    -1,    -1,    -1,
    1371,  1372,  1373,    -1,    -1,    -1,  2677,   151,    -1,   153,
      -1,    -1,   156,    -1,    -1,    -1,    -1,    -1,   162,    -1,
      -1,    -1,    -1,    -1,   138,    -1,    -1,   171,  1838,    -1,
      -1,    -1,    -1,   177,    -1,    -1,    -1,    -1,   182,    -1,
     184,    -1,    -1,    -1,   188,  1416,    -1,  2847,    -1,    -1,
    2721,    -1,  1423,    -1,  1425,   199,    -1,   201,  1429,    -1,
      -1,    -1,  1433,    -1,    -1,   179,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2847,    -1,    -1,    -1,   191,    -1,    -1,
      -1,  1452,   196,   227,    -1,    -1,    -1,   201,    -1,    -1,
     204,    -1,   206,    -1,    -1,  1466,    -1,  1468,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   250,   251,    -1,    -1,
      -1,    -1,   256,    -1,    -1,    -1,    -1,   231,    -1,    -1,
     264,    -1,    -1,  1494,    -1,    -1,    -1,  2927,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   249,    -1,   281,    -1,  1510,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2927,  1525,    -1,    -1,    -1,    -1,    -1,
      -1,  2961,    -1,    -1,    -1,    -1,    -1,   311,    -1,    -1,
      -1,  1542,    -1,    -1,    -1,    -1,   290,   321,    -1,    -1,
     324,    -1,   326,    -1,   298,    -1,   330,  2961,    -1,  2860,
    2861,   335,    -1,    -1,   338,    -1,  1567,    -1,   342,  1570,
      -1,    -1,    -1,   347,    -1,    -1,    -1,    -1,   352,    -1,
    2020,   355,    -1,    -1,    -1,    -1,  2887,   361,    -1,   333,
      -1,  2892,  2893,  2894,  2895,  2896,    -1,    -1,    -1,  2900,
      -1,    -1,    -1,    -1,  1605,    -1,  1607,    -1,    -1,  1610,
      -1,  1612,    -1,    -1,   388,    -1,   390,    -1,  1619,    -1,
      -1,    -1,   396,    -1,   398,    -1,    -1,   401,    -1,   373,
     404,    -1,    -1,  3063,    -1,    -1,  1097,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2088,   393,
      -1,    -1,    -1,  2954,    -1,    -1,  1657,    76,    -1,  3063,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   411,    -1,    -1,
    2110,    90,    -1,   447,   418,   419,   420,    -1,  2118,    98,
      -1,    -1,    -1,    -1,   103,    -1,    -1,  1688,  1689,    -1,
      -1,    -1,    -1,    -1,    -1,  1696,    -1,  2998,  1699,  1700,
      -1,   445,    -1,    -1,   448,   449,   450,  1708,    -1,    -1,
    1711,  1712,    -1,    -1,    -1,    -1,    -1,    -1,  1719,    -1,
      -1,    -1,  1723,  1724,  1725,  1726,    -1,    -1,    -1,    -1,
      -1,    -1,  1733,  1734,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1749,  1750,
    1751,    -1,    -1,  1754,    -1,    -1,  1097,  1758,    -1,    -1,
      -1,  1762,    -1,    -1,  1765,  1766,  1767,  1768,  1769,  1770,
    1771,  1772,  1773,    -1,  1775,    -1,    -1,    -1,    -1,  1780,
    3210,    -1,    -1,  1784,    -1,  3086,  3087,    -1,    -1,    -1,
      -1,    -1,   211,    -1,    -1,  3096,   215,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3210,    -1,  3109,    -1,
    3240,    -1,    -1,    -1,  3115,  3116,   235,   236,    -1,  3120,
    3121,    -1,    -1,    -1,  3125,    -1,    -1,  1828,    -1,   248,
      -1,    -1,    -1,    -1,    -1,    -1,  3240,    -1,    -1,  1840,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     279,    -1,    -1,   282,    -1,    -1,    -1,    -1,    -1,  1870,
      -1,  1872,    -1,    -1,    76,    -1,   295,    -1,   297,    -1,
      -1,    -1,  2322,    -1,    -1,  3186,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,
      -1,   103,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1915,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1930,
      -1,    -1,    -1,    92,    -1,    -1,    -1,   356,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1948,  1949,    -1,
      -1,    -1,    -1,    -1,    -1,   114,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1425,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    76,    -1,    -1,    -1,  3278,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,
      -1,  1452,    -1,    -1,    -1,    98,    -1,    -1,    -1,    -1,
     103,    -1,    -1,    -1,   423,  1466,    -1,    -1,    -1,   211,
      -1,    -1,    -1,   215,    -1,   434,   435,   436,    -1,   438,
     439,   440,   441,   442,   443,    -1,    -1,  3328,    -1,   448,
      -1,    -1,    -1,   235,   236,  3465,    -1,    -1,    -1,  2040,
      -1,    -1,    -1,   202,    -1,  2046,   248,    -1,    -1,  1510,
     209,    -1,   211,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2061,  3465,  2063,   222,  1525,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   279,    -1,    -1,
     282,  1542,    -1,    -1,  1425,    -1,    -1,    -1,    -1,  3519,
      -1,    -1,    -1,   295,    -1,   297,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2544,    -1,  1567,    -1,   211,    -1,
    2550,  1452,   215,    -1,    -1,  3519,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1466,    -1,  2128,    -1,  2569,
      -1,    -1,   235,   236,    -1,    -1,  2137,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   248,    -1,    -1,    -1,  1610,
      -1,    -1,    -1,    -1,   356,    -1,    -1,    -1,  1619,    -1,
      -1,    -1,  3463,  3464,    -1,    -1,    -1,  3468,    -1,  1510,
      -1,    -1,  2612,    -1,  2614,    -1,   279,    -1,    -1,   282,
      -1,    -1,    -1,    -1,  1525,    -1,    -1,    -1,    -1,    -1,
    2191,    -1,   295,    -1,   297,    -1,    -1,    -1,    -1,    -1,
      -1,  1542,    -1,  3504,    -1,    -1,  2646,    -1,    -1,    -1,
      -1,    -1,    -1,  2214,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   423,    -1,    -1,    -1,    -1,  1567,    -1,    -1,    -1,
    3531,    -1,   434,   435,   436,    -1,   438,   439,   440,   441,
     442,   443,    -1,    -1,    -1,  2246,   448,    -1,    -1,  2250,
      -1,    -1,    -1,   356,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2262,  2263,  2264,  2265,    76,    -1,    -1,    -1,  1610,
    2271,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1619,    -1,
    2281,  2282,    -1,  2284,    -1,    -1,    -1,    98,  1749,    -1,
      -1,    -1,   103,    -1,    -1,  2296,    -1,  2298,    -1,    -1,
      -1,  2302,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2751,  2752,    -1,    -1,    -1,    -1,  2318,    -1,    -1,
     423,    -1,    -1,    -1,    -1,    -1,    -1,  2328,    -1,  2330,
    2331,   434,   435,   436,    -1,   438,   439,   440,   441,   442,
     443,    -1,    -1,    -1,    -1,   448,    -1,    -1,    -1,    -1,
    2351,    -1,    -1,    -1,    -1,    -1,  2357,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2365,  2366,  2367,   178,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2388,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    76,    -1,    -1,  2399,    -1,
     211,    -1,    -1,    -1,   215,    -1,    -1,    -1,  1749,    90,
      -1,    -1,    -1,    -1,    -1,  2416,  2417,    98,  2419,    -1,
      -1,    -1,   103,    -1,   235,   236,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2434,    -1,  2436,    -1,   248,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2899,
      -1,    -1,    -1,  2464,    -1,    90,    -1,    -1,    -1,    94,
      -1,   282,    -1,    98,    -1,    -1,    -1,    -1,   103,    -1,
      -1,    -1,  2922,    -1,   295,    -1,    -1,  1948,  1949,    -1,
      -1,    -1,  2932,  2494,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    76,    -1,    -1,    -1,  2509,  2510,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,
     211,   103,    -1,    -1,   215,    -1,  2537,  2538,    -1,    -1,
     165,    -1,    -1,    -1,    -1,   356,    -1,  2548,    -1,    -1,
      -1,    -1,    -1,    -1,   235,   236,    -1,    -1,  2559,    -1,
      -1,   720,    -1,    -1,    -1,    -1,    -1,   248,    -1,   728,
      -1,    -1,  2573,   732,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2046,   211,    -1,  2589,    -1,
     215,    -1,  2593,    -1,    -1,    -1,    -1,    -1,   279,    -1,
      -1,   282,  2063,   762,    -1,  2606,    -1,  1948,  1949,  2610,
     235,   236,   423,    -1,   295,    -1,   297,    -1,    -1,   191,
      -1,    -1,    -1,   248,   196,  2626,    -1,   438,   439,   440,
     441,   442,   443,    -1,    -1,  3075,  3076,  3077,  3078,   211,
      -1,    -1,    -1,   215,    -1,   804,    -1,    -1,    -1,    -1,
    2651,   810,    -1,    -1,   279,    -1,  2657,   282,    -1,  2660,
      -1,    -1,    -1,   235,   236,    -1,    -1,    -1,  2669,    -1,
     295,    -1,   297,    -1,  2675,   356,   248,    -1,  2679,    -1,
      -1,    -1,  2683,  2684,    -1,    -1,  2687,  2688,  2689,  2690,
    2691,  2692,  2693,  2694,  2695,  2696,    -1,    -1,    -1,    -1,
    2701,  2702,    -1,    -1,    -1,  2046,    -1,   279,    -1,  2710,
     282,    -1,    -1,    -1,  2715,    -1,    -1,    -1,    -1,    -1,
      -1,  2722,  2063,   295,  2725,   297,  2727,    -1,    -1,    -1,
      -1,   356,    -1,  2734,  2735,  2736,  2737,    -1,    -1,    -1,
    2741,    -1,   423,  2744,   903,    -1,    -1,    -1,    -1,   908,
      -1,    -1,   911,   434,   435,   436,    -1,   438,   439,   440,
     441,   442,   443,    -1,    -1,    -1,    -1,   448,    -1,    -1,
      -1,    -1,    -1,    -1,   933,   400,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   356,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   423,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,   434,
     435,   436,    -1,   438,   439,   440,   441,   442,   443,    -1,
      -1,    -1,    90,    -1,    -1,    93,    -1,    -1,    -1,    -1,
      98,    -1,    -1,    -1,    -1,   103,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2847,    -1,    -1,    -1,
      -1,   423,    -1,    -1,    -1,    -1,    -1,  3297,    -1,    -1,
      -1,    -1,   434,   435,   436,    -1,   438,   439,   440,   441,
     442,   443,    -1,    -1,    -1,    -1,    -1,  3317,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3340,    -1,    -1,    -1,    -1,    -1,    -1,  1066,  1067,    -1,
      -1,    -1,  1071,    -1,    -1,  2916,    -1,    -1,  1077,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2927,  2388,    -1,    -1,
      -1,    -1,  3372,    -1,    -1,    -1,    -1,    -1,  1097,    -1,
      -1,    -1,    -1,   211,    -1,    -1,    -1,   215,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2416,  2417,    -1,  2419,    -1,
    2961,    -1,    -1,  1122,    -1,    -1,    -1,   235,   236,    -1,
       2,    -1,    -1,  2434,  2975,  2436,    -1,    -1,    -1,  2980,
     248,    -1,  2983,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2464,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   279,    -1,    -1,   282,  3016,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   295,    -1,   297,
      -1,    -1,    -1,  2494,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2388,    -1,  2510,
      -1,    -1,    84,  1212,    -1,    -1,  3057,  3058,    -1,    -1,
      -1,  3062,  3063,    -1,    -1,    -1,    -1,    -1,  3069,  3070,
      -1,    -1,  3073,    -1,    -1,  2416,  2417,  2538,  2419,    -1,
    1239,    -1,    -1,    -1,    -1,    -1,    -1,  2548,   356,    -1,
      -1,    -1,    -1,  2434,    -1,  2436,    -1,    -1,  2559,    -1,
      -1,    -1,    -1,    -1,  1263,  1264,    -1,  1266,    -1,    -1,
      -1,    -1,  2573,    -1,    -1,    -1,   148,    -1,    -1,    -1,
      -1,    -1,    -1,  2464,    -1,  1284,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    84,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2606,  3147,    -1,   180,  2610,
      -1,    -1,    -1,  2494,    -1,   423,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   434,   435,   436,  2510,
     438,   439,   440,   441,   442,   443,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3185,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2538,  1357,  2660,
    3201,  1360,  1361,    -1,  3205,    -1,    -1,  2548,    -1,  3210,
      -1,    -1,    -1,   160,    -1,    -1,    -1,    -1,  2559,    -1,
      -1,    -1,  2683,    -1,    -1,    -1,    -1,    -1,  3229,    -1,
      -1,  3232,  2573,   180,    -1,   182,    -1,    -1,    -1,  3240,
    3241,  3242,    -1,    -1,  3245,    -1,    -1,    -1,    -1,  2710,
      -1,  3252,  3253,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2606,  1425,    -1,    76,  2610,
    1429,    -1,    -1,  2734,  1433,  3276,    -1,    -1,    -1,    -1,
      -1,    -1,    90,    -1,    -1,    93,    -1,    -1,    -1,    -1,
      98,    -1,    -1,  1452,  3295,   103,    -1,    -1,    76,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1466,    -1,  1468,
      -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,  2660,
      98,    -1,    -1,    -1,    -1,   103,    -1,    -1,    -1,    -1,
    3331,  3332,    -1,    -1,    -1,  1494,    -1,    76,    -1,    -1,
      -1,    -1,  2683,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1510,    -1,    -1,    -1,    -1,    -1,  3358,  3359,    98,
      -1,    -1,    -1,    -1,   103,    -1,  1525,    -1,    -1,  2710,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1097,
      -1,    -1,    -1,  1542,    -1,    -1,  2847,    -1,    -1,    -1,
      -1,    -1,    -1,  2734,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   211,    -1,    -1,    -1,   215,  1567,    -1,
      -1,  1570,  3413,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   235,   236,    -1,
      -1,    -1,    -1,   211,    -1,    -1,    -1,   215,    -1,   178,
     248,    -1,    -1,    -1,    -1,    -1,  1605,    -1,  1607,    -1,
      -1,  1610,    -1,  1612,    -1,    -1,    -1,   235,   236,    -1,
    1619,    -1,    -1,    -1,  3465,    -1,  2927,    -1,    -1,    -1,
     248,   279,   211,    -1,   282,    -1,   215,    -1,    -1,    -1,
      -1,  3482,    -1,    -1,    -1,    -1,    -1,   295,    -1,   297,
      -1,    -1,    -1,    -1,    -1,    -1,   235,   236,  1657,    -1,
    2961,   279,    -1,    -1,   282,    -1,  2847,    -1,    -1,   248,
      -1,    -1,    -1,    -1,    -1,  3516,    -1,   295,  3519,   297,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1688,
    1689,    -1,    -1,   565,    -1,    -1,    -1,  1696,    -1,    -1,
    1699,  1700,    -1,   282,    -1,    -1,    -1,    -1,   356,    -1,
      -1,    -1,  1711,  1712,    -1,    -1,   295,    -1,    -1,    -1,
    1719,    -1,    -1,    -1,  1723,  1724,  1725,  1726,    -1,    -1,
      -1,    -1,    -1,    -1,  1733,  1734,    -1,    -1,   356,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2927,    -1,    -1,    -1,
    1749,  1750,  1751,    -1,    -1,  1754,    -1,    -1,    -1,  1758,
      -1,    -1,  3063,  1762,    -1,    -1,  1765,  1766,  1767,  1768,
    1769,  1770,  1771,  1772,  1773,   423,  1775,   356,    -1,    -1,
    2961,  1780,   400,    -1,    -1,  1784,   434,   435,   436,    -1,
     438,   439,   440,   441,   442,   443,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   423,    -1,    -1,    -1,    76,
      -1,    -1,    -1,    -1,    -1,    -1,   434,   435,   436,    -1,
     438,   439,   440,   441,   442,   443,    -1,    -1,   700,    -1,
      -1,    98,    -1,    -1,    -1,    -1,   103,    -1,    -1,    -1,
      -1,  1840,    -1,    -1,   423,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   438,
     439,   440,   441,   442,   443,    -1,    -1,  1425,    -1,    -1,
      -1,    -1,    -1,    76,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3063,    -1,    -1,   757,    -1,    90,    -1,    -1,
      -1,    -1,    -1,    -1,  1452,    98,    -1,    -1,    -1,    -1,
     103,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1466,  3210,
      -1,   178,    -1,    -1,    -1,    -1,  1915,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1930,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3240,
      -1,    -1,    -1,    -1,   211,    -1,    -1,    -1,   215,  1948,
    1949,    -1,  1510,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1525,   235,   236,
     757,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   248,    -1,    -1,  1542,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   871,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   211,  1567,
      -1,    -1,   215,    -1,    -1,   282,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   898,    -1,   295,  3210,
      -1,    -1,   235,   236,    -1,    -1,    -1,   909,   910,    -1,
      -1,  2040,    -1,    -1,    -1,   248,   833,  2046,   835,    -1,
     837,    -1,  1610,    -1,    -1,    -1,   843,   844,    -1,  3240,
      -1,  1619,  2061,    -1,  2063,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   279,    -1,    -1,   282,
      -1,    -1,    -1,    -1,   871,    -1,    -1,    -1,    -1,   356,
      -1,    -1,   295,    -1,   297,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   307,    -1,    -1,    -1,    -1,    -1,
      -1,   898,    -1,    -1,   986,   987,    -1,    -1,   990,   991,
      -1,   993,   909,   910,    -1,    -1,   998,    -1,    -1,  2128,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2137,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   356,    -1,    -1,   423,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3465,    -1,    -1,    -1,    -1,    -1,
      -1,   438,   439,   440,   441,   442,   443,    -1,    -1,    -1,
      -1,    -1,   969,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1749,  2191,    -1,    -1,    -1,    -1,    -1,    -1,   986,
     987,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   998,    -1,    -1,    -1,  2214,    -1,    -1,  3519,    -1,
     423,    -1,  1094,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   434,   435,   436,    -1,   438,   439,   440,   441,   442,
     443,    -1,    -1,    -1,    -1,    -1,    -1,  2246,    -1,    -1,
      -1,  2250,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2262,  2263,  2264,  2265,    -1,    -1,    -1,
      -1,    -1,  2271,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2281,  2282,  3465,  2284,    -1,    -1,  1160,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2296,    -1,  2298,
      -1,    -1,    -1,  2302,    -1,    -1,    -1,  1094,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2318,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2328,
      -1,  2330,  2331,    -1,    -1,    -1,    -1,    -1,  3519,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2351,    -1,    -1,    -1,    -1,    -1,  2357,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2365,  2366,  2367,    -1,
      -1,    -1,    -1,  1160,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2388,
    1948,  1949,    -1,    -1,    76,    -1,  1268,    -1,    -1,    -1,
    2399,    -1,    -1,    -1,    -1,    -1,    -1,  1279,    90,    -1,
      -1,    93,    -1,    -1,    -1,    -1,    98,  2416,  2417,    -1,
    2419,   103,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    76,    -1,    -1,  2434,    -1,  2436,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    90,    -1,    -1,    -1,
      -1,    -1,  1324,  1097,    98,  1327,    -1,  1329,  1330,   103,
      -1,    -1,    -1,    -1,    -1,  2464,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1268,    -1,    -1,    -1,    -1,    -1,    -1,  2046,    -1,
      -1,    -1,  1279,    -1,    -1,  2494,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2063,    -1,    -1,    -1,    -1,
      -1,  2510,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1393,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   211,
    1402,    -1,    -1,   215,  1406,    -1,    -1,  1324,  2537,  2538,
    1327,    -1,  1329,  1330,    -1,    -1,    -1,    -1,    -1,  2548,
      -1,    -1,   196,   235,   236,    -1,    -1,    -1,    -1,    -1,
    2559,    -1,    -1,    -1,    -1,    -1,   248,   211,    -1,    -1,
      -1,   215,    -1,    -1,  2573,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2589,   235,   236,    -1,  2593,    -1,    -1,   279,    -1,    -1,
     282,    -1,    -1,    -1,   248,    -1,  1393,  2606,    -1,    -1,
      -1,  2610,    -1,   295,    -1,   297,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2626,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   279,    -1,    -1,   282,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   295,  2651,   297,    -1,    -1,    -1,    -1,  2657,    -1,
      -1,  2660,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2669,    -1,    -1,    -1,   356,    -1,  2675,    -1,    -1,    -1,
    2679,    -1,    -1,    -1,  2683,  2684,    -1,    -1,  2687,  2688,
    2689,  2690,  2691,  2692,  2693,  2694,  2695,  2696,    -1,    -1,
      -1,    -1,  2701,  2702,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2710,   356,    -1,    -1,  1587,  2715,    -1,    -1,    -1,
      -1,    -1,    -1,  2722,    -1,  1512,  2725,    -1,  2727,    -1,
      -1,    -1,    -1,    -1,    -1,  2734,  2735,  2736,  2737,    -1,
      -1,   423,  2741,    -1,    -1,  2744,    -1,    -1,    -1,    -1,
      -1,    -1,   434,   435,   436,    -1,   438,   439,   440,   441,
     442,   443,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   423,
      -1,  1425,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     434,   435,   436,    -1,   438,   439,   440,   441,   442,   443,
    1587,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1452,    -1,
    1597,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1466,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2388,    -1,    -1,    -1,    -1,    -1,  1708,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2847,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2416,  2417,
     202,  2419,    -1,    -1,    -1,    -1,  1510,   209,    -1,   211,
      -1,    -1,    -1,    -1,    -1,    -1,  2434,    -1,  2436,    -1,
      -1,  1525,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1542,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2464,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1701,  1702,  1703,  2916,    -1,    -1,
      -1,  1708,  1709,  1567,    -1,    -1,  1713,  1714,  2927,    -1,
      -1,    -1,    -1,  1720,    -1,    -1,  2494,  1809,    -1,    -1,
      -1,    -1,  1729,    -1,  1731,    -1,    -1,    -1,    -1,    -1,
      -1,    76,  2510,    -1,    -1,    -1,    -1,    -1,  1745,    -1,
    1747,    -1,  2961,    -1,    -1,    90,  1610,    -1,    -1,    -1,
      -1,    -1,    -1,    98,    -1,  1619,  2975,    -1,   103,    -1,
    2538,  2980,    -1,    -1,  2983,    -1,    -1,    -1,    -1,    -1,
    2548,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2559,    -1,    -1,    -1,    90,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    98,    -1,  2573,    -1,  3016,   103,    -1,
      -1,  1893,  1809,    -1,    -1,    -1,    -1,    -1,  1900,    -1,
    1902,    -1,  1904,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2606,    -1,
      -1,    -1,  2610,    -1,    -1,    -1,    -1,    -1,  3057,  3058,
      -1,    -1,    -1,  3062,  3063,    -1,    -1,    -1,    -1,    -1,
    3069,  3070,    -1,    -1,  3073,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   211,    -1,    -1,    -1,
     215,    -1,    -1,    -1,    -1,  1097,    -1,    -1,    -1,    -1,
    1887,    -1,  2660,    -1,    -1,  1749,  1893,    -1,    -1,    -1,
     235,   236,    -1,  1900,    -1,    -1,    -1,  1989,    -1,    -1,
      -1,    -1,    -1,   248,    -1,  2683,   211,    -1,    -1,    -1,
     215,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3147,    -1,
     235,   236,  2710,    -1,   279,    -1,    -1,   282,    -1,    -1,
      -1,    -1,    -1,   248,    -1,    -1,    -1,    -1,    -1,    -1,
     295,    -1,   297,    -1,    -1,  2047,  2734,    -1,    -1,  2051,
      -1,    -1,    -1,  2055,    -1,    -1,  3185,    -1,    -1,    -1,
      -1,    -1,    -1,  2065,   279,    -1,    -1,   282,    -1,    -1,
      -1,    -1,  3201,    -1,    -1,  1992,  3205,    -1,    -1,    -1,
     295,  3210,   297,  2000,    -1,    -1,  2003,  2004,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2101,
    3229,   356,    -1,  3232,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3240,  3241,  3242,  2116,    -1,  3245,    -1,    -1,    -1,
      -1,    -1,    -1,  3252,  3253,    -1,    -1,    -1,    -1,    -1,
    2047,    -1,    -1,    -1,  2051,    -1,    -1,    -1,  2055,    -1,
      -1,   356,    -1,    -1,    -1,    -1,    -1,  3276,  2065,    -1,
      -1,    -1,    -1,  2070,    -1,    -1,    -1,  2159,    -1,  2847,
      -1,    -1,    -1,   378,    -1,    -1,  3295,    -1,   423,    -1,
      -1,    -1,    -1,    -1,  1948,  1949,    -1,    -1,    -1,   434,
     435,   436,    -1,   438,   439,   440,   441,   442,   443,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2116,
      -1,    -1,  3331,  3332,    -1,    -1,    -1,    -1,   423,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   434,
     435,   436,    -1,   438,   439,   440,   441,   442,   443,  3358,
    3359,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2927,
      -1,    -1,  2159,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   728,    84,    -1,    -1,
     732,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    -1,
      -1,    -1,  2046,  2961,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3413,    -1,    -1,    -1,   115,  2063,
     762,    -1,    -1,  1425,    -1,    -1,  2213,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   133,    -1,   135,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1452,    -1,    -1,    -1,   151,    -1,    -1,    -1,    -1,    -1,
     157,    -1,   804,    -1,  1466,    -1,  3465,    -1,   810,    -1,
      -1,  2343,   169,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3482,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   198,    -1,   200,    -1,  3063,    -1,   204,  1510,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3516,    -1,    -1,
    3519,   218,    -1,  1525,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1542,    -1,    -1,    -1,   241,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2341,   252,  2343,    -1,    -1,    -1,
      -1,   903,    -1,    -1,    -1,  1567,   908,  2439,    -1,   911,
      -1,    -1,    -1,    -1,  2446,    -1,  2448,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   933,    -1,    -1,    -1,    -1,    -1,    -1,   295,    -1,
     297,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1610,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1619,    -1,   316,
      -1,  2493,    -1,  2495,  2496,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2504,    -1,    -1,    -1,    -1,    -1,  2510,    -1,
     337,    -1,    -1,    -1,   341,  2517,   343,    -1,    -1,    -1,
      -1,  2438,  3210,    -1,    -1,    -1,  2528,  2529,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2538,  2454,    -1,    -1,
      -1,    -1,    -1,    -1,  2461,  2462,    -1,   374,   375,    -1,
     377,    -1,  3240,    -1,    -1,    -1,    -1,    -1,   385,    -1,
      -1,    -1,   389,   390,    -1,    -1,    -1,   394,    -1,  2571,
    2572,    -1,   399,    -1,    -1,    -1,  2493,    -1,  2495,  2496,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2504,    -1,    -1,
      -1,    -1,    -1,  2510,  1066,    -1,    -1,    -1,  2515,  1071,
    2517,    -1,    -1,    -1,    -1,  1077,    -1,    -1,    -1,    -1,
      -1,  2528,  2529,    -1,  2388,    -1,    -1,  1749,    -1,    -1,
      -1,  2538,    -1,    -1,    -1,  1097,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2416,  2417,    -1,  2419,    -1,    -1,    -1,    -1,
    1122,    -1,    -1,    -1,  2571,  2572,    -1,    -1,    -1,    -1,
    2434,    -1,  2436,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2464,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2721,
    2494,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2510,    -1,    -1,    -1,
    1212,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2667,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2677,    -1,    -1,    -1,  2538,    -1,    -1,  1239,    -1,    -1,
      -1,    -1,    -1,    -1,  2548,    -1,    -1,  3465,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2559,    -1,    -1,    -1,    -1,
      -1,  1263,  1264,    -1,  1266,    -1,    -1,    -1,    -1,  2573,
      -1,    -1,    -1,    -1,  2721,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1284,    -1,    -1,    -1,  1948,  1949,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3519,  2606,    -1,    -1,    -1,  2610,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2860,  2861,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1357,  2660,    -1,  1360,  1361,
    2892,  2893,  2894,  2895,  2896,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2683,
      -1,    -1,    -1,    -1,  2046,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2063,    -1,    -1,    -1,    -1,  2710,    -1,    -1,    -1,
      -1,    -1,    -1,  2860,  2861,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2954,  1425,    -1,    -1,    -1,    -1,    -1,    -1,
    2734,  1433,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2887,    -1,    -1,    -1,    -1,  2892,  2893,  2894,  2895,  2896,
    1452,    -1,    -1,  2900,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1466,    -1,  1468,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1494,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2954,  1510,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1525,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1542,    -1,    -1,  2847,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3086,  3087,    -1,    -1,    -1,    -1,
      -1,    -1,  3094,    -1,    -1,  1567,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3115,  3116,    -1,    -1,    -1,  3120,  3121,
    3122,    -1,    -1,  3125,  3126,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1605,    -1,  1607,    -1,    -1,  1610,    -1,
    1612,    -1,    -1,    -1,    -1,    -1,    -1,  1619,    -1,    -1,
      -1,    -1,    -1,  2927,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3087,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3096,
      -1,    -1,    -1,    -1,  3186,  1657,    -1,  2961,    -1,    -1,
      -1,    -1,  3109,    -1,    -1,    -1,    -1,    -1,  3115,  3116,
      -1,    -1,    -1,  3120,  3121,    -1,    -1,    -1,  3125,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1688,  1689,    -1,    -1,
      -1,    -1,    -1,    -1,  1696,    -1,    -1,  1699,  1700,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1711,
    1712,    -1,    -1,    -1,    -1,    -1,    -1,  1719,    -1,    -1,
      -1,  1723,  1724,  1725,  1726,    -1,  2388,    -1,    -1,    -1,
      -1,  1733,  1734,    -1,    -1,    -1,    -1,    -1,    -1,  3186,
      -1,    -1,    -1,    -1,    -1,    -1,  3278,  1749,  1750,    -1,
      -1,    -1,  1754,    -1,  2416,  2417,  1758,  2419,    -1,  3063,
    1762,    -1,    -1,  1765,  1766,  1767,  1768,  1769,  1770,  1771,
    1772,  1773,  2434,  1775,  2436,    -1,    -1,    -1,  1780,    -1,
      -1,    -1,  1784,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3328,    -1,    -1,    -1,
      -1,    -1,  2464,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3278,  2494,    -1,    -1,    -1,    -1,    -1,  1840,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2510,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2538,    -1,    -1,    -1,
      -1,  3328,    -1,    -1,    -1,    -1,  2548,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2559,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3210,    -1,    -1,    -1,
      -1,  2573,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1930,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3240,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2606,    -1,  1948,  1949,  2610,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2660,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3463,  3464,    -1,    -1,
      -1,  2683,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2040,    -1,
      -1,    -1,    -1,    -1,  2046,    -1,    -1,    -1,  2710,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2061,
      -1,  2063,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2734,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   728,    -1,    -1,    -1,   732,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2128,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2137,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   762,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3465,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2847,    -1,    -1,   804,  2191,
      -1,    -1,    -1,    -1,   810,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2214,    -1,    -1,  3519,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2246,    -1,    -1,    -1,  2250,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2262,  2263,  2264,  2265,    -1,  2927,    -1,    -1,    -1,  2271,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2281,
    2282,    -1,  2284,    -1,    -1,    -1,    -1,   903,    -1,    -1,
      -1,    -1,    -1,    -1,  2296,    -1,  2298,    -1,    -1,  2961,
    2302,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2318,   933,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2328,    -1,  2330,  2331,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2351,
      -1,    -1,    -1,    -1,    -1,  2357,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2365,  2366,  2367,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2388,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2399,    -1,    -1,
      -1,  3063,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2416,  2417,    -1,  2419,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2434,    -1,  2436,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1066,    -1,    -1,    -1,    -1,  1071,    -1,    -1,    -1,    -1,
      -1,  1077,  2464,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1097,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2494,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1122,    -1,  2510,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2538,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2548,    -1,  3210,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2559,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2573,    -1,    -1,    -1,    -1,    -1,    -1,  3240,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2589,    -1,    -1,
      -1,  2593,    -1,    -1,    -1,    -1,  1212,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2606,    -1,    -1,    -1,  2610,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1239,  2626,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1263,  1264,  2651,
    1266,    -1,    -1,    -1,    -1,  2657,    -1,    -1,  2660,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2669,  1284,    -1,
      -1,    -1,    -1,  2675,    -1,    -1,    -1,  2679,    -1,    -1,
      -1,  2683,  2684,    -1,    -1,  2687,  2688,  2689,  2690,  2691,
    2692,  2693,  2694,  2695,  2696,    -1,    -1,    -1,    -1,  2701,
    2702,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2710,    -1,
      -1,    -1,    -1,  2715,    -1,    -1,    -1,    -1,    -1,    -1,
    2722,    -1,    -1,  2725,    -1,  2727,    -1,    -1,    -1,    -1,
      -1,    -1,  2734,  2735,  2736,  2737,    -1,    -1,    -1,  2741,
      -1,  1357,  2744,    -1,  1360,  1361,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3465,    -1,    -1,    -1,    -1,    -1,  1425,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1452,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2847,    -1,    -1,    -1,    -1,
    1466,    -1,    -1,    -1,    -1,    -1,    -1,  3519,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1510,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1525,
      -1,    -1,    -1,    -1,  2916,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2927,  1542,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1567,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2961,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2975,    -1,    -1,    -1,    -1,  2980,    -1,
      -1,  2983,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1605,
      -1,  1607,    -1,    -1,  1610,    -1,  1612,    -1,    -1,    -1,
      -1,    -1,    -1,  1619,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3016,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   903,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1657,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3057,  3058,    -1,    -1,    -1,
    3062,  3063,    -1,   933,    -1,    -1,    -1,  3069,  3070,    -1,
      -1,  3073,  1688,  1689,    -1,    -1,    -1,    -1,    -1,    -1,
    1696,    -1,    -1,  1699,  1700,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1711,  1712,    -1,    -1,    -1,
      -1,    -1,    -1,  1719,    -1,    -1,    -1,  1723,  1724,  1725,
    1726,    -1,    -1,    -1,    -1,    -1,    -1,  1733,  1734,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1749,  1750,    -1,    -1,    -1,  1754,    -1,
      -1,    -1,  1758,    -1,    -1,  3147,  1762,    -1,    -1,  1765,
    1766,  1767,  1768,  1769,  1770,  1771,  1772,  1773,    -1,  1775,
      -1,    -1,    -1,    -1,  1780,    -1,    -1,    -1,  1784,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3185,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1066,    -1,    -1,  3201,
      -1,    -1,    -1,  3205,    -1,    -1,    -1,    -1,  3210,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1840,    -1,    -1,  3229,    -1,    -1,
    3232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3240,  3241,
    3242,    -1,    -1,  3245,    -1,    -1,    -1,    -1,    -1,    -1,
    3252,  3253,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3276,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3295,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1930,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3331,
    3332,    -1,  1948,  1949,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1212,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3358,  3359,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1239,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1263,  1264,    -1,  1266,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3413,    -1,    -1,  1284,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2040,    -1,    -1,    -1,    -1,    -1,
    2046,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2061,    -1,  2063,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3465,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3482,    -1,    -1,    -1,    -1,    -1,    -1,  1357,    -1,    -1,
    1360,  1361,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2128,    -1,  3516,    -1,    -1,  3519,    -1,    -1,
      -1,  2137,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2191,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2214,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2246,    -1,    -1,    -1,  2250,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2262,  2263,  2264,  2265,
      -1,    -1,    -1,    -1,    -1,  2271,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2281,  2282,    -1,  2284,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2296,    -1,  2298,    -1,    -1,    -1,  2302,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2318,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2328,    -1,  2330,  2331,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1280,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2351,    -1,    -1,    -1,    -1,
      -1,  2357,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2365,
    2366,  2367,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2388,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2399,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1347,    -1,    -1,    -1,    -1,    -1,
    2416,  2417,    -1,  2419,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2434,    -1,
    2436,    -1,    -1,    -1,    -1,    -1,  1696,    -1,    -1,    -1,
    1700,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2464,  1719,
      -1,    -1,    -1,  1723,    -1,    -1,  1726,    -1,    -1,    -1,
      -1,    -1,    -1,  1733,  1734,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2494,    -1,
    1750,    -1,    -1,    -1,  1754,    -1,    -1,    -1,  1758,    -1,
      -1,    -1,  1762,    -1,  2510,  1765,  1766,  1767,  1768,  1769,
    1770,  1771,  1772,  1773,    -1,  1775,    -1,    -1,    -1,    -1,
    1780,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2538,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2548,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2559,    -1,    -1,    -1,    -1,    -1,    -1,
    1503,    -1,    -1,    -1,    -1,    -1,    -1,  2573,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1840,    -1,    -1,  2589,    -1,    -1,    -1,  2593,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2606,    -1,    -1,    -1,  2610,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2626,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2651,    -1,    -1,    -1,    -1,
      -1,  2657,    -1,    -1,  2660,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2669,    -1,    -1,    -1,    -1,    -1,  2675,
    1930,    -1,    -1,  2679,    -1,    -1,    -1,  2683,  2684,    -1,
      -1,  2687,  2688,  2689,  2690,  2691,  2692,  2693,  2694,  2695,
    2696,    -1,    -1,    -1,    -1,  2701,  2702,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2710,    -1,    -1,    -1,    -1,  2715,
      -1,    -1,    -1,    -1,    -1,    -1,  2722,    -1,    -1,  2725,
      -1,  2727,    -1,    -1,    -1,    -1,    -1,    -1,  2734,  2735,
    2736,  2737,    -1,    -1,    -1,  2741,    -1,    -1,  2744,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1694,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1718,    -1,    -1,    -1,    -1,
    2040,  1724,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1737,  1738,    -1,    -1,  1741,    -1,
      -1,  2061,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1778,    -1,    -1,    -1,    -1,
      -1,  2847,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2137,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1849,    -1,    -1,    -1,
    2916,    -1,    -1,  1856,    -1,  1858,    -1,    -1,    -1,    -1,
      -1,  2927,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2191,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2214,  2961,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2975,
      -1,    -1,    -1,    -1,  2980,    -1,    -1,  2983,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2262,    -1,  2264,  2265,    -1,    -1,    -1,    -1,
    3016,  2271,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2296,    -1,  2298,    -1,
      -1,    -1,  2302,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3057,  3058,    -1,    -1,    -1,  3062,  3063,    -1,    -1,
      -1,    -1,    -1,  3069,  3070,    -1,    -1,  3073,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2351,    -1,    -1,    -1,    -1,    -1,  2357,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2365,  2366,  2367,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2399,
      -1,  3147,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3185,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3201,    -1,    -1,    -1,  3205,
      -1,    -1,    -1,    -1,  3210,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3229,    -1,    -1,  3232,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3240,  3241,  3242,    -1,    -1,  3245,
      -1,    -1,    -1,    -1,    -1,    -1,  3252,  3253,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2208,    -1,    -1,    -1,    -1,
    3276,    -1,    -1,    -1,  2217,    -1,  2219,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3295,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2241,    -1,
      -1,  2244,    -1,  2246,  2247,    -1,    -1,  2250,    -1,    -1,
      -1,  2254,    -1,    -1,    -1,    -1,    -1,    -1,  2261,    -1,
      -1,    -1,    -1,  2266,    -1,  3331,  3332,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2277,    -1,    -1,    -1,  2281,  2282,
    2283,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2294,  3358,  3359,    -1,    -1,    -1,    -1,  2301,    -1,
    2303,  2304,  2305,  2306,  2307,  2308,  2309,  2310,  2311,  2312,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2651,    -1,    -1,    -1,    -1,    -1,  2657,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3413,    -1,  2669,
      -1,    -1,    -1,    -1,    -1,  2675,    -1,    -1,    -1,  2679,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2701,  2702,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3465,
      -1,    -1,  2722,  2406,    -1,  2725,    -1,  2727,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2735,  3482,    -1,    -1,    -1,
      -1,  2741,    -1,    -1,  2744,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3516,    -1,    -1,  3519,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2492,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2511,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     5,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    19,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    28,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    39,    40,
      -1,    -1,    -1,    -1,    45,    -1,    47,    48,    -1,    -1,
      -1,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    -1,    -1,    -1,    -1,    -1,
    2603,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   117,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2656,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2682,
      -1,  2684,    -1,    -1,  2687,  2688,  2689,  2690,  2691,  2692,
    2693,  2694,  2695,  2696,    -1,  2698,  3016,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   190,
      -1,    -1,    -1,    -1,    -1,  2718,    -1,    -1,    -1,    -1,
    2723,  2724,    -1,    -1,    -1,    -1,    -1,    -1,   209,    -1,
      -1,    -1,    -1,  2736,  2737,  2738,    -1,  2740,    -1,    -1,
    2743,    -1,  3062,    -1,    -1,    -1,    -1,    -1,   229,  3069,
    3070,    -1,    -1,  3073,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   260,
      -1,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   284,    -1,    -1,    -1,    -1,    -1,    -1,
    2813,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3147,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   345,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3201,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     381,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   393,  2916,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   405,  3245,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3253,    -1,   416,    -1,    -1,    -1,    -1,
     421,   422,    -1,   424,    -1,   426,    -1,    -1,    -1,   430,
     431,    -1,   433,   434,    -1,    -1,  3276,   438,   439,   440,
     441,   442,    -1,    -1,   445,   446,   447,   448,    -1,   450,
     451,   452,    -1,   454,   455,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3013,    -1,  3332,    -1,  3017,    -1,    -1,    -1,    -1,  3022,
    3023,    -1,  3025,    -1,    -1,  3028,    -1,     5,    -1,  3032,
    3033,  3034,  3035,  3036,  3037,  3038,  3039,  3040,  3041,  3042,
    3043,    19,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      28,    -1,    -1,  3056,  3057,  3058,  3059,    -1,  3061,    -1,
      -1,    39,    40,  3066,  3067,  3068,    -1,    -1,  3071,    47,
      48,  3074,    -1,    -1,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    19,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    28,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   117,
      -1,    -1,    39,    40,    -1,    -1,  3149,    -1,    -1,    -1,
      47,    48,    -1,    -1,    -1,    52,    53,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    70,    71,    72,    73,    74,    75,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   190,    -1,    -1,    -1,    -1,    -1,    -1,  3222,
     117,    -1,    -1,    -1,    -1,    -1,  3229,    -1,    -1,  3232,
      -1,   209,  3235,  3236,  3237,    -1,    -1,    -1,  3241,  3242,
    3243,  3244,    -1,  3246,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   229,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   260,    -1,    -1,   263,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   190,    -1,    -1,  3299,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   284,    -1,    -1,    -1,
      -1,    -1,   209,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   229,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3344,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3357,  3358,  3359,  3360,    -1,    -1,
    3363,  3364,  3365,   260,  3367,    -1,   263,   345,    -1,    -1,
      -1,    -1,  3375,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   284,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   381,    -1,    -1,    -1,    -1,  3411,    -1,
      -1,    -1,    -1,    -1,    -1,   393,    -1,    -1,    -1,    -1,
      -1,  3424,  3425,    -1,    -1,    -1,    -1,   405,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   416,    -1,
      -1,    -1,    -1,   421,   422,    -1,   424,    -1,   345,    -1,
      -1,    -1,   430,   431,    -1,   433,   434,    -1,    -1,    -1,
     438,   439,   440,   441,   442,    -1,    -1,   445,   446,   447,
      -1,    -1,    -1,   451,    -1,    -1,    -1,   455,    -1,    -1,
      -1,    -1,    -1,    -1,   381,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   393,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   405,    -1,
      -1,    -1,     5,    -1,    -1,    -1,    -1,    -1,    -1,   416,
      -1,    -1,    -1,    -1,   421,   422,    19,   424,    -1,    -1,
      -1,    -1,    -1,   430,   431,    28,   433,   434,    -1,    -1,
      -1,   438,   439,   440,   441,   442,    39,    40,   445,   446,
     447,   448,    -1,    -1,    47,    48,    -1,    -1,   455,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    -1,     5,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    19,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    28,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    39,    40,
      -1,    -1,    -1,    -1,   117,    -1,    47,    48,    -1,    -1,
      -1,    52,    53,    54,    55,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   117,   190,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   209,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   229,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   260,    -1,   190,
     263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   209,    -1,
      -1,   284,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   229,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   260,
      -1,    -1,   263,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   345,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   284,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   381,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     393,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   405,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   416,   345,    -1,    -1,    -1,   421,   422,
      -1,   424,    -1,    -1,    -1,    -1,    -1,   430,   431,    -1,
     433,   434,    -1,    -1,    -1,   438,   439,   440,   441,   442,
      -1,    -1,   445,   446,   447,   448,    -1,    -1,    -1,    -1,
     381,    -1,   455,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   393,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   405,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   416,    -1,    -1,    -1,    -1,
     421,   422,    -1,   424,    -1,    -1,    -1,    -1,    -1,   430,
     431,    -1,   433,   434,    -1,    -1,    -1,   438,   439,   440,
     441,   442,    -1,    -1,   445,   446,   447,     5,     6,     7,
       8,     9,    10,    11,   455,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    -1,    35,    36,    37,
      38,    39,    40,    -1,    42,    43,    44,    -1,    46,    47,
      48,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,    -1,
     108,   109,   110,    -1,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,   157,
     158,   159,   160,    -1,   162,   163,   164,   165,   166,   167,
     168,   169,   170,   171,   172,   173,   174,   175,   176,   177,
     178,   179,   180,   181,   182,   183,   184,    -1,   186,   187,
     188,   189,   190,   191,   192,   193,   194,   195,   196,   197,
     198,    -1,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   219,   220,   221,   222,   223,   224,   225,   226,   227,
     228,   229,   230,   231,   232,   233,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,    -1,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,    -1,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,    -1,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   381,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,   397,
     398,   399,   400,   401,   402,    -1,    -1,   405,   406,   407,
     408,    -1,   410,   411,   412,   413,   414,   415,   416,   417,
       6,     7,     8,   421,    10,    11,   424,    13,    14,    15,
      -1,    -1,    -1,    19,    20,    -1,    22,    23,    24,    25,
      26,    27,    -1,    29,    30,    31,    -1,    -1,    -1,    35,
      36,    37,    38,   451,    40,    -1,    42,    43,    44,    -1,
      46,    47,    48,    49,    -1,    -1,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    99,    -1,    -1,    -1,   103,   104,   105,
     106,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,   125,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     136,    -1,    -1,    -1,    -1,    -1,   142,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   154,   155,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   183,    -1,    -1,
     186,    -1,    -1,    -1,   190,    -1,    -1,    -1,    -1,   195,
      -1,   197,    -1,    -1,    -1,    -1,    -1,   203,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   211,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   223,   224,    -1,
      -1,    -1,    -1,    -1,   230,    -1,   232,    -1,    -1,   235,
     236,    -1,   238,    -1,    -1,    -1,    -1,    -1,    -1,   245,
     246,    -1,   248,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     266,   267,   268,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   277,    -1,    -1,    -1,    -1,   282,    -1,    -1,   285,
     286,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   299,   300,   301,   302,    -1,    -1,    -1,
      -1,    -1,   308,   309,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   320,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     336,    -1,    -1,   339,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   353,    -1,    -1,
     356,    -1,   358,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   368,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   379,   380,    -1,    -1,    -1,   384,    -1,
     386,    -1,    -1,    -1,    -1,    -1,    -1,   393,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   405,
      -1,   407,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   421,    -1,    -1,   424,     6,
       7,     8,    -1,    10,    11,    -1,    13,    14,    15,    -1,
      -1,    -1,    19,    20,    -1,    22,    23,    24,    25,    26,
      27,    -1,    29,    30,    31,    -1,   452,    -1,    35,    36,
      37,    38,    -1,    40,    -1,    42,    43,    44,    -1,    46,
      47,    48,    49,    -1,    -1,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    99,    -1,    -1,    -1,   103,   104,   105,   106,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,   125,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   136,
      -1,    -1,    -1,    -1,    -1,   142,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   154,   155,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   183,    -1,    -1,   186,
      -1,    -1,    -1,   190,    -1,    -1,    -1,    -1,   195,    -1,
     197,    -1,    -1,    -1,    -1,    -1,   203,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   211,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   223,   224,    -1,    -1,
      -1,    -1,    -1,   230,    -1,   232,    -1,    -1,   235,   236,
      -1,   238,    -1,    -1,    -1,    -1,    -1,    -1,   245,   246,
      -1,   248,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   266,
     267,   268,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     277,    -1,    -1,    -1,    -1,   282,    -1,    -1,   285,   286,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   299,   300,   301,   302,    -1,    -1,    -1,    -1,
      -1,   308,   309,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   320,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   336,
      -1,    -1,   339,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   353,    -1,    -1,   356,
      -1,   358,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   368,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   379,   380,    -1,    -1,    -1,   384,    -1,   386,
      -1,    -1,    -1,    -1,    -1,    -1,   393,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   405,    -1,
     407,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   421,     3,    -1,   424,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      -1,    29,    30,    31,    32,   452,    -1,    35,    36,    37,
      38,    -1,    40,    -1,    42,    43,    44,    -1,    46,    47,
      48,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    87,
      88,    89,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    99,    -1,    -1,   102,   103,   104,   105,   106,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     118,    -1,    -1,   121,    -1,   123,   124,   125,    -1,    -1,
     128,   129,    -1,    -1,    -1,    -1,    -1,    -1,   136,   137,
     138,    -1,    -1,    -1,   142,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   151,    -1,   153,   154,   155,   156,    -1,
      -1,    -1,    -1,    -1,   162,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   171,    -1,    -1,    -1,    -1,    -1,   177,
      -1,    -1,    -1,    -1,   182,   183,   184,    -1,   186,    -1,
     188,    -1,   190,    -1,    -1,    -1,    -1,   195,    -1,   197,
      -1,   199,    -1,   201,    -1,   203,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   211,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   223,   224,    -1,    -1,   227,
      -1,    -1,   230,    -1,   232,    -1,    -1,   235,   236,    -1,
     238,    -1,    -1,    -1,    -1,    -1,    -1,   245,   246,    -1,
     248,    -1,   250,   251,    -1,    -1,    -1,    -1,   256,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   264,    -1,   266,   267,
     268,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   277,
      -1,    -1,    -1,   281,   282,    -1,    -1,   285,   286,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   299,   300,   301,   302,    -1,    -1,    -1,    -1,    -1,
     308,   309,    -1,   311,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   320,   321,    -1,    -1,   324,    -1,   326,    -1,
      -1,    -1,   330,    -1,    -1,    -1,    -1,   335,   336,    -1,
     338,   339,    -1,    -1,   342,    -1,    -1,    -1,    -1,   347,
      -1,    -1,    -1,    -1,   352,   353,    -1,   355,   356,    -1,
     358,    -1,    -1,   361,    -1,    -1,    -1,    -1,    -1,    -1,
     368,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   379,   380,    -1,    -1,    -1,   384,    -1,   386,    -1,
     388,    -1,   390,    -1,    -1,   393,    -1,    -1,   396,    -1,
     398,    -1,    -1,   401,    -1,    -1,   404,   405,    -1,   407,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   421,    -1,    -1,   424,    -1,    -1,    -1,
      -1,    -1,    -1,     5,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,    -1,    20,   447,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    -1,    35,    36,    37,    38,    39,    40,    -1,
      42,    43,    44,    -1,    46,    47,    48,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    -1,    -1,    -1,    -1,
      92,    -1,    -1,    95,    96,    -1,    98,    99,   100,   101,
     102,   103,   104,   105,   106,   107,    -1,   109,   110,    -1,
     112,   113,   114,   115,   116,   117,   118,   119,    -1,   121,
     122,   123,   124,   125,    -1,    -1,   128,   129,   130,   131,
     132,    -1,   134,   135,   136,   137,    -1,   139,   140,   141,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,   155,   156,    -1,   158,    -1,   160,    -1,
     162,   163,   164,    -1,   166,   167,    -1,   169,   170,   171,
     172,    -1,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,   183,   184,    -1,   186,   187,   188,   189,   190,    -1,
     192,    -1,   194,   195,    -1,   197,   198,    -1,   200,    -1,
     202,   203,    -1,   205,    -1,   207,   208,   209,   210,   211,
     212,   213,   214,    -1,   216,   217,   218,   219,   220,   221,
      -1,   223,   224,    -1,   226,   227,   228,   229,   230,    -1,
     232,    -1,    -1,   235,   236,   237,   238,   239,   240,   241,
     242,   243,    -1,   245,   246,   247,   248,    -1,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   287,   288,    -1,    -1,   291,
     292,    -1,    -1,   295,   296,    -1,    -1,   299,   300,   301,
     302,   303,   304,   305,   306,    -1,   308,   309,   310,   311,
     312,    -1,   314,   315,   316,   317,   318,   319,   320,   321,
     322,    -1,   324,   325,   326,   327,   328,   329,   330,   331,
     332,    -1,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,   345,    -1,    -1,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,   358,    -1,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,   374,   375,   376,   377,    -1,   379,   380,    -1,
      -1,   383,   384,   385,   386,   387,   388,   389,   390,   391,
     392,    -1,   394,   395,   396,   397,   398,   399,    -1,   401,
     402,    -1,   404,   405,   406,   407,   408,    -1,    -1,    -1,
     412,   413,   414,   415,   416,   417,    -1,    -1,    -1,   421,
     422,   423,   424,   425,    -1,    -1,   428,   429,   430,   431,
     432,   433,    -1,    -1,    -1,    -1,   438,   439,   440,    -1,
      -1,    -1,    -1,    -1,    -1,   447,   448,     5,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    -1,    35,    36,    37,
      38,    39,    40,    -1,    42,    43,    44,    -1,    46,    47,
      48,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,    -1,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
      -1,   109,   110,    -1,   112,   113,   114,   115,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,   125,    -1,    -1,
     128,   129,   130,   131,   132,    -1,   134,   135,   136,   137,
      -1,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,
      -1,   169,   170,   171,   172,    -1,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,   183,   184,    -1,   186,   187,
     188,   189,   190,    -1,   192,    -1,   194,   195,    -1,   197,
     198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,
     208,   209,   210,   211,   212,   213,   214,    -1,   216,   217,
     218,   219,   220,   221,    -1,   223,   224,    -1,   226,   227,
     228,   229,   230,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,    -1,   245,   246,   247,
     248,    -1,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,    -1,    -1,   291,   292,    -1,    -1,   295,   296,    -1,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,    -1,
     308,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,    -1,    -1,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,   374,   375,   376,   377,
      -1,   379,   380,    -1,    -1,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,    -1,   394,   395,   396,   397,
     398,   399,    -1,   401,   402,    -1,   404,   405,   406,   407,
     408,    -1,    -1,    -1,   412,   413,   414,   415,   416,   417,
      -1,    -1,    -1,   421,   422,   423,   424,   425,    -1,    -1,
     428,   429,   430,   431,   432,   433,    -1,    -1,    -1,    -1,
     438,   439,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   447,
     448,     5,     6,     7,     8,     9,    10,    11,    -1,    13,
      14,    15,    16,    -1,    18,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      -1,    35,    36,    37,    38,    39,    40,    -1,    42,    43,
      44,    -1,    46,    47,    48,    49,    50,    51,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    -1,    98,    99,   100,   101,   102,   103,
     104,   105,   106,   107,    -1,   109,   110,    -1,   112,   113,
      -1,    -1,   116,   117,   118,   119,    -1,   121,   122,   123,
     124,    -1,    -1,    -1,   128,   129,   130,   131,   132,    -1,
     134,   135,    -1,   137,    -1,   139,   140,   141,   142,   143,
      -1,    -1,    -1,    -1,    -1,   149,   150,   151,   152,   153,
     154,   155,   156,    -1,   158,    -1,   160,    -1,   162,   163,
     164,    -1,   166,    -1,    -1,   169,   170,   171,   172,    -1,
     174,   175,   176,    -1,   178,    -1,   180,   181,   182,    -1,
     184,    -1,    -1,    -1,   188,   189,   190,    -1,   192,    -1,
     194,   195,    -1,   197,   198,    -1,   200,    -1,   202,    -1,
      -1,   205,    -1,   207,   208,   209,   210,   211,   212,   213,
     214,   215,   216,   217,   218,   219,   220,   221,    -1,   223,
     224,    -1,   226,   227,   228,   229,   230,    -1,   232,    -1,
      -1,   235,   236,   237,   238,   239,   240,   241,   242,   243,
      -1,    -1,   246,   247,   248,    -1,   250,   251,   252,    -1,
      -1,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,   267,   268,    -1,   270,   271,   272,   273,
     274,   275,   276,    -1,   278,    -1,   280,   281,   282,   283,
      -1,    -1,   286,   287,   288,    -1,    -1,   291,    -1,    -1,
      -1,   295,   296,    -1,    -1,   299,   300,   301,    -1,   303,
     304,   305,   306,    -1,    -1,    -1,   310,   311,   312,    -1,
     314,   315,   316,   317,   318,   319,   320,   321,   322,    -1,
     324,   325,   326,   327,   328,   329,   330,   331,   332,    -1,
     334,   335,   336,   337,   338,    -1,   340,   341,   342,   343,
     344,   345,    -1,    -1,   348,   349,   350,    -1,   352,   353,
     354,   355,   356,   357,   358,    -1,   360,   361,   362,   363,
     364,   365,   366,   367,    -1,   369,    -1,   371,   372,    -1,
     374,   375,   376,   377,    -1,   379,   380,    -1,    -1,   383,
      -1,   385,    -1,    -1,   388,   389,   390,   391,   392,    -1,
      -1,   395,   396,   397,   398,    -1,    -1,   401,   402,    -1,
      -1,   405,   406,   407,   408,    -1,    -1,    -1,   412,   413,
     414,   415,   416,   417,    -1,    -1,    -1,   421,    -1,    -1,
     424,    -1,     6,     7,     8,     9,    10,    11,    -1,    13,
      14,    15,    16,    -1,    18,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,   448,    29,    30,    31,    32,    -1,
      -1,    35,    36,    37,    38,    -1,    -1,    -1,    42,    43,
      44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    -1,    98,    -1,   100,   101,   102,    -1,
     104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,   113,
      -1,    -1,   116,   117,   118,   119,    -1,   121,   122,   123,
     124,   125,    -1,    -1,   128,   129,   130,   131,   132,    -1,
     134,   135,   136,   137,    -1,   139,   140,   141,    -1,   143,
      -1,    -1,    -1,    -1,    -1,   149,   150,   151,   152,   153,
     154,   155,   156,    -1,   158,    -1,   160,    -1,   162,   163,
     164,    -1,   166,    -1,    -1,   169,   170,   171,   172,    -1,
     174,   175,   176,    -1,   178,    -1,   180,   181,   182,   183,
     184,    -1,   186,    -1,   188,   189,   190,    -1,   192,    -1,
     194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,   203,
      -1,   205,    -1,   207,   208,   209,   210,    -1,   212,   213,
     214,    -1,   216,   217,   218,   219,   220,   221,    -1,    -1,
     224,    -1,   226,   227,   228,    -1,   230,    -1,   232,    -1,
      -1,    -1,    -1,   237,    -1,   239,   240,   241,   242,   243,
      -1,   245,    -1,   247,    -1,    -1,   250,   251,   252,    -1,
      -1,   255,   256,   257,   258,   259,   260,   261,   262,   263,
     264,   265,   266,    -1,   268,    -1,   270,   271,   272,   273,
     274,   275,   276,   277,   278,    -1,   280,   281,    -1,   283,
      -1,   285,   286,   287,   288,    -1,    -1,   291,    -1,    -1,
      -1,   295,   296,    -1,    -1,   299,    -1,    -1,   302,   303,
     304,   305,   306,    -1,   308,   309,   310,   311,   312,    -1,
     314,   315,   316,   317,   318,   319,   320,   321,   322,    -1,
     324,   325,   326,   327,   328,   329,   330,   331,   332,    -1,
     334,   335,    -1,   337,   338,   339,   340,   341,   342,   343,
     344,   345,    -1,    -1,   348,   349,   350,    -1,   352,   353,
     354,   355,    -1,   357,   358,    -1,   360,   361,   362,   363,
     364,   365,   366,   367,   368,   369,    -1,   371,   372,    -1,
     374,   375,   376,   377,    -1,   379,   380,    -1,    -1,   383,
     384,   385,   386,    -1,   388,   389,   390,   391,   392,    -1,
      -1,   395,   396,   397,   398,    -1,   400,   401,   402,    -1,
     404,   405,   406,    -1,   408,    -1,    -1,    -1,   412,   413,
     414,   415,   416,   417,    -1,    -1,    -1,   421,    -1,    -1,
     424,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     5,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,   445,    18,    -1,    20,   449,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    -1,    35,
      36,    37,    38,    39,    40,    -1,    42,    43,    44,    -1,
      46,    47,    48,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,
      96,    -1,    98,    99,   100,   101,   102,   103,   104,   105,
     106,   107,   108,   109,   110,    -1,   112,   113,   114,   115,
     116,   117,   118,   119,    -1,   121,   122,   123,   124,   125,
      -1,    -1,   128,   129,   130,   131,   132,    -1,   134,   135,
     136,   137,    -1,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,    -1,    -1,   169,   170,   171,   172,    -1,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,   183,   184,    -1,
     186,   187,   188,   189,   190,    -1,   192,    -1,   194,   195,
     196,   197,   198,    -1,   200,    -1,   202,   203,    -1,   205,
      -1,   207,   208,   209,   210,   211,   212,   213,   214,    -1,
     216,   217,   218,   219,   220,   221,    -1,   223,   224,    -1,
     226,   227,   228,   229,   230,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,    -1,    -1,   291,   292,    -1,    -1,   295,
     296,    -1,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,    -1,   308,   309,   310,   311,   312,    -1,   314,   315,
     316,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,   344,   345,
      -1,    -1,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,   358,    -1,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,    -1,   371,   372,    -1,   374,   375,
     376,   377,    -1,   379,   380,    -1,   382,   383,   384,   385,
     386,   387,   388,   389,   390,   391,   392,    -1,   394,   395,
     396,   397,   398,   399,    -1,   401,   402,    -1,   404,   405,
     406,   407,   408,    -1,    -1,    -1,   412,   413,   414,   415,
     416,   417,    -1,    -1,    -1,   421,   422,   423,   424,   425,
      -1,    -1,   428,   429,   430,   431,   432,   433,    -1,    -1,
      -1,    -1,   438,   439,     5,     6,     7,     8,     9,    10,
      11,   447,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    -1,    35,    36,    37,    38,    39,    40,
      -1,    42,    43,    44,    -1,    46,    47,    48,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    92,    -1,    -1,    95,    96,    -1,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,    -1,   109,   110,
      -1,   112,   113,   114,   115,   116,   117,   118,   119,    -1,
     121,   122,   123,   124,   125,    -1,    -1,   128,   129,   130,
     131,   132,    -1,   134,   135,   136,   137,    -1,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,   170,
     171,   172,    -1,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,   183,   184,    -1,   186,   187,   188,   189,   190,
      -1,   192,    -1,   194,   195,    -1,   197,   198,    -1,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,   209,   210,
     211,   212,   213,   214,    -1,   216,   217,   218,   219,   220,
     221,    -1,   223,   224,    -1,   226,   227,   228,   229,   230,
      -1,   232,    -1,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,    -1,   245,   246,   247,   248,    -1,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,    -1,    -1,
     291,   292,    -1,    -1,   295,   296,    -1,    -1,   299,   300,
     301,   302,   303,   304,   305,   306,    -1,   308,   309,   310,
     311,   312,    -1,   314,   315,   316,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,   344,   345,    -1,    -1,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,   358,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,    -1,
     371,   372,    -1,   374,   375,   376,   377,    -1,   379,   380,
      -1,    -1,   383,   384,   385,   386,   387,   388,   389,   390,
     391,   392,    -1,   394,   395,   396,   397,   398,   399,    -1,
     401,   402,    -1,   404,   405,   406,   407,   408,    -1,    -1,
      -1,   412,   413,   414,   415,   416,   417,    -1,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,   428,   429,   430,
     431,   432,   433,    -1,    -1,    -1,    -1,   438,   439,   440,
      -1,    -1,    -1,    -1,    -1,    -1,   447,     5,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    -1,    35,    36,    37,
      38,    39,    40,    -1,    42,    43,    44,    -1,    46,    47,
      48,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,    -1,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
      -1,   109,   110,    -1,   112,   113,   114,   115,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,   125,    -1,    -1,
     128,   129,   130,   131,   132,    -1,   134,   135,   136,   137,
      -1,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,   157,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,
      -1,   169,   170,   171,   172,    -1,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,   183,   184,    -1,   186,   187,
     188,   189,   190,    -1,   192,    -1,   194,   195,    -1,   197,
     198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,
     208,   209,   210,   211,   212,   213,   214,    -1,   216,   217,
     218,   219,   220,   221,    -1,   223,   224,    -1,   226,   227,
     228,   229,   230,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,    -1,   245,   246,   247,
     248,    -1,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,    -1,    -1,   291,   292,    -1,    -1,   295,   296,    -1,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,    -1,
     308,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,    -1,    -1,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,   374,   375,   376,   377,
      -1,   379,   380,    -1,    -1,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,    -1,   394,   395,   396,   397,
     398,   399,    -1,   401,   402,    -1,   404,   405,   406,   407,
     408,    -1,    -1,    -1,   412,   413,   414,   415,   416,   417,
      -1,    -1,    -1,   421,   422,   423,   424,   425,    -1,    -1,
     428,   429,   430,   431,   432,   433,    -1,    -1,    -1,    -1,
     438,   439,     5,     6,     7,     8,     9,    10,    11,   447,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    -1,    35,    36,    37,    38,    39,    40,    -1,    42,
      43,    44,    -1,    46,    47,    48,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,
      -1,    -1,    95,    96,    -1,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,    -1,   112,
     113,   114,   115,   116,   117,   118,   119,    -1,   121,   122,
     123,   124,   125,    -1,    -1,   128,   129,   130,   131,   132,
      -1,   134,   135,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,    -1,   162,
     163,   164,    -1,   166,    -1,    -1,   169,   170,   171,   172,
      -1,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
     183,   184,    -1,   186,   187,   188,   189,   190,    -1,   192,
      -1,   194,   195,    -1,   197,   198,    -1,   200,    -1,   202,
     203,    -1,   205,    -1,   207,   208,   209,   210,   211,   212,
     213,   214,    -1,   216,   217,   218,   219,   220,   221,    -1,
     223,   224,    -1,   226,   227,   228,   229,   230,    -1,   232,
      -1,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,    -1,   245,   246,   247,   248,    -1,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,    -1,    -1,   291,   292,
      -1,    -1,   295,   296,    -1,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,    -1,   308,   309,   310,   311,   312,
      -1,   314,   315,   316,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,    -1,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,   358,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,    -1,   371,   372,
      -1,   374,   375,   376,   377,    -1,   379,   380,    -1,    -1,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
      -1,   394,   395,   396,   397,   398,   399,    -1,   401,   402,
      -1,   404,   405,   406,   407,   408,    -1,    -1,    -1,   412,
     413,   414,   415,   416,   417,    -1,    -1,    -1,   421,   422,
     423,   424,   425,    -1,    -1,   428,   429,   430,   431,   432,
     433,    -1,    -1,    -1,    -1,   438,   439,     5,     6,     7,
       8,     9,    10,    11,   447,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    -1,    35,    36,    37,
      38,    39,    40,    -1,    42,    43,    44,    -1,    46,    47,
      48,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,    -1,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
      -1,   109,   110,    -1,   112,   113,   114,   115,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,   125,    -1,    -1,
     128,   129,   130,   131,   132,    -1,   134,   135,   136,   137,
      -1,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,
      -1,   169,   170,   171,   172,    -1,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,   183,   184,    -1,   186,   187,
     188,   189,   190,    -1,   192,    -1,   194,   195,    -1,   197,
     198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,
     208,   209,   210,   211,   212,   213,   214,    -1,   216,   217,
     218,   219,   220,   221,    -1,   223,   224,    -1,   226,   227,
     228,   229,   230,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,    -1,   245,   246,   247,
     248,    -1,   250,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,    -1,    -1,   291,   292,    -1,    -1,   295,   296,    -1,
      -1,   299,   300,   301,   302,   303,   304,   305,   306,    -1,
     308,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,    -1,    -1,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,   374,   375,   376,   377,
      -1,   379,   380,    -1,    -1,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,    -1,   394,   395,   396,   397,
     398,   399,    -1,   401,   402,    -1,   404,   405,   406,   407,
     408,    -1,    -1,    -1,   412,   413,   414,   415,   416,   417,
      -1,    -1,    -1,   421,   422,   423,   424,   425,    -1,    -1,
     428,   429,   430,   431,   432,   433,    -1,    -1,    -1,    -1,
     438,   439,     5,     6,     7,     8,     9,    10,    11,   447,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    -1,    35,    36,    37,    38,    39,    40,    -1,    42,
      43,    44,    -1,    46,    47,    48,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,
      -1,    -1,    95,    96,    -1,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,    -1,   112,
     113,   114,   115,   116,   117,   118,   119,    -1,   121,   122,
     123,   124,   125,    -1,    -1,   128,   129,   130,   131,   132,
      -1,   134,   135,   136,   137,    -1,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,    -1,   162,
     163,   164,    -1,   166,    -1,    -1,   169,   170,   171,   172,
      -1,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
     183,   184,    -1,   186,   187,   188,   189,   190,    -1,   192,
      -1,   194,   195,    -1,   197,   198,    -1,   200,    -1,   202,
     203,    -1,   205,    -1,   207,   208,   209,   210,   211,   212,
     213,   214,    -1,   216,   217,   218,   219,   220,   221,    -1,
     223,   224,    -1,   226,   227,   228,   229,   230,    -1,   232,
      -1,    -1,   235,   236,   237,   238,   239,   240,   241,   242,
     243,    -1,   245,   246,   247,   248,    -1,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,   285,   286,   287,   288,    -1,    -1,   291,   292,
      -1,    -1,   295,   296,    -1,    -1,   299,   300,   301,   302,
     303,   304,   305,   306,    -1,   308,   309,   310,   311,   312,
      -1,   314,   315,   316,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,   344,   345,    -1,    -1,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,   358,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,    -1,   371,   372,
      -1,   374,   375,   376,   377,    -1,   379,   380,    -1,    -1,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
      -1,   394,   395,   396,   397,   398,   399,    -1,   401,   402,
      -1,   404,   405,   406,   407,   408,    -1,    -1,    -1,   412,
     413,   414,   415,   416,   417,    -1,    -1,    -1,   421,   422,
     423,   424,   425,    -1,    -1,   428,   429,   430,   431,   432,
     433,    -1,    -1,    -1,    -1,   438,   439,    -1,    -1,    -1,
      -1,    -1,   445,    -1,   447,     5,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    -1,    35,    36,    37,    38,    39,
      40,    -1,    42,    43,    44,    -1,    46,    47,    48,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    92,    -1,    -1,    95,    96,    -1,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,    -1,   109,
     110,    -1,   112,   113,   114,   115,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,   125,    -1,    -1,   128,   129,
     130,   131,   132,    -1,   134,   135,   136,   137,    -1,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,
     170,   171,   172,    -1,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,   183,   184,    -1,   186,   187,   188,   189,
     190,    -1,   192,    -1,   194,   195,   196,   197,   198,    -1,
     200,    -1,   202,   203,    -1,   205,    -1,   207,   208,   209,
     210,   211,   212,   213,   214,    -1,   216,   217,   218,   219,
     220,   221,    -1,   223,   224,    -1,   226,   227,   228,   229,
     230,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,    -1,   245,   246,   247,   248,    -1,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
      -1,   291,   292,    -1,    -1,   295,   296,    -1,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,    -1,   308,   309,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,   344,   345,    -1,    -1,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,   374,   375,   376,   377,    -1,   379,
     380,    -1,    -1,   383,   384,   385,   386,   387,   388,   389,
     390,   391,   392,    -1,   394,   395,   396,   397,   398,   399,
      -1,   401,   402,    -1,   404,   405,   406,   407,   408,    -1,
      -1,    -1,   412,   413,   414,   415,   416,   417,    -1,    -1,
      -1,   421,   422,   423,   424,   425,    -1,    -1,   428,   429,
     430,   431,   432,   433,    -1,    -1,    -1,    -1,   438,   439,
       5,     6,     7,     8,     9,    10,    11,   447,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    -1,
      35,    36,    37,    38,    39,    40,    -1,    42,    43,    44,
      -1,    46,    47,    48,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,
      95,    96,    -1,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,    -1,   109,   110,    -1,   112,   113,   114,
     115,   116,   117,   118,   119,    -1,   121,   122,   123,   124,
     125,    -1,    -1,   128,   129,   130,   131,   132,    -1,   134,
     135,   136,   137,    -1,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,    -1,   162,   163,   164,
      -1,   166,    -1,    -1,   169,   170,   171,   172,    -1,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,   183,   184,
      -1,   186,   187,   188,   189,   190,    -1,   192,    -1,   194,
     195,    -1,   197,   198,    -1,   200,    -1,   202,   203,    -1,
     205,    -1,   207,   208,   209,   210,   211,   212,   213,   214,
      -1,   216,   217,   218,   219,   220,   221,    -1,   223,   224,
      -1,   226,   227,   228,   229,   230,    -1,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,    -1,
     245,   246,   247,   248,    -1,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,    -1,   291,   292,    -1,    -1,
     295,   296,    -1,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,    -1,   308,   309,   310,   311,   312,    -1,   314,
     315,   316,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,    -1,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,    -1,    -1,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,   374,
     375,   376,   377,    -1,   379,   380,    -1,    -1,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,    -1,   394,
     395,   396,   397,   398,   399,    -1,   401,   402,    -1,   404,
     405,   406,   407,   408,    -1,    -1,    -1,   412,   413,   414,
     415,   416,   417,    -1,    -1,    -1,   421,   422,   423,   424,
     425,    -1,    -1,   428,   429,   430,   431,   432,   433,    -1,
      -1,    -1,    -1,   438,   439,     5,     6,     7,     8,     9,
      10,    11,   447,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    -1,    35,    36,    37,    38,    39,
      40,    -1,    42,    43,    44,    -1,    46,    47,    48,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    92,    -1,    -1,    95,    96,    -1,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,    -1,   109,
     110,    -1,   112,   113,   114,   115,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,   125,    -1,    -1,   128,   129,
     130,   131,   132,    -1,   134,   135,   136,   137,    -1,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,
     170,   171,   172,    -1,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,   183,   184,    -1,   186,   187,   188,   189,
     190,    -1,   192,    -1,   194,   195,    -1,   197,   198,    -1,
     200,    -1,   202,   203,    -1,   205,    -1,   207,   208,   209,
     210,   211,   212,   213,   214,    -1,   216,   217,   218,   219,
     220,   221,    -1,   223,   224,    -1,   226,   227,   228,   229,
     230,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,    -1,   245,   246,   247,   248,    -1,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
      -1,   291,   292,    -1,    -1,   295,   296,    -1,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,    -1,   308,   309,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,   344,   345,    -1,    -1,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,   374,   375,   376,   377,    -1,   379,
     380,    -1,    -1,   383,   384,   385,   386,   387,   388,   389,
     390,   391,   392,    -1,    -1,   395,   396,   397,   398,   399,
      -1,   401,   402,    -1,   404,   405,   406,   407,   408,    -1,
      -1,    -1,   412,   413,   414,   415,   416,   417,    -1,    -1,
      -1,   421,   422,   423,   424,   425,    -1,    -1,   428,   429,
     430,   431,   432,   433,    -1,    -1,    -1,    -1,    -1,   439,
       5,     6,     7,     8,     9,    10,    11,   447,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    -1,
      35,    36,    37,    38,    39,    40,    -1,    42,    43,    44,
      -1,    46,    47,    48,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,
      95,    96,    -1,    98,    99,   100,   101,   102,    -1,   104,
     105,   106,   107,    -1,   109,   110,    -1,   112,   113,   114,
     115,   116,   117,   118,   119,    -1,   121,   122,   123,   124,
     125,    -1,    -1,   128,   129,   130,   131,   132,    -1,   134,
     135,   136,   137,    -1,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,    -1,   162,   163,   164,
      -1,   166,    -1,    -1,   169,   170,   171,   172,    -1,   174,
     175,   176,    -1,    -1,    -1,   180,   181,   182,   183,   184,
      -1,   186,   187,   188,   189,   190,    -1,   192,    -1,   194,
     195,    -1,   197,   198,    -1,   200,    -1,   202,   203,    -1,
     205,    -1,   207,   208,   209,   210,    -1,   212,   213,   214,
      -1,   216,   217,   218,   219,   220,   221,    -1,   223,   224,
      -1,   226,   227,   228,   229,   230,    -1,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,    -1,
     245,   246,   247,    -1,    -1,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,   284,
     285,   286,   287,   288,    -1,    -1,   291,   292,    -1,    -1,
     295,   296,    -1,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,    -1,   308,   309,   310,   311,   312,    -1,   314,
     315,   316,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,    -1,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,    -1,    -1,   348,   349,   350,   351,   352,   353,   354,
     355,    -1,   357,   358,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,   374,
     375,   376,   377,    -1,   379,   380,    -1,    -1,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,    -1,   394,
     395,   396,   397,   398,   399,    -1,   401,   402,    -1,   404,
     405,   406,   407,   408,    -1,    -1,    -1,   412,   413,   414,
     415,   416,   417,    -1,    -1,    -1,   421,   422,   423,   424,
     425,    -1,    -1,   428,   429,   430,   431,   432,   433,    -1,
      -1,    -1,    -1,   438,   439,     5,     6,     7,     8,     9,
      10,    11,   447,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    -1,    35,    36,    37,    38,    39,
      40,    -1,    42,    43,    44,    -1,    46,    47,    48,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    92,    -1,    -1,    95,    96,    -1,    98,    99,
     100,   101,   102,    -1,   104,   105,   106,   107,    -1,   109,
     110,    -1,   112,   113,   114,   115,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,   125,    -1,    -1,   128,   129,
     130,   131,   132,    -1,   134,   135,   136,   137,    -1,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,
     170,   171,   172,    -1,   174,   175,   176,    -1,    -1,    -1,
     180,   181,   182,   183,   184,    -1,   186,   187,   188,   189,
     190,    -1,   192,    -1,   194,   195,    -1,   197,   198,    -1,
     200,    -1,   202,   203,    -1,   205,    -1,   207,   208,   209,
     210,    -1,   212,   213,   214,    -1,   216,   217,   218,   219,
     220,   221,    -1,   223,   224,    -1,   226,   227,   228,   229,
     230,    -1,   232,    -1,    -1,   235,   236,   237,   238,   239,
     240,   241,   242,   243,    -1,   245,   246,   247,    -1,    -1,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,   282,   283,   284,   285,   286,   287,   288,    -1,
      -1,   291,   292,    -1,    -1,    -1,   296,    -1,    -1,   299,
     300,   301,   302,   303,   304,   305,   306,    -1,   308,   309,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,   344,   345,    -1,    -1,   348,   349,
     350,   351,   352,   353,   354,   355,    -1,   357,   358,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,   374,   375,   376,   377,    -1,   379,
     380,    -1,    -1,   383,   384,   385,   386,   387,   388,   389,
     390,   391,   392,    -1,    -1,   395,   396,   397,   398,   399,
      -1,   401,   402,    -1,   404,   405,   406,   407,   408,    -1,
      -1,    -1,   412,   413,   414,   415,   416,   417,    -1,    -1,
      -1,   421,   422,    -1,   424,   425,    -1,    -1,   428,   429,
     430,   431,   432,   433,    -1,    -1,    -1,    -1,    -1,   439,
      -1,     6,     7,     8,     9,    10,    11,   447,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    93,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,   113,    -1,
      -1,   116,   117,   118,   119,    -1,   121,   122,   123,   124,
     125,    -1,    -1,   128,   129,   130,   131,   132,    -1,   134,
     135,   136,   137,    -1,   139,   140,   141,   142,   143,    -1,
      -1,    -1,    -1,    -1,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,    -1,   162,   163,   164,
      -1,   166,    -1,    -1,   169,   170,   171,   172,    -1,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,   183,   184,
      -1,   186,    -1,   188,   189,   190,    -1,   192,    -1,   194,
      -1,    -1,   197,   198,    -1,   200,    -1,   202,   203,    -1,
     205,    -1,   207,   208,   209,   210,    -1,   212,   213,   214,
      -1,   216,   217,   218,   219,   220,   221,    -1,   223,   224,
      -1,   226,   227,   228,    -1,   230,    -1,   232,    -1,    -1,
      -1,    -1,   237,   238,   239,   240,   241,   242,   243,    -1,
     245,   246,   247,    -1,    -1,   250,   251,   252,    -1,    -1,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,    -1,   270,   271,   272,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,    -1,   283,    -1,
     285,   286,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,
     295,   296,    -1,    -1,   299,    -1,    -1,   302,   303,   304,
     305,   306,    -1,   308,   309,   310,   311,   312,    -1,   314,
     315,   316,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,    -1,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,    -1,    -1,   348,   349,   350,    -1,   352,   353,   354,
     355,    -1,   357,   358,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,   374,
     375,   376,   377,    -1,   379,   380,    -1,    -1,   383,   384,
     385,   386,    -1,   388,   389,   390,   391,   392,    -1,    -1,
     395,   396,   397,   398,    -1,    -1,   401,   402,    -1,   404,
     405,   406,    -1,   408,    -1,    -1,    -1,   412,   413,   414,
     415,   416,   417,    -1,    -1,    -1,   421,    -1,    -1,   424,
      -1,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,   448,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,    -1,   109,   110,    -1,   112,   113,    -1,
     115,   116,   117,   118,   119,    -1,   121,   122,   123,   124,
     125,    -1,    -1,   128,   129,   130,   131,   132,    -1,   134,
     135,   136,   137,    -1,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,    -1,   162,   163,   164,
      -1,   166,    -1,    -1,   169,   170,   171,   172,    -1,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,   183,   184,
      -1,   186,    -1,   188,   189,   190,    -1,   192,    -1,   194,
     195,    -1,   197,   198,    -1,   200,    -1,   202,   203,    -1,
     205,    -1,   207,   208,   209,   210,   211,   212,   213,   214,
      -1,   216,   217,   218,   219,   220,   221,    -1,   223,   224,
      -1,   226,   227,   228,    -1,   230,    -1,   232,    -1,    -1,
     235,   236,   237,   238,   239,   240,   241,   242,   243,    -1,
     245,   246,   247,   248,    -1,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,   282,   283,    -1,
     285,   286,   287,   288,    -1,    -1,   291,   292,    -1,   294,
     295,   296,    -1,    -1,   299,   300,   301,   302,   303,   304,
     305,   306,    -1,   308,   309,   310,   311,   312,    -1,   314,
     315,   316,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,    -1,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,    -1,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,   374,
     375,   376,   377,    -1,   379,   380,    -1,    -1,   383,   384,
     385,   386,    -1,   388,   389,   390,   391,   392,    -1,    -1,
     395,   396,   397,   398,   399,    -1,   401,   402,    -1,   404,
     405,   406,   407,   408,    -1,    -1,    -1,   412,   413,   414,
     415,   416,   417,    -1,    -1,    -1,   421,    -1,    -1,   424,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,   447,    29,    30,    31,    32,    -1,    -1,    35,
      36,    37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,
      46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    99,   100,   101,   102,   103,   104,   105,
     106,    -1,    -1,   109,   110,    -1,   112,   113,    -1,   115,
     116,   117,   118,   119,    -1,   121,   122,   123,   124,   125,
      -1,    -1,   128,   129,   130,   131,   132,    -1,   134,   135,
     136,   137,    -1,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,    -1,    -1,   169,   170,   171,   172,    -1,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,   183,   184,    -1,
     186,    -1,   188,   189,   190,    -1,   192,    -1,   194,   195,
      -1,   197,   198,    -1,   200,    -1,   202,   203,    -1,   205,
      -1,   207,   208,   209,   210,   211,   212,   213,   214,    -1,
     216,   217,   218,   219,   220,   221,    -1,   223,   224,    -1,
     226,   227,   228,    -1,   230,    -1,   232,    -1,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,    -1,   245,
     246,   247,   248,    -1,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,   282,   283,    -1,   285,
     286,   287,   288,    -1,    -1,   291,   292,    -1,   294,   295,
     296,    -1,    -1,   299,   300,   301,   302,   303,   304,   305,
     306,    -1,   308,   309,   310,   311,   312,    -1,   314,   315,
     316,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,   344,   345,
      -1,    -1,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,   358,    -1,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,    -1,   371,   372,    -1,   374,   375,
     376,   377,    -1,   379,   380,    -1,    -1,   383,   384,   385,
     386,    -1,   388,   389,   390,   391,   392,    -1,    -1,   395,
     396,   397,   398,   399,    -1,   401,   402,    -1,   404,   405,
     406,   407,   408,    -1,    -1,    -1,   412,   413,   414,   415,
     416,   417,    -1,    -1,    -1,   421,    -1,    -1,   424,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,   447,    29,    30,    31,    32,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,
      -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      -1,    98,    99,   100,   101,   102,   103,   104,   105,   106,
      -1,    -1,   109,   110,    -1,   112,   113,    -1,   115,   116,
     117,   118,   119,    -1,   121,   122,   123,   124,   125,    -1,
      -1,   128,   129,   130,   131,   132,    -1,   134,   135,   136,
     137,    -1,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,   152,   153,   154,   155,   156,
      -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,   166,
      -1,    -1,   169,   170,   171,   172,    -1,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,   183,   184,    -1,   186,
      -1,   188,   189,   190,    -1,   192,    -1,   194,   195,    -1,
     197,   198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,
     207,   208,   209,   210,   211,   212,   213,   214,    -1,   216,
     217,   218,   219,   220,   221,    -1,   223,   224,    -1,   226,
     227,   228,    -1,   230,    -1,   232,    -1,    -1,   235,   236,
     237,   238,   239,   240,   241,   242,   243,    -1,   245,   246,
     247,   248,    -1,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,   282,   283,    -1,   285,   286,
     287,   288,    -1,    -1,   291,   292,    -1,    -1,   295,   296,
      -1,    -1,   299,   300,   301,   302,   303,   304,   305,   306,
      -1,   308,   309,   310,   311,   312,    -1,   314,   315,   316,
     317,   318,   319,   320,   321,   322,    -1,   324,   325,   326,
     327,   328,   329,   330,   331,   332,    -1,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,   344,   345,    -1,
      -1,   348,   349,   350,   351,   352,   353,   354,   355,   356,
     357,   358,    -1,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,    -1,   371,   372,    -1,   374,   375,   376,
     377,    -1,   379,   380,    -1,    -1,   383,   384,   385,   386,
      -1,   388,   389,   390,   391,   392,    -1,    -1,   395,   396,
     397,   398,   399,    -1,   401,   402,    -1,   404,   405,   406,
     407,   408,    -1,    -1,    -1,   412,   413,   414,   415,   416,
     417,    -1,    -1,    -1,   421,    -1,    -1,   424,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
     447,    29,    30,    31,    32,    -1,    -1,    35,    36,    37,
      38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,
      -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,
      -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,   125,    -1,    -1,
     128,   129,   130,   131,   132,    -1,   134,   135,   136,   137,
      -1,   139,   140,   141,    -1,   143,    -1,    -1,    -1,    -1,
      -1,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,
      -1,   169,   170,   171,   172,    -1,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,   183,   184,    -1,   186,    -1,
     188,   189,   190,    -1,   192,    -1,   194,    -1,    -1,    -1,
     198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,
     208,   209,   210,    -1,   212,   213,   214,    -1,   216,   217,
     218,   219,   220,   221,    -1,    -1,   224,    -1,   226,   227,
     228,    -1,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,
      -1,   239,   240,   241,   242,   243,    -1,   245,    -1,   247,
      -1,    -1,   250,   251,   252,    -1,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,    -1,
     268,    -1,   270,   271,   272,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,    -1,   283,    -1,   285,   286,   287,
     288,    -1,    -1,   291,    -1,    -1,    -1,   295,   296,    -1,
      -1,   299,    -1,    -1,   302,   303,   304,   305,   306,    -1,
     308,   309,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,    -1,   337,
     338,   339,   340,   341,   342,   343,   344,   345,    -1,    -1,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,   357,
     358,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,    -1,   371,   372,    -1,   374,   375,   376,   377,
      -1,   379,   380,    -1,    -1,   383,   384,   385,   386,    -1,
     388,   389,   390,   391,   392,    -1,    -1,   395,   396,   397,
     398,    -1,    -1,   401,   402,    -1,   404,   405,   406,    -1,
     408,    -1,    -1,    -1,   412,   413,   414,   415,   416,   417,
      -1,    -1,    -1,   421,   422,    -1,   424,   425,    -1,    -1,
      -1,    -1,   430,   431,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   446,   447,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    -1,    29,    30,    31,    32,    -1,    -1,    35,
      36,    37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,
      46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,   113,    -1,    -1,
     116,   117,   118,   119,    -1,   121,   122,   123,   124,   125,
      -1,    -1,   128,   129,   130,   131,   132,    -1,   134,   135,
     136,   137,    -1,   139,   140,   141,    -1,   143,    -1,    -1,
      -1,    -1,    -1,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,    -1,    -1,   169,   170,   171,   172,    -1,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,   183,   184,    -1,
     186,    -1,   188,   189,   190,    -1,   192,    -1,   194,    -1,
      -1,    -1,   198,    -1,   200,    -1,   202,   203,    -1,   205,
      -1,   207,   208,   209,   210,    -1,   212,   213,   214,    -1,
     216,   217,   218,   219,   220,   221,    -1,    -1,   224,    -1,
     226,   227,   228,    -1,   230,    -1,   232,    -1,    -1,    -1,
      -1,   237,    -1,   239,   240,   241,   242,   243,    -1,   245,
      -1,   247,    -1,    -1,   250,   251,   252,    -1,    -1,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,    -1,   268,    -1,   270,   271,   272,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,    -1,   283,    -1,   285,
     286,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,   295,
     296,    -1,    -1,   299,    -1,    -1,   302,   303,   304,   305,
     306,    -1,   308,   309,   310,   311,   312,    -1,   314,   315,
     316,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
      -1,   337,   338,   339,   340,   341,   342,   343,   344,   345,
      -1,    -1,   348,   349,   350,    -1,   352,   353,   354,   355,
      -1,   357,   358,    -1,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,    -1,   371,   372,    -1,   374,   375,
     376,   377,    -1,   379,   380,    -1,    -1,   383,   384,   385,
     386,    -1,   388,   389,   390,   391,   392,    -1,    -1,   395,
     396,   397,   398,    -1,    -1,   401,   402,    -1,   404,   405,
     406,    -1,   408,    -1,    -1,    -1,   412,   413,   414,   415,
     416,   417,    -1,    -1,    -1,   421,   422,    -1,   424,   425,
      -1,    -1,    -1,    -1,   430,   431,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,   447,    22,    23,    24,    25,    26,    27,    -1,    29,
      30,    31,    32,    -1,    -1,    35,    36,    37,    38,    -1,
      -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,
     110,    -1,   112,   113,    -1,    -1,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,   125,    -1,    -1,   128,   129,
     130,   131,   132,    -1,   134,   135,   136,   137,    -1,   139,
     140,   141,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,
     170,   171,   172,    -1,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,   183,   184,    -1,   186,    -1,   188,   189,
     190,    -1,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,
     200,    -1,   202,   203,    -1,   205,    -1,   207,   208,   209,
     210,    -1,   212,   213,   214,    -1,   216,   217,   218,   219,
     220,   221,    -1,    -1,   224,    -1,   226,   227,   228,    -1,
     230,    -1,   232,    -1,    -1,    -1,    -1,   237,    -1,   239,
     240,   241,   242,   243,    -1,   245,    -1,   247,    -1,    -1,
     250,   251,   252,    -1,    -1,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,    -1,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,    -1,   283,    -1,   285,   286,   287,   288,    -1,
      -1,   291,   292,    -1,    -1,   295,   296,    -1,    -1,   299,
      -1,    -1,   302,   303,   304,   305,   306,    -1,   308,   309,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,    -1,   337,   338,   339,
     340,   341,   342,   343,   344,   345,    -1,    -1,   348,   349,
     350,    -1,   352,   353,   354,   355,    -1,   357,   358,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,   374,   375,   376,   377,    -1,   379,
     380,    -1,    -1,   383,   384,   385,   386,    -1,   388,   389,
     390,   391,   392,    -1,    -1,   395,   396,   397,   398,    -1,
      -1,   401,   402,    -1,   404,   405,   406,    -1,   408,    -1,
      -1,    -1,   412,   413,   414,   415,   416,   417,    -1,    -1,
      -1,   421,    -1,    -1,   424,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,   447,    29,    30,
      31,    32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,
      -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,
      -1,   112,   113,    -1,    -1,   116,   117,   118,   119,    -1,
     121,   122,   123,   124,   125,    -1,    -1,   128,   129,   130,
     131,   132,    -1,   134,   135,   136,   137,    -1,   139,   140,
     141,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
      -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,   170,
     171,   172,    -1,   174,   175,   176,    -1,   178,    -1,   180,
     181,   182,   183,   184,    -1,   186,    -1,   188,   189,   190,
      -1,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,
      -1,   202,   203,    -1,   205,    -1,   207,   208,   209,   210,
      -1,   212,   213,   214,    -1,   216,   217,   218,   219,   220,
     221,    -1,    -1,   224,    -1,   226,   227,   228,    -1,   230,
      -1,   232,    -1,    -1,    -1,    -1,   237,    -1,   239,   240,
     241,   242,   243,    -1,   245,    -1,   247,    -1,    -1,   250,
     251,   252,    -1,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,    -1,   268,    -1,   270,
     271,   272,   273,   274,   275,   276,   277,   278,    -1,   280,
     281,    -1,   283,    -1,   285,   286,   287,   288,    -1,    -1,
     291,    -1,    -1,    -1,   295,   296,    -1,    -1,   299,    -1,
      -1,   302,   303,   304,   305,   306,    -1,   308,   309,   310,
     311,   312,    -1,   314,   315,   316,   317,   318,   319,   320,
     321,   322,    -1,   324,   325,   326,   327,   328,   329,   330,
     331,   332,    -1,   334,   335,    -1,   337,   338,   339,   340,
     341,   342,   343,   344,   345,    -1,   347,   348,   349,   350,
      -1,   352,   353,   354,   355,    -1,   357,   358,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,    -1,
     371,   372,    -1,   374,   375,   376,   377,    -1,   379,   380,
      -1,    -1,   383,   384,   385,   386,    -1,   388,   389,   390,
     391,   392,    -1,    -1,   395,   396,   397,   398,    -1,    -1,
     401,   402,    -1,   404,   405,   406,    -1,   408,    -1,    -1,
      -1,   412,   413,   414,   415,   416,   417,    -1,    -1,    -1,
     421,    -1,    -1,   424,   425,    -1,    -1,    -1,    -1,    -1,
      -1,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    -1,    18,    -1,    20,   447,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,   113,    -1,
      -1,   116,   117,   118,   119,    -1,   121,   122,   123,   124,
     125,    -1,    -1,   128,   129,   130,   131,   132,    -1,   134,
     135,   136,   137,    -1,   139,   140,   141,    -1,   143,    -1,
      -1,    -1,    -1,    -1,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,    -1,   162,   163,   164,
      -1,   166,    -1,    -1,   169,   170,   171,   172,    -1,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,   183,   184,
      -1,   186,    -1,   188,   189,   190,    -1,   192,    -1,   194,
      -1,    -1,    -1,   198,    -1,   200,    -1,   202,   203,    -1,
     205,    -1,   207,   208,   209,   210,    -1,   212,   213,   214,
      -1,   216,   217,   218,   219,   220,   221,    -1,    -1,   224,
      -1,   226,   227,   228,    -1,   230,    -1,   232,    -1,    -1,
      -1,    -1,   237,    -1,   239,   240,   241,   242,   243,    -1,
     245,    -1,   247,    -1,    -1,   250,   251,   252,    -1,    -1,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,    -1,   268,    -1,   270,   271,   272,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,    -1,   283,    -1,
     285,   286,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,
     295,   296,    -1,    -1,   299,    -1,    -1,   302,   303,   304,
     305,   306,    -1,   308,   309,   310,   311,   312,    -1,   314,
     315,   316,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,    -1,   334,
     335,    -1,   337,   338,   339,   340,   341,   342,   343,   344,
     345,    -1,   347,   348,   349,   350,    -1,   352,   353,   354,
     355,    -1,   357,   358,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,   374,
     375,   376,   377,    -1,   379,   380,    -1,    -1,   383,   384,
     385,   386,    -1,   388,   389,   390,   391,   392,    -1,    -1,
     395,   396,   397,   398,    -1,    -1,   401,   402,    -1,   404,
     405,   406,    -1,   408,    -1,    -1,    -1,   412,   413,   414,
     415,   416,   417,    -1,    -1,    -1,   421,    -1,    -1,   424,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,   447,    29,    30,    31,    32,    -1,    -1,    35,
      36,    37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,
      46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,   113,    -1,    -1,
     116,   117,   118,   119,    -1,   121,   122,   123,   124,   125,
      -1,    -1,   128,   129,   130,   131,   132,    -1,   134,   135,
     136,   137,    -1,   139,   140,   141,    -1,   143,    -1,    -1,
      -1,    -1,    -1,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,    -1,    -1,   169,   170,   171,   172,    -1,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,   183,   184,    -1,
     186,    -1,   188,   189,   190,    -1,   192,    -1,   194,    -1,
      -1,    -1,   198,    -1,   200,    -1,   202,   203,    -1,   205,
      -1,   207,   208,   209,   210,    -1,   212,   213,   214,    -1,
     216,   217,   218,   219,   220,   221,    -1,    -1,   224,    -1,
     226,   227,   228,    -1,   230,    -1,   232,    -1,    -1,    -1,
      -1,   237,    -1,   239,   240,   241,   242,   243,    -1,   245,
      -1,   247,    -1,    -1,   250,   251,   252,    -1,    -1,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,    -1,   268,    -1,   270,   271,   272,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,    -1,   283,    -1,   285,
     286,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,   295,
     296,    -1,    -1,   299,    -1,    -1,   302,   303,   304,   305,
     306,    -1,   308,   309,   310,   311,   312,    -1,   314,   315,
     316,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
      -1,   337,   338,   339,   340,   341,   342,   343,   344,   345,
      -1,    -1,   348,   349,   350,    -1,   352,   353,   354,   355,
      -1,   357,   358,    -1,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,    -1,   371,   372,    -1,   374,   375,
     376,   377,    -1,   379,   380,    -1,    -1,   383,   384,   385,
     386,    -1,   388,   389,   390,   391,   392,    -1,    -1,   395,
     396,   397,   398,    -1,    -1,   401,   402,    -1,   404,   405,
     406,    -1,   408,    -1,    -1,    -1,   412,   413,   414,   415,
     416,   417,    -1,    -1,    -1,   421,    -1,    -1,   424,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,   447,    29,    30,    31,    32,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,
      -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
      -1,    -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,
     117,   118,   119,    -1,   121,   122,   123,   124,   125,    -1,
      -1,   128,   129,   130,   131,   132,    -1,   134,   135,   136,
     137,    -1,   139,   140,   141,    -1,   143,    -1,    -1,    -1,
      -1,    -1,   149,   150,   151,   152,   153,   154,   155,   156,
      -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,   166,
      -1,    -1,   169,   170,   171,   172,    -1,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,   183,   184,    -1,   186,
      -1,   188,   189,   190,    -1,   192,    -1,   194,    -1,    -1,
      -1,   198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,
     207,   208,   209,   210,    -1,   212,   213,   214,    -1,   216,
     217,   218,   219,   220,   221,    -1,    -1,   224,    -1,   226,
     227,   228,    -1,   230,    -1,   232,    -1,    -1,    -1,    -1,
     237,    -1,   239,   240,   241,   242,   243,    -1,   245,    -1,
     247,    -1,    -1,   250,   251,   252,    -1,    -1,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
      -1,   268,    -1,   270,   271,   272,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,    -1,   283,    -1,   285,   286,
     287,   288,    -1,    -1,   291,    -1,    -1,    -1,   295,   296,
      -1,    -1,   299,    -1,    -1,   302,   303,   304,   305,   306,
      -1,   308,   309,   310,   311,   312,    -1,   314,   315,   316,
     317,   318,   319,   320,   321,   322,    -1,   324,   325,   326,
     327,   328,   329,   330,   331,   332,    -1,   334,   335,    -1,
     337,   338,   339,   340,   341,   342,   343,   344,   345,    -1,
      -1,   348,   349,   350,    -1,   352,   353,   354,   355,    -1,
     357,   358,    -1,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,    -1,   371,   372,    -1,   374,   375,   376,
     377,    -1,   379,   380,    -1,    -1,   383,   384,   385,   386,
      -1,   388,   389,   390,   391,   392,    -1,    -1,   395,   396,
     397,   398,    -1,    -1,   401,   402,    -1,   404,   405,   406,
      -1,   408,    -1,    -1,    -1,   412,   413,   414,   415,   416,
     417,    -1,    -1,    -1,   421,    -1,    -1,   424,    -1,    -1,
      -1,    -1,    -1,    -1,     5,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
     447,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    -1,    35,    36,    37,    38,    39,    40,
      -1,    42,    43,    44,    -1,    46,    47,    48,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,   108,   109,   110,
      -1,   112,   113,   114,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   124,    -1,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,    -1,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,   157,   158,   159,   160,
      -1,   162,   163,   164,   165,   166,   167,   168,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   180,
     181,   182,    -1,   184,    -1,    -1,   187,   188,   189,   190,
     191,   192,   193,   194,   195,   196,   197,   198,    -1,   200,
     201,   202,    -1,   204,   205,   206,   207,   208,   209,   210,
     211,   212,   213,   214,   215,   216,   217,   218,   219,   220,
     221,   222,   223,    -1,    -1,   226,   227,   228,   229,   230,
     231,   232,   233,    -1,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,    -1,   246,   247,   248,   249,   250,
     251,   252,    -1,    -1,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,    -1,   278,   279,   280,
     281,   282,   283,   284,    -1,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,    -1,   300,
     301,    -1,   303,   304,   305,   306,    -1,    -1,    -1,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,   338,    -1,   340,
     341,   342,   343,   344,   345,    -1,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,   363,   364,   365,   366,   367,    -1,   369,   370,
     371,   372,   373,   374,   375,   376,   377,   378,   379,   380,
      -1,   382,   383,    -1,   385,    -1,   387,   388,   389,   390,
     391,   392,    -1,   394,   395,   396,   397,   398,   399,   400,
     401,   402,    -1,    -1,   405,   406,   407,   408,    -1,   410,
     411,   412,   413,   414,   415,   416,   417,    -1,    -1,    -1,
     421,   422,   423,   424,   425,    -1,    -1,    -1,    -1,   430,
     431,    -1,   433,   434,   435,   436,    -1,   438,   439,   440,
     441,   442,   443,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    32,
      -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
     113,    -1,    -1,   116,   117,   118,   119,    -1,   121,   122,
     123,   124,   125,    -1,    -1,   128,   129,   130,   131,   132,
      -1,   134,   135,   136,   137,    -1,   139,   140,   141,    -1,
     143,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,    -1,   162,
     163,   164,    -1,   166,    -1,    -1,   169,   170,   171,   172,
      -1,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
     183,   184,    -1,   186,    -1,   188,   189,   190,    -1,   192,
      -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,
     203,    -1,   205,    -1,   207,   208,   209,   210,    -1,   212,
     213,   214,    -1,   216,   217,   218,   219,   220,   221,    -1,
      -1,   224,    -1,   226,   227,   228,    -1,   230,    -1,   232,
      -1,    -1,    -1,    -1,   237,    -1,   239,   240,   241,   242,
     243,    -1,   245,    -1,   247,    -1,    -1,   250,   251,   252,
      -1,    -1,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,    -1,   268,    -1,   270,   271,   272,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,    -1,
     283,    -1,   285,   286,   287,   288,    -1,    -1,   291,    -1,
      -1,    -1,   295,   296,    -1,    -1,   299,    -1,    -1,   302,
     303,   304,   305,   306,    -1,   308,   309,   310,   311,   312,
      -1,   314,   315,   316,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,    -1,   337,   338,   339,   340,   341,   342,
     343,   344,   345,    -1,    -1,   348,   349,   350,    -1,   352,
     353,   354,   355,    -1,   357,   358,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,    -1,   371,   372,
      -1,   374,   375,   376,   377,    -1,   379,   380,    -1,    -1,
     383,   384,   385,   386,    -1,   388,   389,   390,   391,   392,
      -1,    -1,   395,   396,   397,   398,    -1,    -1,   401,   402,
      -1,   404,   405,   406,    -1,   408,    -1,    -1,    -1,   412,
     413,   414,   415,   416,   417,    -1,    -1,    -1,   421,    -1,
     423,   424,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   434,   435,   436,    -1,   438,   439,   440,   441,   442,
     443,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,   113,    -1,
      -1,   116,   117,   118,   119,    -1,   121,   122,   123,   124,
     125,    -1,    -1,   128,   129,   130,   131,   132,    -1,   134,
     135,   136,   137,    -1,   139,   140,   141,    -1,   143,    -1,
      -1,    -1,    -1,    -1,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,    -1,   162,   163,   164,
      -1,   166,    -1,    -1,   169,   170,   171,   172,    -1,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,   183,   184,
      -1,   186,    -1,   188,   189,   190,    -1,   192,    -1,   194,
      -1,    -1,    -1,   198,    -1,   200,    -1,   202,   203,    -1,
     205,    -1,   207,   208,   209,   210,    -1,   212,   213,   214,
      -1,   216,   217,   218,   219,   220,   221,    -1,    -1,   224,
      -1,   226,   227,   228,    -1,   230,    -1,   232,    -1,    -1,
      -1,    -1,   237,    -1,   239,   240,   241,   242,   243,    -1,
     245,    -1,   247,    -1,    -1,   250,   251,   252,    -1,    -1,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,    -1,   268,    -1,   270,   271,   272,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,    -1,   283,    -1,
     285,   286,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,
     295,   296,    -1,    -1,   299,    -1,    -1,   302,   303,   304,
     305,   306,    -1,   308,   309,   310,   311,   312,    -1,   314,
     315,   316,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,    -1,   334,
     335,    -1,   337,   338,   339,   340,   341,   342,   343,   344,
     345,    -1,    -1,   348,   349,   350,    -1,   352,   353,   354,
     355,    -1,   357,   358,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,   374,
     375,   376,   377,    -1,   379,   380,    -1,    -1,   383,   384,
     385,   386,    -1,   388,   389,   390,   391,   392,    -1,    -1,
     395,   396,   397,   398,    -1,    -1,   401,   402,    -1,   404,
     405,   406,    -1,   408,    -1,    -1,    -1,   412,   413,   414,
     415,   416,   417,    -1,    -1,    -1,   421,    -1,   423,   424,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   434,
     435,   436,    -1,   438,   439,   440,   441,   442,   443,     5,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    -1,    35,
      36,    37,    38,    39,    40,    -1,    42,    43,    44,    -1,
      46,    47,    48,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,    -1,   108,   109,   110,    -1,   112,   113,   114,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,   157,   158,   159,   160,    -1,   162,   163,   164,   165,
     166,   167,   168,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   180,   181,   182,   183,   184,    -1,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
     196,   197,   198,    -1,   200,   201,   202,   203,   204,   205,
     206,   207,   208,   209,   210,   211,   212,   213,   214,   215,
     216,   217,   218,   219,   220,   221,   222,   223,   224,   225,
     226,   227,   228,   229,   230,   231,   232,   233,    -1,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   252,    -1,    -1,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,    -1,   308,   309,   310,   311,   312,   313,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,   344,   345,
      -1,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,   383,   384,   385,
     386,   387,   388,   389,   390,   391,   392,   393,   394,   395,
     396,   397,   398,   399,   400,   401,   402,    -1,    -1,   405,
     406,   407,   408,    -1,   410,   411,   412,   413,   414,   415,
     416,   417,    -1,    -1,    -1,   421,    -1,    -1,   424,    -1,
       5,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    -1,    18,   440,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    -1,
      35,    36,    37,    38,    39,    40,    -1,    42,    43,    44,
      -1,    46,    47,    48,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,   107,    -1,   109,   110,    -1,   112,   113,    -1,
      -1,   116,   117,   118,   119,    -1,   121,   122,   123,   124,
      -1,    -1,    -1,   128,   129,   130,   131,   132,    -1,   134,
     135,    -1,   137,    -1,   139,   140,   141,    -1,   143,    -1,
      -1,    -1,    -1,    -1,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,    -1,   162,   163,   164,
      -1,   166,    -1,    -1,   169,   170,   171,   172,    -1,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,    -1,   184,
      -1,    -1,    -1,   188,   189,   190,    -1,   192,    -1,   194,
      -1,    -1,    -1,   198,    -1,   200,    -1,   202,    -1,    -1,
     205,    -1,   207,   208,   209,   210,    -1,   212,   213,   214,
      -1,   216,   217,   218,   219,   220,   221,    -1,    -1,    -1,
      -1,   226,   227,   228,   229,   230,    -1,   232,    -1,    -1,
      -1,    -1,   237,    -1,   239,   240,   241,   242,   243,    -1,
      -1,    -1,   247,    -1,    -1,   250,   251,   252,    -1,    -1,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,    -1,   268,    -1,   270,   271,   272,   273,   274,
     275,   276,    -1,   278,    -1,   280,   281,    -1,   283,    -1,
      -1,   286,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,
     295,   296,    -1,    -1,    -1,    -1,    -1,    -1,   303,   304,
     305,   306,    -1,    -1,    -1,   310,   311,   312,    -1,   314,
     315,   316,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,    -1,   334,
     335,    -1,   337,   338,    -1,   340,   341,   342,   343,   344,
     345,    -1,    -1,   348,   349,   350,    -1,   352,   353,   354,
     355,    -1,   357,   358,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,    -1,   369,    -1,   371,   372,    -1,   374,
     375,   376,   377,    -1,   379,   380,    -1,    -1,   383,    -1,
     385,    -1,    -1,   388,   389,   390,   391,   392,    -1,    -1,
     395,   396,   397,   398,    -1,    -1,   401,   402,    -1,    -1,
     405,   406,    -1,   408,    -1,    -1,    -1,   412,   413,   414,
     415,   416,   417,    -1,    -1,    -1,   421,    -1,    -1,   424,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    -1,    20,   440,    22,    23,    24,    25,
      26,    27,    -1,    29,    30,    31,    32,    -1,    -1,    35,
      36,    37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,
      46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,   113,    -1,    -1,
     116,   117,   118,   119,    -1,   121,   122,   123,   124,   125,
      -1,    -1,   128,   129,   130,   131,   132,    -1,   134,   135,
     136,   137,    -1,   139,   140,   141,    -1,   143,    -1,    -1,
      -1,    -1,    -1,   149,   150,   151,   152,   153,   154,   155,
     156,    -1,   158,    -1,   160,    -1,   162,   163,   164,    -1,
     166,    -1,    -1,   169,   170,   171,   172,    -1,   174,   175,
     176,    -1,   178,    -1,   180,   181,   182,   183,   184,    -1,
     186,    -1,   188,   189,   190,    -1,   192,    -1,   194,    -1,
      -1,    -1,   198,    -1,   200,    -1,   202,   203,    -1,   205,
      -1,   207,   208,   209,   210,    -1,   212,   213,   214,    -1,
     216,   217,   218,   219,   220,   221,    -1,    -1,   224,    -1,
     226,   227,   228,    -1,   230,    -1,   232,    -1,    -1,    -1,
      -1,   237,    -1,   239,   240,   241,   242,   243,    -1,   245,
      -1,   247,    -1,    -1,   250,   251,   252,    -1,    -1,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,    -1,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,    -1,   280,   281,    -1,   283,    -1,   285,
     286,   287,   288,    -1,    -1,   291,   292,    -1,    -1,   295,
     296,    -1,    -1,   299,    -1,    -1,   302,   303,   304,   305,
     306,    -1,   308,   309,   310,   311,   312,    -1,   314,   315,
     316,   317,   318,   319,   320,   321,   322,    -1,   324,   325,
     326,   327,   328,   329,   330,   331,   332,    -1,   334,   335,
      -1,   337,   338,   339,   340,   341,   342,   343,   344,   345,
      -1,    -1,   348,   349,   350,    -1,   352,   353,   354,   355,
      -1,   357,   358,    -1,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,    -1,   371,   372,    -1,   374,   375,
     376,   377,    -1,   379,   380,    -1,    -1,   383,   384,   385,
     386,    -1,   388,   389,   390,   391,   392,    -1,    -1,   395,
     396,   397,   398,    -1,    -1,   401,   402,    -1,   404,   405,
     406,    -1,   408,    -1,    -1,    -1,   412,   413,   414,   415,
     416,   417,    -1,    -1,    -1,   421,    -1,    -1,   424,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,    -1,    20,   440,    22,    23,    24,    25,    26,
      27,    -1,    29,    30,    31,    32,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,
      -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
      -1,    -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,
     117,   118,   119,    -1,   121,   122,   123,   124,   125,    -1,
      -1,   128,   129,   130,   131,   132,    -1,   134,   135,   136,
     137,    -1,   139,   140,   141,    -1,   143,    -1,    -1,    -1,
      -1,    -1,   149,   150,   151,   152,   153,   154,   155,   156,
     157,   158,    -1,   160,    -1,   162,   163,   164,    -1,   166,
      -1,    -1,   169,   170,   171,   172,    -1,   174,   175,   176,
      -1,   178,    -1,   180,   181,   182,   183,   184,    -1,   186,
     187,   188,   189,   190,    -1,   192,    -1,   194,    -1,    -1,
      -1,   198,    -1,   200,    -1,   202,   203,    -1,   205,    -1,
     207,   208,   209,   210,    -1,   212,   213,   214,    -1,   216,
     217,   218,   219,   220,   221,    -1,    -1,   224,    -1,   226,
     227,   228,    -1,   230,    -1,   232,    -1,    -1,    -1,    -1,
     237,    -1,   239,   240,   241,   242,   243,    -1,   245,    -1,
     247,    -1,    -1,   250,   251,   252,    -1,    -1,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
      -1,   268,    -1,   270,   271,   272,   273,   274,   275,   276,
     277,   278,    -1,   280,   281,    -1,   283,    -1,   285,   286,
     287,   288,   289,    -1,   291,    -1,   293,    -1,   295,   296,
      -1,    -1,   299,    -1,    -1,   302,   303,   304,   305,   306,
      -1,   308,   309,   310,   311,   312,    -1,   314,   315,   316,
     317,   318,   319,   320,   321,   322,    -1,   324,   325,   326,
     327,   328,   329,   330,   331,   332,    -1,   334,   335,    -1,
     337,   338,   339,   340,   341,   342,   343,   344,   345,    -1,
      -1,   348,   349,   350,    -1,   352,   353,   354,   355,    -1,
     357,   358,    -1,   360,   361,   362,   363,   364,   365,   366,
     367,   368,   369,    -1,   371,   372,    -1,   374,   375,   376,
     377,    -1,   379,   380,    -1,    -1,   383,   384,   385,   386,
     387,   388,   389,   390,   391,   392,    -1,    -1,   395,   396,
     397,   398,    -1,    -1,   401,   402,    -1,   404,   405,   406,
      -1,   408,    -1,    -1,    -1,   412,   413,   414,   415,   416,
     417,    -1,    -1,    -1,   421,   422,    -1,   424,   425,    -1,
      -1,    -1,    -1,   430,   431,    -1,   433,    -1,    -1,    -1,
      -1,    -1,   439,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    32,
      -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
     113,    -1,    -1,   116,   117,   118,   119,    -1,   121,   122,
     123,   124,   125,    -1,    -1,   128,   129,   130,   131,   132,
      -1,   134,   135,   136,   137,    -1,   139,   140,   141,    -1,
     143,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,    -1,   162,
     163,   164,    -1,   166,    -1,    -1,   169,   170,   171,   172,
      -1,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
     183,   184,    -1,   186,   187,   188,   189,   190,    -1,   192,
      -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,
     203,    -1,   205,    -1,   207,   208,   209,   210,    -1,   212,
     213,   214,    -1,   216,   217,   218,   219,   220,   221,    -1,
      -1,   224,    -1,   226,   227,   228,    -1,   230,    -1,   232,
      -1,    -1,    -1,    -1,   237,    -1,   239,   240,   241,   242,
     243,    -1,   245,    -1,   247,    -1,    -1,   250,   251,   252,
      -1,    -1,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,    -1,   268,    -1,   270,   271,   272,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,    -1,
     283,    -1,   285,   286,   287,   288,   289,    -1,   291,    -1,
     293,    -1,   295,   296,    -1,    -1,   299,    -1,    -1,   302,
     303,   304,   305,   306,    -1,   308,   309,   310,   311,   312,
      -1,   314,   315,   316,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,    -1,   337,   338,   339,   340,   341,   342,
     343,   344,   345,    -1,    -1,   348,   349,   350,    -1,   352,
     353,   354,   355,    -1,   357,   358,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,    -1,   371,   372,
      -1,   374,   375,   376,   377,    -1,   379,   380,    -1,    -1,
     383,   384,   385,   386,   387,   388,   389,   390,   391,   392,
      -1,    -1,   395,   396,   397,   398,    -1,    -1,   401,   402,
      -1,   404,   405,   406,    -1,   408,    -1,    -1,    -1,   412,
     413,   414,   415,   416,   417,    -1,    -1,    -1,   421,   422,
      -1,   424,   425,    -1,    -1,    -1,    -1,   430,   431,    -1,
     433,    -1,    -1,    -1,    -1,    -1,   439,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,   113,    -1,    -1,   116,   117,   118,
     119,    -1,   121,   122,   123,   124,   125,    -1,    -1,   128,
     129,   130,   131,   132,    -1,   134,   135,   136,   137,    -1,
     139,   140,   141,    -1,   143,    -1,    -1,    -1,    -1,    -1,
     149,   150,   151,   152,   153,   154,   155,   156,    -1,   158,
      -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,
     169,   170,   171,   172,    -1,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,   183,   184,    -1,   186,    -1,   188,
     189,   190,    -1,   192,    -1,   194,    -1,   196,    -1,   198,
      -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,   208,
     209,   210,    -1,   212,   213,   214,   215,   216,   217,   218,
     219,   220,   221,    -1,    -1,   224,    -1,   226,   227,   228,
      -1,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,    -1,
     239,   240,   241,   242,   243,    -1,   245,    -1,   247,    -1,
      -1,   250,   251,   252,    -1,    -1,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,    -1,   268,
      -1,   270,   271,   272,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,    -1,   283,    -1,   285,   286,   287,   288,
      -1,    -1,   291,    -1,    -1,    -1,   295,   296,    -1,    -1,
     299,    -1,    -1,   302,   303,   304,   305,   306,    -1,   308,
     309,   310,   311,   312,    -1,   314,   315,   316,   317,   318,
     319,   320,   321,   322,    -1,   324,   325,   326,   327,   328,
     329,   330,   331,   332,    -1,   334,   335,    -1,   337,   338,
     339,   340,   341,   342,   343,   344,   345,    -1,    -1,   348,
     349,   350,    -1,   352,   353,   354,   355,    -1,   357,   358,
      -1,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,   374,   375,   376,   377,    -1,
     379,   380,    -1,    -1,   383,   384,   385,   386,    -1,   388,
     389,   390,   391,   392,    -1,    -1,   395,   396,   397,   398,
      -1,    -1,   401,   402,    -1,   404,   405,   406,    -1,   408,
      -1,    -1,    -1,   412,   413,   414,   415,   416,   417,    -1,
      -1,    -1,   421,    -1,    -1,   424,   425,    -1,    -1,    -1,
      -1,    -1,   431,    -1,     6,     7,     8,     9,    10,    11,
     439,    13,    14,    15,    16,    -1,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    -1,    29,    30,    31,
      32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,
      42,    43,    44,    -1,    46,    -1,    -1,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,   113,    -1,    -1,   116,   117,   118,   119,    -1,   121,
     122,   123,   124,   125,    -1,    -1,   128,   129,   130,   131,
     132,    -1,   134,   135,   136,   137,    -1,   139,   140,   141,
      -1,   143,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,
     152,   153,   154,   155,   156,    -1,   158,    -1,   160,    -1,
     162,   163,   164,    -1,   166,    -1,    -1,   169,   170,   171,
     172,    -1,   174,   175,   176,    -1,   178,    -1,   180,   181,
     182,   183,   184,    -1,   186,    -1,   188,   189,   190,    -1,
     192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,
     202,   203,    -1,   205,    -1,   207,   208,   209,   210,    -1,
     212,   213,   214,    -1,   216,   217,   218,   219,   220,   221,
      -1,    -1,   224,    -1,   226,   227,   228,    -1,   230,    -1,
     232,    -1,    -1,    -1,    -1,   237,    -1,   239,   240,   241,
     242,   243,    -1,   245,    -1,   247,    -1,    -1,   250,   251,
     252,    -1,    -1,   255,   256,   257,   258,   259,   260,   261,
     262,   263,   264,   265,   266,    -1,   268,    -1,   270,   271,
     272,   273,   274,   275,   276,   277,   278,    -1,   280,   281,
      -1,   283,    -1,   285,   286,   287,   288,    -1,    -1,   291,
      -1,    -1,    -1,   295,   296,    -1,    -1,   299,    -1,    -1,
     302,   303,   304,   305,   306,    -1,   308,   309,   310,   311,
     312,    -1,   314,   315,   316,   317,   318,   319,   320,   321,
     322,    -1,   324,   325,   326,   327,   328,   329,   330,   331,
     332,    -1,   334,   335,    -1,   337,   338,   339,   340,   341,
     342,   343,   344,   345,    -1,    -1,   348,   349,   350,    -1,
     352,   353,   354,   355,    -1,   357,   358,    -1,   360,   361,
     362,   363,   364,   365,   366,   367,   368,   369,    -1,   371,
     372,    -1,   374,   375,   376,   377,    -1,   379,   380,    -1,
      -1,   383,   384,   385,   386,    -1,   388,   389,   390,   391,
     392,    -1,    -1,   395,   396,   397,   398,    -1,    -1,   401,
     402,    -1,   404,   405,   406,    -1,   408,    -1,    -1,    -1,
     412,   413,   414,   415,   416,   417,    -1,    -1,    -1,   421,
      -1,    -1,   424,   425,    -1,    -1,    -1,    -1,    -1,   431,
      -1,     6,     7,     8,     9,    10,    11,   439,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,   113,    -1,
      -1,   116,   117,   118,   119,    -1,   121,   122,   123,   124,
     125,    -1,    -1,   128,   129,   130,   131,   132,    -1,   134,
     135,   136,   137,    -1,   139,   140,   141,    -1,   143,    -1,
      -1,    -1,    -1,    -1,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,    -1,   160,    -1,   162,   163,   164,
      -1,   166,    -1,    -1,   169,   170,   171,   172,    -1,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,   183,   184,
      -1,   186,    -1,   188,   189,   190,    -1,   192,    -1,   194,
      -1,    -1,    -1,   198,    -1,   200,    -1,   202,   203,    -1,
     205,    -1,   207,   208,   209,   210,    -1,   212,   213,   214,
      -1,   216,   217,   218,   219,   220,   221,    -1,    -1,   224,
      -1,   226,   227,   228,    -1,   230,    -1,   232,    -1,    -1,
      -1,    -1,   237,    -1,   239,   240,   241,   242,   243,    -1,
     245,    -1,   247,    -1,    -1,   250,   251,   252,    -1,    -1,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,    -1,   268,    -1,   270,   271,   272,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,    -1,   283,    -1,
     285,   286,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,
     295,   296,    -1,    -1,   299,    -1,    -1,   302,   303,   304,
     305,   306,    -1,   308,   309,   310,   311,   312,    -1,   314,
     315,   316,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,    -1,   334,
     335,    -1,   337,   338,   339,   340,   341,   342,   343,   344,
     345,    -1,    -1,   348,   349,   350,    -1,   352,   353,   354,
     355,    -1,   357,   358,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,   374,
     375,   376,   377,    -1,   379,   380,   381,    -1,   383,   384,
     385,   386,    -1,   388,   389,   390,   391,   392,    -1,    -1,
     395,   396,   397,   398,    -1,    -1,   401,   402,    -1,   404,
     405,   406,    -1,   408,    -1,    -1,    -1,   412,   413,   414,
     415,   416,   417,    -1,    -1,    -1,   421,    -1,    -1,   424,
     425,    -1,    -1,     6,     7,     8,     9,    10,    11,   434,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    32,
      -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
     113,    -1,    -1,   116,   117,   118,   119,    -1,   121,   122,
     123,   124,   125,    -1,    -1,   128,   129,   130,   131,   132,
      -1,   134,   135,   136,   137,    -1,   139,   140,   141,    -1,
     143,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,    -1,   162,
     163,   164,    -1,   166,    -1,    -1,   169,   170,   171,   172,
      -1,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
     183,   184,    -1,   186,    -1,   188,   189,   190,    -1,   192,
      -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,
     203,    -1,   205,    -1,   207,   208,   209,   210,    -1,   212,
     213,   214,    -1,   216,   217,   218,   219,   220,   221,    -1,
      -1,   224,    -1,   226,   227,   228,    -1,   230,    -1,   232,
      -1,    -1,    -1,    -1,   237,    -1,   239,   240,   241,   242,
     243,    -1,   245,    -1,   247,    -1,    -1,   250,   251,   252,
      -1,    -1,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,    -1,   268,    -1,   270,   271,   272,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,    -1,
     283,    -1,   285,   286,   287,   288,    -1,    -1,   291,    -1,
      -1,    -1,   295,   296,    -1,    -1,   299,    -1,    -1,   302,
     303,   304,   305,   306,    -1,   308,   309,   310,   311,   312,
      -1,   314,   315,   316,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,    -1,   337,   338,   339,   340,   341,   342,
     343,   344,   345,    -1,    -1,   348,   349,   350,    -1,   352,
     353,   354,   355,    -1,   357,   358,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,    -1,   371,   372,
      -1,   374,   375,   376,   377,    -1,   379,   380,    -1,    -1,
     383,   384,   385,   386,    -1,   388,   389,   390,   391,   392,
      -1,    -1,   395,   396,   397,   398,    -1,    -1,   401,   402,
      -1,   404,   405,   406,    -1,   408,    -1,    -1,    -1,   412,
     413,   414,   415,   416,   417,    -1,    -1,    -1,   421,   422,
      -1,   424,   425,    -1,    -1,   428,   429,   430,   431,    -1,
     433,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,   113,    -1,
      -1,   116,   117,   118,   119,    -1,   121,   122,   123,   124,
     125,    -1,    -1,   128,   129,   130,   131,   132,    -1,   134,
     135,   136,   137,    -1,   139,   140,   141,    -1,   143,    -1,
      -1,    -1,    -1,    -1,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,    -1,   162,   163,   164,
      -1,   166,    -1,    -1,   169,   170,   171,   172,    -1,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,   183,   184,
      -1,   186,    -1,   188,   189,   190,    -1,   192,    -1,   194,
      -1,    -1,    -1,   198,    -1,   200,    -1,   202,   203,    -1,
     205,    -1,   207,   208,   209,   210,    -1,   212,   213,   214,
      -1,   216,   217,   218,   219,   220,   221,    -1,    -1,   224,
      -1,   226,   227,   228,    -1,   230,    -1,   232,    -1,    -1,
      -1,    -1,   237,    -1,   239,   240,   241,   242,   243,    -1,
     245,    -1,   247,    -1,    -1,   250,   251,   252,    -1,    -1,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,    -1,   268,    -1,   270,   271,   272,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,    -1,   283,    -1,
     285,   286,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,
     295,   296,    -1,    -1,   299,    -1,    -1,   302,   303,   304,
     305,   306,    -1,   308,   309,   310,   311,   312,    -1,   314,
     315,   316,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,    -1,   334,
     335,    -1,   337,   338,   339,   340,   341,   342,   343,   344,
     345,    -1,    -1,   348,   349,   350,    -1,   352,   353,   354,
     355,    -1,   357,   358,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,   374,
     375,   376,   377,    -1,   379,   380,   381,    -1,   383,   384,
     385,   386,    -1,   388,   389,   390,   391,   392,    -1,    -1,
     395,   396,   397,   398,    -1,    -1,   401,   402,    -1,   404,
     405,   406,    -1,   408,    -1,    -1,    -1,   412,   413,   414,
     415,   416,   417,    -1,    -1,    -1,   421,   422,    -1,   424,
     425,    -1,    -1,    -1,    -1,   430,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    -1,    29,
      30,    31,    32,    -1,    -1,    35,    36,    37,    38,    -1,
      -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,
     110,    -1,   112,   113,    -1,    -1,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,   125,    -1,    -1,   128,   129,
     130,   131,   132,    -1,   134,   135,   136,   137,    -1,   139,
     140,   141,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,
     150,   151,   152,   153,   154,   155,   156,   157,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,
     170,   171,   172,    -1,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,   183,   184,    -1,   186,    -1,   188,   189,
     190,    -1,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,
     200,    -1,   202,   203,    -1,   205,    -1,   207,   208,   209,
     210,    -1,   212,   213,   214,    -1,   216,   217,   218,   219,
     220,   221,    -1,    -1,   224,    -1,   226,   227,   228,    -1,
     230,    -1,   232,    -1,    -1,    -1,    -1,   237,    -1,   239,
     240,   241,   242,   243,    -1,   245,    -1,   247,    -1,    -1,
     250,   251,   252,    -1,    -1,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,    -1,   268,    -1,
     270,   271,   272,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,    -1,   283,    -1,   285,   286,   287,   288,    -1,
      -1,   291,    -1,    -1,    -1,   295,   296,    -1,    -1,   299,
      -1,    -1,   302,   303,   304,   305,   306,    -1,   308,   309,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,    -1,   337,   338,   339,
     340,   341,   342,   343,   344,   345,    -1,    -1,   348,   349,
     350,    -1,   352,   353,   354,   355,    -1,   357,   358,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,   374,   375,   376,   377,    -1,   379,
     380,    -1,    -1,   383,   384,   385,   386,    -1,   388,   389,
     390,   391,   392,    -1,    -1,   395,   396,   397,   398,    -1,
      -1,   401,   402,    -1,   404,   405,   406,    -1,   408,    -1,
      -1,    -1,   412,   413,   414,   415,   416,   417,    -1,    -1,
      -1,   421,   422,    -1,   424,   425,    -1,    -1,    -1,    -1,
     430,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,   113,    -1,
      -1,   116,   117,   118,   119,    -1,   121,   122,   123,   124,
     125,    -1,    -1,   128,   129,   130,   131,   132,    -1,   134,
     135,   136,   137,    -1,   139,   140,   141,    -1,   143,    -1,
      -1,    -1,    -1,    -1,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,    -1,   160,    -1,   162,   163,   164,
      -1,   166,    -1,    -1,   169,   170,   171,   172,    -1,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,   183,   184,
      -1,   186,    -1,   188,   189,   190,    -1,   192,    -1,   194,
      -1,    -1,    -1,   198,    -1,   200,    -1,   202,   203,    -1,
     205,    -1,   207,   208,   209,   210,    -1,   212,   213,   214,
      -1,   216,   217,   218,   219,   220,   221,    -1,    -1,   224,
      -1,   226,   227,   228,    -1,   230,    -1,   232,    -1,    -1,
      -1,    -1,   237,    -1,   239,   240,   241,   242,   243,    -1,
     245,    -1,   247,    -1,    -1,   250,   251,   252,    -1,    -1,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,    -1,   268,    -1,   270,   271,   272,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,    -1,   283,    -1,
     285,   286,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,
     295,   296,    -1,    -1,   299,    -1,    -1,   302,   303,   304,
     305,   306,    -1,   308,   309,   310,   311,   312,    -1,   314,
     315,   316,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,    -1,   334,
     335,    -1,   337,   338,   339,   340,   341,   342,   343,   344,
     345,    -1,    -1,   348,   349,   350,    -1,   352,   353,   354,
     355,    -1,   357,   358,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,   374,
     375,   376,   377,    -1,   379,   380,    -1,    -1,   383,   384,
     385,   386,    -1,   388,   389,   390,   391,   392,    -1,    -1,
     395,   396,   397,   398,    -1,    -1,   401,   402,    -1,   404,
     405,   406,    -1,   408,    -1,    -1,    -1,   412,   413,   414,
     415,   416,   417,    -1,    -1,    -1,   421,   422,    -1,   424,
     425,    -1,    -1,    -1,    -1,   430,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    -1,    29,
      30,    31,    32,    -1,    -1,    35,    36,    37,    38,    -1,
      -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,
     110,    -1,   112,   113,    -1,    -1,   116,   117,   118,   119,
      -1,   121,   122,   123,   124,   125,    -1,    -1,   128,   129,
     130,   131,   132,    -1,   134,   135,   136,   137,    -1,   139,
     140,   141,    -1,   143,    -1,    -1,    -1,    -1,    -1,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,   169,
     170,   171,   172,    -1,   174,   175,   176,    -1,   178,    -1,
     180,   181,   182,   183,   184,    -1,   186,    -1,   188,   189,
     190,    -1,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,
     200,    -1,   202,   203,    -1,   205,    -1,   207,   208,   209,
     210,    -1,   212,   213,   214,    -1,   216,   217,   218,   219,
     220,   221,    -1,    -1,   224,    -1,   226,   227,   228,    -1,
     230,    -1,   232,    -1,    -1,    -1,    -1,   237,    -1,   239,
     240,   241,   242,   243,    -1,   245,    -1,   247,    -1,    -1,
     250,   251,   252,    -1,    -1,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,    -1,   268,    -1,
     270,   271,   272,   273,   274,   275,   276,   277,   278,    -1,
     280,   281,    -1,   283,    -1,   285,   286,   287,   288,    -1,
      -1,   291,    -1,    -1,    -1,   295,   296,    -1,    -1,   299,
      -1,    -1,   302,   303,   304,   305,   306,    -1,   308,   309,
     310,   311,   312,    -1,   314,   315,   316,   317,   318,   319,
     320,   321,   322,    -1,   324,   325,   326,   327,   328,   329,
     330,   331,   332,    -1,   334,   335,    -1,   337,   338,   339,
     340,   341,   342,   343,   344,   345,    -1,    -1,   348,   349,
     350,    -1,   352,   353,   354,   355,    -1,   357,   358,    -1,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
      -1,   371,   372,    -1,   374,   375,   376,   377,    -1,   379,
     380,    -1,    -1,   383,   384,   385,   386,    -1,   388,   389,
     390,   391,   392,    -1,    -1,   395,   396,   397,   398,    -1,
      -1,   401,   402,    -1,   404,   405,   406,    -1,   408,    -1,
      -1,    -1,   412,   413,   414,   415,   416,   417,    -1,    -1,
      -1,   421,   422,    -1,   424,   425,    -1,    -1,    -1,    -1,
     430,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,   113,    -1,
      -1,   116,   117,   118,   119,    -1,   121,   122,   123,   124,
     125,    -1,    -1,   128,   129,   130,   131,   132,    -1,   134,
     135,   136,   137,    -1,   139,   140,   141,    -1,   143,    -1,
      -1,    -1,    -1,    -1,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,    -1,   162,   163,   164,
      -1,   166,    -1,    -1,   169,   170,   171,   172,    -1,   174,
     175,   176,    -1,   178,    -1,   180,   181,   182,   183,   184,
      -1,   186,    -1,   188,   189,   190,    -1,   192,    -1,   194,
      -1,    -1,    -1,   198,    -1,   200,    -1,   202,   203,    -1,
     205,    -1,   207,   208,   209,   210,    -1,   212,   213,   214,
      -1,   216,   217,   218,   219,   220,   221,    -1,    -1,   224,
      -1,   226,   227,   228,    -1,   230,    -1,   232,    -1,    -1,
      -1,    -1,   237,    -1,   239,   240,   241,   242,   243,    -1,
     245,    -1,   247,    -1,    -1,   250,   251,   252,    -1,    -1,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,    -1,   268,    -1,   270,   271,   272,   273,   274,
     275,   276,   277,   278,    -1,   280,   281,    -1,   283,    -1,
     285,   286,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,
     295,   296,    -1,    -1,   299,    -1,    -1,   302,   303,   304,
     305,   306,    -1,   308,   309,   310,   311,   312,    -1,   314,
     315,   316,   317,   318,   319,   320,   321,   322,    -1,   324,
     325,   326,   327,   328,   329,   330,   331,   332,    -1,   334,
     335,    -1,   337,   338,   339,   340,   341,   342,   343,   344,
     345,    -1,    -1,   348,   349,   350,    -1,   352,   353,   354,
     355,    -1,   357,   358,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,    -1,   371,   372,    -1,   374,
     375,   376,   377,    -1,   379,   380,    -1,    -1,   383,   384,
     385,   386,    -1,   388,   389,   390,   391,   392,    -1,    -1,
     395,   396,   397,   398,    -1,    -1,   401,   402,    -1,   404,
     405,   406,    -1,   408,    -1,    -1,    -1,   412,   413,   414,
     415,   416,   417,    -1,    -1,    -1,   421,    -1,    -1,   424,
      -1,     4,   427,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    17,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    32,
      -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
     113,    -1,    -1,   116,   117,   118,   119,    -1,   121,   122,
     123,   124,   125,    -1,    -1,   128,   129,   130,   131,   132,
      -1,   134,   135,   136,   137,    -1,   139,   140,   141,    -1,
     143,    -1,    -1,    -1,    -1,    -1,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,    -1,   162,
     163,   164,    -1,   166,    -1,    -1,   169,   170,   171,   172,
      -1,   174,   175,   176,    -1,   178,    -1,   180,   181,   182,
     183,   184,    -1,   186,    -1,   188,   189,   190,    -1,   192,
      -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,
     203,    -1,   205,    -1,   207,   208,   209,   210,    -1,   212,
     213,   214,    -1,   216,   217,   218,   219,   220,   221,    -1,
      -1,   224,    -1,   226,   227,   228,    -1,   230,    -1,   232,
      -1,    -1,    -1,    -1,   237,    -1,   239,   240,   241,   242,
     243,    -1,   245,    -1,   247,    -1,    -1,   250,   251,   252,
      -1,    -1,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,    -1,   268,    -1,   270,   271,   272,
     273,   274,   275,   276,   277,   278,    -1,   280,   281,    -1,
     283,    -1,   285,   286,   287,   288,    -1,    -1,   291,    -1,
      -1,    -1,   295,   296,    -1,    -1,   299,    -1,    -1,   302,
     303,   304,   305,   306,    -1,   308,   309,   310,   311,   312,
      -1,   314,   315,   316,   317,   318,   319,   320,   321,   322,
      -1,   324,   325,   326,   327,   328,   329,   330,   331,   332,
      -1,   334,   335,    -1,   337,   338,   339,   340,   341,   342,
     343,   344,   345,    -1,    -1,   348,   349,   350,    -1,   352,
     353,   354,   355,    -1,   357,   358,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,   368,   369,    -1,   371,   372,
      -1,   374,   375,   376,   377,    -1,   379,   380,    -1,    -1,
     383,   384,   385,   386,    -1,   388,   389,   390,   391,   392,
      -1,    -1,   395,   396,   397,   398,    -1,    -1,   401,   402,
      -1,   404,   405,   406,    -1,   408,    -1,    -1,    -1,   412,
     413,   414,   415,   416,   417,     6,     7,     8,   421,    10,
      11,   424,    13,    14,    15,    -1,    -1,    -1,    19,    20,
      -1,    22,    23,    24,    25,    26,    27,    -1,    29,    30,
      31,    -1,    -1,    -1,    35,    36,    37,    38,    -1,    40,
      -1,    42,    43,    44,    45,    46,    47,    48,    49,    -1,
      -1,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,
      -1,    -1,   103,   104,   105,   106,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,    -1,    -1,
      -1,    -1,    -1,    -1,   125,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   136,    -1,    -1,    -1,    -1,
      -1,   142,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   154,   155,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   183,    -1,    -1,   186,    -1,    -1,    -1,   190,
      -1,    -1,    -1,    -1,   195,    -1,   197,    -1,    -1,    -1,
      -1,    -1,   203,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     211,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   223,   224,    -1,    -1,    -1,    -1,    -1,   230,
      -1,   232,    -1,    -1,   235,   236,    -1,   238,    -1,    -1,
      -1,    -1,    -1,    -1,   245,   246,    -1,   248,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   266,   267,   268,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   277,    -1,    -1,    -1,
      -1,   282,    -1,    -1,   285,   286,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   299,   300,
     301,   302,    -1,    -1,    -1,    -1,    -1,   308,   309,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   320,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   336,    -1,    -1,   339,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   353,    -1,    -1,   356,    -1,   358,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   368,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,   380,
      -1,    -1,    -1,   384,    -1,   386,    -1,    -1,    -1,    -1,
      -1,    -1,   393,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   405,    -1,   407,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     421,    -1,    -1,   424,    -1,   426,     6,     7,     8,    -1,
      10,    11,    -1,    13,    14,    15,    -1,    -1,    -1,    19,
      20,    -1,    22,    23,    24,    25,    26,    27,    -1,    29,
      30,    31,    -1,    -1,    -1,    35,    36,    37,    38,    -1,
      40,    -1,    42,    43,    44,    45,    46,    47,    48,    49,
      -1,    -1,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    99,
      -1,    -1,    -1,   103,   104,   105,   106,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,    -1,
      -1,    -1,    -1,    -1,    -1,   125,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   136,    -1,    -1,    -1,
      -1,    -1,   142,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   154,   155,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   183,    -1,    -1,   186,    -1,    -1,    -1,
     190,    -1,    -1,    -1,    -1,   195,    -1,   197,    -1,    -1,
      -1,    -1,    -1,   203,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   211,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   223,   224,    -1,    -1,    -1,    -1,    -1,
     230,    -1,   232,    -1,    -1,   235,   236,    -1,   238,    -1,
      -1,    -1,    -1,    -1,    -1,   245,   246,    -1,   248,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   266,   267,   268,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   277,    -1,    -1,
      -1,    -1,   282,    -1,    -1,   285,   286,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   299,
     300,   301,   302,    -1,    -1,    -1,    -1,    -1,   308,   309,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     320,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   336,    -1,    -1,   339,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   353,    -1,    -1,   356,    -1,   358,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   368,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,
     380,    -1,    -1,    -1,   384,    -1,   386,    -1,    -1,    -1,
      -1,    -1,    -1,   393,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   405,    -1,   407,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   421,    -1,    -1,   424,    -1,   426,     5,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    -1,    35,    36,    37,
      38,    39,    40,    -1,    42,    43,    44,    -1,    46,    47,
      48,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,    -1,
     108,   109,   110,    -1,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,   157,
     158,   159,   160,    -1,   162,   163,   164,   165,   166,   167,
     168,   169,   170,   171,   172,   173,   174,   175,   176,   177,
     178,   179,   180,   181,   182,   183,   184,    -1,   186,   187,
     188,   189,   190,   191,   192,   193,   194,   195,   196,   197,
     198,    -1,   200,   201,   202,   203,   204,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   219,   220,   221,   222,   223,   224,   225,   226,   227,
     228,   229,   230,   231,   232,   233,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   247,
     248,   249,   250,   251,   252,    -1,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,   269,   270,   271,   272,   273,   274,   275,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   285,   286,   287,
     288,   289,   290,   291,   292,   293,   294,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,    -1,
     308,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,    -1,   347,
     348,   349,   350,   351,   352,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,   363,   364,   365,   366,   367,
     368,   369,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   381,   382,   383,   384,   385,   386,   387,
     388,   389,   390,   391,   392,   393,   394,   395,   396,   397,
     398,   399,   400,   401,   402,    -1,    -1,   405,   406,   407,
     408,    -1,   410,   411,   412,   413,   414,   415,   416,   417,
      -1,    -1,    -1,   421,    -1,    -1,   424,     5,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    -1,    35,    36,    37,
      38,    39,    40,    -1,    42,    43,    44,    -1,    46,    47,
      48,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
      -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,
     128,   129,   130,   131,   132,    -1,   134,   135,    -1,   137,
      -1,   139,   140,   141,   142,   143,    -1,    -1,    -1,    -1,
      -1,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,
      -1,   169,   170,   171,   172,    -1,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,    -1,   184,    -1,    -1,    -1,
     188,   189,   190,    -1,   192,    -1,   194,   195,    -1,   197,
     198,    -1,   200,    -1,   202,    -1,    -1,   205,    -1,   207,
     208,   209,   210,   211,   212,   213,   214,   215,   216,   217,
     218,   219,   220,   221,    -1,   223,   224,    -1,   226,   227,
     228,   229,   230,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,    -1,    -1,   246,   247,
     248,    -1,   250,   251,   252,    -1,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,    -1,   270,   271,   272,   273,   274,   275,   276,    -1,
     278,    -1,   280,   281,   282,   283,    -1,    -1,   286,   287,
     288,    -1,    -1,   291,    -1,    -1,    -1,   295,   296,    -1,
      -1,   299,   300,   301,    -1,   303,   304,   305,   306,    -1,
      -1,    -1,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,   336,   337,
     338,    -1,   340,   341,   342,   343,   344,   345,    -1,    -1,
     348,   349,   350,    -1,   352,   353,   354,   355,   356,   357,
     358,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
      -1,   369,    -1,   371,   372,    -1,   374,   375,   376,   377,
      -1,   379,   380,    -1,    -1,   383,    -1,   385,    -1,    -1,
     388,   389,   390,   391,   392,    -1,    -1,   395,   396,   397,
     398,    -1,    -1,   401,   402,    -1,    -1,   405,   406,   407,
     408,    -1,    -1,    -1,   412,   413,   414,   415,   416,   417,
      -1,    -1,    -1,   421,    -1,    -1,   424,     5,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    -1,    35,    36,    37,
      38,    39,    40,    -1,    42,    43,    44,    -1,    46,    47,
      48,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
      -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,
     128,   129,   130,   131,   132,    -1,   134,   135,    -1,   137,
      -1,   139,   140,   141,   142,   143,    -1,    -1,    -1,    -1,
      -1,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,
      -1,   169,   170,   171,   172,    -1,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,    -1,   184,    -1,    -1,    -1,
     188,   189,   190,    -1,   192,    -1,   194,   195,    -1,   197,
     198,    -1,   200,    -1,   202,    -1,    -1,   205,    -1,   207,
     208,   209,   210,   211,   212,   213,   214,    -1,   216,   217,
     218,   219,   220,   221,    -1,   223,    -1,    -1,   226,   227,
     228,   229,   230,    -1,   232,    -1,    -1,   235,   236,   237,
     238,   239,   240,   241,   242,   243,    -1,    -1,   246,   247,
     248,    -1,   250,   251,   252,    -1,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,   267,
     268,    -1,   270,   271,   272,   273,   274,   275,   276,    -1,
     278,    -1,   280,   281,   282,   283,    -1,    -1,   286,   287,
     288,    -1,    -1,   291,    -1,    -1,    -1,   295,   296,    -1,
      -1,    -1,   300,   301,    -1,   303,   304,   305,   306,    -1,
      -1,    -1,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,   336,   337,
     338,    -1,   340,   341,   342,   343,   344,   345,    -1,    -1,
     348,   349,   350,    -1,   352,   353,   354,   355,   356,   357,
     358,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
      -1,   369,    -1,   371,   372,    -1,   374,   375,   376,   377,
      -1,   379,   380,    -1,    -1,   383,    -1,   385,    -1,    -1,
     388,   389,   390,   391,   392,    -1,    -1,   395,   396,   397,
     398,    -1,    -1,   401,   402,    -1,    -1,   405,   406,   407,
     408,    -1,    -1,    -1,   412,   413,   414,   415,   416,   417,
      -1,    -1,    -1,   421,    -1,    -1,   424,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    41,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,   113,    -1,    -1,   116,   117,   118,
     119,    -1,   121,   122,   123,   124,   125,    -1,    -1,   128,
     129,   130,   131,   132,    -1,   134,   135,   136,   137,    -1,
     139,   140,   141,    -1,   143,    -1,    -1,    -1,    -1,    -1,
     149,   150,   151,   152,   153,   154,   155,   156,    -1,   158,
      -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,
     169,   170,   171,   172,    -1,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,   183,   184,    -1,   186,    -1,   188,
     189,   190,    -1,   192,    -1,   194,    -1,    -1,    -1,   198,
      -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,   208,
     209,   210,    -1,   212,   213,   214,    -1,   216,   217,   218,
     219,   220,   221,    -1,    -1,   224,    -1,   226,   227,   228,
      -1,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,    -1,
     239,   240,   241,   242,   243,    -1,   245,    -1,   247,    -1,
      -1,   250,   251,   252,    -1,    -1,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,    -1,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,    -1,   283,    -1,   285,   286,   287,   288,
      -1,    -1,   291,   292,    -1,    -1,   295,   296,    -1,    -1,
     299,    -1,    -1,   302,   303,   304,   305,   306,    -1,   308,
     309,   310,   311,   312,    -1,   314,   315,   316,   317,   318,
     319,   320,   321,   322,    -1,   324,   325,   326,   327,   328,
     329,   330,   331,   332,    -1,   334,   335,    -1,   337,   338,
     339,   340,   341,   342,   343,   344,   345,    -1,    -1,   348,
     349,   350,    -1,   352,   353,   354,   355,    -1,   357,   358,
      -1,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,    -1,   371,   372,   373,   374,   375,   376,   377,    -1,
     379,   380,    -1,    -1,   383,   384,   385,   386,    -1,   388,
     389,   390,   391,   392,    -1,    -1,   395,   396,   397,   398,
      -1,    -1,   401,   402,    -1,   404,   405,   406,    -1,   408,
      -1,    -1,    -1,   412,   413,   414,   415,   416,   417,    -1,
      -1,    -1,   421,    -1,    -1,   424,   425,     6,     7,     8,
       9,    10,    11,    12,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,   113,    -1,    -1,   116,   117,   118,
     119,    -1,   121,   122,   123,   124,   125,    -1,    -1,   128,
     129,   130,   131,   132,    -1,   134,   135,   136,   137,    -1,
     139,   140,   141,    -1,   143,    -1,    -1,    -1,    -1,    -1,
     149,   150,   151,   152,   153,   154,   155,   156,   157,   158,
      -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,
     169,   170,   171,   172,    -1,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,   183,   184,    -1,   186,    -1,   188,
     189,   190,    -1,   192,    -1,   194,    -1,    -1,    -1,   198,
      -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,   208,
     209,   210,    -1,   212,   213,   214,    -1,   216,   217,   218,
     219,   220,   221,    -1,    -1,   224,    -1,   226,   227,   228,
      -1,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,    -1,
     239,   240,   241,   242,   243,    -1,   245,    -1,   247,    -1,
      -1,   250,   251,   252,    -1,    -1,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,    -1,   268,
      -1,   270,   271,   272,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,    -1,   283,    -1,   285,   286,   287,   288,
      -1,    -1,   291,    -1,    -1,    -1,   295,   296,    -1,    -1,
     299,    -1,    -1,   302,   303,   304,   305,   306,    -1,   308,
     309,   310,   311,   312,    -1,   314,   315,   316,   317,   318,
     319,   320,   321,   322,    -1,   324,   325,   326,   327,   328,
     329,   330,   331,   332,    -1,   334,   335,    -1,   337,   338,
     339,   340,   341,   342,   343,   344,   345,    -1,    -1,   348,
     349,   350,    -1,   352,   353,   354,   355,    -1,   357,   358,
      -1,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,   374,   375,   376,   377,    -1,
     379,   380,    -1,    -1,   383,   384,   385,   386,    -1,   388,
     389,   390,   391,   392,    -1,    -1,   395,   396,   397,   398,
      -1,    -1,   401,   402,    -1,   404,   405,   406,    -1,   408,
      -1,    -1,    -1,   412,   413,   414,   415,   416,   417,    -1,
      -1,    -1,   421,    -1,    -1,   424,   425,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,   113,    -1,    -1,   116,   117,   118,
     119,    -1,   121,   122,   123,   124,   125,    -1,    -1,   128,
     129,   130,   131,   132,    -1,   134,   135,   136,   137,    -1,
     139,   140,   141,    -1,   143,    -1,    -1,    -1,    -1,    -1,
     149,   150,   151,   152,   153,   154,   155,   156,   157,   158,
      -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,
     169,   170,   171,   172,    -1,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,   183,   184,    -1,   186,    -1,   188,
     189,   190,    -1,   192,    -1,   194,    -1,    -1,    -1,   198,
      -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,   208,
     209,   210,    -1,   212,   213,   214,    -1,   216,   217,   218,
     219,   220,   221,    -1,    -1,   224,    -1,   226,   227,   228,
      -1,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,    -1,
     239,   240,   241,   242,   243,    -1,   245,    -1,   247,    -1,
      -1,   250,   251,   252,    -1,    -1,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,    -1,   268,
      -1,   270,   271,   272,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,    -1,   283,    -1,   285,   286,   287,   288,
      -1,    -1,   291,    -1,    -1,    -1,   295,   296,    -1,    -1,
     299,    -1,    -1,   302,   303,   304,   305,   306,    -1,   308,
     309,   310,   311,   312,    -1,   314,   315,   316,   317,   318,
     319,   320,   321,   322,    -1,   324,   325,   326,   327,   328,
     329,   330,   331,   332,    -1,   334,   335,    -1,   337,   338,
     339,   340,   341,   342,   343,   344,   345,    -1,    -1,   348,
     349,   350,    -1,   352,   353,   354,   355,    -1,   357,   358,
      -1,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,   374,   375,   376,   377,    -1,
     379,   380,    -1,    -1,   383,   384,   385,   386,    -1,   388,
     389,   390,   391,   392,    -1,    -1,   395,   396,   397,   398,
      -1,    -1,   401,   402,    -1,   404,   405,   406,    -1,   408,
      -1,    -1,    -1,   412,   413,   414,   415,   416,   417,    -1,
      -1,    -1,   421,    -1,    -1,   424,   425,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    17,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,   113,    -1,    -1,   116,   117,   118,
     119,    -1,   121,   122,   123,   124,   125,    -1,    -1,   128,
     129,   130,   131,   132,    -1,   134,   135,   136,   137,    -1,
     139,   140,   141,    -1,   143,    -1,    -1,    -1,    -1,    -1,
     149,   150,   151,   152,   153,   154,   155,   156,    -1,   158,
      -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,
     169,   170,   171,   172,    -1,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,   183,   184,    -1,   186,    -1,   188,
     189,   190,    -1,   192,    -1,   194,    -1,    -1,    -1,   198,
      -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,   208,
     209,   210,    -1,   212,   213,   214,    -1,   216,   217,   218,
     219,   220,   221,    -1,    -1,   224,    -1,   226,   227,   228,
      -1,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,    -1,
     239,   240,   241,   242,   243,    -1,   245,    -1,   247,    -1,
      -1,   250,   251,   252,    -1,    -1,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,    -1,   268,
      -1,   270,   271,   272,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,    -1,   283,    -1,   285,   286,   287,   288,
      -1,    -1,   291,    -1,    -1,    -1,   295,   296,    -1,    -1,
     299,    -1,    -1,   302,   303,   304,   305,   306,    -1,   308,
     309,   310,   311,   312,    -1,   314,   315,   316,   317,   318,
     319,   320,   321,   322,    -1,   324,   325,   326,   327,   328,
     329,   330,   331,   332,    -1,   334,   335,    -1,   337,   338,
     339,   340,   341,   342,   343,   344,   345,    -1,    -1,   348,
     349,   350,    -1,   352,   353,   354,   355,    -1,   357,   358,
      -1,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,   374,   375,   376,   377,    -1,
     379,   380,    -1,    -1,   383,   384,   385,   386,    -1,   388,
     389,   390,   391,   392,    -1,    -1,   395,   396,   397,   398,
      -1,    -1,   401,   402,    -1,   404,   405,   406,    -1,   408,
      -1,    -1,    -1,   412,   413,   414,   415,   416,   417,    -1,
      -1,    -1,   421,    -1,    -1,   424,   425,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,   113,    -1,    -1,   116,   117,   118,
     119,    -1,   121,   122,   123,   124,   125,    -1,    -1,   128,
     129,   130,   131,   132,    -1,   134,   135,   136,   137,    -1,
     139,   140,   141,    -1,   143,    -1,    -1,    -1,    -1,    -1,
     149,   150,   151,   152,   153,   154,   155,   156,    -1,   158,
      -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,
     169,   170,   171,   172,    -1,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,   183,   184,    -1,   186,    -1,   188,
     189,   190,    -1,   192,    -1,   194,    -1,    -1,    -1,   198,
      -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,   208,
     209,   210,    -1,   212,   213,   214,    -1,   216,   217,   218,
     219,   220,   221,    -1,    -1,   224,    -1,   226,   227,   228,
      -1,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,    -1,
     239,   240,   241,   242,   243,    -1,   245,    -1,   247,    -1,
      -1,   250,   251,   252,    -1,    -1,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,    -1,   268,
      -1,   270,   271,   272,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,    -1,   283,    -1,   285,   286,   287,   288,
      -1,    -1,   291,    -1,    -1,    -1,   295,   296,    -1,    -1,
     299,    -1,    -1,   302,   303,   304,   305,   306,    -1,   308,
     309,   310,   311,   312,    -1,   314,   315,   316,   317,   318,
     319,   320,   321,   322,    -1,   324,   325,   326,   327,   328,
     329,   330,   331,   332,    -1,   334,   335,    -1,   337,   338,
     339,   340,   341,   342,   343,   344,   345,    -1,    -1,   348,
     349,   350,    -1,   352,   353,   354,   355,    -1,   357,   358,
      -1,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,   374,   375,   376,   377,    -1,
     379,   380,    -1,    -1,   383,   384,   385,   386,    -1,   388,
     389,   390,   391,   392,    -1,    -1,   395,   396,   397,   398,
      -1,    -1,   401,   402,    -1,   404,   405,   406,    -1,   408,
      -1,    -1,    -1,   412,   413,   414,   415,   416,   417,    -1,
      -1,    -1,   421,    -1,    -1,   424,   425,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,   113,    -1,    -1,   116,   117,   118,
     119,    -1,   121,   122,   123,   124,   125,    -1,    -1,   128,
     129,   130,   131,   132,    -1,   134,   135,   136,   137,    -1,
     139,   140,   141,    -1,   143,    -1,    -1,    -1,    -1,    -1,
     149,   150,   151,   152,   153,   154,   155,   156,    -1,   158,
      -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,
     169,   170,   171,   172,    -1,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,   183,   184,    -1,   186,    -1,   188,
     189,   190,    -1,   192,    -1,   194,    -1,    -1,    -1,   198,
      -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,   208,
     209,   210,    -1,   212,   213,   214,    -1,   216,   217,   218,
     219,   220,   221,    -1,    -1,   224,    -1,   226,   227,   228,
      -1,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,    -1,
     239,   240,   241,   242,   243,    -1,   245,    -1,   247,    -1,
      -1,   250,   251,   252,    -1,    -1,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,    -1,   268,
      -1,   270,   271,   272,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,    -1,   283,    -1,   285,   286,   287,   288,
      -1,    -1,   291,    -1,    -1,    -1,   295,   296,    -1,    -1,
     299,    -1,    -1,   302,   303,   304,   305,   306,    -1,   308,
     309,   310,   311,   312,    -1,   314,   315,   316,   317,   318,
     319,   320,   321,   322,    -1,   324,   325,   326,   327,   328,
     329,   330,   331,   332,    -1,   334,   335,    -1,   337,   338,
     339,   340,   341,   342,   343,   344,   345,    -1,    -1,   348,
     349,   350,    -1,   352,   353,   354,   355,    -1,   357,   358,
      -1,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,   374,   375,   376,   377,    -1,
     379,   380,    -1,    -1,   383,   384,   385,   386,    -1,   388,
     389,   390,   391,   392,    -1,    -1,   395,   396,   397,   398,
      -1,    -1,   401,   402,    -1,   404,   405,   406,    -1,   408,
      -1,    -1,    -1,   412,   413,   414,   415,   416,   417,    -1,
      -1,    -1,   421,    -1,    -1,   424,   425,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,   113,    -1,    -1,   116,   117,   118,
     119,    -1,   121,   122,   123,   124,   125,    -1,    -1,   128,
     129,   130,   131,   132,    -1,   134,   135,   136,   137,    -1,
     139,   140,   141,    -1,   143,    -1,    -1,    -1,    -1,    -1,
     149,   150,   151,   152,   153,   154,   155,   156,    -1,   158,
      -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,    -1,
     169,   170,   171,   172,    -1,   174,   175,   176,    -1,   178,
      -1,   180,   181,   182,   183,   184,    -1,   186,    -1,   188,
     189,   190,    -1,   192,    -1,   194,    -1,    -1,    -1,   198,
      -1,   200,    -1,   202,   203,    -1,   205,    -1,   207,   208,
     209,   210,    -1,   212,   213,   214,    -1,   216,   217,   218,
     219,   220,   221,    -1,    -1,   224,    -1,   226,   227,   228,
      -1,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,    -1,
     239,   240,   241,   242,   243,    -1,   245,    -1,   247,    -1,
      -1,   250,   251,   252,    -1,    -1,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,    -1,   268,
      -1,   270,   271,   272,   273,   274,   275,   276,   277,   278,
      -1,   280,   281,    -1,   283,    -1,   285,   286,   287,   288,
      -1,    -1,   291,    -1,    -1,    -1,   295,   296,    -1,    -1,
     299,    -1,    -1,   302,   303,   304,   305,   306,    -1,   308,
     309,   310,   311,   312,    -1,   314,   315,   316,   317,   318,
     319,   320,   321,   322,    -1,   324,   325,   326,   327,   328,
     329,   330,   331,   332,    -1,   334,   335,    -1,   337,   338,
     339,   340,   341,   342,   343,   344,   345,    -1,    -1,   348,
     349,   350,    -1,   352,   353,   354,   355,    -1,   357,   358,
      -1,   360,   361,   362,   363,   364,   365,   366,   367,   368,
     369,    -1,   371,   372,    -1,   374,   375,   376,   377,    -1,
     379,   380,    -1,    -1,   383,   384,   385,   386,    -1,   388,
     389,   390,   391,   392,    -1,    -1,   395,   396,   397,   398,
      -1,    -1,   401,   402,    -1,   404,   405,   406,    -1,   408,
      -1,    -1,    -1,   412,   413,   414,   415,   416,   417,    -1,
      -1,    -1,   421,    -1,    -1,   424,   425,     5,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    -1,    35,    36,    37,
      38,    39,    40,    -1,    42,    43,    44,    -1,    46,    47,
      48,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,   107,
      -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,
     128,   129,   130,   131,   132,    -1,   134,   135,    -1,   137,
      -1,   139,   140,   141,    -1,   143,    -1,    -1,    -1,    -1,
      -1,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,
      -1,   169,   170,   171,   172,    -1,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,    -1,   184,    -1,    -1,    -1,
     188,   189,   190,    -1,   192,    -1,   194,    -1,    -1,    -1,
     198,    -1,   200,    -1,   202,    -1,    -1,   205,    -1,   207,
     208,   209,   210,    -1,   212,   213,   214,   215,   216,   217,
     218,   219,   220,   221,    -1,    -1,   224,    -1,   226,   227,
     228,   229,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,
      -1,   239,   240,   241,   242,   243,    -1,    -1,    -1,   247,
      -1,    -1,   250,   251,   252,    -1,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,    -1,
     268,    -1,   270,   271,   272,   273,   274,   275,   276,    -1,
     278,    -1,   280,   281,    -1,   283,    -1,    -1,   286,   287,
     288,    -1,    -1,   291,    -1,    -1,    -1,   295,   296,    -1,
      -1,   299,    -1,    -1,    -1,   303,   304,   305,   306,    -1,
      -1,    -1,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,    -1,   337,
     338,    -1,   340,   341,   342,   343,   344,   345,    -1,    -1,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,   357,
     358,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
      -1,   369,    -1,   371,   372,    -1,   374,   375,   376,   377,
      -1,   379,   380,    -1,    -1,   383,    -1,   385,    -1,    -1,
     388,   389,   390,   391,   392,    -1,    -1,   395,   396,   397,
     398,    -1,    -1,   401,   402,    -1,    -1,   405,   406,    -1,
     408,    -1,    -1,    -1,   412,   413,   414,   415,   416,   417,
      -1,    -1,    -1,   421,    -1,    -1,   424,     5,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    -1,    35,    36,    37,
      38,    39,    40,    -1,    42,    43,    44,    -1,    46,    47,
      48,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,   107,
      -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,
     128,   129,   130,   131,   132,    -1,   134,   135,    -1,   137,
      -1,   139,   140,   141,    -1,   143,    -1,    -1,    -1,    -1,
      -1,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,
      -1,   169,   170,   171,   172,    -1,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,    -1,   184,    -1,    -1,    -1,
     188,   189,   190,    -1,   192,    -1,   194,    -1,    -1,    -1,
     198,    -1,   200,    -1,   202,    -1,    -1,   205,    -1,   207,
     208,   209,   210,    -1,   212,   213,   214,    -1,   216,   217,
     218,   219,   220,   221,    -1,    -1,    -1,    -1,   226,   227,
     228,   229,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,
      -1,   239,   240,   241,   242,   243,    -1,    -1,    -1,   247,
      -1,    -1,   250,   251,   252,    -1,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,    -1,
     268,    -1,   270,   271,   272,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,    -1,   283,    -1,    -1,   286,   287,
     288,    -1,    -1,   291,    -1,    -1,    -1,   295,   296,    -1,
      -1,    -1,    -1,    -1,    -1,   303,   304,   305,   306,    -1,
      -1,    -1,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,    -1,   337,
     338,    -1,   340,   341,   342,   343,   344,   345,    -1,    -1,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,   357,
     358,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
      -1,   369,    -1,   371,   372,    -1,   374,   375,   376,   377,
      -1,   379,   380,    -1,    -1,   383,    -1,   385,    -1,    -1,
     388,   389,   390,   391,   392,    -1,    -1,   395,   396,   397,
     398,    -1,    -1,   401,   402,    -1,    -1,   405,   406,    -1,
     408,    -1,    -1,    -1,   412,   413,   414,   415,   416,   417,
      -1,    -1,    -1,   421,    -1,    -1,   424,     5,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    -1,    35,    36,    37,
      38,    39,    40,    -1,    42,    43,    44,    -1,    46,    47,
      48,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,   107,
      -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,
     128,   129,   130,   131,   132,    -1,   134,   135,    -1,   137,
      -1,   139,   140,   141,    -1,   143,    -1,    -1,    -1,    -1,
      -1,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,
      -1,   169,   170,   171,   172,    -1,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,    -1,   184,    -1,    -1,    -1,
     188,   189,   190,    -1,   192,    -1,   194,    -1,    -1,    -1,
     198,    -1,   200,    -1,   202,    -1,    -1,   205,    -1,   207,
     208,   209,   210,    -1,   212,   213,   214,    -1,   216,   217,
     218,   219,   220,   221,    -1,    -1,    -1,    -1,   226,   227,
     228,   229,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,
      -1,   239,   240,   241,   242,   243,    -1,    -1,    -1,   247,
      -1,    -1,   250,   251,   252,    -1,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,    -1,
     268,    -1,   270,   271,   272,   273,   274,   275,   276,   277,
     278,    -1,   280,   281,    -1,   283,    -1,    -1,   286,   287,
     288,    -1,    -1,   291,    -1,    -1,    -1,   295,   296,    -1,
      -1,    -1,    -1,    -1,    -1,   303,   304,   305,   306,    -1,
      -1,    -1,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,    -1,   337,
     338,    -1,   340,   341,   342,   343,   344,   345,    -1,    -1,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,   357,
     358,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
      -1,   369,    -1,   371,   372,    -1,   374,   375,   376,   377,
      -1,   379,   380,    -1,    -1,   383,    -1,   385,    -1,    -1,
     388,   389,   390,   391,   392,    -1,    -1,   395,   396,   397,
     398,    -1,    -1,   401,   402,    -1,    -1,   405,   406,    -1,
     408,    -1,    -1,    -1,   412,   413,   414,   415,   416,   417,
      -1,    -1,    -1,   421,    -1,    -1,   424,     5,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    -1,    35,    36,    37,
      38,    39,    40,    -1,    42,    43,    44,    -1,    46,    47,
      48,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,   107,
      -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,
     128,   129,   130,   131,   132,    -1,   134,   135,    -1,   137,
      -1,   139,   140,   141,    -1,   143,    -1,    -1,    -1,    -1,
      -1,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,
      -1,   169,   170,   171,   172,    -1,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,    -1,   184,    -1,    -1,    -1,
     188,   189,   190,    -1,   192,    -1,   194,    -1,    -1,    -1,
     198,    -1,   200,    -1,   202,    -1,    -1,   205,    -1,   207,
     208,   209,   210,    -1,   212,   213,   214,    -1,   216,   217,
     218,   219,   220,   221,    -1,    -1,    -1,    -1,   226,   227,
     228,   229,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,
      -1,   239,   240,   241,   242,   243,    -1,    -1,    -1,   247,
      -1,    -1,   250,   251,   252,    -1,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,    -1,
     268,    -1,   270,   271,   272,   273,   274,   275,   276,    -1,
     278,    -1,   280,   281,    -1,   283,   284,    -1,   286,   287,
     288,    -1,    -1,   291,    -1,    -1,    -1,   295,   296,    -1,
      -1,    -1,    -1,    -1,    -1,   303,   304,   305,   306,    -1,
      -1,    -1,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,    -1,   337,
     338,    -1,   340,   341,   342,   343,   344,   345,    -1,    -1,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,   357,
     358,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
      -1,   369,    -1,   371,   372,    -1,   374,   375,   376,   377,
      -1,   379,   380,    -1,    -1,   383,    -1,   385,    -1,    -1,
     388,   389,   390,   391,   392,    -1,    -1,   395,   396,   397,
     398,    -1,    -1,   401,   402,    -1,    -1,   405,   406,    -1,
     408,    -1,    -1,    -1,   412,   413,   414,   415,   416,   417,
      -1,    -1,    -1,   421,    -1,    -1,   424,     5,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    -1,    35,    36,    37,
      38,    39,    40,    -1,    42,    43,    44,    -1,    46,    47,
      48,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,   107,
      -1,   109,   110,    -1,   112,   113,    -1,    -1,   116,   117,
     118,   119,    -1,   121,   122,   123,   124,    -1,    -1,    -1,
     128,   129,   130,   131,   132,    -1,   134,   135,    -1,   137,
      -1,   139,   140,   141,    -1,   143,    -1,    -1,    -1,    -1,
      -1,   149,   150,   151,   152,   153,   154,   155,   156,    -1,
     158,    -1,   160,    -1,   162,   163,   164,    -1,   166,    -1,
      -1,   169,   170,   171,   172,    -1,   174,   175,   176,    -1,
     178,    -1,   180,   181,   182,    -1,   184,    -1,    -1,    -1,
     188,   189,   190,    -1,   192,    -1,   194,    -1,    -1,    -1,
     198,    -1,   200,    -1,   202,    -1,    -1,   205,    -1,   207,
     208,   209,   210,    -1,   212,   213,   214,    -1,   216,   217,
     218,   219,   220,   221,    -1,    -1,    -1,    -1,   226,   227,
     228,   229,   230,    -1,   232,    -1,    -1,    -1,    -1,   237,
      -1,   239,   240,   241,   242,   243,    -1,    -1,    -1,   247,
      -1,    -1,   250,   251,   252,    -1,    -1,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,   265,   266,    -1,
     268,    -1,   270,   271,   272,   273,   274,   275,   276,    -1,
     278,    -1,   280,   281,    -1,   283,    -1,    -1,   286,   287,
     288,    -1,    -1,   291,    -1,    -1,    -1,   295,   296,    -1,
      -1,    -1,    -1,    -1,    -1,   303,   304,   305,   306,    -1,
      -1,    -1,   310,   311,   312,    -1,   314,   315,   316,   317,
     318,   319,   320,   321,   322,    -1,   324,   325,   326,   327,
     328,   329,   330,   331,   332,    -1,   334,   335,    -1,   337,
     338,    -1,   340,   341,   342,   343,   344,   345,    -1,    -1,
     348,   349,   350,    -1,   352,   353,   354,   355,    -1,   357,
     358,    -1,   360,   361,   362,   363,   364,   365,   366,   367,
      -1,   369,    -1,   371,   372,    -1,   374,   375,   376,   377,
      -1,   379,   380,    -1,    -1,   383,    -1,   385,    -1,    -1,
     388,   389,   390,   391,   