/*--------------------------------------------------------------------
 * FILE:
 *     pgreplicate.h
 *
 * Portions Copyright (c) 2003-2005, Atsushi Mitani
 *--------------------------------------------------------------------
 */
#ifndef PGREPLICATE_H
#define PGREPLICATE_H

#define PGREPLICATE_VERSION		"1.0.9d"

#include "../libpgc/libpgc.h"

/* cascade packet id */
#define	CMD_SYS_CASCADE	'C'
#define CMD_STS_TO_UPPER 'U'
#define CMD_STS_TO_LOWER 'L'
#define CMD_TYPE_ADD 'A'
#define CMD_TYPE_DELTE 'D'
#define CMD_TYPE_UPDATE_ALL 'A'

/* log packet id */
#define	CMD_SYS_LOG	'L'
#define CMD_STS_DELETE_QUERY 'q'
#define CMD_STS_DELETE_TRANSACTION 't'

#define INIT_TRANSACTION_TBL_NUM (12)
#define MAX_HOST_NAME_LEN	(128)
#define MAX_DB_SERVER	(32)
#define	MAX_CONNECTIONS	(128)
#define PGR_MAX_TICKETS (0x7FFFFFFF)
#define PGR_MAX_QUERY_ID (0x7FFFFFFF)
#define PGR_CONNECT_RETRY_TIME  (3)
#define PGR_EXEC_RETRY_TIME  (5)
#define DB_TBL_FREE	(0)
#define DB_TBL_INIT	(1)
#define DB_TBL_USE	(2)
#define DB_TBL_ERROR	(-1)
#define DB_TBL_TOP	(10)
#define DB_TBL_END	(11)
#define RECOVERY_HEADER_MTYPE	(1)
#define PGREPLICATE_CONF_FILE	"pgreplicate.conf"
#define PGREPLICATE_LOG_FILE	"pgreplicate.log"
#define PGREPLICATE_STATUS_FILE	"pgreplicate.sts"
#define PGREPLICATE_PID_FILE	"pgreplicate.pid"
#define CLUSTER_SERVER_TAG	"Cluster_Server_Info"
#define LOAD_BALANCE_SERVER_TAG	"LoadBalance_Server_Info"
#define REPLICATE_PORT_TAG	"Replication_Port"
#define RECOVERY_PORT_TAG	"Recovery_Port"
#define RESPONSE_MODE_TAG	"Response_Mode"
#define	RESPONSE_MODE_FAST	"fast"
#define	RESPONSE_MODE_NORMAL	"normal"
#define	RESPONSE_MODE_RELIABLE	"reliable"
#define	USE_REPLICATION_LOG_TAG	"Use_Replication_Log"
#define SEM_NUM_OF_RECOVERY	(1)
#define SEM_NUM_OF_LOCK	(1)
#define STATUS_LOCK_CONFLICT (2)
#define STATUS_DEADLOCK_DETECT (3)
#define STATUS_ABORTED (4)
#define PGR_NOWAIT_ANSWER (0)
#define PGR_WAIT_ANSWER (1)
#define LOOP_CONTINUE	(0)
#define LOOP_END	(1)
#define LOWER_CASCADE	(1)
#define UPPER_CASCADE	(2)
#define ALL_CASCADE	(3)

#define PGR_SEND_RETRY_CNT (1000)
#define PGR_SEND_WAIT_MSEC (50)
#define PGR_RECV_RETRY_CNT (1000)
#define PGR_RECV_WAIT_MSEC (50)
#define PGR_RECV_TIMEOUT	(10)
#define PGR_SEND_TIMEOUT	(600)
#define PGR_LOCK_WAIT_MSEC	(50)
#define PGR_LOCK_TIMEOUT	(60)
#define PGR_RECOVERY_RETRY_CNT	(60)
#define PGR_RECOVERY_WAIT_MSEC	(50)

#define PGR_RECOVERY_1ST_STAGE	(1)
#define PGR_RECOVERY_2ND_STAGE	(2)

/*
 * connection table for transaction query
 */
typedef struct {
	int useFlag;
	int lock;
	unsigned short port;
	unsigned short pid;
	unsigned int hostIP;
	unsigned int srcHostIP;
	char host[HOSTNAME_MAX_LENGTH];
	char srcHost[HOSTNAME_MAX_LENGTH];
	char dbName[DBNAME_MAX_LENGTH];
	PGconn	* conn;
}TransactionTbl;

/*
 * cluster server table
 */
typedef struct {
	int useFlag;
	char hostName[HOSTNAME_MAX_LENGTH];
	int port;
	int recoveryPort;
	int hostNum;
}HostTbl;

/*
 * host table for recovery request
 */
typedef struct {
	char hostName[HOSTNAME_MAX_LENGTH];
	int port;
	int recoveryPort;
	int sock;
	int recovery_sock;
} RecoveryTbl;

/*
 * status table for recovery
 */
typedef struct {
	int useFlag;
	int transaction_count;
	int recovery_status;
	HostTbl target_host;
} RecoveryStatusInf;

typedef struct {
	long mtype;
	long query_mtype;
	char mdata[1];
} RecoveryQueueHeader;

typedef struct {
	long mtype;
	char mdata[1];
} RecoveryQueueQuery;

typedef struct {
	unsigned int entry_ticket;
	unsigned int lock_wait_queue_length;
	int overflow;
} LockWaitInf;

typedef struct {
	int response_mode;
	int current_cluster;
} ResponseInf;

typedef struct {
	ReplicateHeader * header;
	char * query;
	char * next;
	char * last;
} QueryLogType;

typedef struct {
	ReplicateServerInfo * lower;
	ReplicateServerInfo * upper;
	ReplicateServerInfo * myself;
	int useFlag;
} CascadeInf;

typedef struct {
	union 
	{
		int useFlag;
		int commit_log_num;
	} inf;
	ReplicateHeader header;
} CommitLogInf;

typedef struct {
	ReplicateHeader * header;
	char * query;
} ReplicationLogInf;

typedef struct {
	int dest;
	int current_cluster;
	HostTbl * host_ptr;
	TransactionTbl * transaction_tbl;
	ReplicateHeader * header;
	char * query;
} ThreadArgInf;

extern HostTbl * Host_Tbl_Begin;
extern TransactionTbl * Transaction_Tbl_Begin;
extern TransactionTbl * Transaction_Tbl_End;
extern RecoveryTbl * LoadBalanceTbl;
extern RecoveryStatusInf * Recovery_Status_Inf;
extern LockWaitInf * Lock_Wait_Tbl;
extern ReplicateHeader * PGR_Log_Header;
extern ReplicateServerInfo * Cascade_Tbl;
extern CascadeInf * Cascade_Inf;
extern CommitLogInf * Commit_Log_Tbl;
extern ReplicationLogInf * Replicateion_Log;
extern int Port_Number;
extern int Recovery_Port_Number;
extern int RecoveryShmid;
extern int RecoveryMsgid;
extern int HostTblShmid;
extern int LockWaitTblShmid;
extern int CascadeTblShmid;
extern int CascadeInfShmid;
extern int CommitLogShmid;
extern int MaxBackends;
extern char * PGR_Result;
extern int SemID;
extern int RecoverySemID;
extern int LockSemID;
extern int VacuumSemID;
extern char * PGR_Data_Path;
extern char * PGR_Write_Path;
extern FILE * LogFp;
extern FILE * StatusFp;
extern int Log_Print;
extern int Debug_Print;
extern char * Function;
extern int IS_SESSION_AUTHORIZATION;
extern ResponseInf * PGR_Response_Inf;
extern bool StartReplication[MAX_DB_SERVER];
extern bool PGR_Cascade;
extern bool	PGR_Use_Replication_Log;
extern bool	PGR_AutoCommit;
extern unsigned int * PGR_Send_Query_ID;
extern unsigned int PGR_Query_ID;
extern int Transaction_Tbl_Num;
/*
 * external prototype in conf.c
 */
extern int PGRset_Conf_Data(char * path);

/*
 * external prototype in replicate.c
 */
extern bool PGRis_same_host(char * host1, unsigned short port1 , char * host2, unsigned short port2);
extern HostTbl * PGRadd_HostTbl(HostTbl *  conf_data, int useFlag);
extern HostTbl * PGRget_master(void);
extern void PGRset_recovery_status(int status);
extern int PGRget_recovery_status(void);
extern int PGRcheck_recovered_host(void);
extern int PGRset_recovered_host(HostTbl * target,int useFlag);
extern int PGRinit_recovery(void);
extern void PGRreplicate_exit(int signal_arg);
extern int PGRsend_replicate_packet_to_server( HostTbl * host_ptr, ReplicateHeader * header, char *query , char * result);
extern int PGRreplicate_packet_send_each_server( HostTbl * ptr, bool return_response, ReplicateHeader * header, char * query,int dest);
extern HostTbl * PGRget_HostTbl(char * hostName,int port);
extern int PGRset_queue(ReplicateHeader * header,char * query);
extern int PGRset_host_status(HostTbl * host_ptr,int status);
extern void PGRclear_connections(void);
extern void PGRsem_unlock( int semid, short sem_num );
extern void PGRsem_lock( int semid, short sem_num );
extern int PGRdo_replicate(int sock,ReplicateHeader *header, char * query);
extern int PGRreturn_result(int dest, char * result, int wait);
extern int PGRreplicate_packet_send( ReplicateHeader * header, char * query,int dest);
extern char * PGRread_packet(int sock, ReplicateHeader *header);
extern char * PGRread_query(int sock, ReplicateHeader *header);
extern int PGRwait_transaction_count_clear(void);
extern unsigned int PGRget_next_query_id(void);
extern int PGRinit_transaction_table(void);

/*
 * external prototype in recovery.c
 */
extern int PGRsend_load_balance_packet(RecoveryPacket * packet);
extern void PGRrecovery_main(void);

/*
 * external prototype in rlog.c
 */
extern void PGRwrite_rlog(ReplicateHeader * header, char * query);
extern void PGRreconfirm_commit(int sock, ReplicateHeader * header);
extern void PGRset_rlog(ReplicateHeader * header, char * query);
extern void PGRunset_rlog(ReplicateHeader * header, char * query);

/*
 * external prototype in cascade.c
 */
extern int PGRstartup_cascade(void);
extern int PGRsend_lower_cascade(ReplicateHeader * header, char * query);
extern int PGRsend_upper_cascade(ReplicateHeader * header, char * query);
extern ReplicateServerInfo * PGRget_lower_cascade(void);
extern ReplicateServerInfo * PGRget_upper_cascade(void);
extern void PGRset_cascade_server_status(ReplicateServerInfo * cascade, int status);
extern ReplicateServerInfo * PGRrecv_cascade_answer(ReplicateServerInfo * cascade,ReplicateHeader * header);
extern int PGRsend_cascade(ReplicateServerInfo * cascade, ReplicateHeader * header, char * query);
extern int PGRcascade_main(int sock, ReplicateHeader * header, char * query);

#endif /* PGREPLICATE_H */
