/*
 * Written by Tomas Dosoudil
 * This file is distributed under BSD-style license.
 *
 */

#ifndef _PGDVIEW_H_
#define _PGDVIEW_H_

/* PageHeaderData see in Postgre doc chapter 50. Database Physical Storage*/
#define     PAGE_HEADER             24
#define     PD_PAGESIZE_VERSION     2
#define     ITEM_POINTER            4

/* file descriptor queue debug */
#define		FD_DEBUG				0

/* 
 * CONTROL AN INPUT
 */
/* max length of path to db inclusive of file name */
#define		MAX_FILENAME_LENGTH		200

/* max number of opened files */
#define		MAX_FD_OPENED			5

/* 
 * check if argument has parameter 
 *  - parameter must not be last, last is database file name
 *  - first character must not be '-'
 */
#define 	HAS_ARGUMENT(optc,optv) ((*(*(optv) + 1) == NULL) && \
									(((optc) - 1) > 0) && \
									(**((optv) + 1) != '-'))


/* Diferent between versions. Macros are defined for version 8.0.8 */
/* for version 8.0.8 */
#ifndef HEAP_XMAX_UNLOGGED
#define HEAP_XMAX_UNLOGGED      0x0080
#endif

#ifndef HEAP_MARKED_FOR_UPDATE 
#define HEAP_MARKED_FOR_UPDATE	0x1000
#endif

/* for version 8.1.4 */
#ifndef HEAP_XMAX_SHARED_LOCK
#define HEAP_XMAX_SHARED_LOCK	0x0080
#endif

#ifndef HEAP_XMAX_IS_MULTI 
#define HEAP_XMAX_IS_MULTI 		0x1000
#endif

#ifndef HEAP_XMAX_EXCL_LOCK
#define HEAP_XMAX_EXCL_LOCK		0x0040 
#endif

/*
 * PageHeaderData accessor macros
 * check values in pd_flags
 */
#define PageHeaderHasFreeLines(pageHeader) \
          (((pageHeader)->pd_flags & PD_HAS_FREE_LINES) != 0)
          
#define PageHeaderHasPageFull(pageHeader) \
          (((pageHeader)->pd_flags & PD_PAGE_FULL) != 0)
          
#define PageHeaderHasValidFlagBits(pageHeader) \
          (((pageHeader)->pd_flags & PD_VALID_FLAG_BITS) != 0)


/*
 * HeapTupleHeader accessor macros
 * check values in t_infomask
 */
#define _HeapTupleHasNulls(tupleHeader) \
          (((tupleHeader)->t_infomask & HEAP_HASNULL) != 0)

#define _HeapTupleHasVarWidth(tupleHeader) \
          (((tupleHeader)->t_infomask & HEAP_HASVARWIDTH) != 0)

#define _HeapTupleHasExternal(tupleHeader) \
          (((tupleHeader)->t_infomask & HEAP_HASEXTERNAL) != 0)
          
#define _HeapTupleGetOid(tupleHeader) \
( \
     (HeapTupleHasOid(tupleHeader)) ? \
         *((Oid *) ((char *)(tupleHeader) + (tupleHeader)->t_hoff - sizeof(Oid))) \
     : \
         InvalidOid \
)

#define HeapTupleHasOid(tupleHeader) \
         (((tupleHeader)->t_infomask & HEAP_HASOID) != 0)
   
#define HeapTupleHasComboCid(tupleHeader) \
         (((tupleHeader)->t_infomask & HEAP_COMBOCID) != 0)

#define HeapTupleHasXmaxExclLock(tupleHeader) \
         (((tupleHeader)->t_infomask & HEAP_XMAX_EXCL_LOCK) != 0)         

#define HeapTupleHasXmaxSharedLock(tupleHeader) \
         (((tupleHeader)->t_infomask & HEAP_XMAX_SHARED_LOCK) != 0)             

#define HeapTupleHasXminCommitted(tupleHeader) \
         (((tupleHeader)->t_infomask & HEAP_XMIN_COMMITTED) != 0)

#define HeapTupleHasXminInvalid(tupleHeader) \
         (((tupleHeader)->t_infomask & HEAP_XMIN_INVALID) != 0)

#define HeapTupleHasXmaxCommitted(tupleHeader) \
         (((tupleHeader)->t_infomask & HEAP_XMAX_COMMITTED) != 0)

#define HeapTupleHasXmaxInvalid(tupleHeader) \
         (((tupleHeader)->t_infomask & HEAP_XMAX_INVALID) != 0)
         
#define HeapTupleHasXmaxIsMulti(tupleHeader) \
         (((tupleHeader)->t_infomask & HEAP_XMAX_IS_MULTI) != 0)

#define HeapTupleHasUpdated(tupleHeader) \
         (((tupleHeader)->t_infomask & HEAP_UPDATED) != 0)

#define HeapTupleHasMovedOff(tupleHeader) \
         (((tupleHeader)->t_infomask & HEAP_MOVED_OFF) != 0)

#define HeapTupleHasMovedIn(tupleHeader) \
         (((tupleHeader)->t_infomask & HEAP_MOVED_IN) != 0)

#define HeapTupleHasXactMask(tupleHeader) \
         (((tupleHeader)->t_infomask & HEAP_XACT_MASK) != 0)
         
/* check values in t_infomask2 */
#define HeapTupleHasNattsMask(tupleHeader) \
         (((tupleHeader)->t_infomask2 & HEAP_NATTS_MASK) != 0)
         
#define HeapTupleHasHotUpdated(tupleHeader) \
         (((tupleHeader)->t_infomask2 & HEAP_HOT_UPDATED) != 0)
         
#define HeapTupleHasOnlyTuple(tupleHeader) \
         (((tupleHeader)->t_infomask2 & HEAP_ONLY_TUPLE) != 0)
         
#define HeapTupleHasXastMask2(tupleHeader) \
         (((tupleHeader)->t_infomask2 & HEAP2_XACT_MASK) != 0)
         
#define HeapTupleGetNumAttributes(tupleHeader) \
         ((tupleHeader)->t_infomask2 & HEAP_NATTS_MASK)

#endif /* _PGDVIEW_h_ */
