#include "odbc.h"
#include <odbcinst.h>
#include "resource.h"
#include "connection.h"

#ifdef USE_SSL
	SSL_FREE_FUNC                             SSL_FREE;
	SSL_SHUTDOWN_FUNC                         SSL_SHUTDOWN;
	SSL_WRITE_FUNC                            SSL_WRITE;
	SSL_READ_FUNC                             SSL_READ;
	SSL_CTX_FREE_FUNC                         SSL_CTX_FREE;
	SSL_CTX_NEW_FUNC                          SSL_CTX_NEW;
	SSL_LIBRARY_INIT_FUNC                     SSL_LIBRARY_INIT;
	SSL_LOAD_ERROR_STRINGS_FUNC               SSL_LOAD_ERROR_STRINGS;
	SSLV23_CLIENT_METHOD_FUNC                 SSLV23_CLIENT_METHOD;
	SSL_CTX_CTRL_FUNC                         SSL_CTX_CTRL;
	SSL_NEW_FUNC                              SSL_NEW;
	SSL_SET_FD_FUNC                           SSL_SET_FD;
	SSL_CONNECT_FUNC                          SSL_CONNECT;
	SSL_GET_ERROR_FUNC                        SSL_GET_ERROR;
	SSL_CTX_USE_CERTIFICATE_CHAIN_FILE_FUNC   SSL_CTX_USE_CERTIFICATE_CHAIN_FILE;
	SSL_CTX_USE_PRIVATEKEY_FILE_FUNC          SSL_CTX_USE_PRIVATEKEY_FILE;
	SSL_CTX_SET_DEFAULT_PASSWORD_CB_FUNC      SSL_CTX_SET_DEFAULT_PASSWORD_CB;
	SSL_CTX_SET_DEFAULT_PASSWORD_CB_USERDATA_FUNC SSL_CTX_SET_DEFAULT_PASSWORD_CB_USERDATA;
#endif /* USE_SSL */

HINSTANCE g_hModule;
static HMODULE   g_hSSLEAY32;
static HMODULE   g_hLIBEAY32;



BOOL WINAPI
DllMain(HINSTANCE hInst, ULONG ul_reason_for_call, LPVOID lpReserved)
{
	switch (ul_reason_for_call)
	{
		case DLL_PROCESS_DETACH:
#ifdef USE_SSL
			if (g_hSSLEAY32)
			{
				FreeLibrary(g_hLIBEAY32);
				FreeLibrary(g_hSSLEAY32);
				g_hSSLEAY32 = NULL;
				g_hLIBEAY32 = NULL;
			}
#endif /* USE_SSL */
			return TRUE;
		case DLL_PROCESS_ATTACH:
			g_hModule = hInst;
#ifdef USE_SSL
			g_hSSLEAY32 = NULL;
			g_hLIBEAY32 = NULL;
#endif /* USE_SSL */
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		default:
			break;
	}
	return TRUE;
} 

const TCHAR*
GetDSN(const TCHAR* lpszAttributes)
{
	const TCHAR* lpszAttribute = lpszAttributes;

	while(lpszAttribute[0])
	{
		if (0 == _tcsncmp(lpszAttribute, _T("DSN="), STR_SIZEOF("DSN=")))
		{
			lpszAttribute += STR_SIZEOF("DSN=");
			/* check DSN for validity */
			return lpszAttribute;
		}
		lpszAttribute += _tcslen(lpszAttribute) + 1;
	}

	return lpszAttribute;
}

int CALLBACK
TestConnectionDlgProc(HWND hdlg, UINT wMsg, WPARAM wParam, LPARAM lParam)
{
	switch (wMsg)
	{
		case WM_INITDIALOG:
			SetDlgItemText(hdlg, IDC_CONNECTION_STATUS, (TCHAR*) lParam);
			return TRUE;
		case WM_COMMAND:
			switch (GET_WM_COMMAND_ID(wParam, lParam))
			{
				case IDOK:
					EndDialog(hdlg, wParam);
					return TRUE;
			}
	}
	return FALSE;
}


int CALLBACK
ConfigDlgProc(HWND hdlg, UINT wMsg, WPARAM wParam, LPARAM lParam)
{
	int    i;
	int    length;
	int    send_msg;
	DWORD  cmd;
	TCHAR  combo_box[COMBOBOX_MAX_LENGTH+1];
	TCHAR* param_ptr;
	TCHAR* param;
	TCHAR* szConnectionString;
	static TCHAR** parameters;

	SQLSMALLINT nLength;

	switch (wMsg)
	{
		case WM_INITDIALOG:
			parameters = (TCHAR**)lParam;
			/* fill edits with text data */
			for (i=0;i<DS_EDIT_PARAMETERS_NUMBER;i++)
				SetDlgItemText(hdlg, c_stDSParameters[i].unDialogItemID, parameters[i]);
			/* set check boxes' states */
			for (;i<DS_CHECKBOX_PARAMETERS_NUMBER;i++)
				if (_T('Y') == *parameters[i])
					CheckDlgButton(hdlg, c_stDSParameters[i].unDialogItemID, BST_CHECKED);
			/* set combo boxes' strings */
			for (;i<DS_PARAMETERS_NUMBER;i++)
			{
				param_ptr = (TCHAR*)c_stDSParameters[i].szDefaultValue;
				while(param_ptr)
				{
					if (NULL != (param = _tcschr(param_ptr, _T(','))))
					{
						_tcsncpy(combo_box, param_ptr, length = param - param_ptr);
						combo_box[length] = _T('\0');
						SendDlgItemMessage(hdlg, c_stDSParameters[i].unDialogItemID, CB_ADDSTRING, 0, (LPARAM) combo_box);
						param_ptr = param + 1;
					}
					else
					{
						SendDlgItemMessage(hdlg, c_stDSParameters[i].unDialogItemID, CB_ADDSTRING, 0, (LPARAM) param_ptr);
						param_ptr = NULL;
					}
				}
				send_msg = (i >= COMBOBOX_LIST_PARAM) ? WM_SETTEXT : CB_SELECTSTRING;
				SendDlgItemMessage(hdlg, c_stDSParameters[i].unDialogItemID, send_msg, 0, (LPARAM) parameters[i]);
			}
			
			if (parameters[DS_PARAMETERS_NUMBER] != NULL)
				SetDlgItemText(hdlg, IDE_DSN, parameters[DS_PARAMETERS_NUMBER]);

			return TRUE;
		case WM_COMMAND:
			switch (cmd = GET_WM_COMMAND_ID(wParam, lParam))
			{
				/* save and exit */
				case IDOK:
				{/* validate Data Source Name */
					HKEY    hKey;
					TCHAR   dsn[DSN_MAX_LENGTH+1];

					GetDlgItemText(hdlg, IDE_DSN, dsn, DSN_MAX_LENGTH);
					
					if (parameters[DS_PARAMETERS_NUMBER] != NULL)
					{
						/* check for valid name's length and used characters in it */
						if (!SQLValidDSN(dsn))
						{
							MessageBox(hdlg, _T("Invalid Data Source Name specified."), _T("Mammoth ODBC - DSN configuration"), MB_OK | MB_ICONWARNING);
							return TRUE;
						}

						/* check for the same name using other driver 
						 * EXPLANATION: impossible to call SQLDataSources here!!! ^), let's try to read it from registry
						 */
						if (ERROR_SUCCESS == RegOpenKeyEx(HKEY_CURRENT_USER, _T("Software\\ODBC\\ODBC.INI\\ODBC Data Sources"), 0, KEY_READ, &hKey))
						{/* such DSN exists*/
							BOOL   res = IDYES;
							TCHAR  desc[1000];
							DWORD  desc_length = sizeof(desc);

							if (ERROR_SUCCESS == RegQueryValueEx(hKey, dsn, NULL, NULL, (BYTE*)desc, &desc_length) && _tcscmp(desc, c_szDriverName))
							{
								TCHAR* msg = GetText(_T("Specified name is already used as DSN for '?' ODBC driver. Rewrite it?"), desc, NULL);
								res = MessageBox(hdlg, msg, _T("Mammoth ODBC - DSN configuration"), MB_YESNO | MB_ICONWARNING | MB_DEFBUTTON2);
								FREE(msg);
							}
							RegCloseKey(hKey);
							if (IDNO == res)
								return TRUE;
						}
					}

					/* read data from dialog items */
					ReadFromDialogItems(hdlg, parameters);
				}
				/* no break! */
				case IDCANCEL:
					EndDialog(hdlg, wParam);
					return TRUE;
				/* check connection by sending en Empty Query String */
				case IDC_TEST:
					/* read data from dialog items */
					ReadFromDialogItems(hdlg, parameters);
					/* prepare Connection String */
					PrepareConnectionString(NULL, 0, &nLength, parameters, NULL);
					nLength = (SQLSMALLINT)sizeof(TCHAR)*(nLength+1);
					szConnectionString = (TCHAR*)malloc(nLength);
					PrepareConnectionString(szConnectionString, nLength, &nLength, parameters, NULL);
					TestConnection(hdlg, szConnectionString);
					FREE(szConnectionString);
					return TRUE;
			}
	}
	return FALSE;
}

BOOL CALLBACK
ConfigDSN_ (HWND hwndParent, WORD fRequest, LPCTSTR lpszDriver, LPCTSTR lpszAttributes)
{
	BOOL fResult = FALSE;

	switch (fRequest)
	{
		case ODBC_REMOVE_DSN:
		{
			LPCTSTR lpDSN = GetDSN(lpszAttributes);
			fResult = (_T('\0') == lpDSN[0]) ? FALSE : SQLRemoveDSNFromIni(lpDSN);
			break;
		}
		case ODBC_ADD_DSN:
		case ODBC_CONFIG_DSN:
		{
			int    i;
			TCHAR* pBuffer;
			TCHAR  dsn[DSN_MAX_LENGTH+1];
			TCHAR* parameters[DS_PARAMETERS_NUMBER+1];
			TCHAR  parameters_buffer[DS_PARAMETERS_BUFFER_SIZE+DSN_MAX_LENGTH+1];

			memset(parameters_buffer, 0, sizeof(parameters_buffer));
			pBuffer = parameters_buffer;
			for (i=0;i<DS_PARAMETERS_NUMBER;i++)
			{
				parameters[i] = pBuffer;
				pBuffer += c_stDSParameters[i].unMaxValueLength + 1;
			}
			parameters[DS_PARAMETERS_NUMBER] = pBuffer;
			_tcsncpy(dsn, GetDSN(lpszAttributes), DSN_MAX_LENGTH);
			_tcscpy(parameters[DS_PARAMETERS_NUMBER], (_T('\0') == dsn[0]) ? c_szDriverName : dsn);
			ReadFromDS(parameters, parameters[DS_PARAMETERS_NUMBER], SQL_NTS);

			if (hwndParent && (IDOK != DialogBoxParam(g_hModule, MAKEINTRESOURCE(DLG_CONFIG), hwndParent, (DLGPROC)ConfigDlgProc, (LPARAM) parameters)))
				return TRUE;

			/* check for renaming Data Source Name - in such case we should create new DSN, and remove old */
			if ((_T('\0') != dsn[0]) && _tcscmp(parameters[DS_PARAMETERS_NUMBER], dsn))
			{/* remove old DSN */
				SQLRemoveDSNFromIni(dsn);
			}

			/* save parameters to DSN */
			fResult = SQLWriteDSNToIni(parameters[DS_PARAMETERS_NUMBER], c_szDriverName);
			WriteToDS(parameters, parameters[DS_PARAMETERS_NUMBER]);
		}
	}

	return fResult;
}

/*-----------------------------------------------------------------------------
 * TestConnection
 *-----------------------------------------------------------------------------
 */
void TestConnection(HWND hWnd, const TCHAR* ConnectionString)
{
	const TCHAR* szConnectionStatus	= _T("failed.");

  SQLHENV  henv  = NULL;
  SQLHDBC  hdbc  = NULL;
  SQLHSTMT hstmt = NULL;

	if (SQL_ERROR != SQLAllocHandle(SQL_HANDLE_ENV,  NULL, &henv) &&
	    SQL_ERROR != SQLSetEnvAttr(henv, SQL_ATTR_ODBC_VERSION, (void*)SQL_OV_ODBC3, SQL_IS_INTEGER) &&
	    SQL_ERROR != SQLAllocHandle(SQL_HANDLE_DBC,  henv, &hdbc)
	   )
	{
		if (SQL_ERROR != SQLDriverConnect(hdbc, hWnd, (SQLTCHAR*)ConnectionString, SQL_NTS, NULL, 0, NULL, SQL_DRIVER_NOPROMPT) &&
		    SQL_ERROR != SQLDisconnect(hdbc)
		   )
			szConnectionStatus = _T("succeeded.");
	}
	else
	{
		/* can't allocate statement */
	}

	DialogBoxParam(g_hModule, MAKEINTRESOURCE(DLG_TEST_RESULTS), hWnd, TestConnectionDlgProc, (WPARAM)szConnectionStatus);

	if (NULL != hstmt) SQLFreeHandle(SQL_HANDLE_STMT, hstmt);
	if (NULL != hdbc)  SQLFreeHandle(SQL_HANDLE_DBC,  hdbc);
	if (NULL != henv)  SQLFreeHandle(SQL_HANDLE_ENV,  henv);
}

/*-----------------------------------------------------------------------------
 * ReadFromDialogItems
 *-----------------------------------------------------------------------------
 */
void ReadFromDialogItems(HWND hdlg, TCHAR** parameters)
{
	unsigned int i;

	/* read all text data in edit items */
	for (i=0;i<DS_EDIT_PARAMETERS_NUMBER;i++)
		GetDlgItemText(hdlg, c_stDSParameters[i].unDialogItemID, parameters[i], c_stDSParameters[i].unMaxValueLength);
	/* read check boxes' states */
	for (;i<DS_CHECKBOX_PARAMETERS_NUMBER;i++)
		*parameters[i] = (BST_CHECKED == IsDlgButtonChecked(hdlg, c_stDSParameters[i].unDialogItemID)) ? _T('Y') : _T('N');
	/* read comboboxes' text */
	for (;i<DS_PARAMETERS_NUMBER;i++)
		GetDlgItemText(hdlg, c_stDSParameters[i].unDialogItemID, parameters[i], c_stDSParameters[i].unMaxValueLength);

	if (parameters[DS_PARAMETERS_NUMBER])
		GetDlgItemText(hdlg, IDE_DSN, parameters[DS_PARAMETERS_NUMBER], DSN_MAX_LENGTH);
}

#ifdef USE_SSL
int InitSSL()
{
	if (!g_hSSLEAY32)
	{/* get full path from registry */
		HKEY hKey;

		if (ERROR_SUCCESS == RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\CommandPrompt\\Mammoth ODBC\\Open SSL"), 0, KEY_READ, &hKey))
		{/* key exists*/
			TCHAR path[MAX_PATH+100];
			DWORD path_length = sizeof(path);

			if (ERROR_SUCCESS == RegQueryValueEx(hKey, _T("dir"), NULL, NULL, (BYTE*)path, &path_length))
			{/* we've got it */
				path_length /= sizeof(TCHAR);
				path_length--;

				/* compile full name */
				_tcscpy(path+path_length, _T("libeay32"));
				if (NULL != (g_hLIBEAY32 = LoadLibrary(path)))
				{
					_tcscpy(path+path_length, _T("ssleay32"));
					if (NULL != (g_hSSLEAY32 = LoadLibrary(path)))
					{
						SSL_LIBRARY_INIT                   = (SSL_LIBRARY_INIT_FUNC)GetProcAddress(g_hSSLEAY32, "SSL_library_init");
						SSL_LOAD_ERROR_STRINGS             = (SSL_LOAD_ERROR_STRINGS_FUNC)GetProcAddress(g_hSSLEAY32, "SSL_load_error_strings");
						SSL_CTX_NEW                        = (SSL_CTX_NEW_FUNC)GetProcAddress(g_hSSLEAY32, "SSL_CTX_new");
						SSLV23_CLIENT_METHOD               = (SSLV23_CLIENT_METHOD_FUNC)GetProcAddress(g_hSSLEAY32, "SSLv23_client_method");
						SSL_CTX_CTRL                       = (SSL_CTX_CTRL_FUNC)GetProcAddress(g_hSSLEAY32, "SSL_CTX_ctrl");
						SSL_NEW                            = (SSL_NEW_FUNC)GetProcAddress(g_hSSLEAY32, "SSL_new");
						SSL_SET_FD                         = (SSL_SET_FD_FUNC)GetProcAddress(g_hSSLEAY32, "SSL_set_fd");
						SSL_CONNECT                        = (SSL_CONNECT_FUNC)GetProcAddress(g_hSSLEAY32, "SSL_connect");
						SSL_FREE                           = (SSL_FREE_FUNC)GetProcAddress(g_hSSLEAY32, "SSL_free");
						SSL_CTX_FREE                       = (SSL_CTX_FREE_FUNC)GetProcAddress(g_hSSLEAY32, "SSL_CTX_free");
						SSL_SHUTDOWN                       = (SSL_SHUTDOWN_FUNC)GetProcAddress(g_hSSLEAY32, "SSL_shutdown");
						SSL_WRITE                          = (SSL_WRITE_FUNC)GetProcAddress(g_hSSLEAY32, "SSL_write");
						SSL_READ                           = (SSL_READ_FUNC)GetProcAddress(g_hSSLEAY32, "SSL_read");
						SSL_CTX_USE_CERTIFICATE_CHAIN_FILE = (SSL_CTX_USE_CERTIFICATE_CHAIN_FILE_FUNC)GetProcAddress(g_hSSLEAY32, "SSL_CTX_use_certificate_chain_file");
						SSL_GET_ERROR                      = (SSL_GET_ERROR_FUNC)GetProcAddress(g_hSSLEAY32, "SSL_get_error");
						SSL_CTX_USE_PRIVATEKEY_FILE        = (SSL_CTX_USE_PRIVATEKEY_FILE_FUNC)GetProcAddress(g_hSSLEAY32, "SSL_CTX_use_RSAPrivateKey_file");
						SSL_CTX_SET_DEFAULT_PASSWORD_CB    = (SSL_CTX_SET_DEFAULT_PASSWORD_CB_FUNC)GetProcAddress(g_hSSLEAY32, "SSL_CTX_set_default_passwd_cb");
						SSL_CTX_SET_DEFAULT_PASSWORD_CB_USERDATA = (SSL_CTX_SET_DEFAULT_PASSWORD_CB_USERDATA_FUNC)GetProcAddress(g_hSSLEAY32, "SSL_CTX_set_default_passwd_cb_userdata");

						if (SSL_LIBRARY_INIT && SSL_LOAD_ERROR_STRINGS && SSL_CTX_NEW && SSLV23_CLIENT_METHOD && SSL_CTX_CTRL && SSL_NEW && SSL_SET_FD && SSL_CONNECT && SSL_FREE && SSL_CTX_FREE && SSL_SHUTDOWN && SSL_WRITE && SSL_READ && SSL_CTX_USE_CERTIFICATE_CHAIN_FILE && SSL_GET_ERROR && SSL_CTX_USE_PRIVATEKEY_FILE && SSL_CTX_SET_DEFAULT_PASSWORD_CB)
						{/* no errors! */
							RegCloseKey(hKey);
							return FALSE;
						}
						else
						{
							FreeLibrary(g_hSSLEAY32);
							g_hSSLEAY32 = NULL;
						}
					}
					FreeLibrary(g_hLIBEAY32);
					g_hLIBEAY32 = NULL;
				}
			}
			RegCloseKey(hKey);
		}
		return TRUE;
	}

	return FALSE;
}
#endif /* USE_SSL */
