#include "statement.h"
#include "protocol.h"
#include "common.h"

#ifdef WIN32
#include "resource.h"

extern HINSTANCE g_hModule;

int CALLBACK ConfigDlgProc(HWND hdlg, UINT wMsg, WPARAM wParam, LPARAM lParam);
#endif

#define SQL_FUNC_IMPLEMENTED(pfExists, uwAPI) \
				((*(((UWORD*) (pfExists)) + ((uwAPI) >> 4)) \
					|= (1 << ((uwAPI) & 0x000F)) \
 				 ) \
				)

TCHAR c_SQLTables_query[]                    = _T("SELECT g,n.nspname,c.relname,(SELECT CASE\?\?\? END),d.description FROM current_database() g,pg_namespace n,pg_class c LEFT JOIN pg_description d ON (c.oid=d.objoid AND d.objsubid=0) WHERE n.oid=c.relnamespace AND(has_table_privilege(c.oid, 'SELECT')OR has_table_privilege(c.oid,'INSERT')OR has_table_privilege(c.oid,'UPDATE')OR has_table_privilege(c.oid,'DELETE')OR has_table_privilege(c.oid,'RULE')OR has_table_privilege(c.oid,'REFERENCES')OR has_table_privilege(c.oid,'TRIGGER'))AND has_schema_privilege(n.oid, 'USAGE'::text)AND (?\?\?)\?\?\?\?\? ORDER BY 2,3,4");
TCHAR c_SQLColumns_query[]                   = _T("SELECT a.atttypmod,n.nspname,c.relname,a.attname,a.atttypid,q.typname,a.attlen,null,null,null,CASE WHEN a.attnotnull THEN 0 ELSE 1 END,d.description,f.adsrc,null,null,null,a.attnum,CASE WHEN a.attnotnull THEN 'NO' ELSE 'YES' END FROM current_database() g,pg_catalog.pg_type q,pg_catalog.pg_namespace n,pg_catalog.pg_class c,pg_catalog.pg_attribute a LEFT JOIN pg_catalog.pg_description d ON (a.attrelid=d.objoid AND a.attnum=d.objsubid) LEFT JOIN pg_catalog.pg_attrdef f ON (a.attrelid=f.adrelid AND a.attnum=f.adnum) WHERE a.attnum>0 AND c.oid=a.attrelid AND n.oid=c.relnamespace AND a.atttypid=q.oid AND c.relkind in ('r','v')AND has_schema_privilege(n.oid, 'USAGE'::text)\?\?\?\?\? ORDER BY 2,3,17");
TCHAR c_SQLProcedureColumns[]                = _T("SELECT NULL,n.nspname,p.proname,CASE WHEN a.n=0 THEN''::text ELSE NULLIF(p.proargnames[a.n],''::text)END,NULL,CASE WHEN a.n=0 THEN p.prorettype ELSE p.proargtypes[a.n-1]END,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,a.n,NULL FROM current_database()g,pg_catalog.pg_proc p,pg_catalog.pg_namespace n,(SELECT 0 UNION SELECT information_schema._pg_keypositions())a(n)WHERE n.oid=p.pronamespace AND has_schema_privilege(n.oid, 'USAGE'::text) AND p.pronargs>=a.n\?\?\?\? ORDER BY 1,2,3");
TCHAR c_SQLProcedures_query[]                = _T("SELECT DISTINCT g,n.nspname,p.proname,'','','',d.description,CASE WHEN p.prorettype = 0 THEN 1 ELSE 2 END FROM current_database() g,pg_catalog.pg_namespace n, pg_catalog.pg_proc p LEFT JOIN pg_catalog.pg_description d ON (p.oid=d.objoid AND d.objsubid=0) WHERE p.pronamespace = n.oid AND pg_catalog.has_function_privilege(p.oid,'EXECUTE')AND has_schema_privilege(n.oid, 'USAGE'::text)\?\?\?\? ORDER BY 1,2,3");
TCHAR c_SQLStatistics_query[]                = _T("SELECT w.g,w.nspname,w.relname,i.unique,i.conname,i.conname,i.type,a.n,t.attname,'A'::char,NULL,COALESCE(i.pages,w.relpages),i.consrc FROM (SELECT c.oid,c.relpages,g,n.nspname,c.relname FROM current_database()g,pg_catalog.pg_namespace n,pg_catalog.pg_class c WHERE c.relnamespace=n.oid\?\?\?\?\?)w LEFT JOIN(SELECT 3 AS type,NULL AS pages,1 AS unique,conrelid,conname,conkey,consrc FROM pg_catalog.pg_constraint WHERE contype='c' UNION SELECT CASE WHEN i.indisclustered THEN 1 WHEN m.amname='hash'THEN 2 ELSE 3 END,c.relpages,CASE WHEN i.indisunique THEN 0 ELSE 1 END,i.indrelid,c.relname,i.indkey,NULL FROM pg_catalog.pg_index i LEFT JOIN pg_catalog.pg_class c ON c.oid=i.indexrelid,pg_catalog.pg_am m WHERE m.oid=c.relam)i ON(i.conrelid=w.oid),(SELECT * FROM generate_series(1,current_setting('max_index_keys')::int,1))a(n),pg_catalog.pg_attribute t WHERE t.attrelid=w.oid AND t.attnum=i.conkey[a.n-1] ORDER BY 4,7,5,6,8");
TCHAR c_SQLPrimaryKeys_query[]               = _T("SELECT g,n.nspname,c.relname,ta.attname,i.conkey[a.n],i.conname FROM current_database()g,pg_catalog.pg_namespace n,pg_catalog.pg_class c,pg_catalog.pg_attribute ta,pg_catalog.pg_constraint i,(SELECT * FROM generate_series(1,current_setting('max_index_keys')::int,1))a(n)WHERE c.oid=i.conrelid AND n.oid=c.relnamespace AND i.contype='p'::char AND ta.attrelid=i.conrelid AND ta.attnum=i.conkey[a.n]AND(NOT ta.attisdropped)AND has_schema_privilege(n.oid, 'USAGE'::text)\?\?\?\?\? ORDER BY 5");
TCHAR c_SQLForeignKeys_query_1[]             = _T("SELECT g,n.nspname,c.relname,a.attname,g,fn.nspname,fc.relname,fa.attname,b.n,NULL,NULL,f.conname,pr.conname,CASE WHEN NOT f.condeferred THEN 7 WHEN f.condeferrable THEN 5 ELSE 6 END FROM current_database()g,pg_catalog.pg_attribute a,pg_catalog.pg_attribute fa,pg_catalog.pg_class c,pg_catalog.pg_class fc,pg_catalog.pg_namespace n,pg_catalog.pg_namespace fn,pg_catalog.pg_constraint f left join pg_catalog.pg_constraint pr on(f.conrelid=pr.conrelid and pr.contype='p'),(SELECT * FROM generate_series(1,current_setting('max_index_keys')::int,1))b(n)WHERE fn.oid=fc.relnamespace AND n.oid=c.relnamespace AND c.oid=f.confrelid AND fc.oid=f.conrelid AND a.attrelid=f.confrelid AND fa.attrelid=f.conrelid AND a.attnum=f.confkey[b.n]AND fa.attnum=f.conkey[b.n]AND f.contype='f'AND f.conkey[b.n]<>0 AND has_schema_privilege(n.oid, 'USAGE'::text)\?\?\?\?\?");
TCHAR c_SQLForeignKeys_query_2[]             = _T("SELECT g,n.nspname,pc.relname,pa.attname,g,n.nspname,c.relname,a.attname,b.n,NULL,NULL,f.conname,pr.conname,CASE WHEN NOT f.condeferred THEN 7 WHEN f.condeferrable THEN 5 ELSE 6 END FROM current_database()g,pg_catalog.pg_attribute a,pg_catalog.pg_attribute pa,pg_catalog.pg_class c,pg_catalog.pg_class pc,pg_catalog.pg_namespace n,pg_catalog.pg_namespace pn,pg_catalog.pg_constraint f left join pg_catalog.pg_constraint pr on(f.conrelid=pr.conrelid and pr.contype='p'),(SELECT * FROM generate_series(1,current_setting('max_index_keys')::int,1))b(n)WHERE n.oid=c.relnamespace AND pn.oid=pc.relnamespace AND pc.oid=f.confrelid AND c.oid=f.conrelid AND pa.attrelid=f.confrelid AND a.attrelid=f.conrelid AND pa.attnum=f.confkey[b.n]AND a.attnum=f.conkey[b.n]AND f.contype='f'AND f.conkey[b.n]<>0 AND has_schema_privilege(n.oid, 'USAGE'::text)\?\?\?\?\?");
TCHAR c_SQLTablePrivileges_8_0_query[]       = _T("SELECT g,n.nspname,c.relname,CASE WHEN u.usename=o.usename THEN'_SYSTEM'::text ELSE u.usename END,o.usename,p.type,CASE WHEN aclcontains(c.relacl,makeaclitem(o.usesysid,0,u.usesysid,p.type,TRUE))THEN'YES'::text ELSE'NO'::text END FROM current_database()g,pg_catalog.pg_class c,pg_catalog.pg_namespace n,pg_catalog.pg_user u,(SELECT z.usename,z.usesysid,x.grosysid FROM pg_catalog.pg_user z LEFT JOIN pg_catalog.pg_group x ON z.usesysid=ANY(x.grolist))o,((((((SELECT'SELECT'UNION ALL SELECT'DELETE')UNION ALL SELECT'INSERT')UNION ALL SELECT'UPDATE')UNION ALL SELECT'REFERENCES')UNION ALL SELECT'RULE')UNION ALL SELECT'TRIGGER')p(type)WHERE c.relnamespace=n.oid AND(c.relkind in('r'::char,'v'::char)AND(c.relowner=o.usesysid AND u.usesysid=c.relowner) OR (aclcontains(c.relacl,makeaclitem(0,0,u.usesysid,p.type,FALSE))OR aclcontains(c.relacl,makeaclitem(o.usesysid,0,u.usesysid,p.type,FALSE))OR aclcontains(c.relacl,makeaclitem(0,o.grosysid,u.usesysid,p.type,FALSE))))\?\?\?\?\? ORDER BY 1,2,3,6,5");
TCHAR c_SQLTablePrivileges_8_1_query[]       = _T("SELECT g,n.nspname,c.relname,CASE WHEN u.usename=o.usename THEN'_SYSTEM'::text ELSE u.usename END,o.usename,p.type,CASE WHEN aclcontains(c.relacl,makeaclitem(o.usesysid,u.usesysid,p.type,TRUE))THEN'YES'::text ELSE'NO'::text END FROM current_database()g,pg_catalog.pg_class c,pg_catalog.pg_namespace n,pg_catalog.pg_user u,(SELECT z.usename,z.usesysid,x.grosysid FROM pg_catalog.pg_user z LEFT JOIN pg_catalog.pg_group x ON z.usesysid=ANY(x.grolist))o,((((((SELECT'SELECT'UNION ALL SELECT'DELETE')UNION ALL SELECT'INSERT')UNION ALL SELECT'UPDATE')UNION ALL SELECT'REFERENCES')UNION ALL SELECT'RULE')UNION ALL SELECT'TRIGGER')p(type)WHERE c.relnamespace=n.oid AND(c.relkind in('r'::char,'v'::char)AND(c.relowner=o.usesysid AND u.usesysid=c.relowner) OR (aclcontains(c.relacl,makeaclitem(0,u.usesysid,p.type,FALSE))OR aclcontains(c.relacl,makeaclitem(o.usesysid,u.usesysid,p.type,FALSE))OR aclcontains(c.relacl,makeaclitem(o.grosysid,u.usesysid,p.type,FALSE))))\?\?\?\?\? ORDER BY 1,2,3,6,5");
TCHAR c_SQLColumnPrivileges_8_0_query[]      = _T("SELECT DISTINCT g,n.nspname,c.relname,a.attname,CASE WHEN u.usename=o.usename THEN'_SYSTEM'::text ELSE u.usename END,o.usename,p.type,CASE WHEN aclcontains(c.relacl,makeaclitem(o.usesysid,0,u.usesysid,p.type,TRUE))THEN'YES'::text ELSE'NO'::text END FROM current_database()g,pg_catalog.pg_class c,pg_catalog.pg_namespace n,pg_catalog.pg_user u,(SELECT z.usename,z.usesysid,x.grosysid FROM pg_catalog.pg_user z LEFT JOIN pg_catalog.pg_group x ON z.usesysid=ANY(x.grolist))o,((((((SELECT'SELECT'UNION ALL SELECT'DELETE')UNION ALL SELECT'INSERT')UNION ALL SELECT'UPDATE')UNION ALL SELECT'REFERENCES')UNION ALL SELECT'RULE')UNION ALL SELECT'TRIGGER')p(type),pg_catalog.pg_attribute a WHERE a.attnum>0 AND NOT a.attisdropped AND a.attrelid = c.oid ")_T("AND c.relnamespace=n.oid AND(c.relkind in('r'::char,'v'::char)AND(c.relowner=o.usesysid AND u.usesysid=c.relowner) OR (aclcontains(c.relacl,makeaclitem(0,0,u.usesysid,p.type,FALSE))OR aclcontains(c.relacl,makeaclitem(o.usesysid,0,u.usesysid,p.type,FALSE))OR aclcontains(c.relacl,makeaclitem(0,o.grosysid,u.usesysid,p.type,FALSE))))\?\?\?\?\? ORDER BY 1,2,3,4,7");
TCHAR c_SQLColumnPrivileges_8_1_query[]      = _T("SELECT DISTINCT g,n.nspname,c.relname,a.attname,CASE WHEN u.usename=o.usename THEN'_SYSTEM'::text ELSE u.usename END,o.usename,p.type,CASE WHEN aclcontains(c.relacl,makeaclitem(o.usesysid,u.usesysid,p.type,TRUE))THEN'YES'::text ELSE'NO'::text END FROM current_database()g,pg_catalog.pg_class c,pg_catalog.pg_namespace n,pg_catalog.pg_user u,(SELECT z.usename,z.usesysid,x.grosysid FROM pg_catalog.pg_user z LEFT JOIN pg_catalog.pg_group x ON z.usesysid=ANY(x.grolist))o,((((((SELECT'SELECT'UNION ALL SELECT'DELETE')UNION ALL SELECT'INSERT')UNION ALL SELECT'UPDATE')UNION ALL SELECT'REFERENCES')UNION ALL SELECT'RULE')UNION ALL SELECT'TRIGGER')p(type),pg_catalog.pg_attribute a WHERE a.attnum>0 AND NOT a.attisdropped AND a.attrelid = c.oid ")_T("AND c.relnamespace=n.oid AND(c.relkind in('r'::char,'v'::char)AND(c.relowner=o.usesysid AND u.usesysid=c.relowner) OR (aclcontains(c.relacl,makeaclitem(0,u.usesysid,p.type,FALSE))OR aclcontains(c.relacl,makeaclitem(o.usesysid,u.usesysid,p.type,FALSE))OR aclcontains(c.relacl,makeaclitem(o.grosysid,u.usesysid,p.type,FALSE))))\?\?\?\?\? ORDER BY 1,2,3,4,7");
TCHAR c_SQLSpecialColumns_ROWVER_query[]     = _T("SELECT 260,'ctid',1043,'varchar',NULL,NULL,NULL,NULL UNION SELECT -1,'oid',26,'oid',NULL,NULL,NULL,NULL FROM current_database() g,pg_catalog.pg_class c, pg_catalog.pg_namespace n WHERE c.relnamespace = n.oid AND c.relhasoids AND has_schema_privilege(n.oid, 'USAGE'::text)\?\?\?\?\?");
TCHAR c_SQLSpecialColumns_BEST_ROWID_query[] = _T("SELECT a.atttypmod,a.attname,a.atttypid,q.typname,null,null,null,null FROM current_database() g,pg_catalog.pg_type q,pg_catalog.pg_namespace n,pg_catalog.pg_class c,pg_catalog.pg_attribute a,pg_catalog.pg_constraint i,(SELECT * FROM generate_series(1,current_setting('max_index_keys')::int,1))k(n) WHERE c.oid=i.conrelid AND i.contype='p'::char AND a.attnum>0 AND a.attrelid=i.conrelid AND c.oid=a.attrelid AND n.oid=c.relnamespace AND a.atttypid=q.oid AND c.relkind in ('r')AND a.attnum=i.conkey[k.n]AND(NOT a.attisdropped) AND has_schema_privilege(n.oid, 'USAGE'::text)\?\?\?\?\? ORDER BY 2");

TCHAR c_SQLTables_ST[]  = _T(" when(n.nspname='pg_catalog')then'SYSTEM TABLE'");
TCHAR c_SQLTables_T[]   = _T(" when(c.relkind='r')then'TABLE'");
TCHAR c_SQLTables_V[]   = _T(" when(c.relkind='v')then'VIEW'");
TCHAR c_SQLTables_ST_[] = _T("(n.nspname='pg_catalog'and c.relkind in('r','v'))");
/* WARNING! following string must begin from ' or ', used in SQLTables */
TCHAR c_SQLTables_V_[]  = _T(" or (n.nspname<>'pg_catalog'and c.relkind='v')");
TCHAR c_SQLTables_T_[]  = _T(" or (n.nspname<>'pg_catalog'and c.relkind='r')");

/* for CompileCSOCQuery(...) */
TCHAR c_query_catalog[]   = _T(" AND g\?'\?'");
TCHAR c_query_procedure[] = _T(" AND p.proname\?'\?'");
TCHAR c_query_schema[]    = _T(" AND n.nspname\?'\?'");
TCHAR c_query_table[]     = _T(" AND c.relname\?'\?'");
TCHAR c_query_column[]    = _T(" AND a.attname\?'\?'");
TCHAR c_query_like[]      = _T(" LIKE");
TCHAR c_query_equal[]     = _T("=");

#define ADD_NUMERIC_FIELD(numeric, column)	_itot(numeric, buffer, 10); \
                                            pBuffer = AddField(pStatement, length = _tcslen(buffer)); \
                                            _tcsncpy(pBuffer, buffer, length); \
                                            pIRD->id_records[column].common.data_ptr[nRowsResulted] = ((BYTE*)pBuffer)-sizeof(int);
#define IS_INTERVAL_DATA_TYPE(concise)   (SQL_TYPE_DATE == concise || SQL_TYPE_TIME == concise || SQL_TYPE_TIMESTAMP == concise || SQL_DATE == concise || SQL_TIME == concise || SQL_TIMESTAMP == concise)
/*-----------------------------------------------------------------------------
 * SQLColumns
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLColumns_(SQLHSTMT StatementHandle,
            SQLTCHAR *CatalogName, SQLSMALLINT CatalogNameLength,
            SQLTCHAR *SchemaName,  SQLSMALLINT SchemaNameLength,
            SQLTCHAR *TableName,   SQLSMALLINT TableNameLength,
            SQLTCHAR *ColumnName,  SQLSMALLINT ColumnNameLength)
{
	SQLRETURN    nRet       = SQL_ERROR;
	unsigned int conv       = TC_AS_IS;
	SQLTCHAR*    query      = NULL;
	Statement*   pStatement = (Statement*) StatementHandle;
	int          nRowsResulted = 0;
		
	ENTER_STMT(StatementHandle, _T("SQLColumns"));

	while ((conv < TC_STOP) && (SQL_ERROR != (nRet = ResetStatement(pStatement))))
	{
		if (NULL != (query = CompileCSOCQuery(pStatement, c_SQLColumns_query, conv, CatalogName, CatalogNameLength, SchemaName, SchemaNameLength, TableName, TableNameLength, ColumnName, ColumnNameLength, CSOC_OBJ_TABLE)))
		{
			if ((SQL_ERROR != (nRet = PrepareQuery(pStatement, query, SQL_NTS, QO_IGNORE_BOOKMARK | QO_FORCE_BUFFERING))) &&
			    (SQL_ERROR != (nRet = ExecuteStatement(pStatement, TRUE))) &&
					(0 == pStatement->ird->header.array_size)
			   )
				++conv;
			else
				conv = TC_STOP;
			FREE(query);
		}
		else
		{
			SetError(SQL_HANDLE_STMT, StatementHandle, ERR_NOT_ENOUGH_MEMORY, NULL);
			conv = TC_STOP;
			nRet = SQL_ERROR;
		}
	}

	if (SQL_SUCCEEDED(nRet))
	{/* rename columns */
		SQLUINTEGER odbc_version = pStatement->connection->environment->attributes.odbc_version;
		/* choose correct data to return - ODBC 2.0 (15) and ODBC 3.0 (18) have different resultsets */
		int nColumns = (SQL_OV_ODBC2 == odbc_version) ? 15 : 18;
		BOOL mjet = pStatement->connection->mjet;

		Descriptor* pIRD = GET_DESCRIPTOR(pStatement->ird);
		SetDescField(pIRD, 0, SQL_DESC_COUNT, (SQLPOINTER)(SQLLEN_TO_POINTER) nColumns, SQL_IS_SMALLINT);
		RET_DESCRIPTOR(pIRD);

		RenameColumns(pStatement, c_ColumnsColumns, nColumns);
		/* -- handmade resultset -- */
		if (0 < (nRowsResulted = pStatement->ird->header.array_size))
		{
			int   length;
			TCHAR buffer[20];
		
			TCHAR* null_field;
			TCHAR* catalog;

			TCHAR* pBuffer;

			pIRD = GET_DESCRIPTOR(pStatement->ird);

			/* save catalog name */
			catalog = AddField(pStatement, length = _tcslen(pStatement->connection->parameters[DATABASE_PARAM]));
			_tcsncpy(catalog, pStatement->connection->parameters[DATABASE_PARAM], length);
			catalog -= sizeof(int)/sizeof(TCHAR);
			/* null field */
			null_field = AddField(pStatement, 0);
			null_field -= sizeof(int)/sizeof(TCHAR);

			/* prepare resultset */
			for (--nRowsResulted;0<=nRowsResulted;nRowsResulted--)
			{				
				SQLSMALLINT concise_sql_type;
				SQLSMALLINT precision;
				SQLINTEGER  num_prec_radix;
				SQLINTEGER  type_length;
				SQLINTEGER  data_size;
				SQLSMALLINT type;

				TCHAR*      oid_ptr  = (TCHAR*)((SQLINTEGER*)pIRD->id_records[4].common.data_ptr[nRowsResulted]+1);
				TCHAR*      mod_ptr  = (TCHAR*)((SQLINTEGER*)pIRD->id_records[0].common.data_ptr[nRowsResulted]+1);
				SQLINTEGER  oid_len  = *((SQLINTEGER*)oid_ptr-1);
				SQLINTEGER  mod_len  = *((SQLINTEGER*)mod_ptr-1);

				SQLINTEGER  oid      = GetInt(&oid_ptr, 0, &oid_len, 10);
				SQLINTEGER  modifier = GetInt(&mod_ptr, 0, &mod_len, 10);

				PostgreTypeToSQLType(oid, modifier, odbc_version, NULL, &concise_sql_type, &type_length, &precision, mjet);
				DescribeSQLType(concise_sql_type, type_length, precision, &type, &data_size, &num_prec_radix, NULL);
				
				/* TABLE_CAT */
				pIRD->id_records[0].common.data_ptr[nRowsResulted] = catalog;
				/* TABLE_SCHEM */
				/* TABLE_NAME */
				/* COLUMN_NAME */
				/* DATA_TYPE */
				ADD_NUMERIC_FIELD(concise_sql_type, 4);
				/* TYPE_NAME */
				/* COLUMN_SIZE */
				ADD_NUMERIC_FIELD(data_size, 6);
				/* BUFFER_LENGTH */
				ADD_NUMERIC_FIELD(GetCTypeLength(GetCDefaultType(concise_sql_type), (SQL_NUMERIC == concise_sql_type || SQL_DECIMAL == concise_sql_type) ? (type_length + 2) : type_length), 7);
				/* DECIMAL_DIGITS */
				if (0 < num_prec_radix)
				{
					ADD_NUMERIC_FIELD(precision, 8);
				}
				/* NUM_PREC_RADIX */
				if (0 < num_prec_radix)
				{
					ADD_NUMERIC_FIELD(num_prec_radix, 9);
				}
				/* NULLABLE */
				/* REMARKS */
				/* COLUMN_DEF */
				/* SQL_DATA_TYPE */
				ADD_NUMERIC_FIELD(type, 13);
				/* SQL_DATETIME_SUB */
				if IS_INTERVAL_DATA_TYPE(concise_sql_type)
				{
					ADD_NUMERIC_FIELD(GetIntervalSubType(concise_sql_type), 14);
				}
				/* CHAR_OCTET_LENGTH */

				/* ORDINAL_POSITION */
				/* IS_NULLABLE */
			}
			RET_DESCRIPTOR(pIRD);
		}
	}
	LEAVE_STMT(StatementHandle, nRet);
}

/*-----------------------------------------------------------------------------
 * SQLDriverConnect
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLDriverConnect_(SQLHDBC ConnectionHandle, SQLHWND hwnd,
                  SQLTCHAR* ConnStrIn,  SQLSMALLINT ConnStrInLength,
                  SQLTCHAR* ConnStrOut, SQLSMALLINT ConnStrOutMax,
                  SQLSMALLINT* pcbConnStrOut, SQLUSMALLINT fDriverCompletion
								 )
{
	SQLRETURN nRet;
	SQLRETURN nRes;
	Connection* pConnection = (Connection*) ConnectionHandle;

	ENTER_CONN(ConnectionHandle, _T("SQLDriverConnect"));
	ConnStrOutMax = BYTES_TO_CHARACTERS(ConnStrOutMax);

	/* parse input connection string */	
	switch (nRes = ParseConnectionString(pConnection, ConnStrIn, ConnStrInLength))
	{
		case SQL_NEED_DATA:
			switch (fDriverCompletion)
			{
				case SQL_DRIVER_NOPROMPT:
					nRet = SQL_ERROR;
					break;
				case SQL_DRIVER_COMPLETE:
				case SQL_DRIVER_COMPLETE_REQUIRED:
				case SQL_DRIVER_PROMPT:
#ifdef WIN32
				{
					TCHAR* parameters[DS_PARAMETERS_NUMBER+1];
					int i;

					parameters[DS_PARAMETERS_NUMBER] = NULL;
					memcpy(&parameters, &pConnection->parameters, sizeof(pConnection->parameters));

					for (i=0;i<DS_CHECKBOX_PARAMETERS_NUMBER;++i)
						if (_T('\0') == *pConnection->parameters[i])
							_tcscpy(pConnection->parameters[i], c_stDSParameters[i].szDefaultValue);

					nRet = (hwnd) ? (((IDOK == DialogBoxParam(g_hModule, MAKEINTRESOURCE(DLG_LOGIN), hwnd, (DLGPROC)ConfigDlgProc, (LPARAM) &parameters)) && (_T('\0') != parameters[UID_PARAM][0])) ? SQL_SUCCESS : SQL_NO_DATA) : SQL_ERROR;
				}
#else
					nRet = SQL_ERROR;
#endif /* WIN32 */
				if (!SQL_SUCCEEDED(nRet))
					SetError(SQL_HANDLE_DBC, pConnection, ERR_FAILED_LOGIN_DLG, NULL);
					break;
				default:
					;
			}
			if (!SQL_SUCCEEDED(nRet))
			{
				SetError(SQL_HANDLE_DBC, pConnection, ERR_NEED_LOGIN_INFO, NULL);
				break;
			}
			nRes = SQL_SUCCESS;
		/* no break! */
		case SQL_SUCCESS_WITH_INFO:
		case SQL_SUCCESS:
			if (SQL_SUCCESS == (nRet = Connect(pConnection)))
				nRet = nRes;
			break;
		default:
			nRet = SQL_ERROR;
	}

	if (!SQL_SUCCEEDED(nRet) || (nRet == SQL_NO_DATA))
	{
		memset(&pConnection->parameters_buffer, 0, sizeof(pConnection->parameters_buffer));
		memset(&pConnection->dsn, 0, sizeof(pConnection->dsn));
	} else {
		nRes = PrepareConnectionString(ConnStrOut, ConnStrOutMax, pcbConnStrOut, pConnection->parameters, pConnection->dsn);
		if (SQL_SUCCESS_WITH_INFO == nRes)
		{
			SetError(SQL_HANDLE_DBC, pConnection, ERR_TOO_SMALL_BUFFER, _T("ConnStrOut"), NULL);
			nRet = MAX_ERROR(nRet, nRes);
		}
	}

	LEAVE_CONN(ConnectionHandle, nRet);
}

/*-----------------------------------------------------------------------------
 * FUNCTION: SQLGetData
 *
 * DESCRIPTION: returns the data in a specified column
 *
 *  -- relaxed restrictions ---------------------------------------------------
 *  1. SQL_GD_BOUND - applicable for any column in result set (including bound)
 *  2. SQL_GD_ANY_ORDER - can be called in any order for unbound columns
 *  3. SQL_GD_ANY_COLUMN - can be called for any unbound column before the last
 *                         bound column
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLGetData(SQLHSTMT StatementHandle, SQLUSMALLINT ColumnNumber, SQLSMALLINT TargetType,
           SQLPOINTER TargetValue, SQLLEN BufferLength, SQLLEN* StrLen_or_Ind)
{
	SQLRETURN nRet;

	ENTER_STMT(StatementHandle, _T("SQLGetData"));
	nRet = GetData((Statement*) StatementHandle, ColumnNumber, TargetType, TargetValue, BufferLength, StrLen_or_Ind);
	LEAVE_STMT(StatementHandle, nRet);
}

/*-----------------------------------------------------------------------------
 * SQLGetFunctions
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLGetFunctions(SQLHDBC ConnectionHandle, SQLUSMALLINT FunctionId, SQLUSMALLINT *Supported)
{
	ENTER_CONN(ConnectionHandle, _T("SQLGetFunctions"));
	switch(FunctionId)
	{
		/* ODBC 3.0 and earlier */
		case SQL_API_ODBC3_ALL_FUNCTIONS:
			memset(Supported, SQL_FALSE, SQL_API_ODBC3_ALL_FUNCTIONS_SIZE*sizeof(SQLUSMALLINT));
			
			/* ODBC core level api */
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLALLOCHANDLE);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLBINDCOL);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLBINDPARAMETER);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLCANCEL);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLCLOSECURSOR);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLCOLATTRIBUTE);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLCOLUMNS);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLCONNECT);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLCOPYDESC);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLDATASOURCES);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLDESCRIBECOL);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLDISCONNECT);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLDRIVERCONNECT);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLDRIVERS);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLENDTRAN);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLEXECDIRECT);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLEXECUTE);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLFETCH);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLFETCHSCROLL);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLFREEHANDLE);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLFREESTMT);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLGETCONNECTATTR);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLGETCURSORNAME);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLGETDATA);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLGETDESCFIELD);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLGETDESCREC);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLGETDIAGFIELD);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLGETDIAGREC);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLGETENVATTR);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLGETFUNCTIONS);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLGETINFO);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLGETSTMTATTR);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLGETTYPEINFO);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLNATIVESQL);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLNUMPARAMS);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLNUMRESULTCOLS);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLPARAMDATA);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLPREPARE);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLPUTDATA);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLROWCOUNT);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLSETCONNECTATTR);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLSETCURSORNAME);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLSETDESCFIELD);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLSETDESCREC);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLSETENVATTR);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLSETSTMTATTR);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLSPECIALCOLUMNS);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLSTATISTICS);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLTABLES);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLEXTENDEDFETCH);
			
			/* ODBC level 1 api */
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLBROWSECONNECT);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLBULKOPERATIONS);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLMORERESULTS);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLPRIMARYKEYS);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLPROCEDURECOLUMNS);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLPROCEDURES);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLSETPOS);

			/* ODBC level 2 api */
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLCOLUMNPRIVILEGES);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLDESCRIBEPARAM);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLFOREIGNKEYS);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLTABLEPRIVILEGES);
			
			/* deprecated */
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLALLOCCONNECT);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLALLOCENV);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLALLOCSTMT);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLBINDPARAM);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLCOLATTRIBUTES);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLERROR);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLFREECONNECT);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLFREEENV);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLGETCONNECTOPTION);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLGETSTMTOPTION);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLPARAMOPTIONS);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLSETCONNECTOPTION);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLSETPARAM);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLSETSCROLLOPTIONS);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLSETSTMTOPTION);
			SQL_FUNC_IMPLEMENTED(Supported, SQL_API_SQLTRANSACT);
			break;
		/* ODBC 2.0 and earlier */
		case SQL_API_ALL_FUNCTIONS:
			memset(Supported, SQL_FALSE, 100*sizeof(SQLUSMALLINT));

			/* ODBC core level api */
			Supported[SQL_API_SQLALLOCHANDLE]   = SQL_TRUE;
			Supported[SQL_API_SQLBINDCOL]       = SQL_TRUE;
			Supported[SQL_API_SQLBINDPARAMETER] = SQL_TRUE;
			Supported[SQL_API_SQLCANCEL]        = SQL_TRUE;
			Supported[SQL_API_SQLCLOSECURSOR]   = SQL_TRUE;
			Supported[SQL_API_SQLCOLATTRIBUTE]  = SQL_TRUE;
			Supported[SQL_API_SQLCOLUMNS]       = SQL_TRUE;
			Supported[SQL_API_SQLCONNECT]       = SQL_TRUE;
			Supported[SQL_API_SQLCOPYDESC]      = SQL_TRUE;
			Supported[SQL_API_SQLDATASOURCES]   = SQL_TRUE;
			Supported[SQL_API_SQLDESCRIBECOL]   = SQL_TRUE;
			Supported[SQL_API_SQLDISCONNECT]    = SQL_TRUE;
			Supported[SQL_API_SQLDRIVERCONNECT] = SQL_TRUE;
			Supported[SQL_API_SQLDRIVERS]       = SQL_TRUE;
			Supported[SQL_API_SQLENDTRAN]       = SQL_TRUE;
			Supported[SQL_API_SQLEXECDIRECT]    = SQL_TRUE;
			Supported[SQL_API_SQLEXECUTE]       = SQL_TRUE;
			Supported[SQL_API_SQLFETCH]         = SQL_TRUE;
			Supported[SQL_API_SQLFETCHSCROLL]   = SQL_TRUE;
			Supported[SQL_API_SQLFREEHANDLE]    = SQL_TRUE;
			Supported[SQL_API_SQLFREESTMT]      = SQL_TRUE;
			Supported[SQL_API_SQLGETCONNECTATTR]= SQL_TRUE;
			Supported[SQL_API_SQLGETCURSORNAME] = SQL_TRUE;
			Supported[SQL_API_SQLGETDATA]       = SQL_TRUE;
			Supported[SQL_API_SQLGETDESCFIELD]  = SQL_TRUE;
			Supported[SQL_API_SQLGETDESCREC]    = SQL_TRUE;
			Supported[SQL_API_SQLGETDIAGFIELD]  = SQL_TRUE;
			Supported[SQL_API_SQLGETDIAGREC]    = SQL_TRUE;
			Supported[SQL_API_SQLGETENVATTR]    = SQL_TRUE;
			Supported[SQL_API_SQLGETFUNCTIONS]  = SQL_TRUE;
			Supported[SQL_API_SQLGETINFO]       = SQL_TRUE;
			Supported[SQL_API_SQLGETSTMTATTR]   = SQL_TRUE;
			Supported[SQL_API_SQLGETTYPEINFO]   = SQL_TRUE;
			Supported[SQL_API_SQLNATIVESQL]     = SQL_TRUE;
			Supported[SQL_API_SQLNUMPARAMS]     = SQL_TRUE;
			Supported[SQL_API_SQLNUMRESULTCOLS] = SQL_TRUE;
			Supported[SQL_API_SQLPARAMDATA]     = SQL_TRUE;
			Supported[SQL_API_SQLPREPARE]       = SQL_TRUE;
			Supported[SQL_API_SQLPUTDATA]       = SQL_TRUE;
			Supported[SQL_API_SQLROWCOUNT]      = SQL_TRUE;
			Supported[SQL_API_SQLSETCONNECTATTR]= SQL_TRUE;
			Supported[SQL_API_SQLSETCURSORNAME] = SQL_TRUE;
			Supported[SQL_API_SQLSETDESCFIELD]  = SQL_TRUE;
			Supported[SQL_API_SQLSETDESCREC]    = SQL_TRUE;
			Supported[SQL_API_SQLSETENVATTR]    = SQL_TRUE;
			Supported[SQL_API_SQLSETSTMTATTR]   = SQL_TRUE;
			Supported[SQL_API_SQLSPECIALCOLUMNS]= SQL_TRUE;
			Supported[SQL_API_SQLSTATISTICS]    = SQL_TRUE;
			Supported[SQL_API_SQLTABLES]        = SQL_TRUE;
			Supported[SQL_API_SQLEXTENDEDFETCH] = SQL_TRUE;
			
			/* ODBC level 1 api */
			Supported[SQL_API_SQLBROWSECONNECT]    = SQL_TRUE;
			Supported[SQL_API_SQLBULKOPERATIONS]   = SQL_TRUE;
			Supported[SQL_API_SQLMORERESULTS]      = SQL_TRUE;
			Supported[SQL_API_SQLPRIMARYKEYS]      = SQL_TRUE;
			Supported[SQL_API_SQLPROCEDURECOLUMNS] = SQL_TRUE;
			Supported[SQL_API_SQLPROCEDURES]       = SQL_TRUE;
			Supported[SQL_API_SQLSETPOS]           = SQL_TRUE;

			/* ODBC level 2 api */
			Supported[SQL_API_SQLCOLUMNPRIVILEGES] = SQL_TRUE;
			Supported[SQL_API_SQLDESCRIBEPARAM]    = SQL_TRUE;
			Supported[SQL_API_SQLFOREIGNKEYS]      = SQL_TRUE;
			Supported[SQL_API_SQLTABLEPRIVILEGES]  = SQL_TRUE;
			
			/* deprecated */
			Supported[SQL_API_SQLALLOCCONNECT]     = SQL_TRUE;
			Supported[SQL_API_SQLALLOCENV]         = SQL_TRUE;
			Supported[SQL_API_SQLALLOCSTMT]        = SQL_TRUE;
			Supported[SQL_API_SQLBINDPARAM]        = SQL_TRUE;
			Supported[SQL_API_SQLCOLATTRIBUTES]    = SQL_TRUE;
			Supported[SQL_API_SQLERROR]            = SQL_TRUE;
			Supported[SQL_API_SQLFREECONNECT]      = SQL_TRUE;
			Supported[SQL_API_SQLFREEENV]          = SQL_TRUE;
			Supported[SQL_API_SQLGETCONNECTOPTION] = SQL_TRUE;
			Supported[SQL_API_SQLGETSTMTOPTION]    = SQL_TRUE;
			Supported[SQL_API_SQLPARAMOPTIONS]     = SQL_TRUE;
			Supported[SQL_API_SQLSETCONNECTOPTION] = SQL_TRUE;
			Supported[SQL_API_SQLSETPARAM]         = SQL_TRUE;
			Supported[SQL_API_SQLSETSCROLLOPTIONS] = SQL_TRUE;
			Supported[SQL_API_SQLSETSTMTOPTION]    = SQL_TRUE;
			Supported[SQL_API_SQLTRANSACT]         = SQL_TRUE;
			break;
		/* single ODBC function id */
		default:
			/* only for ODBC 2.0 and earlier */
			switch(FunctionId)
			{
				/* ODBC core level api */
				case SQL_API_SQLALLOCHANDLE:
				case SQL_API_SQLBINDCOL:
				case SQL_API_SQLBINDPARAMETER:
				case SQL_API_SQLCANCEL:
				case SQL_API_SQLCLOSECURSOR:
				case SQL_API_SQLCOLATTRIBUTE:
				case SQL_API_SQLCOLUMNS:
				case SQL_API_SQLCONNECT:
				case SQL_API_SQLCOPYDESC:
				case SQL_API_SQLDATASOURCES:
				case SQL_API_SQLDESCRIBECOL:
				case SQL_API_SQLDISCONNECT:
				case SQL_API_SQLDRIVERCONNECT:
				case SQL_API_SQLDRIVERS:
				case SQL_API_SQLENDTRAN:
				case SQL_API_SQLEXECDIRECT:
				case SQL_API_SQLEXECUTE:
				case SQL_API_SQLFETCH:
				case SQL_API_SQLFETCHSCROLL:
				case SQL_API_SQLFREEHANDLE:
				case SQL_API_SQLFREESTMT:
				case SQL_API_SQLGETCONNECTATTR:
				case SQL_API_SQLGETCURSORNAME:
				case SQL_API_SQLGETDATA:
				case SQL_API_SQLGETDESCFIELD:
				case SQL_API_SQLGETDESCREC:
				case SQL_API_SQLGETDIAGFIELD:
				case SQL_API_SQLGETDIAGREC:
				case SQL_API_SQLGETENVATTR:
				case SQL_API_SQLGETFUNCTIONS:
				case SQL_API_SQLGETINFO:
				case SQL_API_SQLGETSTMTATTR:
				case SQL_API_SQLGETTYPEINFO:
				case SQL_API_SQLNATIVESQL:
				case SQL_API_SQLNUMPARAMS:
				case SQL_API_SQLNUMRESULTCOLS:
				case SQL_API_SQLPARAMDATA:
				case SQL_API_SQLPREPARE:
				case SQL_API_SQLPUTDATA:
				case SQL_API_SQLROWCOUNT:
				case SQL_API_SQLSETCONNECTATTR:
				case SQL_API_SQLSETCURSORNAME:
				case SQL_API_SQLSETDESCFIELD:
				case SQL_API_SQLSETDESCREC:
				case SQL_API_SQLSETENVATTR:
				case SQL_API_SQLSETSTMTATTR:
				case SQL_API_SQLSPECIALCOLUMNS:
				case SQL_API_SQLSTATISTICS:
				case SQL_API_SQLTABLES:
				case SQL_API_SQLEXTENDEDFETCH:
					*Supported = SQL_TRUE;
					break;

				/* unsupported function or reserved */

				/* ODBC level 1 api */
				case SQL_API_SQLBROWSECONNECT:
				case SQL_API_SQLBULKOPERATIONS:
				case SQL_API_SQLMORERESULTS:
				case SQL_API_SQLPRIMARYKEYS:
				case SQL_API_SQLPROCEDURECOLUMNS:
				case SQL_API_SQLPROCEDURES:
				case SQL_API_SQLSETPOS:

				/* ODBC level 2 api */
				case SQL_API_SQLCOLUMNPRIVILEGES:
				case SQL_API_SQLDESCRIBEPARAM:
				case SQL_API_SQLFOREIGNKEYS:
				case SQL_API_SQLTABLEPRIVILEGES:
			
				/* deprecated */
				case SQL_API_SQLALLOCCONNECT:
				case SQL_API_SQLALLOCENV:
				case SQL_API_SQLALLOCSTMT:
				case SQL_API_SQLBINDPARAM:
/*				case SQL_API_SQLCOLATTRIBUTES: */
				case SQL_API_SQLERROR:
				case SQL_API_SQLFREECONNECT:
				case SQL_API_SQLFREEENV:
				case SQL_API_SQLGETCONNECTOPTION:
				case SQL_API_SQLGETSTMTOPTION:
				case SQL_API_SQLPARAMOPTIONS:
				case SQL_API_SQLSETCONNECTOPTION:
				case SQL_API_SQLSETPARAM:
				case SQL_API_SQLSETSCROLLOPTIONS:
				case SQL_API_SQLSETSTMTOPTION:
				case SQL_API_SQLTRANSACT:
				default:
					*Supported = SQL_TRUE;
			}
	}

	LEAVE_CONN(ConnectionHandle, SQL_SUCCESS);
}


/*-----------------------------------------------------------------------------
 * SQLGetInfo (READY)
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLGetInfo_(SQLHDBC ConnectionHandle, SQLUSMALLINT InfoType, SQLPOINTER InfoValue,
            SQLSMALLINT BufferLength, SQLSMALLINT *StringLength)
{
	SQLRETURN nRet;

	ENTER_CONN(ConnectionHandle, _T("SQLGetInfo"));
	nRet = GetConnectionInfo((Connection*)ConnectionHandle, InfoType, InfoValue, (SQLSMALLINT)BYTES_TO_CHARACTERS(BufferLength), StringLength);
	LEAVE_CONN(ConnectionHandle, nRet);
}

/*-----------------------------------------------------------------------------
 * FUNCTION: SQLGetTypeInfo
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLGetTypeInfo(SQLHSTMT StatementHandle, SQLSMALLINT DataType)
{
	SQLRETURN   nRet;
	SQLSMALLINT sql_type;
	TCHAR       buffer[100];
	TCHAR*      pBuffer;
	int         nRowsResulted;
	Descriptor* pIRD;
	int         i;

	ENTER_STMT(StatementHandle, _T("SQLGetTypeInfo"));
	if (SQL_ERROR != (nRet = ResetStatement((Statement*)StatementHandle)))
	{
		SQLUINTEGER odbc_version = ((Statement*)StatementHandle)->connection->environment->attributes.odbc_version;
		SQLINTEGER  interval_precision = 0;

		const TCHAR* prefix;
		const TCHAR* suffix;

		((Statement*)StatementHandle)->use_buffering |= TRUE;
		/* handmade resultset */
		pIRD = GET_DESCRIPTOR(((Statement*)StatementHandle)->ird);
		SetDescField(pIRD, 0, SQL_DESC_COUNT, (SQLPOINTER)(SQLSMALLINT)(sizeof(c_GetTypeInfoColumns)/sizeof(ColumnNameType)), SQL_IS_SMALLINT);
		RET_DESCRIPTOR(pIRD);
		RenameColumns((Statement*) StatementHandle, c_GetTypeInfoColumns, sizeof(c_GetTypeInfoColumns)/sizeof(ColumnNameType));

		/* prepare resultset */
		for (nRowsResulted=0,i=0;i<PSQL_DATATYPES_NUMBER;i++)
		{
			BYTE        is_unsigned;
			SQLINTEGER  length;
			SQLINTEGER  data_size;
			SQLINTEGER  num_prec_radix;
			SQLSMALLINT concise_type = c_PostgreSQLDataTypes[i].sql_type;

			is_unsigned  = c_PostgreSQLDataTypes[i].is_unsigned;

			prefix = suffix = (i < 9) ? NULL : _T("'");
			DescribeSQLType(concise_type, c_PostgreSQLDataTypes[i].column_size, 0, &sql_type, &data_size, &num_prec_radix, NULL);
                        
			if (((SQL_ALL_TYPES == DataType) || (DataType == concise_type) || (DataType == sql_type)) &&
			    /* filter unused SQL types for selected ODBC version */
			    (((SQL_OV_ODBC2 == odbc_version) && (concise_type != SQL_TYPE_TIME) && (concise_type != SQL_TYPE_DATE) && (concise_type != SQL_TYPE_TIMESTAMP)) ||
			     ((SQL_OV_ODBC3 == odbc_version) && (concise_type != SQL_TIME)      && (concise_type != SQL_DATE)      && (concise_type != SQL_TIMESTAMP))
			    )
			   )
			{
				/* TYPE_NAME */
				pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(c_PostgreSQLDataTypes[i].name));
				_tcsncpy(pBuffer, c_PostgreSQLDataTypes[i].name, length);

				/* DATA_TYPE */
				_itot(concise_type, buffer, 10);
				pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(buffer));
				_tcsncpy(pBuffer, buffer, length);

				/* COLUMN_SIZE */
				_itot(data_size, buffer, 10);
				pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(buffer));
				_tcsncpy(pBuffer, buffer, length);

				/* LITERAL_PREFIX */
				if (NULL == prefix)
					pBuffer = AddField((Statement*)StatementHandle, 0);
				else
				{
					pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(prefix));
					_tcsncpy(pBuffer, prefix, length);				
				}

				/* LITERAL_SUFFIX */
				if (NULL == suffix)
					pBuffer = AddField((Statement*)StatementHandle, 0);
				else
				{
					pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(suffix));
					_tcsncpy(pBuffer, suffix, length);
				}

				/* CREATE_PARAMS */
				if (NULL == c_PostgreSQLDataTypes[i].create_params)
				{
					SQLINTEGER* pBuffer = (SQLINTEGER*)AddField((Statement*)StatementHandle, 0) - 1;
					*pBuffer = -1;
				}
				else
				{
					pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(c_PostgreSQLDataTypes[i].create_params));
					_tcsncpy(pBuffer, c_PostgreSQLDataTypes[i].create_params, length);				
				}

				/* NULLABLE */
				_itot(c_PostgreSQLDataTypes[i].is_nullable, buffer, 10);
				pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(buffer));
				_tcsncpy(pBuffer, buffer, length);

				/* CASE_SENSITIVE */
				_itot(SQL_FALSE, buffer, 10);
				pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(buffer));
				_tcsncpy(pBuffer, buffer, length);

				/* SEARCHABLE */
				_itot(SQL_SEARCHABLE, buffer, 10);
				pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(buffer));
				_tcsncpy(pBuffer, buffer, length);

				/* UNSIGNED_ATTRIBUTE */
				if (0 == is_unsigned)
				{
					SQLINTEGER* pBuffer = (SQLINTEGER*)AddField((Statement*)StatementHandle, 0) - 1;
					*pBuffer = -1;
				}
				else
				{
					_itot((1 == is_unsigned) ? SQL_FALSE : SQL_TRUE, buffer, 10);
					pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(buffer));
					_tcsncpy(pBuffer, buffer, length);				
				}

				/* FIXED_PREC_SCALE */
				_itot(SQL_FALSE, buffer, 10);
				pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(buffer));
				_tcsncpy(pBuffer, buffer, length);

				/* AUTO_UNIQUE_VALUE */
				if (0 == c_PostgreSQLDataTypes[i].is_autoincrementing)
				{
					SQLINTEGER* pBuffer = (SQLINTEGER*)AddField((Statement*)StatementHandle, 0) - 1;
					*pBuffer = -1;				
				}
				else
				{
					_itot((1 == c_PostgreSQLDataTypes[i].is_autoincrementing) ? SQL_FALSE : SQL_TRUE, buffer, 10);
					pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(buffer));
					_tcsncpy(pBuffer, buffer, length);				
				}

				/* LOCAL_TYPE_NAME */
				pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(c_PostgreSQLDataTypes[i].local_name));
				_tcsncpy(pBuffer, c_PostgreSQLDataTypes[i].local_name, length);

				/* MINIMUM_SCALE */
				if (0 > c_PostgreSQLDataTypes[i].minimum_scale)
				{
					SQLINTEGER* pBuffer = (SQLINTEGER*)AddField((Statement*)StatementHandle, 0) - 1;
					*pBuffer = -1;								
				}
				else
				{
					_itot(c_PostgreSQLDataTypes[i].minimum_scale, buffer, 10);
					pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(buffer));
					_tcsncpy(pBuffer, buffer, length);
				}

				/* MAXIMUM_SCALE */
				if (0 > c_PostgreSQLDataTypes[i].maximum_scale)
				{
					SQLINTEGER* pBuffer = (SQLINTEGER*)AddField((Statement*)StatementHandle, 0) - 1;
					*pBuffer = -1;								
				}
				else
				{
					_itot(c_PostgreSQLDataTypes[i].maximum_scale, buffer, 10);
					pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(buffer));
					_tcsncpy(pBuffer, buffer, length);
				}

				/* SQL_DATA_TYPE */
				_itot(sql_type, buffer, 10);
				pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(buffer));
				_tcsncpy(pBuffer, buffer, length);

				/* SQL_DATETIME_SUB */
				if (SQL_DATETIME == sql_type || SQL_INTERVAL == sql_type)
				{
					_itot(concise_type, buffer, 10);
					pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(buffer));
					_tcsncpy(pBuffer, buffer, length);
				}
				else
				{
					SQLINTEGER* pBuffer = (SQLINTEGER*)AddField((Statement*)StatementHandle, 0) - 1;
					*pBuffer = -1;				
				}

				/* NUM_PREC_RADIX */
				if (0 < num_prec_radix)
				{
					_itot(num_prec_radix, buffer, 10);
					pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(buffer));
					_tcsncpy(pBuffer, buffer, length);
				}
				else
				{
					SQLINTEGER* pBuffer = (SQLINTEGER*)AddField((Statement*)StatementHandle, 0) - 1;
					*pBuffer = -1;				
				}

				/* INTERVAL_PRECISION */
				if (SQL_INTERVAL != sql_type)
				{
					SQLINTEGER* pBuffer = (SQLINTEGER*)AddField((Statement*)StatementHandle, 0) - 1;
					*pBuffer = -1;				
				}
				else
				{
					_itot(interval_precision, buffer, 10);
					pBuffer = AddField((Statement*)StatementHandle, length = _tcslen(buffer));
					_tcsncpy(pBuffer, buffer, length);				
				}

				nRowsResulted++;
			}
		}
		
		pIRD = GET_DESCRIPTOR(((Statement*)StatementHandle)->ird);
		pIRD->header.rows_affected = nRowsResulted;
		RET_DESCRIPTOR(pIRD);

		PrepareResultset((Statement*)StatementHandle, nRowsResulted);
		((Statement*)StatementHandle)->ird->header.query_type = ST_SELECT;

		nRet = SQL_SUCCESS;
	}

	LEAVE_STMT(StatementHandle, nRet);
}

/*-----------------------------------------------------------------------------
 * FUNCTION: SQLPutData
 *
 * DESCRIPTION: Supplies data for column or parameter, it can be called for any parameter,
 *              but only for character or binary data more than once
 *
 * IMPLEMENTATION: Function works only with 'DataAtExec' structure of the Statement
 *                 handle. The next call to SQLParamData will process this data
 *                 and set corresponding descriptor fields.
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLPutData(SQLHSTMT StatementHandle, SQLPOINTER Data, SQLLEN StrLen_or_Ind)
{
	SQLRETURN nRet = SQL_SUCCESS;
	ENTER_STMT(StatementHandle, _T("SQLPutData"));
	{/* get info about data-buffer */
		DataAtExec* daexec = &((Statement*)StatementHandle)->data_at_exec;

		switch(StrLen_or_Ind)
		{
			case SQL_NULL_DATA:	/* null data supplied */
				daexec->indicator = SQL_NULL_DATA;
				break;
			case SQL_DEFAULT_PARAM: /* use default value */
				daexec->indicator = SQL_DEFAULT_PARAM;
				break;
			default:
			{/* get length of supplied data */
				SQLINTEGER length = GetCTypeLength(daexec->c_type, (SQL_NTS == StrLen_or_Ind) ? ((SQL_C_WCHAR == daexec->c_type) ? wcslen((WCHAR*)Data) : strlen((char*)Data)) : (SQL_C_WCHAR == daexec->c_type) ? (StrLen_or_Ind/sizeof(WCHAR)) : StrLen_or_Ind);

				/* check for free space and allocate space if needed */
				if (0 >= daexec->max_length)
				{/* max length is known for this parameter */
					daexec->max_length = (0 == daexec->max_length || SQL_NTS == StrLen_or_Ind) ? length : -daexec->max_length;
					daexec->buffer = (BYTE*)malloc(daexec->max_length);
					daexec->indicator = 0;
				}

				/* we have finite allocated buffer */
				if ((daexec->max_length - daexec->indicator) < length)
				{/* specified buffer smaller then data - correct length */
					length = daexec->max_length - daexec->indicator;
					SetError(SQL_HANDLE_STMT, StatementHandle, ERR_PUTPARAM_TRUNCATED_DATA, NULL);
					nRet = SQL_SUCCESS_WITH_INFO;
				}

				/* put data into buffer */
				memcpy(daexec->buffer + daexec->indicator, Data, length);
				daexec->indicator += length;
			}
		}
	}
	LEAVE_STMT(StatementHandle, nRet);
}

/*-----------------------------------------------------------------------------
 * SQLSpecialColumns
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLSpecialColumns_(SQLHSTMT StatementHandle, SQLUSMALLINT IdentifierType,
									 SQLTCHAR *CatalogName, SQLSMALLINT CatalogNameLength,
									 SQLTCHAR *SchemaName, SQLSMALLINT SchemaNameLength,
									 SQLTCHAR *TableName, SQLSMALLINT TableNameLength,
									 SQLUSMALLINT Scope, SQLUSMALLINT Nullable)
{
	SQLRETURN    nRet          = SQL_ERROR;
	unsigned int conv          = TC_AS_IS;
	SQLTCHAR*    query         = NULL;
	int          nRowsResulted = 0;
	Statement*   pStatement    = (Statement*) StatementHandle;
	Descriptor*  pIRD          = NULL;

	ENTER_STMT(StatementHandle, _T("SQLSpecialColumns"));
	if (NULL == TableName || _T('\0') == *TableName || 0 == TableNameLength)
	{/* TableName can't be a null pointer */
		SetError(SQL_HANDLE_STMT, pStatement, ERR_EMPTY_STRING, _T("TableName"), NULL);
		nRet = SQL_ERROR;
	}
	else
	{
		TCHAR* special_query = (SQL_BEST_ROWID == IdentifierType) ? c_SQLSpecialColumns_BEST_ROWID_query : c_SQLSpecialColumns_ROWVER_query;
		BOOL mjet = pStatement->connection->mjet;

		/* BEST_ROWID - let's test table for primary keys, this will cover all scopes */
		while ((conv < TC_STOP) && (SQL_ERROR != (nRet = ResetStatement(pStatement))))
		{
			if (NULL != (query = CompileCSOCQuery(pStatement, special_query, conv, CatalogName, CatalogNameLength, SchemaName, SchemaNameLength, TableName, TableNameLength, NULL, 0, CSOC_OBJ_TABLE)))
			{
				if ((SQL_ERROR != (nRet = PrepareQuery(pStatement, query, SQL_NTS, QO_IGNORE_BOOKMARK | QO_FORCE_BUFFERING))) &&
				    (SQL_ERROR != (nRet = ExecuteStatement(pStatement, TRUE))) &&
						(0 == ((Statement*)StatementHandle)->ird->header.array_size)
				   )
					++conv;
				else
					conv = TC_STOP;
				FREE(query);
			}
			else
			{
				SetError(SQL_HANDLE_STMT, StatementHandle, ERR_NOT_ENOUGH_MEMORY, NULL);
				conv = TC_STOP;
				nRet = SQL_ERROR;
			}
		}
		
		pIRD = GET_DESCRIPTOR(pStatement->ird);
		if (SQL_SUCCEEDED(nRet))
		{/* rename columns */
			SetDescField(pIRD, 0, SQL_DESC_COUNT, (SQLPOINTER)(SQLSMALLINT)(sizeof(c_SpecialColumnsColumns)/sizeof(ColumnNameType)), SQL_IS_SMALLINT);
			RenameColumns(pStatement, c_SpecialColumnsColumns, sizeof(c_SpecialColumnsColumns)/sizeof(ColumnNameType));				
		}

		if (0 < (nRowsResulted = pStatement->ird->header.rows_affected))
		{
			SQLUINTEGER odbc_version = pStatement->connection->environment->attributes.odbc_version;
			int    column_type = (SQL_ROWVER == IdentifierType) ? SQL_PC_PSEUDO : SQL_PC_NOT_PSEUDO;
			TCHAR  buffer[10];
			TCHAR* pBuffer;
			int    length;

			--nRowsResulted;
			for(;0<=nRowsResulted;--nRowsResulted)
			{
				SQLSMALLINT concise_sql_type;
				SQLSMALLINT precision;
				SQLINTEGER  num_prec_radix;
				SQLINTEGER  type_length;
				SQLINTEGER  data_size;
				SQLSMALLINT type;

				TCHAR*      oid_ptr  = (TCHAR*)((SQLINTEGER*)pIRD->id_records[2].common.data_ptr[nRowsResulted]+1);
				TCHAR*      mod_ptr  = (TCHAR*)((SQLINTEGER*)pIRD->id_records[0].common.data_ptr[nRowsResulted]+1);
				SQLINTEGER  oid_len  = *((SQLINTEGER*)oid_ptr-1);
				SQLINTEGER  mod_len  = *((SQLINTEGER*)mod_ptr-1);

				SQLINTEGER  oid      = GetInt(&oid_ptr, 0, &oid_len, 10);
				SQLINTEGER  modifier = GetInt(&mod_ptr, 0, &mod_len, 10);

				PostgreTypeToSQLType(oid, modifier, odbc_version, NULL, &concise_sql_type, &type_length, &precision, mjet);
				DescribeSQLType(concise_sql_type, type_length, precision, &type, &data_size, &num_prec_radix, NULL);

				/* SCOPE */
				if (SQL_ROWVER == IdentifierType)
				{/* NULL is returned when IdentifierType is SQL_ROWVER */
					SQLINTEGER* pBuffer = (SQLINTEGER*)AddField(pStatement, 0) - 1;
					*pBuffer = -1;
				}
				else
				{
					ADD_NUMERIC_FIELD(SQL_SCOPE_SESSION, 0);
				}
				/* COLUMN_NAME */
				/* DATA_TYPE */
				ADD_NUMERIC_FIELD(concise_sql_type, 2);
				/* TYPE_NAME */
				/* COLUMN_SIZE */
				ADD_NUMERIC_FIELD(data_size, 4);
				/* BUFFER_LENGTH */
				ADD_NUMERIC_FIELD(GetCTypeLength(GetCDefaultType(concise_sql_type), (SQL_NUMERIC == concise_sql_type || SQL_DECIMAL == concise_sql_type) ? (type_length + 2) : type_length), 5);
				/* DECIMAL_DIGITS */
				if (0 < num_prec_radix)
				{
					ADD_NUMERIC_FIELD(precision, 6);
				}
				/* PSEUDO_COLUMN */
				ADD_NUMERIC_FIELD(column_type, 7);
			}
			nRet = SQL_SUCCESS;
		}
		else
			nRet = SQL_SUCCESS;
		
		RET_DESCRIPTOR(pIRD);
	}
	LEAVE_STMT(StatementHandle, nRet);
}
/*-----------------------------------------------------------------------------
 * SQLStatistics
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLStatistics_(SQLHSTMT StatementHandle,
               SQLTCHAR* CatalogName, SQLSMALLINT CatalogNameLength,
               SQLTCHAR* SchemaName,  SQLSMALLINT SchemaNameLength,
               SQLTCHAR* TableName,   SQLSMALLINT TableNameLength,
               SQLUSMALLINT Unique,   SQLUSMALLINT Reserved)
{
	SQLRETURN    nRet  = SQL_ERROR;
	unsigned int conv  = TC_AS_IS;
	SQLTCHAR*    query = NULL;

	ENTER_STMT(StatementHandle, _T("SQLStatistics"));
	if (NULL == TableName || _T('\0') == *TableName)
	{/* TableName can't be a null pointer */
		SetError(SQL_HANDLE_STMT, StatementHandle, ERR_EMPTY_STRING, _T("TableName"), NULL);
		nRet = SQL_ERROR;
	}
	else while ((conv < TC_STOP) && (SQL_ERROR != (nRet = ResetStatement((Statement*) StatementHandle))))
	{
		if (NULL != (query = CompileCSOCQuery((Statement*)StatementHandle, c_SQLStatistics_query, conv, CatalogName, CatalogNameLength, SchemaName, SchemaNameLength, TableName, TableNameLength, NULL, 0, CSOC_OBJ_TABLE)))
		{
			if ((SQL_ERROR != (nRet = PrepareQuery((Statement*) StatementHandle, query, SQL_NTS, QO_IGNORE_BOOKMARK | QO_FORCE_BUFFERING))) &&
			    (SQL_ERROR != (nRet = ExecuteStatement((Statement*) StatementHandle, TRUE))) &&
					(0 == ((Statement*)StatementHandle)->ird->header.rows_affected)
			   )
				++conv;
			else
				conv = TC_STOP;
			FREE(query);
		}
		else
		{
			SetError(SQL_HANDLE_STMT, StatementHandle, ERR_NOT_ENOUGH_MEMORY, NULL);
			conv = TC_STOP;
			nRet = SQL_ERROR;
		}
	}

	if (SQL_SUCCEEDED(nRet))
	{/* rename columns */
		RenameColumns((Statement*)StatementHandle, c_StatisticsColumns, sizeof(c_StatisticsColumns)/sizeof(ColumnNameType));
	}

	LEAVE_STMT(StatementHandle, nRet);
}

/*-----------------------------------------------------------------------------
 * SQLTables
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLTables_(SQLHSTMT StatementHandle,
           SQLTCHAR* CatalogName, SQLSMALLINT CatalogNameLength,
           SQLTCHAR* SchemaName, SQLSMALLINT SchemaNameLength,
           SQLTCHAR* TableName, SQLSMALLINT TableNameLength,
           SQLTCHAR* TableType, SQLSMALLINT TableTypeLength)
{
	SQLRETURN    nRet;
	unsigned int types;

	ENTER_STMT(StatementHandle, _T("SQLTables"));
	if (SQL_ERROR != (nRet = ResetStatement((Statement*) StatementHandle)))
	{
		/* set table-types application requested */
		if (NULL == TableType || 0 == TableTypeLength || _T('\0') == *TableType)
			/* no types specified in parameter - use default */
			types = TT_DEFAULT;
		else
		{
			unsigned int type = TT_NO_ONE;
			SQLTCHAR*    LastChar;
			BOOL         bNewType;
		
			if (SQL_NTS == TableTypeLength)
				TableTypeLength = _tcslen((TCHAR*)TableType);
			/* parse parameter string with types and determine supported */
			for (types=TT_NO_ONE, bNewType=TRUE, LastChar=TableType+TableTypeLength;LastChar!=TableType;TableType++)
			{
				if (TRUE == bNewType)
				{
					switch (*TableType)
					{
						case _T('\''):
						case _T(' '):
							continue;
						case _T('S'):
							if (0 == _tcsncmp((TCHAR*)TableType, _T("SYSTEM TABLE"), STR_SIZEOF("SYSTEM TABLE")))
							{
								type = TT_SYSTEM_TABLE;
								TableType += STR_SIZEOF("SYSTEM TABLE")-1;
							}
							break;
						case _T('T'):
							if (0 == _tcsncmp((TCHAR*)TableType, _T("TABLE"), STR_SIZEOF("TABLE")))
							{
								type = TT_TABLE;
								TableType += STR_SIZEOF("TABLE")-1;
							}
							break;
						case _T('V'):
							if (0 == _tcsncmp((TCHAR*)TableType, _T("VIEW"), STR_SIZEOF("VIEW")))
							{
								type = TT_VIEW;
								TableType += STR_SIZEOF("VIEW")-1;
							}
							break;
					}
					bNewType = FALSE;
				}
				else
				{
					switch (*TableType)
					{
						case _T('\''):
						case _T(' '):
							break;
						case _T(','):
							types |= type;
							bNewType = TRUE;
							break;
						default:
							type = TT_NO_ONE;
					}
				}
			}
			types |= type;
		}

		if (TT_NO_ONE == types)
		{
			/* There was no one valid table type specified in parameter TableType */
			TCHAR* typesStr;

			if (_T('\0') == *TableType)
				/* save time - do not duplicate string, use parameter because it's 0-terminated */
				typesStr = (TCHAR*)(TableType - TableTypeLength);
			else if (NULL != (typesStr = (TCHAR*)malloc((TableTypeLength+1)*sizeof(TCHAR))))
			{
				_tcsncpy(typesStr, (TCHAR*)TableType-TableTypeLength, TableTypeLength);
				typesStr[TableTypeLength] = _T('\0');
			}
			SetError(SQL_HANDLE_STMT, StatementHandle, ERR_STMT_NO_VALID_TABLE_TYPES, typesStr, NULL);
			if (_T('\0') != *TableType)
				FREE(typesStr);
			nRet = SQL_ERROR;
		}
		else
		{
			int oor = STR_SIZEOF(" or ");
			const TCHAR* params[6];
			unsigned int conv  = TC_AS_IS;

			TCHAR*    temp;         /* query after first parsing */
			SQLTCHAR* query = NULL; /* prepared query text */

			/* note: SYSTEM TABLE is a table in 'pg_catalog' schema */
			if (0 == (types & TT_SYSTEM_TABLE))
				params[0] = params[3] = _T("");
			else
			{
				params[0] = c_SQLTables_ST;
				params[3] = c_SQLTables_ST_;
				oor = 0;
			}

			if (0 == (types & TT_TABLE))
				params[1] = params[4] = _T("");
			else
			{
				params[1] = c_SQLTables_T;
				params[4] = c_SQLTables_T_ + oor;
				oor = 0;
			}

			if (0 == (types & TT_VIEW))
				params[2] = params[5] = _T("");
			else
			{
				params[2] = c_SQLTables_V;
				params[5] = c_SQLTables_V_ + oor;
			}

			if (NULL != (temp = GetText(c_SQLTables_query, params[0], params[1], params[2], params[3], params[4], params[5], NULL)))
			{
				while ((conv < TC_STOP) && (SQL_ERROR != (nRet = ResetStatement((Statement*) StatementHandle))))
				{
					if (NULL != (query = CompileCSOCQuery((Statement*) StatementHandle, temp, conv, CatalogName, CatalogNameLength, SchemaName, SchemaNameLength, TableName, TableNameLength, NULL, 0, CSOC_OBJ_TABLE)))
					{
						/* execute query */
						if ((SQL_ERROR != (nRet = PrepareQuery((Statement*) StatementHandle, query, SQL_NTS, QO_IGNORE_BOOKMARK | QO_FORCE_BUFFERING))) &&
						    (SQL_ERROR != (nRet = ExecuteStatement((Statement*) StatementHandle, TRUE))) &&
								(0 == ((Statement*)StatementHandle)->ird->header.array_size)
						   )
							++conv;
						else
							conv = TC_STOP;
						free(query);
					}
					else
						conv = TC_STOP;
				}

				if (SQL_SUCCEEDED(nRet))
				{/* rename columns */
					RenameColumns((Statement*)StatementHandle, c_TablesColumns, sizeof(c_TablesColumns)/sizeof(ColumnNameType));
				}
			}
			if (NULL == temp || NULL == query)
			{
				SetError(SQL_HANDLE_STMT, StatementHandle, ERR_NOT_ENOUGH_MEMORY, NULL);
				nRet = SQL_ERROR;
			}
			FREE(temp);
		}
	}

	LEAVE_STMT(StatementHandle, nRet);
}

/*-----------------------------------------------------------------------------
 * FUNCTION: SQLProcedures
 *
 * DESCRIPTION: we will show only those fuctions - the user can execute
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLProcedures_(SQLHSTMT StatementHandle,
							 SQLTCHAR* CatalogName, SQLSMALLINT CatalogNameLength,
               SQLTCHAR* SchemaName, SQLSMALLINT SchemaNameLength,
               SQLTCHAR* ProcName, SQLSMALLINT ProcNameLength)
{
	SQLRETURN    nRet  = SQL_ERROR;
	unsigned int conv  = TC_AS_IS;
	SQLTCHAR*    query = NULL;

	ENTER_STMT(StatementHandle, _T("SQLProcedures"));
	while ((conv < TC_STOP) && (SQL_ERROR != (nRet = ResetStatement((Statement*) StatementHandle))))
	{
		if (NULL != (query = CompileCSOCQuery((Statement*)StatementHandle, c_SQLProcedures_query, conv, CatalogName, CatalogNameLength, SchemaName, SchemaNameLength, NULL, 0, NULL, 0, CSOC_OBJ_TABLE)))
		{
			if ((SQL_ERROR != (nRet = PrepareQuery((Statement*) StatementHandle, query, SQL_NTS, QO_IGNORE_BOOKMARK | QO_FORCE_BUFFERING))) &&
			    (SQL_ERROR != (nRet = ExecuteStatement((Statement*) StatementHandle, TRUE))) &&
					(0 == ((Statement*)StatementHandle)->ird->header.array_size)
			   )
				++conv;
			else
				conv = TC_STOP;
			FREE(query);
		}
		else
		{
			SetError(SQL_HANDLE_STMT, StatementHandle, ERR_NOT_ENOUGH_MEMORY, NULL);
			conv = TC_STOP;
			nRet = SQL_ERROR;
		}
	}

	if (SQL_SUCCEEDED(nRet))
	{/* rename columns */
		RenameColumns((Statement*)StatementHandle, c_ProceduresColumns, sizeof(c_ProceduresColumns)/sizeof(ColumnNameType));
	}

	LEAVE_STMT(StatementHandle, nRet);
}

/*-----------------------------------------------------------------------------
 * SQLPrimaryKeys
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLPrimaryKeys_(SQLHSTMT StatementHandle,
                SQLTCHAR* CatalogName, SQLSMALLINT CatalogNameLength,
                SQLTCHAR* SchemaName, SQLSMALLINT SchemaNameLength,
                SQLTCHAR* TableName, SQLSMALLINT TableNameLength)
{
	SQLRETURN    nRet  = SQL_ERROR;
	unsigned int conv  = TC_AS_IS;
	SQLTCHAR*    query = NULL;

	ENTER_STMT(StatementHandle, _T("SQLPrimaryKeys"));
	while ((conv < TC_STOP) && (SQL_ERROR != (nRet = ResetStatement((Statement*) StatementHandle))))
	{
		if (NULL != (query = CompileCSOCQuery((Statement*)StatementHandle, c_SQLPrimaryKeys_query, conv, CatalogName, CatalogNameLength, SchemaName, SchemaNameLength, TableName, TableNameLength, NULL, 0, CSOC_OBJ_TABLE)))
		{
			if ((SQL_ERROR != (nRet = PrepareQuery((Statement*) StatementHandle, query, SQL_NTS, QO_IGNORE_BOOKMARK | QO_FORCE_BUFFERING))) &&
			    (SQL_ERROR != (nRet = ExecuteStatement((Statement*) StatementHandle, TRUE))) &&
					(0 == ((Statement*)StatementHandle)->ird->header.array_size)
			   )
				++conv;
			else
				conv = TC_STOP;
			FREE(query);
		}
		else
		{
			SetError(SQL_HANDLE_STMT, StatementHandle, ERR_NOT_ENOUGH_MEMORY, NULL);
			conv = TC_STOP;
			nRet = SQL_ERROR;
		}
	}

	if (SQL_SUCCEEDED(nRet))
	{/* rename columns */
		RenameColumns((Statement*)StatementHandle, c_PrimaryKeysColumns, sizeof(c_PrimaryKeysColumns)/sizeof(ColumnNameType));
	}

	LEAVE_STMT(StatementHandle, nRet);
}


/*----------------------------------------------------------------------------
 * FUNCTION: SQLProcedureColumns
 *
 * DESCRIPTION: we will show only those fuctions - the user can execute
 *----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLProcedureColumns_(SQLHSTMT StatementHandle,
                     SQLTCHAR* CatalogName, SQLSMALLINT CatalogNameLength,
                     SQLTCHAR* SchemaName, SQLSMALLINT SchemaNameLength,
                     SQLTCHAR* ProcName, SQLSMALLINT ProcNameLength,
                     SQLTCHAR* ColumnName, SQLSMALLINT ColumnNameLength
                    )
{
	SQLRETURN    nRet   = SQL_ERROR;
	unsigned int conv   = TC_AS_IS;
	SQLTCHAR*    query  = NULL;
	Statement*   pStatement = (Statement*)StatementHandle;

	ENTER_STMT(StatementHandle, _T("SQLProcedureColumns"));
	while ((conv < TC_STOP) && (SQL_ERROR != (nRet = ResetStatement((Statement*) StatementHandle))))
	{
		if (NULL != (query = CompileCSOCQuery((Statement*)StatementHandle, c_SQLProcedureColumns, conv, CatalogName, CatalogNameLength, SchemaName, SchemaNameLength, ProcName, ProcNameLength, ColumnName, ColumnNameLength, CSOC_OBJ_PROC)))
		{
			if ((SQL_ERROR != (nRet = PrepareQuery((Statement*) StatementHandle, query, SQL_NTS, QO_IGNORE_BOOKMARK | QO_FORCE_BUFFERING))) &&
			    (SQL_ERROR != (nRet = ExecuteStatement((Statement*) StatementHandle, TRUE))) &&
					(0 == ((Statement*)StatementHandle)->ird->header.array_size)
			   )
				++conv;
			else
				conv = TC_STOP;
			FREE(query);
		}
		else
		{
			SetError(SQL_HANDLE_STMT, StatementHandle, ERR_NOT_ENOUGH_MEMORY, NULL);
			conv = TC_STOP;
			nRet = SQL_ERROR;
		}
	}

	if (SQL_SUCCEEDED(nRet))
	{/* prepare handmade resultset */
		TCHAR buffer[SQLSMALLINT_LENGTH];
		SQLINTEGER nRowsResulted;

		SQLINTEGER  length       = 0;		
		TCHAR*      pBuffer      = NULL;
		TCHAR*      catalog      = NULL;
		TCHAR*      yes          = NULL;
		TCHAR*      return_value = NULL;
		TCHAR*      param_value  = NULL;
		SQLUINTEGER odbc_version = pStatement->connection->environment->attributes.odbc_version;
		BOOL        mjet         = pStatement->connection->mjet;

		Descriptor* pIRD = GET_DESCRIPTOR(pStatement->ird);

		/* save catalog name */
		catalog = AddField(pStatement, length = _tcslen(pStatement->connection->parameters[DATABASE_PARAM]));
		_tcsncpy(catalog, pStatement->connection->parameters[DATABASE_PARAM], length);
		catalog -= sizeof(int)/sizeof(TCHAR);

		/* save "YES" and SQL_NULLABLE for nullability */
		_tcsncpy(yes = AddField(pStatement, STR_SIZEOF("YES")), _T("YES"), STR_SIZEOF("YES"));
		yes -= sizeof(int)/sizeof(TCHAR);

		/* save SQL_RETURN_VALUE and SQL_PARAM_INPUT */
		_tcsncpy(return_value = AddField(pStatement, STR_SIZEOF("5")), _T("5"), STR_SIZEOF("5"));
		return_value -= sizeof(int)/sizeof(TCHAR);
		_tcsncpy(param_value = AddField(pStatement, STR_SIZEOF("1")), _T("1"), STR_SIZEOF("1"));
		param_value -= sizeof(int)/sizeof(TCHAR);

		for (nRowsResulted=pStatement->ird->header.array_size-1;nRowsResulted>=0;--nRowsResulted)
		{/* get data description for every oid, returned in resultset */
			SQLSMALLINT concise_sql_type;
			SQLSMALLINT precision;
			SQLINTEGER  num_prec_radix;
			SQLINTEGER  type_length;
			SQLINTEGER  data_size;
			SQLSMALLINT type;
			TCHAR*      type_name;

			TCHAR*     oid_ptr = (TCHAR*)((SQLINTEGER*)pIRD->id_records[5].common.data_ptr[nRowsResulted]+1);
			SQLINTEGER oid_len = *((SQLINTEGER*)oid_ptr-1);
			SQLINTEGER oid     = GetInt(&oid_ptr, 0, &oid_len, 10);

			PostgreTypeToSQLType(oid, -1, odbc_version, &type_name, &concise_sql_type, &type_length, &precision, mjet);
			DescribeSQLType(concise_sql_type, type_length, precision, &type, &data_size, &num_prec_radix, NULL);

			/* PROCEDURE_CAT*/
			pIRD->id_records[0].common.data_ptr[nRowsResulted] = catalog;
			/* PROCEDURE_SCHEM */
			/* PROCEDURE_NAME */
			/* COLUMN_NAME  */
			/* COLUMN_TYPE */
			pIRD->id_records[4].common.data_ptr[nRowsResulted] = (_T('0') == *(TCHAR*)((int*)pIRD->id_records[17].common.data_ptr[nRowsResulted]+1)) ? return_value : param_value;
			/* DATA_TYPE */
			ADD_NUMERIC_FIELD(concise_sql_type, 5);
			/* TYPE_NAME */
			pBuffer = AddField(pStatement, length = _tcslen(type_name));
			_tcsncpy(pBuffer, type_name, length);
			pIRD->id_records[6].common.data_ptr[nRowsResulted] = ((BYTE*)pBuffer) - sizeof(int);						

			/* COLUMN_SIZE */
			ADD_NUMERIC_FIELD(data_size, 7);
			/* BUFFER_LENGTH */
			ADD_NUMERIC_FIELD(GetCTypeLength(GetCDefaultType(concise_sql_type), (SQL_NUMERIC == concise_sql_type || SQL_DECIMAL == concise_sql_type) ? (type_length + 2) : type_length), 8);
			/* DECIMAL_DIGITS */
			if (0 < num_prec_radix)
			{
				ADD_NUMERIC_FIELD(precision, 9);
			}
			/* NUM_PREC_RADIX */
			if (0 < num_prec_radix)
			{
				ADD_NUMERIC_FIELD(num_prec_radix, 10);
			}
			/* NULLABLE */
			pIRD->id_records[11].common.data_ptr[nRowsResulted] = param_value;
			/* REMARKS, COLUMN_DEF - always null, PostgreSQL specyfic */
			/* SQL_DATA_TYPE */
			ADD_NUMERIC_FIELD(type, 14);
			/* SQL_DATETIME_SUB */
			if IS_INTERVAL_DATA_TYPE(concise_sql_type)
			{
				ADD_NUMERIC_FIELD(GetIntervalSubType(concise_sql_type), 15);
			}
			/* CHAR_OCTET_LENGTH */
			/* ORDINAL_POSITION - already set */
			/* IS_NULLABLE */
			pIRD->id_records[18].common.data_ptr[nRowsResulted] = yes;
		}

		RET_DESCRIPTOR(pIRD);

		/* rename columns */
		RenameColumns(pStatement, c_ProcedureColumnsColumns, sizeof(c_ProcedureColumnsColumns)/sizeof(ColumnNameType));
	}

	LEAVE_STMT(StatementHandle, nRet);
}

/*-----------------------------------------------------------------------------
 * FUNCTION: CompileRestrictions
 *-----------------------------------------------------------------------------
 */
#define RESTR_SQL    "(n.nspname LIKE'\?'AND c.relname LIKE'\?')OR"

TCHAR*
CompileRestrictions(Restrictions* restrictions)
{
	if (0 < restrictions->list.used)
	{
		TCHAR* body = (TCHAR*)malloc(sizeof(TCHAR)*(STR_SIZEOF(" AND ()")-1)+(sizeof(_T(RESTR_SQL))-sizeof(TCHAR))*(restrictions->list.used));
		TCHAR* ptr  = body;
		TCHAR* ret  = NULL;
		int    i;
		
		/* prepare body pattern of the additional query, we need additional ? */
		_tcsncpy(ptr, _T(" AND ("), STR_SIZEOF(" AND ("));
		for (i=0,ptr+=STR_SIZEOF(" AND (");i<restrictions->list.used;i+=2,ptr+=STR_SIZEOF(RESTR_SQL))
			_tcsncpy(ptr, _T(RESTR_SQL), STR_SIZEOF(RESTR_SQL));
		*--ptr = _T('\0');
		*--ptr = _T(')');

		ret = GetTextFromArray(body, restrictions->list.used, (const TCHAR**)restrictions->list.handles);
		FREE(body);
		return ret;
	}
	else
	{
		return NULL;
	}
}

/*----------------------------------------------------------------------------
 * FUNCTION: CompileCSOCQuery
 *----------------------------------------------------------------------------
 */
SQLTCHAR*
CompileCSOCQuery(Statement* pStatement, TCHAR* query, unsigned int Conversion,
                 SQLTCHAR* CatalogName, SQLSMALLINT CatalogNameLength,
                 SQLTCHAR* SchemaName,  SQLSMALLINT SchemaNameLength,
                 SQLTCHAR* ObjectName,  SQLSMALLINT ObjectNameLength,
                 SQLTCHAR* ColumnName,  SQLSMALLINT ColumnNameLength,
                 SQLSMALLINT ObjectType)
{
	int i = 4;
	TCHAR* empty_string = _T("");
	TCHAR* params[13];
	TCHAR* oper = (SQL_FALSE == pStatement->attributes.metadata_id) ? c_query_like : c_query_equal;

	/* use 'public' schema name if no schema name specified */
	/*TCHAR* schema  = (0 == SchemaNameLength || NULL == SchemaName || _T('\0') == *SchemaName) ? _tcsdup(_T("public")) : GetSQLString(SchemaName, SchemaNameLength);*/


	/* do we need additional conditions ? */
	if ((NULL != CatalogName) && (SQL_NTS == CatalogNameLength || 0 < CatalogNameLength) && _T('\0') != CatalogName[0])
	{
		params[0]   = c_query_catalog;
		params[i++] = oper;
		params[i++] = (TCHAR*)GetSQLString(CatalogName, CatalogNameLength, Conversion);
	}
	else
		params[0] = empty_string;

	if (NULL != SchemaName && (SQL_NTS == SchemaNameLength || 0 < SchemaNameLength) && _T('\0') != SchemaName[0])
	{
		params[1]   = c_query_schema;
		params[i++] = oper;
		params[i++] = (TCHAR*)GetSQLString(SchemaName, SchemaNameLength, Conversion);
	}
	else
		params[1] = empty_string;

	if (NULL != ObjectName && (SQL_NTS == ObjectNameLength || 0 < ObjectNameLength) && _T('\0') != ObjectName[0])
	{
		switch (ObjectType)
		{
			case CSOC_OBJ_PROC:
				params[2] = c_query_procedure;
				break;
			case CSOC_OBJ_TABLE:
			default:
				params[2] = c_query_table;
		}
		params[i++] = oper;
		params[i++] = (TCHAR*)GetSQLString(ObjectName, ObjectNameLength, Conversion);
	}
	else
		params[2] = _T("");

	if (NULL != ColumnName && (SQL_NTS == ColumnNameLength || 0 < ColumnNameLength) && _T('\0') != ColumnName[0])
	{
		params[3]   = c_query_column;
		params[i++] = oper;
		params[i++] = (TCHAR*)GetSQLString(ColumnName, ColumnNameLength, Conversion);
	}
	else
		params[3] = empty_string;

	if (NULL == (params[12] = CompileRestrictions(&pStatement->connection->restrictions)))
		params[12] = empty_string;

	query = GetText(query, params[0], params[1], params[2], params[3], params[12], NULL);
	if (4 < i)
	{
		int j;
		TCHAR* temp = query;
		for (j=i;j<12;j++)
			params[j] = NULL;
		query = (GetText(query, params[4], params[5], params[6], params[7], params[8], params[9], params[10], params[11], NULL));
		for(j=5;j<i;j+=2)
			FREE(params[j]);

		FREE(temp);
	}

	if (empty_string != params[12])
		FREE(params[12]);

	return (SQLTCHAR*)query;
}

/*-----------------------------------------------------------------------------
 * SQLTablePrivileges
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLTablePrivileges_(SQLHSTMT StatementHandle,
                    SQLTCHAR* CatalogName, SQLSMALLINT CatalogNameLength,
                    SQLTCHAR* SchemaName,  SQLSMALLINT SchemaNameLength,
                    SQLTCHAR* TableName,   SQLSMALLINT TableNameLength
									 )
{
	SQLRETURN    nRet  = SQL_ERROR;
	unsigned int conv  = TC_AS_IS;
	SQLTCHAR*    query = NULL;
	TCHAR*       main_query = NULL;

	ENTER_STMT(StatementHandle, _T("SQLTablePrivileges"));
	/* because of changes made to makeaclitem() in PostgreSQL 8.1 - we need two different queries */
	main_query = (8 < ((Statement*)StatementHandle)->connection->backend.version_first || 0 < ((Statement*)StatementHandle)->connection->backend.version_second) ? c_SQLTablePrivileges_8_1_query : c_SQLTablePrivileges_8_0_query;
	while ((conv < TC_STOP) && (SQL_ERROR != (nRet = ResetStatement((Statement*) StatementHandle))))
	{
		if (NULL != (query = CompileCSOCQuery((Statement*)StatementHandle, main_query, conv, CatalogName, CatalogNameLength, SchemaName, SchemaNameLength, TableName, TableNameLength, NULL, 0, CSOC_OBJ_TABLE)))
		{
			if ((SQL_ERROR != (nRet = PrepareQuery((Statement*) StatementHandle, query, SQL_NTS, QO_IGNORE_BOOKMARK | QO_FORCE_BUFFERING))) &&
			    (SQL_ERROR != (nRet = ExecuteStatement((Statement*) StatementHandle, TRUE))) &&
					(0 == ((Statement*)StatementHandle)->ird->header.array_size)
			   )
				++conv;
			else
				conv = TC_STOP;
			FREE(query);
		}
		else
		{
			SetError(SQL_HANDLE_STMT, StatementHandle, ERR_NOT_ENOUGH_MEMORY, NULL);
			conv = TC_STOP;
			nRet = SQL_ERROR;
		}
	}

	if (SQL_SUCCEEDED(nRet))
	{/* rename columns */
		RenameColumns((Statement*)StatementHandle, c_TablePrivilegesColumns, sizeof(c_TablePrivilegesColumns)/sizeof(ColumnNameType));
	}

	LEAVE_STMT(StatementHandle, nRet);
}


/*-----------------------------------------------------------------------------
 * FUNCTION: SQLMoreResults
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLMoreResults(SQLHSTMT StatementHandle)
{
	SQLRETURN  nRet       = SQL_ERROR;
	Statement* pStatement = (Statement*)StatementHandle;

	ENTER_STMT(StatementHandle, _T("SQLMoreResults"));
	
	if (pStatement->results.irds.used <= ++pStatement->results.current)
		/* no more results avaible */
		nRet = SQL_NO_DATA;
	else
	{
		/* populate new resultset - simply select next stored implementation descriptor */
		Descriptor* pIRD = GET_DESCRIPTOR(pStatement->ird);
		CopyDescriptor((Descriptor*)pStatement->results.irds.handles[pStatement->results.current], pIRD);
		RET_DESCRIPTOR(pIRD);
		pStatement->fetch_first    = -1;
		pStatement->fetch_position = -1;

		nRet = SQL_SUCCESS;
	}

	LEAVE_STMT(StatementHandle, nRet);
}

/*-----------------------------------------------------------------------------
 * FUNCTION: SQLMoreResults
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLForeignKeys_(SQLHSTMT StatementHandle,
                SQLTCHAR* PkCatalogName, SQLSMALLINT PkCatalogNameLength,
                SQLTCHAR* PkSchemaName,  SQLSMALLINT PkSchemaNameLength,
                SQLTCHAR* PkTableName,   SQLSMALLINT PkTableNameLength,

                SQLTCHAR* FkCatalogName, SQLSMALLINT FkCatalogNameLength,
                SQLTCHAR* FkSchemaName,  SQLSMALLINT FkSchemaNameLength,
                SQLTCHAR* FkTableName,   SQLSMALLINT FkTableNameLength)
{
	SQLRETURN    nRet  = SQL_ERROR;
	unsigned int conv  = TC_AS_IS;
	SQLTCHAR*    query = NULL;

	ENTER_STMT(StatementHandle, _T("SQLForeignKeys"));
	while ((conv < TC_STOP) && (SQL_ERROR != (nRet = ResetStatement((Statement*) StatementHandle))))
	{
		if (NULL != PkTableName && 0 != PkTableNameLength && _T('\0') != PkTableName[0])
			query = CompileCSOCQuery((Statement*)StatementHandle, c_SQLForeignKeys_query_1, conv, PkCatalogName, PkCatalogNameLength, PkSchemaName, PkSchemaNameLength, PkTableName, PkTableNameLength, NULL, 0, CSOC_OBJ_TABLE);
		else if (NULL != FkTableName && 0 != FkTableNameLength && _T('\0') != FkTableName[0])
			query = CompileCSOCQuery((Statement*)StatementHandle, c_SQLForeignKeys_query_2, conv, FkCatalogName, FkCatalogNameLength, FkSchemaName, FkSchemaNameLength, FkTableName, FkTableNameLength, NULL, 0, CSOC_OBJ_TABLE);
		else
			query = NULL;

		if (NULL != query)
		{
			if ((SQL_ERROR != (nRet = PrepareQuery((Statement*) StatementHandle, query, SQL_NTS, QO_IGNORE_BOOKMARK | QO_FORCE_BUFFERING))) &&
			    (SQL_ERROR != (nRet = ExecuteStatement((Statement*) StatementHandle, TRUE))) &&
					(0 == ((Statement*)StatementHandle)->ird->header.array_size)
			   )
				++conv;
			else
				conv = TC_STOP;
			FREE(query);
		}
		else
		{
			SetError(SQL_HANDLE_STMT, StatementHandle, ERR_NOT_ENOUGH_MEMORY, NULL);
			conv = TC_STOP;
			nRet = SQL_ERROR;
		}
	}

	if (SQL_SUCCEEDED(nRet))
	{/* rename columns */
		RenameColumns((Statement*)StatementHandle, c_ForeignKeysColumns, sizeof(c_ForeignKeysColumns)/sizeof(ColumnNameType));
	}

	LEAVE_STMT(StatementHandle, nRet);
}

/*-----------------------------------------------------------------------------
 * FUNCTION: SQLColumnPrivileges
 *-----------------------------------------------------------------------------
 */
SQLRETURN SQL_API
SQLColumnPrivileges_(SQLHSTMT StatementHandle,
										 SQLTCHAR* CatalogName, SQLSMALLINT CatalogNameLength,
										 SQLTCHAR* SchemaName,  SQLSMALLINT SchemaNameLength,
										 SQLTCHAR* TableName,   SQLSMALLINT TableNameLength,
										 SQLTCHAR* ColumnName,  SQLSMALLINT ColumnNameLength)
{
	SQLRETURN    nRet  = SQL_ERROR;
	unsigned int conv  = TC_AS_IS;
	SQLTCHAR*    query = NULL;
	TCHAR*       main_query = NULL;

	ENTER_STMT(StatementHandle, _T("SQLColumnPrivileges"));
	/* because of changes made to makeaclitem() in PostgreSQL 8.1 - we need two different queries */
	main_query = (8 < ((Statement*)StatementHandle)->connection->backend.version_first || 0 < ((Statement*)StatementHandle)->connection->backend.version_second) ? c_SQLColumnPrivileges_8_1_query : c_SQLColumnPrivileges_8_0_query;
	while ((conv < TC_STOP) && (SQL_ERROR != (nRet = ResetStatement((Statement*) StatementHandle))))
	{
		if (NULL != (query = CompileCSOCQuery((Statement*)StatementHandle, main_query, conv, CatalogName, CatalogNameLength, SchemaName, SchemaNameLength, TableName, TableNameLength, ColumnName, ColumnNameLength, CSOC_OBJ_TABLE)))
		{
			if ((SQL_ERROR != (nRet = PrepareQuery((Statement*) StatementHandle, query, SQL_NTS, QO_IGNORE_BOOKMARK | QO_FORCE_BUFFERING))) &&
			    (SQL_ERROR != (nRet = ExecuteStatement((Statement*) StatementHandle, TRUE))) &&
					(0 == ((Statement*)StatementHandle)->ird->header.array_size)
			   )
				++conv;
			else
				conv = TC_STOP;
			FREE(query);
		}
		else
		{
			SetError(SQL_HANDLE_STMT, StatementHandle, ERR_NOT_ENOUGH_MEMORY, NULL);
			conv = TC_STOP;
			nRet = SQL_ERROR;
		}
	}

	if (SQL_SUCCEEDED(nRet))
	{/* rename columns */
		RenameColumns((Statement*)StatementHandle, c_ColumnPrivilegesColumns, sizeof(c_ColumnPrivilegesColumns)/sizeof(ColumnNameType));
	}

	LEAVE_STMT(StatementHandle, nRet);
}
