
#=====================================================================
# SQL-Ledger Accounting
# Copyright (c) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#  Contributors: Reed White <alta@alta-research.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# customer/vendor module
#
#======================================================================


use SL::CT;
$form->{rowcount}=40;

1;
# end of main



sub add {

  $form->{title} = "Add";

  $form->{callback} = "$form->{script}?action=add&db=$form->{db}&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}";

  ###newadded
  $form->create_links("AR", \%myconfig, "customer");


  foreach $key (keys %{ $form->{AR_links} }) {

    foreach $ref (@{ $form->{AR_links}{$key} }) {

      $form->{"select$key"} .= "<option>$ref->{accno}--$ref->{description}\n";


    }
}


###newadded
$form->{nextfocus}="$form->{db}code";
  CT->taxaccounts(\%myconfig, \%$form);

  &{ "$form->{db}_header" };
  &form_footer;
  
}

sub search {

  $form->{title} = $locale->text("Search for " . ucfirst $form->{db});
 
# type=submit $locale->text('Search for Customer')
# type=submit $locale->text('Search for Vendor')

# $locale->text('Customer Number')
# $locale->text('Customer Name')
# $locale->text('Vendor Number')
# $locale->text('Vendor Name')

  $number = ucfirst $form->{db} . " Number";
  $code = ucfirst $form->{db} . " Group";
  $name = ucfirst $form->{db} . " Name";
  

  $form->header;
  
  print qq|
  <script>
<!--
function stb(){parent.document.title ="$form->{title}";}

	// -->
</script>

<body bgcolor=ffffff  onLoad=stb()>
<form method=post action=$form->{script} name=myform>

<input type=hidden name=db value=$form->{db}>

<table border=1>

<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>

<tr valign=top>
<td>
<table>

<tr>

  <th align=right>$code</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=$form->{db}code size=35></td>

</tr>

<tr>

  <th align=right>$number</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=$form->{db}number size=35></td>

</tr>

<tr>

  <th align=right>$name</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=name size=35></td>

</tr>

<tr>

  <th align=right>|.$locale->text('Contact').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=contact size=35></td>

</tr>
<tr>

  <th align=right>|.$locale->text('Location').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=locationcode size=35></td>

</tr>
|;
if($form->{db} eq "customer"){

print qq|
<tr>

  <th align=right>|.$locale->text('Sales Person').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=salesperson size=35></td>

</tr>
|;
$sp = "<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name='l_salesperson' type=checkbox class=checkbox value=Y>&nbsp;".$locale->text('Sales Person');

}



print qq|
<tr>

  <th align=right>|.$locale->text('Include in Report').qq|</th>
  <td>
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_name" type=checkbox class=checkbox value=Y $form->{l_name} >&nbsp;$name
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_$form->{db}number" type=checkbox class=checkbox value=Y $form->{"l_$form->{db}number"}>&nbsp;$number
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_$form->{db}code" type=checkbox class=checkbox value=Y $form->{"l_$form->{db}code"}>&nbsp;$code
 <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_locationcode" type=checkbox class=checkbox value=Y $form->{l_locationcode}>&nbsp;|.$locale->text('Location').qq|<br>

 $sp

 <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_terms" type=checkbox class=checkbox value=Y $form->{l_terms}>&nbsp;|.$locale->text('Terms').qq|
   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_address" type=checkbox class=checkbox value=Y $form->{l_address}>&nbsp;|.$locale->text('Address').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_contact" type=checkbox class=checkbox value=Y  $form->{l_contact}>&nbsp;|.$locale->text('Contact').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_phone" type=checkbox class=checkbox value=Y  $form->{l_phone}>&nbsp;|.$locale->text('Phone').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_fax" type=checkbox class=checkbox value=Y $form->{l_fax}>&nbsp;|.$locale->text('Fax').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_email" type=checkbox class=checkbox value=Y  $form->{l_email}>&nbsp;|.$locale->text('E-mail').qq|
  
  </td>
</tr>

</table>
</td>

</tr>
</table>

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>
<input type=hidden name=rowcount value=$form->{rowcount}>
<input type=hidden name=nextfocus value=$form->{nextfocus}>

<br>
<input type=submit class=submit name=action value="|.$locale->text('Search for ' . ucfirst $form->{db}).qq|">
<input type=submit class=submit name=action value="Print">
</form>

<p>
|.$locale->text("To display all $form->{db}s, leave fields blank")

.qq|

</body>
</html>
|;
}

sub search_short {

  $form->{title} = $locale->text("Search for " . ucfirst $form->{db});
 
# type=submit $locale->text('Search for Customer')
# type=submit $locale->text('Search for Vendor')

# $locale->text('Customer Number')
# $locale->text('Customer Name')
# $locale->text('Vendor Number')
# $locale->text('Vendor Name')

  $number = ucfirst $form->{db} . " Number";
  $code = ucfirst $form->{db} . " Group";
  $name = ucfirst $form->{db} . " Name";
  

  $form->header;
  
  print qq|
  <script>
<!--
function stb(){parent.document.title ="$form->{title}";}

	// -->
</script>

<body bgcolor=ffffff  onLoad=stb()>
<form method=post action=$form->{script} name=myform>

<input type=hidden name=db value=$form->{db}>

<table border=1>

<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>

<tr valign=top>
<td>
<table>



<tr>

  <th align=right>$number</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=$form->{db}number size=35></td>

</tr>

<tr>

  <th align=right>$name</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=name size=35></td>

</tr>

<tr>

  <th align=right>|.$locale->text('Contact').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=contact size=35></td>

</tr>

|;




print qq|  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_name" type=hidden class=checkbox value=Y >| if $form->{l_name};
print qq|  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_$form->{db}number" type=hidden class=checkbox value=Y >&nbsp;| if $form->{"l_$form->{db}number"};
print qq|  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_$form->{db}code" type=hidden class=checkbox value=Y &nbsp;| if $form->{"l_$form->{db}code"};
print qq| <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_locationcode" type=hidden class=checkbox value=Y >&nbsp;| if $form->{l_locationcode};
print qq| <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_salesperson" type=hidden class=checkbox value=Y >&nbsp;| if $form->{l_salesperson};
print qq| <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_terms" type=hidden class=checkbox value=Y $>&nbsp;| if $form->{l_terms};
print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_address" type=hidden class=checkbox value=Y>&nbsp;| if $form->{l_address};
print qq|  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_contact" type=hidden class=checkbox value=Y  >&nbsp;| if $form->{l_contact};
print qq|  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_phone" type=hidden class=checkbox value=Y  >&nbsp;| if $form->{l_phone};
print qq|  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_fax" type=hidden class=checkbox value=Y >&nbsp;| if $form->{l_fax};
print qq|  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_email" type=hidden class=checkbox value=Y  >&nbsp;| if $form->{l_email};

  print qq|

</table>
</td>

</tr>
</table>

<input type=hidden name=db value=$form->{db}>
<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>
<input type=hidden name=rowcount value=$form->{rowcount}>
<input type=hidden name=nextfocus value=$form->{nextfocus}>

<br>
<input type=submit class=submit name=action value="|.$locale->text('Search for ' . ucfirst $form->{db}).qq|">
<input type=submit class=submit name=action value="More">
<input type=submit class=submit name=action value="Print">
</form>

<p>
|.$locale->text("To display all $form->{db}s, leave fields blank")

.qq|

</body>
</html>
|;
}


sub more{
 @columns = (name, "$form->{db}number","$form->{db}code",locationcode, salesperson,terms,address, contact, phone, fax, email);
    map { $form->{"l_$_"} = "checked" if $form->{"l_$_"} eq "Y" } @columns;

 &search;
}

# $locale->text('To display all customers, leave fields blank')
# $locale->text('To display all vendors, leave fields blank')

sub print {
	$form->{print}="true";
  &search_for_name;
	
}

sub search_for_customer {
  &search_for_name;
}

sub search_for_vendor {
  &search_for_name;
}


sub search_for_name {
   map { $form->{$_} = $myconfig{$_} } (qw(company address businessnumber nativecurr fy));
 if(!$form->{print}){
    $listheading="class=listheading";
    $listheadingcolor="color=ffffff";
    $listtop="class=listtop";
    $listrow="class=listrow";
    $listtotal="class=listtotal";
    $listsubtotal="class=listsubtotal";
    $lastline=$locale->text("Click on $form->{db} name to edit");
    $mouseaction[0]=" onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow0';\"";
    $mouseaction[1]=" onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow1';\"";
      }else{
    $line = "<hr size=2 noshade>";
    $fontsize="size=1";
  $listprint="class=print";
   $listheading="class=print";
    $listtop="class=print";
    $listrow="class=print";
    $listsubtotal="class=print";
  }

  
  CT->search(\%myconfig, \%$form);
  
  $callback = "$form->{script}?action=search_for_name&db=$form->{db}&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}";
  
  $href = "$form->{script}?action=search_for_name&db=$form->{db}&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&name=".$form->escape($form->{name})."&contact=".$form->escape($form->{contact})."&$form->{db}number=".$form->escape($form->{"$form->{db}number"});
  
  @columns = $form->sort_columns(name, "$form->{db}number","$form->{db}code",locationcode, salesperson,terms,address, contact, phone, fax, email);

  foreach $item (@columns) {
    if ($form->{"l_$item"} eq "Y") {
      push @column_index, $item;

      # add column to href and callback
      $callback .= "&l_$item=Y";
      $href .= "&l_$item=Y";
    }
  }
  
  
  if ($form->{name}) {
    $callback .= "&name=$form->{name}";
    $option .= "Name : $form->{name}<Br>";
  }

  if ($form->{contact}) {
    $callback .= "&contact=$form->{contact}";
    $option .= "Contact : $form->{contact}<Br>";
  }
    if ($form->{locationcode}) {
    $callback .= "&locationcode=$form->{locationcode}";
    $option .= "Location : $form->{locationcode}<Br>";
  }
    if ($form->{salesperson}) {
    $callback .= "&salesperson=$form->{salesperson}";
    $option .= "Sales Person : $form->{salesperson}<Br>";
  }
  if ($form->{"$form->{db}number"}) {
    $callback .= qq|&$form->{db}number=$form->{"$form->{db}number"}|;
     $option .= "$form->{db} Number : ".$form->{"$form->{db}number"}."<Br>";
 }
  if ($form->{"$form->{db}code"}) {
    $callback .= qq|&$form->{db}code=$form->{"$form->{db}code"}|;
     $option .= "$form->{db} Group : ".$form->{"$form->{db}code"}."<Br>";
 }

  $callback = $form->escape($callback . "&sort=$form->{sort}");
  
  $name = ucfirst $form->{db} . " Name";
  $number = ucfirst $form->{db} . " Number";
  $code = ucfirst $form->{db} . " Group";
  
  $column_header{"$form->{db}code"} = qq|<th>$line<a $listheading href=$href&sort=$form->{db}number>$code</a>$line</th>|;
  $column_header{"$form->{db}number"} = qq|<th>$line<a $listheading href=$href&sort=$form->{db}number>$number</a>$line</th>|;
  $column_header{locationcode} = qq|<th>$line<a $listheading href=$href&sort=contact>|.$locale->text('Location').qq|</a>$line</th>|;
  $column_header{salesperson} = qq|<th>$line<a $listheading href=$href&sort=contact>|.$locale->text('S/Person').qq|</a>$line</th>|;
  $column_header{terms} = qq|<th>$line<a $listheading href=$href&sort=contact>|.$locale->text('Terms').qq|</a>$line</th>|;
  $column_header{name} = qq|<th>$line<a $listheading href=$href&sort=name>$name</a>$line</th>|;
  $column_header{address} = qq~<th>$line<a $listheading href=$href&sort="addr1 || addr2 || addr3">~.$locale->text('Address').qq|</a>$line</th>|;
  $column_header{contact} = qq|<th>$line<a $listheading href=$href&sort=contact>|.$locale->text('Contact').qq|</a>$line</th>|;
  $column_header{phone} = qq|<th>$line<a $listheading href=$href&sort=phone>|.$locale->text('Phone').qq|</a>$line</th>|;
  $column_header{fax} = qq|<th>$line<a $listheading href=$href&sort=fax>|.$locale->text('Fax').qq|</a>$line</th>|;
  $column_header{email} = qq|<th>$line<a $listheading href=$href&sort=email>|.$locale->text('E-mail').qq|</a>$line</th>|;
  

# $locale->text('Customer List')
# $locale->text('Vendor List')

  $form->{title} = $locale->text(ucfirst $form->{db} . " List");

  $form->header;

  $colspan = $#column_index + 1;

  print qq|
<body bgcolor=ffffff>

 <p style="page-break-before: always">F/Y : $form->{fy}</p>
<H1  $listprint align=center >$form->{company}<br>$form->{title}</h1>
<table border=0 width=100%>
<tr><td colspan=$colspan>$option</td></td>
<tr $listheading color=ffffff>
|;

  map { print "$column_header{$_}\n" } @column_index;
  
  print qq|
</tr>
|;

  foreach $ref (@{ $form->{CT} }) {

    map { $column_data{$_} = "<td>$ref->{$_}&nbsp;</td>" } ("$form->{db}code","$form->{db}number", locationcode, salesperson, terms,address, contact, phone, fax);
    
    $column_data{name} = "<td><a href=$form->{script}?action=edit&id=$ref->{id}&db=$form->{db}&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&callback=$callback>$ref->{name}&nbsp;</td>";
    
    $column_data{email} = ($ref->{email}) ? qq|<td><a href="mailto:$ref->{email}">$ref->{email}</a></td>| : "<td>&nbsp;</td>";
    
    $i++; $i %= 2;$r++;
    print "<tr $listrow$i $mouseaction[$i] >";

    map { print "$column_data{$_}\n" } @column_index;

    print qq|</tr>|;
    
    	#page break

if($form->{rowcount} && $form->{print} && $form->{rowcount} <= $r){

$pagenum++;
    print "<tr $listrow$i $mouseaction[$i]  >";

	
	  map { $column_data{$_} = "<td $listprint >$line&nbsp;</td>" } @column_index;
    # $column_data{description} = "<td $listprint >$line SubTotal</td>";
    #$column_data{qtykg} = "<td  $listprint align=right>$line $pagetotalqtykg</td>";
   # $column_data{qty} = "<td  $listprint align=right>$line $pagetotaldebit</td>";
    #$column_data{subtotal1} = "<td  $listprint align=right>$line".$form->format_amount(\%myconfig, $pagetotalcredit, 2, "&nbsp;") . "</td>";
     map { print "\n$column_data{$_}" } @column_index;

     print qq|
     </tr>
</table>

 <p style="page-break-before: always">F/Y : $form->{fy}</p>
<H1  $listprint align=center >$form->{company}<br>$form->{title}</h1>
<table  $listprint border=0 width=100%>

<tr $listheading >|;
map { print  "$column_header{$_}\n" } @column_index;


print qq|
</tr><tr>
|;


 	  map { $column_data{$_} = "<td $listprint >&nbsp;</td>" } @column_index;
    # $column_data{description} = "<td $listprint >**Subtotal B/F for Page $pagenum </td>";
   #  $column_data{qtykg} = "<td  $listprint align=right> $pagetotalqtykg</td>";
   # $column_data{qty} = "<td  $listprint align=right> $pagetotaldebit </td>";
   # $column_data{subtotal1} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $pagetotalcredit, 2, "&nbsp;") . "</td>";
    map { print "\n$column_data{$_}" } @column_index;
print qq|
</tr>
|;
$r=0;

}



    
    
  }
  print qq|
</table>

<p>$lastline </p>

</body>
</html>
|;
 
}


sub edit {

  CT->get_tuple(\%myconfig, \%$form);

  $form->{title} = "Edit";

  # format discount
  $form->{discount} *= 100;
  $form->{nextfocus}="$form->{db}code";
  &{ "$form->{db}_header" };
  &form_footer;

}


sub customer_header {


# type=submit $locale->text('Add Customer')
# type=submit $locale->text('Edit Customer')
  
  foreach $item (split / /, $form->{taxaccounts}) {
    if (($form->{tax}{$item}{taxable}) || !($form->{id})) {
      $taxable .= qq| <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="tax_$item" value=1 class=checkbox type=checkbox checked>&nbsp;<b>$form->{tax}{$item}{description}</b>|;
    } else {
      $taxable .= qq| <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="tax_$item" value=1 class=checkbox type=checkbox>&nbsp;<b>$form->{tax}{$item}{description}</b>|;
    }
  }

  $tax = qq|<tr><th align=right>|.$locale->text('Taxable').qq|</th><td colspan=2>$taxable</td></tr>|;

  $form->{taxincluded} = ($form->{taxincluded}) ? "checked" : "";
  $form->{creditlimit} = $form->format_amount(\%myconfig, $form->{creditlimit}, 0);
  
    
  $form->{title} = $locale->text("$form->{title} Customer");
  
  $form->header;



  print qq|
  <script>
<!--

function stb(){
        document.myform.$form->{nextfocus}.focus();parent.document.title ="$form->{title}";
}

// -->
</script>

<body bgcolor=ffffff onLoad=stb()>

<form method=post action=$form->{script} name=myform>
<input type=hidden name=vc value=customer>
<input type=hidden name=type value=sales_order>
<input type=hidden name=title value="Sales Order">

<table border=1>
<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>

<tr>
  <td>

  <table>

  <tr>
  
    <th colspan=2>|.$locale->text('Billing Address').qq|</th>
    <th colspan=2>|.$locale->text('Shipping Address').qq|</th>

  </tr>


  <tr>

    <th align=right>|.$locale->text('Group').qq|</th>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=customercode size=35 maxsize=35 value="$form->{customercode}"></td>

  </tr>

    <tr>

    <th align=right>|.$locale->text('Location Code').qq|</th>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=locationcode size=35 maxsize=35 value="$form->{locationcode}"></td>

  </tr>

  <tr>

    <th align=right>|.$locale->text('Customer Number').qq|</th>
    <td colspan=3><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=customernumber size=35 maxsize=35 value="$form->{customernumber}"></td>

  </tr>

  <tr>

    <th align=right>|.$locale->text('Customer Name').qq|</th>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=name size=35 maxsize=35 value="$form->{name}"></td>
    <td colspan=2><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=shiptoname size=35 maxsize=35 value="$form->{shiptoname}"></td>

  </tr>

  <tr>

    <th align=right>|.$locale->text('Address').qq|</th>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=addr1 size=35 maxsize=35 value="$form->{addr1}"></td>
    <td colspan=2><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=shiptoaddr1 size=35 maxsize=35 value="$form->{shiptoaddr1}"></td>

  </tr>

  <tr>

    <th></th>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=addr2 size=35 maxsize=35 value="$form->{addr2}"></td>
    <td colspan=2><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=shiptoaddr2 size=35 maxsize=35 value="$form->{shiptoaddr2}"></td>

  </tr>

  <tr>

    <th></th>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=addr3 size=35 maxsize=35 value="$form->{addr3}"></td>
    <td colspan=2><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=shiptoaddr3 size=35 maxsize=35 value="$form->{shiptoaddr3}"></td>

  </tr>

  <tr>

    <th></th>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=addr4 size=35 maxsize=35 value="$form->{addr4}"></td>
    <td colspan=2><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=shiptoaddr4 size=35 maxsize=35 value="$form->{shiptoaddr4}"></td>

  </tr>

  <tr>

    <th align=right>|.$locale->text('Contact').qq|</th>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=contact size=20 maxsize=35 value="$form->{contact}"></td>
    <td colspan=2><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=shiptocontact size=20 maxsize=35 value="$form->{shiptocontact}"></td>

  </tr>
  
  <tr>

    <th align=right>|.$locale->text('Phone').qq|</th>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=phone size=20 maxsize=20 value="$form->{phone}"></td>
    <td colspan=2><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=shiptophone size=20 maxsize=20 value="$form->{shiptophone}"></td>

  </tr>

  <tr>

    <th align=right>|.$locale->text('Fax').qq|</th>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=fax size=20 maxsize=20 value="$form->{fax}"></td>
    <td colspan=2><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=shiptofax size=20 maxsize=20 value="$form->{shiptofax}"></td>

  </tr>

  <tr>

    <th align=right>|.$locale->text('E-mail').qq|</th>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=email size=25 value="$form->{email}"></td>
    <td colspan=2><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=shiptoemail size=25 value="$form->{shiptoemail}"></td>

  </tr>
   <tr>

    <th align=right>|.$locale->text('Sales Person').qq|</th>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=salesperson size=25 value="$form->{salesperson}"></td>
    <td colspan=2></td>

  </tr>

  <tr>
    <td colspan=4>
    <table width=100%><tr>

    <th align=right>|.$locale->text('Terms: Net').qq|</th>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=terms size=2 value="$form->{terms}"></td>
    <th>|.$locale->text('days').qq|</th>
    <th align=right>|.$locale->text('Credit Limit').qq|</th>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=creditlimit size=9 value="$form->{creditlimit}"></td>
    <th align=right>|.$locale->text('Discount').qq|</th>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=discount size=4 value="$form->{discount}"></td>
    <th>%</th>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=taxincluded class=checkbox type=checkbox value=1 $form->{taxincluded}></td>
    <th align=left>|.$locale->text('Tax Included').qq|</th>

    </tr>
    </table>
    </td>
  </tr>

  $tax
  
  <tr valign=top>

    <th align=right>|.$locale->text('Notes').qq|</th>
    <td colspan=3 rowspan=3>
    <textarea name=notes rows=3 cols=30>$form->{notes}</textarea>
    </td>

  </tr>
    
  </table>

  </td>
</tr>

</table>
|;

}



sub vendor_header {

  $form->{title} = $locale->text("$form->{title} Vendor");
 
  foreach $item (split / /, $form->{taxaccounts}) {
    if (($form->{tax}{$item}{taxable}) || !($form->{id})) {
      $taxable .= qq| <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="tax_$item" value=1 class=checkbox type=checkbox checked>&nbsp;<b>$form->{tax}{$item}{description}</b>|;
    } else {
      $taxable .= qq| <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="tax_$item" value=1 class=checkbox type=checkbox>&nbsp;<b>$form->{tax}{$item}{description}</b>|;
    }
  }

  $tax = qq|<tr><th align=right>|.$locale->text('Taxable').qq|</th><td>$taxable</td></tr>|;

  $form->{taxincluded} = ($form->{taxincluded}) ? "checked" : "";
  $form->{debitlimit} = $form->format_amount(\%myconfig, $form->{debitlimit}, 0);
 
  $form->header;

# type=submit $locale->text('Add Vendor')
# type=submit $locale->text('Edit Vendor')

  print qq|
  <script>
<!--

function stb(){
        document.myform.$form->{nextfocus}.focus();parent.document.title ="$form->{title}";
}

// -->
</script>

<body bgcolor=ffffff onLoad=stb()>

<form method=post action=$form->{script} name=myform>
<input type=hidden name=vc value=vendor>
<input type=hidden name=type value=purchase_order>
<input type=hidden name=title value="Purchase Order">

<table border=1>
<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>
<tr>
  <td>

  <table border=0>
  
  <tr>

    <th align=right>|.$locale->text('Group').qq|</th>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=vendorcode size=35 maxsize=35 value="$form->{vendorcode}"></td>

  </tr>
    <tr>

    <th align=right>|.$locale->text('Location Code').qq|</th>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=locationcode size=35 maxsize=35 value="$form->{locationcode}"></td>

  </tr>

  <tr>

    <th align=right>|.$locale->text('Vendor Number').qq|</th>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=vendornumber size=35 maxsize=35 value="$form->{vendornumber}"></td>

  </tr>

  <tr>
  
    <th align=right>|.$locale->text('Vendor Name').qq|</th>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=name size=35 maxsize=35 value="$form->{name}"></td>

  </tr>

  <tr>
  
    <th align=right>|.$locale->text('Address').qq|</th>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=addr1 size=35 maxsize=35 value="$form->{addr1}"></td>

  </tr>
  
  <tr>

    <td></td>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=addr2 size=35 maxsize=35 value="$form->{addr2}"></td>

  </tr>
  
  <tr>

    <td></td>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=addr3 size=35 maxsize=35 value="$form->{addr3}"></td>

  </tr>
  
  <tr>

    <td></td>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=addr4 size=35 maxsize=35 value="$form->{addr4}"></td>

  </tr>
  
  <tr>

    <th align=right>|.$locale->text('Contact').qq|</th>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=contact size=20 maxsize=35 value="$form->{contact}"></td>

  </tr>
  
  <tr>

    <th align=right>|.$locale->text('Phone').qq|</th>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=phone size=20 maxsize=20 value="$form->{phone}"></td>

  </tr>

  <tr>

    <th align=right>|.$locale->text('Fax').qq|</th>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=fax size=20 maxsize=20 value="$form->{fax}"></td>

  </tr>

  <tr>

    <th align=right>|.$locale->text('E-mail').qq|</th>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=email size=25 value="$form->{email}"></td>

  </tr>

  <tr>
    <td colspan=2>
    <table>
      <tr>

      <th align=right>|.$locale->text('Terms: Net').qq|</th>
      <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=terms size=3 value=$form->{terms}></td>
      <th>|.$locale->text('days').qq|</th>
      <th align=right>&nbsp;&nbsp;&nbsp;|.$locale->text('Debit Limit').qq|</th>
      <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=debitlimit size=9 value="$form->{debitlimit}"></td>
      <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=taxincluded class=checkbox type=checkbox value=1 $form->{taxincluded}></td>
      <th align=left>|.$locale->text('Tax Included').qq|</th>

      </tr>
      </table>
    </td>
  </tr>
 
  $tax
  
  <tr valign=top>

    <th align=right>|.$locale->text('Notes').qq|</th>
    <td rowspan=3>
    <textarea name=notes rows=3 cols=30>$form->{notes}</textarea>
    </td>

  </tr>
  
  </table>

  </td>
</tr>

</table>
|;

}


sub form_footer {

  $label = ucfirst $form->{db};
  if ($form->{db} eq 'customer') {
    $orderline = qq|<input class=submit type=submit name=action value="|.$locale->text('Sales Order').qq|">|;
  }
  if ($form->{db} eq 'vendor') {
    $orderline = qq|<input class=submit type=submit name=action value="|.$locale->text('Purchase Order').qq|">|;
  }

# type=submit $locale->text('Save Customer')
# type=submit $locale->text('Delete Customer')
# type=submit $locale->text('Save Vendor')
# type=submit $locale->text('Delete Vendor')
# type=submit $locale->text('Customer Invoice')
# type=submit $locale->text('Vendor Invoice')

 
  print qq|

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=id type=hidden value=$form->{id}>
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=taxaccounts type=hidden value="$form->{taxaccounts}">

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>

<input type=hidden name=callback value="$form->{callback}">
<input type=hidden name=db value=$form->{db}>
<input type=hidden name=nextfocus value=$form->{nextfocus}>

<br>
<input class=submit type=submit name=action value="|.$locale->text("Save $label").qq|">

|;

  if ($form->{id}) {
    print qq|<input class=submit type=submit name=action value="|.$locale->text('Delete ' . ucfirst $form->{db}).qq|">\n|;
  }

  print qq|<input class=submit type=submit name=action value="|.$locale->text("$label Invoice").qq|">

  $orderline
  
  </form>

</body>
</html>
|;

}


sub customer_invoice {

  $form->isblank("name", $locale->text("Customer Name missing!"));
  CT->save_customer(\%myconfig, \%$form);
  
  $form->{script} = "is.pl";
  require "$form->{path}/$form->{script}";
  $form->{rowcount}=0;

  # locale messages
  $locale = new Locale "$myconfig{countrycode}", "is";

  $form->{customer_id} = $form->{id};
  delete $form->{id};

  # since we are chaining off pull in customized scripts
  &custom_scripts;

  &add;

}


sub vendor_invoice {

  $form->isblank("name", $locale->text("Vendor Name missing!"));
  CT->save_vendor(\%myconfig, \%$form);
  
  $form->{script} = "ir.pl";
  require "$form->{path}/$form->{script}";
  $form->{rowcount}=0;

  # locale messages
  $locale = new Locale "$myconfig{countrycode}", "ir";
  
  $form->{vendor_id} = $form->{id};
  delete $form->{id};

  # since we are chaining off pull in customized scripts
  &custom_scripts;

  &add;

}


sub sales_order {

  $form->isblank("name", $locale->text("Customer Name missing!"));
  CT->save_customer(\%myconfig, \%$form);
  
  $form->{script} = "oe.pl";
  $form->{transtype} = "SO";
  $form->{rowcount}=0;
  require "$form->{path}/$form->{script}";

  # locale messages
  $locale = new Locale "$myconfig{countrycode}", "oe";

  $form->{customer_id} = $form->{id};
  $form->{type} = 'sales_order';
  
  delete $form->{id};

  # since we are chaining off pull in customized scripts
  &custom_scripts;

  &add;

}


sub purchase_order {

  $form->isblank("name", $locale->text("Vendor Name missing!"));
  CT->save_vendor(\%myconfig, \%$form);
  
  $form->{script} = "oe.pl";
  $form->{transtype} = "PO";
  $form->{rowcount}=0;
  require "$form->{path}/$form->{script}";

  # locale messages
  $locale = new Locale "$myconfig{countrycode}", "oe";
  
  $form->{vendor_id} = $form->{id};
  $form->{type} = 'purchase_order';
  
  delete $form->{id};

  # since we are chaining off pull in customized scripts
  &custom_scripts;
    
  &add;

}


sub delete_customer {

  $form->header;

  print qq|
<body bgcolor=ffffff>

<form method=post action=$form->{script}>
|;

  # delete action variable
  delete $form->{action};

  foreach $key (keys %$form) {
    $form->{$key} =~ s/"/&quot;/g;
    print qq|<input type=hidden name=$key value="$form->{$key}">\n|;
  }

  print qq|
<h2><font color=blue>|.$locale->text('Confirm!').qq|</font></h2>

<h4>|.$locale->text('Are you sure you want to delete customer ').qq| $form->{name}</h4>
<p>
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=action class=submit type=submit value="|.$locale->text('Yes Delete Customer').qq|">
</form>
|;


}
sub yes_delete_customer {

  $rc = CT->delete_customer(\%myconfig, \%$form);
  
  if ($rc == -1) {
    $form->error($locale->text('Transactions exist, cannot delete customer!'));
  }

  $form->isdeleted($rc);

}


sub save_customer {

  $form->isblank("name", $locale->text("Customer Name missing!"));
  CT->save_customer(\%myconfig, \%$form);
  $form->redirect;
  
}


sub save_vendor {

  $form->isblank("name", $locale->text("Vendor Name missing!"));
  CT->save_vendor(\%myconfig, \%$form);
  $form->redirect;
  
}


sub delete_vendor {

  $form->header;

  print qq|
<body bgcolor=ffffff>

<form method=post action=$form->{script}>
|;

  # delete action variable
  delete $form->{action};

  foreach $key (keys %$form) {
    $form->{$key} =~ s/"/&quot;/g;
    print qq|<input type=hidden name=$key value="$form->{$key}">\n|;
  }

  print qq|
<h2><font color=blue>|.$locale->text('Confirm!').qq|</font></h2>

<h4>|.$locale->text('Are you sure you want to delete vendor ').qq| $form->{name}</h4>
<p>
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=action class=submit type=submit value="|.$locale->text('Yes Delete Vendor').qq|">
</form>
|;


}

sub yes_delete_vendor {

  $rc = CT->delete_vendor(\%myconfig, \%$form);
  
  if ($rc == -1) {
    $form->error($locale->text('Transactions exist, cannot delete vendor!'));
  }

  $form->isdeleted($rc);

}


sub custom_scripts {

  # customized scripts
  if (-f "$form->{path}/custom_$form->{script}") {
    eval { require "$form->{path}/custom_$form->{script}"; };
    $form->error($@) if ($@);
  }

  # customized scripts for login
  if (-f "$form->{path}/$form->{login}_$form->{script}") {
    eval { require "$form->{path}/$form->{login}_$form->{script}"; };
    $form->error($@) if ($@);
  }

}


