#=====================================================================
# SQL-Ledger Accounting
# Copyright (C) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#  Contributors:
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# Inventory Control backend
#
#======================================================================

package IC;


sub get_part {
  my ($self, $myconfig, $form) = @_;

  # connect to db
  my $dbh = $form->dbconnect($myconfig);

  my $query = qq|SELECT p.*,
                      (SELECT accno FROM chart c
		      WHERE p.inventory_accno_id = c.id) AS inventory_accno,
                      (SELECT accno FROM chart c
		      WHERE p.income_accno_id = c.id) AS income_accno,
                      (SELECT accno FROM chart c
		      WHERE p.expense_accno_id = c.id) AS expense_accno
	         FROM parts p
                 WHERE p.id = $form->{id}|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
  my $ref = $sth->fetchrow_hashref(NAME_lc);

  # copy to $form variables
  map { $form->{$_} = $ref->{$_} } ( keys %{ $ref } );
  
  $sth->finish;
  
 
  # part or service item
  $form->{item} = ($form->{inventory_accno}) ? 'part' : 'service';
  if ($form->{assembly} ) {
    $form->{item} = 'assembly' ;
    #$form->{item} = 'combo' ;

    # retrieve assembly items
    $query = qq|SELECT p.id, p.partnumber, p.description,
                p.sellprice, p.weight, a.qty,p.onhand 
                FROM parts p, assembly a
		WHERE a.parts_id = p.id and combo ='f'
		AND a.id = $form->{id}
		
		union all
		
         	  SELECT p.id, p.partnumber, p.description, p.sellprice, p.weight,a.qty, c.onhand
                 
                 FROM parts as p,(select c.id , sum(onhand) as onhand from combo as c,parts as p where c.parts_id=p.id group by c.id) as c,assembly a
  	         WHERE p.id=c.id 
		 and a.parts_id = p.id 
		 AND a.id = $form->{id}
		
|;

    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);
    
    $form->{assembly_rows} = 0;
    while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
      $form->{assembly_rows}++;
      foreach my $key ( keys %{ $ref } ) {
	$form->{"${key}_$form->{assembly_rows}"} = $ref->{$key};
      }
    }
    $sth->finish;
  }

  if ($form->{combo} ) {
 #   $form->{item} = 'assembly' ;
    $form->{item} = 'combo' ;

    # retrieve assembly items
    $query = qq|SELECT p.id, p.partnumber, p.description,
                p.sellprice, p.weight, p.onhand as qty
                FROM parts p, combo a
		WHERE a.parts_id = p.id 
		AND a.id = $form->{id}|;

    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);
    
    $form->{combo_rows} = 0;
    while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
      $form->{combo_rows}++;
      foreach my $key ( keys %{ $ref } ) {
	$form->{"${key}_$form->{combo_rows}"} = $ref->{$key};
      }
    }
    $sth->finish;
  }

  # setup accno hash for <option checked> {amount} is used in create_links
  $form->{amount}{$ref->{inventory_accno}} = $form->{inventory_accno};
  $form->{amount}{$ref->{income_accno}} = $form->{income_accno};
  $form->{amount}{$ref->{expense_accno}} = $form->{expense_accno};
  

  if ($form->{item} eq 'part') {
    # get makes
    if ($form->{makemodel}) {
      $query = qq|SELECT name FROM makemodel
                  WHERE parts_id = $form->{id}|;

      $sth = $dbh->prepare($query);
      $sth->execute || $form->dberror($query);
      
      my $i = 1;
      while (($form->{"make_$i"}, $form->{"model_$i"}) = split(/:/, $sth->fetchrow_array)) {
	$i++;
      }
      $sth->finish;
      $form->{makemodel_rows} = $i - 1;

    }
  }

  # now get accno for taxes
  $query = qq|SELECT c.accno
              FROM chart c, partstax pt
	      WHERE pt.chart_id = c.id
	      AND pt.parts_id = $form->{id}|;
  
  $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  while (($key) = $sth->fetchrow_array) {
    $form->{amount}{$key} = $key;
  }

  $sth->finish;

  $dbh->disconnect;
  
}


sub save {
  my ($self, $myconfig, $form) = @_;

  ($form->{inventory_accno}) = split(/--/, $form->{IC});
  ($form->{expense_accno}) = split(/--/, $form->{IC_expense});
  ($form->{income_accno}) = split(/--/, $form->{IC_income});

  # connect to database, turn off AutoCommit
  my $dbh = $form->dbconnect_noauto($myconfig);

  # save the part
  # make up a unique handle and store in partnumber field
  # then retrieve the record based on the unique handle to get the id
  # replace the partnumber field with the actual variable
  # add records for makemodel

  # if there is a $form->{id} then replace the old entry
  # delete all makemodel entries and add the new ones

  # escape '
  map { $form->{$_} =~ s/'/\\'/g } qw(partnumber description notes unit);

  # if no data set values to 0
  map { $form->{$_} *= 1 } qw(inventory_accno income_accno expense_accno);

  # undo amount formatting
  map { $form->{$_} = $form->parse_amount($myconfig, $form->{$_}) } qw(rop weight listprice sellprice);
  
  # set date to NULL if nothing entered
  $form->{priceupdate} = ($form->{priceupdate}) ? qq|'$form->{priceupdate}'| : "NULL";
  
  $form->{makemodel} = (($form->{make_1}) || ($form->{model_1})) ? 1 : 0;

  $form->{alternate} = 0;
  $form->{assembly} = ($form->{item} eq 'assembly') ? 1 : 0;
  $form->{combo} = ($form->{item} eq 'combo') ? 1 : 0;
  $form->{obsolete} *= 1;
    $form->{taxincluded} *= 1;
  
  my ($query, $sth, $uid);
  
  if ($form->{id}) {
    
    if ($form->{item} eq 'part') {
      # delete makemodel records
      $query = qq|DELETE FROM makemodel
		  WHERE parts_id = $form->{id}|;
      $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
    }

    if ($form->{item} eq 'assembly') {
      if ($form->{onhand} != 0) {
	&adjust_inventory($dbh, $form, $form->{id}, -$form->{onhand});
      }
      
      # delete assembly records
      $query = qq|DELETE FROM assembly
		  WHERE id = $form->{id}|;
      $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
    }
    
     if ($form->{item} eq 'combo') {
      if ($form->{onhand} != 0) {
	&adjust_combo($dbh, $form, $form->{id}, -$form->{onhand});
      }
      
      # delete assembly records
      $query = qq|DELETE FROM combo
		  WHERE id = $form->{id}|;
      $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
    }
    
    
    # delete tax records
    $query = qq|DELETE FROM partstax
		WHERE parts_id = $form->{id}|;
    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

  } else {
    
    $uid = time;
    $uid .= $form->{login};

    $query = qq|INSERT INTO parts (partnumber)
                VALUES ('$uid')|;
    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

    $query = qq|SELECT id
                FROM parts
		WHERE partnumber = '$uid'|;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    ($form->{id}) = $sth->fetchrow_array;
    $sth->finish;
  }
    
  $query = qq|UPDATE parts SET 
	      partnumber = '$form->{partnumber}',
	      description = '$form->{description}',
	      makemodel = '$form->{makemodel}',
	      alternate = '$form->{alternate}',
	      assembly = '$form->{assembly}',
	      combo = '$form->{combo}',
	      listprice = $form->{listprice},
	      sellprice = $form->{sellprice},
	      weight = $form->{weight},
	      priceupdate = $form->{priceupdate},
	      unit = '$form->{unit}',
	      notes = '$form->{notes}',
	      rop = $form->{rop},
	      avgcost = 0,
	      bin = '$form->{bin}',
	      inventory_accno_id = (SELECT id FROM chart
				    WHERE accno = '$form->{inventory_accno}'),
	      income_accno_id = (SELECT id FROM chart
				 WHERE accno = '$form->{income_accno}'),
	      expense_accno_id = (SELECT id FROM chart
				  WHERE accno = '$form->{expense_accno}'),
              obsolete = '$form->{obsolete}',
              taxincluded = '$form->{taxincluded}'
	      WHERE id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

 
  # insert makemodel records
  if ($form->{item} eq 'part') {
    for my $i (1 .. $form->{makemodel_rows}) {
      # put make and model together
      if (($form->{"make_$i"}) || ($form->{"model_$i"})) {
	$form->{"make_$i"} =~ s/'/\\'/g;
	$form->{"model_$i"} =~ s/'/\\'/g;
	
	$query = qq|INSERT INTO makemodel (parts_id, name)
		    VALUES ($form->{id},
		    '$form->{"make_$i"}:$form->{"model_$i"}')|;
	$dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
      }
    }
  }


  # insert taxes
  foreach $item (split / /, $form->{taxaccounts}) {
    if ($form->{"IC_tax_$item"}) {
      $query = qq|INSERT INTO partstax (parts_id, chart_id)
                  VALUES ($form->{id}, 
		          (SELECT id
			   FROM chart
			   WHERE accno = '$item'))|;
      $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
    }
  }

  # add assembly records
  if ($form->{item} eq 'assembly') {
    
    for my $i (1 .. $form->{assembly_rows}) {
      $form->{"qty_$i"} = $form->parse_amount($myconfig, $form->{"qty_$i"});
      
      if ($form->{"qty_$i"} != 0) {
	$query = qq|INSERT INTO assembly (id, parts_id, qty)
		    VALUES ($form->{id}, $form->{"id_$i"}, $form->{"qty_$i"})|;
	$dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
      }
    }
        # adjust onhand for the parts
    if ($form->{onhand} != 0) {
      &adjust_inventory($dbh, $form, $form->{id}, $form->{onhand});
    }
    
  }

  if ($form->{item} eq 'combo') {
    
    for my $i (1 .. $form->{combo_rows}-1) {
      $form->{"qty_$i"} = $form->parse_amount($myconfig, $form->{"qty_$i"});
      
   #   if ($form->{"qty_$i"} != 0) {
	$query = qq|INSERT INTO combo (id, parts_id)
		    VALUES ($form->{id}, $form->{"id_$i"})|;
	$dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
   #   }
    }
    # adjust onhand for the parts
    #if ($form->{onhand} != 0) {
      &adjust_combo($dbh, $form, $form->{id}, $form->{onhand});
    #}
    
  }

      
  # commit
  my $rc = $dbh->commit;
  $dbh->disconnect;

  $rc;
  
}


sub retrieve_allocated {
  my ($self, $myconfig, $form) = @_;
  
  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my $where = '1 = 1';
  
  if ($form->{id}) {
  #  my $partnumber = $form->like(lc $form->{partnumber});
    $where .= " AND parts_id = '$form->{id}'";
  }
  

  # retrieve assembly items
  my $query = qq|SELECT (qty+allocated)*-1 as qty,sellprice ,transdate
                 FROM invoice,ap
 		 WHERE $where and qty+allocated <  0 and invoice.trans_id=ap.id
		 |;

  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
 # $form->dberror($query);
  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
    push @{ $form->{all_allocated} }, $ref;
  }
  $sth->finish;

  $dbh->disconnect;
  
}


sub retrieve_assemblies {
  my ($self, $myconfig, $form) = @_;
  
  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my $where = '1 = 1';
  
  if ($form->{partnumber}) {
    my $partnumber = $form->like(lc $form->{partnumber});
    $where .= " AND lower(partnumber) LIKE '$partnumber'";
  }
  
  if ($form->{description}) {
    my $description = $form->like(lc $form->{description});
    $where .= " AND lower(description) LIKE '$description'";
  }


  # retrieve assembly items
  my $query = qq|SELECT id, partnumber, description, bin, onhand, rop
                 FROM parts
 		 WHERE $where
		 AND assembly = '1'|;

  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
  
  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
    push @{ $form->{assembly_items} }, $ref;
  }
  $sth->finish;

  $dbh->disconnect;
  
}


sub restock_assemblies {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect_noauto($myconfig);
  
  for my $i (1 .. $form->{rowcount}) {

    $form->{"qty_$i"} = $form->parse_amount($myconfig, $form->{"qty_$i"});

    if ($form->{"qty_$i"} != 0) {
      &adjust_inventory($dbh, $form, $form->{"id_$i"}, $form->{"qty_$i"});
    }

  }
  
  my $rc = $dbh->commit;
  $dbh->disconnect;

  $rc;

}


sub adjust_inventory {
  my ($dbh, $form, $id, $qty) = @_;

  my $query = qq|SELECT p.id, p.inventory_accno_id, p.assembly, a.qty
		 FROM parts p, assembly a
		 WHERE a.parts_id = p.id
		 AND a.id = $id|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {

    my $allocate = $qty * $ref->{qty};
    
    # is it a service item, then loop
    $ref->{inventory_accno_id} *= 1;
    next if (($ref->{inventory_accno_id} == 0) && !$ref->{assembly});
    
    # adjust parts onhand
    $form->update_balance($dbh,
			  "parts",
			  "onhand",
			  qq|id = $ref->{id}|,
			  $allocate * -1);
  }

  $sth->finish;

  # update assembly
  $form->update_balance($dbh,
			"parts",
			"onhand",
			qq|id = $id|,
			$qty);
 
}

sub adjust_combo {
  my ($dbh, $form, $id, $qty) = @_;

  my $query = qq|SELECT p.id, p.inventory_accno_id, p.combo, p.onhand as qty
		 FROM parts p, combo a
		 WHERE a.parts_id = p.id
		 AND a.id = $id|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {

    my $allocate = $qty * $ref->{qty};
    
    # is it a service item, then loop
    $ref->{inventory_accno_id} *= 1;
    next if (($ref->{inventory_accno_id} == 0) && !$ref->{combo});
    
    # adjust parts onhand
    $form->update_balance($dbh,
			  "parts",
			  "onhand",
			  qq|id = $ref->{id}|,
			  $allocate * -1);
  }

  $sth->finish;

  # update assembly
  $form->update_balance($dbh,
			"parts",
			"onhand",
			qq|id = $id|,
			$qty);
 
}



sub delete {
  my ($self, $myconfig, $form) = @_;

  # connect to database, turn off AutoCommit
  my $dbh = $form->dbconnect_noauto($myconfig);

  # check if the item is in the invoice table
  my $query = qq|SELECT trans_id
	      FROM invoice
	      WHERE parts_id = $form->{id}|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
  my ($id) = $sth->fetchrow_array;
  $sth->finish;

  if ($id) {
    $dbh->disconnect;
    return 2;
  }
    # check if the item is in the adjus table
  my $query = qq|SELECT trans_id
	      FROM adjustitems
	      WHERE parts_id = $form->{id}|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
  my ($id) = $sth->fetchrow_array;
  $sth->finish;

  if ($id) {
    $dbh->disconnect;
    return 2;
  }
 
    # check if the item is in the debitnote table
  my $query = qq|SELECT trans_id
	      FROM debititems
	      WHERE parts_id = $form->{id}|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
  my ($id) = $sth->fetchrow_array;
  $sth->finish;

  if ($id) {
    $dbh->disconnect;
    return 2;
  }
   
       # check if the item is in the creditnote table
  my $query = qq|SELECT trans_id
	      FROM credititems
	      WHERE parts_id = $form->{id}|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
  my ($id) = $sth->fetchrow_array;
  $sth->finish;

  if ($id) {
    $dbh->disconnect;
    return 2;
  }
  
  # check if part belongs to an assembly
  $query = qq|SELECT id
              FROM assembly
	      WHERE parts_id = $form->{id}|;
  $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
  ($id) = $sth->fetchrow_array;
  $sth->finish;

  if ($id) {
    $dbh->disconnect;
    return 3;
  }

  # check if the item is in the orderitems table
  my $query = qq|SELECT trans_id
	      FROM orderitems
	      WHERE parts_id = $form->{id}|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
  my ($id) = $sth->fetchrow_array;
  $sth->finish;

  if ($id) {
    $dbh->disconnect;
    return 4;
  }
  
  
  $query = qq|DELETE FROM parts
	      WHERE id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

  $query = qq|DELETE FROM partstax
	      WHERE parts_id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

  # check if it is a part, assembly or service
  if ($form->{item} eq 'part') {
    $query = qq|DELETE FROM makemodel
		WHERE parts_id = $form->{id}|;
    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
  }

  if ($form->{item} eq 'assembly') {
    $query = qq|DELETE FROM assembly
		WHERE id = $form->{id}|;
    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
  }
    if ($form->{item} eq 'combo') {
    $query = qq|DELETE FROM combo
		WHERE id = $form->{id}|;
    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
  }
  
  if ($form->{item} eq 'alternate') {
    $query = qq|DELETE FROM alternate
		WHERE id = $form->{id}|;
    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
  }

  # commit
  my $rc = $dbh->commit;
  $dbh->disconnect;

  $rc;
  
}


sub assembly_item {
  my ($self, $myconfig, $form) = @_;

   $i = $form->{assembly_rows} if $form->{assembly_rows} > 0;
   $i = $form->{combo_rows} if $form->{combo_rows} > 0;
  my $partnumber = $form->like(lc $form->{"partnumber_$i"});
  my $description = $form->like(lc $form->{"description_$i"});
  my $where = "1 = 1";
  my $sort = "";

  if ($partnumber) {
    $where .= " AND lower(partnumber) LIKE '$partnumber'";
  }
  if ($description) {
    $where .= " AND lower(description) LIKE '$description'";
  }
  if ($form->{id}) {
    $where .= " AND NOT id = $form->{id}";
  }

  if ($partnumber) {
    $sort .= " ORDER BY partnumber";
  } else {
    $sort .= " ORDER BY description";
  }

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my $query = qq|
  		select * from(
  		SELECT id, partnumber, description, sellprice, weight, onhand
		   FROM parts
		   WHERE combo<>'1' 
		   
		   union all
		  SELECT p.id, p.partnumber, p.description, p.sellprice, p.weight,c.onhand
                 
                 FROM parts as p,(select c.id , sum(onhand) as onhand from combo as c,parts as p where c.parts_id=p.id group by c.id) as c
  	         WHERE p.id=c.id 
		 
		 $sort
		 ) as foo where $where
		 
		   |;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
#$form->dberror($query);
  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
    push @{ $form->{item_list} }, $ref;
  }
  
  $sth->finish;
  $dbh->disconnect;
  
}

sub all_item_id {
  my ($self, $myconfig, $form) = @_;

 
  my $where = "1 = 1";

  $i=1;
  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my $query = qq|SELECT id,partnumber,description,unit,sellprice,lastcost,onhand
		   FROM parts
		   WHERE $where order by partnumber|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

 
  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
    $form->{"id_$i"} =$ref->{id};
    $form->{"partnumber_$i"} =$ref->{partnumber};
    $form->{"description_$i"} =$ref->{description};
    $form->{"unit_$i"} =$ref->{unit};
    $form->{"onhand_$i"} =$ref->{onhand};
    $form->{"sellprice_$i"} =$ref->{sellprice};
    $form->{"lastcost_$i"} =$ref->{lastcost};
    $form->{"rowcount"}=$i;
    $i++;
  }

  $sth->finish;
  $dbh->disconnect;
  
}

sub all_parts {
  my ($self, $myconfig, $form) = @_;

  my $where = '1 = 1';
  
#  my $onhand = 'p.onhand';
 
  if ($form->{part_id}) {
   # my $partnumber = $form->like(lc $form->{partnumber});
    $where .= " AND p.id=$form->{part_id}";
    }else{
	 if ($form->{partnumber}) {
    my $partnumber = $form->like(lc $form->{partnumber});
    $where .= " AND lower(p.partnumber) LIKE '$partnumber'";
  }
   if ($form->{description}) {
    my $description = $form->like(lc $form->{description});
    $where .= " AND lower(p.description) LIKE '$description'";
  }
      
    }
    
 ($customerno, $form->{customer1}) = split(/--/, $form->{customerno});
  if ($form->{customer1}) {
	  my $source =  $form->{customer1};
    $cwhere .= " AND customer_id = $source";
  }

  ($vendorno, $form->{vendor1}) = split(/--/, $form->{vendorno});
  if ($form->{vendor1}) {
    my $source =  $form->{vendor1};
    $vwhere .= " AND vendor_id =$source";
  }

 
  if ($form->{searchitems} eq 'parts') {
    $where .= " AND p.inventory_accno_id > 0";
  }
  if ($form->{searchitems} eq 'assemblies') {
   # $form->{bought} = "";
    $where .= " AND p.assembly = '1'";
  }
  
    if ($form->{searchitems} eq 'combo') {
   # $form->{bought} = "";
    $where .= " AND p.combo = '1'";
  }
  
  if ($form->{searchitems} eq 'bom') {
    $where .= " AND p.assembly = '1'";
  }

  
  if ($form->{searchitems} eq 'services') {
    $where .= " AND p.inventory_accno_id IS NULL AND NOT assembly = '1' AND NOT combo = '1'";
    # irrelevant for services
    $form->{make} = $form->{model} = "";
  }

  # items which were never bought or sold
  if ($form->{orphaned}) {
    $form->{onhand} = $form->{short} = $form->{bought} = $form->{sold} = 0;
    $form->{transdatefrom} = $form->{transdateto} = "";
    
    $where .= " AND p.onhand = 0
                AND p.id NOT IN (SELECT p.id FROM parts p, invoice i
				 WHERE p.id = i.parts_id)
		AND p.id NOT IN (SELECT p.id FROM parts p, assembly a
				 WHERE p.id = a.parts_id)
                AND p.id NOT IN (SELECT p.id FROM parts p, orderitems o
				 WHERE p.id = o.parts_id)";
  }

  #if ($form->{onhand}) {
  #  $where .= " AND p.onhand > 0";
  #}
  #if ($form->{short}) {
  #  $where .= " AND p.onhand < 0";
  #}
  if ($form->{obsolete}) {
    $where .= " AND p.obsolete = '1'";
  }
 if ($form->{not_obsolete}) {
    $where .= " AND p.obsolete = '0'";
  }
 if ($form->{qtygt}) {
    $where .= " AND p.onhand > 0";
  }
 if ($form->{qtylt}) {
    $where .= " AND p.onhand <= 0";
  }
  
  if ($form->{make}) {
    my $make = $form->like(lc $form->{make}.":");
    $where .= " AND p.id IN (SELECT DISTINCT ON (m.parts_id) m.parts_id
                           FROM makemodel m WHERE lower(m.name) LIKE '$make')";
  }
  if ($form->{model}) {
    my $model = $form->like(lc ":".$form->{model});
    $where .= " AND p.id IN (SELECT DISTINCT ON (m.parts_id) m.parts_id
                           FROM makemodel m WHERE lower(m.name) LIKE '$model')";
  }
 
  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my $sortorder = join ', ', $form->sort_columns(qw( partnumber description bin ));
  $sortorder = $form->{sort} .','. $sortorder;


  my $query = qq|SELECT p.id, p.partnumber, p.description, p.onhand, p.unit,
                 p.bin, p.sellprice, p.listprice, p.lastcost, p.rop, p.weight,
		 p.priceupdate
                 FROM parts as p
  	         WHERE $where
	         ORDER BY $sortorder|;

    if ($form->{searchitems} eq 'combo1') {
    $where .= " AND p.combo = '1'";
    
     $query = qq|
     		SELECT p.id, p.partnumber, p.description,  p.unit,c.onhand,
                 p.bin, p.sellprice, p.listprice, p.lastcost, p.rop, p.weight,
		 p.priceupdate
                 FROM parts as p,(select c.id , sum(onhand) as onhand from combo as c,parts as p where c.parts_id=p.id group by c.id) as c
  	         WHERE p.id=c.id and $where
	         ORDER BY $sortorder
		 
		 |;

  }
  #  $form->dberror( $query);
  
  # leave for next version  
#  if ($form->{searchitems} eq 'bom') {
#    $query = qq|SELECT p.id, p.partnumber, p.description, p.onhand, p.unit,
#                p.bin, p.sellprice, p.listprice, p.lastcost, p.rop, p.weight,
#		p.priceupdate
#                FROM parts p
#  	        WHERE $where
#		AND assembly
#	        ORDER BY $sortorder|;
#	UNION
#		SELECT p.id, p.partnumber, p.description, p.onhand, p.unit,
#		p.bin, p.sellprice, p.listprice, p.lastcost, p.rop, p.weight,
#		p.priceupdate
#		FROM parts p, assembly a
#		WHERE p.id = a.parts_id
#		AND a.id IN (SELECT id FROM parts p WHERE $where)
#$form->{bought} = $form->{sold} = "";
#  }

   $whereob = $where." AND a.transdate < '$form->{transdatefrom}'" if $form->{transdatefrom};
   
   $where .= " AND a.transdate >= '$form->{transdatefrom}'" if $form->{transdatefrom};
   $where .= " AND a.transdate <= '$form->{transdateto}'" if $form->{transdateto};

      $queryirob= qq|SELECT p.id, p.partnumber, p.description,
                i.qty AS onhand,
                p.unit, p.bin, i.sellprice,
		p.listprice, p.lastcost, p.rop, p.weight, p.priceupdate,
		'ir' AS module, a.invnumber,a.transdate,
		i.trans_id,vendornumber as number ,name
		FROM parts p, invoice i, ap a,vendor as vc 
		WHERE $whereob and vc.id=a.vendor_id and a.id=i.trans_id and p.id=i.parts_id  $vwhere|;

  $queryisob= qq|SELECT p.id, p.partnumber, p.description,
                i.qty AS onhand,
                p.unit, p.bin, i.sellprice,
		p.listprice, p.lastcost, p.rop, p.weight, p.priceupdate,
		'is' AS module, a.invnumber,a.transdate,
		i.trans_id,customernumber as number ,name
		FROM parts p, invoice i, ar a,customer as vc
		WHERE $whereob and vc.id=a.customer_id  and a.id=i.trans_id  and p.id=i.parts_id $cwhere|;
  $queryadob= qq|	 SELECT p.id, p.partnumber, p.description,
                i.qty*-1 AS onhand,
                p.unit, p.bin, i.sellprice,
		p.listprice, p.lastcost, p.rop, p.weight, p.priceupdate,
		'adjust' AS module, a.adnumber as invnumber,a.transdate,
		i.trans_id,'','Stock Adjust'
		FROM parts p, adjustitems i, adjust a
		WHERE $whereob  and a.id=i.trans_id  and p.id=i.parts_id|;
  $querycnob= qq|	 SELECT p.id, p.partnumber, p.description,
                i.qty *-1 AS onhand ,
                p.unit, p.bin, i.sellprice,
		p.listprice, p.lastcost, p.rop, p.weight, p.priceupdate,
		'creditnote' AS module, a.ordnumber as invnumber,a.transdate,
		i.trans_id,customernumber as number ,name
		FROM parts p, credititems i, creditnote a,customer as vc
		WHERE $whereob and vendor_id = 0  and a.id=i.trans_id  and vc.id=a.customer_id  and p.id=i.parts_id $cwhere|;
  $querydnob= qq|	 SELECT p.id, p.partnumber, p.description,
                i.qty  AS onhand,
                p.unit, p.bin, i.sellprice,
		p.listprice, p.lastcost, p.rop, p.weight, p.priceupdate,
		'debitnote' AS module, a.ordnumber as invnumber,a.transdate,
		i.trans_id,vendornumber as number ,name
		FROM parts p, credititems i, creditnote a,vendor as vc
		WHERE $whereob and customer_id = 0  and a.id=i.trans_id  and vc.id=a.vendor_id  and p.id=i.parts_id $vwhere|;

		
		
    $fdcd =$form->first_day_current_Date($myconfig) ;

    
 $queryempty = qq|select 0 as id,'' as partnumber,'' as description ,0 as onhand,'' as unit,'' as bin,0 as sellprice,0 as listprice,0 as lastcost,'' as rop,'' as weight
 		,'$fdcd' as priceupdate,'' as module,'' as invnumber ,'$fdcd' as transdate,0 as trans_id,'' as number,'' as name
                     |;
		     
  $queryir= qq|SELECT p.id, p.partnumber, p.description,
                i.qty AS onhand,
                p.unit, p.bin, i.sellprice,
		p.listprice, p.lastcost, p.rop, p.weight, p.priceupdate,
		'ir' AS module, a.invnumber,a.transdate,
		i.trans_id,vendornumber as number ,name
		FROM parts p, invoice i, ap a,vendor as vc 
		WHERE $where and vc.id=a.vendor_id and a.id=i.trans_id and p.id=i.parts_id  $vwhere|;

  $queryis= qq|SELECT p.id, p.partnumber, p.description,
                i.qty AS onhand,
                p.unit, p.bin, i.sellprice,
		p.listprice, p.lastcost, p.rop, p.weight, p.priceupdate,
		'is' AS module, a.invnumber,a.transdate,
		i.trans_id,customernumber as number ,name
		FROM parts p, invoice i, ar a,customer as vc
		WHERE $where and vc.id=a.customer_id  and a.id=i.trans_id  and p.id=i.parts_id $cwhere|;
  $queryad= qq|	 SELECT p.id, p.partnumber, p.description,
                i.qty*-1 AS onhand,
                p.unit, p.bin, i.sellprice,
		p.listprice, p.lastcost, p.rop, p.weight, p.priceupdate,
		'adjust' AS module, a.adnumber as invnumber,a.transdate,
		i.trans_id,'','Stock Adjust'
		FROM parts p, adjustitems i, adjust a
		WHERE $where  and a.id=i.trans_id  and p.id=i.parts_id|;
  $querycn= qq|	 SELECT p.id, p.partnumber, p.description,
                i.qty *-1 AS onhand ,
                p.unit, p.bin, i.sellprice,
		p.listprice, p.lastcost, p.rop, p.weight, p.priceupdate,
		'creditnote' AS module, a.ordnumber as invnumber,a.transdate,
		i.trans_id,customernumber as number ,name
		FROM parts p, credititems i, creditnote a,customer as vc
		WHERE $where and vendor_id = 0  and a.id=i.trans_id  and vc.id=a.customer_id  and p.id=i.parts_id $cwhere|;
  $querydn= qq|	 SELECT p.id, p.partnumber, p.description,
                i.qty  AS onhand,
                p.unit, p.bin, i.sellprice,
		p.listprice, p.lastcost, p.rop, p.weight, p.priceupdate,
		'debitnote' AS module, a.ordnumber as invnumber,a.transdate,
		i.trans_id,vendornumber as number ,name
		FROM parts p, credititems i, creditnote a,vendor as vc
		WHERE $where and customer_id = 0  and a.id=i.trans_id  and vc.id=a.vendor_id  and p.id=i.parts_id $vwhere|;

$whereorder="1=1";
foreach $item (split /;/, $form->{otype}) {
	$whereorder.=" or transtype='$item'";
}

  $whereorder =~ s/1=1 or//;

 $queryov= qq|	 SELECT p.id, p.partnumber, p.description,
                i.qty*-1  AS onhand,
                p.unit, p.bin, i.sellprice,
		p.listprice, p.lastcost, p.rop, p.weight, p.priceupdate,
		'oev' AS module, a.ordnumber as invnumber,a.transdate,
		i.trans_id,vendornumber as number ,name
		FROM parts p, orderitems i, oe a,vendor as vc
		WHERE $where and customer_id = 0  and a.id=i.trans_id  and status=1 and vc.id=a.vendor_id  and p.id=i.parts_id and ($whereorder) $vwhere|;

 $queryoc= qq|	 SELECT p.id, p.partnumber, p.description,
                i.qty  AS onhand ,
                p.unit, p.bin, i.sellprice,
		p.listprice, p.lastcost, p.rop, p.weight, p.priceupdate,
		'oec' AS module, a.ordnumber as invnumber,a.transdate,
		i.trans_id,customernumber as number ,name
		FROM parts p, orderitems i, oe a,customer as vc
		WHERE $where and vendor_id = 0  and a.id=i.trans_id  and status=1 and vc.id=a.customer_id  and p.id=i.parts_id and ($whereorder) $cwhere|;
		
		


  # rebuild query for bought and sold items
  if ($form->{bought} || $form->{sold} || $form->{adjust}|| $form->{creditnote}|| $form->{debitnote}|| $form->{orders}) {
    $where .= " AND i.parts_id = p.id AND i.trans_id = a.id ";

    $queryob = "";
    if($form->{transdatefrom} && $form->{part_id}){
	$queryob .= " union all $queryirob \n "  if $form->{bought} ;
	$queryob .= " union all $queryisob \n "  if $form->{sold} ;
	$queryob .= " union all $queryadob \n "  if $form->{adjust};
	$queryob .= " union all $querycnob \n "  if $form->{creditnote};
	$queryob .= " union all $querydnob \n "  if $form->{debitnote};
	$queryob .= " union all $queryocob \n "  if $form->{orders};
	$queryob .= " union all $queryovob \n "  if $form->{orders};
   }
   
    $queryob =~ s/union all//;
    $queryob = qq| select 0 as id,'OB' as partnumber,'Opening Balance' as description ,sum(onhand) as onhand, '' as unit, '' as bin, 0 as sellprice, 0 as listprice, 0 as lastcost, '' as rop,
    			0 as weight, '$form->{transdatefrom}' as priceupdate, 'ob' as module, '' as invnumber,'$form->{transdatefrom}' as transdate, 0 as trans_id, 'OB' as number, 'Opening Balance' as name from ($queryob) as foo| if ($queryob);
       
      $query = $queryob ;
    $query .= " union all $queryir \n "  if $form->{bought} ;
   $query .= " union all $queryis \n "  if $form->{sold} ;
   $query .= " union all $queryad \n "  if $form->{adjust};
   $query .= " union all $querycn \n "  if $form->{creditnote};
   $query .= " union all $querydn \n "  if $form->{debitnote};
   $query .= " union all $queryoc \n "  if $form->{orders};
   $query .= " union all $queryov \n "  if $form->{orders};
  $query =~ s/union all//  if (!$queryob);


      $query .= " ORDER BY $sortorder";
  # if($query ne $queryempty){
  #  }


  }
  if($form->{vendor1}){
    $query = "";
   $query .= " union all $queryir \n "  if $form->{bought} ;
     $query .= " union all $querydn \n "  if $form->{debitnote};

  }
  if($form->{customer1}){
    $query = "";
   $query .= " union all $queryis \n "  if $form->{sold} ;
     $query .= " union all $querycn \n "  if $form->{creditnote};

  }

  my $sth = $dbh->prepare($query);

$sth->execute || $form->dberror($query);
# $form->dberror( $query);

  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
    push @{ $form->{parts} }, $ref;
  }

  $sth->finish;
  $dbh->disconnect;

}


sub create_links {
  my ($self, $module, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my $query = qq|SELECT accno, description, link
                 FROM chart
		 WHERE link LIKE '%$module%'
		 ORDER BY accno|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
    foreach my $key (split(/:/, $ref->{link})) {
      if ($key =~ /$module/) {
	push @{ $form->{"${module}_links"}{$key} }, { accno => $ref->{accno},
				      description => $ref->{description} };
      }
    }
  }

  $sth->finish;

  if ($form->{id}) {
    $query = qq|SELECT weightunit
                FROM defaults|;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    ($form->{weightunit}) = $sth->fetchrow_array;
    $sth->finish;

  } else {
    $query = qq|SELECT weightunit, current_date
                FROM defaults|;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    ($form->{weightunit}, $form->{priceupdate}) = $sth->fetchrow_array;
    $sth->finish;
  }
  
  $dbh->disconnect;

}


1;

