#=====================================================================
# SQL-Ledger Accounting
# Copyright (C) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#  Contributors:
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# Accounts Payables database backend routines
#
#======================================================================


package AP;


sub post_transaction {
  my ($self, $myconfig, $form) = @_;

  $form->{sub}=$form->{subb};
  # connect to database
  my $dbh = $form->dbconnect_noauto($myconfig);

  my ($null, $taxrate, $amount);
  my $exchangerate = 0;
 $transno = $form->{transno} +1;
 $form->{callback} .= "&accno2=$form->{accno2}&accno3=$form->{accno3}&transdate=$form->{transdate}&transtype=$form->{transtype}&batch=$form->{batch}&transno=$transno&subtransno=$form->{subtransno}&AP=$form->{AP}&AP_amount=$form->{AP_amount}";

  # split and store id numbers in link accounts
 # ($null,$form->{vendor_id}) = split(/--/, $form->{vendor});
  ($form->{AP}{payables}) = split(/--/, $form->{AP});
  ($form->{AP}{amount}) = split(/--/, $form->{AP_amount});

  if ($form->{currency} eq $form->{defaultcurrency}) {
    $form->{exchangerate} = 1;
  } else {
    $exchangerate = $form->check_exchangerate($myconfig, $form->{currency}, $form->{transdate}, 'sell');

    $form->{exchangerate} = ($exchangerate) ? $exchangerate : $form->parse_amount($myconfig, $form->{exchangerate});
  }
  
  # reverse and parse amounts
  $amount = $form->round_amount($form->parse_amount($myconfig, $form->{amount}), 2);
  $form->{amount} = $form->round_amount($amount * $form->{exchangerate} * -1, 2);
  
  # taxincluded doesn't make sense if there is no amount
  $form->{taxincluded} = 0 if ($form->{amount} == 0);

  for my $item (split / /, $form->{taxaccounts}) {
    $form->{AP}{"tax_$item"} = $item;

    $amount = $form->round_amount($form->parse_amount($myconfig, $form->{"tax_$item"}), 2);
    
    $form->{"tax_$item"} = $form->round_amount($amount * $form->{exchangerate} * -1, 2);
    $form->{total_tax} += $form->{"tax_$item"};
  }
 

  # adjust paidaccounts if there is no date in the last row
  $form->{paidaccounts}-- unless ($form->{"datepaid_$form->{paidaccounts}"});
  
  $form->{invpaid} = 0;
  # add payments
  for my $i (1 .. $form->{paidaccounts}) {
    $form->{"paid_$i"} = $form->round_amount($form->parse_amount($myconfig, $form->{"paid_$i"}), 2);
    
    $form->{invpaid} += $form->{"paid_$i"};
    $form->{datepaid} = $form->{"datepaid_$i"};

  }
  
  if ($form->{taxincluded} *= 1) {
    # deduct taxes from amount
    $form->{amount} -= $form->{total_tax};
  }

  # keep netamount positive
  $form->{netamount} = $form->{amount} * -1;

  $form->{invpaid} = $form->round_amount($form->{invpaid} * $form->{exchangerate}, 2);
  
  # store invoice total, this goes into ap table
  $form->{invtotal} = $form->round_amount(($form->{amount} + $form->{total_tax}) * -1, 2);
  
  # amount for total AP
  $form->{payables} = $form->{invtotal};
 

  my ($query, $uid, $sth);

  # if we have an id delete old records
  if ($form->{id}) {

    # delete detail records
    $query = qq|DELETE FROM acc_trans WHERE trans_id = $form->{id}|;

    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query);  
    
  } else {
    $uid = time;
    $uid .= $form->{login};

    $query = qq|INSERT INTO ap (invnumber, employee_id)
                VALUES ( '$uid', (SELECT id FROM employee
		                  WHERE login = '$form->{login}') )|;
    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

    # retrieve id
    $query = qq|SELECT id
                FROM ap
		WHERE invnumber = '$uid'|;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    ($form->{id}) = $sth->fetchrow_array;
    $sth->finish;
    
  }

  # escape '
  $form->{notes} =~ s/'/\\'/g;
    
  $form->{datepaid} = $form->{transdate} unless ($form->{datepaid});
  my $datepaid = ($form->{invpaid} != 0) ? qq|'$form->{datepaid}'| : 'NULL';

  ######for max
      	  #    $form->{qty_1} = $form->format_amount(\%myconfig, $form->{qty_1}, 2, 0) ;
      	  #    $form->{qty_2} = $form->format_amount(\%myconfig, $form->{qty_2}, 2, 0) ;
      	  #    $form->{qty_3} = $form->format_amount(\%myconfig, $form->{qty_3}, 2, 0) ;
      	 #     $form->{qty_4} = $form->format_amount(\%myconfig, $form->{qty_4}, 2, 0) ;
      	 #     $form->{qty_5} = $form->format_amount(\%myconfig, $form->{qty_5}, 2, 0) ;

      	 #     $form->{amount_1} =$form->format_amount(\%myconfig, $form->{amount_1}, 2, 0) ;
     	 #     $form->{amount_2} = $form->format_amount(\%myconfig, $form->{amount_2}, 2, 0) ;
     	 #     $form->{amount_3} = $form->format_amount(\%myconfig, $form->{amount_3}, 2, 0) ;
     	 #     $form->{amount_4} = $form->format_amount(\%myconfig, $form->{amount_4}, 2, 0) ;
     	 #     $form->{amount_5} = $form->format_amount(\%myconfig, $form->{amount_5}, 2, 0) ;
 ########end for max
 
  ######for max
 	#      desc_1 = '$form->{desc_1}',
	#      desc_2 = '$form->{desc_2}',
	#      desc_3 = '$form->{desc_3}',
	#      desc_4 = '$form->{desc_4}',
	#      desc_5 = '$form->{desc_5}',

      	 ##     qty_1 = $form->{qty_1},
      	 #     qty_2 =  $form->{qty_2} ,
      	 #     qty_3 =  $form->{qty_3} ,
      	  #    qty_4 =  $form->{qty_4} ,
      	  #    qty_5 =  $form->{qty_5} ,

      	  #    amount_1 = $form->{amount_1} ,
     	 #     amount_2 =  $form->{amount_2} ,
     	 #     amount_3 =  $form->{amount_3} ,
     	  #    amount_4 =  $form->{amount_4} ,
     	  #    amount_5 =  $form->{amount_5} ,
 $query = qq|UPDATE ap SET

	      invnumber = '$form->{invnumber}',
	      transdate = '$form->{transdate}',
	      ordnumber = '$form->{ordnumber}',
	      vendor_id = $form->{vendor_id},
	      taxincluded = '$form->{taxincluded}',
	      amount = $form->{invtotal},
	      duedate = '$form->{duedate}',
	      paid = $form->{invpaid},
	      datepaid = $datepaid,
	      netamount = $form->{netamount},
	      curr = '$form->{currency}',
	      transno = '$form->{transno}',
	      batch = '$form->{batch}',
	      transtype = '$form->{transtype}',
	      subtransno = '$form->{subtransno}',
	      project = '$form->{project}',
	      subb = '$form->{subb}',
	      notes = '$form->{notes}'
	      WHERE id = $form->{id}
	     |;
	     
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 


  # update exchangerate
  if (($form->{currency} ne $form->{defaultcurrency}) && !$exchangerate) {
    $form->update_exchangerate($dbh, $form->{currency}, $form->{transdate}, 0, $form->{exchangerate});
  }

  # add individual transactions
  foreach my $item (keys %{ $form->{AP} }) {
    # insert detail records in acc_trans
    if ($form->{$item} != 0) {
      $query = qq|INSERT INTO acc_trans (trans_id, chart_id, amount, transdate,project,sub)
                  VALUES ($form->{id}, (SELECT id FROM chart
		                        WHERE accno = '$form->{AP}{$item}'),
		  $form->{$item}, '$form->{transdate}','$form->{project}','$form->{sub}')|;
      $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
    }
  }

  # if there is no amount but a payment record a payable
  if ($form->{amount} == 0 && $form->{invtotal} == 0) {
    $form->{payables} = $form->{invpaid};
  }
 
  # add paid transactions
  for my $i (1 .. $form->{paidaccounts}) {
    if ($form->{"paid_$i"} != 0) {

      $exchangerate = 0;
      if ($form->{currency} eq $form->{defaultcurrency}) {
	$form->{"exchangerate_$i"} = 1;
      } else {
	$exchangerate = $form->check_exchangerate($myconfig, $form->{currency}, $form->{"datepaid_$i"}, 'sell');

	$form->{"exchangerate_$i"} = ($exchangerate) ? $exchangerate : $form->parse_amount($myconfig, $form->{"exchangerate_$i"});
      }
      
      
      # get paid account
      ($form->{AP}{"paid_$i"}) = split(/--/, $form->{"AP_paid_$i"});
      $form->{"datepaid_$i"} = $form->{transdate} unless ($form->{"datepaid_$i"});

      # if there is no amount and invtotal is zero there is no exchangerate
      if ($form->{amount} == 0 && $form->{invtotal} == 0) {
	$form->{exchangerate} = $form->{"exchangerate_$i"};
      }
      
      $amount = $form->round_amount($form->{"paid_$i"} * $form->{exchangerate} * -1, 2);
      if ($form->{payables}) {
	$query = qq|INSERT INTO acc_trans (trans_id, chart_id, amount,
		    transdate,project,sub)
		    VALUES ($form->{id},
		           (SELECT id FROM chart
			    WHERE accno = '$form->{AP}{payables}'),
		    $amount, '$form->{"datepaid_$i"}','$form->{project}','$form->{sub}')|;
	$dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
      }
      $form->{payables} = $amount;

      # add payment
      $query = qq|INSERT INTO acc_trans (trans_id, chart_id, amount,
                  transdate, source,project,sub)
                  VALUES ($form->{id},
		         (SELECT id FROM chart
		          WHERE accno = '$form->{AP}{"paid_$i"}'),
		  $form->{"paid_$i"}, '$form->{"datepaid_$i"}',
		  '$form->{"source_$i"}','$form->{project}','$form->{sub}')|;
      $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
      
      # add exchange rate difference
      $amount = $form->round_amount($form->{"paid_$i"} * ($form->{"exchangerate_$i"} - 1), 2);
      if ($amount != 0) {
	$query = qq|INSERT INTO acc_trans (trans_id, chart_id, amount,
		    transdate, fx_transaction, cleared,project,sub)
		    VALUES ($form->{id},
		           (SELECT id FROM chart
			    WHERE accno = '$form->{AP}{"paid_$i"}'),
		    $amount, '$form->{"datepaid_$i"}', '1', '1','$form->{project}','$form->{sub}')|;

	$dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
      }

      # exchangerate gain/loss
      $amount = $form->round_amount($form->{"paid_$i"} * ($form->{exchangerate} - $form->{"exchangerate_$i"}), 2);

      if ($amount != 0) {
	$accno = ($amount > 0) ? $form->{fxgain_accno} : $form->{fxloss_accno};
	$query = qq|INSERT INTO acc_trans (trans_id, chart_id, amount,
		    transdate, fx_transaction, cleared,project,sub)
		    VALUES ($form->{id}, (SELECT id FROM chart
					  WHERE accno = '$accno'),
		    $amount, '$form->{"datepaid_$i"}', '1', '1','$form->{project}','$form->{sub}')|;
	$dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
      }

      # update exchange rate record
      if (($form->{currency} ne $form->{defaultcurrency}) && !$exchangerate) {
	$form->update_exchangerate($dbh, $form->{currency}, $form->{"datepaid_$i"}, 0, $form->{"exchangerate_$i"});
      }
    }
  }

  my $rc = $dbh->commit;
  $dbh->disconnect;


  $rc;
  
}




sub delete_transaction {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect_noauto($myconfig);

  # check for other foreign currency transactions
  $form->delete_exchangerate($dbh) if ($form->{currency} ne $form->{defaultcurrency});
  
  my $query = qq|DELETE FROM ap WHERE id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

  $query = qq|DELETE FROM acc_trans WHERE trans_id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
  
  # commit and redirect
  my $rc = $dbh->commit;
  $dbh->disconnect;

  $rc;

}



sub process_payments {
  my ($self, $myconfig, $form) = @_;

  my $dbh = $form->dbconnect_noauto($myconfig);

  my ($query, $amount, $exchangerate);
  
  # go through line by line
  for my $i (1 .. $form->{rowcount}) {
    ($form->{"accno_$i"}) = split(/--/, $form->{"accno_$i"});

    $form->{"paid_$i"} = $form->parse_amount(\%myconfig, $form->{"paid_$i"});

    if ($form->{"datepaid_$i"} && $form->{"paid_$i"} != 0) {

      # add payment
      $query = qq|INSERT INTO acc_trans (trans_id, chart_id, transdate, amount,
                  source,project,sub)
                  VALUES ($form->{"id_$i"},
		         (SELECT id FROM chart
		          WHERE accno = '$form->{"accno_$i"}'),
                  '$form->{"datepaid_$i"}', $form->{"paid_$i"},
		  '$form->{"source_$i"}','$form->{project}','$form->{sub}')|;
      $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

      $exchangerate = 0;
      
      # add exchangerate difference if currency ne defaultcurrency
      if ($form->{"currency_$i"} eq $form->{defaultcurrency}) {
	$form->{"exchangerate_$i"} = 1;
      } else {
        # check exchangerate
	$exchangerate = $form->check_exchangerate($myconfig, $form->{"currency_$i"}, $form->{"datepaid_$i"}, 'sell');
	
	$form->{"exchangerate_$i"} = ($exchangerate) ? $exchangerate : $form->parse_amount($myconfig, $form->{"exchangerate_$i"});
      }
      
      $amount = $form->round_amount($form->{"paid_$i"} * ($form->{"exchangerate_$i"} - 1), 2);

      if ($amount != 0) {
	# exchangerate difference
	$query = qq|INSERT INTO acc_trans (trans_id, chart_id, transdate,
	            amount, cleared, fx_transaction,project,sub)
	            VALUES ($form->{"id_$i"},
		           (SELECT id FROM chart
		            WHERE accno = '$form->{"accno_$i"}'),
                    '$form->{"datepaid_$i"}', $amount, '1', '1',
		    '$form->{project}','$form->{sub}')|;
        $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

        # gain / loss
	$amount = $form->round_amount($form->{"paid_$i"} * ($form->{"iexch_$i"} - $form->{"exchangerate_$i"}), 2);
	$accno = ($amount > 0) ? $form->{fxgain_accno} : $form->{fxloss_accno};
	$query = qq|INSERT INTO acc_trans (trans_id, chart_id, transdate,
	            amount, cleared, fx_transaction,project,sub)
	            VALUES ($form->{"id_$i"}, (SELECT id FROM chart
		                               WHERE accno = '$accno'),
                    '$form->{"datepaid_$i"}', $amount, '1', '1','$form->{project}','$form->{sub}')|;
        $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
      }

      # update exchangerate
      if (($form->{"currency_$i"} ne $form->{defaultcurrency}) && !$exchangerate) {
	$form->update_exchangerate($dbh, $form->{"currency_$i"}, $form->{"datepaid_$i"}, 0, $form->{"exchangerate_$i"});
      }

      # amount for AP transaction
      $amount = $form->round_amount($form->{"paid_$i"} * $form->{"iexch_$i"}, 2);
      # reverse amount for AP
      $amount *= -1;
      
      # add AP
      $query = qq|INSERT INTO acc_trans (trans_id, chart_id, transdate, amount,project,sub)
                  VALUES ($form->{"id_$i"}, (SELECT id FROM chart
		                             WHERE accno = '$form->{"AP_$i"}'),
                  '$form->{"datepaid_$i"}', $amount,'$form->{project}','$form->{sub}')|;
      $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 


      # payment to totalpaid
      $form->{"totalpaid_$i"} += $form->{"paid_$i"};
      $form->{"totalpaid_$i"} = $form->round_amount($form->{"totalpaid_$i"} * $form->{"iexch_$i"}, 2);
 
      # update AP transaction
      $query = qq|UPDATE ap SET 
 		  paid = $form->{"totalpaid_$i"},
		  datepaid = '$form->{"datepaid_$i"}'
		  WHERE id = $form->{"id_$i"}|;
      $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
    }
  }
  
  $dbh->commit;
  $dbh->disconnect;

}



sub ap_transactions {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);
 
 
##for max
 # 		a.desc_1,a.desc_2,a.desc_3,a.desc_4,a.desc_5,
#		a.qty_1,a.qty_2,a.qty_3,a.qty_4,a.qty_5,
#		a.amount_1,a.amount_2,a.amount_3,a.amount_4,a.amount_5,
   my $query = qq|SELECT a.id, a.invnumber, a.transdate, a.duedate,
		
                
		a.amount, a.paid, a.ordnumber, v.name, a.invoice,a.rowcount,
	         a.netamount, a.datepaid, a.notes,a.transtype,a.batch,a.transno,a.subtransno,a.subb,a.project,v.vendornumber,(SELECT EXTRACT(EPOCH FROM age(duedate,transdate))) /60/60/24 as terms,e.login
	         FROM ap a, vendor v,employee e
	         WHERE a.vendor_id = v.id and e.id=a.employee_id|;

  my $invnumber = $form->like(lc $form->{invnumber});
  my $ordnumber = $form->like(lc $form->{ordnumber});
  my $notes = $form->like(lc $form->{notes});

  $query .= " AND lower(a.transtype) LIKE lower('$form->{transtypeno}%')" if $form->{transtypeno};
  $query .= " AND lower(a.transno) LIKE lower('$form->{transnono}%')" if $form->{transnono};
  $query .= " AND lower(a.subtransno) LIKE lower('$form->{subtransnono}%')" if $form->{subtransnono};
  $query .= " AND lower(a.batch) LIKE lower('$form->{batchno}%')" if $form->{batchno};
    $query .= " AND lower(a.project) LIKE lower('$form->{project}%')" if $form->{project};
  $query .= " AND lower(a.subb) LIKE lower('$form->{subb}%')" if $form->{subb};

  $query .= " AND lower(a.invnumber) LIKE '$invnumber'" if $form->{invnumber};
  $query .= " AND lower(a.ordnumber) LIKE '$ordnumber'" if $form->{ordnumber};
  $query .= " AND lower(a.notes) LIKE '$notes'" if $form->{notes};
  $query .= " AND a.vendor_id = $form->{vendor_id}" if ($form->{vendor_id});
  $query .= " AND a.transdate >= '$form->{transdatefrom}'" if $form->{transdatefrom};
  $query .= " AND a.transdate <= '$form->{transdateto}'" if $form->{transdateto};

  if ($form->{open} || $form->{closed}) {
    unless ($form->{open} && $form->{closed}) {
      $query .= " AND a.amount <> a.paid" if ($form->{open});
      $query .= " AND a.amount = a.paid" if ($form->{closed});
    }
  }

   my $sortorder = join ', ', $form->sort_columns(qw(transtype batch transno subtransno transdate invnumber vendornumber));
 $sortorder = $form->{sort} unless $sortorder;
  
  $query .= " ORDER by $sortorder";

  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  while (my $ap = $sth->fetchrow_hashref(NAME_lc)) {
    push @{ $form->{AP} }, $ap;
  }
  
  $sth->finish;
  $dbh->disconnect;
  
}



sub payments {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);
  
  # get paid accounts from chart
  my $query = qq|SELECT accno, description
                 FROM chart
	         WHERE link LIKE '%AP_paid%'|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  while (my $ap = $sth->fetchrow_hashref(NAME_lc)) {
    $form->{paidaccount}{$ap->{accno}} = $ap;
  }
  $sth->finish;
    
  # get AP accounts from chart
  $query = qq|SELECT accno
              FROM chart
	      WHERE link LIKE '%AP%'
	      AND link NOT LIKE '%AP_%'|;
  $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  while ($ap = $sth->fetchrow_hashref(NAME_lc)) {
    $form->{AP_account}{$ap->{accno}} = $ap->{accno};
  }
  $sth->finish;

  # get fxgain and loss accounts
  $query = qq|SELECT curr, closedto,
       (SELECT accno FROM chart WHERE id = fxgain_accno_id) AS fxgain_accno,
       (SELECT accno FROM chart WHERE id = fxloss_accno_id) AS fxloss_accno
              FROM defaults|;
  $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);

  ($form->{defaultcurrency}, $form->{closedto}, $form->{fxgain_accno}, $form->{fxloss_accno}) = $sth->fetchrow_array;
  $sth->finish;
  
  $form->{defaultcurrency} =~ s/:.*//;
  
  $query = qq|SELECT a.id, a.invnumber, a.transdate, a.datepaid, a.amount,
              a.paid, a.ordnumber, v.name, a.invoice, a.curr AS currency
	      FROM ap a,vendor v
	      WHERE a.vendor_id = v.id|;

  my $invnumber = $form->like(lc $form->{invnumber});
  my $ordnumber = $form->like(lc $form->{ordnumber});
  
  $query .= " AND lower(a.invnumber) LIKE '$invnumber'" if $form->{invnumber};
  $query .= " AND lower(a.ordnumber) LIKE '$ordnumber'" if $form->{ordnumber};
  $query .= " AND a.vendor_id = $form->{vendor_id}" if ($form->{vendor_id});
  $query .= " AND a.transdate >= '$form->{transdatefrom}'" if $form->{transdatefrom};
  $query .= " AND a.transdate <= '$form->{transdateto}'" if $form->{transdateto};
  $query .= " AND a.amount <> a.paid" if ($form->{open} eq "Y");
  $query .= " ORDER by $form->{sort}";
  
  $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);


  while ($ap = $sth->fetchrow_hashref(NAME_lc)) {

    # get exchangerate
    $ap->{exchangerate} = $form->get_exchangerate($dbh, $ap->{currency}, $ap->{transdate}, "sell");

    # get accno from acc_trans
    $query = qq|SELECT accno, transdate, amount, source, cleared
                FROM acc_trans a, chart c
                WHERE c.id = a.chart_id
		AND a.trans_id = $ap->{id}
		AND NOT a.fx_transaction = '1'
		ORDER BY transdate|;
    my $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);
    
    while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
      # check if the accno matches one of the accounts
      if ($form->{paidaccount}{$ref->{accno}}) {
	$ref->{exchangerate} = $form->get_exchangerate($dbh, $ap->{currency}, $ref->{transdate}, "sell");
	push @{ $ap->{payments} }, $ref;
	next;
      }
      if ($form->{AP_account}{$ref->{accno}}) {
	$ap->{AP_account} = $ref->{accno};
      }
    }
    $sth->finish;

    push @{ $form->{AP} }, $ap;

  }
  
  $sth->finish;
  $dbh->disconnect;

}

sub purchase_report {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);
   $where .= " AND a.transdate >= '$form->{transdatefrom}'" if $form->{transdatefrom};
  $where .= " AND a.transdate <= '$form->{transdateto}'" if $form->{transdateto};
 
  my $query = qq|select vendornumber,name,amount from vendor, 
  		 (SELECT vendor_id,sum(amount) as amount
	         FROM ap a, vendor c
	         WHERE a.vendor_id = c.id $where group by vendor_id) as foo where vendor.id=foo.vendor_id
		 |;

  my $invnumber = $form->like(lc $form->{invnumber});
  my $ordnumber = $form->like(lc $form->{ordnumber});
  my $notes = $form->like(lc $form->{notes});


 # my $sortorder = join ', ', $form->sort_columns(qw( invnumbername));
  $sortorder = $form->{sort} unless $sortorder;

  $query .= "  ORDER by $sortorder ";

  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
#$form->dberror($query);
  while (my $ar = $sth->fetchrow_hashref(NAME_lc)) {
    push @{ $form->{AR} }, $ar;
  }

  $sth->finish;
  $dbh->disconnect;

}


1;

