#!/usr/sbin/dtrace -qs

/*
 * USAGE       : transaction_time.d
 *
 * DESCRIPTION : Measures processing time for each transaction
 *
 * AUTHOR      : Robert Lor <robert.lor@sun.com>
 *
 * $Header$
 */

postgresql*:::transaction-start
{
	self->ts  = timestamp;
}

postgresql*:::transaction-commit
/self->ts/
{
	@commit[pid, arg0] = sum(timestamp - self->ts);
	self->ts=0;
}

postgresql*:::transaction-abort
/self->ts/
{
	@abort[pid, arg0] = sum(timestamp - self->ts);
	self->ts=0;
}

profile:::tick-1s
{
        printf("******* Committed Transactions ******\n");
        printf("%5s %15s %15s\n","PID", "Tx Id", "Time (ns)");
	printf("=====================================\n");
        printa("%5d %15d %@15d\n",@commit);

	printf("\n");

        printf("******** Aborted Transactions *******\n");
        printf("%5s %15s %15s\n","PID", "Tx Id", "Time (ns)");
	printf("=====================================\n");
        printa("%5d %15d %@15d\n",@abort);

        printf("\n\n");

}

tick-1msec
{
	trunc (@commit, 20);
	trunc (@abort, 20);
}
