#!/bin/bash

####################
# default variable #
####################

PGHEADER=/usr/local/pgsql/include
PGLIBDIR=/usr/local/pgsql/lib

##############
# check user #
##############

if [ `id -u` -ne 0 ];then
	echo 'This command in only executed by root'
    exit 1
fi

#################################
#check postgres header directry #
#################################

echo
echo 'Please input postgres header directory'
echo "default setting is..${PGHEADER}"
read PGHEADER_IPT

if [ -n "$PGHEADER_IPT" ]; then
	echo "postgres header directory is setted to ${PGHEADER_IPT}"
	PGHEADER=$PGHEADER_IPT
else
	echo 'continue with default setting..'
fi

if [ ! -d "$PGHEADER" ]; then
	echo
	echo "postgres header directory ${PGHEADER} is not found."
	echo 'you have to specify the valid path.'
	echo
	exit 1;
fi

##################################
#check postgres library directry #
##################################

echo
echo 'Please input postgres library directory'
echo "default setting is..${PGLIBDIR}"
read PGLIBDIR_IPT

if [ -n "$PGLIBDIR_IPT" ]; then
	echo "postgres library directory is setted to ${PGLIBDIR_IPT}"
	PGLIBDIR=$PGLIBDIR_IPT
else
	echo 'continue with default setting..'
fi

if [ ! -d "$PGLIBDIR" ]; then
	echo
	echo "postgres library directory ${PGLIBDIR} is not found."
	echo 'you have to specify the valid path.'
	echo
	exit 1;
fi

# clean up
make clean

RESULT=
function path_escape {
	ARG=$1
	# remove last slash
	if [ -n `echo "$ARG" | grep '\/$'` ]; then 
		RESULT=${ARG%\/}
	fi
	# escape slash
	RESULT=${ARG//\//\\\/}
}

path_escape ${PGHEADER}
PGHEADER=$RESULT

path_escape $PGLIBDIR
PGLIBDIR=$RESULT

#################
# edit Makefile #
#################

sed -e "s/\/usr\/local\/pgsql\/include/${PGHEADER}/g" \
	-e "s/\/usr\/local\/pgsql\/lib/${PGLIBDIR}/g" \
	Makefile.orig > Makefile

#echo
#echo
#more Makefile
#echo
#
#echo 'Is the Makefile fit to your environment ?'
#select input in yes no
#do
#	case $input in
#	    'yes')
#			break
#			;;
#	    'no')
#	    	echo
#	    	echo "PGHEADER=$PGHEADER"
#	    	echo "PGLIBDIR=$PGLIBDIR"
#	    	echo
#	    	cp -f Makefile.orig Makefile
#	    	echo
#	        echo 'quit'
#	        exit 1;
#	        break
#	        ;;
#	    *)
#	        echo 'input argument is invalid'
#	        echo 'please choose number.'
#	        ;;
#	esac
#done

############
# run make #
############

echo
make pgxload
echo

echo
echo 'finish!'

