/**
 * xpsql.c,v 1.5 2003/07/17 14:10:45 myui Exp
 * 
 * ----------------------
 *	Copyright (c) 2003	Makoto Yui <yuin@bb.din.or.jp>
 *  All rights reserved.
 *
 * XpSQL is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * XpSQL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with XpSQL; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * XMLPGSQL Copyright (C) 2001-2003 (Eurah) MediaFront Inc.
 *
 * This file includes part of XMLPGSQL.
 *
 * XMLPGSQL is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * XMLPGSQL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with xpsql; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

//#define __DEBUG__
#define __INFO__				/* show infomations */

#include <string.h>
//#include <stdlib.h>				/* realloc */
#include "xpsql.h"
#include "executor/spi.h"		/* for SPI_exec */
#include "commands/sequence.h"	/* for nextval() */
#include "lib/stringinfo.h"		/* for makeStringInfo() */
#include "mb/pg_wchar.h"

#define LRU_MAP 12
#define MAX_SPLANS 12
#define MAX_OPLANS  8

#define find_replacement(s) 				\
	int max = 0;							\
	for(int i=0; i<LRU_MAP; i++)			\
		max = (s[i]>max) ? s[i] : max;		\
	return max;

#ifndef INT4ARRAYOID
#define INT4ARRAYOID 1007		/* see bootstrap.c, defined in there. */
#endif

#define _SPI_CONN() connected=(SPI_connect()==SPI_ERROR_CONNECT)
#define _SPI_FIN() if(!connected)SPI_finish()

#define R_NORMAL(r) \
		switch(r) \
		{ \
			case 1: elog(NOTICE, "Status: SPI_OK_CONNECT");break; \
			case 2: elog(NOTICE, "Status: SPI_OK_FINISH");break; \
			case 3: elog(NOTICE, "Status: SPI_OK_FETCH");break; \
			case 4: elog(NOTICE, "Status: SPI_OK_UTILITY");break; \
			case 5: elog(NOTICE, "Status: SPI_OK_SELECT");break; \
			case 6: elog(NOTICE, "Status: SPI_OK_SELINTO");break; \
			case 7: elog(NOTICE, "Status: SPI_OK_INSERT");break; \
			case 8: elog(NOTICE, "Status: SPI_OK_DELETE");break; \
			case 9: elog(NOTICE, "Status: SPI_OK_UPDATE");break; \
			case 10: elog(NOTICE, "Status: SPI_OK_CURSOR");break; \
			default: elog(NOTICE, "Unknown status: %d", ret); \
		}

#define R_ERROR(r) \
		switch (r) \
		{ \
			case -1: elog(ERROR, "[SPI_ERROR_CONNECT] %s", query);break; \
			case -2: elog(ERROR, "[SPI_ERROR_COPY] %s", query);break; \
			case -3: elog(ERROR, "[SPI_ERROR_OPUNKNOWN] %s", query);break; \
			case -4: elog(ERROR, "[SPI_ERROR_UNCONNECTED] %s", query);break; \
 			case -5: elog(ERROR, "[SPI_ERROR_CURSOR] %s", query);break; \
			case -6: elog(ERROR, "[SPI_ERROR_ARGUMENT] %s", query);break; \
			case -7: elog(ERROR, "[SPI_ERROR_PARAM] %s", query);break; \
			case -8: elog(ERROR, "[SPI_ERROR_TRANSACTION] %s", query);break; \
			case -9: elog(ERROR, "[SPI_ERROR_NOATTRIBUTE] %s", query);break; \
			case -10: elog(ERROR, "[SPI_ERROR_NOOUTFUNC] %s", query);break; \
			case -11: elog(ERROR, "[SPI_ERROR_TYPUNKNOWN] %s", query);break; \
			default: elog(ERROR, "[SPI_ERROR_OTHER] %s", query); \
		}

/**
 * exec_query
 *		-- internal function
 * 
 * Author: Makoto Yui <yuin@bb.din.or.jp>
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
int
exec_query(char *query)
{
	int ret;

#ifdef __DEBUG__
	elog(NOTICE, "Query:%s", query);
#endif
	if ((ret = SPI_exec(query,0)) < 0) {
		R_ERROR(ret);
	}
#ifdef __DEBUG__
	R_NORMAL(ret);
#endif

	return ret;
}

/**
 * execp_query
 * 
 * @author Makoto Yui <yuin@bb.din.or.jp>
 * @see spi.h
 * @params qstr 
 * 		query skelton
 * @params nargs
 * 		number of input parameters ($1, $2, etc.)
 * @params argtypes
 * 		pointer to an array containing the OIDs of the data types of the parameters
 * @params nulls
 * 		 An array describing which parameters are null.
 * @params ptype
 * 		specify the type of plan.
 */
int
execp_query(char *qstr, int nargs, Oid *argtypes, Datum *pvals, char *nulls, char ptype)
{
	EPlan *qplan;			/* prepared plan */
	int stat;

	if(ptype=='s')
	{ /* for SELECT */
		/* find query plan which stored in memory */
		qplan = find_plan(qstr, &sPlans, &n_sPlans, MAX_SPLANS);
	}
	else if(ptype=='o' || ptype=='i' || ptype=='u' || ptype=='d')
	{ /* for INSERT, UPDATE, DELETE */
		qplan = find_plan(qstr, &oPlans, &n_oPlans, MAX_OPLANS);
	}
	//else /* take care */

	/* if there is no plan, we have to prepare plan ... */
	if (qplan->splan == NULL)
	{
#ifdef __INFO__
		elog(NOTICE, "There is no allocated plan. create new plan.");
#endif
		create_plan(&qplan, qstr, nargs, argtypes);
	}
#ifdef __INFO__
	else	elog(NOTICE, "Reuse already prepared plan.");
#endif

	/* Ok, execute prepared plan. */
	stat = SPI_execp(qplan->splan, pvals, NULL, 0);
	return stat;
}


/**
 * create_new_document:
 *		-- unspecified in DOM level 2, proprietary extention 
 * 
 * Author: Makoto Yui <yuin@bb.din.or.jp>
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(create_new_document);
Datum
create_new_document(PG_FUNCTION_ARGS)
{
	char *qstr;
	int32 node_id, doc_id;
	bool connected, isnull;
	Datum seqname;
	Datum pval1[1];
	Datum pval2[2];
	StringInfo str;
	Oid argtypes1[1] = {VARCHAROID};
	Oid argtypes2[2] = {INT4OID, VARCHAROID};
	Datum doc_file = PG_GETARG_DATUM(0);

#ifdef __DEBUG__
	elog(NOTICE, "[create_new_document] DOCUMENT:%s", 
				 DatumGetCString(DirectFunctionCall1(varcharout, doc_file)));
#endif
	_SPI_CONN();
	
	pval1[0] = doc_file;
	qstr = "SELECT docid FROM xml_document WHERE name=$1 UNION ALL "
		   "SELECT coalesce(max(docid)+1,1) FROM xml_document";
	execp_query(qstr, 1, argtypes1, pval1, NULL, 's');

	if (SPI_processed != 1) {
		_SPI_FIN();
		PG_RETURN_NULL();
	}
	else {
		doc_id = DatumGetInt32(SPI_getbinval
							  (SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1,
							   &isnull));

		pval2[0] = Int32GetDatum(doc_id);
		pval2[1] = doc_file;
		qstr = "INSERT INTO xml_document(docid,name) VALUES($1,$2)";
		execp_query(qstr, 2, argtypes2, pval2, NULL, 'i');

		seqname =
			DirectFunctionCall1(textin, CStringGetDatum("xml_nodeid_seq"));
		DirectFunctionCall1(nextval, seqname);
		node_id = (int32) DatumGetInt64(DirectFunctionCall1(nextval, seqname));
		pfree(DatumGetTextP(seqname));

		str = makeStringInfo();
		appendStringInfo(str,
						 "INSERT INTO xml_node(id,kind,docid,pathid,dewey) VALUES(%d,'%d',%d,0,'{0,%d}');"
						 "INSERT INTO xml_node(id,kind,docid,pathid,dewey) VALUES(%d,'%d',%d,0,'{-1,%d}')",
						 node_id-1, KIND_ROOT, doc_id, doc_id,
						 node_id, KIND_DUMMY, doc_id, doc_id);
		exec_query(str->data);
		pfree(str->data);
		
		_SPI_FIN();
		PG_RETURN_INT32(node_id-1);
	}
}

/**
 * xml_tagid
 *		-- unspecified in DOM level 2, proprietary extention 
 * 
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(xml_tagid);
Datum
xml_tagid(PG_FUNCTION_ARGS)
{
	char *qstr;
	bool connected, isnull;
	Datum tag_id, seqname;
	Datum pval1[1];
	Datum pval2[2];
	Datum tag_name = PG_GETARG_DATUM(0);
	Oid argtypes1[1] = {VARCHAROID};
	Oid argtypes2[2] = {INT4OID, VARCHAROID};
	
#ifdef __DEBUG__
	elog(NOTICE, "[xml_tagid]");
#endif

	_SPI_CONN();
	qstr = "SELECT tagid FROM xml_tag WHERE name = $1";
	pval1[0] = tag_name;
	execp_query(qstr, 1, argtypes1, pval1, NULL, 's');
	
	if (SPI_processed > 0) {
		tag_id = SPI_getbinval
						  (SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1,
						   &isnull);
	}
	else 
	{
		seqname =
			DirectFunctionCall1(textin, CStringGetDatum("xml_tagid_seq"));
		tag_id = DirectFunctionCall1(nextval, seqname);
		pfree(DatumGetTextP(seqname));
		
		qstr = "INSERT INTO xml_tag VALUES($1, $2)";
		pval2[0] = tag_id;
		pval2[1] = tag_name;
		execp_query(qstr, 2, argtypes2, pval2, NULL, 'i');
	}

	_SPI_FIN();
	PG_RETURN_INT32(tag_id);
}

/**
 * xml_attid:
 *		-- unspecified in DOM level 2, proprietary extention 
 * 
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(xml_attid);
Datum
xml_attid(PG_FUNCTION_ARGS)
{
	char *qstr;
	bool connected, isnull;
	Datum att_id, seqname;
	Datum pval1[1];
	Datum pval2[2];
	Datum att_name = PG_GETARG_DATUM(0);
	Oid argtypes1[1] = {VARCHAROID};
	Oid argtypes2[2] = {INT4OID, VARCHAROID};

#ifdef __DEBUG__
	elog(NOTICE, "[xml_attid]");
#endif

	_SPI_CONN();
	
	//att_name
	qstr = "SELECT tagid FROM xml_attribute WHERE name = $1";
	pval1[0] = att_name;
	execp_query(qstr, 1, argtypes1, pval1, NULL, 's');
	
	if (SPI_processed > 0)
		att_id = SPI_getbinval
						  (SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1,
						   &isnull);
	else {
		seqname =
			DirectFunctionCall1(textin, CStringGetDatum("xml_attid_seq"));
		att_id = DirectFunctionCall1(nextval, seqname);
		pfree(DatumGetTextP(seqname));

		// att_id, att_name
		qstr = "INSERT INTO xml_attribute VALUES($1, $2)";
		pval2[0] = att_id;
		pval2[1] = att_name;
		execp_query(qstr, 2, argtypes2, pval2, NULL, 'i');
	}

	_SPI_FIN();
	PG_RETURN_INT32(att_id);
}


/**
 * xml_nsid
 *		-- unspecified in DOM level 2, proprietary extention 
 *
 *  Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(xml_nsid);
Datum
xml_nsid(PG_FUNCTION_ARGS)
{
	char *qstr;
	bool connected, isnull;
	Datum ns_id, seqname;
	Datum pval1[1];
	Datum pval2[2];
	Datum ns_name = PG_GETARG_DATUM(0);
	Oid argtypes1[1] = {VARCHAROID};
	Oid argtypes2[2] = {INT4OID, VARCHAROID};

#ifdef __DEBUG__
	elog(NOTICE, "[xml_nsid]");
#endif

	_SPI_CONN();
	// ns_name
	qstr = "SELECT tagid FROM xml_namespace WHERE name = $1";
	pval1[0] = ns_name;
	execp_query(qstr, 1, argtypes1, pval1, NULL, 's');

	if (SPI_processed > 0)
		ns_id = SPI_getbinval
						  (SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1,
						   &isnull);
	else 
	{
		seqname =
			DirectFunctionCall1(textin, CStringGetDatum("xml_nsid_seq"));
		ns_id = DirectFunctionCall1(nextval, seqname);
		pfree(DatumGetTextP(seqname));

		// ns_id, ns_name
		qstr = "INSERT INTO xml_namespace VALUES($1, $2)";
		pval2[0] = ns_id;
		pval2[1] = ns_name;
		execp_query(qstr, 2, argtypes2, pval2, NULL, 'i');
	}
	
	_SPI_FIN();
	PG_RETURN_INT32(ns_id);
}


/**
 * xml_piid
 *		-- unspecified in DOM level 2, proprietary extention 
 * 
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(xml_piid);
Datum
xml_piid(PG_FUNCTION_ARGS)
{
	char *qstr;
	bool connected, isnull;
	Datum pi_id, seqname;
	Datum pval1[1];
	Datum pval2[2];
	Datum pi_name = PG_GETARG_DATUM(0);
	Oid argtypes1[1] = {VARCHAROID};
	Oid argtypes2[2] = {INT4OID, VARCHAROID};

#ifdef __DEBUG__
	elog(NOTICE, "[xml_piid]");
#endif

	_SPI_CONN();
	qstr = "SELECT tagid FROM xml_pi WHERE name = $1";
	pval1[0] = pi_name;
	execp_query(qstr, 1, argtypes1, pval1, NULL, 's');

	if (SPI_processed > 0)
		pi_id = SPI_getbinval
						  (SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1,
						   &isnull);
	else 
	{
		seqname =
			DirectFunctionCall1(textin, CStringGetDatum("xml_piid_seq"));
		pi_id = DirectFunctionCall1(nextval, seqname);
		pfree(DatumGetTextP(seqname));

		qstr = "INSERT INTO xml_pi VALUES(%d,'%s')", 
		pval2[0] = pi_id;
		pval2[1] = pi_name;
		execp_query(qstr, 2, argtypes2, pval2, NULL, 'i');
	}

	_SPI_FIN();
	PG_RETURN_INT32(pi_id);
}

/**
 * drop_document:
 *		-- unspecified in DOM level 2, proprietary extention
 * 
 * Modified by Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(drop_document);
Datum
drop_document(PG_FUNCTION_ARGS)
{
	char *doc_file =
		DatumGetCString(DirectFunctionCall1(varcharout, PG_GETARG_DATUM(0)));
	int32 doc_id;
	bool connected;
	bool isnull;
	StringInfo str = makeStringInfo();

#ifdef __DEBUG__
	elog(NOTICE, "[drop_document] DOCUMENT:%s", doc_file);
#endif

	_SPI_CONN();
	appendStringInfo(str, "SELECT docid FROM xml_document WHERE name='%s'",
					 doc_file);
	exec_query(str->data);
	initStringInfo(str);
	if (SPI_processed > 0) {
		doc_id =
				 DatumGetInt32(SPI_getbinval
							  (SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1,
							   &isnull));
		appendStringInfo(str,
						 "DELETE FROM xml_document WHERE docid=%d;DELETE FROM xml_node WHERE docid=%d",
						 doc_id, doc_id);
		exec_query(str->data);
		pfree(str->data);
		_SPI_FIN();
		PG_RETURN_BOOL(TRUE);
	}
	else {
		pfree(str->data);
		_SPI_FIN();
		PG_RETURN_BOOL(FALSE);
	}
}

/**
 * get_tagid:
 *		-- unspecified in DOM level 2, proprietary extention 
 * 
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(get_tagid);
Datum
get_tagid(PG_FUNCTION_ARGS)
{
	char *tag_name =
		DatumGetCString(DirectFunctionCall1(varcharout, PG_GETARG_DATUM(0)));
	int32 tag_id;
	bool connected;
	bool isnull;
	StringInfo str = makeStringInfo();

#ifdef __DEBUG__
	elog(NOTICE, "[get_tagid] TAG:%s", tag_name);
#endif
	_SPI_CONN();
	appendStringInfo(str, "SELECT tagid FROM xml_tag WHERE name='%s'",
					 tag_name);
	exec_query(str->data);
	pfree(str->data);

	if (SPI_processed > 0) {
		tag_id =
			DatumGetInt32(SPI_getbinval
						  (SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1,
						   &isnull));
		_SPI_FIN();
		PG_RETURN_INT32(tag_id);
	}
	else {
		_SPI_FIN();
		PG_RETURN_NULL();
	}
}

/**
 * get_attid:
 *		-- unspecified in DOM level 2, proprietary extention 
 * 
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(get_attid);
Datum
get_attid(PG_FUNCTION_ARGS)
{
	char *att_name =
		DatumGetCString(DirectFunctionCall1(varcharout, PG_GETARG_DATUM(0)));
	int32 att_id;
	bool connected;
	bool isnull;
	StringInfo str = makeStringInfo();

#ifdef __DEBUG__
	elog(NOTICE, "[get_attid] ATTRIBUTE:%s", att_name);
#endif

	_SPI_CONN();
	appendStringInfo(str,
					 "SELECT tagid FROM xml_attribute WHERE name='%s'",
					 att_name);
	exec_query(str->data);
	pfree(str->data);

	if (SPI_processed > 0) {
		att_id =
			DatumGetInt32(SPI_getbinval
						  (SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1,
						   &isnull));
		_SPI_FIN();
		PG_RETURN_INT32(att_id);
	}
	else {
		_SPI_FIN();
		PG_RETURN_NULL();
	}
}

/**
 * get_nsid:
 *		-- unspecified in DOM level 2, proprietary extention 
 * 
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(get_nsid);
Datum
get_nsid(PG_FUNCTION_ARGS)
{
	char *ns_name =
		DatumGetCString(DirectFunctionCall1(varcharout, PG_GETARG_DATUM(0)));
	int32 ns_id;
	bool connected;
	bool isnull;
	StringInfo str = makeStringInfo();

#ifdef __DEBUG__
	elog(NOTICE, "[get_nsid] TAG:%s", ns_name);
#endif

	_SPI_CONN();
	appendStringInfo(str,
					 "SELECT tagid FROM xml_namespace WHERE name='%s'",
					 ns_name);
	exec_query(str->data);
	pfree(str->data);

	if (SPI_processed > 0) {
		ns_id =
			DatumGetInt32(SPI_getbinval
						  (SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1,
						   &isnull));
		_SPI_FIN();
		PG_RETURN_INT32(ns_id);
	}
	else {
		_SPI_FIN();
		PG_RETURN_NULL();
	}
}

/**
 * get_piid:
 *		-- unspecified in DOM level 2, proprietary extention 
 * 
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(get_piid);
Datum
get_piid(PG_FUNCTION_ARGS)
{
	char *pi_name =
		DatumGetCString(DirectFunctionCall1(varcharout, PG_GETARG_DATUM(0)));
	int32 pi_id;
	bool connected;
	bool isnull;
	StringInfo str = makeStringInfo();

#ifdef __DEBUG__
	elog(NOTICE, "[get_piid] PI:%s", pi_name);
#endif

	_SPI_CONN();
	appendStringInfo(str, "SELECT tagid FROM xml_pi WHERE name='%s'",
					 pi_name);
	exec_query(str->data);
	pfree(str->data);
	
	if (SPI_processed > 0) {
		pi_id =
			DatumGetInt32(SPI_getbinval
						  (SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1,
						   &isnull));
		_SPI_FIN();
		PG_RETURN_INT32(pi_id);
	}
	else {
		_SPI_FIN();
		PG_RETURN_NULL();
	}
}

/**
 * Document.createElement(tagName)
 * 	-- DOM Level 2 core
 *
 * Description:  
 * 		Creates an element of the type specified. 
 * 		Note that the instance returned implements the Element interface, 
 * 		so attributes can be specified directly on the returned object.
 * 
 * Parameters: 
 * 		DOMString tagName  -  The name of the element type to instantiate. 
 * 							(Remember that for XML this is case-sensitive.)
 * 
 * Returns:  
 * 		Element -  A new Element object with the nodeName attribute set to tagName, 
 * 				and localName, prefix, and namespaceURI set to null.
 * 
 * Exceptions:  
 * 		DOMException INVALID_CHARACTER_ERR -- not yet impled
 * 		Raised if the specified name contains an illegal character.
 *  
 * Author: Makoto Yui <yuin@bb.din.or.jp>
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(createelement);
Datum
	createelement(PG_FUNCTION_ARGS)
{
	int32 doc_node=PG_GETARG_INT32(0);
	char *tag_name=DatumGetCString(DirectFunctionCall1(varcharout, PG_GETARG_DATUM(1)));
	int doc_id;
	int32 node_id;
	int32 dummy_id;
	bool connected;
	Datum seqname;
	StringInfo str = makeStringInfo();
	
#ifdef __DEBUG__
	elog(NOTICE,"[createElement] DOC_NODE:%d TAG:%s",doc_node,tag_name);
#endif
	_SPI_CONN();
	
	appendStringInfo(str, "SELECT docid FROM xml_node WHERE id = %d AND kind = '%d'",
					doc_node, KIND_ROOT);
	exec_query(str->data);
	initStringInfo(str);
	if(SPI_processed==0){
#ifdef __DEBUG__
		elog(NOTICE,"[createElement] Raising a DOMException,"
					"first argument must be document-node.");
#endif
		_SPI_FIN();
		PG_RETURN_NULL();
	}
	doc_id=atoi(SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1));

	seqname = DirectFunctionCall1(textin,CStringGetDatum("xml_nodeid_seq"));
	node_id = (int32) DatumGetInt64(DirectFunctionCall1(nextval,seqname));
	pfree(DatumGetTextP(seqname));
	
	seqname = DirectFunctionCall1(textin,CStringGetDatum("xml_node_dummy_seq"));
	dummy_id = (int32) DatumGetInt64(DirectFunctionCall1(nextval,seqname));
	pfree(DatumGetTextP(seqname));

#ifdef __DEBUG__
	elog(NOTICE,"NODE:%d",node_id);
#endif

	/* set node */
	appendStringInfo(str, "INSERT INTO xml_node(id,kind,docid,pathid,dewey,parent,tagid) "
						  "VALUES(%d,'%d',%d,%d,'{-1,%d,%d}',%d,xml_tagid('%s'));"
						  "INSERT INTO xml_path VALUES(%d,'#/%s','false')",
					node_id, KIND_ELEMENT, doc_id, node_id, doc_id, dummy_id, doc_node, tag_name,
					node_id, tag_name
				);
	exec_query(str->data);
	
	pfree(str->data);		
	_SPI_FIN();
	PG_RETURN_INT32(node_id);
}

/**
 * Document.createProcessingInstruction(target, data)
 *		-- DOM Level 2 core
 * 
 * Description:  
 * 		Creates a ProcessingInstruction node given the specified name and data strings.
 * 
 * Parameters:  
 * 		DOMString target  -  The target part of the processing instruction.
 * 		DOMString data  -  The data for the node.
 * 
 * Returns:  
 * 		ProcessingInstruction -  The new ProcessingInstruction object.
 * 
 * Exceptions:  
 * 		DOMException INVALID_CHARACTER_ERR
 * 			Raised if the specified target contains an illegal character. 
 * 		DOMException NOT_SUPPORTED_ERR
 * 			Raised if this document is an HTML document. 
 * 
 * Author: Makoto Yui <yuin@bb.din.or.jp>
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(createprocessinginstruction);
Datum
	createprocessinginstruction(PG_FUNCTION_ARGS)
{
	int32 doc_node=PG_GETARG_INT32(0);
	char *pi_name=DatumGetCString(DirectFunctionCall1(varcharout, PG_GETARG_DATUM(1)));
	char *pi_data=DatumGetCString(DirectFunctionCall1(varcharout, PG_GETARG_DATUM(2)));
	int doc_id;
	int32 node_id;
	int32 dummy_id;
	bool connected;
	Datum seqname;
	StringInfo str = makeStringInfo();
	
#ifdef __DEBUG__
	elog(NOTICE,"[createProcessingInstruction] DOC_NODE:%d PI_NAME:%s",doc_node,pi_name);
#endif
	_SPI_CONN();

	appendStringInfo(str, "SELECT docid FROM xml_node WHERE id = %d AND kind = '%d'",
					doc_node, KIND_ROOT);
	exec_query(str->data);
	initStringInfo(str);
	if(SPI_processed==0){
#ifdef __DEBUG__
		elog(NOTICE,"[createProcessingInstruction] Raising a DOMException,"
					"first argument must be document-node.");
#endif
		_SPI_FIN();
		PG_RETURN_NULL();
	}
	doc_id=atoi(SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1));

	seqname = DirectFunctionCall1(textin,CStringGetDatum("xml_nodeid_seq"));
	node_id = (int32) DatumGetInt64(DirectFunctionCall1(nextval,seqname));
	pfree(DatumGetTextP(seqname));

	seqname = DirectFunctionCall1(textin,CStringGetDatum("xml_node_dummy_seq"));
	dummy_id = (int32) DatumGetInt64(DirectFunctionCall1(nextval,seqname));
	pfree(DatumGetTextP(seqname));

#ifdef __DEBUG__
	elog(NOTICE,"NODE:%d",node_id);
#endif

	pi_data = escapeString(pi_data);
	appendStringInfo(str, "INSERT INTO xml_node(id,kind,docid,pathid,dewey,parent,tagid,value) "
						  "VALUES(%d, '%d', %d, %d, '{-1,%d,%d}', %d, xml_piid('%s'), '%s');"
						  "INSERT INTO xml_path VALUES(%d,'#/processing-instruction()','false')",
					node_id, KIND_PI, doc_id, node_id, doc_id, dummy_id, doc_node, pi_name, pi_data,
					node_id
				);
	exec_query(str->data);

	pfree(str->data);		
	_SPI_FIN();
	PG_RETURN_INT32(node_id);
}

/**
 * Document.createTextNode(data)
 *	-- DOM Level 2 core
 * 
 * Description:  
 * 		Creates a Text node given the specified string.
 * 
 * Parameters:  
 * 		DOMString data  -  The data for the node.
 * 
 * Returns:  
 * 		Text -  The new Text object.
 * 
 * Exceptions:  
 * 		none
 * 
 * Author: Makoto Yui <yuin@bb.din.or.jp>
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(createtextnode);
Datum
	createtextnode(PG_FUNCTION_ARGS)
{
	int32 doc_node=PG_GETARG_INT32(0);
	char *content=DatumGetCString(DirectFunctionCall1(varcharout, PG_GETARG_DATUM(1)));
	int doc_id;
	int32 node_id;
	int32 dummy_id;
	bool connected;
	Datum seqname;
	StringInfo str = makeStringInfo();
	
#ifdef __DEBUG__
	elog(NOTICE,"[createTextNode] DOC_NODE:%d VALUE:%s",doc_node,content);
#endif
	_SPI_CONN();
	
	appendStringInfo(str, "SELECT docid FROM xml_node WHERE id = %d AND kind = '%d'",
					doc_node, KIND_ROOT);
	exec_query(str->data);
	initStringInfo(str);
	if(SPI_processed==0){
#ifdef __DEBUG__
		elog(NOTICE,"[createTextNode] Raising a DOMException,"
					"first argument must be document-node.");
#endif
		_SPI_FIN();
		PG_RETURN_NULL();
	}
	doc_id=atoi(SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1));

	seqname = DirectFunctionCall1(textin,CStringGetDatum("xml_nodeid_seq"));
	node_id = (int32) DatumGetInt64(DirectFunctionCall1(nextval,seqname));
	pfree(DatumGetTextP(seqname));

	seqname = DirectFunctionCall1(textin,CStringGetDatum("xml_node_dummy_seq"));
	dummy_id = (int32) DatumGetInt64(DirectFunctionCall1(nextval,seqname));
	pfree(DatumGetTextP(seqname));

#ifdef __DEBUG__
	elog(NOTICE,"NODE:%d",node_id);
#endif

	content = escapeString(content);
	appendStringInfo(str, "INSERT INTO xml_node(id,kind,docid,pathid,dewey,parent,value) "
						  "VALUES(%d, '%d', %d, %d, '{-1,%d,%d}', %d, '%s');"
						  "INSERT INTO xml_path VALUES(%d,'#/text()','false')",
					node_id, KIND_TEXT, doc_id, node_id, doc_id, dummy_id, doc_node, content,
					node_id);
	exec_query(str->data);

	pfree(str->data);		
	_SPI_FIN();
	PG_RETURN_INT32(node_id);
}

/**
 * Document.createComment(data)
 *		-- DOM Level 2 core
 *
 * Description:  
 * 		Creates a Comment node given the specified string.
 * 
 * Parameters:  
 * 		DOMString data  -  The data for the node.
 * 
 * Returns:  
 * 		Comment -  The new Comment object.
 * 
 * Exceptions:  
 * 		none
 * 
 * Author: Makoto Yui <yuin@bb.din.or.jp>
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(createcomment);
Datum
	createcomment(PG_FUNCTION_ARGS)
{
	int32 doc_node=PG_GETARG_INT32(0);
	char *content=DatumGetCString(DirectFunctionCall1(varcharout, PG_GETARG_DATUM(1)));
	//char *doc_id;
	int doc_id;
	int32 node_id;
	int32 dummy_id;
	bool connected;
	Datum seqname;
	StringInfo str = makeStringInfo();
	
#ifdef __DEBUG__
	elog(NOTICE,"[createComment] DOC_NODE:%d VALUE:%s",doc_node,content);
#endif
	_SPI_CONN();

	appendStringInfo(str, "SELECT docid FROM xml_node WHERE id = %d AND kind = '%d'",
					doc_node, KIND_ROOT);
	exec_query(str->data);
	initStringInfo(str);
	if(SPI_processed==0){
#ifdef __DEBUG__
		elog(NOTICE,"[createComment] Raising a DOMException,"
					"first argument must be document-node.");
#endif
		_SPI_FIN();
		PG_RETURN_NULL();
	}
	doc_id=atoi(SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1));

	seqname = DirectFunctionCall1(textin,CStringGetDatum("xml_nodeid_seq"));
	node_id = (int32) DatumGetInt64(DirectFunctionCall1(nextval,seqname));
	pfree(DatumGetTextP(seqname));

	seqname = DirectFunctionCall1(textin,CStringGetDatum("xml_node_dummy_seq"));
	dummy_id = (int32) DatumGetInt64(DirectFunctionCall1(nextval,seqname));
	pfree(DatumGetTextP(seqname));

#ifdef __DEBUG__
	elog(NOTICE,"NODE:%d",node_id);
#endif

	content = escapeString(content);
	appendStringInfo(str, "INSERT INTO xml_node(id,kind,docid,pathid,dewey,parent,value) "
						  "VALUES(%d, '%d', %d, %d, '{-1,%d,%d}', %d, '%s');"
						  "INSERT INTO xml_path VALUES(%d,'#/comment()','false')",
					node_id, KIND_COMMENT, doc_id, node_id, doc_id, dummy_id, doc_node, content,
					node_id
				);
	exec_query(str->data);
	
	pfree(str->data);		
	_SPI_FIN();
	PG_RETURN_INT32(node_id);
}

/**
 * addChildElement
 *		-- unspecified in DOM level 2, proprietary extention
 * 
 * Author: Makoto Yui <yuin@bb.din.or.jp>
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(addchildelement);
Datum
addchildelement(PG_FUNCTION_ARGS)
{
	char *qstr;
	bool connected, isnull;
	Datum doc_id, node_id, seqname;
	Datum pval1[1];
	Datum pval4[4];
	Datum parent_id = PG_GETARG_DATUM(0);
	Datum tag_name = PG_GETARG_DATUM(1);
	Oid argtypes1[1] = {INT4OID};
	Oid argtypes4[4] = {INT4OID, INT4OID, INT4OID, INT4OID};
	
#ifdef __DEBUG__
	elog(NOTICE, "[addChildElement]");
#endif
	_SPI_CONN();

	/*
	 * Error check routine for DOMException, HIERARCHY_REQUEST_ERR
	 */
	pval1[0] = parent_id;
	qstr = "SELECT docid FROM xml_node "
		   "WHERE id = $1 AND (kind = 1 OR (kind = 0 AND child IS NULL))";
	execp_query(qstr, 1, argtypes1, pval1, NULL, 's');
	
	if (SPI_processed == 0) {
		_SPI_FIN();
		PG_RETURN_NULL();
	}
	doc_id = SPI_getbinval(SPI_tuptable->vals[0], 
						SPI_tuptable->tupdesc, 1, &isnull);

	seqname = DirectFunctionCall1(textin, CStringGetDatum("xml_nodeid_seq"));
	// should cast to INT32 from INT64 ?
	node_id = DirectFunctionCall1(nextval, seqname);
	pfree(DatumGetTextP(seqname));
	
	/*
	 * SET node info
	 */
	pval4[0] = pval4[2] = node_id;
	pval4[1] = doc_id;
	pval4[3] = DirectFunctionCall1(xml_tagid, tag_name);
	qstr = "INSERT INTO xml_node(id,kind,docid,pathid,tagid) "
		   "VALUES($1, 1, $2, $3, $4)";
	execp_query(qstr, 4, argtypes4, pval4, NULL, 'i');

	/*
	 * SET parent-child link
	 */
	DirectFunctionCall2(appendchild, parent_id, node_id);

	_SPI_FIN();
	PG_RETURN_INT32(node_id);
}

/**
 * addChildPi:
 *		-- unspecified in DOM level 2, proprietary extention
 * 
 * Author: Makoto Yui <yuin@bb.din.or.jp>
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(addchildpi);
Datum
addchildpi(PG_FUNCTION_ARGS)
{
	char *qstr;
	bool connected, isnull;
	Datum doc_id, node_id, seqname;
	Datum pval1[1];
	Datum pval5[5];
	Datum parent_id = PG_GETARG_DATUM(0);
	Datum pi_name = PG_GETARG_DATUM(1);
	char *pi_data = 
		DatumGetCString(DirectFunctionCall1(varcharout, PG_GETARG_DATUM(2)));
	Oid argtypes1[1] = {INT4OID};
	Oid argtypes5[5] = {INT4OID, INT4OID, INT4OID, INT4OID, VARCHAROID};
	
#ifdef __DEBUG__
	elog(NOTICE, "[addChildPi]");
#endif
	_SPI_CONN();
	
	qstr = "SELECT docid FROM xml_node WHERE id = $1 AND kind = 1";
	pval1[0] = parent_id;
	execp_query(qstr, 1, argtypes1, pval1, NULL, 's');

	if (SPI_processed == 0) {
		_SPI_FIN();
		PG_RETURN_NULL();
	}
	doc_id = SPI_getbinval(SPI_tuptable->vals[0], 
						SPI_tuptable->tupdesc, 1, &isnull);

	seqname = DirectFunctionCall1(textin, CStringGetDatum("xml_nodeid_seq"));
	node_id = DirectFunctionCall1(nextval, seqname);
	pfree(DatumGetTextP(seqname));

#ifndef __OFF_ESCAPING__
	pi_data = escapeString(pi_data);
#endif
	qstr = "INSERT INTO xml_node(id,kind,docid,pathid,tagid,value) "
		   "VALUES(%d, 4, %s, %d, ('%s'), '%s')";
	pval5[0] = pval5[2] = node_id;
	pval5[1] = doc_id;
	pval5[3] = DirectFunctionCall1(xml_piid, pi_name);
	pval5[4] = CStringGetDatum(pi_data);
	execp_query(qstr, 5, argtypes5, pval5, NULL, 'i');

	DirectFunctionCall2(appendchild, parent_id, node_id);

	_SPI_FIN();
	PG_RETURN_INT32(node_id);
}

/**
 * addChildText:
 *		-- unspecified in DOM level 2, proprietary extention
 * 
 * Author: Makoto Yui <yuin@bb.din.or.jp>
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(addchildtext);
Datum
addchildtext(PG_FUNCTION_ARGS)
{
	char *qstr;
	bool connected, isnull;
	Datum doc_id, node_id, seqname;
	Datum pval1[1];
	Datum pval4[4];
	Datum parent_id = PG_GETARG_DATUM(0);
	char *content =
		DatumGetCString(DirectFunctionCall1(varcharout, PG_GETARG_DATUM(1)));
	Oid argtypes1[1] = {INT4OID};
	Oid argtypes4[4] = {INT4OID, INT4OID, INT4OID, VARCHAROID};

#ifdef __DEBUG__
	elog(NOTICE, "[addChildText]");
#endif
	_SPI_CONN();
	
	qstr = "SELECT docid FROM xml_node WHERE id = $1 AND kind = 1";
	pval1[0] = parent_id;
	execp_query(qstr, 1, argtypes1, pval1, NULL, 's');
	
	if (SPI_processed == 0) {
		_SPI_FIN();
		PG_RETURN_NULL();
	}
	doc_id = SPI_getbinval(SPI_tuptable->vals[0], 
						SPI_tuptable->tupdesc, 1, &isnull);

	seqname = DirectFunctionCall1(textin, CStringGetDatum("xml_nodeid_seq"));
	node_id = DirectFunctionCall1(nextval, seqname);
	pfree(DatumGetTextP(seqname));

	content = escapeString(content);
	qstr = "INSERT INTO xml_node(id,kind,docid,pathid,value) "
		   "VALUES(%d, 2, %s, %d, '%s')";
	pval4[0] = pval4[2] = node_id;
	pval4[1] = doc_id;
	pval4[3] = CStringGetDatum(content);
	execp_query(qstr, 4, argtypes4, pval4, NULL, 'i');

	DirectFunctionCall2(appendchild, parent_id, node_id);

	_SPI_FIN();
	PG_RETURN_INT32(node_id);
}

/**
 * addChildComment:
 *		-- unspecified in DOM level 2, proprietary extention
 * 
 * Author: Makoto Yui <yuin@bb.din.or.jp>
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(addchildcomment);
Datum
addchildcomment(PG_FUNCTION_ARGS)
{
	char *qstr;
	bool connected, isnull;
	Datum doc_id, node_id, seqname;
	Datum pval1[1];
	Datum pval4[4];
	Datum parent_id = PG_GETARG_DATUM(0);
	char *content =
		DatumGetCString(DirectFunctionCall1(varcharout, PG_GETARG_DATUM(1)));
	Oid argtypes1[1] = {INT4OID};
	Oid argtypes4[4] = {INT4OID, INT4OID, INT4OID, VARCHAROID};

#ifdef __DEBUG__
	elog(NOTICE, "[addChildComment]");
#endif
	_SPI_CONN();

	qstr = "SELECT docid FROM xml_node WHERE id = $1 AND kind = 2";
	pval1[0] = parent_id;
	execp_query(qstr, 1, argtypes1, pval1, NULL, 's');

	if (SPI_processed == 0) {
		_SPI_FIN();
		PG_RETURN_NULL();
	}
	doc_id = SPI_getbinval(SPI_tuptable->vals[0], 
						SPI_tuptable->tupdesc, 1, &isnull);

	seqname = DirectFunctionCall1(textin, CStringGetDatum("xml_nodeid_seq"));
	node_id = DirectFunctionCall1(nextval, seqname);
	pfree(DatumGetTextP(seqname));

#ifndef __OFF_ESCAPING__
	content = escapeString(content);
#endif
	qstr = "INSERT INTO xml_node(id,kind,docid,pathid,value) "
		   "VALUES(%d, 3, %s, %d, '%s')";
	pval4[0] = pval4[2] = node_id;
	pval4[1] = doc_id;
	pval4[3] = CStringGetDatum(content);
	execp_query(qstr, 4, argtypes4, pval4, NULL, 'i');
	
	DirectFunctionCall2(appendchild, parent_id, node_id);

	_SPI_FIN();
	PG_RETURN_INT32(node_id);
}

/**
 * setAttribute:
 * 
 * Description: 
 * 		Adds a new attribute. 
 * 
 * Parameters:  
 * 		DOMString name  -  The name of the attribute to create or alter.
 * 		DOMString value  -  Value to set in string form.
 * 
 * Returns:  
 * 		attid
 * 
 * Modified by Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(setattribute);
Datum
setattribute(PG_FUNCTION_ARGS)
{
	char *qstr;
	bool connected, isnull;
	Datum doc_id, node_id, seqname;
	Datum pval1[1];
	Datum pval2[2];
	Datum pval5[5];
	Datum parent_id = PG_GETARG_DATUM(0);
	Datum att_name = PG_GETARG_DATUM(1);
	char *att_value =
		DatumGetCString(DirectFunctionCall1(varcharout, PG_GETARG_DATUM(2)));
	Oid argtypes1[1] = {INT4OID};
	Oid argtypes2[2] = {INT4OID, INT4OID};
	Oid argtypes5[5] = {INT4OID, INT4OID, INT4OID, INT4OID, VARCHAROID};

#ifdef __DEBUG__
	elog(NOTICE, "[setAttribute]");
#endif
	_SPI_CONN();
	
	qstr = "SELECT id FROM xml_node "
		   "WHERE kind = 5 AND parent = $1 AND tagid = $2";
	pval2[0] = parent_id;
	pval2[1] = DirectFunctionCall1(get_attid, att_name);
	execp_query(qstr, 2, argtypes2, pval2, NULL, 's');

#ifndef __OFF_ESCAPING__
	att_value = escapeString(att_value);
#endif

	if (SPI_processed > 0) {
		node_id = SPI_getbinval
						  (SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1,
						   &isnull);
		qstr = "UPDATE xml_node SET value = $1 WHERE id = $2";
		argtypes2[0] = VARCHAROID;
		pval2[0] = CStringGetDatum(att_value);
		pval2[1] = node_id;
		execp_query(qstr, 2, argtypes2, pval2, NULL, 'u');
	}
	else 
	{
		qstr ="SELECT docid FROM xml_node WHERE id = $1";
		pval1[0] = parent_id;
		execp_query(qstr, 1, argtypes1, pval1, NULL, 's');
		
		if (SPI_processed == 0) {
			_SPI_FIN();
			PG_RETURN_NULL();
		}
		doc_id = SPI_getbinval
						  (SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1,
						   &isnull);

		seqname =
			DirectFunctionCall1(textin, CStringGetDatum("xml_nodeid_seq"));
		node_id = DirectFunctionCall1(nextval, seqname);
		pfree(DatumGetTextP(seqname));

		qstr = "INSERT INTO xml_node(id,kind,docid,pathid,tagid,value) "
			   "VALUES($1, 5, $2, $3, $4, $5)";
		pval5[0] = pval5[2] = node_id;
		pval5[1] = doc_id;
		pval5[3] = DirectFunctionCall1(xml_attid, att_name);
		pval5[4] = CStringGetDatum(att_value);
		execp_query(qstr, 5, argtypes5, pval5, NULL, 'i');

		qstr = "UPDATE xml_node SET parent = $1 WHERE id = $2";
		pval2[0] = parent_id;
		pval2[1] = node_id;
		execp_query(qstr, 2, argtypes2, pval2, NULL, 'u');
	}

	_SPI_FIN();
	PG_RETURN_INT32(node_id);
}

/**
 * setNamespace
 *		-- unspecified in DOM level 2, proprietary extention 
 * 
 * Author: Makoto Yui <yuin@bb.din.or.jp>
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(setnamespace);
Datum
setnamespace(PG_FUNCTION_ARGS)
{
	char *qstr, *ns_value;
	bool connected, isnull, default_ns;
	Datum doc_id, node_id, ns_name, seqname;
	Datum pval1[1];
	Datum pval2[2];
	Datum pval4[4];
	Datum parent_id = PG_GETARG_DATUM(0);
	Oid argtypes1[1] = {INT4OID};
	Oid argtypes2[2] = {INT4OID, INT4OID};
	Oid argtypes4[4] = {INT4OID, INT4OID, INT4OID, VARCHAROID};
	StringInfo str = makeStringInfo();
	
	if (fcinfo->nargs == 3)
	{
		default_ns = FALSE;
		ns_name = PG_GETARG_DATUM(1);
		ns_value = DatumGetCString(
					DirectFunctionCall1(varcharout, PG_GETARG_DATUM(2)));	
	}
	else if(fcinfo->nargs == 2)
	{
		default_ns = TRUE;
		appendStringInfo(str, "xmlns:%s", 
						DatumGetCString(DirectFunctionCall1(varcharout, PG_GETARG_DATUM(1)))
						);		
		ns_name = CStringGetDatum(str);
		ns_value = DatumGetCString(
					DirectFunctionCall1(varcharout, PG_GETARG_DATUM(1)));			
	}
	else
		PG_RETURN_NULL();

#ifdef __DEBUG__
	elog(NOTICE, "[setNamespace]");
#endif
	_SPI_CONN();
	
	qstr = "SELECT id FROM xml_node "
		   "WHERE kind = 6 AND parent = $1 AND tagid = $2";
	pval2[0] = parent_id;
	pval2[1] = DirectFunctionCall1(get_nsid, ns_name);
	execp_query(qstr, 2, argtypes2, pval2, NULL, 's');

#ifndef __OFF_ESCAPING__
	ns_value = escapeString(ns_value);
#endif
	
	if (SPI_processed > 0) {
		node_id = SPI_getbinval
						  (SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1,
						   &isnull);
		qstr = "UPDATE xml_node SET value = $1 WHERE id = $2";
		argtypes2[0] = VARCHAROID;
		pval2[0] = CStringGetDatum(ns_value);
		pval2[1] = node_id;
		execp_query(qstr, 2, argtypes2, pval2, NULL, 'u');
	}
	else 
	{
		qstr = "SELECT docid FROM xml_node WHERE id = $1";
		pval1[0] = parent_id;
		execp_query(qstr, 1, argtypes1, pval1, NULL, 's');

		if (SPI_processed == 0) {
			_SPI_FIN();
			PG_RETURN_NULL();
		}
		doc_id = SPI_getbinval
							(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1,
							&isnull);

		seqname =
			DirectFunctionCall1(textin, CStringGetDatum("xml_nodeid_seq"));
		node_id = DirectFunctionCall1(nextval, seqname);
		pfree(DatumGetTextP(seqname));
		
		qstr = "INSERT INTO xml_node(id,kind,docid,tagid,value) "
			   "VALUES($1, 6, $2, $3, $4)";
		pval4[0] = node_id;
		pval4[1] = doc_id;
		pval4[2] = DirectFunctionCall1(xml_nsid, ns_name);
		pval4[3] = CStringGetDatum(ns_value);
		execp_query(qstr, 4, argtypes4, pval4, NULL, 'i');

		qstr = "UPDATE xml_node SET parent = $1 WHERE id = $2";
		pval2[0] = parent_id;
		pval2[1] = node_id;
		execp_query(qstr, 2, argtypes2, pval2, NULL, 'u');
	}

	pfree(str->data);
	_SPI_FIN();
	PG_RETURN_INT32(node_id);
}

/**
 * appendChild()
 * 		-- DOM Level2 Core
 * 
 * Description:
 * 		Adds the node newChild to the end of the list of children of this node. 
 * 
 * Parameters:  
 * 		Node newChild  -  The node to add. If it is a DocumentFragment object, 
 * 						the entire contents of the document fragment are moved 
 * 						into the child list of this node.
 * 
 * Returns:	
 * 		Node -  The node added.
 * 
 * Exceptions:  
 * 		DOMException HIERARCHY_REQUEST_ERR
 * 			Raised if this node is of a type that does not allow children 
 * 			of the type of the newChild node, or if the node to append is 
 * 			one of this node's ancestors or this node itself. 
 * 		DOMException WRONG_DOCUMENT_ERR
 * 			Raised if newChild was created from a different document than 
 * 			the one that created this node. 
 * 		DOMException NO_MODIFICATION_ALLOWED_ERR	-- not yet imple'd
 * 			Raised if this node is readonly or if the previous parent of 
 * 			the node being inserted is readonly. 
 * 
 * Author: Makoto Yui <yuin@bb.din.or.jp>
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(appendchild);
Datum
appendchild(PG_FUNCTION_ARGS)
{
	int32 parent_node_id = PG_GETARG_INT32(0);
	int32 node_id = PG_GETARG_INT32(1);
	int kind_code;
	bool connected;
	StringInfo str = makeStringInfo();

#ifdef __DEBUG__
	elog(NOTICE, "[appendChild] PARENT_ID:%d CHILD_ID:%d",
		 parent_node_id, node_id);
#endif

	_SPI_CONN();
	appendStringInfo(str, "SELECT kind FROM xml_node WHERE id=%d", node_id);
	exec_query(str->data);
	initStringInfo(str);
	if (SPI_processed == 0) {
		_SPI_FIN();
		PG_RETURN_BOOL(FALSE);
	}
	kind_code =
		atoi(SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1));

	if ((kind_code == KIND_ROOT) || (kind_code == KIND_ATTRIBUTE)
		|| (kind_code == KIND_NAMESPACE)) {
		_SPI_FIN();
		elog(ERROR,"[appendChild] Raising a DOMException, HIERARCHY_REQUEST_ERR.");
	}

	appendStringInfo(str, "UPDATE xml_node SET parent=%d WHERE id=%d",
					 parent_node_id, node_id);
	exec_query(str->data);
	initStringInfo(str);

	/*
	 * parent node has child ?
	 */
	appendStringInfo(str,
					 "SELECT id FROM xml_node WHERE id=%d AND child IS NOT NULL",
					 parent_node_id);
	exec_query(str->data);
	initStringInfo(str);

	if (SPI_processed > 0) {
		/*
		 * link from older brother
		 */
		appendStringInfo(str,
						 "UPDATE xml_node SET next=%d WHERE parent=%d and id!=%d and kind<>%d and kind<>%d and next is NULL",
						 node_id, parent_node_id, node_id, KIND_ATTRIBUTE,
						 KIND_NAMESPACE);
		exec_query(str->data);
	}
	else {
		/*
		 * link from parent
		 */
		appendStringInfo(str, "UPDATE xml_node SET child = %d WHERE id = %d",
						 node_id, parent_node_id);
		exec_query(str->data);
	}

	pfree(str->data);
	_SPI_FIN();
	PG_RETURN_BOOL(TRUE);
}

/**
 * insertBefore()
 * 		-- DOM Level2 Core
 * 
 * Description:
 * 		inserts the node newChild before the existing child node refChild. 
 * 		If refChild is null, insert newChild at the end of the list of children.
 * 
 * Parameters:  
 * 		Node newChild  -  The node to insert.
 *		Node refChild  -  The reference node, 
 * 							i.e., the node before which the new node must be inserted.
 * Returns:	
 * 		Node -  The node being inserted.  
 * 
 * Exceptions:
 * 		DOMException HIERARCHY_REQUEST_ERR
 * 			Raised if this node is of a type that does not allow children of the type 
 * 			of the newChild node, or if the node to insert is one of this node's ancestors 
 * 			or this node itself. 
 * 		DOMException WRONG_DOCUMENT_ERR			 -- diffrent specification with DOM
 * 			Raised if newChild was created from a different document than the one that 
 * 			created this node. 
 * 		DOMException NO_MODIFICATION_ALLOWED_ERR -- not yet implemented
 * 			Raised if this node is readonly or if the parent of the node being inserted is 
 * 			readonly. 
 * 		DOMException NOT_FOUND_ERR				 -- not yet implemented
 * 			Raised if refChild is not a child of this node. 
 * 
 * Author: Makoto Yui <yuin@bb.din.or.jp>
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(insertbefore);
Datum
	insertbefore(PG_FUNCTION_ARGS)
{
	int32 newChild;
	int refChild;
	int child_id;
	char *parent_id,*ref_doc;
	int kind_code;
	bool connected;
	StringInfo str = makeStringInfo();

	newChild = PG_GETARG_INT32(0);
	refChild = (int) PG_GETARG_INT32(1);

#ifdef __DEBUG__
	elog(NOTICE,"[insertBefore] InsertNode:%d BeforeNode:%d",newChild,refChild);
#endif

	_SPI_CONN();

	/**
	 * HIERARCHY_REQUEST_ERR 
	 */
	appendStringInfo(str,"select kind,docid,parent from xml_node where id=%d", refChild);
	exec_query(str->data);
	initStringInfo(str);
		
	if(SPI_processed==0){
		_SPI_FIN();
		PG_RETURN_BOOL(FALSE);
	}
	kind_code =
		atoi(SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1));

	if((kind_code==KIND_ROOT)||(kind_code==KIND_ATTRIBUTE)||(kind_code==KIND_NAMESPACE)){
		_SPI_FIN();
		PG_RETURN_BOOL(FALSE);
	}

	ref_doc=SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 2);
	parent_id=SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 3);

	if(parent_id==NULL){
#ifdef __DEBUG__
		elog(NOTICE,"Parent is NULL:%d",refChild);
#endif
		_SPI_FIN();
		PG_RETURN_BOOL(FALSE);
	}

	/* new node will be first-child of the parent ? */
	appendStringInfo(str,"select child from xml_node where id=%s and docid=%s",parent_id,ref_doc);
	exec_query(str->data);
	initStringInfo(str);
	
	if(SPI_processed==0){
		_SPI_FIN();
		PG_RETURN_BOOL(FALSE);
	}

	child_id = atoi(SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1));
	
	if( refChild==child_id){
		/* if firstchild */
		appendStringInfo(str,"update xml_node set child=%d where id=%s;"
				   			 "update xml_node set docid=%s, parent=%s, next=%d where id=%d",
						newChild,parent_id, ref_doc, parent_id, refChild, newChild);
		exec_query(str->data);

	}
	else{
		/* modify older brother's link info */
		appendStringInfo(str,"update xml_node set next=%d where id=(select id from xml_node where next=%d);"
				   			 "update xml_node set docid=%s, parent=%s, next=%d where id=%d",
				   		newChild, refChild, ref_doc, parent_id, refChild, newChild);
		exec_query(str->data);
	}

	pfree(str->data);
	_SPI_FIN();
	PG_RETURN_BOOL(TRUE);
}



/**
 * stringValue
 * 		-- XPath 1.0
 *
 * This function is too stupid, might be replaced.
 * I recommeds you don't use this syntax. '/aaa[bbb="ccc"]'
 * 
 * we have alternative way using this syntax, '/aaa[bbb=="ccc]'.
 * 
 * Author: Makoto Yui <yuin@bb.din.or.jp>
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(stringvalue);
Datum
stringvalue(PG_FUNCTION_ARGS)
{
	int i, needed, newlen, datalen;
	char *qstr;
	bool connected,isnull;
	VarChar *result;
	Datum kind,dewey;
	Datum *pvals;
    Datum node_id = PG_GETARG_DATUM(0);
	char *ret_text = NULL;
	Oid argtypes1[1] = {INT4OID};
	Oid argtypes2[2] = {INT4ARRAYOID,INT4ARRAYOID};
	Datum pval1[1];
	StringInfo str = makeStringInfo();
	pval1[0] = node_id;
		
#ifdef __DEBUG__
	elog(NOTICE, "[stringValue]");
#endif

	_SPI_CONN();
	qstr = "SELECT kind,dewey FROM xml_node WHERE id = $1";	//and kind != '-1'
    execp_query(qstr, 1, argtypes1, pval1, NULL, 's');
    if (SPI_processed == 0) {
		_SPI_FIN();
		PG_RETURN_NULL();
    }

	kind = SPI_getbinval(
				SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1, 
				&isnull);
	dewey = SPI_getbinval(
				SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 2, 
				&isnull);
	
	switch (kind) 
	{
	  case KIND_ROOT:
	  case KIND_ELEMENT:
	  	  // KIND_TEXT, d_order, d_order
		  qstr = "SELECT value "
				 "FROM xml_node "
				 "WHERE kind='2' "	//value IS NOT NULL AND
				 	"AND dewey > $1 AND dewey < nextSibling($2) "
				 "ORDER BY dewey";
		  pvals = (Datum *) palloc(sizeof(Datum) * 2);
		  pvals[0] = pvals[1] = dewey; 
	      execp_query(qstr, 2, argtypes2, pvals, NULL, 's');
	      pfree(pvals);
	      if (SPI_processed == 0) {
			  _SPI_FIN();
			  PG_RETURN_NULL();
	      }
		  /* get(enlarge) enough buffer */
		  newlen = 128 + 32 * SPI_processed;
		  str->data = (char *) repalloc(str->data, newlen);
		  str->maxlen = newlen;

#ifdef __DEBUG__
		  elog(NOTICE,"SPI_processed=%d, expected len=%d",SPI_processed,newlen);
#endif

		  for(i=0; i<SPI_processed; i++) 
		  {
		  	  // ret_text have to be NULL terminated.
		  	  ret_text = SPI_getvalue(SPI_tuptable->vals[i], SPI_tuptable->tupdesc, 1);

#ifdef __DEBUG__
			  elog(NOTICE,"i=%d, SPI_processed=%d",i,SPI_processed);
#endif

			  if (ret_text != NULL) 
			  {
				  datalen = strlen(ret_text);
				  needed = str->len + datalen + 1;
		
				  if( needed > str->maxlen)
				  {
				  	  if(i+2 == SPI_processed) // when the next is last entry.
				  	  	  newlen += datalen;
				  	  else
					  	  newlen = 2 * needed;
					  str->data = (char *) repalloc(str->data, newlen);
					  str->maxlen = newlen;
				  }
				
				  /* OK, append the data */
				  memcpy(str->data + str->len, ret_text, datalen);
				  str->len += datalen;
				  str->data[str->len] = '\0';
		
				  pfree(ret_text);	// free in loop clearly ? might be changed.
			      					// need bits more thinking. 
			  }
		  }

#ifdef __DEBUG__
		  elog(NOTICE,"actual len=%d",str->len);
#endif

		  ret_text = str->data;
		  break;
	  case KIND_TEXT:
	  case KIND_COMMENT:
	  case KIND_ATTRIBUTE:
	  case KIND_NAMESPACE:
	  case KIND_PI:
	  	  // node_id
		  qstr = "SELECT value FROM xml_node WHERE id = $1";
	      execp_query(qstr, 1, argtypes1, pval1, NULL, 's');
		  if (SPI_processed == 0) {
			  _SPI_FIN();
			  PG_RETURN_NULL();
	      }
		  ret_text = SPI_getvalue(
		  				SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1);
		  break;
	  default:
		  _SPI_FIN();
		  PG_RETURN_NULL();
	}

	// disconenct
	_SPI_FIN();	
		
	if(ret_text==NULL)
		PG_RETURN_NULL();
	result = DatumGetVarCharP(
				DirectFunctionCall1(varcharin, CStringGetDatum(ret_text)));
	/* 
	 * sometimes, pfree(ret_text) cause this error why ?
	 * 
	 * in backend/utils/mmgr/aset.c AllocSetFree()
	 * ERROR:  could not find block containing chunk 0x833ad00
	 * 
	 * Maybe the the chunk could not allocated in a single-chunk block.
	 */
	//pfree(ret_text);
		
	PG_RETURN_VARCHAR_P(result);
}

PG_FUNCTION_INFO_V1(toxml);
Datum toxml(PG_FUNCTION_ARGS)
{
    Datum node_id = PG_GETARG_DATUM(0);
	int i, needed, newlen, datalen;
    char *qstr;
   	bool connected, isnull;
    Datum d_start, d_nextsibling;
	Datum pvals[10];
	VarChar *result;
	StringInfo str = makeStringInfo();
	char *ret_text = NULL;
	Oid argtypes1[1] = {INT4OID};
	Oid argtypes[10] = {INT4ARRAYOID, INT4ARRAYOID,INT4ARRAYOID, INT4ARRAYOID, INT4ARRAYOID, 
					   INT4ARRAYOID, INT4ARRAYOID,INT4ARRAYOID, INT4ARRAYOID, INT4ARRAYOID
					};
	/* have to allocate to accesable space */
	Datum *pvals1 = (Datum *) palloc(sizeof(Datum));
	pvals1[0] = node_id;

#ifdef __DEBUG__
    elog(NOTICE, "[toXML]");
#endif

    _SPI_CONN();
    qstr = "SELECT dewey, nextSibling(dewey) FROM xml_node WHERE id = $1";
    execp_query(qstr, 1, argtypes1, pvals1, NULL, 's');
    pfree(pvals1);
    if (SPI_processed == 0) {
		_SPI_FIN();
		PG_RETURN_NULL();
    }

    d_start = SPI_getbinval(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1, &isnull);
    d_nextsibling = SPI_getbinval(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 2, &isnull);
	pvals[0] = pvals[2] = pvals[4] = pvals[6] = pvals[8] = d_start;
	pvals[1] = pvals[3] = pvals[5] = pvals[7] = pvals[9] = d_nextsibling;
	
    qstr = "SELECT "
				"xn.dewey as dewey, 1 as seq, '<' || xt.name as parsed_text "
			"FROM xml_node xn, xml_tag xt "
			"WHERE xn.tagid = xt.tagid AND xn.kind = '1' "
				"AND (xn.dewey >= $1 AND xn.dewey < $2) "
			"UNION ALL "
			"SELECT " 
				"xn.dewey, xn.kind - 3 as seq, CASE WHEN xn.kind = '5' THEN ' ' || xa.name || '=\"' || xn.value || '\"' ELSE ' ' || ns.name || '=\"' || xn.value || '\"' END "
			"FROM xml_node xn LEFT JOIN xml_attribute xa USING(tagid) "
				"LEFT JOIN xml_namespace ns USING(tagid) "
			"WHERE (xn.kind = '5' OR xn.kind = '6') "
				"AND (xn.dewey >= $3 AND xn.dewey < $4) "
			"UNION ALL "
			"SELECT "
				"xn.dewey + 0, 4 as seq, '>' "
			"FROM xml_node xn "
			"WHERE xn.kind = '1' AND (xn.dewey >= $5 and xn.dewey < $6) "
			"UNION ALL "
			"SELECT "
				"xn.dewey, 5 as seq, CASE WHEN xn.kind = '2' THEN xn.value WHEN xn.kind = '3' THEN '<!-- ' || xn.value || ' -->' ELSE '<?' || pi.name || xn.value || '?>' END "
			"FROM xml_node xn LEFT JOIN xml_pi pi USING(tagid) "
			"WHERE (xn.kind = '2' OR xn.kind = '3' OR xn.kind = '4') "
				"AND (xn.dewey >= $7 AND xn.dewey < $8) "
			"UNION ALL "
			"SELECT "
				"xn.dewey + 2147483647, 6 as seq, '</' || xt.name || '>' "
			"FROM xml_node xn, xml_tag xt "
			"WHERE xn.tagid = xt.tagid AND xn.kind = '1' "
				"AND (xn.dewey >= $9 AND xn.dewey < $10) "
			"ORDER BY dewey, seq";

#ifdef __DEBUG__ 
	elog(NOTICE, "%s", qstr);
#endif
    execp_query(qstr, 10, argtypes, pvals, NULL, 's');
    if (SPI_processed == 0) {
		_SPI_FIN();
		PG_RETURN_NULL();
    }
    
    /* get enough Buffer */
    str->data = (char *) repalloc(str->data, XBUFSIZE);
    str->maxlen = XBUFSIZE;

    for (i = 0; i < SPI_processed; i++) {
		ret_text = SPI_getvalue(SPI_tuptable->vals[i], SPI_tuptable->tupdesc, 3);
		if (ret_text != NULL) 
		{
			datalen = strlen(ret_text);
			needed = str->len + datalen + 1;

			if( needed > str->maxlen)
			{
				/* There is not enough buffer, have to make more room. 
				 *
				 * [note]
				 * if data size have lots variation, this strategy
				 * is not efficient. especially, enlarging is caused
				 * in the last call.
				 * 
				 *  1. len=0; maxlen=5; needed=100;	 
				 *		-> newlen=200; actual=100;
				 *  2. len=100; maxlen=200; needed=1000;
				 * 		-> newlen=2000; actual=1100;
				 *  3. len=1000; maxlen=2000; needed=1;
				 * 		-> newlen=2000; actual=1101;
				 *  	   cause 899 bytes of futility.
				 * 
				 * influence a remained percentage and differ-size of
				 * newlen and actual. 
				 */
				newlen = 2 * needed;
				
				str->data = (char *) repalloc(str->data, newlen);
				str->maxlen = newlen;
			}
		
			/* OK, append the data */
			memcpy(str->data + str->len, ret_text, datalen);
			str->len += datalen;
			str->data[str->len] = '\0';

			pfree(ret_text);
		}
    }
    
	_SPI_FIN();	// disconenct

	if (str->data == NULL)
		PG_RETURN_NULL();
	
	result = DatumGetVarCharP(DirectFunctionCall1
							(varcharin, CStringGetDatum(str->data)));
	pfree(str->data);
	
    PG_RETURN_VARCHAR_P(result);
}

/**
 * escapeString
 * 
 */
static char *
escapeString(char *s)
{
	char *p1, *ret;
	size_t len;
	static char xbuf[XBUFSIZE];
	char *p2 = NULL;

#ifdef __DEBUG__
	elog(NOTICE, "escapeString()");
#endif
		
	if( (p1=strchr(s,'\'')) != NULL ||
		(p2=strchr(s,'\\')) != NULL )
	{
		// escape string
		len = strlen(s);
		if(len < XBUFSIZE)
		{
		    strncpy(xbuf,s,len+1);
			ret = xbuf;		// copy the head of string array
		}	
		else
		    ret = (char *) repalloc(s,(int)len * 1.4);
	
		if(p1!=NULL)
		{
			StrReplace(ret,"\'","\'\'");
			if(p2!=NULL || strchr(ret,'\\')==NULL)
				StrReplace(ret,"\\","\\\\");
		}
		else
			StrReplace(ret,"\\","\\\\");
			
		return ret;
	}
	
	return s;	// needs no changing
}


/*
 *  StrReplace - replace string
 *  
 * 	this function needs care for handring, segfault.
 */
static int
StrReplace(char *ap, const char *bp, const char *cp)
{
	int bs, cs, rc;
	char *limit;

	rc = 0;
	bs = strlen(bp);
	cs = strlen(cp);
	limit = ap + strlen(ap) - bs;

	while (ap <= limit)
	{
		if (strncmp(ap, bp, bs) == 0) 
		{
			memmove(ap + cs, ap + bs, limit - ap + 1);
			strncpy(ap, cp, cs);
			limit += cs - bs;
			rc++;
			ap += cs;
		}
		else
			ap++;
	}
	return rc;
}// streplace

/* for caching of query plans, stolen from contrib/spi/\*.c */
static EPlan *
find_plan(char *ident, EPlan ** eplan, int *nplans, int max_plans)
{
	EPlan	   *newp;
	int			i;
	//static short lru[LRU_MAP];

#ifdef __INFO__
	elog(NOTICE,"Show counters of prepared plans below.\n"
		    "Selecting..%d, Others..%d\n", n_sPlans, n_oPlans);
#endif

	if (*nplans > max_plans)
	{
		/*
		 * restrict the number of plans.
		 * if there is no more space, the oldest place is assigned newly.
		 * 
		 * for now, this algorithm is too poor(FIFO).
		 * will be replaced to Least Reacently Replacement(LRU) in the future.
		 */
		(*nplans)--;
		newp = *eplan - (max_plans - 1);
		pfree(newp->ident);

#ifdef __INFO__
		elog(NOTICE,"There are too many plans. "
					"The oldest plan is replaced to this new plan."); 
#endif

	}
	else if (*nplans > 0)
	{
		// find a plan which matched to the specified label first.
		for (i = 0; i < *nplans; i++)
		{
			if (strcmp((*eplan)[i].ident, ident) == 0)
				break;
		}
		// found
		if (i != *nplans)
			return (*eplan + i);
		// not found. expand the space and create new space for a plan.
		*eplan = (EPlan *) realloc(*eplan, (i + 1) * sizeof(EPlan));
		newp = *eplan + i;
	}
	else // there is no allocated space for plan.
	{
		newp = *eplan = (EPlan *) malloc(sizeof(EPlan));
		(*nplans) = i = 0;
	}

	// set identifier.
	newp->ident = (char *) malloc(strlen(ident) + 1);
	strcpy(newp->ident, ident);
	// initialize plan.
	newp->splan = NULL;
	
	// increment plan counter
	(*nplans)++;

	return (newp); // return space for a plan which specified by the identifier
}

/*
 * prepare plan and save it.
 * 
 * @return prepared plan
 */
static void 
create_plan(EPlan **qplan, char *querystr, int nargs, Oid *argtypes)
{
	void	   *pplan;
	
	/* Prepare plan for query */
	pplan = SPI_prepare(querystr, nargs, argtypes);
	if (pplan == NULL)
		elog(ERROR, "SPI_prepare returned %d", SPI_result);

	/*
	 * Remember that SPI_prepare places plan in current memory context
	 * - so, we have to save plan in Top memory context for latter
	 * use.
	 */
	pplan = SPI_saveplan(pplan);
	if (pplan == NULL)
		elog(ERROR, "SPI_saveplan returned %d", SPI_result);

	(*qplan)->splan = (void *) malloc(sizeof(void *));
	(*qplan)->splan = pplan;	// saving plan

	return;
}


/**
 * indent option
 * -bad -bap -cdb -br -nce -npcs -nbc -lp -nfca -fc1 -i4 -ci4 -cli2 -d4 -ts4
 * 
 * [c.h]
 * typedef signed int int32;               // Size 32bits 4byte (int4)
 * 
 * [limits.h]
 * define INT_MAX 2147483647
 */
