#!/bin/bash

echo "starting.."
date
echo

starttime=`date +%s`

# check user
if [ `id -u` -ne 0 ];then
	echo 'This command in only executed by root'
    exit 1
fi

echo "I'll recommend you to start bulkloading with the postmaster option \"-F\"."
echo

echo 'Input xml file must be encoded with UTF-8.'
echo 'If not, please convert to UTF-8 as follows,'
echo
iconv --usage
echo
echo 'Are you ready ?'
echo

PWD=`pwd`

echo "input directory name or file name"
read TRG
echo

echo " list of loading files "
echo "-----------------------"
echo `ls -sh1 ${TRG} | grep "\.xml$"`
echo

echo "input database name in roman"
read DBNAME
echo

echo "input database username"
read USER
echo

echo "input the user password"
read PASS
echo

echo "enables strip_space ? (Get detail on XSLT reference page)"
select input in true false
do
	case $input in
	    true)
	        SPACES="-s"
			break
			;;
	    false)
	        SPACES=""
	        break
	        ;;
	    *)
	        echo 'input argument is invalid'
	        echo 'please choose'
	        ;;
	esac
done

echo "checking your db encoding ? "
pwd=`pwd`
dbenc=`su - postgres -c "psql -t ${DBNAME} -f ${pwd}/pgenc.sql"`
echo $dbenc

if [ -z `iconv -l | grep -i $dbenc` ]
then
	echo
	echo "iconv: conversion to ${dbenc} is not supported"
	echo 'Please input your DB encoding in more normal name.'
	echo 'Ex). not EUC_JP postgres but EUC-JP general.'
	read dbenc
fi

if [ -z "$dbenc" ]
then
	echo
	echo 'error: variable dbenc is not setted'
	exit 1
fi

TRGLIST=`find ${TRG} | grep "\.xml$"`

echo "preparing for bulkloading..."
su - postgres -c "psql ${DBNAME} < ${PWD}/before.sql"
su - postgres -c "psql ${DBNAME} < ${PWD}/init_statistics.sql"
echo

for i in ${TRGLIST}
do
	echo "now loading..." ${i}
	loadstart=`date +%s`
#	if [ -z "$CONV" ]
#	then
#		echo 'now converting to UTF-8'
#		iconv -t
#	fi
	./pgxload -u ${USER} -p ${PASS} -d ${DBNAME} ${SPACES} -f UTF-8 -t ${dbenc} ${i}
	endload=$(echo "`date +%s`-$loadstart" | bc -l)
	echo "done.. ${endload} sec"
	echo
done

echo "preparing for finishing..."
su - postgres -c "psql ${DBNAME} < ${PWD}/after.sql"
echo

endtime=$(echo "`date +%s`-$starttime" | bc -l)
echo "elapsed time=$endtime seconds."
echo
date
echo "finish!"

