#!/bin/sh

# check user
if [ `id -u` -ne 0 ];then
	echo 'This command in only executed by root'
    exit 1
fi

PWD=`pwd`

chmod +x *.sh

echo 'input database name in roman'
read DBNAME
echo

echo '----- create schema -----'
echo 'drop schema...'
su - postgres -c "psql ${DBNAME} < ${PWD}/dropschema.sql";
echo 
echo 'create schema...'
su - postgres -c "psql ${DBNAME} < ${PWD}/createschema.sql";
echo

echo '----- create function -----'
echo
echo 'create or replace function...'
su - postgres -c "psql ${DBNAME} < ${PWD}/createfunction.sql";
echo 
echo 'create gc function...'
su - postgres -c "psql ${DBNAME} < ${PWD}/gc_pathexp.sql";
echo

echo '----- create or renew index -----'
echo
echo 'phase 1...'
su - postgres -c "psql ${DBNAME} < ${PWD}/createidx-1.sql";
echo
echo 'phase 2...' 
su - postgres -c "psql ${DBNAME} < ${PWD}/createidx-2.sql";
echo 
echo 'phase 3...'
su - postgres -c "psql ${DBNAME} < ${PWD}/createidx-3.sql";
echo

echo 'Do you use bulkload ? please choose'
select input in true false
do
	case $input in
	    true)
	        echo
			echo '----- create index for next -----'
			su - postgres -c "psql ${DBNAME} < ${PWD}/createidx-next.sql"
			echo 
			echo 'this index is for bulkload, not needed in XPath.'
			echo 'if you need better performance, you should delete this index after bulkloaded.'
			echo
			break
			;;
	    false)
	        echo
	        echo 'do not create index for next'
	        echo
			echo '----- create index for dewey -----'
			su - postgres -c "psql ${DBNAME} < ${PWD}/createidx-dewey.sql"
			echo
			echo 'Please drop this index, if an updating performance is more important '
			echo 'than a selection one.' 
	        break
	        ;;
	    *)
	        echo 'input argument is invalid'
	        echo 'please choose'
	        ;;
	esac
done

echo
echo 'Create index for xpath queries right now ?'
echo '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~'
echo '[Caution]'
echo '* When you perform bulkload after this, please choose false '
echo '   and execute afterload.sh* after.'
echo '* You have to install intarray before execute.'
echo 
echo 'Please choose'
select input in true false
do
	case $input in
	    true)
	        echo
			echo '------ create index for xpath queries -----'
			./afterload.sh ${DBNAME}
			echo
			break
			;;
	    false)
	        echo
	        echo 'do not create index for xpath queries'
	        echo
	        break
	        ;;
	    *)
	        echo 'input argument is invalid'
	        echo 'please choose'
	        ;;
	esac
done

echo
echo '----- initial data input -----'
su - postgres -c "psql ${DBNAME} < ${PWD}/initdata.sql"
echo

echo 'finish!'


