SELECT DISTINCT
    xn3.docid,
    xn3.id
FROM
    xml_path xp2,
    xml_node xn2,
    xml_node xn3
WHERE
    xp2.pathexp = '#/site/closed_auction' AND
    xn2.pathid = xp2.pathid AND
    xn3.parent = xn2.parent AND
    xn2.dewey < xn3.dewey AND
    xn3.kind = '1'

/*
                                                                   QUERY PLAN                                                                    
-------------------------------------------------------------------------------------------------------------------------------------------------
 Unique  (cost=2076.47..2104.93 rows=379 width=134) (actual time=0.09..0.09 rows=0 loops=1)
   ->  Sort  (cost=2076.47..2085.95 rows=3795 width=134) (actual time=0.09..0.09 rows=0 loops=1)
         Sort Key: xn3.docid, xn3.id
         ->  Nested Loop  (cost=0.00..1850.89 rows=3795 width=134) (actual time=0.03..0.03 rows=0 loops=1)
               Join Filter: ("outer".dewey < "inner".dewey)
               ->  Nested Loop  (cost=0.00..298.50 rows=454 width=67) (actual time=0.02..0.02 rows=0 loops=1)
                     ->  Index Scan using xml_path_exp on xml_path xp2  (cost=0.00..5.53 rows=1 width=4) (actual time=0.02..0.02 rows=0 loops=1)
                           Index Cond: (pathexp = '#/site/closed_auction'::character varying)
                     ->  Index Scan using xml_node_pathid on xml_node xn2  (cost=0.00..283.87 rows=728 width=63) (never executed)
                           Index Cond: (xn2.pathid = "outer".pathid)
               ->  Index Scan using xml_node_parent on xml_node xn3  (cost=0.00..3.37 rows=4 width=67) (never executed)
                     Index Cond: (xn3.parent = "outer".parent)
                     Filter: (kind = 1::smallint)
 Total runtime: 0.36 msec
(14 rows)

Time: 12.63 ms
*/
