/*
* Disponible en http://www.kazak.ws
*
* Desarrollado por Soluciones KAZAK 
* Grupo de Investigacion y Desarrollo de Software Libre
* Santiago de Cali/Republica de Colombia 2001
*
* CLASS ReportDesigner v 0.1                                                   
* Descripcion:
* Esta clase se encarga de mostrar la ventana inicial de reportes   
* donde el usuario escoge los campo a incluir en el reporte.       
*                                                                 
* Los objetos de este tipo se crean desde la clase Querys        
*
* Preguntas, Comentarios y Sugerencias: xpg@kazak.ws
*                                                                   
* Fecha: 2001/10/01                                                 
*
* Autores: Beatriz Florin  - bettyflor@kazak.ws                    
*          Gustavo Gonzalez - xtingray@kazak.ws                     
*          Angela Sandobal  - angesand@libertad.univalle.edu.co     
*/

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import java.util.*;
import java.net.URL;
import java.applet.*;

public class ReportDesigner extends JDialog implements ActionListener,FocusListener,KeyListener{

 JTextArea LogWin;
 JFrame frame;
 Vector nameFields;
 JList fields;
 boolean trigger = false;
 JList selected;
 Vector choosed = new Vector();
 Vector names = new Vector();
 Vector inT = new Vector();
 Vector inC = new Vector();
 Vector combox = new Vector();
 Vector data = new Vector();
 Hashtable indexes = new Hashtable();
 HtmlProperties htmlInfo = new HtmlProperties();
 JTextField title = new JTextField();
 JTextField title2;
 String component = "";
 JCheckBox xtitle;
 JComboBox op;
 JCheckBox result;
 Language idiom;
 JButton appe,stylex,view;
 Vector tableN = new Vector(); 
 PGConnection pgconn;

 public ReportDesigner(JFrame aframe,Vector columNames,Vector info, Language lang, JTextArea lw, String tables, PGConnection pg) 
  {
   super(aframe,true);
   idiom = lang;
   frame = aframe;
   LogWin = lw;
   pgconn = pg;
   nameFields = columNames;
   data = info;
   for(int p=0;p<nameFields.size();p++) 
    {
     String nome = (String) nameFields.elementAt(p); 
     Integer intCast = new Integer(p);
     indexes.put(nome,intCast);
    }

   StringTokenizer st = new StringTokenizer(tables,",");
   while (st.hasMoreTokens()) 
    {
      String word = st.nextToken();
      word = word.trim();
      tableN.addElement(word);
    }

   setTitle(idiom.getWord("REPTED"));
   getContentPane().setLayout(new BorderLayout());
   JPanel center = new JPanel();
   center.setLayout(new FlowLayout(FlowLayout.CENTER));

   Border etched1 = BorderFactory.createEtchedBorder();
   TitledBorder title1 = BorderFactory.createTitledBorder(etched1,idiom.getWord("FIELED"));
   center.setBorder(title1);

   fields = new JList(nameFields);

   fields.setVisibleRowCount(5);
   JScrollPane scrollC = new JScrollPane(fields);
   JButton selectAll = new JButton(idiom.getWord("SELALL"));
   selectAll.setActionCommand("SELALL");
   selectAll.addActionListener(this);

   JPanel buttons = new JPanel();
   buttons.setLayout(new FlowLayout(FlowLayout.CENTER));
   buttons.add(selectAll);

   JPanel options = new JPanel();
   options.setLayout(new BorderLayout());
   options.add(scrollC,BorderLayout.CENTER);
   options.add(buttons,BorderLayout.SOUTH);

   String init[] = {" "};
   selected = new JList(init);
   selected.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
   selected.setVisibleRowCount(5);
   selected.addFocusListener(this);

   MouseListener mouseListener = new MouseAdapter() 
     {
	public void mousePressed(MouseEvent e) 
         {
          int index = selected.locationToIndex(e.getPoint());
          if(index > -1 && !(choosed.isEmpty())) 
           {
            xtitle.setEnabled(true);
            String campo = (String) selected.getSelectedValue();
            title.setText(idiom.getWord("FIELD")+" "+ campo);
            title2.setText((String) names.elementAt(index));
            String isT = (String) inT.elementAt(index); 
            if(isNumericType(campo))
             {
              if(!result.isEnabled())
               result.setEnabled(true);
             }
            else
               result.setEnabled(false);

            if(isT.equals("1")) 
             {
              xtitle.setSelected(true); 
              title2.setEnabled(true);
              title2.setEditable(true);
             }
          else 
           {
            xtitle.setSelected(false);
            title2.setEditable(false);
            title2.setEnabled(false);
           }

          String isC = (String) inC.elementAt(index); 

          if(isC.equals("1")) 
           {
            op.setEnabled(true); 
            result.setSelected(true);
            int pox = Integer.parseInt((String) combox.elementAt(index));
            op.setSelectedIndex(pox);
           }
          else 
           {
            op.setEnabled(false); 
            result.setSelected(false);
            op.setSelectedIndex(0);
           }
          }
         }
        };

    selected.addMouseListener(mouseListener);

    JScrollPane scrollE = new JScrollPane(selected);
    JButton clear = new JButton(idiom.getWord("CLRSEL"));
    clear.setActionCommand("CLEAR");
    clear.addActionListener(this);
    JPanel bit = new JPanel();
    bit.setLayout(new FlowLayout(FlowLayout.CENTER));
    bit.add(clear);

    JPanel elec = new JPanel();
    elec.setLayout(new BorderLayout());
    elec.add(scrollE,BorderLayout.CENTER);
    elec.add(bit,BorderLayout.SOUTH);

    JPanel properties = new JPanel();
    properties.setLayout(new BorderLayout());
    title = new JTextField(idiom.getWord("NOFSEL"));
    title.setHorizontalAlignment(JTextField.CENTER);
    title.setEditable(false);

    xtitle = new JCheckBox(idiom.getWord("SETTIT"));
    xtitle.setActionCommand("TITULE");
    xtitle.addActionListener(this);

    title2 = new JTextField(10);
    title2.setEditable(false);
    title2.setEnabled(false);
    xtitle.setEnabled(false);

    result = new JCheckBox(idiom.getWord("INCRES"));
    result.setActionCommand("RESULT");
    result.addActionListener(this);

    String[] valuex = {idiom.getWord("NONE"),idiom.getWord("TOTAL"),idiom.getWord("AVERG")};
    op = new JComboBox(valuex);
    op.setEnabled(false);
    op.setActionCommand("COMBO");
    op.addActionListener(this);
    result.setEnabled(false);

    JPanel block = new JPanel();
    block.setLayout(new GridLayout(2,0));
    block.add(xtitle);
    block.add(result);

    JPanel pTit= new JPanel();
    pTit.setLayout(new FlowLayout(FlowLayout.CENTER));
    pTit.add(title2);
    JPanel pop = new JPanel();
    pop.setLayout(new FlowLayout(FlowLayout.CENTER));
    pop.add(op);

    JPanel block2 = new JPanel();
    block2.setLayout(new GridLayout(2,0));
    block2.add(pTit);
    block2.add(pop);

    properties.add(title,BorderLayout.NORTH);
    properties.add(block,BorderLayout.CENTER);
    properties.add(block2,BorderLayout.EAST);
    title1 = BorderFactory.createTitledBorder(etched1);
    properties.setBorder(title1);

    URL imgURL = getClass().getResource("icons/16_Right.gif");
    JButton adds = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
    adds.setActionCommand("ADDS");
    adds.addActionListener(this);
    JLabel space = new JLabel(" ");
    JPanel medium = new JPanel();
    medium.setLayout(new BorderLayout());
    medium.add(adds,BorderLayout.CENTER);
    medium.add(space,BorderLayout.SOUTH);

    JPanel block3 = new JPanel();
    block3.setLayout(new FlowLayout(FlowLayout.CENTER));
    block3.add(options);
    block3.add(medium);
    block3.add(elec);
    block3.setBorder(title1);

    center.add(block3);
    center.add(properties);

    JPanel buttons2 = new JPanel();
    buttons2.setLayout(new FlowLayout(FlowLayout.CENTER));
    appe = new JButton(idiom.getWord("LOOK"));
    appe.setActionCommand("APPE");
    appe.addActionListener(this);
    appe.setEnabled(false);
    stylex = new JButton(idiom.getWord("PRESTY"));
    stylex.setActionCommand("STYLES");
    stylex.addActionListener(this);
    stylex.setEnabled(false);
    view = new JButton(idiom.getWord("VIEW"));
    view.setActionCommand("VIEW");
    view.addActionListener(this);
    view.setEnabled(false);
    JButton close = new JButton(idiom.getWord("CLOSE"));
    close.setActionCommand("CLOSE");
    close.addActionListener(this);
    buttons2.add(appe);
    buttons2.add(stylex);
    buttons2.add(view);
    buttons2.add(close);

    JPanel filesLocation = new JPanel();
    filesLocation.setLayout(new BorderLayout());
    filesLocation.setLayout(new BoxLayout(filesLocation, BoxLayout.Y_AXIS));

    String OS = System.getProperty("os.name");
    String path = "";

    if(OS.equals("Linux") || OS.equals("Solaris") || OS.equals("FreeBSD"))
     path = System.getProperty("user.home") + System.getProperty("file.separator") + ".xpg" + System.getProperty("file.separator") + "reports" + System.getProperty("file.separator");

    if(OS.startsWith("Windows"))
     path = System.getProperty("xpgHome") + System.getProperty("file.separator")
            + "reports" + System.getProperty("file.separator");

    JLabel reportLabel = new JLabel(idiom.getWord("RFP"));
    JTextField reportLocation = new JTextField(path,20);

    JButton browse = new JButton(idiom.getWord("BROWSE"));

    JPanel line = new JPanel();
    line.setLayout(new FlowLayout());
    line.add(reportLabel);
    line.add(reportLocation);
    line.add(browse);

    JPanel line2 = new JPanel();
    line2.setLayout(new FlowLayout());
    JLabel patronFile = new JLabel(idiom.getWord("FNP"));
    JTextField patronString = new JTextField(15);

    JLabel recordsLimit = new JLabel(idiom.getWord("RPP"));
    JTextField recordsNumber = new JTextField("30",3);

    line2.add(patronFile);
    line2.add(patronString);
    line2.add(recordsLimit);
    line2.add(recordsNumber);

    filesLocation.add(line);
    filesLocation.add(line2);

    title1 = BorderFactory.createTitledBorder(etched1,idiom.getWord("FEATURES"));
    filesLocation.setBorder(title1);

    JPanel mediumBlock = new JPanel();    
    mediumBlock.setLayout(new BorderLayout());
    mediumBlock.add(center,BorderLayout.CENTER);
    mediumBlock.add(filesLocation,BorderLayout.SOUTH);

    getContentPane().add(mediumBlock,BorderLayout.CENTER);
    getContentPane().add(buttons2,BorderLayout.SOUTH);
    pack();
    setLocationRelativeTo(frame);
    setVisible(true);
  }

/*** Manejo de Eventos ***/

public void actionPerformed(java.awt.event.ActionEvent e) 
 {

  if(e.getActionCommand().equals("APPE")) 
   {
    ReportAppearance dialog = new ReportAppearance(ReportDesigner.this,frame, idiom);
    if(dialog.wellDone)
      htmlInfo = dialog.htmlInfo;
   }

  /* if(e.getActionCommand().equals("STYLES")) 
   {
    StyleSelector win = new StyleSelector(ReportDesigner.this,idiom);
    if(win.wellDone)
     htmlInfo = new HtmlProperties(win.indice);
   }
  */

  if(e.getActionCommand().equals("VIEW")) 
   {
   
    if(choosed.size()==0)
     {
      JOptionPane.showMessageDialog(ReportDesigner.this,                               
      idiom.getWord("NFIR"),                       
      idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
     }
    else 
     {
      int[] posic = new int[choosed.size()];
      for(int k=0;k<choosed.size();k++)
        {
         String tmp = (String) choosed.elementAt(k);
         Integer valor = (Integer) indexes.get(tmp);
         posic[k] = valor.intValue();
        }
      setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
      ReportMaker proof = new ReportMaker(idiom,names,data,posic,combox,htmlInfo,LogWin);
      setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
     }
   }

  if(e.getActionCommand().equals("CLOSE")) 
   {
     setVisible(false);
   }

  if(e.getActionCommand().equals("ADDS")) 
   {
    if(!fields.isSelectionEmpty())
    {
     Object[] fieldsArray = fields.getSelectedValues();
     for(int i=0;i< fieldsArray.length;i++)
     {
      if(!choosed.contains(fieldsArray[i])) 
       {
        choosed.addElement(fieldsArray[i]);
        names.addElement(fieldsArray[i]);
        inT.addElement("0");
        inC.addElement("0");
        combox.addElement("0");
       }
    }

    selected.setListData(choosed);
    appe.setEnabled(true);
    //stylex.setEnabled(true);
    view.setEnabled(true);
    title.setText(idiom.getWord("NOFSEL"));
    title2.setText("");
   }
 }

 if(e.getActionCommand().equals("SELALL")) 
  {
   if(!trigger) 
    {
     int[] indexes = new int[nameFields.size()];
     for(int k=0;k<nameFields.size();k++)
       indexes[k] = k;
     fields.setSelectedIndices(indexes);
     trigger = true;
    }
   else 
    {
     trigger = false;
     fields.clearSelection();
    }
  }

 if(e.getActionCommand().equals("CLEAR")) 
  {
   appe.setEnabled(false);
   stylex.setEnabled(false);
   view.setEnabled(false);
   choosed = new Vector();
   names = new Vector();
   String[] dat = {" "};
   selected.setListData(dat);
   title.setText(idiom.getWord("NOFSEL"));
   title2.setText("");

   if(xtitle.isSelected())
      xtitle.setSelected(false);

   if(result.isSelected())
      result.setSelected(false);

   xtitle.setEnabled(false);
   result.setEnabled(false);
   op.setEnabled(false);
  }	

 if(e.getActionCommand().equals("TITULE"))
  {
   int pos = selected.getSelectedIndex();

   if(xtitle.isSelected()) 
    {
     title2.setEnabled(true);
     title2.setEditable(true);
     title2.addFocusListener(this);
     inT.setElementAt("1",pos);
    }
   else 
    {
      String mesg = (String) selected.getSelectedValue();
      names.setElementAt(mesg,pos);
      title2.setText(mesg); 
      title2.setEditable(false);
      title2.setEnabled(false);
      title2.removeFocusListener(this);
      inT.setElementAt("0",pos);
    }
 }

 if(e.getActionCommand().equals("RESULT"))
  {
   int pos = selected.getSelectedIndex();
   if(result.isSelected()) 
    {
     op.setEnabled(true);
     inC.setElementAt("1",pos);
    }
   else 
    {
     op.setSelectedIndex(0);
     op.setEnabled(false);
     combox.setElementAt("0",pos); 
     inC.setElementAt("0",pos);
    }
  }

 if(e.getActionCommand().equals("COMBO"))
  {
   int pos = selected.getSelectedIndex();
   int index = op.getSelectedIndex();
   combox.setElementAt("" + index,pos);
  } 

 }

 public void focusGained(FocusEvent e) 
  {
    Component tmp = e.getComponent();
    String c = tmp.toString();

    if (c.indexOf("javax.swing.JList") != -1)
        component = "JList"; 

    if (c.indexOf("javax.swing.JTextField") != -1)
        component = "JTextField"; 

    tmp.addKeyListener(this);
  }

 public void focusLost(FocusEvent e) 
  {
    String mesg = title2.getText();
    int pos = selected.getSelectedIndex();

    if(mesg.length()>0)
      names.setElementAt(mesg,pos);

    Component tmp = e.getComponent();
    component = "";
    tmp.removeKeyListener(this);
       
  } 

 public void keyTyped(KeyEvent e) 
  {
  }   

 public void keyPressed(KeyEvent e) 
  {
   int keyCode = e.getKeyCode();
   String keySelected = KeyEvent.getKeyText(keyCode);

   if(component.equals("JList")) 
    {
     if(keySelected.equals("Down"))    
      {
        int pos = selected.getSelectedIndex();
        if(pos<choosed.size() - 1)
         {
          String campo = (String) choosed.elementAt(pos + 1);
          String real = (String) names.elementAt(pos + 1);
          title.setText(idiom.getWord("FIELD")+" "+ campo);
          title2.setText(real);
          String isT = (String) inT.elementAt(pos + 1); 
          if(isT.equals("1")) 
            {
             xtitle.setSelected(true); 
             title2.setEnabled(true);
             title2.setEditable(true); 
            }
          else 
            {
             xtitle.setSelected(false);
             title2.setEnabled(false);
             title2.setEditable(false);
	    }

          String isC = (String) inC.elementAt(pos + 1); 
          if(isC.equals("1")) 
           {
            op.setEnabled(true); 
            result.setSelected(true);
           }
          else 
           {
            op.setEnabled(false); 
            result.setSelected(false);
           }

         }
      }

     if(keySelected.equals("Up"))    
      {
        int pos = selected.getSelectedIndex();

        if(pos>0) 
         { 
          String campo = (String) choosed.elementAt(pos - 1);
          String real = (String) names.elementAt(pos - 1);
          title.setText(idiom.getWord("FIELD")+" "+ campo);
          title2.setText(real);
          String isT = (String) inT.elementAt(pos - 1); 

          if(isT.equals("1")) 
           {
            xtitle.setSelected(true); 
            title2.setEnabled(true);
            title2.setEditable(true); 
           }
          else 
           {
            xtitle.setSelected(false);
            title2.setEnabled(false);
            title2.setEditable(false); 
           }

          String isC = (String) inC.elementAt(pos - 1); 
          if(isC.equals("1")) 
           {
            op.setEnabled(true); 
            result.setSelected(true);
           }
          else 
           {
            op.setEnabled(false); 
            result.setSelected(false);
           }
         }

      }
   }
 }

 public void keyReleased(KeyEvent e) 
  {
  } 

 boolean isNumericType(String fieldN)
  {
    int i = tableN.size();     
    for(int j=0;j<i;j++)
     {
       Vector res;
       String nameT = (String) tableN.elementAt(j);
       Vector field = pgconn.TableQuery("SELECT t.typname FROM pg_class c, pg_attribute a, pg_type t WHERE c.relname='" + nameT + "' AND a.attrelid = c.oid AND a.atttypid = t.oid AND a.attname='" + fieldN + "';"); 
       if(!field.isEmpty())
        {
          res = (Vector) field.elementAt(0);
          if(!res.isEmpty())
           {
            String type = (String) res.elementAt(0);
            if(type.startsWith("int") || type.equals("serial") || type.equals("smallint") || type.equals("real") || type.equals("double"))
              return true;
            else
              return false;
           }
        }
     }
    return false;
  }

} // Fin de la Clase
