/*
* Disponible en http://www.kazak.ws
*
* Desarrollado por Soluciones KAZAK 
* Grupo de Investigacion y Desarrollo de Software Libre
* Santiago de Cali/Republica de Colombia 2001
*
* CLASS DropGroup v 0.1                                                   
* Descripcion:
* Esta clase se encarga de mostrar el dialogo mediante el
* cual se elimina un grupo del SMBD.
*
* Preguntas, Comentarios y Sugerencias: xpg@kazak.ws
*                                                                   
* Fecha: 2001/10/01                                                 
*
* Autores: Beatriz Florin  - bettyflor@kazak.ws                    
*          Gustavo Gonzalez - xtingray@kazak.ws                     
*/

import java.awt.*;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import javax.swing.*;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

class DropGroup extends JDialog
 {
    private JOptionPane optionPane;
    JTextArea LogWin;
    final JComboBox cmbUser;
    Language idiom;
    PGConnection conn;

    public DropGroup(JFrame jframe, Language language, PGConnection pg_konnection, JTextArea jtextarea)
     {
        super(jframe, true);
        idiom = language;
        conn = pg_konnection;
        LogWin = jtextarea;
        setTitle(idiom.getWord("RMGRP"));
        String as[] = conn.getGroups();

        JLabel jlabel = new JLabel(idiom.getWord("SELGRP"));
        cmbUser = new JComboBox(as);

        Object aobj[] = { jlabel, cmbUser };
        Object aobj1[] = { idiom.getWord("DROP"), idiom.getWord("CANCEL") };

        optionPane = new JOptionPane(((Object) (aobj)), 3, 0, null, aobj1, aobj1[0]);
        setContentPane(optionPane);
        setDefaultCloseOperation(0);
 
        addWindowListener(new WindowAdapter() 
         {
            public void windowClosing(WindowEvent windowevent)
            {
                optionPane.setValue(new Integer(-1));
            }
         });

        optionPane.addPropertyChangeListener(new PropertyChangeListener() 
         {
            public void propertyChange(PropertyChangeEvent propertychangeevent)
            {
                String s = propertychangeevent.getPropertyName();
                if(isVisible() && propertychangeevent.getSource() == optionPane && (s.equals("value") || s.equals("inputValue")))
                {
                    Object obj = optionPane.getValue();
                    if(obj == JOptionPane.UNINITIALIZED_VALUE)
                        return;
                    if(obj.equals(idiom.getWord("DROP")))
                     {
                        String s1 = (String)cmbUser.getSelectedItem();
                        String s2 = "DROP GROUP " + s1 + ";";
                        String s3 = conn.SQL_Instruction(s2);

                        addTextLogMonitor(idiom.getWord("EXEC") + " \"" + s2 + "\"");
                        addTextLogMonitor(idiom.getWord("RES") + s3);

                        if(s3.equals("OK"))
                            setVisible(false);
                        else
                         {
                            JOptionPane.showMessageDialog(DropGroup.this, s3, idiom.getWord("ERROR!"), 0);
                            return;
                         }
                      } 
                     else
                        setVisible(false);
                 }
            }

        });
    }

    public void addTextLogMonitor(String s)
     {
        LogWin.append(s + "\n");
        int i = LogWin.getDocument().getLength();
        if(i > 0)
            LogWin.setCaretPosition(i - 1);
     }

} //Fin de la Clase
