/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql;

import java.sql.SQLException;
import java.sql.SQLWarning;
import org.postgresql.ResultSet;
import org.postgresql.util.PSQLException;

public abstract class Statement {
    protected SQLWarning warnings = null;
    protected java.sql.ResultSet result = null;
    protected int maxrows = 0;
    protected int timeout = 0;
    protected boolean escapeProcessing = true;
    private static final short IN_SQLCODE = 0;
    private static final short IN_STRING = 1;
    private static final short BACKSLASH = 2;
    private static final short ESC_TIMEDATE = 3;

    public void cancel() throws SQLException {
    }

    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public void close() throws SQLException {
        java.sql.ResultSet resultSet = this.getResultSet();
        if (resultSet != null) {
            resultSet.close();
        }
        this.result = null;
    }

    protected static String escapeSQL(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = -1;
        int n3 = string.length();
        while (++n2 < n3) {
            char c = string.charAt(n2);
            switch (n) {
                case 0: {
                    if (c == '\'') {
                        n = 1;
                    } else if (c == '{' && n2 + 1 < n3) {
                        char c2 = string.charAt(n2 + 1);
                        if (c2 == 'd') {
                            n = 3;
                            ++n2;
                            break;
                        }
                        if (c2 == 't') {
                            n = 3;
                            n2 += n2 + 2 < n3 && string.charAt(n2 + 2) == 's' ? 2 : 1;
                            break;
                        }
                    }
                    stringBuffer.append(c);
                    break;
                }
                case 1: {
                    if (c == '\'') {
                        n = 0;
                    } else if (c == '\\') {
                        n = 2;
                    }
                    stringBuffer.append(c);
                    break;
                }
                case 2: {
                    n = 1;
                    stringBuffer.append(c);
                    break;
                }
                case 3: {
                    if (c == '}') {
                        n = 0;
                        break;
                    }
                    stringBuffer.append(c);
                    break;
                }
            }
        }
        return stringBuffer.toString();
    }

    public int getInsertedOID() throws SQLException {
        if (this.result == null) {
            return 0;
        }
        return (int)((ResultSet)((Object)this.result)).getLastOID();
    }

    public long getLastOID() throws SQLException {
        if (this.result == null) {
            return 0L;
        }
        return ((ResultSet)((Object)this.result)).getLastOID();
    }

    public int getMaxFieldSize() throws SQLException {
        return 8192;
    }

    public int getMaxRows() throws SQLException {
        return this.maxrows;
    }

    public int getQueryTimeout() throws SQLException {
        return this.timeout;
    }

    public java.sql.ResultSet getResultSet() throws SQLException {
        if (this.result != null && ((ResultSet)((Object)this.result)).reallyResultSet()) {
            return this.result;
        }
        return null;
    }

    public String getResultStatusString() {
        if (this.result == null) {
            return null;
        }
        return ((ResultSet)((Object)this.result)).getStatusString();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.escapeProcessing = bl;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        throw new PSQLException("postgresql.stat.maxfieldsize");
    }

    public void setMaxRows(int n) throws SQLException {
        this.maxrows = n;
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.timeout = n;
    }
}

