/*
* Disponible en http://www.kazak.ws
*
* Desarrollado por Soluciones KAZAK 
* Grupo de Investigacion y Desarrollo de Software Libre
* Santiago de Cali/Republica de Colombia 2001
*
* CLASS CustomizeFilter v 0.1                                                   
* Descripcion:
*
* Preguntas, Comentarios y Sugerencias: xpg@kazak.ws
*                                                                   
* Fecha: 2001/10/01                                                 
*
* Autores: Beatriz Florin  - bettyflor@kazak.ws                    
*          Gustavo Gonzalez - xtingray@kazak.ws                     
*/

import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JComboBox;
import javax.swing.*;
import javax.swing.BorderFactory; 
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import java.awt.*;
import java.awt.event.*;

public class CustomizeFilter extends JDialog implements ActionListener{

 JComboBox postSEL;
 Table mytable;
 JTextArea SQLspace;
 boolean wellDone = false;
 String select = "";
 Language idiom;

 public CustomizeFilter(Table table,JFrame frame,Language leng) {
   super(frame, true);
   idiom = leng;
   setTitle(idiom.getWord("CUF"));
   mytable = table;
   JLabel title = new JLabel("SELECT ",JLabel.CENTER);
   String[] diff = {"ALL","DISTINCT"};
   postSEL = new JComboBox(diff);
   JPanel first = new JPanel();
   first.setLayout(new FlowLayout(FlowLayout.CENTER));
   first.add(title);
   title = new JLabel(" ON " + mytable.Name,JLabel.CENTER); 
   first.add(postSEL);
   first.add(title);
   Border etched1; 
   etched1 = BorderFactory.createEtchedBorder();
   TitledBorder title1 = BorderFactory.createTitledBorder(etched1);
   first.setBorder(title1);
   SQLspace = new JTextArea(6,35);
   JScrollPane block = new JScrollPane(SQLspace);
   JPanel Tarea = new JPanel();
   Tarea.setLayout(new BorderLayout());
   Tarea.add(block,BorderLayout.CENTER);
   title1 = BorderFactory.createTitledBorder(etched1,"WHERE");
   Tarea.setBorder(title1);

   JButton ok = new JButton(idiom.getWord("RUN"));
   ok.setActionCommand("ButtonOk");
   ok.addActionListener(this);
   JButton clear = new JButton(idiom.getWord("CLR"));
   clear.setActionCommand("ButtonClear");
   clear.addActionListener(this);
   JButton cancel = new JButton(idiom.getWord("CANCEL"));
   cancel.setActionCommand("ButtonCancel");
   cancel.addActionListener(this);

   Object[] array = {first,Tarea};
   Object[] options = {ok,clear,cancel};
   JOptionPane optionPane = new JOptionPane(array, JOptionPane.PLAIN_MESSAGE, JOptionPane.YES_NO_OPTION, null,
                               options, options[0]);

   setContentPane(optionPane);
   pack();
   setLocationRelativeTo(frame);
   setVisible(true);
  }

 /*** Manejo de Eventos ***/

 public void actionPerformed(java.awt.event.ActionEvent e) {

 if(e.getActionCommand().equals("ButtonOk")) 
 {
  String condition = (String) postSEL.getSelectedItem();
  select = "SELECT " + condition + " * FROM " + mytable.Name;
  String text = SQLspace.getText();
  if(text.length()>0) 
   {
    text = text.trim();
    text = Querys.clearSpaces(text);
    select += " WHERE " + text;
   }
  if(!text.endsWith(";"))
   select += ";";
  wellDone = true;
  setVisible(false);
 }

 if(e.getActionCommand().equals("ButtonClear"))
  {
   SQLspace.setText("");
   SQLspace.requestFocus();
  }

 if(e.getActionCommand().equals("ButtonCancel")) 
  {
   setVisible(false);
  }
 }

} //Fin de la Clase
