#!/bin/sh
#
# xcodegen Ant script
#
# Author:   Herve Tchepannou
# Version:  $Revision$

#=====================================================================
# Resolve the jdk home directory
#=====================================================================

if [ ! -z "$JAVA_PATH" -a -z "$jdkhome" ] ; then
    jdkhome=$JAVA_PATH
fi

if [ ! -z "$JDK_HOME" -a -z "$jdkhome" ] ; then
    jdkhome=$JDK_HOME
fi

if [ -z "$jdkhome" ] ; then
    echo "Cannot find JDK. Please set the JDK_HOME environment variable to point"
    echo "to your JDK installation directory"
    echo ""
    exit 1
fi


#=====================================================================
# build classpath
#=====================================================================

libpath=../../lib
buildpath=../../build

xcp=$libpath/ant.jar:\
$libpath/commons-collections.jar:\
$libpath/log4j.jar:\
$libpath/velocity.jar:\
$buildpath/lib/xcodegen.jar:\
$jdkhome/lib/tools.jar

echo "CLASSPATH=$xcp"


#=====================================================================
# run ant
#=====================================================================

$jdkhome/bin/java -cp $xcp org.apache.tools.ant.Main $@


	
